
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "md5.h"

#define BLOCK_SIZE (4096)

int main(int argc, char *argv[])
{
    int i;
    MD5_CTX context;                                        /* context */
    unsigned char block[BLOCK_SIZE];
    unsigned char digest[16];                         /* message digest */
    char *path;
    FILE* fp;
    size_t bytes_read;

    if (argc != 2)
    {
	fprintf(stderr, "usage: %s <filename>\n", argv[0]);
	exit(1);
    }

    path = argv[1];

    fp = fopen(path, "rb");

    if (fp == NULL)
    {
	perror(path);
	exit(1);
    }

    MD5Init(&context);

    bytes_read = BLOCK_SIZE;   /* go through loop at least once */

    while (bytes_read == BLOCK_SIZE)
    {
	bytes_read = fread(block, sizeof(unsigned char), BLOCK_SIZE, fp);

	if (bytes_read < BLOCK_SIZE)    /* eof or error */
	{
	    if (ferror(fp))
	    {
		perror(path);
		exit(1);
	    }
	}

	MD5Update(&context, block, (unsigned)bytes_read);
    }

    fclose(fp);

    MD5Final(digest, &context);

    for (i = 0; i < 16; i++) printf("%02x", digest[i]);
    printf("\n");

    return 0;
}

