/*             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--             J. Scott Edwards - j.scott.edwards@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: export_public.c,v $
-- Revision 1.2  2007/04/07 12:20:13  jsedwards
-- Change to new separate time stamp for public and private.
--
-- Revision 1.1  2006/12/13 13:45:01  jsedwards
-- Initial version.
--
*/

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "../objectify_private.h"



int main(int argc, char* argv[])
{
    Disk_Header disk_header;
    Disk_Header* public_header_ptr;
    int obj_fd;
    FILE* out_fp;
    uint8 block[FILE_BLOCK_SIZE];
    size_t bytes_read;
    uint32 used_public_blocks;
    int i;

    if (argc != 2)
    {
	fprintf(stderr, "usage: %s file-name\n", argv[0]);
	exit(1);
    }

    out_fp = fopen(argv[1], "w");

    if (out_fp == NULL)
    {
	perror(argv[1]);
	exit(1);
    }

    obj_fd = open(DEFAULT_FILE, O_RDONLY);    /* don't need large file if not seeking? */

    if (obj_fd < 0)
    {
	perror(DEFAULT_FILE);
	exit(1);
    }


    /* read the header first */

    bytes_read = read(obj_fd, block, sizeof(block));

    if (bytes_read != sizeof(block))
    {
	perror(DEFAULT_FILE);
	exit(1);
    }

    memcpy(&disk_header, block, sizeof(disk_header));    /* copy the header into the header structure */


    /* create the public header in the block */

    memset(block, 0, sizeof(block));

    public_header_ptr = (Disk_Header*) block;

    memcpy(public_header_ptr->magic_number, disk_header.magic_number, sizeof(public_header_ptr->magic_number));

    memcpy(public_header_ptr->version_string, disk_header.version_string, sizeof(public_header_ptr->version_string));

    memcpy(public_header_ptr->public_last_change, disk_header.public_last_change, sizeof(public_header_ptr->public_last_change));

    memcpy(public_header_ptr->used_public_blocks, disk_header.used_public_blocks, sizeof(public_header_ptr->used_public_blocks));
    nwos_4_uint8_to_uint32(public_header_ptr->used_public_blocks, &used_public_blocks);

    public_header_ptr = NULL;    /* don't use this anymore */


    /* write the header block */

    if (fwrite(block, 1, sizeof(block), out_fp) != sizeof(block))
    {
	perror(argv[1]);
	exit(1);
    }

    for (i = 1; i < used_public_blocks; i++)
    {
	bytes_read = read(obj_fd, block, sizeof(block));

	if (bytes_read != sizeof(block))
	{
	    perror(DEFAULT_FILE);
	    exit(1);
	}

	if (fwrite(block, 1, sizeof(block), out_fp) != sizeof(block))
	{
	    perror(argv[1]);
	    exit(1);
	}
    }

    close(obj_fd);

    if (fclose(out_fp) != 0)
    {
	perror(argv[1]);
	exit(1);
    }

    return 1;
}

