# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import mobius
import pymobius
from gi.repository import GObject
from gi.repository import Gtk

from metadata import *


# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief About Dialog
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class AboutDialog(Gtk.AboutDialog):

    # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
    # @brief build widget
    # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
    def __init__(self, *args):
        GObject.GObject.__init__(self, *args)
        app = mobius.core.application()

        self.set_program_name(app.name)
        self.set_version('v' + app.version)
        self.set_copyright(app.copyright)
        self.set_authors(['Eduardo Aguiar <aguiar@protonmail.ch>'])
        self.set_comments('Open-source forensic toolkit')
        self.set_website('https://www.nongnu.org/mobiusft')
        self.set_website_label('https://www.nongnu.org/mobiusft')

        # logo
        logo_path = pymobius.mediator.call('extension.get-resource-path', EXTENSION_ID, 'logo.svg')
        image = mobius.ui.new_icon_by_path(logo_path, mobius.ui.icon.size_extra_large)
        icon = image.get_widget().get_ui_widget().get_pixbuf()
        self.set_logo(icon)

        # license
        license_path = pymobius.mediator.call('extension.get-resource-path', EXTENSION_ID, 'gpl.txt')
        license_text = open(license_path, 'r').read()
        self.set_license(license_text)
