/*===========================================================================*/
/*
 * This file is part of libogg++ - a c++ library for the Ogg transport format
 *
 * Copyright (C) 2006, 2007, 2008 Elaine Tsiang YueLien
 *
 * libogg++ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Ogg::Logical to Transport interface                                       */
/*                                                                           */
/*===========================================================================*/
#ifndef LogicalToTransportInterface
#define	LogicalToTransportInterface

#ifdef __GNUG__
#pragma interface
#endif

namespace	Ogg
{
  class		LogicalToTransport;
  class		PacketToTransport;
}

#include	<TransportImpl.H>

#include	<exception>

///
///@file <src/lib/LogicalToTransport.H>
///
namespace	Ogg
{
  class PacketToTransport : public Packet
  {
    friend class	TransportImpl;
    friend class	PageEncapser;
    friend class	PageDecapser;

  protected:
    static
    PacketToTransport *
    createPacket(
		 LogicalToTransport *
		 ,size_t
		 );

    void
    endStream();

    bool
    streamEnding();

    long
    pageSize();

    PacketToTransport *
    resize(
	   size_t
	   );
	
    bool
    flush();

    bool
    isHeader();

    long
    headerNo();

    void
    packetNo(
	     PacketNo
	     );
    
    Error
    transportError();

    void
    transportError(
		   Error::ErrorNo
		   );

    void
    transportError(
		   Error
		   );

    long
    done();

    void
    done(long);

    long
    toDo();

    void *
    copyLoc();

    Position
    granulePosition();

    void
    granulePosition(
		    Position
		    );
  };

  /// @brief Logical to Transport implementation interface
  ///
  /// @ingroup logicalImplementation
  ///
  /// Enques packets for encapsulation.
  /// Or deques decapsulated packets.
  /// Each Logical has its own queue.
  ///
  class LogicalToTransport
  {
    friend class	Page;
    friend class	PageImpl;
    friend class	TransportImpl;
    friend class	TransportToLogical;
    friend class	PageEncapser;
    friend class	PageDecapser;

  protected:
    /// @brief Return the Logical interface object

    Logical &
    intf();

    ///
    ///@brief Enque to the packet queue
    ///
    void
    enq(
	Packet &
	);

    ///
    /// @brief If there is anything to deque
    ///
    bool
    empty()
      ;
    
    ///
    /// @brief If the queue is full
    ///
    bool
    full()
      ;
    
    ///
    /// @brief Deque from the packet queue
    ///
    Packet *
    deq()
      ;

    ///
    /// @brief Wait for something to deque
    ///
    void
    wait()
      ;

    ///
    ///@brief Are we really decapsulating?
    ///
    bool
    decapping();

    ///
    ///@brief Are we reading pages?
    ///
    bool
    pageReading();

    ///
    ///@brief Are we really encapsulating?
    ///
    bool
    encapping();

    ///
    ///@brief Are we writing pages?
    ///
    bool
    pageWriting();

    ///
    ///@brief Enque to the page queue
    ///
    void
    enqPage(
	    Page &
	    );

    ///
    /// @brief If there is any page to deque
    ///
    bool
    anyPage()
      ;
    
    ///
    /// @brief If there are too many pages in page queue
    ///
    bool
    tooManyPages()
      ;
    
    ///
    /// @brief Deque from the page queue
    ///
    Page *
    deqPage()
      ;

    ///
    /// @brief Wait for a Page to deque
    ///
    void
    waitForPage()
      ;
  };
};
#endif
