/* Copyright (C) 2004 W.P. van Paassen - peter@paassen.tmfweb.nl

   This file is part of libmd5model
   
   libmd5model will attempt to parse ID's Doom3 mesh and animation model formats
   
   libmd5model is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your
   option) any later version.

   libmd5model is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with libmd5model; see the file COPYING.  If not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  */

#ifndef MD5_H
#define MD5_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
	int	version;
	const char* commandline;
	int	num_joints;
	int	num_meshes;
} MD5_MESH_HEADER;

typedef struct 
{
	float x,y,z;
} MD5_POINT;

typedef struct
{
	float x,y,z,w;
} MD5_QUAT;

typedef struct md5_joint
{
	const char* name;
	union
	{
		int idx;
		struct md5_joint* parent;
	} parent;
	MD5_POINT position;
	MD5_QUAT orientation;
} MD5_JOINT;

typedef struct md5_weight
{
	/*int id;*/
	union
	{
		int idx;
		MD5_JOINT* joint;
	} joint;
	float weight;
	float offset_x;
	float offset_y;
	float offset_z;
} MD5_WEIGHT;

typedef struct md5_mesh
{
	const char* shader;
	int num_verts;
	struct md5_vertex* verts;
	int num_tris;
	struct md5_triangle* tris;
	int num_weights;
	struct md5_weight* weights;
} MD5_MESH;

typedef struct md5_vertex
{
	/*int id;*/
	float texture_u;
	float texture_v;
	union
	{
		int idx;
		MD5_WEIGHT* weight;
	} weight;
	int num_weights;
} MD5_VERTEX;

typedef struct md5_triangle
{
	/*int id;*/
	union
	{
		int idx;
		MD5_VERTEX* vertex;
	} vertex1;
	union
	{
		int idx;
		MD5_VERTEX* vertex;
	} vertex2;
	union
	{
		int idx;
		MD5_VERTEX* vertex;
	} vertex3;
} MD5_TRIANGLE;

extern MD5_MESH_HEADER header;
extern MD5_JOINT* joints;
extern MD5_MESH* meshes;

int MD5_parse(const char* md5_filename, int compute_indices);
MD5_MESH_HEADER* MD5Mesh_get_header();
MD5_JOINT* MD5Mesh_get_joint(int idx);
MD5_MESH* MD5Mesh_get_mesh(int idx);
MD5_JOINT** MD5Mesh_get_joints();
MD5_MESH** MD5Mesh_get_meshes();
MD5_VERTEX* MD5Mesh_get_vertex(int mesh_id, int vertex_id);
MD5_TRIANGLE* MD5Mesh_get_triangle(int mesh_id, int triangle_id);
MD5_WEIGHT* MD5Mesh_get_weight(int mesh_id, int weight_id);
MD5_VERTEX** MD5Mesh_get_vertices(int mesh_id);
MD5_TRIANGLE** MD5Mesh_get_triangles(int mesh_id);
MD5_WEIGHT** MD5Mesh_get_weights(int mesh_id);
void MD5_free();

#ifdef __cplusplus
} /* closing bracket for extern "C" */
#endif

#endif
