/* A Bison parser, made by GNU Bison 1.875c.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     NUMBER = 258,
     VERSIONID = 259,
     CMDLINEID = 260,
     STRING = 261,
     NUMJOINTSID = 262,
     NUMFRAMESID = 263,
     JOINTSID = 264,
     FRAMERATEID = 265,
     LCURLY = 266,
     RCURLY = 267,
     LBRACKET = 268,
     RBRACKET = 269,
     NUMANICOMPSID = 270,
     HIERARCHYID = 271,
     BOUNDSID = 272,
     BASEFRAMEID = 273,
     FRAMEID = 274
   };
#endif
#define NUMBER 258
#define VERSIONID 259
#define CMDLINEID 260
#define STRING 261
#define NUMJOINTSID 262
#define NUMFRAMESID 263
#define JOINTSID 264
#define FRAMERATEID 265
#define LCURLY 266
#define RCURLY 267
#define LBRACKET 268
#define RBRACKET 269
#define NUMANICOMPSID 270
#define HIERARCHYID 271
#define BOUNDSID 272
#define BASEFRAMEID 273
#define FRAMEID 274




/* Copy the first part of user declarations.  */
#line 20 "md5anim_parser.y"

#include "libmd5model.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "md5anim_defines.h"
#define    yylex   MD5ANIM_lex
#define MD5ANIM_TRANSLATION_X	1
#define MD5ANIM_TRANSLATION_Y	2
#define MD5ANIM_TRANSLATION_Z	4
#define MD5ANIM_ORIENTATION_X	8
#define MD5ANIM_ORIENTATION_Y	16
#define MD5ANIM_ORIENTATION_Z	32
MD5ANIM_HEADER anim_header;
MD5ANIM_JOINT* baseframe = (MD5ANIM_JOINT*)NULL;
MD5_BOUND* bounds = (MD5_BOUND*)NULL;
extern int md5_perror;
float* frames;
int frame_index;
int frame_number;
int count;
typedef struct h_joint
{
	int flag;
	int start_index;
} H_JOINT;
H_JOINT* h_joints;

extern float sqrtf(float x);
extern char* strdup(const char* s);
extern int MD5ANIM_lex(void);

void MD5ANIM_error(char const* s)
{
	fprintf(stderr, "%s\n", s);
	md5_perror = 1;
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 62 "md5anim_parser.y"
typedef union YYSTYPE {
	int itype;
	float ftype;
	const char* ctype;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 161 "md5anim_parser.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 173 "md5anim_parser.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  6
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   86

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  20
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  22
/* YYNRULES -- Number of rules. */
#define YYNRULES  28
/* YYNRULES -- Number of states. */
#define YYNSTATES  79

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   274

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     9,    16,    19,    22,    25,    28,    31,
      34,    39,    41,    44,    49,    54,    56,    59,    70,    75,
      77,    80,    91,    93,    96,   102,   107,   109,   112
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      21,     0,    -1,    22,    29,    32,    35,    38,    -1,    23,
      24,    25,    26,    27,    28,    -1,     4,     3,    -1,     5,
       6,    -1,     8,     3,    -1,     7,     3,    -1,    10,     3,
      -1,    15,     3,    -1,    16,    11,    30,    12,    -1,    31,
      -1,    30,    31,    -1,     6,     3,     3,     3,    -1,    17,
      11,    33,    12,    -1,    34,    -1,    33,    34,    -1,    13,
       3,     3,     3,    14,    13,     3,     3,     3,    14,    -1,
      18,    11,    36,    12,    -1,    37,    -1,    36,    37,    -1,
      13,     3,     3,     3,    14,    13,     3,     3,     3,    14,
      -1,    39,    -1,    38,    39,    -1,    19,     3,    11,    40,
      12,    -1,    19,     3,    11,    12,    -1,    41,    -1,    40,
      41,    -1,     3,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,    87,    87,   192,   195,   201,   207,   214,   224,   230,
     236,   244,   245,   248,   264,   272,   273,   276,   289,   299,
     300,   303,   328,   329,   332,   336,   342,   343,   346
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "NUMBER", "VERSIONID", "CMDLINEID",
  "STRING", "NUMJOINTSID", "NUMFRAMESID", "JOINTSID", "FRAMERATEID",
  "LCURLY", "RCURLY", "LBRACKET", "RBRACKET", "NUMANICOMPSID",
  "HIERARCHYID", "BOUNDSID", "BASEFRAMEID", "FRAMEID", "$accept",
  "md5anim_file", "md5anim_header", "md5anim_version", "md5anim_cmdline",
  "md5anim_numframes", "md5anim_numjoints", "md5anim_framerate",
  "md5anim_numanimated_comps", "md5anim_jointspart", "md5anim_joints",
  "md5anim_joint", "md5anim_boundspart", "md5anim_bounds", "md5anim_bound",
  "md5anim_baseframe_part", "md5anim_baseframe_items",
  "md5anim_baseframe_item", "md5anim_framepart", "md5anim_frame",
  "md5anim_framenumbers", "md5anim_framenumber", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    30,    31,    32,    33,    33,    34,    35,    36,
      36,    37,    38,    38,    39,    39,    40,    40,    41
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     5,     6,     2,     2,     2,     2,     2,     2,
       4,     1,     2,     4,     4,     1,     2,    10,     4,     1,
       2,    10,     1,     2,     5,     4,     1,     2,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,     0,     0,     0,     0,     4,     1,     0,     0,     0,
       0,     0,     0,     0,     5,     0,     0,     0,     0,    11,
       0,     0,     0,     6,     0,     0,     0,    10,    12,     0,
       0,    15,     0,     0,     2,    22,     7,     0,     0,     0,
       0,    14,    16,     0,     0,    19,     0,    23,     8,     0,
       3,    13,     0,     0,    18,    20,     0,     9,     0,     0,
      28,    25,     0,    26,     0,     0,    24,    27,     0,     0,
       0,     0,     0,     0,     0,     0,    17,     0,    21
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     2,     3,     4,    10,    16,    25,    38,    50,     8,
      18,    19,    13,    30,    31,    22,    44,    45,    34,    35,
      62,    63
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -17
static const yysigned_char yypact[] =
{
       3,     8,    12,    -1,     9,   -17,   -17,     2,     0,    10,
      11,    14,     7,     4,   -17,    18,    16,    21,    -4,   -17,
      13,    17,     6,   -17,    24,    19,    27,   -17,   -17,    28,
      -9,   -17,    20,    29,     6,   -17,   -17,    31,    22,    32,
      33,   -17,   -17,    35,    -7,   -17,    30,   -17,   -17,    36,
     -17,   -17,    37,    39,   -17,   -17,    -3,   -17,    34,    40,
     -17,   -17,    -2,   -17,    38,    41,   -17,   -17,    42,    43,
      44,    46,    47,    49,    45,    50,   -17,    48,   -17
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -17,   -17,   -17,   -17,   -17,   -17,   -17,   -17,   -17,   -17,
     -17,    26,   -17,   -17,    51,   -17,   -17,    23,   -17,    52,
     -17,   -16
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
      60,    60,    17,    41,    29,    54,    43,     1,    27,    61,
      66,     5,     6,    11,     9,     7,    14,    12,    20,    15,
      17,    23,    21,    24,    26,    33,    29,    36,    32,    37,
      39,    40,    46,    43,    48,    51,    52,    49,    53,    57,
      58,    56,    59,    65,    28,    70,    67,    72,    64,    73,
      74,    68,    75,    77,     0,    69,    71,     0,     0,    76,
       0,     0,    78,     0,     0,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,     0,    47
};

static const yysigned_char yycheck[] =
{
       3,     3,     6,    12,    13,    12,    13,     4,    12,    12,
      12,     3,     0,    11,     5,    16,     6,    17,    11,     8,
       6,     3,    18,     7,     3,    19,    13,     3,    11,    10,
       3,     3,     3,    13,     3,     3,     3,    15,     3,     3,
       3,    11,     3,     3,    18,     3,    62,     3,    14,     3,
       3,    13,     3,     3,    -1,    14,    13,    -1,    -1,    14,
      -1,    -1,    14,    -1,    -1,    -1,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    30,    -1,    -1,    -1,    -1,    34
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     4,    21,    22,    23,     3,     0,    16,    29,     5,
      24,    11,    17,    32,     6,     8,    25,     6,    30,    31,
      11,    18,    35,     3,     7,    26,     3,    12,    31,    13,
      33,    34,    11,    19,    38,    39,     3,    10,    27,     3,
       3,    12,    34,    13,    36,    37,     3,    39,     3,    15,
      28,     3,     3,     3,    12,    37,    11,     3,     3,     3,
       3,    12,    40,    41,    14,     3,    12,    41,    13,    14,
       3,    13,     3,     3,     3,     3,    14,     3,    14
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 88 "md5anim_parser.y"
    {
			/* post-processing */
			
			int i,j;

			if (frame_index != anim_header.num_frames)
				MD5ANIM_error("Error: Incorrect number of frames");	

			for (i = 0; i < anim_header.num_joints; ++i)
			{
				if (h_joints[i].flag)
				{
					baseframe[i].frames = (MD5ANIM_FRAME*)malloc(anim_header.num_frames * sizeof(MD5ANIM_FRAME));

					/*TODO optimize, remove bit tests from loop */
					for (j = 0; j < anim_header.num_frames; ++j)
					{
						int flag_count = 0;
						if (h_joints[i].flag & MD5ANIM_TRANSLATION_X)
						{
							baseframe[i].frames[j].position.x = frames[j * anim_header.num_joints + h_joints[i].start_index];	
							flag_count++;
						}
						else
						{
							baseframe[i].frames[j].position.x = baseframe[i].position.x;
						}
						if (h_joints[i].flag & MD5ANIM_TRANSLATION_Y)
						{
							baseframe[i].frames[j].position.y = frames[j * anim_header.num_joints + h_joints[i].start_index + flag_count];	
							flag_count++;
						}
						else
						{
							baseframe[i].frames[j].position.y = baseframe[i].position.y;
						}
						if (h_joints[i].flag & MD5ANIM_TRANSLATION_Z)
						{
							baseframe[i].frames[j].position.z = frames[j * anim_header.num_joints + h_joints[i].start_index + flag_count];	
							flag_count++;
						}
						else
						{
							baseframe[i].frames[j].position.z = baseframe[i].position.z;
						}

						if (h_joints[i].flag & MD5ANIM_ORIENTATION_X)
						{
							baseframe[i].frames[j].orientation.x = frames[j * anim_header.num_joints + h_joints[i].start_index + flag_count];	
							flag_count++;
						}
						else
						{
							baseframe[i].frames[j].orientation.x = baseframe[i].orientation.x;
						}
						if (h_joints[i].flag & MD5ANIM_ORIENTATION_Y)
						{
							baseframe[i].frames[j].orientation.y = frames[j * anim_header.num_joints + h_joints[i].start_index + flag_count];	
							flag_count++;
						}
						else
						{
							baseframe[i].frames[j].orientation.y = baseframe[i].orientation.y;
						}
						if (h_joints[i].flag & MD5ANIM_ORIENTATION_Z)
						{
							baseframe[i].frames[j].orientation.z = frames[j * anim_header.num_joints + h_joints[i].start_index + flag_count];	
							flag_count++;
						}
						else
						{
							baseframe[i].frames[j].orientation.z = baseframe[i].orientation.z;
						}
						
						/*compute and set w component of quateration */

						if (h_joints[i].flag & 56)
						{
							float tmp;
							tmp = 1.0f - ( baseframe[i].frames[j].orientation.x * baseframe[i].frames[j].orientation.x + baseframe[i].frames[j].orientation.y * baseframe[i].frames[j].orientation.y + baseframe[i].frames[j].orientation.z * baseframe[i].frames[j].orientation.z );
							if(tmp > 0.0f)
								baseframe[i].frames[j].orientation.w = -sqrtf( tmp );
							else
								baseframe[i].frames[j].orientation.w = 0.0f;
						}
						else
						{
								baseframe[i].frames[j].orientation.w = baseframe[i].orientation.w;
						}
					}		
				}
				else
				{
					baseframe[i].frames = (MD5ANIM_FRAME*)NULL;
				}
			}	

			free(h_joints);
			free(frames);
		
			md5_perror = 0;
		}
    break;

  case 4:
#line 196 "md5anim_parser.y"
    {
			anim_header.version = yyvsp[0].itype;
 		}
    break;

  case 5:
#line 202 "md5anim_parser.y"
    {
			anim_header.commandline = (const char*)strdup(yyvsp[0].ctype);
		}
    break;

  case 6:
#line 208 "md5anim_parser.y"
    {
			anim_header.num_frames = yyvsp[0].itype;
			bounds = (MD5_BOUND*)malloc(anim_header.num_frames * sizeof(MD5_BOUND));
		}
    break;

  case 7:
#line 215 "md5anim_parser.y"
    {
			anim_header.num_joints = yyvsp[0].itype;
			baseframe = (MD5ANIM_JOINT*)malloc(anim_header.num_joints * sizeof(MD5ANIM_JOINT));
			h_joints = (H_JOINT*)malloc(anim_header.num_joints * sizeof(H_JOINT));
			frames = (float*)malloc(anim_header.num_joints * 6 * anim_header.num_frames * sizeof(float));
			count = 0;
		}
    break;

  case 8:
#line 225 "md5anim_parser.y"
    {
			anim_header.frame_rate = yyvsp[0].itype;
		}
    break;

  case 9:
#line 231 "md5anim_parser.y"
    {
			anim_header.num_animated_components = yyvsp[0].itype;
		}
    break;

  case 10:
#line 237 "md5anim_parser.y"
    {
			if (count != anim_header.num_joints)
				MD5ANIM_error("Error: Incorrect number of joints");	
			count = 0;
		}
    break;

  case 13:
#line 249 "md5anim_parser.y"
    {
			int idx = yyvsp[-2].itype;
			baseframe[count].name = (const char*)strdup(yyvsp[-3].ctype);

			if (idx == -1)
				baseframe[count].parent = (MD5ANIM_JOINT*)NULL;
			else
				baseframe[count].parent = (MD5ANIM_JOINT*)(baseframe + idx);

			h_joints[count].flag = yyvsp[-1].itype;
			h_joints[count].start_index = yyvsp[0].itype;
			count++;
		}
    break;

  case 14:
#line 265 "md5anim_parser.y"
    {
			if (count != anim_header.num_frames)
				MD5ANIM_error("Error: Incorrect number of bounds");	
			count = 0;	
		}
    break;

  case 17:
#line 277 "md5anim_parser.y"
    {
			bounds[count].min.x = yyvsp[-8].ftype;
			bounds[count].min.y = yyvsp[-7].ftype;
			bounds[count].min.z = yyvsp[-6].ftype;
 
			bounds[count].max.x = yyvsp[-3].ftype;
			bounds[count].max.y = yyvsp[-2].ftype;
			bounds[count].max.z = yyvsp[-1].ftype;
			count++;
		}
    break;

  case 18:
#line 290 "md5anim_parser.y"
    {
			if (count != anim_header.num_joints)
				MD5ANIM_error("Error: Incorrect number of baseframe joints");	
			count = 0;
			frame_index = 0;
			frame_number = 0;
		}
    break;

  case 21:
#line 304 "md5anim_parser.y"
    {
			float tmp,q1,q2,q3;

			baseframe[count].position.x = yyvsp[-8].ftype;			
			baseframe[count].position.y = yyvsp[-7].ftype;			
			baseframe[count].position.z = yyvsp[-6].ftype;			

			q1 = yyvsp[-3].ftype;
			q2 = yyvsp[-2].ftype;
			q3 = yyvsp[-1].ftype;
			baseframe[count].orientation.x = q1;
			baseframe[count].orientation.y = q2;
			baseframe[count].orientation.z = q3;

			tmp = 1.0f - ( q1 * q1 + q2 * q2 + q3 * q3 );
			if(tmp > 0.0f)
				baseframe[count].orientation.w = -sqrtf( tmp );
			else
				baseframe[count].orientation.w = 0.0f;

			count++;
		}
    break;

  case 24:
#line 333 "md5anim_parser.y"
    {
			frame_index++;
		}
    break;

  case 25:
#line 337 "md5anim_parser.y"
    {
			frame_index++;
		}
    break;

  case 28:
#line 347 "md5anim_parser.y"
    {
			frames[frame_index * anim_header.num_joints + frame_number] = yyvsp[0].ftype;
			frame_number++;
		}
    break;


    }

/* Line 1000 of yacc.c.  */
#line 1374 "md5anim_parser.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
		 yydestruct (yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
	  yydestruct (yytoken, &yylval);
	  yychar = YYEMPTY;

	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 353 "md5anim_parser.y"




