/*
 * vsop87_data.c - Series of terms in the VSOP87(A) theory
 * Copyright (C) 2010 Shiva Iyer <shiva.iyer AT g m a i l DOT c o m>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <vsop87.h>

struct vsop87_term mercury_x0[] = {
	{0.37546291728, 4.39651506942, 26087.90314157420},
	{0.03825746672, 1.16485604339, 52175.80628314840},
	{0.02625615963, 3.14159265359, 0.00000000000},
	{0.00584261333, 4.21599394757, 78263.70942472259},
	{0.00105716695, 0.98379033182, 104351.61256629678},
	{0.00021011730, 4.03469353923, 130439.51570787099},
	{0.00004433373, 0.80236674527, 156527.41884944518},
	{0.00000974967, 3.85319674536, 182615.32199101939},
	{0.00000700327, 4.45478725367, 24978.52458948080},
	{0.00000626468, 1.18563492001, 27197.28169366760},
	{0.00000446989, 2.97507181503, 1059.38193018920},
	{0.00000398401, 1.86487895049, 20426.57109242200},
	{0.00000277216, 3.77909548342, 31749.23519072640},
	{0.00000190657, 4.27201801941, 53285.18483524180},
	{0.00000181790, 4.94857138217, 1109.37855209340},
	{0.00000194418, 0.67806013045, 4551.95349705880},
	{0.00000221028, 0.62082250658, 208703.22513259358},
	{0.00000190713, 1.17385212686, 5661.33204915220},
	{0.00000138492, 1.22446421973, 51066.42773105500},
	{0.00000151693, 2.67604566886, 51116.42435295920},
	{0.00000095481, 0.16753795386, 529.69096509460},
	{0.00000114338, 0.56002737806, 57837.13833230060},
	{0.00000075179, 6.06954012703, 27147.28507176339},
	{0.00000074528, 4.92454709213, 46514.47423399620},
	{0.00000068378, 0.19832816518, 25132.30339996560},
	{0.00000065034, 4.90982770245, 21535.94964451540},
	{0.00000083764, 3.18666883018, 10213.28554621100},
	{0.00000057815, 5.70200416012, 14765.23904326980},
	{0.00000058577, 5.41671940122, 27043.50288318280},
	{0.00000060503, 4.99652964522, 47623.85278608960},
	{0.00000052662, 2.29801650543, 26617.59410666880},
	{0.00000054816, 5.30909046008, 12566.15169998280},
	{0.00000047830, 1.04296800531, 79373.08797681599},
	{0.00000051223, 3.53627826803, 426.59819087600},
	{0.00000051287, 3.67162149494, 234791.12827416777},
	{0.00000048376, 3.51890954721, 1589.07289528380},
	{0.00000048308, 3.65259825204, 25558.21217647960},
	{0.00000048571, 5.72915514275, 77204.32749453338},
	{0.00000034348, 5.67940957102, 51646.11531805379},
	{0.00000032947, 2.99496495895, 955.59974160860},
	{0.00000044563, 2.47566796995, 41962.52073693740},
	{0.00000028370, 0.70313546811, 30639.85663863300},
	{0.00000031389, 4.27598213407, 77154.33087262919},
	{0.00000027626, 6.14846127958, 37410.56723987860},
	{0.00000031953, 3.61313384181, 83925.04147387479},
	{0.00000027138, 0.33631401741, 39609.65458316560},
	{0.00000023212, 2.29683623821, 53131.40602475700},
	{0.00000026667, 6.25618354827, 36301.18868778519},
	{0.00000025545, 3.71486034105, 11322.66409830440},
	{0.00000027160, 1.78091430845, 6283.07584999140},
	{0.00000020743, 5.68024807830, 15874.61759536320},
	{0.00000023509, 3.99714350287, 13521.75144159140},
	{0.00000016406, 1.69451902864, 72602.37737557039},
	{0.00000016077, 3.22492362452, 9103.90699411760},
	{0.00000021076, 1.76532979749, 73711.75592766379},
	{0.00000015073, 2.81196372969, 18849.22754997420},
	{0.00000017093, 2.11618772835, 51749.20809227239},
	{0.00000015401, 0.38409642418, 7238.67559160000},
	{0.00000013833, 2.86060252439, 53235.18821333759},
	{0.00000016621, 2.16299341033, 50586.73338786459},
	{0.00000013461, 5.21674902395, 52705.49724824299},
	{0.00000013312, 5.80885733761, 25028.52121138500},
	{0.00000013751, 3.01700253042, 63498.47038145279},
	{0.00000012986, 3.87848079183, 26107.57290247399},
	{0.00000013012, 1.77284954668, 26068.23338067440},
	{0.00000013561, 3.25355689343, 51220.20654153979},
	{0.00000013481, 2.49743950723, 103292.23063610759},
	{0.00000012122, 0.43923849384, 260879.03141574195},
	{0.00000011390, 1.97720953024, 19317.19254032860},
	{0.00000010112, 2.38879888058, 77734.01845962799},
	{0.00000011952, 5.53005209823, 68050.42387851159},
	{0.00000012080, 4.09566440961, 105460.99111839019},
	{0.00000009187, 2.47899096314, 40853.14218484400},
	{0.00000009526, 2.10685579050, 38654.05484155699},
	{0.00000012384, 3.88491364454, 45892.73043315699},
	{0.00000008930, 0.47010685402, 26084.02180621620},
	{0.00000008927, 5.18134720032, 26091.78447693220},
	{0.00000012067, 3.39979120537, 65697.55772473979},
	{0.00000008856, 0.33573269125, 26514.50133245020},
	{0.00000008880, 0.74693819701, 3442.57494496540},
	{0.00000008473, 0.38165820380, 110012.94461544899},
	{0.00000008768, 4.86692437236, 32370.97899156560},
	{0.00000007627, 3.72724507066, 56727.75978020720},
	{0.00000008150, 0.32531424488, 27676.97603685800},
	{0.00000007210, 1.15776232612, 6770.71060124560},
	{0.00000007049, 2.53147779108, 33326.57873317420},
	{0.00000007373, 4.54270714371, 23869.14603738740},
	{0.00000005950, 5.34652499897, 79219.30916633119},
	{0.00000007534, 1.04407773149, 103242.23401420339},
	{0.00000005961, 3.04054522257, 62389.09182935939},
	{0.00000006001, 5.97534098237, 59414.48187474840},
	{0.00000006074, 3.52491992077, 32858.61374281979},
	{0.00000005423, 2.27094643224, 43071.89928903080},
	{0.00000005824, 0.72194174801, 19804.82729158280},
	{0.00000006044, 4.81765546230, 99799.65906923798},
	{0.00000006266, 5.22643441280, 25874.60404613620},
	{0.00000006266, 2.74603372834, 639.89728631400},
	{0.00000005832, 1.07051866290, 28306.66024576099},
	{0.00000005003, 0.33033193603, 26301.20223701220},
	{0.00000005657, 4.82919740832, 22645.32819660879},
	{0.00000004994, 1.08270815662, 213.29909543800},
	{0.00000004603, 4.10818821236, 26095.01668857500},
	{0.00000004092, 0.55410491255, 58946.51688439399},
	{0.00000005440, 5.17874103610, 76674.63652943878},
	{0.00000004418, 1.60012301239, 26080.78959457339},
	{0.00000003888, 4.74721605492, 98690.28051714458},
	{0.00000005320, 5.16942669114, 77837.11123384659},
	{0.00000003619, 5.54847850901, 129380.13377768178},
	{0.00000003309, 1.95062167120, 78793.40038981718},
	{0.00000003903, 0.75356452005, 29530.47808653960},
	{0.00000004017, 4.06270853170, 2118.76386037840},
	{0.00000003055, 5.92110388322, 79323.09135491178},
	{0.00000003593, 0.17002529302, 91785.46086631398},
	{0.00000003054, 5.55498513785, 69159.80243060499},
	{0.00000003082, 2.29839877933, 94138.32702008578},
	{0.00000003462, 0.65717640120, 71980.63357473118},
	{0.00000002908, 3.48998577457, 286966.93455731616},
	{0.00000003697, 6.07251486266, 89586.37352302698},
	{0.00000002722, 5.88257146743, 44937.13069154840},
	{0.00000002714, 5.41990364356, 103821.92160120218},
	{0.00000003249, 0.27004450324, 16983.99614745660},
	{0.00000003195, 4.87662483707, 2218.75710418680},
	{0.00000002650, 4.82437940961, 52156.13652224860},
	{0.00000003239, 2.70670864860, 25934.12433108940},
	{0.00000003208, 2.94509218256, 26241.68195205900},
	{0.00000003530, 1.59643050751, 7.11354700080},
	{0.00000003077, 0.02256903738, 77308.10968311399},
	{0.00000002481, 5.31236272529, 24498.83024629040},
	{0.00000003094, 0.86497244960, 131548.89425996438},
	{0.00000002727, 0.19052309532, 149.56319713460},
	{0.00000002485, 3.12313746508, 1052.26838318840},
	{0.00000002670, 0.64762614763, 52195.47604404819},
	{0.00000002225, 3.43314585329, 136100.84775702319},
	{0.00000001969, 5.16585183325, 64741.95798313119},
	{0.00000002412, 4.23189156828, 54394.56338733519},
	{0.00000002530, 6.01975765668, 1066.49547719000},
	{0.00000001942, 1.68431166303, 58458.88213313979},
	{0.00000001869, 0.48618542978, 82815.66292178139},
	{0.00000001825, 1.94930670328, 52179.68761850640},
	{0.00000001832, 5.52981828535, 66941.04532641819},
	{0.00000001778, 1.93899005409, 25619.93815121980},
	{0.00000001820, 3.52168197550, 52171.92494779040},
	{0.00000002115, 2.90697905251, 51535.90899683439},
	{0.00000001965, 5.03484402548, 45405.09568190280},
	{0.00000001705, 3.71423083400, 26555.86813192860},
	{0.00000001639, 3.39953737033, 52602.40447402440},
	{0.00000001664, 3.83119379567, 5327.47610838280},
	{0.00000001925, 5.78531479532, 13655.86049117640},
	{0.00000001650, 1.58612017312, 125887.56221081219},
	{0.00000001514, 3.39500148443, 53764.87917843220},
	{0.00000001866, 4.09501965735, 129330.13715577759},
	{0.00000001627, 4.79352239798, 48733.23133818299},
	{0.00000001673, 4.32252049417, 52168.69273614759},
	{0.00000001445, 6.10060041654, 88476.99497093359},
	{0.00000001654, 6.12789079469, 76.26607127560},
	{0.00000001539, 2.12017582322, 105307.21230790539},
	{0.00000001536, 1.96319343567, 102762.53967101299},
	{0.00000001393, 1.25587354727, 26081.27458267419},
	{0.00000001393, 4.39574517890, 26094.53170047421},
	{0.00000001411, 1.31309973304, 49957.04917896160},
	{0.00000001529, 2.73364151205, 85502.38501632259},
	{0.00000001247, 4.05247492508, 51962.50718771040},
	{0.00000001266, 6.24072120577, 35191.81013569180},
	{0.00000001458, 1.93796370187, 103925.01437542078},
	{0.00000001561, 1.52798608608, 6681.22485339960},
	{0.00000001537, 3.43210104670, 52389.10537858640},
	{0.00000001411, 1.66986522557, 50057.04242277000},
	{0.00000001014, 1.81620829580, 74821.13447975718},
	{0.00000001232, 0.84010473770, 52182.91983014920},
	{0.00000001068, 5.82601643881, 26727.80042788820},
	{0.00000000963, 2.31649309053, 155468.03691925599},
	{0.00000000991, 3.22224423668, 117873.36400788819},
	{0.00000000939, 3.69536889843, 12432.04265039780},
	{0.00000000956, 1.51577387873, 124778.18365871879},
	{0.00000000851, 3.47856448633, 85034.42002596818},
	{0.00000000907, 3.70816916557, 98068.53671630539},
	{0.00000000827, 4.98534406085, 104881.30353139139},
	{0.00000000827, 4.70714045338, 25661.30495069820},
	{0.00000000794, 5.34803060760, 120226.23016165999},
	{0.00000000846, 2.52472705200, 51123.53789995999},
	{0.00000000903, 5.45953667423, 52026.24308601380},
	{0.00000000923, 2.83668265777, 115674.27666460119},
	{0.00000000834, 5.95001308021, 3340.61242669980},
	{0.00000000706, 0.25739782784, 313054.83769889036},
	{0.00000000802, 3.91721323343, 157636.79740153858},
	{0.00000000929, 3.79917679735, 55618.38122811380},
	{0.00000000773, 2.32134386344, 95247.70557217918},
	{0.00000000723, 2.69407605052, 105410.99449648599},
	{0.00000000859, 5.91464456306, 51109.31080595839},
	{0.00000000716, 2.17754981522, 129909.82474277639},
	{0.00000000677, 0.70216648530, 419.48464387520},
	{0.00000000650, 3.13131829872, 64607.84893354619},
	{0.00000000673, 0.86671401461, 28206.66700195260},
	{0.00000000607, 1.59220678788, 78244.03966382280},
	{0.00000000659, 5.75914725971, 52022.02747266360},
	{0.00000000739, 3.07428442368, 103396.01282468818},
	{0.00000000585, 0.20238616925, 162188.75089859738},
	{0.00000000674, 5.81169972173, 38519.94579197200},
	{0.00000000730, 3.41907506693, 433.71173787680},
	{0.00000000590, 2.65601790847, 71025.03383312259},
	{0.00000000524, 2.22406383572, 10021.83728009940},
	{0.00000000673, 5.99514165920, 52329.58509363319},
	{0.00000000661, 5.96096138275, 77623.81213840858},
	{0.00000000506, 4.78871089926, 23754.70674870219},
	{0.00000000633, 4.13478072308, 45494.58142974879},
	{0.00000000466, 4.75460050527, 84546.78527471398},
	{0.00000000592, 3.30852715140, 7994.52844202420},
	{0.00000000545, 5.80602159358, 52099.54021187280},
	{0.00000000552, 2.39711760878, 1692.16566950240},
	{0.00000000456, 1.94151045577, 90829.86112470538},
	{0.00000000469, 3.29068228268, 26237.46633870879},
	{0.00000000521, 0.86596201958, 80482.46652890938},
	{0.00000000614, 3.69895971929, 78283.37918562238},
	{0.00000000444, 4.63869120122, 151975.46535238638},
	{0.00000000440, 6.26532535664, 27140.17152476259},
	{0.00000000472, 0.86276697768, 155418.04029735178},
	{0.00000000469, 3.53622250201, 108903.56606335558},
	{0.00000000590, 1.92833574451, 853.19638175200},
	{0.00000000425, 5.11858657725, 632.78373931320},
	{0.00000000447, 1.04087892038, 78256.59587772179},
	{0.00000000453, 3.64418740188, 26137.89976347840},
	{0.00000000454, 2.00715474668, 26037.90651966999},
	{0.00000000436, 0.82989514902, 2333.19639287200},
	{0.00000000405, 2.57594056066, 1581.95934828300},
	{0.00000000418, 5.03310520138, 128850.44281258718},
	{0.00000000429, 2.31358963023, 29428.51556827400},
	{0.00000000419, 5.00087241120, 78267.59076008058},
	{0.00000000400, 0.83625504703, 28421.09953444620},
	{0.00000000438, 1.02063855266, 78050.41032928458},
	{0.00000000502, 0.81791649248, 26720.68688088739},
	{0.00000000446, 5.82498138989, 25984.81036735560},
	{0.00000000426, 2.83085905523, 27154.39861876420},
	{0.00000000422, 2.30407366448, 93028.94846799239},
	{0.00000000441, 6.19559752006, 26190.99591579279},
	{0.00000000517, 4.94804650401, 25455.11940226100},
	{0.00000000390, 4.99072482742, 130012.91751699499},
	{0.00000000366, 3.54049188579, 22747.29071487440},
	{0.00000000364, 0.17059200526, 78690.30761559859},
	{0.00000000360, 2.87002870666, 114564.89811250778},
	{0.00000000418, 0.29020498002, 78259.82808936459},
	{0.00000000352, 0.48243014753, 52643.77127350280},
	{0.00000000447, 4.62889752225, 76144.94556434419},
	{0.00000000393, 0.20924522982, 78477.00852016058},
	{0.00000000337, 0.17003651408, 79852.78232000639},
	{0.00000000423, 1.38576321047, 46848.33017476560},
	{0.00000000328, 5.12139261865, 72936.23331633979},
	{0.00000000356, 6.07425645036, 48835.19385644859},
	{0.00000000335, 2.06671111251, 18207.81398823521},
	{0.00000000316, 4.36448926663, 76044.95232053580},
	{0.00000000403, 5.17867896855, 131395.11544947959},
	{0.00000000368, 5.56337901283, 25565.32572348040},
	{0.00000000417, 1.80274920701, 71492.99882347698},
	{0.00000000299, 4.63500144403, 25973.46385288896},
	{0.00000000297, 1.02156805675, 26202.34243025941},
	{0.00000000295, 2.68493144932, 103.09277421860},
	{0.00000000411, 0.25560489631, 1596.18644228460},
	{0.00000000285, 1.16807752441, 52182.43484204840},
	{0.00000000309, 0.40904055994, 74.78159856730},
	{0.00000000372, 1.49143639581, 19406.67828817460},
	{0.00000000293, 4.67573472055, 23969.13928119580},
	{0.00000000303, 4.97988934115, 51707.84129279399},
	{0.00000000287, 2.94652251384, 26164.16921284980},
	{0.00000000370, 3.57337038653, 26162.68474014150},
	{0.00000000321, 0.05550391453, 26610.48055966799},
	{0.00000000324, 6.13605453847, 20760.42703319140},
	{0.00000000267, 6.27484488465, 143961.26714946238},
	{0.00000000282, 2.62877155080, 536.80451209540},
	{0.00000000300, 2.58633931300, 224.34479570190},
	{0.00000000366, 5.76748576672, 111590.28815789679},
	{0.00000000258, 5.37268509995, 181555.94006083018},
	{0.00000000343, 2.03380599265, 26013.12154300690},
	{0.00000000273, 1.10657254532, 956.28915597060},
	{0.00000000252, 0.59000537549, 25668.41849769900},
	{0.00000000244, 4.83556134823, 51756.32163927320},
	{0.00000000285, 4.30750157848, 52169.17772424839},
	{0.00000000321, 1.57031879808, 25771.51127191760},
	{0.00000000320, 4.08881851808, 26404.29501123080},
	{0.00000000237, 0.47343036140, 124156.43985787958},
	{0.00000000305, 3.88207196267, 78270.82297172339},
	{0.00000000277, 1.42703926451, 1162.47470440780},
	{0.00000000274, 5.58277756568, 77211.44104153418},
	{0.00000000279, 2.68601229144, 77197.21394753258},
	{0.00000000259, 4.47711002004, 32769.12799497380},
	{0.00000000229, 0.93581945851, 110.20632121940},
	{0.00000000297, 4.60046007507, 2648.45482547300},
	{0.00000000218, 4.72556155170, 100909.03762133139},
	{0.00000000277, 4.66039961569, 26507.38778544939},
	{0.00000000212, 0.53351044088, 1478.86657406440},
	{0.00000000220, 0.21393446501, 111122.32316754239},
	{0.00000000213, 0.60035314724, 16066.06586147480},
	{0.00000000212, 3.53403079789, 42153.96900304900},
	{0.00000000208, 2.11083387325, 146314.13330323418},
	{0.00000000230, 5.88454220643, 141762.17980617538},
	{0.00000000241, 4.57150130406, 150866.08680029298},
	{0.00000000210, 0.69225590128, 183724.70054311278},
	{0.00000000279, 2.23082630295, 78114.14622758799},
	{0.00000000211, 1.74747254431, 130969.20667296558},
	{0.00000000243, 1.23801467525, 11610.55195837420},
	{0.00000000265, 2.55781243216, 39743.76363275060},
	{0.00000000222, 0.56159148263, 81706.28436968799},
	{0.00000000197, 2.60291082834, 52815.70356946240},
	{0.00000000247, 0.88342639891, 71582.48457132299},
	{0.00000000244, 2.23408992933, 51742.09454527159},
	{0.00000000202, 2.33370581573, 25881.71759313700},
	{0.00000000196, 3.28084664215, 26294.08869001139},
	{0.00000000177, 1.97797395237, 14477.35118320000},
	{0.00000000207, 5.81290429105, 1375.77379984580},
	{0.00000000220, 1.08810755857, 7880.08915333899},
	{0.00000000174, 3.31130146787, 339142.74084046457},
	{0.00000000169, 4.11217724456, 106570.36967048359},
	{0.00000000184, 6.12955693514, 129483.91596626239},
	{0.00000000172, 0.97217516384, 51543.02254383520},
	{0.00000000185, 2.73333187819, 103711.71527998279},
	{0.00000000192, 3.25987344029, 50483.64061364600},
	{0.00000000191, 5.22978475164, 155997.72788435058},
	{0.00000000196, 5.36844580786, 121335.60871375339},
	{0.00000000149, 3.30525660286, 33967.99229491319},
	{0.00000000152, 2.53081717814, 78109.93061423779},
	{0.00000000167, 3.75899797460, 467.96499035440},
	{0.00000000153, 1.95502612633, 44181.27784112419},
	{0.00000000155, 3.25656297117, 188276.65404017158},
	{0.00000000178, 5.74884343681, 131498.89763806018},
	{0.00000000158, 2.94930459323, 61279.71327726600},
	{0.00000000205, 3.72849237219, 51322.60990139639},
	{0.00000000159, 5.67523653240, 70269.18098269838},
	{0.00000000142, 3.09515542757, 50593.84693486539},
	{0.00000000148, 4.64350567688, 104331.94280539699},
	{0.00000000152, 5.28423765869, 52101.02468458109},
	{0.00000000158, 2.76578351678, 78417.48823520739},
	{0.00000000173, 5.18821469013, 26624.70765366959},
	{0.00000000139, 2.47064593676, 52278.89905736699},
	{0.00000000162, 0.92049935752, 25780.34552060460},
	{0.00000000159, 4.73827541063, 26395.46076254379},
	{0.00000000150, 4.09326692088, 23888.81579828719},
	{0.00000000149, 0.46707747400, 104371.28232719658},
	{0.00000000130, 4.64320618121, 22759.76748529401},
	{0.00000000125, 1.65138113985, 66653.15746634839},
	{0.00000000127, 3.92908708947, 54294.57014352679},
	{0.00000000139, 3.82303818931, 52808.59002246159},
	{0.00000000133, 1.43643107625, 102232.84870591838},
	{0.00000000170, 2.57893150930, 78187.44335344699},
	{0.00000000119, 1.41360479766, 178063.36849396059},
	{0.00000000121, 3.91397388740, 181505.94343892598},
	{0.00000000149, 2.93978448379, 13362.44970679920},
	{0.00000000122, 2.54446157327, 52072.71350892979},
	{0.00000000139, 5.71941525592, 97112.93697469679},
	{0.00000000115, 4.07185769679, 104344.49901929598},
	{0.00000000117, 1.54182773466, 110634.68841628819},
	{0.00000000127, 0.21479421217, 26521.61487945100},
	{0.00000000112, 1.81733872734, 154938.34595416138},
	{0.00000000111, 0.50939039069, 18093.37469954999},
	{0.00000000113, 0.81015998025, 25754.04720080480},
	{0.00000000108, 5.76941118774, 25448.00585526019},
	{0.00000000146, 0.58342798299, 60055.89543648739},
	{0.00000000108, 2.35657716458, 24176.70365835700},
	{0.00000000110, 4.84051151993, 26421.75908234360},
	{0.00000000104, 0.13113326845, 68241.87214462319},
	{0.00000000145, 1.30876998592, 316.39186965660},
	{0.00000000104, 1.75849927543, 156100.82065856918},
	{0.00000000110, 5.00176300515, 116917.76426627958},
	{0.00000000121, 1.57094829203, 28286.99048486120},
	{0.00000000143, 0.64505147056, 25551.09862947879},
	{0.00000000141, 5.41856442991, 50579.61984086379},
	{0.00000000101, 4.14115345148, 26198.10946279360},
	{0.00000000100, 5.46137709146, 25035.63475838580},
	{0.00000000101, 2.84451540031, 74923.09699802278},
	{0.00000000109, 3.14296852629, 51639.00177105299},
	{0.00000000096, 5.13699115630, 323.50541665740},
	{0.00000000100, 3.26577605891, 104564.91166173479},
	{0.00000000132, 2.63118128725, 647.01083331480},
	{0.00000000120, 0.30678874176, 134991.46920492979},
	{0.00000000098, 0.40293133382, 31415.37924995700},
	{0.00000000110, 0.16237016300, 24356.78078864160},
	{0.00000000127, 4.13213704562, 104138.31347085879},
	{0.00000000103, 5.28415599079, 55516.41870984820},
	{0.00000000097, 3.48076257184, 742.99006053260},
	{0.00000000093, 5.06100768596, 52125.80966124419},
	{0.00000000090, 3.88628119026, 54509.00267602040},
	{0.00000000102, 1.76819684789, 104355.49390165479},
	{0.00000000092, 0.93585280841, 29416.03879785439},
	{0.00000000099, 3.05816380866, 51951.46148744649},
	{0.00000000101, 5.00210914828, 26941.09952332620},
	{0.00000000093, 5.47802579149, 27780.06881107659},
	{0.00000000092, 5.92381365319, 140652.80125408198},
	{0.00000000101, 0.37463492787, 52250.58788171570},
	{0.00000000110, 1.19226098509, 49527.35145767539},
	{0.00000000106, 1.95430653957, 157483.01859105378},
	{0.00000000085, 0.07491193588, 52325.36948028299},
	{0.00000000088, 5.23856931735, 36109.74042167360},
	{0.00000000092, 4.54873108884, 51219.51712717779},
	{0.00000000099, 4.86416581345, 97580.90196505119},
	{0.00000000096, 5.49023224946, 27819.02549450680},
	{0.00000000083, 3.06701367899, 53228.07466633679},
	{0.00000000086, 4.71420290052, 52065.59996192899},
	{0.00000000100, 0.37157933173, 52225.80290505260},
	{0.00000000102, 5.36307297883, 119116.85160956658},
	{0.00000000086, 3.22100292543, 104778.21075717278},
	{0.00000000080, 3.16723228694, 27999.10262479140},
	{0.00000000082, 3.52865654881, 78731.67441507700},
	{0.00000000091, 6.01617993088, 12725.45343477500},
	{0.00000000079, 3.22192807282, 40565.25432477420},
	{0.00000000091, 4.58356981907, 51859.41441349179},
	{0.00000000078, 5.89716715733, 53242.30176033840},
	{0.00000000076, 1.13153106088, 102132.85546210999},
	{0.00000000079, 3.22173800911, 105940.68546158058},
	{0.00000000093, 2.96543716449, 2221.85663459700},
	{0.00000000090, 4.23026579034, 51013.33157874059},
	{0.00000000089, 0.85475471665, 1911.19948321720},
	{0.00000000075, 4.78657001260, 3328.13565628019},
	{0.00000000089, 2.51053764331, 137678.19129947099},
	{0.00000000073, 5.12605342426, 50696.93970908399},
	{0.00000000102, 3.34060456120, 104347.73123093879},
	{0.00000000072, 3.05203065820, 170049.17029103659},
	{0.00000000088, 0.84909576958, 52492.19815280499},
	{0.00000000078, 5.73315772437, 103285.11708910679},
	{0.00000000076, 2.77567349877, 25021.40766438420},
	{0.00000000074, 1.54799312825, 52595.29092702359},
	{0.00000000075, 1.65964856775, 77844.22478084739},
	{0.00000000076, 5.29592084579, 25953.79409198919},
	{0.00000000093, 3.12123076178, 52698.38370124219},
	{0.00000000071, 1.81949696208, 99024.13645791399},
	{0.00000000069, 5.67393312508, 27669.86248985719},
	{0.00000000082, 4.53867872623, 8194.27533320860},
	{0.00000000070, 3.97459919519, 24998.19435038059},
	{0.00000000073, 0.37194429847, 26222.01219115920},
	{0.00000000066, 4.21010251137, 78270.33798362259},
	{0.00000000075, 0.63857154574, 104358.72611329758},
	{0.00000000068, 1.33087179491, 25977.69682035479},
	{0.00000000065, 5.87150671106, 12546.48193908300},
	{0.00000000068, 2.13534804773, 207643.84320240439},
	{0.00000000073, 3.92326982541, 97670.38771289718},
	{0.00000000083, 0.67057706395, 522.57741809380},
	{0.00000000077, 5.28001515588, 104202.04936916218},
	{0.00000000080, 5.28926332171, 77829.99768684579},
	{0.00000000068, 2.82878970797, 2111.65031337760},
	{0.00000000079, 3.79946681872, 25446.48957983520},
	{0.00000000062, 3.49840489113, 150244.34299945379},
	{0.00000000070, 3.33224029594, 27684.08958385880},
	{0.00000000060, 4.35892959809, 846.08283475120},
	{0.00000000072, 6.12464480054, 50800.03248330259},
	{0.00000000063, 1.68487980742, 27177.61193276780},
	{0.00000000070, 4.93912259682, 17893.62780836560},
	{0.00000000062, 4.07249777023, 52290.24557183361},
	{0.00000000059, 1.39971005804, 52061.36699446317},
	{0.00000000074, 1.85368417401, 26729.31670331319},
	{0.00000000059, 5.00188297268, 220.41264243880},
	{0.00000000067, 1.68143884967, 2008.55753915900},
	{0.00000000078, 5.50238014696, 26086.41866886590},
	{0.00000000077, 2.35428024909, 103299.34418310839},
	{0.00000000077, 0.15680563848, 26089.38761428249},
	{0.00000000058, 2.64366803071, 167850.08294774959},
	{0.00000000056, 3.75317204098, 209812.60368468695},
	{0.00000000058, 1.54141936736, 25508.21555457540},
	{0.00000000055, 5.11846973847, 44295.71712980940},
	{0.00000000074, 5.40235174363, 90695.75207512038},
	{0.00000000056, 5.41213842126, 22625.65843570900},
	{0.00000000058, 5.00595087071, 24448.83362438620},
	{0.00000000066, 1.74137162401, 77795.74443436819},
	{0.00000000060, 3.25440342504, 137210.22630911658},
	{0.00000000053, 6.01392123943, 52252.07235442399},
	{0.00000000055, 5.16128806691, 172402.03644480839},
	{0.00000000063, 0.49748028885, 77410.51304297059},
	{0.00000000055, 3.60654464612, 107794.18751126219},
	{0.00000000067, 1.36610006933, 19.66976089979},
	{0.00000000054, 4.25219663118, 60370.08161635699},
	{0.00000000062, 3.70491161314, 949.17560896980},
	{0.00000000072, 1.66730834668, 2199.08734328700},
	{0.00000000070, 4.72694535646, 24864.08530079559},
	{0.00000000054, 0.83991353377, 25938.33994443960},
	{0.00000000052, 5.67389658184, 26312.24793727610},
	{0.00000000051, 4.20616611062, 55503.94193942859},
	{0.00000000051, 1.38932880278, 126996.94076290558},
	{0.00000000057, 5.00882179696, 38.13303563780},
	{0.00000000052, 4.12665298549, 26667.59072857300},
	{0.00000000061, 2.99099061629, 38813.35657634920},
	{0.00000000050, 1.22898875729, 58857.03113654799},
	{0.00000000049, 5.77137528617, 129799.61842155698},
	{0.00000000055, 4.77668766562, 157057.10981453978},
	{0.00000000066, 1.07578161516, 78257.08086582259},
	{0.00000000047, 5.68018085277, 51969.62073471119},
	{0.00000000050, 0.62769089958, 27726.97265876220},
	{0.00000000047, 6.07590356304, 76681.75007643958},
	{0.00000000064, 0.02610133525, 76571.54375522019},
	{0.00000000048, 3.85151205518, 77630.92568540938},
	{0.00000000047, 4.16677363723, 27044.19229754480},
	{0.00000000047, 2.89523133719, 155571.81910783658},
	{0.00000000054, 5.79169304973, 23919.14265929160},
	{0.00000000063, 0.92748869514, 27311.72098235281},
	{0.00000000046, 0.24060913723, 29550.14784743939},
	{0.00000000051, 1.39209045161, 28736.35796704720},
	{0.00000000062, 1.33564279040, 176953.98994186718},
	{0.00000000053, 0.23746311564, 27037.07875054399},
	{0.00000000043, 5.65844331747, 78903.60671103658},
	{0.00000000053, 0.29722112114, 54087.00576636560},
	{0.00000000043, 4.35653510451, 1272.68102562720},
	{0.00000000050, 3.33106077360, 1.48447270830},
	{0.00000000043, 3.66662961756, 16703.06213349900},
	{0.00000000042, 2.03378131455, 1485.98012106520},
	{0.00000000042, 2.08219460796, 78188.92782615528},
	{0.00000000053, 2.13789461791, 147423.51185532758},
	{0.00000000048, 5.60385784254, 65831.66677432480},
	{0.00000000041, 6.24695538371, 206.18554843720},
	{0.00000000048, 5.45683494266, 25138.72753260440},
	{0.00000000053, 0.12507223621, 52381.99183158559},
	{0.00000000041, 3.35871947817, 1795.25844372100},
	{0.00000000049, 5.16281052467, 26709.64694241340},
	{0.00000000040, 0.81354779862, 132658.27281205778},
	{0.00000000054, 0.20680001648, 153.77881048480},
	{0.00000000048, 0.50977666152, 25466.15934073500},
	{0.00000000047, 2.16892174570, 76667.52298243798},
	{0.00000000040, 1.64818311544, 26823.77965510599},
	{0.00000000044, 0.08844410692, 365230.64398203876},
	{0.00000000049, 1.91714086006, 75930.51303185058},
	{0.00000000040, 4.01884342217, 25352.02662804239},
	{0.00000000046, 5.62653039055, 104275.34649502118},
	{0.00000000044, 0.03463265500, 214364.55718174578},
	{0.00000000044, 1.85079090927, 52712.61079524379},
	{0.00000000051, 1.98801868265, 182085.63102592478},
	{0.00000000044, 6.15351278676, 28256.66362385679},
	{0.00000000038, 5.81365212706, 104505.39137678158},
	{0.00000000043, 5.33420928917, 25867.49049913539},
	{0.00000000037, 5.57899251145, 104197.83375581198},
	{0.00000000042, 5.19722521758, 25169.97285559240},
	{0.00000000038, 3.94772947506, 26102.13023557580},
	{0.00000000038, 3.51956196186, 130459.18546877075},
	{0.00000000036, 4.54511004825, 128320.75184749259},
	{0.00000000037, 3.02198266683, 26118.23000257860},
	{0.00000000041, 1.79637344087, 1265.56747862640},
	{0.00000000037, 1.67070947391, 24203.00197815680},
	{0.00000000036, 2.65041173436, 26057.57628056979},
	{0.00000000038, 1.66427845773, 26402.08932144380},
	{0.00000000038, 5.13531782692, 9384.84100807520},
	{0.00000000039, 0.46607609112, 27005.83342755599},
	{0.00000000039, 5.40354793843, 151.04766984290},
	{0.00000000037, 5.42747720341, 78366.80219894118},
	{0.00000000037, 4.00811594346, 25773.71696170459},
	{0.00000000034, 3.56462720934, 27566.76971563859},
	{0.00000000045, 0.79959361589, 2125.87740737920},
	{0.00000000035, 0.56576540054, 78896.49316403578},
	{0.00000000034, 1.75287834063, 26073.67604757259},
	{0.00000000038, 1.41911789835, 130419.84594697120},
	{0.00000000044, 2.53375250429, 157586.80077963437},
	{0.00000000034, 3.67701355195, 25985.94062330859},
	{0.00000000033, 0.53966934587, 51852.30086649099},
	{0.00000000035, 4.00506060972, 27972.80430499159},
	{0.00000000035, 2.61916970082, 27463.67694142000},
	{0.00000000033, 1.99538084924, 26189.86565983980},
	{0.00000000032, 0.69003641909, 207593.84658050018},
	{0.00000000040, 4.40927057090, 148.07872442630},
	{0.00000000035, 3.16175106244, 51653.22886505459},
	{0.00000000034, 3.96853644086, 51868.24866217880},
	{0.00000000038, 5.50377225938, 64901.25971792339},
	{0.00000000043, 3.02087771501, 51528.79544983359},
	{0.00000000036, 0.94812382604, 130226.21661243298},
	{0.00000000042, 0.56126000400, 26308.31578401300},
	{0.00000000031, 5.57428335318, 78160.61665050399},
	{0.00000000032, 4.46013138626, 204151.27163553478},
	{0.00000000032, 2.18005598447, 51432.81622261579},
	{0.00000000030, 0.82681675219, 130432.40216087017},
	{0.00000000030, 2.78120590799, 116783.65521669458},
	{0.00000000032, 1.19634441527, 26011.63707029860},
	{0.00000000030, 4.81616957225, 182188.72380014337},
	{0.00000000030, 4.58762516085, 49842.60989027639},
	{0.00000000029, 4.88576757444, 181026.24909573558},
	{0.00000000031, 4.17809672541, 26083.97098831109},
	{0.00000000029, 4.00562317628, 23439.44831610119},
	{0.00000000030, 3.25773726286, 94329.77528619739},
	{0.00000000028, 0.70524581752, 80382.47328510099},
	{0.00000000029, 4.41924870429, 114.39910691340},
	{0.00000000030, 0.97454681171, 77101.23472031478},
	{0.00000000031, 3.62133003349, 13541.42120249119},
	{0.00000000027, 5.91976429127, 101011.00013959699},
	{0.00000000037, 4.29084367097, 37698.45509994840},
	{0.00000000029, 1.50978551760, 26091.83529483729},
	{0.00000000027, 1.62628759375, 52509.66222391780},
	{0.00000000027, 0.05278402845, 130652.81480330898},
	{0.00000000028, 4.62722813500, 54374.89362643540},
	{0.00000000034, 1.33764060023, 77307.42026875199},
	{0.00000000028, 5.03737783889, 183570.92173262799},
	{0.00000000026, 5.99681746879, 26049.77010593640},
	{0.00000000030, 0.32859851834, 24395.73747207180},
	{0.00000000034, 1.25342876252, 22003.91463486980},
	{0.00000000033, 6.20284454959, 77726.90491262719},
	{0.00000000029, 4.59659721132, 136722.59155786238},
	{0.00000000035, 1.49684301877, 52483.36390411799},
	{0.00000000033, 2.75649306165, 49953.94964855139},
	{0.00000000026, 1.90176515926, 76784.84285065818},
	{0.00000000031, 6.01278123151, 87367.61641884019},
	{0.00000000034, 0.00576676128, 1905.46476494040},
	{0.00000000029, 2.06052680441, 51226.63067417859},
	{0.00000000028, 5.93842433817, 34282.17847478280},
	{0.00000000032, 3.35937950567, 161079.37234650398},
	{0.00000000031, 4.07910584606, 75615.25459924959},
	{0.00000000033, 6.12422500331, 78039.36462902068},
	{0.00000000027, 0.91518492018, 1223.81784077861},
	{0.00000000033, 2.48498925172, 123200.84011627098},
	{0.00000000029, 0.08978768557, 26575.53789282839},
	{0.00000000025, 3.43998049238, 78338.49102328988},
	{0.00000000024, 2.66945427931, 24824.74577899600},
	{0.00000000024, 3.24564642216, 1045.15483618760},
	{0.00000000029, 5.58510707424, 25600.26839032000},
	{0.00000000027, 0.73776364996, 27170.98337386779},
	{0.00000000027, 4.92586138125, 25004.82290928060},
	{0.00000000026, 5.97260588863, 39450.35284837340},
	{0.00000000023, 3.00242836566, 27351.06050415239},
	{0.00000000024, 2.49215995784, 129373.02023068098},
	{0.00000000025, 2.88697470245, 50064.15596977079},
	{0.00000000025, 5.00115643159, 299.12639426920},
	{0.00000000027, 1.76553297822, 143005.66740785378},
	{0.00000000023, 3.27216589351, 52609.51802102519},
	{0.00000000027, 1.29818173739, 24072.92146977640},
	{0.00000000028, 3.14979814758, 65717.22748563958},
	{0.00000000024, 0.97156468917, 52286.01260436779},
	{0.00000000030, 4.42414087291, 30171.89164827860},
	{0.00000000025, 1.41122590276, 48847.67062686820},
	{0.00000000029, 4.64941810533, 3.93215326310},
	{0.00000000026, 1.50614892755, 78153.50310350319},
	{0.00000000023, 1.32747738833, 77947.31755506598},
	{0.00000000023, 1.63079770877, 123668.80510662538},
	{0.00000000030, 2.27056118316, 53906.92863608099},
	{0.00000000022, 1.83245731848, 78213.71280281838},
	{0.00000000025, 5.93871501925, 26724.89941359840},
	{0.00000000025, 6.00809531914, 25450.90686955000},
	{0.00000000022, 5.41897797101, 50264.60679993120},
	{0.00000000030, 2.89300380445, 1731.12235293260},
	{0.00000000029, 6.26467372784, 6129.29703950660},
	{0.00000000022, 3.40134712578, 6885.14988993081},
	{0.00000000026, 4.37859274213, 28102.88481337200},
	{0.00000000024, 6.19145581405, 78786.28684281638},
	{0.00000000025, 0.11282707964, 130435.63437251298},
	{0.00000000022, 3.21335876929, 50444.68393021580},
	{0.00000000021, 0.94006911216, 51955.39364070959},
	{0.00000000022, 3.51848051148, 103498.41618454478},
	{0.00000000021, 2.37348270979, 35472.74414964940},
	{0.00000000023, 2.05327785040, 103917.90082841998},
	{0.00000000023, 4.96709654012, 16342.58258571760},
	{0.00000000025, 2.29706808754, 52174.32181044009},
	{0.00000000022, 3.88895575058, 78580.10129437919},
	{0.00000000022, 0.65838685946, 80596.90581759460},
	{0.00000000024, 3.86546209537, 51841.95034237900},
	{0.00000000029, 1.62800102685, 14.22709400160},
	{0.00000000023, 5.40491354928, 129387.24732468258},
	{0.00000000020, 1.31076853893, 51329.72344839720},
	{0.00000000025, 2.01244999882, 81604.32185142238},
	{0.00000000021, 3.01395405474, 1063.31408345230},
	{0.00000000021, 0.67741466251, 123758.29085447139},
	{0.00000000027, 2.90106794933, 76887.93562487679},
	{0.00000000023, 3.97874341983, 3462.24470586520},
	{0.00000000020, 1.71776764968, 1089.70879119360},
	{0.00000000022, 2.28317396212, 24491.71669928959},
	{0.00000000021, 5.53325591048, 163766.09444104518},
	{0.00000000022, 3.98134921024, 50167.24874398939},
	{0.00000000020, 5.13525290875, 735.87651353180},
	{0.00000000021, 2.05459082055, 130289.95251073639},
	{0.00000000020, 6.09945384418, 196137.07343261078},
	{0.00000000023, 2.69768658787, 166740.70439565618},
	{0.00000000021, 0.61205369640, 96357.08412427259},
	{0.00000000022, 0.06669236593, 26126.03617721200},
	{0.00000000022, 5.71636060779, 26734.91397488900},
	{0.00000000019, 4.66884897067, 78683.19406859778},
	{0.00000000024, 2.12828546843, 145204.75475114079},
	{0.00000000023, 4.84049690148, 27223.58001346740},
	{0.00000000019, 3.69323819425, 130446.62925487179},
	{0.00000000024, 3.04675754545, 52177.29075585669},
	{0.00000000018, 0.72295496626, 112231.70171963578},
	{0.00000000024, 4.23773296616, 24925.42843716640},
	{0.00000000025, 4.82366657336, 130443.39704322898},
	{0.00000000020, 5.54482262721, 39629.32434406539},
	{0.00000000022, 0.83649888960, 24952.22626968100},
	{0.00000000019, 6.21298740233, 24505.94379329119},
	{0.00000000020, 0.30552664552, 104819.57755665119},
	{0.00000000019, 6.23315092064, 26248.31051095900},
	{0.00000000019, 5.71365941775, 25927.49577218939},
	{0.00000000018, 4.18931740994, 128220.75860368418},
	{0.00000000020, 5.93600662958, 25907.82601128960},
	{0.00000000020, 6.01080370881, 26267.98027185880},
	{0.00000000019, 4.93432108959, 52817.21984488739},
	{0.00000000018, 1.78785742512, 53029.00266490040},
	{0.00000000018, 1.87891344947, 26411.40855823160},
	{0.00000000022, 4.75001386674, 103932.12792242158},
	{0.00000000018, 4.90666145829, 27573.19384827740},
	{0.00000000021, 6.27990297281, 130866.11389874699},
	{0.00000000025, 3.36120084514, 78313.70604662679},
	{0.00000000018, 0.81718560103, 52137.67324751059},
	{0.00000000020, 5.18305639217, 233731.74634397858},
	{0.00000000020, 0.38279809837, 12412.37288949800},
	{0.00000000018, 3.15536708233, 78413.27262185719},
	{0.00000000017, 2.29182997194, 53867.97195265079},
	{0.00000000019, 3.08463122927, 102659.44689679438},
	{0.00000000017, 0.77039059907, 24602.61243487099},
	{0.00000000019, 6.28210678104, 132028.58860315479},
	{0.00000000016, 2.69293004860, 79330.20490191258},
	{0.00000000018, 6.15816966745, 79315.97780791098},
	{0.00000000016, 2.78510813583, 92741.06060792258},
	{0.00000000019, 2.01731902987, 86143.79857806159},
	{0.00000000016, 1.31341405081, 50903.12525752120},
	{0.00000000016, 2.44368919495, 3.88133535800},
	{0.00000000016, 3.65774554265, 50689.82616208319},
	{0.00000000016, 6.10122094573, 28309.75977617119},
	{0.00000000016, 4.26178376234, 6044.22858137540},
	{0.00000000015, 2.51967305706, 155887.52156313117},
	{0.00000000022, 6.08458810680, 1055.44977692610},
	{0.00000000021, 5.13080043101, 3178.14579056760},
	{0.00000000017, 3.32835182606, 55638.05098901359},
	{0.00000000016, 0.98987078340, 104358.24112519680},
	{0.00000000015, 0.52512621542, 235900.50682626116},
	{0.00000000016, 0.28898343422, 176332.24614102798},
	{0.00000000015, 3.42730813171, 52309.91533273340},
	{0.00000000017, 4.88375242853, 125112.03959948818},
	{0.00000000016, 1.99816798814, 62197.64356324779},
	{0.00000000016, 4.51457964099, 61560.64729122359},
	{0.00000000018, 4.94346053652, 50049.92887576919},
	{0.00000000015, 2.61658139005, 50007.04580086580},
	{0.00000000015, 0.06610754830, 26830.89320210680},
	{0.00000000014, 0.38206454808, 133882.09065283638},
	{0.00000000015, 5.28887949143, 102755.42612401219},
	{0.00000000015, 2.92331490635, 102769.65321801379},
	{0.00000000014, 5.66688710771, 193937.98608932378},
	{0.00000000016, 1.91576514422, 77.75054398390},
	{0.00000000016, 4.13091799370, 104344.98400739678},
	{0.00000000014, 1.95123243708, 26247.20487636640},
	{0.00000000014, 3.71239259413, 25928.60140678200},
	{0.00000000015, 5.21246865831, 173511.41499690177},
	{0.00000000013, 2.28227257639, 50380.54783942739},
	{0.00000000016, 3.86619726000, 50910.23880452200},
	{0.00000000014, 5.78969562755, 1169.58825140860},
	{0.00000000014, 4.35629855542, 153084.84390447979},
	{0.00000000016, 3.71527476533, 53814.87580033639},
	{0.00000000014, 0.41808098652, 25234.70675982219},
	{0.00000000014, 4.45337551699, 78149.27013603736},
	{0.00000000016, 4.39060666970, 203041.89308344138},
	{0.00000000015, 6.07885192222, 77616.69859140778},
	{0.00000000013, 4.95992660397, 25654.19140369739},
	{0.00000000014, 4.39150540314, 52161.57918914679},
	{0.00000000014, 0.84211332161, 78378.14871340781},
	{0.00000000014, 0.69241893678, 35833.22369743080},
	{0.00000000014, 3.21771971652, 26076.85744131030},
	{0.00000000014, 2.44590531469, 26098.94884183810},
	{0.00000000016, 0.56654525193, 51534.39272140940},
	{0.00000000014, 4.45033215443, 20043.67456019880},
	{0.00000000014, 1.93515798949, 198489.93958638258},
	{0.00000000013, 0.54283839653, 103718.82882698359},
	{0.00000000016, 4.43529118981, 1639.06951718800},
	{0.00000000012, 5.66254865130, 122444.98726584678},
	{0.00000000016, 6.03889434600, 34082.43158359840},
	{0.00000000012, 1.26244334627, 25984.12095299360},
	{0.00000000012, 4.40118168494, 26191.68533015479},
	{0.00000000014, 4.74015829600, 53265.51507434200},
	{0.00000000012, 5.94982180077, 181659.72224941078},
	{0.00000000014, 3.98129674269, 53399.62412392700},
	{0.00000000012, 0.13991027783, 53771.99272543299},
	{0.00000000012, 1.72516185425, 43981.53094993980},
	{0.00000000012, 5.92386757303, 28199.55345495179},
	{0.00000000012, 4.59110069577, 51596.11869614960},
	{0.00000000013, 0.25880243151, 52024.75861330549},
	{0.00000000011, 4.64769916430, 52911.68279668019},
	{0.00000000011, 1.89863893326, 70383.62027138360},
	{0.00000000015, 4.79472245666, 103883.64757594238},
	{0.00000000014, 4.32477700221, 27250.37784598199},
	{0.00000000013, 5.01690772702, 208173.53416749898},
	{0.00000000015, 0.03679463460, 163298.12945069079},
	{0.00000000011, 2.17975116288, 48713.56157728320},
	{0.00000000014, 1.00856446032, 52755.49387014719},
	{0.00000000014, 2.05272684647, 52041.69723356339},
	{0.00000000012, 2.40230884933, 130363.24963659538},
	{0.00000000011, 5.14348161985, 104276.83096772949},
	{0.00000000015, 5.02019535476, 86457.98475793119},
	{0.00000000013, 1.25530162701, 52027.72755872209},
	{0.00000000013, 3.20863649406, 78469.89497315978},
	{0.00000000011, 3.18070767588, 57503.28239153120},
	{0.00000000014, 1.85655805059, 860.30992875280},
	{0.00000000011, 2.30875109886, 333.85594076940},
	{0.00000000011, 1.25057869011, 20894.53608277640},
	{0.00000000012, 0.71489552500, 51439.92976961659},
	{0.00000000012, 4.22401388053, 52179.73843641149},
	{0.00000000012, 5.79488724906, 19958.60610206760},
	{0.00000000011, 5.64222354696, 641.41356173899},
	{0.00000000011, 1.70452703232, 50536.73676596039},
	{0.00000000012, 2.51294543080, 53757.76563143139},
	{0.00000000010, 2.79700804590, 78339.97549599818},
	{0.00000000011, 4.88405989087, 78800.51393681798},
	{0.00000000010, 4.25860529638, 84944.93427812219},
	{0.00000000013, 1.35336167125, 11.04570026390},
	{0.00000000012, 6.06146445452, 142871.55835826878},
	{0.00000000014, 1.53374794610, 183145.01295611398},
	{0.00000000010, 3.55930973128, 53093.73656913019},
	{0.00000000010, 1.32119540129, 154408.65498906678},
	{0.00000000014, 2.93956277298, 54344.56676543099},
	{0.00000000011, 2.53121281826, 78057.52387628538},
	{0.00000000012, 1.32462443773, 26149.62911631439},
	{0.00000000012, 4.33900059348, 26026.17716683400},
	{0.00000000010, 1.43862971027, 25131.61398560359},
	{0.00000000010, 2.36278600509, 91919.56991589899},
	{0.00000000014, 3.26945543294, 53124.98189211819},
	{0.00000000012, 5.83805070397, 76041.85279012559},
	{0.00000000010, 3.56286217757, 77940.20400806518},
	{0.00000000010, 4.17334109977, 6751.04084034580},
	{0.00000000010, 0.50269108150, 28791.51929624980},
	{0.00000000013, 5.65469308747, 50270.34151820800},
	{0.00000000011, 5.25033320568, 77520.71936418998},
	{0.00000000011, 5.27964044996, 39763.43339365039},
	{0.00000000010, 0.66820373958, 636.99627202420},
	{0.00000000013, 0.95208862336, 25241.82030682300},
	{0.00000000009, 2.58296270636, 130593.29451835579},
	{0.00000000009, 1.93570258198, 26513.81191808820},
	{0.00000000009, 3.72792244923, 25661.99436506020},
	{0.00000000013, 0.90383542596, 26014.60601571519},
	{0.00000000013, 4.75978960525, 26161.20026743319},
	{0.00000000010, 3.06250530365, 24712.12934172840},
	{0.00000000010, 2.43967897596, 104991.50985261079},
	{0.00000000010, 1.24342292300, 52061.40717623499},
	{0.00000000011, 5.57723740117, 183674.70392120858},
	{0.00000000009, 5.98881741458, 4371.87636677420},
	{0.00000000010, 5.16716938460, 23384.28698689860},
	{0.00000000009, 2.37191444133, 80174.90890793978},
	{0.00000000012, 3.47156983874, 52396.21892558720},
	{0.00000000013, 5.95714865174, 1073.60902419080},
	{0.00000000009, 3.96944968919, 103189.13786188899},
	{0.00000000009, 0.21796861386, 156547.08861034496},
	{0.00000000009, 2.34791148855, 130285.73689738619},
	{0.00000000009, 3.61118357787, 104984.39630560997},
	{0.00000000011, 3.38048420918, 19367.18916223280},
	{0.00000000009, 2.34685033934, 24609.03656750980},
	{0.00000000009, 5.69493908628, 76152.05911134499},
	{0.00000000009, 0.74268878384, 76255.15188556358},
	{0.00000000009, 4.41648492428, 31281.27020037200},
	{0.00000000012, 5.37243378655, 1699.27921650320},
	{0.00000000009, 2.41712554824, 51130.65144696079},
	{0.00000000009, 3.64428252561, 158746.17595363196},
	{0.00000000009, 1.96969875107, 52797.55008398759},
	{0.00000000009, 5.38585404056, 24844.41553989579},
	{0.00000000009, 0.27777099065, 27331.39074325260},
	{0.00000000010, 1.25786678282, 230239.17477710896},
	{0.00000000009, 4.03973091884, 156314.11975400719},
	{0.00000000010, 1.22710162921, 4022.26253196420},
	{0.00000000008, 3.74557002417, 91805.13062721379},
	{0.00000000009, 5.89077044915, 23866.04650697719},
	{0.00000000009, 0.95857873027, 114.43928868521},
	{0.00000000008, 2.65669489808, 38634.38508065720},
	{0.00000000011, 5.69314298563, 46046.50924364180},
	{0.00000000009, 0.74288994112, 52190.03337714999},
	{0.00000000011, 2.58755823478, 2538.24850425360},
	{0.00000000010, 3.10787144925, 391318.54712361297},
	{0.00000000009, 0.81265678038, 101703.15774082378},
	{0.00000000010, 0.76588647880, 54060.70744656579},
	{0.00000000009, 2.54367312949, 1685.05212250160},
	{0.00000000010, 3.69315427501, 2168.76048228260},
	{0.00000000009, 2.36652271316, 1485.29070670320},
	{0.00000000008, 2.14298858852, 209658.82487420218},
	{0.00000000009, 3.83602212713, 22595.33157470459},
	{0.00000000008, 2.74799294290, 2324.94940881560},
	{0.00000000008, 3.42854022505, 117893.03376878797},
	{0.00000000009, 0.89908538700, 52171.87412988529},
	{0.00000000008, 2.16824028856, 1574.84580128220},
	{0.00000000008, 0.66150337713, 51876.67988887919},
	{0.00000000010, 3.52894049374, 2751.54759969160},
	{0.00000000011, 4.78735190834, 28096.46068073319},
	{0.00000000008, 2.16844090943, 128106.31931499895},
	{0.00000000008, 0.74099606624, 77956.15180375299},
	{0.00000000008, 2.46215429910, 52400.15107885030},
	{0.00000000008, 2.46081725742, 10681.25053656540},
	{0.00000000008, 4.46257369959, 54824.26110862140},
	{0.00000000010, 3.07618265192, 240452.46032331996},
	{0.00000000008, 0.55712719908, 77741.13200662879},
	{0.00000000008, 0.42508106268, 42790.96527507320},
	{0.00000000008, 4.70625369395, 52489.99246301800},
	{0.00000000008, 3.86744165099, 156520.30530244438},
	{0.00000000007, 5.42400420261, 26933.98597632540},
	{0.00000000007, 6.06395790305, 52206.13314415280},
	{0.00000000008, 2.15800762997, 17098.43543614181},
	{0.00000000007, 4.72158791300, 50290.90511973100},
	{0.00000000010, 4.49694993347, 22065.64060961000},
	{0.00000000008, 2.65028306976, 51112.49219969609},
	{0.00000000009, 2.14235988572, 104454.70534051539},
	{0.00000000010, 3.27818898040, 440.82528487760},
	{0.00000000008, 5.30486076185, 3308.46589538040},
	{0.00000000007, 1.10080961200, 27360.58416720139},
	{0.00000000008, 0.11827657719, 187167.27548807819},
	{0.00000000009, 4.39445007595, 156507.74908854539},
	{0.00000000007, 0.74218080416, 51086.09749195479},
	{0.00000000008, 0.44382848778, 430.53034413910},
	{0.00000000008, 5.53615944362, 149288.74325784518},
	{0.00000000007, 3.70441477670, 233681.74972207438},
	{0.00000000007, 2.34002720858, 104248.51979207818},
	{0.00000000008, 5.03600399329, 77314.53381575279},
	{0.00000000007, 1.59729628741, 29396.36903695460},
	{0.00000000007, 4.06632874380, 22779.43724619380},
	{0.00000000007, 5.95614295602, 26290.15653674829},
	{0.00000000007, 5.99066738237, 25885.64974640009},
	{0.00000000009, 1.08053818223, 49.99662190420},
	{0.00000000007, 3.03792135842, 156740.71794488319},
	{0.00000000010, 3.37701481763, 2703.61615467560},
	{0.00000000009, 1.51395746159, 32132.13172294960},
	{0.00000000008, 4.55619991306, 78571.26704569219},
	{0.00000000007, 3.14378763001, 52663.44103440259},
	{0.00000000008, 4.91272317043, 102872.74599223239},
	{0.00000000007, 4.34382102751, 917.93028598180},
	{0.00000000007, 0.43580348099, 52073.84376488279},
	{0.00000000007, 3.67619371722, 149846.19399604558},
	{0.00000000007, 4.30856641724, 77417.62658997139},
	{0.00000000009, 2.22375687747, 90989.16285949759},
	{0.00000000007, 0.27683273956, 81591.84508100279},
	{0.00000000009, 1.15427906487, 56259.79478985279},
	{0.00000000009, 2.88360599168, 18073.70493865020},
	{0.00000000008, 2.28353993312, 32808.61712091560},
	{0.00000000008, 1.79224996176, 207114.15223730978},
	{0.00000000008, 0.61620182924, 48997.66049258080},
	{0.00000000008, 1.62443400895, 579.68758699880},
	{0.00000000007, 2.91658615206, 23267.07199744800},
	{0.00000000007, 2.74703887915, 28908.73428570040},
	{0.00000000007, 5.70115634056, 52145.47942214399},
	{0.00000000008, 4.37383732921, 103395.32341032618},
	{0.00000000007, 1.57841023127, 208276.62694171758},
	{0.00000000007, 1.00187511506, 8989.46770543239},
	{0.00000000007, 1.08260637181, 63786.35824152260},
	{0.00000000006, 0.95564679710, 53132.09543911899},
	{0.00000000007, 2.64514514998, 127098.90328117118},
	{0.00000000008, 2.96149409416, 103814.80805420138},
	{0.00000000006, 5.07797134858, 27573.88326263939},
	{0.00000000007, 5.91191228675, 102975.83876645098},
	{0.00000000008, 2.98617051725, 102018.41617342478},
	{0.00000000007, 1.96863702347, 45290.65639321759},
	{0.00000000006, 3.83307059240, 28774.62523611540},
	{0.00000000006, 1.83055443881, 23401.18104703300},
	{0.00000000006, 1.38930109810, 80462.79676800959},
	{0.00000000006, 0.67582514582, 106262.81204951399},
	{0.00000000008, 1.96535036231, 51257.87599716660},
	{0.00000000006, 3.61870647781, 23704.71012679799},
	{0.00000000006, 2.04491855340, 28471.09615635040},
	{0.00000000007, 1.61837202878, 53311.48315504160},
	{0.00000000007, 5.53291690668, 1802.37199072180},
	{0.00000000007, 5.32851714437, 79994.83177765518},
	{0.00000000009, 1.73174499580, 2014.98167179780},
	{0.00000000007, 5.04612545544, 52277.76880141400},
	{0.00000000006, 6.06855779639, 53438.96364572659},
	{0.00000000007, 1.80593240016, 29580.47470844380},
	{0.00000000007, 3.67914527744, 27388.72995977919},
	{0.00000000007, 1.98447975377, 24787.07632336920},
	{0.00000000006, 3.77150246945, 106470.37642667518},
	{0.00000000006, 6.11601315825, 191.44826611160},
	{0.00000000007, 2.88869753965, 104127.26777059489},
	{0.00000000006, 2.29442353801, 1135.67687189320},
	{0.00000000007, 0.34091991598, 27623.87988454360},
	{0.00000000007, 5.32270511523, 24551.92639860479},
	{0.00000000008, 0.77567524248, 51861.62010327879},
	{0.00000000007, 4.55467358235, 107679.74822257696},
	{0.00000000008, 3.58552572007, 51554.06248230919},
	{0.00000000007, 2.84651949085, 52213.93931878620},
	{0.00000000008, 1.66020848442, 4083.98850670440},
	{0.00000000007, 5.58797516267, 25572.43927048119},
	{0.00000000007, 0.07564986854, 26603.36701266720},
	{0.00000000007, 5.38412095716, 415.55249061210},
	{0.00000000006, 1.24514352941, 2686.72209454120},
	{0.00000000008, 1.12257158980, 54190.78795494619},
	{0.00000000007, 4.30357149579, 48091.81777644400},
	{0.00000000006, 3.84286985257, 78043.29678228378},
	{0.00000000007, 4.29733971410, 2974.60995461100},
	{0.00000000006, 1.70009289223, 53661.09698985160},
	{0.00000000006, 0.21405293391, 104426.39416486409},
	{0.00000000006, 5.31095660951, 26.29831979980},
	{0.00000000006, 0.26081525757, 27883.16158529519},
	{0.00000000006, 3.09307209285, 156523.53751408719},
	{0.00000000006, 1.52479776631, 225.82926841020},
	{0.00000000008, 0.22164311055, 120417.67842777158},
	{0.00000000008, 5.86283230643, 51120.35650622229},
	{0.00000000007, 1.41502656935, 1884.90116341740},
	{0.00000000006, 4.68109524986, 149756.70824819959},
	{0.00000000008, 3.80478888311, 53258.88651544199},
	{0.00000000006, 5.07032980124, 130005.80396999417},
	{0.00000000007, 1.36856874001, 162810.49469943657},
	{0.00000000006, 2.21234472657, 27441.65188659100},
	{0.00000000006, 3.45128030464, 24734.15439655740},
	{0.00000000008, 3.49263998453, 422.66603761290},
	{0.00000000006, 5.52344781030, 155460.92337225519},
	{0.00000000006, 4.38638116269, 50160.82461135059},
	{0.00000000006, 5.35041562795, 78262.22495201428},
	{0.00000000006, 3.67662399741, 222.86032299360},
	{0.00000000006, 3.76321444127, 78225.57638908479},
	{0.00000000007, 1.16300487672, 30110.16567353840},
	{0.00000000006, 4.67707783228, 78597.56536549199},
	{0.00000000006, 2.87078629973, 95.97922721780},
	{0.00000000006, 5.36576953243, 76468.45098100159},
	{0.00000000006, 0.44311785186, 76777.72930365738},
	{0.00000000005, 3.48830916279, 58220.03486452380},
	{0.00000000006, 5.17863319897, 171292.65789271498},
	{0.00000000006, 4.20102757189, 29864.33402730900},
	{0.00000000006, 1.46259745932, 22311.47225583940},
	{0.00000000006, 4.38694980798, 76991.02839909539},
	{0.00000000005, 0.68949263605, 27410.58078910560},
	{0.00000000005, 4.97413239516, 24765.22549404280},
	{0.00000000006, 1.69366740663, 51092.72605085480},
	{0.00000000007, 2.78056963159, 34102.10134449819},
	{0.00000000007, 1.77574194617, 151199.94274106238},
	{0.00000000006, 5.55737889155, 31903.01400121119},
	{0.00000000006, 0.10624613966, 20272.79228193720},
	{0.00000000006, 2.86083846875, 104874.18998439058},
	{0.00000000005, 2.16795888097, 155475.15046625677},
	{0.00000000005, 6.14116962879, 128747.35003836859},
	{0.00000000005, 5.05100044910, 26500.27423844859},
	{0.00000000005, 0.61262458211, 25675.53204469980},
	{0.00000000006, 2.15084946795, 3492.57156686960},
	{0.00000000007, 2.65435909947, 13675.53025207620},
	{0.00000000005, 5.69197138572, 53551.58008299420},
	{0.00000000006, 1.72837394563, 76137.83201734339},
	{0.00000000005, 0.34624525970, 60170.33472517260},
	{0.00000000005, 1.93171690707, 5193.36705879780},
	{0.00000000005, 6.05655614068, 27353.47062020059},
	{0.00000000007, 4.37521324748, 9745.32055585660},
	{0.00000000005, 2.02517578450, 628.85158605010},
	{0.00000000007, 4.81829524389, 169093.57054942798},
	{0.00000000005, 0.20090403597, 9123.57675501740},
	{0.00000000006, 4.84978213740, 25462.23294926180},
	{0.00000000006, 0.81384289381, 26713.57333388659},
	{0.00000000007, 2.97463476206, 2641.34127847220},
	{0.00000000007, 4.23604941684, 1577.34354244780},
	{0.00000000005, 2.70097411082, 52812.80255517260},
	{0.00000000006, 1.52077024889, 156531.30018480319},
	{0.00000000005, 1.19912051467, 26235.98186600050},
	{0.00000000005, 5.77803835359, 71378.55953479178},
	{0.00000000007, 4.47073325724, 1083.08023229360},
	{0.00000000005, 4.73755202618, 26034.80698925980},
	{0.00000000005, 0.92607300503, 26140.99929388859},
	{0.00000000006, 3.87149168929, 28213.78054895339},
	{0.00000000005, 0.44047672764, 1243.48760167840},
	{0.00000000006, 4.83520525387, 437.64389113990},
	{0.00000000005, 4.36934946235, 104035.22069664019},
	{0.00000000005, 3.74810256898, 52098.05573916449},
	{0.00000000005, 2.74132817040, 65538.25598994759},
	{0.00000000005, 4.88320109198, 104301.61594439259},
	{0.00000000005, 0.04883294047, 78697.42116259939},
	{0.00000000006, 5.21822734458, 621.74380083920},
	{0.00000000005, 0.11277607968, 104401.60918820098},
	{0.00000000005, 0.32519606443, 53654.67285721279},
	{0.00000000005, 6.14333001424, 51006.21803173979},
	{0.00000000006, 4.56143654817, 104241.40624507738},
	{0.00000000005, 0.65495415751, 104668.00443595338},
	{0.00000000004, 6.26437463075, 76532.58707178998},
	{0.00000000005, 5.16993727796, 23389.45169419700},
	{0.00000000005, 0.49368775325, 28786.35458895140},
	{0.00000000004, 1.13517998278, 31775.53351052620},
	{0.00000000004, 4.52844504843, 20400.27277262220},
	{0.00000000005, 4.46403422032, 112545.88789950538},
	{0.00000000005, 6.09620933760, 78265.19389743089},
	{0.00000000006, 2.35286352659, 51688.17153189420},
	{0.00000000005, 5.08976870339, 25863.55834587229},
	{0.00000000004, 2.73813240429, 35211.47989659159},
	{0.00000000004, 2.92549262692, 16964.32638655680},
	{0.00000000005, 3.82552908418, 487.63475125420},
	{0.00000000004, 1.08485860111, 27039.97976483379},
	{0.00000000004, 4.57876643010, 25135.82651831460},
	{0.00000000005, 4.59959229753, 25778.62481891839},
	{0.00000000005, 1.06403273368, 26397.18146422999},
	{0.00000000005, 2.09930628583, 189853.99758261938},
	{0.00000000005, 4.02283478855, 78373.91574594198},
	{0.00000000004, 1.04243464310, 19202.75325164339},
	{0.00000000004, 0.75081825828, 263097.78851992876},
	{0.00000000004, 1.67917095725, 33480.35754365900},
	{0.00000000004, 3.98445407396, 18695.44873948940},
	{0.00000000005, 0.60115238757, 703.63318461740},
	{0.00000000004, 5.10698405361, 156377.85565231058},
	{0.00000000005, 2.32798791782, 2015.67108615980},
	{0.00000000004, 0.61980953649, 76998.14194609619},
	{0.00000000004, 3.19010933277, 1368.66025284500},
	{0.00000000004, 0.12965867040, 129586.31932611899},
	{0.00000000004, 1.49194500309, 45424.76544280259},
	{0.00000000004, 5.39873919994, 28928.40404660019},
	{0.00000000004, 0.26488583127, 23247.40223654820},
	{0.00000000004, 2.35188051852, 20452.86941222180},
	{0.00000000004, 3.31174451269, 31722.93687092660},
	{0.00000000004, 2.30331784549, 26238.95081141709},
	{0.00000000004, 2.77836300783, 52355.88341343300},
	{0.00000000004, 3.46342382133, 51538.81001112419},
	{0.00000000004, 3.69944590805, 32278.92615582100},
	{0.00000000004, 1.96417912316, 19896.88012732740},
	{0.00000000004, 6.03499106435, 23976.25282819660},
	{0.00000000004, 1.70188026990, 78905.12298646157},
	{0.00000000004, 1.66509444770, 87648.55043279778},
	{0.00000000004, 4.41949123763, 223180.57631579356},
	{0.00000000004, 3.00071021966, 52336.21365253320},
	{0.00000000004, 5.68676014339, 50912.64892057020},
	{0.00000000004, 1.96557859005, 199599.31813847595},
	{0.00000000005, 5.12444942434, 26090.87208699080},
	{0.00000000005, 0.53917560687, 26084.93419615759},
	{0.00000000004, 3.34711834324, 25923.46723098479},
	{0.00000000004, 2.31650668797, 26252.33905216361},
	{0.00000000005, 1.46787228776, 50951.98844236979},
	{0.00000000005, 0.84223070790, 13705.85711308060},
	{0.00000000005, 4.82139432331, 38469.94917006779},
	{0.00000000005, 4.69896171289, 18227.48374913500},
	{0.00000000005, 0.96466331832, 33948.32253401340},
	{0.00000000004, 4.35820339713, 74935.57376844239},
	{0.00000000004, 0.37589110708, 26130.78621647760},
	{0.00000000004, 5.28773392413, 26045.02006667080},
	{0.00000000005, 6.00635216618, 51102.19725895759},
	{0.00000000004, 1.48479477953, 104771.09721017198},
	{0.00000000004, 0.75542038962, 61165.27398858079},
	{0.00000000004, 1.07035769632, 24079.34560241519},
	{0.00000000004, 3.34025458568, 18319.53658487960},
	{0.00000000004, 2.32337044553, 33856.26969826880},
	{0.00000000005, 3.80744702100, 51315.49635439559},
	{0.00000000004, 3.26438690958, 159969.99379441059},
	{0.00000000005, 5.53495278972, 24822.33566294780},
	{0.00000000005, 5.02554220823, 107692.22499299659},
	{0.00000000004, 3.44129218830, 73891.83305794839},
	{0.00000000005, 3.05069290377, 49637.55777889479},
	{0.00000000005, 3.22665320828, 35077.37084700659},
	{0.00000000005, 0.63333030208, 77929.85348395319},
	{0.00000000004, 3.70617022011, 106684.80895916879},
	{0.00000000004, 2.87321007380, 25248.93385382380},
	{0.00000000004, 2.79041495741, 26926.87242932459},
	{0.00000000005, 1.54666149626, 130020.03106399579},
	{0.00000000004, 1.73965439817, 42430.48572729180},
	{0.00000000004, 3.25018015096, 130907.48069822539},
	{0.00000000004, 2.06353106693, 76352.50994150538},
	{0.00000000004, 3.82039111865, 50690.51557644519},
	{0.00000000004, 0.40278258619, 27047.02600153180},
	{0.00000000004, 5.26084244502, 25128.78028161659},
	{0.00000000003, 5.68912682186, 76094.94894243999},
	{0.00000000003, 4.44502926835, 25980.59783464459},
	{0.00000000003, 1.21859576286, 26195.20844850380},
	{0.00000000004, 4.63561794007, 52164.76058288449},
	{0.00000000004, 6.13459757306, 118828.96374949679},
	{0.00000000005, 0.15089449096, 45455.09230380700},
	{0.00000000004, 2.55610884099, 215941.90072419358},
	{0.00000000004, 5.41986884632, 25991.92391435639},
	{0.00000000004, 0.24375618489, 26183.88236879199},
	{0.00000000004, 4.35391878884, 48153.54375118419},
	{0.00000000004, 0.44819649652, 16496.36139620240},
	{0.00000000004, 5.21542853469, 35679.44488694599},
	{0.00000000004, 4.59443055400, 8044.52506392840},
	{0.00000000005, 1.35623327800, 10059.50673572620},
	{0.00000000004, 1.91641090854, 49424.25868345679},
	{0.00000000004, 3.88762025023, 51040.12941125520},
	{0.00000000004, 2.46145540531, 128843.32926558638},
	{0.00000000004, 5.39518200455, 23336.35554188260},
	{0.00000000003, 3.16690823789, 202.25339517410},
	{0.00000000004, 2.48121871677, 52015.39891376359},
	{0.00000000003, 1.35017943249, 23113.29318696320},
	{0.00000000003, 4.31344559872, 29062.51309618520},
	{0.00000000003, 0.13992300676, 25794.49235719700},
	{0.00000000003, 5.52370202445, 26381.31392595140},
	{0.00000000004, 1.99797546531, 251775.12442162436},
	{0.00000000004, 0.78738841944, 23543.23050468179},
	{0.00000000004, 4.87623661177, 28632.57577846660},
	{0.00000000003, 2.34677335126, 26279.35140768579},
	{0.00000000003, 3.31685167995, 25896.45487546260},
	{0.00000000004, 4.17686572959, 25998.41739372820},
	{0.00000000004, 1.48675930162, 26177.38888942019},
	{0.00000000003, 2.83722079462, 49850.85687433279},
	{0.00000000004, 6.14972721531, 32217.20018108080},
	{0.00000000004, 0.04334468913, 14235.54807817520},
	{0.00000000004, 5.62028034208, 37940.25820497319},
	{0.00000000003, 3.19751497889, 41494.55574658299},
	{0.00000000004, 3.72289178215, 261988.40996783535},
	{0.00000000004, 3.03839569378, 168959.46149984296},
	{0.00000000004, 2.70356592860, 51995.72915286380},
	{0.00000000003, 0.89067609209, 154308.66174525839},
	{0.00000000003, 5.65136861530, 24292.64469785319},
	{0.00000000003, 0.19486754591, 78397.81847430758},
	{0.00000000003, 3.22218438408, 202420.14928260217},
	{0.00000000004, 1.13844882216, 179172.74704605396},
	{0.00000000003, 4.85336780642, 79116.90580647459},
	{0.00000000003, 2.26852923431, 148532.89040742096},
	{0.00000000004, 2.92925215887, 24182.43837663380},
	{0.00000000003, 1.82348628585, 26114.20146137400},
	{0.00000000003, 3.84013874536, 26061.60482177439},
	{0.00000000004, 1.84151604889, 23962.02573419499},
	{0.00000000003, 5.32480281715, 47803.92991637420},
	{0.00000000003, 3.67756235555, 99979.73619952259},
	{0.00000000003, 3.11077916313, 27993.36790651460},
	{0.00000000004, 3.05439250241, 156954.01704032118},
	{0.00000000004, 5.73212182199, 192828.60753723037},
	{0.00000000003, 3.93077791188, 130446.14426677099},
	{0.00000000003, 0.29895063711, 25344.91308104160},
	{0.00000000003, 3.65489060162, 25764.39772491679},
	{0.00000000003, 1.43670342990, 23420.85080793279},
	{0.00000000003, 4.22692160131, 28754.95547521560},
	{0.00000000003, 3.29097711242, 22909.75735100660},
	{0.00000000004, 0.29131403040, 50476.52706664519},
	{0.00000000003, 4.88894436553, 133767.65136415116},
	{0.00000000003, 4.21457884017, 52072.02409456780},
	{0.00000000003, 3.61792324623, 77622.29586298359},
	{0.00000000003, 0.47995189315, 52016.50454835620},
	{0.00000000003, 2.65810233456, 273311.07406613971},
	{0.00000000004, 3.16714765573, 25014.29411738339},
	{0.00000000003, 1.68763185836, 25970.58327335399},
	{0.00000000003, 3.97599317285, 26205.22300979439},
	{0.00000000003, 3.08446305860, 54879.42243782400},
	{0.00000000004, 5.27937253398, 27511.46787353720},
	{0.00000000004, 0.38425249723, 24664.33840961120},
	{0.00000000003, 2.30032754148, 33917.99567300899},
	{0.00000000003, 3.36329748973, 18257.81061013940},
	{0.00000000004, 3.76381458115, 61921.12683900499},
	{0.00000000003, 2.88335625086, 222224.97657418498},
	{0.00000000003, 1.15891911019, 78249.48233072099},
	{0.00000000003, 5.96024730236, 123554.36581794015},
	{0.00000000004, 3.05981714265, 158116.49174472898},
	{0.00000000003, 1.88338582885, 26387.02953584340},
	{0.00000000003, 5.82360005059, 25440.89230825939},
	{0.00000000003, 5.04796024742, 26983.98259822960},
	{0.00000000003, 0.61566478379, 25191.82368491880},
	{0.00000000003, 0.74835060715, 79487.52726550119},
	{0.00000000003, 1.69642678501, 210921.98223678036},
	{0.00000000003, 0.50518757578, 1263.15736257819},
	{0.00000000003, 3.11959949863, 50490.75416064679},
	{0.00000000003, 2.27314510672, 73.29712585900},
	{0.00000000003, 4.69667538764, 55484.27217852879},
	{0.00000000003, 1.39779381233, 1382.88734684660},
	{0.00000000003, 3.55178169020, 158438.61833266239},
	{0.00000000003, 1.10945585352, 24601.92302050899},
	{0.00000000003, 0.76074196322, 242985.40360737636},
	{0.00000000003, 0.70803012800, 1471.75302706360},
	{0.00000000003, 4.72386292146, 146505.58156934578},
	{0.00000000003, 5.04493378788, 24510.55959912640},
	{0.00000000003, 0.61869124333, 27665.24668402200},
	{0.00000000004, 1.05779479813, 25810.86814783279},
	{0.00000000004, 4.60583023308, 26364.93813531560},
	{0.00000000003, 4.81672439155, 229463.65216578495},
	{0.00000000003, 3.49736618564, 50600.96048186620},
	{0.00000000003, 1.03986340949, 185943.45764729957},
	{0.00000000003, 0.69061740155, 15406.65260500879},
	{0.00000000003, 0.29778988754, 179966.86716554638},
	{0.00000000003, 1.31624723631, 26202.30224848760},
	{0.00000000003, 4.92485338063, 24815.22211594700},
	{0.00000000003, 0.60305414741, 963.40270297140},
	{0.00000000003, 1.94033818226, 203375.74902421077},
	{0.00000000003, 3.48095850628, 2352.86615377180},
	{0.00000000003, 3.83630727282, 289185.69166150296},
	{0.00000000003, 1.42673173544, 29000.78712144500},
	{0.00000000003, 4.23689329577, 23175.01916170339},
	{0.00000000003, 2.74878005228, 2820.83114412620},
	{0.00000000003, 1.35908128792, 49201.19632853740},
	{0.00000000002, 6.25037565978, 5019.91848741320},
	{0.00000000003, 2.38673232157, 51734.98099827079},
	{0.00000000003, 2.84532132702, 25914.45457018961},
	{0.00000000003, 2.81830370419, 26261.35171295879},
	{0.00000000003, 5.82072785115, 143164.96914264598},
	{0.00000000002, 2.01367500779, 278972.40611529196},
	{0.00000000003, 5.22041687007, 51745.27593900929},
	{0.00000000002, 3.03566163825, 25554.28002321649},
	{0.00000000002, 2.62796339296, 26621.52625993189},
	{0.00000000003, 5.20753478644, 25530.45240337380},
	{0.00000000003, 0.45609024477, 26645.35387977460},
	{0.00000000003, 5.03565808597, 25626.56671011980},
	{0.00000000003, 0.62796694524, 26549.23957302859},
	{0.00000000003, 5.34361577728, 20956.26205751660},
	{0.00000000003, 0.32000925393, 31219.54422563180},
	{0.00000000003, 4.44133523435, 283524.35961235073},
	{0.00000000002, 4.58931827360, 21202.09370374600},
	{0.00000000002, 1.07430675761, 30973.71257940240},
	{0.00000000003, 2.48443590939, 76358.24465978218},
	{0.00000000003, 1.87893732728, 543.91805909620},
	{0.00000000002, 1.40938866249, 257436.45647077652},
	{0.00000000003, 0.83289676584, 25361.42112170400},
	{0.00000000003, 4.83072826537, 26814.38516144439},
	{0.00000000002, 1.24497717708, 57369.17334194619},
	{0.00000000003, 5.41525530380, 52186.85198341230},
	{0.00000000002, 2.63620968801, 31127.49138988719},
	{0.00000000002, 3.02741534320, 21048.31489326120},
	{0.00000000002, 0.06083055027, 152155.54248267098},
	{0.00000000002, 0.16837305460, 27133.05797776179},
	{0.00000000002, 3.23690883920, 267649.74201698754},
	{0.00000000003, 4.73128149211, 21650.38893320061},
	{0.00000000003, 0.93234353910, 30525.41734994779},
	{0.00000000003, 6.06730146110, 128857.55635958798},
	{0.00000000002, 2.18169836096, 29266.04893214180},
	{0.00000000002, 0.71621395615, 5635.03372935240},
	{0.00000000002, 2.11602382972, 138319.60486120995},
	{0.00000000003, 4.34402660372, 53338.28098755619},
	{0.00000000002, 3.25230557265, 102129.75593169978},
	{0.00000000002, 4.82283999680, 5687.63036895200},
	{0.00000000003, 3.82055258756, 21716.02677480000},
	{0.00000000002, 0.63318713248, 54862.52837768960},
	{0.00000000003, 3.39676430082, 24971.41104247999},
	{0.00000000003, 2.26686073039, 27204.39524066840},
	{0.00000000002, 3.67279256888, 143980.93691036216},
	{0.00000000002, 2.27453733075, 220025.88923089796},
	{0.00000000002, 0.03187793840, 67608.75720795698},
	{0.00000000002, 5.01817813007, 26165.65368555809},
	{0.00000000002, 0.39913665768, 241561.83887541336},
	{0.00000000002, 0.36962686584, 236702.32775738496},
	{0.00000000003, 3.12809886294, 206584.46127221518},
	{0.00000000003, 2.97200687644, 189386.03259226495},
	{0.00000000002, 5.24239507145, 180496.55813064099},
	{0.00000000003, 2.68824003168, 27161.51216576500},
	{0.00000000003, 0.86347662918, 49976.71893986139},
	{0.00000000002, 6.12457483767, 27151.21722502649},
	{0.00000000003, 1.61229350276, 29050.78374334920},
	{0.00000000003, 4.05133152845, 23125.02253979920},
	{0.00000000002, 3.42071639800, 32973.05303150501},
	{0.00000000002, 1.57427839936, 110395.84114767218},
	{0.00000000002, 0.64120353129, 78484.12206716138},
	{0.00000000002, 0.13220595262, 50373.43429242659},
	{0.00000000003, 2.58347515249, 246113.79237247216},
	{0.00000000002, 0.46042924320, 156534.53239644598},
	{0.00000000003, 6.01468501613, 7768.36655669460},
	{0.00000000003, 4.30654322236, 78115.63070029629},
	{0.00000000002, 0.28012264229, 51760.25379253629},
	{0.00000000003, 3.05134920767, 5815.11085963699},
	{0.00000000003, 0.35333837497, 117.31986822020},
	{0.00000000002, 5.12603604161, 30486.07782814820},
	{0.00000000002, 0.53758898960, 21689.72845500019},
	{0.00000000003, 3.31169456914, 78112.66175487968},
	{0.00000000002, 4.36572855791, 1898.35121793960},
	{0.00000000003, 0.43348211086, 134.10904958500},
	{0.00000000002, 5.21277275820, 235746.72801577636},
	{0.00000000002, 0.94406129311, 26024.16724327080},
	{0.00000000002, 4.71956373811, 26151.63903987760},
	{0.00000000003, 4.30724193035, 42116.29954742219},
	{0.00000000002, 4.14095681447, 216897.50046580215},
	{0.00000000003, 5.88207110188, 25949.38564470350},
	{0.00000000003, 6.06473923651, 26226.42063844490},
	{0.00000000002, 1.17081922558, 249268.47945736776},
	{0.00000000003, 2.07303362426, 65851.33653522459},
	{0.00000000003, 1.90326122005, 26375.79100164400},
	{0.00000000003, 3.76036381116, 25800.01528150440},
	{0.00000000002, 3.55776839826, 1593.00504854690},
	{0.00000000003, 3.79796015832, 23581.25817731760},
	{0.00000000003, 1.86566487289, 28594.54810583080},
	{0.00000000002, 3.33500745482, 4525.65517725900},
	{0.00000000002, 5.99627564723, 247223.17092456557},
	{0.00000000002, 0.05141204952, 97466.46267636596},
	{0.00000000002, 2.24548271996, 425.90877651400},
	{0.00000000002, 0.41829675041, 1279.79457262800},
	{0.00000000003, 4.22958660433, 26051.25457864469},
	{0.00000000003, 1.43403842688, 26124.55170450369},
	{0.00000000002, 5.48576882408, 52367.25454925999},
	{0.00000000002, 4.14056597313, 51949.97701473820},
	{0.00000000002, 2.55940503302, 28133.21167437640},
	{0.00000000002, 3.10421999819, 24042.59460877199},
	{0.00000000003, 2.17160326158, 51753.14024553549},
	{0.00000000003, 6.15199422925, 25632.99377504689},
	{0.00000000003, 5.79481610914, 26542.81250810149},
	{0.00000000002, 3.97512757833, 24999.29998497320},
	{0.00000000002, 1.68849745288, 27176.50629817519},
	{0.00000000002, 1.16910623519, 190495.41114435835},
	{0.00000000002, 5.12727920131, 4398.17468657401},
	{0.00000000002, 2.91202347140, 27143.35291850029},
	{0.00000000002, 3.03690554065, 25024.58905812189},
	{0.00000000002, 5.82171148629, 195047.36464141717},
	{0.00000000002, 2.34212792422, 2854.64037391020},
	{0.00000000002, 1.51917223670, 20618.01935853360},
	{0.00000000002, 4.14445279451, 31557.78692461479},
	{0.00000000002, 1.98831285254, 51952.94596015479},
	{0.00000000002, 6.21843289934, 41520.85406638280},
	{0.00000000002, 1.57183044674, 52249.10340900739},
	{0.00000000002, 3.38651380345, 126067.63934109679},
	{0.00000000002, 4.71436622522, 52202.10460294820},
	{0.00000000002, 5.83862446410, 4601.95011896300},
	{0.00000000002, 3.67162403222, 330.61896365820},
	{0.00000000002, 1.34218693696, 138633.79104107959},
	{0.00000000002, 4.92926606199, 231348.55332920236},
	{0.00000000002, 2.49109566786, 52822.81711646319},
	{0.00000000002, 3.63217289611, 1535.97674296940},
	{0.00000000002, 4.71304833568, 232457.93188129576},
	{0.00000000002, 0.79025165001, 24705.70520908959},
	{0.00000000002, 4.87337338120, 27470.10107405880},
	{0.00000000002, 1.33512594210, 2655.56837247380},
	{0.00000000002, 0.12163545664, 1603.29998928540},
	{0.00000000002, 5.71504799272, 30459.77950834840},
	{0.00000000002, 6.14999504197, 1353.74874501680},
	{0.00000000002, 4.19897532608, 32838.94398192000},
	{0.00000000002, 0.13374340654, 14297.27405291540},
	{0.00000000002, 5.52988162467, 37878.53223023300},
	{0.00000000002, 6.20542886765, 104501.17576343138},
	{0.00000000002, 2.15596610967, 2544.67263689240},
	{0.00000000002, 1.06395351693, 44131.28121921999},
	{0.00000000002, 2.13013210662, 77039.89158394396},
	{0.00000000002, 1.15844515063, 4578.25181685860},
	{0.00000000002, 3.63958668308, 51546.95469709829},
	{0.00000000002, 3.63738028447, 164407.50800278416},
	{0.00000000002, 5.42696145538, 7392.45440208480},
	{0.00000000002, 6.25775046727, 31107.82162898740},
	{0.00000000002, 5.68905987112, 21067.98465416099},
	{0.00000000002, 2.91756593205, 113455.51956041438},
	{0.00000000002, 1.98570847468, 27299.24421193320},
	{0.00000000002, 3.67791655653, 24876.56207121520},
	{0.00000000002, 5.74298703182, 105418.10804348679},
	{0.00000000002, 2.69099617398, 49534.46500467620},
	{0.00000000002, 1.80708255079, 24957.74919398840},
	{0.00000000002, 3.85654248042, 27218.05708916000},
	{0.00000000002, 3.11677200697, 27257.49139298280},
	{0.00000000002, 3.49399734860, 40738.70289615879},
	{0.00000000002, 0.21234042745, 309.27832265580},
	{0.00000000002, 2.33781787949, 1155.36115740700},
	{0.00000000002, 3.03248338331, 102239.96225291918},
	{0.00000000002, 1.65828575265, 197092.67317421938},
	{0.00000000002, 5.56610117919, 20235.12282631040},
	{0.00000000002, 0.09752385202, 31940.68345683799},
	{0.00000000002, 5.28799958774, 225687.22128005016},
	{0.00000000002, 0.34521072462, 1585.14074202070},
	{0.00000000002, 0.89847733804, 130432.88714897096},
	{0.00000000002, 5.35295047368, 79955.87509422498},
	{0.00000000002, 0.15743392494, 838.96928775040},
	{0.00000000002, 2.86349665303, 171960.36977425378},
	{0.00000000002, 0.82971507937, 51738.16239200849},
	{0.00000000002, 4.40886857181, 27953.13454409180},
	{0.00000000002, 1.25475645940, 24222.67173905660},
	{0.00000000002, 5.67142449888, 299398.97720771392},
	{0.00000000002, 0.02963994293, 28440.76929534600},
	{0.00000000002, 5.63398508828, 23735.03698780239},
	{0.00000000002, 4.94052786966, 26948.21307032700},
	{0.00000000002, 0.72309716155, 25227.59321282139},
	{0.00000000002, 4.51386522935, 164721.69418265378},
	{0.00000000002, 2.19543947073, 24918.31489016559},
	{0.00000000002, 2.12858110666, 25888.83114013780},
	{0.00000000002, 3.53504392455, 26286.97514301059},
	{0.00000000002, 5.05414655112, 4268.09417819360},
	{0.00000000002, 5.71672028658, 80432.46990700519},
	{0.00000000002, 2.91629438354, 13989.71643194580},
	{0.00000000002, 2.74733064767, 38186.08985120260},
	{0.00000000002, 2.55314053643, 124663.74437003357},
	{0.00000000002, 3.27370866937, 525.75881183150},
	{0.00000000002, 4.35111571758, 3776.43088573480},
	{0.00000000002, 2.93541110992, 2045.30853280220},
	{0.00000000002, 2.81103866959, 221135.26778299136},
	{0.00000000002, 0.79461762449, 76064.62208143558},
	{0.00000000002, 2.53232253566, 150751.64751160776},
	{0.00000000002, 1.47457311730, 30831.30490474460},
	{0.00000000002, 4.18905191392, 21344.50137840379},
	{0.00000000002, 2.92553614920, 105403.88094948517},
	{0.00000000002, 5.98978548406, 19336.86230122839},
	{0.00000000001, 3.52879720086, 66826.60603773296},
	{0.00000000001, 1.77634435436, 93696.66034953119},
	{0.00000000001, 0.57809610749, 24919.00430452760},
	{0.00000000001, 5.08552892372, 27256.80197862080},
	{0.00000000002, 6.08826344175, 7830.09253143480},
	{0.00000000001, 4.22613812778, 959.12285995760},
	{0.00000000002, 5.23844394745, 8482.16319327840},
	{0.00000000002, 0.42518108376, 43693.64308986999},
	{0.00000000002, 2.62167846998, 9591.54174537180},
	{0.00000000001, 4.92214692877, 52499.31169980579},
	{0.00000000001, 0.45067029057, 26010.15259759030},
	{0.00000000001, 1.49974892148, 190809.59732422797},
	{0.00000000002, 1.28849937541, 87253.17713015496},
	{0.00000000002, 5.49174220323, 21516.27988361560},
	{0.00000000002, 0.17188282798, 30659.52639953279},
	{0.00000000002, 4.10872174479, 2214.74308759620},
	{0.00000000001, 5.68799206535, 233202.05537888398},
	{0.00000000002, 0.33446329498, 28839.45074126579},
	{0.00000000002, 3.48052508137, 14650.79975458459},
	{0.00000000001, 4.64660194247, 184526.52147423658},
	{0.00000000002, 1.56059892812, 129971.55071751658},
	{0.00000000002, 5.50101176990, 102225.73515891758},
	{0.00000000001, 2.62468643294, 50807.14603030339},
	{0.00000000002, 1.90253736481, 307.55762096960},
	{0.00000000001, 0.09710299820, 5039.58824831300},
	{0.00000000002, 0.17683937064, 23549.65463732060},
	{0.00000000002, 5.06371993416, 51472.17309853099},
	{0, 0, 0}
};

struct vsop87_term mercury_x1[] = {
	{0.00318848034, 0.00000000000, 0.00000000000},
	{0.00105289019, 5.91600475006, 52175.80628314840},
	{0.00032316001, 2.68247273347, 78263.70942472259},
	{0.00011992889, 5.81575112963, 26087.90314157420},
	{0.00008783200, 5.73285747425, 104351.61256629678},
	{0.00002329042, 2.50023793407, 130439.51570787099},
	{0.00000614473, 5.55087602844, 156527.41884944518},
	{0.00000162192, 2.31836529248, 182615.32199101939},
	{0.00000069028, 2.91494938058, 24978.52458948080},
	{0.00000062918, 2.73196853262, 27197.28169366760},
	{0.00000042904, 5.36906063918, 208703.22513259358},
	{0.00000017519, 5.96830863185, 51066.42773105500},
	{0.00000013252, 5.78388474441, 53285.18483524180},
	{0.00000011874, 0.17869376191, 1109.37855209340},
	{0.00000012470, 1.40668283978, 1059.38193018920},
	{0.00000011372, 0.34951033396, 20426.57109242200},
	{0.00000011379, 2.13659786081, 234791.12827416777},
	{0.00000008364, 5.31326841022, 31749.23519072640},
	{0.00000006296, 5.47576447612, 4551.95349705880},
	{0.00000004830, 0.25724123783, 21535.94964451540},
	{0.00000004843, 2.73719284227, 77154.33087262919},
	{0.00000004247, 3.39407863893, 46514.47423399620},
	{0.00000004379, 5.09788247126, 25132.30339996560},
	{0.00000003919, 2.37947659591, 1589.07289528380},
	{0.00000004008, 4.41606139947, 27147.28507176339},
	{0.00000003755, 4.17884091449, 14765.23904326980},
	{0.00000004311, 4.26366834787, 51116.42435295920},
	{0.00000003833, 0.53521442894, 27043.50288318280},
	{0.00000003147, 1.09831959010, 26617.59410666880},
	{0.00000003134, 4.68201320654, 25558.21217647960},
	{0.00000003026, 5.18732430310, 260879.03141574195},
	{0.00000002892, 5.42640574300, 26107.57290247399},
	{0.00000002888, 0.22490912553, 26068.23338067440},
	{0.00000002372, 2.07173805606, 26084.02180621620},
	{0.00000002367, 3.57959596454, 26091.78447693220},
	{0.00000002060, 1.47444774290, 37410.56723987860},
	{0.00000001995, 5.43702405397, 30639.85663863300},
	{0.00000001993, 2.49283396541, 79373.08797681599},
	{0.00000001882, 0.21679831472, 47623.85278608960},
	{0.00000001581, 1.69266319262, 9103.90699411760},
	{0.00000001582, 4.31392718266, 955.59974160860},
	{0.00000001500, 0.43230658391, 19317.19254032860},
	{0.00000001393, 0.16139897514, 72602.37737557039},
	{0.00000001444, 4.90545517336, 529.69096509460},
	{0.00000001356, 3.28177198592, 50586.73338786459},
	{0.00000001486, 3.77636138698, 12566.15169998280},
	{0.00000001421, 2.04410197951, 426.59819087600},
	{0.00000001205, 3.93561468963, 52705.49724824299},
	{0.00000001291, 2.48193614053, 26095.01668857500},
	{0.00000001468, 2.98912712521, 23869.14603738740},
	{0.00000001247, 3.22538051848, 26080.78959457339},
	{0.00000001170, 5.49212997481, 3442.57494496540},
	{0.00000001101, 1.21730591912, 53235.18821333759},
	{0.00000001372, 5.78877124476, 103242.23401420339},
	{0.00000001238, 1.82183266298, 51220.20654153979},
	{0.00000001188, 2.63716562694, 28306.66024576099},
	{0.00000000966, 3.56558363028, 53131.40602475700},
	{0.00000000857, 0.94331413205, 40853.14218484400},
	{0.00000000853, 5.33085598917, 27676.97603685800},
	{0.00000000828, 1.04707260283, 25874.60404613620},
	{0.00000000923, 0.74286443513, 639.89728631400},
	{0.00000000891, 5.15325597213, 32858.61374281979},
	{0.00000000806, 1.95470061860, 286966.93455731616},
	{0.00000000797, 4.63253542288, 26301.20223701220},
	{0.00000000867, 2.13196527993, 83925.04147387479},
	{0.00000000981, 0.13945164140, 22645.32819660879},
	{0.00000000732, 2.19417873413, 56727.75978020720},
	{0.00000000808, 4.76289394654, 36301.18868778519},
	{0.00000000720, 1.49820361938, 18849.22754997420},
	{0.00000000703, 2.68691048153, 6770.71060124560},
	{0.00000000772, 5.23111667516, 11322.66409830440},
	{0.00000000865, 6.19400537490, 7.11354700080},
	{0.00000000765, 1.88382728885, 39609.65458316560},
	{0.00000000662, 3.27821203278, 52156.13652224860},
	{0.00000000673, 4.81376442012, 1052.26838318840},
	{0.00000000619, 3.92327916834, 43071.89928903080},
	{0.00000000666, 0.85409428955, 15874.61759536320},
	{0.00000000607, 2.02898715788, 5661.33204915220},
	{0.00000000806, 4.33567606005, 1066.49547719000},
	{0.00000000627, 0.70425946008, 51646.11531805379},
	{0.00000000554, 3.01415103037, 2118.76386037840},
	{0.00000000533, 0.35442356295, 52179.68761850640},
	{0.00000000621, 1.43632380898, 25028.52121138500},
	{0.00000000651, 5.48424947861, 29530.47808653960},
	{0.00000000525, 4.93316232438, 26514.50133245020},
	{0.00000000500, 0.52252923934, 38654.05484155699},
	{0.00000000507, 4.51932253005, 63498.47038145279},
	{0.00000000467, 5.15486312196, 110012.94461544899},
	{0.00000000519, 2.18877626983, 52195.47604404819},
	{0.00000000439, 3.21217330239, 98690.28051714458},
	{0.00000000436, 4.11931609127, 33326.57873317420},
	{0.00000000486, 3.63985026707, 51749.20809227239},
	{0.00000000527, 0.13511199028, 2218.75710418680},
	{0.00000000419, 1.64150782899, 7238.67559160000},
	{0.00000000433, 5.12287491235, 52171.92494779040},
	{0.00000000386, 2.03457265559, 58946.51688439399},
	{0.00000000388, 0.61592624795, 78793.40038981718},
	{0.00000000402, 6.00790488958, 52168.69273614759},
	{0.00000000354, 1.51714429161, 62389.09182935939},
	{0.00000000370, 0.98752045979, 103292.23063610759},
	{0.00000000326, 4.29715521116, 79323.09135491178},
	{0.00000000392, 2.55718962178, 129330.13715577759},
	{0.00000000430, 2.49466005761, 213.29909543800},
	{0.00000000382, 5.51179087871, 52182.91983014920},
	{0.00000000401, 5.75972783493, 54394.56338733519},
	{0.00000000317, 6.10262679977, 76674.63652943878},
	{0.00000000322, 6.04526148570, 49957.04917896160},
	{0.00000000325, 4.04813766509, 68050.42387851159},
	{0.00000000312, 4.91137892283, 51535.90899683439},
	{0.00000000366, 4.84960838633, 77308.10968311399},
	{0.00000000315, 3.48940938594, 45405.09568190280},
	{0.00000000318, 4.23654189229, 13655.86049117640},
	{0.00000000259, 1.48788758809, 52389.10537858640},
	{0.00000000230, 5.23970398210, 82815.66292178139},
	{0.00000000230, 0.83436604790, 51123.53789995999},
	{0.00000000235, 0.14479942195, 48733.23133818299},
	{0.00000000222, 3.99294043990, 66941.04532641819},
	{0.00000000215, 5.00570874902, 313054.83769889036},
	{0.00000000207, 0.32441801559, 24498.83024629040},
	{0.00000000208, 1.13897731894, 57837.13833230060},
	{0.00000000274, 1.31712695932, 51109.31080595839},
	{0.00000000218, 3.35990718284, 32370.97899156560},
	{0.00000000197, 2.05074719141, 53764.87917843220},
	{0.00000000195, 0.73253707200, 69159.80243060499},
	{0.00000000201, 4.02545532193, 129380.13377768178},
	{0.00000000195, 2.67914149669, 50057.04242277000},
	{0.00000000200, 4.46579555836, 44937.13069154840},
	{0.00000000197, 2.70214163195, 10213.28554621100},
	{0.00000000186, 1.91764312607, 136100.84775702319},
	{0.00000000183, 2.29039964704, 419.48464387520},
	{0.00000000179, 5.25460376556, 105460.99111839019},
	{0.00000000174, 3.75890575398, 51962.50718771040},
	{0.00000000170, 0.05120008168, 78244.03966382280},
	{0.00000000229, 1.74472216574, 433.71173787680},
	{0.00000000172, 0.78909849325, 94138.32702008578},
	{0.00000000157, 3.59078806709, 64741.95798313119},
	{0.00000000156, 0.89517325452, 59414.48187474840},
	{0.00000000162, 2.48823301223, 16983.99614745660},
	{0.00000000159, 6.16937915488, 853.19638175200},
	{0.00000000155, 4.69757523405, 35191.81013569180},
	{0.00000000147, 1.70693555948, 52602.40447402440},
	{0.00000000154, 2.29441335016, 19804.82729158280},
	{0.00000000181, 2.25156652773, 55618.38122811380},
	{0.00000000155, 3.39294110953, 99799.65906923798},
	{0.00000000138, 6.20163548170, 25973.46385288896},
	{0.00000000138, 5.74171028268, 26202.34243025941},
	{0.00000000190, 3.87246923080, 26727.80042788820},
	{0.00000000136, 0.07614870196, 23754.70674870219},
	{0.00000000135, 3.41426499833, 78267.59076008058},
	{0.00000000128, 4.56870410553, 88476.99497093359},
	{0.00000000139, 1.25262181717, 77734.01845962799},
	{0.00000000135, 6.26763497988, 124778.18365871879},
	{0.00000000148, 1.14288127596, 27154.39861876420},
	{0.00000000118, 5.25266695461, 12432.04265039780},
	{0.00000000121, 3.61637465924, 104881.30353139139},
	{0.00000000116, 4.75079129151, 25934.12433108940},
	{0.00000000113, 0.89519838976, 26241.68195205900},
	{0.00000000110, 5.99510808456, 28206.66700195260},
	{0.00000000145, 1.02699984744, 25661.30495069820},
	{0.00000000108, 1.68420561967, 27140.17152476259},
	{0.00000000115, 4.02826839099, 103821.92160120218},
	{0.00000000106, 5.56501238566, 28421.09953444620},
	{0.00000000113, 5.61187119686, 155418.04029735178},
	{0.00000000142, 4.93457693777, 1596.18644228460},
	{0.00000000113, 2.46071266285, 5327.47610838280},
	{0.00000000100, 3.51095185925, 25619.93815121980},
	{0.00000000130, 1.24930068630, 38519.94579197200},
	{0.00000000101, 5.56349300645, 2333.19639287200},
	{0.00000000096, 2.14218398324, 26555.86813192860},
	{0.00000000117, 1.76096469784, 7994.52844202420},
	{0.00000000094, 3.27399866756, 74821.13447975718},
	{0.00000000109, 1.60677184759, 103396.01282468818},
	{0.00000000097, 1.08688412870, 105410.99449648599},
	{0.00000000094, 2.74336450397, 78256.59587772179},
	{0.00000000110, 6.08725694137, 79219.30916633119},
	{0.00000000095, 0.09924693440, 58458.88213313979},
	{0.00000000094, 4.41966418167, 1581.95934828300},
	{0.00000000103, 4.94647459474, 91785.46086631398},
	{0.00000000088, 2.61301107864, 73711.75592766379},
	{0.00000000089, 0.10217527089, 125887.56221081219},
	{0.00000000082, 0.79472961749, 155468.03691925599},
	{0.00000000082, 1.77469219848, 77623.81213840858},
	{0.00000000097, 5.37398198079, 71980.63357473118},
	{0.00000000081, 3.12863861827, 41962.52073693740},
	{0.00000000081, 2.81711911396, 76044.95232053580},
	{0.00000000080, 5.04229374313, 26137.89976347840},
	{0.00000000080, 0.61667373644, 26037.90651966999},
	{0.00000000104, 2.27911229916, 78270.82297172339},
	{0.00000000080, 1.04658076616, 536.80451209540},
	{0.00000000103, 5.23326876495, 78283.37918562238},
	{0.00000000088, 1.89491499121, 78259.82808936459},
	{0.00000000076, 4.59002761471, 64607.84893354619},
	{0.00000000077, 0.52151658040, 18207.81398823521},
	{0.00000000083, 3.91650291052, 77211.44104153418},
	{0.00000000082, 4.38336427974, 77197.21394753258},
	{0.00000000079, 2.47113265383, 80482.46652890938},
	{0.00000000068, 5.02161386487, 85034.42002596818},
	{0.00000000067, 3.83221093171, 120226.23016165999},
	{0.00000000065, 4.96292091927, 162188.75089859738},
	{0.00000000075, 4.93090584764, 149.56319713460},
	{0.00000000064, 2.43966713771, 102762.53967101299},
	{0.00000000071, 2.00840081014, 108903.56606335558},
	{0.00000000062, 3.28305785024, 51756.32163927320},
	{0.00000000078, 3.78933172192, 25565.32572348040},
	{0.00000000078, 0.26259075737, 71492.99882347698},
	{0.00000000076, 4.60309339869, 78477.00852016058},
	{0.00000000063, 0.77267148826, 93028.94846799239},
	{0.00000000076, 3.91621214261, 51742.09454527159},
	{0.00000000056, 3.59213518955, 2648.45482547300},
	{0.00000000057, 5.54251181480, 76144.94556434419},
	{0.00000000057, 1.77596246202, 339142.74084046457},
	{0.00000000057, 1.70642283566, 117873.36400788819},
	{0.00000000064, 5.39890155177, 13521.75144159140},
	{0.00000000059, 1.21407442533, 71025.03383312259},
	{0.00000000052, 0.56412394027, 10021.83728009940},
	{0.00000000054, 5.76743595117, 51322.60990139639},
	{0.00000000053, 5.07040569914, 79852.78232000639},
	{0.00000000058, 1.30087149719, 632.78373931320},
	{0.00000000053, 0.21733504041, 78050.41032928458},
	{0.00000000052, 2.15957506124, 98068.53671630539},
	{0.00000000051, 6.00939227801, 131548.89425996438},
	{0.00000000049, 0.37484483697, 90829.86112470538},
	{0.00000000066, 1.83477065457, 26610.48055966799},
	{0.00000000050, 5.30296789488, 81706.28436968799},
	{0.00000000051, 0.72899300866, 129909.82474277639},
	{0.00000000051, 0.86113541342, 647.01083331480},
	{0.00000000056, 3.55772283134, 26624.70765366959},
	{0.00000000045, 3.09839778780, 104331.94280539699},
	{0.00000000043, 4.78106693432, 78690.30761559859},
	{0.00000000042, 1.33862549536, 114564.89811250778},
	{0.00000000040, 5.84877872776, 23969.13928119580},
	{0.00000000043, 0.49578719152, 103925.01437542078},
	{0.00000000052, 1.00605916556, 39743.76363275060},
	{0.00000000045, 4.58309301985, 76.26607127560},
	{0.00000000038, 0.12510850308, 77204.32749453338},
	{0.00000000038, 4.96138824900, 33967.99229491319},
	{0.00000000037, 3.14446623632, 151975.46535238638},
	{0.00000000049, 0.75521435692, 50579.61984086379},
	{0.00000000037, 3.08060535588, 22759.76748529401},
	{0.00000000049, 2.25743098712, 25551.09862947879},
	{0.00000000043, 4.80730811274, 26521.61487945100},
	{0.00000000035, 3.18489263300, 84546.78527471398},
	{0.00000000040, 0.70008569909, 52815.70356946240},
	{0.00000000034, 0.93646404165, 26190.99591579279},
	{0.00000000044, 2.62980232477, 7880.08915333899},
	{0.00000000041, 3.03548824144, 150866.08680029298},
	{0.00000000040, 5.00668302258, 26294.08869001139},
	{0.00000000034, 0.85062194570, 89586.37352302698},
	{0.00000000035, 2.53628638096, 157636.79740153858},
	{0.00000000041, 0.57259526223, 25881.71759313700},
	{0.00000000041, 4.17638990278, 52329.58509363319},
	{0.00000000042, 6.01467005956, 26507.38778544939},
	{0.00000000033, 4.72754895093, 25984.81036735560},
	{0.00000000036, 3.68841887913, 44181.27784112419},
	{0.00000000033, 1.27875804610, 50593.84693486539},
	{0.00000000043, 6.09764090047, 6681.22485339960},
	{0.00000000036, 0.34367134726, 130969.20667296558},
	{0.00000000036, 0.18284823248, 104355.49390165479},
	{0.00000000032, 2.37243073610, 181505.94343892598},
	{0.00000000036, 3.11876877578, 46848.33017476560},
	{0.00000000032, 1.30247204488, 105307.21230790539},
	{0.00000000032, 4.64178119595, 129483.91596626239},
	{0.00000000030, 5.20322865236, 52643.77127350280},
	{0.00000000031, 2.51185507502, 52290.24557183361},
	{0.00000000029, 5.24573487183, 25668.41849769900},
	{0.00000000028, 3.83067185571, 181555.94006083018},
	{0.00000000031, 4.73782198518, 51639.00177105299},
	{0.00000000029, 2.51843531665, 29416.03879785439},
	{0.00000000029, 4.21426623259, 53242.30176033840},
	{0.00000000028, 3.64092818784, 95247.70557217918},
	{0.00000000035, 4.81649322770, 6283.07584999140},
	{0.00000000036, 2.18114421958, 522.57741809380},
	{0.00000000026, 2.32663083381, 54509.00267602040},
	{0.00000000026, 2.95753849706, 52061.36699446317},
	{0.00000000025, 0.03848563033, 956.28915597060},
	{0.00000000025, 5.13721031791, 42153.96900304900},
	{0.00000000030, 2.99039613509, 26941.09952332620},
	{0.00000000025, 0.42860125930, 29428.51556827400},
	{0.00000000029, 4.14866394337, 131498.89763806018},
	{0.00000000028, 5.32578029265, 104358.72611329758},
	{0.00000000029, 1.60408389107, 25448.00585526019},
	{0.00000000025, 1.67779796211, 26237.46633870879},
	{0.00000000024, 5.28807279458, 22747.29071487440},
	{0.00000000024, 2.71950429042, 54294.57014352679},
	{0.00000000023, 0.58725165783, 146314.13330323418},
	{0.00000000027, 4.52767940172, 25021.40766438420},
	{0.00000000022, 4.74442146801, 143961.26714946238},
	{0.00000000023, 3.78299370119, 25035.63475838580},
	{0.00000000025, 0.72182905302, 52026.24308601380},
	{0.00000000026, 1.72512030163, 27684.08958385880},
	{0.00000000023, 1.73611078502, 188276.65404017158},
	{0.00000000021, 5.86830807135, 102132.85546210999},
	{0.00000000023, 1.39950717748, 61279.71327726600},
	{0.00000000022, 3.49214829498, 130012.91751699499},
	{0.00000000021, 5.78709952320, 104344.49901929598},
	{0.00000000022, 0.10565363711, 77844.22478084739},
	{0.00000000021, 5.21078068231, 124156.43985787958},
	{0.00000000021, 2.38516672571, 85502.38501632259},
	{0.00000000027, 0.68051286566, 103299.34418310839},
	{0.00000000021, 1.14211463317, 103285.11708910679},
	{0.00000000020, 4.96664866905, 103711.71527998279},
	{0.00000000021, 2.16986734764, 49527.35145767539},
	{0.00000000026, 2.05285271079, 60055.89543648739},
	{0.00000000023, 0.68702668183, 77829.99768684579},
	{0.00000000020, 2.29347505450, 1478.86657406440},
	{0.00000000019, 3.64972257327, 52125.80966124419},
	{0.00000000022, 0.84681454741, 70269.18098269838},
	{0.00000000019, 0.04587600812, 3328.13565628019},
	{0.00000000022, 1.42374321926, 104564.91166173479},
	{0.00000000026, 1.26272356256, 13362.44970679920},
	{0.00000000025, 0.01235262119, 24864.08530079559},
	{0.00000000019, 5.60700670343, 106570.36967048359},
	{0.00000000025, 5.65750865200, 27311.72098235281},
	{0.00000000018, 4.78075197963, 53228.07466633679},
	{0.00000000017, 2.51531506964, 1162.47470440780},
	{0.00000000020, 3.30348564295, 97580.90196505119},
	{0.00000000021, 1.98272438830, 104371.28232719658},
	{0.00000000017, 2.59293571203, 77410.51304297059},
	{0.00000000020, 3.91482329597, 131395.11544947959},
	{0.00000000017, 3.10260674166, 104138.31347085879},
	{0.00000000021, 5.05260717886, 134991.46920492979},
	{0.00000000016, 6.20867250288, 100909.03762133139},
	{0.00000000017, 2.39497408205, 18093.37469954999},
	{0.00000000016, 4.32698359511, 12546.48193908300},
	{0.00000000018, 4.91279767114, 52698.38370124219},
	{0.00000000016, 0.84901493535, 25867.49049913539},
	{0.00000000016, 5.55931175273, 183724.70054311278},
	{0.00000000017, 1.54418014066, 115674.27666460119},
	{0.00000000017, 4.81848703132, 128850.44281258718},
	{0.00000000015, 2.38102656379, 16066.06586147480},
	{0.00000000017, 4.80393132096, 51528.79544983359},
	{0.00000000020, 6.13069123005, 11610.55195837420},
	{0.00000000019, 3.74384920337, 155997.72788435058},
	{0.00000000014, 3.58173383909, 44295.71712980940},
	{0.00000000015, 2.07746651676, 107794.18751126219},
	{0.00000000018, 4.53931120962, 51543.02254383520},
	{0.00000000015, 4.93940053675, 26308.31578401300},
	{0.00000000015, 1.33651838433, 26164.16921284980},
	{0.00000000015, 2.26943407259, 102232.84870591838},
	{0.00000000018, 3.82088730679, 119116.85160956658},
	{0.00000000018, 5.91863678140, 45494.58142974879},
	{0.00000000015, 5.17830960776, 26222.01219115920},
	{0.00000000014, 4.76550818683, 2111.65031337760},
	{0.00000000015, 1.74258697688, 52225.80290505260},
	{0.00000000015, 3.82786291889, 76667.52298243798},
	{0.00000000014, 4.77147651749, 27999.10262479140},
	{0.00000000018, 4.93958674569, 104347.73123093879},
	{0.00000000014, 3.43030204306, 116917.76426627958},
	{0.00000000015, 4.82510142643, 365230.64398203876},
	{0.00000000013, 3.69040263930, 323.50541665740},
	{0.00000000013, 0.92750711335, 24176.70365835700},
	{0.00000000014, 0.49576253379, 25953.79409198919},
	{0.00000000013, 6.18203275911, 178063.36849396059},
	{0.00000000017, 4.23443256776, 97112.93697469679},
	{0.00000000013, 3.31644628485, 220.41264243880},
	{0.00000000015, 0.24698669297, 52712.61079524379},
	{0.00000000015, 1.05658470808, 52099.54021187280},
	{0.00000000013, 4.30617411007, 76681.75007643958},
	{0.00000000013, 5.74254354304, 55503.94193942859},
	{0.00000000013, 4.49086187677, 103.09277421860},
	{0.00000000013, 1.08207420360, 1692.16566950240},
	{0.00000000015, 1.28342499223, 27669.86248985719},
	{0.00000000014, 1.82228184088, 105940.68546158058},
	{0.00000000012, 1.79845456663, 111122.32316754239},
	{0.00000000013, 3.31209041530, 14477.35118320000},
	{0.00000000012, 1.57036398698, 104778.21075717278},
	{0.00000000013, 4.39267521476, 140652.80125408198},
	{0.00000000012, 1.33521638588, 52072.71350892979},
	{0.00000000012, 4.66725197197, 111590.28815789679},
	{0.00000000015, 5.49469453836, 2125.87740737920},
	{0.00000000012, 6.21958146278, 72936.23331633979},
	{0.00000000015, 1.55251538013, 20760.42703319140},
	{0.00000000011, 2.98365933273, 25977.69682035479},
	{0.00000000012, 6.24533055094, 110634.68841628819},
	{0.00000000014, 1.03063178545, 78417.48823520739},
	{0.00000000011, 3.57047418140, 36109.74042167360},
	{0.00000000011, 2.67619239702, 26198.10946279360},
	{0.00000000014, 5.29903467924, 77837.11123384659},
	{0.00000000012, 5.21668700555, 31415.37924995700},
	{0.00000000011, 4.12038634021, 51969.62073471119},
	{0.00000000012, 6.15491126193, 130419.84594697120},
	{0.00000000014, 2.66253684701, 32769.12799497380},
	{0.00000000010, 0.30174606733, 28736.35796704720},
	{0.00000000010, 1.78614915805, 68241.87214462319},
	{0.00000000012, 0.89596440765, 224.34479570190},
	{0.00000000011, 3.62051737282, 65697.55772473979},
	{0.00000000012, 4.51767669506, 38813.35657634920},
	{0.00000000010, 1.51502620255, 170049.17029103659},
	{0.00000000010, 0.65896029584, 157483.01859105378},
	{0.00000000012, 1.50419920446, 12725.45343477500},
	{0.00000000010, 0.60086822741, 207643.84320240439},
	{0.00000000012, 0.27544235334, 26395.46076254379},
	{0.00000000012, 5.38818267787, 25780.34552060460},
	{0.00000000012, 4.18148179610, 26724.89941359840},
	{0.00000000012, 1.48214323511, 25450.90686955000},
	{0.00000000010, 4.43951347141, 141762.17980617538},
	{0.00000000009, 5.62764518642, 51219.51712717779},
	{0.00000000009, 1.40970085491, 155571.81910783658},
	{0.00000000009, 3.80728835859, 78903.60671103658},
	{0.00000000009, 1.98340877635, 78731.67441507700},
	{0.00000000010, 1.06876588648, 90695.75207512038},
	{0.00000000012, 2.28213947586, 25446.48957983520},
	{0.00000000012, 3.38148555535, 26729.31670331319},
	{0.00000000010, 4.04489455556, 65831.66677432480},
	{0.00000000009, 1.97985537350, 16703.06213349900},
	{0.00000000009, 0.19461343328, 51707.84129279399},
	{0.00000000009, 5.42812340959, 207593.84658050018},
	{0.00000000009, 0.25320629703, 156100.82065856918},
	{0.00000000012, 6.08675975595, 176953.98994186718},
	{0.00000000011, 2.32296397326, 52022.02747266360},
	{0.00000000009, 0.04502499664, 49842.60989027639},
	{0.00000000009, 3.48790336223, 55516.41870984820},
	{0.00000000009, 1.60659830268, 52609.51802102519},
	{0.00000000009, 2.19657708690, 1911.19948321720},
	{0.00000000011, 3.36653560664, 157057.10981453978},
	{0.00000000010, 1.95365576783, 52381.99183158559},
	{0.00000000008, 5.89998501862, 52182.43484204840},
	{0.00000000008, 0.07994652584, 27177.61193276780},
	{0.00000000008, 5.58367850537, 24998.19435038059},
	{0.00000000008, 4.04423154032, 3340.61242669980},
	{0.00000000009, 3.91205376466, 24491.71669928959},
	{0.00000000009, 3.20602268861, 19.66976089979},
	{0.00000000008, 6.13311048887, 48847.67062686820},
	{0.00000000009, 1.07817311326, 206.18554843720},
	{0.00000000008, 6.23748821057, 860.30992875280},
	{0.00000000007, 0.62849516745, 9384.84100807520},
	{0.00000000007, 3.37283868879, 50696.93970908399},
	{0.00000000008, 2.95337805438, 52595.29092702359},
	{0.00000000008, 2.09085109942, 130446.62925487179},
	{0.00000000009, 3.23441439127, 130443.39704322898},
	{0.00000000008, 4.23722680471, 26720.68688088739},
	{0.00000000008, 5.65039159250, 1223.81784077861},
	{0.00000000007, 2.30474556787, 209812.60368468695},
	{0.00000000007, 3.64200504235, 172402.03644480839},
	{0.00000000007, 3.15699312277, 51013.33157874059},
	{0.00000000007, 0.75605454895, 846.08283475120},
	{0.00000000007, 3.04941872455, 27044.19229754480},
	{0.00000000007, 1.99337329060, 150244.34299945379},
	{0.00000000009, 3.93059938713, 26734.91397488900},
	{0.00000000007, 4.75714960140, 52325.36948028299},
	{0.00000000007, 5.10226976956, 13541.42120249119},
	{0.00000000007, 5.38424470913, 80596.90581759460},
	{0.00000000007, 0.02516209233, 110.20632121940},
	{0.00000000006, 3.78360025001, 52278.89905736699},
	{0.00000000008, 3.73990342667, 129387.24732468258},
	{0.00000000009, 3.42497309447, 75930.51303185058},
	{0.00000000008, 2.75106262517, 52169.17772424839},
	{0.00000000008, 1.50347216209, 77726.90491262719},
	{0.00000000006, 1.00543740922, 79330.20490191258},
	{0.00000000007, 5.56521824483, 78378.14871340781},
	{0.00000000006, 4.20397273576, 129373.02023068098},
	{0.00000000007, 1.62569971593, 26162.68474014150},
	{0.00000000006, 4.50914445356, 130652.81480330898},
	{0.00000000007, 1.43696950392, 77630.92568540938},
	{0.00000000006, 0.25065144064, 25508.21555457540},
	{0.00000000006, 5.41297359057, 26667.59072857300},
	{0.00000000006, 1.04635537302, 39629.32434406539},
	{0.00000000006, 5.52124151783, 40565.25432477420},
	{0.00000000007, 5.85352766815, 8194.27533320860},
	{0.00000000006, 3.75147990976, 103917.90082841998},
	{0.00000000008, 0.93245740025, 157586.80077963437},
	{0.00000000006, 2.36516103356, 51653.22886505459},
	{0.00000000007, 1.15740041561, 154938.34595416138},
	{0.00000000006, 4.00716639365, 26013.12154300690},
	{0.00000000007, 4.77970201762, 214364.55718174578},
	{0.00000000006, 1.84888596079, 6885.14988993081},
	{0.00000000007, 4.36588080270, 25754.04720080480},
	{0.00000000007, 1.29774422851, 26421.75908234360},
	{0.00000000006, 6.00893693971, 78149.27013603736},
	{0.00000000005, 0.89617169225, 50064.15596977079},
	{0.00000000006, 2.63212801251, 128220.75860368418},
	{0.00000000006, 2.80934233604, 66653.15746634839},
	{0.00000000005, 6.05965648339, 130226.21661243298},
	{0.00000000006, 0.06830775273, 123668.80510662538},
	{0.00000000005, 1.17676147240, 102769.65321801379},
	{0.00000000006, 1.81840060185, 161079.37234650398},
	{0.00000000006, 3.17893579358, 103932.12792242158},
	{0.00000000005, 3.89300636955, 35472.74414964940},
	{0.00000000005, 5.74462559833, 80382.47328510099},
	{0.00000000006, 3.53640622861, 1265.56747862640},
	{0.00000000005, 0.40751082829, 78213.71280281838},
	{0.00000000006, 0.47609620784, 182085.63102592478},
	{0.00000000005, 0.72763573757, 102755.42612401219},
	{0.00000000007, 1.01041013974, 64901.25971792339},
	{0.00000000005, 5.06606479586, 75615.25459924959},
	{0.00000000005, 6.09989191383, 6044.22858137540},
	{0.00000000005, 3.68449716556, 19406.67828817460},
	{0.00000000005, 0.55347836802, 25654.19140369739},
	{0.00000000005, 1.21533954768, 137678.19129947099},
	{0.00000000005, 2.42117857215, 53399.62412392700},
	{0.00000000005, 3.99647174335, 27780.06881107659},
	{0.00000000005, 0.51237606895, 26402.08932144380},
	{0.00000000005, 5.15124896226, 25773.71696170459},
	{0.00000000005, 1.58549672991, 77616.69859140778},
	{0.00000000006, 0.18266035721, 50049.92887576919},
	{0.00000000005, 3.56670679513, 17893.62780836560},
	{0.00000000005, 1.61430068646, 54087.00576636560},
	{0.00000000005, 0.59515032793, 45892.73043315699},
	{0.00000000005, 4.35949013333, 24505.94379329119},
	{0.00000000004, 2.54682197432, 130432.40216087017},
	{0.00000000004, 1.97821363637, 51852.30086649099},
	{0.00000000005, 2.92494499838, 204151.27163553478},
	{0.00000000004, 2.42171570518, 132658.27281205778},
	{0.00000000005, 4.14081422433, 25938.33994443960},
	{0.00000000005, 4.31428427792, 39450.35284837340},
	{0.00000000005, 4.64089847229, 65717.22748563958},
	{0.00000000004, 2.80245159203, 51955.39364070959},
	{0.00000000004, 5.66137471686, 103498.41618454478},
	{0.00000000005, 1.63974900109, 52396.21892558720},
	{0.00000000004, 4.13434256469, 104505.39137678158},
	{0.00000000005, 0.99790116577, 123200.84011627098},
	{0.00000000004, 5.04512254863, 949.17560896980},
	{0.00000000004, 2.16539647390, 28791.51929624980},
	{0.00000000004, 3.49822855731, 23384.28698689860},
	{0.00000000005, 6.09748705519, 53029.00266490040},
	{0.00000000004, 3.38348270644, 26823.77965510599},
	{0.00000000004, 2.28014232477, 25352.02662804239},
	{0.00000000004, 5.11054976948, 133882.09065283638},
	{0.00000000004, 4.79464066723, 53771.99272543299},
	{0.00000000004, 3.58076228853, 183570.92173262799},
	{0.00000000005, 0.57466690776, 145204.75475114079},
	{0.00000000004, 5.08739935768, 23439.44831610119},
	{0.00000000004, 2.91942328210, 27170.98337386779},
	{0.00000000004, 2.74420174911, 25004.82290928060},
	{0.00000000004, 1.71297602638, 78786.28684281638},
	{0.00000000004, 5.16889446071, 636.99627202420},
	{0.00000000004, 5.09217946129, 1795.25844372100},
	{0.00000000005, 3.41506026848, 26709.64694241340},
	{0.00000000005, 2.24856476273, 25466.15934073500},
	{0.00000000004, 5.84172747790, 52065.59996192899},
	{0.00000000004, 1.68123807603, 2221.85663459700},
	{0.00000000004, 4.55458054656, 50483.64061364600},
	{0.00000000005, 2.46371613890, 25234.70675982219},
	{0.00000000004, 2.68517686010, 78270.33798362259},
	{0.00000000004, 1.79847863201, 34282.17847478280},
	{0.00000000004, 0.54205020737, 199599.31813847595},
	{0.00000000004, 0.19066423879, 143005.66740785378},
	{0.00000000004, 3.27752582001, 78800.51393681798},
	{0.00000000004, 5.02476065705, 130459.18546877075},
	{0.00000000004, 4.14907610702, 3178.14579056760},
	{0.00000000004, 4.96500381777, 52250.58788171570},
	{0.00000000003, 4.30211830006, 78160.61665050399},
	{0.00000000004, 4.46181026998, 87367.61641884019},
	{0.00000000004, 5.81440577111, 60370.08161635699},
	{0.00000000004, 1.72859821695, 130435.63437251298},
	{0.00000000004, 1.63790933088, 26575.53789282839},
	{0.00000000004, 4.02571570033, 25600.26839032000},
	{0.00000000004, 5.34209380620, 128320.75184749259},
	{0.00000000003, 0.66817274434, 1485.98012106520},
	{0.00000000003, 1.93014248251, 52309.91533273340},
	{0.00000000003, 1.03809809070, 167850.08294774959},
	{0.00000000003, 0.34394173964, 70383.62027138360},
	{0.00000000003, 4.41765442359, 52252.07235442399},
	{0.00000000005, 1.98227688514, 52808.59002246159},
	{0.00000000004, 5.74995583021, 58857.03113654799},
	{0.00000000004, 4.77171683373, 51951.46148744649},
	{0.00000000003, 3.97223691848, 50264.60679993120},
	{0.00000000004, 2.74364830901, 20043.67456019880},
	{0.00000000003, 5.53627007155, 25985.94062330859},
	{0.00000000003, 0.12735495966, 26189.86565983980},
	{0.00000000004, 3.03031240281, 136722.59155786238},
	{0.00000000003, 0.61004720971, 735.87651353180},
	{0.00000000003, 2.56714384303, 25131.61398560359},
	{0.00000000003, 1.95760647082, 48835.19385644859},
	{0.00000000004, 1.89782941813, 129799.61842155698},
	{0.00000000003, 4.19410945260, 181026.24909573558},
	{0.00000000003, 0.20996976206, 26073.67604757259},
	{0.00000000003, 5.45365526915, 26102.13023557580},
	{0.00000000003, 4.53247360475, 86143.79857806159},
	{0.00000000004, 2.86746639454, 37698.45509994840},
	{0.00000000003, 3.44421079458, 26247.20487636640},
	{0.00000000003, 2.21941423663, 25928.60140678200},
	{0.00000000004, 4.84952063164, 132028.58860315479},
	{0.00000000004, 1.88877518970, 467.96499035440},
	{0.00000000003, 2.53719866549, 8989.46770543239},
	{0.00000000004, 3.00645389386, 32132.13172294960},
	{0.00000000004, 1.14854014554, 166740.70439565618},
	{0.00000000003, 5.16507118208, 2703.61615467560},
	{0.00000000003, 1.57772720091, 79315.97780791098},
	{0.00000000003, 4.62863855126, 130866.11389874699},
	{0.00000000003, 2.23216290209, 51868.24866217880},
	{0.00000000003, 2.34626079514, 126996.94076290558},
	{0.00000000003, 0.19144773586, 76784.84285065818},
	{0.00000000004, 0.40583501169, 78109.93061423779},
	{0.00000000003, 1.31292716378, 19202.75325164339},
	{0.00000000003, 0.19319971566, 61560.64729122359},
	{0.00000000003, 5.72167155686, 52286.01260436779},
	{0.00000000003, 6.06197330359, 77101.23472031478},
	{0.00000000003, 5.97751979418, 77741.13200662879},
	{0.00000000003, 3.62486778390, 45290.65639321759},
	{0.00000000003, 5.68567369750, 24925.42843716640},
	{0.00000000004, 6.05038593627, 28286.99048486120},
	{0.00000000004, 5.89642440212, 23888.81579828719},
	{0.00000000002, 3.26392643567, 182188.72380014337},
	{0.00000000003, 5.52666614504, 74.78159856730},
	{0.00000000003, 6.24797687447, 27250.37784598199},
	{0.00000000003, 5.71051457818, 51315.49635439559},
	{0.00000000002, 3.83786759867, 173511.41499690177},
	{0.00000000002, 2.79317647457, 2008.55753915900},
	{0.00000000002, 2.32070917581, 81591.84508100279},
	{0.00000000002, 4.91686748502, 51329.72344839720},
	{0.00000000002, 5.68200667980, 147423.51185532758},
	{0.00000000003, 0.23735872795, 81604.32185142238},
	{0.00000000003, 0.95743283729, 52812.80255517260},
	{0.00000000003, 4.47606214286, 34082.43158359840},
	{0.00000000003, 1.59253054642, 391318.54712361297},
	{0.00000000002, 4.54029209815, 196137.07343261078},
	{0.00000000003, 2.85252650926, 156507.74908854539},
	{0.00000000002, 6.12062449239, 121335.60871375339},
	{0.00000000003, 2.50847406676, 27726.97265876220},
	{0.00000000003, 3.15515096445, 24448.83362438620},
	{0.00000000002, 4.46394320758, 26011.63707029860},
	{0.00000000002, 1.06183386008, 78057.52387628538},
	{0.00000000003, 4.75030126782, 78313.70604662679},
	{0.00000000003, 2.83857270203, 203041.89308344138},
	{0.00000000002, 1.11670300110, 38634.38508065720},
	{0.00000000003, 5.82930728472, 78257.08086582259},
	{0.00000000002, 0.05620437017, 205260.65018762815},
	{0.00000000002, 5.65450810136, 114.43928868521},
	{0.00000000003, 2.95149274211, 128106.31931499895},
	{0.00000000003, 3.52707759552, 52041.69723356339},
	{0.00000000002, 0.81911436141, 24609.03656750980},
	{0.00000000002, 5.03728139459, 104819.57755665119},
	{0.00000000002, 0.34244940933, 62197.64356324779},
	{0.00000000002, 1.09939750415, 74923.09699802278},
	{0.00000000002, 2.48332922164, 101703.15774082378},
	{0.00000000002, 0.60560213674, 17098.43543614181},
	{0.00000000002, 5.11946015222, 78469.89497315978},
	{0.00000000002, 2.20613703147, 77307.42026875199},
	{0.00000000002, 0.59446302071, 104991.50985261079},
	{0.00000000002, 4.03918468742, 26312.24793727610},
	{0.00000000002, 0.80941764272, 91919.56991589899},
	{0.00000000002, 4.02958262076, 26183.88236879199},
	{0.00000000002, 1.63404241045, 25991.92391435639},
	{0.00000000002, 3.64118684388, 225687.22128005016},
	{0.00000000002, 2.90800082543, 96357.08412427259},
	{0.00000000002, 3.38748443048, 177287.84588263658},
	{0.00000000003, 5.23217095654, 51534.39272140940},
	{0.00000000002, 1.72280954996, 215473.93573383916},
	{0.00000000002, 1.73910591832, 25455.11940226100},
	{0.00000000002, 0.08655833344, 183145.01295611398},
	{0.00000000002, 4.91320505829, 189386.03259226495},
	{0.00000000002, 2.73964259090, 26397.18146422999},
	{0.00000000002, 2.92398244031, 25778.62481891839},
	{0.00000000002, 5.05024038444, 42790.96527507320},
	{0.00000000002, 5.11101145665, 51538.81001112419},
	{0.00000000002, 4.02707586748, 24952.22626968100},
	{0.00000000002, 1.63654916373, 27223.58001346740},
	{0.00000000002, 4.56989494681, 103718.82882698359},
	{0.00000000002, 3.21686304521, 25984.12095299360},
	{0.00000000002, 2.44676198600, 26191.68533015479},
	{0.00000000002, 0.73451437899, 25927.49577218939},
	{0.00000000002, 4.92911065222, 26248.31051095900},
	{0.00000000002, 3.14486706475, 53265.51507434200},
	{0.00000000002, 1.46628877500, 51841.95034237900},
	{0.00000000002, 2.09863898672, 29550.14784743939},
	{0.00000000002, 3.56498604449, 22625.65843570900},
	{0.00000000002, 1.44463204026, 27037.07875054399},
	{0.00000000002, 4.21899299095, 25138.72753260440},
	{0.00000000002, 0.12919974221, 52817.21984488739},
	{0.00000000002, 5.02538083126, 138319.60486120995},
	{0.00000000002, 3.79805429136, 104202.04936916218},
	{0.00000000002, 3.65031025117, 233731.74634397858},
	{0.00000000002, 3.29338443989, 54824.26110862140},
	{0.00000000002, 2.12894187827, 50910.23880452200},
	{0.00000000002, 3.08974476939, 51859.41441349179},
	{0.00000000002, 5.26455969937, 92741.06060792258},
	{0.00000000002, 5.25139825164, 168959.46149984296},
	{0.00000000002, 1.46840529933, 25863.55834587229},
	{0.00000000002, 4.33245746008, 23976.25282819660},
	{0.00000000002, 4.40672336509, 53757.76563143139},
	{0.00000000002, 5.60768237774, 52492.19815280499},
	{0.00000000002, 5.50882009325, 26076.85744131030},
	{0.00000000002, 0.15480493796, 26098.94884183810},
	{0.00000000002, 4.95075276458, 176332.24614102798},
	{0.00000000002, 5.17774922517, 78896.49316403578},
	{0.00000000002, 0.26673303771, 26411.40855823160},
	{0.00000000002, 4.42579128459, 181659.72224941078},
	{0.00000000002, 3.44678527119, 52483.36390411799},
	{0.00000000002, 5.27672418948, 113341.08027172917},
	{0.00000000001, 4.63971494884, 27351.06050415239},
	{0.00000000001, 1.02391008237, 24824.74577899600},
	{0.00000000001, 4.66880968358, 78697.42116259939},
	{0.00000000001, 3.24905067191, 51596.11869614960},
	{0.00000000002, 4.53665275519, 103814.80805420138},
	{0.00000000002, 4.58331327521, 116783.65521669458},
	{0.00000000002, 0.70194343478, 51226.63067417859},
	{0.00000000002, 0.18180872148, 151199.94274106238},
	{0.00000000001, 3.03383040944, 231348.55332920236},
	{0.00000000002, 2.67846250087, 50951.98844236979},
	{0.00000000002, 1.58435794119, 25440.89230825939},
	{0.00000000001, 1.25537531369, 193937.98608932378},
	{0.00000000002, 3.35591413107, 86457.98475793119},
	{0.00000000001, 4.71704307559, 54879.42243782400},
	{0.00000000002, 4.94615782219, 94329.77528619739},
	{0.00000000001, 4.19525126274, 189853.99758261938},
	{0.00000000001, 4.79191528728, 52509.66222391780},
	{0.00000000002, 5.64922837609, 26713.57333388659},
	{0.00000000002, 0.01439665512, 25462.23294926180},
	{0.00000000002, 3.08925038032, 118828.96374949679},
	{0.00000000002, 1.97012173863, 99024.13645791399},
	{0.00000000002, 4.11674730434, 23919.14265929160},
	{0.00000000002, 1.54687772687, 28256.66362385679},
	{0.00000000002, 4.79684569019, 35077.37084700659},
	{0.00000000001, 1.58300591770, 28199.55345495179},
	{0.00000000001, 5.37086062741, 87253.17713015496},
	{0.00000000001, 0.36331366874, 103127.79472551816},
	{0.00000000001, 5.62873981032, 112545.88789950538},
	{0.00000000001, 2.53173488195, 112231.70171963578},
	{0.00000000001, 3.50023943727, 26933.98597632540},
	{0.00000000001, 0.57318968993, 50380.54783942739},
	{0.00000000001, 4.87198031328, 241561.83887541336},
	{0.00000000002, 5.62002771737, 27566.76971563859},
	{0.00000000001, 4.38686363141, 80174.90890793978},
	{0.00000000001, 3.98058009404, 49953.94964855139},
	{0.00000000001, 0.70022281901, 155460.92337225519},
	{0.00000000001, 0.70726844016, 179172.74704605396},
	{0.00000000001, 4.37321488294, 26926.87242932459},
	{0.00000000001, 1.29041014827, 25248.93385382380},
	{0.00000000001, 5.32324865971, 139428.98341330336},
	{0.00000000001, 1.51650944248, 48997.66049258080},
	{0.00000000001, 4.69307275860, 90989.16285949759},
	{0.00000000001, 0.54761639710, 23962.02573419499},
	{0.00000000001, 5.22070652557, 27005.83342755599},
	{0.00000000001, 0.44291850564, 25169.97285559240},
	{0.00000000001, 4.43926451679, 143980.93691036216},
	{0.00000000001, 4.99715761034, 50689.82616208319},
	{0.00000000001, 0.26741554519, 163298.12945069079},
	{0.00000000001, 3.67963627218, 133767.65136415116},
	{0.00000000001, 1.24890392539, 122444.98726584678},
	{0.00000000001, 4.07473618347, 76152.05911134499},
	{0.00000000001, 1.41453859000, 84307.93800609799},
	{0.00000000001, 5.82040259792, 24072.92146977640},
	{0.00000000001, 6.12640774047, 28102.88481337200},
	{0.00000000001, 0.51650041444, 24844.41553989579},
	{0.00000000001, 5.14712461677, 27331.39074325260},
	{0.00000000001, 1.95974246534, 154408.65498906678},
	{0.00000000001, 1.80028024653, 106262.81204951399},
	{0.00000000001, 5.62631785594, 58220.03486452380},
	{0.00000000001, 2.37988104916, 97670.38771289718},
	{0.00000000001, 4.99005405979, 117893.03376878797},
	{0.00000000001, 4.63169895688, 24356.78078864160},
	{0.00000000001, 1.03192607433, 27819.02549450680},
	{0.00000000001, 2.00018453744, 24395.73747207180},
	{0.00000000001, 0.64266724686, 149642.26895951436},
	{0.00000000001, 1.86708387864, 132350.71519108818},
	{0.00000000001, 3.72309272905, 148532.89040742096},
	{0.00000000001, 0.33911349458, 209658.82487420218},
	{0.00000000001, 3.17243932745, 125112.03959948818},
	{0.00000000001, 5.05024621722, 137210.22630911658},
	{0.00000000001, 5.41436422726, 23704.71012679799},
	{0.00000000001, 0.24926080395, 28471.09615635040},
	{0.00000000001, 5.21985223980, 51439.92976961659},
	{0.00000000001, 4.02649464248, 26177.38888942019},
	{0.00000000001, 1.63713038873, 25998.41739372820},
	{0.00000000001, 1.98713499450, 233681.74972207438},
	{0.00000000001, 3.17318181579, 21650.38893320061},
	{0.00000000001, 2.49044321542, 30525.41734994779},
	{0.00000000001, 0.19731686066, 26094.53170047421},
	{0.00000000001, 4.15055550489, 24203.00197815680},
	{0.00000000001, 1.51306952633, 27972.80430499159},
	{0.00000000001, 3.82198016519, 104197.83375581198},
	{0.00000000001, 2.86028052056, 50167.24874398939},
	{0.00000000001, 1.54854247637, 78413.27262185719},
	{0.00000000001, 6.28162689960, 156531.30018480319},
	{0.00000000001, 6.09525332464, 25227.59321282139},
	{0.00000000001, 4.51338458149, 25151.97316086539},
	{0.00000000001, 1.15024044972, 27023.83312228300},
	{0.00000000001, 4.26118287889, 247223.17092456557},
	{0.00000000001, 4.56611897971, 102018.41617342478},
	{0.00000000001, 1.45821418416, 163766.09444104518},
	{0.00000000001, 3.96461816746, 183674.70392120858},
	{0.00000000001, 6.06920679029, 26126.03617721200},
	{0.00000000001, 5.87760354810, 26049.77010593640},
	{0.00000000001, 6.26540081354, 107679.74822257696},
	{0.00000000001, 5.34892363416, 27388.72995977919},
	{0.00000000001, 0.31470139705, 24787.07632336920},
	{0.00000000001, 0.51689218530, 155475.15046625677},
	{0.00000000001, 5.17339556279, 24602.61243487099},
	{0.00000000001, 0.49022946842, 27573.19384827740},
	{0.00000000001, 0.40614537067, 198489.93958638258},
	{0.00000000001, 5.13509102157, 156534.53239644598},
	{0.00000000001, 2.23259165946, 61165.27398858079},
	{0.00000000001, 0.52115552294, 130005.80396999417},
	{0.00000000001, 0.61669479944, 77039.89158394396},
	{0.00000000001, 6.28031983065, 129215.69786709236},
	{0.00000000001, 5.25475920583, 25923.46723098479},
	{0.00000000001, 0.40886582538, 26252.33905216361},
	{0.00000000001, 1.82474594164, 73891.83305794839},
	{0.00000000001, 1.20518566567, 126067.63934109679},
	{0.00000000001, 2.40166427113, 30171.89164827860},
	{0.00000000001, 3.26196076008, 22003.91463486980},
	{0, 0, 0}
};

struct vsop87_term mercury_x2[] = {
	{0.00001484185, 4.35401210269, 52175.80628314840},
	{0.00000907467, 1.13216343018, 78263.70942472259},
	{0.00001214995, 0.00000000000, 0.00000000000},
	{0.00000368809, 4.18705944126, 104351.61256629678},
	{0.00000254306, 4.12817377140, 26087.90314157420},
	{0.00000130149, 0.95681684789, 130439.51570787099},
	{0.00000042868, 4.00892196726, 156527.41884944518},
	{0.00000013566, 0.77740665693, 182615.32199101939},
	{0.00000004184, 3.82884210516, 208703.22513259358},
	{0.00000002906, 1.33529655305, 24978.52458948080},
	{0.00000002677, 4.31517647277, 27197.28169366760},
	{0.00000001268, 0.59695956916, 234791.12827416777},
	{0.00000001011, 4.40490230415, 51066.42773105500},
	{0.00000000379, 3.64772765617, 260879.03141574195},
	{0.00000000354, 1.08917562345, 53285.18483524180},
	{0.00000000350, 1.77280702796, 1109.37855209340},
	{0.00000000352, 1.18170316153, 77154.33087262919},
	{0.00000000177, 1.12611560699, 1589.07289528380},
	{0.00000000193, 4.15648107481, 25132.30339996560},
	{0.00000000171, 1.47490138738, 27043.50288318280},
	{0.00000000161, 0.04902247718, 1059.38193018920},
	{0.00000000140, 1.84983910496, 21535.94964451540},
	{0.00000000140, 4.99408246712, 20426.57109242200},
	{0.00000000117, 5.88592772067, 26617.59410666880},
	{0.00000000115, 6.09306139752, 25558.21217647960},
	{0.00000000112, 0.41587357894, 286966.93455731616},
	{0.00000000116, 1.82846585957, 46514.47423399620},
	{0.00000000107, 2.57772432456, 14765.23904326980},
	{0.00000000105, 2.94297794273, 27147.28507176339},
	{0.00000000124, 1.42405663717, 23869.14603738740},
	{0.00000000103, 3.78216777057, 4551.95349705880},
	{0.00000000120, 4.23792109159, 103242.23401420339},
	{0.00000000103, 4.21297257897, 28306.66024576099},
	{0.00000000099, 0.66196730608, 31749.23519072640},
	{0.00000000085, 5.14492546566, 19317.19254032860},
	{0.00000000068, 0.11271966893, 9103.90699411760},
	{0.00000000066, 3.92016503259, 3442.57494496540},
	{0.00000000061, 4.53397757302, 50586.73338786459},
	{0.00000000059, 4.88869826613, 72602.37737557039},
	{0.00000000059, 3.10507163380, 37410.56723987860},
	{0.00000000059, 2.56122053117, 52705.49724824299},
	{0.00000000059, 2.65338512183, 529.69096509460},
	{0.00000000065, 0.65463924387, 51220.20654153979},
	{0.00000000057, 3.80644223882, 30639.85663863300},
	{0.00000000070, 1.72021333432, 22645.32819660879},
	{0.00000000055, 5.61982417509, 51116.42435295920},
	{0.00000000053, 0.46679718569, 32858.61374281979},
	{0.00000000051, 5.34709457186, 639.89728631400},
	{0.00000000049, 4.02776993187, 27676.97603685800},
	{0.00000000045, 1.60026053734, 25973.46385288896},
	{0.00000000044, 4.05810232577, 26202.34243025941},
	{0.00000000045, 5.95361998059, 53235.18821333759},
	{0.00000000053, 5.16526900470, 955.59974160860},
	{0.00000000039, 2.65493111018, 25874.60404613620},
	{0.00000000039, 5.64911272409, 40853.14218484400},
	{0.00000000038, 2.96694233358, 26301.20223701220},
	{0.00000000036, 1.80953346883, 2118.76386037840},
	{0.00000000044, 3.91987173876, 29530.47808653960},
	{0.00000000038, 4.27891905126, 53131.40602475700},
	{0.00000000033, 0.62515314785, 56727.75978020720},
	{0.00000000040, 1.01193838180, 129330.13715577759},
	{0.00000000033, 3.46947113137, 313054.83769889036},
	{0.00000000031, 4.26713688144, 6770.71060124560},
	{0.00000000038, 1.69042706019, 2218.75710418680},
	{0.00000000032, 4.48774417428, 49957.04917896160},
	{0.00000000031, 1.93866033936, 47623.85278608960},
	{0.00000000025, 5.55384551516, 43071.89928903080},
	{0.00000000025, 1.66429605369, 98690.28051714458},
	{0.00000000024, 5.51512603999, 78793.40038981718},
	{0.00000000023, 3.56120112847, 77308.10968311399},
	{0.00000000027, 0.98357005483, 54394.56338733519},
	{0.00000000022, 1.92756765233, 45405.09568190280},
	{0.00000000018, 3.61025694461, 58946.51688439399},
	{0.00000000024, 0.61193595038, 18849.22754997420},
	{0.00000000018, 6.14187591989, 213.29909543800},
	{0.00000000018, 1.73990981189, 52156.13652224860},
	{0.00000000017, 2.72916234159, 79323.09135491178},
	{0.00000000021, 2.68093863363, 13655.86049117640},
	{0.00000000017, 2.40773796722, 12566.15169998280},
	{0.00000000018, 0.31168509807, 51535.90899683439},
	{0.00000000017, 6.10620927353, 52389.10537858640},
	{0.00000000016, 1.66583339325, 23754.70674870219},
	{0.00000000017, 3.21787186790, 51646.11531805379},
	{0.00000000016, 1.85663665448, 48733.23133818299},
	{0.00000000015, 5.39822666802, 38654.05484155699},
	{0.00000000017, 0.47473519961, 426.59819087600},
	{0.00000000016, 4.15133356060, 79373.08797681599},
	{0.00000000015, 4.37601198404, 853.19638175200},
	{0.00000000014, 5.09664706361, 52179.68761850640},
	{0.00000000014, 3.68991823488, 82815.66292178139},
	{0.00000000014, 2.42828725984, 66941.04532641819},
	{0.00000000014, 3.63538725359, 110012.94461544899},
	{0.00000000014, 0.69791035823, 53764.87917843220},
	{0.00000000015, 0.66471022805, 52195.47604404819},
	{0.00000000013, 1.07484706961, 76674.63652943878},
	{0.00000000015, 4.95964145342, 33326.57873317420},
	{0.00000000012, 3.86072810652, 50057.04242277000},
	{0.00000000016, 0.69576423227, 55618.38122811380},
	{0.00000000013, 0.67881557905, 83925.04147387479},
	{0.00000000013, 4.06012579136, 155418.04029735178},
	{0.00000000012, 4.00107179066, 28421.09953444620},
	{0.00000000013, 3.59727069136, 52171.92494779040},
	{0.00000000013, 3.14908318702, 36301.18868778519},
	{0.00000000011, 1.67250696064, 24498.83024629040},
	{0.00000000014, 4.17248996684, 5661.33204915220},
	{0.00000000013, 2.13490029542, 26727.80042788820},
	{0.00000000013, 0.63715146770, 11322.66409830440},
	{0.00000000010, 6.18169621500, 62389.09182935939},
	{0.00000000010, 0.83598356132, 52290.24557183361},
	{0.00000000012, 3.14290523608, 26514.50133245020},
	{0.00000000010, 3.11126287173, 35191.81013569180},
	{0.00000000009, 1.25757815859, 76044.95232053580},
	{0.00000000010, 2.52278705670, 15874.61759536320},
	{0.00000000010, 0.24410880924, 339142.74084046457},
	{0.00000000011, 3.00721890024, 38519.94579197200},
	{0.00000000009, 4.70984038054, 124778.18365871879},
	{0.00000000010, 2.93539474520, 25028.52121138500},
	{0.00000000009, 4.78186604625, 78244.03966382280},
	{0.00000000009, 4.66454207113, 52061.36699446317},
	{0.00000000009, 3.23143026804, 39609.65458316560},
	{0.00000000008, 4.04549915755, 2333.19639287200},
	{0.00000000008, 4.74485412331, 28206.66700195260},
	{0.00000000009, 2.19121952514, 104881.30353139139},
	{0.00000000008, 0.23967004017, 103396.01282468818},
	{0.00000000008, 0.37987106631, 136100.84775702319},
	{0.00000000009, 4.91595161990, 16983.99614745660},
	{0.00000000008, 0.60920060214, 79219.30916633119},
	{0.00000000009, 0.20735942028, 7994.52844202420},
	{0.00000000008, 0.45328868578, 12432.04265039780},
	{0.00000000008, 2.09461474144, 7238.67559160000},
	{0.00000000007, 2.36547832832, 69159.80243060499},
	{0.00000000007, 4.71531871147, 52168.69273614759},
	{0.00000000008, 6.19634687633, 63498.47038145279},
	{0.00000000007, 2.10610027970, 64741.95798313119},
	{0.00000000007, 1.85911354830, 78267.59076008058},
	{0.00000000008, 4.00207680038, 52182.91983014920},
	{0.00000000007, 5.23512171216, 18207.81398823521},
	{0.00000000006, 5.80443519678, 105410.99449648599},
	{0.00000000007, 6.15999622470, 51962.50718771040},
	{0.00000000008, 3.36914220367, 44937.13069154840},
	{0.00000000006, 2.40284625703, 129380.13377768178},
	{0.00000000005, 2.96155447733, 88476.99497093359},
	{0.00000000005, 3.59127862190, 25661.30495069820},
	{0.00000000006, 6.23825391056, 52602.40447402440},
	{0.00000000006, 2.93043859466, 78477.00852016058},
	{0.00000000006, 0.46188986304, 108903.56606335558},
	{0.00000000005, 0.49574606925, 33967.99229491319},
	{0.00000000005, 3.75441675157, 81706.28436968799},
	{0.00000000005, 5.53673433934, 94138.32702008578},
	{0.00000000005, 5.89664568761, 57837.13833230060},
	{0.00000000005, 4.83027667513, 74821.13447975718},
	{0.00000000007, 4.98545551601, 71492.99882347698},
	{0.00000000007, 3.70894912583, 78283.37918562238},
	{0.00000000005, 1.29964111137, 51322.60990139639},
	{0.00000000005, 2.49074669996, 68050.42387851159},
	{0.00000000006, 6.08348615777, 10213.28554621100},
	{0.00000000005, 3.82719391877, 105460.99111839019},
	{0.00000000005, 0.35178516619, 78259.82808936459},
	{0.00000000004, 1.30282358460, 78256.59587772179},
	{0.00000000006, 5.44757978079, 103292.23063610759},
	{0.00000000005, 5.27636599134, 51749.20809227239},
	{0.00000000005, 0.22804238075, 77734.01845962799},
	{0.00000000004, 6.06869194581, 64607.84893354619},
	{0.00000000004, 4.12693153599, 29416.03879785439},
	{0.00000000004, 1.53669349522, 22759.76748529401},
	{0.00000000005, 1.44239228085, 59414.48187474840},
	{0.00000000005, 5.48943391239, 93028.94846799239},
	{0.00000000004, 0.83479952169, 181505.94343892598},
	{0.00000000004, 3.69264490004, 79852.78232000639},
	{0.00000000004, 0.34140382701, 76144.94556434419},
	{0.00000000004, 0.76148268878, 77204.32749453338},
	{0.00000000004, 5.49142516376, 155468.03691925599},
	{0.00000000004, 2.40110600466, 32370.97899156560},
	{0.00000000004, 0.77482738791, 54509.00267602040},
	{0.00000000003, 3.42320644167, 162188.75089859738},
	{0.00000000005, 5.60476147871, 44181.27784112419},
	{0.00000000004, 0.72336948817, 78270.82297172339},
	{0.00000000004, 4.12628804953, 7880.08915333899},
	{0.00000000004, 3.98922640345, 80482.46652890938},
	{0.00000000004, 5.74841518024, 39743.76363275060},
	{0.00000000004, 5.69417470352, 13521.75144159140},
	{0.00000000003, 1.56317795942, 104331.94280539699},
	{0.00000000003, 4.88795554029, 125887.56221081219},
	{0.00000000003, 3.38935474258, 77623.81213840858},
	{0.00000000003, 3.77971209044, 25448.00585526019},
	{0.00000000004, 4.09930467385, 27311.72098235281},
	{0.00000000004, 1.56432035736, 24864.08530079559},
	{0.00000000003, 2.27664811174, 120226.23016165999},
	{0.00000000003, 1.92640543576, 99799.65906923798},
	{0.00000000003, 5.32912761349, 58458.88213313979},
	{0.00000000003, 5.99165196975, 73711.75592766379},
	{0.00000000003, 4.31843145830, 102132.85546210999},
	{0.00000000003, 3.24943700009, 129483.91596626239},
	{0.00000000003, 1.49035567017, 150866.08680029298},
	{0.00000000003, 5.13470741781, 90829.86112470538},
	{0.00000000003, 2.71986865181, 19804.82729158280},
	{0.00000000003, 2.81668831922, 103821.92160120218},
	{0.00000000003, 5.20351790812, 130969.20667296558},
	{0.00000000003, 0.52414566536, 6283.07584999140},
	{0.00000000002, 1.60034178501, 3328.13565628019},
	{0.00000000003, 1.19742120401, 26941.09952332620},
	{0.00000000002, 2.52299718299, 2648.45482547300},
	{0.00000000003, 6.22248876679, 71025.03383312259},
	{0.00000000002, 6.05228562355, 114564.89811250778},
	{0.00000000002, 3.89856574340, 78378.14871340781},
	{0.00000000003, 4.92249999513, 104355.49390165479},
	{0.00000000002, 3.28730608507, 365230.64398203876},
	{0.00000000003, 5.24274548309, 52815.70356946240},
	{0.00000000002, 2.84424981131, 77197.21394753258},
	{0.00000000002, 3.05496732731, 78690.30761559859},
	{0.00000000002, 0.47881810383, 104371.28232719658},
	{0.00000000002, 1.00755310729, 23969.13928119580},
	{0.00000000002, 2.35946048456, 77211.44104153418},
	{0.00000000002, 4.29749936450, 104344.49901929598},
	{0.00000000002, 0.09271854750, 41962.52073693740},
	{0.00000000002, 3.70310718037, 78050.41032928458},
	{0.00000000002, 3.18110797568, 25450.90686955000},
	{0.00000000002, 2.48251705553, 26724.89941359840},
	{0.00000000002, 1.75589608164, 97580.90196505119},
	{0.00000000002, 6.11482656755, 61279.71327726600},
	{0.00000000002, 2.56963368887, 131498.89763806018},
	{0.00000000002, 3.40296904568, 18093.37469954999},
	{0.00000000002, 1.43340926720, 78149.27013603736},
	{0.00000000002, 0.50955931589, 107794.18751126219},
	{0.00000000002, 6.01648265545, 104564.91166173479},
	{0.00000000002, 2.00949716011, 44295.71712980940},
	{0.00000000002, 3.78855559110, 104358.72611329758},
	{0.00000000002, 3.41504704768, 104347.73123093879},
	{0.00000000002, 3.50069323104, 134991.46920492979},
	{0.00000000002, 1.44523177132, 54294.57014352679},
	{0.00000000001, 1.57614797452, 151975.46535238638},
	{0.00000000002, 5.85569288704, 27154.39861876420},
	{0.00000000002, 5.60379556548, 129909.82474277639},
	{0.00000000001, 0.15538967236, 131548.89425996438},
	{0.00000000001, 0.13924678529, 117873.36400788819},
	{0.00000000001, 2.27107417680, 181555.94006083018},
	{0.00000000001, 3.46531620032, 91785.46086631398},
	{0.00000000001, 0.05177929477, 27140.17152476259},
	{0.00000000001, 1.89455753690, 84546.78527471398},
	{0.00000000001, 0.93976716900, 55503.94193942859},
	{0.00000000001, 5.89766230280, 103285.11708910679},
	{0.00000000001, 0.58625817603, 98068.53671630539},
	{0.00000000001, 3.67344922340, 105307.21230790539},
	{0.00000000001, 1.75668234959, 49842.60989027639},
	{0.00000000001, 0.18883482364, 188276.65404017158},
	{0.00000000001, 5.33421434440, 146314.13330323418},
	{0.00000000001, 4.05364019654, 65697.55772473979},
	{0.00000000001, 2.87996568466, 39629.32434406539},
	{0.00000000001, 2.78365934655, 12546.48193908300},
	{0.00000000001, 0.84435710644, 26080.78959457339},
	{0.00000000001, 4.96226105388, 29428.51556827400},
	{0.00000000001, 0.70136397733, 22747.29071487440},
	{0.00000000001, 4.58859350492, 48847.67062686820},
	{0.00000000001, 2.16941361108, 119116.85160956658},
	{0.00000000001, 2.45852813929, 25021.40766438420},
	{0.00000000001, 0.34446508161, 26107.57290247399},
	{0.00000000001, 1.69190197378, 26068.23338067440},
	{0.00000000001, 1.12310082033, 106570.36967048359},
	{0.00000000001, 2.51649409144, 65831.66677432480},
	{0.00000000001, 0.40144081264, 105940.68546158058},
	{0.00000000001, 0.86957384492, 53399.62412392700},
	{0.00000000001, 1.17409480348, 26095.01668857500},
	{0.00000000001, 3.82636106300, 80596.90581759460},
	{0.00000000001, 6.22213633631, 85034.42002596818},
	{0.00000000001, 3.81096263298, 71980.63357473118},
	{0.00000000001, 3.53258568663, 60055.89543648739},
	{0.00000000001, 5.03983679522, 26091.78447693220},
	{0.00000000001, 1.78390992735, 116917.76426627958},
	{0.00000000001, 3.13743037240, 49527.35145767539},
	{0.00000000001, 5.15447176594, 10021.83728009940},
	{0.00000000001, 3.66133486835, 52643.77127350280},
	{0.00000000001, 3.49839180322, 85502.38501632259},
	{0.00000000001, 3.27557007032, 26084.02180621620},
	{0.00000000001, 4.42760145944, 77410.51304297059},
	{0.00000000001, 5.34025826757, 35472.74414964940},
	{0.00000000001, 0.32336676364, 16703.06213349900},
	{0.00000000001, 0.29031592817, 86143.79857806159},
	{0.00000000001, 0.51202513196, 42153.96900304900},
	{0.00000000001, 5.64798496540, 51123.53789995999},
	{0.00000000001, 3.41816609617, 102762.53967101299},
	{0.00000000001, 2.14800633151, 95247.70557217918},
	{0.00000000001, 1.88367237285, 25035.63475838580},
	{0.00000000001, 5.42434479910, 103299.34418310839},
	{0.00000000000, 4.45904714857, 45892.73043315699},
	{0.00000000001, 6.03041944713, 7.11354700080},
	{0.00000000000, 3.24985330908, 111122.32316754239},
	{0.00000000000, 5.89247671933, 116783.65521669458},
	{0.00000000000, 0.08006879030, 1066.49547719000},
	{0.00000000000, 3.14877511767, 102232.84870591838},
	{0.00000000000, 5.43291689345, 77829.99768684579},
	{0.00000000000, 6.05247716942, 25654.19140369739},
	{0.00000000000, 2.64981425141, 53242.30176033840},
	{0.00000000000, 2.55379191250, 52329.58509363319},
	{0.00000000000, 0.09283328239, 89586.37352302698},
	{0.00000000000, 1.84786865421, 25234.70675982219},
	{0.00000000000, 2.90052187589, 97112.93697469679},
	{0.00000000000, 4.61352864146, 130419.84594697120},
	{0.00000000000, 3.88771739364, 207593.84658050018},
	{0.00000000000, 2.04823124840, 78903.60671103658},
	{0, 0, 0}
};

struct vsop87_term mercury_x3[] = {
	{0.00000046252, 3.14159265359, 0.00000000000},
	{0.00000017461, 5.90570575226, 78263.70942472259},
	{0.00000014855, 2.98081270061, 52175.80628314840},
	{0.00000010499, 2.65555597352, 104351.61256629678},
	{0.00000006474, 3.10442611992, 26087.90314157420},
	{0.00000004906, 5.70235297811, 130439.51570787099},
	{0.00000002012, 2.46917870918, 156527.41884944518},
	{0.00000000762, 5.52012723644, 182615.32199101939},
	{0.00000000274, 2.28815108376, 208703.22513259358},
	{0.00000000095, 5.33930475465, 234791.12827416777},
	{0.00000000032, 2.10881559249, 260879.03141574195},
	{0.00000000022, 2.85958066164, 51066.42773105500},
	{0.00000000013, 5.91413101289, 77154.33087262919},
	{0.00000000011, 5.83933103010, 53285.18483524180},
	{0.00000000010, 5.15754613710, 286966.93455731616},
	{0.00000000006, 2.68531623603, 103242.23401420339},
	{0.00000000004, 2.63984308882, 79373.08797681599},
	{0.00000000003, 1.92882196964, 313054.83769889036},
	{0.00000000002, 5.74038187507, 129330.13715577759},
	{0.00000000002, 0.30227695595, 46514.47423399620},
	{0.00000000001, 3.30055357539, 72602.37737557039},
	{0.00000000001, 2.98533044655, 1109.37855209340},
	{0.00000000001, 5.48949174205, 51220.20654153979},
	{0.00000000001, 4.41669314602, 53235.18821333759},
	{0.00000000001, 0.98973080298, 52705.49724824299},
	{0.00000000001, 0.09996351935, 98690.28051714458},
	{0.00000000001, 1.39499754575, 27147.28507176339},
	{0.00000000001, 2.15405026353, 77308.10968311399},
	{0.00000000001, 5.60478475476, 30639.85663863300},
	{0.00000000001, 2.92719149168, 49957.04917896160},
	{0.00000000001, 2.85009909224, 53131.40602475700},
	{0.00000000001, 4.09987056849, 40853.14218484400},
	{0.00000000001, 4.98078848335, 339142.74084046457},
	{0.00000000001, 5.36230089957, 56727.75978020720},
	{0.00000000001, 5.71989825863, 105460.99111839019},
	{0.00000000001, 2.51473977978, 155418.04029735178},
	{0.00000000001, 1.04369278317, 25028.52121138500},
	{0.00000000001, 4.01223445079, 78793.40038981718},
	{0.00000000001, 1.01751150860, 79323.09135491178},
	{0.00000000000, 1.30980510467, 51646.11531805379},
	{0.00000000000, 2.55596806448, 27676.97603685800},
	{0.00000000001, 2.24540131361, 24978.52458948080},
	{0.00000000001, 5.75115503305, 54394.56338733519},
	{0.00000000000, 0.38100437824, 45405.09568190280},
	{0.00000000000, 2.12401299269, 82815.66292178139},
	{0.00000000000, 2.55683513716, 27197.28169366760},
	{0.00000000000, 2.64992114042, 4551.95349705880},
	{0.00000000000, 0.83114621691, 20426.57109242200},
	{0.00000000000, 5.51088661461, 5661.33204915220},
	{0.00000000000, 5.92904258214, 76674.63652943878},
	{0.00000000000, 0.30779797419, 24498.83024629040},
	{0.00000000000, 0.88049716681, 66941.04532641819},
	{0.00000000000, 3.47000316143, 23869.14603738740},
	{0.00000000000, 5.99203553905, 76044.95232053580},
	{0, 0, 0}
};

struct vsop87_term mercury_x4[] = {
	{0.00000000396, 3.14159265359, 0.00000000000},
	{0.00000000277, 4.46911521792, 78263.70942472259},
	{0.00000000233, 1.15859255567, 104351.61256629678},
	{0.00000000175, 1.69697731540, 52175.80628314840},
	{0.00000000142, 4.18294832661, 130439.51570787099},
	{0.00000000072, 0.93996426089, 156527.41884944518},
	{0.00000000034, 2.12555294236, 26087.90314157420},
	{0.00000000032, 3.98624643079, 182615.32199101939},
	{0.00000000014, 0.75012775830, 208703.22513259358},
	{0.00000000005, 3.79721330106, 234791.12827416777},
	{0.00000000002, 0.56145150603, 260879.03141574195},
	{0.00000000001, 3.61220093194, 286966.93455731616},
	{0.00000000000, 4.34124968448, 77154.33087262919},
	{0.00000000000, 1.17335789419, 51066.42773105500},
	{0.00000000000, 4.21582355257, 53285.18483524180},
	{0, 0, 0}
};

struct vsop87_term mercury_x5[] = {
	{0.00000000010, 0.00000000000, 0.00000000000},
	{0.00000000004, 5.91649200666, 104351.61256629678},
	{0.00000000004, 2.83757947000, 78263.70942472259},
	{0.00000000003, 2.66817005051, 130439.51570787099},
	{0.00000000003, 5.15477008535, 52175.80628314840},
	{0.00000000002, 5.69794729891, 156527.41884944518},
	{0.00000000002, 6.20347759900, 26087.90314157420},
	{0.00000000001, 2.45874789246, 182615.32199101939},
	{0.00000000001, 5.48978296351, 208703.22513259358},
	{0.00000000000, 2.24360021689, 234791.12827416777},
	{0, 0, 0}
};

struct vsop87_term mercury_y0[] = {
	{0.37953642888, 2.83780617820, 26087.90314157420},
	{0.11626131831, 3.14159265359, 0.00000000000},
	{0.03854668215, 5.88780608966, 52175.80628314840},
	{0.00587711268, 2.65498896201, 78263.70942472259},
	{0.00106235493, 5.70550616735, 104351.61256629678},
	{0.00021100828, 2.47291315849, 130439.51570787099},
	{0.00004450056, 5.52354907071, 156527.41884944518},
	{0.00000978286, 2.29102643026, 182615.32199101939},
	{0.00000707500, 2.89516591531, 24978.52458948080},
	{0.00000654742, 5.92892123881, 27197.28169366760},
	{0.00000448561, 1.40595042211, 1059.38193018920},
	{0.00000402168, 0.30317998006, 20426.57109242200},
	{0.00000290604, 2.23645868392, 31749.23519072640},
	{0.00000191358, 2.70792842547, 53285.18483524180},
	{0.00000181119, 0.23941291054, 1109.37855209340},
	{0.00000193372, 5.38698781997, 4551.95349705880},
	{0.00000221718, 5.34170676570, 208703.22513259358},
	{0.00000139514, 5.94698662319, 51066.42773105500},
	{0.00000154924, 1.12201865761, 51116.42435295920},
	{0.00000177242, 2.78855813429, 5661.33204915220},
	{0.00000116072, 5.28608170116, 57837.13833230060},
	{0.00000081399, 3.50862797958, 21535.94964451540},
	{0.00000086595, 5.06999843254, 529.69096509460},
	{0.00000075457, 4.50396814445, 27147.28507176339},
	{0.00000075078, 3.36291170975, 46514.47423399620},
	{0.00000069045, 4.92160428335, 25132.30339996560},
	{0.00000063460, 3.91239075334, 27043.50288318280},
	{0.00000083250, 1.60127885818, 10213.28554621100},
	{0.00000058160, 4.13677602210, 14765.23904326980},
	{0.00000061405, 3.43747372432, 47623.85278608960},
	{0.00000054050, 0.72631991357, 26617.59410666880},
	{0.00000055113, 3.74298611127, 12566.15169998280},
	{0.00000052556, 1.98636705426, 25558.21217647960},
	{0.00000047932, 5.76195364026, 79373.08797681599},
	{0.00000051303, 1.96782292508, 426.59819087600},
	{0.00000051435, 2.10921381130, 234791.12827416777},
	{0.00000048521, 1.95016897012, 1589.07289528380},
	{0.00000049166, 4.17094551348, 77204.32749453338},
	{0.00000035132, 4.11987679873, 51646.11531805379},
	{0.00000035814, 4.73966512079, 37410.56723987860},
	{0.00000032754, 4.57352694115, 955.59974160860},
	{0.00000045435, 0.91835136158, 41962.52073693740},
	{0.00000028902, 5.43922975997, 30639.85663863300},
	{0.00000031572, 2.71470274369, 77154.33087262919},
	{0.00000032251, 2.05357225780, 83925.04147387479},
	{0.00000028206, 5.07338603494, 39609.65458316560},
	{0.00000026848, 5.25320670297, 11322.66409830440},
	{0.00000027077, 4.69298133865, 36301.18868778519},
	{0.00000022896, 0.71333836963, 53131.40602475700},
	{0.00000026742, 0.17305422750, 6283.07584999140},
	{0.00000021009, 4.08684580221, 15874.61759536320},
	{0.00000016503, 0.13257325259, 72602.37737557039},
	{0.00000016125, 1.65667771920, 9103.90699411760},
	{0.00000021011, 5.65119092880, 13521.75144159140},
	{0.00000021301, 0.20534560769, 73711.75592766379},
	{0.00000015173, 1.24810995296, 18849.22754997420},
	{0.00000017483, 0.56186392439, 51749.20809227239},
	{0.00000017112, 0.55137156527, 50586.73338786459},
	{0.00000013891, 1.29665748792, 53235.18821333759},
	{0.00000015079, 1.97879118551, 7238.67559160000},
	{0.00000013631, 3.65214684654, 52705.49724824299},
	{0.00000014545, 1.48385300876, 63498.47038145279},
	{0.00000012963, 4.18911929952, 25028.52121138500},
	{0.00000013152, 0.21408490669, 26068.23338067440},
	{0.00000013131, 2.31994193470, 26107.57290247399},
	{0.00000013657, 1.69271280727, 51220.20654153979},
	{0.00000013598, 0.93759628331, 103292.23063610759},
	{0.00000011751, 1.43132876728, 33326.57873317420},
	{0.00000012154, 5.15990276384, 260879.03141574195},
	{0.00000011477, 0.41407124478, 19317.19254032860},
	{0.00000010236, 0.82838354702, 77734.01845962799},
	{0.00000012081, 3.96948779355, 68050.42387851159},
	{0.00000012108, 2.53182219980, 105460.99111839019},
	{0.00000009243, 0.91470178389, 40853.14218484400},
	{0.00000009577, 0.54300980490, 38654.05484155699},
	{0.00000012617, 2.32903972631, 45892.73043315699},
	{0.00000009024, 3.62265462866, 26091.78447693220},
	{0.00000009026, 5.19456413590, 26084.02180621620},
	{0.00000012253, 1.84260347906, 65697.55772473979},
	{0.00000008921, 2.21279123795, 32858.61374281979},
	{0.00000008903, 5.05278309499, 26514.50133245020},
	{0.00000008904, 5.46086574052, 3442.57494496540},
	{0.00000008277, 0.97930362795, 43071.89928903080},
	{0.00000008532, 5.10423076286, 110012.94461544899},
	{0.00000008865, 3.30085475170, 32370.97899156560},
	{0.00000007700, 2.17157469442, 56727.75978020720},
	{0.00000008182, 5.04279721089, 27676.97603685800},
	{0.00000007388, 2.71311941898, 6770.71060124560},
	{0.00000008021, 5.76384193035, 213.29909543800},
	{0.00000006447, 1.30219534399, 16983.99614745660},
	{0.00000007443, 2.98224053647, 23869.14603738740},
	{0.00000006952, 3.42284499782, 22645.32819660879},
	{0.00000006607, 5.48986631078, 19804.82729158280},
	{0.00000006015, 1.47698341146, 62389.09182935939},
	{0.00000006309, 4.44334031620, 59414.48187474840},
	{0.00000005925, 3.77454325940, 79219.30916633119},
	{0.00000007571, 5.76555894291, 103242.23401420339},
	{0.00000006092, 3.25705731504, 99799.65906923798},
	{0.00000006562, 5.86248316518, 28306.66024576099},
	{0.00000006285, 1.17813289842, 639.89728631400},
	{0.00000005895, 3.66873787385, 25874.60404613620},
	{0.00000005168, 5.05804995902, 26301.20223701220},
	{0.00000004714, 2.54429045075, 26095.01668857500},
	{0.00000004577, 0.02129879069, 26080.78959457339},
	{0.00000005517, 3.60620866320, 76674.63652943878},
	{0.00000003908, 3.18519537351, 98690.28051714458},
	{0.00000005385, 3.61083679851, 77837.11123384659},
	{0.00000003644, 3.98783714230, 129380.13377768178},
	{0.00000003338, 0.38724993766, 78793.40038981718},
	{0.00000003316, 5.12183457548, 58946.51688439399},
	{0.00000003962, 5.48363213369, 29530.47808653960},
	{0.00000004028, 2.49396327752, 2118.76386037840},
	{0.00000003629, 4.89385319464, 91785.46086631398},
	{0.00000003068, 4.35775545042, 79323.09135491178},
	{0.00000003499, 5.38046448626, 71980.63357473118},
	{0.00000003105, 0.73732898186, 94138.32702008578},
	{0.00000002915, 1.92745964306, 286966.93455731616},
	{0.00000003797, 4.52469688488, 89586.37352302698},
	{0.00000002737, 4.31987616717, 44937.13069154840},
	{0.00000002736, 3.85841365012, 103821.92160120218},
	{0.00000002692, 3.89664472121, 69159.80243060499},
	{0.00000002670, 3.26411796271, 52156.13652224860},
	{0.00000003234, 0.15700821776, 2218.75710418680},
	{0.00000002946, 3.91413787998, 25661.30495069820},
	{0.00000003275, 1.14799205324, 25934.12433108940},
	{0.00000003246, 1.38661008976, 26241.68195205900},
	{0.00000002559, 3.49987927726, 48733.23133818299},
	{0.00000003095, 4.74440359796, 77308.10968311399},
	{0.00000003103, 5.58481290362, 131548.89425996438},
	{0.00000002736, 4.90415740433, 149.56319713460},
	{0.00000002487, 1.54879706016, 1052.26838318840},
	{0.00000002690, 5.37064066297, 52195.47604404819},
	{0.00000002237, 1.87187835709, 136100.84775702319},
	{0.00000001979, 3.60257646907, 64741.95798313119},
	{0.00000002537, 4.45007627900, 1066.49547719000},
	{0.00000001955, 0.11915602691, 58458.88213313979},
	{0.00000001882, 5.21113955797, 82815.66292178139},
	{0.00000001838, 0.38908718331, 52179.68761850640},
	{0.00000001842, 3.96594806805, 66941.04532641819},
	{0.00000001788, 0.37792450541, 25619.93815121980},
	{0.00000001833, 1.96136353630, 52171.92494779040},
	{0.00000002202, 2.59644390666, 54394.56338733519},
	{0.00000001723, 2.15586269154, 26555.86813192860},
	{0.00000002138, 1.35105904779, 51535.90899683439},
	{0.00000001978, 3.47172854103, 45405.09568190280},
	{0.00000001647, 1.83531703242, 52602.40447402440},
	{0.00000001665, 2.25971262112, 5327.47610838280},
	{0.00000001935, 4.21959122354, 13655.86049117640},
	{0.00000001817, 0.28147419437, 7.11354700080},
	{0.00000001660, 0.02502133169, 125887.56221081219},
	{0.00000001521, 1.83104073509, 53764.87917843220},
	{0.00000001874, 2.53319058791, 129330.13715577759},
	{0.00000001692, 2.75833415261, 52168.69273614759},
	{0.00000001454, 4.53754269661, 88476.99497093359},
	{0.00000001657, 4.55762528747, 76.26607127560},
	{0.00000001539, 0.55256735058, 105307.21230790539},
	{0.00000001549, 0.39789620728, 102762.53967101299},
	{0.00000001408, 2.83687387786, 26094.53170047421},
	{0.00000001408, 5.98015898835, 26081.27458267419},
	{0.00000001420, 6.03495956591, 49957.04917896160},
	{0.00000001561, 1.18454524473, 85502.38501632259},
	{0.00000001272, 2.51538497151, 51962.50718771040},
	{0.00000001469, 0.37777284264, 103925.01437542078},
	{0.00000001565, 6.24937013327, 6681.22485339960},
	{0.00000001264, 4.66222164975, 35191.81013569180},
	{0.00000001342, 4.75750445244, 38519.94579197200},
	{0.00000001441, 6.24581101364, 50057.04242277000},
	{0.00000001556, 1.87102996187, 52389.10537858640},
	{0.00000001106, 5.15222384273, 12432.04265039780},
	{0.00000001243, 5.56004522021, 52182.91983014920},
	{0.00000001072, 4.25942542568, 26727.80042788820},
	{0.00000000967, 0.75487021033, 155468.03691925599},
	{0.00000000997, 1.66157901963, 117873.36400788819},
	{0.00000000937, 2.00054583710, 85034.42002596818},
	{0.00000000960, 6.23663722276, 124778.18365871879},
	{0.00000000913, 2.14759141886, 98068.53671630539},
	{0.00000000837, 0.48875422450, 46848.33017476560},
	{0.00000000832, 3.42202735905, 104881.30353139139},
	{0.00000000864, 0.97123767041, 51123.53789995999},
	{0.00000000797, 3.78730285311, 120226.23016165999},
	{0.00000000923, 3.90587740343, 52026.24308601380},
	{0.00000000938, 1.28285332683, 115674.27666460119},
	{0.00000000746, 0.02765328657, 74821.13447975718},
	{0.00000000936, 2.24023772681, 55618.38122811380},
	{0.00000000804, 2.35412750829, 157636.79740153858},
	{0.00000000708, 4.97835058075, 313054.83769889036},
	{0.00000000726, 1.13072864457, 105410.99449648599},
	{0.00000000875, 4.36192286909, 51109.31080595839},
	{0.00000000719, 0.61492825170, 129909.82474277639},
	{0.00000000703, 5.24980293056, 419.48464387520},
	{0.00000000742, 4.43954042629, 3340.61242669980},
	{0.00000000675, 5.58413863440, 28206.66700195260},
	{0.00000000650, 0.63237258720, 95247.70557217918},
	{0.00000000610, 0.03146551062, 78244.03966382280},
	{0.00000000663, 4.19794322902, 52022.02747266360},
	{0.00000000602, 0.71110689228, 20760.42703319140},
	{0.00000000639, 5.76187724040, 80482.46652890938},
	{0.00000000743, 1.51241001220, 103396.01282468818},
	{0.00000000586, 4.92207524971, 162188.75089859738},
	{0.00000000731, 1.85044743030, 433.71173787680},
	{0.00000000592, 1.09214531526, 71025.03383312259},
	{0.00000000551, 3.29395183970, 23754.70674870219},
	{0.00000000526, 0.65987913797, 10021.83728009940},
	{0.00000000677, 4.43410327506, 52329.58509363319},
	{0.00000000666, 4.40151837219, 77623.81213840858},
	{0.00000000644, 2.58708081761, 45494.58142974879},
	{0.00000000596, 1.74322610176, 7994.52844202420},
	{0.00000000558, 4.25198337310, 52099.54021187280},
	{0.00000000467, 3.18899512617, 84546.78527471398},
	{0.00000000464, 3.48448266155, 24498.83024629040},
	{0.00000000555, 0.82693925421, 1692.16566950240},
	{0.00000000471, 1.72510786190, 26237.46633870879},
	{0.00000000456, 0.37602833213, 90829.86112470538},
	{0.00000000617, 2.13813397736, 78283.37918562238},
	{0.00000000442, 4.70125751809, 27140.17152476259},
	{0.00000000445, 3.07523267609, 151975.46535238638},
	{0.00000000473, 5.58382968969, 155418.04029735178},
	{0.00000000470, 1.97509785099, 108903.56606335558},
	{0.00000000449, 5.76009397500, 78256.59587772179},
	{0.00000000592, 0.36143126121, 853.19638175200},
	{0.00000000459, 0.44821212178, 26037.90651966999},
	{0.00000000439, 0.74557141998, 29428.51556827400},
	{0.00000000459, 2.08602741390, 26137.89976347840},
	{0.00000000441, 5.55002400505, 2333.19639287200},
	{0.00000000420, 3.46875832008, 128850.44281258718},
	{0.00000000406, 0.99733773104, 1581.95934828300},
	{0.00000000406, 5.56438736356, 28421.09953444620},
	{0.00000000515, 5.53709511500, 26720.68688088739},
	{0.00000000420, 3.43880146473, 78267.59076008058},
	{0.00000000457, 4.25870257295, 25984.81036735560},
	{0.00000000409, 1.89235979066, 22747.29071487440},
	{0.00000000441, 5.74769719365, 78050.41032928458},
	{0.00000000460, 4.60455680282, 26190.99591579279},
	{0.00000000428, 1.26561734018, 27154.39861876420},
	{0.00000000533, 3.36410465544, 25455.11940226100},
	{0.00000000422, 0.73875718620, 93028.94846799239},
	{0.00000000490, 3.02631541744, 76144.94556434419},
	{0.00000000390, 3.42688671619, 130012.91751699499},
	{0.00000000364, 4.89106808289, 78690.30761559859},
	{0.00000000361, 1.30246090918, 114564.89811250778},
	{0.00000000356, 5.20137348148, 52643.77127350280},
	{0.00000000419, 5.01120890083, 78259.82808936459},
	{0.00000000395, 4.93033073834, 78477.00852016058},
	{0.00000000337, 4.88969069715, 79852.78232000639},
	{0.00000000364, 4.51546243970, 48835.19385644859},
	{0.00000000336, 0.50294839757, 18207.81398823521},
	{0.00000000317, 2.80195601464, 76044.95232053580},
	{0.00000000402, 3.61219119527, 131395.11544947959},
	{0.00000000302, 3.06677264697, 25973.46385288896},
	{0.00000000300, 5.73869132813, 26202.34243025941},
	{0.00000000418, 0.23893690129, 71492.99882347698},
	{0.00000000362, 4.00328511109, 25565.32572348040},
	{0.00000000412, 4.97023785153, 1596.18644228460},
	{0.00000000287, 5.88293841172, 52182.43484204840},
	{0.00000000356, 1.08678100754, 64607.84893354619},
	{0.00000000304, 3.41461416241, 51707.84129279399},
	{0.00000000289, 1.38259428580, 26164.16921284980},
	{0.00000000331, 4.78176305377, 26610.48055966799},
	{0.00000000379, 2.01230891559, 26162.68474014150},
	{0.00000000369, 4.21106702409, 111590.28815789679},
	{0.00000000269, 4.70967571334, 143961.26714946238},
	{0.00000000303, 1.01901288426, 224.34479570190},
	{0.00000000268, 1.81712028026, 42153.96900304900},
	{0.00000000304, 4.67005655250, 25448.00585526019},
	{0.00000000361, 0.50112315849, 26013.12154300690},
	{0.00000000256, 3.80003583229, 181555.94006083018},
	{0.00000000275, 5.82016920298, 956.28915597060},
	{0.00000000273, 5.09640213545, 111122.32316754239},
	{0.00000000326, 0.96777570631, 44181.27784112419},
	{0.00000000246, 3.27375223453, 51756.32163927320},
	{0.00000000330, 0.00798707088, 25771.51127191760},
	{0.00000000287, 2.74227004893, 52169.17772424839},
	{0.00000000292, 6.15601792690, 1162.47470440780},
	{0.00000000310, 4.06618330246, 632.78373931320},
	{0.00000000329, 2.52774260295, 26404.29501123080},
	{0.00000000237, 5.19825257378, 124156.43985787958},
	{0.00000000270, 2.17478042507, 33967.99229491319},
	{0.00000000308, 2.31701247486, 78270.82297172339},
	{0.00000000252, 5.43206013202, 25668.41849769900},
	{0.00000000232, 1.16243057531, 536.80451209540},
	{0.00000000276, 4.02093667465, 77211.44104153418},
	{0.00000000280, 1.12656118140, 77197.21394753258},
	{0.00000000261, 2.91718305686, 32769.12799497380},
	{0.00000000282, 3.10618381920, 26507.38778544939},
	{0.00000000226, 3.21437416344, 100909.03762133139},
	{0.00000000301, 3.03205392988, 2648.45482547300},
	{0.00000000214, 5.24868357305, 1478.86657406440},
	{0.00000000285, 1.16645481114, 18093.37469954999},
	{0.00000000210, 4.64797028936, 74.78159856730},
	{0.00000000231, 4.32501953451, 141762.17980617538},
	{0.00000000208, 0.53974604249, 146314.13330323418},
	{0.00000000275, 2.92194964370, 19406.67828817460},
	{0.00000000215, 3.07194607878, 72936.23331633979},
	{0.00000000241, 3.00041465942, 150866.08680029298},
	{0.00000000210, 5.40180831849, 183724.70054311278},
	{0.00000000280, 0.67080969267, 78114.14622758799},
	{0.00000000266, 0.99085054170, 39743.76363275060},
	{0.00000000211, 0.17681817187, 130969.20667296558},
	{0.00000000244, 5.94815635837, 11610.55195837420},
	{0.00000000204, 3.19846374771, 40565.25432477420},
	{0.00000000223, 5.28159723194, 81706.28436968799},
	{0.00000000197, 1.04277639896, 52815.70356946240},
	{0.00000000210, 5.55248384993, 110.20632121940},
	{0.00000000249, 5.60231399902, 71582.48457132299},
	{0.00000000249, 5.36588348601, 522.57741809380},
	{0.00000000204, 0.78597046714, 25881.71759313700},
	{0.00000000248, 0.67786738916, 51742.09454527159},
	{0.00000000201, 1.71510524072, 26294.08869001139},
	{0.00000000186, 2.14393493086, 16066.06586147480},
	{0.00000000233, 2.62533762305, 7880.08915333899},
	{0.00000000181, 3.52971486811, 14477.35118320000},
	{0.00000000208, 4.24178638905, 1375.77379984580},
	{0.00000000175, 5.68870918967, 51543.02254383520},
	{0.00000000174, 1.73818712188, 339142.74084046457},
	{0.00000000184, 4.55500539385, 129483.91596626239},
	{0.00000000184, 1.16335036072, 103711.71527998279},
	{0.00000000195, 1.69401523663, 50483.64061364600},
	{0.00000000191, 3.65375892828, 155997.72788435058},
	{0.00000000156, 4.67130228846, 90695.75207512038},
	{0.00000000174, 0.99979811068, 25938.33994443960},
	{0.00000000153, 0.95690434145, 78109.93061423779},
	{0.00000000155, 1.68645428840, 188276.65404017158},
	{0.00000000178, 4.17805845892, 131498.89763806018},
	{0.00000000157, 1.36959583051, 61279.71327726600},
	{0.00000000165, 2.17592149563, 467.96499035440},
	{0.00000000201, 2.16052573018, 51322.60990139639},
	{0.00000000177, 3.62256077196, 26624.70765366959},
	{0.00000000169, 3.68765594503, 121335.60871375339},
	{0.00000000154, 3.71172436062, 52101.02468458109},
	{0.00000000148, 3.07726125475, 104331.94280539699},
	{0.00000000141, 1.50870150844, 50593.84693486539},
	{0.00000000158, 1.19202527109, 78417.48823520739},
	{0.00000000144, 2.36390617422, 106570.36967048359},
	{0.00000000141, 0.89841562130, 52278.89905736699},
	{0.00000000163, 5.63284948646, 25780.34552060460},
	{0.00000000134, 3.07482380747, 22759.76748529401},
	{0.00000000161, 3.16796063002, 26395.46076254379},
	{0.00000000150, 5.18410766275, 104371.28232719658},
	{0.00000000168, 3.63358402936, 103.09277421860},
	{0.00000000140, 6.13152525193, 102232.84870591838},
	{0.00000000147, 2.51789010019, 23888.81579828719},
	{0.00000000127, 2.36011326038, 54294.57014352679},
	{0.00000000141, 2.25597418479, 52808.59002246159},
	{0.00000000173, 1.01540755996, 78187.44335344699},
	{0.00000000119, 6.12399199517, 178063.36849396059},
	{0.00000000122, 2.34676419834, 181505.94343892598},
	{0.00000000151, 1.37299401445, 13362.44970679920},
	{0.00000000157, 5.28735408136, 25551.09862947879},
	{0.00000000123, 0.96970788409, 52072.71350892979},
	{0.00000000139, 4.14216887691, 97112.93697469679},
	{0.00000000128, 4.93461808532, 26521.61487945100},
	{0.00000000116, 2.49690552706, 104344.49901929598},
	{0.00000000114, 0.24802201171, 154938.34595416138},
	{0.00000000115, 5.79810804423, 29416.03879785439},
	{0.00000000115, 6.24514589647, 110634.68841628819},
	{0.00000000110, 4.82546925433, 68241.87214462319},
	{0.00000000112, 0.79767917933, 24176.70365835700},
	{0.00000000115, 5.52737393321, 25754.04720080480},
	{0.00000000113, 3.27781553156, 26421.75908234360},
	{0.00000000145, 3.81995922658, 50579.61984086379},
	{0.00000000105, 0.18392017096, 156100.82065856918},
	{0.00000000104, 2.59023526043, 26198.10946279360},
	{0.00000000122, 6.27846196005, 28286.99048486120},
	{0.00000000111, 3.42525009396, 116917.76426627958},
	{0.00000000115, 1.34072654703, 26011.63707029860},
	{0.00000000112, 1.57964254375, 51639.00177105299},
	{0.00000000103, 1.26476363927, 74923.09699802278},
	{0.00000000100, 3.81573971334, 25035.63475838580},
	{0.00000000101, 1.80630451732, 27999.10262479140},
	{0.00000000097, 3.56860113068, 323.50541665740},
	{0.00000000100, 1.69912254726, 104564.91166173479},
	{0.00000000129, 2.55737037120, 104138.31347085879},
	{0.00000000099, 5.11520176982, 31415.37924995700},
	{0.00000000119, 5.01902877668, 134991.46920492979},
	{0.00000000110, 4.87500455770, 24356.78078864160},
	{0.00000000131, 1.06726827836, 647.01083331480},
	{0.00000000107, 3.72516243793, 55516.41870984820},
	{0.00000000094, 2.32320888992, 54509.00267602040},
	{0.00000000094, 3.49259349841, 52125.80966124419},
	{0.00000000103, 1.50774531093, 51951.46148744649},
	{0.00000000095, 1.91538502113, 742.99006053260},
	{0.00000000103, 3.43765189240, 26941.09952332620},
	{0.00000000094, 3.91518615306, 27780.06881107659},
	{0.00000000102, 0.20220739054, 104355.49390165479},
	{0.00000000108, 5.64358884743, 49527.35145767539},
	{0.00000000087, 4.80227955082, 52325.36948028299},
	{0.00000000097, 2.98258829049, 51219.51712717779},
	{0.00000000102, 5.09206185737, 52250.58788171570},
	{0.00000000092, 4.35841484859, 140652.80125408198},
	{0.00000000107, 0.38517739982, 157483.01859105378},
	{0.00000000090, 3.67394196940, 36109.74042167360},
	{0.00000000100, 3.93901407412, 27819.02549450680},
	{0.00000000086, 1.50847151211, 53228.07466633679},
	{0.00000000088, 3.14925830025, 52065.59996192899},
	{0.00000000099, 3.28990595710, 97580.90196505119},
	{0.00000000102, 5.08658507796, 52225.80290505260},
	{0.00000000087, 1.65916392662, 104778.21075717278},
	{0.00000000096, 1.03224594955, 38813.35657634920},
	{0.00000000081, 6.20215025642, 25977.69682035479},
	{0.00000000083, 1.97230419758, 78731.67441507700},
	{0.00000000100, 3.78538237499, 119116.85160956658},
	{0.00000000094, 3.01992291922, 51859.41441349179},
	{0.00000000081, 4.33788649947, 53242.30176033840},
	{0.00000000081, 1.65998131052, 105940.68546158058},
	{0.00000000077, 5.85420580120, 102132.85546210999},
	{0.00000000091, 2.66548595290, 51013.33157874059},
	{0.00000000089, 0.95977221728, 137678.19129947099},
	{0.00000000094, 1.39579973847, 2221.85663459700},
	{0.00000000076, 0.07242308044, 3328.13565628019},
	{0.00000000078, 4.80022000976, 60055.89543648739},
	{0.00000000085, 1.29757029645, 12725.45343477500},
	{0.00000000090, 5.56852789130, 52492.19815280499},
	{0.00000000089, 2.43562167097, 1911.19948321720},
	{0.00000000073, 3.57598233076, 50696.93970908399},
	{0.00000000076, 6.27731427042, 52595.29092702359},
	{0.00000000102, 1.77465769367, 104347.73123093879},
	{0.00000000072, 1.47416335611, 170049.17029103659},
	{0.00000000079, 4.16366799640, 103285.11708910679},
	{0.00000000076, 0.08688140800, 77844.22478084739},
	{0.00000000095, 1.56604928496, 52698.38370124219},
	{0.00000000073, 1.11932970193, 25021.40766438420},
	{0.00000000078, 5.36472752861, 104358.72611329758},
	{0.00000000068, 3.11461030341, 206.18554843720},
	{0.00000000072, 2.40806201062, 24998.19435038059},
	{0.00000000071, 4.11293729141, 27669.86248985719},
	{0.00000000074, 5.08891807794, 26222.01219115920},
	{0.00000000079, 3.71784757916, 104202.04936916218},
	{0.00000000067, 2.65457842453, 78270.33798362259},
	{0.00000000080, 6.13936658892, 8194.27533320860},
	{0.00000000073, 3.70705736171, 25953.79409198919},
	{0.00000000074, 2.34582989695, 97670.38771289718},
	{0.00000000069, 0.57091762082, 207643.84320240439},
	{0.00000000065, 4.30219875903, 12546.48193908300},
	{0.00000000071, 0.07238150577, 126996.94076290558},
	{0.00000000066, 3.25393240581, 70269.18098269838},
	{0.00000000079, 2.22876948108, 25446.48957983520},
	{0.00000000063, 1.94299439248, 150244.34299945379},
	{0.00000000066, 1.24367311450, 2111.65031337760},
	{0.00000000078, 3.71442447350, 77829.99768684579},
	{0.00000000081, 3.57966030338, 49842.60989027639},
	{0.00000000062, 2.82688841358, 846.08283475120},
	{0.00000000071, 1.76878466162, 27684.08958385880},
	{0.00000000065, 0.10862838701, 27177.61193276780},
	{0.00000000077, 0.29329825954, 26729.31670331319},
	{0.00000000082, 4.87562280261, 26089.38761428249},
	{0.00000000076, 1.87316011759, 137210.22630911658},
	{0.00000000071, 3.36184821357, 17893.62780836560},
	{0.00000000063, 2.50604307758, 52290.24557183361},
	{0.00000000060, 6.11673834767, 52061.36699446317},
	{0.00000000081, 3.95123901433, 26086.41866886590},
	{0.00000000072, 4.57323993670, 50800.03248330259},
	{0.00000000066, 0.09493437207, 2008.55753915900},
	{0.00000000077, 0.77427822658, 103299.34418310839},
	{0.00000000058, 1.07510302489, 167850.08294774959},
	{0.00000000071, 5.75558240346, 34282.17847478280},
	{0.00000000056, 3.55494344576, 44295.71712980940},
	{0.00000000055, 5.96851303023, 23969.13928119580},
	{0.00000000055, 2.16330884790, 209812.60368468695},
	{0.00000000065, 5.22228985131, 77410.51304297059},
	{0.00000000058, 6.25432646821, 25508.21555457540},
	{0.00000000056, 3.84165768987, 22625.65843570900},
	{0.00000000054, 4.44808157827, 52252.07235442399},
	{0.00000000055, 2.05172474251, 107794.18751126219},
	{0.00000000066, 0.18130668165, 77795.74443436819},
	{0.00000000068, 2.93375218430, 19.66976089979},
	{0.00000000055, 3.59336928200, 172402.03644480839},
	{0.00000000056, 3.42328370031, 24448.83362438620},
	{0.00000000073, 3.18180022689, 24864.08530079559},
	{0.00000000052, 4.91273220472, 66653.15746634839},
	{0.00000000053, 4.10843855595, 26312.24793727610},
	{0.00000000054, 2.57050838382, 26667.59072857300},
	{0.00000000068, 0.06574276360, 2199.08734328700},
	{0.00000000049, 1.03606235160, 96357.08412427259},
	{0.00000000051, 5.94534572630, 58857.03113654799},
	{0.00000000068, 5.79687331046, 78257.08086582259},
	{0.00000000050, 4.20409547221, 129799.61842155698},
	{0.00000000049, 2.61342795296, 27044.19229754480},
	{0.00000000062, 3.64195225027, 38.13303563780},
	{0.00000000051, 5.36138555309, 27726.97265876220},
	{0.00000000048, 6.03611290368, 99024.13645791399},
	{0.00000000047, 4.10470299674, 51969.62073471119},
	{0.00000000049, 2.30004526739, 77630.92568540938},
	{0.00000000056, 4.95742185541, 27037.07875054399},
	{0.00000000065, 5.63247484940, 27311.72098235281},
	{0.00000000055, 3.21960099803, 157057.10981453978},
	{0.00000000064, 4.73090166157, 76571.54375522019},
	{0.00000000055, 4.21524098893, 23919.14265929160},
	{0.00000000047, 4.96233788191, 29550.14784743939},
	{0.00000000047, 1.33048751622, 155571.81910783658},
	{0.00000000048, 4.68524066713, 39629.32434406539},
	{0.00000000049, 2.26366790917, 86143.79857806159},
	{0.00000000052, 6.11102279257, 28736.35796704720},
	{0.00000000046, 4.52836499361, 76681.75007643958},
	{0.00000000063, 6.05525919705, 176953.98994186718},
	{0.00000000052, 3.81191987554, 220.41264243880},
	{0.00000000052, 3.90556632585, 25138.72753260440},
	{0.00000000044, 2.11826208004, 16703.06213349900},
	{0.00000000044, 4.09373605789, 78903.60671103658},
	{0.00000000043, 2.78314274287, 1272.68102562720},
	{0.00000000054, 4.84794812605, 52381.99183158559},
	{0.00000000042, 0.46089983609, 1485.98012106520},
	{0.00000000042, 0.51072992828, 78188.92782615528},
	{0.00000000048, 4.03364140605, 65831.66677432480},
	{0.00000000042, 1.76526717012, 1795.25844372100},
	{0.00000000047, 4.06325102883, 104275.34649502118},
	{0.00000000048, 5.22216564191, 25466.15934073500},
	{0.00000000046, 2.09054510396, 949.17560896980},
	{0.00000000039, 2.42252858155, 55503.94193942859},
	{0.00000000048, 0.55204010547, 76667.52298243798},
	{0.00000000041, 4.68645736183, 54087.00576636560},
	{0.00000000044, 0.18464522171, 1265.56747862640},
	{0.00000000047, 3.57377527690, 26709.64694241340},
	{0.00000000046, 4.58966952379, 28256.66362385679},
	{0.00000000040, 2.43593735104, 25352.02662804239},
	{0.00000000044, 0.28326275745, 52712.61079524379},
	{0.00000000040, 0.06426607172, 26823.77965510599},
	{0.00000000043, 4.78359780736, 365230.64398203876},
	{0.00000000051, 0.42322753564, 182085.63102592478},
	{0.00000000045, 3.69056749350, 25867.49049913539},
	{0.00000000038, 2.95265152123, 128320.75184749259},
	{0.00000000038, 4.24964079407, 104505.39137678158},
	{0.00000000037, 5.45870103761, 132658.27281205778},
	{0.00000000036, 4.01505056763, 104197.83375581198},
	{0.00000000042, 4.73645882503, 214364.55718174578},
	{0.00000000042, 3.62652817335, 25169.97285559240},
	{0.00000000038, 5.05414542008, 13541.42120249119},
	{0.00000000036, 1.25304159965, 116783.65521669458},
	{0.00000000037, 0.15651744362, 26073.67604757259},
	{0.00000000037, 1.95429510696, 130459.18546877075},
	{0.00000000037, 0.10010579661, 24203.00197815680},
	{0.00000000036, 1.07961540756, 26057.57628056979},
	{0.00000000036, 2.35351546150, 26102.13023557580},
	{0.00000000039, 3.82952906520, 151.04766984290},
	{0.00000000035, 1.43330630555, 26118.23000257860},
	{0.00000000036, 5.28457918668, 78896.49316403578},
	{0.00000000047, 0.46836410864, 147423.51185532758},
	{0.00000000037, 3.86488170615, 78366.80219894118},
	{0.00000000034, 1.99586823431, 27566.76971563859},
	{0.00000000039, 5.16595018555, 27005.83342755599},
	{0.00000000045, 5.50909039088, 2125.87740737920},
	{0.00000000045, 1.86629837439, 153.77881048480},
	{0.00000000037, 2.43731961667, 25773.71696170459},
	{0.00000000044, 5.23291381444, 26308.31578401300},
	{0.00000000035, 1.05320110634, 27463.67694142000},
	{0.00000000040, 4.02382647386, 25654.19140369739},
	{0.00000000037, 0.07560209645, 26402.08932144380},
	{0.00000000036, 1.61232862223, 51653.22886505459},
	{0.00000000033, 0.42458452244, 26189.86565983980},
	{0.00000000032, 5.23283983463, 51852.30086649099},
	{0.00000000042, 2.44221903170, 75615.25459924959},
	{0.00000000040, 2.83526315611, 148.07872442630},
	{0.00000000033, 2.88930013582, 204151.27163553478},
	{0.00000000036, 6.12428536735, 130419.84594697120},
	{0.00000000035, 0.40523188780, 9384.84100807520},
	{0.00000000032, 2.08833719067, 25985.94062330859},
	{0.00000000033, 0.23168510760, 35472.74414964940},
	{0.00000000033, 2.40916004743, 27972.80430499159},
	{0.00000000043, 0.94126409897, 157586.80077963437},
	{0.00000000034, 2.40767650115, 51868.24866217880},
	{0.00000000044, 1.43873271021, 51528.79544983359},
	{0.00000000031, 4.01862366233, 78160.61665050399},
	{0.00000000031, 5.39381686645, 207593.84658050018},
	{0.00000000031, 1.63565043557, 94329.77528619739},
	{0.00000000030, 5.53920573257, 130432.40216087017},
	{0.00000000030, 3.30348567737, 181026.24909573558},
	{0.00000000031, 0.58465350275, 51432.81622261579},
	{0.00000000035, 5.63323743373, 130226.21661243298},
	{0.00000000041, 4.10893149085, 64901.25971792339},
	{0.00000000038, 2.74077466350, 37698.45509994840},
	{0.00000000028, 5.42226462076, 80382.47328510099},
	{0.00000000028, 3.23530343392, 182188.72380014337},
	{0.00000000030, 5.69753597308, 77101.23472031478},
	{0.00000000029, 2.84454397902, 114.39910691340},
	{0.00000000032, 1.03692995892, 49953.94964855139},
	{0.00000000027, 4.34958892371, 101011.00013959699},
	{0.00000000029, 2.60689456510, 26083.97098831109},
	{0.00000000027, 0.05549126696, 52509.66222391780},
	{0.00000000029, 6.19291069275, 26091.83529483729},
	{0.00000000032, 2.62281532990, 24925.42843716640},
	{0.00000000034, 5.96614879093, 22003.91463486980},
	{0.00000000035, 6.21900169182, 52483.36390411799},
	{0.00000000029, 3.02582488582, 136722.59155786238},
	{0.00000000031, 4.43970588456, 87367.61641884019},
	{0.00000000033, 4.64183110644, 77726.90491262719},
	{0.00000000034, 4.71487895725, 1905.46476494040},
	{0.00000000026, 4.27544189057, 26049.77010593640},
	{0.00000000025, 4.75010185308, 130652.81480330898},
	{0.00000000026, 3.04611137889, 54374.89362643540},
	{0.00000000028, 0.48396088623, 51226.63067417859},
	{0.00000000033, 4.54904645879, 78039.36462902068},
	{0.00000000027, 3.40789619643, 183570.92173262799},
	{0.00000000033, 0.91422316489, 123200.84011627098},
	{0.00000000025, 1.86918416559, 78338.49102328988},
	{0.00000000027, 5.63520290926, 1223.81784077861},
	{0.00000000024, 1.09879284413, 24824.74577899600},
	{0.00000000030, 6.02578053535, 77307.42026875199},
	{0.00000000026, 4.40497747181, 39450.35284837340},
	{0.00000000024, 1.67160749703, 1045.15483618760},
	{0.00000000029, 4.01431074745, 25600.26839032000},
	{0.00000000027, 5.45015263034, 27170.98337386779},
	{0.00000000027, 3.35506505446, 25004.82290928060},
	{0.00000000024, 1.70570280621, 52609.51802102519},
	{0.00000000024, 0.92190112786, 129373.02023068098},
	{0.00000000025, 3.42703894978, 299.12639426920},
	{0.00000000027, 0.19476264674, 143005.66740785378},
	{0.00000000027, 6.01076879125, 24072.92146977640},
	{0.00000000024, 5.68395366955, 52286.01260436779},
	{0.00000000028, 4.77908913093, 26575.53789282839},
	{0.00000000030, 1.77580150574, 161079.37234650398},
	{0.00000000025, 3.28511315405, 92741.06060792258},
	{0.00000000023, 1.28923152263, 60370.08161635699},
	{0.00000000023, 0.30769835394, 76784.84285065818},
	{0.00000000025, 6.12372098057, 48847.67062686820},
	{0.00000000026, 6.21853790794, 78153.50310350319},
	{0.00000000023, 6.03986636871, 77947.31755506598},
	{0.00000000023, 0.06005390957, 123668.80510662538},
	{0.00000000022, 0.26166099168, 78213.71280281838},
	{0.00000000025, 4.36791869246, 26724.89941359840},
	{0.00000000025, 4.43729899234, 25450.90686955000},
	{0.00000000022, 1.41483604412, 27351.06050415239},
	{0.00000000028, 2.82763549527, 30171.89164827860},
	{0.00000000022, 3.84824366233, 50264.60679993120},
	{0.00000000026, 5.41642995127, 25234.70675982219},
	{0.00000000030, 0.70937754307, 53906.92863608099},
	{0.00000000023, 4.80298766860, 316.39186965660},
	{0.00000000024, 4.62065948726, 78786.28684281638},
	{0.00000000022, 1.83211095898, 6885.14988993081},
	{0.00000000022, 1.19881833941, 50064.15596977079},
	{0.00000000025, 4.82521606002, 130435.63437251298},
	{0.00000000022, 1.64262163906, 50444.68393021580},
	{0.00000000023, 0.48284788906, 103917.90082841998},
	{0.00000000025, 0.72627176075, 52174.32181044009},
	{0.00000000022, 2.31815942379, 78580.10129437919},
	{0.00000000022, 5.37072237928, 80596.90581759460},
	{0.00000000024, 2.29466576857, 51841.95034237900},
	{0.00000000022, 3.98563117453, 163766.09444104518},
	{0.00000000024, 2.77938448215, 28102.88481337200},
	{0.00000000028, 4.67187139230, 6129.29703950660},
	{0.00000000028, 4.50423924612, 1731.12235293260},
	{0.00000000023, 3.83483940099, 129387.24732468258},
	{0.00000000025, 0.44167057897, 81604.32185142238},
	{0.00000000021, 1.43990956253, 1063.31408345230},
	{0.00000000020, 5.63766440403, 51955.39364070959},
	{0.00000000019, 0.14811705167, 1089.70879119360},
	{0.00000000021, 0.48382399190, 130289.95251073639},
	{0.00000000020, 6.06263628388, 86457.98475793119},
	{0.00000000020, 5.37392483479, 123758.29085447139},
	{0.00000000019, 5.99896464484, 51329.72344839720},
	{0.00000000020, 4.52823506105, 196137.07343261078},
	{0.00000000023, 1.12690816744, 166740.70439565618},
	{0.00000000022, 3.39965156778, 16342.58258571760},
	{0.00000000022, 5.57412323033, 3462.24470586520},
	{0.00000000023, 2.31183970817, 50167.24874398939},
	{0.00000000022, 4.76145913299, 26126.03617721200},
	{0.00000000022, 4.14425825536, 26734.91397488900},
	{0.00000000019, 3.09805264388, 78683.19406859778},
	{0.00000000019, 1.57754212699, 78413.27262185719},
	{0.00000000024, 0.55755098688, 145204.75475114079},
	{0.00000000019, 3.56013605744, 102018.41617342478},
	{0.00000000019, 2.12244186746, 130446.62925487179},
	{0.00000000024, 1.47596121866, 52177.29075585669},
	{0.00000000025, 3.25287024656, 130443.39704322898},
	{0.00000000022, 5.54888786998, 24952.22626968100},
	{0.00000000020, 5.01791562590, 104819.57755665119},
	{0.00000000019, 0.22114816361, 53029.00266490040},
	{0.00000000019, 4.66235459384, 26248.31051095900},
	{0.00000000019, 4.14286309096, 25927.49577218939},
	{0.00000000018, 2.61853732084, 128220.75860368418},
	{0.00000000020, 4.36521030279, 25907.82601128960},
	{0.00000000020, 4.44000738201, 26267.98027185880},
	{0.00000000019, 3.36352476280, 52817.21984488739},
	{0.00000000018, 0.30828612349, 26411.40855823160},
	{0.00000000022, 3.17973512175, 103932.12792242158},
	{0.00000000018, 5.78685842485, 75930.51303185058},
	{0.00000000020, 5.09591693073, 12412.37288949800},
	{0.00000000025, 1.79028039602, 78313.70604662679},
	{0.00000000020, 3.61265389901, 233731.74634397858},
	{0.00000000021, 3.24219932966, 27223.58001346740},
	{0.00000000017, 0.72171071986, 53867.97195265079},
	{0.00000000019, 4.86189338108, 25863.55834587229},
	{0.00000000017, 5.48277957945, 24602.61243487099},
	{0.00000000016, 4.01284635822, 3.88133535800},
	{0.00000000016, 1.12213372181, 79330.20490191258},
	{0.00000000017, 0.36844604424, 11.04570026390},
	{0.00000000018, 4.58738050642, 79315.97780791098},
	{0.00000000022, 1.30917900414, 76887.93562487679},
	{0.00000000016, 3.30777698968, 27573.19384827740},
	{0.00000000021, 3.15503951358, 153084.84390447979},
	{0.00000000017, 5.50445239257, 52137.67324751059},
	{0.00000000018, 0.43707176640, 62197.64356324779},
	{0.00000000019, 4.71487615393, 130866.11389874699},
	{0.00000000016, 4.53135096192, 28309.75977617119},
	{0.00000000019, 4.97195581426, 163298.12945069079},
	{0.00000000015, 6.01544571455, 50903.12525752120},
	{0.00000000015, 0.94947396087, 155887.52156313117},
	{0.00000000016, 1.95850844074, 103498.41618454478},
	{0.00000000022, 4.51054091879, 1055.44977692610},
	{0.00000000021, 3.55728303850, 3178.14579056760},
	{0.00000000015, 3.36560803567, 61560.64729122359},
	{0.00000000017, 1.75781825802, 55638.05098901359},
	{0.00000000018, 4.71857780098, 132028.58860315479},
	{0.00000000016, 5.70225976379, 104358.24112519680},
	{0.00000000016, 5.00130427149, 176332.24614102798},
	{0.00000000017, 2.00762224529, 80174.90890793978},
	{0.00000000015, 1.85651180492, 52309.91533273340},
	{0.00000000015, 5.85519527755, 6044.22858137540},
	{0.00000000017, 1.48305732410, 102659.44689679438},
	{0.00000000015, 2.05223117625, 50689.82616208319},
	{0.00000000015, 5.20562567296, 235900.50682626116},
	{0.00000000014, 4.13325462242, 193937.98608932378},
	{0.00000000015, 1.04578298609, 50007.04580086580},
	{0.00000000015, 4.77605690111, 26830.89320210680},
	{0.00000000014, 5.09441703249, 133882.09065283638},
	{0.00000000014, 0.73264409160, 50380.54783942739},
	{0.00000000016, 0.34142596191, 77.75054398390},
	{0.00000000016, 5.83322656205, 81591.84508100279},
	{0.00000000016, 2.56012166691, 104344.98400739678},
	{0.00000000014, 0.38043611029, 26247.20487636640},
	{0.00000000014, 2.14159626733, 25928.60140678200},
	{0.00000000016, 2.29540093320, 50910.23880452200},
	{0.00000000014, 4.21516962824, 1169.58825140860},
	{0.00000000016, 2.14443787663, 53814.87580033639},
	{0.00000000014, 2.88257919019, 78149.27013603736},
	{0.00000000016, 2.81982401926, 203041.89308344138},
	{0.00000000017, 0.14097228090, 14.22709400160},
	{0.00000000015, 4.50854313896, 77616.69859140778},
	{0.00000000013, 2.95502641054, 125112.03959948818},
	{0.00000000014, 2.82070907634, 52161.57918914679},
	{0.00000000012, 1.09784520065, 19202.75325164339},
	{0.00000000014, 5.55450230200, 78378.14871340781},
	{0.00000000014, 1.64692338972, 26076.85744131030},
	{0.00000000014, 0.87510898790, 26098.94884183810},
	{0.00000000012, 0.84912804767, 45290.65639321759},
	{0.00000000016, 5.27893423231, 51534.39272140940},
	{0.00000000014, 2.87981573153, 20043.67456019880},
	{0.00000000012, 5.35625751365, 23439.44831610119},
	{0.00000000014, 0.36434746971, 198489.93958638258},
	{0.00000000013, 5.25472472921, 103718.82882698359},
	{0.00000000015, 5.02501370640, 2168.76048228260},
	{0.00000000013, 5.68468150971, 32132.13172294960},
	{0.00000000013, 5.38865614891, 35833.22369743080},
	{0.00000000012, 5.97483232665, 25984.12095299360},
	{0.00000000012, 2.83038535815, 26191.68533015479},
	{0.00000000014, 3.16931627704, 53265.51507434200},
	{0.00000000012, 4.37902547397, 181659.72224941078},
	{0.00000000014, 2.41044769584, 53399.62412392700},
	{0.00000000012, 4.85232249551, 53771.99272543299},
	{0.00000000012, 0.15450821256, 43981.53094993980},
	{0.00000000013, 3.53629828268, 102755.42612401219},
	{0.00000000012, 4.35406626992, 28199.55345495179},
	{0.00000000016, 4.42924935277, 34082.43158359840},
	{0.00000000012, 3.02030436898, 51596.11869614960},
	{0.00000000013, 4.97119141190, 52024.75861330549},
	{0.00000000013, 3.53530203976, 173511.41499690177},
	{0.00000000011, 3.07690283750, 52911.68279668019},
	{0.00000000011, 0.32804624048, 70383.62027138360},
	{0.00000000015, 3.18025181635, 50049.92887576919},
	{0.00000000015, 3.22392612987, 103883.64757594238},
	{0.00000000013, 3.44611140023, 208173.53416749898},
	{0.00000000011, 0.60906260336, 48713.56157728320},
	{0.00000000015, 6.03373462236, 1639.06951718800},
	{0.00000000014, 5.51224524188, 25241.82030682300},
	{0.00000000014, 5.72095344070, 52755.49387014719},
	{0.00000000014, 0.48193051968, 52041.69723356339},
	{0.00000000012, 0.83151252253, 130363.24963659538},
	{0.00000000011, 3.57268529306, 104276.83096772949},
	{0.00000000012, 5.63836365571, 101703.15774082378},
	{0.00000000012, 1.06185654246, 90989.16285949759},
	{0.00000000011, 1.25165027664, 102769.65321801379},
	{0.00000000011, 1.61020488121, 57503.28239153120},
	{0.00000000013, 5.96769060739, 52027.72755872209},
	{0.00000000013, 1.63784016727, 78469.89497315978},
	{0.00000000014, 0.28303105851, 860.30992875280},
	{0.00000000011, 5.96339220303, 20894.53608277640},
	{0.00000000013, 2.71291064284, 27250.37784598199},
	{0.00000000012, 5.42728450538, 51439.92976961659},
	{0.00000000012, 2.65321755374, 52179.73843641149},
	{0.00000000011, 0.13380048704, 50536.73676596039},
	{0.00000000012, 0.94217302733, 53757.76563143139},
	{0.00000000010, 1.22621171910, 78339.97549599818},
	{0.00000000011, 3.31326356407, 78800.51393681798},
	{0.00000000010, 2.68789421408, 84944.93427812219},
	{0.00000000014, 6.24613692649, 183145.01295611398},
	{0.00000000010, 6.18871346175, 154408.65498906678},
	{0.00000000011, 5.44812833329, 636.99627202420},
	{0.00000000010, 1.98851340448, 53093.73656913019},
	{0.00000000014, 1.36870962052, 54344.56676543099},
	{0.00000000010, 3.90840385729, 333.85594076940},
	{0.00000000010, 0.94586399547, 641.41356173899},
	{0.00000000011, 0.96041649146, 78057.52387628538},
	{0.00000000012, 6.03701341811, 26149.62911631439},
	{0.00000000012, 2.76820426669, 26026.17716683400},
	{0.00000000011, 2.43168682439, 158746.17595363196},
	{0.00000000011, 4.83636793377, 91805.13062721379},
	{0.00000000010, 2.61011872081, 6751.04084034580},
	{0.00000000010, 0.79218036562, 91919.56991589899},
	{0.00000000014, 1.69865910615, 53124.98189211819},
	{0.00000000010, 1.99206585078, 77940.20400806518},
	{0.00000000013, 4.08389676067, 50270.34151820800},
	{0.00000000011, 3.68044220158, 77520.71936418998},
	{0.00000000011, 3.70781443358, 39763.43339365039},
	{0.00000000010, 5.75274329860, 114.43928868521},
	{0.00000000009, 1.01216637956, 130593.29451835579},
	{0.00000000009, 0.36490625518, 26513.81191808820},
	{0.00000000009, 2.15712612244, 25661.99436506020},
	{0.00000000013, 5.61622440634, 26014.60601571519},
	{0.00000000013, 3.18899327846, 26161.20026743319},
	{0.00000000010, 0.86888264917, 104991.50985261079},
	{0.00000000010, 5.95581190338, 52061.40717623499},
	{0.00000000010, 4.42035362502, 4371.87636677420},
	{0.00000000011, 4.00644107438, 183674.70392120858},
	{0.00000000010, 3.59637305781, 23384.28698689860},
	{0.00000000012, 1.90077351195, 52396.21892558720},
	{0.00000000013, 4.38320598457, 1073.60902419080},
	{0.00000000009, 2.39902771912, 103189.13786188899},
	{0.00000000013, 4.08385124235, 76041.85279012559},
	{0.00000000009, 4.93035759424, 156547.08861034496},
	{0.00000000009, 5.19425764887, 28791.51929624980},
	{0.00000000009, 0.77711516175, 130285.73689738619},
	{0.00000000009, 6.13900158212, 25131.61398560359},
	{0.00000000011, 5.98671337291, 4022.26253196420},
	{0.00000000011, 1.81020647842, 19367.18916223280},
	{0.00000000009, 2.04038725108, 104984.39630560997},
	{0.00000000009, 5.45614765496, 76255.15188556358},
	{0.00000000011, 5.95782587167, 3.93215326310},
	{0.00000000009, 2.84521042237, 31281.27020037200},
	{0.00000000012, 3.79821694912, 1699.27921650320},
	{0.00000000009, 0.84632922145, 51130.65144696079},
	{0.00000000010, 4.24458785082, 19958.60610206760},
	{0.00000000009, 0.39890242427, 52797.55008398759},
	{0.00000000009, 5.81793329193, 27360.58416720139},
	{0.00000000009, 3.81505771377, 24844.41553989579},
	{0.00000000009, 4.99015997103, 27331.39074325260},
	{0.00000000010, 5.97140853581, 230239.17477710896},
	{0.00000000009, 2.46893459204, 156314.11975400719},
	{0.00000000008, 1.08719749627, 38634.38508065720},
	{0.00000000011, 4.12126538369, 46046.50924364180},
	{0.00000000009, 5.45527892151, 52190.03337714999},
	{0.00000000011, 1.01398377196, 2538.24850425360},
	{0.00000000010, 1.53707512245, 391318.54712361297},
	{0.00000000008, 3.81834546623, 26933.98597632540},
	{0.00000000010, 5.47822459894, 54060.70744656579},
	{0.00000000009, 0.96943014829, 1685.05212250160},
	{0.00000000009, 0.39954966213, 65717.22748563958},
	{0.00000000008, 5.66324066149, 53132.09543911899},
	{0.00000000008, 1.17295053787, 2324.94940881560},
	{0.00000000009, 2.26575649117, 22595.33157470459},
	{0.00000000009, 4.01881898285, 1485.29070670320},
	{0.00000000008, 0.89598602983, 10681.25053656540},
	{0.00000000009, 5.61147436738, 52171.87412988529},
	{0.00000000008, 0.59346140745, 1574.84580128220},
	{0.00000000008, 5.37389235751, 51876.67988887919},
	{0.00000000010, 2.64362358554, 49.99662190420},
	{0.00000000010, 1.95510800967, 2751.54759969160},
	{0.00000000011, 3.21752719962, 28096.46068073319},
	{0.00000000010, 0.03803981577, 118828.96374949679},
	{0.00000000008, 5.45338504662, 77956.15180375299},
	{0.00000000008, 0.89135797231, 52400.15107885030},
	{0.00000000008, 2.89181901651, 54824.26110862140},
	{0.00000000010, 1.50538632513, 240452.46032331996},
	{0.00000000008, 5.27009439447, 77741.13200662879},
	{0.00000000008, 5.13763418673, 42790.96527507320},
	{0.00000000008, 3.13545736715, 52489.99246301800},
	{0.00000000008, 2.29664532419, 156520.30530244438},
	{0.00000000008, 0.58781443842, 17098.43543614181},
	{0.00000000007, 4.49316157626, 52206.13314415280},
	{0.00000000007, 3.15085715061, 50290.90511973100},
	{0.00000000010, 2.92673152753, 22065.64060961000},
	{0.00000000008, 1.07948674297, 51112.49219969609},
	{0.00000000010, 1.70478735166, 440.82528487760},
	{0.00000000009, 0.57156355893, 104454.70534051539},
	{0.00000000008, 2.09479344301, 35077.37084700659},
	{0.00000000008, 4.70706722263, 120417.67842777158},
	{0.00000000008, 4.83062968915, 187167.27548807819},
	{0.00000000009, 2.82365374916, 156507.74908854539},
	{0.00000000007, 5.45465770137, 51086.09749195479},
	{0.00000000008, 5.15363939201, 430.53034413910},
	{0.00000000008, 3.96538887746, 149288.74325784518},
	{0.00000000008, 3.32202684341, 112231.70171963578},
	{0.00000000009, 4.41737021309, 76152.05911134499},
	{0.00000000007, 2.13361844991, 233681.74972207438},
	{0.00000000007, 0.76923088178, 104248.51979207818},
	{0.00000000008, 3.46520766649, 77314.53381575279},
	{0.00000000007, 0.02649996061, 29396.36903695460},
	{0.00000000007, 2.49553241701, 22779.43724619380},
	{0.00000000007, 4.38534662923, 26290.15653674829},
	{0.00000000007, 4.41987105557, 25885.64974640009},
	{0.00000000009, 5.00120036070, 2703.61615467560},
	{0.00000000007, 1.46712503162, 156740.71794488319},
	{0.00000000008, 2.98540358627, 78571.26704569219},
	{0.00000000008, 3.46227249114, 2014.98167179780},
	{0.00000000009, 3.60323244194, 24395.73747207180},
	{0.00000000007, 1.57299130322, 52663.44103440259},
	{0.00000000008, 3.34291932325, 102872.74599223239},
	{0.00000000009, 4.15307297121, 24505.94379329119},
	{0.00000000007, 5.14819246138, 52073.84376488279},
	{0.00000000007, 2.10644528980, 149846.19399604558},
	{0.00000000007, 2.73815653722, 77417.62658997139},
	{0.00000000007, 3.99043202484, 1135.67687189320},
	{0.00000000009, 5.86657971342, 56259.79478985279},
	{0.00000000009, 1.31330622674, 18073.70493865020},
	{0.00000000008, 0.16231496773, 207114.15223730978},
	{0.00000000008, 0.71218709319, 32808.61712091560},
	{0.00000000007, 1.34578982527, 23267.07199744800},
	{0.00000000007, 1.17624255235, 28908.73428570040},
	{0.00000000007, 5.92828079032, 917.93028598180},
	{0.00000000008, 2.80385302808, 103395.32341032618},
	{0.00000000007, 4.13036001377, 52145.47942214399},
	{0.00000000007, 0.00761390447, 208276.62694171758},
	{0.00000000007, 5.79521967115, 63786.35824152260},
	{0.00000000007, 1.07448219743, 127098.90328117118},
	{0.00000000008, 1.39088196258, 103814.80805420138},
	{0.00000000006, 3.50717502178, 27573.88326263939},
	{0.00000000006, 2.56522679948, 8989.46770543239},
	{0.00000000007, 4.34204308173, 102975.83876645098},
	{0.00000000006, 2.26227426560, 28774.62523611540},
	{0.00000000006, 0.25975811202, 23401.18104703300},
	{0.00000000006, 6.10163893636, 80462.79676800959},
	{0.00000000008, 3.19469782712, 579.68758699880},
	{0.00000000008, 0.39455403552, 51257.87599716660},
	{0.00000000006, 2.04791015101, 23704.71012679799},
	{0.00000000006, 0.47412222661, 28471.09615635040},
	{0.00000000007, 3.95910943139, 1802.37199072180},
	{0.00000000007, 0.04757570199, 53311.48315504160},
	{0.00000000007, 3.75772081758, 79994.83177765518},
	{0.00000000007, 3.47532912865, 52277.76880141400},
	{0.00000000006, 4.49776146960, 53438.96364572659},
	{0.00000000007, 0.23424532162, 29580.47470844380},
	{0.00000000007, 2.10834895065, 27388.72995977919},
	{0.00000000007, 0.41368342697, 24787.07632336920},
	{0.00000000006, 2.20070614265, 106470.37642667518},
	{0.00000000007, 1.31790121285, 104127.26777059489},
	{0.00000000007, 5.05330889636, 27623.87988454360},
	{0.00000000007, 3.75190878844, 24551.92639860479},
	{0.00000000008, 5.48806422287, 51861.62010327879},
	{0.00000000008, 2.01472939327, 51554.06248230919},
	{0.00000000007, 1.27572316405, 52213.93931878620},
	{0.00000000007, 2.73167050152, 2974.60995461100},
	{0.00000000007, 4.01717883587, 25572.43927048119},
	{0.00000000007, 4.78803884893, 26603.36701266720},
	{0.00000000007, 3.81075000430, 415.55249061210},
	{0.00000000007, 6.19062740919, 1083.08023229360},
	{0.00000000008, 5.83496057018, 54190.78795494619},
	{0.00000000007, 0.63875539049, 3308.46589538040},
	{0.00000000007, 2.73288976570, 48091.81777644400},
	{0.00000000006, 2.27207352577, 78043.29678228378},
	{0.00000000006, 3.59345495938, 24822.33566294780},
	{0.00000000006, 0.12929656544, 53661.09698985160},
	{0.00000000006, 0.35086113339, 209658.82487420218},
	{0.00000000006, 4.92644191429, 104426.39416486409},
	{0.00000000006, 2.39715110930, 25764.39772491679},
	{0.00000000006, 4.97320423795, 27883.16158529519},
	{0.00000000006, 3.69839341742, 142871.55835826878},
	{0.00000000006, 1.52227576605, 156523.53751408719},
	{0.00000000006, 5.16948222242, 117893.03376878797},
	{0.00000000008, 4.29203597963, 51120.35650622229},
	{0.00000000006, 6.23369265991, 225.82926841020},
	{0.00000000006, 3.56663907388, 5193.36705879780},
	{0.00000000006, 3.11032917996, 149756.70824819959},
	{0.00000000007, 5.12005781910, 48997.66049258080},
	{0.00000000008, 2.23399255632, 53258.88651544199},
	{0.00000000006, 3.49961056081, 130005.80396999417},
	{0.00000000006, 5.07465642279, 76777.72930365738},
	{0.00000000006, 4.66798207100, 47803.92991637420},
	{0.00000000007, 6.08095772039, 162810.49469943657},
	{0.00000000006, 0.64154839978, 27441.65188659100},
	{0.00000000006, 1.88048397784, 24734.15439655740},
	{0.00000000006, 3.95287785965, 155460.92337225519},
	{0.00000000008, 1.91926925056, 422.66603761290},
	{0.00000000006, 2.81558483589, 50160.82461135059},
	{0.00000000006, 2.10318926713, 222.86032299360},
	{0.00000000006, 3.77961930116, 78262.22495201428},
	{0.00000000006, 3.79600164114, 76468.45098100159},
	{0.00000000006, 2.19241811447, 78225.57638908479},
	{0.00000000006, 3.10628150548, 78597.56536549199},
	{0.00000000007, 5.87457428048, 30110.16567353840},
	{0.00000000006, 3.63300370506, 4083.98850670440},
	{0.00000000006, 3.60786932853, 171292.65789271498},
	{0.00000000006, 2.63023124510, 29864.33402730900},
	{0.00000000006, 6.17498643970, 22311.47225583940},
	{0.00000000006, 2.81699286653, 76991.02839909539},
	{0.00000000006, 4.97892299151, 21716.02677480000},
	{0.00000000005, 5.40188161644, 27410.58078910560},
	{0.00000000005, 3.40333606836, 24765.22549404280},
	{0.00000000006, 0.12287107983, 51092.72605085480},
	{0.00000000006, 6.26396450919, 179172.74704605396},
	{0.00000000007, 1.20914785176, 34102.10134449819},
	{0.00000000006, 3.98658256476, 31903.01400121119},
	{0.00000000006, 4.81863512004, 20272.79228193720},
	{0.00000000005, 0.59743867876, 155475.15046625677},
	{0.00000000006, 2.99448492312, 1884.90116341740},
	{0.00000000006, 1.29004214195, 104874.18998439058},
	{0.00000000007, 6.08314945100, 9745.32055585660},
	{0.00000000005, 4.57176510415, 128747.35003836859},
	{0.00000000005, 3.48020412230, 26500.27423844859},
	{0.00000000005, 5.32501356250, 25675.53204469980},
	{0.00000000005, 0.67567879748, 189853.99758261938},
	{0.00000000005, 5.62586823874, 487.63475125420},
	{0.00000000005, 4.12117505892, 53551.58008299420},
	{0.00000000005, 5.05847825453, 60170.33472517260},
	{0.00000000005, 4.48575981388, 27353.47062020059},
	{0.00000000005, 0.45209405317, 628.85158605010},
	{0.00000000005, 2.04047293459, 189386.03259226495},
	{0.00000000007, 3.24752363205, 169093.57054942798},
	{0.00000000006, 3.27898581061, 25462.23294926180},
	{0.00000000006, 5.52623187419, 26713.57333388659},
	{0.00000000007, 1.39980699002, 2641.34127847220},
	{0.00000000006, 4.69852322879, 25440.89230825939},
	{0.00000000005, 1.13017778403, 52812.80255517260},
	{0.00000000006, 6.23315922928, 156531.30018480319},
	{0.00000000006, 2.82802951228, 122444.98726584678},
	{0.00000000005, 5.91150949505, 26235.98186600050},
	{0.00000000006, 0.64362124464, 3492.57156686960},
	{0.00000000005, 3.16675569939, 26034.80698925980},
	{0.00000000005, 5.63846198541, 26140.99929388859},
	{0.00000000006, 4.41863890724, 13675.53025207620},
	{0.00000000006, 2.30069536250, 28213.78054895339},
	{0.00000000005, 2.72683369817, 127791.06088239799},
	{0.00000000005, 2.79855313555, 104035.22069664019},
	{0.00000000005, 2.16612728193, 1263.15736257819},
	{0.00000000006, 3.26180559114, 437.64389113990},
	{0.00000000005, 2.17730624219, 52098.05573916449},
	{0.00000000005, 1.17064954712, 65538.25598994759},
	{0.00000000005, 3.31240476519, 104301.61594439259},
	{0.00000000005, 4.76122192085, 78697.42116259939},
	{0.00000000005, 5.20657468818, 1243.48760167840},
	{0.00000000005, 2.85173407545, 2686.72209454120},
	{0.00000000005, 4.82516506007, 104401.60918820098},
	{0.00000000005, 5.03758504482, 53654.67285721279},
	{0.00000000005, 2.30415192529, 23866.04650697719},
	{0.00000000005, 4.57253368744, 51006.21803173979},
	{0.00000000006, 2.99064022137, 104241.40624507738},
	{0.00000000005, 5.36734313790, 104668.00443595338},
	{0.00000000004, 4.69357830395, 76532.58707178998},
	{0.00000000005, 0.50200123282, 24491.71669928959},
	{0.00000000005, 3.59914095117, 23389.45169419700},
	{0.00000000005, 5.20607673363, 28786.35458895140},
	{0.00000000004, 5.84756896317, 31775.53351052620},
	{0.00000000004, 2.95764872163, 20400.27277262220},
	{0.00000000005, 4.52541301080, 78265.19389743089},
	{0.00000000006, 0.78206719980, 51688.17153189420},
	{0.00000000005, 2.53934989272, 58220.03486452380},
	{0.00000000004, 1.16733607750, 35211.47989659159},
	{0.00000000004, 1.35469630012, 16964.32638655680},
	{0.00000000005, 6.27736599262, 76137.83201734339},
	{0.00000000004, 5.79724758149, 27039.97976483379},
	{0.00000000004, 3.00797010331, 25135.82651831460},
	{0.00000000005, 3.02879597074, 25778.62481891839},
	{0.00000000005, 5.77642171406, 26397.18146422999},
	{0.00000000005, 2.45203846176, 78373.91574594198},
	{0.00000000004, 0.10837463046, 33480.35754365900},
	{0.00000000004, 2.41365774716, 18695.44873948940},
	{0.00000000005, 5.31103491600, 703.63318461740},
	{0.00000000004, 3.53618772681, 156377.85565231058},
	{0.00000000004, 4.88536855567, 24182.43837663380},
	{0.00000000005, 0.75362139040, 2015.67108615980},
	{0.00000000004, 4.84402630975, 129586.31932611899},
	{0.00000000004, 0.41914706804, 199599.31813847595},
	{0.00000000004, 5.33219851688, 76998.14194609619},
	{0.00000000004, 1.24487525140, 1368.66025284500},
	{0.00000000004, 6.20344076250, 45424.76544280259},
	{0.00000000004, 3.82794287315, 28928.40404660019},
	{0.00000000004, 4.97727481165, 23247.40223654820},
	{0.00000000004, 0.78108419173, 20452.86941222180},
	{0.00000000004, 1.74094818589, 31722.93687092660},
	{0.00000000004, 0.73252151870, 26238.95081141709},
	{0.00000000004, 1.20756668103, 52355.88341343300},
	{0.00000000004, 1.89262749454, 51538.81001112419},
	{0.00000000004, 2.12864958126, 32278.92615582100},
	{0.00000000004, 0.39338279636, 19896.88012732740},
	{0.00000000004, 0.13108394311, 78905.12298646157},
	{0.00000000004, 1.42991389286, 52336.21365253320},
	{0.00000000004, 4.11596381659, 50912.64892057020},
	{0.00000000005, 3.55365309754, 26090.87208699080},
	{0.00000000005, 5.25156458726, 26084.93419615759},
	{0.00000000004, 1.77632201645, 25923.46723098479},
	{0.00000000004, 0.74571036118, 26252.33905216361},
	{0.00000000004, 3.45962912770, 106262.81204951399},
	{0.00000000005, 5.55461968829, 13705.85711308060},
	{0.00000000005, 3.25059799651, 38469.94917006779},
	{0.00000000005, 3.12816538610, 18227.48374913500},
	{0.00000000005, 5.67705229870, 33948.32253401340},
	{0.00000000004, 2.78749020522, 74935.57376844239},
	{0.00000000004, 5.08828008747, 26130.78621647760},
	{0.00000000004, 3.71693759733, 26045.02006667080},
	{0.00000000005, 4.43555583939, 51102.19725895759},
	{0.00000000004, 6.19718375992, 104771.09721017198},
	{0.00000000004, 0.26322316371, 19336.86230122839},
	{0.00000000004, 1.76945825889, 18319.53658487960},
	{0.00000000004, 0.75257411874, 33856.26969826880},
	{0.00000000005, 2.23665069420, 51315.49635439559},
	{0.00000000004, 1.69359058279, 159969.99379441059},
	{0.00000000004, 2.89301646158, 25939.82441714789},
	{0.00000000005, 3.45474588143, 107692.22499299659},
	{0.00000000005, 1.47989657697, 49637.55777889479},
	{0.00000000004, 2.13958521874, 24292.64469785319},
	{0.00000000005, 5.34571928246, 77929.85348395319},
	{0.00000000004, 2.13537389331, 106684.80895916879},
	{0.00000000004, 1.30241374700, 25248.93385382380},
	{0.00000000004, 1.21961863062, 26926.87242932459},
	{0.00000000005, 6.25905047664, 130020.03106399579},
	{0.00000000004, 0.16908897765, 42430.48572729180},
	{0.00000000004, 0.65996952307, 24712.12934172840},
	{0.00000000004, 1.67938382417, 130907.48069822539},
	{0.00000000004, 0.49273474013, 76352.50994150538},
	{0.00000000004, 3.03818840694, 8044.52506392840},
	{0.00000000004, 2.24959479186, 50690.51557644519},
	{0.00000000003, 4.11860713513, 76094.94894243999},
	{0.00000000004, 5.11517156658, 27047.02600153180},
	{0.00000000004, 3.69004611822, 25128.78028161659},
	{0.00000000003, 2.87423294156, 25980.59783464459},
	{0.00000000003, 5.93098474324, 26195.20844850380},
	{0.00000000004, 3.06482161328, 52164.76058288449},
	{0.00000000004, 0.98879727436, 215941.90072419358},
	{0.00000000005, 4.86374437755, 45455.09230380700},
	{0.00000000004, 6.09264875397, 151199.94274106238},
	{0.00000000004, 3.84907251953, 25991.92391435639},
	{0.00000000004, 4.95614516527, 26183.88236879199},
	{0.00000000005, 6.06890934253, 10059.50673572620},
	{0.00000000004, 2.78312246204, 48153.54375118419},
	{0.00000000004, 5.16058547691, 16496.36139620240},
	{0.00000000004, 3.64463220789, 35679.44488694599},
	{0.00000000004, 2.31682392343, 51040.12941125520},
	{0.00000000004, 0.89612134983, 128843.32926558638},
	{0.00000000004, 0.91042238998, 52015.39891376359},
	{0.00000000003, 6.06256841288, 23113.29318696320},
	{0.00000000003, 2.74264927192, 29062.51309618520},
	{0.00000000003, 4.85231198714, 25794.49235719700},
	{0.00000000003, 3.95290569766, 26381.31392595140},
	{0.00000000003, 4.53666662059, 117077.06600107178},
	{0.00000000004, 1.27827004084, 113455.51956041438},
	{0.00000000003, 1.74369273900, 9123.57675501740},
	{0.00000000004, 5.49977739982, 23543.23050468179},
	{0.00000000004, 3.30544028498, 28632.57577846660},
	{0.00000000003, 0.77597702447, 26279.35140768579},
	{0.00000000003, 1.74605535315, 25896.45487546260},
	{0.00000000003, 4.84401273911, 143980.93691036216},
	{0.00000000004, 2.60606940279, 25998.41739372820},
	{0.00000000004, 6.19914828201, 26177.38888942019},
	{0.00000000004, 5.74351106248, 50951.98844236979},
	{0.00000000003, 1.26642446783, 49850.85687433279},
	{0.00000000004, 4.75573366952, 14235.54807817520},
	{0.00000000004, 4.04948401528, 37940.25820497319},
	{0.00000000004, 2.15457403796, 261988.40996783535},
	{0.00000000003, 1.62529527167, 41494.55574658299},
	{0.00000000004, 4.57562203112, 32217.20018108080},
	{0.00000000004, 1.13276960181, 51995.72915286380},
	{0.00000000003, 5.60306507247, 154308.66174525839},
	{0.00000000003, 4.90725652630, 78397.81847430758},
	{0.00000000004, 0.74705899090, 49424.25868345679},
	{0.00000000003, 1.65138805728, 202420.14928260217},
	{0.00000000003, 3.28257147962, 79116.90580647459},
	{0.00000000003, 0.25268995906, 26114.20146137400},
	{0.00000000003, 2.26934241856, 26061.60482177439},
	{0.00000000003, 0.76377303552, 112545.88789950538},
	{0.00000000003, 1.53998283633, 27993.36790651460},
	{0.00000000004, 1.48359617562, 156954.01704032118},
	{0.00000000003, 4.96130874142, 25344.91308104160},
	{0.00000000004, 4.16132549519, 192828.60753723037},
	{0.00000000003, 1.41397155639, 191.44826611160},
	{0.00000000003, 2.35998158508, 130446.14426677099},
	{0.00000000003, 0.58877390822, 26.29831979980},
	{0.00000000003, 6.14909241029, 23420.85080793279},
	{0.00000000003, 2.65612527451, 28754.95547521560},
	{0.00000000004, 5.30569233154, 117.31986822020},
	{0.00000000003, 5.91402019226, 184834.07909520617},
	{0.00000000004, 5.00370301079, 50476.52706664519},
	{0.00000000003, 2.64378251337, 52072.02409456780},
	{0.00000000003, 2.04712691944, 77622.29586298359},
	{0.00000000003, 5.19234087353, 52016.50454835620},
	{0.00000000003, 0.11683553157, 25970.58327335399},
	{0.00000000003, 2.40519684605, 26205.22300979439},
	{0.00000000004, 3.70857620718, 27511.46787353720},
	{0.00000000004, 5.09664147762, 24664.33840961120},
	{0.00000000003, 3.60635808002, 24079.34560241519},
	{0.00000000003, 0.72953121469, 33917.99567300899},
	{0.00000000003, 1.79250116293, 18257.81061013940},
	{0.00000000003, 0.90477621292, 220025.88923089796},
	{0.00000000004, 2.19435190001, 61921.12683900499},
	{0.00000000003, 3.67050911713, 8482.16319327840},
	{0.00000000003, 3.87625546504, 226796.59983214356},
	{0.00000000003, 1.31319711766, 222224.97657418498},
	{0.00000000003, 5.87130809057, 78249.48233072099},
	{0.00000000004, 1.48902081585, 158116.49174472898},
	{0.00000000003, 0.35052613743, 107679.74822257696},
	{0.00000000003, 0.31258950206, 26387.02953584340},
	{0.00000000003, 1.73728166781, 25936.85547173129},
	{0.00000000003, 3.47716392063, 26983.98259822960},
	{0.00000000003, 5.32805376417, 25191.82368491880},
	{0.00000000003, 5.46073958753, 79487.52726550119},
	{0.00000000003, 1.54880317183, 50490.75416064679},
	{0.00000000003, 0.33667155775, 251775.12442162436},
	{0.00000000003, 3.12587906085, 55484.27217852879},
	{0.00000000003, 3.35660316298, 205260.65018762815},
	{0.00000000003, 6.10516130974, 1382.88734684660},
	{0.00000000003, 3.15734817044, 146505.58156934578},
	{0.00000000003, 4.70646783103, 5019.91848741320},
	{0.00000000003, 5.41521179939, 1471.75302706360},
	{0.00000000003, 1.19647848516, 2820.83114412620},
	{0.00000000003, 3.47413746108, 24510.55959912640},
	{0.00000000003, 5.33108022372, 27665.24668402200},
	{0.00000000004, 5.77018377851, 25810.86814783279},
	{0.00000000004, 3.03503390629, 26364.93813531560},
	{0.00000000003, 5.01481009275, 179966.86716554638},
	{0.00000000004, 4.33432698720, 128106.31931499895},
	{0.00000000003, 1.92656985885, 50600.96048186620},
	{0.00000000003, 6.09093416793, 110395.84114767218},
	{0.00000000003, 6.02863621669, 26202.30224848760},
	{0.00000000003, 5.77135105714, 1577.34354244780},
	{0.00000000003, 2.48974578151, 184526.52147423658},
	{0.00000000003, 6.13912071583, 29000.78712144500},
	{0.00000000003, 2.66609696897, 23175.01916170339},
	{0.00000000002, 3.73235165225, 24601.92302050899},
	{0.00000000003, 6.07147026831, 49201.19632853740},
	{0.00000000003, 4.25494225394, 143164.96914264598},
	{0.00000000003, 0.81593599477, 51734.98099827079},
	{0.00000000002, 3.21160734753, 229463.65216578495},
	{0.00000000003, 5.30206948415, 963.40270297140},
	{0.00000000003, 1.27452500023, 25914.45457018961},
	{0.00000000003, 1.24750737739, 26261.35171295879},
	{0.00000000003, 3.64962054328, 51745.27593900929},
	{0.00000000003, 1.33150568827, 54879.42243782400},
	{0.00000000003, 2.24581935743, 15406.65260500879},
	{0.00000000002, 1.46486531145, 25554.28002321649},
	{0.00000000002, 1.05716706617, 26621.52625993189},
	{0.00000000003, 3.63673845964, 25530.45240337380},
	{0.00000000003, 5.16847922516, 26645.35387977460},
	{0.00000000003, 3.46486175917, 25626.56671011980},
	{0.00000000003, 5.34035592563, 26549.23957302859},
	{0.00000000003, 3.77281945049, 20956.26205751660},
	{0.00000000003, 5.03239823431, 31219.54422563180},
	{0.00000000003, 2.87469047879, 283524.35961235073},
	{0.00000000002, 2.91928536931, 210921.98223678036},
	{0.00000000002, 3.01852194681, 21202.09370374600},
	{0.00000000002, 5.78669573799, 30973.71257940240},
	{0.00000000003, 0.91363958260, 76358.24465978218},
	{0.00000000003, 1.16154088625, 97466.46267636596},
	{0.00000000002, 1.48398406791, 190495.41114435835},
	{0.00000000002, 2.27754325505, 5635.03372935240},
	{0.00000000003, 5.54528574622, 25361.42112170400},
	{0.00000000003, 3.25993193858, 26814.38516144439},
	{0.00000000002, 5.95736615747, 57369.17334194619},
	{0.00000000003, 3.84445897700, 52186.85198341230},
	{0.00000000002, 0.10098432708, 5687.63036895200},
	{0.00000000002, 1.06541336121, 31127.49138988719},
	{0.00000000002, 1.45661901641, 21048.31489326120},
	{0.00000000002, 4.88076203498, 27133.05797776179},
	{0.00000000003, 4.35294230915, 222244.64633508476},
	{0.00000000003, 1.52452494294, 67608.75720795698},
	{0.00000000003, 4.55603852700, 5815.11085963699},
	{0.00000000003, 4.50068949383, 128857.55635958798},
	{0.00000000003, 3.16048516532, 21650.38893320061},
	{0.00000000003, 5.64473251948, 30525.41734994779},
	{0.00000000003, 1.88855081937, 2352.86615377180},
	{0.00000000002, 0.61090203417, 29266.04893214180},
	{0.00000000002, 1.68643488525, 102129.75593169978},
	{0.00000000003, 2.78460866874, 735.87651353180},
	{0.00000000003, 2.77323027693, 53338.28098755619},
	{0.00000000002, 5.43265775269, 242985.40360737636},
	{0.00000000003, 4.72365570387, 23549.65463732060},
	{0.00000000002, 3.36458907123, 127261.36991730338},
	{0.00000000002, 5.34557611286, 54862.52837768960},
	{0.00000000003, 1.28968303726, 7768.36655669460},
	{0.00000000003, 1.82596797402, 24971.41104247999},
	{0.00000000003, 0.69606440360, 27204.39524066840},
	{0.00000000002, 3.44738180328, 26165.65368555809},
	{0.00000000002, 1.20703571117, 24815.22211594700},
	{0.00000000002, 1.61710949142, 267649.74201698754},
	{0.00000000003, 5.17245782566, 134.10904958500},
	{0.00000000003, 1.56133414368, 206584.46127221518},
	{0.00000000002, 3.20945918034, 23976.25282819660},
	{0.00000000002, 1.95494649553, 309.27832265580},
	{0.00000000002, 0.88420623496, 1155.36115740700},
	{0.00000000003, 5.58005355370, 49976.71893986139},
	{0.00000000003, 1.11744370489, 27161.51216576500},
	{0.00000000002, 4.55377851088, 27151.21722502649},
	{0.00000000003, 0.04149717596, 29050.78374334920},
	{0.00000000003, 2.48053520166, 23125.02253979920},
	{0.00000000002, 0.49287409814, 87648.55043279778},
	{0.00000000002, 1.99024542711, 25788.77674730500},
	{0.00000000002, 2.21400317955, 289185.69166150296},
	{0.00000000002, 1.84764313777, 32973.05303150501},
	{0.00000000002, 5.35359251167, 78484.12206716138},
	{0.00000000002, 4.84459493300, 50373.43429242659},
	{0.00000000003, 1.01624578623, 246113.79237247216},
	{0.00000000002, 0.39721293103, 543.91805909620},
	{0.00000000003, 1.70612964175, 75085.56363415498},
	{0.00000000003, 4.90340116609, 196156.74319351057},
	{0.00000000002, 3.44266551407, 225687.22128005016},
	{0.00000000002, 5.17281822358, 156534.53239644598},
	{0.00000000003, 3.14119557868, 180496.55813064099},
	{0.00000000003, 2.73574689557, 78115.63070029629},
	{0.00000000002, 4.99251162267, 51760.25379253629},
	{0.00000000002, 3.58342272703, 4398.17468657401},
	{0.00000000002, 3.55523971481, 30486.07782814820},
	{0.00000000002, 5.24997796999, 21689.72845500019},
	{0.00000000003, 1.74089824235, 78112.66175487968},
	{0.00000000002, 3.70878134452, 95.97922721780},
	{0.00000000002, 2.78958694468, 1898.35121793960},
	{0.00000000002, 3.64570275924, 235746.72801577636},
	{0.00000000002, 3.50852936833, 621.74380083920},
	{0.00000000002, 3.20346776831, 144916.86689107098},
	{0.00000000002, 5.65645027349, 26024.16724327080},
	{0.00000000002, 3.14876741131, 26151.63903987760},
	{0.00000000002, 5.88732323489, 249268.47945736776},
	{0.00000000003, 2.73644560356, 42116.29954742219},
	{0.00000000002, 1.76809181777, 4525.65517725900},
	{0.00000000003, 4.31127477508, 25949.38564470350},
	{0.00000000003, 4.49394290972, 26226.42063844490},
	{0.00000000002, 1.47978756571, 41520.85406638280},
	{0.00000000003, 0.50196484662, 65851.33653522459},
	{0.00000000003, 0.33246489326, 26375.79100164400},
	{0.00000000003, 2.18956748437, 25800.01528150440},
	{0.00000000003, 2.22716383153, 23581.25817731760},
	{0.00000000003, 0.29486854609, 28594.54810583080},
	{0.00000000002, 5.75081777002, 73891.83305794839},
	{0.00000000002, 1.98184360182, 1593.00504854690},
	{0.00000000002, 2.60932927551, 138319.60486120995},
	{0.00000000002, 5.12632591221, 1279.79457262800},
	{0.00000000002, 1.36330743614, 197266.12174560397},
	{0.00000000002, 2.08857795426, 71378.55953479178},
	{0.00000000003, 2.65879027753, 26051.25457864469},
	{0.00000000003, 6.14642740727, 26124.55170450369},
	{0.00000000002, 3.91497249728, 52367.25454925999},
	{0.00000000002, 2.56976964633, 51949.97701473820},
	{0.00000000002, 0.98913727679, 175730.17210108857},
	{0.00000000002, 0.98860870622, 28133.21167437640},
	{0.00000000002, 1.53342367140, 24042.59460877199},
	{0.00000000003, 0.60080693478, 51753.14024553549},
	{0.00000000003, 4.58119790245, 25632.99377504689},
	{0.00000000003, 4.22401978235, 26542.81250810149},
	{0.00000000002, 3.15146237007, 177287.84588263658},
	{0.00000000002, 2.40433125154, 24999.29998497320},
	{0.00000000002, 0.11770112608, 27176.50629817519},
	{0.00000000002, 3.73548941002, 138633.79104107959},
	{0.00000000002, 0.17018827892, 153878.96402397218},
	{0.00000000002, 5.94978604165, 133767.65136415116},
	{0.00000000002, 1.34122714460, 27143.35291850029},
	{0.00000000002, 6.23156121709, 20618.01935853360},
	{0.00000000002, 2.57365646771, 31557.78692461479},
	{0.00000000002, 0.41751652575, 51952.94596015479},
	{0.00000000002, 0.76607594408, 2854.64037391020},
	{0.00000000002, 0.00103411994, 52249.10340900739},
	{0.00000000002, 5.38839699166, 99979.73619952259},
	{0.00000000002, 0.68315072405, 7392.45440208480},
	{0.00000000002, 3.14356989843, 52202.10460294820},
	{0.00000000002, 4.99018195848, 66826.60603773296},
	{0.00000000002, 5.66676020953, 178243.44562424519},
	{0.00000000002, 1.12725015054, 4601.95011896300},
	{0.00000000002, 3.71415544355, 2544.67263689240},
	{0.00000000002, 2.09631003725, 330.61896365820},
	{0.00000000002, 5.01321986817, 40738.70289615879},
	{0.00000000002, 2.54696619158, 25973.50403466079},
	{0.00000000002, 2.49237809905, 206370.02873972156},
	{0.00000000002, 0.92029934107, 52822.81711646319},
	{0.00000000002, 1.43247785592, 1353.74874501680},
	{0.00000000002, 1.30678359365, 7830.09253143480},
	{0.00000000002, 2.85490308833, 190809.59732422797},
	{0.00000000002, 0.83915501030, 273311.07406613971},
	{0.00000000002, 6.04242335976, 2655.56837247380},
	{0.00000000002, 5.50264063039, 24705.70520908959},
	{0.00000000002, 3.30257705441, 27470.10107405880},
	{0.00000000002, 5.87474944976, 4578.25181685860},
	{0.00000000002, 4.82888675726, 1603.29998928540},
	{0.00000000002, 1.43074235300, 2045.30853280220},
	{0.00000000002, 4.14425166593, 30459.77950834840},
	{0.00000000002, 2.62817899928, 32838.94398192000},
	{0.00000000002, 4.84613238692, 14297.27405291540},
	{0.00000000002, 3.95908529788, 37878.53223023300},
	{0.00000000002, 4.63463254085, 104501.17576343138},
	{0.00000000002, 5.77634249731, 44131.28121921999},
	{0.00000000002, 2.06879035628, 51546.95469709829},
	{0.00000000002, 6.07216400811, 237009.88537835456},
	{0.00000000002, 4.68695414047, 31107.82162898740},
	{0.00000000002, 4.11826354433, 21067.98465416099},
	{0.00000000002, 0.41491214788, 27299.24421193320},
	{0.00000000002, 2.10712022974, 24876.56207121520},
	{0.00000000002, 4.17219070503, 105418.10804348679},
	{0.00000000002, 1.12019984719, 49534.46500467620},
	{0.00000000002, 4.16482236656, 170068.84005193636},
	{0.00000000002, 0.23628622399, 24957.74919398840},
	{0.00000000002, 2.28574615363, 27218.05708916000},
	{0.00000000002, 1.54597568017, 27257.49139298280},
	{0.00000000002, 5.01877243889, 236702.32775738496},
	{0.00000000002, 4.45179618799, 129215.69786709236},
	{0.00000000002, 5.05246292131, 1585.14074202070},
	{0.00000000002, 3.99530485240, 20235.12282631040},
	{0.00000000002, 4.80991283240, 31940.68345683799},
	{0.00000000002, 5.61086631842, 130432.88714897096},
	{0.00000000002, 3.78215414688, 79955.87509422498},
	{0.00000000002, 0.01277373043, 164721.69418265378},
	{0.00000000002, 4.10481915739, 299398.97720771392},
	{0.00000000002, 1.23240843377, 123554.36581794015},
	{0.00000000002, 5.54210405976, 51738.16239200849},
	{0.00000000002, 2.83807224501, 27953.13454409180},
	{0.00000000002, 5.96714543979, 24222.67173905660},
	{0.00000000002, 4.74202892331, 28440.76929534600},
	{0.00000000002, 4.06318876149, 23735.03698780239},
	{0.00000000002, 2.77900649268, 3776.43088573480},
	{0.00000000002, 3.48668662145, 307.55762096960},
	{0.00000000002, 3.48757125419, 4268.09417819360},
	{0.00000000002, 3.36973154287, 26948.21307032700},
	{0.00000000002, 5.43548614193, 25227.59321282139},
	{0.00000000002, 0.64413971421, 24918.31489016559},
	{0.00000000002, 0.55778477986, 25888.83114013780},
	{0.00000000002, 1.96424759776, 26286.97514301059},
	{0.00000000002, 4.14592395979, 80432.46990700519},
	{0.00000000002, 1.34549805675, 13989.71643194580},
	{0.00000000002, 1.17653432087, 38186.08985120260},
	{0.00000000002, 5.64977063090, 515.46387109300},
	{0.00000000002, 5.50647814213, 76064.62208143558},
	{0.00000000002, 4.18299182626, 9591.54174537180},
	{0.00000000002, 2.50118955855, 87253.17713015496},
	{0.00000000002, 6.18696209768, 30831.30490474460},
	{0.00000000002, 2.61825558712, 21344.50137840379},
	{0.00000000001, 5.79719820080, 959.12285995760},
	{0.00000000002, 1.35473982240, 105403.88094948517},
	{0.00000000001, 5.17269251049, 26010.15259759030},
	{0.00000000002, 5.01464967970, 14650.79975458459},
	{0.00000000002, 1.15577442187, 124663.74437003357},
	{0.00000000001, 5.29048508788, 24919.00430452760},
	{0.00000000001, 3.51473259692, 27256.80197862080},
	{0.00000000001, 1.64939139619, 5039.58824831300},
	{0.00000000001, 0.57146312681, 2383.19301477620},
	{0.00000000002, 5.13757006415, 43693.64308986999},
	{0.00000000001, 3.35135060198, 52499.31169980579},
	{0.00000000001, 2.47792186293, 25042.74830538660},
	{0.00000000002, 2.53272290248, 2214.74308759620},
	{0.00000000001, 4.12090782995, 233202.05537888398},
	{0.00000000002, 3.92094587643, 21516.27988361560},
	{0.00000000002, 4.88427180837, 30659.52639953279},
	{0.00000000002, 3.93512097196, 102225.73515891758},
	{0.00000000002, 5.04685227536, 28839.45074126579},
	{0.00000000002, 6.27298790851, 129971.55071751658},
	{0.00000000001, 1.39509036339, 15432.95092480860},
	{0.00000000001, 1.05389010615, 50807.14603030339},
	{0.00000000002, 3.49292360736, 51472.17309853099},
	{0.00000000002, 0.19610603007, 952.07662325960},
	{0, 0, 0}
};

struct vsop87_term mercury_y1[] = {
	{0.00107803852, 4.34964793883, 52175.80628314840},
	{0.00080651544, 3.14159265359, 0.00000000000},
	{0.00032715354, 1.11763734425, 78263.70942472259},
	{0.00008858158, 4.16852401867, 104351.61256629678},
	{0.00011914709, 1.22139986340, 26087.90314157420},
	{0.00002344469, 0.93615372641, 130439.51570787099},
	{0.00000617838, 3.98693992284, 156527.41884944518},
	{0.00000162955, 0.75452718043, 182615.32199101939},
	{0.00000070135, 1.35447664024, 24978.52458948080},
	{0.00000063991, 1.18000294070, 27197.28169366760},
	{0.00000043082, 3.80528844384, 208703.22513259358},
	{0.00000017706, 4.40634127417, 51066.42773105500},
	{0.00000013279, 4.22577566721, 53285.18483524180},
	{0.00000011682, 1.76404497924, 1109.37855209340},
	{0.00000012619, 6.12221497999, 1059.38193018920},
	{0.00000011650, 5.06720847010, 20426.57109242200},
	{0.00000011421, 0.57284937520, 234791.12827416777},
	{0.00000008018, 3.73528031615, 31749.23519072640},
	{0.00000006099, 3.87856029780, 4551.95349705880},
	{0.00000004738, 4.97800929323, 21535.94964451540},
	{0.00000004881, 1.17454074876, 77154.33087262919},
	{0.00000004307, 1.83017640372, 46514.47423399620},
	{0.00000004460, 3.53571937802, 25132.30339996560},
	{0.00000003936, 0.80973598550, 1589.07289528380},
	{0.00000004037, 2.84879735121, 27147.28507176339},
	{0.00000003784, 2.61021114752, 14765.23904326980},
	{0.00000003952, 5.27139824600, 27043.50288318280},
	{0.00000004218, 2.70289062748, 51116.42435295920},
	{0.00000003299, 5.80945771947, 26617.59410666880},
	{0.00000003022, 3.11389766991, 25558.21217647960},
	{0.00000003036, 3.62362220555, 260879.03141574195},
	{0.00000002928, 4.94900975921, 26068.23338067440},
	{0.00000002916, 3.86813577657, 26107.57290247399},
	{0.00000002398, 2.02069419116, 26091.78447693220},
	{0.00000002392, 0.51342544634, 26084.02180621620},
	{0.00000002070, 3.88639207621, 30639.85663863300},
	{0.00000002070, 6.19899610943, 37410.56723987860},
	{0.00000001993, 0.93804934862, 79373.08797681599},
	{0.00000001864, 4.94267930925, 47623.85278608960},
	{0.00000001583, 0.12078429237, 9103.90699411760},
	{0.00000001574, 5.88839166356, 955.59974160860},
	{0.00000001517, 5.15214768135, 19317.19254032860},
	{0.00000001406, 4.88025959589, 72602.37737557039},
	{0.00000001366, 1.71840454751, 50586.73338786459},
	{0.00000001513, 2.21352358383, 12566.15169998280},
	{0.00000001392, 0.48634980709, 426.59819087600},
	{0.00000001228, 2.36966134706, 52705.49724824299},
	{0.00000001329, 0.91947275142, 26095.01668857500},
	{0.00000001297, 1.64793153920, 26080.78959457339},
	{0.00000001485, 1.42812285205, 23869.14603738740},
	{0.00000001109, 5.93496425650, 53235.18821333759},
	{0.00000001170, 3.92015942653, 3442.57494496540},
	{0.00000001084, 3.70940677149, 32858.61374281979},
	{0.00000001288, 1.12226805319, 28306.66024576099},
	{0.00000001252, 0.25878403718, 51220.20654153979},
	{0.00000001381, 4.22593487926, 103242.23401420339},
	{0.00000001059, 4.93178280597, 529.69096509460},
	{0.00000000964, 2.00174932268, 53131.40602475700},
	{0.00000001106, 4.94616537059, 22645.32819660879},
	{0.00000000864, 5.66060639309, 40853.14218484400},
	{0.00000000858, 3.76385932364, 27676.97603685800},
	{0.00000000858, 5.73806224669, 25874.60404613620},
	{0.00000000926, 5.45535000947, 639.89728631400},
	{0.00000000824, 3.08049270116, 26301.20223701220},
	{0.00000000883, 0.45084463736, 11322.66409830440},
	{0.00000000809, 0.39136440746, 286966.93455731616},
	{0.00000000890, 0.56532726320, 83925.04147387479},
	{0.00000000838, 3.20685394363, 36301.18868778519},
	{0.00000000745, 0.63676880132, 56727.75978020720},
	{0.00000000726, 4.24035820533, 6770.71060124560},
	{0.00000000731, 6.21695250751, 18849.22754997420},
	{0.00000000715, 2.44570090401, 43071.89928903080},
	{0.00000000668, 1.71704627521, 52156.13652224860},
	{0.00000000673, 3.24136414552, 1052.26838318840},
	{0.00000000733, 0.31521674193, 39609.65458316560},
	{0.00000000702, 5.58423906419, 15874.61759536320},
	{0.00000000810, 2.76691780988, 1066.49547719000},
	{0.00000000576, 0.68273915307, 5661.33204915220},
	{0.00000000555, 1.44480865678, 2118.76386037840},
	{0.00000000598, 5.40710232495, 51646.11531805379},
	{0.00000000540, 2.73251678283, 16983.99614745660},
	{0.00000000538, 5.07690787025, 52179.68761850640},
	{0.00000000619, 6.13858968874, 25028.52121138500},
	{0.00000000665, 3.93109197005, 29530.47808653960},
	{0.00000000506, 5.24159135308, 38654.05484155699},
	{0.00000000530, 3.36422519322, 26514.50133245020},
	{0.00000000473, 3.59055175449, 110012.94461544899},
	{0.00000000487, 2.93506686309, 63498.47038145279},
	{0.00000000522, 0.62912353695, 52195.47604404819},
	{0.00000000441, 1.64790874543, 98690.28051714458},
	{0.00000000534, 1.70054963408, 2218.75710418680},
	{0.00000000435, 2.54548425009, 33326.57873317420},
	{0.00000000476, 2.07918702570, 51749.20809227239},
	{0.00000000435, 3.56264869714, 52171.92494779040},
	{0.00000000401, 3.23464522849, 7238.67559160000},
	{0.00000000392, 5.33365190740, 78793.40038981718},
	{0.00000000407, 4.44476287637, 52168.69273614759},
	{0.00000000362, 0.42873204406, 58946.51688439399},
	{0.00000000359, 6.23300670520, 62389.09182935939},
	{0.00000000379, 5.70187484299, 103292.23063610759},
	{0.00000000327, 2.73153219856, 79323.09135491178},
	{0.00000000394, 0.99378340812, 129330.13715577759},
	{0.00000000387, 3.94846766008, 52182.91983014920},
	{0.00000000315, 4.54497673319, 76674.63652943878},
	{0.00000000324, 4.48254226320, 49957.04917896160},
	{0.00000000334, 2.48260797685, 68050.42387851159},
	{0.00000000298, 4.99631840995, 48733.23133818299},
	{0.00000000379, 4.15724883772, 54394.56338733519},
	{0.00000000315, 3.35778860471, 51535.90899683439},
	{0.00000000369, 3.28585153276, 77308.10968311399},
	{0.00000000317, 1.92463402354, 45405.09568190280},
	{0.00000000321, 2.67304207488, 13655.86049117640},
	{0.00000000305, 4.89249914414, 7.11354700080},
	{0.00000000263, 6.20975408266, 52389.10537858640},
	{0.00000000235, 5.56250286661, 51123.53789995999},
	{0.00000000232, 3.67747292832, 82815.66292178139},
	{0.00000000223, 2.42466836013, 66941.04532641819},
	{0.00000000216, 3.44223471965, 313054.83769889036},
	{0.00000000226, 1.80631316423, 32370.97899156560},
	{0.00000000278, 6.04510796667, 51109.31080595839},
	{0.00000000198, 0.48439148557, 53764.87917843220},
	{0.00000000198, 5.45868421930, 69159.80243060499},
	{0.00000000198, 1.05088517434, 50057.04242277000},
	{0.00000000204, 2.45848643380, 129380.13377768178},
	{0.00000000202, 2.90008957782, 44937.13069154840},
	{0.00000000186, 0.34501313169, 136100.84775702319},
	{0.00000000184, 0.66520680194, 419.48464387520},
	{0.00000000179, 2.18135449870, 51962.50718771040},
	{0.00000000198, 6.24548788507, 38519.94579197200},
	{0.00000000175, 3.70186890404, 105460.99111839019},
	{0.00000000170, 4.76480820754, 78244.03966382280},
	{0.00000000174, 5.50628514595, 94138.32702008578},
	{0.00000000228, 0.17150693291, 433.71173787680},
	{0.00000000158, 2.02200752968, 64741.95798313119},
	{0.00000000159, 4.59781203561, 853.19638175200},
	{0.00000000154, 3.11106938682, 35191.81013569180},
	{0.00000000149, 5.55768086104, 59414.48187474840},
	{0.00000000147, 0.13708317947, 52602.40447402440},
	{0.00000000144, 4.84328699315, 23754.70674870219},
	{0.00000000182, 0.69098340435, 55618.38122811380},
	{0.00000000181, 5.38091227869, 57837.13833230060},
	{0.00000000141, 0.43737121379, 19804.82729158280},
	{0.00000000154, 1.82260394090, 99799.65906923798},
	{0.00000000139, 4.62954456179, 25973.46385288896},
	{0.00000000139, 4.17648511776, 26202.34243025941},
	{0.00000000150, 0.38751874779, 12432.04265039780},
	{0.00000000191, 2.30641502359, 26727.80042788820},
	{0.00000000146, 5.94769996528, 77734.01845962799},
	{0.00000000135, 1.84579237766, 78267.59076008058},
	{0.00000000129, 3.00023369224, 88476.99497093359},
	{0.00000000149, 5.86186493808, 27154.39861876420},
	{0.00000000135, 4.69551709590, 124778.18365871879},
	{0.00000000121, 2.04673401184, 104881.30353139139},
	{0.00000000117, 5.62340094017, 26241.68195205900},
	{0.00000000146, 2.33019644576, 213.29909543800},
	{0.00000000114, 3.20229489909, 25934.12433108940},
	{0.00000000111, 4.43341533070, 28206.66700195260},
	{0.00000000108, 0.12055562317, 27140.17152476259},
	{0.00000000108, 4.00300903450, 28421.09953444620},
	{0.00000000115, 2.44069966013, 103821.92160120218},
	{0.00000000147, 5.78118598550, 25661.30495069820},
	{0.00000000143, 3.36413722238, 1596.18644228460},
	{0.00000000112, 4.03628252899, 155418.04029735178},
	{0.00000000113, 0.89323533784, 5327.47610838280},
	{0.00000000101, 1.94624186930, 25619.93815121980},
	{0.00000000103, 3.99533045688, 2333.19639287200},
	{0.00000000098, 0.58109085915, 26555.86813192860},
	{0.00000000118, 0.18946350402, 7994.52844202420},
	{0.00000000109, 0.03546800856, 103396.01282468818},
	{0.00000000096, 4.82412903185, 58458.88213313979},
	{0.00000000095, 1.17322458014, 78256.59587772179},
	{0.00000000108, 4.55255767260, 79219.30916633119},
	{0.00000000097, 5.79799018982, 105410.99449648599},
	{0.00000000104, 3.38377920613, 91785.46086631398},
	{0.00000000094, 2.84735719730, 1581.95934828300},
	{0.00000000090, 4.81615242206, 125887.56221081219},
	{0.00000000084, 1.63978190741, 74821.13447975718},
	{0.00000000083, 5.10540266957, 24498.83024629040},
	{0.00000000083, 0.21041749661, 77623.81213840858},
	{0.00000000098, 3.79443655655, 71980.63357473118},
	{0.00000000080, 5.50123915378, 155468.03691925599},
	{0.00000000081, 1.24471501739, 76044.95232053580},
	{0.00000000082, 2.10079395964, 10213.28554621100},
	{0.00000000081, 3.47273729856, 26137.89976347840},
	{0.00000000087, 0.96769986532, 80482.46652890938},
	{0.00000000081, 5.32947215471, 26037.90651966999},
	{0.00000000078, 0.98498478741, 73711.75592766379},
	{0.00000000105, 0.71334145620, 78270.82297172339},
	{0.00000000104, 3.66342015283, 78283.37918562238},
	{0.00000000089, 0.32104107901, 78259.82808936459},
	{0.00000000077, 5.22885086883, 18207.81398823521},
	{0.00000000081, 2.33694388762, 77211.44104153418},
	{0.00000000082, 2.81119087789, 77197.21394753258},
	{0.00000000067, 3.45611920251, 85034.42002596818},
	{0.00000000066, 2.25341317524, 120226.23016165999},
	{0.00000000076, 3.36946418463, 149.56319713460},
	{0.00000000066, 3.38335740927, 162188.75089859738},
	{0.00000000071, 0.43788427177, 108903.56606335558},
	{0.00000000064, 1.72668339565, 51756.32163927320},
	{0.00000000061, 0.85156750769, 102762.53967101299},
	{0.00000000061, 5.87232894228, 536.80451209540},
	{0.00000000073, 0.71807111236, 522.57741809380},
	{0.00000000080, 0.95243616639, 41962.52073693740},
	{0.00000000076, 3.02910585186, 78477.00852016058},
	{0.00000000063, 5.48151873299, 93028.94846799239},
	{0.00000000078, 4.97215052079, 71492.99882347698},
	{0.00000000077, 2.34940739586, 51742.09454527159},
	{0.00000000077, 2.23039388415, 25565.32572348040},
	{0.00000000057, 2.02164287621, 2648.45482547300},
	{0.00000000058, 0.20188459959, 339142.74084046457},
	{0.00000000055, 3.39931628865, 13521.75144159140},
	{0.00000000055, 3.95248458913, 76144.94556434419},
	{0.00000000060, 3.68878783807, 33967.99229491319},
	{0.00000000060, 5.91873713879, 71025.03383312259},
	{0.00000000056, 0.12827895263, 117873.36400788819},
	{0.00000000053, 5.28346247937, 10021.83728009940},
	{0.00000000055, 4.21946130925, 51322.60990139639},
	{0.00000000053, 3.50270077624, 79852.78232000639},
	{0.00000000054, 4.92792314090, 78050.41032928458},
	{0.00000000058, 2.81154337799, 64607.84893354619},
	{0.00000000053, 0.59571673904, 98068.53671630539},
	{0.00000000068, 0.28167911102, 26610.48055966799},
	{0.00000000049, 5.08570479388, 90829.86112470538},
	{0.00000000050, 4.43499705514, 131548.89425996438},
	{0.00000000057, 5.89765927926, 632.78373931320},
	{0.00000000050, 3.73696798374, 81706.28436968799},
	{0.00000000057, 1.99845655428, 26624.70765366959},
	{0.00000000048, 1.72165289468, 46848.33017476560},
	{0.00000000051, 5.44789453960, 129909.82474277639},
	{0.00000000055, 2.67037457843, 18093.37469954999},
	{0.00000000045, 1.53256570325, 104331.94280539699},
	{0.00000000043, 3.21375486020, 78690.30761559859},
	{0.00000000050, 5.55955993807, 647.01083331480},
	{0.00000000060, 2.46786657303, 44181.27784112419},
	{0.00000000042, 6.05032686000, 114564.89811250778},
	{0.00000000050, 0.35287690462, 25448.00585526019},
	{0.00000000046, 3.01593133957, 76.26607127560},
	{0.00000000052, 5.71954387859, 39743.76363275060},
	{0.00000000043, 5.20907523109, 103925.01437542078},
	{0.00000000039, 1.52015918184, 22759.76748529401},
	{0.00000000047, 4.16294922404, 7880.08915333899},
	{0.00000000051, 0.64336380499, 25551.09862947879},
	{0.00000000037, 1.54306065932, 151975.46535238638},
	{0.00000000044, 3.24253086773, 26521.61487945100},
	{0.00000000050, 5.41249272242, 50579.61984086379},
	{0.00000000041, 5.42065925757, 52815.70356946240},
	{0.00000000036, 1.60823257348, 84546.78527471398},
	{0.00000000035, 3.16352925954, 25984.81036735560},
	{0.00000000042, 5.31330734899, 25881.71759313700},
	{0.00000000038, 1.94461159801, 20760.42703319140},
	{0.00000000040, 3.45207563685, 26294.08869001139},
	{0.00000000041, 1.46373068876, 150866.08680029298},
	{0.00000000041, 2.59929301074, 52329.58509363319},
	{0.00000000033, 5.65242255825, 26190.99591579279},
	{0.00000000043, 4.45960439238, 26507.38778544939},
	{0.00000000035, 0.94458988495, 157636.79740153858},
	{0.00000000033, 5.49712174212, 89586.37352302698},
	{0.00000000033, 1.02557119665, 29416.03879785439},
	{0.00000000037, 5.05612012470, 130969.20667296558},
	{0.00000000045, 4.56329533173, 6681.22485339960},
	{0.00000000032, 0.81223636394, 181505.94343892598},
	{0.00000000036, 4.90396980927, 104355.49390165479},
	{0.00000000033, 2.20907300044, 95247.70557217918},
	{0.00000000030, 3.64034430247, 52643.77127350280},
	{0.00000000032, 3.07834718000, 129483.91596626239},
	{0.00000000032, 5.92360692203, 50593.84693486539},
	{0.00000000030, 2.26774333910, 181555.94006083018},
	{0.00000000031, 0.94422467729, 52290.24557183361},
	{0.00000000030, 6.02102768353, 105307.21230790539},
	{0.00000000032, 3.17587486064, 51639.00177105299},
	{0.00000000031, 3.79079245196, 77204.32749453338},
	{0.00000000030, 2.65307578652, 53242.30176033840},
	{0.00000000028, 0.76476883745, 54509.00267602040},
	{0.00000000030, 3.96649414762, 25668.41849769900},
	{0.00000000026, 1.39174885866, 52061.36699446317},
	{0.00000000026, 5.17584348971, 29428.51556827400},
	{0.00000000031, 1.42512028038, 26941.09952332620},
	{0.00000000025, 4.71318347837, 956.28915597060},
	{0.00000000025, 3.82482687733, 22747.29071487440},
	{0.00000000026, 0.12161666654, 26237.46633870879},
	{0.00000000029, 3.76445788944, 104358.72611329758},
	{0.00000000029, 2.57759749899, 131498.89763806018},
	{0.00000000024, 1.15377636817, 54294.57014352679},
	{0.00000000023, 5.31248405128, 146314.13330323418},
	{0.00000000024, 2.14828351418, 25035.63475838580},
	{0.00000000023, 3.51522402665, 42153.96900304900},
	{0.00000000025, 2.81295161547, 25021.40766438420},
	{0.00000000023, 3.16185186674, 143961.26714946238},
	{0.00000000026, 0.16015479279, 27684.08958385880},
	{0.00000000023, 0.76234430512, 85502.38501632259},
	{0.00000000023, 1.93214715353, 130012.91751699499},
	{0.00000000021, 4.22606773111, 104344.49901929598},
	{0.00000000021, 4.30403088752, 102132.85546210999},
	{0.00000000023, 4.82095240983, 77844.22478084739},
	{0.00000000023, 6.09848080953, 61279.71327726600},
	{0.00000000024, 5.43301943304, 52026.24308601380},
	{0.00000000021, 4.82582614568, 206.18554843720},
	{0.00000000028, 5.39827333268, 103299.34418310839},
	{0.00000000021, 3.65808766486, 124156.43985787958},
	{0.00000000023, 5.40550001829, 77829.99768684579},
	{0.00000000021, 0.15049062299, 188276.65404017158},
	{0.00000000020, 0.71942657444, 1478.86657406440},
	{0.00000000019, 2.08327707784, 52125.80966124419},
	{0.00000000019, 0.39572623459, 49527.35145767539},
	{0.00000000020, 5.86539829358, 103285.11708910679},
	{0.00000000019, 3.38049497890, 103711.71527998279},
	{0.00000000019, 1.62343185954, 3328.13565628019},
	{0.00000000022, 6.13349712417, 104564.91166173479},
	{0.00000000026, 5.96914298480, 13362.44970679920},
	{0.00000000025, 4.72474160158, 24864.08530079559},
	{0.00000000021, 1.75089409332, 97580.90196505119},
	{0.00000000019, 3.21617188609, 53228.07466633679},
	{0.00000000024, 4.07017150249, 27311.72098235281},
	{0.00000000019, 0.01409672971, 115674.27666460119},
	{0.00000000021, 0.42232709112, 104371.28232719658},
	{0.00000000018, 3.95444821177, 106570.36967048359},
	{0.00000000022, 3.48072739991, 134991.46920492979},
	{0.00000000017, 0.85708896301, 1162.47470440780},
	{0.00000000016, 1.01452476805, 77410.51304297059},
	{0.00000000019, 3.35287626013, 52698.38370124219},
	{0.00000000017, 1.53003869474, 104138.31347085879},
	{0.00000000016, 2.76299512297, 12546.48193908300},
	{0.00000000015, 4.67333162818, 100909.03762133139},
	{0.00000000018, 2.36207795372, 131395.11544947959},
	{0.00000000016, 5.51525513218, 25867.49049913539},
	{0.00000000016, 0.14257422390, 60055.89543648739},
	{0.00000000015, 1.22870448460, 65697.55772473979},
	{0.00000000016, 3.31067179278, 26308.31578401300},
	{0.00000000021, 4.56372121432, 11610.55195837420},
	{0.00000000020, 3.01802641783, 51543.02254383520},
	{0.00000000017, 3.21776480838, 51528.79544983359},
	{0.00000000015, 6.06025379954, 26164.16921284980},
	{0.00000000020, 4.28247273571, 45494.58142974879},
	{0.00000000019, 2.18136203189, 155997.72788435058},
	{0.00000000017, 2.13417847261, 76667.52298243798},
	{0.00000000018, 2.25020745189, 119116.85160956658},
	{0.00000000016, 4.97934330897, 52712.61079524379},
	{0.00000000017, 5.06532306406, 49842.60989027639},
	{0.00000000014, 6.04847951703, 90695.75207512038},
	{0.00000000014, 2.00566016514, 44295.71712980940},
	{0.00000000014, 3.89737183526, 183724.70054311278},
	{0.00000000014, 3.18665999637, 27999.10262479140},
	{0.00000000019, 3.37998775559, 104347.73123093879},
	{0.00000000014, 3.19141679400, 2111.65031337760},
	{0.00000000015, 0.17179065008, 52225.80290505260},
	{0.00000000018, 2.68126129305, 97112.93697469679},
	{0.00000000015, 3.20359726329, 128850.44281258718},
	{0.00000000016, 5.81395988324, 52099.54021187280},
	{0.00000000014, 1.85956386315, 116917.76426627958},
	{0.00000000015, 3.25430509963, 365230.64398203876},
	{0.00000000013, 5.63989609373, 24176.70365835700},
	{0.00000000014, 3.14536047801, 111590.28815789679},
	{0.00000000014, 5.20815151417, 25953.79409198919},
	{0.00000000013, 4.58713099926, 178063.36849396059},
	{0.00000000014, 0.49361194238, 107794.18751126219},
	{0.00000000015, 0.24966144265, 105940.68546158058},
	{0.00000000014, 3.58612114877, 26222.01219115920},
	{0.00000000015, 4.47532653098, 40565.25432477420},
	{0.00000000013, 2.11806707918, 323.50541665740},
	{0.00000000015, 6.00200377172, 27669.86248985719},
	{0.00000000013, 4.88852328329, 14477.35118320000},
	{0.00000000012, 2.67513147421, 76681.75007643958},
	{0.00000000012, 4.62759446539, 72936.23331633979},
	{0.00000000012, 3.92223202416, 16066.06586147480},
	{0.00000000013, 2.82189216105, 140652.80125408198},
	{0.00000000012, 6.06250888369, 52072.71350892979},
	{0.00000000015, 3.45337214515, 77837.11123384659},
	{0.00000000015, 3.92082035349, 2125.87740737920},
	{0.00000000012, 5.77007103086, 1692.16566950240},
	{0.00000000014, 2.72526558025, 38813.35657634920},
	{0.00000000012, 4.67458570991, 110634.68841628819},
	{0.00000000012, 0.55371302918, 102232.84870591838},
	{0.00000000011, 2.00033237383, 36109.74042167360},
	{0.00000000011, 1.10539607022, 26198.10946279360},
	{0.00000000014, 5.75250501205, 78417.48823520739},
	{0.00000000012, 0.46344500005, 45892.73043315699},
	{0.00000000012, 3.62733339243, 31415.37924995700},
	{0.00000000011, 0.14540231257, 111122.32316754239},
	{0.00000000011, 6.27463466728, 104778.21075717278},
	{0.00000000011, 1.42069515516, 25977.69682035479},
	{0.00000000011, 6.17305766602, 39629.32434406539},
	{0.00000000011, 2.54959001341, 51969.62073471119},
	{0.00000000015, 1.08931229419, 32769.12799497380},
	{0.00000000010, 4.00452085532, 55503.94193942859},
	{0.00000000012, 4.58411493514, 130419.84594697120},
	{0.00000000011, 2.95045626847, 141762.17980617538},
	{0.00000000013, 5.16720446526, 70269.18098269838},
	{0.00000000010, 5.01492480888, 28736.35796704720},
	{0.00000000012, 2.34850046455, 220.41264243880},
	{0.00000000013, 5.70406073241, 25654.19140369739},
	{0.00000000010, 2.23466649370, 78903.60671103658},
	{0.00000000012, 5.60290289064, 224.34479570190},
	{0.00000000010, 6.22843606515, 170049.17029103659},
	{0.00000000010, 5.31334628497, 207643.84320240439},
	{0.00000000012, 4.98783133373, 26395.46076254379},
	{0.00000000012, 3.81738635107, 25780.34552060460},
	{0.00000000012, 2.61068546931, 26724.89941359840},
	{0.00000000012, 6.19453221549, 25450.90686955000},
	{0.00000000009, 4.05684885963, 51219.51712717779},
	{0.00000000009, 6.12208983529, 155571.81910783658},
	{0.00000000009, 0.41261244956, 78731.67441507700},
	{0.00000000012, 0.71134314907, 25446.48957983520},
	{0.00000000012, 1.81068922855, 26729.31670331319},
	{0.00000000010, 2.47468110683, 65831.66677432480},
	{0.00000000009, 0.40952403441, 16703.06213349900},
	{0.00000000009, 4.90697568305, 51707.84129279399},
	{0.00000000009, 3.85732708279, 207593.84658050018},
	{0.00000000009, 4.96561807224, 156100.82065856918},
	{0.00000000009, 3.75776745639, 1911.19948321720},
	{0.00000000012, 4.51598356731, 176953.98994186718},
	{0.00000000011, 3.03748956531, 12725.45343477500},
	{0.00000000009, 0.04073004429, 52609.51802102519},
	{0.00000000009, 1.91710703544, 55516.41870984820},
	{0.00000000010, 0.81972980160, 52022.02747266360},
	{0.00000000008, 4.36451680511, 52182.43484204840},
	{0.00000000011, 1.79573927984, 157057.10981453978},
	{0.00000000010, 0.38285944104, 52381.99183158559},
	{0.00000000009, 4.83864149352, 19.66976089979},
	{0.00000000008, 4.79233550623, 27177.61193276780},
	{0.00000000008, 4.01288217857, 24998.19435038059},
	{0.00000000008, 2.85801662646, 26720.68688088739},
	{0.00000000008, 4.56240457496, 48847.67062686820},
	{0.00000000008, 4.66429418352, 860.30992875280},
	{0.00000000008, 0.38701534981, 13541.42120249119},
	{0.00000000008, 4.10511816483, 1223.81784077861},
	{0.00000000007, 0.36409349149, 68241.87214462319},
	{0.00000000008, 1.38258172759, 52595.29092702359},
	{0.00000000008, 0.52005477263, 130446.62925487179},
	{0.00000000007, 1.77349206529, 50696.93970908399},
	{0.00000000009, 1.66361806448, 130443.39704322898},
	{0.00000000007, 0.73615049600, 209812.60368468695},
	{0.00000000009, 1.23134600870, 52169.17772424839},
	{0.00000000007, 2.07118222069, 172402.03644480839},
	{0.00000000007, 5.46443083494, 846.08283475120},
	{0.00000000007, 1.93763204899, 35472.74414964940},
	{0.00000000007, 1.48249068512, 27044.19229754480},
	{0.00000000007, 0.42254434487, 150244.34299945379},
	{0.00000000009, 2.36048752326, 26734.91397488900},
	{0.00000000007, 3.18648827109, 52325.36948028299},
	{0.00000000007, 2.24046065624, 9384.84100807520},
	{0.00000000007, 3.81340646490, 80596.90581759460},
	{0.00000000006, 2.21280392322, 52278.89905736699},
	{0.00000000008, 2.16932671663, 129387.24732468258},
	{0.00000000008, 1.13965005489, 25234.70675982219},
	{0.00000000008, 6.21586114247, 77726.90491262719},
	{0.00000000006, 5.71782638960, 79330.20490191258},
	{0.00000000007, 3.99442191803, 78378.14871340781},
	{0.00000000006, 2.63385868818, 129373.02023068098},
	{0.00000000007, 0.06529608191, 26162.68474014150},
	{0.00000000006, 1.55390090257, 51013.33157874059},
	{0.00000000006, 3.29219308990, 75615.25459924959},
	{0.00000000007, 5.23140732853, 157483.01859105378},
	{0.00000000006, 2.46763974875, 26013.12154300690},
	{0.00000000006, 6.03059495880, 137678.19129947099},
	{0.00000000006, 2.93834812676, 130652.81480330898},
	{0.00000000007, 6.14935848430, 77630.92568540938},
	{0.00000000006, 4.96304042103, 25508.21555457540},
	{0.00000000006, 3.84217726377, 26667.59072857300},
	{0.00000000006, 0.29225742955, 6885.14988993081},
	{0.00000000006, 2.18079162130, 103917.90082841998},
	{0.00000000008, 5.64484638063, 157586.80077963437},
	{0.00000000006, 4.16879920974, 80382.47328510099},
	{0.00000000006, 0.66117422106, 34282.17847478280},
	{0.00000000007, 3.20892469724, 214364.55718174578},
	{0.00000000007, 2.79508447590, 25754.04720080480},
	{0.00000000007, 6.01013320890, 26421.75908234360},
	{0.00000000006, 4.43814061291, 78149.27013603736},
	{0.00000000005, 5.60856067263, 50064.15596977079},
	{0.00000000006, 1.06133168572, 128220.75860368418},
	{0.00000000005, 4.48886015660, 130226.21661243298},
	{0.00000000006, 4.78075047395, 123668.80510662538},
	{0.00000000005, 4.50559999191, 110.20632121940},
	{0.00000000005, 5.89140407331, 102769.65321801379},
	{0.00000000005, 2.50213086189, 19406.67828817460},
	{0.00000000006, 1.60825783072, 103932.12792242158},
	{0.00000000006, 0.24754368045, 161079.37234650398},
	{0.00000000006, 3.54848918635, 86143.79857806159},
	{0.00000000007, 5.68676720253, 64901.25971792339},
	{0.00000000006, 1.96214622184, 1265.56747862640},
	{0.00000000005, 5.11989980868, 78213.71280281838},
	{0.00000000006, 5.18848518823, 182085.63102592478},
	{0.00000000006, 0.59952467665, 51653.22886505459},
	{0.00000000005, 5.44401843923, 102755.42612401219},
	{0.00000000006, 1.15772089340, 8194.27533320860},
	{0.00000000005, 0.85038224536, 53399.62412392700},
	{0.00000000005, 2.42671724536, 27780.06881107659},
	{0.00000000005, 5.22476504934, 26402.08932144380},
	{0.00000000005, 3.58045263546, 25773.71696170459},
	{0.00000000006, 3.39764117475, 6283.07584999140},
	{0.00000000005, 2.42996301937, 25938.33994443960},
	{0.00000000005, 0.01470040312, 77616.69859140778},
	{0.00000000006, 4.89504933760, 50049.92887576919},
	{0.00000000005, 1.99586214710, 17893.62780836560},
	{0.00000000004, 6.00566134496, 167850.08294774959},
	{0.00000000006, 5.77707621428, 154938.34595416138},
	{0.00000000005, 4.78954041827, 3340.61242669980},
	{0.00000000004, 0.97602564752, 130432.40216087017},
	{0.00000000004, 0.40741730958, 51852.30086649099},
	{0.00000000005, 1.35488481256, 204151.27163553478},
	{0.00000000004, 3.67345614971, 636.99627202420},
	{0.00000000004, 2.74223078461, 116783.65521669458},
	{0.00000000005, 2.74366605427, 39450.35284837340},
	{0.00000000004, 1.23165526523, 51955.39364070959},
	{0.00000000004, 4.09127907081, 103498.41618454478},
	{0.00000000004, 2.37045324906, 45290.65639321759},
	{0.00000000005, 0.06895267430, 52396.21892558720},
	{0.00000000004, 2.56354623790, 104505.39137678158},
	{0.00000000005, 5.71032452100, 123200.84011627098},
	{0.00000000004, 0.59460014711, 28791.51929624980},
	{0.00000000004, 1.92743223051, 23384.28698689860},
	{0.00000000005, 4.52669072840, 53029.00266490040},
	{0.00000000004, 1.81268637965, 26823.77965510599},
	{0.00000000004, 0.70934599797, 25352.02662804239},
	{0.00000000004, 3.53975344268, 133882.09065283638},
	{0.00000000004, 3.01935498774, 50483.64061364600},
	{0.00000000004, 2.01334717451, 183570.92173262799},
	{0.00000000004, 3.22384434044, 53771.99272543299},
	{0.00000000005, 5.28711139263, 145204.75475114079},
	{0.00000000004, 1.34862695530, 27170.98337386779},
	{0.00000000004, 1.17340542232, 25004.82290928060},
	{0.00000000004, 0.14217969958, 78786.28684281638},
	{0.00000000004, 3.51787698369, 1795.25844372100},
	{0.00000000005, 1.84426394169, 26709.64694241340},
	{0.00000000005, 0.67776843593, 25466.15934073500},
	{0.00000000005, 1.25657099336, 32132.13172294960},
	{0.00000000004, 4.27093115110, 52065.59996192899},
	{0.00000000004, 0.10710186975, 2221.85663459700},
	{0.00000000004, 1.11438053331, 78270.33798362259},
	{0.00000000004, 2.21736054801, 96357.08412427259},
	{0.00000000004, 3.34685106694, 949.17560896980},
	{0.00000000004, 1.34025094893, 6044.22858137540},
	{0.00000000004, 4.90309780700, 143005.66740785378},
	{0.00000000004, 1.70672949321, 78800.51393681798},
	{0.00000000004, 0.90136038469, 132658.27281205778},
	{0.00000000004, 6.04765404465, 54087.00576636560},
	{0.00000000004, 3.45396433025, 130459.18546877075},
	{0.00000000004, 2.57433955449, 3178.14579056760},
	{0.00000000004, 3.39420749098, 52250.58788171570},
	{0.00000000004, 2.89280023626, 87367.61641884019},
	{0.00000000003, 2.73132197327, 78160.61665050399},
	{0.00000000003, 4.14416998165, 114.43928868521},
	{0.00000000004, 0.15780189015, 130435.63437251298},
	{0.00000000004, 0.06711300408, 26575.53789282839},
	{0.00000000004, 2.45491937354, 25600.26839032000},
	{0.00000000003, 5.37713404461, 1485.98012106520},
	{0.00000000003, 0.35934615572, 52309.91533273340},
	{0.00000000003, 5.05649683266, 70383.62027138360},
	{0.00000000003, 2.84685809679, 52252.07235442399},
	{0.00000000005, 0.41148055834, 52808.59002246159},
	{0.00000000004, 4.17938922255, 58857.03113654799},
	{0.00000000004, 3.20092050693, 51951.46148744649},
	{0.00000000003, 2.40144059169, 50264.60679993120},
	{0.00000000004, 1.17285198222, 20043.67456019880},
	{0.00000000003, 0.93320061996, 81591.84508100279},
	{0.00000000003, 3.96547374476, 25985.94062330859},
	{0.00000000003, 4.83974394004, 26189.86565983980},
	{0.00000000004, 1.45951607601, 136722.59155786238},
	{0.00000000003, 0.03403776890, 23969.13928119580},
	{0.00000000003, 4.75567563333, 61560.64729122359},
	{0.00000000003, 2.62671587640, 181026.24909573558},
	{0.00000000004, 3.79559151920, 128320.75184749259},
	{0.00000000004, 0.32749351115, 129799.61842155698},
	{0.00000000003, 4.92235874244, 26073.67604757259},
	{0.00000000003, 3.88285894236, 26102.13023557580},
	{0.00000000004, 0.30171000276, 467.96499035440},
	{0.00000000003, 0.49521348870, 2703.61615467560},
	{0.00000000003, 2.83604151145, 19202.75325164339},
	{0.00000000004, 1.29687523233, 37698.45509994840},
	{0.00000000003, 1.87341446779, 26247.20487636640},
	{0.00000000003, 0.64861790983, 25928.60140678200},
	{0.00000000003, 2.68609993628, 103.09277421860},
	{0.00000000004, 3.27872430484, 132028.58860315479},
	{0.00000000003, 1.46102417169, 75930.51303185058},
	{0.00000000004, 5.86092912592, 166740.70439565618},
	{0.00000000003, 0.00693087411, 79315.97780791098},
	{0.00000000003, 3.05784222447, 130866.11389874699},
	{0.00000000003, 3.64997039969, 35077.37084700659},
	{0.00000000003, 0.66136657530, 51868.24866217880},
	{0.00000000003, 4.90383671624, 76784.84285065818},
	{0.00000000004, 5.11822399207, 78109.93061423779},
	{0.00000000003, 5.09644922263, 121335.60871375339},
	{0.00000000003, 4.15087523006, 52286.01260436779},
	{0.00000000003, 4.49117697679, 77101.23472031478},
	{0.00000000003, 4.40672346738, 77741.13200662879},
	{0.00000000003, 1.17033111095, 74.78159856730},
	{0.00000000003, 1.72068912262, 24505.94379329119},
	{0.00000000004, 4.47958960947, 28286.99048486120},
	{0.00000000004, 4.32562807533, 23888.81579828719},
	{0.00000000002, 0.15001821237, 48835.19385644859},
	{0.00000000002, 1.69313010887, 182188.72380014337},
	{0.00000000003, 4.67718054767, 27250.37784598199},
	{0.00000000003, 4.13971825138, 51315.49635439559},
	{0.00000000003, 2.73499122343, 26011.63707029860},
	{0.00000000002, 1.21896533465, 2008.55753915900},
	{0.00000000002, 1.13182429686, 126996.94076290558},
	{0.00000000002, 3.33832397299, 24925.42843716640},
	{0.00000000002, 3.34607115822, 51329.72344839720},
	{0.00000000003, 4.94974770833, 81604.32185142238},
	{0.00000000003, 5.66982181767, 52812.80255517260},
	{0.00000000003, 0.02173421963, 391318.54712361297},
	{0.00000000002, 2.96978628967, 196137.07343261078},
	{0.00000000003, 1.28173018247, 156507.74908854539},
	{0.00000000003, 0.93767773997, 27726.97265876220},
	{0.00000000003, 1.58435463765, 24448.83362438620},
	{0.00000000002, 5.77422284047, 78057.52387628538},
	{0.00000000002, 4.07811706723, 8989.46770543239},
	{0.00000000003, 3.17950494103, 78313.70604662679},
	{0.00000000003, 1.26777637523, 203041.89308344138},
	{0.00000000002, 5.82933637566, 38634.38508065720},
	{0.00000000003, 2.77488316132, 34082.43158359840},
	{0.00000000002, 2.71698289856, 163766.09444104518},
	{0.00000000003, 4.25851095793, 78257.08086582259},
	{0.00000000003, 1.95628126873, 52041.69723356339},
	{0.00000000002, 3.46648506780, 104819.57755665119},
	{0.00000000002, 5.05493269125, 62197.64356324779},
	{0.00000000002, 2.31391865561, 65717.22748563958},
	{0.00000000003, 3.67398707035, 113341.08027172917},
	{0.00000000002, 0.57819709496, 66653.15746634839},
	{0.00000000002, 5.81134538507, 74923.09699802278},
	{0.00000000002, 5.31799111712, 17098.43543614181},
	{0.00000000002, 3.54866382542, 78469.89497315978},
	{0.00000000002, 0.63534070468, 77307.42026875199},
	{0.00000000002, 5.30685200110, 104991.50985261079},
	{0.00000000002, 1.01052937078, 101703.15774082378},
	{0.00000000002, 2.46838836063, 26312.24793727610},
	{0.00000000002, 1.48861622297, 50951.98844236979},
	{0.00000000002, 5.52205824738, 91919.56991589899},
	{0.00000000002, 1.43776747042, 99024.13645791399},
	{0.00000000002, 2.07491313678, 225687.22128005016},
	{0.00000000002, 2.45878629397, 26183.88236879199},
	{0.00000000002, 0.06324608365, 25991.92391435639},
	{0.00000000003, 3.66137462974, 51534.39272140940},
	{0.00000000002, 4.79894731382, 183145.01295611398},
	{0.00000000002, 1.16884626410, 26397.18146422999},
	{0.00000000002, 1.35318611352, 25778.62481891839},
	{0.00000000002, 3.47961101671, 42790.96527507320},
	{0.00000000002, 3.54021512986, 51538.81001112419},
	{0.00000000002, 2.45627954068, 24952.22626968100},
	{0.00000000002, 0.06575283694, 27223.58001346740},
	{0.00000000002, 2.99909862001, 103718.82882698359},
	{0.00000000002, 1.64606671842, 25984.12095299360},
	{0.00000000002, 0.87596565920, 26191.68533015479},
	{0.00000000002, 5.44690335938, 25927.49577218939},
	{0.00000000002, 3.35831432542, 26248.31051095900},
	{0.00000000002, 1.80317516125, 177287.84588263658},
	{0.00000000002, 5.05959592679, 118828.96374949679},
	{0.00000000002, 1.57407073796, 53265.51507434200},
	{0.00000000002, 6.17867775538, 51841.95034237900},
	{0.00000000002, 0.52784265993, 29550.14784743939},
	{0.00000000002, 1.99418971769, 22625.65843570900},
	{0.00000000002, 6.15702102064, 27037.07875054399},
	{0.00000000002, 2.64819666416, 25138.72753260440},
	{0.00000000002, 4.84158872259, 52817.21984488739},
	{0.00000000002, 4.00429984448, 87253.17713015496},
	{0.00000000002, 0.01411567213, 168959.46149984296},
	{0.00000000002, 2.22725796457, 104202.04936916218},
	{0.00000000002, 2.07951392438, 233731.74634397858},
	{0.00000000002, 4.90161061296, 102018.41617342478},
	{0.00000000002, 1.72258811309, 54824.26110862140},
	{0.00000000002, 0.55814555148, 50910.23880452200},
	{0.00000000002, 1.51894844260, 51859.41441349179},
	{0.00000000002, 0.57437116940, 25131.61398560359},
	{0.00000000002, 2.82794115256, 24609.03656750980},
	{0.00000000002, 6.28078149044, 25863.55834587229},
	{0.00000000002, 2.83592703830, 53757.76563143139},
	{0.00000000002, 4.03688605095, 52492.19815280499},
	{0.00000000002, 3.93802376646, 26076.85744131030},
	{0.00000000002, 4.86719391834, 26098.94884183810},
	{0.00000000002, 3.37995643779, 176332.24614102798},
	{0.00000000002, 3.60695289838, 78896.49316403578},
	{0.00000000002, 4.97912201809, 26411.40855823160},
	{0.00000000002, 2.85499495780, 181659.72224941078},
	{0.00000000002, 1.87598894439, 52483.36390411799},
	{0.00000000001, 3.06891862205, 27351.06050415239},
	{0.00000000001, 5.73629906275, 24824.74577899600},
	{0.00000000001, 3.09801335678, 78697.42116259939},
	{0.00000000001, 1.67825434512, 51596.11869614960},
	{0.00000000001, 2.50491935869, 153084.84390447979},
	{0.00000000002, 2.96585642839, 103814.80805420138},
	{0.00000000002, 5.41433241516, 51226.63067417859},
	{0.00000000001, 1.46779104995, 231348.55332920236},
	{0.00000000002, 0.08777712054, 23976.25282819660},
	{0.00000000002, 5.45481395203, 149642.26895951436},
	{0.00000000002, 5.14888486482, 23962.02573419499},
	{0.00000000001, 3.87951272011, 112545.88789950538},
	{0.00000000001, 2.62874092556, 189853.99758261938},
	{0.00000000001, 3.14624674879, 54879.42243782400},
	{0.00000000002, 3.37548806405, 94329.77528619739},
	{0.00000000001, 3.22111896048, 52509.66222391780},
	{0.00000000002, 4.07843204929, 26713.57333388659},
	{0.00000000002, 4.72678563551, 25462.23294926180},
	{0.00000000002, 2.54595097754, 23919.14265929160},
	{0.00000000002, 6.25926670726, 28256.66362385679},
	{0.00000000002, 3.20475280547, 80174.90890793978},
	{0.00000000001, 0.01220959090, 28199.55345495179},
	{0.00000000002, 1.82803437881, 125112.03959948818},
	{0.00000000001, 1.92944311048, 26933.98597632540},
	{0.00000000001, 0.59258926714, 25241.82030682300},
	{0.00000000001, 3.30576238641, 241561.83887541336},
	{0.00000000001, 5.28557867032, 50380.54783942739},
	{0.00000000001, 6.27614032109, 215473.93573383916},
	{0.00000000002, 4.04923139057, 27566.76971563859},
	{0.00000000001, 0.20613619394, 106262.81204951399},
	{0.00000000001, 2.40978376724, 49953.94964855139},
	{0.00000000001, 5.41286890292, 155460.92337225519},
	{0.00000000001, 4.12537467992, 163298.12945069079},
	{0.00000000002, 0.20694684105, 25440.89230825939},
	{0.00000000001, 2.80241855615, 26926.87242932459},
	{0.00000000001, 6.00279912865, 25248.93385382380},
	{0.00000000001, 4.53786604484, 205260.65018762815},
	{0.00000000001, 5.35982042099, 128106.31931499895},
	{0.00000000002, 0.12452737797, 142871.55835826878},
	{0.00000000001, 6.22889842287, 48997.66049258080},
	{0.00000000001, 3.64991019877, 27005.83342755599},
	{0.00000000001, 5.15530748603, 25169.97285559240},
	{0.00000000001, 3.42636128355, 50689.82616208319},
	{0.00000000001, 4.02494689929, 112231.70171963578},
	{0.00000000001, 3.17879397547, 90989.16285949759},
	{0.00000000001, 0.12352160841, 143980.93691036216},
	{0.00000000001, 2.50393985667, 76152.05911134499},
	{0.00000000001, 6.25922905509, 91805.13062721379},
	{0.00000000001, 6.12692757039, 84307.93800609799},
	{0.00000000001, 3.46792746542, 138319.60486120995},
	{0.00000000001, 5.69844148915, 92741.06060792258},
	{0.00000000001, 4.24960627112, 24072.92146977640},
	{0.00000000001, 4.55561141368, 28102.88481337200},
	{0.00000000001, 6.16493393350, 24395.73747207180},
	{0.00000000001, 5.22888939483, 24844.41553989579},
	{0.00000000001, 3.57632828997, 27331.39074325260},
	{0.00000000001, 0.38942177438, 154408.65498906678},
	{0.00000000001, 2.78357107118, 193937.98608932378},
	{0.00000000001, 4.05552152915, 58220.03486452380},
	{0.00000000001, 0.81202957380, 97670.38771289718},
	{0.00000000001, 2.55908057007, 60370.08161635699},
	{0.00000000001, 3.06090263008, 24356.78078864160},
	{0.00000000001, 5.74431505472, 27819.02549450680},
	{0.00000000001, 3.77400510642, 25764.39772491679},
	{0.00000000001, 4.14180223370, 151199.94274106238},
	{0.00000000001, 5.05251600508, 209658.82487420218},
	{0.00000000001, 3.84356790046, 23704.71012679799},
	{0.00000000001, 4.96164978434, 28471.09615635040},
	{0.00000000001, 0.26444294836, 23439.44831610119},
	{0.00000000001, 3.64905591301, 51439.92976961659},
	{0.00000000001, 2.45569831568, 26177.38888942019},
	{0.00000000001, 0.06633406194, 25998.41739372820},
	{0.00000000001, 0.41633866770, 233681.74972207438},
	{0.00000000001, 1.60238548900, 21650.38893320061},
	{0.00000000001, 0.91964688862, 30525.41734994779},
	{0.00000000001, 4.32794152273, 159855.55450572536},
	{0.00000000001, 2.57975917809, 24203.00197815680},
	{0.00000000001, 6.22545850671, 27972.80430499159},
	{0.00000000001, 1.69909342383, 26094.53170047421},
	{0.00000000001, 2.25118383840, 104197.83375581198},
	{0.00000000001, 1.28948419377, 50167.24874398939},
	{0.00000000001, 3.16953164459, 199599.31813847595},
	{0.00000000001, 6.26093145675, 78413.27262185719},
	{0.00000000001, 4.71083057280, 156531.30018480319},
	{0.00000000001, 5.34553007074, 147423.51185532758},
	{0.00000000001, 2.69486500780, 247223.17092456557},
	{0.00000000001, 2.94258825469, 25151.97316086539},
	{0.00000000001, 5.86262943011, 27023.83312228300},
	{0.00000000001, 2.39382184066, 183674.70392120858},
	{0.00000000001, 3.49918672345, 97466.46267636596},
	{0.00000000001, 4.49841046349, 26126.03617721200},
	{0.00000000001, 4.30680722131, 26049.77010593640},
	{0.00000000001, 3.77812730736, 27388.72995977919},
	{0.00000000001, 5.02709037744, 24787.07632336920},
	{0.00000000001, 0.16003886949, 132350.71519108818},
	{0.00000000001, 5.22928116569, 155475.15046625677},
	{0.00000000001, 3.60259923599, 24602.61243487099},
	{0.00000000001, 5.20261844881, 27573.19384827740},
	{0.00000000001, 5.11853435105, 198489.93958638258},
	{0.00000000001, 3.56429469477, 156534.53239644598},
	{0.00000000001, 5.23354450332, 130005.80396999417},
	{0.00000000001, 2.18749112623, 77039.89158394396},
	{0.00000000001, 4.70952350385, 129215.69786709236},
	{0.00000000001, 3.68396287904, 25923.46723098479},
	{0.00000000001, 5.12125480576, 26252.33905216361},
	{0.00000000001, 3.39554226843, 73891.83305794839},
	{0.00000000001, 5.91757464605, 126067.63934109679},
	{0.00000000001, 0.83086794433, 30171.89164827860},
	{0.00000000001, 1.69116443329, 22003.91463486980},
	{0, 0, 0}
};

struct vsop87_term mercury_y2[] = {
	{0.00004612157, 0.00000000000, 0.00000000000},
	{0.00001575670, 2.81172733349, 52175.80628314840},
	{0.00000927896, 5.85368769122, 78263.70942472259},
	{0.00000670255, 0.90964509090, 26087.90314157420},
	{0.00000373744, 2.62279275699, 104351.61256629678},
	{0.00000131389, 5.67519052208, 130439.51570787099},
	{0.00000043188, 2.44402631830, 156527.41884944518},
	{0.00000013650, 5.49573569359, 182615.32199101939},
	{0.00000004206, 2.26403437926, 208703.22513259358},
	{0.00000002984, 6.06067837128, 24978.52458948080},
	{0.00000002686, 2.76365562250, 27197.28169366760},
	{0.00000001274, 5.31539852523, 234791.12827416777},
	{0.00000001027, 2.84300614786, 51066.42773105500},
	{0.00000000381, 2.08333719811, 260879.03141574195},
	{0.00000000352, 5.82507812341, 53285.18483524180},
	{0.00000000335, 3.37537319389, 1109.37855209340},
	{0.00000000356, 5.90144515856, 77154.33087262919},
	{0.00000000178, 5.83879634770, 1589.07289528380},
	{0.00000000197, 2.58901447921, 25132.30339996560},
	{0.00000000165, 4.77968548608, 1059.38193018920},
	{0.00000000174, 6.19970518794, 27043.50288318280},
	{0.00000000138, 0.32050955420, 21535.94964451540},
	{0.00000000152, 3.46766299392, 20426.57109242200},
	{0.00000000125, 4.32480488747, 26617.59410666880},
	{0.00000000117, 4.51608581878, 25558.21217647960},
	{0.00000000119, 0.26940576275, 46514.47423399620},
	{0.00000000113, 5.13479506099, 286966.93455731616},
	{0.00000000108, 1.00337547207, 14765.23904326980},
	{0.00000000126, 6.14682046798, 23869.14603738740},
	{0.00000000106, 1.37019536118, 27147.28507176339},
	{0.00000000121, 2.67342689025, 103242.23401420339},
	{0.00000000107, 2.67501768515, 28306.66024576099},
	{0.00000000103, 5.45719542646, 31749.23519072640},
	{0.00000000086, 3.58192012664, 19317.19254032860},
	{0.00000000095, 2.17047827218, 4551.95349705880},
	{0.00000000067, 4.81636058177, 9103.90699411760},
	{0.00000000077, 0.22294716973, 22645.32819660879},
	{0.00000000066, 2.34654801419, 3442.57494496540},
	{0.00000000059, 3.32463299177, 72602.37737557039},
	{0.00000000060, 2.26631911660, 30639.85663863300},
	{0.00000000059, 2.98425907470, 50586.73338786459},
	{0.00000000060, 0.99475775846, 52705.49724824299},
	{0.00000000059, 1.55381311926, 37410.56723987860},
	{0.00000000066, 5.36962395931, 51220.20654153979},
	{0.00000000058, 5.26315302410, 32858.61374281979},
	{0.00000000052, 3.78393573371, 639.89728631400},
	{0.00000000049, 2.45936277850, 27676.97603685800},
	{0.00000000051, 4.08715478685, 51116.42435295920},
	{0.00000000045, 2.48850621100, 26202.34243025941},
	{0.00000000045, 0.02918998649, 25973.46385288896},
	{0.00000000045, 4.38367721547, 53235.18821333759},
	{0.00000000040, 1.42851453913, 26301.20223701220},
	{0.00000000052, 0.46087243356, 955.59974160860},
	{0.00000000039, 1.10147216023, 25874.60404613620},
	{0.00000000039, 4.08449976646, 40853.14218484400},
	{0.00000000037, 0.24047079066, 2118.76386037840},
	{0.00000000046, 2.36226611879, 29530.47808653960},
	{0.00000000039, 2.71510286457, 53131.40602475700},
	{0.00000000034, 5.34770943540, 56727.75978020720},
	{0.00000000040, 5.72538622894, 129330.13715577759},
	{0.00000000033, 1.89317335643, 313054.83769889036},
	{0.00000000032, 5.81428165747, 6770.71060124560},
	{0.00000000038, 3.26185757209, 2218.75710418680},
	{0.00000000030, 4.05437615641, 43071.89928903080},
	{0.00000000033, 2.92004182064, 49957.04917896160},
	{0.00000000036, 5.40556752348, 529.69096509460},
	{0.00000000025, 0.09705599716, 98690.28051714458},
	{0.00000000030, 0.44155155116, 47623.85278608960},
	{0.00000000023, 4.22922851538, 16983.99614745660},
	{0.00000000024, 3.94664051894, 78793.40038981718},
	{0.00000000024, 1.99165646805, 77308.10968311399},
	{0.00000000028, 5.72914844642, 54394.56338733519},
	{0.00000000022, 0.35963548929, 45405.09568190280},
	{0.00000000024, 5.32858635997, 18849.22754997420},
	{0.00000000018, 0.17787797764, 52156.13652224860},
	{0.00000000018, 1.16105857213, 79323.09135491178},
	{0.00000000022, 1.11933727537, 13655.86049117640},
	{0.00000000018, 0.83099200037, 12566.15169998280},
	{0.00000000018, 4.54633317296, 52389.10537858640},
	{0.00000000018, 5.02672541458, 51535.90899683439},
	{0.00000000018, 1.65595798708, 51646.11531805379},
	{0.00000000016, 0.09513192311, 23754.70674870219},
	{0.00000000016, 1.99438250231, 58946.51688439399},
	{0.00000000015, 3.83660842048, 38654.05484155699},
	{0.00000000016, 2.81765573502, 213.29909543800},
	{0.00000000015, 2.03096195084, 5661.33204915220},
	{0.00000000015, 0.22694790547, 48733.23133818299},
	{0.00000000015, 5.36500920222, 426.59819087600},
	{0.00000000016, 2.08963950452, 11322.66409830440},
	{0.00000000015, 2.10902101239, 82815.66292178139},
	{0.00000000014, 2.78613814970, 853.19638175200},
	{0.00000000014, 3.52261302721, 52179.68761850640},
	{0.00000000015, 2.61226501657, 79373.08797681599},
	{0.00000000014, 0.87917385569, 66941.04532641819},
	{0.00000000014, 5.41787560745, 53764.87917843220},
	{0.00000000014, 2.07377604640, 110012.94461544899},
	{0.00000000014, 1.61288448694, 36301.18868778519},
	{0.00000000013, 2.42169327872, 28421.09953444620},
	{0.00000000013, 5.77387844338, 76674.63652943878},
	{0.00000000015, 5.36990490192, 52195.47604404819},
	{0.00000000016, 3.41100376315, 33326.57873317420},
	{0.00000000013, 5.40167186911, 83925.04147387479},
	{0.00000000016, 5.39991081548, 55618.38122811380},
	{0.00000000013, 2.49786568147, 155418.04029735178},
	{0.00000000012, 2.28713351757, 50057.04242277000},
	{0.00000000013, 2.01707000795, 52171.92494779040},
	{0.00000000014, 0.57769767887, 26727.80042788820},
	{0.00000000011, 4.62449766576, 62389.09182935939},
	{0.00000000010, 5.55718728874, 52290.24557183361},
	{0.00000000012, 1.55438318082, 26514.50133245020},
	{0.00000000009, 5.97731076392, 76044.95232053580},
	{0.00000000009, 1.52608730668, 35191.81013569180},
	{0.00000000010, 3.15434437042, 124778.18365871879},
	{0.00000000009, 4.94399763372, 339142.74084046457},
	{0.00000000009, 3.23297814751, 78244.03966382280},
	{0.00000000011, 1.37012220080, 38519.94579197200},
	{0.00000000009, 1.65178893035, 39609.65458316560},
	{0.00000000008, 3.08406781779, 52061.36699446317},
	{0.00000000010, 1.78007560053, 25028.52121138500},
	{0.00000000009, 1.99370375699, 12432.04265039780},
	{0.00000000009, 0.64203429747, 104881.30353139139},
	{0.00000000008, 2.46909335815, 2333.19639287200},
	{0.00000000008, 5.09160593281, 136100.84775702319},
	{0.00000000008, 4.95977806392, 103396.01282468818},
	{0.00000000008, 3.17511222783, 28206.66700195260},
	{0.00000000008, 5.30797759703, 79219.30916633119},
	{0.00000000009, 4.93174852989, 7994.52844202420},
	{0.00000000009, 4.69826318545, 63498.47038145279},
	{0.00000000009, 1.06973985086, 15874.61759536320},
	{0.00000000007, 3.14954677340, 52168.69273614759},
	{0.00000000007, 0.55559122998, 64741.95798313119},
	{0.00000000007, 0.76613463585, 69159.80243060499},
	{0.00000000007, 0.31047071847, 78267.59076008058},
	{0.00000000009, 1.78142262939, 44937.13069154840},
	{0.00000000007, 3.66488715060, 18207.81398823521},
	{0.00000000008, 2.43253154916, 52182.91983014920},
	{0.00000000006, 4.20186212149, 105410.99449648599},
	{0.00000000006, 1.43352275284, 88476.99497093359},
	{0.00000000007, 4.55836386142, 51962.50718771040},
	{0.00000000006, 0.82384473987, 129380.13377768178},
	{0.00000000006, 4.69107663948, 52602.40447402440},
	{0.00000000006, 0.95309123619, 68050.42387851159},
	{0.00000000007, 3.94256114885, 7238.67559160000},
	{0.00000000005, 4.22538197267, 57837.13833230060},
	{0.00000000006, 1.35964226786, 78477.00852016058},
	{0.00000000005, 3.27748453006, 74821.13447975718},
	{0.00000000005, 4.79928508484, 13521.75144159140},
	{0.00000000007, 2.15262985645, 78283.37918562238},
	{0.00000000007, 3.41483534504, 71492.99882347698},
	{0.00000000005, 2.00252804083, 25661.30495069820},
	{0.00000000005, 2.30423096631, 105460.99111839019},
	{0.00000000005, 3.95725794199, 94138.32702008578},
	{0.00000000005, 6.01203009176, 51322.60990139639},
	{0.00000000006, 4.90832237060, 77734.01845962799},
	{0.00000000006, 5.09323451879, 78259.82808936459},
	{0.00000000005, 5.15754800675, 108903.56606335558},
	{0.00000000005, 2.16962219454, 81706.28436968799},
	{0.00000000005, 6.03160576908, 78256.59587772179},
	{0.00000000006, 3.87273262792, 103292.23063610759},
	{0.00000000004, 0.83457275877, 32370.97899156560},
	{0.00000000004, 5.01761361986, 33967.99229491319},
	{0.00000000004, 2.55613520919, 29416.03879785439},
	{0.00000000004, 6.24908247561, 22759.76748529401},
	{0.00000000005, 3.91889103336, 93028.94846799239},
	{0.00000000004, 5.09314307859, 76144.94556434419},
	{0.00000000004, 5.54718850207, 181505.94343892598},
	{0.00000000004, 3.66591555169, 51749.20809227239},
	{0.00000000004, 5.43535832308, 77204.32749453338},
	{0.00000000005, 6.24450165084, 59414.48187474840},
	{0.00000000005, 5.47240472132, 78270.82297172339},
	{0.00000000004, 3.89916025123, 44181.27784112419},
	{0.00000000004, 6.22902554255, 24498.83024629040},
	{0.00000000004, 3.92116783578, 155468.03691925599},
	{0.00000000004, 5.48712842142, 54509.00267602040},
	{0.00000000004, 4.27463598779, 18093.37469954999},
	{0.00000000003, 1.85244465361, 162188.75089859738},
	{0.00000000003, 4.77836422656, 41962.52073693740},
	{0.00000000004, 2.12335410594, 79852.78232000639},
	{0.00000000004, 4.17801375091, 39743.76363275060},
	{0.00000000004, 5.70840309627, 7880.08915333899},
	{0.00000000003, 0.39806541191, 99799.65906923798},
	{0.00000000004, 2.38564459509, 80482.46652890938},
	{0.00000000003, 6.27556693980, 104331.94280539699},
	{0.00000000003, 1.35069678358, 19804.82729158280},
	{0.00000000003, 1.81855841579, 77623.81213840858},
	{0.00000000004, 2.52850834706, 27311.72098235281},
	{0.00000000004, 6.27670933774, 24864.08530079559},
	{0.00000000003, 0.70573582046, 120226.23016165999},
	{0.00000000003, 3.32514993267, 125887.56221081219},
	{0.00000000003, 3.75830218405, 58458.88213313979},
	{0.00000000003, 2.74763513151, 102132.85546210999},
	{0.00000000003, 1.67864067330, 129483.91596626239},
	{0.00000000003, 6.20277750460, 150866.08680029298},
	{0.00000000004, 1.26893874193, 103821.92160120218},
	{0.00000000003, 3.56406791266, 90829.86112470538},
	{0.00000000003, 3.63272158132, 130969.20667296558},
	{0.00000000002, 3.23610336539, 3328.13565628019},
	{0.00000000003, 5.91047728379, 26941.09952332620},
	{0.00000000002, 0.95061008775, 2648.45482547300},
	{0.00000000003, 4.65184843181, 71025.03383312259},
	{0.00000000002, 4.48148929675, 114564.89811250778},
	{0.00000000002, 2.32776941660, 78378.14871340781},
	{0.00000000003, 3.35170366833, 104355.49390165479},
	{0.00000000002, 5.14923443722, 10213.28554621100},
	{0.00000000003, 4.22691038602, 64607.84893354619},
	{0.00000000002, 1.71650975828, 365230.64398203876},
	{0.00000000003, 3.67194915630, 52815.70356946240},
	{0.00000000002, 1.27345348451, 77197.21394753258},
	{0.00000000002, 1.48417100051, 78690.30761559859},
	{0.00000000002, 2.36187956438, 6283.07584999140},
	{0.00000000002, 6.12303826586, 26080.78959457339},
	{0.00000000002, 5.19120708421, 104371.28232719658},
	{0.00000000002, 0.78853413649, 77211.44104153418},
	{0.00000000002, 2.72670303771, 104344.49901929598},
	{0.00000000002, 4.67739374144, 73711.75592766379},
	{0.00000000002, 1.53237872748, 25021.40766438420},
	{0.00000000002, 2.13231085358, 78050.41032928458},
	{0.00000000002, 0.91172072873, 26724.89941359840},
	{0.00000000002, 1.61031164889, 25450.90686955000},
	{0.00000000002, 0.18515603002, 97580.90196505119},
	{0.00000000002, 1.24467307746, 25035.63475838580},
	{0.00000000002, 4.54718046119, 61279.71327726600},
	{0.00000000002, 0.99883736208, 131498.89763806018},
	{0.00000000002, 6.14579824758, 78149.27013603736},
	{0.00000000002, 5.22194829628, 107794.18751126219},
	{0.00000000002, 4.44568632865, 104564.91166173479},
	{0.00000000002, 0.43885889697, 44295.71712980940},
	{0.00000000002, 2.21775926430, 104358.72611329758},
	{0.00000000002, 6.01244126070, 26095.01668857500},
	{0.00000000002, 1.97247119445, 25448.00585526019},
	{0.00000000002, 1.84425072089, 104347.73123093879},
	{0.00000000002, 1.92978783375, 134991.46920492979},
	{0.00000000002, 6.15762075171, 54294.57014352679},
	{0.00000000001, 0.00646259477, 151975.46535238638},
	{0.00000000002, 4.28651900923, 27154.39861876420},
	{0.00000000001, 4.96493278918, 131548.89425996438},
	{0.00000000002, 4.03299923868, 129909.82474277639},
	{0.00000000001, 4.85411171080, 117873.36400788819},
	{0.00000000001, 0.70037814448, 181555.94006083018},
	{0.00000000001, 4.76887553825, 27140.17152476259},
	{0.00000000001, 2.20665692734, 71980.63357473118},
	{0.00000000001, 0.32376121011, 84546.78527471398},
	{0.00000000001, 2.02269954361, 105307.21230790539},
	{0.00000000001, 5.65215614938, 55503.94193942859},
	{0.00000000001, 4.32724826212, 103285.11708910679},
	{0.00000000001, 5.29833008252, 98068.53671630539},
	{0.00000000001, 0.18572568831, 49842.60989027639},
	{0.00000000001, 4.90122380403, 188276.65404017158},
	{0.00000000001, 3.76341801760, 146314.13330323418},
	{0.00000000001, 1.30916935787, 39629.32434406539},
	{0.00000000001, 1.21286301975, 12546.48193908300},
	{0.00000000001, 3.39146472709, 29428.51556827400},
	{0.00000000001, 5.41375295771, 22747.29071487440},
	{0.00000000001, 3.01779717813, 48847.67062686820},
	{0.00000000001, 0.59868544996, 119116.85160956658},
	{0.00000000001, 3.78611740517, 26068.23338067440},
	{0.00000000001, 2.27036539747, 65697.55772473979},
	{0.00000000001, 4.83301226330, 85034.42002596818},
	{0.00000000001, 1.67985210779, 91785.46086631398},
	{0.00000000001, 0.94607737269, 65831.66677432480},
	{0.00000000001, 3.70907832809, 25668.41849769900},
	{0.00000000001, 5.11382979303, 105940.68546158058},
	{0.00000000001, 2.55240899630, 23969.13928119580},
	{0.00000000001, 5.58196282531, 53399.62412392700},
	{0.00000000001, 5.05138921018, 86143.79857806159},
	{0.00000000001, 2.25556473621, 80596.90581759460},
	{0.00000000001, 0.21311360055, 116917.76426627958},
	{0.00000000001, 1.56663404561, 49527.35145767539},
	{0.00000000001, 0.86126131153, 26091.78447693220},
	{0.00000000001, 1.85701383103, 102762.53967101299},
	{0.00000000001, 5.22154224565, 42153.96900304900},
	{0.00000000001, 3.58367543915, 10021.83728009940},
	{0.00000000001, 2.09053854156, 52643.77127350280},
	{0.00000000001, 5.79544037209, 106570.36967048359},
	{0.00000000001, 1.91470461401, 60055.89543648739},
	{0.00000000001, 2.85680513265, 77410.51304297059},
	{0.00000000001, 3.76946194078, 35472.74414964940},
	{0.00000000001, 5.03575574402, 16703.06213349900},
	{0.00000000001, 4.78643120649, 51109.31080595839},
	{0.00000000001, 0.57669802141, 95247.70557217918},
	{0.00000000001, 2.90180569851, 25234.70675982219},
	{0.00000000001, 1.58201404622, 90695.75207512038},
	{0.00000000001, 2.68747867545, 26107.57290247399},
	{0.00000000001, 4.30211746075, 51123.53789995999},
	{0.00000000001, 5.61783600207, 26084.02180621620},
	{0.00000000001, 3.85421340571, 103299.34418310839},
	{0.00000000000, 1.67828847641, 111122.32316754239},
	{0.00000000000, 4.32269517066, 116783.65521669458},
	{0.00000000000, 1.57680890241, 102232.84870591838},
	{0.00000000000, 3.86212056666, 77829.99768684579},
	{0.00000000000, 1.07901792462, 53242.30176033840},
	{0.00000000000, 5.66444613327, 45892.73043315699},
	{0.00000000000, 2.20085558024, 85502.38501632259},
	{0.00000000000, 0.98299558571, 52329.58509363319},
	{0.00000000000, 1.32972554910, 97112.93697469679},
	{0.00000000000, 1.12592342011, 70269.18098269838},
	{0.00000000000, 3.04273231467, 130419.84594697120},
	{0.00000000000, 2.31692106685, 207593.84658050018},
	{0.00000000000, 0.47743492160, 78903.60671103658},
	{0, 0, 0}
};

struct vsop87_term mercury_y3[] = {
	{0.00000018231, 4.35141183918, 78263.70942472259},
	{0.00000017840, 1.45419068020, 52175.80628314840},
	{0.00000015722, 0.00000000000, 0.00000000000},
	{0.00000010723, 1.09353490107, 104351.61256629678},
	{0.00000008835, 4.62739214222, 26087.90314157420},
	{0.00000004973, 4.13805648872, 130439.51570787099},
	{0.00000002032, 0.90409186617, 156527.41884944518},
	{0.00000000768, 3.95481408065, 182615.32199101939},
	{0.00000000275, 0.72281686312, 208703.22513259358},
	{0.00000000095, 3.77357857159, 234791.12827416777},
	{0.00000000032, 0.53816590044, 260879.03141574195},
	{0.00000000023, 1.30039835479, 51066.42773105500},
	{0.00000000013, 4.35126170071, 77154.33087262919},
	{0.00000000011, 4.27058573849, 53285.18483524180},
	{0.00000000010, 3.58474125179, 286966.93455731616},
	{0.00000000006, 1.11939414362, 103242.23401420339},
	{0.00000000004, 1.06911580934, 79373.08797681599},
	{0.00000000003, 0.35802564284, 313054.83769889036},
	{0.00000000003, 4.97694448000, 24978.52458948080},
	{0.00000000002, 4.16958554828, 129330.13715577759},
	{0.00000000002, 4.98034080151, 46514.47423399620},
	{0.00000000002, 0.75178980879, 27197.28169366760},
	{0.00000000002, 1.79735462475, 72602.37737557039},
	{0.00000000002, 3.97020440960, 51220.20654153979},
	{0.00000000001, 5.79259488047, 52705.49724824299},
	{0.00000000001, 5.78106278480, 25028.52121138500},
	{0.00000000001, 4.81235249974, 98690.28051714458},
	{0.00000000001, 0.58325393673, 77308.10968311399},
	{0.00000000001, 6.25607623811, 27147.28507176339},
	{0.00000000001, 1.35639516489, 49957.04917896160},
	{0.00000000001, 1.27930276545, 53131.40602475700},
	{0.00000000001, 2.53029769574, 40853.14218484400},
	{0.00000000001, 3.40999215656, 339142.74084046457},
	{0.00000000001, 4.14914204525, 105460.99111839019},
	{0.00000000001, 0.94394345298, 155418.04029735178},
	{0.00000000001, 2.78477981756, 53235.18821333759},
	{0.00000000001, 2.44143812400, 78793.40038981718},
	{0.00000000001, 5.72990048899, 79323.09135491178},
	{0.00000000001, 3.75969757986, 56727.75978020720},
	{0.00000000000, 6.02219408506, 51646.11531805379},
	{0.00000000000, 0.98563675822, 27676.97603685800},
	{0.00000000001, 4.18035870626, 54394.56338733519},
	{0.00000000000, 4.63820647009, 27043.50288318280},
	{0.00000000000, 4.88088145588, 24498.83024629040},
	{0.00000000000, 5.09384017469, 45405.09568190280},
	{0.00000000001, 0.83186420507, 1109.37855209340},
	{0.00000000000, 0.55268160318, 82815.66292178139},
	{0.00000000000, 4.06242566095, 30639.85663863300},
	{0.00000000000, 2.29306072785, 20426.57109242200},
	{0.00000000000, 2.83724469642, 26617.59410666880},
	{0.00000000000, 4.35824625534, 76674.63652943878},
	{0.00000000000, 3.83033321377, 5661.33204915220},
	{0.00000000000, 0.32449010894, 213.29909543800},
	{0.00000000000, 2.73204881726, 16983.99614745660},
	{0.00000000000, 0.94024466666, 25132.30339996560},
	{0.00000000000, 5.59288614720, 66941.04532641819},
	{0.00000000000, 6.21244642317, 14765.23904326980},
	{0.00000000000, 5.04079948823, 23869.14603738740},
	{0.00000000000, 4.42123921226, 76044.95232053580},
	{0, 0, 0}
};

struct vsop87_term mercury_y4[] = {
	{0.00000000448, 3.14159265359, 0.00000000000},
	{0.00000000299, 2.91725329579, 78263.70942472259},
	{0.00000000241, 5.88233684971, 104351.61256629678},
	{0.00000000234, 0.11142561910, 52175.80628314840},
	{0.00000000145, 2.62003969568, 130439.51570787099},
	{0.00000000073, 5.65860776108, 156527.41884944518},
	{0.00000000056, 3.19455986519, 26087.90314157420},
	{0.00000000033, 2.42044304883, 182615.32199101939},
	{0.00000000014, 5.46300124767, 208703.22513259358},
	{0.00000000005, 2.23239849027, 234791.12827416777},
	{0.00000000002, 5.28061358621, 260879.03141574195},
	{0.00000000001, 2.04140460514, 286966.93455731616},
	{0.00000000000, 6.11024431934, 51066.42773105500},
	{0.00000000000, 2.77045335769, 77154.33087262919},
	{0.00000000000, 2.64502722578, 53285.18483524180},
	{0, 0, 0}
};

struct vsop87_term mercury_y5[] = {
	{0.00000000005, 4.36366479961, 104351.61256629678},
	{0.00000000004, 1.29818204726, 78263.70942472259},
	{0.00000000003, 1.10210039292, 130439.51570787099},
	{0.00000000003, 2.32804418834, 26087.90314157420},
	{0.00000000004, 0.00000000000, 0.00000000000},
	{0.00000000003, 3.92465699188, 52175.80628314840},
	{0.00000000002, 4.13335263836, 156527.41884944518},
	{0.00000000001, 0.88060083637, 182615.32199101939},
	{0.00000000001, 3.91898663672, 208703.22513259358},
	{0.00000000000, 0.67280389009, 234791.12827416777},
	{0, 0, 0}
};

struct vsop87_term mercury_z0[] = {
	{0.04607665326, 1.99295081967, 26087.90314157420},
	{0.00708734365, 3.14159265359, 0.00000000000},
	{0.00469171617, 5.04215742764, 52175.80628314840},
	{0.00071626395, 1.80894256071, 78263.70942472259},
	{0.00012957446, 4.85922032010, 104351.61256629678},
	{0.00002575002, 1.62646731545, 130439.51570787099},
	{0.00000543259, 4.67698860167, 156527.41884944518},
	{0.00000119462, 1.44437994097, 182615.32199101939},
	{0.00000079477, 4.94442849343, 27197.28169366760},
	{0.00000082635, 2.03127961938, 24978.52458948080},
	{0.00000044712, 0.52659463739, 1059.38193018920},
	{0.00000043131, 5.66922412963, 20426.57109242200},
	{0.00000034677, 2.36736170874, 25028.52121138500},
	{0.00000032337, 1.29099631099, 31749.23519072640},
	{0.00000027465, 3.57680072404, 5661.33204915220},
	{0.00000027081, 4.49499356963, 208703.22513259358},
	{0.00000020978, 4.46131555233, 4551.95349705880},
	{0.00000020602, 1.12768557199, 1109.37855209340},
	{0.00000020252, 0.11722157720, 51116.42435295920},
	{0.00000023561, 1.82361021215, 53285.18483524180},
	{0.00000014150, 4.42485698284, 57837.13833230060},
	{0.00000016632, 5.09118864825, 51066.42773105500},
	{0.00000011609, 3.48812792468, 21535.94964451540},
	{0.00000009897, 2.80940292918, 27043.50288318280},
	{0.00000008380, 2.46820093103, 46514.47423399620},
	{0.00000007950, 0.44767912341, 10213.28554621100},
	{0.00000009234, 3.80445817621, 529.69096509460},
	{0.00000007834, 4.08006285427, 25132.30339996560},
	{0.00000007169, 2.43861625280, 47623.85278608960},
	{0.00000006283, 1.26244592145, 234791.12827416777},
	{0.00000006189, 3.24598311063, 77204.32749453338},
	{0.00000006312, 3.60156222051, 27147.28507176339},
	{0.00000005874, 3.18517530495, 14765.23904326980},
	{0.00000005464, 0.18067146403, 13521.75144159140},
	{0.00000005844, 4.88684915394, 79373.08797681599},
	{0.00000005207, 1.04360609206, 426.59819087600},
	{0.00000005084, 2.88826076001, 12566.15169998280},
	{0.00000004862, 1.05211425705, 1589.07289528380},
	{0.00000005778, 4.74518603718, 30639.85663863300},
	{0.00000004470, 5.94243776120, 11322.66409830440},
	{0.00000004084, 6.10730721947, 41962.52073693740},
	{0.00000003921, 1.19592374632, 83925.04147387479},
	{0.00000003933, 1.60795544806, 25661.30495069820},
	{0.00000004046, 3.08469176646, 51646.11531805379},
	{0.00000003739, 2.04428825509, 15874.61759536320},
	{0.00000003728, 1.74332154184, 24498.83024629040},
	{0.00000003797, 1.86233694539, 77154.33087262919},
	{0.00000003417, 4.10830949198, 39609.65458316560},
	{0.00000003691, 3.50893180252, 37410.56723987860},
	{0.00000002644, 5.60089521868, 73711.75592766379},
	{0.00000003230, 5.39015797984, 955.59974160860},
	{0.00000002653, 5.52156950287, 26617.59410666880},
	{0.00000002526, 5.49112478707, 6283.07584999140},
	{0.00000003017, 6.08863660917, 53131.40602475700},
	{0.00000003020, 5.46768108443, 25558.21217647960},
	{0.00000002169, 5.85843688724, 50586.73338786459},
	{0.00000002217, 5.81930894103, 51749.20809227239},
	{0.00000002036, 2.79411907992, 7238.67559160000},
	{0.00000001904, 0.02429449494, 33326.57873317420},
	{0.00000001841, 3.31987542265, 36301.18868778519},
	{0.00000001693, 0.04022611885, 103292.23063610759},
	{0.00000001814, 0.58414302882, 63498.47038145279},
	{0.00000001910, 5.54302892735, 72602.37737557039},
	{0.00000001560, 0.96215455240, 65697.55772473979},
	{0.00000001605, 0.84854708960, 51220.20654153979},
	{0.00000001595, 5.65216619091, 26068.23338067440},
	{0.00000001487, 1.66950376778, 105460.99111839019},
	{0.00000001595, 1.47238921630, 26107.57290247399},
	{0.00000001485, 4.31307667056, 260879.03141574195},
	{0.00000001344, 3.05188579262, 68050.42387851159},
	{0.00000001601, 0.69333064931, 9103.90699411760},
	{0.00000001224, 3.56543079781, 19804.82729158280},
	{0.00000001258, 2.62817126488, 52705.49724824299},
	{0.00000001386, 0.42909271065, 53235.18821333759},
	{0.00000001392, 0.41896396083, 18849.22754997420},
	{0.00000001104, 1.37365365216, 45892.73043315699},
	{0.00000001191, 5.76715631957, 19317.19254032860},
	{0.00000001218, 6.16642870453, 77734.01845962799},
	{0.00000000991, 0.77508695125, 32858.61374281979},
	{0.00000001039, 4.25003847002, 110012.94461544899},
	{0.00000001155, 1.83291524170, 16983.99614745660},
	{0.00000000913, 4.91386835375, 103242.23401420339},
	{0.00000001096, 2.77782845562, 26091.78447693220},
	{0.00000000843, 2.10283893013, 23869.14603738740},
	{0.00000001147, 1.40069226758, 56727.75978020720},
	{0.00000001096, 4.34969785012, 26084.02180621620},
	{0.00000000888, 5.96405172933, 38654.05484155699},
	{0.00000000798, 5.90979724117, 43071.89928903080},
	{0.00000000894, 6.20891949330, 40853.14218484400},
	{0.00000000751, 2.38280961577, 99799.65906923798},
	{0.00000000858, 3.48194203031, 59414.48187474840},
	{0.00000000903, 4.51539427543, 3442.57494496540},
	{0.00000000816, 4.68549846425, 28306.66024576099},
	{0.00000000739, 4.03898100455, 26514.50133245020},
	{0.00000000874, 3.33462533468, 22645.32819660879},
	{0.00000000685, 2.68994541603, 76674.63652943878},
	{0.00000000933, 3.52008984237, 6770.71060124560},
	{0.00000000668, 2.67447570603, 77837.11123384659},
	{0.00000000688, 4.13735845510, 27676.97603685800},
	{0.00000000643, 0.26212576857, 639.89728631400},
	{0.00000000747, 2.88413728742, 79219.30916633119},
	{0.00000000594, 4.72204801083, 29530.47808653960},
	{0.00000000580, 0.49131159361, 62389.09182935939},
	{0.00000000560, 0.58980434738, 26080.78959457339},
	{0.00000000636, 5.01277329265, 7.11354700080},
	{0.00000000664, 5.40615713600, 213.29909543800},
	{0.00000000460, 2.41008353609, 25448.00585526019},
	{0.00000000453, 4.02646064195, 91785.46086631398},
	{0.00000000441, 3.60120922804, 89586.37352302698},
	{0.00000000473, 3.19147656788, 25874.60404613620},
	{0.00000000452, 3.10205575226, 129380.13377768178},
	{0.00000000406, 1.57776301723, 2118.76386037840},
	{0.00000000495, 4.35094686160, 58946.51688439399},
	{0.00000000395, 0.29737033271, 25934.12433108940},
	{0.00000000392, 0.53546585935, 26241.68195205900},
	{0.00000000382, 4.72731471129, 131548.89425996438},
	{0.00000000382, 4.49198737842, 71980.63357473118},
	{0.00000000368, 3.89892172772, 77308.10968311399},
	{0.00000000351, 1.04745682138, 2218.75710418680},
	{0.00000000356, 6.12309999532, 94138.32702008578},
	{0.00000000458, 2.31746139528, 98690.28051714458},
	{0.00000000327, 4.52406643775, 52195.47604404819},
	{0.00000000393, 3.09725258397, 69159.80243060499},
	{0.00000000310, 1.10653094623, 23969.13928119580},
	{0.00000000356, 1.08062840940, 286966.93455731616},
	{0.00000000345, 5.71957868514, 78793.40038981718},
	{0.00000000293, 1.74897333943, 54394.56338733519},
	{0.00000000275, 4.05372155800, 149.56319713460},
	{0.00000000325, 2.41844865673, 52156.13652224860},
	{0.00000000273, 0.34374545554, 51535.90899683439},
	{0.00000000256, 3.57544759221, 1066.49547719000},
	{0.00000000252, 2.07789295059, 48733.23133818299},
	{0.00000000326, 3.49941746899, 79323.09135491178},
	{0.00000000327, 2.94651885500, 103821.92160120218},
	{0.00000000300, 3.53612598449, 26301.20223701220},
	{0.00000000253, 0.67254115542, 1052.26838318840},
	{0.00000000274, 1.02128544399, 136100.84775702319},
	{0.00000000227, 1.68291413296, 129330.13715577759},
	{0.00000000264, 4.42527687575, 82815.66292178139},
	{0.00000000280, 3.47711681992, 44937.13069154840},
	{0.00000000207, 5.26698515692, 25938.33994443960},
	{0.00000000233, 1.58956295605, 26095.01668857500},
	{0.00000000211, 2.55179422569, 45405.09568190280},
	{0.00000000223, 1.11566460119, 52171.92494779040},
	{0.00000000195, 5.61180266071, 25021.40766438420},
	{0.00000000204, 5.44212122344, 125887.56221081219},
	{0.00000000193, 2.20507758963, 25035.63475838580},
	{0.00000000189, 5.78823648500, 102762.53967101299},
	{0.00000000213, 1.31985764486, 26555.86813192860},
	{0.00000000191, 0.24359410467, 85502.38501632259},
	{0.00000000195, 5.97596513107, 105307.21230790539},
	{0.00000000218, 5.85009667782, 25619.93815121980},
	{0.00000000181, 5.75215140812, 103925.01437542078},
	{0.00000000190, 3.25444605074, 13655.86049117640},
	{0.00000000177, 5.31586012519, 50057.04242277000},
	{0.00000000207, 2.75433176036, 64741.95798313119},
	{0.00000000224, 5.82663546732, 52179.68761850640},
	{0.00000000164, 3.65486891804, 76.26607127560},
	{0.00000000166, 5.16708694657, 49957.04917896160},
	{0.00000000171, 1.99193197138, 26094.53170047421},
	{0.00000000159, 2.10978774324, 32370.97899156560},
	{0.00000000164, 5.82981713266, 12432.04265039780},
	{0.00000000155, 5.39879388941, 6681.22485339960},
	{0.00000000199, 3.05926705479, 66941.04532641819},
	{0.00000000171, 5.13520423660, 26081.27458267419},
	{0.00000000150, 0.90885651206, 52389.10537858640},
	{0.00000000184, 1.74487163243, 51962.50718771040},
	{0.00000000164, 0.91431121775, 52602.40447402440},
	{0.00000000138, 5.40226519416, 26011.63707029860},
	{0.00000000149, 2.17444239275, 52168.69273614759},
	{0.00000000184, 1.61828580097, 20760.42703319140},
	{0.00000000152, 0.96120452018, 53764.87917843220},
	{0.00000000146, 5.57207251195, 58458.88213313979},
	{0.00000000150, 3.58807734183, 88476.99497093359},
	{0.00000000124, 1.42633058836, 55618.38122811380},
	{0.00000000141, 1.44033578815, 5327.47610838280},
	{0.00000000126, 0.80278847447, 117873.36400788819},
	{0.00000000118, 3.91167705851, 19406.67828817460},
	{0.00000000117, 4.68118162480, 52182.91983014920},
	{0.00000000130, 3.12963980623, 38519.94579197200},
	{0.00000000123, 2.90959272560, 52026.24308601380},
	{0.00000000114, 3.34729061863, 51109.31080595839},
	{0.00000000109, 0.37062017000, 115674.27666460119},
	{0.00000000108, 5.35523619654, 46848.33017476560},
	{0.00000000120, 6.15890498480, 155468.03691925599},
	{0.00000000105, 1.26949313866, 98068.53671630539},
	{0.00000000124, 5.59073645014, 74821.13447975718},
	{0.00000000113, 5.37283602123, 124778.18365871879},
	{0.00000000101, 1.50859657746, 157636.79740153858},
	{0.00000000112, 6.24044765899, 51123.53789995999},
	{0.00000000089, 0.66689996363, 103396.01282468818},
	{0.00000000088, 3.24234443321, 26727.80042788820},
	{0.00000000083, 3.46887356727, 77623.81213840858},
	{0.00000000082, 3.58489505049, 52329.58509363319},
	{0.00000000082, 2.76598729250, 35191.81013569180},
	{0.00000000092, 2.89919284588, 120226.23016165999},
	{0.00000000081, 3.34888362248, 52022.02747266360},
	{0.00000000080, 1.61800826930, 45494.58142974879},
	{0.00000000087, 5.99930110618, 129909.82474277639},
	{0.00000000075, 1.29165560989, 78283.37918562238},
	{0.00000000097, 0.94285631414, 85034.42002596818},
	{0.00000000075, 0.93132779667, 433.71173787680},
	{0.00000000087, 3.29295494560, 3340.61242669980},
	{0.00000000083, 4.56076128644, 419.48464387520},
	{0.00000000080, 0.27627260080, 105410.99449648599},
	{0.00000000079, 5.99645052852, 95247.70557217918},
	{0.00000000074, 0.63932580906, 64607.84893354619},
	{0.00000000066, 4.71152255697, 80482.46652890938},
	{0.00000000073, 3.21815072307, 52099.54021187280},
	{0.00000000066, 2.98683203711, 23754.70674870219},
	{0.00000000091, 2.50052149852, 104881.30353139139},
	{0.00000000062, 5.73156315784, 853.19638175200},
	{0.00000000086, 4.13151425024, 313054.83769889036},
	{0.00000000064, 1.17129038283, 108903.56606335558},
	{0.00000000059, 0.79111914848, 7994.52844202420},
	{0.00000000065, 0.25068571900, 71025.03383312259},
	{0.00000000057, 6.23642054033, 1692.16566950240},
	{0.00000000057, 4.67121384993, 28206.66700195260},
	{0.00000000059, 4.92822158961, 78050.41032928458},
	{0.00000000056, 2.09215892689, 76144.94556434419},
	{0.00000000056, 1.73304008242, 25654.19140369739},
	{0.00000000057, 4.73385475413, 155418.04029735178},
	{0.00000000056, 5.88720785632, 26037.90651966999},
	{0.00000000074, 5.46823409002, 78244.03966382280},
	{0.00000000061, 4.50066150046, 25668.41849769900},
	{0.00000000071, 4.06855895670, 162188.75089859738},
	{0.00000000052, 2.74630211595, 131395.11544947959},
	{0.00000000055, 1.23376269855, 26137.89976347840},
	{0.00000000051, 4.16406216247, 78259.82808936459},
	{0.00000000048, 5.64584502444, 71492.99882347698},
	{0.00000000056, 2.21556357721, 151975.46535238638},
	{0.00000000052, 2.58403290426, 128850.44281258718},
	{0.00000000048, 2.53427528158, 130012.91751699499},
	{0.00000000045, 3.30208209778, 111590.28815789679},
	{0.00000000051, 2.59172476683, 78267.59076008058},
	{0.00000000047, 1.65481269433, 18093.37469954999},
	{0.00000000045, 4.61275436981, 2333.19639287200},
	{0.00000000043, 4.08074925073, 1596.18644228460},
	{0.00000000042, 2.94276331302, 24395.73747207180},
	{0.00000000042, 4.02117925826, 78477.00852016058},
	{0.00000000056, 4.77237421864, 28421.09953444620},
	{0.00000000047, 6.11377086686, 93028.94846799239},
	{0.00000000040, 3.23768263734, 25234.70675982219},
	{0.00000000045, 5.03235979949, 78256.59587772179},
	{0.00000000053, 6.07709485433, 10021.83728009940},
	{0.00000000050, 5.81013134251, 90829.86112470538},
	{0.00000000038, 1.96485604602, 632.78373931320},
	{0.00000000051, 3.90465378478, 74.78159856730},
	{0.00000000036, 6.02764042024, 78114.14622758799},
	{0.00000000035, 0.19483010119, 77197.21394753258},
	{0.00000000038, 0.85372328004, 26237.46633870879},
	{0.00000000036, 3.61160802929, 48835.19385644859},
	{0.00000000036, 0.36428632576, 27154.39861876420},
	{0.00000000037, 2.58618864774, 51707.84129279399},
	{0.00000000047, 3.11077813997, 16066.06586147480},
	{0.00000000034, 5.90024410478, 103.09277421860},
	{0.00000000035, 1.89948168639, 52169.17772424839},
	{0.00000000035, 3.09037355598, 77211.44104153418},
	{0.00000000035, 5.86095139046, 18207.81398823521},
	{0.00000000038, 1.94104879109, 76044.95232053580},
	{0.00000000032, 1.45277855585, 78270.82297172339},
	{0.00000000044, 4.36195482299, 52643.77127350280},
	{0.00000000043, 0.13191769323, 1581.95934828300},
	{0.00000000032, 4.70833495807, 71582.48457132299},
	{0.00000000037, 3.75248447021, 27140.17152476259},
	{0.00000000042, 2.34341217670, 84546.78527471398},
	{0.00000000031, 2.09939558148, 2648.45482547300},
	{0.00000000033, 4.22087782315, 111122.32316754239},
	{0.00000000032, 5.93849066304, 51742.09454527159},
	{0.00000000037, 2.22778724531, 25973.46385288896},
	{0.00000000031, 0.06282672228, 536.80451209540},
	{0.00000000030, 0.17325551658, 224.34479570190},
	{0.00000000030, 4.46570213013, 81706.28436968799},
	{0.00000000029, 4.99680928394, 24491.71669928959},
	{0.00000000035, 5.04036468235, 52182.43484204840},
	{0.00000000033, 4.30956969733, 14477.35118320000},
	{0.00000000039, 3.99296635763, 78690.30761559859},
	{0.00000000028, 3.41723065188, 7880.08915333899},
	{0.00000000039, 0.38970280197, 114564.89811250778},
	{0.00000000033, 3.85407359005, 143961.26714946238},
	{0.00000000029, 2.14304937049, 150866.08680029298},
	{0.00000000028, 4.95187621332, 956.28915597060},
	{0.00000000036, 4.89757043872, 26202.34243025941},
	{0.00000000030, 0.55025093927, 33967.99229491319},
	{0.00000000028, 1.52043005918, 40565.25432477420},
	{0.00000000027, 5.29884427476, 1162.47470440780},
	{0.00000000027, 3.44440418351, 141762.17980617538},
	{0.00000000035, 2.50821332798, 72936.23331633979},
	{0.00000000028, 0.83354394743, 42153.96900304900},
	{0.00000000036, 4.02142487381, 79852.78232000639},
	{0.00000000026, 1.15352991801, 51322.60990139639},
	{0.00000000026, 0.13577439886, 22747.29071487440},
	{0.00000000027, 4.82379477303, 110.20632121940},
	{0.00000000025, 0.71097564554, 50483.64061364600},
	{0.00000000024, 2.92248010137, 121335.60871375339},
	{0.00000000026, 4.56151347419, 183724.70054311278},
	{0.00000000024, 2.16545180970, 32769.12799497380},
	{0.00000000031, 2.33336639968, 51756.32163927320},
	{0.00000000032, 2.93016714121, 181555.94006083018},
	{0.00000000027, 4.32935860229, 124156.43985787958},
	{0.00000000023, 6.16949223424, 39743.76363275060},
	{0.00000000023, 2.77333133719, 155997.72788435058},
	{0.00000000022, 2.90047805068, 25863.55834587229},
	{0.00000000023, 0.26296960044, 103711.71527998279},
	{0.00000000022, 0.49237419293, 23439.44831610119},
	{0.00000000027, 2.77269830479, 24505.94379329119},
	{0.00000000022, 0.39938514656, 26164.16921284980},
	{0.00000000022, 0.07820939757, 78187.44335344699},
	{0.00000000022, 3.71330627735, 129483.91596626239},
	{0.00000000023, 5.63887355161, 522.57741809380},
	{0.00000000021, 3.36821177399, 1375.77379984580},
	{0.00000000029, 5.62929042847, 44181.27784112419},
	{0.00000000022, 4.35422573947, 26720.68688088739},
	{0.00000000021, 5.12497732226, 11610.55195837420},
	{0.00000000025, 5.36835518856, 26013.12154300690},
	{0.00000000024, 5.55813303813, 130969.20667296558},
	{0.00000000020, 4.79424075731, 25780.34552060460},
	{0.00000000020, 3.82740705898, 24925.42843716640},
	{0.00000000020, 4.26878389727, 25131.61398560359},
	{0.00000000021, 5.10505150441, 25977.69682035479},
	{0.00000000020, 3.32855955978, 131498.89763806018},
	{0.00000000020, 1.29805086237, 467.96499035440},
	{0.00000000023, 2.06377601353, 100909.03762133139},
	{0.00000000027, 4.46165349883, 316.39186965660},
	{0.00000000019, 2.33132135274, 26395.46076254379},
	{0.00000000019, 0.35229627877, 78417.48823520739},
	{0.00000000019, 2.86176933014, 50579.61984086379},
	{0.00000000018, 4.33826105585, 104371.28232719658},
	{0.00000000022, 1.69381062404, 106570.36967048359},
	{0.00000000021, 0.89581658307, 339142.74084046457},
	{0.00000000025, 5.95532312645, 146314.13330323418},
	{0.00000000020, 0.11725114676, 52815.70356946240},
	{0.00000000018, 1.66756826028, 23888.81579828719},
	{0.00000000022, 4.37150668135, 1478.86657406440},
	{0.00000000017, 4.39063105551, 60055.89543648739},
	{0.00000000017, 3.17668084118, 70269.18098269838},
	{0.00000000017, 1.74029229152, 104138.31347085879},
	{0.00000000017, 5.24411288462, 102232.84870591838},
	{0.00000000019, 0.11691865573, 78109.93061423779},
	{0.00000000017, 3.28697052824, 25565.32572348040},
	{0.00000000019, 0.84289230962, 188276.65404017158},
	{0.00000000018, 0.47252163890, 27999.10262479140},
	{0.00000000016, 2.81320924670, 52101.02468458109},
	{0.00000000016, 4.20710393311, 134991.46920492979},
	{0.00000000019, 0.54267379272, 50593.84693486539},
	{0.00000000015, 5.78613478653, 24712.12934172840},
	{0.00000000018, 2.23136091809, 104331.94280539699},
	{0.00000000016, 3.30957717580, 97112.93697469679},
	{0.00000000016, 1.02655918243, 26162.68474014150},
	{0.00000000015, 0.51501957594, 13362.44970679920},
	{0.00000000015, 5.44457668379, 28286.99048486120},
	{0.00000000015, 3.33697839260, 206.18554843720},
	{0.00000000015, 3.09319808895, 25984.81036735560},
	{0.00000000019, 5.95214817336, 29428.51556827400},
	{0.00000000017, 1.60411390680, 26507.38778544939},
	{0.00000000016, 3.62113927445, 26610.48055966799},
	{0.00000000018, 4.55509949626, 51543.02254383520},
	{0.00000000016, 4.95762784074, 25771.51127191760},
	{0.00000000014, 0.15853597470, 647.01083331480},
	{0.00000000016, 3.53658275362, 25551.09862947879},
	{0.00000000013, 2.28786159405, 12725.45343477500},
	{0.00000000016, 3.05451392033, 26190.99591579279},
	{0.00000000013, 5.81922389967, 157483.01859105378},
	{0.00000000013, 4.03160498458, 24356.78078864160},
	{0.00000000013, 4.49878848868, 29416.03879785439},
	{0.00000000016, 1.14380482430, 26404.29501123080},
	{0.00000000016, 4.77704247519, 24609.03656750980},
	{0.00000000013, 1.33944288754, 52808.59002246159},
	{0.00000000015, 1.50513017421, 181505.94343892598},
	{0.00000000012, 0.92918175452, 104347.73123093879},
	{0.00000000014, 2.44451494167, 26421.75908234360},
	{0.00000000012, 1.66798607577, 51013.33157874059},
	{0.00000000012, 4.24892890325, 52225.80290505260},
	{0.00000000014, 4.68967753702, 25754.04720080480},
	{0.00000000013, 0.63063491269, 51639.00177105299},
	{0.00000000013, 0.51980975221, 51951.46148744649},
	{0.00000000013, 0.11999669275, 26294.08869001139},
	{0.00000000012, 5.63990253843, 104355.49390165479},
	{0.00000000013, 0.37271479520, 74923.09699802278},
	{0.00000000015, 2.19958896111, 22759.76748529401},
	{0.00000000013, 1.47842980598, 54294.57014352679},
	{0.00000000012, 3.10508217703, 27819.02549450680},
	{0.00000000011, 2.42209220629, 97580.90196505119},
	{0.00000000013, 2.58513127775, 116917.76426627958},
	{0.00000000011, 4.76885794954, 49527.35145767539},
	{0.00000000011, 3.92593978045, 26521.61487945100},
	{0.00000000011, 2.89444277066, 119116.85160956658},
	{0.00000000012, 5.58737020094, 25881.71759313700},
	{0.00000000013, 5.59537220560, 156100.82065856918},
	{0.00000000012, 2.01299993075, 51219.51712717779},
	{0.00000000011, 0.99253734697, 25455.11940226100},
	{0.00000000014, 5.68122574937, 154938.34595416138},
	{0.00000000015, 5.27886514517, 178063.36849396059},
	{0.00000000014, 6.12654802167, 52278.89905736699},
	{0.00000000011, 0.06908636848, 52072.71350892979},
	{0.00000000011, 0.80982228740, 104564.91166173479},
	{0.00000000013, 3.96505351243, 68241.87214462319},
	{0.00000000011, 2.65559265085, 52125.80966124419},
	{0.00000000012, 6.26057108211, 24176.70365835700},
	{0.00000000012, 1.73021765373, 104344.49901929598},
	{0.00000000010, 2.77364193598, 77829.99768684579},
	{0.00000000010, 2.83314383566, 104202.04936916218},
	{0.00000000010, 4.05963464737, 26089.38761428249},
	{0.00000000012, 5.40316858194, 110634.68841628819},
	{0.00000000010, 6.17247219966, 103299.34418310839},
	{0.00000000010, 0.02153234343, 137678.19129947099},
	{0.00000000012, 2.25188175428, 52065.59996192899},
	{0.00000000010, 3.11650831039, 26086.41866886590},
	{0.00000000010, 3.27287049435, 103285.11708910679},
	{0.00000000010, 1.38532261128, 25446.48957983520},
	{0.00000000012, 1.52019007531, 54509.00267602040},
	{0.00000000011, 6.21574870463, 61279.71327726600},
	{0.00000000009, 0.49710408415, 2221.85663459700},
	{0.00000000009, 2.88821691711, 90695.75207512038},
	{0.00000000011, 2.16522629249, 26624.70765366959},
	{0.00000000009, 4.80391342687, 27311.72098235281},
	{0.00000000009, 4.23373474411, 52250.58788171570},
	{0.00000000009, 5.74437259170, 26729.31670331319},
	{0.00000000010, 3.47517485960, 140652.80125408198},
	{0.00000000010, 2.80299508279, 55516.41870984820},
	{0.00000000013, 4.07250716348, 34282.17847478280},
	{0.00000000009, 0.66918270135, 52698.38370124219},
	{0.00000000010, 5.43273059228, 126996.94076290558},
	{0.00000000009, 1.51413989531, 97670.38771289718},
	{0.00000000010, 1.07944281160, 742.99006053260},
	{0.00000000009, 3.33909678408, 1911.19948321720},
	{0.00000000009, 6.28167845492, 147423.51185532758},
	{0.00000000010, 0.71259250113, 137210.22630911658},
	{0.00000000009, 3.57005441415, 50800.03248330259},
	{0.00000000009, 5.50160718751, 2199.08734328700},
	{0.00000000009, 2.08845571909, 51859.41441349179},
	{0.00000000009, 4.25308230419, 26222.01219115920},
	{0.00000000009, 2.50157520492, 24864.08530079559},
	{0.00000000008, 2.47794653703, 25440.89230825939},
	{0.00000000009, 2.85482376043, 25953.79409198919},
	{0.00000000008, 2.29776576843, 23866.04650697719},
	{0.00000000009, 0.78685007135, 104778.21075717278},
	{0.00000000008, 4.62944551319, 52492.19815280499},
	{0.00000000009, 5.48506768547, 77844.22478084739},
	{0.00000000010, 1.12934836943, 78731.67441507700},
	{0.00000000008, 2.59549267900, 26941.09952332620},
	{0.00000000008, 4.95780242181, 78257.08086582259},
	{0.00000000008, 2.55696609752, 17893.62780836560},
	{0.00000000008, 4.52002369897, 104358.72611329758},
	{0.00000000008, 3.82529998469, 76571.54375522019},
	{0.00000000010, 2.73498400513, 323.50541665740},
	{0.00000000009, 1.57363188943, 24998.19435038059},
	{0.00000000008, 0.65301230309, 8194.27533320860},
	{0.00000000008, 4.30691637723, 77410.51304297059},
	{0.00000000008, 5.61648727808, 77795.74443436819},
	{0.00000000009, 2.56370604921, 50696.93970908399},
	{0.00000000008, 5.53494196837, 2008.55753915900},
	{0.00000000009, 0.81310827208, 105940.68546158058},
	{0.00000000008, 3.03053180726, 27780.06881107659},
	{0.00000000008, 1.09072579794, 949.17560896980},
	{0.00000000008, 5.21537078773, 176953.98994186718},
	{0.00000000008, 2.88040588282, 36109.74042167360},
	{0.00000000008, 3.90879186991, 54087.00576636560},
	{0.00000000007, 2.09304055777, 25344.91308104160},
	{0.00000000007, 3.77982679537, 19.66976089979},
	{0.00000000008, 2.01169539344, 31415.37924995700},
	{0.00000000008, 6.01136820214, 207643.84320240439},
	{0.00000000008, 6.24227744862, 38813.35657634920},
	{0.00000000008, 1.33108336808, 55503.94193942859},
	{0.00000000007, 3.30804741677, 23919.14265929160},
	{0.00000000008, 3.48746520229, 53242.30176033840},
	{0.00000000008, 5.56477337187, 27177.61193276780},
	{0.00000000009, 5.00034866965, 102132.85546210999},
	{0.00000000007, 0.40751314845, 2111.65031337760},
	{0.00000000008, 1.66471235682, 52290.24557183361},
	{0.00000000007, 0.77215567463, 26073.67604757259},
	{0.00000000007, 5.32306426879, 52595.29092702359},
	{0.00000000007, 2.57023734016, 24448.83362438620},
	{0.00000000007, 1.40330361432, 150244.34299945379},
	{0.00000000008, 3.96541390761, 52325.36948028299},
	{0.00000000008, 0.64215744063, 53228.07466633679},
	{0.00000000007, 5.40994893955, 25508.21555457540},
	{0.00000000009, 0.63097343517, 170049.17029103659},
	{0.00000000006, 2.73735624509, 153.77881048480},
	{0.00000000006, 1.57808561874, 49842.60989027639},
	{0.00000000006, 5.85639973088, 182085.63102592478},
	{0.00000000007, 1.22602076365, 107794.18751126219},
	{0.00000000007, 2.99828544115, 22625.65843570900},
	{0.00000000007, 3.38113527243, 12546.48193908300},
	{0.00000000006, 5.98824736570, 76667.52298243798},
	{0.00000000007, 2.75252330601, 172402.03644480839},
	{0.00000000007, 0.93184314111, 3328.13565628019},
	{0.00000000006, 2.72361970528, 26709.64694241340},
	{0.00000000008, 1.81192469081, 78270.33798362259},
	{0.00000000006, 2.31595886989, 157057.10981453978},
	{0.00000000006, 1.73557063122, 26667.59072857300},
	{0.00000000006, 4.37863242786, 25466.15934073500},
	{0.00000000006, 3.19403160700, 104275.34649502118},
	{0.00000000006, 1.09823646265, 25867.49049913539},
	{0.00000000007, 0.11236053840, 25764.39772491679},
	{0.00000000007, 5.69537766284, 66653.15746634839},
	{0.00000000007, 1.98238737869, 846.08283475120},
	{0.00000000006, 0.65894058731, 116783.65521669458},
	{0.00000000005, 4.66761334131, 2125.87740737920},
	{0.00000000006, 4.52221761723, 27726.97265876220},
	{0.00000000006, 0.09840227420, 167850.08294774959},
	{0.00000000006, 3.36608415071, 129799.61842155698},
	{0.00000000007, 5.27549434329, 52061.36699446317},
	{0.00000000007, 1.32305784951, 209812.60368468695},
	{0.00000000006, 3.60884349448, 78903.60671103658},
	{0.00000000005, 3.76183094594, 28256.66362385679},
	{0.00000000006, 5.26397966812, 75930.51303185058},
	{0.00000000006, 3.23097479261, 27669.86248985719},
	{0.00000000005, 5.68060753615, 1265.56747862640},
	{0.00000000005, 3.87273283224, 214364.55718174578},
	{0.00000000005, 3.93047654027, 365230.64398203876},
	{0.00000000006, 2.60562458198, 44295.71712980940},
	{0.00000000005, 1.56438384826, 60370.08161635699},
	{0.00000000005, 0.91437456221, 27684.08958385880},
	{0.00000000005, 2.78304413268, 25169.97285559240},
	{0.00000000006, 5.76131236705, 58857.03113654799},
	{0.00000000005, 2.67085954875, 38.13303563780},
	{0.00000000006, 0.50453577398, 155571.81910783658},
	{0.00000000005, 3.86250449828, 52381.99183158559},
	{0.00000000005, 4.32361771821, 27005.83342755599},
	{0.00000000005, 1.63783306460, 34082.43158359840},
	{0.00000000006, 4.13235037436, 29550.14784743939},
	{0.00000000005, 0.09069856194, 13541.42120249119},
	{0.00000000005, 5.50663993071, 26402.08932144380},
	{0.00000000004, 5.22554265930, 28736.35796704720},
	{0.00000000005, 5.88997457155, 78188.92782615528},
	{0.00000000005, 1.29427545799, 77630.92568540938},
	{0.00000000006, 3.65818107099, 76681.75007643958},
	{0.00000000005, 1.59378640261, 25773.71696170459},
	{0.00000000005, 5.53985466815, 24203.00197815680},
	{0.00000000005, 1.10121885185, 130459.18546877075},
	{0.00000000005, 3.55866759420, 52252.07235442399},
	{0.00000000004, 5.49843651098, 52712.61079524379},
	{0.00000000005, 3.39959787962, 104505.39137678158},
	{0.00000000005, 1.94175393423, 1272.68102562720},
	{0.00000000004, 0.58115883263, 26118.23000257860},
	{0.00000000004, 0.54682947961, 157586.80077963437},
	{0.00000000004, 2.04212740892, 148.07872442630},
	{0.00000000005, 1.64853656178, 26198.10946279360},
	{0.00000000005, 0.18946812001, 1.48447270830},
	{0.00000000004, 5.04774492766, 112231.70171963578},
	{0.00000000004, 3.24889530044, 26312.24793727610},
	{0.00000000005, 2.14793916248, 128320.75184749259},
	{0.00000000004, 3.03681019540, 151.04766984290},
	{0.00000000004, 0.23608219351, 26057.57628056979},
	{0.00000000004, 2.78449581166, 25138.72753260440},
	{0.00000000004, 1.74750321635, 27044.19229754480},
	{0.00000000004, 5.26585590029, 138319.60486120995},
	{0.00000000004, 2.16361705057, 78366.80219894118},
	{0.00000000005, 1.86438708559, 51653.22886505459},
	{0.00000000004, 3.67745684549, 148532.89040742096},
	{0.00000000005, 3.36418574107, 86457.98475793119},
	{0.00000000004, 4.39817949768, 78896.49316403578},
	{0.00000000004, 3.16495363173, 104197.83375581198},
	{0.00000000004, 5.96720583626, 1485.98012106520},
	{0.00000000003, 3.62369510287, 51852.30086649099},
	{0.00000000004, 4.95850373202, 80382.47328510099},
	{0.00000000003, 0.24273955075, 128106.31931499895},
	{0.00000000004, 6.09423095974, 51528.79544983359},
	{0.00000000004, 2.26832726016, 64901.25971792339},
	{0.00000000004, 5.37231956323, 99024.13645791399},
	{0.00000000004, 5.83099981006, 26411.40855823160},
	{0.00000000003, 5.27877050710, 14.22709400160},
	{0.00000000004, 1.01079656557, 16703.06213349900},
	{0.00000000003, 5.29624442233, 51432.81622261579},
	{0.00000000003, 1.99372517333, 9384.84100807520},
	{0.00000000003, 1.08549694329, 92741.06060792258},
	{0.00000000004, 2.61532511231, 27250.37784598199},
	{0.00000000004, 3.84384246230, 65831.66677432480},
	{0.00000000004, 5.07647835306, 118828.96374949679},
	{0.00000000004, 0.95691561960, 1795.25844372100},
	{0.00000000003, 4.56071055194, 130419.84594697120},
	{0.00000000004, 3.21002699852, 51969.62073471119},
	{0.00000000003, 0.53542089836, 25985.94062330859},
	{0.00000000003, 0.86346795613, 27972.80430499159},
	{0.00000000004, 1.11850373850, 52609.51802102519},
	{0.00000000003, 5.13697350283, 26189.86565983980},
	{0.00000000003, 3.83162907268, 207593.84658050018},
	{0.00000000003, 3.70405700948, 193937.98608932378},
	{0.00000000003, 1.82907554275, 153084.84390447979},
	{0.00000000003, 1.75677414102, 158746.17595363196},
	{0.00000000003, 0.34579536632, 161079.37234650398},
	{0.00000000003, 3.85483830173, 39629.32434406539},
	{0.00000000003, 0.82694378727, 51868.24866217880},
	{0.00000000003, 0.16328069810, 27463.67694142000},
	{0.00000000003, 4.08971647963, 130226.21661243298},
	{0.00000000004, 3.70176043302, 163766.09444104518},
	{0.00000000003, 1.31853873267, 204151.27163553478},
	{0.00000000004, 2.50849600287, 220.41264243880},
	{0.00000000003, 3.29076294593, 125112.03959948818},
	{0.00000000003, 5.82527117029, 49953.94964855139},
	{0.00000000003, 1.83258674312, 37698.45509994840},
	{0.00000000003, 1.84707936363, 26076.85744131030},
	{0.00000000003, 3.96840940578, 130432.40216087017},
	{0.00000000003, 0.01192870778, 26098.94884183810},
	{0.00000000003, 2.24128507678, 78160.61665050399},
	{0.00000000003, 1.67457691866, 182188.72380014337},
	{0.00000000003, 1.36021422148, 136722.59155786238},
	{0, 0, 0}
};

struct vsop87_term mercury_z1[] = {
	{0.00108722177, 3.91134750825, 26087.90314157420},
	{0.00057826621, 3.14159265359, 0.00000000000},
	{0.00004297352, 2.56373047177, 52175.80628314840},
	{0.00002435833, 0.05112640506, 78263.70942472259},
	{0.00000795699, 3.20041081922, 104351.61256629678},
	{0.00000229251, 0.00558431110, 130439.51570787099},
	{0.00000063404, 3.07612843684, 156527.41884944518},
	{0.00000017253, 6.13908634954, 182615.32199101939},
	{0.00000009622, 0.37621894804, 27197.28169366760},
	{0.00000006297, 0.39728882750, 24978.52458948080},
	{0.00000004662, 2.91492698307, 208703.22513259358},
	{0.00000002148, 3.48577221863, 53285.18483524180},
	{0.00000001752, 3.07246871620, 31749.23519072640},
	{0.00000001734, 3.48012770286, 51066.42773105500},
	{0.00000001256, 5.97163248139, 234791.12827416777},
	{0.00000000919, 2.20247811299, 51116.42435295920},
	{0.00000000893, 2.83549644335, 1109.37855209340},
	{0.00000000834, 0.65008044610, 25028.52121138500},
	{0.00000000706, 4.09989437475, 21535.94964451540},
	{0.00000000549, 4.55772827645, 27043.50288318280},
	{0.00000000599, 1.30707878411, 5661.33204915220},
	{0.00000000503, 0.26513156342, 77154.33087262919},
	{0.00000000573, 4.27226335442, 1059.38193018920},
	{0.00000000395, 4.32073156427, 47623.85278608960},
	{0.00000000390, 3.05829239675, 26107.57290247399},
	{0.00000000370, 0.26188837520, 79373.08797681599},
	{0.00000000365, 0.25587601358, 529.69096509460},
	{0.00000000342, 0.06201621683, 57837.13833230060},
	{0.00000000338, 2.74361031332, 260879.03141574195},
	{0.00000000319, 4.06638794904, 26068.23338067440},
	{0.00000000347, 5.42940711986, 37410.56723987860},
	{0.00000000329, 2.57908142670, 25132.30339996560},
	{0.00000000282, 0.72426739653, 46514.47423399620},
	{0.00000000303, 2.97597780334, 30639.85663863300},
	{0.00000000326, 3.09888267640, 20426.57109242200},
	{0.00000000283, 6.18870391394, 1589.07289528380},
	{0.00000000315, 5.97732845019, 26084.02180621620},
	{0.00000000267, 3.50170128183, 25558.21217647960},
	{0.00000000236, 1.57642784422, 27147.28507176339},
	{0.00000000267, 1.13990449748, 26091.78447693220},
	{0.00000000235, 1.49701289406, 14765.23904326980},
	{0.00000000232, 2.69589305138, 10213.28554621100},
	{0.00000000236, 2.22525353065, 4551.95349705880},
	{0.00000000194, 1.02173542846, 50586.73338786459},
	{0.00000000175, 0.12964063811, 28306.66024576099},
	{0.00000000158, 4.72011691978, 13521.75144159140},
	{0.00000000148, 0.50941562343, 23869.14603738740},
	{0.00000000146, 3.32809085248, 103242.23401420339},
	{0.00000000148, 2.67606270632, 32858.61374281979},
	{0.00000000148, 3.97558333546, 26617.59410666880},
	{0.00000000144, 6.17471854034, 39609.65458316560},
	{0.00000000135, 5.29023702746, 15874.61759536320},
	{0.00000000127, 1.74708107452, 41962.52073693740},
	{0.00000000167, 1.41845890576, 53131.40602475700},
	{0.00000000142, 5.51538705616, 77204.32749453338},
	{0.00000000143, 5.60549263164, 25661.30495069820},
	{0.00000000135, 4.51294119590, 22645.32819660879},
	{0.00000000114, 1.61571061542, 51749.20809227239},
	{0.00000000136, 2.44803626803, 24498.83024629040},
	{0.00000000123, 2.92199816754, 7.11354700080},
	{0.00000000111, 5.61693406682, 51220.20654153979},
	{0.00000000128, 4.16885336182, 19317.19254032860},
	{0.00000000119, 3.89351050712, 72602.37737557039},
	{0.00000000105, 2.35643129018, 63498.47038145279},
	{0.00000000108, 2.29989754953, 19804.82729158280},
	{0.00000000118, 5.34899821984, 9103.90699411760},
	{0.00000000131, 5.10396827386, 51646.11531805379},
	{0.00000000090, 3.10411714137, 29530.47808653960},
	{0.00000000102, 1.51408473952, 43071.89928903080},
	{0.00000000099, 2.91528801994, 3442.57494496540},
	{0.00000000083, 4.86155505530, 53235.18821333759},
	{0.00000000091, 5.79825387142, 286966.93455731616},
	{0.00000000077, 1.85515220962, 1066.49547719000},
	{0.00000000086, 1.26853285597, 52705.49724824299},
	{0.00000000087, 0.72759501705, 955.59974160860},
	{0.00000000085, 4.42703723237, 639.89728631400},
	{0.00000000071, 6.10725384639, 52195.47604404819},
	{0.00000000069, 1.67616660064, 11322.66409830440},
	{0.00000000075, 2.39295477917, 1052.26838318840},
	{0.00000000070, 1.30207069777, 73711.75592766379},
	{0.00000000081, 0.50340529337, 12566.15169998280},
	{0.00000000087, 6.02618346605, 56727.75978020720},
	{0.00000000064, 2.37390283244, 6283.07584999140},
	{0.00000000074, 0.83774903676, 52156.13652224860},
	{0.00000000062, 0.53772034528, 25035.63475838580},
	{0.00000000062, 5.21607078985, 213.29909543800},
	{0.00000000055, 3.37388306274, 54394.56338733519},
	{0.00000000072, 5.15200652842, 6770.71060124560},
	{0.00000000058, 2.74579734777, 52171.92494779040},
	{0.00000000053, 3.37195010831, 105460.99111839019},
	{0.00000000054, 3.13274907598, 16983.99614745660},
	{0.00000000057, 4.55150471829, 40853.14218484400},
	{0.00000000052, 1.08065292487, 25021.40766438420},
	{0.00000000057, 2.75679326163, 27676.97603685800},
	{0.00000000050, 2.66709856718, 2218.75710418680},
	{0.00000000048, 2.42991055784, 51535.90899683439},
	{0.00000000044, 3.39778429468, 52168.69273614759},
	{0.00000000061, 4.19872301893, 52179.68761850640},
	{0.00000000055, 4.79861662627, 25448.00585526019},
	{0.00000000057, 5.98485072073, 58946.51688439399},
	{0.00000000043, 0.10468670721, 129330.13715577759},
	{0.00000000046, 3.95713790204, 76674.63652943878},
	{0.00000000048, 0.56028391393, 2118.76386037840},
	{0.00000000054, 6.03589506827, 26080.78959457339},
	{0.00000000052, 5.90025920123, 26095.01668857500},
	{0.00000000047, 3.30474983516, 25874.60404613620},
	{0.00000000039, 1.38925724838, 26301.20223701220},
	{0.00000000038, 5.10867352468, 51109.31080595839},
	{0.00000000039, 3.92764341118, 48733.23133818299},
	{0.00000000037, 4.06335565460, 38654.05484155699},
	{0.00000000036, 2.58651261399, 33326.57873317420},
	{0.00000000036, 2.37849808537, 77308.10968311399},
	{0.00000000035, 2.51199649101, 110012.94461544899},
	{0.00000000042, 5.12550293524, 18849.22754997420},
	{0.00000000036, 3.01544789695, 65697.55772473979},
	{0.00000000034, 3.58250413994, 49957.04917896160},
	{0.00000000038, 5.08242945191, 426.59819087600},
	{0.00000000033, 2.98998399815, 52182.91983014920},
	{0.00000000035, 4.81500543604, 69159.80243060499},
	{0.00000000030, 2.26689961718, 26514.50133245020},
	{0.00000000041, 0.69895535280, 98690.28051714458},
	{0.00000000030, 5.32057648028, 59414.48187474840},
	{0.00000000028, 1.68266249602, 13655.86049117640},
	{0.00000000028, 0.94446303339, 45405.09568190280},
	{0.00000000027, 4.36683104110, 45892.73043315699},
	{0.00000000029, 0.10950522744, 32370.97899156560},
	{0.00000000033, 4.33155420786, 78793.40038981718},
	{0.00000000034, 4.98037524090, 83925.04147387479},
	{0.00000000023, 5.02100001952, 38519.94579197200},
	{0.00000000027, 2.80994919073, 82815.66292178139},
	{0.00000000028, 1.74282790985, 79323.09135491178},
	{0.00000000027, 0.28076690940, 50057.04242277000},
	{0.00000000030, 4.47636450035, 51123.53789995999},
	{0.00000000022, 5.48879950844, 433.71173787680},
	{0.00000000023, 2.29729212380, 25934.12433108940},
	{0.00000000021, 6.12545300745, 55618.38122811380},
	{0.00000000028, 1.99718125621, 23969.13928119580},
	{0.00000000020, 5.02045625760, 62389.09182935939},
	{0.00000000027, 5.94991611742, 36301.18868778519},
	{0.00000000021, 6.11796766629, 419.48464387520},
	{0.00000000025, 3.81085583999, 103292.23063610759},
	{0.00000000022, 5.11742565391, 52389.10537858640},
	{0.00000000024, 2.56844167585, 313054.83769889036},
	{0.00000000018, 1.14666568569, 12432.04265039780},
	{0.00000000021, 4.43914073078, 79219.30916633119},
	{0.00000000017, 1.26846398958, 129380.13377768178},
	{0.00000000018, 4.35450426346, 23754.70674870219},
	{0.00000000016, 3.43674109707, 25654.19140369739},
	{0.00000000017, 1.21295214728, 25619.93815121980},
	{0.00000000017, 4.88341452559, 77837.11123384659},
	{0.00000000017, 5.64525452444, 136100.84775702319},
	{0.00000000020, 1.45417843599, 66941.04532641819},
	{0.00000000014, 5.44182921160, 89586.37352302698},
	{0.00000000018, 2.83938591200, 25668.41849769900},
	{0.00000000018, 3.80808950852, 25973.46385288896},
	{0.00000000014, 2.87427500051, 78283.37918562238},
	{0.00000000015, 1.23233013937, 26727.80042788820},
	{0.00000000014, 2.46376055999, 1596.18644228460},
	{0.00000000019, 3.89131231180, 78244.03966382280},
	{0.00000000016, 3.64255427035, 853.19638175200},
	{0.00000000015, 0.97248576911, 78267.59076008058},
	{0.00000000013, 4.95074075966, 27154.39861876420},
	{0.00000000017, 5.83556508068, 53764.87917843220},
	{0.00000000012, 3.15781754753, 155418.04029735178},
	{0.00000000015, 1.91063402672, 44937.13069154840},
	{0.00000000016, 3.31784437154, 26202.34243025941},
	{0.00000000012, 5.79880666801, 78259.82808936459},
	{0.00000000012, 0.78485262110, 51962.50718771040},
	{0.00000000015, 1.11484431483, 74821.13447975718},
	{0.00000000014, 3.77122510089, 124778.18365871879},
	{0.00000000012, 4.34152068071, 94138.32702008578},
	{0.00000000013, 0.98498982943, 64741.95798313119},
	{0.00000000011, 0.01126157685, 80482.46652890938},
	{0.00000000012, 5.38061503044, 52602.40447402440},
	{0.00000000011, 5.42471517163, 103396.01282468818},
	{0.00000000011, 1.92091833374, 77197.21394753258},
	{0.00000000011, 2.51043583674, 77734.01845962799},
	{0.00000000012, 5.59878501315, 77623.81213840858},
	{0.00000000012, 0.20589141568, 78256.59587772179},
	{0.00000000013, 3.17586650226, 28421.09953444620},
	{0.00000000010, 4.05322231768, 26241.68195205900},
	{0.00000000010, 1.39265587740, 51742.09454527159},
	{0.00000000010, 6.08175105796, 78270.82297172339},
	{0.00000000011, 2.69589922169, 26137.89976347840},
	{0.00000000010, 3.07928279036, 2333.19639287200},
	{0.00000000011, 0.30468128561, 68050.42387851159},
	{0.00000000009, 5.53388738438, 7994.52844202420},
	{0.00000000011, 1.08579591854, 104881.30353139139},
	{0.00000000009, 0.40604041041, 24491.71669928959},
	{0.00000000011, 1.95060315202, 1581.95934828300},
	{0.00000000010, 1.36389391290, 77211.44104153418},
	{0.00000000011, 2.39071740763, 64607.84893354619},
	{0.00000000009, 1.91392780093, 88476.99497093359},
	{0.00000000008, 4.69235988049, 536.80451209540},
	{0.00000000008, 4.94434306289, 632.78373931320},
	{0.00000000009, 0.35558235819, 76044.95232053580},
	{0.00000000009, 4.46490542313, 26037.90651966999},
	{0.00000000008, 0.49047863023, 102762.53967101299},
	{0.00000000008, 5.85483327203, 108903.56606335558},
	{0.00000000008, 4.03785547628, 71492.99882347698},
	{0.00000000009, 4.85229479056, 105410.99449648599},
	{0.00000000009, 2.51175483230, 85034.42002596818},
	{0.00000000008, 0.01221598580, 5327.47610838280},
	{0.00000000007, 5.78988808042, 26555.86813192860},
	{0.00000000007, 4.27853212968, 18207.81398823521},
	{0.00000000007, 2.02962199178, 78477.00852016058},
	{0.00000000007, 3.20780787297, 18093.37469954999},
	{0.00000000007, 3.29917452925, 51322.60990139639},
	{0.00000000008, 4.46683241624, 155468.03691925599},
	{0.00000000007, 4.04442368573, 25455.11940226100},
	{0.00000000007, 0.70887703358, 24505.94379329119},
	{0.00000000008, 3.50499122731, 28206.66700195260},
	{0.00000000009, 5.55849714525, 27140.17152476259},
	{0.00000000007, 3.67689450101, 125887.56221081219},
	{0.00000000008, 3.21701385277, 76144.94556434419},
	{0.00000000007, 4.49386341300, 50579.61984086379},
	{0.00000000007, 3.33858090062, 58458.88213313979},
	{0.00000000008, 1.14310455995, 103821.92160120218},
	{0.00000000008, 5.48340707498, 25234.70675982219},
	{0.00000000008, 0.66014034660, 51756.32163927320},
	{0.00000000007, 0.91622586929, 46848.33017476560},
	{0.00000000006, 4.71362239722, 647.01083331480},
	{0.00000000006, 2.84816755580, 81706.28436968799},
	{0.00000000008, 0.54081102339, 35191.81013569180},
	{0.00000000007, 5.97950952528, 99799.65906923798},
	{0.00000000007, 5.59806550392, 339142.74084046457},
	{0.00000000008, 2.06065598813, 71980.63357473118},
	{0.00000000007, 2.35899025407, 33967.99229491319},
	{0.00000000006, 4.54497734613, 93028.94846799239},
	{0.00000000005, 4.96809690798, 52026.24308601380},
	{0.00000000006, 1.23723826618, 44181.27784112419},
	{0.00000000006, 1.22067313314, 120226.23016165999},
	{0.00000000006, 1.20900133400, 2648.45482547300},
	{0.00000000005, 3.28690720493, 25938.33994443960},
	{0.00000000005, 4.99695296239, 71025.03383312259},
	{0.00000000005, 3.80540207824, 78050.41032928458},
	{0.00000000006, 2.46355111951, 162188.75089859738},
	{0.00000000005, 5.46272081654, 26610.48055966799},
	{0.00000000005, 0.63510871716, 104331.94280539699},
	{0.00000000004, 5.71678194245, 98068.53671630539},
	{0.00000000004, 3.52099164933, 26507.38778544939},
	{0.00000000004, 5.31353397656, 117873.36400788819},
	{0.00000000004, 5.13194743371, 7880.08915333899},
	{0.00000000005, 1.63217415397, 91785.46086631398},
	{0.00000000004, 4.85259057218, 50593.84693486539},
	{0.00000000004, 3.58205868095, 45494.58142974879},
	{0.00000000004, 0.56456514853, 150866.08680029298},
	{0.00000000004, 4.05482156113, 104355.49390165479},
	{0.00000000005, 4.31294151281, 10021.83728009940},
	{0.00000000005, 0.67943011611, 522.57741809380},
	{0.00000000004, 0.78297474988, 26081.27458267419},
	{0.00000000005, 2.59888164869, 79852.78232000639},
	{0.00000000004, 4.42615122275, 52815.70356946240},
	{0.00000000004, 4.38434908977, 129909.82474277639},
	{0.00000000004, 4.52782207994, 39743.76363275060},
	{0.00000000004, 2.20941190445, 26521.61487945100},
	{0.00000000005, 5.32700006988, 25551.09862947879},
	{0.00000000004, 0.64407233905, 22759.76748529401},
	{0.00000000004, 0.87584552144, 95247.70557217918},
	{0.00000000004, 2.22216873998, 51639.00177105299},
	{0.00000000003, 5.36514246733, 52099.54021187280},
	{0.00000000003, 4.57090150345, 103299.34418310839},
	{0.00000000004, 4.07559367157, 130969.20667296558},
	{0.00000000004, 1.99404423656, 53242.30176033840},
	{0.00000000004, 0.10237777214, 52290.24557183361},
	{0.00000000003, 2.16782942564, 129483.91596626239},
	{0.00000000003, 3.70439682827, 26011.63707029860},
	{0.00000000004, 6.19007910993, 181505.94343892598},
	{0.00000000003, 3.38593366707, 22747.29071487440},
	{0.00000000004, 4.13509939102, 90829.86112470538},
	{0.00000000004, 3.81107948599, 7238.67559160000},
	{0.00000000004, 2.22487204858, 78690.30761559859},
	{0.00000000003, 2.90685522022, 104358.72611329758},
	{0.00000000004, 0.21293011176, 29416.03879785439},
	{0.00000000004, 4.66094846706, 26190.99591579279},
	{0.00000000004, 1.44138552313, 52329.58509363319},
	{0.00000000003, 3.88120838753, 24864.08530079559},
	{0.00000000003, 3.23195009997, 27311.72098235281},
	{0.00000000003, 0.59206616691, 151975.46535238638},
	{0.00000000004, 3.92282949127, 26094.53170047421},
	{0.00000000004, 0.36706915227, 26624.70765366959},
	{0.00000000003, 5.02263365854, 13362.44970679920},
	{0.00000000003, 4.48812754789, 77829.99768684579},
	{0.00000000003, 1.61364456756, 131498.89763806018},
	{0.00000000003, 2.35918530711, 53228.07466633679},
	{0.00000000003, 6.23943631292, 54509.00267602040},
	{0.00000000003, 5.96454474491, 104371.28232719658},
	{0.00000000004, 2.69614750910, 42153.96900304900},
	{0.00000000004, 5.02476392638, 114564.89811250778},
	{0.00000000003, 1.72345770389, 20760.42703319140},
	{0.00000000003, 0.50072748279, 26941.09952332620},
	{0.00000000003, 1.96977611447, 25565.32572348040},
	{0.00000000003, 5.11624187785, 206.18554843720},
	{0.00000000003, 0.51349992272, 131548.89425996438},
	{0.00000000003, 3.95256477489, 77844.22478084739},
	{0.00000000002, 5.27163804648, 104564.91166173479},
	{0.00000000002, 0.91771435129, 97580.90196505119},
	{0.00000000003, 6.19741175627, 1478.86657406440},
	{0.00000000002, 5.59272300692, 27684.08958385880},
	{0.00000000003, 0.49620259289, 84546.78527471398},
	{0.00000000003, 0.55085259267, 52061.36699446317},
	{0.00000000003, 3.60660500687, 90695.75207512038},
	{0.00000000003, 2.55821625518, 103711.71527998279},
	{0.00000000002, 4.99656134147, 103285.11708910679},
	{0.00000000003, 6.09360707526, 3340.61242669980},
	{0.00000000003, 5.65125942893, 52022.02747266360},
	{0.00000000003, 3.20289240295, 106570.36967048359},
	{0.00000000003, 2.51813838035, 100909.03762133139},
	{0.00000000003, 2.68010870521, 52643.77127350280},
	{0.00000000002, 2.44153022122, 6681.22485339960},
	{0.00000000003, 5.92095118575, 49527.35145767539},
	{0.00000000002, 6.16203356882, 157636.79740153858},
	{0.00000000003, 1.36500275259, 181555.94006083018},
	{0.00000000002, 6.07006355391, 111122.32316754239},
	{0.00000000002, 1.23018945268, 51543.02254383520},
	{0.00000000003, 1.60593056043, 149.56319713460},
	{0.00000000002, 5.44832173338, 188276.65404017158},
	{0.00000000002, 3.35555846135, 104344.49901929598},
	{0.00000000002, 1.11410400334, 31415.37924995700},
	{0.00000000003, 3.45570860970, 102132.85546210999},
	{0.00000000002, 1.24196977449, 52125.80966124419},
	{0.00000000003, 3.25629749382, 103925.01437542078},
	{0.00000000002, 3.48238572047, 25881.71759313700},
	{0.00000000002, 2.46677138393, 3328.13565628019},
	{0.00000000002, 2.20368175695, 143961.26714946238},
	{0.00000000002, 4.84459398809, 70269.18098269838},
	{0.00000000002, 1.68083413322, 25984.81036735560},
	{0.00000000003, 5.26458846607, 60055.89543648739},
	{0.00000000002, 2.45157941038, 52698.38370124219},
	{0.00000000002, 0.78207794200, 130012.91751699499},
	{0.00000000002, 0.98920727566, 76.26607127560},
	{0.00000000002, 3.92568245374, 956.28915597060},
	{0.00000000002, 2.65082246284, 11610.55195837420},
	{0.00000000002, 2.68749814956, 124156.43985787958},
	{0.00000000002, 4.33665959283, 146314.13330323418},
	{0.00000000002, 0.15981568000, 77410.51304297059},
	{0.00000000002, 0.32248774042, 155997.72788435058},
	{0.00000000002, 6.12803752756, 104138.31347085879},
	{0.00000000002, 0.21368583386, 54294.57014352679},
	{0.00000000002, 0.65535255591, 1162.47470440780},
	{0.00000000002, 3.29929774684, 128850.44281258718},
	{0.00000000002, 2.01772381418, 134991.46920492979},
	{0.00000000002, 5.39328391253, 32769.12799497380},
	{0.00000000001, 4.12045734648, 25440.89230825939},
	{0.00000000002, 5.86068713588, 16066.06586147480},
	{0.00000000001, 6.27237588760, 105940.68546158058},
	{0.00000000001, 1.18539094152, 12546.48193908300},
	{0.00000000001, 1.60398831894, 26294.08869001139},
	{0.00000000001, 3.99060758894, 25867.49049913539},
	{0.00000000002, 2.21751883952, 103.09277421860},
	{0.00000000002, 1.60021595888, 51528.79544983359},
	{0, 0, 0}
};

struct vsop87_term mercury_z2[] = {
	{0.00001053118, 5.37979214357, 26087.90314157420},
	{0.00001185024, 0.00000000000, 0.00000000000},
	{0.00000087113, 0.42206932430, 52175.80628314840},
	{0.00000049534, 4.38054039769, 78263.70942472259},
	{0.00000025685, 1.45827443162, 104351.61256629678},
	{0.00000010457, 4.62224691737, 130439.51570787099},
	{0.00000003757, 1.44589954776, 156527.41884944518},
	{0.00000001259, 4.52974728932, 182615.32199101939},
	{0.00000000405, 1.31903942108, 208703.22513259358},
	{0.00000000510, 2.02741559889, 27197.28169366760},
	{0.00000000194, 4.84656399029, 24978.52458948080},
	{0.00000000126, 4.38484918485, 234791.12827416777},
	{0.00000000084, 5.13112206401, 53285.18483524180},
	{0.00000000081, 1.77991669334, 51066.42773105500},
	{0.00000000041, 5.92878165673, 21535.94964451540},
	{0.00000000038, 4.59494089680, 31749.23519072640},
	{0.00000000039, 1.16389533568, 260879.03141574195},
	{0.00000000031, 5.70517746266, 27043.50288318280},
	{0.00000000031, 4.90092982476, 77154.33087262919},
	{0.00000000025, 3.42051368965, 51116.42435295920},
	{0.00000000023, 5.12888703467, 1109.37855209340},
	{0.00000000020, 5.51663618269, 529.69096509460},
	{0.00000000016, 1.90390313968, 28306.66024576099},
	{0.00000000020, 0.17917379064, 25028.52121138500},
	{0.00000000015, 1.05701795325, 20426.57109242200},
	{0.00000000013, 1.81822077884, 25132.30339996560},
	{0.00000000012, 5.73430455559, 22645.32819660879},
	{0.00000000011, 5.17414328474, 23869.14603738740},
	{0.00000000012, 0.83014470454, 37410.56723987860},
	{0.00000000011, 1.70573481806, 103242.23401420339},
	{0.00000000012, 4.22252353447, 286966.93455731616},
	{0.00000000010, 5.89719716922, 47623.85278608960},
	{0.00000000010, 6.25321109518, 4551.95349705880},
	{0.00000000011, 2.38969901037, 50586.73338786459},
	{0.00000000009, 4.94664962083, 26107.57290247399},
	{0.00000000009, 1.94242243150, 79373.08797681599},
	{0.00000000009, 4.50823985532, 32858.61374281979},
	{0.00000000010, 4.80498005582, 1589.07289528380},
	{0.00000000010, 3.66489496424, 25558.21217647960},
	{0.00000000007, 2.38751237733, 53131.40602475700},
	{0.00000000008, 4.77323220031, 46514.47423399620},
	{0.00000000007, 1.59120637282, 26084.02180621620},
	{0.00000000007, 5.50461749703, 14765.23904326980},
	{0.00000000006, 2.44506021688, 26617.59410666880},
	{0.00000000008, 6.04439838452, 26068.23338067440},
	{0.00000000006, 5.86363603201, 25874.60404613620},
	{0.00000000007, 3.11235514306, 26091.78447693220},
	{0.00000000007, 2.52359174803, 19317.19254032860},
	{0.00000000006, 2.52692228886, 213.29909543800},
	{0.00000000005, 4.50577216714, 51220.20654153979},
	{0.00000000006, 5.49024917012, 25973.46385288896},
	{0.00000000004, 4.99984592617, 54394.56338733519},
	{0.00000000004, 3.56822908434, 9103.90699411760},
	{0.00000000005, 3.36356474475, 43071.89928903080},
	{0.00000000004, 3.41104929582, 25661.30495069820},
	{0.00000000005, 1.61564484968, 26202.34243025941},
	{0.00000000004, 2.04986993982, 72602.37737557039},
	{0.00000000004, 4.78586478582, 129330.13715577759},
	{0.00000000004, 1.23285415070, 39609.65458316560},
	{0.00000000004, 1.99566356802, 26095.01668857500},
	{0.00000000004, 1.35380519898, 29530.47808653960},
	{0.00000000005, 1.23150173506, 3442.57494496540},
	{0.00000000004, 6.07982863589, 7.11354700080},
	{0.00000000005, 3.14220892226, 10213.28554621100},
	{0.00000000004, 0.26585418784, 51646.11531805379},
	{0.00000000004, 2.77782586170, 41962.52073693740},
	{0.00000000004, 1.09650929108, 5661.33204915220},
	{0.00000000004, 1.42544654600, 1059.38193018920},
	{0.00000000003, 1.97577379834, 49957.04917896160},
	{0.00000000003, 6.02171816863, 52705.49724824299},
	{0.00000000004, 1.66969189830, 30639.85663863300},
	{0.00000000003, 1.24157422567, 57837.13833230060},
	{0.00000000004, 2.56870959742, 639.89728631400},
	{0.00000000003, 4.24139247807, 51535.90899683439},
	{0.00000000003, 3.78980887484, 1066.49547719000},
	{0.00000000003, 4.31183095451, 2218.75710418680},
	{0.00000000003, 2.71716318847, 26080.78959457339},
	{0.00000000003, 3.08295372453, 33326.57873317420},
	{0.00000000003, 2.83124529131, 40853.14218484400},
	{0.00000000003, 3.98094106813, 63498.47038145279},
	{0.00000000003, 6.11998019073, 36301.18868778519},
	{0.00000000003, 0.99287952932, 313054.83769889036},
	{0.00000000003, 4.47232610391, 24498.83024629040},
	{0.00000000003, 4.39447085694, 56727.75978020720},
	{0.00000000002, 3.14629176189, 53235.18821333759},
	{0.00000000003, 1.29496956788, 58946.51688439399},
	{0.00000000003, 5.78518537876, 48733.23133818299},
	{0.00000000002, 5.85755018741, 26301.20223701220},
	{0.00000000002, 2.40580678378, 6283.07584999140},
	{0.00000000003, 5.69045733615, 2118.76386037840},
	{0.00000000002, 0.74752177962, 955.59974160860},
	{0.00000000003, 5.78326807846, 77204.32749453338},
	{0.00000000002, 3.23521381372, 16983.99614745660},
	{0.00000000002, 2.51660292710, 426.59819087600},
	{0.00000000002, 0.60194942543, 38519.94579197200},
	{0.00000000002, 4.25397821203, 1052.26838318840},
	{0.00000000002, 5.22827823253, 76674.63652943878},
	{0.00000000002, 1.10676834844, 77308.10968311399},
	{0.00000000002, 5.59153557926, 23754.70674870219},
	{0.00000000002, 0.11046591263, 13655.86049117640},
	{0.00000000002, 5.62658768684, 45405.09568190280},
	{0.00000000002, 4.51918269786, 15874.61759536320},
	{0.00000000002, 5.81399594028, 27147.28507176339},
	{0.00000000002, 4.45536988130, 55618.38122811380},
	{0.00000000002, 1.67886337044, 103292.23063610759},
	{0.00000000002, 0.80870638069, 6770.71060124560},
	{0.00000000002, 5.31050462895, 98690.28051714458},
	{0.00000000002, 1.62830798818, 50057.04242277000},
	{0.00000000001, 6.01789746929, 25448.00585526019},
	{0.00000000001, 4.78174334560, 18849.22754997420},
	{0.00000000001, 1.57539135914, 155418.04029735178},
	{0.00000000002, 2.85669980691, 78793.40038981718},
	{0.00000000001, 1.75120212864, 853.19638175200},
	{0.00000000001, 5.64239884249, 26514.50133245020},
	{0.00000000001, 2.84295285158, 51749.20809227239},
	{0.00000000002, 1.45037370060, 27676.97603685800},
	{0.00000000001, 1.23148841961, 82815.66292178139},
	{0.00000000001, 3.52678021698, 13521.75144159140},
	{0.00000000001, 4.70607503583, 52290.24557183361},
	{0.00000000001, 1.53818723749, 28421.09953444620},
	{0.00000000001, 0.02671273573, 79323.09135491178},
	{0.00000000001, 4.97923101690, 76044.95232053580},
	{0.00000000001, 3.30595716996, 52389.10537858640},
	{0.00000000001, 1.18548085609, 124778.18365871879},
	{0.00000000001, 4.58961379543, 12566.15169998280},
	{0.00000000001, 3.98103204416, 339142.74084046457},
	{0.00000000001, 2.22519315150, 52061.36699446317},
	{0.00000000001, 4.88662211480, 104881.30353139139},
	{0.00000000001, 2.53584920025, 38654.05484155699},
	{0.00000000001, 2.91594160501, 83925.04147387479},
	{0.00000000001, 2.43128064879, 77734.01845962799},
	{0.00000000001, 3.19056771528, 51962.50718771040},
	{0.00000000001, 6.12765391330, 66941.04532641819},
	{0.00000000001, 4.02441820677, 12432.04265039780},
	{0.00000000001, 2.42994719646, 52602.40447402440},
	{0.00000000001, 1.22454857023, 28206.66700195260},
	{0.00000000001, 4.83037329157, 129380.13377768178},
	{0.00000000001, 0.64473152248, 110012.94461544899},
	{0.00000000001, 2.99248190026, 7994.52844202420},
	{0.00000000001, 4.49658833907, 78267.59076008058},
	{0.00000000001, 4.71749238622, 64741.95798313119},
	{0.00000000001, 4.54522829555, 11322.66409830440},
	{0.00000000001, 5.58176968080, 78477.00852016058},
	{0, 0, 0}
};

struct vsop87_term mercury_z3[] = {
	{0.00000021392, 2.12804278460, 26087.90314157420},
	{0.00000017872, 0.00000000000, 0.00000000000},
	{0.00000002919, 5.41085836184, 52175.80628314840},
	{0.00000001164, 2.43324966912, 78263.70942472259},
	{0.00000000649, 5.91828820019, 104351.61256629678},
	{0.00000000338, 2.90727188863, 130439.51570787099},
	{0.00000000153, 6.06902785421, 156527.41884944518},
	{0.00000000063, 2.90040506590, 182615.32199101939},
	{0.00000000024, 5.99412433164, 208703.22513259358},
	{0.00000000009, 2.78985700920, 234791.12827416777},
	{0.00000000009, 3.85014410427, 27197.28169366760},
	{0.00000000007, 0.94845759850, 24978.52458948080},
	{0.00000000003, 5.85227323245, 260879.03141574195},
	{0.00000000001, 1.46066971079, 1109.37855209340},
	{0.00000000001, 5.63330817461, 51066.42773105500},
	{0.00000000001, 2.63664793392, 286966.93455731616},
	{0.00000000001, 3.12548288181, 77154.33087262919},
	{0.00000000001, 0.10273460254, 1059.38193018920},
	{0.00000000001, 5.38950202464, 20426.57109242200},
	{0.00000000001, 4.27644306777, 25132.30339996560},
	{0.00000000000, 1.26722844502, 1589.07289528380},
	{0.00000000001, 1.85750372421, 53285.18483524180},
	{0.00000000000, 1.48315414167, 27043.50288318280},
	{0.00000000000, 0.00510102644, 103242.23401420339},
	{0.00000000000, 0.26222106415, 31749.23519072640},
	{0.00000000000, 4.29763167864, 4551.95349705880},
	{0.00000000000, 1.62427828402, 21535.94964451540},
	{0.00000000000, 2.55626351718, 46514.47423399620},
	{0, 0, 0}
};

struct vsop87_term mercury_z4[] = {
	{0.00000000587, 4.86442699315, 26087.90314157420},
	{0.00000000283, 3.14159265359, 0.00000000000},
	{0.00000000055, 3.04082107246, 52175.80628314840},
	{0.00000000026, 0.53815113361, 78263.70942472259},
	{0.00000000015, 4.06065320707, 104351.61256629678},
	{0.00000000009, 1.14893791529, 130439.51570787099},
	{0.00000000005, 4.38565359175, 156527.41884944518},
	{0.00000000002, 1.25002341217, 182615.32199101939},
	{0.00000000001, 4.38192942162, 208703.22513259358},
	{0.00000000000, 1.16515085289, 234791.12827416777},
	{0, 0, 0}
};

struct vsop87_term mercury_z5[] = {
	{0.00000000004, 0.00000000000, 0.00000000000},
	{0.00000000002, 5.42849777894, 26087.90314157420},
	{0.00000000002, 1.19011087498, 52175.80628314840},
	{0.00000000001, 4.84147977903, 78263.70942472259},
	{0.00000000000, 2.14343331955, 104351.61256629678},
	{0.00000000000, 5.61950230485, 130439.51570787099},
	{0.00000000000, 2.76880495732, 156527.41884944518},
	{0, 0, 0}
};

struct vsop87_term venus_x0[] = {
	{0.72211281391, 3.17575836361, 10213.28554621100},
	{0.00486448018, 0.00000000000, 0.00000000000},
	{0.00244500474, 4.05566613861, 20426.57109242200},
	{0.00002800281, 0.33147492492, 2352.86615377180},
	{0.00001949669, 4.23196016801, 1577.34354244780},
	{0.00001241717, 4.93573787058, 30639.85663863300},
	{0.00001162258, 2.87958246189, 18073.70493865020},
	{0.00001046690, 1.75434920413, 6283.07584999140},
	{0.00000764293, 0.59379588767, 529.69096509460},
	{0.00000669461, 1.45721228842, 14143.49524243060},
	{0.00000657195, 0.50086450258, 8635.94200376320},
	{0.00000476445, 5.84309782840, 10186.98722641120},
	{0.00000474466, 3.64991163504, 10239.58386601080},
	{0.00000559074, 1.16554783301, 22003.91463486980},
	{0.00000546778, 2.71490884128, 11790.62908865880},
	{0.00000408988, 3.92725431993, 775.52261132400},
	{0.00000287059, 2.79578956958, 9683.59458111640},
	{0.00000268822, 0.42000307859, 10742.97651130560},
	{0.00000297742, 5.65655811166, 5507.55323866740},
	{0.00000214149, 0.74884072598, 10021.83728009940},
	{0.00000241103, 5.80627627098, 10988.80815753500},
	{0.00000209303, 2.47129919435, 10404.73381232260},
	{0.00000271022, 2.62377780320, 19896.88012732740},
	{0.00000254480, 5.09961413241, 9153.90361602180},
	{0.00000174985, 6.12704911391, 191.44826611160},
	{0.00000175040, 3.53163977560, 9437.76293488700},
	{0.00000122990, 1.58925439374, 1059.38193018920},
	{0.00000154379, 5.35607704390, 4705.73230754360},
	{0.00000147455, 5.55780022641, 19651.04848109800},
	{0.00000069504, 0.09284153982, 9103.90699411760},
	{0.00000082633, 4.14038372098, 15720.83878487840},
	{0.00000057905, 3.09112177798, 11322.66409830440},
	{0.00000058863, 3.05825416735, 20618.01935853360},
	{0.00000060672, 3.78380568336, 4551.95349705880},
	{0.00000046372, 0.52050501625, 10192.51015071860},
	{0.00000046247, 2.68940900983, 10234.06094170340},
	{0.00000062363, 2.59167610929, 25934.12433108940},
	{0.00000049846, 4.74559004636, 8624.21265092720},
	{0.00000057244, 0.64178511675, 3154.68708489560},
	{0.00000044352, 1.62905355389, 19367.18916223280},
	{0.00000040142, 3.21137282665, 9411.46461508720},
	{0.00000047629, 0.86806456392, 213.29909543800},
	{0.00000039831, 1.63910906528, 801.82093112380},
	{0.00000045105, 2.05062276794, 29580.47470844380},
	{0.00000036963, 4.39471796609, 7058.59846131540},
	{0.00000029387, 6.20012003310, 11015.10647733480},
	{0.00000031396, 5.70560306421, 15874.61759536320},
	{0.00000035988, 3.91661388674, 9999.98645077300},
	{0.00000027030, 1.82255608984, 1109.37855209340},
	{0.00000035335, 5.58257679416, 10426.58464164900},
	{0.00000024532, 5.47009748867, 7860.41939243920},
	{0.00000020348, 0.50298205801, 10206.17199921020},
	{0.00000020289, 2.70241661509, 10220.39909321180},
	{0.00000021702, 2.51229307210, 13367.97263110660},
	{0.00000023556, 4.96219726942, 21228.39202354580},
	{0.00000021314, 2.94962042107, 3128.38876509580},
	{0.00000018918, 5.32707832336, 26.29831979980},
	{0.00000018806, 2.03000092809, 7.11354700080},
	{0.00000020165, 3.03418313848, 3930.20969621960},
	{0.00000017623, 1.34615692033, 18837.49819713819},
	{0.00000015237, 4.38451593035, 9830.38901398780},
	{0.00000017193, 0.21214926890, 3532.06069281140},
	{0.00000014675, 5.12159442035, 10596.18207843420},
	{0.00000016092, 2.35712884119, 20213.27199698400},
	{0.00000014921, 4.07229277194, 29864.33402730900},
	{0.00000011103, 3.77017026259, 28286.99048486120},
	{0.00000012814, 2.04996476711, 1589.07289528380},
	{0.00000014633, 2.10306620243, 7084.89678111520},
	{0.00000012815, 3.81478671364, 17298.18232732620},
	{0.00000014040, 3.86381640402, 23581.25817731760},
	{0.00000009882, 5.05468665271, 21535.94964451540},
	{0.00000009391, 0.62349717207, 11272.66747640020},
	{0.00000012650, 4.58629724985, 9786.68735533500},
	{0.00000011612, 6.19596440423, 3340.61242669980},
	{0.00000010763, 1.23302426124, 9929.42622734580},
	{0.00000008934, 1.67849943453, 29050.78374334920},
	{0.00000010378, 1.97768668783, 10497.14486507620},
	{0.00000007498, 5.81621256989, 40853.14218484400},
	{0.00000007361, 0.80024676602, 16496.36139620240},
	{0.00000008792, 0.46879154923, 10207.76262190360},
	{0.00000008786, 2.74189609908, 10218.80847051840},
	{0.00000007423, 4.16147582473, 10175.25787357520},
	{0.00000007386, 5.33241731471, 10251.31321884680},
	{0.00000006656, 4.38046352226, 8094.52168583260},
	{0.00000006531, 1.17040611406, 20419.45754542119},
	{0.00000005871, 2.02826795819, 32217.20018108080},
	{0.00000007913, 3.46752863857, 12566.15169998280},
	{0.00000005864, 0.20073358491, 5661.33204915220},
	{0.00000005717, 2.30775630611, 24356.78078864160},
	{0.00000005958, 0.33507108266, 6681.22485339960},
	{0.00000005982, 2.16507598652, 426.59819087600},
	{0.00000007242, 0.18019941143, 25158.60171976540},
	{0.00000004940, 3.65883501045, 3149.16416058820},
	{0.00000005637, 2.38025391336, 382.89653222320},
	{0.00000004570, 2.63257803672, 14765.23904326980},
	{0.00000004689, 0.27530100709, 18849.22754997420},
	{0.00000005332, 4.44058586883, 26087.90314157420},
	{0.00000005081, 2.77574657924, 20452.86941222180},
	{0.00000005495, 3.29347843305, 17085.95866572220},
	{0.00000005436, 5.41859714400, 33794.54372352860},
	{0.00000003866, 2.86208012723, 13745.34623902240},
	{0.00000003943, 3.08912453167, 4732.03062734340},
	{0.00000003635, 0.35356507493, 1551.04522264800},
	{0.00000003772, 1.01689124687, 18307.80723204360},
	{0.00000004327, 3.40429598827, 23958.63178523340},
	{0.00000003885, 1.61513228322, 29088.81141598500},
	{0.00000002949, 2.82363129759, 10198.03307502600},
	{0.00000002944, 0.38707317908, 10228.53801739600},
	{0.00000003221, 0.43638422742, 20400.27277262220},
	{0.00000002493, 5.95440151056, 17277.40693183380},
	{0.00000002747, 1.78150237025, 5481.25491886760},
	{0.00000002549, 2.85980700621, 6872.67311951120},
	{0.00000002431, 3.85585401608, 30110.16567353840},
	{0.00000002294, 3.89566278246, 3442.57494496540},
	{0.00000002424, 0.96902079851, 20956.26205751660},
	{0.00000002742, 5.30280142666, 27511.46787353720},
	{0.00000002212, 5.16572775524, 14945.31617355440},
	{0.00000002649, 3.69610044860, 9580.50180689780},
	{0.00000002021, 1.06602786364, 19999.97290154599},
	{0.00000002372, 5.35791881546, 9573.38825989700},
	{0.00000002205, 3.60992396033, 536.80451209540},
	{0.00000002011, 0.56822837266, 21202.09370374600},
	{0.00000002471, 5.74724422420, 10846.06928552420},
	{0.00000001827, 3.06851083486, 7064.12138562280},
	{0.00000002188, 5.98208928052, 9967.45389998160},
	{0.00000001812, 4.00455436862, 22779.43724619380},
	{0.00000002278, 4.39189942690, 10110.19277199240},
	{0.00000002278, 5.10198662047, 10316.37832042960},
	{0.00000002104, 0.71768958427, 522.57741809380},
	{0.00000002118, 3.51159941917, 10459.11719244040},
	{0.00000001753, 0.39882451630, 13553.89797291080},
	{0.00000002246, 3.03979815042, 33019.02111220460},
	{0.00000002050, 4.25748513060, 9690.70812811720},
	{0.00000001832, 5.56224262077, 20809.46762464520},
	{0.00000001962, 5.23480186630, 10735.86296430480},
	{0.00000001484, 2.74088797191, 3723.50895892300},
	{0.00000002057, 0.56837576346, 37724.75341974820},
	{0.00000001987, 1.97150363851, 103.09277421860},
	{0.00000001659, 1.57309692340, 20235.12282631040},
	{0.00000001553, 4.88459995586, 9161.01716302260},
	{0.00000001873, 1.50261813839, 30213.25844775700},
	{0.00000001541, 4.02220022796, 6489.77658728800},
	{0.00000001360, 5.79998899684, 10232.95530711079},
	{0.00000001360, 3.69389705053, 10193.61578531121},
	{0.00000001592, 2.48951212353, 10288.06714477830},
	{0.00000001592, 0.72118861666, 10138.50394764370},
	{0.00000001271, 5.70934511266, 13936.79450513400},
	{0.00000001238, 3.79102501998, 20.77539549240},
	{0.00000001560, 0.36404331783, 9896.89367655440},
	{0.00000001560, 2.84665742236, 10529.67741586760},
	{0.00000001179, 6.00538975341, 14919.01785375460},
	{0.00000001466, 2.04239320632, 9146.79006902100},
	{0.00000001158, 3.85902457723, 10632.77019008620},
	{0.00000001259, 4.23560000055, 2379.16447357160},
	{0.00000001493, 1.40653635325, 22805.73556599360},
	{0.00000001402, 5.00430127066, 10639.88373708700},
	{0.00000001129, 5.77658236271, 9793.80090233580},
	{0.00000001342, 4.46625072671, 36949.23080842420},
	{0.00000000968, 1.59662059386, 639.89728631400},
	{0.00000001190, 4.52803152244, 39264.06928956020},
	{0.00000001013, 2.10885792626, 10419.47109464820},
	{0.00000001010, 1.09565332862, 10007.09999777380},
	{0.00000001226, 5.50768847726, 74.78159856730},
	{0.00000000996, 4.53849426210, 13341.67431130680},
	{0.00000001126, 1.83484274734, 245.83164622940},
	{0.00000000846, 0.63826672604, 18875.52586977400},
	{0.00000001139, 2.43229399782, 2118.76386037840},
	{0.00000000845, 6.08176877562, 9676.48103411560},
	{0.00000000760, 4.01810781408, 7564.83072073800},
	{0.00000000786, 2.08323238184, 11764.33076885900},
	{0.00000000795, 3.42432291896, 10750.09005830640},
	{0.00000000770, 0.68487491199, 7834.12107263940},
	{0.00000000698, 3.40358510787, 36147.40987730040},
	{0.00000000906, 0.29625818951, 31441.67756975680},
	{0.00000000787, 5.89002463165, 19889.76658032659},
	{0.00000000788, 0.18032696972, 7994.52844202420},
	{0.00000000624, 2.84767789659, 39793.76025465480},
	{0.00000000865, 1.99609335238, 41654.96311596780},
	{0.00000000744, 2.51526632902, 19903.99367432819},
	{0.00000000689, 4.60518059807, 1066.49547719000},
	{0.00000000823, 5.88974834586, 40879.44050464380},
	{0.00000000592, 0.65691971752, 17778.11626694899},
	{0.00000000770, 2.88484885613, 26735.94526221320},
	{0.00000000715, 5.24194846626, 16983.99614745660},
	{0.00000000569, 1.11632920377, 19786.67380610799},
	{0.00000000621, 1.17055028822, 52175.80628314840},
	{0.00000000548, 1.60570553727, 27197.28169366760},
	{0.00000000544, 3.16092493258, 110.20632121940},
	{0.00000000605, 4.63445753926, 10059.50673572620},
	{0.00000000552, 2.14941738098, 28521.09277825460},
	{0.00000000676, 5.20222552429, 20529.66386664059},
	{0.00000000593, 4.85950564308, 10367.06435669580},
	{0.00000000514, 5.06894525071, 8662.24032356300},
	{0.00000000661, 0.05527791273, 1162.47470440780},
	{0.00000000469, 5.48839305777, 8631.32619792800},
	{0.00000000454, 0.79241873074, 10042.61267559180},
	{0.00000000515, 2.92229144851, 12432.04265039780},
	{0.00000000444, 2.41828206903, 10383.95841683020},
	{0.00000000460, 0.69107495802, 11802.35844149480},
	{0.00000000436, 1.85693485685, 9638.94074787620},
	{0.00000000422, 1.39991487980, 10787.63034454580},
	{0.00000000416, 1.72605691131, 10225.01489904700},
	{0.00000000416, 1.48464382888, 10201.55619337500},
	{0.00000000431, 1.72994989473, 8617.09910392640},
	{0.00000000548, 5.68904924324, 8521.11987670860},
	{0.00000000381, 0.22534351229, 19317.19254032860},
	{0.00000000377, 5.67325483442, 149.56319713460},
	{0.00000000466, 5.23261301624, 6770.71060124560},
	{0.00000000444, 1.73410494666, 2218.75710418680},
	{0.00000000511, 1.02944887408, 44809.65020086340},
	{0.00000000363, 4.26514474189, 30831.30490474460},
	{0.00000000489, 4.26102629725, 30666.15495843280},
	{0.00000000354, 2.84306437211, 10323.49186743040},
	{0.00000000354, 0.36763636808, 10103.07922499160},
	{0.00000000427, 2.66965454095, 13655.86049117640},
	{0.00000000466, 5.30548072597, 38.13303563780},
	{0.00000000400, 0.98930698981, 1052.26838318840},
	{0.00000000359, 0.09178138960, 27490.69247804480},
	{0.00000000366, 3.21039535060, 283.85931886520},
	{0.00000000315, 0.01870495544, 20639.87018786000},
	{0.00000000364, 4.22573825928, 38734.37832446560},
	{0.00000000399, 4.24912842655, 10211.80107350270},
	{0.00000000399, 5.24475762082, 10214.77001891930},
	{0.00000000388, 2.28168065953, 29999.95935231900},
	{0.00000000398, 3.64836729223, 9835.91193829520},
	{0.00000000404, 3.98593080979, 20351.78949385470},
	{0.00000000385, 1.36867886553, 20180.73944619260},
	{0.00000000379, 5.84551887726, 10590.65915412680},
	{0.00000000300, 5.68088059375, 24150.08005134500},
	{0.00000000283, 5.59475061655, 26709.64694241340},
	{0.00000000390, 3.42415946376, 45585.17281218740},
	{0.00000000365, 1.42467845102, 10348.91087122100},
	{0.00000000365, 1.78602228917, 10077.66022120100},
	{0.00000000336, 0.74367409336, 220.41264243880},
	{0.00000000309, 5.67052430501, 6309.37416979120},
	{0.00000000283, 5.53469245500, 3903.91137641980},
	{0.00000000271, 3.85648668964, 9745.32055585660},
	{0.00000000327, 6.11774154244, 9360.08916445900},
	{0.00000000264, 5.16129358878, 76.26607127560},
	{0.00000000343, 3.92438566200, 206.18554843720},
	{0.00000000314, 1.40080599663, 20405.79569692960},
	{0.00000000306, 1.12587272451, 2957.71589447660},
	{0.00000000254, 5.63745223648, 10681.25053656540},
	{0.00000000343, 4.64296056111, 8106.25103866860},
	{0.00000000324, 3.98782911883, 31749.23519072640},
	{0.00000000234, 3.82015244739, 19624.75016129820},
	{0.00000000281, 0.78332222978, 9399.73526225120},
	{0.00000000322, 2.45576489589, 48739.85989708300},
	{0.00000000308, 0.46119280399, 37410.56723987860},
	{0.00000000230, 4.91404068561, 574.34479833480},
	{0.00000000228, 4.45814031952, 949.17560896980},
	{0.00000000295, 5.75145374701, 34596.36465465240},
	{0.00000000261, 5.54107777950, 632.78373931320},
	{0.00000000214, 0.59816494895, 12592.45001978260},
	{0.00000000233, 4.35078533465, 9264.10993724120},
	{0.00000000255, 4.03464641753, 9992.87290377220},
	{0.00000000255, 5.45923962984, 10433.69818864980},
	{0.00000000211, 0.18276464350, 10249.31341288840},
	{0.00000000211, 3.02793609669, 10177.25767953360},
	{0.00000000255, 2.42745817670, 11026.83583017080},
	{0.00000000288, 1.80083466219, 35371.88726597640},
	{0.00000000221, 0.56282855969, 38.02767263580},
	{0.00000000224, 4.78244233129, 19360.07561523199},
	{0.00000000247, 1.90808707769, 29587.58825544460},
	{0.00000000206, 3.37469119852, 30426.55754319500},
	{0.00000000263, 3.16130275876, 20433.68463942280},
	{0.00000000212, 3.16045353079, 10206.65698731099},
	{0.00000000212, 0.05024720940, 10219.91410511101},
	{0.00000000202, 0.82731831247, 16894.51039961060},
	{0.00000000272, 4.85092274037, 12320.32005375340},
	{0.00000000258, 5.22999934273, 29573.36116144300},
	{0.00000000211, 5.11529334983, 11162.46115518080},
	{0.00000000210, 5.15156975899, 22645.32819660879},
	{0.00000000267, 4.30118423273, 377.37360791580},
	{0.00000000186, 4.53704574212, 10251.41858184880},
	{0.00000000186, 4.95684030525, 10175.15251057320},
	{0.00000000258, 2.52339488384, 9864.36112576300},
	{0.00000000186, 4.87586761272, 17271.88400752640},
	{0.00000000254, 3.15931084747, 19264.09638801420},
	{0.00000000240, 1.30869138812, 16522.65971600220},
	{0.00000000246, 0.68740438301, 10562.20996665900},
	{0.00000000211, 6.16254771086, 11375.76025061880},
	{0.00000000178, 0.50910605505, 10949.16205974280},
	{0.00000000178, 2.70159468514, 9477.40903267920},
	{0.00000000197, 0.96052683602, 1692.16566950240},
	{0.00000000174, 4.78535633940, 40077.61957352000},
	{0.00000000177, 0.12290786955, 20316.36477120259},
	{0.00000000173, 1.33272334806, 8734.41897214660},
	{0.00000000196, 4.69372863801, 9779.57380833420},
	{0.00000000198, 3.27402275626, 27991.40181316000},
	{0.00000000154, 0.72358681867, 10199.05845220940},
	{0.00000000154, 2.48711392152, 10227.51264021260},
	{0.00000000189, 0.66769513206, 9256.99639024040},
	{0.00000000193, 2.39642315228, 17468.85519794540},
	{0.00000000205, 3.90575045563, 52670.06959330260},
	{0.00000000172, 1.89149575452, 14.22709400160},
	{0.00000000166, 3.75162140471, 10263.04257168280},
	{0.00000000166, 5.74226464266, 10163.52852073920},
	{0.00000000168, 5.33584294691, 7991.42891161400},
	{0.00000000194, 0.90820651456, 38526.57435087200},
	{0.00000000196, 4.87499369677, 49515.38250840700},
	{0.00000000196, 3.44370650262, 846.08283475120},
	{0.00000000169, 5.71918201676, 11265.55392939940},
	{0.00000000194, 2.26711785239, 8837.51174636520},
	{0.00000000140, 0.33029139370, 10191.43471688460},
	{0.00000000140, 2.88040934649, 10235.13637553740},
	{0.00000000196, 2.27333422690, 1293.48422358260},
	{0.00000000162, 5.59199233193, 7255.56965173440},
	{0.00000000138, 0.38495137130, 10217.21769947410},
	{0.00000000138, 2.82574936889, 10209.35339294790},
	{0.00000000149, 2.28858934145, 19374.30270923360},
	{0.00000000143, 1.40332876782, 20447.34648791440},
	{0.00000000126, 3.82073811345, 20277.00789528740},
	{0.00000000162, 1.69374604806, 10063.72234907640},
	{0.00000000149, 2.18564631641, 10135.61177578300},
	{0.00000000149, 1.02505442378, 10290.95931663900},
	{0.00000000117, 0.93777977092, 1581.95934828300},
	{0.00000000151, 0.84241735172, 10245.81809700240},
	{0.00000000151, 2.36828338847, 10180.75299541960},
	{0.00000000152, 4.60730376543, 18830.38465013739},
	{0.00000000144, 3.98382443588, 24383.07910844140},
	{0.00000000114, 4.16184056386, 32858.61374281979},
	{0.00000000144, 3.82694942167, 9985.80941342200},
	{0.00000000144, 5.66693662570, 10440.76167900000},
	{0.00000000143, 1.56048542507, 18844.61174413899},
	{0.00000000130, 5.57171941495, 10236.06074766180},
	{0.00000000130, 3.92216663242, 10190.51034476020},
	{0.00000000156, 4.19081128787, 20388.43805678420},
	{0.00000000155, 0.85940335797, 8237.79300035500},
	{0.00000000131, 5.39530111218, 8101.63523283340},
	{0.00000000111, 2.93356769076, 43071.89928903080},
	{0.00000000099, 4.32745781002, 24978.52458948080},
	{0.00000000101, 5.26437713251, 20043.67456019880},
	{0.00000000113, 4.29323425653, 3.93215326310},
	{0.00000000132, 5.33260115213, 56600.27928952220},
	{0.00000000136, 6.07742370370, 5999.21653112620},
	{0.00000000127, 2.33491999261, 42456.78404709160},
	{0.00000000097, 0.92060560081, 853.19638175200},
	{0.00000000131, 3.21869975863, 4176.04134244900},
	{0.00000000106, 1.57523662131, 19573.37471066999},
	{0.00000000112, 2.47056814408, 20206.15844998319},
	{0.00000000093, 0.23284844018, 8204.72800705200},
	{0.00000000098, 3.12531862236, 11059.36838096220},
	{0.00000000090, 2.40621950932, 29057.89729034999},
	{0.00000000103, 5.15240336003, 10244.19967184600},
	{0.00000000103, 4.34148268734, 10182.37142057600},
	{0.00000000125, 2.35130047125, 12188.77809206700},
	{0.00000000095, 4.18811631729, 78263.70942472259},
	{0.00000000088, 4.33292988106, 20350.30502114640},
	{0.00000000105, 3.96512076229, 19793.78735310880},
	{0.00000000122, 5.43246799719, 2636.72547263700},
	{0.00000000095, 3.90711906214, 2333.19639287200},
	{0.00000000087, 1.36045970674, 8087.40813883180},
	{0.00000000086, 3.64749231964, 7035.13975564340},
	{0.00000000095, 2.03086124785, 10202.23984594710},
	{0.00000000095, 1.17983949234, 10224.33124647490},
	{0.00000000084, 1.22799614537, 10401.21069397360},
	{0.00000000084, 1.98270459482, 10025.36039844840},
	{0.00000000085, 5.03727591626, 19477.39548345219},
	{0.00000000099, 2.80246425084, 2648.45482547300},
	{0.00000000087, 4.97431232996, 29043.67019634839},
	{0.00000000082, 6.17390445678, 44007.82926973960},
	{0.00000000093, 4.35602536763, 5.52292430740},
	{0.00000000098, 5.37191506696, 20220.38554398480},
	{0.00000000100, 5.07106883209, 1596.18644228460},
	{0.00000000095, 3.35136515938, 29477.38193422520},
	{0.00000000096, 1.62154996582, 30206.14490075619},
	{0.00000000095, 4.51772320117, 30220.37199475780},
	{0.00000000089, 3.13112055622, 29786.66025688100},
	{0.00000000107, 4.65459265447, 2069.00683490660},
	{0.00000000100, 4.44047000599, 38500.27603107220},
	{0.00000000077, 3.58586905737, 10853.18283252500},
	{0.00000000076, 4.87466102622, 10243.10698435980},
	{0.00000000076, 4.61922502115, 10183.46410806220},
	{0.00000000101, 0.03242064905, 53445.59220462660},
	{0.00000000086, 2.29756841695, 18734.40542291960},
	{0.00000000076, 6.08479538571, 956.28915597060},
	{0.00000000100, 2.64031933351, 28947.69096913060},
	{0.00000000073, 1.68280932827, 21000.91589075680},
	{0.00000000073, 0.32333160897, 17248.42530185440},
	{0.00000000094, 5.44157645789, 28313.28880466100},
	{0.00000000085, 5.27335453034, 3914.95722503460},
	{0.00000000074, 1.92420739215, 8827.39026987480},
	{0.00000000070, 1.49155244201, 6298.32832117640},
	{0.00000000069, 2.29681555948, 34570.06633485260},
	{0.00000000071, 3.95871098581, 34171.91733144440},
	{0.00000000079, 2.65919074354, 10018.31416175040},
	{0.00000000079, 0.55150999665, 10408.25693067160},
	{0.00000000080, 2.11794073365, 14128.24277124560},
	{0.00000000087, 3.78428652532, 46386.99374331120},
	{0.00000000069, 0.90460126437, 41044.59045095560},
	{0.00000000069, 2.25427054035, 9644.46367218360},
	{0.00000000069, 0.95643019984, 10782.10742023840},
	{0.00000000083, 5.79338403589, 9721.62225375220},
	{0.00000000083, 3.70050201148, 10704.94883866980},
	{0.00000000090, 5.18770728347, 20049.19748450620},
	{0.00000000076, 1.05201678798, 21485.95302261119},
	{0.00000000064, 1.61066481633, 18314.92077904440},
	{0.00000000071, 6.14408943769, 1573.82042409880},
	{0.00000000071, 5.46198489134, 1580.86666079680},
	{0.00000000067, 0.48620096430, 3956.50801601940},
	{0.00000000085, 0.47649339021, 60530.48898574180},
	{0.00000000087, 5.47908592763, 29264.08283878720},
	{0.00000000060, 1.34871003737, 20421.04816811460},
	{0.00000000064, 4.29919445052, 18300.69368504279},
	{0.00000000076, 3.93987139141, 29683.56748266239},
	{0.00000000062, 1.28649389372, 11599.18082254720},
	{0.00000000058, 3.08212047215, 7576.56007357400},
	{0.00000000057, 3.67915137516, 11279.78102340100},
	{0.00000000066, 3.67579379885, 18100.00325845000},
	{0.00000000059, 1.26040809465, 10254.83633719580},
	{0.00000000059, 1.95029264554, 10171.73475522620},
	{0.00000000057, 4.06263183264, 20464.59876505780},
	{0.00000000079, 1.97795760115, 10137.01947493540},
	{0.00000000064, 5.57155754500, 30007.07289931980},
	{0.00000000058, 3.05734136153, 75449.50683949639},
	{0.00000000073, 3.85067893410, 51449.32426327820},
	{0.00000000074, 5.48466882213, 21720.05531600460},
	{0.00000000072, 3.24619558125, 39302.09696219600},
	{0.00000000072, 4.47140920987, 100608.10855926179},
	{0.00000000070, 5.15360777942, 50317.20343953080},
	{0.00000000052, 2.09263469212, 40426.54399396800},
	{0.00000000058, 1.31187367842, 20412.34399842039},
	{0.00000000055, 5.75623323744, 1478.86657406440},
	{0.00000000057, 1.89761311531, 8307.82078127060},
	{0.00000000065, 1.67946533112, 53285.18483524180},
	{0.00000000050, 4.69707035274, 8418.02710249000},
	{0.00000000066, 6.05166710265, 19580.48825767080},
	{0.00000000047, 4.81853147221, 38741.49187146640},
	{0.00000000050, 1.33990099082, 59160.94941688760},
	{0.00000000056, 3.53833578370, 34363.36559755600},
	{0.00000000054, 0.68665384144, 48947.66387067660},
	{0.00000000045, 4.21526527082, 194.97138446060},
	{0.00000000056, 1.07866938616, 9936.53977434660},
	{0.00000000056, 2.13203135403, 10490.03131807540},
	{0.00000000054, 4.49664827025, 9922.31268034500},
	{0.00000000054, 4.99723777712, 10504.25841207700},
	{0.00000000060, 2.00609002833, 18204.71445782499},
	{0.00000000048, 1.22735240928, 38727.26477746480},
	{0.00000000044, 5.84040951995, 38204.68735937100},
	{0.00000000061, 5.98664723657, 10139.98842035200},
	{0.00000000061, 3.50723881080, 10286.58267207000},
	{0.00000000061, 0.57175309158, 6566.93516885660},
	{0.00000000060, 2.76944336702, 3684.37804999020},
	{0.00000000048, 3.35196570960, 9246.31466877540},
	{0.00000000049, 2.38104573869, 47623.85278608960},
	{0.00000000060, 3.41701626624, 14427.35456129580},
	{0.00000000051, 5.43117183762, 9566.27471289620},
	{0.00000000052, 0.06129028276, 8727.30542514580},
	{0.00000000048, 2.05391369918, 433.71173787680},
	{0.00000000045, 5.52086086974, 10263.28216811520},
	{0.00000000045, 3.97302517763, 10163.28892430680},
	{0.00000000049, 1.65627933457, 9794.36114731040},
	{0.00000000049, 1.55442140562, 10632.20994511160},
	{0.00000000054, 1.47632908603, 57375.80190084620},
	{0.00000000058, 6.19295972616, 1861.20286131300},
	{0.00000000047, 1.50917280490, 20142.71177355680},
	{0.00000000056, 1.90382257572, 64460.69868196140},
	{0.00000000042, 2.81747931977, 25132.30339996560},
	{0.00000000046, 5.38584594180, 2349.34303542280},
	{0.00000000046, 4.70373951682, 2356.38927212080},
	{0.00000000044, 2.04804189558, 30632.74309163219},
	{0.00000000044, 3.19618376464, 27461.71084806540},
	{0.00000000041, 0.12857964444, 12850.01101884800},
	{0.00000000042, 5.08305246551, 77802.37299326819},
	{0.00000000050, 3.02284234315, 36301.18868778519},
	{0.00000000044, 0.04275677189, 9367.20271145980},
	{0.00000000044, 4.46864162759, 79379.71653571600},
	{0.00000000054, 4.54758275119, 66038.04222440919},
	{0.00000000040, 1.16488473080, 31022.75317085620},
	{0.00000000052, 2.92722662671, 90394.82301305079},
	{0.00000000040, 0.23497278107, 38519.94579197200},
	{0.00000000039, 3.44427209717, 28631.29909947399},
	{0.00000000052, 5.20963747195, 38631.28555024700},
	{0.00000000043, 6.14192019965, 11180.25642364660},
	{0.00000000038, 1.29716058654, 47938.03896595920},
	{0.00000000039, 1.02482380212, 1265.56747862640},
	{0.00000000052, 1.99634485152, 1.48447270830},
	{0.00000000039, 0.47445767706, 54981.38495608960},
	{0.00000000044, 1.17091466926, 10168.14432657440},
	{0.00000000044, 2.03978607093, 10258.42676584760},
	{0.00000000047, 4.89732365161, 187.92514776260},
	{0.00000000043, 5.12210246822, 22030.21295466960},
	{0.00000000051, 5.89313829453, 104538.31825548140},
	{0.00000000051, 6.27593798552, 16250.52974997300},
	{0.00000000037, 4.48691474448, 29160.99006456860},
	{0.00000000043, 4.92338640427, 10362.84874334560},
	{0.00000000038, 4.13589617678, 47917.26357046680},
	{0.00000000037, 4.41298184434, 6256.77753019160},
	{0.00000000036, 2.97028388691, 8673.96967639900},
	{0.00000000049, 1.96336022300, 491.66329245880},
	{0.00000000035, 4.23887120976, 55798.45835839840},
	{0.00000000035, 2.75316618128, 12546.48193908300},
	{0.00000000049, 0.68713949784, 32243.49850088060},
	{0.00000000035, 1.54030603995, 80482.46652890938},
	{0.00000000044, 4.30648713686, 9697.82167511800},
	{0.00000000044, 5.18739891051, 10728.74941730400},
	{0.00000000036, 2.23669262946, 69941.95360082899},
	{0.00000000037, 3.25220014102, 35191.81013569180},
	{0.00000000040, 2.23416725118, 28418.00000403600},
	{0.00000000035, 4.79214932619, 10011.03215103690},
	{0.00000000035, 4.70173672118, 10415.53894138510},
	{0.00000000034, 5.41644307615, 48733.23133818299},
	{0.00000000033, 5.38015255564, 49477.35483577119},
	{0.00000000033, 3.74889730790, 10117.30631899320},
	{0.00000000033, 5.74498873947, 10309.26477342880},
	{0.00000000034, 4.93633143876, 7461.73794651940},
	{0.00000000032, 4.82073066675, 100909.03762133139},
	{0.00000000042, 2.02575996826, 36173.70819710020},
	{0.00000000038, 2.89788933077, 115674.27666460119},
	{0.00000000031, 3.44788323640, 30103.05212653759},
	{0.00000000039, 2.73013808773, 316.39186965660},
	{0.00000000032, 3.76438941047, 21977.61631507000},
	{0.00000000036, 1.22867623820, 20430.50324568509},
	{0.00000000031, 1.46724432126, 50290.90511973100},
	{0.00000000032, 0.22257491587, 81732.58268948780},
	{0.00000000042, 2.48755696559, 14169.79356223040},
	{0.00000000034, 4.16441980838, 58946.51688439399},
	{0.00000000030, 2.52685372964, 419.48464387520},
	{0.00000000030, 0.22687369463, 51640.77252938980},
	{0.00000000031, 2.49011566919, 11.04570026390},
	{0.00000000033, 5.88115236046, 83309.92623193559},
	{0.00000000029, 0.24041707519, 11752.60141602300},
	{0.00000000029, 5.51688017902, 9800.91444933660},
	{0.00000000029, 3.97700586835, 10625.65664308540},
	{0.00000000030, 3.62180540908, 20432.09401672940},
	{0.00000000029, 4.40925784627, 9889.78012955360},
	{0.00000000029, 1.77614141850, 224.34479570190},
	{0.00000000039, 5.97000692581, 69968.25192062880},
	{0.00000000028, 0.27335698936, 10098.84625752579},
	{0.00000000028, 2.93734375083, 10327.72483489621},
	{0.00000000031, 3.65358279415, 63498.47038145279},
	{0.00000000034, 4.23088120025, 1539.31586981200},
	{0.00000000028, 5.43510977873, 1179.19453903960},
	{0.00000000039, 5.18936615352, 30563.59056735740},
	{0.00000000039, 1.33255333737, 5791.41255753260},
	{0.00000000037, 0.01420012860, 47964.33728575900},
	{0.00000000034, 3.47970683246, 37703.97802425580},
	{0.00000000031, 5.46651444566, 39786.64670765400},
	{0.00000000028, 3.65950618561, 73872.16329704860},
	{0.00000000028, 1.94950811352, 28528.20632525540},
	{0.00000000037, 3.33141664712, 68390.90837818099},
	{0.00000000028, 0.41915165036, 15694.54046507860},
	{0.00000000034, 3.67871414535, 40213.24489853000},
	{0.00000000031, 4.76909835895, 106570.36967048359},
	{0.00000000031, 0.95396015997, 27682.14074415640},
	{0.00000000037, 2.63889593800, 13859.63592356540},
	{0.00000000028, 1.92419873752, 7886.71771223900},
	{0, 0, 0}
};

struct vsop87_term venus_x1[] = {
	{0.00033862636, 3.14159265359, 0.00000000000},
	{0.00017234992, 0.92721124604, 20426.57109242200},
	{0.00006510416, 2.19289889733, 10213.28554621100},
	{0.00000175153, 1.80662375856, 30639.85663863300},
	{0.00000060308, 4.92818504243, 8635.94200376320},
	{0.00000062875, 2.09139376733, 10186.98722641120},
	{0.00000062673, 1.11931770829, 10239.58386601080},
	{0.00000049288, 4.57672399872, 11790.62908865880},
	{0.00000036778, 2.06851242251, 775.52261132400},
	{0.00000030106, 5.32720335267, 10021.83728009940},
	{0.00000029274, 4.16540644255, 10404.73381232260},
	{0.00000019967, 1.16604774963, 9437.76293488700},
	{0.00000017823, 2.07836542600, 10988.80815753500},
	{0.00000013944, 3.69080302800, 9683.59458111640},
	{0.00000013302, 1.34684482109, 191.44826611160},
	{0.00000013514, 5.77326513156, 10742.97651130560},
	{0.00000014023, 3.49827896956, 4705.73230754360},
	{0.00000013305, 1.15252179423, 19651.04848109800},
	{0.00000006878, 4.83643789894, 9103.90699411760},
	{0.00000007518, 5.57355256300, 1059.38193018920},
	{0.00000007314, 6.00715030461, 15720.83878487840},
	{0.00000005893, 4.65079788415, 11322.66409830440},
	{0.00000005966, 2.10338851243, 10206.17199921020},
	{0.00000005966, 1.10731222776, 10220.39909321180},
	{0.00000005146, 2.49797078266, 3154.68708489560},
	{0.00000004570, 4.59128591402, 20618.01935853360},
	{0.00000004253, 6.04441888042, 9999.98645077300},
	{0.00000004157, 3.43980473612, 10426.58464164900},
	{0.00000004649, 2.86570782502, 9830.38901398780},
	{0.00000004457, 0.35149067415, 10596.18207843420},
	{0.00000003831, 0.32591122929, 7.11354700080},
	{0.00000003220, 2.31596557655, 7860.41939243920},
	{0.00000002790, 3.91140503058, 19367.18916223280},
	{0.00000002701, 0.65622385382, 7058.59846131540},
	{0.00000002426, 5.63707111420, 8624.21265092720},
	{0.00000002228, 3.80476415463, 11015.10647733480},
	{0.00000002742, 4.97112619529, 801.82093112380},
	{0.00000002539, 5.96953643859, 9411.46461508720},
	{0.00000001733, 3.35882285196, 1109.37855209340},
	{0.00000001820, 2.53309413889, 13367.97263110660},
	{0.00000001586, 2.69305924778, 40853.14218484400},
	{0.00000002007, 2.52717557705, 26.29831979980},
	{0.00000001740, 2.26366858618, 4551.95349705880},
	{0.00000001695, 4.86384593057, 3930.20969621960},
	{0.00000001491, 0.63663352937, 12566.15169998280},
	{0.00000001400, 6.24739539057, 11272.66747640020},
	{0.00000001282, 4.66310117053, 10218.80847051840},
	{0.00000001282, 4.83078487684, 10207.76262190360},
	{0.00000001424, 3.84877764517, 7084.89678111520},
	{0.00000001480, 5.68175195919, 3128.38876509580},
	{0.00000001352, 2.86394052328, 20419.45754542119},
	{0.00000001331, 5.67740813364, 23581.25817731760},
	{0.00000001165, 1.86912148528, 1577.34354244780},
	{0.00000001217, 3.13914848069, 9153.90361602180},
	{0.00000001283, 3.88489184697, 382.89653222320},
	{0.00000001084, 4.35524384671, 10198.03307502600},
	{0.00000001084, 5.13864220066, 10228.53801739600},
	{0.00000000935, 2.69155510108, 2352.86615377180},
	{0.00000001204, 4.96311045584, 16496.36139620240},
	{0.00000001110, 0.28360276400, 1589.07289528380},
	{0.00000000927, 0.95159471682, 15874.61759536320},
	{0.00000000745, 2.15244210116, 3149.16416058820},
	{0.00000000727, 0.71047310572, 28286.99048486120},
	{0.00000000800, 5.11147158475, 426.59819087600},
	{0.00000000629, 4.09794953076, 6283.07584999140},
	{0.00000000625, 3.18531726606, 20400.27277262220},
	{0.00000000613, 0.22192928894, 21535.94964451540},
	{0.00000000844, 1.91525540918, 21228.39202354580},
	{0.00000000647, 1.91404418261, 536.80451209540},
	{0.00000000673, 5.27601179416, 8094.52168583260},
	{0.00000000635, 0.24814486022, 18849.22754997420},
	{0.00000000659, 3.85074823650, 17298.18232732620},
	{0.00000000558, 2.17212279619, 5661.33204915220},
	{0.00000000617, 2.40257223116, 522.57741809380},
	{0.00000000504, 0.50752256282, 20452.86941222180},
	{0.00000000471, 5.08849959119, 32217.20018108080},
	{0.00000000569, 2.27089991313, 529.69096509460},
	{0.00000000449, 3.23050669378, 9161.01716302260},
	{0.00000000406, 5.47199309176, 24356.78078864160},
	{0.00000000421, 2.57695843451, 29050.78374334920},
	{0.00000000416, 4.91711862645, 6681.22485339960},
	{0.00000000433, 3.74326536161, 9146.79006902100},
	{0.00000000432, 0.83861429466, 20809.46762464520},
	{0.00000000368, 0.50948592294, 9786.68735533500},
	{0.00000000364, 2.71580018519, 10639.88373708700},
	{0.00000000440, 0.73691128332, 10735.86296430480},
	{0.00000000442, 2.47960767723, 9690.70812811720},
	{0.00000000372, 0.50265145827, 10251.31321884680},
	{0.00000000372, 2.70804928192, 10175.25787357520},
	{0.00000000417, 5.95567969898, 22003.91463486980},
	{0.00000000319, 1.05799141125, 17277.40693183380},
	{0.00000000430, 2.94467829658, 18837.49819713819},
	{0.00000000305, 1.07705608500, 14765.23904326980},
	{0.00000000299, 1.17049327210, 9573.38825989700},
	{0.00000000351, 2.50782509682, 6489.77658728800},
	{0.00000000297, 1.06831804424, 10232.95530711079},
	{0.00000000297, 2.14238269595, 10193.61578531121},
	{0.00000000283, 1.43375599031, 9676.48103411560},
	{0.00000000282, 2.35469083120, 3442.57494496540},
	{0.00000000262, 3.22424298845, 21202.09370374600},
	{0.00000000280, 4.54909343150, 13745.34623902240},
	{0.00000000303, 0.76647154703, 27511.46787353720},
	{0.00000000265, 5.63411986393, 22779.43724619380},
	{0.00000000289, 5.78612488740, 20235.12282631040},
	{0.00000000280, 5.08975182162, 14919.01785375460},
	{0.00000000262, 1.80492967584, 10750.09005830640},
	{0.00000000256, 4.41502652709, 10234.06094170340},
	{0.00000000256, 5.07885952028, 10192.51015071860},
	{0.00000000281, 6.24023878472, 4732.03062734340},
	{0.00000000273, 4.38798616028, 19999.97290154599},
	{0.00000000231, 4.24584068448, 3723.50895892300},
	{0.00000000285, 5.52678721077, 20956.26205751660},
	{0.00000000248, 0.80860047227, 13936.79450513400},
	{0.00000000303, 0.16166252665, 14945.31617355440},
	{0.00000000229, 2.00393082027, 18307.80723204360},
	{0.00000000232, 1.29928665498, 19889.76658032659},
	{0.00000000199, 0.33116594460, 9638.94074787620},
	{0.00000000218, 0.81835340957, 19903.99367432819},
	{0.00000000236, 3.29779198483, 1551.04522264800},
	{0.00000000182, 4.19683782346, 6872.67311951120},
	{0.00000000179, 0.13299783559, 30110.16567353840},
	{0.00000000183, 2.86361582264, 10787.63034454580},
	{0.00000000235, 2.81697648619, 1066.49547719000},
	{0.00000000208, 5.61842788521, 10007.09999777380},
	{0.00000000208, 3.87545816216, 10419.47109464820},
	{0.00000000184, 1.66108291395, 9967.45389998160},
	{0.00000000157, 4.86147676477, 5507.55323866740},
	{0.00000000163, 4.95974146969, 10225.01489904700},
	{0.00000000163, 4.53414457768, 10201.55619337500},
	{0.00000000156, 6.06699266861, 10316.37832042960},
	{0.00000000156, 3.42689337876, 10110.19277199240},
	{0.00000000178, 1.54946213545, 10459.11719244040},
	{0.00000000163, 3.33666234638, 8617.09910392640},
	{0.00000000157, 5.15568499427, 13553.89797291080},
	{0.00000000152, 5.19090463479, 639.89728631400},
	{0.00000000153, 4.56991285435, 7064.12138562280},
	{0.00000000140, 3.74168278014, 8631.32619792800},
	{0.00000000162, 1.41066050496, 18875.52586977400},
	{0.00000000177, 4.60803620012, 5481.25491886760},
	{0.00000000128, 5.46982761491, 10632.77019008620},
	{0.00000000154, 0.98203597063, 2118.76386037840},
	{0.00000000122, 3.52963783211, 22805.73556599360},
	{0.00000000131, 2.25810592292, 31441.67756975680},
	{0.00000000151, 2.51506129756, 29864.33402730900},
	{0.00000000143, 4.89084173973, 7994.52844202420},
	{0.00000000128, 4.83324965266, 14143.49524243060},
	{0.00000000119, 2.18817672539, 28521.09277825460},
	{0.00000000126, 4.45567569879, 9793.80090233580},
	{0.00000000133, 4.66569043351, 12432.04265039780},
	{0.00000000099, 2.30761648841, 20.77539549240},
	{0.00000000104, 6.17531547106, 36147.40987730040},
	{0.00000000101, 3.14541381584, 1052.26838318840},
	{0.00000000093, 0.14711850987, 574.34479833480},
	{0.00000000129, 4.90463216286, 7564.83072073800},
	{0.00000000092, 1.92693800199, 9360.08916445900},
	{0.00000000105, 0.69367524807, 16983.99614745660},
	{0.00000000095, 3.66782801204, 10433.69818864980},
	{0.00000000095, 5.82605803532, 9992.87290377220},
	{0.00000000096, 5.33118576681, 220.41264243880},
	{0.00000000081, 0.17273168667, 19896.88012732740},
	{0.00000000110, 0.30263518591, 11802.35844149480},
	{0.00000000108, 5.13400660338, 29580.47470844380},
	{0.00000000093, 5.89270070063, 2957.71589447660},
	{0.00000000094, 1.47978763830, 20433.68463942280},
	{0.00000000084, 3.01528050439, 25158.60171976540},
	{0.00000000092, 5.73596317172, 206.18554843720},
	{0.00000000077, 4.50520624769, 10177.25767953360},
	{0.00000000077, 4.98867979968, 10249.31341288840},
	{0.00000000088, 1.15956894470, 2379.16447357160},
	{0.00000000076, 2.94238842779, 213.29909543800},
	{0.00000000071, 1.17266418386, 24150.08005134500},
	{0.00000000071, 0.26608127921, 29043.67019634839},
	{0.00000000091, 0.45051499731, 19360.07561523199},
	{0.00000000068, 3.96046123295, 10383.95841683020},
	{0.00000000068, 5.53342481442, 10042.61267559180},
	{0.00000000077, 0.65927841966, 29573.36116144300},
	{0.00000000069, 4.86964064866, 26735.94526221320},
	{0.00000000073, 0.21800067624, 29587.58825544460},
	{0.00000000065, 5.46497273946, 39302.09696219600},
	{0.00000000066, 3.87839547247, 3532.06069281140},
	{0.00000000061, 0.66096812913, 29057.89729034999},
	{0.00000000081, 4.74585575332, 11764.33076885900},
	{0.00000000067, 1.15918883443, 40077.61957352000},
	{0.00000000077, 0.71010883429, 20213.27199698400},
	{0.00000000077, 3.31402395838, 7834.12107263940},
	{0.00000000067, 1.57099488677, 17778.11626694899},
	{0.00000000057, 1.40415259234, 110.20632121940},
	{0.00000000060, 6.21424049877, 30831.30490474460},
	{0.00000000055, 1.10439423420, 6770.71060124560},
	{0.00000000054, 4.90109549879, 19317.19254032860},
	{0.00000000055, 1.55888979134, 27490.69247804480},
	{0.00000000060, 0.10100099885, 9779.57380833420},
	{0.00000000059, 3.60960317836, 35371.88726597640},
	{0.00000000050, 1.75539922827, 10103.07922499160},
	{0.00000000050, 1.45530151192, 10323.49186743040},
	{0.00000000050, 6.20989838059, 39793.76025465480},
	{0.00000000052, 0.61784659161, 26709.64694241340},
	{0.00000000050, 3.88430063812, 16522.65971600220},
	{0.00000000048, 3.03978445690, 27197.28169366760},
	{0.00000000047, 3.62423252693, 20639.87018786000},
	{0.00000000046, 4.31718940500, 19786.67380610799},
	{0.00000000045, 4.37583121590, 29999.95935231900},
	{0.00000000047, 2.61829720304, 57837.13833230060},
	{0.00000000045, 0.64539022706, 43232.30665841560},
	{0.00000000055, 3.28045715106, 2218.75710418680},
	{0.00000000043, 5.13872092014, 29786.66025688100},
	{0.00000000046, 4.36312032216, 29088.81141598500},
	{0.00000000051, 2.50513032627, 44007.82926973960},
	{0.00000000045, 0.02215975970, 30666.15495843280},
	{0.00000000056, 3.87309891223, 17468.85519794540},
	{0.00000000054, 0.93200345594, 25934.12433108940},
	{0.00000000051, 1.29476626427, 13341.67431130680},
	{0.00000000051, 1.12825933915, 13655.86049117640},
	{0.00000000039, 5.77845089286, 20447.34648791440},
	{0.00000000038, 3.46632011895, 21000.91589075680},
	{0.00000000038, 5.73479924178, 33019.02111220460},
	{0.00000000042, 0.50159500441, 3914.95722503460},
	{0.00000000042, 4.77757016347, 38204.68735937100},
	{0.00000000041, 0.07265138638, 18830.38465013739},
	{0.00000000036, 5.95301096335, 10077.66022120100},
	{0.00000000036, 3.54087508402, 10348.91087122100},
	{0.00000000047, 6.22385797527, 8662.24032356300},
	{0.00000000040, 5.87480727345, 18844.61174413899},
	{0.00000000040, 3.88666957401, 47938.03896595920},
	{0.00000000036, 1.01249884206, 33794.54372352860},
	{0.00000000032, 5.49940747482, 16894.51039961060},
	{0.00000000034, 0.08271536061, 19374.30270923360},
	{0.00000000032, 1.98563978946, 47162.51635463520},
	{0.00000000042, 0.37006972783, 55798.45835839840},
	{0.00000000031, 3.51648880247, 20043.67456019880},
	{0.00000000033, 1.44340083609, 48417.97290558199},
	{0.00000000034, 5.27191255343, 54247.41313575040},
	{0.00000000032, 2.12080485438, 10191.43471688460},
	{0.00000000032, 1.08989588582, 10235.13637553740},
	{0.00000000038, 0.78775617354, 7255.56965173440},
	{0.00000000031, 2.88646250826, 8087.40813883180},
	{0.00000000030, 1.96661961760, 10853.18283252500},
	{0.00000000030, 0.79959461257, 36949.23080842420},
	{0.00000000033, 1.13583992722, 12592.45001978260},
	{0.00000000029, 5.21162982204, 10290.95931663900},
	{0.00000000029, 4.28225622533, 10135.61177578300},
	{0.00000000028, 5.74069736147, 104351.61256629678},
	{0.00000000032, 4.16582591800, 20206.15844998319},
	{0.00000000029, 1.47368482939, 34596.36465465240},
	{0.00000000032, 5.37255836333, 9835.91193829520},
	{0.00000000032, 4.12132768404, 10590.65915412680},
	{0.00000000027, 6.25293404514, 6298.32832117640},
	{0.00000000035, 5.35069959846, 9985.80941342200},
	{0.00000000035, 4.14318644891, 10440.76167900000},
	{0.00000000028, 4.67032066017, 55022.93574707440},
	{0.00000000033, 1.09348944613, 27461.71084806540},
	{0.00000000026, 4.77604676579, 34363.36559755600},
	{0.00000000032, 1.06669637529, 11265.55392939940},
	{0.00000000029, 3.31180384238, 30206.14490075619},
	{0.00000000032, 5.28519921901, 51868.24866217880},
	{0.00000000033, 1.79088538074, 59728.66805461800},
	{0.00000000029, 3.70229059266, 20220.38554398480},
	{0.00000000024, 5.85539151209, 8734.41897214660},
	{0.00000000024, 1.21351947969, 36173.70819710020},
	{0.00000000024, 4.42282986398, 31022.75317085620},
	{0.00000000024, 2.16102096842, 40879.44050464380},
	{0.00000000027, 2.40070719103, 37724.75341974820},
	{0.00000000027, 2.82758334354, 30220.37199475780},
	{0.00000000023, 0.26922480404, 24383.07910844140},
	{0.00000000023, 3.40993702222, 51092.72605085480},
	{0.00000000023, 2.71148449796, 10367.06435669580},
	{0.00000000023, 0.49921624223, 10059.50673572620},
	{0.00000000029, 2.93595097785, 26087.90314157420},
	{0.00000000026, 2.79749713332, 39271.18283656100},
	{0.00000000026, 3.27997889051, 39256.95574255939},
	{0.00000000025, 5.61288176999, 46386.99374331120},
	{0.00000000023, 3.93905950844, 49515.38250840700},
	{0.00000000026, 3.68291120913, 8101.63523283340},
	{0.00000000022, 2.92851543538, 24978.52458948080},
	{0.00000000030, 4.35689646676, 17248.42530185440},
	{0.00000000022, 0.61619120317, 22645.32819660879},
	{0.00000000022, 1.75420132293, 30426.55754319500},
	{0.00000000022, 2.56035448587, 66813.56483573320},
	{0.00000000022, 0.93565021177, 9566.27471289620},
	{0.00000000023, 2.47790916174, 6309.37416979120},
	{0.00000000021, 2.05775290145, 10949.16205974280},
	{0.00000000021, 1.15294783874, 9477.40903267920},
	{0.00000000028, 0.54837105379, 9580.50180689780},
	{0.00000000024, 0.56697771725, 10288.06714477830},
	{0.00000000024, 2.64372302294, 10138.50394764370},
	{0.00000000020, 2.21258610934, 11279.78102340100},
	{0.00000000020, 3.68816505309, 18073.70493865020},
	{0.00000000021, 6.08866841317, 58953.14544329400},
	{0.00000000023, 5.24359027210, 45585.17281218740},
	{0.00000000023, 2.67526294292, 10263.04257168280},
	{0.00000000023, 0.53543779727, 10163.52852073920},
	{0.00000000027, 3.93215204936, 24341.52831745660},
	{0.00000000021, 5.90887195268, 18300.69368504279},
	{0.00000000026, 3.21325564576, 63658.87775083760},
	{0.00000000023, 5.86841686095, 52175.80628314840},
	{0.00000000019, 1.80883011026, 20316.36477120259},
	{0.00000000020, 2.90910269310, 38526.57435087200},
	{0.00000000019, 3.53288056554, 44809.65020086340},
	{0.00000000020, 0.92201968088, 62081.53420838980},
	{0.00000000020, 4.23941240591, 42456.78404709160},
	{0.00000000020, 2.70819091080, 49477.35483577119},
	{0.00000000019, 6.01601338494, 28513.97923125379},
	{0.00000000018, 5.40437078778, 9050.81084180320},
	{0.00000000019, 0.08422406558, 47623.85278608960},
	{0.00000000017, 4.46941749243, 10497.14486507620},
	{0.00000000017, 5.02446855494, 9929.42622734580},
	{0.00000000017, 1.63590437693, 28313.28880466100},
	{0.00000000018, 4.34354168525, 27682.14074415640},
	{0.00000000017, 0.77261247444, 19624.75016129820},
	{0.00000000020, 1.53858484384, 43071.89928903080},
	{0.00000000017, 6.13245058546, 18314.92077904440},
	{0.00000000018, 0.75283830224, 50317.20343953080},
	{0.00000000018, 0.02898286217, 42430.48572729180},
	{0.00000000016, 5.43519924864, 9745.32055585660},
	{0.00000000016, 4.05868679873, 10681.25053656540},
	{0.00000000016, 4.40841499018, 41654.96311596780},
	{0.00000000015, 5.40287159543, 10199.05845220940},
	{0.00000000015, 4.09101445194, 10227.51264021260},
	{0.00000000017, 3.98136429313, 70743.77453195279},
	{0.00000000015, 4.91286509923, 48739.85989708300},
	{0.00000000015, 4.83495777746, 38734.37832446560},
	{0.00000000015, 1.22362311631, 62883.35513951360},
	{0.00000000015, 2.70406994167, 53285.18483524180},
	{0.00000000015, 2.34568905276, 66011.74390460939},
	{0.00000000015, 2.83729246953, 38727.26477746480},
	{0.00000000015, 1.51873359040, 46360.69542351140},
	{0.00000000019, 4.60380196538, 67589.08744705719},
	{0.00000000014, 0.37440982130, 39999.94580309200},
	{0.00000000014, 1.52734358006, 11026.83583017080},
	{0.00000000014, 1.68335716013, 9399.73526225120},
	{0.00000000014, 0.04043838791, 28528.20632525540},
	{0.00000000014, 1.39515112241, 37895.42629036740},
	{0.00000000014, 1.44889652645, 37410.56723987860},
	{0.00000000014, 2.77974606905, 14128.24277124560},
	{0.00000000014, 2.94217443085, 50290.90511973100},
	{0.00000000015, 6.22361957178, 21485.95302261119},
	{0.00000000013, 6.14132798035, 52670.06959330260},
	{0.00000000015, 3.18753797236, 27991.40181316000},
	{0, 0, 0}
};

struct vsop87_term venus_x2[] = {
	{0.00000704794, 5.09874399916, 20426.57109242200},
	{0.00000624477, 3.86836776757, 10213.28554621100},
	{0.00000649010, 3.14159265359, 0.00000000000},
	{0.00000011644, 5.50982814990, 30639.85663863300},
	{0.00000008620, 2.69988723020, 10186.98722641120},
	{0.00000008590, 0.50870967404, 10239.58386601080},
	{0.00000003815, 0.77119888833, 9437.76293488700},
	{0.00000002806, 3.22770970899, 8635.94200376320},
	{0.00000003408, 2.43107046634, 10988.80815753500},
	{0.00000002200, 3.74779356664, 10021.83728009940},
	{0.00000002279, 6.27047209584, 11790.62908865880},
	{0.00000002142, 5.74529785137, 10404.73381232260},
	{0.00000001697, 0.37726443109, 775.52261132400},
	{0.00000000716, 1.35432613135, 9830.38901398780},
	{0.00000000645, 1.80158579035, 4705.73230754360},
	{0.00000000682, 1.85637661737, 10596.18207843420},
	{0.00000000594, 2.81614157236, 19651.04848109800},
	{0.00000000527, 4.51723747327, 10742.97651130560},
	{0.00000000527, 4.96386147132, 9683.59458111640},
	{0.00000000532, 2.93260463288, 191.44826611160},
	{0.00000000570, 5.05711649193, 801.82093112380},
	{0.00000000526, 1.01160968834, 7058.59846131540},
	{0.00000000329, 1.41548628066, 15720.83878487840},
	{0.00000000286, 3.25503239085, 9103.90699411760},
	{0.00000000362, 5.91786685439, 9411.46461508720},
	{0.00000000301, 2.27011866705, 26.29831979980},
	{0.00000000359, 2.19075630034, 13367.97263110660},
	{0.00000000250, 6.23903308413, 11322.66409830440},
	{0.00000000298, 3.54353073631, 11015.10647733480},
	{0.00000000239, 4.19538799331, 3154.68708489560},
	{0.00000000302, 5.83564279638, 3128.38876509580},
	{0.00000000191, 3.61200654986, 1059.38193018920},
	{0.00000000190, 1.78329501671, 10426.58464164900},
	{0.00000000190, 1.42740572348, 9999.98645077300},
	{0.00000000187, 0.38219508219, 1577.34354244780},
	{0.00000000192, 6.19395381253, 20618.01935853360},
	{0.00000000146, 4.41425613950, 2352.86615377180},
	{0.00000000179, 1.99989531828, 21228.39202354580},
	{0.00000000156, 6.20080955726, 40853.14218484400},
	{0.00000000158, 5.43294450699, 382.89653222320},
	{0.00000000161, 4.51005276896, 7860.41939243920},
	{0.00000000125, 2.64197102629, 18849.22754997420},
	{0.00000000132, 0.16898152725, 3930.20969621960},
	{0.00000000110, 0.59245910440, 8624.21265092720},
	{0.00000000134, 3.64312166787, 17298.18232732620},
	{0.00000000107, 5.82966879256, 20452.86941222180},
	{0.00000000068, 5.84598202962, 19367.18916223280},
	{0.00000000072, 1.10778150127, 23581.25817731760},
	{0.00000000070, 5.63299061783, 7084.89678111520},
	{0.00000000074, 3.16178470541, 16496.36139620240},
	{0.00000000057, 4.96237460299, 1109.37855209340},
	{0.00000000053, 2.36605837917, 22003.91463486980},
	{0.00000000048, 4.93562349382, 18073.70493865020},
	{0.00000000054, 2.36466233604, 20809.46762464520},
	{0.00000000043, 3.78706374371, 29050.78374334920},
	{0.00000000055, 0.22978754207, 4732.03062734340},
	{0.00000000043, 0.15185271000, 8094.52168583260},
	{0.00000000044, 5.10533977629, 9638.94074787620},
	{0.00000000044, 4.38854627107, 10787.63034454580},
	{0.00000000040, 5.32074711484, 6283.07584999140},
	{0.00000000043, 4.98849256625, 12566.15169998280},
	{0.00000000033, 1.04174898368, 14919.01785375460},
	{0.00000000028, 3.85390317672, 20235.12282631040},
	{0.00000000033, 0.99530602494, 6489.77658728800},
	{0.00000000037, 5.11045310809, 9153.90361602180},
	{0.00000000027, 0.81625295039, 10639.88373708700},
	{0.00000000027, 2.39444778980, 9786.68735533500},
	{0.00000000029, 4.87032618379, 28286.99048486120},
	{0.00000000030, 3.37471697119, 24356.78078864160},
	{0.00000000026, 0.63216688286, 3149.16416058820},
	{0.00000000027, 5.00859316582, 14143.49524243060},
	{0.00000000031, 0.82947045576, 5507.55323866740},
	{0.00000000030, 3.88005298578, 20400.27277262220},
	{0.00000000026, 0.46698874540, 18875.52586977400},
	{0.00000000024, 5.30704569197, 11272.66747640020},
	{0.00000000026, 2.47001707887, 27511.46787353720},
	{0.00000000024, 1.86048219684, 21535.94964451540},
	{0.00000000022, 0.00126624686, 18307.80723204360},
	{0.00000000023, 2.21622723743, 13936.79450513400},
	{0.00000000018, 3.36089889556, 28521.09277825460},
	{0.00000000015, 2.23535668841, 8662.24032356300},
	{0.00000000016, 2.19972601182, 14945.31617355440},
	{0.00000000014, 3.19729711687, 21202.09370374600},
	{0.00000000014, 2.58068667661, 17277.40693183380},
	{0.00000000014, 5.26463032742, 11764.33076885900},
	{0.00000000016, 2.92030002382, 32217.20018108080},
	{0.00000000013, 1.93488220322, 34570.06633485260},
	{0.00000000013, 0.68541371817, 22779.43724619380},
	{0.00000000012, 3.89742961770, 31441.67756975680},
	{0.00000000015, 3.60443851725, 29580.47470844380},
	{0.00000000013, 3.99248913141, 25934.12433108940},
	{0.00000000012, 3.50566249225, 25158.60171976540},
	{0.00000000009, 3.35947600276, 38500.27603107220},
	{0.00000000009, 4.96082633163, 29088.81141598500},
	{0.00000000007, 1.94868342879, 43232.30665841560},
	{0.00000000007, 1.87956392812, 22805.73556599360},
	{0.00000000007, 6.01401596195, 29999.95935231900},
	{0.00000000007, 5.94489646128, 9573.38825989700},
	{0.00000000007, 3.40501345577, 30110.16567353840},
	{0, 0, 0}
};

struct vsop87_term venus_x3[] = {
	{0.00000073606, 0.00000000000, 0.00000000000},
	{0.00000019386, 5.23038243202, 10213.28554621100},
	{0.00000024718, 3.25340548805, 20426.57109242200},
	{0.00000000623, 3.24709806895, 30639.85663863300},
	{0.00000000009, 3.72367923110, 40853.14218484400},
	{0, 0, 0}
};

struct vsop87_term venus_x4[] = {
	{0.00000000946, 0.39076344760, 10213.28554621100},
	{0.00000000546, 3.14159265359, 0.00000000000},
	{0.00000000289, 0.95993858755, 20426.57109242200},
	{0.00000000030, 0.98741714872, 30639.85663863300},
	{0, 0, 0}
};

struct vsop87_term venus_x5[] = {
	{0.00000000063, 3.14159265359, 0.00000000000},
	{0.00000000029, 1.94730457757, 10213.28554621100},
	{0.00000000022, 0.34341584207, 20426.57109242200},
	{0, 0, 0}
};

struct vsop87_term venus_y0[] = {
	{0.72324820731, 1.60573808356, 10213.28554621100},
	{0.00549506273, 3.14159265359, 0.00000000000},
	{0.00244884790, 2.48564954004, 20426.57109242200},
	{0.00002789807, 5.04214523606, 2352.86615377180},
	{0.00001933868, 5.80597990261, 1577.34354244780},
	{0.00001243658, 3.36573697344, 30639.85663863300},
	{0.00001164480, 1.30970620277, 18073.70493865020},
	{0.00001041872, 0.18129136925, 6283.07584999140},
	{0.00000770549, 5.30366680002, 529.69096509460},
	{0.00000670527, 6.17032430376, 14143.49524243060},
	{0.00000657675, 5.21360427049, 8635.94200376320},
	{0.00000477182, 4.27309387857, 10186.98722641120},
	{0.00000475690, 2.08026660779, 10239.58386601080},
	{0.00000559632, 5.87842445808, 22003.91463486980},
	{0.00000542381, 1.15040078193, 11790.62908865880},
	{0.00000367778, 2.17623939625, 9437.76293488700},
	{0.00000407052, 2.35411923107, 775.52261132400},
	{0.00000275646, 1.23968348521, 9683.59458111640},
	{0.00000268898, 5.13218653673, 10742.97651130560},
	{0.00000302219, 0.94310085463, 5507.55323866740},
	{0.00000214465, 5.46202116536, 10021.83728009940},
	{0.00000241591, 4.23657289457, 10988.80815753500},
	{0.00000207456, 0.88354754907, 10404.73381232260},
	{0.00000274181, 0.42777141449, 9153.90361602180},
	{0.00000271427, 1.05376720660, 19896.88012732740},
	{0.00000175993, 1.40721119359, 191.44826611160},
	{0.00000123120, 0.01710584424, 1059.38193018920},
	{0.00000154080, 3.78432893453, 4705.73230754360},
	{0.00000146618, 3.98848869231, 19651.04848109800},
	{0.00000069607, 4.80578213159, 9103.90699411760},
	{0.00000062765, 1.56960357113, 11322.66409830440},
	{0.00000080946, 2.57565274435, 15720.83878487840},
	{0.00000058886, 1.48624205515, 20618.01935853360},
	{0.00000069363, 3.69964170363, 13367.97263110660},
	{0.00000060880, 2.21481236691, 4551.95349705880},
	{0.00000046449, 5.23328801608, 10192.51015071860},
	{0.00000046324, 1.11900673339, 10234.06094170340},
	{0.00000062214, 1.01972067969, 25934.12433108940},
	{0.00000050886, 0.04577660930, 8624.21265092720},
	{0.00000045635, 0.06422916339, 19367.18916223280},
	{0.00000057305, 2.21379435263, 3154.68708489560},
	{0.00000043008, 4.77406484115, 11015.10647733480},
	{0.00000040191, 1.64117305351, 9411.46461508720},
	{0.00000047803, 5.57043181545, 213.29909543800},
	{0.00000039695, 3.21219423570, 801.82093112380},
	{0.00000045195, 0.48101910280, 29580.47470844380},
	{0.00000036983, 2.82425916202, 7058.59846131540},
	{0.00000028623, 3.35612170637, 1109.37855209340},
	{0.00000032033, 4.14384371647, 15874.61759536320},
	{0.00000036570, 2.34542445828, 9999.98645077300},
	{0.00000035385, 4.01098677439, 10426.58464164900},
	{0.00000026683, 4.05505010621, 7860.41939243920},
	{0.00000031203, 5.14153242529, 17298.18232732620},
	{0.00000020281, 1.13139072441, 10220.39909321180},
	{0.00000020203, 5.21881955034, 10206.17199921020},
	{0.00000019545, 0.48811065404, 7.11354700080},
	{0.00000021268, 1.37799999997, 3128.38876509580},
	{0.00000018884, 0.61668932816, 26.29831979980},
	{0.00000019675, 1.34966583849, 3930.20969621960},
	{0.00000017677, 1.74739410911, 3532.06069281140},
	{0.00000015237, 2.81371933371, 9830.38901398780},
	{0.00000017691, 3.60800987998, 7084.89678111520},
	{0.00000013327, 5.53453199388, 5661.33204915220},
	{0.00000014371, 3.52598338070, 10596.18207843420},
	{0.00000016090, 0.78654424919, 20213.27199698400},
	{0.00000011121, 2.20216490389, 28286.99048486120},
	{0.00000014763, 2.49676145619, 29864.33402730900},
	{0.00000012842, 0.47911260035, 1589.07289528380},
	{0.00000014712, 2.29133684995, 23581.25817731760},
	{0.00000009394, 5.33533491552, 11272.66747640020},
	{0.00000011695, 4.63672266528, 3340.61242669980},
	{0.00000010763, 5.94541303751, 9929.42622734580},
	{0.00000008761, 0.11029927382, 29050.78374334920},
	{0.00000010378, 0.40689057274, 10497.14486507620},
	{0.00000007445, 3.28642860734, 21535.94964451540},
	{0.00000007498, 4.24533507981, 40853.14218484400},
	{0.00000007389, 5.51255095771, 16496.36139620240},
	{0.00000008792, 5.18118052529, 10207.76262190360},
	{0.00000008786, 1.17109977659, 10218.80847051840},
	{0.00000009913, 6.14997101823, 9786.68735533500},
	{0.00000007423, 2.59067946967, 10175.25787357520},
	{0.00000007386, 3.76162101633, 10251.31321884680},
	{0.00000008148, 3.12774143805, 18837.49819713819},
	{0.00000006728, 5.95684074920, 8094.52168583260},
	{0.00000006531, 5.88279509445, 20419.45754542119},
	{0.00000007978, 1.89127848081, 12566.15169998280},
	{0.00000005882, 0.45870719779, 32217.20018108080},
	{0.00000005728, 0.74065551442, 24356.78078864160},
	{0.00000005963, 5.04938942644, 6681.22485339960},
	{0.00000005965, 0.59433125558, 426.59819087600},
	{0.00000004944, 2.08956957827, 3149.16416058820},
	{0.00000005640, 3.95018415563, 382.89653222320},
	{0.00000004593, 1.06358355759, 14765.23904326980},
	{0.00000004707, 4.98650913328, 18849.22754997420},
	{0.00000005507, 1.80406867812, 25158.60171976540},
	{0.00000005411, 2.88024654297, 26087.90314157420},
	{0.00000005495, 1.72074788403, 17085.95866572220},
	{0.00000005326, 3.83237566744, 33794.54372352860},
	{0.00000005089, 0.10337236315, 14945.31617355440},
	{0.00000003978, 1.32528412563, 13745.34623902240},
	{0.00000004659, 1.22404458937, 20452.86941222180},
	{0.00000003998, 4.65648271949, 4732.03062734340},
	{0.00000004330, 1.83563721109, 23958.63178523340},
	{0.00000003477, 5.05468526636, 1551.04522264800},
	{0.00000002949, 1.25283495999, 10198.03307502600},
	{0.00000002944, 5.09946217029, 10228.53801739600},
	{0.00000003221, 5.14877320147, 20400.27277262220},
	{0.00000003317, 1.49275898018, 18875.52586977400},
	{0.00000002888, 2.65887654829, 18307.80723204360},
	{0.00000002743, 0.21013076684, 5481.25491886760},
	{0.00000003422, 3.20260172773, 29088.81141598500},
	{0.00000003167, 3.72833942933, 27511.46787353720},
	{0.00000002431, 2.28525105333, 30110.16567353840},
	{0.00000002308, 1.19399794720, 6872.67311951120},
	{0.00000002306, 2.32729148663, 3442.57494496540},
	{0.00000002424, 5.68140954809, 20956.26205751660},
	{0.00000002376, 5.99390031067, 8662.24032356300},
	{0.00000002431, 2.10516277403, 21228.39202354580},
	{0.00000002601, 2.22431686363, 9580.50180689780},
	{0.00000001984, 4.11155161070, 17277.40693183380},
	{0.00000002044, 5.75289655241, 19999.97290154599},
	{0.00000002100, 5.81905329229, 28521.09277825460},
	{0.00000002207, 2.03000529435, 536.80451209540},
	{0.00000002010, 5.27974132127, 21202.09370374600},
	{0.00000002471, 4.17663285501, 10846.06928552420},
	{0.00000001988, 4.08614647864, 20809.46762464520},
	{0.00000002188, 4.41129276996, 9967.45389998160},
	{0.00000002278, 2.82110310010, 10110.19277199240},
	{0.00000002278, 3.53119029368, 10316.37832042960},
	{0.00000001804, 2.43206099970, 22779.43724619380},
	{0.00000002118, 1.94080328198, 10459.11719244040},
	{0.00000002260, 0.59802721740, 9573.38825989700},
	{0.00000001753, 5.10951080278, 13553.89797291080},
	{0.00000001766, 4.70160896115, 7064.12138562280},
	{0.00000002081, 5.38873357358, 522.57741809380},
	{0.00000002093, 2.69264168456, 9690.70812811720},
	{0.00000002128, 3.57071500134, 103.09277421860},
	{0.00000001962, 3.66416649367, 10735.86296430480},
	{0.00000001483, 4.31350753488, 3723.50895892300},
	{0.00000002074, 4.62137633405, 33019.02111220460},
	{0.00000001480, 4.20172565416, 16983.99614745660},
	{0.00000001976, 5.25155661903, 37724.75341974820},
	{0.00000001472, 5.58089341541, 6770.71060124560},
	{0.00000001659, 0.00230055843, 20235.12282631040},
	{0.00000001873, 6.21486910777, 30213.25844775700},
	{0.00000001542, 2.45181007185, 6489.77658728800},
	{0.00000001360, 4.22919267004, 10232.95530711079},
	{0.00000001360, 2.12310072374, 10193.61578531121},
	{0.00000001567, 3.66460689276, 9146.79006902100},
	{0.00000001592, 0.91871579673, 10288.06714477830},
	{0.00000001592, 5.43357759705, 10138.50394764370},
	{0.00000001257, 3.93598172725, 9793.80090233580},
	{0.00000001232, 5.36389077993, 20.77539549240},
	{0.00000001560, 5.07643229822, 9896.89367655440},
	{0.00000001560, 1.27586109556, 10529.67741586760},
	{0.00000001178, 4.45247045018, 14919.01785375460},
	{0.00000001158, 2.28822825043, 10632.77019008620},
	{0.00000001254, 5.80795879481, 2379.16447357160},
	{0.00000001237, 1.11516406327, 12592.45001978260},
	{0.00000001402, 3.43281150113, 10639.88373708700},
	{0.00000001435, 0.39193883021, 9161.01716302260},
	{0.00000000967, 0.02581226166, 639.89728631400},
	{0.00000001192, 2.95601574230, 39264.06928956020},
	{0.00000001010, 5.80804230901, 10007.09999777380},
	{0.00000001008, 0.55046820997, 10419.47109464820},
	{0.00000001269, 6.03842899487, 36949.23080842420},
	{0.00000001187, 5.04350394974, 31441.67756975680},
	{0.00000001216, 3.92525318232, 74.78159856730},
	{0.00000000995, 2.96746942556, 13341.67431130680},
	{0.00000001120, 0.26190073863, 245.83164622940},
	{0.00000001139, 0.86087945459, 2118.76386037840},
	{0.00000000761, 5.59004416449, 7564.83072073800},
	{0.00000000786, 0.51228624161, 11764.33076885900},
	{0.00000000795, 1.85352659217, 10750.09005830640},
	{0.00000000769, 5.39709006967, 7834.12107263940},
	{0.00000000784, 4.48666174060, 9676.48103411560},
	{0.00000000695, 1.82001334483, 36147.40987730040},
	{0.00000000845, 3.16389685660, 22805.73556599360},
	{0.00000000787, 4.31922872731, 19889.76658032659},
	{0.00000000798, 3.51175121692, 13936.79450513400},
	{0.00000000789, 4.89377019350, 7994.52844202420},
	{0.00000000624, 1.27677428473, 39793.76025465480},
	{0.00000000808, 0.37657594142, 41654.96311596780},
	{0.00000000744, 0.94447044889, 19903.99367432819},
	{0.00000000689, 3.03288154721, 1066.49547719000},
	{0.00000000783, 1.17537914975, 40879.44050464380},
	{0.00000000632, 5.89589146195, 52175.80628314840},
	{0.00000000686, 1.54143807247, 12432.04265039780},
	{0.00000000520, 1.44881507469, 110.20632121940},
	{0.00000000647, 4.49596793914, 26735.94526221320},
	{0.00000000605, 3.06366110276, 10059.50673572620},
	{0.00000000503, 2.26978085577, 17778.11626694899},
	{0.00000000676, 3.63142919749, 20529.66386664059},
	{0.00000000593, 3.28870942824, 10367.06435669580},
	{0.00000000665, 4.76490629865, 1162.47470440780},
	{0.00000000464, 0.84118413790, 8631.32619792800},
	{0.00000000454, 5.50480758535, 10042.61267559180},
	{0.00000000444, 0.84748587084, 10383.95841683020},
	{0.00000000439, 4.57010937002, 24150.08005134500},
	{0.00000000582, 1.01106657087, 8521.11987670860},
	{0.00000000460, 5.40297168283, 11802.35844149480},
	{0.00000000498, 2.61301324745, 16522.65971600220},
	{0.00000000436, 0.28613813561, 9638.94074787620},
	{0.00000000416, 0.15526058452, 10225.01489904700},
	{0.00000000416, 6.19703280926, 10201.55619337500},
	{0.00000000439, 5.33807558951, 27991.40181316000},
	{0.00000000431, 3.30244061049, 8617.09910392640},
	{0.00000000472, 3.26622622976, 2218.75710418680},
	{0.00000000379, 4.94184026058, 19317.19254032860},
	{0.00000000377, 4.10224485736, 149.56319713460},
	{0.00000000391, 6.01609758586, 10787.63034454580},
	{0.00000000355, 2.68573127230, 30831.30490474460},
	{0.00000000354, 1.27226804531, 10323.49186743040},
	{0.00000000354, 5.08002534847, 10103.07922499160},
	{0.00000000420, 1.77275125703, 9050.81084180320},
	{0.00000000478, 0.19721186884, 35371.88726597640},
	{0.00000000490, 2.59601400341, 44809.65020086340},
	{0.00000000429, 1.10169709405, 13655.86049117640},
	{0.00000000468, 3.72988210531, 38.13303563780},
	{0.00000000398, 5.69369661409, 1052.26838318840},
	{0.00000000404, 5.98015684299, 30666.15495843280},
	{0.00000000331, 4.69331165984, 27490.69247804480},
	{0.00000000315, 4.73109393582, 20639.87018786000},
	{0.00000000328, 1.01438027476, 19786.67380610799},
	{0.00000000392, 4.05329100749, 632.78373931320},
	{0.00000000392, 0.71173908582, 29999.95935231900},
	{0.00000000399, 2.67833209975, 10211.80107350270},
	{0.00000000399, 3.67396129403, 10214.77001891930},
	{0.00000000398, 2.07757069100, 9835.91193829520},
	{0.00000000404, 2.41513448299, 20351.78949385470},
	{0.00000000385, 6.08106825320, 20180.73944619260},
	{0.00000000379, 4.27472283876, 10590.65915412680},
	{0.00000000318, 0.94946325025, 6309.37416979120},
	{0.00000000336, 5.44898460787, 220.41264243880},
	{0.00000000365, 6.13706743141, 10348.91087122100},
	{0.00000000365, 0.21522596237, 10077.66022120100},
	{0.00000000283, 3.96316373805, 3903.91137641980},
	{0.00000000269, 4.01599389913, 26709.64694241340},
	{0.00000000271, 2.28569001687, 9745.32055585660},
	{0.00000000327, 1.40630049713, 9360.08916445900},
	{0.00000000264, 3.58982234478, 76.26607127560},
	{0.00000000314, 6.11319497702, 20405.79569692960},
	{0.00000000273, 2.81398608180, 206.18554843720},
	{0.00000000306, 5.83870523892, 2957.71589447660},
	{0.00000000329, 1.76365842835, 45585.17281218740},
	{0.00000000254, 4.06665627806, 10681.25053656540},
	{0.00000000343, 3.07216304543, 8106.25103866860},
	{0.00000000294, 3.40944983272, 19360.07561523199},
	{0.00000000234, 2.24935611965, 19624.75016129820},
	{0.00000000281, 5.49571066653, 9399.73526225120},
	{0.00000000229, 0.20430029596, 574.34479833480},
	{0.00000000280, 2.60576987045, 38734.37832446560},
	{0.00000000229, 2.88442554028, 949.17560896980},
	{0.00000000309, 4.01568679365, 48739.85989708300},
	{0.00000000222, 2.81789285850, 8734.41897214660},
	{0.00000000292, 3.65814608665, 27197.28169366760},
	{0.00000000267, 2.30394736960, 31749.23519072640},
	{0.00000000229, 2.85216297633, 9264.10993724120},
	{0.00000000255, 2.46385009073, 9992.87290377220},
	{0.00000000255, 3.88844330305, 10433.69818864980},
	{0.00000000259, 3.73915077229, 29573.36116144300},
	{0.00000000211, 4.89515362389, 10249.31341288840},
	{0.00000000211, 1.45713976989, 10177.25767953360},
	{0.00000000255, 0.85666245088, 11026.83583017080},
	{0.00000000275, 1.03976284586, 34596.36465465240},
	{0.00000000220, 2.13242742555, 38.02767263580},
	{0.00000000247, 0.33731775967, 29587.58825544460},
	{0.00000000206, 1.80396539478, 30426.55754319500},
	{0.00000000263, 1.59050643196, 20433.68463942280},
	{0.00000000212, 1.58965720399, 10206.65698731099},
	{0.00000000212, 4.76263618979, 10219.91410511101},
	{0.00000000202, 5.53771508607, 16894.51039961060},
	{0.00000000197, 3.20271468078, 40077.61957352000},
	{0.00000000254, 2.17517906027, 37410.56723987860},
	{0.00000000272, 3.28012791525, 12320.32005375340},
	{0.00000000211, 3.54449702303, 11162.46115518080},
	{0.00000000266, 2.72829191880, 377.37360791580},
	{0.00000000186, 2.96624941532, 10251.41858184880},
	{0.00000000186, 3.38604397846, 10175.15251057320},
	{0.00000000258, 0.95259827692, 9864.36112576300},
	{0.00000000186, 3.29302251278, 17271.88400752640},
	{0.00000000257, 3.20894861459, 10063.72234907640},
	{0.00000000254, 1.58851548099, 19264.09638801420},
	{0.00000000246, 5.39979365811, 10562.20996665900},
	{0.00000000211, 4.59175138406, 11375.76025061880},
	{0.00000000233, 1.59229597312, 39302.09696219600},
	{0.00000000178, 5.22149503543, 10949.16205974280},
	{0.00000000178, 1.13079835835, 9477.40903267920},
	{0.00000000197, 5.67124977323, 1692.16566950240},
	{0.00000000177, 4.83529684993, 20316.36477120259},
	{0.00000000154, 5.43597579906, 10199.05845220940},
	{0.00000000154, 0.91631759472, 10227.51264021260},
	{0.00000000176, 0.33520501486, 14.22709400160},
	{0.00000000152, 4.19364670284, 283.85931886520},
	{0.00000000166, 2.18082507791, 10263.04257168280},
	{0.00000000166, 4.17146831587, 10163.52852073920},
	{0.00000000168, 0.62501827359, 7991.42891161400},
	{0.00000000182, 2.27073026813, 9256.99639024040},
	{0.00000000197, 1.86994400353, 846.08283475120},
	{0.00000000169, 4.14838568997, 11265.55392939940},
	{0.00000000152, 4.81054163957, 9367.20271145980},
	{0.00000000195, 3.84051863538, 8837.51174636520},
	{0.00000000140, 5.04268037408, 10191.43471688460},
	{0.00000000140, 1.30961301970, 10235.13637553740},
	{0.00000000196, 3.84517606319, 1293.48422358260},
	{0.00000000191, 5.43460705034, 52670.06959330260},
	{0.00000000183, 2.47363849671, 38526.57435087200},
	{0.00000000138, 5.09734035169, 10217.21769947410},
	{0.00000000138, 1.25495304209, 10209.35339294790},
	{0.00000000148, 0.77105069393, 19374.30270923360},
	{0.00000000143, 6.11571774821, 20447.34648791440},
	{0.00000000156, 6.26097721339, 9779.57380833420},
	{0.00000000126, 2.24994178665, 20277.00789528740},
	{0.00000000149, 0.61484998961, 10135.61177578300},
	{0.00000000149, 5.73744340417, 10290.95931663900},
	{0.00000000117, 5.64821183940, 1581.95934828300},
	{0.00000000151, 5.55480633210, 10245.81809700240},
	{0.00000000151, 0.79748706168, 10180.75299541960},
	{0.00000000119, 1.19706827555, 7255.56965173440},
	{0.00000000144, 2.25615309488, 9985.80941342200},
	{0.00000000144, 4.09614029890, 10440.76167900000},
	{0.00000000130, 4.00092308815, 10236.06074766180},
	{0.00000000130, 2.35137030563, 10190.51034476020},
	{0.00000000156, 2.62001496108, 20388.43805678420},
	{0.00000000155, 5.57179123583, 8237.79300035500},
	{0.00000000134, 3.09738168989, 49515.38250840700},
	{0.00000000130, 2.02381333844, 38204.68735937100},
	{0.00000000106, 6.19602488368, 17468.85519794540},
	{0.00000000131, 0.68489685701, 8101.63523283340},
	{0.00000000103, 2.80780479569, 24978.52458948080},
	{0.00000000102, 2.52405576525, 419.48464387520},
	{0.00000000122, 2.34109232351, 19793.78735310880},
	{0.00000000101, 3.69358080572, 20043.67456019880},
	{0.00000000135, 4.50553232470, 5999.21653112620},
	{0.00000000097, 5.63290016993, 853.19638175200},
	{0.00000000123, 2.99027576045, 43232.30665841560},
	{0.00000000109, 4.59018786120, 43071.89928903080},
	{0.00000000099, 2.67241755916, 78263.70942472259},
	{0.00000000130, 1.64611266829, 4176.04134244900},
	{0.00000000122, 5.60169381159, 24383.07910844140},
	{0.00000000097, 5.88286380267, 32858.61374281979},
	{0.00000000112, 0.89977181729, 20206.15844998319},
	{0.00000000093, 1.80493983620, 8204.72800705200},
	{0.00000000098, 1.55452229557, 11059.36838096220},
	{0.00000000121, 3.89536747733, 42456.78404709160},
	{0.00000000091, 2.45754138550, 18844.61174413899},
	{0.00000000103, 3.58160703323, 10244.19967184600},
	{0.00000000103, 2.77068636055, 10182.37142057600},
	{0.00000000125, 0.78050551092, 12188.77809206700},
	{0.00000000097, 2.34874466786, 2333.19639287200},
	{0.00000000122, 0.57162307533, 56600.27928952220},
	{0.00000000088, 2.76213355426, 20350.30502114640},
	{0.00000000102, 5.88069001423, 3.93215326310},
	{0.00000000122, 3.86087135261, 2636.72547263700},
	{0.00000000087, 2.93241416282, 8087.40813883180},
	{0.00000000086, 5.21923091634, 7035.13975564340},
	{0.00000000086, 0.89639333663, 29057.89729034999},
	{0.00000000095, 0.46006492106, 10202.23984594710},
	{0.00000000095, 5.89222847272, 10224.33124647490},
	{0.00000000084, 5.03945503208, 27461.71084806540},
	{0.00000000084, 5.94038512576, 10401.21069397360},
	{0.00000000084, 0.41190826802, 10025.36039844840},
	{0.00000000085, 3.46647958947, 19477.39548345219},
	{0.00000000099, 1.23120634693, 2648.45482547300},
	{0.00000000098, 3.80111874017, 20220.38554398480},
	{0.00000000100, 3.49942556903, 1596.18644228460},
	{0.00000000091, 3.84142883929, 14169.79356223040},
	{0.00000000095, 1.78055741695, 29477.38193422520},
	{0.00000000096, 0.05074222339, 30206.14490075619},
	{0.00000000101, 2.86422529330, 38500.27603107220},
	{0.00000000095, 2.94691545874, 30220.37199475780},
	{0.00000000077, 2.01507273057, 10853.18283252500},
	{0.00000000107, 3.08276575514, 2069.00683490660},
	{0.00000000076, 3.30386469943, 10243.10698435980},
	{0.00000000076, 3.04842869435, 10183.46410806220},
	{0.00000000076, 4.53950259247, 44007.82926973960},
	{0.00000000078, 5.37998455046, 7880.08915333899},
	{0.00000000076, 4.51276408387, 956.28915597060},
	{0.00000000084, 4.18317376174, 1478.86657406440},
	{0.00000000100, 1.06747118471, 28947.69096913060},
	{0.00000000072, 1.90029548750, 17248.42530185440},
	{0.00000000082, 5.95948324562, 5.52292430740},
	{0.00000000078, 3.37272107675, 29043.67019634839},
	{0.00000000075, 0.44027902661, 21000.91589075680},
	{0.00000000071, 2.52223847071, 22645.32819660879},
	{0.00000000074, 0.35341011835, 8827.39026987480},
	{0.00000000085, 0.56779936902, 3914.95722503460},
	{0.00000000070, 6.20393956561, 6298.32832117640},
	{0.00000000072, 2.38867048672, 34171.91733144440},
	{0.00000000079, 1.08839441675, 10018.31416175040},
	{0.00000000079, 5.26389897703, 10408.25693067160},
	{0.00000000075, 0.64877739613, 18734.40542291960},
	{0.00000000069, 5.61697903331, 41044.59045095560},
	{0.00000000069, 0.68347421356, 9644.46367218360},
	{0.00000000069, 5.66881918022, 10782.10742023840},
	{0.00000000083, 4.22258770909, 9721.62225375220},
	{0.00000000083, 2.12970568469, 10704.94883866980},
	{0.00000000072, 0.13848852336, 18830.38465013739},
	{0.00000000090, 3.61691095667, 20049.19748450620},
	{0.00000000076, 5.76440532006, 21485.95302261119},
	{0.00000000072, 2.56964528099, 19573.37471066999},
	{0.00000000063, 3.18646450612, 18314.92077904440},
	{0.00000000070, 1.43478197258, 1573.82042409880},
	{0.00000000083, 5.34151461839, 46386.99374331120},
	{0.00000000067, 2.05862077241, 3956.50801601940},
	{0.00000000070, 0.75267806535, 1580.86666079680},
	{0.00000000087, 3.90827818520, 29264.08283878720},
	{0.00000000071, 0.66382087848, 28418.00000403600},
	{0.00000000061, 1.55846256298, 27682.14074415640},
	{0.00000000060, 6.06109901775, 20421.04816811460},
	{0.00000000076, 2.36906364898, 29683.56748266239},
	{0.00000000064, 5.87747392917, 18300.69368504279},
	{0.00000000062, 5.99888400949, 11599.18082254720},
	{0.00000000079, 0.78455831236, 28313.28880466100},
	{0.00000000058, 1.51132246914, 7576.56007357400},
	{0.00000000057, 2.10835504837, 11279.78102340100},
	{0.00000000079, 1.99170433665, 60530.48898574180},
	{0.00000000059, 5.97279707503, 10254.83633719580},
	{0.00000000059, 0.37949631875, 10171.73475522620},
	{0.00000000057, 2.49183550585, 20464.59876505780},
	{0.00000000079, 3.55016127148, 10137.01947493540},
	{0.00000000062, 1.89895196585, 31022.75317085620},
	{0.00000000074, 3.35112731202, 53285.18483524180},
	{0.00000000064, 4.00074980257, 30007.07289931980},
	{0.00000000058, 1.48653338098, 75449.50683949639},
	{0.00000000073, 2.27987119168, 51449.32426327820},
	{0.00000000074, 3.91369739911, 21720.05531600460},
	{0.00000000069, 4.29368361875, 18093.37469954999},
	{0.00000000072, 2.90060146744, 100608.10855926179},
	{0.00000000061, 5.27096932810, 18100.00325845000},
	{0.00000000052, 0.52182858466, 40426.54399396800},
	{0.00000000058, 6.02426265881, 20412.34399842039},
	{0.00000000065, 2.14229590210, 32243.49850088060},
	{0.00000000059, 4.73931220180, 47162.51635463520},
	{0.00000000056, 4.39886775705, 53445.59220462660},
	{0.00000000057, 3.46964286996, 8307.82078127060},
	{0.00000000050, 6.27092935627, 8418.02710249000},
	{0.00000000066, 3.34109931244, 78604.19392439199},
	{0.00000000066, 4.48087077585, 19580.48825767080},
	{0.00000000047, 3.24772372978, 38741.49187146640},
	{0.00000000050, 6.05227901906, 59160.94941688760},
	{0.00000000055, 5.41416986220, 48947.66387067660},
	{0.00000000046, 5.77895747608, 194.97138446060},
	{0.00000000056, 5.79105836654, 9936.53977434660},
	{0.00000000056, 0.56123502724, 10490.03131807540},
	{0.00000000054, 2.92585194345, 9922.31268034500},
	{0.00000000054, 3.42644145033, 10504.25841207700},
	{0.00000000059, 3.59330170983, 18204.71445782499},
	{0.00000000048, 5.93972997403, 38727.26477746480},
	{0.00000000061, 4.41585090977, 10139.98842035200},
	{0.00000000061, 1.93644248401, 10286.58267207000},
	{0.00000000061, 5.28413978764, 6566.93516885660},
	{0.00000000060, 6.18401612782, 86464.61331683119},
	{0.00000000048, 1.78116870506, 9246.31466877540},
	{0.00000000060, 4.34226209904, 3684.37804999020},
	{0.00000000060, 1.84622268138, 14427.35456129580},
	{0.00000000051, 0.71928664610, 9566.27471289620},
	{0.00000000052, 1.63253830755, 8727.30542514580},
	{0.00000000054, 3.78910232599, 47623.85278608960},
	{0.00000000048, 0.48345704135, 433.71173787680},
	{0.00000000045, 3.95006454295, 10263.28216811520},
	{0.00000000045, 2.40222885083, 10163.28892430680},
	{0.00000000049, 0.08548300777, 9794.36114731040},
	{0.00000000049, 6.26681038601, 10632.20994511160},
	{0.00000000058, 1.48165013529, 1861.20286131300},
	{0.00000000047, 6.22156178529, 20142.71177355680},
	{0.00000000044, 0.47724556879, 30632.74309163219},
	{0.00000000041, 4.84097099797, 12850.01101884800},
	{0.00000000045, 3.81128625757, 2349.34303542280},
	{0.00000000045, 3.12918282665, 2356.38927212080},
	{0.00000000042, 3.51224472308, 77802.37299326819},
	{0.00000000046, 1.42734790968, 115674.27666460119},
	{0.00000000044, 2.89783366184, 79379.71653571600},
	{0.00000000041, 1.23522586481, 25132.30339996560},
	{0.00000000039, 1.87346435474, 28631.29909947399},
	{0.00000000052, 3.63882972952, 38631.28555024700},
	{0.00000000043, 4.57112464191, 11180.25642364660},
	{0.00000000039, 5.73237078975, 1265.56747862640},
	{0.00000000052, 0.42186741524, 1.48447270830},
	{0.00000000047, 0.17782919736, 187.92514776260},
	{0.00000000039, 5.18683524181, 54981.38495608960},
	{0.00000000044, 5.88330364964, 10168.14432657440},
	{0.00000000044, 0.46898974414, 10258.42676584760},
	{0.00000000041, 1.16123981348, 24341.52831745660},
	{0.00000000051, 3.41164207102, 64460.69868196140},
	{0.00000000043, 0.40869970249, 22030.21295466960},
	{0.00000000041, 0.99171071955, 47358.59097539280},
	{0.00000000051, 4.32233055210, 104538.31825548140},
	{0.00000000051, 4.70514482859, 16250.52974997300},
	{0.00000000037, 2.91616393795, 29160.99006456860},
	{0.00000000043, 3.35259007747, 10362.84874334560},
	{0.00000000039, 1.62990239695, 37674.99639427640},
	{0.00000000038, 2.56508843435, 47917.26357046680},
	{0.00000000037, 2.84218380221, 6256.77753019160},
	{0.00000000036, 1.39948651785, 8673.96967639900},
	{0.00000000050, 1.83789408271, 54247.41313575040},
	{0.00000000044, 0.56832443467, 50317.20343953080},
	{0.00000000049, 0.39141584772, 491.66329245880},
	{0.00000000035, 1.18237243551, 12546.48193908300},
	{0.00000000044, 2.73569081007, 9697.82167511800},
	{0.00000000044, 3.61660258371, 10728.74941730400},
	{0.00000000036, 0.66587329374, 69941.95360082899},
	{0.00000000037, 1.68139239859, 35191.81013569180},
	{0.00000000035, 0.76656495982, 48733.23133818299},
	{0.00000000035, 3.22135299939, 10011.03215103690},
	{0.00000000035, 3.13094039439, 10415.53894138510},
	{0.00000000036, 3.40125641272, 100909.03762133139},
	{0.00000000044, 1.20989531942, 36301.18868778519},
	{0.00000000047, 2.53044739139, 88041.95685927900},
	{0.00000000034, 5.96407611411, 47938.03896595920},
	{0.00000000033, 3.80922491688, 49477.35483577119},
	{0.00000000045, 6.15174229277, 66038.04222440919},
	{0.00000000040, 5.33231345721, 28513.97923125379},
	{0.00000000033, 1.28829842226, 34363.36559755600},
	{0.00000000033, 2.72260069006, 55798.45835839840},
	{0.00000000033, 3.40692233770, 54394.56338733519},
	{0.00000000034, 4.57649322994, 31214.20143696780},
	{0.00000000033, 2.17810098111, 10117.30631899320},
	{0.00000000033, 4.17419241267, 10309.26477342880},
	{0.00000000034, 0.22515043919, 7461.73794651940},
	{0.00000000037, 5.80408586611, 58946.51688439399},
	{0.00000000044, 1.32352355619, 90394.82301305079},
	{0.00000000039, 1.14927453817, 316.39186965660},
	{0.00000000038, 1.18845657835, 74821.13447975718},
	{0.00000000031, 1.87707549397, 30103.05212653759},
	{0.00000000032, 0.98619416724, 34570.06633485260},
	{0.00000000032, 1.81438986358, 29786.66025688100},
	{0.00000000032, 2.19359308367, 21977.61631507000},
	{0.00000000036, 5.94106521859, 20430.50324568509},
	{0.00000000032, 4.93495248062, 81732.58268948780},
	{0.00000000043, 3.24614367572, 58177.62283197000},
	{0.00000000035, 6.20793918435, 51092.72605085480},
	{0.00000000033, 1.38971011469, 55022.93574707440},
	{0.00000000033, 4.31034440765, 83309.92623193559},
	{0.00000000029, 4.95280733068, 11752.60141602300},
	{0.00000000030, 0.91907247414, 11.04570026390},
	{0.00000000029, 3.94608385223, 9800.91444933660},
	{0.00000000029, 2.40620954155, 10625.65664308540},
	{0.00000000030, 2.05100908229, 20432.09401672940},
	{0.00000000029, 5.98297157212, 9889.78012955360},
	{0.00000000038, 1.57699576377, 47964.33728575900},
	{0.00000000039, 5.95942234005, 47888.28194048740},
	{0.00000000039, 5.51640686424, 14128.24277124560},
	{0.00000000029, 1.67115577064, 85034.42002596818},
	{0.00000000039, 5.81881044351, 73898.46161684839},
	{0.00000000040, 2.84352268392, 80181.53746683979},
	{0.00000000029, 0.20497537275, 224.34479570190},
	{0.00000000028, 4.98574596975, 10098.84625752579},
	{0.00000000028, 1.36654742403, 10327.72483489621},
	{0.00000000039, 2.90361169612, 5791.41255753260},
	{0.00000000039, 3.61855841109, 30563.59056735740},
	{0.00000000034, 2.65806280363, 1539.31586981200},
	{0.00000000028, 0.72550860398, 1179.19453903960},
	{0.00000000031, 3.89570695535, 39786.64670765400},
	{0.00000000028, 2.08868760692, 73872.16329704860},
	{0.00000000028, 5.13152921511, 15694.54046507860},
	{0.00000000034, 2.10761573799, 40213.24489853000},
	{0.00000000030, 4.24679619338, 62883.35513951360},
	{0.00000000029, 5.84823794150, 110012.94461544899},
	{0.00000000034, 1.33501180136, 42430.48572729180},
	{0.00000000037, 4.74983943559, 82534.40362061159},
	{0.00000000037, 1.06810341965, 13859.63592356540},
	{0.00000000037, 2.06942308542, 37703.97802425580},
	{0.00000000031, 1.84196344987, 25960.42265088920},
	{0.00000000028, 3.49625376754, 7886.71771223900},
	{0, 0, 0}
};

struct vsop87_term venus_y1[] = {
	{0.00039231430, 0.00000000000, 0.00000000000},
	{0.00017282326, 5.63824735900, 20426.57109242200},
	{0.00005968075, 3.60854944086, 10213.28554621100},
	{0.00000175529, 0.23554665359, 30639.85663863300},
	{0.00000060346, 3.35752563808, 8635.94200376320},
	{0.00000063046, 0.52083190822, 10186.98722641120},
	{0.00000062777, 5.83131036994, 10239.58386601080},
	{0.00000049333, 3.00159177408, 11790.62908865880},
	{0.00000036923, 0.50255601130, 775.52261132400},
	{0.00000030123, 3.75643102233, 10021.83728009940},
	{0.00000029363, 2.59481166718, 10404.73381232260},
	{0.00000019871, 5.85591903319, 9437.76293488700},
	{0.00000017907, 0.50709742814, 10988.80815753500},
	{0.00000014387, 2.14852937659, 9683.59458111640},
	{0.00000013498, 2.90084412618, 191.44826611160},
	{0.00000013527, 4.20185541440, 10742.97651130560},
	{0.00000014059, 1.92999301659, 4705.73230754360},
	{0.00000013447, 5.86031739106, 19651.04848109800},
	{0.00000006877, 3.26548847716, 9103.90699411760},
	{0.00000007587, 4.00807231212, 1059.38193018920},
	{0.00000007454, 4.42301263508, 15720.83878487840},
	{0.00000006040, 3.09328817274, 11322.66409830440},
	{0.00000005966, 0.53259218563, 10206.17199921020},
	{0.00000005966, 5.81970120815, 10220.39909321180},
	{0.00000005176, 4.06410179125, 3154.68708489560},
	{0.00000004564, 3.01891927717, 20618.01935853360},
	{0.00000004240, 4.49316795437, 9999.98645077300},
	{0.00000004157, 1.86903191118, 10426.58464164900},
	{0.00000004649, 1.29491122903, 9830.38901398780},
	{0.00000004405, 5.05081380319, 10596.18207843420},
	{0.00000004049, 5.10031933517, 7.11354700080},
	{0.00000003590, 0.89608249763, 7860.41939243920},
	{0.00000002625, 0.95628165683, 8624.21265092720},
	{0.00000002726, 2.33981418835, 19367.18916223280},
	{0.00000002696, 5.36941111650, 7058.59846131540},
	{0.00000002546, 1.70280413881, 11015.10647733480},
	{0.00000002707, 0.24920171339, 801.82093112380},
	{0.00000002539, 4.39873959203, 9411.46461508720},
	{0.00000001912, 4.86762627934, 1109.37855209340},
	{0.00000001933, 3.28230569196, 3930.20969621960},
	{0.00000001833, 0.97295205973, 13367.97263110660},
	{0.00000001586, 1.12226291756, 40853.14218484400},
	{0.00000001758, 0.69532491254, 4551.95349705880},
	{0.00000001992, 4.09610698677, 26.29831979980},
	{0.00000001694, 0.76426907626, 1577.34354244780},
	{0.00000001484, 5.54999908988, 7084.89678111520},
	{0.00000001515, 5.35568982676, 12566.15169998280},
	{0.00000001400, 4.67642362946, 11272.66747640020},
	{0.00000001282, 3.09230484373, 10218.80847051840},
	{0.00000001282, 3.25998855005, 10207.76262190360},
	{0.00000001352, 1.29314419649, 20419.45754542119},
	{0.00000001469, 4.11460578747, 3128.38876509580},
	{0.00000001241, 4.14143822683, 23581.25817731760},
	{0.00000001284, 5.45408487651, 382.89653222320},
	{0.00000001307, 1.82500475732, 9153.90361602180},
	{0.00000001191, 3.69515282095, 2352.86615377180},
	{0.00000001084, 2.78444751991, 10198.03307502600},
	{0.00000001084, 3.56784587387, 10228.53801739600},
	{0.00000001192, 3.38577049275, 16496.36139620240},
	{0.00000001113, 4.99520755106, 1589.07289528380},
	{0.00000000917, 5.67300034485, 15874.61759536320},
	{0.00000000760, 5.36638189114, 28286.99048486120},
	{0.00000000747, 0.58426038651, 3149.16416058820},
	{0.00000000795, 3.54160005210, 426.59819087600},
	{0.00000000617, 4.93603196300, 21535.94964451540},
	{0.00000000625, 1.61452093926, 20400.27277262220},
	{0.00000000613, 0.59191874324, 5661.33204915220},
	{0.00000000820, 0.36295378777, 21228.39202354580},
	{0.00000000650, 0.34096101675, 536.80451209540},
	{0.00000000674, 0.56550938814, 8094.52168583260},
	{0.00000000637, 4.96647140484, 18849.22754997420},
	{0.00000000613, 0.81482028073, 522.57741809380},
	{0.00000000657, 2.20985602421, 17298.18232732620},
	{0.00000000512, 4.24771252522, 529.69096509460},
	{0.00000000510, 5.30981933415, 20452.86941222180},
	{0.00000000432, 3.60135550460, 32217.20018108080},
	{0.00000000457, 1.01447998087, 29050.78374334920},
	{0.00000000414, 3.89598271580, 24356.78078864160},
	{0.00000000472, 5.35027481275, 9146.79006902100},
	{0.00000000418, 3.35190637416, 6681.22485339960},
	{0.00000000394, 2.90954841406, 5507.55323866740},
	{0.00000000364, 1.14500385840, 10639.88373708700},
	{0.00000000360, 5.19238212137, 9786.68735533500},
	{0.00000000361, 2.31869873474, 14945.31617355440},
	{0.00000000422, 4.94394431892, 9161.01716302260},
	{0.00000000439, 0.89714640250, 9690.70812811720},
	{0.00000000425, 5.51224263435, 20809.46762464520},
	{0.00000000440, 5.44930026371, 10735.86296430480},
	{0.00000000372, 5.21504043865, 10251.31321884680},
	{0.00000000372, 1.13725295513, 10175.25787357520},
	{0.00000000319, 5.77038311559, 17277.40693183380},
	{0.00000000389, 4.76446577072, 6283.07584999140},
	{0.00000000412, 4.35484091112, 22003.91463486980},
	{0.00000000423, 1.39634467087, 18837.49819713819},
	{0.00000000301, 5.78050751122, 14765.23904326980},
	{0.00000000351, 0.93761476307, 6489.77658728800},
	{0.00000000297, 5.78070702462, 10232.95530711079},
	{0.00000000297, 0.57158636916, 10193.61578531121},
	{0.00000000291, 3.33683517922, 18073.70493865020},
	{0.00000000287, 0.79492340372, 3442.57494496540},
	{0.00000000290, 3.01296539996, 13745.34623902240},
	{0.00000000262, 1.65344723077, 21202.09370374600},
	{0.00000000289, 4.21532853378, 20235.12282631040},
	{0.00000000269, 6.12924784861, 9676.48103411560},
	{0.00000000261, 4.05709707087, 22779.43724619380},
	{0.00000000281, 3.53032805800, 14919.01785375460},
	{0.00000000262, 0.23413334905, 10750.09005830640},
	{0.00000000256, 2.84423020029, 10234.06094170340},
	{0.00000000256, 3.50806319349, 10192.51015071860},
	{0.00000000238, 2.72262438861, 9573.38825989700},
	{0.00000000284, 1.52451893915, 4732.03062734340},
	{0.00000000233, 3.85294503850, 18875.52586977400},
	{0.00000000232, 5.81292836693, 3723.50895892300},
	{0.00000000285, 3.95599055369, 20956.26205751660},
	{0.00000000270, 2.83438706731, 19999.97290154599},
	{0.00000000225, 2.53611507701, 14143.49524243060},
	{0.00000000234, 5.59143946418, 27511.46787353720},
	{0.00000000232, 6.01167605637, 19889.76658032659},
	{0.00000000199, 5.04355453043, 9638.94074787620},
	{0.00000000218, 5.53074283644, 19903.99367432819},
	{0.00000000203, 2.88548150239, 6872.67311951120},
	{0.00000000234, 1.73310379947, 1551.04522264800},
	{0.00000000188, 1.32418537499, 10787.63034454580},
	{0.00000000179, 4.84532694620, 30110.16567353840},
	{0.00000000211, 2.96248499763, 8662.24032356300},
	{0.00000000207, 1.05108863363, 29864.33402730900},
	{0.00000000235, 1.24465087649, 1066.49547719000},
	{0.00000000208, 4.04763155841, 10007.09999777380},
	{0.00000000208, 2.30466183537, 10419.47109464820},
	{0.00000000177, 0.78176584307, 6770.71060124560},
	{0.00000000184, 0.09028640270, 9967.45389998160},
	{0.00000000163, 3.38894514289, 10225.01489904700},
	{0.00000000163, 2.96334825089, 10201.55619337500},
	{0.00000000157, 2.10855674162, 9793.80090233580},
	{0.00000000156, 4.49619634182, 10316.37832042960},
	{0.00000000156, 1.85609705196, 10110.19277199240},
	{0.00000000160, 5.67144686210, 16983.99614745660},
	{0.00000000178, 6.26185130623, 10459.11719244040},
	{0.00000000204, 5.28633538343, 13936.79450513400},
	{0.00000000163, 4.90881626780, 8617.09910392640},
	{0.00000000170, 1.17359453056, 213.29909543800},
	{0.00000000157, 3.58488866748, 13553.89797291080},
	{0.00000000151, 3.62024024548, 639.89728631400},
	{0.00000000140, 5.31634257150, 8631.32619792800},
	{0.00000000145, 6.19538998481, 7064.12138562280},
	{0.00000000128, 3.89903128812, 10632.77019008620},
	{0.00000000176, 3.03968242278, 5481.25491886760},
	{0.00000000154, 5.69297164059, 2118.76386037840},
	{0.00000000143, 3.32004421353, 7994.52844202420},
	{0.00000000106, 3.32721912157, 18307.80723204360},
	{0.00000000122, 0.66618818020, 28521.09277825460},
	{0.00000000098, 3.86407649478, 20.77539549240},
	{0.00000000104, 4.60450548155, 36147.40987730040},
	{0.00000000114, 4.33617309197, 12592.45001978260},
	{0.00000000112, 5.96644557875, 25934.12433108940},
	{0.00000000100, 1.56966430355, 1052.26838318840},
	{0.00000000129, 0.19360167861, 7564.83072073800},
	{0.00000000093, 1.72016321457, 574.34479833480},
	{0.00000000092, 3.49830258795, 9360.08916445900},
	{0.00000000095, 2.09703168525, 10433.69818864980},
	{0.00000000095, 4.25526170853, 9992.87290377220},
	{0.00000000117, 3.09675047102, 12432.04265039780},
	{0.00000000096, 3.75411376182, 220.41264243880},
	{0.00000000110, 5.01502416629, 11802.35844149480},
	{0.00000000108, 3.56320379623, 29580.47470844380},
	{0.00000000093, 4.32292624028, 2957.71589447660},
	{0.00000000094, 6.19217661869, 20433.68463942280},
	{0.00000000097, 4.70823534788, 22805.73556599360},
	{0.00000000084, 4.29266227852, 206.18554843720},
	{0.00000000077, 2.93440992089, 10177.25767953360},
	{0.00000000077, 3.41788347289, 10249.31341288840},
	{0.00000000087, 2.72065485079, 2379.16447357160},
	{0.00000000080, 4.52003698796, 19896.88012732740},
	{0.00000000071, 5.88504650520, 24150.08005134500},
	{0.00000000071, 4.97845884396, 29043.67019634839},
	{0.00000000068, 2.38966490616, 10383.95841683020},
	{0.00000000068, 3.96262848762, 10042.61267559180},
	{0.00000000077, 5.37170501434, 29573.36116144300},
	{0.00000000073, 4.93041743859, 29587.58825544460},
	{0.00000000067, 0.87827389481, 31441.67756975680},
	{0.00000000061, 5.37334569388, 29057.89729034999},
	{0.00000000081, 3.17506116360, 11764.33076885900},
	{0.00000000081, 5.09723714696, 19360.07561523199},
	{0.00000000067, 5.87155987351, 40077.61957352000},
	{0.00000000077, 5.42249781467, 20213.27199698400},
	{0.00000000077, 1.74322642947, 7834.12107263940},
	{0.00000000058, 6.11200668623, 110.20632121940},
	{0.00000000060, 4.64344417198, 30831.30490474460},
	{0.00000000067, 3.14528019429, 17778.11626694899},
	{0.00000000062, 0.02038792256, 26735.94526221320},
	{0.00000000054, 3.33030021242, 19317.19254032860},
	{0.00000000059, 1.67202214793, 9779.57380833420},
	{0.00000000051, 2.54206679415, 29088.81141598500},
	{0.00000000051, 6.18969950383, 27490.69247804480},
	{0.00000000050, 0.18460290148, 10103.07922499160},
	{0.00000000050, 6.16769049230, 10323.49186743040},
	{0.00000000050, 4.63967914172, 39793.76025465480},
	{0.00000000059, 4.81241059013, 2218.75710418680},
	{0.00000000047, 2.05343620014, 20639.87018786000},
	{0.00000000046, 2.74639399772, 19786.67380610799},
	{0.00000000047, 4.18910494546, 57837.13833230060},
	{0.00000000049, 5.28696888326, 26709.64694241340},
	{0.00000000044, 2.82427089648, 29999.95935231900},
	{0.00000000044, 3.83988514830, 33019.02111220460},
	{0.00000000044, 5.38579680438, 16522.65971600220},
	{0.00000000043, 3.56791317771, 29786.66025688100},
	{0.00000000051, 0.93431467650, 44007.82926973960},
	{0.00000000051, 6.00716095198, 13341.67431130680},
	{0.00000000051, 5.84065348173, 13655.86049117640},
	{0.00000000039, 4.20765456607, 20447.34648791440},
	{0.00000000049, 1.86400601956, 25158.60171976540},
	{0.00000000042, 3.20675553761, 38204.68735937100},
	{0.00000000041, 2.07859666220, 3914.95722503460},
	{0.00000000035, 5.19408052685, 36949.23080842420},
	{0.00000000036, 4.38221463656, 10077.66022120100},
	{0.00000000036, 1.97007875722, 10348.91087122100},
	{0.00000000041, 0.04248316951, 27991.40181316000},
	{0.00000000039, 1.66722657698, 18830.38465013739},
	{0.00000000039, 1.44095509312, 30666.15495843280},
	{0.00000000039, 1.17630403927, 18844.61174413899},
	{0.00000000037, 4.90257598448, 19374.30270923360},
	{0.00000000032, 1.54363874459, 17468.85519794540},
	{0.00000000037, 5.13021678677, 49515.38250840700},
	{0.00000000040, 2.31585340283, 47938.03896595920},
	{0.00000000032, 3.92861114802, 16894.51039961060},
	{0.00000000042, 5.08244679686, 55798.45835839840},
	{0.00000000031, 1.66877830319, 21000.91589075680},
	{0.00000000031, 1.94569247568, 20043.67456019880},
	{0.00000000033, 6.15577840084, 48417.97290558199},
	{0.00000000034, 0.55952854816, 54247.41313575040},
	{0.00000000032, 0.55000852758, 10191.43471688460},
	{0.00000000032, 5.80228486620, 10235.13637553740},
	{0.00000000031, 4.45837229281, 8087.40813883180},
	{0.00000000030, 0.39582329080, 10853.18283252500},
	{0.00000000033, 2.51511900155, 7255.56965173440},
	{0.00000000029, 3.64083349524, 10290.95931663900},
	{0.00000000029, 2.71145989854, 10135.61177578300},
	{0.00000000028, 4.16989490843, 104351.61256629678},
	{0.00000000028, 0.27992982935, 40879.44050464380},
	{0.00000000032, 2.59502959120, 20206.15844998319},
	{0.00000000032, 0.89449566883, 66813.56483573320},
	{0.00000000032, 3.80176203654, 9835.91193829520},
	{0.00000000032, 2.55053135724, 10590.65915412680},
	{0.00000000027, 4.68213586027, 6298.32832117640},
	{0.00000000035, 3.77990327166, 9985.80941342200},
	{0.00000000035, 2.57239012212, 10440.76167900000},
	{0.00000000026, 3.20523902336, 34363.36559755600},
	{0.00000000032, 5.77908535567, 11265.55392939940},
	{0.00000000029, 1.74099609995, 30206.14490075619},
	{0.00000000032, 3.71438295524, 51868.24866217880},
	{0.00000000025, 2.53077774895, 3532.06069281140},
	{0.00000000033, 0.22007720629, 59728.66805461800},
	{0.00000000029, 2.13149426586, 20220.38554398480},
	{0.00000000024, 1.14570150294, 8734.41897214660},
	{0.00000000028, 5.75151342282, 62883.35513951360},
	{0.00000000024, 2.78432068759, 36173.70819710020},
	{0.00000000024, 2.85202212155, 31022.75317085620},
	{0.00000000024, 1.83048948732, 24383.07910844140},
	{0.00000000027, 1.25677560111, 30220.37199475780},
	{0.00000000023, 1.14068817117, 10367.06435669580},
	{0.00000000023, 5.21160522261, 10059.50673572620},
	{0.00000000026, 1.22668255838, 39271.18283656100},
	{0.00000000026, 1.70916432914, 39256.95574255939},
	{0.00000000023, 1.65963740543, 44809.65020086340},
	{0.00000000024, 1.93436586234, 14128.24277124560},
	{0.00000000026, 5.25543048954, 8101.63523283340},
	{0.00000000022, 1.35770769295, 24978.52458948080},
	{0.00000000025, 4.35755866572, 52175.80628314840},
	{0.00000000030, 5.92769775641, 17248.42530185440},
	{0.00000000022, 2.63350741660, 43071.89928903080},
	{0.00000000024, 2.87771905446, 34596.36465465240},
	{0.00000000022, 0.18339358050, 30426.55754319500},
	{0.00000000024, 5.00394819251, 47623.85278608960},
	{0.00000000023, 2.48673782346, 27461.71084806540},
	{0.00000000024, 2.31573395875, 70743.77453195279},
	{0.00000000022, 2.50653771933, 9566.27471289620},
	{0.00000000023, 4.03659045702, 6309.37416979120},
	{0.00000000021, 0.48695657465, 10949.16205974280},
	{0.00000000021, 5.86533681913, 9477.40903267920},
	{0.00000000024, 5.27936669763, 10288.06714477830},
	{0.00000000024, 1.07292669615, 10138.50394764370},
	{0.00000000027, 2.11906192246, 9580.50180689780},
	{0.00000000020, 0.64178978255, 11279.78102340100},
	{0.00000000023, 1.10446661612, 10263.04257168280},
	{0.00000000023, 5.24782677766, 10163.52852073920},
	{0.00000000022, 0.81492467590, 46386.99374331120},
	{0.00000000020, 1.20516011145, 18300.69368504279},
	{0.00000000026, 1.64244752119, 63658.87775083760},
	{0.00000000019, 0.23803378346, 20316.36477120259},
	{0.00000000020, 5.63439724563, 62081.53420838980},
	{0.00000000020, 1.13738100407, 49477.35483577119},
	{0.00000000018, 3.04721004004, 48739.85989708300},
	{0.00000000018, 0.69437828159, 9050.81084180320},
	{0.00000000017, 3.19845935674, 28313.28880466100},
	{0.00000000017, 2.89862116564, 10497.14486507620},
	{0.00000000017, 3.45367222814, 9929.42622734580},
	{0.00000000017, 1.80554865966, 24341.52831745660},
	{0.00000000017, 3.41082764288, 38734.37832446560},
	{0.00000000017, 5.48500145482, 19624.75016129820},
	{0.00000000017, 1.42397530088, 18314.92077904440},
	{0.00000000018, 4.74133155662, 42430.48572729180},
	{0.00000000016, 3.86440292184, 9745.32055585660},
	{0.00000000016, 2.48789047194, 10681.25053656540},
	{0.00000000015, 3.83207526863, 10199.05845220940},
	{0.00000000015, 2.52021812515, 10227.51264021260},
	{0.00000000019, 5.68038426151, 55022.93574707440},
	{0.00000000015, 5.64700993390, 27197.28169366760},
	{0.00000000014, 5.96767163228, 41654.96311596780},
	{0.00000000015, 1.13326219925, 53285.18483524180},
	{0.00000000015, 0.77488131034, 66011.74390460939},
	{0.00000000015, 1.26648472710, 38727.26477746480},
	{0.00000000015, 6.23108278461, 46360.69542351140},
	{0.00000000016, 5.66380096786, 42456.78404709160},
	{0.00000000019, 3.03299422296, 67589.08744705719},
	{0.00000000014, 5.08678738606, 39999.94580309200},
	{0.00000000014, 6.23973256044, 11026.83583017080},
	{0.00000000014, 0.11256083334, 9399.73526225120},
	{0.00000000015, 4.29556829645, 38526.57435087200},
	{0.00000000016, 2.23316987672, 50317.20343953080},
	{0.00000000014, 6.10752868717, 37895.42629036740},
	{0.00000000014, 6.16126093965, 37410.56723987860},
	{0.00000000014, 1.37134390822, 50290.90511973100},
	{0.00000000015, 4.65282324499, 21485.95302261119},
	{0.00000000013, 4.57052023792, 52670.06959330260},
	{0.00000000013, 4.57568246165, 32243.49850088060},
	{0, 0, 0}
};

struct vsop87_term venus_y2[] = {
	{0.00002007155, 3.14159265359, 0.00000000000},
	{0.00000702052, 3.52724964753, 20426.57109242200},
	{0.00000265709, 4.68091836985, 10213.28554621100},
	{0.00000011646, 3.93744761819, 30639.85663863300},
	{0.00000008639, 1.13135823620, 10186.98722641120},
	{0.00000008604, 5.22297159997, 10239.58386601080},
	{0.00000003811, 5.48798160948, 9437.76293488700},
	{0.00000002807, 1.65676292385, 8635.94200376320},
	{0.00000003369, 0.86189885486, 10988.80815753500},
	{0.00000002200, 2.17699710464, 10021.83728009940},
	{0.00000002289, 4.69814874247, 11790.62908865880},
	{0.00000002148, 4.17521761989, 10404.73381232260},
	{0.00000001696, 5.08313144954, 775.52261132400},
	{0.00000000716, 6.06671484212, 9830.38901398780},
	{0.00000000644, 0.22734493457, 4705.73230754360},
	{0.00000000682, 0.28558057356, 10596.18207843420},
	{0.00000000594, 1.23861380027, 19651.04848109800},
	{0.00000000554, 4.44452698973, 191.44826611160},
	{0.00000000528, 3.41861650599, 9683.59458111640},
	{0.00000000527, 2.94644114647, 10742.97651130560},
	{0.00000000566, 0.35292137179, 801.82093112380},
	{0.00000000525, 5.72227596543, 7058.59846131540},
	{0.00000000328, 6.11646091965, 15720.83878487840},
	{0.00000000358, 2.02954020915, 11015.10647733480},
	{0.00000000286, 1.68423535567, 9103.90699411760},
	{0.00000000362, 4.34706999662, 9411.46461508720},
	{0.00000000299, 3.84462203798, 26.29831979980},
	{0.00000000359, 0.61996179973, 13367.97263110660},
	{0.00000000250, 4.66823756637, 11322.66409830440},
	{0.00000000239, 5.77307549832, 3154.68708489560},
	{0.00000000301, 4.25962414255, 3128.38876509580},
	{0.00000000191, 2.03616386440, 1059.38193018920},
	{0.00000000190, 0.21249868991, 10426.58464164900},
	{0.00000000190, 6.13979470387, 9999.98645077300},
	{0.00000000192, 4.62315723240, 20618.01935853360},
	{0.00000000179, 0.42909787895, 21228.39202354580},
	{0.00000000156, 4.63001323046, 40853.14218484400},
	{0.00000000162, 0.68333343155, 382.89653222320},
	{0.00000000125, 1.07117378709, 18849.22754997420},
	{0.00000000142, 5.97606134065, 1577.34354244780},
	{0.00000000110, 2.14128325211, 8624.21265092720},
	{0.00000000141, 2.93513683988, 7860.41939243920},
	{0.00000000109, 4.55956211819, 2352.86615377180},
	{0.00000000134, 2.07232763439, 17298.18232732620},
	{0.00000000115, 4.27710770643, 20452.86941222180},
	{0.00000000076, 0.89056324144, 7084.89678111520},
	{0.00000000071, 5.87255690826, 23581.25817731760},
	{0.00000000064, 4.23014249947, 19367.18916223280},
	{0.00000000063, 0.19465269649, 1109.37855209340},
	{0.00000000074, 1.59098773305, 16496.36139620240},
	{0.00000000061, 2.45374361751, 9153.90361602180},
	{0.00000000063, 2.58253929093, 18073.70493865020},
	{0.00000000054, 0.79386600924, 20809.46762464520},
	{0.00000000043, 2.21625350053, 29050.78374334920},
	{0.00000000055, 1.81114570337, 4732.03062734340},
	{0.00000000043, 1.72253634885, 8094.52168583260},
	{0.00000000049, 4.77430806005, 3930.20969621960},
	{0.00000000044, 3.53454344950, 9638.94074787620},
	{0.00000000044, 2.81774994428, 10787.63034454580},
	{0.00000000046, 0.97289096935, 22003.91463486980},
	{0.00000000039, 0.53727814725, 6283.07584999140},
	{0.00000000043, 3.41770981695, 12566.15169998280},
	{0.00000000033, 5.75412898458, 14919.01785375460},
	{0.00000000037, 3.04751770033, 8662.24032356300},
	{0.00000000028, 2.28310684992, 20235.12282631040},
	{0.00000000033, 5.70769321932, 6489.77658728800},
	{0.00000000027, 5.52864193077, 10639.88373708700},
	{0.00000000027, 0.82365146301, 9786.68735533500},
	{0.00000000029, 3.29953382621, 28286.99048486120},
	{0.00000000030, 1.80392203545, 24356.78078864160},
	{0.00000000026, 5.34455326161, 3149.16416058820},
	{0.00000000027, 0.29620716954, 14143.49524243060},
	{0.00000000030, 2.30925665899, 20400.27277262220},
	{0.00000000026, 2.03778959040, 18875.52586977400},
	{0.00000000024, 3.73809869847, 11272.66747640020},
	{0.00000000024, 1.05266162760, 27511.46787353720},
	{0.00000000024, 0.28968474189, 21535.94964451540},
	{0.00000000022, 1.57206710017, 18307.80723204360},
	{0.00000000025, 4.18795706116, 5507.55323866740},
	{0.00000000023, 0.64543351157, 13936.79450513400},
	{0.00000000018, 1.79009115313, 28521.09277825460},
	{0.00000000014, 1.62650115265, 21202.09370374600},
	{0.00000000014, 1.00989513563, 17277.40693183380},
	{0.00000000014, 3.69383400063, 11764.33076885900},
	{0.00000000016, 1.34949765828, 32217.20018108080},
	{0.00000000013, 0.36409212654, 34570.06633485260},
	{0.00000000013, 5.39780269855, 22779.43724619380},
	{0.00000000011, 3.20491922374, 25934.12433108940},
	{0.00000000012, 2.32661613460, 31441.67756975680},
	{0.00000000015, 2.03363077483, 29580.47470844380},
	{0.00000000012, 1.93485474982, 25158.60171976540},
	{0.00000000010, 3.93946468852, 14945.31617355440},
	{0.00000000009, 1.78868782927, 38500.27603107220},
	{0.00000000009, 3.39001858921, 29088.81141598500},
	{0.00000000007, 3.45037167055, 22805.73556599360},
	{0.00000000007, 0.37787568636, 43232.30665841560},
	{0.00000000007, 1.23251889653, 9573.38825989700},
	{0.00000000007, 4.44320821952, 29999.95935231900},
	{0.00000000007, 1.83420571334, 30110.16567353840},
	{0, 0, 0}
};

struct vsop87_term venus_y3[] = {
	{0.00000022966, 0.38709241285, 10213.28554621100},
	{0.00000024860, 1.68572825734, 20426.57109242200},
	{0.00000003743, 3.14159265359, 0.00000000000},
	{0.00000000623, 1.67630174215, 30639.85663863300},
	{0.00000000009, 2.15288290431, 40853.14218484400},
	{0, 0, 0}
};

struct vsop87_term venus_y4[] = {
	{0.00000000801, 2.03074942043, 10213.28554621100},
	{0.00000000690, 0.00000000000, 0.00000000000},
	{0.00000000286, 5.64884337944, 20426.57109242200},
	{0.00000000030, 5.69980612910, 30639.85663863300},
	{0, 0, 0}
};

struct vsop87_term venus_y5[] = {
	{0.00000000029, 3.51424873779, 10213.28554621100},
	{0.00000000022, 5.05580482246, 20426.57109242200},
	{0.00000000018, 0.00000000000, 0.00000000000},
	{0, 0, 0}
};

struct vsop87_term venus_z0[] = {
	{0.04282990302, 0.26703856476, 10213.28554621100},
	{0.00035588343, 3.14159265359, 0.00000000000},
	{0.00014501879, 1.14696911390, 20426.57109242200},
	{0.00000140675, 0.85984113219, 1577.34354244780},
	{0.00000134921, 3.70465787853, 2352.86615377180},
	{0.00000095750, 3.66962547073, 9437.76293488700},
	{0.00000072910, 1.55750278240, 9153.90361602180},
	{0.00000073654, 2.02778434780, 30639.85663863300},
	{0.00000059714, 6.25390371649, 18073.70493865020},
	{0.00000045307, 2.28075620268, 5507.55323866740},
	{0.00000043023, 3.95620233472, 529.69096509460},
	{0.00000037415, 4.53900359933, 22003.91463486980},
	{0.00000032943, 0.72316171903, 10239.58386601080},
	{0.00000028156, 2.93415727239, 10186.98722641120},
	{0.00000032447, 3.86196252330, 8635.94200376320},
	{0.00000027853, 6.12790511758, 11790.62908865880},
	{0.00000023013, 0.98699428893, 775.52261132400},
	{0.00000019425, 5.12759462747, 6283.07584999140},
	{0.00000016289, 2.90852685195, 10988.80815753500},
	{0.00000015382, 5.98588709813, 19896.88012732740},
	{0.00000015507, 2.00401259454, 13367.97263110660},
	{0.00000012412, 4.13644030917, 10021.83728009940},
	{0.00000013004, 4.83195492470, 14143.49524243060},
	{0.00000010730, 5.61235409382, 10404.73381232260},
	{0.00000010336, 2.75167531541, 191.44826611160},
	{0.00000010848, 3.29419910254, 11015.10647733480},
	{0.00000009775, 1.21418881204, 8624.21265092720},
	{0.00000010158, 5.71954183827, 9683.59458111640},
	{0.00000008080, 2.69831049093, 19651.04848109800},
	{0.00000008209, 3.55371021890, 10742.97651130560},
	{0.00000006416, 0.46264840234, 9786.68735533500},
	{0.00000006429, 4.91481073656, 1059.38193018920},
	{0.00000006722, 2.41848486045, 4705.73230754360},
	{0.00000005903, 5.96215831403, 25934.12433108940},
	{0.00000005647, 3.57594715836, 3154.68708489560},
	{0.00000004044, 6.24650537722, 11322.66409830440},
	{0.00000004033, 3.42887820794, 9103.90699411760},
	{0.00000004210, 4.99232132925, 7084.89678111520},
	{0.00000004135, 3.43782832503, 17298.18232732620},
	{0.00000003747, 1.30318722019, 15720.83878487840},
	{0.00000003417, 3.95474989164, 7860.41939243920},
	{0.00000003440, 0.77140273510, 4551.95349705880},
	{0.00000003488, 0.14633368219, 20618.01935853360},
	{0.00000002851, 5.68591706153, 10206.17199921020},
	{0.00000002750, 3.89497095361, 10192.51015071860},
	{0.00000002734, 5.62996472233, 12566.15169998280},
	{0.00000002682, 4.58018033496, 801.82093112380},
	{0.00000002743, 6.06387494803, 10234.06094170340},
	{0.00000002832, 4.24241233220, 213.29909543800},
	{0.00000002756, 5.43236957664, 29580.47470844380},
	{0.00000002155, 0.29731467355, 9411.46461508720},
	{0.00000002403, 4.90533210845, 19367.18916223280},
	{0.00000002103, 1.12514771936, 29864.33402730900},
	{0.00000001632, 4.67123397256, 1109.37855209340},
	{0.00000001787, 2.52506338741, 15874.61759536320},
	{0.00000001613, 1.47525165805, 7058.59846131540},
	{0.00000001598, 2.21757389250, 10426.58464164900},
	{0.00000001154, 1.98818396175, 26.29831979980},
	{0.00000001132, 5.38517603552, 7.11354700080},
	{0.00000001468, 0.75541488791, 9999.98645077300},
	{0.00000001118, 0.96571599573, 23581.25817731760},
	{0.00000001210, 3.17717646354, 3532.06069281140},
	{0.00000000965, 0.01161931809, 3128.38876509580},
	{0.00000001027, 2.51592691800, 33794.54372352860},
	{0.00000000847, 1.24888706950, 9573.38825989700},
	{0.00000000889, 1.48214942791, 9830.38901398780},
	{0.00000000953, 5.73118460251, 20213.27199698400},
	{0.00000000987, 4.70495944427, 14945.31617355440},
	{0.00000001030, 0.84929643011, 8094.52168583260},
	{0.00000000770, 4.54196353475, 21228.39202354580},
	{0.00000000778, 1.16378510983, 8662.24032356300},
	{0.00000000860, 5.74281955136, 5661.33204915220},
	{0.00000000670, 5.36864204589, 1589.07289528380},
	{0.00000000615, 1.96289781619, 26087.90314157420},
	{0.00000000740, 1.97614280765, 10596.18207843420},
	{0.00000000606, 6.22070159607, 25158.60171976540},
	{0.00000000533, 0.73765107493, 28286.99048486120},
	{0.00000000547, 5.06653964506, 29050.78374334920},
	{0.00000000592, 3.32632513186, 3340.61242669980},
	{0.00000000591, 4.62374022159, 9929.42622734580},
	{0.00000000537, 6.00327539255, 4732.03062734340},
	{0.00000000569, 5.37276655331, 10497.14486507620},
	{0.00000000520, 6.11596800207, 10218.80847051840},
	{0.00000000542, 3.94171539558, 37724.75341974820},
	{0.00000000575, 2.29073875885, 21535.94964451540},
	{0.00000000437, 2.42330391120, 10251.31321884680},
	{0.00000000439, 2.90237828484, 40853.14218484400},
	{0.00000000459, 1.69153061401, 3930.20969621960},
	{0.00000000405, 1.42927875873, 9161.01716302260},
	{0.00000000418, 5.48110803243, 32217.20018108080},
	{0.00000000521, 3.84286345199, 10207.76262190360},
	{0.00000000457, 6.16974742379, 10220.39909321180},
	{0.00000000440, 1.25236241968, 10175.25787357520},
	{0.00000000394, 4.81650684498, 9146.79006902100},
	{0.00000000362, 0.02259543121, 14765.23904326980},
	{0.00000000396, 4.56209231282, 10063.72234907640},
	{0.00000000407, 6.15731262846, 18875.52586977400},
	{0.00000000349, 5.78507522549, 12592.45001978260},
	{0.00000000379, 4.56511543982, 20419.45754542119},
	{0.00000000314, 5.08259050420, 18837.49819713819},
	{0.00000000343, 2.36516734231, 27511.46787353720},
	{0.00000000292, 3.76618455555, 6681.22485339960},
	{0.00000000289, 3.59841384736, 11272.66747640020},
	{0.00000000314, 5.23220905264, 426.59819087600},
	{0.00000000301, 4.24971815099, 14919.01785375460},
	{0.00000000322, 1.36846420067, 29088.81141598500},
	{0.00000000292, 0.74997511570, 3149.16416058820},
	{0.00000000306, 0.47092243462, 23958.63178523340},
	{0.00000000254, 4.34026574490, 10137.01947493540},
	{0.00000000304, 5.33181632059, 41654.96311596780},
	{0.00000000264, 0.01153452145, 20452.86941222180},
	{0.00000000334, 5.28920083729, 382.89653222320},
	{0.00000000236, 1.03442196051, 22779.43724619380},
	{0.00000000250, 5.05395469123, 24356.78078864160},
	{0.00000000278, 0.10022232617, 16496.36139620240},
	{0.00000000232, 0.48064662619, 17085.95866572220},
	{0.00000000205, 6.19639409918, 7064.12138562280},
	{0.00000000197, 3.71380377240, 1551.04522264800},
	{0.00000000200, 4.06516779510, 18849.22754997420},
	{0.00000000170, 5.96522395118, 10198.03307502600},
	{0.00000000170, 3.52866583267, 10228.53801739600},
	{0.00000000180, 0.48168923159, 45585.17281218740},
	{0.00000000144, 2.81280885697, 17277.40693183380},
	{0.00000000177, 3.58248029244, 20400.27277262220},
	{0.00000000170, 3.72282190488, 31441.67756975680},
	{0.00000000166, 0.03569768750, 13745.34623902240},
	{0.00000000127, 5.14389302386, 5481.25491886760},
	{0.00000000138, 1.19253977825, 22805.73556599360},
	{0.00000000126, 4.21594185374, 20956.26205751660},
	{0.00000000118, 1.71706550416, 13341.67431130680},
	{0.00000000131, 0.92317994329, 3442.57494496540},
	{0.00000000137, 2.89407950366, 33019.02111220460},
	{0.00000000104, 2.47347358674, 26709.64694241340},
	{0.00000000127, 0.46833130674, 536.80451209540},
	{0.00000000126, 2.84049662693, 9967.45389998160},
	{0.00000000107, 4.19045394315, 19999.97290154599},
	{0.00000000110, 0.73944778374, 30110.16567353840},
	{0.00000000138, 4.01403107693, 21202.09370374600},
	{0.00000000121, 3.85928223786, 522.57741809380},
	{0.00000000122, 0.37000676558, 10459.11719244040},
	{0.00000000095, 5.25435135477, 30213.25844775700},
	{0.00000000099, 5.61149803116, 10529.67741586760},
	{0.00000000106, 2.42064996718, 20809.46762464520},
	{0.00000000095, 3.11317801589, 9896.89367655440},
	{0.00000000085, 5.88248062550, 3723.50895892300},
	{0.00000000099, 1.93329637732, 49515.38250840700},
	{0.00000000084, 4.93745373910, 52175.80628314840},
	{0.00000000086, 0.85755223960, 2379.16447357160},
	{0.00000000114, 5.11309629210, 103.09277421860},
	{0.00000000110, 1.44699918003, 43232.30665841560},
	{0.00000000088, 1.59017183044, 10110.19277199240},
	{0.00000000086, 0.87055324194, 16522.65971600220},
	{0.00000000089, 2.33714216061, 10316.37832042960},
	{0.00000000098, 4.66807552803, 20235.12282631040},
	{0.00000000104, 5.02724740402, 35371.88726597640},
	{0.00000000093, 4.21356144460, 36301.18868778519},
	{0.00000000089, 0.88060757437, 6489.77658728800},
	{0.00000000083, 2.07543775594, 31749.23519072640},
	{0.00000000096, 2.90682399304, 9793.80090233580},
	{0.00000000078, 2.65839634325, 10232.95530711079},
	{0.00000000078, 0.55230439694, 10193.61578531121},
	{0.00000000092, 5.63110477712, 10288.06714477830},
	{0.00000000092, 3.86278127025, 10138.50394764370},
	{0.00000000090, 4.34324193073, 36949.23080842420},
	{0.00000000073, 2.56775245907, 13936.79450513400},
	{0.00000000071, 0.64943236639, 20.77539549240},
	{0.00000000090, 0.07319663423, 6872.67311951120},
	{0.00000000069, 1.52914774412, 9690.70812811720},
	{0.00000000086, 1.02476175384, 65236.22129328540},
	{0.00000000079, 1.65446145032, 39264.06928956020},
	{0.00000000071, 0.70714638996, 36147.40987730040},
	{0.00000000071, 2.52879760001, 26735.94526221320},
	{0.00000000061, 5.47943297658, 11764.33076885900},
	{0.00000000080, 2.87220602049, 47162.51635463520},
	{0.00000000065, 2.53312656681, 10735.86296430480},
	{0.00000000068, 2.28501865578, 8521.11987670860},
	{0.00000000065, 2.12423586627, 28313.28880466100},
	{0.00000000062, 2.28587915309, 3903.91137641980},
	{0.00000000069, 0.42270579845, 9580.50180689780},
	{0.00000000063, 5.80076678078, 2118.76386037840},
	{0.00000000056, 4.73821324745, 639.89728631400},
	{0.00000000063, 3.35690006984, 53445.59220462660},
	{0.00000000053, 2.14583523296, 8631.32619792800},
	{0.00000000066, 4.12244312057, 28521.09277825460},
	{0.00000000058, 5.25045057985, 10419.47109464820},
	{0.00000000058, 4.23724598221, 10007.09999777380},
	{0.00000000053, 3.02375632858, 19317.19254032860},
	{0.00000000071, 2.36609582367, 74.78159856730},
	{0.00000000062, 2.46239069210, 10846.06928552420},
	{0.00000000061, 3.77333230443, 51868.24866217880},
	{0, 0, 0}
};

struct vsop87_term venus_z1[] = {
	{0.00208096402, 1.88967278742, 10213.28554621100},
	{0.00001264989, 3.71037501321, 20426.57109242200},
	{0.00001364144, 0.00000000000, 0.00000000000},
	{0.00000011139, 4.85437878205, 30639.85663863300},
	{0.00000009557, 2.27891093355, 9437.76293488700},
	{0.00000007822, 5.54315419538, 1577.34354244780},
	{0.00000005390, 5.37203588853, 2352.86615377180},
	{0.00000005760, 0.27988422334, 9153.90361602180},
	{0.00000004681, 5.23427572089, 10186.98722641120},
	{0.00000003589, 1.59383779306, 11790.62908865880},
	{0.00000003297, 0.73050419137, 5507.55323866740},
	{0.00000003681, 4.17406921354, 10239.58386601080},
	{0.00000002395, 1.34531028758, 10404.73381232260},
	{0.00000002557, 1.61905357827, 18073.70493865020},
	{0.00000002079, 5.59900440541, 529.69096509460},
	{0.00000001893, 5.04556374323, 10988.80815753500},
	{0.00000001957, 6.14586118921, 22003.91463486980},
	{0.00000001749, 1.72876483551, 8635.94200376320},
	{0.00000001361, 0.40192228967, 13367.97263110660},
	{0.00000001159, 2.31994412916, 10021.83728009940},
	{0.00000001060, 4.40549998074, 19651.04848109800},
	{0.00000001026, 5.05449603850, 775.52261132400},
	{0.00000000894, 6.18769608247, 7860.41939243920},
	{0.00000000686, 1.37692807485, 19896.88012732740},
	{0.00000000741, 3.15293239238, 6283.07584999140},
	{0.00000000559, 0.63256033185, 8624.21265092720},
	{0.00000000531, 1.77610826151, 11322.66409830440},
	{0.00000000415, 3.00153763564, 15720.83878487840},
	{0.00000000390, 5.10646391319, 9786.68735533500},
	{0.00000000440, 1.71617898465, 20618.01935853360},
	{0.00000000426, 2.83056359378, 14143.49524243060},
	{0.00000000382, 0.29076532255, 4705.73230754360},
	{0.00000000372, 1.80541993350, 17298.18232732620},
	{0.00000000369, 1.25931663640, 25934.12433108940},
	{0.00000000278, 4.22437893192, 191.44826611160},
	{0.00000000268, 1.81731580128, 1059.38193018920},
	{0.00000000296, 0.68834496754, 19367.18916223280},
	{0.00000000325, 0.20788633679, 11015.10647733480},
	{0.00000000316, 2.29565820718, 10742.97651130560},
	{0.00000000231, 6.23978632212, 9830.38901398780},
	{0.00000000305, 3.73514346008, 10596.18207843420},
	{0.00000000230, 4.92924491630, 3930.20969621960},
	{0.00000000233, 2.14466305631, 801.82093112380},
	{0.00000000207, 1.90716961392, 9103.90699411760},
	{0.00000000253, 2.27887468784, 9999.98645077300},
	{0.00000000193, 2.68584410734, 23581.25817731760},
	{0.00000000198, 2.61036398872, 9411.46461508720},
	{0.00000000169, 3.65397698917, 7.11354700080},
	{0.00000000173, 3.75026764989, 7058.59846131540},
	{0.00000000199, 4.79364893479, 10206.17199921020},
	{0.00000000153, 5.90450931307, 3154.68708489560},
	{0.00000000180, 3.65160439089, 21228.39202354580},
	{0.00000000166, 3.22481107463, 12566.15169998280},
	{0.00000000138, 6.13843515618, 9161.01716302260},
	{0.00000000147, 4.40417469081, 10220.39909321180},
	{0.00000000148, 1.39050905939, 10234.06094170340},
	{0.00000000127, 6.11794706117, 10426.58464164900},
	{0.00000000139, 2.69109384056, 29864.33402730900},
	{0.00000000120, 5.56979067201, 10192.51015071860},
	{0.00000000137, 5.85513359031, 213.29909543800},
	{0.00000000132, 0.65236823857, 29580.47470844380},
	{0.00000000148, 5.78273623919, 26.29831979980},
	{0.00000000110, 1.54178765941, 9683.59458111640},
	{0.00000000147, 4.38575949385, 15874.61759536320},
	{0.00000000099, 1.18053788195, 7084.89678111520},
	{0.00000000097, 5.83350659322, 40853.14218484400},
	{0.00000000103, 2.37976615570, 3128.38876509580},
	{0.00000000097, 4.64659904732, 25158.60171976540},
	{0.00000000092, 0.17084455774, 9146.79006902100},
	{0.00000000077, 1.60206102260, 10207.76262190360},
	{0.00000000077, 1.60857575234, 10218.80847051840},
	{0.00000000078, 5.16888914284, 8662.24032356300},
	{0.00000000086, 5.48266928025, 37724.75341974820},
	{0.00000000072, 2.49760315888, 4551.95349705880},
	{0.00000000079, 6.07206626858, 20419.45754542119},
	{0.00000000070, 5.55011021099, 5661.33204915220},
	{0.00000000074, 0.74329919338, 382.89653222320},
	{0.00000000075, 4.01698827629, 33794.54372352860},
	{0.00000000074, 6.21974610833, 18837.49819713819},
	{0.00000000062, 1.21365119312, 10198.03307502600},
	{0.00000000062, 1.99704954707, 10228.53801739600},
	{0.00000000056, 0.16985541402, 14919.01785375460},
	{0.00000000057, 0.62155717729, 41654.96311596780},
	{0.00000000049, 3.44789037675, 28286.99048486120},
	{0.00000000048, 2.58976541849, 22779.43724619380},
	{0.00000000043, 5.29403475475, 3149.16416058820},
	{0.00000000044, 3.34917429540, 11272.66747640020},
	{0.00000000046, 1.96987893116, 426.59819087600},
	{0.00000000053, 1.80084365566, 45585.17281218740},
	{0.00000000037, 4.19631930368, 27511.46787353720},
	{0.00000000049, 1.74739410911, 3532.06069281140},
	{0.00000000036, 0.04372461247, 20400.27277262220},
	{0.00000000033, 2.63152688250, 16496.36139620240},
	{0.00000000037, 5.05563683620, 536.80451209540},
	{0.00000000035, 3.59004163922, 21535.94964451540},
	{0.00000000044, 0.78654424919, 20213.27199698400},
	{0.00000000033, 6.02490547159, 21202.09370374600},
	{0.00000000036, 5.54416488475, 522.57741809380},
	{0.00000000038, 6.19285352338, 29088.81141598500},
	{0.00000000031, 1.57491569709, 32217.20018108080},
	{0.00000000029, 3.64911521641, 20452.86941222180},
	{0.00000000027, 1.46263510852, 8094.52168583260},
	{0.00000000034, 4.19685270992, 13341.67431130680},
	{0.00000000028, 0.28339069792, 29050.78374334920},
	{0.00000000031, 1.20392434392, 12592.45001978260},
	{0.00000000031, 1.27304383227, 33019.02111220460},
	{0.00000000036, 3.22618486892, 49515.38250840700},
	{0.00000000028, 3.70748385631, 4732.03062734340},
	{0, 0, 0}
};

struct vsop87_term venus_z2[] = {
	{0.00009148044, 3.34791005272, 10213.28554621100},
	{0.00000163977, 0.00000000000, 0.00000000000},
	{0.00000013554, 5.33914310904, 20426.57109242200},
	{0.00000000683, 0.01279354578, 10186.98722641120},
	{0.00000000540, 4.13666778984, 10239.58386601080},
	{0.00000000471, 1.76796792110, 30639.85663863300},
	{0.00000000304, 6.04133491762, 10988.80815753500},
	{0.00000000275, 3.26254603491, 11790.62908865880},
	{0.00000000303, 0.54544143559, 2352.86615377180},
	{0.00000000241, 6.17158812425, 9437.76293488700},
	{0.00000000282, 4.03266493057, 1577.34354244780},
	{0.00000000238, 2.83008439932, 10404.73381232260},
	{0.00000000259, 5.13154893421, 9153.90361602180},
	{0.00000000117, 5.42784121915, 5507.55323866740},
	{0.00000000091, 6.04946077734, 19651.04848109800},
	{0.00000000094, 3.15707903458, 18073.70493865020},
	{0.00000000071, 0.79640279433, 10021.83728009940},
	{0.00000000087, 5.24030699307, 13367.97263110660},
	{0.00000000095, 0.59412563032, 529.69096509460},
	{0.00000000075, 0.23631944253, 8635.94200376320},
	{0.00000000069, 1.12472727399, 22003.91463486980},
	{0.00000000050, 4.62591678818, 15720.83878487840},
	{0.00000000062, 2.52935211512, 9683.59458111640},
	{0.00000000039, 3.30445248741, 11322.66409830440},
	{0.00000000053, 5.25641571023, 10596.18207843420},
	{0.00000000048, 3.80682230141, 775.52261132400},
	{0.00000000041, 4.19285341280, 14143.49524243060},
	{0.00000000038, 4.71787306716, 7058.59846131540},
	{0.00000000029, 4.73183895530, 9830.38901398780},
	{0.00000000038, 1.87932224242, 801.82093112380},
	{0.00000000034, 2.62408666722, 19896.88012732740},
	{0.00000000023, 2.90537821537, 6283.07584999140},
	{0.00000000025, 2.85904964714, 9411.46461508720},
	{0.00000000022, 2.31119555973, 18849.22754997420},
	{0.00000000018, 4.95998579326, 4705.73230754360},
	{0.00000000019, 3.25100262086, 20618.01935853360},
	{0.00000000016, 0.53259218563, 10206.17199921020},
	{0.00000000016, 5.81970120815, 10220.39909321180},
	{0.00000000017, 5.41171132064, 26.29831979980},
	{0.00000000015, 4.61555386478, 9999.98645077300},
	{0.00000000015, 4.88064054230, 10426.58464164900},
	{0.00000000021, 0.31827807970, 11015.10647733480},
	{0.00000000015, 6.18636933791, 191.44826611160},
	{0.00000000016, 3.94104051711, 10742.97651130560},
	{0.00000000017, 2.69405014279, 3128.38876509580},
	{0, 0, 0}
};

struct vsop87_term venus_z3[] = {
	{0.00000272005, 4.87648116140, 10213.28554621100},
	{0.00000013656, 3.14159265359, 0.00000000000},
	{0.00000001743, 0.42985032723, 20426.57109242200},
	{0.00000000033, 1.54914240166, 10186.98722641120},
	{0.00000000025, 5.78743368814, 10239.58386601080},
	{0.00000000015, 0.26812223508, 30639.85663863300},
	{0.00000000010, 5.48827753353, 9437.76293488700},
	{0.00000000008, 4.60069153442, 11790.62908865880},
	{0.00000000010, 1.90027732701, 2352.86615377180},
	{0.00000000009, 0.86239699726, 10988.80815753500},
	{0, 0, 0}
};

struct vsop87_term venus_z4[] = {
	{0.00000006175, 0.17121460361, 10213.28554621100},
	{0.00000000125, 3.14159265359, 0.00000000000},
	{0.00000000041, 2.50364136928, 20426.57109242200},
	{0, 0, 0}
};

struct vsop87_term venus_z5[] = {
	{0.00000000108, 1.67439739641, 10213.28554621100},
	{0.00000000025, 0.00000000000, 0.00000000000},
	{0.00000000003, 3.66751123903, 20426.57109242200},
	{0, 0, 0}
};

struct vsop87_term earth_x0[] = {
	{0.99982928844, 1.75348568475, 6283.07584999140},
	{0.00835257300, 1.71034539450, 12566.15169998280},
	{0.00561144206, 0.00000000000, 0.00000000000},
	{0.00010466628, 1.66722645223, 18849.22754997420},
	{0.00003110838, 0.66875185215, 83996.84731811189},
	{0.00002552498, 0.58310207301, 529.69096509460},
	{0.00002137256, 1.09235189672, 1577.34354244780},
	{0.00001709103, 0.49540223397, 6279.55273164240},
	{0.00001707882, 6.15315547484, 6286.59896834040},
	{0.00001445242, 3.47272783760, 2352.86615377180},
	{0.00001091006, 3.68984782465, 5223.69391980220},
	{0.00000934429, 6.07389922585, 12036.46073488820},
	{0.00000899144, 3.17571950523, 10213.28554621100},
	{0.00000566514, 2.15262034016, 1059.38193018920},
	{0.00000684416, 1.30699021227, 5753.38488489680},
	{0.00000734455, 4.35500196530, 398.14900340820},
	{0.00000681437, 2.21821534685, 4705.73230754360},
	{0.00000611238, 5.38479234323, 6812.76681508600},
	{0.00000451836, 6.08768280868, 5884.92684658320},
	{0.00000451953, 1.27933728354, 6256.77753019160},
	{0.00000449517, 5.36923831714, 6309.37416979120},
	{0.00000406248, 0.54361367084, 6681.22485339960},
	{0.00000540957, 0.78677364655, 775.52261132400},
	{0.00000547004, 1.46146650376, 14143.49524243060},
	{0.00000520484, 4.43295799975, 7860.41939243920},
	{0.00000214960, 4.50213844573, 11506.76976979360},
	{0.00000227892, 1.23941482802, 7058.59846131540},
	{0.00000225878, 3.27244306207, 4694.00295470760},
	{0.00000255820, 2.26556277246, 12168.00269657460},
	{0.00000256182, 1.45474116190, 709.93304855830},
	{0.00000178120, 2.96205424204, 796.29800681640},
	{0.00000161205, 1.47337718956, 5486.77784317500},
	{0.00000178325, 6.24374704602, 6283.14316029419},
	{0.00000178325, 0.40466470869, 6283.00853968860},
	{0.00000155487, 1.62409309523, 25132.30339996560},
	{0.00000209024, 5.85207528073, 11790.62908865880},
	{0.00000199971, 4.07209938245, 17789.84561978500},
	{0.00000128933, 5.21693314150, 7079.37385680780},
	{0.00000128099, 4.80182882228, 3738.76143010800},
	{0.00000151691, 0.86921639327, 213.29909543800},
	{0.00000094483, 4.60187620729, 10977.07880469900},
	{0.00000077801, 1.84444797200, 8827.39026987480},
	{0.00000077277, 3.58396027325, 5507.55323866740},
	{0.00000073493, 2.69522392584, 1589.07289528380},
	{0.00000065359, 3.65156347970, 11769.85369316640},
	{0.00000063240, 2.24124130944, 6262.30045449900},
	{0.00000062961, 4.40729381941, 6303.85124548380},
	{0.00000085870, 3.02430773140, 167283.76158766549},
	{0.00000082957, 6.19254908840, 3340.61242669980},
	{0.00000079201, 2.49366716519, 6069.77675455340},
	{0.00000060048, 3.39951805979, 4136.91043351620},
	{0.00000062119, 2.01472298915, 7.11354700080},
	{0.00000075601, 4.15956023781, 6496.37494542940},
	{0.00000067771, 4.03416283669, 9437.76293488700},
	{0.00000053715, 1.56222706033, 1194.44701022460},
	{0.00000057574, 2.67881766950, 6282.09552892320},
	{0.00000057574, 3.96971590315, 6284.05617105960},
	{0.00000051129, 1.31255522350, 6290.18939699220},
	{0.00000050529, 5.34827650648, 6275.96230299060},
	{0.00000049613, 2.64370071484, 6127.65545055720},
	{0.00000048085, 4.00886197380, 6438.49624942560},
	{0.00000057340, 3.79459979103, 3154.68708489560},
	{0.00000047378, 6.10705175562, 3128.38876509580},
	{0.00000048104, 4.77180566934, 801.82093112380},
	{0.00000041149, 3.32726302190, 8429.24126646660},
	{0.00000052309, 5.30571599873, 13367.97263110660},
	{0.00000051321, 5.78450026632, 12352.85260454480},
	{0.00000050648, 2.05206551992, 11856.21865142450},
	{0.00000043381, 3.64501749522, 17260.15465469040},
	{0.00000039554, 4.93022392385, 5481.25491886760},
	{0.00000048969, 0.45418080759, 9225.53927328300},
	{0.00000047568, 3.16123585999, 5856.47765911540},
	{0.00000047271, 0.62147119447, 2544.31441988340},
	{0.00000037987, 3.04100734504, 426.59819087600},
	{0.00000032481, 0.80957263520, 3930.20969621960},
	{0.00000032559, 1.97427864771, 2146.16541647520},
	{0.00000032521, 2.84566871337, 4164.31198961300},
	{0.00000032546, 3.01796808307, 5088.62883976680},
	{0.00000028515, 6.10933021271, 12569.67481833180},
	{0.00000036898, 2.91097134183, 18073.70493865020},
	{0.00000024936, 2.17935828787, 26.29831979980},
	{0.00000030322, 1.99340330773, 4535.05943692440},
	{0.00000028166, 0.48127325250, 12562.62858163380},
	{0.00000021880, 5.12635088590, 11371.70468975820},
	{0.00000021642, 4.63524156478, 12559.03815298200},
	{0.00000020480, 1.46713660207, 7084.89678111520},
	{0.00000026112, 0.30447108865, 71430.69561812909},
	{0.00000022867, 4.76437399404, 8031.09226305840},
	{0.00000018593, 3.38415795860, 1748.01641306700},
	{0.00000023250, 6.19030311409, 18319.53658487960},
	{0.00000017104, 0.58684867006, 4933.20844033260},
	{0.00000021687, 4.30348901447, 10447.38783960440},
	{0.00000021065, 3.80028088787, 7477.52286021600},
	{0.00000014285, 1.29528607840, 2942.46342329160},
	{0.00000013898, 4.59171958613, 8635.94200376320},
	{0.00000019220, 0.49428010004, 17298.18232732620},
	{0.00000018884, 2.42694414831, 156137.47598479928},
	{0.00000017889, 0.15750451509, 1592.59601363280},
	{0.00000013605, 5.19721055627, 13095.84266507740},
	{0.00000015049, 3.12084096050, 16496.36139620240},
	{0.00000013852, 6.16243027421, 7632.94325965020},
	{0.00000014421, 1.43791851415, 20426.57109242200},
	{0.00000013247, 3.60768174652, 12139.55350910680},
	{0.00000011583, 5.46076026245, 5331.35744374080},
	{0.00000014329, 6.02791958133, 7342.45778018060},
	{0.00000012375, 3.10941923273, 6279.48542133960},
	{0.00000012366, 3.53911446434, 6286.66627864320},
	{0.00000009951, 1.25735916596, 7234.79425624200},
	{0.00000012425, 1.06396563046, 15110.46611986620},
	{0.00000011004, 2.19276723240, 10988.80815753500},
	{0.00000011583, 4.05256206393, 5729.50644714900},
	{0.00000009046, 5.43016645841, 9623.68827669120},
	{0.00000008869, 5.04690941813, 6148.01076995600},
	{0.00000010507, 2.62758025060, 6836.64525283380},
	{0.00000011129, 4.17728063171, 15720.83878487840},
	{0.00000008614, 1.60161176919, 6418.14093002680},
	{0.00000008532, 2.46198384967, 14712.31711645800},
	{0.00000007910, 3.15429574843, 2118.76386037840},
	{0.00000010546, 4.79503596728, 1349.86740965880},
	{0.00000010480, 2.95288908781, 5999.21653112620},
	{0.00000007456, 5.42522643084, 6040.34724601740},
	{0.00000009820, 3.69556194245, 6566.93516885660},
	{0.00000009171, 3.92216439653, 5643.17856367740},
	{0.00000007018, 1.23420199826, 6525.80445396540},
	{0.00000009797, 1.91951822764, 21228.39202354580},
	{0.00000009060, 4.61643194755, 4690.47983635860},
	{0.00000007545, 1.23604549224, 12539.85338018300},
	{0.00000008227, 0.32929613711, 10973.55568635000},
	{0.00000007202, 5.88391543785, 6245.04817735560},
	{0.00000007144, 0.76464650349, 6321.10352262720},
	{0.00000006625, 0.70112927898, 5327.47610838280},
	{0.00000007412, 5.03197290869, 23543.23050468179},
	{0.00000006160, 0.94570829909, 12964.30070339100},
	{0.00000006378, 6.20903842618, 951.71840625060},
	{0.00000006359, 5.03541261021, 1990.74501704100},
	{0.00000007254, 3.57690549862, 536.80451209540},
	{0.00000005777, 6.10164059960, 955.59974160860},
	{0.00000006393, 3.97543391449, 24072.92146977640},
	{0.00000006927, 0.71517687323, 522.57741809380},
	{0.00000007793, 4.30411864972, 22003.91463486980},
	{0.00000006346, 3.50687769075, 5230.80746680300},
	{0.00000007534, 3.51457135016, 18422.62935909819},
	{0.00000006953, 2.74384548965, 155.42039943420},
	{0.00000006224, 2.24416723229, 18451.07854656599},
	{0.00000005830, 2.32860514691, 639.89728631400},
	{0.00000005762, 3.49866583471, 1551.04522264800},
	{0.00000006251, 4.45479090841, 6288.59877429880},
	{0.00000006251, 2.19374266424, 6277.55292568400},
	{0.00000006278, 0.64265846614, 5216.58037280140},
	{0.00000006405, 2.25334669847, 5650.29211067820},
	{0.00000006545, 1.98229464447, 103.09277421860},
	{0.00000004737, 3.74210997787, 14314.16811304980},
	{0.00000004646, 1.33492108974, 553.56940284240},
	{0.00000006263, 4.39529396163, 26087.90314157420},
	{0.00000006196, 2.58704269072, 84672.47584450469},
	{0.00000006160, 4.78249950381, 239424.39025435288},
	{0.00000004988, 0.73122576373, 77713.77146812050},
	{0.00000005414, 2.99961957880, 6179.98307577280},
	{0.00000005414, 3.65424820690, 6386.16862421000},
	{0.00000004863, 3.76722340488, 90279.92316810328},
	{0.00000005711, 4.32714492993, 6915.85958930460},
	{0.00000004269, 2.38367994999, 7875.67186362420},
	{0.00000004017, 3.78580907612, 6254.62666252360},
	{0.00000004067, 2.42033776129, 3634.62102451840},
	{0.00000003993, 2.86272124248, 6311.52503745920},
	{0.00000005305, 3.34359172920, 25158.60171976540},
	{0.00000004804, 2.82827032932, 5760.49843189760},
	{0.00000004349, 5.62752376053, 7238.67559160000},
	{0.00000004119, 3.29663921982, 6709.67404086740},
	{0.00000004024, 0.55473527406, 11015.10647733480},
	{0.00000004409, 3.80563977803, 6805.65326808520},
	{0.00000003348, 3.54433469125, 12592.45001978260},
	{0.00000003172, 5.19146555016, 1066.49547719000},
	{0.00000003532, 3.92898013298, 9917.69687450980},
	{0.00000003580, 4.19680692038, 11926.25441366880},
	{0.00000003336, 1.79793376416, 10575.40668294180},
	{0.00000003149, 6.21487368875, 4292.33083295040},
	{0.00000003899, 5.53698997029, 74.78159856730},
	{0.00000002979, 6.20067573402, 12566.21901028560},
	{0.00000003981, 1.19685195313, 13341.67431130680},
	{0.00000003025, 3.18620101831, 18052.92954315780},
	{0.00000003624, 5.60981856994, 6208.29425142410},
	{0.00000003581, 1.03995231220, 6357.85744855870},
	{0.00000003698, 5.22105764023, 5966.68398033480},
	{0.00000002793, 4.13369432245, 3.52311834900},
	{0.00000003626, 1.42632163253, 6599.46771964800},
	{0.00000003625, 3.00192353938, 6019.99192661860},
	{0.00000002611, 2.43263787635, 6702.56049386660},
	{0.00000002535, 1.58310693201, 31415.37924995700},
	{0.00000003520, 5.37986364075, 250570.67585721909},
	{0.00000002593, 4.91225714775, 16730.46368959580},
	{0.00000003434, 3.64656881585, 6546.15977336420},
	{0.00000002788, 3.30835728306, 12721.57209941700},
	{0.00000003383, 1.74748489437, 14945.31617355440},
	{0.00000002653, 4.42220751136, 5863.59120611620},
	{0.00000003049, 0.02765893726, 4732.03062734340},
	{0.00000002378, 3.62936279948, 2388.89402044920},
	{0.00000002979, 0.36159339669, 12566.08438968000},
	{0.00000002716, 3.06935305016, 12029.34718788740},
	{0.00000002216, 5.26633529197, 13362.44970679920},
	{0.00000003014, 4.76640877174, 29088.81141598500},
	{0.00000002742, 5.06666852445, 13916.01910964160},
	{0.00000002265, 5.95706192557, 6076.89030155420},
	{0.00000002529, 5.94709040579, 12043.57428188900},
	{0.00000002015, 2.48432243402, 6262.72053059260},
	{0.00000002218, 0.69324011482, 6489.26139842860},
	{0.00000002005, 4.16423889100, 6303.43116939020},
	{0.00000002009, 4.09759324685, 4701.11650170840},
	{0.00000002105, 4.63993587835, 5746.27133789600},
	{0.00000001937, 0.22112768064, 13521.75144159140},
	{0.00000002437, 6.12896014686, 149.56319713460},
	{0.00000002602, 4.28001549113, 4590.91018048900},
	{0.00000001893, 5.66795892365, 6286.95718534940},
	{0.00000001893, 0.98057464900, 6279.19451463340},
	{0.00000002156, 2.00898711721, 18139.29450141590},
	{0.00000002388, 0.13031678718, 1162.47470440780},
	{0.00000001962, 0.25060934155, 4686.88940770680},
	{0.00000002337, 4.40745417534, 10021.83728009940},
	{0.00000001884, 5.27011523204, 242.72860397400},
	{0.00000002436, 4.40772141072, 95143.13292097810},
	{0.00000001759, 0.19888470443, 13517.87010623340},
	{0.00000002163, 1.41797947214, 6037.24420376200},
	{0.00000002167, 4.72612563566, 23013.53953958720},
	{0.00000002250, 2.39728930597, 12669.24447420140},
	{0.00000002052, 5.23006568302, 6528.90749622080},
	{0.00000001774, 2.08484497348, 6819.88036208680},
	{0.00000001842, 0.34675193374, 65147.61976813770},
	{0.00000001549, 0.71612589777, 20.77539549240},
	{0.00000001543, 5.96098287839, 6272.43918464160},
	{0.00000001543, 0.68755069426, 6293.71251534120},
	{0.00000001727, 4.50674659690, 17654.78053974960},
	{0.00000001436, 2.99734831658, 110.20632121940},
	{0.00000001427, 1.68851809181, 13119.72110282519},
	{0.00000001395, 3.25347392533, 10177.25767953360},
	{0.00000001446, 2.26563038586, 1052.26838318840},
	{0.00000001819, 3.18848907826, 18875.52586977400},
	{0.00000001740, 5.48710781556, 19651.04848109800},
	{0.00000001794, 5.74176427744, 25934.12433108940},
	{0.00000001800, 6.18908014275, 33019.02111220460},
	{0.00000001488, 5.67443981584, 76.26607127560},
	{0.00000001349, 5.75097793699, 6016.46880826960},
	{0.00000001477, 4.14004787537, 12779.45079542080},
	{0.00000001251, 1.50045769848, 3894.18182954220},
	{0.00000001492, 6.22975090570, 9411.46461508720},
	{0.00000001471, 5.75783391755, 18635.92845453620},
	{0.00000001672, 5.43726223249, 16200.77272450120},
	{0.00000001263, 0.91728971350, 12573.26524698360},
	{0.00000001366, 1.09160445123, 2379.16447357160},
	{0.00000001272, 0.89738866811, 6549.68289171320},
	{0.00000001274, 5.34253525843, 632.78373931320},
	{0.00000001156, 1.38847609016, 11499.65622279280},
	{0.00000001543, 4.26237609038, 18209.33026366019},
	{0.00000001460, 4.97233669659, 245.83164622940},
	{0.00000001253, 1.41164782000, 6993.00889854970},
	{0.00000001455, 5.29534379992, 38.13303563780},
	{0.00000001228, 2.83750345253, 24356.78078864160},
	{0.00000001028, 2.51030023881, 6112.40297937220},
	{0.00000001268, 4.67217109478, 5429.87946823940},
	{0.00000001312, 1.10091569645, 12491.37010141550},
	{0.00000000992, 4.13817717100, 6453.74872061060},
	{0.00000000988, 0.98006619973, 8273.82086703240},
	{0.00000001191, 3.21845317343, 6276.02961329339},
	{0.00000001191, 3.43008039922, 6290.12208668940},
	{0.00000000978, 4.73852763851, 6247.04798331399},
	{0.00000000971, 1.91000718426, 6319.10371666880},
	{0.00000000962, 2.63568544853, 12565.17137891460},
	{0.00000001025, 2.21768401152, 12545.37630449040},
	{0.00000001146, 3.85865009647, 206.18554843720},
	{0.00000000944, 0.78473810598, 6306.95428773920},
	{0.00000000944, 5.86379546667, 6259.19741224360},
	{0.00000001092, 3.92002105501, 17796.95916678580},
	{0.00000000886, 5.23132430543, 6172.86952877200},
	{0.00000000859, 1.48130342803, 1692.16566950240},
	{0.00000001211, 4.04154480615, 82576.98122099529},
	{0.00000001132, 0.96198039943, 17782.73207278420},
	{0.00000000942, 1.42062620155, 6267.82337880639},
	{0.00000000942, 5.22790737110, 6298.32832117640},
	{0.00000001045, 0.46337213067, 15508.61512327440},
	{0.00000000850, 1.45204280805, 6393.28217121080},
	{0.00000000895, 2.40085098648, 3903.91137641980},
	{0.00000001016, 0.71504248238, 220.41264243880},
	{0.00000000853, 4.42455068314, 949.17560896980},
	{0.00000000917, 2.47015034331, 149854.40013480789},
	{0.00000001085, 1.32862144392, 36949.23080842420},
	{0.00000000779, 3.58339451743, 2648.45482547300},
	{0.00000001000, 0.24880432000, 11403.67699557500},
	{0.00000000962, 3.92658368218, 12567.13202105100},
	{0.00000000770, 6.20173754399, 4804.20927592700},
	{0.00000000986, 4.62897469531, 22805.73556599360},
	{0.00000000931, 2.22558469426, 2787.04302385740},
	{0.00000000743, 3.79903933428, 7834.12107263940},
	{0.00000000905, 3.81538816339, 6284.56032269970},
	{0.00000000905, 2.83314540925, 6281.59137728310},
	{0.00000000715, 5.50312651042, 17256.63153634140},
	{0.00000000798, 2.62501077543, 12410.73130054860},
	{0.00000000828, 1.54060095214, 10969.96525769820},
	{0.00000000821, 0.52122150189, 12416.58850284820},
	{0.00000000826, 4.78071938299, 10984.19235169980},
	{0.00000000754, 3.82898538792, 4061.21921539440},
	{0.00000000616, 5.70479516739, 1596.18644228460},
	{0.00000000723, 3.06755247513, 161000.68573767410},
	{0.00000000782, 0.87676753080, 4907.30205014560},
	{0.00000000707, 3.28533306159, 5849.36411211460},
	{0.00000000783, 3.43481557690, 846.08283475120},
	{0.00000000623, 2.94730498294, 5333.90024102160},
	{0.00000000696, 4.89623582044, 11712.95531823080},
	{0.00000000616, 1.47727208161, 5573.14280143310},
	{0.00000000595, 1.30546777768, 12323.42309600880},
	{0.00000000611, 1.31321200457, 11933.36796066960},
	{0.00000000611, 1.53155679450, 853.19638175200},
	{0.00000000570, 4.54665961586, 12586.92709547520},
	{0.00000000778, 1.57590278073, 8662.24032356300},
	{0.00000000597, 4.69316038420, 9779.10867612540},
	{0.00000000536, 6.06660590951, 18852.75066832320},
	{0.00000000532, 4.58762153412, 18842.11400297339},
	{0.00000000599, 2.11793250999, 6151.53388830500},
	{0.00000000540, 3.40440707564, 6279.78949257360},
	{0.00000000540, 3.24412649701, 6286.36220740920},
	{0.00000000621, 1.14533482552, 52175.80628314840},
	{0.00000000513, 3.70291605445, 12455.94537876340},
	{0.00000000623, 5.52546598759, 5326.78669402080},
	{0.00000000649, 4.90568768794, 11764.33076885900},
	{0.00000000582, 4.53092407532, 6414.61781167780},
	{0.00000000610, 3.94320832220, 10419.98628350760},
	{0.00000000679, 0.26045226696, 6133.51265285680},
	{0.00000000531, 3.00684541494, 3496.03282613400},
	{0.00000000536, 3.70224967645, 7232.25145896120},
	{0.00000000510, 4.38198402315, 11513.88331679440},
	{0.00000000517, 2.93096521231, 433.71173787680},
	{0.00000000643, 6.06382589060, 26735.94526221320},
	{0.00000000665, 2.75085842376, 40879.44050464380},
	{0.00000000549, 0.63911798007, 22483.84857449259},
	{0.00000000479, 1.33580595339, 5547.19933645960},
	{0.00000000564, 3.92025647347, 4171.42553661380},
	{0.00000000462, 1.96611775944, 3104.93005942380},
	{0.00000000551, 4.03874430699, 6503.48849243020},
	{0.00000000535, 6.12277226234, 173566.83743765688},
	{0.00000000545, 2.61441075819, 6062.66320755260},
	{0.00000000477, 3.50657951584, 9388.00590941520},
	{0.00000000448, 5.09815034585, 4274.51831083240},
	{0.00000000532, 0.22623731981, 283.85931886520},
	{0.00000000527, 6.24827316267, 24602.61243487099},
	{0.00000000502, 0.97407194728, 12489.88562870720},
	{0.00000000603, 0.85487083482, 322711.30452390644},
	{0.00000000493, 6.11920290350, 29296.61538957860},
	{0.00000000530, 0.43491203890, 18845.70443162520},
	{0.00000000431, 5.31145947560, 7018.95236352320},
	{0.00000000559, 1.71609589414, 1581.95934828300},
	{0.00000000584, 0.07135689258, 72850.56171524568},
	{0.00000000478, 1.85248622079, 14.22709400160},
	{0.00000000569, 2.95236791425, 97238.62754448749},
	{0.00000000405, 5.39493918596, 10873.98603048040},
	{0.00000000401, 4.50443000854, 17267.26820169119},
	{0.00000000389, 3.43047350256, 6244.94281435360},
	{0.00000000389, 3.21806007009, 6321.20888562920},
	{0.00000000388, 1.13963224225, 6297.30294399300},
	{0.00000000388, 5.50890133040, 6268.84875598980},
	{0.00000000515, 1.67075193318, 12320.32005375340},
	{0.00000000393, 4.37184659923, 14919.01785375460},
	{0.00000000394, 6.10411050787, 4157.19844261220},
	{0.00000000491, 5.96740803508, 1478.86657406440},
	{0.00000000505, 4.66096327599, 17157.06188047180},
	{0.00000000528, 5.62841514056, 135.06508003540},
	{0.00000000439, 4.82558161657, 233141.31440436149},
	{0.00000000417, 3.74443512826, 13760.59871020740},
	{0.00000000419, 5.08318905121, 15671.08175940660},
	{0.00000000393, 1.56711153414, 7872.14874527520},
	{0.00000000392, 1.30305906278, 419.48464387520},
	{0.00000000365, 2.11020607854, 6922.97313630540},
	{0.00000000419, 0.62417554081, 5642.19824260920},
	{0.00000000387, 0.68719040069, 17253.04110768959},
	{0.00000000371, 5.76233828697, 13625.53363017200},
	{0.00000000379, 0.81831291068, 3185.19202726560},
	{0.00000000499, 2.72563350590, 161710.61878623239},
	{0.00000000414, 3.32204347851, 22779.43724619380},
	{0.00000000485, 1.35444198321, 12528.01866434500},
	{0.00000000358, 3.15737999738, 6271.34649715540},
	{0.00000000358, 3.49115357527, 6294.80520282740},
	{0.00000000351, 2.21887707287, 11616.97609101300},
	{0.00000000387, 0.49044025161, 956.28915597060},
	{0.00000000451, 0.91836677580, 29864.33402730900},
	{0.00000000421, 4.82745120825, 7445.55055439920},
	{0.00000000327, 3.95232223910, 20995.39296644940},
	{0.00000000336, 1.41330667750, 6279.14369672830},
	{0.00000000336, 5.23522689515, 6287.00800325450},
	{0.00000000358, 0.81490874525, 21393.54196985760},
	{0.00000000450, 0.23149923655, 1385.56157495110},
	{0.00000000320, 0.03172757569, 16858.48253293320},
	{0.00000000348, 4.27565702309, 3.93215326310},
	{0.00000000363, 4.29069778349, 7335.34423317980},
	{0.00000000330, 3.68113867113, 38.02767263580},
	{0.00000000395, 5.39428043096, 5905.70224207560},
	{0.00000000414, 4.19402575890, 44809.65020086340},
	{0.00000000300, 3.87083875051, 640.87760738220},
	{0.00000000304, 0.15986036979, 5749.86176654780},
	{0.00000000351, 5.93395455459, 12345.73905754400},
	{0.00000000307, 5.30261033229, 5120.60114558360},
	{0.00000000304, 4.93657040735, 29826.30635467320},
	{0.00000000297, 6.01664889580, 20597.24396304120},
	{0.00000000395, 0.07726910331, 4176.04134244900},
	{0.00000000320, 2.49799253183, 10818.13528691580},
	{0.00000000365, 1.25425297875, 6660.44945790720},
	{0.00000000339, 6.10828911901, 6923.95345737360},
	{0.00000000274, 1.11162071728, 26709.64694241340},
	{0.00000000386, 2.29044623019, 2636.72547263700},
	{0.00000000367, 1.18722914434, 30666.15495843280},
	{0.00000000268, 4.95835137530, 10454.50138660520},
	{0.00000000265, 5.11010291991, 19378.91851506880},
	{0.00000000325, 2.49277998223, 12359.96615154560},
	{0.00000000326, 4.24702233173, 16522.65971600220},
	{0.00000000269, 0.20537129126, 6816.28993343500},
	{0.00000000298, 5.15059518785, 10344.29506538580},
	{0.00000000344, 3.51559745333, 6147.45052498140},
	{0.00000000255, 4.94642831875, 1375.77379984580},
	{0.00000000283, 2.57877323959, 316.39186965660},
	{0.00000000334, 3.13303102229, 6418.70117500140},
	{0.00000000316, 5.54205366730, 6055.59971720240},
	{0.00000000316, 0.36194124996, 21954.15760939799},
	{0.00000000243, 4.10172883526, 6310.47740608820},
	{0.00000000243, 2.54680473739, 6255.67429389460},
	{0.00000000314, 4.99359717889, 17996.03116822220},
	{0.00000000296, 0.07899534657, 6129.29703950660},
	{0.00000000301, 1.10648000281, 6510.55198278040},
	{0.00000000329, 1.15676558971, 377.37360791580},
	{0.00000000267, 3.42007125342, 24705.70520908959},
	{0.00000000285, 2.50494681053, 5469.52556603160},
	{0.00000000311, 3.23911937497, 11720.06886523160},
	{0.00000000286, 0.28647339668, 6436.85466047620},
	{0.00000000273, 4.29648399498, 28286.99048486120},
	{0.00000000319, 4.71062528834, 169379.25621117488},
	{0.00000000229, 1.01384122818, 1265.56747862640},
	{0.00000000234, 3.36893910039, 4487.81740627040},
	{0.00000000252, 0.51301411030, 4377.61108505100},
	{0.00000000214, 2.09487711967, 2221.85663459700},
	{0.00000000213, 3.79431896643, 30355.99731976780},
	{0.00000000263, 6.11317571912, 9380.95967271720},
	{0.00000000239, 1.33165763648, 10440.27429260360},
	{0.00000000289, 0.55454156939, 6206.80977871580},
	{0.00000000259, 3.43127382595, 6282.83203250789},
	{0.00000000259, 3.21725974670, 6283.31966747490},
	{0.00000000243, 4.14346390349, 7096.62613395120},
	{0.00000000246, 5.83734028861, 8671.96987044060},
	{0.00000000199, 0.93488663037, 11216.28429032400},
	{0.00000000265, 5.61985831637, 48739.85989708300},
	{0.00000000207, 3.06628694399, 12562.56127133100},
	{0.00000000212, 1.75471606720, 7129.15868474260},
	{0.00000000269, 1.52668826951, 70755.06709173629},
	{0.00000000225, 4.01656879083, 5636.06501667660},
	{0.00000000192, 2.04748658291, 17271.88400752640},
	{0.00000000240, 5.09605084016, 15906.76412668260},
	{0.00000000187, 0.15192842664, 11609.86254401220},
	{0.00000000256, 2.30143585875, 224.34479570190},
	{0.00000000250, 4.24183292428, 5934.15142954340},
	{0.00000000220, 0.73345029623, 11087.28512591840},
	{0.00000000175, 5.41174539523, 11614.43329373220},
	{0.00000000175, 4.58212579300, 3744.82734573780},
	{0.00000000241, 0.28788321480, 8390.11035753380},
	{0.00000000234, 2.61192358068, 34596.36465465240},
	{0.00000000174, 2.85207900960, 263.08392337280},
	{0.00000000233, 2.02657287745, 1.48447270830},
	{0.00000000190, 6.26917436708, 394.62588505920},
	{0.00000000187, 5.58825382870, 401.67212175720},
	{0.00000000178, 3.72578587318, 12132.43996210600},
	{0.00000000230, 2.40692341132, 6632.00027043940},
	{0.00000000177, 4.73089168144, 4797.09572892620},
	{0.00000000167, 3.97388034335, 5714.25397596400},
	{0.00000000160, 2.37187295106, 742.99006053260},
	{0.00000000214, 4.34116392416, 24492.40611365159},
	{0.00000000217, 4.52620284574, 3097.88382272579},
	{0.00000000172, 5.38973312367, 6332.83287546320},
	{0.00000000172, 1.25880044898, 6233.31882451960},
	{0.00000000221, 4.98998061605, 266.60704172180},
	{0.00000000159, 3.90246086071, 13198.93543929600},
	{0.00000000207, 3.49598218672, 12569.74212863460},
	{0.00000000176, 4.05199455874, 12012.58229714040},
	{0.00000000157, 5.43302098132, 16840.67001081519},
	{0.00000000170, 0.63813817825, 6272.03014972750},
	{0.00000000170, 6.01039539440, 6294.12155025530},
	{0.00000000213, 4.21609963122, 19804.82729158280},
	{0.00000000167, 5.54070880349, 17686.75284556640},
	{0.00000000187, 5.70099962642, 20452.86941222180},
	{0.00000000147, 4.99188388936, 16737.57723659660},
	{0.00000000148, 2.67465318849, 6851.89772401880},
	{0.00000000146, 0.23801153618, 17370.36097590980},
	{0.00000000143, 0.85202449839, 5618.31980486140},
	{0.00000000193, 3.57442994352, 33326.57873317420},
	{0.00000000140, 1.22261707467, 2008.55753915900},
	{0.00000000155, 0.27598891874, 20199.09495963300},
	{0.00000000182, 5.69212378196, 28766.92442448400},
	{0.00000000184, 3.48483358167, 5540.08578945880},
	{0.00000000162, 4.78754155685, 12551.92460598120},
	{0.00000000143, 2.32151913243, 5010.39482436420},
	{0.00000000190, 0.66924538276, 23581.25817731760},
	{0.00000000135, 5.34929799142, 735.87651353180},
	{0.00000000135, 0.07815962516, 12431.08661994740},
	{0.00000000134, 3.03203004875, 11925.27409260060},
	{0.00000000179, 1.07503153366, 16460.33352952499},
	{0.00000000182, 3.66470209346, 28.44918746780},
	{0.00000000146, 1.55848605346, 12701.21678001820},
	{0.00000000137, 2.60133025404, 11.04570026390},
	{0.00000000167, 1.26986508714, 17473.45375012840},
	{0.00000000170, 0.76594212114, 52670.06959330260},
	{0.00000000124, 5.79650915048, 6947.83189512140},
	{0.00000000135, 3.38698681678, 3531.52825029980},
	{0.00000000172, 4.94248686856, 167959.39011405829},
	{0.00000000122, 5.69264255527, 3583.34103067380},
	{0.00000000170, 1.45223415923, 333857.59012677266},
	{0.00000000155, 4.05744056379, 6058.73105428950},
	{0.00000000120, 1.19140907580, 12808.88030395680},
	{0.00000000141, 5.52534979149, 162420.55183479069},
	{0.00000000124, 1.37398060221, 8982.81066930900},
	{0.00000000120, 5.84076902832, 12528.12402734700},
	{0.00000000119, 1.19695856457, 19247.37655338240},
	{0.00000000143, 2.13563488838, 95.97922721780},
	{0.00000000117, 0.73795877914, 11610.55195837420},
	{0.00000000154, 4.06475922223, 38526.57435087200},
	{0.00000000163, 3.11560982847, 661.23292678100},
	{0.00000000163, 4.35848910377, 9929.42622734580},
	{0.00000000115, 2.14676232906, 19402.79695281660},
	{0.00000000119, 4.28708216617, 12249.75983032620},
	{0.00000000145, 2.74250030398, 6360.74962041940},
	{0.00000000145, 3.90603326867, 6205.40207956340},
	{0.00000000159, 4.18513291774, 228278.10465148659},
	{0.00000000156, 2.57788957454, 4307.58330413540},
	{0.00000000116, 0.60146141700, 24065.80792277559},
	{0.00000000118, 1.23925579836, 6302.74561089119},
	{0.00000000118, 5.40927777429, 6263.40608909160},
	{0.00000000110, 2.33480621176, 16062.18452611680},
	{0.00000000137, 4.10438279102, 6250.54329920000},
	{0.00000000137, 2.54415078163, 6315.60840078280},
	{0.00000000111, 2.27442358208, 6339.97422492700},
	{0.00000000111, 4.37410999057, 6226.17747505580},
	{0.00000000150, 0.96205875343, 19800.94595622480},
	{0.00000000123, 2.37616666242, 24734.15439655740},
	{0.00000000107, 2.16622176546, 12463.05892576420},
	{0.00000000123, 1.00594418221, 6305.85105144220},
	{0.00000000123, 5.64258939044, 6260.30064854060},
	{0.00000000106, 1.67655703852, 11190.37790013700},
	{0.00000000113, 1.95413568499, 2111.65031337760},
	{0.00000000131, 3.61185299316, 18415.51581209739},
	{0.00000000110, 4.88667127380, 6276.44729109139},
	{0.00000000110, 1.76186229885, 6289.70440889141},
	{0.00000000103, 2.75809551865, 6324.62664097620},
	{0.00000000103, 3.89043805400, 6241.52505900660},
	{0.00000000103, 5.76083420502, 23937.85638974100},
	{0.00000000107, 1.72027333824, 83973.83535572988},
	{0.00000000107, 2.75882604296, 84019.85928049390},
	{0.00000000113, 2.65508166498, 24336.00539314920},
	{0.00000000106, 3.27680652019, 12772.33724842000},
	{0.00000000143, 1.51199781479, 2069.00683490660},
	{0.00000000143, 0.91985752497, 18772.96147869860},
	{0.00000000115, 3.78220330855, 3641.73457151920},
	{0.00000000126, 1.19294266238, 18822.92923017440},
	{0.00000000115, 4.66544469064, 12570.08385324590},
	{0.00000000098, 5.07674655291, 16310.97904572060},
	{0.00000000138, 4.55918305844, 6209.77872413240},
	{0.00000000138, 2.08935051421, 6356.37297585040},
	{0.00000000120, 4.95740945799, 9814.60410029120},
	{0.00000000135, 0.57059381593, 18699.66435283960},
	{0.00000000104, 2.15061044327, 12560.62877567540},
	{0.00000000098, 5.57514710248, 5815.11085963699},
	{0.00000000106, 1.77919890262, 23539.70738633280},
	{0.00000000114, 3.75372093481, 6155.05700665400},
	{0.00000000114, 2.89481263784, 6411.09469332880},
	{0.00000000097, 6.03825791149, 27043.50288318280},
	{0.00000000095, 5.63307798614, 11300.58422135640},
	{0.00000000110, 2.79120257993, 6312.50535852740},
	{0.00000000110, 3.85733099272, 6253.64634145540},
	{0.00000000091, 2.99457476326, 12829.23562335560},
	{0.00000000128, 5.41337210078, 1293.48422358260},
	{0.00000000096, 5.97584747761, 2699.73481931760},
	{0.00000000119, 5.98882616741, 17892.93839400359},
	{0.00000000126, 0.25750574604, 311565.01892104017},
	{0.00000000120, 2.08798412726, 14158.74771361560},
	{0.00000000100, 4.30344030661, 16627.37091537720},
	{0.00000000099, 3.61958161583, 6432.63904712600},
	{0.00000000095, 4.18452410969, 78263.70942472259},
	{0.00000000124, 0.48010020247, 178430.04719053170},
	{0.00000000089, 1.07338604948, 6751.04084034580},
	{0.00000000096, 2.64494034094, 7349.57132718140},
	{0.00000000117, 5.44811650549, 42456.78404709160},
	{0.00000000103, 4.37748903957, 18202.21671665939},
	{0.00000000099, 0.58169736416, 6313.98997562640},
	{0.00000000099, 6.06683620849, 6252.16172435640},
	{0.00000000090, 0.38965081024, 58864.54391814630},
	{0.00000000097, 0.27231106216, 10557.59416082380},
	{0.00000000101, 3.42372783781, 19004.64794940840},
	{0.00000000098, 3.23381285207, 6126.67512948900},
	{0.00000000098, 3.41472072058, 6439.47657049380},
	{0.00000000086, 1.34149823513, 23123.74586080659},
	{0.00000000118, 3.73846259947, 13951.71327493390},
	{0.00000000084, 3.13824782000, 8858.31494432060},
	{0.00000000117, 4.10879972365, 89569.99011954499},
	{0.00000000101, 0.23009068890, 18429.74290609900},
	{0.00000000088, 3.76745959676, 17053.96910625319},
	{0.00000000113, 2.05049922518, 12985.63634385800},
	{0.00000000082, 0.19375634761, 5483.25472482600},
	{0.00000000084, 4.23745405632, 6379.05507720920},
	{0.00000000084, 2.41107951633, 6187.09662277360},
	{0.00000000097, 4.02159784443, 10239.58386601080},
	{0.00000000105, 2.77478785571, 6434.97313107660},
	{0.00000000105, 3.87374571694, 6131.17856890620},
	{0.00000000114, 4.07080498725, 8258.56839584740},
	{0.00000000082, 3.82704107824, 3958.12644117580},
	{0.00000000093, 1.35189028328, 18216.44381066100},
	{0.00000000102, 2.89783593458, 5767.61197889840},
	{0.00000000102, 3.75069763806, 6798.53972108440},
	{0.00000000110, 2.19234510205, 56600.27928952220},
	{0.00000000112, 5.48905138227, 12188.77809206700},
	{0.00000000080, 3.59070813227, 24080.03501677719},
	{0.00000000088, 3.00398297222, 1573.82042409880},
	{0.00000000092, 4.36461689094, 101426.20877096949},
	{0.00000000087, 2.32187773582, 1580.86666079680},
	{0.00000000110, 0.37009059115, 78423.70451667879},
	{0.00000000099, 2.40898854628, 33794.54372352860},
	{0.00000000080, 3.27906531246, 6485.32924516550},
	{0.00000000080, 3.36946826019, 6080.82245481730},
	{0.00000000089, 5.20240793768, 17363.24742890899},
	{0.00000000079, 4.53817935583, 36109.38220466459},
	{0.00000000088, 0.87070535180, 16943.76278503380},
	{0.00000000088, 3.24901264480, 12537.70251251500},
	{0.00000000087, 1.75120977431, 28237.23345938940},
	{0.00000000080, 3.62211320521, 3956.50801601940},
	{0.00000000083, 0.01677699839, 21424.46664430340},
	{0.00000000099, 4.35778148149, 5017.50837136500},
	{0.00000000079, 4.50777133706, 5621.84292321040},
	{0.00000000096, 1.98497858569, 5888.44996493220},
	{0.00000000096, 4.66355498696, 6677.70173505060},
	{0.00000000074, 5.98124271909, 6304.41149045840},
	{0.00000000074, 0.66729085356, 6261.74020952440},
	{0.00000000073, 2.62129339640, 6695.44694686580},
	{0.00000000073, 4.02724017625, 5870.70475311700},
	{0.00000000085, 3.65241534932, 12850.01101884800},
	{0.00000000076, 1.33659857866, 40796.33892267419},
	{0.00000000097, 0.92251430623, 24383.07910844140},
	{0.00000000072, 0.32356695638, 6312.89728814020},
	{0.00000000072, 0.04178130909, 6253.25441184259},
	{0.00000000095, 0.62289841825, 11080.17157891760},
	{0.00000000100, 5.37794668456, 5316.10497255580},
	{0.00000000085, 2.90983978106, 12282.29238111760},
	{0.00000000071, 6.13573135109, 41194.48792608240},
	{0.00000000072, 4.76869158882, 15141.39079431200},
	{0.00000000075, 1.96590126974, 24422.37035140730},
	{0.00000000073, 1.29002951973, 45892.73043315699},
	{0.00000000076, 1.98229485596, 63658.87775083760},
	{0.00000000087, 3.63418769958, 18106.23748944160},
	{0.00000000070, 2.01720588184, 6442.01936777460},
	{0.00000000070, 4.63132769081, 6124.13233220820},
	{0.00000000097, 4.76857001908, 92747.68916682259},
	{0.00000000078, 4.94336223185, 23550.34405168259},
	{0.00000000076, 3.43423122344, 5237.92101380380},
	{0.00000000078, 4.98905027033, 9924.81042151060},
	{0.00000000082, 5.48703292615, 6774.73914245020},
	{0.00000000067, 0.17045052997, 7082.89697515680},
	{0.00000000067, 4.81312573338, 6171.88920770380},
	{0.00000000067, 1.83540783927, 6394.26249227900},
	{0.00000000080, 5.36760004078, 22380.75580027400},
	{0.00000000070, 2.04678665255, 6175.41232605280},
	{0.00000000070, 4.60174692010, 6390.73937393000},
	{0.00000000091, 2.47526506655, 6652.77566593180},
	{0.00000000091, 4.17326850610, 5913.37603405100},
	{0.00000000067, 0.13241010748, 6300.88837210940},
	{0.00000000067, 0.23293815799, 6265.26332787340},
	{0.00000000067, 1.43864813435, 5959.57043333400},
	{0.00000000080, 0.77942675353, 23646.32327890039},
	{0.00000000068, 3.64312434743, 4897.18057365520},
	{0.00000000069, 2.14076204045, 6944.30877677240},
	{0.00000000089, 1.97945887866, 10660.68693504240},
	{0.00000000073, 4.53414425046, 6195.76764545159},
	{0.00000000073, 2.11438932219, 6370.38405453120},
	{0.00000000066, 4.95039391556, 323.50541665740},
	{0.00000000066, 3.95274142218, 6251.10354417460},
	{0.00000000066, 2.69579215047, 6315.04815580820},
	{0.00000000063, 4.27995423229, 11823.16163945020},
	{0.00000000064, 0.09094709813, 28774.03797148480},
	{0.00000000086, 4.32355291567, 12341.80690428090},
	{0.00000000081, 0.47769423835, 31441.67756975680},
	{0.00000000071, 5.70281660725, 16207.88627150200},
	{0.00000000061, 0.43078256287, 35050.00027447539},
	{0.00000000066, 2.78136130877, 17576.54652434700},
	{0.00000000072, 0.54355547965, 18100.00325845000},
	{0.00000000072, 1.59783293112, 245707.46610434429},
	{0.00000000064, 1.93356156446, 23006.42599258639},
	{0.00000000068, 2.90815872826, 28759.81087748319},
	{0.00000000062, 0.67966053291, 3855.03366695720},
	{0.00000000073, 6.18334008725, 23440.13773046320},
	{0.00000000060, 3.22950754418, 13088.72911807660},
	{0.00000000078, 4.56094059497, 12564.66722727450},
	{0.00000000060, 4.47214922427, 7548.64332861780},
	{0.00000000075, 4.42126467141, 18624.88275427230},
	{0.00000000069, 5.82409328726, 167993.69463622378},
	{0.00000000059, 0.42392189557, 41990.78593289880},
	{0.00000000081, 1.27058672695, 7250.04672742700},
	{0.00000000059, 3.96273011871, 6289.14176562120},
	{0.00000000059, 2.68580345394, 6277.00993436160},
	{0.00000000063, 4.91003104939, 5436.99301524020},
	{0.00000000059, 2.73782977803, 8584.66166590080},
	{0.00000000074, 2.29556008890, 28313.28880466100},
	{0.00000000057, 0.01221429824, 10027.90319572920},
	{0.00000000057, 4.87299369650, 792.77488846740},
	{0.00000000060, 2.20527423485, 647.01083331480},
	{0.00000000056, 4.47895058873, 15265.88651930040},
	{0.00000000072, 4.16398251563, 4598.02372748980},
	{0.00000000063, 1.27506758028, 5.52292430740},
	{0.00000000068, 2.71579728238, 3166.41643773160},
	{0.00000000074, 3.23404191447, 82534.40362061159},
	{0.00000000056, 1.96997381249, 6339.87911216120},
	{0.00000000056, 4.67855976016, 6226.27258782160},
	{0.00000000069, 1.89738325082, 23536.11695768099},
	{0.00000000056, 2.52728721608, 12303.06777661000},
	{0.00000000055, 3.89144240866, 22345.26037610820},
	{0.00000000057, 3.55801157684, 6702.00024889200},
	{0.00000000057, 3.09052199581, 5864.15145109080},
	{0.00000000064, 5.42433316705, 14169.79356223040},
	{0.00000000075, 5.93374782872, 32217.20018108080},
	{0.00000000059, 2.17826568386, 18003.14471522300},
	{0.00000000059, 3.38504946794, 67589.08744705719},
	{0.00000000076, 2.34884503279, 23226.83863502520},
	{0.00000000073, 6.00950734574, 30348.88377276700},
	{0.00000000070, 1.56579326622, 12299.54465826100},
	{0.00000000060, 0.37221954582, 12171.52581492360},
	{0.00000000058, 3.15618940951, 6716.78758786820},
	{0.00000000074, 5.91246929008, 3684.37804999020},
	{0.00000000067, 2.65177830926, 22743.40937951640},
	{0.00000000062, 2.47017142882, 16193.65917750039},
	{0.00000000059, 2.60023110979, 15.25247118500},
	{0.00000000059, 1.05069387628, 12164.47957822560},
	{0.00000000056, 4.02457745520, 3178.14579056760},
	{0.00000000063, 3.66056370325, 5219.76176653910},
	{0.00000000063, 0.58993036842, 5227.62607306530},
	{0.00000000071, 3.61897462493, 60530.48898574180},
	{0.00000000072, 1.05408545034, 4583.79663348820},
	{0.00000000052, 5.67741459488, 3627.50747751760},
	{0.00000000052, 1.77495138030, 6155.12431695680},
	{0.00000000052, 4.87358219235, 6411.02738302600},
	{0.00000000073, 4.40543588100, 80181.53746683979},
	{0.00000000058, 4.29308512080, 30775.48196364300},
	{0.00000000068, 1.86654756299, 35371.88726597640},
	{0.00000000062, 4.46845874247, 6908.74604230380},
	{0.00000000062, 2.18007483018, 5657.40565767900},
	{0.00000000050, 1.53898120800, 2575.23909432920},
	{0.00000000052, 1.82842431930, 5244.04923920100},
	{0.00000000050, 4.69455799921, 5881.40372823420},
	{0.00000000050, 1.95397557344, 6684.74797174860},
	{0.00000000053, 5.33677558065, 12146.66705610760},
	{0.00000000068, 6.19033473088, 96677.89886304220},
	{0.00000000064, 5.16841754323, 24279.10701821359},
	{0.00000000050, 3.21675900656, 43738.80234596580},
	{0.00000000050, 1.95435790721, 23141.55838292460},
	{0.00000000059, 4.28456134455, 3981.49003408200},
	{0.00000000058, 2.65359377943, 40077.61957352000},
	{0.00000000054, 3.56564135998, 15664.03552270859},
	{0.00000000061, 2.88962487651, 40398.18991926600},
	{0.00000000051, 3.00540767523, 7668.97112632760},
	{0.00000000048, 4.80656273565, 3646.35037735440},
	{0.00000000048, 2.80573655186, 170.67287061920},
	{0.00000000065, 6.08902325889, 47162.51635463520},
	{0.00000000056, 4.19093499866, 799.82112516540},
	{0.00000000049, 3.72443814803, 96562.99901809469},
	{0.00000000050, 5.17709552474, 17583.66007134780},
	{0.00000000049, 5.16566731300, 5490.30096152400},
	{0.00000000058, 5.40778008235, 6076.37511269480},
	{0.00000000058, 1.24075349030, 6489.77658728800},
	{0.00000000059, 1.72439508836, 44034.12758953940},
	{0.00000000045, 1.62661962717, 4480.70385926960},
	{0.00000000061, 5.10264428859, 491.66329245880},
	{0.00000000044, 1.10033696885, 2301.58581590939},
	{0.00000000054, 3.85123315789, 6559.82162185580},
	{0.00000000054, 2.79730041476, 6006.33007812700},
	{0.00000000052, 5.42245980619, 244287.60000722769},
	{0.00000000048, 1.42585982742, 36147.40987730040},
	{0.00000000044, 0.81389810430, 5113.48759858280},
	{0.00000000045, 4.22954077900, 533.21408344360},
	{0.00000000046, 2.27703250571, 4384.72463205180},
	{0.00000000048, 6.20173890368, 35579.69123957000},
	{0.00000000051, 0.20646603354, 18326.65013188039},
	{0.00000000043, 3.18939503640, 27832.03821928320},
	{0.00000000046, 4.72419541485, 16703.06213349900},
	{0.00000000052, 4.17179726389, 11919.14086666800},
	{0.00000000052, 0.71926561105, 46386.99374331120},
	{0.00000000047, 0.82248881139, 5209.46682580060},
	{0.00000000046, 4.04752097938, 12555.10599971890},
	{0.00000000052, 0.43326734132, 6574.04871585740},
	{0.00000000052, 6.21526623133, 5992.10298412540},
	{0.00000000044, 5.37918791865, 69941.95360082899},
	{0.00000000058, 0.36325356715, 74673.98422817240},
	{0.00000000056, 1.50089021543, 27707.54249429480},
	{0.00000000045, 6.22182195617, 46360.69542351140},
	{0.00000000043, 3.11608101277, 8401.83971036980},
	{0.00000000047, 2.39687793686, 143571.32428481648},
	{0.00000000043, 1.13301289185, 30639.85663863300},
	{0.00000000049, 1.97844011728, 22030.21295466960},
	{0.00000000045, 4.79114307475, 71519.29714327680},
	{0.00000000051, 4.52703512787, 7761.94242405580},
	{0.00000000041, 0.43156447693, 3735.23831175900},
	{0.00000000041, 1.66415755313, 44136.95134937400},
	{0.00000000047, 4.45924253669, 4708.23004870920},
	{0.00000000056, 0.65498687965, 28663.83165026540},
	{0.00000000055, 3.26682599355, 39302.09696219600},
	{0.00000000049, 5.40929899528, 27511.46787353720},
	{0.00000000047, 0.89791015009, 316428.22867391503},
	{0.00000000040, 0.05000438602, 18208.34994259200},
	{0.00000000056, 2.85120720656, 83659.27687239899},
	{0.00000000053, 3.02524199997, 38650.17350619900},
	{0.00000000048, 2.50261741205, 12662.13092720060},
	{0.00000000052, 4.41165168727, 12571.67462429020},
	{0.00000000043, 4.69793306978, 7322.10246078180},
	{0.00000000041, 3.56541409677, 664.75604513000},
	{0.00000000044, 5.20087497624, 6140.89722295520},
	{0.00000000044, 1.44765859641, 6425.25447702760},
	{0.00000000039, 0.38207420659, 22594.05489571199},
	{0.00000000039, 4.22033276864, 27278.46881644080},
	{0.00000000045, 4.12311427457, 44007.82926973960},
	{0.00000000054, 4.69164296803, 6006.04085625000},
	{0.00000000054, 1.95689060462, 6560.11084373280},
	{0.00000000045, 5.54498349441, 142861.39123625819},
	{0.00000000047, 1.12159858858, 24499.51966065240},
	{0.00000000043, 1.36615498859, 7026.06591052400},
	{0.00000000040, 0.90738693747, 26880.31981303260},
	{0.00000000047, 4.50830744099, 24485.29256665079},
	{0.00000000043, 5.81439105801, 6359.34192126700},
	{0.00000000042, 4.70083045322, 6231.79551212899},
	{0.00000000042, 1.94770311943, 6334.35618785381},
	{0.00000000037, 5.39982800110, 23020.65308658799},
	{0.00000000052, 3.53311914292, 11904.91877320180},
	{0.00000000040, 1.50947925293, 7075.85073845880},
	{0.00000000049, 3.73016699917, 32243.49850088060},
	{0.00000000043, 4.45265815492, 40000.04091585779},
	{0.00000000040, 0.07156369559, 7122.04513774180},
	{0.00000000040, 0.29378456988, 5444.10656224100},
	{0.00000000038, 2.24527247949, 44933.24935619040},
	{0.00000000037, 0.09116813653, 6850.79448772180},
	{0.00000000037, 0.27418012894, 5715.35721226100},
	{0.00000000039, 2.88920508037, 20.35531939880},
	{0.00000000051, 5.82785362503, 84111.74716305939},
	{0.00000000037, 1.90653942815, 16723.35014259500},
	{0.00000000042, 3.79031051907, 6328.21706962800},
	{0.00000000042, 2.85822305358, 6237.93463035480},
	{0.00000000036, 2.35204592553, 20760.42703319140},
	{0.00000000049, 4.54040658078, 11293.47067435560},
	{0.00000000040, 3.64328287226, 3215.13638064320},
	{0.00000000050, 1.62788844152, 84334.41776382479},
	{0.00000000040, 0.78396796338, 71980.63357473118},
	{0, 0, 0}
};

struct vsop87_term earth_x1[] = {
	{0.00123403056, 0.00000000000, 0.00000000000},
	{0.00051500156, 6.00266267204, 12566.15169998280},
	{0.00001290726, 5.95943124583, 18849.22754997420},
	{0.00001068627, 2.01554176551, 6283.07584999140},
	{0.00000212689, 1.73380190491, 6279.55273164240},
	{0.00000212515, 4.91489371033, 6286.59896834040},
	{0.00000062260, 0.36239798178, 4705.73230754360},
	{0.00000059822, 3.81195369871, 6256.77753019160},
	{0.00000059514, 2.83634160150, 6309.37416979120},
	{0.00000048841, 5.21419389335, 775.52261132400},
	{0.00000042883, 0.43789776559, 1059.38193018920},
	{0.00000046286, 0.01839494103, 7860.41939243920},
	{0.00000035675, 1.45279327264, 5884.92684658320},
	{0.00000036061, 2.16002201071, 5753.38488489680},
	{0.00000035367, 4.47243820095, 6812.76681508600},
	{0.00000032137, 5.19589851893, 6681.22485339960},
	{0.00000028763, 5.91618989512, 25132.30339996560},
	{0.00000028447, 1.14976253807, 6127.65545055720},
	{0.00000027573, 5.50119104683, 6438.49624942560},
	{0.00000024815, 2.92204909812, 5486.77784317500},
	{0.00000020611, 3.71790880968, 7079.37385680780},
	{0.00000019565, 2.89351924469, 5507.55323866740},
	{0.00000018308, 1.46954314992, 11790.62908865880},
	{0.00000016471, 6.22682639292, 11506.76976979360},
	{0.00000016757, 3.81935015812, 7058.59846131540},
	{0.00000014555, 5.97554823531, 6290.18939699220},
	{0.00000014388, 0.68157599309, 6275.96230299060},
	{0.00000013921, 1.44156172409, 796.29800681640},
	{0.00000011845, 4.15246503623, 4694.00295470760},
	{0.00000012573, 0.30429978572, 7.11354700080},
	{0.00000010073, 3.28940171828, 3738.76143010800},
	{0.00000009513, 4.62657118532, 6069.77675455340},
	{0.00000010425, 4.26610810148, 6282.09552892320},
	{0.00000010425, 2.38242547117, 6284.05617105960},
	{0.00000009565, 1.89315044337, 4136.91043351620},
	{0.00000009044, 2.00977420682, 6496.37494542940},
	{0.00000008543, 0.05563879210, 1194.44701022460},
	{0.00000008230, 1.25204318279, 1589.07289528380},
	{0.00000006181, 3.36235656603, 8827.39026987480},
	{0.00000006252, 4.75560512125, 8429.24126646660},
	{0.00000005525, 5.36960259598, 4933.20844033260},
	{0.00000007312, 0.49039562572, 4535.05943692440},
	{0.00000007074, 4.39447155183, 5088.62883976680},
	{0.00000005168, 5.15700586490, 11769.85369316640},
	{0.00000004878, 0.63279675325, 6040.34724601740},
	{0.00000005339, 5.63168593753, 3154.68708489560},
	{0.00000004985, 4.62777616911, 12569.67481833180},
	{0.00000004902, 4.14599178687, 3930.20969621960},
	{0.00000004709, 3.96401482904, 5331.35744374080},
	{0.00000004601, 6.02376082863, 6525.80445396540},
	{0.00000004331, 1.32999081524, 7632.94325965020},
	{0.00000005607, 2.55800588736, 5729.50644714900},
	{0.00000003968, 2.72696169781, 7234.79425624200},
	{0.00000004394, 0.04709283876, 12559.03815298200},
	{0.00000005262, 6.19471325132, 8031.09226305840},
	{0.00000005100, 4.10862449537, 6836.64525283380},
	{0.00000005075, 2.30582917471, 7477.52286021600},
	{0.00000003287, 5.41013501104, 10977.07880469900},
	{0.00000003366, 0.28947921379, 11371.70468975820},
	{0.00000003341, 1.64988056630, 5223.69391980220},
	{0.00000003495, 3.73571049570, 4164.31198961300},
	{0.00000004294, 4.93755825416, 1592.59601363280},
	{0.00000003408, 2.40593164878, 3128.38876509580},
	{0.00000002997, 4.86533819655, 1748.01641306700},
	{0.00000002750, 5.24429623672, 7342.45778018060},
	{0.00000002669, 3.42836090012, 2146.16541647520},
	{0.00000003313, 1.92016526057, 801.82093112380},
	{0.00000002991, 2.26433580653, 8635.94200376320},
	{0.00000003390, 4.23836515895, 155.42039943420},
	{0.00000002384, 5.74836325186, 7084.89678111520},
	{0.00000002288, 4.51088946570, 17260.15465469040},
	{0.00000002405, 5.96195251565, 4690.47983635860},
	{0.00000002052, 1.42012676041, 951.71840625060},
	{0.00000002049, 3.53634954129, 1990.74501704100},
	{0.00000002778, 1.46151348750, 5481.25491886760},
	{0.00000002656, 5.71405746008, 26.29831979980},
	{0.00000002135, 1.89020345470, 536.80451209540},
	{0.00000002529, 0.00975556739, 1349.86740965880},
	{0.00000001877, 2.82846563483, 553.56940284240},
	{0.00000001858, 0.74657310664, 398.14900340820},
	{0.00000002013, 2.40172210263, 522.57741809380},
	{0.00000001904, 4.23263119723, 9437.76293488700},
	{0.00000001708, 0.29065876129, 10988.80815753500},
	{0.00000001853, 1.84012190435, 5230.80746680300},
	{0.00000001857, 2.34009177634, 5216.58037280140},
	{0.00000001558, 1.10024744060, 426.59819087600},
	{0.00000001543, 5.14512865944, 10447.38783960440},
	{0.00000001555, 3.67004205114, 13095.84266507740},
	{0.00000001779, 1.80817581905, 12562.62858163380},
	{0.00000001450, 0.99962470222, 6262.72053059260},
	{0.00000001450, 5.64890887043, 6303.43116939020},
	{0.00000001880, 1.74872544631, 10973.55568635000},
	{0.00000001372, 0.89279228106, 7875.67186362420},
	{0.00000001247, 1.86318425701, 2118.76386037840},
	{0.00000001231, 4.10277044176, 18319.53658487960},
	{0.00000001373, 4.83873686423, 12721.57209941700},
	{0.00000001140, 3.49255962548, 1066.49547719000},
	{0.00000001127, 6.04843564608, 5643.17856367740},
	{0.00000001136, 2.83389341769, 2942.46342329160},
	{0.00000001071, 3.77511422440, 242.72860397400},
	{0.00000001165, 5.90779831262, 15720.83878487840},
	{0.00000000974, 0.24120093775, 639.89728631400},
	{0.00000000973, 1.30526267473, 4292.33083295040},
	{0.00000000993, 3.20822379065, 10575.40668294180},
	{0.00000000964, 2.13521649390, 2388.89402044920},
	{0.00000000929, 1.06241249364, 16496.36139620240},
	{0.00000000939, 5.78268735385, 20426.57109242200},
	{0.00000000889, 0.06581239696, 6288.59877429880},
	{0.00000000889, 0.29953586851, 6277.55292568400},
	{0.00000001018, 4.23379398746, 12539.85338018300},
	{0.00000001042, 2.30738424939, 529.69096509460},
	{0.00000001033, 1.04793549544, 5760.49843189760},
	{0.00000001017, 5.59172649862, 6805.65326808520},
	{0.00000000801, 5.36423767778, 14314.16811304980},
	{0.00000000795, 4.97031461103, 6279.78949257360},
	{0.00000000795, 1.67821896162, 6286.36220740920},
	{0.00000000723, 3.87714868475, 9623.68827669120},
	{0.00000000800, 4.75445675725, 12029.34718788740},
	{0.00000000698, 0.23124375738, 6148.01076995600},
	{0.00000000675, 5.56136235734, 12964.30070339100},
	{0.00000000678, 0.13408273301, 6418.14093002680},
	{0.00000000671, 1.28940504615, 6709.67404086740},
	{0.00000000898, 2.26352977340, 13367.97263110660},
	{0.00000000716, 4.07157593048, 16730.46368959580},
	{0.00000000651, 5.31876664276, 5856.47765911540},
	{0.00000000744, 4.25820617142, 12043.57428188900},
	{0.00000000650, 3.96082074858, 14712.31711645800},
	{0.00000000643, 6.14575788122, 2352.86615377180},
	{0.00000000666, 6.18664331112, 5746.27133789600},
	{0.00000000588, 3.24442116878, 13119.72110282519},
	{0.00000000627, 1.85323853183, 4686.88940770680},
	{0.00000000584, 1.78420561597, 13517.87010623340},
	{0.00000000610, 0.48716946879, 6819.88036208680},
	{0.00000000666, 3.29946942274, 3634.62102451840},
	{0.00000000585, 0.14860338726, 12036.46073488820},
	{0.00000000620, 5.87390167695, 31415.37924995700},
	{0.00000000553, 2.36074148933, 6306.95428773920},
	{0.00000000553, 4.28779208332, 6259.19741224360},
	{0.00000000527, 4.65845256725, 10177.25767953360},
	{0.00000000523, 5.55991825992, 12139.55350910680},
	{0.00000000514, 2.30343678959, 4701.11650170840},
	{0.00000000495, 3.58067041581, 13362.44970679920},
	{0.00000000688, 0.41160312810, 13916.01910964160},
	{0.00000000481, 4.14197696514, 6286.95718534940},
	{0.00000000481, 2.50655660751, 6279.19451463340},
	{0.00000000465, 0.81901657744, 14143.49524243060},
	{0.00000000440, 2.91975126929, 3894.18182954220},
	{0.00000000431, 3.09968854047, 11499.65622279280},
	{0.00000000452, 5.55409870988, 12573.26524698360},
	{0.00000000499, 1.08746978287, 12410.73130054860},
	{0.00000000440, 2.14902528642, 24072.92146977640},
	{0.00000000435, 4.76945528790, 9917.69687450980},
	{0.00000000398, 5.77181168519, 8273.82086703240},
	{0.00000000379, 4.62464502982, 6386.16862421000},
	{0.00000000379, 2.02388854283, 6179.98307577280},
	{0.00000000377, 5.90355422208, 7872.14874527520},
	{0.00000000419, 5.62219999256, 5327.47610838280},
	{0.00000000383, 0.40420536338, 6319.10371666880},
	{0.00000000383, 6.24432820927, 6247.04798331399},
	{0.00000000486, 3.05618432546, 12592.45001978260},
	{0.00000000457, 2.45652916518, 6489.26139842860},
	{0.00000000457, 4.19200440747, 6076.89030155420},
	{0.00000000512, 1.88365818219, 11015.10647733480},
	{0.00000000344, 0.28667648401, 18451.07854656599},
	{0.00000000340, 2.75068444234, 12323.42309600880},
	{0.00000000454, 0.72878821246, 2787.04302385740},
	{0.00000000364, 2.25070711701, 6321.10352262720},
	{0.00000000364, 4.39782645564, 6245.04817735560},
	{0.00000000342, 6.10019640486, 6303.85124548380},
	{0.00000000342, 0.54833716779, 6262.30045449900},
	{0.00000000324, 2.66245548691, 77713.77146812050},
	{0.00000000316, 0.14807870151, 11926.25441366880},
	{0.00000000318, 1.32350341546, 6311.52503745920},
	{0.00000000318, 5.32503015719, 6254.62666252360},
	{0.00000000304, 2.00970548291, 12779.45079542080},
	{0.00000000360, 4.10116091510, 1052.26838318840},
	{0.00000000343, 2.93550529951, 6267.82337880639},
	{0.00000000343, 3.71302827314, 6298.32832117640},
	{0.00000000398, 0.12276624389, 1551.04522264800},
	{0.00000000300, 1.77610616438, 90279.92316810328},
	{0.00000000367, 2.75102591636, 10021.83728009940},
	{0.00000000297, 0.51546903036, 5429.87946823940},
	{0.00000000337, 2.71244267795, 17782.73207278420},
	{0.00000000295, 4.05850212848, 6702.56049386660},
	{0.00000000331, 0.94287498279, 7238.67559160000},
	{0.00000000321, 2.23719619346, 17796.95916678580},
	{0.00000000378, 2.47077025009, 213.29909543800},
	{0.00000000268, 4.36573038796, 2544.31441988340},
	{0.00000000290, 5.31163321847, 220.41264243880},
	{0.00000000349, 0.95962542267, 17789.84561978500},
	{0.00000000275, 3.67150875811, 14945.31617355440},
	{0.00000000253, 2.22918080251, 18073.70493865020},
	{0.00000000257, 1.04749733742, 955.59974160860},
	{0.00000000234, 4.07399715957, 1596.18644228460},
	{0.00000000282, 4.50260494490, 13341.67431130680},
	{0.00000000280, 5.71871851487, 206.18554843720},
	{0.00000000269, 6.10957634874, 9779.10867612540},
	{0.00000000306, 3.20523259534, 5863.59120611620},
	{0.00000000216, 5.60561646872, 3185.19202726560},
	{0.00000000280, 1.91082976057, 5642.19824260920},
	{0.00000000233, 3.01339621844, 10984.19235169980},
	{0.00000000263, 2.16888500036, 12168.00269657460},
	{0.00000000226, 4.44534966925, 3496.03282613400},
	{0.00000000260, 3.16564185469, 10969.96525769820},
	{0.00000000227, 4.95666866168, 5849.36411211460},
	{0.00000000211, 1.22111379347, 19651.04848109800},
	{0.00000000250, 4.61595902292, 6923.95345737360},
	{0.00000000194, 2.37630770389, 640.87760738220},
	{0.00000000203, 4.39496828470, 6062.66320755260},
	{0.00000000203, 2.25356528795, 6503.48849243020},
	{0.00000000184, 0.13859812924, 18209.33026366019},
	{0.00000000184, 4.20955149479, 12566.21901028560},
	{0.00000000180, 5.76799248594, 853.19638175200},
	{0.00000000199, 2.84103239065, 3.52311834900},
	{0.00000000187, 4.59167688742, 6276.02961329339},
	{0.00000000187, 2.05685668523, 6290.12208668940},
	{0.00000000192, 2.99578290747, 4732.03062734340},
	{0.00000000184, 4.65365446464, 12566.08438968000},
	{0.00000000230, 2.23774195109, 12567.13202105100},
	{0.00000000165, 1.34307380910, 110.20632121940},
	{0.00000000166, 1.19477871058, 433.71173787680},
	{0.00000000184, 3.38049914956, 6037.24420376200},
	{0.00000000156, 2.34457936544, 2648.45482547300},
	{0.00000000175, 3.26771507312, 6528.90749622080},
	{0.00000000154, 5.67725689556, 6453.74872061060},
	{0.00000000154, 0.97127667708, 6112.40297937220},
	{0.00000000166, 4.51313560848, 12352.85260454480},
	{0.00000000146, 4.05664802756, 149.56319713460},
	{0.00000000172, 0.88734623011, 1577.34354244780},
	{0.00000000144, 3.76179690789, 18635.92845453620},
	{0.00000000146, 1.99164761433, 13760.59871020740},
	{0.00000000136, 0.75192359085, 11712.95531823080},
	{0.00000000142, 1.34533369944, 4157.19844261220},
	{0.00000000133, 0.01824912792, 18139.29450141590},
	{0.00000000124, 0.99880484927, 17256.63153634140},
	{0.00000000140, 1.25451695814, 9380.95967271720},
	{0.00000000123, 0.26259126301, 6172.86952877200},
	{0.00000000123, 0.10275700246, 6393.28217121080},
	{0.00000000121, 5.40082218265, 20.77539549240},
	{0.00000000117, 4.47711713051, 18852.75066832320},
	{0.00000000114, 2.33765655466, 65147.61976813770},
	{0.00000000120, 2.29184279740, 17253.04110768959},
	{0.00000000132, 4.94196827917, 18875.52586977400},
	{0.00000000123, 4.42839393502, 12565.17137891460},
	{0.00000000129, 2.56187150433, 11513.88331679440},
	{0.00000000121, 2.27781803851, 10419.98628350760},
	{0.00000000112, 0.58654969541, 632.78373931320},
	{0.00000000118, 5.96799701373, 17654.78053974960},
	{0.00000000105, 5.26799267002, 23013.53953958720},
	{0.00000000103, 0.24702432231, 6271.34649715540},
	{0.00000000103, 0.11832394316, 6294.80520282740},
	{0.00000000102, 2.69803619583, 17267.26820169119},
	{0.00000000108, 2.49639211639, 23543.23050468179},
	{0.00000000114, 2.21695343681, 4171.42553661380},
	{0.00000000101, 4.42100430236, 4804.20927592700},
	{0.00000000111, 3.66256237589, 1581.95934828300},
	{0.00000000119, 0.24456263546, 10213.28554621100},
	{0.00000000102, 5.67042027327, 6549.68289171320},
	{0.00000000102, 0.97811329938, 6016.46880826960},
	{0.00000000121, 0.05336972054, 13625.53363017200},
	{0.00000000090, 3.68828039857, 76.26607127560},
	{0.00000000086, 5.93949751968, 12808.88030395680},
	{0.00000000095, 1.34358559692, 12345.73905754400},
	{0.00000000106, 5.14281705612, 11216.28429032400},
	{0.00000000095, 2.50046439714, 12012.58229714040},
	{0.00000000081, 3.84772814821, 11614.43329373220},
	{0.00000000084, 1.14755262027, 6255.67429389460},
	{0.00000000084, 5.50098095238, 6310.47740608820},
	{0.00000000106, 6.00471264495, 3097.88382272579},
	{0.00000000080, 0.34711727404, 6922.97313630540},
	{0.00000000085, 5.79536877725, 5636.06501667660},
	{0.00000000092, 0.87789019103, 10818.13528691580},
	{0.00000000080, 4.19702650261, 3583.34103067380},
	{0.00000000083, 3.70902039500, 5120.60114558360},
	{0.00000000080, 1.41939312484, 13521.75144159140},
	{0.00000000084, 3.01891268791, 10440.27429260360},
	{0.00000000077, 5.70306938809, 6993.00889854970},
	{0.00000000104, 5.42105253386, 5650.29211067820},
	{0.00000000086, 0.81273058913, 12359.96615154560},
	{0.00000000090, 6.02294397735, 6195.76764545159},
	{0.00000000090, 0.62558959530, 6370.38405453120},
	{0.00000000074, 2.33758314304, 3340.61242669980},
	{0.00000000082, 0.19767948100, 18842.11400297339},
	{0.00000000083, 5.31994916859, 18415.51581209739},
	{0.00000000101, 2.86191811970, 3104.93005942380},
	{0.00000000073, 6.09594424715, 949.17560896980},
	{0.00000000084, 4.35521501162, 2379.16447357160},
	{0.00000000075, 1.62833922577, 30355.99731976780},
	{0.00000000069, 3.24662354142, 10454.50138660520},
	{0.00000000076, 3.92665935350, 17298.18232732620},
	{0.00000000076, 4.83482959872, 18429.74290609900},
	{0.00000000079, 0.06205634713, 22805.73556599360},
	{0.00000000077, 2.05455640378, 16858.48253293320},
	{0.00000000087, 5.09755111164, 3903.91137641980},
	{0.00000000061, 3.70271756349, 16737.57723659660},
	{0.00000000078, 4.31638741861, 8671.96987044060},
	{0.00000000063, 0.99541849434, 24356.78078864160},
	{0.00000000075, 2.14136838637, 23581.25817731760},
	{0.00000000073, 4.49527510239, 9388.00590941520},
	{0.00000000058, 0.89406841198, 17996.03116822220},
	{0.00000000057, 2.48914084100, 419.48464387520},
	{0.00000000062, 4.06342805588, 11925.27409260060},
	{0.00000000060, 3.51548088474, 34570.06633485260},
	{0.00000000057, 4.46050926275, 149854.40013480789},
	{0.00000000056, 5.33393809517, 12455.94537876340},
	{0.00000000056, 2.17965993818, 11764.33076885900},
	{0.00000000061, 0.15194461973, 28237.23345938940},
	{0.00000000065, 5.87045161229, 7335.34423317980},
	{0.00000000072, 5.87296425674, 6510.55198278040},
	{0.00000000072, 0.77556931591, 6055.59971720240},
	{0.00000000071, 0.23083621209, 12545.37630449040},
	{0.00000000061, 5.37705181537, 6253.64634145540},
	{0.00000000061, 1.27148175728, 6312.50535852740},
	{0.00000000055, 1.18603703570, 2699.73481931760},
	{0.00000000056, 6.18401368339, 5573.14280143310},
	{0.00000000055, 5.94073604896, 15671.08175940660},
	{0.00000000052, 0.26563539971, 5326.78669402080},
	{0.00000000053, 1.77739578512, 26735.94526221320},
	{0.00000000065, 2.33938496802, 14919.01785375460},
	{0.00000000049, 4.18739781015, 35579.69123957000},
	{0.00000000053, 5.28549359722, 6357.85744855870},
	{0.00000000053, 1.36303997543, 6208.29425142410},
	{0.00000000051, 0.76407742618, 16522.65971600220},
	{0.00000000049, 4.92674479666, 21393.54196985760},
	{0.00000000049, 0.60525485888, 7018.95236352320},
	{0.00000000049, 6.04327871377, 5547.19933645960},
	{0.00000000049, 2.59123701567, 12416.58850284820},
	{0.00000000050, 0.07523239468, 26084.02180621620},
	{0.00000000048, 5.46985443988, 12132.43996210600},
	{0.00000000051, 3.40683294217, 23006.42599258639},
	{0.00000000058, 2.46543150418, 15141.39079431200},
	{0.00000000048, 4.88190521609, 16200.77272450120},
	{0.00000000047, 0.97667389279, 24279.10701821359},
	{0.00000000049, 1.66846784739, 5749.86176654780},
	{0.00000000049, 4.98006572526, 6816.28993343500},
	{0.00000000046, 3.45134537804, 19378.91851506880},
	{0.00000000047, 2.09300174029, 24065.80792277559},
	{0.00000000046, 5.73797450552, 104351.61256629678},
	{0.00000000049, 1.45701599108, 8982.81066930900},
	{0.00000000050, 4.49441848554, 24602.61243487099},
	{0.00000000045, 0.12799634054, 24491.42579258340},
	{0.00000000049, 2.95918505969, 16460.33352952499},
	{0.00000000054, 0.03974674424, 7834.12107263940},
	{0.00000000045, 5.05860612319, 161000.68573767410},
	{0.00000000044, 3.92726741188, 8662.24032356300},
	{0.00000000049, 4.51486356794, 29303.72893657940},
	{0.00000000049, 4.98978743446, 29289.50184257780},
	{0.00000000043, 3.34677142688, 5244.04923920100},
	{0.00000000044, 3.63764737159, 6175.41232605280},
	{0.00000000044, 3.01088620106, 6390.73937393000},
	{0.00000000042, 1.47305743112, 24705.70520908959},
	{0.00000000041, 4.78696656856, 17370.36097590980},
	{0.00000000041, 4.99610869214, 22483.84857449259},
	{0.00000000057, 3.19497095530, 84334.66158130829},
	{0.00000000041, 3.62603303245, 23020.65308658799},
	{0.00000000045, 2.13147646951, 54247.41313575040},
	{0.00000000040, 3.00393229632, 32243.49850088060},
	{0.00000000040, 0.45946989377, 24336.00539314920},
	{0.00000000040, 0.00254937606, 8401.83971036980},
	{0.00000000041, 5.05922003836, 26482.17080962440},
	{0.00000000044, 4.93011217974, 28230.18722269139},
	{0.00000000039, 5.54872052106, 45585.17281218740},
	{0.00000000038, 3.93561558747, 6268.84875598980},
	{0.00000000038, 2.71291798518, 6297.30294399300},
	{0.00000000041, 4.95311845784, 15508.61512327440},
	{0.00000000038, 0.10976793876, 6171.88920770380},
	{0.00000000038, 0.25558032671, 6394.26249227900},
	{0.00000000039, 3.31511780881, 29826.30635467320},
	{0.00000000038, 4.03952051907, 16062.18452611680},
	{0.00000000037, 2.07587316842, 20452.86941222180},
	{0.00000000049, 5.78169307611, 18216.44381066100},
	{0.00000000041, 1.35496527372, 29088.81141598500},
	{0.00000000038, 6.16268217428, 18202.21671665939},
	{0.00000000036, 3.84319801860, 39302.09696219600},
	{0.00000000038, 6.14920442251, 26709.64694241340},
	{0.00000000036, 6.28049708584, 9924.81042151060},
	{0.00000000035, 4.66732134451, 4061.21921539440},
	{0.00000000040, 3.43223548088, 27511.46787353720},
	{0.00000000034, 1.38801022558, 6147.45052498140},
	{0.00000000034, 5.26052334707, 6418.70117500140},
	{0.00000000034, 1.97967478962, 17271.88400752640},
	{0.00000000037, 6.05744777692, 21150.81336588360},
	{0.00000000034, 1.90509484306, 29026.48522950779},
	{0.00000000035, 3.20661690466, 7322.10246078180},
	{0.00000000044, 2.79017179925, 3981.49003408200},
	{0.00000000034, 1.21719184072, 21548.96236929180},
	{0.00000000033, 4.13127114332, 173566.83743765688},
	{0.00000000033, 3.22867201822, 30666.15495843280},
	{0.00000000034, 4.95128499531, 38500.27603107220},
	{0.00000000032, 4.38302389502, 17686.75284556640},
	{0.00000000038, 4.95582614524, 19004.64794940840},
	{0.00000000033, 1.70921741352, 34520.30930938080},
	{0.00000000041, 4.09101902227, 21202.09370374600},
	{0.00000000031, 0.28544969417, 22003.91463486980},
	{0.00000000037, 1.21597687953, 7349.57132718140},
	{0.00000000031, 0.19462514993, 27832.03821928320},
	{0.00000000037, 3.41912843249, 29296.61538957860},
	{0.00000000035, 2.69261244483, 11919.14086666800},
	{0.00000000035, 0.83074174405, 29062.51309618520},
	{0.00000000030, 2.96012497927, 12489.88562870720},
	{0.00000000035, 4.83736876925, 21228.39202354580},
	{0.00000000032, 6.26164802166, 6231.79551212899},
	{0.00000000032, 0.38688555099, 6334.35618785381},
	{0.00000000029, 0.70432070922, 49515.38250840700},
	{0.00000000032, 0.44788919628, 31172.65064598300},
	{0.00000000031, 2.69970301246, 33019.02111220460},
	{0.00000000029, 2.26256470092, 27278.46881644080},
	{0.00000000031, 3.19023486538, 5017.50837136500},
	{0.00000000028, 1.87849143707, 24080.03501677719},
	{0.00000000034, 0.78574341965, 5905.70224207560},
	{0.00000000034, 5.86279015300, 6660.44945790720},
	{0.00000000038, 5.12224209756, 31570.79964939120},
	{0.00000000027, 3.76025315460, 19402.79695281660},
	{0.00000000027, 0.53327304803, 233141.31440436149},
	{0.00000000030, 2.32405719366, 12586.92709547520},
	{0.00000000028, 5.54772804461, 34911.41207609100},
	{0.00000000027, 5.30079330746, 43232.30665841560},
	{0.00000000027, 6.17189140209, 1692.16566950240},
	{0.00000000036, 4.81217077776, 15664.03552270859},
	{0.00000000027, 0.65637418130, 6360.74962041940},
	{0.00000000027, 5.99215939135, 6205.40207956340},
	{0.00000000026, 3.42413737440, 24383.07910844140},
	{0.00000000033, 3.45722382528, 28628.33622609960},
	{0.00000000027, 2.32049228976, 32367.09765620760},
	{0.00000000026, 1.98182489066, 19804.82729158280},
	{0.00000000027, 1.77114813957, 4487.81740627040},
	{0.00000000028, 2.89944615107, 58953.14544329400},
	{0.00000000028, 3.80331477821, 10239.58386601080},
	{0.00000000026, 0.36912120822, 6339.97422492700},
	{0.00000000026, 6.27941236443, 6226.17747505580},
	{0.00000000026, 6.01416870867, 4797.09572892620},
	{0.00000000028, 2.80825729869, 22476.73502749179},
	{0.00000000029, 0.17746825116, 6592.35417264720},
	{0.00000000029, 0.18788001431, 5973.79752733560},
	{0.00000000026, 3.93576097012, 36949.23080842420},
	{0.00000000027, 0.64682460545, 29424.63423291600},
	{0.00000000026, 2.54059552040, 9910.58332750900},
	{0.00000000028, 2.41855003101, 46386.99374331120},
	{0.00000000024, 1.22629501602, 21947.11137270000},
	{0.00000000024, 0.55027097678, 11616.97609101300},
	{0.00000000025, 2.78491065355, 6302.74561089119},
	{0.00000000025, 3.86362291910, 6263.40608909160},
	{0.00000000026, 4.44347824401, 15110.46611986620},
	{0.00000000027, 5.91935985488, 52175.80628314840},
	{0.00000000028, 6.10918595816, 18052.92954315780},
	{0.00000000023, 1.99242379288, 30774.50164257480},
	{0.00000000024, 3.73458431258, 31968.94865279940},
	{0.00000000023, 0.62347300029, 17892.93839400359},
	{0.00000000024, 3.21260068222, 23550.34405168259},
	{0.00000000023, 1.36063534536, 6716.78758786820},
	{0.00000000027, 0.02724821878, 25158.60171976540},
	{0.00000000026, 3.57645528088, 8584.66166590080},
	{0.00000000022, 3.99741791962, 7445.55055439920},
	{0.00000000022, 6.10694895695, 15265.88651930040},
	{0.00000000025, 0.81555419576, 14155.22459526660},
	{0.00000000023, 3.06283945185, 6272.03014972750},
	{0.00000000023, 3.58569412080, 6294.12155025530},
	{0.00000000025, 2.44880076940, 20199.09495963300},
	{0.00000000021, 5.78253540504, 22779.43724619380},
	{0.00000000023, 2.25096306087, 34115.11406927460},
	{0.00000000022, 4.67990936559, 34596.36465465240},
	{0.00000000029, 0.93434607315, 11933.36796066960},
	{0.00000000021, 4.08577407328, 30220.93223973240},
	{0.00000000020, 0.47093224249, 47162.51635463520},
	{0.00000000022, 1.38262024424, 4379.63903749020},
	{0.00000000020, 5.31355969163, 40879.44050464380},
	{0.00000000022, 4.52226925108, 28759.81087748319},
	{0.00000000026, 3.41054638032, 18422.62935909819},
	{0.00000000027, 0.67002293804, 34513.26307268280},
	{0.00000000019, 4.78610064760, 28313.28880466100},
	{0.00000000020, 5.09152714894, 8186.51266249260},
	{0.00000000025, 3.53211055104, 55798.45835839840},
	{0.00000000025, 0.38024667868, 9225.53927328300},
	{0.00000000020, 1.71238700404, 27433.88921587499},
	{0.00000000024, 1.20856889899, 9411.46461508720},
	{0.00000000020, 1.65292451759, 6379.05507720920},
	{0.00000000020, 4.99560905506, 6187.09662277360},
	{0.00000000020, 2.94178503134, 19800.94595622480},
	{0.00000000020, 4.32349571107, 62883.35513951360},
	{0.00000000022, 4.44470422678, 18326.65013188039},
	{0.00000000019, 4.37840329985, 16207.88627150200},
	{0.00000000022, 4.46505143635, 6332.83287546320},
	{0.00000000022, 2.18348213630, 6233.31882451960},
	{0.00000000019, 1.36569875427, 23539.70738633280},
	{0.00000000018, 4.61817062443, 6593.91664885980},
	{0.00000000018, 2.03036294822, 5972.23505112300},
	{0.00000000019, 2.36455752682, 5618.31980486140},
	{0.00000000019, 4.28397604583, 6947.83189512140},
	{0.00000000019, 0.18461307728, 83973.83535572988},
	{0.00000000019, 4.29574440213, 84019.85928049390},
	{0.00000000020, 2.85390720284, 9070.11887384880},
	{0, 0, 0}
};

struct vsop87_term earth_x2[] = {
	{0.00004143217, 3.14159265359, 0.00000000000},
	{0.00002175695, 4.39999849572, 12566.15169998280},
	{0.00000995233, 0.20790847155, 6283.07584999140},
	{0.00000092659, 4.19285471010, 18849.22754997420},
	{0.00000013679, 3.37833642063, 6286.59896834040},
	{0.00000013668, 3.27271492019, 6279.55273164240},
	{0.00000008190, 4.41928022030, 6256.77753019160},
	{0.00000008145, 2.22925093408, 6309.37416979120},
	{0.00000008004, 5.92288197328, 6127.65545055720},
	{0.00000007746, 0.72469358509, 6438.49624942560},
	{0.00000008899, 5.38113427234, 83996.84731811189},
	{0.00000004754, 6.16710003373, 709.93304855830},
	{0.00000003737, 2.48724420764, 5507.55323866740},
	{0.00000002893, 4.94972697460, 4705.73230754360},
	{0.00000002937, 4.08160813245, 25132.30339996560},
	{0.00000003203, 4.14275083744, 7058.59846131540},
	{0.00000002254, 3.51957213521, 775.52261132400},
	{0.00000002170, 1.70495739017, 7860.41939243920},
	{0.00000002031, 2.29363438970, 6275.96230299060},
	{0.00000002031, 4.35489918295, 6290.18939699220},
	{0.00000001904, 4.46668961834, 5486.77784317500},
	{0.00000001720, 5.23142094282, 1059.38193018920},
	{0.00000001548, 2.12906745749, 6040.34724601740},
	{0.00000001563, 2.18101487697, 7079.37385680780},
	{0.00000001456, 3.53770823599, 5753.38488489680},
	{0.00000001424, 3.16250984559, 6812.76681508600},
	{0.00000001470, 4.51659549398, 6525.80445396540},
	{0.00000001429, 3.01998118552, 5884.92684658320},
	{0.00000001288, 3.62892288697, 6681.22485339960},
	{0.00000001338, 1.04445705185, 5729.50644714900},
	{0.00000001039, 5.85310113863, 6282.09552892320},
	{0.00000001039, 0.79543243402, 6284.05617105960},
	{0.00000001212, 5.61713170172, 6836.64525283380},
	{0.00000000904, 2.43535199673, 5331.35744374080},
	{0.00000000871, 3.84816000443, 4933.20844033260},
	{0.00000000879, 3.06133930098, 11790.62908865880},
	{0.00000001102, 4.59510736976, 167283.76158766549},
	{0.00000000769, 4.22812146942, 7234.79425624200},
	{0.00000000744, 0.34956564055, 4136.91043351620},
	{0.00000000939, 3.62288542048, 11856.21865142450},
	{0.00000000675, 2.82587446878, 7632.94325965020},
	{0.00000000654, 1.40322441961, 11506.76976979360},
	{0.00000000854, 5.24328642976, 4535.05943692440},
	{0.00000000665, 4.81749499447, 1194.44701022460},
	{0.00000000834, 5.75118975782, 155.42039943420},
	{0.00000000785, 5.88776299473, 5088.62883976680},
	{0.00000000548, 6.12128965864, 796.29800681640},
	{0.00000000686, 1.90135823927, 801.82093112380},
	{0.00000000507, 5.42408029291, 4694.00295470760},
	{0.00000000677, 2.71965226391, 3128.38876509580},
	{0.00000000499, 3.02752235850, 12569.67481833180},
	{0.00000000480, 0.01327044252, 8429.24126646660},
	{0.00000000592, 1.39433962245, 8031.09226305840},
	{0.00000000498, 6.19000103499, 1589.07289528380},
	{0.00000000562, 0.77105088912, 7477.52286021600},
	{0.00000000415, 0.00558962450, 6069.77675455340},
	{0.00000000415, 0.35131226280, 6496.37494542940},
	{0.00000000402, 1.72177128440, 3738.76143010800},
	{0.00000000503, 3.41456622371, 1592.59601363280},
	{0.00000000390, 5.36711219721, 26.29831979980},
	{0.00000000372, 4.35153585802, 553.56940284240},
	{0.00000000458, 0.85618925594, 156137.47598479928},
	{0.00000000325, 2.94948293011, 951.71840625060},
	{0.00000000321, 2.01798251637, 1990.74501704100},
	{0.00000000335, 1.12608331535, 4690.47983635860},
	{0.00000000366, 0.10449761483, 12721.57209941700},
	{0.00000000287, 2.26476426223, 242.72860397400},
	{0.00000000347, 1.34248948630, 5481.25491886760},
	{0.00000000368, 3.91910931412, 9437.76293488700},
	{0.00000000255, 1.83876117314, 11371.70468975820},
	{0.00000000242, 4.92327001310, 8827.39026987480},
	{0.00000000307, 1.56817330160, 1349.86740965880},
	{0.00000000242, 0.12263961387, 1748.01641306700},
	{0.00000000222, 4.88851960168, 4164.31198961300},
	{0.00000000230, 1.05870192923, 3154.68708489560},
	{0.00000000204, 0.44240387853, 11769.85369316640},
	{0.00000000188, 5.65888993470, 7875.67186362420},
	{0.00000000189, 0.61654841817, 2388.89402044920},
	{0.00000000233, 5.23023625373, 7084.89678111520},
	{0.00000000183, 4.10128236867, 7342.45778018060},
	{0.00000000173, 0.52511015365, 10977.07880469900},
	{0.00000000159, 2.72294432534, 4292.33083295040},
	{0.00000000207, 2.28587256917, 13367.97263110660},
	{0.00000000202, 3.21445201981, 10973.55568635000},
	{0.00000000145, 5.45882589245, 398.14900340820},
	{0.00000000155, 5.81412827494, 12410.73130054860},
	{0.00000000134, 4.56296979111, 10575.40668294180},
	{0.00000000127, 4.84612567560, 13119.72110282519},
	{0.00000000115, 4.96539448045, 2146.16541647520},
	{0.00000000125, 3.87814283336, 12562.62858163380},
	{0.00000000125, 0.17913722961, 8635.94200376320},
	{0.00000000122, 1.05019176110, 12592.45001978260},
	{0.00000000111, 2.15765835240, 1577.34354244780},
	{0.00000000134, 6.25201667258, 3930.20969621960},
	{0.00000000107, 3.43601884429, 13517.87010623340},
	{0.00000000102, 4.37125144267, 10988.80815753500},
	{0.00000000095, 5.98656941724, 17260.15465469040},
	{0.00000000100, 2.34969093002, 13095.84266507740},
	{0.00000000110, 3.63768958070, 5223.69391980220},
	{0.00000000085, 4.32512089859, 3894.18182954220},
	{0.00000000109, 3.99726753431, 12539.85338018300},
	{0.00000000079, 5.22586609526, 16730.46368959580},
	{0.00000000079, 0.08497701397, 10447.38783960440},
	{0.00000000076, 4.11846374330, 12323.42309600880},
	{0.00000000105, 3.53845510796, 5642.19824260920},
	{0.00000000075, 5.73067319226, 6709.67404086740},
	{0.00000000075, 0.91786038039, 5856.47765911540},
	{0.00000000082, 5.90914298142, 10177.25767953360},
	{0.00000000100, 0.66749297482, 250570.67585721909},
	{0.00000000071, 0.59970099558, 14314.16811304980},
	{0.00000000092, 1.98240564470, 13916.01910964160},
	{0.00000000091, 3.10960444681, 6923.95345737360},
	{0.00000000082, 4.00218490582, 31415.37924995700},
	{0.00000000083, 5.97854162397, 95143.13292097810},
	{0.00000000061, 4.23984291228, 8273.82086703240},
	{0.00000000055, 1.41429091428, 5643.17856367740},
	{0.00000000057, 4.71394484871, 639.89728631400},
	{0.00000000054, 5.63153101737, 16496.36139620240},
	{0.00000000075, 5.01329496789, 71430.69561812909},
	{0.00000000055, 3.83548544187, 13341.67431130680},
	{0.00000000052, 4.39839251424, 3634.62102451840},
	{0.00000000056, 1.31106242697, 15720.83878487840},
	{0.00000000050, 4.18716262207, 12573.26524698360},
	{0.00000000064, 3.35781526441, 4732.03062734340},
	{0.00000000066, 5.49585898905, 2787.04302385740},
	{0.00000000048, 2.02353005537, 13362.44970679920},
	{0.00000000049, 2.48296676043, 14143.49524243060},
	{0.00000000053, 4.12375134867, 14919.01785375460},
	{0.00000000047, 3.82959048333, 12964.30070339100},
	{0.00000000042, 0.38069707842, 24072.92146977640},
	{0.00000000051, 1.26573618407, 6195.76764545159},
	{0.00000000051, 5.38279738858, 6370.38405453120},
	{0.00000000048, 0.59989438773, 2118.76386037840},
	{0.00000000041, 2.49731951011, 18319.53658487960},
	{0.00000000041, 4.09328168773, 3185.19202726560},
	{0.00000000056, 1.01626259839, 84672.47584450469},
	{0.00000000039, 4.27641929836, 20426.57109242200},
	{0.00000000053, 3.21190793912, 239424.39025435288},
	{0.00000000040, 6.05039617409, 3496.03282613400},
	{0.00000000044, 1.67103342381, 8662.24032356300},
	{0.00000000043, 3.69693055127, 18139.29450141590},
	{0.00000000035, 3.60804630271, 18875.52586977400},
	{0.00000000035, 6.09077128153, 10419.98628350760},
	{0.00000000033, 0.53088739877, 10213.28554621100},
	{0.00000000031, 0.64652215197, 23013.53953958720},
	{0.00000000035, 0.91150627653, 9779.10867612540},
	{0.00000000030, 4.39715700541, 12808.88030395680},
	{0.00000000042, 5.61217219717, 82576.98122099529},
	{0.00000000031, 5.53053428232, 14712.31711645800},
	{0.00000000041, 5.62875780162, 17789.84561978500},
	{0.00000000031, 0.76672410297, 22779.43724619380},
	{0.00000000028, 2.34481351815, 5429.87946823940},
	{0.00000000027, 4.68961132588, 16200.77272450120},
	{0.00000000028, 3.91086715449, 11015.10647733480},
	{0.00000000026, 2.29393980670, 9623.68827669120},
	{0.00000000026, 4.35459376595, 2942.46342329160},
	{0.00000000026, 1.75234208326, 18209.33026366019},
	{0.00000000025, 6.04606961258, 9917.69687450980},
	{0.00000000025, 2.68813215214, 3583.34103067380},
	{0.00000000026, 0.90493478768, 12012.58229714040},
	{0.00000000023, 2.29788589227, 9380.95967271720},
	{0.00000000023, 2.49168005831, 12559.03815298200},
	{0.00000000023, 2.26727226510, 26709.64694241340},
	{0.00000000024, 4.92046069591, 77713.77146812050},
	{0.00000000022, 5.99172814093, 6993.00889854970},
	{0.00000000021, 2.38334945179, 17256.63153634140},
	{0.00000000023, 0.80841468126, 149854.40013480789},
	{0.00000000026, 3.19870156016, 84334.66158130829},
	{0.00000000023, 2.53410224481, 19651.04848109800},
	{0.00000000019, 1.93058658449, 11926.25441366880},
	{0.00000000018, 2.28255799994, 11614.43329373220},
	{0.00000000019, 3.66100662326, 30639.85663863300},
	{0.00000000022, 3.76382094449, 17298.18232732620},
	{0.00000000019, 5.39096925285, 16460.33352952499},
	{0.00000000023, 4.78353231767, 72850.56171524568},
	{0.00000000018, 3.19936496001, 18073.70493865020},
	{0.00000000017, 3.95703025000, 8982.81066930900},
	{0.00000000021, 3.77368081700, 16858.48253293320},
	{0.00000000021, 4.47047819380, 12036.46073488820},
	{0.00000000015, 0.65562803693, 16062.18452611680},
	{0.00000000014, 4.12927933278, 2352.86615377180},
	{0.00000000015, 4.21849500083, 20199.09495963300},
	{0.00000000014, 0.15947511180, 22483.84857449259},
	{0.00000000019, 2.81419648175, 8671.96987044060},
	{0.00000000014, 1.26341547558, 90279.92316810328},
	{0.00000000016, 0.41160329502, 23543.23050468179},
	{0.00000000012, 2.70990889006, 17996.03116822220},
	{0.00000000012, 0.72222975090, 19402.79695281660},
	{0.00000000012, 4.37880728616, 10818.13528691580},
	{0.00000000015, 0.57625721169, 12567.13202105100},
	{0.00000000011, 1.78472830783, 28766.92442448400},
	{0.00000000013, 3.18567583228, 5573.14280143310},
	{0.00000000011, 4.93327896664, 18451.07854656599},
	{0.00000000011, 5.43587992260, 14945.31617355440},
	{0.00000000011, 2.24607508630, 35371.88726597640},
	{0.00000000011, 5.02228901732, 22805.73556599360},
	{0.00000000010, 2.16930383321, 15664.03552270859},
	{0.00000000014, 1.93314444705, 21228.39202354580},
	{0.00000000010, 6.05310595892, 23141.55838292460},
	{0.00000000010, 2.55645282698, 22345.26037610820},
	{0.00000000009, 1.49155179482, 29826.30635467320},
	{0.00000000010, 0.18358815992, 12779.45079542080},
	{0.00000000011, 4.05473090705, 23581.25817731760},
	{0.00000000011, 0.39656469738, 25158.60171976540},
	{0, 0, 0}
};

struct vsop87_term earth_x3[] = {
	{0.00000175213, 3.14159265359, 0.00000000000},
	{0.00000072337, 2.89303952476, 12566.15169998280},
	{0.00000008364, 3.85500954096, 6283.07584999140},
	{0.00000005040, 2.53152989786, 18849.22754997420},
	{0.00000001481, 2.23672235234, 6438.49624942560},
	{0.00000001481, 4.41181122031, 6127.65545055720},
	{0.00000000644, 4.88567904780, 6279.55273164240},
	{0.00000000644, 1.76285452485, 6286.59896834040},
	{0.00000000318, 3.63840310183, 6040.34724601740},
	{0.00000000318, 3.01013047082, 6525.80445396540},
	{0.00000000220, 2.34166945312, 25132.30339996560},
	{0.00000000201, 0.82714760810, 6836.64525283380},
	{0.00000000201, 5.82138596455, 5729.50644714900},
	{0.00000000036, 1.41202770454, 12569.67481833180},
	{0.00000000033, 4.23554585611, 12410.73130054860},
	{0.00000000018, 2.32709487755, 12721.57209941700},
	{0.00000000011, 6.27313981891, 12592.45001978260},
	{0.00000000006, 2.56028859854, 242.72860397400},
	{0, 0, 0}
};

struct vsop87_term earth_x4[] = {
	{0.00000004022, 0.00000000000, 0.00000000000},
	{0.00000001927, 1.18746233453, 12566.15169998280},
	{0.00000000491, 5.29890244491, 6283.07584999140},
	{0.00000000210, 3.74319530048, 6438.49624942560},
	{0.00000000210, 2.90533827217, 6127.65545055720},
	{0.00000000229, 0.88072621187, 18849.22754997420},
	{0.00000000044, 4.59638160457, 709.93304855830},
	{0.00000000021, 0.18394116301, 6279.55273164240},
	{0.00000000021, 0.18140710246, 6286.59896834040},
	{0.00000000013, 3.81035106449, 83996.84731811189},
	{0.00000000011, 0.65552931190, 25132.30339996560},
	{0.00000000009, 5.19374498802, 11856.21865142450},
	{0.00000000007, 6.16589776486, 167283.76158766549},
	{0.00000000005, 2.68915538708, 12410.73130054860},
	{0.00000000006, 5.56853736836, 156137.47598479928},
	{0, 0, 0}
};

struct vsop87_term earth_x5[] = {
	{0.00000000108, 0.00000000000, 0.00000000000},
	{0.00000000043, 6.08789652058, 12566.15169998280},
	{0.00000000025, 5.33779665346, 6438.49624942560},
	{0.00000000025, 1.31073691919, 6127.65545055720},
	{0.00000000020, 0.94333339828, 6283.07584999140},
	{0.00000000008, 5.52588061142, 18849.22754997420},
	{0, 0, 0}
};

struct vsop87_term earth_y0[] = {
	{0.99989211030, 0.18265890456, 6283.07584999140},
	{0.02442699036, 3.14159265359, 0.00000000000},
	{0.00835292314, 0.13952878991, 12566.15169998280},
	{0.00010466965, 0.09641690558, 18849.22754997420},
	{0.00003110838, 5.38114091484, 83996.84731811189},
	{0.00002570338, 5.30103973360, 529.69096509460},
	{0.00002147473, 2.66253538905, 1577.34354244780},
	{0.00001709219, 5.20780401071, 6279.55273164240},
	{0.00001707987, 4.58232858766, 6286.59896834040},
	{0.00001440265, 1.90068164664, 2352.86615377180},
	{0.00001135092, 5.27313415220, 5223.69391980220},
	{0.00000934539, 4.50301201844, 12036.46073488820},
	{0.00000900565, 1.60563288120, 10213.28554621100},
	{0.00000567126, 0.58142248753, 1059.38193018920},
	{0.00000744932, 2.80728871886, 398.14900340820},
	{0.00000639316, 6.02923915017, 5753.38488489680},
	{0.00000681324, 0.64729627497, 4705.73230754360},
	{0.00000611347, 3.81381495286, 6812.76681508600},
	{0.00000450435, 4.52785572489, 5884.92684658320},
	{0.00000452018, 5.99167242707, 6256.77753019160},
	{0.00000449968, 3.79880375595, 6309.37416979120},
	{0.00000551390, 3.96125249369, 5507.55323866740},
	{0.00000406334, 5.25616268027, 6681.22485339960},
	{0.00000541273, 5.49902805917, 775.52261132400},
	{0.00000546360, 6.17311131785, 14143.49524243060},
	{0.00000507084, 2.87025193381, 7860.41939243920},
	{0.00000219504, 2.95216139568, 11506.76976979360},
	{0.00000227937, 5.95179248814, 7058.59846131540},
	{0.00000227792, 4.84547074733, 4694.00295470760},
	{0.00000255845, 0.69454231563, 12168.00269657460},
	{0.00000256132, 6.16722512388, 709.93304855830},
	{0.00000179242, 1.40003446021, 796.29800681640},
	{0.00000178280, 5.11717552231, 6283.00853968860},
	{0.00000178280, 4.67307255246, 6283.14316029419},
	{0.00000155454, 0.05340525434, 25132.30339996560},
	{0.00000206257, 4.28366728882, 11790.62908865880},
	{0.00000149769, 6.07429023278, 5486.77784317500},
	{0.00000200005, 2.50144088120, 17789.84561978500},
	{0.00000129006, 3.64623708634, 7079.37385680780},
	{0.00000128211, 3.23254821381, 3738.76143010800},
	{0.00000152790, 5.58120800450, 213.29909543800},
	{0.00000118725, 5.45361490488, 9437.76293488700},
	{0.00000078419, 0.28253093914, 8827.39026987480},
	{0.00000073513, 1.12433371880, 1589.07289528380},
	{0.00000065694, 2.08898587059, 11769.85369316640},
	{0.00000063240, 0.67044491570, 6262.30045449900},
	{0.00000062961, 2.83649755996, 6303.85124548380},
	{0.00000085870, 1.45351152151, 167283.76158766549},
	{0.00000063616, 0.49038985445, 7.11354700080},
	{0.00000080740, 0.92225805400, 6069.77675455340},
	{0.00000083511, 4.63223527298, 3340.61242669980},
	{0.00000060039, 1.82878888713, 4136.91043351620},
	{0.00000075626, 2.58860726122, 6496.37494542940},
	{0.00000058089, 0.55165509745, 10977.07880469900},
	{0.00000053747, 6.27553948416, 1194.44701022460},
	{0.00000057574, 1.10802134270, 6282.09552892320},
	{0.00000057574, 2.39891957636, 6284.05617105960},
	{0.00000051141, 6.02458046766, 6290.18939699220},
	{0.00000050679, 3.77133779892, 6275.96230299060},
	{0.00000049613, 1.07290390127, 6127.65545055720},
	{0.00000047934, 2.43176952238, 6438.49624942560},
	{0.00000061133, 5.34335721244, 3154.68708489560},
	{0.00000048425, 0.05833183710, 801.82093112380},
	{0.00000047359, 4.53607945311, 3128.38876509580},
	{0.00000048379, 0.25856696781, 7084.89678111520},
	{0.00000051293, 4.21367834558, 12352.85260454480},
	{0.00000050630, 0.48144269678, 11856.21865142450},
	{0.00000037539, 1.60040603609, 8429.24126646660},
	{0.00000049347, 2.15740113992, 2544.31441988340},
	{0.00000039555, 3.35943284176, 5481.25491886760},
	{0.00000048913, 5.16531049040, 9225.53927328300},
	{0.00000042135, 2.06532560040, 17260.15465469040},
	{0.00000037954, 1.47005640108, 426.59819087600},
	{0.00000031140, 3.61579568733, 2146.16541647520},
	{0.00000032603, 4.41806626166, 4164.31198961300},
	{0.00000039728, 4.70048863454, 5856.47765911540},
	{0.00000028515, 4.53853388964, 12569.67481833180},
	{0.00000036368, 1.33416490018, 18073.70493865020},
	{0.00000025032, 3.74982021361, 26.29831979980},
	{0.00000030329, 0.42324614391, 4535.05943692440},
	{0.00000026741, 5.97172882162, 3930.20969621960},
	{0.00000028166, 5.19366222912, 12562.62858163380},
	{0.00000024843, 1.00265326013, 5088.62883976680},
	{0.00000021642, 3.06444526478, 12559.03815298200},
	{0.00000025701, 0.75895390818, 13367.97263110660},
	{0.00000020498, 3.44435384536, 11371.70468975820},
	{0.00000025997, 1.87312778491, 71430.69561812909},
	{0.00000017888, 5.01504194498, 1748.01641306700},
	{0.00000023246, 4.61910038205, 18319.53658487960},
	{0.00000017077, 5.29722216277, 4933.20844033260},
	{0.00000021070, 2.22959477131, 7477.52286021600},
	{0.00000017512, 6.16192589291, 10447.38783960440},
	{0.00000020024, 2.96823180998, 8031.09226305840},
	{0.00000013831, 3.02450528624, 8635.94200376320},
	{0.00000014095, 6.03707103538, 2942.46342329160},
	{0.00000018884, 0.85614789376, 156137.47598479928},
	{0.00000017861, 4.86809570283, 1592.59601363280},
	{0.00000013605, 3.62641145030, 13095.84266507740},
	{0.00000015078, 1.55132224732, 16496.36139620240},
	{0.00000017985, 2.07741211308, 17298.18232732620},
	{0.00000014386, 6.14898732933, 20426.57109242200},
	{0.00000012227, 4.38359423735, 7632.94325965020},
	{0.00000013376, 2.03616887071, 12139.55350910680},
	{0.00000011583, 3.88971333608, 5331.35744374080},
	{0.00000013558, 1.44666331503, 16730.46368959580},
	{0.00000014332, 4.45678693729, 7342.45778018060},
	{0.00000012375, 1.53862289477, 6279.48542133960},
	{0.00000012366, 1.96831814872, 6286.66627864320},
	{0.00000012446, 5.78094918529, 15110.46611986620},
	{0.00000010989, 0.62040343662, 10988.80815753500},
	{0.00000012556, 2.59194808538, 15720.83878487840},
	{0.00000011583, 2.48165809843, 5729.50644714900},
	{0.00000009023, 3.85655029499, 9623.68827669120},
	{0.00000009121, 5.83006047147, 7234.79425624200},
	{0.00000008869, 3.47611265290, 6148.01076995600},
	{0.00000008614, 0.03081589303, 6418.14093002680},
	{0.00000007911, 1.58348238359, 2118.76386037840},
	{0.00000008293, 0.85407021371, 14712.31711645800},
	{0.00000010219, 0.13075179540, 1349.86740965880},
	{0.00000010126, 0.99630008630, 6836.64525283380},
	{0.00000010480, 1.38209301929, 5999.21653112620},
	{0.00000007353, 3.83220307326, 6040.34724601740},
	{0.00000009820, 2.12476655144, 6566.93516885660},
	{0.00000007018, 5.94659180519, 6525.80445396540},
	{0.00000006874, 4.57503512461, 7238.67559160000},
	{0.00000007545, 5.94843444430, 12539.85338018300},
	{0.00000009540, 3.49613271706, 21228.39202354580},
	{0.00000007202, 4.31311898936, 6245.04817735560},
	{0.00000007144, 5.47703560836, 6321.10352262720},
	{0.00000006627, 5.41373102778, 5327.47610838280},
	{0.00000008544, 1.82829301857, 11015.10647733480},
	{0.00000008602, 5.43953575310, 5643.17856367740},
	{0.00000006158, 5.65852675233, 12964.30070339100},
	{0.00000007414, 3.46720433621, 23543.23050468179},
	{0.00000007317, 2.01664477821, 536.80451209540},
	{0.00000006352, 3.46461304398, 1990.74501704100},
	{0.00000006251, 1.52860898333, 951.71840625060},
	{0.00000005828, 1.37555383064, 955.59974160860},
	{0.00000006389, 2.40580071461, 24072.92146977640},
	{0.00000006976, 4.76626361488, 10973.55568635000},
	{0.00000006916, 5.39658071678, 522.57741809380},
	{0.00000007459, 2.71133898870, 22003.91463486980},
	{0.00000005376, 2.34968505500, 14314.16811304980},
	{0.00000006852, 4.33781274406, 155.42039943420},
	{0.00000007527, 1.94392127074, 18422.62935909819},
	{0.00000006222, 0.67296135144, 18451.07854656599},
	{0.00000005836, 0.75921238848, 639.89728631400},
	{0.00000006487, 2.22135874272, 5216.58037280140},
	{0.00000006251, 2.88399458161, 6288.59877429880},
	{0.00000006251, 0.62294633745, 6277.55292568400},
	{0.00000007004, 3.57492830242, 103.09277421860},
	{0.00000005337, 1.97127813671, 4690.47983635860},
	{0.00000005605, 1.92150700481, 1551.04522264800},
	{0.00000006210, 0.81866451118, 5650.29211067820},
	{0.00000006064, 5.19708779870, 5230.80746680300},
	{0.00000004596, 2.92936593195, 553.56940284240},
	{0.00000005386, 5.40633950052, 77713.77146812050},
	{0.00000006332, 2.83725098708, 26087.90314157420},
	{0.00000006196, 4.15787078176, 84672.47584450469},
	{0.00000006160, 3.21170435536, 239424.39025435288},
	{0.00000005016, 1.46006858313, 4732.03062734340},
	{0.00000005414, 1.42882325200, 6179.98307577280},
	{0.00000005413, 2.08325983447, 6386.16862421000},
	{0.00000004863, 2.19642746549, 90279.92316810328},
	{0.00000005711, 2.75630374926, 6915.85958930460},
	{0.00000004270, 0.81269903423, 7875.67186362420},
	{0.00000004017, 2.21501265909, 6254.62666252360},
	{0.00000004071, 3.99159158863, 3634.62102451840},
	{0.00000003993, 1.29192500625, 6311.52503745920},
	{0.00000004858, 1.27914374675, 5760.49843189760},
	{0.00000005274, 4.91687036691, 25158.60171976540},
	{0.00000004120, 1.72568521475, 6709.67404086740},
	{0.00000004410, 2.23536264210, 6805.65326808520},
	{0.00000003174, 3.62030131501, 1066.49547719000},
	{0.00000003064, 2.46605561478, 5863.59120611620},
	{0.00000003083, 5.68731909779, 9917.69687450980},
	{0.00000003385, 3.81076637101, 13916.01910964160},
	{0.00000002979, 4.62987940723, 12566.21901028560},
	{0.00000003980, 5.90917210624, 13341.67431130680},
	{0.00000003290, 0.95752698537, 16200.77272450120},
	{0.00000003885, 3.94360149823, 74.78159856730},
	{0.00000003060, 1.63142398497, 18052.92954315780},
	{0.00000003745, 3.65023712104, 5966.68398033480},
	{0.00000003592, 4.03843804285, 6208.29425142410},
	{0.00000003581, 5.75234129258, 6357.85744855870},
	{0.00000003626, 6.13871061291, 6599.46771964800},
	{0.00000002927, 1.79201822142, 12721.57209941700},
	{0.00000003625, 1.43112641053, 6019.99192661860},
	{0.00000002589, 2.27559640821, 12592.45001978260},
	{0.00000002558, 6.08151329647, 10575.40668294180},
	{0.00000002670, 2.64370887209, 3.52311834900},
	{0.00000002611, 0.86180315523, 6702.56049386660},
	{0.00000002535, 0.01231078888, 31415.37924995700},
	{0.00000003520, 3.80906746266, 250570.67585721909},
	{0.00000003434, 2.07577333297, 6546.15977336420},
	{0.00000002378, 2.05651519036, 2388.89402044920},
	{0.00000002979, 5.07398237708, 12566.08438968000},
	{0.00000002716, 1.49855840728, 12029.34718788740},
	{0.00000002215, 3.69574321309, 13362.44970679920},
	{0.00000003049, 0.05228873308, 29088.81141598500},
	{0.00000002784, 3.37954165171, 14945.31617355440},
	{0.00000002284, 4.38146814547, 6076.89030155420},
	{0.00000002529, 4.37629589914, 12043.57428188900},
	{0.00000002015, 0.91352603582, 6262.72053059260},
	{0.00000002218, 5.40562909521, 6489.26139842860},
	{0.00000002005, 2.59344263770, 6303.43116939020},
	{0.00000002681, 5.85620039558, 4590.91018048900},
	{0.00000002011, 5.69828891426, 4701.11650170840},
	{0.00000002440, 4.55844746985, 149.56319713460},
	{0.00000002600, 3.93109819647, 19651.04848109800},
	{0.00000002197, 5.22411628121, 13517.87010623340},
	{0.00000001893, 4.09716259686, 6286.95718534940},
	{0.00000001893, 5.69296362938, 6279.19451463340},
	{0.00000002402, 4.84503253270, 1162.47470440780},
	{0.00000002156, 0.43826128691, 18139.29450141590},
	{0.00000001778, 2.79119893202, 4292.33083295040},
	{0.00000001966, 1.82224928185, 4686.88940770680},
	{0.00000002327, 2.83472726504, 10021.83728009940},
	{0.00000002436, 2.83689873280, 95143.13292097810},
	{0.00000002163, 6.13036765564, 6037.24420376200},
	{0.00000001841, 3.67947373190, 242.72860397400},
	{0.00000001672, 0.33097080655, 13119.72110282519},
	{0.00000002250, 0.82649282051, 12669.24447420140},
	{0.00000001627, 4.77445737868, 13521.75144159140},
	{0.00000001888, 2.87850805387, 8662.24032356300},
	{0.00000002052, 3.65927016475, 6528.90749622080},
	{0.00000001774, 0.51400448882, 6819.88036208680},
	{0.00000001840, 1.91711006767, 65147.61976813770},
	{0.00000001544, 1.33911061474, 110.20632121940},
	{0.00000001756, 2.96482886554, 5746.27133789600},
	{0.00000001543, 4.39018655159, 6272.43918464160},
	{0.00000001543, 5.39993967465, 6293.71251534120},
	{0.00000001952, 3.09643550846, 23013.53953958720},
	{0.00000001484, 2.15301976837, 20.77539549240},
	{0.00000001558, 2.79679951671, 17654.78053974960},
	{0.00000001440, 0.69014829975, 1052.26838318840},
	{0.00000001648, 3.98135416194, 632.78373931320},
	{0.00000001795, 1.47161886169, 33019.02111220460},
	{0.00000001488, 4.10377440731, 76.26607127560},
	{0.00000001349, 4.18018072818, 6016.46880826960},
	{0.00000001477, 2.56925128481, 12779.45079542080},
	{0.00000001252, 6.26830198321, 11499.65622279280},
	{0.00000001491, 4.65893645946, 9411.46461508720},
	{0.00000001471, 4.18695456530, 18635.92845453620},
	{0.00000001263, 5.62967869388, 12573.26524698360},
	{0.00000001385, 2.65776727703, 2379.16447357160},
	{0.00000001272, 5.60977857361, 6549.68289171320},
	{0.00000001578, 4.10046385407, 25934.12433108940},
	{0.00000001557, 4.78614835776, 18875.52586977400},
	{0.00000001358, 0.33781842226, 5120.60114558360},
	{0.00000001505, 2.70837129901, 18209.33026366019},
	{0.00000001460, 3.40156973977, 245.83164622940},
	{0.00000001252, 6.12407876457, 6993.00889854970},
	{0.00000001242, 1.27359177098, 24356.78078864160},
	{0.00000001464, 3.73000165992, 38.13303563780},
	{0.00000001028, 0.93950338023, 6112.40297937220},
	{0.00000001014, 4.36072926630, 17256.63153634140},
	{0.00000001312, 5.81330496460, 12491.37010141550},
	{0.00000000992, 2.56738139157, 6453.74872061060},
	{0.00000000988, 5.69171453384, 8273.82086703240},
	{0.00000001191, 1.64765684664, 6276.02961329339},
	{0.00000001191, 1.85928407242, 6290.12208668940},
	{0.00000000978, 3.16773119822, 6247.04798331399},
	{0.00000001223, 6.22694723537, 5429.87946823940},
	{0.00000000971, 0.33921097188, 6319.10371666880},
	{0.00000000962, 1.06488912173, 12565.17137891460},
	{0.00000001025, 0.64688768472, 12545.37630449040},
	{0.00000001234, 2.50427756599, 22483.84857449259},
	{0.00000001134, 5.76287831677, 17782.73207278420},
	{0.00000000944, 5.49712708636, 6306.95428773920},
	{0.00000000944, 4.29299913988, 6259.19741224360},
	{0.00000001092, 2.35048657695, 17796.95916678580},
	{0.00000000995, 1.11794413013, 10177.25767953360},
	{0.00000000894, 2.94681683620, 206.18554843720},
	{0.00000001216, 5.61396859194, 82576.98122099529},
	{0.00000000860, 6.19327755003, 1692.16566950240},
	{0.00000000942, 6.13301518193, 6267.82337880639},
	{0.00000000942, 3.65711104430, 6298.32832117640},
	{0.00000001045, 5.17292899506, 15508.61512327440},
	{0.00000000850, 6.16443178844, 6393.28217121080},
	{0.00000000873, 2.86766306801, 949.17560896980},
	{0.00000000896, 0.83013691514, 3903.91137641980},
	{0.00000001023, 5.42813246189, 220.41264243880},
	{0.00000000856, 1.36181993943, 4804.20927592700},
	{0.00000001033, 3.31340063953, 5573.14280143310},
	{0.00000000817, 3.58855573226, 6172.86952877200},
	{0.00000000917, 0.89919993710, 149854.40013480789},
	{0.00000001081, 2.89245979526, 36949.23080842420},
	{0.00000000779, 2.01260281552, 2648.45482547300},
	{0.00000000962, 2.35578735539, 12567.13202105100},
	{0.00000000990, 4.97210778261, 11403.67699557500},
	{0.00000000739, 3.39896198161, 11926.25441366880},
	{0.00000000929, 0.64994792213, 2787.04302385740},
	{0.00000000973, 6.19358824421, 22805.73556599360},
	{0.00000000743, 2.22828430376, 7834.12107263940},
	{0.00000000905, 2.24459183660, 6284.56032269970},
	{0.00000000905, 1.26234908246, 6281.59137728310},
	{0.00000000798, 1.05421393588, 12410.73130054860},
	{0.00000000813, 5.23283372183, 12416.58850284820},
	{0.00000000869, 1.74785663537, 6133.51265285680},
	{0.00000000756, 5.40063116731, 4061.21921539440},
	{0.00000000616, 4.13389755770, 1596.18644228460},
	{0.00000000724, 1.49651873854, 161000.68573767410},
	{0.00000000612, 5.89184406078, 16858.48253293320},
	{0.00000000814, 3.82004246488, 3894.18182954220},
	{0.00000000785, 2.44918664136, 4907.30205014560},
	{0.00000000788, 1.86746379419, 846.08283475120},
	{0.00000000611, 6.24387943735, 853.19638175200},
	{0.00000000570, 2.97586328906, 12586.92709547520},
	{0.00000000561, 5.85814246596, 12323.42309600880},
	{0.00000000646, 5.91116942848, 52175.80628314840},
	{0.00000000590, 0.47736597307, 15671.08175940660},
	{0.00000000555, 2.86698301793, 11513.88331679440},
	{0.00000000536, 4.49580958272, 18852.75066832320},
	{0.00000000737, 5.41358302312, 23581.25817731760},
	{0.00000000532, 3.01682571392, 18842.11400297339},
	{0.00000000552, 6.08260944683, 11933.36796066960},
	{0.00000000599, 0.54713576844, 6151.53388830500},
	{0.00000000540, 1.83361074884, 6279.78949257360},
	{0.00000000540, 1.67333017022, 6286.36220740920},
	{0.00000000513, 2.13211972766, 12455.94537876340},
	{0.00000000649, 3.33488856037, 11764.33076885900},
	{0.00000000582, 2.96012819576, 6414.61781167780},
	{0.00000000608, 2.37588807672, 10419.98628350760},
	{0.00000000620, 0.83937590497, 5326.78669402080},
	{0.00000000536, 2.13145334966, 7232.25145896120},
	{0.00000000538, 1.33481115516, 5333.90024102160},
	{0.00000000516, 1.35797709246, 433.71173787680},
	{0.00000000596, 0.99065349155, 6062.66320755260},
	{0.00000000664, 4.31358012484, 40879.44050464380},
	{0.00000000607, 4.79849916312, 5849.36411211460},
	{0.00000000629, 1.34455816041, 26735.94526221320},
	{0.00000000479, 6.04755907663, 5547.19933645960},
	{0.00000000565, 5.49238261982, 4171.42553661380},
	{0.00000000472, 3.81181804730, 10969.96525769820},
	{0.00000000462, 3.53729128828, 3104.93005942380},
	{0.00000000551, 2.46794798020, 6503.48849243020},
	{0.00000000535, 4.55197627124, 173566.83743765688},
	{0.00000000450, 0.38613288324, 4274.51831083240},
	{0.00000000527, 4.67747327047, 24602.61243487099},
	{0.00000000502, 5.68646136646, 12489.88562870720},
	{0.00000000603, 5.56725954240, 322711.30452390644},
	{0.00000000432, 5.22277533085, 9388.00590941520},
	{0.00000000530, 5.14730101928, 18845.70443162520},
	{0.00000000431, 3.74066314880, 7018.95236352320},
	{0.00000000484, 0.31541423564, 14.22709400160},
	{0.00000000560, 0.14432555287, 1581.95934828300},
	{0.00000000584, 4.78380792490, 72850.56171524568},
	{0.00000000408, 4.98636538552, 3496.03282613400},
	{0.00000000569, 1.38164944312, 97238.62754448749},
	{0.00000000478, 4.58275550120, 29296.61538957860},
	{0.00000000389, 1.85967717576, 6244.94281435360},
	{0.00000000389, 1.64726374330, 6321.20888562920},
	{0.00000000388, 5.85202122263, 6297.30294399300},
	{0.00000000388, 3.93810500361, 6268.84875598980},
	{0.00000000515, 0.09995703640, 12320.32005375340},
	{0.00000000395, 1.39225625253, 4157.19844261220},
	{0.00000000492, 4.39757189321, 1478.86657406440},
	{0.00000000423, 2.45281376602, 9779.10867612540},
	{0.00000000439, 3.25487944876, 233141.31440436149},
	{0.00000000501, 3.08355690853, 17157.06188047180},
	{0.00000000416, 2.17399987974, 13760.59871020740},
	{0.00000000503, 4.02857067171, 135.06508003540},
	{0.00000000393, 6.27884951137, 7872.14874527520},
	{0.00000000365, 0.53940975175, 6922.97313630540},
	{0.00000000409, 6.14577564379, 10984.19235169980},
	{0.00000000371, 4.19153897517, 13625.53363017200},
	{0.00000000370, 2.79623025524, 14919.01785375460},
	{0.00000000499, 1.15482230725, 161710.61878623239},
	{0.00000000379, 5.52650430530, 3185.19202726560},
	{0.00000000420, 1.76851201552, 22779.43724619380},
	{0.00000000485, 6.06683096360, 12528.01866434500},
	{0.00000000358, 1.58658367058, 6271.34649715540},
	{0.00000000358, 1.92035724848, 6294.80520282740},
	{0.00000000354, 2.96580857786, 17267.26820169119},
	{0.00000000351, 0.64808322427, 11616.97609101300},
	{0.00000000388, 5.20354943335, 956.28915597060},
	{0.00000000409, 2.03946298626, 21954.15760939799},
	{0.00000000369, 3.36327405725, 5436.99301524020},
	{0.00000000421, 3.25654135729, 7445.55055439920},
	{0.00000000361, 5.53538077166, 21393.54196985760},
	{0.00000000336, 6.12569565789, 6279.14369672830},
	{0.00000000336, 3.66443056835, 6287.00800325450},
	{0.00000000450, 1.80230243402, 1385.56157495110},
	{0.00000000315, 3.47678894225, 10873.98603048040},
	{0.00000000363, 2.71990145670, 7335.34423317980},
	{0.00000000347, 5.27040068469, 17253.04110768959},
	{0.00000000349, 1.04077270827, 316.39186965660},
	{0.00000000395, 3.82348293170, 5905.70224207560},
	{0.00000000308, 2.54337606421, 20995.39296644940},
	{0.00000000319, 5.30613709521, 38.02767263580},
	{0.00000000304, 4.87224757874, 5749.86176654780},
	{0.00000000414, 5.73458482925, 44809.65020086340},
	{0.00000000298, 2.28443357697, 640.87760738220},
	{0.00000000351, 4.36315900786, 12345.73905754400},
	{0.00000000304, 3.36893995706, 29826.30635467320},
	{0.00000000395, 4.78955929514, 4176.04134244900},
	{0.00000000329, 5.87961134010, 3.93215326310},
	{0.00000000374, 5.15697532254, 5642.19824260920},
	{0.00000000320, 0.92923666608, 10818.13528691580},
	{0.00000000365, 5.96664322939, 6660.44945790720},
	{0.00000000339, 4.53749520696, 6923.95345737360},
	{0.00000000357, 1.12153755723, 16460.33352952499},
	{0.00000000386, 0.71941423743, 2636.72547263700},
	{0.00000000273, 5.79109432105, 26709.64694241340},
	{0.00000000265, 3.53930695872, 19378.91851506880},
	{0.00000000325, 0.92198442483, 12359.96615154560},
	{0.00000000278, 3.86335874809, 20597.24396304120},
	{0.00000000294, 2.59935512947, 28286.99048486120},
	{0.00000000269, 4.91776226798, 6816.28993343500},
	{0.00000000357, 2.74654149425, 30666.15495843280},
	{0.00000000344, 1.94480070409, 6147.45052498140},
	{0.00000000255, 3.37524772579, 1375.77379984580},
	{0.00000000308, 5.40069482744, 29864.33402730900},
	{0.00000000334, 1.56223513612, 6418.70117500140},
	{0.00000000316, 3.97125662279, 6055.59971720240},
	{0.00000000243, 2.53093250846, 6310.47740608820},
	{0.00000000243, 0.97600841060, 6255.67429389460},
	{0.00000000296, 4.79138384974, 6129.29703950660},
	{0.00000000301, 5.81886973641, 6510.55198278040},
	{0.00000000329, 5.86928788098, 377.37360791580},
	{0.00000000282, 3.64505853337, 263.08392337280},
	{0.00000000267, 1.84936252726, 24705.70520908959},
	{0.00000000285, 0.93414827012, 5469.52556603160},
	{0.00000000234, 0.33992064306, 5017.50837136500},
	{0.00000000286, 4.99886287753, 6436.85466047620},
	{0.00000000309, 0.57495592500, 27511.46787353720},
	{0.00000000319, 3.13977654412, 169379.25621117488},
	{0.00000000263, 6.04953863141, 11712.95531823080},
	{0.00000000285, 5.85104532566, 16522.65971600220},
	{0.00000000230, 5.72898960063, 1265.56747862640},
	{0.00000000235, 4.94143074133, 4487.81740627040},
	{0.00000000253, 2.08490293021, 4377.61108505100},
	{0.00000000312, 1.61150992635, 11720.06886523160},
	{0.00000000220, 6.00356459702, 20199.09495963300},
	{0.00000000214, 0.52396088270, 2221.85663459700},
	{0.00000000213, 2.22365237019, 30355.99731976780},
	{0.00000000259, 1.86047749915, 6282.83203250789},
	{0.00000000259, 1.64646341991, 6283.31966747490},
	{0.00000000243, 2.57267015777, 7096.62613395120},
	{0.00000000221, 4.65757923242, 5540.08578945880},
	{0.00000000246, 4.26495076165, 8671.96987044060},
	{0.00000000208, 3.10897679499, 10440.27429260360},
	{0.00000000199, 5.64807046697, 11216.28429032400},
	{0.00000000209, 3.71139099761, 419.48464387520},
	{0.00000000207, 1.49549061720, 12562.56127133100},
	{0.00000000212, 0.18391974040, 7129.15868474260},
	{0.00000000269, 6.23907991227, 70755.06709173629},
	{0.00000000224, 5.58680388524, 5636.06501667660},
	{0.00000000192, 0.47333599881, 17271.88400752640},
	{0.00000000241, 3.52161359834, 15906.76412668260},
	{0.00000000257, 0.87147328095, 48739.85989708300},
	{0.00000000184, 3.83487369725, 9380.95967271720},
	{0.00000000256, 0.73074058890, 224.34479570190},
	{0.00000000250, 2.67103537581, 5934.15142954340},
	{0.00000000185, 1.51386870105, 19800.94595622480},
	{0.00000000189, 2.52919302388, 16062.18452611680},
	{0.00000000175, 3.84093628240, 11614.43329373220},
	{0.00000000175, 6.15313646522, 3744.82734573780},
	{0.00000000240, 0.45238664563, 1.48447270830},
	{0.00000000241, 5.00040455119, 8390.11035753380},
	{0.00000000193, 4.71506547135, 394.62588505920},
	{0.00000000169, 0.80098424793, 742.99006053260},
	{0.00000000189, 4.03411872458, 401.67212175720},
	{0.00000000230, 0.83612842798, 6632.00027043940},
	{0.00000000227, 4.16811397278, 34596.36465465240},
	{0.00000000165, 0.39341190294, 10454.50138660520},
	{0.00000000221, 2.07224292531, 6206.80977871580},
	{0.00000000201, 6.23059857608, 3097.88382272579},
	{0.00000000205, 2.56533473350, 16627.37091537720},
	{0.00000000178, 0.01807925983, 4797.09572892620},
	{0.00000000225, 3.43883654828, 266.60704172180},
	{0.00000000167, 2.40308228314, 5714.25397596400},
	{0.00000000167, 1.16660958168, 10344.29506538580},
	{0.00000000172, 3.81893679688, 6332.83287546320},
	{0.00000000172, 5.97118942936, 6233.31882451960},
	{0.00000000214, 2.77237801335, 24492.40611365159},
	{0.00000000159, 2.33166453392, 13198.93543929600},
	{0.00000000207, 1.92518585993, 12569.74212863460},
	{0.00000000176, 2.48119329994, 12012.58229714040},
	{0.00000000196, 5.41851032427, 11087.28512591840},
	{0.00000000161, 2.18455666842, 12132.43996210600},
	{0.00000000170, 5.35052715864, 6272.03014972750},
	{0.00000000170, 4.43959906760, 6294.12155025530},
	{0.00000000168, 3.97617357428, 17686.75284556640},
	{0.00000000199, 5.15620822027, 33326.57873317420},
	{0.00000000194, 2.13712729333, 28.44918746780},
	{0.00000000144, 2.03929994576, 16737.57723659660},
	{0.00000000148, 1.10385881777, 6851.89772401880},
	{0.00000000146, 4.95201849548, 17370.36097590980},
	{0.00000000143, 5.56441147227, 5618.31980486140},
	{0.00000000140, 5.93460328071, 2008.55753915900},
	{0.00000000162, 3.21674523006, 12551.92460598120},
	{0.00000000143, 3.89365374642, 5010.39482436420},
	{0.00000000161, 1.75025798421, 31441.67756975680},
	{0.00000000151, 4.72729575304, 16723.35014259500},
	{0.00000000135, 4.79054860554, 12431.08661994740},
	{0.00000000148, 3.93657905776, 28766.92442448400},
	{0.00000000146, 6.27087503385, 12701.21678001820},
	{0.00000000137, 1.02989768135, 11.04570026390},
	{0.00000000167, 5.98371371124, 17473.45375012840},
	{0.00000000161, 1.02898808001, 20452.86941222180},
	{0.00000000124, 4.22571513469, 6947.83189512140},
	{0.00000000135, 4.95838914470, 3531.52825029980},
	{0.00000000172, 0.23035302794, 167959.39011405829},
	{0.00000000122, 4.12184077581, 3583.34103067380},
	{0.00000000170, 6.16462338453, 333857.59012677266},
	{0.00000000155, 5.62826239458, 6058.73105428950},
	{0.00000000120, 5.90379805618, 12808.88030395680},
	{0.00000000141, 3.95455987291, 162420.55183479069},
	{0.00000000145, 3.70967890118, 95.97922721780},
	{0.00000000120, 4.26997270152, 12528.12402734700},
	{0.00000000119, 5.90934719297, 19247.37655338240},
	{0.00000000117, 5.45034772919, 11610.55195837420},
	{0.00000000163, 1.54432161045, 661.23292678100},
	{0.00000000161, 2.28994816795, 52670.06959330260},
	{0.00000000163, 2.78769644779, 9929.42622734580},
	{0.00000000119, 2.71628583938, 12249.75983032620},
	{0.00000000145, 1.17170397718, 6360.74962041940},
	{0.00000000145, 2.33523694188, 6205.40207956340},
	{0.00000000159, 2.61434351364, 228278.10465148659},
	{0.00000000156, 1.00708912320, 4307.58330413540},
	{0.00000000118, 5.95164477875, 6302.74561089119},
	{0.00000000118, 3.83848144749, 6263.40608909160},
	{0.00000000135, 2.80387650268, 19804.82729158280},
	{0.00000000112, 3.88136222265, 16840.67001081519},
	{0.00000000148, 3.55909740786, 28237.23345938940},
	{0.00000000124, 5.50657775921, 10239.58386601080},
	{0.00000000137, 0.97335445483, 6315.60840078280},
	{0.00000000137, 2.53358646423, 6250.54329920000},
	{0.00000000111, 0.70362725529, 6339.97422492700},
	{0.00000000111, 2.80331366377, 6226.17747505580},
	{0.00000000139, 4.20829691432, 11609.86254401220},
	{0.00000000124, 3.12647421017, 19402.79695281660},
	{0.00000000123, 0.80538262187, 24734.15439655740},
	{0.00000000107, 0.59542543867, 12463.05892576420},
	{0.00000000140, 5.62756230388, 38526.57435087200},
	{0.00000000123, 5.71833316259, 6305.85105144220},
	{0.00000000123, 4.07179306365, 6260.30064854060},
	{0.00000000113, 0.38311301542, 2111.65031337760},
	{0.00000000117, 1.11114131260, 24336.00539314920},
	{0.00000000131, 2.04122395494, 18415.51581209739},
	{0.00000000106, 2.18835416515, 12341.80690428090},
	{0.00000000110, 3.31587494701, 6276.44729109139},
	{0.00000000110, 0.19106597205, 6289.70440889141},
	{0.00000000103, 1.18729919186, 6324.62664097620},
	{0.00000000103, 2.31964172720, 6241.52505900660},
	{0.00000000131, 5.93782050272, 5791.41255753260},
	{0.00000000107, 0.14948042255, 83973.83535572988},
	{0.00000000107, 1.18803015964, 84019.85928049390},
	{0.00000000106, 1.70601019340, 12772.33724842000},
	{0.00000000143, 6.22488817389, 2069.00683490660},
	{0.00000000143, 5.63221604750, 18772.96147869860},
	{0.00000000115, 5.35511207484, 3641.73457151920},
	{0.00000000121, 3.53431033420, 17996.03116822220},
	{0.00000000126, 5.90533164276, 18822.92923017440},
	{0.00000000115, 3.09464836385, 12570.08385324590},
	{0.00000000119, 0.26217017763, 9814.60410029120},
	{0.00000000138, 2.98838673165, 6209.77872413240},
	{0.00000000138, 0.51855418741, 6356.37297585040},
	{0.00000000100, 3.07908951574, 5.52292430740},
	{0.00000000135, 5.28292512146, 18699.66435283960},
	{0.00000000104, 0.57981411648, 12560.62877567540},
	{0.00000000098, 4.00434933508, 5815.11085963699},
	{0.00000000096, 3.47793123567, 22743.40937951640},
	{0.00000000099, 2.68455377979, 78263.70942472259},
	{0.00000000114, 2.18292460802, 6155.05700665400},
	{0.00000000114, 1.32401631104, 6411.09469332880},
	{0.00000000093, 0.34809743975, 11190.37790013700},
	{0.00000000095, 4.06228552408, 11300.58422135640},
	{0.00000000117, 2.41831042685, 24383.07910844140},
	{0.00000000110, 1.22040625314, 6312.50535852740},
	{0.00000000110, 2.28653466592, 6253.64634145540},
	{0.00000000091, 1.42377843647, 12829.23562335560},
	{0.00000000120, 4.42365311529, 17892.93839400359},
	{0.00000000090, 4.05016333707, 15664.03552270859},
	{0.00000000126, 0.70432668892, 1293.48422358260},
	{0.00000000126, 4.96989709208, 311565.01892104017},
	{0.00000000120, 0.51717377640, 14158.74771361560},
	{0.00000000110, 1.99803947181, 16097.67995028260},
	{0.00000000092, 1.75886109740, 21424.46664430340},
	{0.00000000099, 2.04878528903, 6432.63904712600},
	{0.00000000124, 5.19244899173, 178430.04719053170},
	{0.00000000088, 0.12768507477, 15141.39079431200},
	{0.00000000089, 5.78577662098, 6751.04084034580},
	{0.00000000096, 1.07414401415, 7349.57132718140},
	{0.00000000094, 1.30652024350, 2699.73481931760},
	{0.00000000087, 1.63535344372, 23141.55838292460},
	{0.00000000103, 2.80666225492, 18202.21671665939},
	{0.00000000099, 5.29408634455, 6313.98997562640},
	{0.00000000099, 4.49603988169, 6252.16172435640},
	{0.00000000090, 1.96045243600, 58864.54391814630},
	{0.00000000113, 3.06789441452, 10557.59416082380},
	{0.00000000098, 1.66301652528, 6126.67512948900},
	{0.00000000098, 1.84392439378, 6439.47657049380},
	{0.00000000086, 6.05385675766, 23123.74586080659},
	{0.00000000094, 5.54106526599, 23539.70738633280},
	{0.00000000118, 2.16762826283, 13951.71327493390},
	{0.00000000117, 2.53845687210, 89569.99011954499},
	{0.00000000083, 4.71523084157, 8858.31494432060},
	{0.00000000101, 4.94270501848, 18429.74290609900},
	{0.00000000088, 2.19663281211, 17053.96910625319},
	{0.00000000113, 0.47970289838, 12985.63634385800},
	{0.00000000082, 4.90614256431, 5483.25472482600},
	{0.00000000095, 0.81797133475, 11925.27409260060},
	{0.00000000084, 2.66665772953, 6379.05507720920},
	{0.00000000084, 0.84028318953, 6187.09662277360},
	{0.00000000093, 3.10680657507, 35371.88726597640},
	{0.00000000105, 1.20399152892, 6434.97313107660},
	{0.00000000105, 2.30294939014, 6131.17856890620},
	{0.00000000114, 2.50001433093, 8258.56839584740},
	{0.00000000084, 3.82196413310, 32217.20018108080},
	{0.00000000082, 5.40278723857, 3958.12644117580},
	{0.00000000102, 1.32703960779, 5767.61197889840},
	{0.00000000102, 2.17990131127, 6798.53972108440},
	{0.00000000092, 6.07396273786, 18216.44381066100},
	{0.00000000112, 3.91825505548, 12188.77809206700},
	{0.00000000086, 4.18439486840, 16193.65917750039},
	{0.00000000080, 2.01988251452, 24080.03501677719},
	{0.00000000093, 4.66163367881, 23937.85638974100},
	{0.00000000088, 4.57496913724, 1573.82042409880},
	{0.00000000092, 2.79375473262, 101426.20877096949},
	{0.00000000110, 5.08243853758, 78423.70451667879},
	{0.00000000087, 3.89286413327, 1580.86666079680},
	{0.00000000080, 1.70826898567, 6485.32924516550},
	{0.00000000080, 1.79867193339, 6080.82245481730},
	{0.00000000079, 6.16114738580, 40796.33892267419},
	{0.00000000079, 2.96735408932, 36109.38220466459},
	{0.00000000088, 5.58306387433, 16943.76278503380},
	{0.00000000093, 0.22422436515, 283.85931886520},
	{0.00000000088, 1.67821631800, 12537.70251251500},
	{0.00000000079, 4.76362160922, 41194.48792608240},
	{0.00000000081, 5.19149105668, 3956.50801601940},
	{0.00000000103, 3.71008010926, 56600.27928952220},
	{0.00000000079, 2.93697301370, 5621.84292321040},
	{0.00000000096, 0.41418225890, 5888.44996493220},
	{0.00000000096, 3.09275866016, 6677.70173505060},
	{0.00000000074, 4.41044639229, 6304.41149045840},
	{0.00000000074, 5.37967983395, 6261.74020952440},
	{0.00000000073, 1.05049706961, 6695.44694686580},
	{0.00000000073, 2.45644384945, 5870.70475311700},
	{0.00000000073, 1.61765616896, 16207.88627150200},
	{0.00000000085, 2.08161902252, 12850.01101884800},
	{0.00000000072, 5.03595593677, 6312.89728814020},
	{0.00000000072, 4.75417028947, 6253.25441184259},
	{0.00000000100, 3.80714752393, 5316.10497255580},
	{0.00000000085, 1.33904345426, 12282.29238111760},
	{0.00000000077, 5.07586430304, 22345.26037610820},
	{0.00000000075, 0.39510451579, 24422.37035140730},
	{0.00000000076, 0.41146256256, 63658.87775083760},
	{0.00000000087, 2.06336091493, 18106.23748944160},
	{0.00000000070, 0.44640955505, 6442.01936777460},
	{0.00000000070, 3.06053136401, 6124.13233220820},
	{0.00000000074, 5.61945589711, 15265.88651930040},
	{0.00000000078, 3.38283383527, 23550.34405168259},
	{0.00000000077, 5.00656029204, 5237.92101380380},
	{0.00000000075, 3.64547243832, 27832.03821928320},
	{0.00000000082, 3.91623659935, 6774.73914245020},
	{0.00000000067, 4.88284279928, 7082.89697515680},
	{0.00000000067, 3.24232940659, 6171.88920770380},
	{0.00000000067, 0.26461151247, 6394.26249227900},
	{0.00000000080, 3.79677325613, 22380.75580027400},
	{0.00000000070, 0.47599032576, 6175.41232605280},
	{0.00000000070, 3.03095059330, 6390.73937393000},
	{0.00000000077, 0.29137018417, 9924.81042151060},
	{0.00000000091, 0.90446873976, 6652.77566593180},
	{0.00000000091, 2.60247217930, 5913.37603405100},
	{0.00000000067, 4.84479908786, 6300.88837210940},
	{0.00000000067, 4.94532713838, 6265.26332787340},
	{0.00000000088, 3.59122542798, 10660.68693504240},
	{0.00000000066, 3.01430181986, 5959.57043333400},
	{0.00000000080, 5.49178527606, 23646.32327890039},
	{0.00000000068, 2.07232411643, 4897.18057365520},
	{0.00000000069, 0.56996801147, 6944.30877677240},
	{0.00000000073, 2.96334792367, 6195.76764545159},
	{0.00000000073, 0.54359299539, 6370.38405453120},
	{0.00000000071, 3.57166978930, 17363.24742890899},
	{0.00000000074, 1.56614709067, 27043.50288318280},
	{0.00000000066, 2.38194509538, 6251.10354417460},
	{0.00000000066, 1.12499582368, 6315.04815580820},
	{0.00000000064, 3.50738755186, 323.50541665740},
	{0.00000000078, 0.83740696355, 42456.78404709160},
	{0.00000000063, 2.70916268945, 11823.16163945020},
	{0.00000000064, 4.80330562067, 28774.03797148480},
	{0.00000000079, 5.66337403718, 24065.80792277559},
	{0.00000000072, 2.11096843463, 18100.00325845000},
	{0.00000000066, 1.21053452412, 17576.54652434700},
	{0.00000000072, 0.02703779211, 245707.46610434429},
	{0.00000000068, 0.52464381855, 18003.14471522300},
	{0.00000000068, 1.33733194362, 28759.81087748319},
	{0.00000000062, 2.25046717820, 3855.03366695720},
	{0.00000000060, 5.83008017266, 18606.49894600020},
	{0.00000000079, 2.49476757272, 22476.73502749179},
	{0.00000000073, 4.61251602377, 23440.13773046320},
	{0.00000000060, 1.65871121739, 13088.72911807660},
	{0.00000000078, 2.99014426818, 12564.66722727450},
	{0.00000000060, 2.90135289748, 7548.64332861780},
	{0.00000000073, 4.73963217435, 735.87651353180},
	{0.00000000059, 2.43330626408, 5113.48759858280},
	{0.00000000075, 2.85043788676, 18624.88275427230},
	{0.00000000069, 4.25329739931, 167993.69463622378},
	{0.00000000059, 5.13628041810, 41990.78593289880},
	{0.00000000081, 5.98297918907, 7250.04672742700},
	{0.00000000059, 2.39193379192, 6289.14176562120},
	{0.00000000059, 1.11500712714, 6277.00993436160},
	{0.00000000072, 4.87534601803, 8982.81066930900},
	{0.00000000057, 3.30911091342, 792.77488846740},
	{0.00000000057, 1.61290511224, 10027.90319572920},
	{0.00000000072, 5.73653948228, 4598.02372748980},
	{0.00000000060, 0.63449806943, 647.01083331480},
	{0.00000000066, 0.80721495515, 5220.17080145320},
	{0.00000000056, 5.24002840662, 35050.00027447539},
	{0.00000000077, 2.14165124499, 46386.99374331120},
	{0.00000000068, 1.14499338723, 3166.41643773160},
	{0.00000000056, 0.39917748570, 6339.87911216120},
	{0.00000000056, 3.10776343336, 6226.27258782160},
	{0.00000000056, 0.95649088929, 12303.06777661000},
	{0.00000000057, 1.98721525004, 6702.00024889200},
	{0.00000000057, 1.51972566902, 5864.15145109080},
	{0.00000000069, 0.33788710387, 23536.11695768099},
	{0.00000000059, 1.81421782103, 67589.08744705719},
	{0.00000000076, 0.77801824814, 23226.83863502520},
	{0.00000000059, 1.03968301691, 15.25247118500},
	{0.00000000073, 4.43868056110, 30348.88377276700},
	{0.00000000054, 4.96201305869, 36147.40987730040},
	{0.00000000070, 6.27818224660, 12299.54465826100},
	{0.00000000060, 5.08461088458, 12171.52581492360},
	{0.00000000074, 1.19928905734, 3684.37804999020},
	{0.00000000058, 1.58539308271, 6716.78758786820},
	{0.00000000061, 3.25163800829, 27707.54249429480},
	{0.00000000059, 5.76308524321, 12164.47957822560},
	{0.00000000070, 0.07217173698, 16833.55646381439},
	{0.00000000063, 2.16224668422, 5227.62607306530},
	{0.00000000063, 5.23287718161, 5219.76176653910},
	{0.00000000056, 2.45377587379, 3178.14579056760},
	{0.00000000072, 2.62702736253, 4583.79663348820},
	{0.00000000052, 0.96546586882, 3627.50747751760},
	{0.00000000052, 0.20415505351, 6155.12431695680},
	{0.00000000052, 3.30278586555, 6411.02738302600},
	{0.00000000060, 0.48342399631, 5244.04923920100},
	{0.00000000058, 2.72226132172, 30775.48196364300},
	{0.00000000052, 5.80291300969, 30639.85663863300},
	{0.00000000053, 5.75258856716, 37724.75341974820},
	{0.00000000062, 2.89766241568, 6908.74604230380},
	{0.00000000062, 0.60927850338, 5657.40565767900},
	{0.00000000050, 3.11011154958, 2575.23909432920},
	{0.00000000054, 1.15676928987, 18208.34994259200},
	{0.00000000050, 3.12376167242, 5881.40372823420},
	{0.00000000050, 0.38317924664, 6684.74797174860},
	{0.00000000068, 4.61950794623, 96677.89886304220},
	{0.00000000054, 0.77163765121, 41654.96311596780},
	{0.00000000066, 5.13003693613, 60530.48898574180},
	{0.00000000050, 1.64593222191, 43738.80234596580},
	{0.00000000048, 5.44674337925, 25685.87280280800},
	{0.00000000059, 2.71376008731, 3981.49003408200},
	{0.00000000058, 0.74658643142, 14169.79356223040},
	{0.00000000051, 1.43461659855, 7668.97112632760},
	{0.00000000048, 3.23576011756, 3646.35037735440},
	{0.00000000054, 4.50803792908, 39302.09696219600},
	{0.00000000057, 2.62704971421, 799.82112516540},
	{0.00000000061, 3.28745263972, 44034.12758953940},
	{0.00000000049, 2.15365169571, 96562.99901809469},
	{0.00000000050, 3.60626874009, 17583.66007134780},
	{0.00000000051, 1.16028405425, 38650.17350619900},
	{0.00000000053, 1.90122336672, 11080.17157891760},
	{0.00000000059, 0.68886289824, 62883.35513951360},
	{0.00000000046, 0.83996053249, 25287.72379939980},
	{0.00000000049, 3.59486880927, 5490.30096152400},
	{0.00000000058, 5.95314247069, 6489.77658728800},
	{0.00000000058, 3.83698375555, 6076.37511269480},
	{0.00000000047, 4.43378504018, 170.67287061920},
	{0.00000000045, 5.81363953764, 33318.81606245820},
	{0.00000000046, 3.19651245272, 4480.70385926960},
	{0.00000000060, 3.92066214096, 28313.28880466100},
	{0.00000000061, 3.53510681440, 491.66329245880},
	{0.00000000051, 6.00904914233, 3428.43547608120},
	{0.00000000060, 3.51283911810, 50317.20343953080},
	{0.00000000054, 1.22650408797, 6006.33007812700},
	{0.00000000054, 2.28043683109, 6559.82162185580},
	{0.00000000052, 3.85271761797, 244287.60000722769},
	{0.00000000046, 3.84965479184, 4384.72463205180},
	{0.00000000045, 0.29195078507, 44136.95134937400},
	{0.00000000044, 2.71274650311, 2301.58581590939},
	{0.00000000048, 4.64164514773, 35579.69123957000},
	{0.00000000051, 4.91887651070, 18326.65013188039},
	{0.00000000046, 3.15339406184, 16703.06213349900},
	{0.00000000048, 2.39477993061, 5209.46682580060},
	{0.00000000046, 2.47672465258, 12555.10599971890},
	{0.00000000052, 4.64446990453, 5992.10298412540},
	{0.00000000052, 5.14565632171, 6574.04871585740},
	{0.00000000044, 3.80836113401, 69941.95360082899},
	{0.00000000050, 3.54529295551, 22030.21295466960},
	{0.00000000043, 1.20775471242, 20894.77567920879},
	{0.00000000044, 2.61939991177, 533.21408344360},
	{0.00000000045, 4.65113002963, 46360.69542351140},
	{0.00000000047, 2.17023181784, 45585.17281218740},
	{0.00000000043, 1.54528183996, 8401.83971036980},
	{0.00000000054, 3.62371389676, 24279.10701821359},
	{0.00000000042, 5.13054174413, 27433.88921587499},
	{0.00000000042, 1.32093818083, 21548.96236929180},
	{0.00000000045, 3.22031193914, 71519.29714327680},
	{0.00000000043, 2.75467576214, 27278.46881644080},
	{0.00000000042, 2.68353478578, 28230.18722269139},
	{0.00000000051, 2.95623880108, 7761.94242405580},
	{0.00000000041, 5.14394847571, 3735.23831175900},
	{0.00000000042, 3.66392136716, 26084.02180621620},
	{0.00000000047, 6.03338630990, 4708.23004870920},
	{0.00000000056, 5.67442109710, 88041.95685927900},
	{0.00000000056, 5.36734540218, 28663.83165026540},
	{0.00000000040, 1.07842393153, 28628.33622609960},
	{0.00000000047, 5.61045374376, 316428.22867391503},
	{0.00000000056, 1.28041118541, 83659.27687239899},
	{0.00000000039, 0.71682305362, 34570.06633485260},
	{0.00000000056, 1.60418809786, 82534.40362061159},
	{0.00000000052, 1.15000260118, 40398.18991926600},
	{0.00000000048, 0.93182108526, 12662.13092720060},
	{0.00000000041, 4.95215656542, 37057.57749256620},
	{0.00000000052, 2.84085536047, 12571.67462429020},
	{0.00000000043, 3.12714109961, 7322.10246078180},
	{0.00000000041, 1.98689255259, 664.75604513000},
	{0.00000000043, 4.45441019609, 19004.64794940840},
	{0.00000000044, 3.63007864944, 6140.89722295520},
	{0.00000000044, 6.16004757680, 6425.25447702760},
	{0.00000000044, 3.57757676616, 49515.38250840700},
	{0.00000000039, 5.09443272912, 22594.05489571199},
	{0.00000000055, 5.97876206707, 80181.53746683979},
	{0.00000000054, 3.12084664124, 6006.04085625000},
	{0.00000000054, 0.38609427782, 6560.11084373280},
	{0.00000000045, 0.83262497188, 142861.39123625819},
	{0.00000000047, 5.83395711112, 24499.51966065240},
	{0.00000000043, 6.07854396898, 7026.06591052400},
	{0.00000000047, 2.57216284949, 11919.14086666800},
	{0.00000000047, 2.93748065634, 24485.29256665079},
	{0.00000000050, 3.13873979564, 92747.68916682259},
	{0.00000000043, 4.24359473122, 6359.34192126700},
	{0.00000000049, 2.11824959319, 66813.56483573320},
	{0.00000000042, 3.13003412642, 6231.79551212899},
	{0.00000000042, 0.37690679264, 6334.35618785381},
	{0.00000000052, 1.96232281613, 11904.91877320180},
	{0.00000000040, 6.22187276386, 7075.85073845880},
	{0.00000000040, 4.78395267597, 7122.04513774180},
	{0.00000000040, 5.00617355027, 5444.10656224100},
	{0.00000000038, 0.67444569484, 44933.24935619040},
	{0.00000000037, 4.80355711691, 6850.79448772180},
	{0.00000000037, 4.98656910933, 5715.35721226100},
	{0.00000000050, 0.35643037555, 21947.11137270000},
	{0.00000000039, 2.97136332005, 21150.81336588360},
	{0.00000000042, 2.21951419227, 6328.21706962800},
	{0.00000000042, 1.28742672679, 6237.93463035480},
	{0.00000000051, 4.42510682790, 60284.41001526290},
	{0.00000000040, 5.21447072458, 3215.13638064320},
	{0.00000000039, 3.85122558089, 30774.50164257480},
	{0.00000000046, 3.45581538922, 12146.66705610760},
	{0.00000000050, 0.05709243771, 84334.41776382479},
	{0, 0, 0}
};

struct vsop87_term earth_y1[] = {
	{0.00093046324, 0.00000000000, 0.00000000000},
	{0.00051506609, 4.43180499286, 12566.15169998280},
	{0.00001290800, 4.38860548540, 18849.22754997420},
	{0.00000464550, 5.82729912952, 6283.07584999140},
	{0.00000212689, 0.16300556918, 6279.55273164240},
	{0.00000212533, 3.34400595407, 6286.59896834040},
	{0.00000062345, 5.07377354827, 4705.73230754360},
	{0.00000059794, 2.24100907272, 6256.77753019160},
	{0.00000059441, 1.26619990626, 6309.37416979120},
	{0.00000048987, 3.64166577835, 775.52261132400},
	{0.00000042746, 5.15177425824, 1059.38193018920},
	{0.00000046642, 4.71575215800, 7860.41939243920},
	{0.00000037274, 0.66041323804, 5753.38488489680},
	{0.00000035625, 6.15462846966, 5884.92684658320},
	{0.00000035373, 2.90052012152, 6812.76681508600},
	{0.00000032157, 3.62669702015, 6681.22485339960},
	{0.00000028763, 4.34539355621, 25132.30339996560},
	{0.00000028447, 5.86215103214, 6127.65545055720},
	{0.00000027502, 3.92641632542, 6438.49624942560},
	{0.00000024830, 1.35190115953, 5486.77784317500},
	{0.00000020618, 2.14772396647, 7079.37385680780},
	{0.00000019531, 1.29958310594, 5507.55323866740},
	{0.00000018447, 6.17330532651, 11790.62908865880},
	{0.00000016520, 4.63328039489, 11506.76976979360},
	{0.00000016754, 2.24862220282, 7058.59846131540},
	{0.00000014560, 4.40425761361, 6290.18939699220},
	{0.00000014426, 5.39226330857, 6275.96230299060},
	{0.00000014186, 6.18547219419, 796.29800681640},
	{0.00000012666, 5.73231393752, 4694.00295470760},
	{0.00000012966, 5.10338935824, 7.11354700080},
	{0.00000010100, 1.72464513593, 3738.76143010800},
	{0.00000009427, 3.08115743044, 6069.77675455340},
	{0.00000010425, 2.69531177468, 6282.09552892320},
	{0.00000010425, 0.81162914438, 6284.05617105960},
	{0.00000009576, 0.32459396888, 4136.91043351620},
	{0.00000009043, 0.43888880403, 6496.37494542940},
	{0.00000008545, 4.77137497641, 1194.44701022460},
	{0.00000008199, 5.96838316358, 1589.07289528380},
	{0.00000006291, 3.18312019173, 8429.24126646660},
	{0.00000006133, 1.78033290355, 8827.39026987480},
	{0.00000005524, 3.79842135217, 4933.20844033260},
	{0.00000007316, 5.20404355405, 4535.05943692440},
	{0.00000005146, 3.57146870511, 11769.85369316640},
	{0.00000006461, 2.67840586109, 5088.62883976680},
	{0.00000005270, 0.94095218349, 3154.68708489560},
	{0.00000004829, 5.32876538500, 6040.34724601740},
	{0.00000004985, 3.05697984231, 12569.67481833180},
	{0.00000004709, 2.39292099451, 5331.35744374080},
	{0.00000004601, 4.45296532710, 6525.80445396540},
	{0.00000005607, 0.98720797401, 5729.50644714900},
	{0.00000004081, 5.94191743597, 7632.94325965020},
	{0.00000004394, 4.75948184840, 12559.03815298200},
	{0.00000005053, 4.55162942081, 8031.09226305840},
	{0.00000005077, 0.73549620962, 7477.52286021600},
	{0.00000003779, 1.07385171253, 7234.79425624200},
	{0.00000004974, 2.50029147401, 6836.64525283380},
	{0.00000003614, 2.52455299148, 3930.20969621960},
	{0.00000003482, 3.82652198801, 10977.07880469900},
	{0.00000003576, 5.30219799481, 4164.31198961300},
	{0.00000003376, 5.00213145251, 11371.70468975820},
	{0.00000004290, 3.36736739298, 1592.59601363280},
	{0.00000003406, 0.83525752781, 3128.38876509580},
	{0.00000003124, 3.17143982984, 7084.89678111520},
	{0.00000002752, 3.67389621489, 7342.45778018060},
	{0.00000002778, 0.26817898615, 1748.01641306700},
	{0.00000002694, 4.70989138148, 529.69096509460},
	{0.00000002820, 0.23146914320, 5223.69391980220},
	{0.00000003334, 3.48823993118, 801.82093112380},
	{0.00000003328, 5.83812544995, 155.42039943420},
	{0.00000003008, 0.67203387304, 8635.94200376320},
	{0.00000002348, 5.19665664165, 2146.16541647520},
	{0.00000002307, 2.98930142346, 17260.15465469040},
	{0.00000002778, 6.17392405934, 5481.25491886760},
	{0.00000002046, 1.96605971472, 1990.74501704100},
	{0.00000002670, 1.00151747879, 26.29831979980},
	{0.00000002000, 3.03124266219, 951.71840625060},
	{0.00000002162, 0.33268106563, 536.80451209540},
	{0.00000001830, 4.43806423544, 553.56940284240},
	{0.00000001762, 3.84931185617, 4690.47983635860},
	{0.00000002033, 0.80949219978, 522.57741809380},
	{0.00000002430, 1.64090263419, 1349.86740965880},
	{0.00000001902, 2.66567222573, 9437.76293488700},
	{0.00000001940, 3.91085273629, 5216.58037280140},
	{0.00000001708, 5.00417878382, 10988.80815753500},
	{0.00000001762, 2.39542835845, 398.14900340820},
	{0.00000001790, 3.48655562486, 5230.80746680300},
	{0.00000001524, 5.81370227284, 426.59819087600},
	{0.00000001555, 2.09924417685, 13095.84266507740},
	{0.00000001779, 0.23737949225, 12562.62858163380},
	{0.00000001450, 5.71201368260, 6262.72053059260},
	{0.00000001450, 4.07811254364, 6303.43116939020},
	{0.00000001768, 0.08826500577, 10973.55568635000},
	{0.00000001373, 5.60523185373, 7875.67186362420},
	{0.00000001428, 3.29442777483, 12721.57209941700},
	{0.00000001247, 0.29212365805, 2118.76386037840},
	{0.00000001230, 2.53131850803, 18319.53658487960},
	{0.00000001141, 1.92147452671, 1066.49547719000},
	{0.00000001140, 1.21410806683, 2942.46342329160},
	{0.00000001045, 2.17535721280, 242.72860397400},
	{0.00000000973, 4.95437649984, 639.89728631400},
	{0.00000000969, 1.29405045734, 5643.17856367740},
	{0.00000001064, 4.40566643488, 15720.83878487840},
	{0.00000000962, 0.55758587779, 2388.89402044920},
	{0.00000000943, 4.22062437022, 20426.57109242200},
	{0.00000000869, 5.80860615243, 16496.36139620240},
	{0.00000000874, 1.43036958888, 10575.40668294180},
	{0.00000001088, 5.77656856686, 5760.49843189760},
	{0.00000000889, 4.77820137734, 6288.59877429880},
	{0.00000000889, 5.01192484889, 6277.55292568400},
	{0.00000001018, 2.66299766067, 12539.85338018300},
	{0.00000001017, 4.02093017183, 6805.65326808520},
	{0.00000000794, 3.79329079940, 14314.16811304980},
	{0.00000000795, 3.39951828424, 6279.78949257360},
	{0.00000000795, 0.10742263482, 6286.36220740920},
	{0.00000000759, 4.98301749094, 1577.34354244780},
	{0.00000000757, 3.81754073272, 5856.47765911540},
	{0.00000000800, 3.18366218591, 12029.34718788740},
	{0.00000000716, 2.28687269516, 9623.68827669120},
	{0.00000000698, 4.94363229969, 6148.01076995600},
	{0.00000000907, 0.70119368826, 13367.97263110660},
	{0.00000000672, 3.99153941403, 12964.30070339100},
	{0.00000000678, 4.84647216304, 6418.14093002680},
	{0.00000000671, 6.00179402654, 6709.67404086740},
	{0.00000000657, 1.80163596347, 13119.72110282519},
	{0.00000000662, 4.04031103640, 11015.10647733480},
	{0.00000000744, 2.68741160780, 12043.57428188900},
	{0.00000000673, 2.45322928062, 14712.31711645800},
	{0.00000000696, 2.53877129238, 16730.46368959580},
	{0.00000000671, 0.40543909773, 13517.87010623340},
	{0.00000000604, 5.39462125376, 14143.49524243060},
	{0.00000000754, 5.24655445271, 13916.01910964160},
	{0.00000000629, 3.42493725594, 4686.88940770680},
	{0.00000000610, 5.19955844918, 6819.88036208680},
	{0.00000000667, 4.87151372910, 3634.62102451840},
	{0.00000000609, 4.57544043999, 5746.27133789600},
	{0.00000000620, 4.30310535016, 31415.37924995700},
	{0.00000000553, 0.78994516254, 6306.95428773920},
	{0.00000000553, 2.71699575652, 6259.19741224360},
	{0.00000000524, 3.96543945899, 12139.55350910680},
	{0.00000000514, 3.87793148429, 4701.11650170840},
	{0.00000000553, 4.81568395217, 12036.46073488820},
	{0.00000000495, 2.00987395637, 13362.44970679920},
	{0.00000000562, 4.76145666018, 4292.33083295040},
	{0.00000000481, 2.57118063835, 6286.95718534940},
	{0.00000000481, 0.93576028071, 6279.19451463340},
	{0.00000000635, 3.19879108676, 84334.66158130829},
	{0.00000000445, 1.68959289911, 11499.65622279280},
	{0.00000000596, 1.08038043695, 10447.38783960440},
	{0.00000000452, 3.98330238308, 12573.26524698360},
	{0.00000000499, 5.79985861523, 12410.73130054860},
	{0.00000000440, 0.58121786395, 24072.92146977640},
	{0.00000000575, 1.39410252291, 12592.45001978260},
	{0.00000000404, 0.56451183179, 5863.59120611620},
	{0.00000000398, 4.20035189119, 8273.82086703240},
	{0.00000000418, 2.76069368004, 10177.25767953360},
	{0.00000000379, 3.05384870302, 6386.16862421000},
	{0.00000000379, 0.45309221604, 6179.98307577280},
	{0.00000000377, 4.33269290931, 7872.14874527520},
	{0.00000000419, 4.05140116867, 5327.47610838280},
	{0.00000000383, 5.11659434377, 6319.10371666880},
	{0.00000000383, 4.67353188247, 6247.04798331399},
	{0.00000000457, 0.88573283839, 6489.26139842860},
	{0.00000000457, 2.62120808067, 6076.89030155420},
	{0.00000000378, 5.80861101902, 7238.67559160000},
	{0.00000000344, 4.99907349425, 18451.07854656599},
	{0.00000000334, 0.56215917990, 18073.70493865020},
	{0.00000000453, 5.43513758472, 2787.04302385740},
	{0.00000000364, 0.67991079022, 6321.10352262720},
	{0.00000000364, 2.82703012884, 6245.04817735560},
	{0.00000000342, 4.52940007807, 6303.85124548380},
	{0.00000000342, 5.26072614817, 6262.30045449900},
	{0.00000000319, 4.83173153249, 11926.25441366880},
	{0.00000000316, 1.17362065540, 77713.77146812050},
	{0.00000000318, 6.03589239585, 6311.52503745920},
	{0.00000000318, 3.75423383039, 6254.62666252360},
	{0.00000000315, 1.09950918957, 12323.42309600880},
	{0.00000000310, 4.02477182017, 10213.28554621100},
	{0.00000000311, 5.94074472453, 2352.86615377180},
	{0.00000000304, 0.43890915612, 12779.45079542080},
	{0.00000000343, 1.36470897271, 6267.82337880639},
	{0.00000000343, 2.14223194635, 6298.32832117640},
	{0.00000000398, 4.83558508405, 1551.04522264800},
	{0.00000000358, 2.52713972155, 1052.26838318840},
	{0.00000000300, 0.20527323254, 90279.92316810328},
	{0.00000000297, 2.07974536467, 5429.87946823940},
	{0.00000000332, 2.13791551771, 213.29909543800},
	{0.00000000362, 1.16895887442, 10021.83728009940},
	{0.00000000334, 1.16416729842, 17782.73207278420},
	{0.00000000295, 2.48770580169, 6702.56049386660},
	{0.00000000321, 0.66776723307, 17796.95916678580},
	{0.00000000369, 4.78231597870, 4732.03062734340},
	{0.00000000288, 3.73055532740, 220.41264243880},
	{0.00000000263, 2.60909847321, 955.59974160860},
	{0.00000000305, 0.57265325631, 5642.19824260920},
	{0.00000000258, 4.38103579313, 206.18554843720},
	{0.00000000287, 0.31572653335, 9917.69687450980},
	{0.00000000261, 1.93782216260, 16200.77272450120},
	{0.00000000234, 2.50307529331, 1596.18644228460},
	{0.00000000282, 2.93181184874, 13341.67431130680},
	{0.00000000262, 5.15409122759, 14945.31617355440},
	{0.00000000276, 0.59107321564, 12168.00269657460},
	{0.00000000217, 2.74597813026, 2544.31441988340},
	{0.00000000259, 5.53112324599, 3894.18182954220},
	{0.00000000216, 4.02991604351, 3185.19202726560},
	{0.00000000250, 3.04516511604, 6923.95345737360},
	{0.00000000193, 0.78779752820, 640.87760738220},
	{0.00000000203, 2.82417195790, 6062.66320755260},
	{0.00000000203, 0.68276896116, 6503.48849243020},
	{0.00000000188, 4.83298725434, 18209.33026366019},
	{0.00000000184, 2.63875516800, 12566.21901028560},
	{0.00000000213, 4.09959554852, 9779.10867612540},
	{0.00000000180, 4.19738483213, 853.19638175200},
	{0.00000000248, 5.62050900898, 17789.84561978500},
	{0.00000000187, 3.02088056063, 6276.02961329339},
	{0.00000000187, 0.48606035843, 6290.12208668940},
	{0.00000000168, 6.02158735674, 110.20632121940},
	{0.00000000184, 3.08285813784, 12566.08438968000},
	{0.00000000230, 0.66694562430, 12567.13202105100},
	{0.00000000166, 5.90725172950, 433.71173787680},
	{0.00000000184, 1.80970202711, 6037.24420376200},
	{0.00000000159, 0.31775301914, 3496.03282613400},
	{0.00000000179, 1.27622455391, 3.52311834900},
	{0.00000000156, 0.77329171048, 2648.45482547300},
	{0.00000000182, 0.19927362554, 5849.36411211460},
	{0.00000000175, 1.69691956469, 6528.90749622080},
	{0.00000000154, 5.68366565747, 6112.40297937220},
	{0.00000000154, 4.10646056877, 6453.74872061060},
	{0.00000000162, 0.40509792796, 18875.52586977400},
	{0.00000000163, 2.96167567065, 12352.85260454480},
	{0.00000000146, 2.48714617179, 149.56319713460},
	{0.00000000143, 0.06272029982, 19651.04848109800},
	{0.00000000144, 2.19098385924, 18635.92845453620},
	{0.00000000141, 5.63574749070, 10969.96525769820},
	{0.00000000146, 0.42084370397, 13760.59871020740},
	{0.00000000161, 6.06631099179, 8662.24032356300},
	{0.00000000142, 2.91677439721, 4157.19844261220},
	{0.00000000133, 4.73063338736, 18139.29450141590},
	{0.00000000150, 4.37920284921, 3340.61242669980},
	{0.00000000125, 0.78764990758, 20.77539549240},
	{0.00000000123, 4.97498024339, 6172.86952877200},
	{0.00000000123, 4.81514598285, 6393.28217121080},
	{0.00000000135, 4.59213390099, 10984.19235169980},
	{0.00000000117, 2.90632080371, 18852.75066832320},
	{0.00000000118, 5.67650820416, 17256.63153634140},
	{0.00000000147, 4.60612631701, 17654.78053974960},
	{0.00000000113, 3.90726609167, 65147.61976813770},
	{0.00000000123, 2.85759760823, 12565.17137891460},
	{0.00000000107, 5.46942612515, 9380.95967271720},
	{0.00000000119, 0.71211331875, 10419.98628350760},
	{0.00000000105, 5.13254223053, 632.78373931320},
	{0.00000000103, 4.95941330270, 6271.34649715540},
	{0.00000000103, 4.83071292354, 6294.80520282740},
	{0.00000000102, 5.99360230997, 4804.20927592700},
	{0.00000000114, 3.78885344182, 4171.42553661380},
	{0.00000000113, 4.29988480427, 23013.53953958720},
	{0.00000000112, 0.61034141917, 17253.04110768959},
	{0.00000000111, 2.09128320599, 1581.95934828300},
	{0.00000000113, 0.97983808350, 16858.48253293320},
	{0.00000000102, 4.09962394648, 6549.68289171320},
	{0.00000000102, 5.69050227976, 6016.46880826960},
	{0.00000000106, 0.87687085688, 23543.23050468179},
	{0.00000000121, 4.76575782873, 13625.53363017200},
	{0.00000000090, 2.11774047359, 76.26607127560},
	{0.00000000088, 1.18967345782, 17298.18232732620},
	{0.00000000087, 1.12941525302, 17267.26820169119},
	{0.00000000092, 1.84158032509, 22805.73556599360},
	{0.00000000086, 4.36870119289, 12808.88030395680},
	{0.00000000111, 0.85102422912, 11513.88331679440},
	{0.00000000095, 6.05597457730, 12345.73905754400},
	{0.00000000106, 3.57199937061, 11216.28429032400},
	{0.00000000087, 1.36534411656, 8982.81066930900},
	{0.00000000095, 0.92966303480, 12012.58229714040},
	{0.00000000081, 2.27691876526, 11614.43329373220},
	{0.00000000084, 5.85994160066, 6255.67429389460},
	{0.00000000084, 3.93018462558, 6310.47740608820},
	{0.00000000080, 5.05950625443, 6922.97313630540},
	{0.00000000085, 1.08198764342, 5636.06501667660},
	{0.00000000084, 4.64040201203, 10440.27429260360},
	{0.00000000089, 6.25985265406, 16723.35014259500},
	{0.00000000080, 2.62622474570, 3583.34103067380},
	{0.00000000091, 5.59316682916, 10818.13528691580},
	{0.00000000091, 1.43612727660, 15671.08175940660},
	{0.00000000077, 4.13229801300, 6993.00889854970},
	{0.00000000076, 2.85409687552, 11925.27409260060},
	{0.00000000096, 1.47205677028, 3097.88382272579},
	{0.00000000104, 0.70746530546, 5650.29211067820},
	{0.00000000086, 5.52511956951, 12359.96615154560},
	{0.00000000080, 6.03205499783, 13521.75144159140},
	{0.00000000090, 4.45214765055, 6195.76764545159},
	{0.00000000090, 5.33797857569, 6370.38405453120},
	{0.00000000082, 4.91006846138, 18842.11400297339},
	{0.00000000073, 4.52976823745, 949.17560896980},
	{0.00000000083, 3.74911363362, 18415.51581209739},
	{0.00000000102, 4.43384315891, 3104.93005942380},
	{0.00000000074, 5.90055438198, 5120.60114558360},
	{0.00000000093, 2.53140640111, 16460.33352952499},
	{0.00000000084, 5.92514029201, 2379.16447357160},
	{0.00000000075, 0.05752343047, 30355.99731976780},
	{0.00000000076, 3.26399401386, 18429.74290609900},
	{0.00000000067, 4.00530001957, 16062.18452611680},
	{0.00000000066, 4.81634064130, 10454.50138660520},
	{0.00000000087, 3.52675041577, 3903.91137641980},
	{0.00000000078, 2.74560762552, 8671.96987044060},
	{0.00000000063, 5.70772167485, 24356.78078864160},
	{0.00000000073, 6.08379700055, 9388.00590941520},
	{0.00000000060, 1.94470153573, 34570.06633485260},
	{0.00000000057, 2.89018663881, 149854.40013480789},
	{0.00000000056, 3.76314176838, 12455.94537876340},
	{0.00000000055, 1.32127703933, 23539.70738633280},
	{0.00000000055, 5.60680941684, 15664.03552270859},
	{0.00000000056, 0.60887110989, 11764.33076885900},
	{0.00000000061, 4.86427999867, 28237.23345938940},
	{0.00000000065, 4.29965528550, 7335.34423317980},
	{0.00000000067, 4.20742811531, 11933.36796066960},
	{0.00000000072, 4.30216792995, 6510.55198278040},
	{0.00000000072, 5.48795829629, 6055.59971720240},
	{0.00000000053, 5.64466034451, 17996.03116822220},
	{0.00000000071, 4.94322519248, 12545.37630449040},
	{0.00000000061, 3.80625548858, 6253.64634145540},
	{0.00000000061, 5.98387073766, 6312.50535852740},
	{0.00000000052, 1.83796108842, 5326.78669402080},
	{0.00000000066, 0.79633834660, 14919.01785375460},
	{0.00000000053, 2.81005325604, 2699.73481931760},
	{0.00000000051, 2.33512659118, 16522.65971600220},
	{0.00000000049, 2.61656735675, 35579.69123957000},
	{0.00000000053, 3.71469727042, 6357.85744855870},
	{0.00000000053, 6.07542895582, 6208.29425142410},
	{0.00000000058, 6.24714677357, 16737.57723659660},
	{0.00000000049, 3.35591683551, 21393.54196985760},
	{0.00000000049, 5.31764383927, 7018.95236352320},
	{0.00000000049, 4.47248238697, 5547.19933645960},
	{0.00000000049, 1.02044068888, 12416.58850284820},
	{0.00000000048, 0.93318398067, 5573.14280143310},
	{0.00000000050, 4.78756360288, 26084.02180621620},
	{0.00000000052, 0.61376591765, 45585.17281218740},
	{0.00000000051, 1.83598363802, 23006.42599258639},
	{0.00000000058, 4.03624047121, 15141.39079431200},
	{0.00000000047, 3.55960074091, 22743.40937951640},
	{0.00000000050, 5.52194731109, 21424.46664430340},
	{0.00000000047, 5.68901702449, 24279.10701821359},
	{0.00000000049, 0.09767152059, 5749.86176654780},
	{0.00000000049, 3.40926939847, 6816.28993343500},
	{0.00000000046, 1.88054905125, 19378.91851506880},
	{0.00000000047, 0.52217551707, 24065.80792277559},
	{0.00000000046, 4.16716226231, 104351.61256629678},
	{0.00000000050, 2.92366135772, 24602.61243487099},
	{0.00000000054, 4.75214506546, 7834.12107263940},
	{0.00000000045, 3.48834172987, 161000.68573767410},
	{0.00000000049, 2.94403678329, 29303.72893657940},
	{0.00000000048, 1.95408707684, 5244.04923920100},
	{0.00000000043, 3.93857315871, 12132.43996210600},
	{0.00000000047, 5.81677586075, 18208.34994259200},
	{0.00000000049, 3.41896064981, 29289.50184257780},
	{0.00000000044, 2.06685104480, 6175.41232605280},
	{0.00000000044, 1.44008987426, 6390.73937393000},
	{0.00000000042, 6.18541909471, 24705.70520908959},
	{0.00000000041, 3.21613978391, 17370.36097590980},
	{0.00000000047, 1.17418881008, 58953.14544329400},
	{0.00000000041, 2.05518926769, 23020.65308658799},
	{0.00000000044, 3.20914273688, 26735.94526221320},
	{0.00000000045, 3.70228663504, 54247.41313575040},
	{0.00000000040, 4.57474127522, 32243.49850088060},
	{0.00000000040, 5.17182769558, 24336.00539314920},
	{0.00000000040, 3.62816477586, 19804.82729158280},
	{0.00000000039, 1.13462594128, 18606.49894600020},
	{0.00000000040, 4.71493835645, 8401.83971036980},
	{0.00000000041, 2.69655967341, 16207.88627150200},
	{0.00000000038, 5.56507429543, 29088.81141598500},
	{0.00000000038, 2.36481926067, 6268.84875598980},
	{0.00000000038, 1.14212165839, 6297.30294399300},
	{0.00000000041, 3.38234777816, 15508.61512327440},
	{0.00000000038, 4.82215691915, 6171.88920770380},
	{0.00000000038, 4.96796930709, 6394.26249227900},
	{0.00000000039, 1.75198804720, 29826.30635467320},
	{0.00000000037, 3.64776861935, 20452.86941222180},
	{0.00000000052, 3.98463781177, 1047.74731175470},
	{0.00000000043, 6.01711305973, 55022.93574707440},
	{0.00000000037, 6.18577055273, 4061.21921539440},
	{0.00000000040, 2.02818434731, 49515.38250840700},
	{0.00000000049, 4.21086629146, 18216.44381066100},
	{0.00000000038, 4.59185538964, 18202.21671665939},
	{0.00000000035, 3.16929714068, 26482.17080962440},
	{0.00000000036, 1.56812014048, 9924.81042151060},
	{0.00000000039, 0.88019393819, 24889.57479599160},
	{0.00000000039, 4.63870568395, 26709.64694241340},
	{0.00000000036, 6.07069720518, 25287.72379939980},
	{0.00000000034, 6.10039920596, 6147.45052498140},
	{0.00000000034, 3.68972702028, 6418.70117500140},
	{0.00000000034, 2.54760886649, 21228.39202354580},
	{0.00000000034, 0.68922440987, 33019.02111220460},
	{0.00000000034, 0.40887359374, 17271.88400752640},
	{0.00000000034, 0.33424154418, 29026.48522950779},
	{0.00000000035, 1.63582495302, 7322.10246078180},
	{0.00000000044, 1.21937055747, 3981.49003408200},
	{0.00000000033, 2.56048298726, 173566.83743765688},
	{0.00000000035, 3.00160924335, 21954.15760939799},
	{0.00000000034, 3.38052068808, 38500.27603107220},
	{0.00000000032, 2.81219711037, 17686.75284556640},
	{0.00000000033, 0.13837047156, 34520.30930938080},
	{0.00000000041, 2.52021125438, 21202.09370374600},
	{0.00000000037, 5.92836585991, 7349.57132718140},
	{0.00000000031, 2.79498926181, 28230.18722269139},
	{0.00000000038, 5.01277542891, 9225.53927328300},
	{0.00000000035, 2.49445060142, 8584.66166590080},
	{0.00000000038, 2.67041435749, 15110.46611986620},
	{0.00000000037, 1.84827551648, 29296.61538957860},
	{0.00000000035, 4.26342089717, 11919.14086666800},
	{0.00000000035, 2.59482262662, 62883.35513951360},
	{0.00000000035, 5.54313072444, 29062.51309618520},
	{0.00000000035, 5.96888200431, 25685.87280280800},
	{0.00000000030, 1.38932865248, 12489.88562870720},
	{0.00000000041, 4.39843263561, 18052.92954315780},
	{0.00000000032, 4.69085169487, 6231.79551212899},
	{0.00000000032, 5.09927453137, 6334.35618785381},
	{0.00000000033, 4.71041781828, 5017.50837136500},
	{0.00000000034, 3.82387178783, 22483.84857449259},
	{0.00000000029, 0.69173791628, 27278.46881644080},
	{0.00000000028, 0.30766379271, 24080.03501677719},
	{0.00000000028, 1.80200703459, 21150.81336588360},
	{0.00000000034, 5.49813240003, 5905.70224207560},
	{0.00000000034, 4.29199382621, 6660.44945790720},
	{0.00000000031, 0.77685387250, 15265.88651930040},
	{0.00000000038, 3.55141531291, 31570.79964939120},
	{0.00000000027, 2.03421614285, 36949.23080842420},
	{0.00000000030, 0.75326086687, 12586.92709547520},
	{0.00000000027, 5.24483718904, 233141.31440436149},
	{0.00000000027, 4.99665333874, 24383.07910844140},
	{0.00000000028, 3.97690125997, 34911.41207609100},
	{0.00000000027, 4.60109049263, 1692.16566950240},
	{0.00000000027, 3.01465510733, 23581.25817731760},
	{0.00000000028, 5.79946172825, 16193.65917750039},
	{0.00000000027, 5.36876316169, 6360.74962041940},
	{0.00000000027, 4.42136306455, 6205.40207956340},
	{0.00000000032, 5.04711925057, 27511.46787353720},
	{0.00000000027, 0.74966550512, 32367.09765620760},
	{0.00000000027, 3.34326768159, 4487.81740627040},
	{0.00000000030, 4.32132101590, 52175.80628314840},
	{0.00000000029, 4.00870617495, 46386.99374331120},
	{0.00000000026, 1.30285929374, 4797.09572892620},
	{0.00000000028, 5.37411984168, 10239.58386601080},
	{0.00000000026, 5.08151018860, 6339.97422492700},
	{0.00000000026, 4.70861603764, 6226.17747505580},
	{0.00000000029, 4.88985723155, 6592.35417264720},
	{0.00000000029, 4.90026899469, 5973.79752733560},
	{0.00000000026, 3.80920015468, 25158.60171976540},
	{0.00000000026, 4.12353757087, 9910.58332750900},
	{0.00000000031, 2.37034813214, 24491.42579258340},
	{0.00000000024, 5.26265995716, 11616.97609101300},
	{0.00000000024, 4.68388215645, 31172.65064598300},
	{0.00000000029, 4.62741692698, 19402.79695281660},
	{0.00000000025, 1.21411432675, 6302.74561089119},
	{0.00000000025, 2.29282659231, 6263.40608909160},
	{0.00000000026, 4.64443513632, 30666.15495843280},
	{0.00000000027, 2.79813911349, 19800.94595622480},
	{0.00000000024, 2.16373217847, 31968.94865279940},
	{0.00000000023, 5.33583152283, 17892.93839400359},
	{0.00000000023, 5.05383022333, 29424.63423291600},
	{0.00000000024, 6.12085409163, 20597.24396304120},
	{0.00000000024, 1.65155411828, 23550.34405168259},
	{0.00000000023, 6.07302432574, 6716.78758786820},
	{0.00000000022, 2.42662159283, 7445.55055439920},
	{0.00000000027, 1.56823801633, 28628.33622609960},
	{0.00000000022, 3.39570466574, 40879.44050464380},
	{0.00000000025, 5.52794317615, 14155.22459526660},
	{0.00000000023, 1.49204312505, 6272.03014972750},
	{0.00000000023, 2.01489779401, 6294.12155025530},
	{0.00000000021, 4.21170718841, 22779.43724619380},
	{0.00000000024, 3.83904364251, 8186.51266249260},
	{0.00000000021, 2.51494728863, 30220.93223973240},
	{0.00000000022, 6.09500922463, 4379.63903749020},
	{0.00000000022, 2.95144246643, 28759.81087748319},
	{0.00000000020, 0.07597154617, 28313.28880466100},
	{0.00000000026, 1.83971959567, 18422.62935909819},
	{0.00000000022, 1.06284971840, 27707.54249429480},
	{0.00000000027, 5.38238146057, 34513.26307268280},
	{0.00000000025, 1.96129048463, 55798.45835839840},
	{0.00000000019, 0.75805525916, 11712.95531823080},
	{0.00000000025, 4.06271601240, 29864.33402730900},
	{0.00000000024, 5.92086856803, 9411.46461508720},
	{0.00000000020, 0.08212819079, 6379.05507720920},
	{0.00000000020, 3.42481272827, 6187.09662277360},
	{0.00000000022, 2.87393551670, 18326.65013188039},
	{0.00000000020, 4.26784309163, 21548.96236929180},
	{0.00000000022, 2.89425510955, 6332.83287546320},
	{0.00000000022, 0.61268580951, 6233.31882451960},
	{0.00000000021, 5.43088404515, 50317.20343953080},
	{0.00000000020, 0.38470757997, 22345.26037610820},
	{0.00000000018, 3.04737429764, 6593.91664885980},
	{0.00000000018, 0.45956662142, 5972.23505112300},
	{0.00000000019, 0.79376120003, 5618.31980486140},
	{0.00000000019, 2.71317971903, 6947.83189512140},
	{0.00000000018, 0.28017726157, 34115.11406927460},
	{0.00000000019, 4.89700323392, 83973.83535572988},
	{0.00000000019, 2.72494815105, 84019.85928049390},
	{0.00000000020, 2.60251083721, 42456.78404709160},
	{0.00000000020, 1.28313240949, 9070.11887384880},
	{0, 0, 0}
};

struct vsop87_term earth_y2[] = {
	{0.00005080208, 0.00000000000, 0.00000000000},
	{0.00002178016, 2.82957544235, 12566.15169998280},
	{0.00001020487, 4.63746718598, 6283.07584999140},
	{0.00000092688, 2.62218748420, 18849.22754997420},
	{0.00000013680, 1.80736896884, 6286.59896834040},
	{0.00000013668, 1.70191859339, 6279.55273164240},
	{0.00000008190, 2.84848380902, 6256.77753019160},
	{0.00000008145, 0.65845469208, 6309.37416979120},
	{0.00000008004, 4.35208516133, 6127.65545055720},
	{0.00000007754, 5.43893832496, 6438.49624942560},
	{0.00000008900, 3.80944637329, 83996.84731811189},
	{0.00000004754, 4.59631649528, 709.93304855830},
	{0.00000002895, 3.37918924673, 4705.73230754360},
	{0.00000003730, 0.91975073803, 5507.55323866740},
	{0.00000002937, 2.51081180566, 25132.30339996560},
	{0.00000003203, 2.57193731532, 7058.59846131540},
	{0.00000002268, 1.94917686677, 775.52261132400},
	{0.00000002148, 0.14152116438, 7860.41939243920},
	{0.00000002031, 0.72283806291, 6275.96230299060},
	{0.00000002031, 2.78410285615, 6290.18939699220},
	{0.00000001904, 2.89589054598, 5486.77784317500},
	{0.00000001728, 3.66132960737, 1059.38193018920},
	{0.00000001553, 0.56386962806, 6040.34724601740},
	{0.00000001563, 0.61022183613, 7079.37385680780},
	{0.00000001459, 1.88257310296, 5753.38488489680},
	{0.00000001425, 1.59147859762, 6812.76681508600},
	{0.00000001436, 1.45357168378, 5884.92684658320},
	{0.00000001470, 2.94579999718, 6525.80445396540},
	{0.00000001288, 2.05812819149, 6681.22485339960},
	{0.00000001338, 5.75684444528, 5729.50644714900},
	{0.00000001039, 4.28230481184, 6282.09552892320},
	{0.00000001039, 5.50782141440, 6284.05617105960},
	{0.00000001191, 4.01917074242, 6836.64525283380},
	{0.00000000904, 0.86455323243, 5331.35744374080},
	{0.00000000871, 2.27688978691, 4933.20844033260},
	{0.00000000877, 1.49469829015, 11790.62908865880},
	{0.00000001102, 3.02451706631, 167283.76158766549},
	{0.00000000774, 2.68163901032, 7234.79425624200},
	{0.00000000746, 5.06505548485, 4136.91043351620},
	{0.00000000938, 2.05233105969, 11856.21865142450},
	{0.00000000653, 6.14159854835, 11506.76976979360},
	{0.00000000653, 1.20042991173, 7632.94325965020},
	{0.00000000855, 3.67241064264, 4535.05943692440},
	{0.00000000664, 3.21978126910, 1194.44701022460},
	{0.00000000814, 1.07520259172, 155.42039943420},
	{0.00000000579, 4.64690913221, 796.29800681640},
	{0.00000000778, 4.32748087995, 5088.62883976680},
	{0.00000000511, 0.71257437268, 4694.00295470760},
	{0.00000000686, 3.47131000180, 801.82093112380},
	{0.00000000677, 1.14891148781, 3128.38876509580},
	{0.00000000499, 1.45672603171, 12569.67481833180},
	{0.00000000480, 4.72566522648, 8429.24126646660},
	{0.00000000598, 6.12701256696, 8031.09226305840},
	{0.00000000499, 4.61877818070, 1589.07289528380},
	{0.00000000562, 5.48344520380, 7477.52286021600},
	{0.00000000415, 5.06370124318, 6496.37494542940},
	{0.00000000414, 4.73489535739, 6069.77675455340},
	{0.00000000404, 0.15585991312, 3738.76143010800},
	{0.00000000500, 1.83746339810, 1592.59601363280},
	{0.00000000392, 0.64094689719, 26.29831979980},
	{0.00000000366, 5.93255688855, 553.56940284240},
	{0.00000000458, 5.56847632382, 156137.47598479928},
	{0.00000000320, 0.43684109891, 1990.74501704100},
	{0.00000000318, 4.53872367492, 951.71840625060},
	{0.00000000361, 3.78139914914, 7084.89678111520},
	{0.00000000356, 4.78764157089, 12721.57209941700},
	{0.00000000279, 5.51531767271, 4690.47983635860},
	{0.00000000347, 6.05487619509, 5481.25491886760},
	{0.00000000279, 0.65072513623, 242.72860397400},
	{0.00000000367, 2.35508391326, 9437.76293488700},
	{0.00000000260, 0.98725902772, 5223.69391980220},
	{0.00000000255, 0.26797013701, 11371.70468975820},
	{0.00000000242, 3.35248006615, 8827.39026987480},
	{0.00000000245, 2.60270196816, 3154.68708489560},
	{0.00000000222, 0.17857635292, 4164.31198961300},
	{0.00000000221, 1.83683124614, 1748.01641306700},
	{0.00000000288, 3.16521452041, 1349.86740965880},
	{0.00000000204, 5.15479639183, 11769.85369316640},
	{0.00000000188, 4.08810200628, 7875.67186362420},
	{0.00000000204, 5.17246322251, 10977.07880469900},
	{0.00000000188, 5.32022679153, 2388.89402044920},
	{0.00000000183, 2.53020407005, 7342.45778018060},
	{0.00000000196, 4.81306031436, 3930.20969621960},
	{0.00000000207, 0.71423535949, 13367.97263110660},
	{0.00000000206, 1.68118727655, 10973.55568635000},
	{0.00000000144, 3.12119544517, 10575.40668294180},
	{0.00000000155, 4.24333182826, 12410.73130054860},
	{0.00000000135, 5.62460495351, 12592.45001978260},
	{0.00000000142, 3.43769023959, 529.69096509460},
	{0.00000000125, 2.30734650656, 12562.62858163380},
	{0.00000000118, 3.15911802638, 13119.72110282519},
	{0.00000000124, 4.88716980692, 8635.94200376320},
	{0.00000000111, 0.80973565731, 398.14900340820},
	{0.00000000099, 1.74904579789, 13517.87010623340},
	{0.00000000097, 4.08519883679, 17260.15465469040},
	{0.00000000102, 2.80042792551, 10988.80815753500},
	{0.00000000093, 4.87729654087, 1577.34354244780},
	{0.00000000094, 4.56913615419, 10177.25767953360},
	{0.00000000095, 0.58410858338, 2146.16541647520},
	{0.00000000100, 0.77889460323, 13095.84266507740},
	{0.00000000082, 3.65082093235, 16730.46368959580},
	{0.00000000109, 2.42647120751, 12539.85338018300},
	{0.00000000080, 2.67636202935, 12323.42309600880},
	{0.00000000105, 1.96765666886, 5642.19824260920},
	{0.00000000101, 0.26697958405, 4292.33083295040},
	{0.00000000075, 4.15987686546, 6709.67404086740},
	{0.00000000075, 5.63024936078, 5856.47765911540},
	{0.00000000100, 5.37997214401, 250570.67585721909},
	{0.00000000071, 5.31207567706, 14314.16811304980},
	{0.00000000092, 0.41159879070, 13916.01910964160},
	{0.00000000091, 1.53881053794, 6923.95345737360},
	{0.00000000082, 2.43138857903, 31415.37924995700},
	{0.00000000083, 4.40764560915, 95143.13292097810},
	{0.00000000061, 2.66905862210, 8273.82086703240},
	{0.00000000055, 2.98440193981, 5643.17856367740},
	{0.00000000056, 3.14343584528, 639.89728631400},
	{0.00000000054, 4.06071028317, 16496.36139620240},
	{0.00000000055, 2.26469062405, 13341.67431130680},
	{0.00000000073, 0.30591075918, 71430.69561812909},
	{0.00000000052, 5.97085689483, 3634.62102451840},
	{0.00000000050, 2.61636629528, 12573.26524698360},
	{0.00000000052, 6.19672300540, 15720.83878487840},
	{0.00000000065, 4.92633618792, 4732.03062734340},
	{0.00000000066, 3.92505637420, 2787.04302385740},
	{0.00000000048, 0.45273646609, 13362.44970679920},
	{0.00000000053, 2.55293773264, 14919.01785375460},
	{0.00000000047, 2.25879651839, 12964.30070339100},
	{0.00000000047, 1.06895129610, 3894.18182954220},
	{0.00000000042, 5.09300549015, 24072.92146977640},
	{0.00000000051, 5.97812516445, 6195.76764545159},
	{0.00000000051, 3.81200106179, 6370.38405453120},
	{0.00000000048, 5.31227829697, 2118.76386037840},
	{0.00000000041, 0.92655469135, 18319.53658487960},
	{0.00000000041, 2.52247946610, 3185.19202726560},
	{0.00000000056, 2.58677293772, 84672.47584450469},
	{0.00000000039, 2.70559904392, 20426.57109242200},
	{0.00000000053, 1.64080385432, 239424.39025435288},
	{0.00000000045, 6.04609930388, 9779.10867612540},
	{0.00000000044, 3.24184126256, 8662.24032356300},
	{0.00000000043, 2.12627080359, 18139.29450141590},
	{0.00000000033, 1.67764931937, 3496.03282613400},
	{0.00000000035, 5.17885502556, 18875.52586977400},
	{0.00000000035, 4.51995137508, 10419.98628350760},
	{0.00000000031, 5.35886426810, 23013.53953958720},
	{0.00000000030, 2.82636067861, 12808.88030395680},
	{0.00000000042, 0.90184598337, 82576.98122099529},
	{0.00000000031, 3.95971884541, 14712.31711645800},
	{0.00000000040, 4.02926744005, 17789.84561978500},
	{0.00000000031, 5.47911308336, 22779.43724619380},
	{0.00000000030, 2.31682203487, 10447.38783960440},
	{0.00000000028, 2.11876435927, 14143.49524243060},
	{0.00000000028, 3.91478954977, 5429.87946823940},
	{0.00000000030, 1.17555913144, 9380.95967271720},
	{0.00000000026, 0.72314347990, 9623.68827669120},
	{0.00000000026, 2.78379743916, 2942.46342329160},
	{0.00000000030, 1.83762487734, 10213.28554621100},
	{0.00000000026, 0.18151529861, 18209.33026366019},
	{0.00000000025, 1.11733039286, 3583.34103067380},
	{0.00000000024, 1.36775216012, 9917.69687450980},
	{0.00000000026, 5.61732376806, 12012.58229714040},
	{0.00000000023, 0.92088373151, 12559.03815298200},
	{0.00000000023, 5.52325028212, 11015.10647733480},
	{0.00000000023, 0.69647593831, 26709.64694241340},
	{0.00000000024, 3.30887701069, 77713.77146812050},
	{0.00000000022, 4.42086856143, 6993.00889854970},
	{0.00000000021, 0.81252266714, 17256.63153634140},
	{0.00000000023, 5.52062840479, 149854.40013480789},
	{0.00000000019, 0.35979025769, 11926.25441366880},
	{0.00000000018, 0.71176167314, 11614.43329373220},
	{0.00000000019, 4.89783197147, 18073.70493865020},
	{0.00000000019, 2.09021029647, 30639.85663863300},
	{0.00000000022, 2.19299415984, 17298.18232732620},
	{0.00000000019, 1.23251732918, 19651.04848109800},
	{0.00000000023, 3.21303801707, 72850.56171524568},
	{0.00000000017, 2.38624204004, 8982.81066930900},
	{0.00000000021, 2.20285403235, 16858.48253293320},
	{0.00000000021, 2.89968186701, 12036.46073488820},
	{0.00000000014, 3.30566599775, 16460.33352952499},
	{0.00000000020, 4.99490943445, 5573.14280143310},
	{0.00000000015, 2.64766821618, 20199.09495963300},
	{0.00000000014, 4.87181144278, 22483.84857449259},
	{0.00000000019, 1.24341688060, 8671.96987044060},
	{0.00000000014, 5.97526530111, 90279.92316810328},
	{0.00000000016, 5.12394281212, 23543.23050468179},
	{0.00000000012, 1.13908210541, 17996.03116822220},
	{0.00000000012, 5.43458827343, 19402.79695281660},
	{0.00000000012, 2.80798050151, 10818.13528691580},
	{0.00000000015, 5.28864619208, 12567.13202105100},
	{0.00000000011, 0.21390152319, 28766.92442448400},
	{0.00000000011, 0.68624711981, 14945.31617355440},
	{0.00000000011, 3.36248263984, 18451.07854656599},
	{0.00000000011, 4.69826436697, 2352.86615377180},
	{0.00000000011, 0.30993049479, 22805.73556599360},
	{0.00000000011, 0.67524830165, 35371.88726597640},
	{0.00000000014, 0.36237106347, 21228.39202354580},
	{0.00000000010, 4.48227917427, 23141.55838292460},
	{0.00000000010, 0.98562604234, 22345.26037610820},
	{0.00000000009, 6.20387541356, 29826.30635467320},
	{0.00000000010, 4.89597714031, 12779.45079542080},
	{0.00000000010, 4.53062887484, 213.29909543800},
	{0.00000000011, 5.10892321991, 25158.60171976540},
	{0.00000000009, 2.89659186256, 23581.25817731760},
	{0, 0, 0}
};

struct vsop87_term earth_y3[] = {
	{0.00000128116, 3.14159265359, 0.00000000000},
	{0.00000072366, 1.32019314413, 12566.15169998280},
	{0.00000013847, 5.37444701633, 6283.07584999140},
	{0.00000005044, 0.96001931081, 18849.22754997420},
	{0.00000001481, 0.66592602555, 6438.49624942560},
	{0.00000001481, 2.84101489351, 6127.65545055720},
	{0.00000000644, 3.31488272100, 6279.55273164240},
	{0.00000000644, 0.19205819806, 6286.59896834040},
	{0.00000000318, 2.06760677503, 6040.34724601740},
	{0.00000000318, 1.43933414403, 6525.80445396540},
	{0.00000000220, 0.77087312633, 25132.30339996560},
	{0.00000000201, 5.53953658848, 6836.64525283380},
	{0.00000000201, 4.25058963776, 5729.50644714900},
	{0.00000000036, 6.12441668493, 12569.67481833180},
	{0.00000000033, 2.66474952932, 12410.73130054860},
	{0.00000000018, 0.75629855075, 12721.57209941700},
	{0.00000000011, 4.70234349211, 12592.45001978260},
	{0, 0, 0}
};

struct vsop87_term earth_y4[] = {
	{0.00000004187, 3.14159265359, 0.00000000000},
	{0.00000001931, 5.89883838000, 12566.15169998280},
	{0.00000000595, 0.51679590840, 6283.07584999140},
	{0.00000000210, 2.17239897368, 6438.49624942560},
	{0.00000000210, 1.33454194538, 6127.65545055720},
	{0.00000000229, 5.59311519226, 18849.22754997420},
	{0.00000000044, 3.02550685011, 709.93304855830},
	{0.00000000021, 4.89633014340, 6279.55273164240},
	{0.00000000021, 4.89379608284, 6286.59896834040},
	{0.00000000013, 2.23957099685, 83996.84731811189},
	{0.00000000011, 5.36791829228, 25132.30339996560},
	{0.00000000009, 3.62304265651, 11856.21865142450},
	{0.00000000007, 4.59462394746, 167283.76158766549},
	{0.00000000005, 1.11835906029, 12410.73130054860},
	{0.00000000006, 3.99789149114, 156137.47598479928},
	{0, 0, 0}
};

struct vsop87_term earth_y5[] = {
	{0.00000000072, 0.00000000000, 0.00000000000},
	{0.00000000043, 4.51710019379, 12566.15169998280},
	{0.00000000025, 3.76700032666, 6438.49624942560},
	{0.00000000025, 6.02312589958, 6127.65545055720},
	{0.00000000021, 2.56882591004, 6283.07584999140},
	{0.00000000008, 3.95508428463, 18849.22754997420},
	{0, 0, 0}
};

struct vsop87_term earth_z0[] = {
	{0.00000279620, 3.19870156017, 84334.66158130829},
	{0.00000101625, 5.42248110597, 5507.55323866740},
	{0.00000080461, 3.88027157914, 5223.69391980220},
	{0.00000043855, 3.70430347723, 2352.86615377180},
	{0.00000031853, 3.99997840986, 1577.34354244780},
	{0.00000022724, 3.98473831560, 1047.74731175470},
	{0.00000016395, 3.56456162523, 5856.47765911540},
	{0.00000018150, 4.98479613321, 6283.07584999140},
	{0.00000014477, 3.70258423465, 9437.76293488700},
	{0.00000014325, 3.41020246931, 10213.28554621100},
	{0.00000011204, 4.83021499098, 14143.49524243060},
	{0.00000010896, 2.08023708321, 6812.76681508600},
	{0.00000009716, 3.47560205064, 4694.00295470760},
	{0.00000010363, 4.05663928093, 71092.88135493269},
	{0.00000008792, 4.44890729280, 5753.38488489680},
	{0.00000008337, 4.99167706048, 7084.89678111520},
	{0.00000006921, 4.32559054073, 6275.96230299060},
	{0.00000009145, 1.14182646613, 6620.89011318780},
	{0.00000007205, 3.62441599378, 529.69096509460},
	{0.00000007698, 5.55425745881, 167621.57585086189},
	{0.00000005186, 6.25384533126, 18073.70493865020},
	{0.00000005027, 2.49727910749, 4705.73230754360},
	{0.00000004529, 2.33827747356, 6309.37416979120},
	{0.00000004754, 0.71100829534, 5884.92684658320},
	{0.00000004292, 1.10034019036, 6681.22485339960},
	{0.00000003855, 1.82331477760, 5486.77784317500},
	{0.00000005256, 4.42445744523, 7860.41939243920},
	{0.00000004025, 5.11990285618, 13367.97263110660},
	{0.00000004061, 6.02923989849, 3930.20969621960},
	{0.00000003798, 0.44370219832, 3154.68708489560},
	{0.00000002933, 5.12428135363, 1059.38193018920},
	{0.00000003424, 5.42065191700, 6069.77675455340},
	{0.00000003670, 4.58210192227, 12194.03291462090},
	{0.00000002912, 1.92688087702, 10977.07880469900},
	{0.00000002506, 0.60484952637, 6496.37494542940},
	{0.00000002680, 1.39497359287, 22003.91463486980},
	{0.00000002120, 4.30691000285, 5643.17856367740},
	{0.00000002235, 0.81363184041, 8635.94200376320},
	{0.00000001819, 3.75748003107, 3340.61242669980},
	{0.00000002230, 2.76407822446, 12036.46073488820},
	{0.00000001945, 5.69949789177, 11790.62908865880},
	{0.00000001529, 1.98639348122, 398.14900340820},
	{0.00000001581, 3.19976230948, 5088.62883976680},
	{0.00000001424, 6.26116472313, 2544.31441988340},
	{0.00000001405, 4.69394873481, 7058.59846131540},
	{0.00000001588, 0.25704624784, 17298.18232732620},
	{0.00000001478, 2.81808207569, 25934.12433108940},
	{0.00000001693, 4.95689385293, 156475.29024799570},
	{0.00000001123, 2.38605285936, 3738.76143010800},
	{0.00000000990, 4.29600699156, 9225.53927328300},
	{0.00000000923, 3.07195736431, 4164.31198961300},
	{0.00000000863, 0.55119493097, 8429.24126646660},
	{0.00000000984, 5.96784225392, 7079.37385680780},
	{0.00000001086, 3.14159265359, 0.00000000000},
	{0.00000000824, 1.50050055147, 10447.38783960440},
	{0.00000000829, 3.51336978167, 11506.76976979360},
	{0.00000000908, 0.12102885474, 11015.10647733480},
	{0.00000000742, 1.99159139281, 26087.90314157420},
	{0.00000000850, 4.24120016095, 29864.33402730900},
	{0.00000000762, 2.90028034892, 4732.03062734340},
	{0.00000000711, 1.38596151724, 2146.16541647520},
	{0.00000000766, 0.61397570576, 796.29800681640},
	{0.00000000708, 1.91406542362, 8031.09226305840},
	{0.00000000810, 5.13961498599, 2942.46342329160},
	{0.00000000751, 1.67479850166, 21228.39202354580},
	{0.00000000589, 2.02193316047, 775.52261132400},
	{0.00000000513, 2.60734651128, 12566.15169998280},
	{0.00000000550, 1.61119298963, 801.82093112380},
	{0.00000000592, 4.59481504319, 4690.47983635860},
	{0.00000000519, 5.72925039114, 8827.39026987480},
	{0.00000000515, 4.09976487552, 64809.80550494129},
	{0.00000000503, 5.66433137112, 33794.54372352860},
	{0.00000000476, 3.69640472448, 213.29909543800},
	{0.00000000463, 1.24987240483, 15720.83878487840},
	{0.00000000411, 0.10769444525, 3128.38876509580},
	{0.00000000504, 3.26207669160, 7632.94325965020},
	{0.00000000552, 1.02926440457, 239762.20451754928},
	{0.00000000394, 5.81496021156, 426.59819087600},
	{0.00000000476, 3.52810472421, 16496.36139620240},
	{0.00000000503, 4.85802444134, 6290.18939699220},
	{0.00000000417, 0.81920713533, 5216.58037280140},
	{0.00000000363, 5.70015720452, 1589.07289528380},
	{0.00000000363, 1.28376436579, 6206.80977871580},
	{0.00000000353, 4.70059133110, 7234.79425624200},
	{0.00000000381, 2.61890749829, 7342.45778018060},
	{0.00000000420, 0.97821135132, 4136.91043351620},
	{0.00000000335, 6.22057967320, 12168.00269657460},
	{0.00000000387, 3.09145061418, 25158.60171976540},
	{0.00000000349, 2.94840720073, 9623.68827669120},
	{0.00000000418, 3.75759994446, 5230.80746680300},
	{0.00000000396, 1.22507712354, 6438.49624942560},
	{0.00000000322, 1.21162178805, 8662.24032356300},
	{0.00000000323, 5.50254808471, 1194.44701022460},
	{0.00000000372, 1.72256107938, 14945.31617355440},
	{0.00000000305, 0.80429352049, 37724.75341974820},
	{0.00000000265, 6.10358507671, 6836.64525283380},
	{0.00000000250, 4.56452895547, 7477.52286021600},
	{0.00000000266, 2.62926282354, 7238.67559160000},
	{0.00000000262, 1.34297269105, 11769.85369316640},
	{0.00000000263, 6.22089501237, 6133.51265285680},
	{0.00000000302, 2.81139045072, 1748.01641306700},
	{0.00000000316, 1.62662805006, 250908.49012041549},
	{0.00000000226, 2.42346415873, 11371.70468975820},
	{0.00000000216, 3.68721275185, 5849.36411211460},
	{0.00000000276, 2.33399767923, 19651.04848109800},
	{0.00000000230, 0.36165162947, 5863.59120611620},
	{0.00000000200, 5.86073159059, 4535.05943692440},
	{0.00000000277, 4.65400292395, 82239.16695779889},
	{0.00000000199, 5.05186622555, 5429.87946823940},
	{0.00000000206, 3.70556027982, 10973.55568635000},
	{0.00000000210, 4.50691909144, 29088.81141598500},
	{0.00000000181, 6.00294783127, 4292.33083295040},
	{0.00000000249, 0.12900984422, 154379.79562448629},
	{0.00000000167, 6.27348370813, 10988.80815753500},
	{0.00000000183, 3.19836584401, 16730.46368959580},
	{0.00000000225, 3.18339652605, 18875.52586977400},
	{0.00000000192, 0.87192032514, 77375.95720492408},
	{0.00000000188, 2.22746128596, 41654.96311596780},
	{0.00000000160, 5.20207795189, 5481.25491886760},
	{0.00000000192, 3.89678943865, 17789.84561978500},
	{0.00000000159, 5.32590846475, 7.11354700080},
	{0.00000000214, 4.08171403539, 337.81426319640},
	{0.00000000184, 3.75465072369, 23581.25817731760},
	{0.00000000160, 4.53897529970, 18477.10876461230},
	{0.00000000144, 5.19486374726, 20426.57109242200},
	{0.00000000126, 1.69446958184, 15110.46611986620},
	{0.00000000149, 1.55306832217, 10021.83728009940},
	{0.00000000127, 5.31068233515, 639.89728631400},
	{0.00000000118, 2.73268114062, 18849.22754997420},
	{0.00000000123, 2.55361087146, 12592.45001978260},
	{0.00000000113, 6.07178776726, 6709.67404086740},
	{0.00000000130, 3.94161517411, 7330.82316174610},
	{0.00000000110, 3.51203379263, 18052.92954315780},
	{0.00000000147, 4.63371971408, 22805.73556599360},
	{0.00000000113, 1.20711498905, 14919.01785375460},
	{0.00000000108, 3.76359880753, 14314.16811304980},
	{0.00000000148, 0.65447253687, 95480.94718417450},
	{0.00000000121, 3.13748782783, 14712.31711645800},
	{0.00000000119, 5.92110458985, 33019.02111220460},
	{0.00000000124, 2.93638421840, 32217.20018108080},
	{0.00000000117, 3.65065271640, 45585.17281218740},
	{0.00000000127, 4.74596574209, 49515.38250840700},
	{0.00000000120, 1.04211499785, 6915.85958930460},
	{0.00000000120, 5.60638811846, 5650.29211067820},
	{0.00000000127, 2.70766997307, 12352.85260454480},
	{0.00000000113, 5.39691616452, 5235.32853823670},
	{0.00000000097, 1.07908724794, 9917.69687450980},
	{0.00000000123, 5.15992792934, 27511.46787353720},
	{0.00000000099, 4.45774681732, 4933.20844033260},
	{0.00000000087, 3.93637812950, 17654.78053974960},
	{0.00000000122, 2.23956068680, 83997.09113559539},
	{0.00000000102, 3.97386522171, 10818.13528691580},
	{0.00000000084, 4.21241958885, 22779.43724619380},
	{0.00000000103, 4.63519841733, 1349.86740965880},
	{0.00000000081, 4.01655240430, 1592.59601363280},
	{0.00000000092, 3.24182657569, 78051.58573131690},
	{0.00000000094, 4.33873972800, 36147.40987730040},
	{0.00000000076, 2.83897554420, 17260.15465469040},
	{0.00000000100, 6.07733097102, 26735.94526221320},
	{0.00000000078, 0.72462427283, 12779.45079542080},
	{0.00000000086, 5.26029638250, 28313.28880466100},
	{0.00000000093, 4.31900620254, 44809.65020086340},
	{0.00000000076, 6.22743405935, 13521.75144159140},
	{0.00000000081, 2.16420552322, 13095.84266507740},
	{0.00000000100, 1.38002787119, 28286.99048486120},
	{0.00000000072, 1.55820597747, 6256.77753019160},
	{0.00000000082, 4.95202664555, 10575.40668294180},
	{0.00000000082, 1.69647647075, 1990.74501704100},
	{0.00000000096, 6.16038106485, 24356.78078864160},
	{0.00000000075, 2.29836095644, 3634.62102451840},
	{0.00000000075, 2.66367876557, 16200.77272450120},
	{0.00000000087, 0.26630214764, 31441.67756975680},
	{0.00000000080, 5.00001604436, 150192.21439800429},
	{0.00000000079, 0.01398391548, 90617.73743129970},
	{0.00000000054, 5.59738773448, 161338.50000087050},
	{0.00000000056, 2.60133794851, 73188.37597844210},
	{0.00000000055, 5.81483150022, 143233.51002162008},
	{0.00000000054, 3.38482031504, 323049.11878710288},
	{0, 0, 0}
};

struct vsop87_term earth_z1[] = {
	{0.00227822442, 3.41372504278, 6283.07584999140},
	{0.00005429282, 0.00000000000, 0.00000000000},
	{0.00001903183, 3.37061270964, 12566.15169998280},
	{0.00000023859, 3.32836261978, 18849.22754997420},
	{0.00000008671, 1.82289925035, 5223.69391980220},
	{0.00000007767, 3.88787435832, 5507.55323866740},
	{0.00000007063, 5.19303169379, 2352.86615377180},
	{0.00000007090, 2.32907317990, 83996.84731811189},
	{0.00000005362, 2.22429221689, 529.69096509460},
	{0.00000003894, 2.15568517178, 6279.55273164240},
	{0.00000003892, 1.53021064904, 6286.59896834040},
	{0.00000003285, 4.88047587852, 10213.28554621100},
	{0.00000002165, 6.23220223547, 7860.41939243920},
	{0.00000002084, 5.84682067018, 1577.34354244780},
	{0.00000001959, 1.42270916062, 12036.46073488820},
	{0.00000001396, 0.50057569258, 6309.37416979120},
	{0.00000001584, 1.81185253086, 5856.47765911540},
	{0.00000001493, 1.75695182457, 5884.92684658320},
	{0.00000001713, 6.04661123493, 398.14900340820},
	{0.00000001298, 3.71598693704, 1059.38193018920},
	{0.00000001573, 2.20074999518, 9437.76293488700},
	{0.00000001503, 3.94648902715, 4705.73230754360},
	{0.00000001041, 2.94815263534, 6256.77753019160},
	{0.00000000983, 2.24865863102, 6681.22485339960},
	{0.00000001150, 2.43940396435, 775.52261132400},
	{0.00000001171, 0.74619691355, 6812.76681508600},
	{0.00000000881, 1.86103443124, 3930.20969621960},
	{0.00000000696, 1.45896954690, 11790.62908865880},
	{0.00000000732, 1.60348898963, 4694.00295470760},
	{0.00000000487, 0.04282116718, 11506.76976979360},
	{0.00000000632, 4.34207925908, 5753.38488489680},
	{0.00000000584, 3.11517364836, 709.93304855830},
	{0.00000000583, 3.92560802577, 12168.00269657460},
	{0.00000000409, 4.63047700185, 796.29800681640},
	{0.00000000483, 5.74980419879, 17789.84561978500},
	{0.00000000405, 1.97558286872, 6283.00853968860},
	{0.00000000405, 1.53147989887, 6283.14316029419},
	{0.00000000354, 3.28490469609, 25132.30339996560},
	{0.00000000417, 3.63631064623, 13367.97263110660},
	{0.00000000367, 1.55081387384, 18073.70493865020},
	{0.00000000284, 0.15061211477, 3738.76143010800},
	{0.00000000295, 2.75399172194, 14143.49524243060},
	{0.00000000288, 2.98400521096, 6275.96230299060},
	{0.00000000353, 2.42503121206, 213.29909543800},
	{0.00000000250, 0.42640065085, 7079.37385680780},
	{0.00000000251, 2.81315684448, 6290.18939699220},
	{0.00000000338, 2.55274440586, 7058.59846131540},
	{0.00000000230, 2.54182122331, 7084.89678111520},
	{0.00000000212, 4.71778046808, 6496.37494542940},
	{0.00000000188, 3.17403855561, 5486.77784317500},
	{0.00000000184, 4.29245958347, 1589.07289528380},
	{0.00000000216, 2.95054003179, 22003.91463486980},
	{0.00000000165, 1.19407165511, 5643.17856367740},
	{0.00000000196, 4.68462471621, 167283.76158766549},
	{0.00000000162, 2.94100342992, 15720.83878487840},
	{0.00000000189, 5.09534739493, 17298.18232732620},
	{0.00000000149, 5.23057852418, 11769.85369316640},
	{0.00000000150, 1.65291444016, 3128.38876509580},
	{0.00000000143, 5.48362795500, 10977.07880469900},
	{0.00000000144, 3.81203756929, 6262.30045449900},
	{0.00000000143, 5.97809021355, 6303.85124548380},
	{0.00000000136, 4.97038154072, 4136.91043351620},
	{0.00000000163, 2.00627600582, 5230.80746680300},
	{0.00000000135, 3.68020950012, 7.11354700080},
	{0.00000000130, 4.41428061934, 6127.65545055720},
	{0.00000000123, 0.93547502051, 3340.61242669980},
	{0.00000000122, 3.13394683057, 1194.44701022460},
	{0.00000000131, 4.24961399629, 6282.09552892320},
	{0.00000000131, 5.54051222995, 6284.05617105960},
	{0.00000000161, 3.32421999691, 6283.31966747490},
	{0.00000000128, 4.35489873365, 25934.12433108940},
	{0.00000000113, 4.42578862670, 19651.04848109800},
	{0.00000000107, 2.97447343520, 8827.39026987480},
	{0.00000000107, 0.41198538606, 5481.25491886760},
	{0.00000000131, 2.29167404623, 3154.68708489560},
	{0.00000000139, 0.84923405785, 6069.77675455340},
	{0.00000000109, 3.21932289821, 801.82093112380},
	{0.00000000115, 3.71248897285, 11856.21865142450},
	{0.00000000086, 2.78714560645, 5216.58037280140},
	{0.00000000116, 1.07208569199, 12352.85260454480},
	{0.00000000085, 4.74199868968, 8429.24126646660},
	{0.00000000112, 5.29899379351, 2544.31441988340},
	{0.00000000096, 5.20691825399, 17260.15465469040},
	{0.00000000074, 4.51170584596, 8635.94200376320},
	{0.00000000097, 5.50959692365, 29864.33402730900},
	{0.00000000094, 0.25007575444, 21228.39202354580},
	{0.00000000082, 3.01994555641, 20426.57109242200},
	{0.00000000071, 0.47420303374, 2146.16541647520},
	{0.00000000074, 1.27647360807, 4164.31198961300},
	{0.00000000075, 0.73893922793, 9225.53927328300},
	{0.00000000065, 1.39694123605, 12569.67481833180},
	{0.00000000074, 2.20184828895, 37724.75341974820},
	{0.00000000058, 5.36736393336, 11015.10647733480},
	{0.00000000069, 3.56483879750, 4535.05943692440},
	{0.00000000064, 2.05206957553, 12562.62858163380},
	{0.00000000050, 4.30582312752, 426.59819087600},
	{0.00000000056, 4.14424591372, 5088.62883976680},
	{0.00000000061, 0.63918772258, 33794.54372352860},
	{0.00000000049, 6.20603791837, 12559.03815298200},
	{0.00000000059, 4.92457810620, 71430.69561812909},
	{0.00000000058, 1.68201284430, 25158.60171976540},
	{0.00000000051, 5.03600618727, 5863.59120611620},
	{0.00000000047, 0.30276119177, 11371.70468975820},
	{0.00000000050, 0.77635440262, 26.29831979980},
	{0.00000000041, 1.87344929139, 1748.01641306700},
	{0.00000000041, 5.91861144924, 23581.25817731760},
	{0.00000000055, 1.37242658028, 7342.45778018060},
	{0.00000000053, 1.47750772846, 18319.53658487960},
	{0.00000000042, 0.11693102263, 23543.23050468179},
	{0.00000000045, 5.18332998014, 16496.36139620240},
	{0.00000000045, 1.69577010458, 6702.56049386660},
	{0.00000000050, 3.62740835096, 41654.96311596780},
	{0.00000000050, 0.12043698146, 29088.81141598500},
	{0.00000000039, 2.15562950918, 4933.20844033260},
	{0.00000000048, 5.37118742490, 7477.52286021600},
	{0.00000000040, 3.02033323932, 10447.38783960440},
	{0.00000000035, 3.52010534689, 26087.90314157420},
	{0.00000000045, 6.10982446357, 8031.09226305840},
	{0.00000000043, 4.08726331262, 156137.47598479928},
	{0.00000000032, 6.09025731476, 64809.80550494129},
	{0, 0, 0}
};

struct vsop87_term earth_z2[] = {
	{0.00009721989, 5.15233725915, 6283.07584999140},
	{0.00000349501, 3.14159265359, 0.00000000000},
	{0.00000067136, 0.64403888586, 12566.15169998280},
	{0.00000002169, 1.07314429736, 18849.22754997420},
	{0.00000001662, 1.62746869551, 84334.66158130829},
	{0.00000000635, 3.51985338656, 6279.55273164240},
	{0.00000000492, 2.41382223971, 1047.74731175470},
	{0.00000000347, 6.16127984865, 5223.69391980220},
	{0.00000000322, 0.37660897389, 6286.59896834040},
	{0.00000000302, 4.06770618987, 83996.84731811189},
	{0.00000000314, 2.37089871705, 5507.55323866740},
	{0.00000000242, 1.64810071161, 7860.41939243920},
	{0.00000000243, 3.96741961391, 529.69096509460},
	{0.00000000229, 0.50869157074, 2352.86615377180},
	{0.00000000170, 5.28668290523, 6256.77753019160},
	{0.00000000174, 0.13496987900, 10213.28554621100},
	{0.00000000125, 3.13799899281, 5884.92684658320},
	{0.00000000118, 3.85466055344, 1577.34354244780},
	{0.00000000123, 4.17102530625, 6309.37416979120},
	{0.00000000089, 1.65074757807, 4705.73230754360},
	{0.00000000090, 4.13333302298, 5753.38488489680},
	{0.00000000067, 0.30879908581, 775.52261132400},
	{0.00000000088, 2.93230657226, 12036.46073488820},
	{0.00000000065, 6.02619905507, 6812.76681508600},
	{0.00000000067, 1.15131045651, 25132.30339996560},
	{0.00000000065, 2.72055837855, 6127.65545055720},
	{0.00000000062, 0.78482367183, 6438.49624942560},
	{0.00000000057, 1.49017558261, 11506.76976979360},
	{0.00000000056, 4.55921214755, 5486.77784317500},
	{0.00000000075, 0.84213523741, 167621.57585086189},
	{0.00000000069, 1.21340931171, 398.14900340820},
	{0.00000000047, 5.28931662006, 7079.37385680780},
	{0.00000000044, 3.09697268535, 11790.62908865880},
	{0.00000000057, 6.15295833679, 12194.03291462090},
	{0.00000000040, 1.74073861374, 1059.38193018920},
	{0.00000000040, 2.70069983169, 10988.80815753500},
	{0.00000000036, 0.32483893578, 6681.22485339960},
	{0.00000000046, 3.38617099014, 156475.29024799570},
	{0.00000000033, 1.26266496002, 6290.18939699220},
	{0.00000000033, 2.25067065498, 6275.96230299060},
	{0.00000000032, 2.90595681986, 796.29800681640},
	{0.00000000029, 1.96179670465, 7.11354700080},
	{0.00000000023, 4.86623778952, 3738.76143010800},
	{0.00000000025, 4.85403147726, 709.93304855830},
	{0.00000000021, 6.22275008403, 6069.77675455340},
	{0.00000000024, 5.83690442827, 6282.09552892320},
	{0.00000000024, 3.95322179797, 6284.05617105960},
	{0.00000000022, 3.46618662246, 4136.91043351620},
	{0.00000000021, 3.58048145762, 6496.37494542940},
	{0.00000000025, 5.59503085104, 7058.59846131540},
	{0.00000000019, 1.62978232282, 1194.44701022460},
	{0.00000000019, 2.82679050999, 1589.07289528380},
	{0.00000000024, 5.40715542605, 12168.00269657460},
	{0, 0, 0}
};

struct vsop87_term earth_z3[] = {
	{0.00000276077, 0.59413258730, 6283.07584999140},
	{0.00000025551, 3.14159265359, 0.00000000000},
	{0.00000001810, 0.11612262117, 12566.15169998280},
	{0.00000000113, 5.66152847225, 18849.22754997420},
	{0.00000000056, 5.02765554835, 6279.55273164240},
	{0.00000000024, 0.41571093398, 83996.84731811189},
	{0.00000000019, 5.99007646261, 6256.77753019160},
	{0.00000000018, 3.80004734567, 6309.37416979120},
	{0.00000000018, 1.21049250774, 6127.65545055720},
	{0.00000000018, 2.29734567137, 6438.49624942560},
	{0.00000000015, 4.72881467263, 6286.59896834040},
	{0.00000000011, 1.48347223110, 709.93304855830},
	{0, 0, 0}
};

struct vsop87_term earth_z4[] = {
	{0.00000005751, 2.27069090892, 6283.07584999140},
	{0.00000001305, 0.00000000000, 0.00000000000},
	{0.00000000060, 4.26712050846, 12566.15169998280},
	{0.00000000006, 4.13914011953, 18849.22754997420},
	{0.00000000005, 0.84308705203, 1047.74731175470},
	{0.00000000005, 0.05711572303, 84334.66158130829},
	{0, 0, 0}
};

struct vsop87_term earth_z5[] = {
	{0.00000000114, 4.31169156923, 6283.07584999140},
	{0.00000000035, 0.00000000000, 0.00000000000},
	{0, 0, 0}
};

struct vsop87_term mars_x0[] = {
	{1.51769936383, 6.20403346548, 3340.61242669980},
	{0.19502945246, 3.14159265359, 0.00000000000},
	{0.07070919655, 0.25870338558, 6681.22485339960},
	{0.00494196914, 0.59669127768, 10021.83728009940},
	{0.00040938237, 0.93473307419, 13362.44970679920},
	{0.00021067199, 1.80435656154, 3337.08930835080},
	{0.00021041626, 1.17895619474, 3344.13554504880},
	{0.00011370375, 4.83265211109, 1059.38193018920},
	{0.00013527976, 0.63010765169, 529.69096509460},
	{0.00006774107, 3.61785048282, 3340.59517304760},
	{0.00006774060, 5.64862211431, 3340.62968035200},
	{0.00008226069, 1.86843519535, 2281.23049651060},
	{0.00005469046, 1.13324429003, 2942.46342329160},
	{0.00004817134, 1.85091045536, 3738.76143010800},
	{0.00004937579, 4.43241440654, 5621.84292321040},
	{0.00005276260, 2.33148083116, 6151.53388830500},
	{0.00003636667, 6.11397592106, 796.29800681640},
	{0.00003725823, 1.27280182943, 16703.06213349900},
	{0.00003729746, 1.21398323637, 398.14900340820},
	{0.00002368513, 2.96841895360, 2544.31441988340},
	{0.00002397865, 0.63553674054, 3149.16416058820},
	{0.00002274646, 2.35708328853, 3532.06069281140},
	{0.00001977579, 2.14087826110, 6677.70173505060},
	{0.00002229176, 1.69588962513, 3340.54511639700},
	{0.00002229117, 1.28739323821, 3340.67973700260},
	{0.00002182206, 1.69655112969, 6283.07584999140},
	{0.00002241010, 4.82218655311, 8962.45534991020},
	{0.00001677693, 3.14442612046, 5884.92684658320},
	{0.00001630482, 0.24117974845, 4136.91043351620},
	{0.00001958162, 1.51914544555, 6684.74797174860},
	{0.00001378470, 2.18011900021, 1751.53953141600},
	{0.00001289804, 4.70970778621, 1194.44701022460},
	{0.00001468124, 1.87869730543, 3870.30339179440},
	{0.00001290170, 0.43596325296, 2810.92146160520},
	{0.00001572540, 4.84809921789, 1589.07289528380},
	{0.00000956752, 5.36994227392, 426.59819087600},
	{0.00000819458, 5.15884167649, 4399.99435688900},
	{0.00000708712, 4.69562713369, 5486.77784317500},
	{0.00000719048, 2.91145340412, 191.44826611160},
	{0.00000702848, 4.67590003722, 2146.16541647520},
	{0.00000720121, 2.65539067862, 9492.14631500480},
	{0.00000631186, 3.95569679737, 6681.20759974740},
	{0.00000631186, 5.98646842887, 6681.24210705180},
	{0.00000582287, 3.95295967777, 3185.19202726560},
	{0.00000709131, 0.92869188035, 213.29909543800},
	{0.00000555568, 5.32014604077, 3496.03282613400},
	{0.00000492190, 2.17606530808, 7079.37385680780},
	{0.00000535122, 3.30310120139, 1592.59601363280},
	{0.00000417652, 5.30163601083, 3341.59274776800},
	{0.00000417769, 3.96482796919, 3339.63210563160},
	{0.00000370752, 5.08127148188, 8432.76438481560},
	{0.00000360028, 1.61089122901, 20043.67456019880},
	{0.00000353036, 3.88678429649, 6254.62666252360},
	{0.00000352079, 5.17043717929, 12303.06777661000},
	{0.00000321578, 1.94644283196, 3553.91152213780},
	{0.00000346042, 6.16404119331, 5088.62883976680},
	{0.00000301924, 0.98460899560, 3127.31333126180},
	{0.00000287211, 2.07531303415, 7.11354700080},
	{0.00000307060, 0.00966130243, 1748.01641306700},
	{0.00000260116, 1.89587348902, 1990.74501704100},
	{0.00000313875, 5.10651966600, 4535.05943692440},
	{0.00000271815, 1.94925691995, 6467.92575796160},
	{0.00000223359, 3.55354563068, 3319.83703120740},
	{0.00000221615, 5.71282076784, 3361.38782219220},
	{0.00000234058, 2.03750130921, 9623.68827669120},
	{0.00000207708, 2.03373205181, 6681.15754309680},
	{0.00000205217, 1.85790835685, 10025.36039844840},
	{0.00000207851, 2.47841996435, 10018.31416175040},
	{0.00000253068, 1.39828863887, 2914.01423582380},
	{0.00000193257, 4.93224646907, 2118.76386037840},
	{0.00000218718, 0.97547090194, 6489.77658728800},
	{0.00000190381, 1.28527355998, 4690.47983635860},
	{0.00000207708, 1.62523566496, 6681.29216370240},
	{0.00000178814, 2.54776084181, 1221.84856632140},
	{0.00000157307, 0.48852895157, 2388.89402044920},
	{0.00000177177, 4.27081023055, 2957.71589447660},
	{0.00000147711, 2.47588653124, 7210.91581849420},
	{0.00000164710, 0.57591122272, 7477.52286021600},
	{0.00000153944, 4.44473119432, 639.89728631400},
	{0.00000168450, 5.06929034077, 3723.50895892300},
	{0.00000126166, 2.64309008334, 4292.33083295040},
	{0.00000161231, 1.53118234358, 1349.86740965880},
	{0.00000135146, 0.12922395244, 7903.07341972100},
	{0.00000146849, 4.41614407590, 3337.02199804800},
	{0.00000146211, 4.84723563341, 3344.20285535160},
	{0.00000166323, 3.16905368032, 10213.28554621100},
	{0.00000119425, 4.65545643220, 11773.37681151540},
	{0.00000144098, 5.36305248386, 2787.04302385740},
	{0.00000112328, 0.07498207309, 3205.54734666440},
	{0.00000118125, 5.18570866097, 4929.68532198360},
	{0.00000112305, 3.45701462628, 3333.49887969900},
	{0.00000106788, 2.91050878748, 3475.67750673520},
	{0.00000125116, 3.97421380472, 3894.18182954220},
	{0.00000120319, 3.40966066157, 9225.53927328300},
	{0.00000097207, 2.99865676561, 951.71840625060},
	{0.00000106515, 5.50162815365, 382.89653222320},
	{0.00000096090, 5.81819224527, 3347.72597370060},
	{0.00000088763, 2.98692015057, 12832.75874170460},
	{0.00000088424, 0.46788407862, 3097.88382272579},
	{0.00000115240, 5.86554297015, 155.42039943420},
	{0.00000080693, 2.54262499897, 3583.34103067380},
	{0.00000085394, 3.68553580935, 4933.20844033260},
	{0.00000084575, 0.98139044515, 6674.11130639880},
	{0.00000073165, 5.03165292302, 1052.26838318840},
	{0.00000072879, 4.43895846428, 553.56940284240},
	{0.00000073967, 5.89004738022, 3767.21061757580},
	{0.00000092023, 4.26113870399, 9595.23908922340},
	{0.00000066160, 0.94815285206, 3.52311834900},
	{0.00000073608, 5.48570032991, 7740.60678358880},
	{0.00000066070, 1.60388512429, 1066.49547719000},
	{0.00000066213, 2.34472269926, 2700.71514038580},
	{0.00000069810, 5.73677959672, 5092.15195811580},
	{0.00000054167, 4.29292954610, 6525.80445396540},
	{0.00000066184, 0.04131920152, 10021.85453375160},
	{0.00000049919, 5.09299800813, 3312.16323923200},
	{0.00000049213, 4.17306140605, 3369.06161416760},
	{0.00000047370, 5.51507270323, 15643.68020330980},
	{0.00000066184, 4.29373287721, 10021.82002644720},
	{0.00000057875, 5.05744124530, 6041.32756708560},
	{0.00000043269, 1.94632875724, 149.56319713460},
	{0.00000053324, 2.50863035758, 10419.98628350760},
	{0.00000038940, 5.63973862939, 6682.20517446780},
	{0.00000043109, 2.71319075118, 3325.35995551480},
	{0.00000042867, 0.27117433127, 3355.86489788480},
	{0.00000048698, 5.09899941910, 2274.11694950980},
	{0.00000046383, 1.73717073020, 2288.34404351140},
	{0.00000036267, 1.94902928841, 23384.28698689860},
	{0.00000050165, 2.14736989820, 4562.46099302120},
	{0.00000041472, 3.60893965854, 536.80451209540},
	{0.00000039049, 0.74753075600, 522.57741809380},
	{0.00000044704, 4.31072201688, 3077.52850332700},
	{0.00000031936, 4.22847752010, 5628.95647021120},
	{0.00000033826, 2.14280999100, 242.72860397400},
	{0.00000031516, 2.26487927217, 5331.35744374080},
	{0.00000036134, 2.27592727288, 9808.53818466140},
	{0.00000031693, 5.11483018936, 2648.45482547300},
	{0.00000039073, 4.30379109135, 6680.24453233140},
	{0.00000029903, 0.50914323279, 7373.38245462640},
	{0.00000032386, 5.44057780617, 7875.67186362420},
	{0.00000038513, 2.35130225277, 6894.52394883760},
	{0.00000040052, 4.95360412434, 3603.69635007260},
	{0.00000027675, 2.38007622196, 12964.30070339100},
	{0.00000029415, 1.41703966406, 5614.72937620960},
	{0.00000029767, 5.41991083227, 3178.14579056760},
	{0.00000027624, 1.51598253003, 8429.24126646660},
	{0.00000027780, 3.76684820301, 3503.07906283200},
	{0.00000031613, 1.92518888418, 103.09277421860},
	{0.00000023774, 3.79283688871, 3320.25710730100},
	{0.00000023576, 5.47254185738, 3360.96774609859},
	{0.00000024400, 1.62009556792, 76.26607127560},
	{0.00000022361, 4.86113133643, 15113.98923821520},
	{0.00000022690, 2.19469301612, 13365.97282514820},
	{0.00000023114, 4.24399671317, 1692.16566950240},
	{0.00000024893, 2.94802556560, 692.15760122680},
	{0.00000021831, 1.96164672611, 10021.90459040220},
	{0.00000021452, 3.90485002116, 6660.44945790720},
	{0.00000020657, 4.09048527688, 1581.95934828300},
	{0.00000025193, 0.35005183307, 3335.08950239240},
	{0.00000021831, 2.37014311295, 10021.76996979660},
	{0.00000025135, 2.63045826824, 3346.13535100720},
	{0.00000022753, 1.31299329202, 9830.38901398780},
	{0.00000020575, 0.90645437334, 6438.49624942560},
	{0.00000024954, 2.47676946948, 1648.44675719740},
	{0.00000019324, 0.97030055777, 3329.97576135000},
	{0.00000019241, 2.01197452147, 3351.24909204960},
	{0.00000023600, 6.05705050939, 10713.99488132620},
	{0.00000017286, 0.90425997403, 6872.67311951120},
	{0.00000019863, 5.26277662529, 9381.93999378540},
	{0.00000023245, 2.81335780702, 1758.65307841680},
	{0.00000018911, 1.70838297719, 3863.18984479360},
	{0.00000019594, 1.20290770391, 2818.03500860600},
	{0.00000023014, 2.81461106664, 13358.92658845020},
	{0.00000020716, 6.04882555598, 6702.00024889200},
	{0.00000017630, 0.77500497806, 3074.00538497800},
	{0.00000021283, 0.36889274817, 2707.82868738660},
	{0.00000016342, 4.60982335717, 6298.32832117640},
	{0.00000022491, 3.05082771617, 8031.09226305840},
	{0.00000016318, 2.90860348903, 10551.52824519400},
	{0.00000017705, 0.90939692872, 10818.13528691580},
	{0.00000016242, 2.21265902746, 3607.21946842160},
	{0.00000016533, 2.14796846234, 6158.64743530580},
	{0.00000019622, 3.51635800323, 853.19638175200},
	{0.00000019312, 5.67131104636, 6836.64525283380},
	{0.00000014994, 1.03985219202, 6531.66165626500},
	{0.00000013970, 2.37214915393, 419.48464387520},
	{0.00000017187, 5.02091584362, 11243.68584642080},
	{0.00000013658, 0.95367846073, 7064.12138562280},
	{0.00000013547, 5.18592691748, 6684.81528205140},
	{0.00000015670, 4.46631838197, 3333.56619000180},
	{0.00000016212, 0.84608813575, 5729.50644714900},
	{0.00000016254, 5.63862628078, 6144.42034130420},
	{0.00000016776, 3.21915143967, 4032.77002792660},
	{0.00000013925, 4.61081158788, 12935.85151592320},
	{0.00000016781, 2.44831081494, 3973.39616601300},
	{0.00000012720, 2.28483212376, 3336.73109134180},
	{0.00000012703, 0.69084968319, 3344.49376205780},
	{0.00000015246, 5.27637617538, 5459.37628707820},
	{0.00000014286, 0.57434628738, 10404.73381232260},
	{0.00000013779, 5.24898678188, 433.71173787680},
	{0.00000013737, 5.70954873985, 6127.65545055720},
	{0.00000012994, 3.50514987766, 8827.39026987480},
	{0.00000012310, 3.32813422481, 2487.41604494780},
	{0.00000012133, 4.87509657472, 3980.50971301380},
	{0.00000015437, 5.37888245444, 74.78159856730},
	{0.00000012110, 4.63788633296, 3281.23856478620},
	{0.00000013767, 4.75090697315, 6677.63442474780},
	{0.00000011758, 4.61782311507, 3399.98628861340},
	{0.00000013443, 1.58243707468, 1596.18644228460},
	{0.00000011916, 5.44422183383, 1744.42598441520},
	{0.00000013640, 5.59411674318, 3415.39402526710},
	{0.00000012925, 4.67854321339, 7632.94325965020},
	{0.00000013026, 3.93047583551, 11769.85369316640},
	{0.00000011412, 3.55488173063, 11371.70468975820},
	{0.00000011148, 5.52272711776, 8270.29774868340},
	{0.00000011153, 3.25807789781, 6816.28993343500},
	{0.00000011351, 4.98057415035, 4989.05918389720},
	{0.00000012966, 4.66632646085, 8969.56889691100},
	{0.00000010902, 2.90900176456, 110.20632121940},
	{0.00000013281, 3.70325148510, 3265.83082813250},
	{0.00000013932, 0.43513047926, 6546.15977336420},
	{0.00000013694, 4.65145546794, 3347.65866339780},
	{0.00000010824, 0.88978834814, 3316.73398895200},
	{0.00000010722, 2.08650180598, 3364.49086444760},
	{0.00000013330, 1.73633967849, 8955.34180290940},
	{0.00000010768, 3.32549049401, 16173.37116840440},
	{0.00000013163, 6.21762554655, 6688.33840040040},
	{0.00000011418, 0.88286540120, 3237.51965248120},
	{0.00000012130, 2.00651433041, 3443.70520091840},
	{0.00000009287, 6.03988322239, 3304.58456002240},
	{0.00000009160, 3.21863721466, 3376.64029337720},
	{0.00000008926, 4.01851361248, 8273.82086703240},
	{0.00000009314, 3.91047150173, 14584.29827312060},
	{0.00000012215, 1.30873077067, 10014.72373309860},
	{0.00000011535, 3.38250705677, 3024.22055704320},
	{0.00000008906, 0.93197483563, 3341.03250279340},
	{0.00000008906, 2.04371438516, 3340.19235060619},
	{0.00000009379, 0.70747070827, 632.78373931320},
	{0.00000010563, 4.76088157461, 10973.55568635000},
	{0.00000009728, 2.26828152965, 135.06508003540},
	{0.00000008125, 0.08684877067, 5828.02847164760},
	{0.00000007830, 3.37196781134, 162.46663613220},
	{0.00000010475, 5.87139389943, 3657.00429635640},
	{0.00000008273, 1.36018120251, 6604.95878212400},
	{0.00000010423, 2.32096503578, 12168.00269657460},
	{0.00000007365, 0.74165927300, 3760.09707057500},
	{0.00000007447, 4.28662713398, 1861.74585263540},
	{0.00000007300, 0.37690059591, 13362.46696045140},
	{0.00000007546, 4.17104317176, 3134.42687826260},
	{0.00000009008, 4.88604280960, 6784.31762761820},
	{0.00000007320, 4.63241620258, 13362.43245314700},
	{0.00000006861, 3.80050446208, 3169.93955608060},
	{0.00000008388, 3.35902341878, 12566.15169998280},
	{0.00000008149, 2.72974838905, 2921.12778282460},
	{0.00000007236, 5.08483662864, 3546.79797513700},
	{0.00000008579, 5.84551720825, 5099.26550511660},
	{0.00000007567, 3.44029907335, 3209.07046501340},
	{0.00000007609, 5.08371147556, 3304.00706139560},
	{0.00000006467, 0.02249536614, 10184.30391623160},
	{0.00000007516, 2.88089303559, 6923.95345737360},
	{0.00000006807, 0.13521095675, 7234.79425624200},
	{0.00000006446, 5.78384184406, 3341.04230982650},
	{0.00000006446, 3.48151772817, 3340.18254357310},
	{0.00000006514, 2.78645432045, 1118.75579210280},
	{0.00000006453, 5.46308741155, 3511.28529731900},
	{0.00000007475, 4.17838652821, 3377.21779200400},
	{0.00000006646, 1.41708264287, 1375.77379984580},
	{0.00000006439, 2.33641979571, 1478.86657406440},
	{0.00000006409, 6.18677106785, 10575.40668294180},
	{0.00000007656, 5.81604841460, 11081.21921028860},
	{0.00000006250, 2.84309908311, 956.28915597060},
	{0.00000006039, 0.72624360734, 640.87760738220},
	{0.00000006850, 5.82614287106, 3472.15438838620},
	{0.00000006433, 5.96490221567, 1162.47470440780},
	{0.00000005556, 4.54847111649, 949.17560896980},
	{0.00000005974, 2.84025495512, 13760.59871020740},
	{0.00000006037, 5.85268725215, 18984.29263000960},
	{0.00000006266, 0.66358217014, 220.41264243880},
	{0.00000005383, 3.18331360539, 1228.96211332220},
	{0.00000006832, 3.87277522484, 6606.44325483230},
	{0.00000005381, 1.74289410001, 2766.26762836500},
	{0.00000006944, 5.43820006019, 8329.67161059700},
	{0.00000005618, 2.04973538018, 2699.73481931760},
	{0.00000005240, 4.43599515973, 224.34479570190},
	{0.00000005178, 3.38284373136, 3274.12501778540},
	{0.00000005132, 1.40127317485, 3914.95722503460},
	{0.00000005655, 4.63277610967, 9866.41688066520},
	{0.00000005030, 5.87356666210, 3407.09983561420},
	{0.00000006294, 4.27899813330, 2221.85663459700},
	{0.00000006669, 5.34688319263, 38.13303563780},
	{0.00000004800, 1.93538187506, 4407.10790388980},
	{0.00000005289, 0.07864350876, 13916.01910964160},
	{0.00000006432, 4.86365370127, 3296.89351439480},
	{0.00000006214, 5.76944976140, 8439.87793181640},
	{0.00000006362, 4.39850678391, 3384.33133900480},
	{0.00000006495, 0.01977871702, 7107.82304427560},
	{0.00000004782, 0.76221170409, 6261.74020952440},
	{0.00000006263, 5.31414297159, 1964.83862685400},
	{0.00000005038, 4.00806214098, 6247.51311552280},
	{0.00000004557, 1.53702348618, 2807.39834325620},
	{0.00000004586, 4.50717342127, 6709.67404086740},
	{0.00000004868, 5.44478627062, 4392.88080988820},
	{0.00000006229, 4.40062999767, 26087.90314157420},
	{0.00000004383, 3.06060537188, 6665.97238221460},
	{0.00000004389, 2.60342985448, 13149.15061136120},
	{0.00000005865, 3.94745834552, 206.18554843720},
	{0.00000004835, 5.07151708141, 14314.16811304980},
	{0.00000005778, 3.03661567763, 2178.13772229200},
	{0.00000004352, 2.71002586366, 10235.13637553740},
	{0.00000004627, 3.66505491850, 2803.80791460440},
	{0.00000004372, 6.12468678269, 9168.64089834740},
	{0.00000004137, 1.74921053942, 574.34479833480},
	{0.00000004316, 4.84679479800, 3877.41693879520},
	{0.00000004107, 4.64137843892, 10020.85695903120},
	{0.00000003822, 2.21626693517, 3490.17562383440},
	{0.00000004095, 5.97738996422, 10022.81760116760},
	{0.00000003691, 0.07794330600, 6571.01853218020},
	{0.00000004105, 0.62939165404, 263.08392337280},
	{0.00000004701, 4.02327027005, 2111.65031337760},
	{0.00000003544, 1.42006590232, 13517.87010623340},
	{0.00000003496, 5.77175707487, 11216.28429032400},
	{0.00000003591, 1.55483371434, 3873.82651014340},
	{0.00000004567, 5.47345981316, 13524.91634293140},
	{0.00000003954, 5.40431118866, 6652.77566593180},
	{0.00000004049, 1.12676329347, 3981.49003408200},
	{0.00000003269, 2.47578227627, 6040.34724601740},
	{0.00000003781, 1.51484025806, 2906.90068882300},
	{0.00000003260, 2.06519414445, 8425.65083781480},
	{0.00000003293, 1.70537885026, 9779.10867612540},
	{0.00000003767, 2.28715050291, 26724.89941359840},
	{0.00000003390, 5.15091511991, 18454.60166491500},
	{0.00000003325, 0.39339640639, 6843.69148953180},
	{0.00000003962, 1.83390636841, 6048.44111408640},
	{0.00000003154, 0.64171873873, 5202.35827933520},
	{0.00000004019, 0.60853100264, 6696.47732458460},
	{0.00000003926, 1.75260892669, 266.60704172180},
	{0.00000003266, 3.23784244279, 13936.79450513400},
	{0.00000003115, 1.54066694261, 5305.45105355380},
	{0.00000003268, 2.71865882379, 16304.91313009080},
	{0.00000003904, 3.77158991980, 2384.32327072920},
	{0.00000003234, 3.23642327177, 5518.75014899180},
	{0.00000003311, 2.59909525803, 8671.96987044060},
	{0.00000002846, 3.36189891871, 1332.05488754080},
	{0.00000003766, 5.98631611244, 14712.31711645800},
	{0.00000002950, 5.25308946484, 6944.30877677240},
	{0.00000002717, 5.76322783552, 6518.75821726740},
	{0.00000002645, 5.46777283627, 5989.06725217280},
	{0.00000002740, 0.07808443244, 7910.18696672180},
	{0.00000002707, 1.80768212748, 16858.48253293320},
	{0.00000003230, 4.33139765115, 647.01083331480},
	{0.00000002528, 1.65347317169, 13171.00144068760},
	{0.00000002483, 3.87260065092, 3313.21087060300},
	{0.00000002477, 4.75666685518, 5732.04924442980},
	{0.00000003349, 0.87562878675, 10177.25767953360},
	{0.00000002456, 5.39283487914, 3368.01398279660},
	{0.00000002623, 3.15434704817, 16699.53901514999},
	{0.00000003009, 3.37695224152, 2008.55753915900},
	{0.00000002420, 1.77947870484, 3561.02506913860},
	{0.00000002416, 2.30120840231, 13362.51701710200},
	{0.00000002437, 0.09917053128, 5724.93569742900},
	{0.00000002532, 4.86333607443, 6475.03930496240},
	{0.00000003283, 3.57306497337, 17277.40693183380},
	{0.00000002305, 4.09655242470, 17924.91069982040},
	{0.00000002334, 6.00094674252, 9485.03276800400},
	{0.00000002658, 4.90685253882, 3191.04922956520},
	{0.00000002433, 3.97617962527, 3171.03224356680},
	{0.00000002399, 2.63420596512, 15508.61512327440},
	{0.00000002274, 2.96629550939, 6686.74777770700},
	{0.00000002448, 4.59080697271, 6418.14093002680},
	{0.00000002247, 2.22209606814, 3343.36393731080},
	{0.00000002247, 0.76007819691, 3337.86091608880},
	{0.00000002300, 1.05457137869, 3120.19978426100},
	{0.00000002167, 1.68871638105, 2125.87740737920},
	{0.00000002861, 1.98905363521, 3342.09689940810},
	{0.00000002836, 0.98608001394, 3339.12795399150},
	{0.00000002948, 1.15362511196, 6414.61781167780},
	{0.00000002582, 2.53488965696, 16706.58525184800},
	{0.00000002490, 5.13908908718, 12722.55242048520},
	{0.00000002156, 5.25952376812, 1795.25844372100},
	{0.00000002071, 2.95218926429, 10596.18207843420},
	{0.00000002194, 5.25157497709, 3510.19260983280},
	{0.00000002210, 0.98734172820, 533.21408344360},
	{0.00000002884, 6.25268747056, 661.23292678100},
	{0.00000002662, 3.54868444733, 846.08283475120},
	{0.00000002352, 0.68899979183, 6675.70192909220},
	{0.00000002171, 2.82652953748, 7314.00859271280},
	{0.00000002531, 3.98315571751, 15110.46611986620},
	{0.00000001989, 1.24937409137, 14158.74771361560},
	{0.00000002741, 1.36741656084, 9872.27408296480},
	{0.00000002051, 5.80635565702, 1214.73501932060},
	{0.00000001980, 3.18993306283, 16460.33352952499},
	{0.00000002057, 1.55396572210, 1545.35398297880},
	{0.00000002016, 5.80333116821, 6701.58017279840},
	{0.00000001963, 0.97426402220, 8542.97070603500},
	{0.00000002202, 5.06011306718, 20.77539549240},
	{0.00000001921, 2.25819702736, 2675.85638156980},
	{0.00000002221, 4.13094100375, 6660.86953400080},
	{0.00000002152, 1.93255133621, 14.22709400160},
	{0.00000002185, 0.10437662983, 10042.61267559180},
	{0.00000001963, 4.86879808564, 6456.88005769770},
	{0.00000001894, 1.54747808511, 792.77488846740},
	{0.00000001887, 5.72755288130, 7799.98064550240},
	{0.00000002355, 2.20727531576, 6460.81221096080},
	{0.00000001918, 2.84810154019, 2945.98654164060},
	{0.00000001856, 1.97055567397, 3416.87849797540},
	{0.00000001999, 3.78408023322, 3230.40610548040},
	{0.00000001844, 4.95411775516, 16276.46394262300},
	{0.00000002273, 4.24795887217, 10001.06188460700},
	{0.00000001884, 0.43882284635, 13553.89797291080},
	{0.00000002215, 2.48685102846, 9499.25986200560},
	{0.00000001827, 4.41387331264, 2751.54759969160},
	{0.00000001805, 2.35009306355, 6691.86151874940},
	{0.00000001827, 2.13792483074, 12295.95422960920},
	{0.00000002416, 2.70970478916, 13362.38239649640},
	{0.00000001779, 0.67914472161, 323.50541665740},
	{0.00000002281, 3.85790470815, 6643.09181776180},
	{0.00000001748, 4.57086822580, 5032.77809620220},
	{0.00000001981, 5.03237475958, 12310.18132361080},
	{0.00000002102, 3.23137605134, 13745.34623902240},
	{0.00000002109, 2.11504554973, 7203.80227149340},
	{0.00000001951, 1.10549385911, 799.82112516540},
	{0.00000001709, 1.31732873591, 2391.43681773000},
	{0.00000001700, 5.65890453825, 1435.14766175940},
	{0.00000001672, 2.55075771165, 6947.83189512140},
	{0.00000002150, 0.44492585631, 17256.63153634140},
	{0.00000001651, 5.91049368296, 6756.00645196690},
	{0.00000001660, 4.94561267936, 9638.94074787620},
	{0.00000002136, 0.46897595624, 28.44918746780},
	{0.00000001565, 5.31860104643, 742.99006053260},
	{0.00000001663, 3.83391966792, 2277.70737816160},
	{0.00000001531, 0.78845566080, 4005.36847182980},
	{0.00000001548, 1.53436911444, 6578.13207918100},
	{0.00000002066, 2.70339714714, 13119.72110282519},
	{0.00000001866, 5.59846790440, 1039.02661079040},
	{0.00000001502, 3.79341486186, 316.39186965660},
	{0.00000001555, 0.27389127072, 10028.95082710020},
	{0.00000001553, 3.89950445433, 4193.80880845180},
	{0.00000001870, 0.58471003638, 3113.13629391080},
	{0.00000001462, 5.69888481518, 12995.22537783680},
	{0.00000001459, 5.52526727854, 2679.37949991880},
	{0.00000001547, 1.64100920813, 13355.33615979840},
	{0.00000001463, 0.27191881986, 3318.76159737340},
	{0.00000001463, 2.71025544519, 3362.46325602620},
	{0.00000001526, 0.39781988920, 664.75604513000},
	{0.00000001482, 5.77895037207, 2604.73591316800},
	{0.00000001867, 3.32733017397, 13892.14067189380},
	{0.00000001444, 5.09058625219, 10018.24685144760},
	{0.00000001596, 4.21362500614, 3.93215326310},
	{0.00000001862, 1.31686189323, 6670.58818804980},
	{0.00000001428, 6.05145860944, 9468.26787725700},
	{0.00000001440, 3.90175279638, 2641.34127847220},
	{0.00000001647, 1.18630860116, 9070.11887384880},
	{0.00000001515, 4.40841215958, 4922.57177498280},
	{0.00000001468, 2.48598406210, 2693.60159338500},
	{0.00000001434, 5.73698962451, 3283.71405176420},
	{0.00000001552, 0.75522820685, 9886.77220006400},
	{0.00000001430, 5.52560820233, 10025.42770875120},
	{0.00000001604, 3.48106279055, 699.27114822760},
	{0.00000001403, 3.52792942238, 3397.51080163540},
	{0.00000001404, 3.59395455131, 19800.94595622480},
	{0.00000001700, 2.39699907474, 3568.08855948880},
	{0.00000001599, 5.02451840238, 3212.59358336240},
	{0.00000001492, 3.59400579441, 6155.05700665400},
	{0.00000001556, 3.38483926358, 7895.95987272020},
	{0.00000001469, 2.62524582215, 1015.66301788420},
	{0.00000001329, 3.19680445505, 3347.29609057390},
	{0.00000001329, 6.06855511718, 3333.92876282570},
	{0.00000001503, 0.26778913449, 3378.74546233760},
	{0.00000001400, 3.17228930635, 589.06482700820},
	{0.00000001522, 4.24247358440, 3468.63127003720},
	{0.00000001286, 1.87463796011, 3152.68727893721},
	{0.00000001273, 5.67037587711, 5625.36604155940},
	{0.00000001424, 1.87964420034, 17654.78053974960},
	{0.00000001600, 1.40717280482, 1905.46476494040},
	{0.00000001563, 4.74033234784, 6674.17861670160},
	{0.00000001455, 5.62088037785, 8799.98871377800},
	{0.00000001323, 0.16177637471, 1190.92389187560},
	{0.00000001259, 3.26535416990, 3742.28454845700},
	{0.00000001344, 5.40745111036, 4672.66731424060},
	{0.00000001561, 5.17810613909, 3450.81874791920},
	{0.00000001683, 1.97688854890, 8646.06348025360},
	{0.00000001272, 6.25718697284, 6997.61672305620},
	{0.00000001293, 5.24149879148, 10124.93005431800},
	{0.00000001223, 5.74782096857, 11670.28403729680},
	{0.00000001193, 1.03222295834, 6685.10618875760},
	{0.00000001175, 3.46873404944, 4076.48894023160},
	{0.00000001326, 5.55836614171, 5835.14201864840},
	{0.00000001344, 3.54114655197, 59.37386191360},
	{0.00000001120, 6.09785937216, 15.25247118500},
	{0.00000001205, 4.89787234183, 6688.27109009760},
	{0.00000001102, 3.98443103901, 6364.83298374300},
	{0.00000001171, 5.20713779345, 2771.79055267240},
	{0.00000001128, 4.98003069870, 6621.85099148600},
	{0.00000001111, 5.02485508851, 19402.79695281660},
	{0.00000001312, 5.17135511580, 3311.18291816379},
	{0.00000001312, 4.09400445643, 3370.04193523580},
	{0.00000001233, 3.49018510996, 66.48740891440},
	{0.00000001398, 4.37138512888, 9588.12554222260},
	{0.00000001101, 5.78990851346, 3774.32416457660},
	{0.00000001166, 3.86709010828, 4885.96640967860},
	{0.00000001229, 2.53764879683, 3145.64104223920},
	{0.00000001335, 5.02147392519, 4459.36821880260},
	{0.00000001071, 3.00909064842, 7255.56965173440},
	{0.00000001183, 3.15461838319, 17395.21973472580},
	{0.00000001266, 5.61560028687, 6887.41040183680},
	{0.00000001072, 3.28943407731, 6148.01076995600},
	{0.00000001066, 5.94379242263, 1197.97012857360},
	{0.00000001062, 1.63761668363, 131.54196168640},
	{0.00000001116, 6.06452026137, 5618.31980486140},
	{0.00000001222, 4.54203439135, 3184.21170619740},
	{0.00000001186, 3.10594561435, 2284.75361485960},
	{0.00000001086, 4.32097444181, 2324.94940881560},
	{0.00000001116, 5.86192558592, 11610.91017538320},
	{0.00000001218, 3.59655099027, 10156.90236013480},
	{0.00000001087, 3.97307934350, 5642.19824260920},
	{0.00000001053, 4.99965634200, 14054.60730802600},
	{0.00000001193, 2.62619989298, 6677.34351804160},
	{0.00000001102, 5.26420035459, 7321.12213971360},
	{0.00000001153, 5.41879361902, 6740.59871531320},
	{0.00000001069, 2.27857059569, 9389.05354078620},
	{0.00000000990, 5.95411082482, 3181.66890891660},
	{0.00000001146, 4.72384240476, 3497.01314720220},
	{0.00000000991, 1.49574201602, 4140.43355186520},
	{0.00000001269, 5.19931704623, 3188.71514561460},
	{0.00000001220, 5.17708743476, 6034.21402008480},
	{0.00000000977, 1.05449261588, 3361.94806716680},
	{0.00000000977, 1.92768164917, 3319.27678623280},
	{0.00000000978, 1.63172143816, 11766.26326451460},
	{0.00000000968, 6.07406059422, 1272.68102562720},
	{0.00000001351, 1.69299027486, 9945.57120882380},
	{0.00000001167, 0.99889492369, 9602.35263622420},
	{0.00000001030, 4.17831293451, 12721.57209941700},
	{0.00000001347, 3.63309297765, 19513.98359510420},
	{0.00000001240, 2.54570206463, 3302.47939106200},
	{0.00000000957, 0.10887247031, 6645.19698672220},
	{0.00000000943, 0.62298659929, 3344.15279870100},
	{0.00000000943, 5.50078031935, 3337.07205469860},
	{0.00000000929, 3.64733196616, 4001.84535348080},
	{0.00000000978, 3.69409832283, 2538.24850425360},
	{0.00000001121, 0.39414293182, 9065.54812412880},
	{0.00000000960, 4.05565096298, 3909.43430072720},
	{0.00000000908, 3.63883407052, 3326.38533269820},
	{0.00000000956, 0.18458081832, 20809.46762464520},
	{0.00000000910, 5.91297097098, 931.36308685180},
	{0.00000000943, 1.24836664366, 3337.10656200300},
	{0.00000000943, 4.87540027498, 3344.11829139661},
	{0.00000000938, 3.56693392724, 9380.95967271720},
	{0.00000001177, 3.67253107095, 2301.58581590939},
	{0.00000000888, 0.45676454811, 36.60536530420},
	{0.00000000886, 0.02869348414, 8013.27974094040},
	{0.00000001115, 4.62962731246, 16062.18452611680},
	{0.00000000925, 3.39792299223, 1485.98012106520},
	{0.00000000867, 0.71131990196, 7380.49600162720},
	{0.00000000967, 4.34960561312, 11614.43329373220},
	{0.00000000879, 5.66441531374, 3354.83952070140},
	{0.00000000878, 3.61953632544, 169.58018313300},
	{0.00000000856, 2.38006031197, 6705.10329114740},
	{0.00000001029, 1.80600248702, 1.48447270830},
	{0.00000001200, 5.49938290386, 2970.91261075940},
	{0.00000001039, 1.92430461310, 4936.79886898440},
	{0.00000000966, 0.43635654362, 8958.93223156120},
	{0.00000001018, 1.39692983525, 2597.62236616720},
	{0.00000000868, 4.22723847251, 9947.05568153210},
	{0.00000000888, 6.02934983569, 170.67287061920},
	{0.00000000890, 0.04475975272, 6747.71226231400},
	{0.00000000873, 0.50718226570, 2067.93140107260},
	{0.00000000834, 2.38508120043, 6680.80477730600},
	{0.00000000958, 3.07864166176, 2409.24933984800},
	{0.00000000814, 4.96978756082, 16703.04487984680},
	{0.00000001043, 4.06756024984, 3492.50970778500},
	{0.00000000814, 0.71737388513, 16703.07938715119},
	{0.00000000814, 5.25861261683, 1045.15483618760},
	{0.00000000821, 1.45532635718, 3358.42494881780},
	{0.00000000821, 1.52684790788, 3322.79990458180},
	{0.00000001006, 0.32808498663, 9654.61295113700},
	{0.00000000872, 3.47010951505, 3232.94890276120},
	{0.00000000890, 6.08153339531, 8965.97846825920},
	{0.00000000848, 5.36530370202, 11780.49035851620},
	{0.00000001004, 4.86111370518, 16335.83780453660},
	{0.00000000792, 0.96216543926, 7100.70949727480},
	{0.00000000779, 3.28803155951, 3499.55594448300},
	{0.00000000841, 5.80835389420, 3448.27595063840},
	{0.00000000788, 6.15064642009, 14421.83163698840},
	{0.00000000835, 4.64636271875, 3929.67725370800},
	{0.00000000799, 1.71609142624, 2540.79130153440},
	{0.00000001014, 5.93632751077, 8859.36257569160},
	{0.00000001009, 1.23105531513, 6657.34641565180},
	{0.00000001030, 3.76563035339, 3710.31224264020},
	{0.00000000787, 3.96489441416, 3372.58473251660},
	{0.00000000787, 5.30046515807, 3308.64012088300},
	{0.00000000725, 6.20615375090, 3229.42578441220},
	{0.00000000825, 5.84109202593, 3253.30422216000},
	{0.00000000740, 5.37852418407, 1062.90504853820},
	{0.00000000864, 3.56004399666, 6717.25272007700},
	{0.00000000775, 2.63569062709, 11.04570026390},
	{0.00000000729, 5.39810036362, 22743.40937951640},
	{0.00000000819, 3.40537028007, 802.36392244620},
	{0.00000000700, 3.99056780741, 20426.57109242200},
	{0.00000000694, 3.05917580830, 3451.79906898740},
	{0.00000000692, 3.93969787894, 3067.93946934820},
	{0.00000000730, 2.57787085198, 6016.46880826960},
	{0.00000000691, 5.21607448399, 4356.27544458400},
	{0.00000000795, 3.42431058119, 3427.92063123960},
	{0.00000000707, 3.96444184834, 20597.24396304120},
	{0.00000000729, 3.83003983643, 15906.76412668260},
	{0.00000000950, 2.18428036051, 20199.09495963300},
	{0.00000000723, 5.49722551141, 3735.23831175900},
	{0.00000000667, 0.37126610848, 7270.28968040780},
	{0.00000000854, 2.68545229893, 2075.04494807340},
	{0.00000000720, 5.37203321727, 3264.34635542420},
	{0.00000000651, 6.09020535330, 17468.85519794540},
	{0.00000000790, 3.21398808141, 10264.56588407340},
	{0.00000000652, 3.12935966774, 3212.66089366520},
	{0.00000000649, 4.05814434604, 5938.23479286700},
	{0.00000000675, 5.98880437085, 15664.03552270859},
	{0.00000000659, 0.49287296501, 22345.26037610820},
	{0.00000000633, 3.17232018582, 17101.21113690720},
	{0.00000000646, 2.89002668668, 485.97205278960},
	{0.00000000686, 4.18019464026, 1437.17561419860},
	{0.00000000631, 5.34431180258, 3329.56672643590},
	{0.00000000631, 3.92104776965, 3351.65812696370},
	{0.00000000631, 0.15035258857, 3343.15522398060},
	{0.00000000834, 1.27334165090, 6681.64492949320},
	{0.00000000853, 0.52003136040, 24150.08005134500},
	{0.00000000619, 6.13397500805, 3468.56395973440},
	{0.00000000779, 6.20446939192, 22324.90505670940},
	{0.00000000683, 6.06333470888, 3336.68027343670},
	{0.00000000683, 3.20202486335, 3344.54457996290},
	{0.00000000636, 0.86288201968, 151.04766984290},
	{0.00000000600, 2.64922528930, 3338.06962941900},
	{0.00000000621, 0.40499338312, 10448.43547097540},
	{0.00000000648, 6.17069054157, 148.07872442630},
	{0.00000000616, 2.11503698022, 1169.58825140860},
	{0.00000000706, 4.51954003602, 6717.83021870380},
	{0.00000000616, 6.01148018963, 20.35531939880},
	{0.00000000588, 2.22654252843, 6357.71943674220},
	{0.00000000628, 5.60511337877, 3193.80074017620},
	{0.00000000704, 2.61366884585, 3547.31316399640},
	{0.00000000575, 1.10923040341, 3528.53757446240},
	{0.00000000602, 6.12196613719, 6681.65473652630},
	{0.00000000672, 1.12165707971, 6666.99775939800},
	{0.00000000691, 1.16386423121, 6679.74038069130},
	{0.00000000581, 2.98813744301, 5490.30096152400},
	{0.00000000644, 1.94493731078, 4289.78803566960},
	{0.00000000607, 4.43563939259, 18451.07854656599},
	{0.00000000583, 4.47298961595, 8226.57883637840},
	{0.00000000726, 2.91832718034, 6019.99192661860},
	{0.00000000587, 5.01648676427, 2171.02417529120},
	{0.00000000610, 0.51823731379, 9911.63095888000},
	{0.00000000648, 2.64885452513, 4133.38731516720},
	{0.00000000602, 4.20897598542, 2854.64037391020},
	{0.00000000600, 4.73583940116, 6724.94376570460},
	{0.00000000644, 1.17944696282, 52175.80628314840},
	{0.00000000606, 2.45518551356, 401.67212175720},
	{0.00000000613, 3.89660700480, 6549.68289171320},
	{0.00000000536, 5.25877052470, 3613.28538405140},
	{0.00000000634, 4.14005244900, 6510.55198278040},
	{0.00000000620, 2.73565451839, 2149.68853482420},
	{0.00000000554, 2.33553669625, 394.62588505920},
	{0.00000000602, 3.81964202131, 6680.79497027290},
	{0.00000000676, 0.15809413709, 19004.64794940840},
	{0.00000000702, 6.04600603759, 43.71891230500},
	{0.00000000522, 3.84057547649, 3341.79306935190},
	{0.00000000522, 5.42478409574, 3339.43178404770},
	{0.00000000533, 5.24914312775, 4039.88357492740},
	{0.00000000553, 3.69265541501, 3487.42411322340},
	{0.00000000513, 0.64644878070, 299.12639426920},
	{0.00000000715, 1.53240537508, 4503.08713110760},
	{0.00000000509, 2.23251368203, 8116.37251515900},
	{0.00000000511, 2.84475025859, 16489.76303806100},
	{0.00000000505, 4.84005215499, 1063.31408345230},
	{0.00000000543, 4.52630986182, 1596.11913198180},
	{0.00000000640, 5.62224402692, 1641.33321019660},
	{0.00000000637, 0.43174002743, 3133.91168940320},
	{0.00000000530, 1.06693271495, 1699.27921650320},
	{0.00000000500, 5.72569791561, 11250.79939342160},
	{0.00000000639, 2.24611646652, 3116.26763099790},
	{0.00000000509, 5.97801633911, 6812.76681508600},
	{0.00000000489, 3.06702523150, 13575.74880223720},
	{0.00000000535, 4.96839537782, 9072.66167112960},
	{0.00000000548, 2.32220742395, 1265.56747862640},
	{0.00000000536, 0.22943192463, 3198.43379966360},
	{0.00000000478, 5.77351763837, 114.39910691340},
	{0.00000000619, 4.96805088979, 13207.02930736500},
	{0.00000000476, 0.22242794163, 6850.80503653260},
	{0.00000000475, 5.62964593507, 12323.42309600880},
	{0.00000000527, 6.00961327639, 3289.33208883739},
	{0.00000000527, 3.25574629584, 3391.89276456221},
	{0.00000000491, 1.41447645810, 3288.35211178700},
	{0.00000000491, 1.56769780695, 3392.87274161260},
	{0.00000000532, 1.66614420688, 1055.44977692610},
	{0.00000000633, 2.67463316712, 5085.03841111500},
	{0.00000000577, 0.03289264393, 735.87651353180},
	{0.00000000467, 3.47228897303, 5749.86176654780},
	{0.00000000473, 3.22546086486, 4296.90158267040},
	{0.00000000489, 2.81861982191, 23.87843774780},
	{0.00000000483, 3.92195396855, 3334.54651107000},
	{0.00000000483, 5.34340560368, 3346.67834232960},
	{0.00000000460, 1.30162811155, 2281.24775016280},
	{0.00000000460, 5.55404178724, 2281.21324285840},
	{0.00000000604, 0.33192898022, 2373.64154926420},
	{0.00000000500, 5.13403373442, 3.59042865180},
	{0.00000000456, 4.28478904313, 8962.47260356240},
	{0.00000000456, 2.25401741164, 8962.43809625800},
	{0.00000000468, 2.07609656896, 227.47613278900},
	{0.00000000456, 5.37224883784, 11140.59307220220},
	{0.00000000506, 2.75253411801, 3482.79105373600},
	{0.00000000453, 3.59225016346, 2957.73314812880},
	{0.00000000633, 0.33861758809, 2963.23881878400},
	{0.00000000502, 4.62394688433, 5562.46906129680},
	{0.00000000604, 4.34031313242, 3370.10424500320},
	{0.00000000604, 4.92504643981, 3311.12060839640},
	{0.00000000501, 3.19333781608, 2973.38809773740},
	{0.00000000448, 4.97947122194, 13361.46938573100},
	{0.00000000500, 2.53823457541, 4819.47900076420},
	{0.00000000517, 0.40478673929, 3535.58381116040},
	{0.00000000440, 4.69261655966, 3564.95722240170},
	{0.00000000481, 6.20073949182, 2494.52959194860},
	{0.00000000468, 3.63933137782, 1854.63230563460},
	{0.00000000477, 5.99645045824, 4379.63903749020},
	{0.00000000468, 5.32421286728, 4186.69526145100},
	{0.00000000430, 1.74068392340, 4716.38622654560},
	{0.00000000486, 3.22416128411, 382.87927857100},
	{0.00000000486, 6.15985349823, 3017.10701004240},
	{0.00000000473, 1.58270299229, 2295.45759051220},
	{0.00000000536, 3.39382424699, 860.30992875280},
	{0.00000000561, 0.07727661747, 4271.97551355160},
	{0.00000000423, 3.86495066196, 7366.26890762560},
	{0.00000000427, 3.93347122226, 1574.84580128220},
	{0.00000000456, 3.39763687697, 10006.58480891440},
	{0.00000000539, 2.16593861972, 3185.25933756840},
	{0.00000000420, 3.46957754355, 5753.38488489680},
	{0.00000000558, 5.31907263521, 4555.34744602040},
	{0.00000000546, 4.81957800358, 6637.50594109460},
	{0.00000000412, 3.44279945540, 2480.30249794700},
	{0.00000000433, 5.19722898458, 3305.04969223120},
	{0.00000000433, 4.06813058765, 3376.17516116840},
	{0.00000000423, 0.94668022805, 10037.08975128440},
	{0.00000000481, 1.03096497224, 6685.15700666270},
	{0.00000000422, 5.46293451808, 9374.82644678460},
	{0.00000000402, 1.79269566106, 6151.55114195720},
	{0.00000000402, 6.04510933675, 6151.51663465280},
	{0.00000000423, 3.58342380203, 5483.25472482600},
	{0.00000000403, 5.64429159047, 3723.49170527080},
	{0.00000000430, 1.85452102379, 2655.56837247380},
	{0.00000000398, 4.95155912622, 15806.14683944200},
	{0.00000000400, 2.79186394236, 18849.22754997420},
	{0.00000000481, 5.12886978063, 9797.49248439750},
	{0.00000000477, 3.72133708668, 6614.73744448520},
	{0.00000000398, 5.88751420420, 23539.70738633280},
	{0.00000000487, 2.28517115642, 1655.56030419820},
	{0.00000000555, 2.64204069171, 3717.98603461560},
	{0.00000000425, 5.57148739497, 7218.02936549500},
	{0.00000000402, 4.31277297914, 1685.05212250160},
	{0.00000000391, 3.40113572996, 2142.64229812620},
	{0.00000000486, 4.84700116898, 10050.28646756720},
	{0.00000000412, 0.16244075037, 2547.83753823240},
	{0.00000000398, 4.39213965028, 21265.52312652020},
	{0.00000000404, 5.22642617943, 6644.61948809540},
	{0.00000000414, 2.26881914667, 7747.72033058960},
	{0.00000000498, 5.67868360175, 12509.25332504720},
	{0.00000000378, 2.64779087849, 9801.42463766060},
	{0.00000000427, 5.92154870681, 905.45669666480},
	{0.00000000437, 1.90267249585, 5881.40372823420},
	{0.00000000368, 1.75512352528, 912.57024366560},
	{0.00000000520, 0.92503823923, 3495.96551583120},
	{0.00000000441, 1.82874447797, 2277.29834324750},
	{0.00000000367, 5.98732751616, 8564.30634650200},
	{0.00000000388, 1.53417071545, 18606.49894600020},
	{0.00000000399, 0.90410764395, 515.46387109300},
	{0.00000000436, 5.31667755006, 1903.43681250120},
	{0.00000000398, 5.06921695985, 3826.58447948940},
	{0.00000000363, 1.41903182152, 5888.44996493220},
	{0.00000000441, 5.31541881274, 4142.97634914600},
	{0.00000000429, 5.04278490313, 2285.16264977370},
	{0.00000000502, 2.89985394281, 1765.76662541760},
	{0.00000000415, 4.78022286670, 0.98032106820},
	{0.00000000374, 2.30167430662, 25287.72379939980},
	{0.00000000359, 5.01487522235, 5085.10572141780},
	{0.00000000477, 4.55805347389, 1329.51209026000},
	{0.00000000470, 5.45120104784, 21795.21409161479},
	{0.00000000372, 1.43435867925, 6314.00052443720},
	{0.00000000351, 5.70642746558, 6851.89772401880},
	{0.00000000346, 3.46248777629, 20735.83216142559},
	{0.00000000452, 2.07880491518, 6106.88005506480},
	{0.00000000344, 0.65068647382, 16894.51039961060},
	{0.00000000432, 6.00026910363, 10721.10842832700},
	{0.00000000364, 2.28651674734, 6682.70932610790},
	{0.00000000363, 3.43072832179, 27682.14074415640},
	{0.00000000452, 2.64364626735, 4307.58330413540},
	{0.00000000457, 1.95175594362, 21947.11137270000},
	{0.00000000346, 5.34426955778, 18052.92954315780},
	{0.00000000351, 4.37551100665, 5452.26274007740},
	{0.00000000468, 5.41577295140, 5244.04923920100},
	{0.00000000386, 1.07126796902, 5511.63660199100},
	{0.00000000344, 3.95436427366, 5636.07001721200},
	{0.00000000434, 1.89640980600, 7214.43893684320},
	{0.00000000333, 3.01713296302, 1883.08149310240},
	{0.00000000395, 5.73856202838, 9993.38809263160},
	{0.00000000351, 1.69786249501, 13212.88650966460},
	{0.00000000331, 0.85002011574, 25685.87280280800},
	{0.00000000327, 5.61960069444, 3353.85419909779},
	{0.00000000327, 3.64575887779, 3327.37065430180},
	{0.00000000422, 3.91288097624, 23141.55838292460},
	{0.00000000328, 1.43840362685, 2435.15573003500},
	{0.00000000447, 0.03231232062, 13363.43002786740},
	{0.00000000389, 2.62527245368, 30065.51184029820},
	{0.00000000360, 5.62003938434, 7696.88787128380},
	{0.00000000395, 3.32438313830, 3337.15661865360},
	{0.00000000338, 6.08218637594, 14556.89671702380},
	{0.00000000344, 6.13564952381, 146.81168652360},
	{0.00000000337, 3.39517266137, 543.91805909620},
	{0.00000000408, 1.39299721966, 11883.58313273480},
	{0.00000000366, 5.24290558594, 8982.81066930900},
	{0.00000000384, 5.87249757638, 7733.49323658800},
	{0.00000000352, 5.77288434437, 14128.24277124560},
	{0.00000000335, 4.32457058810, 3060.82592234740},
	{0.00000000388, 4.44896509079, 568.82187402740},
	{0.00000000316, 2.10306900154, 3241.04277083020},
	{0.00000000316, 0.87910526351, 3440.18208256940},
	{0.00000000355, 1.45980558865, 7322.10246078180},
	{0.00000000354, 2.21314787069, 4606.17990532620},
	{0.00000000311, 2.88232671968, 36.02786667740},
	{0.00000000310, 0.93049157656, 6453.74872061060},
	{0.00000000309, 5.01156668552, 1744.49329471800},
	{0.00000000300, 3.78833306333, 1987.22189869200},
	{0.00000000299, 5.63008167210, 10284.92120347220},
	{0.00000000380, 3.85628097313, 1461.05405194640},
	{0.00000000294, 3.49253072198, 20040.15144184979},
	{0.00000000313, 2.87459690276, 6286.59896834040},
	{0.00000000296, 1.12829662810, 15265.88651930040},
	{0.00000000307, 1.51056904066, 9755.23023837760},
	{0.00000000306, 6.04593408110, 8756.26980147300},
	{0.00000000393, 3.05426132167, 19645.52555679060},
	{0.00000000292, 0.99823300732, 20618.01935853360},
	{0.00000000328, 3.60990432876, 3397.41568886960},
	{0.00000000328, 5.65545524347, 3283.80916453000},
	{0.00000000349, 2.66323218421, 5408.54382777240},
	{0.00000000360, 6.18194085240, 685.04405422600},
	{0.00000000289, 3.03452497225, 24341.52831745660},
	{0.00000000291, 2.47822451317, 11986.67590695340},
	{0.00000000314, 4.21854332735, 9983.70424446160},
	{0.00000000339, 1.83011385698, 3856.07629779280},
	{0.00000000339, 1.15206040807, 2825.14855560680},
	{0.00000000383, 4.85732660755, 2921.68802779920},
	{0.00000000311, 5.32153691075, 2060.81785407180},
	{0.00000000302, 0.20821199425, 12825.64519470380},
	{0.00000000286, 2.52935183562, 279.78650435240},
	{0.00000000327, 0.66722093799, 533.62311835770},
	{0.00000000330, 1.47315787255, 1073.60902419080},
	{0.00000000382, 2.75070755631, 3267.31530084080},
	{0.00000000382, 0.23146670874, 3413.90955255880},
	{0.00000000304, 4.94290577295, 3620.39893105220},
	{0.00000000279, 6.01035218252, 7167.19690618920},
	{0.00000000331, 5.02435559950, 16063.16484718500},
	{0.00000000329, 3.13549589139, 10706.88133432540},
	{0.00000000283, 2.78335440325, 12839.87228870540},
	{0.00000000282, 2.30154816582, 596.17837400900},
	{0.00000000283, 6.10276906215, 9859.37064396720},
	{0.00000000304, 3.83786604384, 5621.86017686260},
	{0.00000000280, 1.99086077526, 16511.61386738740},
	{0.00000000264, 4.18346044185, 2938.94030494260},
	{0.00000000325, 5.09647854302, 2267.00340250900},
	{0.00000000262, 4.93101522736, 3936.79080070880},
	{0.00000000320, 3.75392999296, 525.75881183150},
	{0.00000000269, 4.46038699829, 2744.43405269080},
	{0.00000000258, 4.05781923499, 5195.24473233440},
	{0.00000000333, 2.04472732064, 95.97922721780},
	{0.00000000304, 1.80709441235, 5621.82566955820},
	{0.00000000271, 5.41787864949, 3336.04167697980},
	{0.00000000271, 3.84748092274, 3345.18317641980},
	{0.00000000251, 3.72595297988, 3337.50938444440},
	{0.00000000251, 5.53940659235, 3343.71546895520},
	{0.00000000251, 4.94262467913, 9758.75335672660},
	{0.00000000255, 1.40204343749, 8166.15734309380},
	{0.00000000305, 2.93351381201, 12012.58229714040},
	{0.00000000267, 2.53115640127, 6830.78805053420},
	{0.00000000286, 0.19313178141, 1898.35121793960},
	{0.00000000290, 2.87280676776, 20047.19767854780},
	{0.00000000268, 3.04782864984, 16702.99482319620},
	{0.00000000250, 2.52509673305, 9698.33186344200},
	{0.00000000250, 1.90792798203, 206.70073729660},
	{0.00000000325, 5.19161338170, 5223.69391980220},
	{0.00000000246, 5.47040036393, 15650.79375031060},
	{0.00000000247, 1.02711909982, 10016.31435579200},
	{0.00000000256, 3.14761311872, 1727.66109366820},
	{0.00000000276, 0.25330294459, 6670.17915313570},
	{0.00000000321, 0.33443990553, 11904.91877320180},
	{0.00000000239, 5.48924135437, 4694.00295470760},
	{0.00000000323, 0.19078991314, 17085.95866572220},
	{0.00000000250, 4.16248987175, 1250.83019630080},
	{0.00000000258, 4.26017972975, 9488.62319665580},
	{0.00000000248, 5.11028885968, 5430.39465709880},
	{0.00000000269, 3.40949811009, 3866.78027344540},
	{0.00000000248, 3.35507631239, 21548.96236929180},
	{0.00000000265, 4.47706550812, 3053.65006557920},
	{0.00000000240, 3.30477326315, 10027.36020440680},
	{0.00000000252, 0.39861936276, 1442.26120876020},
	{0.00000000321, 4.39948566918, 3759.53682560040},
	{0.00000000319, 5.16188908240, 9815.65173166220},
	{0.00000000251, 5.09258201655, 4996.17273089800},
	{0.00000000251, 1.69378698516, 1279.79457262800},
	{0.00000000251, 0.30797289315, 2790.56614220640},
	{0.00000000326, 5.77584210418, 3707.83675566220},
	{0.00000000234, 3.19518041867, 5.52292430740},
	{0.00000000311, 1.28359118800, 3391.44488600560},
	{0.00000000311, 1.69858307705, 3289.77996739400},
	{0.00000000230, 3.19673604492, 10654.62101941260},
	{0.00000000292, 0.94159319004, 3050.12694723020},
	{0.00000000235, 3.67396491403, 5945.34833986780},
	{0.00000000301, 3.92363660385, 9495.66943335380},
	{0.00000000238, 3.24637215696, 6566.82574648620},
	{0.00000000226, 4.13525718252, 1868.85939963620},
	{0.00000000226, 1.47633059250, 26482.17080962440},
	{0.00000000225, 3.08572061461, 8749.15625447220},
	{0.00000000312, 5.79379290810, 4403.51747523800},
	{0.00000000248, 0.28758278932, 4025.65648092580},
	{0.00000000222, 2.77571943902, 1835.32461760680},
	{0.00000000289, 2.22892326730, 6901.63749583840},
	{0.00000000244, 3.78617592414, 5349.16996585880},
	{0.00000000268, 2.63933226300, 16703.12944380180},
	{0.00000000221, 0.14023240804, 5820.91492464680},
	{0.00000000220, 4.31591174490, 6511.64467026660},
	{0.00000000221, 2.65317035374, 28628.33622609960},
	{0.00000000224, 1.51015445842, 3542.86582187390},
	{0.00000000224, 1.47201980663, 3138.35903152570},
	{0.00000000234, 1.63110110036, 17499.36014031540},
	{0.00000000233, 1.29817926717, 2814.44457995420},
	{0.00000000229, 3.43841964101, 7586.68155006440},
	{0.00000000272, 5.08807244203, 2428.04218303420},
	{0.00000000218, 1.17569842797, 6283.09310364360},
	{0.00000000218, 5.42811210366, 6283.05859633920},
	{0.00000000220, 4.76795289662, 3987.62326001460},
	{0.00000000250, 0.35926935365, 4569.57454002200},
	{0.00000000276, 4.17681654313, 19146.75926614180},
	{0.00000000290, 3.77728541747, 24889.57479599160},
	{0.00000000215, 0.44293995073, 13383.22510229160},
	{0.00000000226, 4.11036906370, 9278.84721956680},
	{0.00000000224, 3.68654579964, 77.75054398390},
	{0.00000000216, 4.73186620361, 1484.93248969420},
	{0.00000000266, 5.48398122109, 16865.52876963120},
	{0.00000000220, 6.16562235845, 10081.21114201300},
	{0.00000000211, 0.32806954610, 12199.97500239140},
	{0.00000000212, 1.71640241592, 2392.41713879820},
	{0.00000000213, 1.85863025152, 8852.24902869080},
	{0.00000000237, 4.78828856124, 3627.57478782039},
	{0.00000000220, 2.11900337312, 6530.17718355670},
	{0.00000000271, 5.46357121828, 1879.55837475340},
	{0.00000000249, 4.15415677649, 3084.64205032780},
	{0.00000000263, 0.61040728538, 4531.53631857540},
	{0.00000000252, 4.61076732703, 3382.16321768460},
	{0.00000000252, 4.65459224520, 3299.06163571500},
	{0.00000000239, 3.20969165945, 3344.06823474600},
	{0.00000000245, 0.72828250886, 5415.65737477320},
	{0.00000000262, 2.04018754229, 3631.09790616940},
	{0.00000000206, 3.37175065629, 7082.89697515680},
	{0.00000000210, 1.09820249005, 6678.47334278860},
	{0.00000000255, 3.12461702046, 1994.26813539000},
	{0.00000000274, 0.08218879095, 12306.59089495900},
	{0.00000000223, 4.70596581354, 3336.25039031000},
	{0.00000000223, 4.55939375869, 3344.97446308960},
	{0.00000000255, 0.57687651969, 2942.48067694380},
	{0.00000000224, 3.09499220473, 6533.14612897330},
	{0.00000000204, 2.43235400749, 15636.56665630900},
	{0.00000000277, 5.82784264481, 12465.53441274220},
	{0.00000000201, 0.64407263170, 9360.60435331840},
	{0.00000000200, 4.36647250597, 5617.91076994730},
	{0.00000000199, 4.83225730856, 3029.77162783140},
	{0.00000000243, 5.80727046187, 9329.67967887260},
	{0.00000000210, 4.11232561432, 28230.18722269139},
	{0.00000000209, 0.61702908361, 4845.90023579280},
	{0.00000000197, 2.72488864890, 3436.59165391760},
	{0.00000000197, 0.25728561615, 3244.63319948200},
	{0.00000000244, 2.15306679937, 4981.94563689640},
	{0.00000000200, 1.77158830078, 8742.04270747140},
	{0.00000000231, 4.21063730317, 6653.82329730280},
	{0.00000000213, 1.25314316353, 5625.77507647350},
	{0.00000000198, 5.49218659041, 3094.36070437679},
	{0.00000000223, 4.58369899094, 13341.67431130680},
	{0.00000000200, 1.29969484450, 194.97138446060},
	{0.00000000195, 2.65042618750, 117.31986822020},
	{0.00000000191, 0.79284041095, 3752.98352357420},
	{0.00000000191, 2.18933385410, 2928.24132982540},
	{0.00000000236, 4.40014218317, 151.89728108520},
	{0.00000000212, 0.12583581747, 4538.58255527340},
	{0.00000000192, 3.57878803630, 3315.75366788380},
	{0.00000000192, 5.68657153593, 3365.47118551580},
	{0.00000000226, 5.11122130646, 3596.58280307180},
	{0.00000000231, 4.57994360527, 2011.10033643980},
	{0.00000000220, 5.61438064276, 367.22432896240},
	{0.00000000189, 2.94640552324, 18208.34994259200},
	{0.00000000255, 4.82929019537, 2942.44616963940},
	{0.00000000191, 2.45356219299, 10544.41469819320},
	{0.00000000206, 5.96915912893, 1155.36115740700},
	{0.00000000205, 2.24870894157, 1059.36467653700},
	{0.00000000251, 2.00699090318, 11236.57229942000},
	{0.00000000242, 3.32140683721, 23958.63178523340},
	{0.00000000200, 2.06264335128, 2735.76268599500},
	{0.00000000188, 1.76018994600, 3363.38092330920},
	{0.00000000188, 1.22198431905, 3317.84393009040},
	{0.00000000204, 5.63575473469, 5106.37905211740},
	{0.00000000231, 4.09195306459, 9093.99731159660},
	{0.00000000184, 0.25169651319, 11353.89216764020},
	{0.00000000182, 2.90199742784, 5960.08562219340},
	{0.00000000247, 3.75287740090, 31022.75317085620},
	{0.00000000199, 2.62229622602, 3890.65871119319},
	{0.00000000193, 4.00281238141, 7417.10136693140},
	{0.00000000179, 2.29351099603, 6382.09845913040},
	{0.00000000181, 3.44076025740, 1755.06264976500},
	{0.00000000222, 1.29490505737, 3070.41495632620},
	{0.00000000178, 1.75815826780, 15106.87569121440},
	{0.00000000177, 4.43296153727, 3651.45322556820},
	{0.00000000213, 0.75884375260, 11925.27409260060},
	{0.00000000232, 5.03524840558, 3163.91869656600},
	{0.00000000232, 4.23011116665, 3517.30615683360},
	{0.00000000180, 0.58769217206, 3332.51855863080},
	{0.00000000180, 2.39448209299, 3348.70629476880},
	{0.00000000179, 3.77306261408, 3586.86414902280},
	{0.00000000205, 4.27948057306, 1059.39918384140},
	{0.00000000187, 2.61826471479, 2619.47319549360},
	{0.00000000176, 5.47433094670, 13465.54248101780},
	{0.00000000174, 6.12894045783, 10096.61887866670},
	{0.00000000188, 5.50057971256, 2574.81936225340},
	{0.00000000175, 0.98299291721, 12299.54465826100},
	{0.00000000182, 1.47732423248, 4288.80771460140},
	{0.00000000177, 4.71143769968, 12928.73796892240},
	{0.00000000177, 0.60448814179, 2572.76360735120},
	{0.00000000210, 2.56022036127, 6683.97636401060},
	{0.00000000175, 5.70361271383, 6708.62640949640},
	{0.00000000174, 0.12435272208, 3155.76251872960},
	{0.00000000169, 5.11813247600, 6684.73071809641},
	{0.00000000192, 5.18570054646, 11567.19126307820},
	{0.00000000169, 0.86571880031, 6684.76522540080},
	{0.00000000207, 4.46904668742, 10001.48196070061},
	{0.00000000206, 1.69988902403, 187.92514776260},
	{0.00000000231, 4.69193654586, 5351.71276313960},
	{0.00000000189, 1.06067161596, 2783.51990550840},
	{0.00000000181, 0.45144430179, 10191.41746323240},
	{0.00000000219, 5.87655805703, 3070.48226662900},
	{0.00000000177, 4.57332885856, 2978.49128996900},
	{0.00000000179, 3.71447292171, 17232.75309859360},
	{0.00000000166, 5.04602150010, 15121.10278521600},
	{0.00000000168, 5.94252269393, 1111.64224510200},
	{0.00000000172, 0.69353998666, 1505.28780909299},
	{0.00000000163, 0.28838717250, 155.35308913140},
	{0.00000000184, 1.39958801864, 12942.96506292400},
	{0.00000000162, 1.97243550807, 16695.94858649819},
	{0.00000000199, 5.68556412360, 26084.02180621620},
	{0.00000000166, 5.66442389971, 20995.39296644940},
	{0.00000000167, 1.96358825585, 4775.76008845920},
	{0.00000000181, 2.15204829552, 1368.66025284500},
	{0.00000000200, 1.68720277112, 3610.80989707340},
	{0.00000000188, 2.44893392701, 2385.37090210020},
	{0.00000000180, 3.06688556020, 3649.89074935560},
	{0.00000000168, 2.00209726633, 6165.76098230660},
	{0.00000000201, 5.56223289068, 3738.74417645580},
	{0.00000000168, 5.97126496813, 27.40155609680},
	{0.00000000163, 0.09102774145, 21393.54196985760},
	{0.00000000165, 5.18462129798, 24491.42579258340},
	{0.00000000163, 1.72014467993, 3345.81161786560},
	{0.00000000163, 1.26202958512, 3335.41323553400},
	{0.00000000161, 3.54247427777, 272.67295735160},
	{0.00000000199, 2.40246756842, 8006.16619393960},
	{0.00000000177, 1.96147391128, 8322.55806359620},
	{0.00000000175, 1.20405833746, 2757.61351532140},
	{0.00000000214, 3.94809439016, 1385.89527633620},
	{0.00000000171, 1.64736764034, 10011.20061474960},
	{0.00000000157, 6.04186245834, 31172.65064598300},
	{0.00000000198, 4.06378380988, 4106.40549114620},
	{0.00000000163, 2.04239538779, 13286.18363552360},
	{0.00000000155, 5.55637185637, 8771.00708379860},
	{0.00000000151, 6.02667746519, 15010.89646399660},
	{0.00000000159, 0.33316888782, 4061.75165790600},
	{0.00000000169, 6.19340718678, 7064.10413197060},
	{0.00000000202, 4.07695393078, 4253.18267036540},
	{0.00000000166, 0.77365213441, 6719.35788903740},
	{0.00000000149, 1.16534241475, 14577.18472611980},
	{0.00000000151, 5.90185701300, 10228.02282853660},
	{0.00000000151, 2.82941538658, 3525.46233467000},
	{0.00000000149, 1.89551632354, 3664.11784335720},
	{0.00000000196, 3.39234316905, 3610.74258677060},
	{0.00000000167, 0.38551119237, 1346.34429130980},
	{0.00000000166, 2.03194803269, 5466.48983407900},
	{0.00000000167, 2.89181496866, 10288.44432182120},
	{0.00000000172, 5.39487275378, 19617.07636932279},
	{0.00000000147, 2.18400664980, 1898.33396428740},
	{0.00000000166, 2.73543927114, 6908.70098618860},
	{0.00000000201, 1.30981921500, 3738.77868376020},
	{0.00000000146, 0.62125880196, 13369.56325380000},
	{0.00000000170, 5.74209007670, 6677.68448139840},
	{0.00000000147, 1.87608878363, 9918.74450588080},
	{0.00000000159, 2.95197147470, 3346.46962899940},
	{0.00000000159, 0.03020279035, 3334.75522440020},
	{0.00000000143, 1.10166083747, 13227.38462676380},
	{0.00000000164, 2.07109751188, 2125.81009707640},
	{0.00000000189, 6.14146200362, 10042.19259949820},
	{0.00000000153, 4.69199840126, 3702.73356343060},
	{0.00000000168, 2.68821315216, 10032.47394544920},
	{0.00000000151, 2.48880937989, 1859.20305535460},
	{0.00000000163, 1.42062692665, 2964.84669512960},
	{0.00000000179, 0.37975631677, 2714.94223438740},
	{0.00000000179, 2.60241794828, 3966.28261901220},
	{0.00000000140, 4.86451546343, 18461.71521191579},
	{0.00000000183, 0.37676347949, 6791.43117461900},
	{0.00000000150, 5.20287301062, 2922.10810389280},
	{0.00000000175, 5.42596524283, 5220.17080145320},
	{0.00000000140, 5.79899062095, 1538.24043597800},
	{0.00000000146, 1.91278049103, 2714.98729050260},
	{0.00000000165, 1.13934061346, 7345.98089852960},
	{0.00000000191, 0.78696608877, 3479.20062508420},
	{0.00000000191, 2.19520817629, 3202.02422831540},
	{0.00000000143, 0.93308559393, 9153.90361602180},
	{0.00000000139, 0.98177816584, 4878.85286267780},
	{0.00000000160, 5.46927582744, 3287.30448041600},
	{0.00000000160, 3.79608374479, 3393.92037298360},
	{0.00000000193, 0.22143365956, 3031.33410404400},
	{0.00000000150, 1.84793747625, 3897.70494789120},
	{0.00000000182, 5.61872247851, 27832.03821928320},
	{0.00000000144, 0.96134974857, 3945.46216740460},
	{0.00000000170, 1.48967640102, 6677.71898870279},
	{0.00000000141, 3.83742737291, 6279.55273164240},
	{0.00000000155, 5.68213195490, 25135.82651831460},
	{0.00000000136, 2.44961684409, 12729.66596748600},
	{0.00000000188, 0.01265622712, 4686.95671800959},
	{0.00000000167, 5.28314283541, 8336.78515759780},
	{0.00000000151, 3.22358745524, 2281.29780681340},
	{0.00000000151, 6.20627936335, 8962.52266021300},
	{0.00000000159, 4.80713616496, 8958.52319664710},
	{0.00000000168, 0.17015651337, 4295.85395129940},
	{0.00000000133, 4.82759769594, 21150.81336588360},
	{0.00000000159, 1.73650436212, 8966.38750317330},
	{0.00000000151, 0.33159044302, 8962.38803960740},
	{0.00000000151, 3.63208384209, 2281.16318620780},
	{0.00000000137, 3.04837973833, 6703.07568272600},
	{0.00000000133, 6.26949704953, 12171.52581492360},
	{0.00000000136, 5.59365849152, 8695.84830818840},
	{0.00000000160, 2.63695807146, 5401.43028077160},
	{0.00000000140, 0.39711511870, 34554.81386366760},
	{0.00000000134, 4.28535760311, 2472.67876262220},
	{0.00000000135, 5.15711417667, 14481.20549890200},
	{0.00000000130, 4.35532122087, 529.67371144240},
	{0.00000000133, 6.07532283158, 6624.32647846400},
	{0.00000000148, 3.97691997672, 7050.92466934000},
	{0.00000000130, 4.65934301751, 7593.79509706520},
	{0.00000000140, 1.69371671061, 11456.98494185880},
	{0.00000000130, 0.10290754518, 529.70821874680},
	{0.00000000143, 4.86125646505, 10014.79104340140},
	{0.00000000154, 1.51195474378, 5607.61582920880},
	{0.00000000143, 5.92681168953, 3041.48603243060},
	{0.00000000158, 4.74267595754, 6092.16002639140},
	{0.00000000134, 6.18223447403, 2954.19277612760},
	{0.00000000145, 4.90616424565, 8373.39052290200},
	{0.00000000173, 6.07118204441, 1086.78348628600},
	{0.00000000137, 5.86596713113, 6137.30679430340},
	{0.00000000167, 5.43777729955, 107.66352393860},
	{0.00000000137, 5.46263047000, 14580.77515477160},
	{0.00000000130, 2.37764705674, 4108.46124604840},
	{0.00000000144, 0.85144131454, 1802.37199072180},
	{0.00000000132, 2.61918637671, 4782.87363546000},
	{0.00000000123, 3.36083480955, 29424.63423291600},
	{0.00000000126, 1.85449654763, 18447.48811791419},
	{0.00000000127, 1.92093733385, 4447.75123238460},
	{0.00000000141, 1.56398014110, 3716.37815827000},
	{0.00000000124, 3.53492874819, 6687.90851727370},
	{0.00000000121, 0.01062042066, 3090.70796595760},
	{0.00000000121, 2.97155384439, 3590.51688744200},
	{0.00000000122, 1.08221642068, 2257.35205876280},
	{0.00000000123, 4.43212874956, 6710.65436193560},
	{0.00000000122, 3.26594164721, 1236.07566032300},
	{0.00000000166, 5.13636005426, 6553.20601006220},
	{0.00000000143, 2.33674585334, 20206.14119633100},
	{0.00000000157, 0.56952639012, 8584.66166590080},
	{0.00000000128, 0.66575049629, 3600.17323172360},
	{0.00000000128, 2.31642376876, 3081.05162167600},
	{0.00000000119, 0.92051706257, 23937.85638974100},
	{0.00000000127, 4.06247504712, 3759.11674950680},
	{0.00000000143, 1.09974278396, 2228.97018159780},
	{0.00000000152, 5.09265509081, 3340.64693400420},
	{0.00000000152, 1.03111182783, 3340.57791939540},
	{0.00000000126, 0.88452034949, 12406.16055082860},
	{0.00000000140, 1.36708586192, 2233.47362101500},
	{0.00000000137, 4.79264710956, 14587.82139146960},
	{0.00000000118, 4.24522226402, 7534.42123515160},
	{0.00000000150, 5.98252134963, 8446.99147881720},
	{0.00000000116, 0.31023473755, 10338.22914975600},
	{0.00000000126, 5.72234812550, 4083.60248723240},
	{0.00000000116, 3.21277912522, 721.13923120620},
	{0.00000000133, 1.77116481582, 3923.61133807820},
	{0.00000000125, 0.79695675334, 9124.92198604240},
	{0.00000000134, 0.59423378961, 6659.37402407320},
	{0.00000000133, 2.32347788867, 6147.60173504190},
	{0.00000000118, 5.14268766839, 19676.45023123640},
	{0.00000000114, 3.36563651789, 6534.41316687600},
	{0.00000000119, 2.45421610326, 1471.75302706360},
	{0.00000000112, 5.63276223022, 1353.39052800780},
	{0.00000000118, 2.59721745181, 2185.25126929280},
	{0.00000000139, 2.53675571989, 14867.73751589219},
	{0.00000000116, 3.08292987464, 3727.03207727200},
	{0.00000000112, 1.08140723902, 6474.52411610300},
	{0.00000000111, 5.09669528080, 7277.40322740860},
	{0.00000000111, 5.06172588434, 6837.62557390200},
	{0.00000000122, 0.61324340709, 9161.52735134660},
	{0.00000000114, 1.06936801122, 3966.23756289700},
	{0.00000000108, 4.40272597236, 27490.69247804480},
	{0.00000000129, 4.66656206914, 3101.40694107480},
	{0.00000000129, 4.59879750310, 3579.81791232480},
	{0.00000000133, 3.86628532692, 6738.12322833520},
	{0.00000000143, 5.51260292487, 10787.63034454580},
	{0.00000000146, 3.29717245103, 3282.73373069600},
	{0.00000000146, 5.96818712120, 3398.49112270360},
	{0.00000000115, 4.70981861448, 2501.64313894940},
	{0.00000000130, 5.51494242208, 6155.46604156810},
	{0.00000000138, 0.53531085594, 604.84974070480},
	{0.00000000115, 4.54726805499, 8976.68244391180},
	{0.00000000105, 5.41363141342, 17821.81792560179},
	{0.00000000104, 3.25094284849, 550.04628449340},
	{0.00000000137, 1.64829531963, 10.63666534980},
	{0.00000000103, 0.09569085161, 31214.20143696780},
	{0.00000000103, 0.32444738176, 1059.31461988640},
	{0.00000000116, 2.76497516745, 21000.91589075680},
	{0.00000000124, 2.96682510796, 2089.78223039900},
	{0.00000000107, 3.74825241556, 7075.85073845880},
	{0.00000000109, 0.75405687887, 27433.88921587499},
	{0.00000000115, 3.05294273666, 7768.00833968560},
	{0.00000000106, 1.35498268917, 338.24269898300},
	{0.00000000105, 5.49367983392, 6961.01135775200},
	{0.00000000129, 3.76517296403, 3719.98584057399},
	{0.00000000129, 5.50018660820, 2961.23901282560},
	{0.00000000122, 2.69389010184, 27676.61781984900},
	{0.00000000137, 4.29317120368, 765.79306444640},
	{0.00000000103, 2.94392199086, 369.69981594040},
	{0.00000000115, 6.24138664661, 2631.62262442320},
	{0.00000000104, 6.26045969928, 31449.82704275180},
	{0.00000000103, 5.98380934531, 4953.56375973140},
	{0.00000000119, 0.25257145975, 5813.29118932200},
	{0.00000000127, 5.95846705295, 2655.50106217100},
	{0.00000000101, 4.76347332672, 21791.69097326579},
	{0.00000000138, 4.81087367911, 3480.31056622260},
	{0.00000000138, 4.45448589312, 3200.91428717700},
	{0.00000000100, 4.46306796510, 101011.00013959699},
	{0.00000000109, 5.70820863859, 249.90446074220},
	{0.00000000100, 2.36720288529, 2651.97794382200},
	{0.00000000112, 0.61908290347, 4825.54491639400},
	{0.00000000106, 2.47924429864, 7899.55030137200},
	{0.00000000100, 0.73142842806, 3340.69699065480},
	{0.00000000100, 5.39233849058, 3340.52786274481},
	{0.00000000099, 1.07037429534, 5312.56460055460},
	{0.00000000110, 4.66774204357, 4179.58171445020},
	{0.00000000119, 4.24896124568, 128.01884333740},
	{0.00000000096, 1.41805272608, 34363.36559755600},
	{0.00000000095, 4.69553914772, 3370.49447031000},
	{0.00000000095, 4.56982042451, 3310.73038308960},
	{0.00000000100, 5.36079056084, 1755.47168467910},
	{0.00000000100, 1.13992481490, 3340.56237004920},
	{0.00000000100, 4.98384210374, 3340.66248335040},
	{0.00000000095, 2.49148312191, 1125.86933910360},
	{0.00000000098, 2.55075465694, 1784.04427974440},
	{0.00000000129, 4.50550938612, 4591.44262300060},
	{0.00000000115, 1.84342023983, 948.19528790160},
	{0.00000000102, 4.70490616658, 2214.74308759620},
	{0.00000000125, 3.41500530183, 30227.97847643040},
	{0.00000000092, 3.28339883365, 1382.88734684660},
	{0.00000000096, 3.69113463475, 158.94351778320},
	{0.00000000096, 5.28632356883, 16975.73509085060},
	{0.00000000117, 4.34728892724, 6342.98215441660},
	{0.00000000101, 4.05180649175, 309.27832265580},
	{0.00000000118, 2.30281760984, 3337.64348128320},
	{0.00000000118, 0.67935665521, 3343.58137211640},
	{0.00000000104, 1.87017877120, 1971.95217385480},
	{0.00000000105, 5.51085323879, 42388.93493630700},
	{0.00000000118, 0.33308541328, 2523.95910048460},
	{0.00000000102, 5.06423665932, 27946.74797991980},
	{0.00000000092, 0.37931448032, 24093.27678917520},
	{0.00000000103, 4.21389346910, 20235.12282631040},
	{0.00000000106, 0.48409497986, 8219.46528937760},
	{0.00000000092, 1.93921425261, 6953.89781075120},
	{0.00000000118, 5.64764411450, 3396.99561277600},
	{0.00000000118, 3.61771545773, 3284.22924062360},
	{0.00000000093, 1.77160363006, 11506.76976979360},
	{0.00000000094, 3.17734400558, 1957.72507985320},
	{0.00000000092, 1.60745438369, 34115.11406927460},
	{0.00000000106, 3.67532877346, 10177.19036923080},
	{0.00000000104, 0.07874415195, 3149.18141424040},
	{0.00000000093, 4.56692119429, 18617.06830104720},
	{0.00000000091, 5.75237351963, 3532.04343915920},
	{0.00000000094, 3.91461919551, 3346.74565263240},
	{0.00000000094, 5.35074037672, 3334.47920076720},
	{0.00000000090, 0.96686807913, 15746.77297752840},
	{0.00000000091, 2.71684236561, 50818.17620277360},
	{0.00000000096, 1.92198734613, 10927.29397676420},
	{0.00000000092, 0.87242130441, 50021.87819595720},
	{0.00000000110, 4.01385678858, 27417.05701482520},
	{0.00000000087, 0.20554759562, 625.67019231240},
	{0.00000000105, 5.13785519094, 440.82528487760},
	{0.00000000103, 6.19913630210, 1059.44924049200},
	{0.00000000089, 2.21598103655, 3368.08129309939},
	{0.00000000089, 0.76619322850, 3313.14356030020},
	{0.00000000092, 1.76294266344, 32509.20897294100},
	{0.00000000107, 0.77642458908, 4822.02179804500},
	{0.00000000086, 2.15668825323, 24336.00539314920},
	{0.00000000091, 1.49995984394, 3532.07794646360},
	{0.00000000114, 1.17888998162, 30774.50164257480},
	{0.00000000095, 2.41544015495, 529.62365479180},
	{0.00000000120, 1.39317335094, 3202.09492982910},
	{0.00000000120, 1.58900091411, 3479.12992357050},
	{0.00000000086, 0.63892610093, 3762.63986785580},
	{0.00000000086, 2.34324816413, 2918.58498554380},
	{0.00000000099, 5.63933737649, 3222.79962380780},
	{0.00000000099, 3.62602219574, 3458.42522959180},
	{0.00000000089, 3.31658981903, 22531.09060514659},
	{0.00000000107, 4.00303304883, 3369.59405667920},
	{0.00000000107, 5.26232652340, 3311.63079672040},
	{0.00000000090, 4.95208405657, 4670.12451695980},
	{0.00000000094, 3.52537110144, 796.28075316420},
	{0.00000000085, 4.38854271531, 809.47746944700},
	{0.00000000086, 2.16630383215, 987.74627292800},
	{0.00000000084, 4.57392791210, 4777.78804089840},
	{0.00000000084, 2.18560642641, 1107.13880568480},
	{0.00000000104, 4.33115782764, 3149.14690693600},
	{0.00000000116, 0.77977053917, 14694.50459434000},
	{0.00000000086, 1.37558388975, 12410.73130054860},
	{0.00000000085, 2.86994886436, 1619.99756972960},
	{0.00000000109, 5.59836287202, 10610.90210710760},
	{0.00000000089, 1.46102468066, 3332.93863472440},
	{0.00000000089, 1.52114958439, 3348.28621867520},
	{0.00000000084, 1.33406969455, 1552.46752997960},
	{0.00000000099, 4.61468010668, 24606.13555322000},
	{0.00000000084, 2.49883491772, 2942.53073359440},
	{0.00000000112, 3.24631234908, 14900.69014277720},
	{0.00000000082, 0.76471194062, 3330.04307165280},
	{0.00000000082, 2.21746232443, 3351.18178174680},
	{0.00000000082, 2.15560831176, 22317.79150970859},
	{0.00000000089, 5.02414670070, 5355.23588148860},
	{0.00000000084, 4.48618455018, 3083.59441895680},
	{0.00000000084, 4.77917502205, 3597.63043444280},
	{0.00000000093, 1.35537122244, 8948.22825590860},
	{0.00000000095, 2.00694376811, 529.75827539740},
	{0.00000000085, 0.15626665144, 1055.85881184020},
	{0.00000000099, 1.87280470738, 7906.59653807000},
	{0.00000000114, 2.85738890734, 3063.57743295840},
	{0.00000000114, 0.12478535771, 3617.64742044120},
	{0.00000000090, 2.28313612434, 51769.89460902420},
	{0.00000000085, 4.25324733609, 54789.93668997800},
	{0.00000000086, 4.98727225433, 23009.94911093539},
	{0.00000000083, 3.80459099750, 20103.04842211240},
	{0.00000000112, 5.31873185789, 5295.32957706340},
	{0.00000000083, 0.55564877844, 4029.24690957760},
	{0.00000000080, 4.41455828078, 31570.79964939120},
	{0.00000000081, 0.73729790566, 3190.71495157300},
	{0.00000000081, 2.24487635939, 3490.50990182660},
	{0.00000000096, 0.23027300186, 2544.29716623120},
	{0.00000000094, 5.55614273293, 796.31526046860},
	{0.00000000089, 5.72126604208, 6311.52503745920},
	{0.00000000085, 0.12415625823, 14715.84023480700},
	{0.00000000102, 3.18943570469, 3524.48201360179},
	{0.00000000102, 6.07592386754, 3156.74283979780},
	{0.00000000086, 2.62365837929, 13517.80279593060},
	{0.00000000084, 2.90733130456, 2942.39611298880},
	{0.00000000084, 4.30297087103, 4801.66647864620},
	{0.00000000079, 1.89987880078, 4423.87279463680},
	{0.00000000082, 5.55317357688, 30220.93223973240},
	{0.00000000081, 5.91225789047, 3347.74322735280},
	{0.00000000081, 3.35310168176, 3333.48162604680},
	{0.00000000079, 3.64160078421, 48031.13317891620},
	{0.00000000083, 2.90263435553, 4049.60222897640},
	{0.00000000078, 2.79442861443, 26880.31981303260},
	{0.00000000079, 2.59415665911, 12988.11183083600},
	{0.00000000096, 1.52859112434, 3357.44462774959},
	{0.00000000096, 1.45358314071, 3323.78022565000},
	{0.00000000082, 0.22380005807, 34513.26307268280},
	{0.00000000098, 3.60718231268, 73.29712585900},
	{0.00000000090, 5.64133979375, 18028.00347403899},
	{0.00000000081, 0.56197619487, 4782.89088911220},
	{0.00000000099, 3.66942611129, 3305.00463611600},
	{0.00000000099, 5.59593346094, 3376.22021728360},
	{0.00000000086, 5.18309238309, 3385.26625994000},
	{0.00000000086, 4.08226718914, 3295.95859345960},
	{0.00000000085, 2.64526952459, 3193.81799382840},
	{0.00000000085, 0.33690474046, 3487.40685957120},
	{0.00000000088, 1.84612419080, 2751.01515718000},
	{0.00000000097, 3.30686127011, 4025.72379122860},
	{0.00000000077, 2.27576479149, 430.53034413910},
	{0.00000000090, 2.83612444399, 16066.06586147480},
	{0.00000000079, 5.30911625997, 1593.00504854690},
	{0.00000000103, 4.98287803658, 6777.20408061740},
	{0.00000000100, 1.06470463453, 1481.40937134520},
	{0.00000000080, 4.95285652438, 1954.71715036360},
	{0.00000000100, 1.74953521165, 10817.08765554480},
	{0.00000000075, 2.02401548869, 14797.59736855860},
	{0.00000000095, 4.35812039823, 17810.20093918380},
	{0.00000000076, 1.17170827309, 11663.17049029600},
	{0.00000000081, 0.45815752842, 3404.34832500320},
	{0.00000000081, 2.52401673663, 3276.87652839640},
	{0.00000000084, 1.04007729585, 45331.39835959860},
	{0.00000000096, 2.26104463335, 2544.33167353560},
	{0.00000000074, 2.66639632955, 7476.47522884500},
	{0.00000000078, 5.92206943670, 8830.91338822380},
	{0.00000000090, 1.59039392369, 1747.60737815290},
	{0.00000000077, 5.30979717297, 1324.94134054000},
	{0.00000000096, 0.61229196319, 52168.04361243240},
	{0.00000000076, 3.90090979569, 21957.68072774700},
	{0.00000000073, 0.73049271630, 31979.51800784640},
	{0.00000000097, 3.07852061878, 8692.32518983940},
	{0.00000000087, 5.83290257662, 15117.51235656420},
	{0.00000000077, 5.61830611535, 1008.54947088340},
	{0.00000000077, 0.40573840944, 4246.06912336460},
	{0.00000000073, 5.81590146580, 927.83996850280},
	{0.00000000077, 4.93122298596, 15423.26756087100},
	{0.00000000080, 5.71635157879, 14061.72085502680},
	{0.00000000081, 5.67561104642, 2917.53735417280},
	{0.00000000081, 0.08793933080, 2910.49111747480},
	{0.00000000073, 4.57978609101, 6809.24369673700},
	{0.00000000075, 1.81129653704, 1214.80232962340},
	{0.00000000075, 0.61176191784, 9090.47419324760},
	{0.00000000073, 0.80597242147, 11869.35603873320},
	{0.00000000080, 3.70920090221, 6151.60119860780},
	{0.00000000075, 1.65852801071, 81604.32185142238},
	{0.00000000074, 5.38130777540, 13635.12266415080},
	{0.00000000074, 5.57898561678, 6603.47430941570},
	{0.00000000081, 2.95396697245, 19573.35745701780},
	{0.00000000071, 5.88002334509, 23539.64007603000},
	{0.00000000071, 5.78949232966, 5621.91023351320},
	{0.00000000072, 5.69738078893, 15276.45587434740},
	{0.00000000090, 5.68707820006, 24532.97658356820},
	{0.00000000071, 5.95708932737, 12140.60114047780},
	{0.00000000070, 2.42585934882, 9384.84100807520},
	{0.00000000070, 5.87974112761, 11247.20896476980},
	{0.00000000070, 4.73224956394, 13951.51453380740},
	{0.00000000073, 2.21781912263, 6493.29970563701},
	{0.00000000073, 0.63102381616, 8436.28750316460},
	{0.00000000069, 3.01335847360, 87.30820453981},
	{0.00000000073, 2.55548238966, 30376.35263916660},
	{0.00000000095, 3.88412225460, 2104.53676637680},
	{0.00000000076, 3.36100516133, 3412.66816005460},
	{0.00000000076, 5.90435441090, 3268.55669334500},
	{0.00000000069, 1.97228484166, 5784.30955934260},
	{0.00000000069, 1.90292001356, 8186.51266249260},
	{0.00000000069, 4.22597683091, 21272.63667352099},
	{0.00000000071, 1.81846746129, 58857.03113654799},
	{0.00000000085, 4.60013473538, 19403.77727388480},
	{0.00000000075, 4.81999758491, 32367.09765620760},
	{0.00000000080, 4.11769728905, 6151.46657800220},
	{0.00000000076, 0.98386664138, 4555.41475632320},
	{0.00000000069, 4.69940432303, 942.06206196900},
	{0.00000000090, 4.89984825456, 30639.85663863300},
	{0.00000000085, 4.39582684427, 45494.58142974879},
	{0.00000000077, 4.08497278156, 78263.70942472259},
	{0.00000000068, 0.82765945114, 8550.08425303580},
	{0.00000000078, 5.32457391220, 422.66603761290},
	{0.00000000073, 2.88235398454, 36105.85908631560},
	{0.00000000069, 4.04053899301, 8027.56914470940},
	{0.00000000070, 1.18585479439, 2332.06295581640},
	{0.00000000068, 2.31090852687, 8528.74361203340},
	{0.00000000071, 2.15201156573, 3371.60441144840},
	{0.00000000071, 0.83016269932, 3309.62044195120},
	{0.00000000080, 4.96962009674, 9705.44541044280},
	{0.00000000070, 2.49836750115, 7843.69955780740},
	{0.00000000081, 0.76982949413, 94329.77528619739},
	{0.00000000070, 1.78964854428, 4349.16189758320},
	{0.00000000067, 5.57564722758, 6112.40297937220},
	{0.00000000075, 1.66067383778, 1585.14074202070},
	{0.00000000086, 0.25993921458, 1612.95133303160},
	{0.00000000069, 2.60354177981, 23553.86717003160},
	{0.00000000067, 2.43147442233, 12725.45343477500},
	{0.00000000072, 2.10386446161, 3414.24788991940},
	{0.00000000072, 0.87830980344, 3266.97696348020},
	{0.00000000069, 1.73288066444, 3186.68719317540},
	{0.00000000069, 1.24929360061, 3494.53766022420},
	{0.00000000075, 3.68220130840, 6836.57794253100},
	{0.00000000090, 2.44476191858, 11527.12508919240},
	{0.00000000093, 3.60055995845, 1826.32112998330},
	{0.00000000085, 2.64904472347, 4157.26575291499},
	{0.00000000093, 5.97228186454, 12892.13260361820},
	{0.00000000067, 2.58897011211, 290.48547946960},
	{0.00000000066, 3.87954800820, 16056.05130018419},
	{0.00000000069, 1.31105511495, 1442.27846241240},
	{0.00000000066, 2.06074554515, 176.69373013380},
	{0.00000000066, 3.36264019921, 225.82926841020},
	{0.00000000068, 0.42746649298, 4897.18057365520},
	{0.00000000067, 3.86247375362, 19247.37655338240},
	{0.00000000065, 5.43572139061, 3357.37731744680},
	{0.00000000065, 3.82963818162, 3323.84753595280},
	{0.00000000066, 0.93287145961, 415.55249061210},
	{0.00000000066, 3.64027452312, 3738.69411980520},
	{0.00000000065, 2.91177847342, 26887.36604973060},
	{0.00000000090, 1.66801934841, 2885.70306017250},
	{0.00000000090, 1.31415491664, 3795.52179322710},
	{0.00000000067, 5.42902273412, 13358.85927814740},
	{0.00000000081, 5.58966586907, 5135.87087042080},
	{0.00000000064, 2.13841748430, 27035.74021246680},
	{0.00000000076, 6.10249673727, 6677.29270013650},
	{0.00000000064, 0.33226555661, 6563.90498517940},
	{0.00000000067, 2.47085873457, 1083.26036793700},
	{0.00000000067, 0.73021872404, 4396.47123854000},
	{0.00000000064, 3.51821204431, 41427.48698317880},
	{0.00000000066, 5.74570221704, 3348.78056328220},
	{0.00000000066, 3.51965735519, 3332.44429011740},
	{0.00000000068, 4.27282420496, 589.59726951980},
	{0.00000000063, 4.22378481482, 15003.78291699580},
	{0.00000000066, 4.39616063982, 3377.60801731080},
	{0.00000000066, 4.86919893241, 3303.61683608880},
	{0.00000000062, 0.97050370815, 423.07507252700},
	{0.00000000073, 1.49148217763, 7250.04672742700},
	{0.00000000066, 3.23177813628, 3738.82874041080},
	{0.00000000065, 5.30587632700, 3226.88298713140},
	{0.00000000065, 3.95948324523, 3454.34186626820},
	{0.00000000069, 2.59633539559, 5884.94410023539},
	{0.00000000079, 5.03199795222, 49225.58018914080},
	{0.00000000072, 4.25964991616, 68241.87214462319},
	{0.00000000082, 3.81994976939, 6573.56132946100},
	{0.00000000078, 5.28528678757, 12979.55317457600},
	{0.00000000078, 0.07000919983, 17078.82786506920},
	{0.00000000063, 4.28938660682, 379.37341387420},
	{0.00000000065, 3.40994727165, 58704.89391501260},
	{0.00000000064, 1.22976149462, 21258.40957951939},
	{0.00000000070, 3.51764772307, 10397.60301166960},
	{0.00000000061, 5.82279175439, 3870.28613814220},
	{0.00000000070, 4.41512641444, 9175.75444534820},
	{0.00000000071, 3.28652650200, 23296.97878235879},
	{0.00000000069, 2.31182487954, 6757.49092467520},
	{0.00000000061, 1.57037807871, 3870.32064544660},
	{0.00000000072, 1.51722213297, 3343.51344098960},
	{0.00000000072, 1.46495213208, 3337.71141241000},
	{0.00000000081, 4.86026830133, 17498.31250894439},
	{0.00000000062, 3.77246444412, 628.85158605010},
	{0.00000000061, 5.70036546851, 54314.20902890760},
	{0.00000000067, 0.68969222601, 955.24152459960},
	{0.00000000062, 2.91999658715, 2711.76084064970},
	{0.00000000062, 1.09464000200, 13738.21543836940},
	{0.00000000071, 6.19798871650, 5621.77561290760},
	{0.00000000065, 5.83189096626, 38650.17350619900},
	{0.00000000067, 1.57027663487, 2899.78714182220},
	{0.00000000063, 2.13936684877, 17660.30346405700},
	{0.00000000059, 5.56221290270, 14071.43950907579},
	{0.00000000073, 6.02852675275, 6695.45194740120},
	{0.00000000059, 4.23500687923, 7056.99058496980},
	{0.00000000067, 2.26422756461, 50420.02719936540},
	{0.00000000059, 1.98957010625, 14319.69103735720},
	{0.00000000069, 0.56556376410, 5884.90959293100},
	{0.00000000083, 4.24356262487, 2636.97924208240},
	{0.00000000060, 4.15624789446, 44535.10035278220},
	{0.00000000061, 3.73591863489, 24076.44458812540},
	{0.00000000064, 1.17391999318, 32522.51805564180},
	{0.00000000076, 4.51755928368, 418.92439890060},
	{0.00000000065, 2.85546048584, 48273.86178289020},
	{0.00000000058, 0.71565564537, 29.49181830340},
	{0.00000000059, 5.68323628850, 9978.11836779440},
	{0.00000000073, 0.26749667915, 30831.30490474460},
	{0.00000000063, 2.63766816139, 9722.71088583020},
	{0.00000000080, 3.23485617789, 3377.26098962930},
	{0.00000000080, 6.03050339435, 3303.96386377030},
	{0.00000000058, 0.73286492045, 16070.27839418580},
	{0.00000000070, 4.06414188362, 11787.60390551700},
	{0.00000000057, 3.92277309891, 27278.46881644080},
	{0.00000000057, 3.48535607735, 37057.57749256620},
	{0.00000000062, 1.45925373057, 38252.02450279080},
	{0.00000000062, 0.38427986095, 437.64389113990},
	{0.00000000071, 2.87138479505, 6486.25346893900},
	{0.00000000057, 3.63114094155, 3930.20969621960},
	{0.00000000074, 5.72909319934, 3189.56475685690},
	{0.00000000058, 1.59816197403, 4712.02419015580},
	{0.00000000058, 1.38401229102, 1969.20066324380},
	{0.00000000064, 3.23303289058, 5525.86369599260},
	{0.00000000059, 4.01427864314, 22854.59602180400},
	{0.00000000069, 0.29377457284, 11240.16272807180},
	{0.00000000057, 2.42003042082, 1022.77656488500},
	{0.00000000074, 0.44861274444, 3192.53370227350},
	{0.00000000060, 5.27775099292, 3348.19110590940},
	{0.00000000060, 3.98760857931, 3333.03374749019},
	{0.00000000055, 3.34525081447, 3325.87514437420},
	{0.00000000055, 5.92010875776, 3355.34970902540},
	{0.00000000057, 2.89244313085, 15842.75220474620},
	{0.00000000055, 2.80680487032, 4565.98411137020},
	{0.00000000055, 2.40063303030, 11560.07771607740},
	{0.00000000063, 5.97432204184, 4136.92768716840},
	{0.00000000055, 4.36076096626, 21.85082932640},
	{0.00000000061, 6.18050944136, 11037.50029798360},
	{0.00000000071, 4.62640656139, 418.50432280700},
	{0.00000000061, 5.32997938163, 222.86032299360},
	{0.00000000073, 2.99831416680, 33716.96506586640},
	{0.00000000062, 3.71439419421, 22487.37169284160},
	{0.00000000055, 0.37443777882, 25665.51748340920},
	{0.00000000061, 2.45880942377, 7630.40046236940},
	{0.00000000061, 5.62643638872, 1737.31243741440},
	{0.00000000067, 5.86396730577, 13366.04013545100},
	{0, 0, 0}
};

struct vsop87_term mars_x1[] = {
	{0.00861441374, 3.14159265359, 0.00000000000},
	{0.00552437949, 5.09565872891, 6681.22485339960},
	{0.00077184977, 5.43315636209, 10021.83728009940},
	{0.00020467294, 5.57051812369, 3340.61242669980},
	{0.00009589581, 5.77107234791, 13362.44970679920},
	{0.00002620610, 6.22441295122, 3344.13554504880},
	{0.00002620537, 3.04172154436, 3337.08930835080},
	{0.00001163612, 6.10909257097, 16703.06213349900},
	{0.00000901178, 3.31585548194, 1059.38193018920},
	{0.00000427058, 2.74008980166, 2942.46342329160},
	{0.00000381428, 0.22342431378, 3738.76143010800},
	{0.00000386916, 5.94232552612, 5621.84292321040},
	{0.00000395001, 0.20042939555, 6684.74797174860},
	{0.00000337356, 5.21417361076, 3149.16416058820},
	{0.00000334209, 2.45910275965, 3185.19202726560},
	{0.00000318463, 4.05140251894, 3532.06069281140},
	{0.00000318426, 0.52909208916, 3496.03282613400},
	{0.00000312605, 4.22912280613, 2544.31441988340},
	{0.00000289251, 4.61759345454, 796.29800681640},
	{0.00000260308, 5.02630754856, 4136.91043351620},
	{0.00000206733, 3.21083229673, 1194.44701022460},
	{0.00000140570, 0.16405101702, 20043.67456019880},
	{0.00000159366, 3.57762977582, 1589.07289528380},
	{0.00000133819, 4.64351814551, 5884.92684658320},
	{0.00000132323, 3.70094513425, 4399.99435688900},
	{0.00000127123, 2.81806076447, 6677.70173505060},
	{0.00000102796, 6.05672047566, 5486.77784317500},
	{0.00000112591, 5.89047647024, 2146.16541647520},
	{0.00000129469, 1.80477637958, 1592.59601363280},
	{0.00000101457, 3.72531913828, 3341.59274776800},
	{0.00000101429, 5.54115874275, 3339.63210563160},
	{0.00000089231, 5.88265350957, 3870.30339179440},
	{0.00000084359, 0.39861148409, 1990.74501704100},
	{0.00000079681, 3.91080385507, 426.59819087600},
	{0.00000077267, 0.64237838596, 7079.37385680780},
	{0.00000081615, 5.65301248357, 5092.15195811580},
	{0.00000064069, 5.27568100391, 2388.89402044920},
	{0.00000057349, 0.50336630984, 10025.36039844840},
	{0.00000057779, 1.95322424838, 3097.88382272579},
	{0.00000075338, 1.25298511750, 5088.62883976680},
	{0.00000075597, 3.61161529128, 4535.05943692440},
	{0.00000057038, 2.69097269126, 4690.47983635860},
	{0.00000058112, 0.40782428306, 7.11354700080},
	{0.00000055693, 1.22100970149, 9492.14631500480},
	{0.00000053020, 1.04990905431, 3583.34103067380},
	{0.00000070673, 3.86820111874, 2787.04302385740},
	{0.00000049103, 4.08361966579, 4292.33083295040},
	{0.00000051266, 4.58705364976, 191.44826611160},
	{0.00000054144, 2.75220168825, 2957.71589447660},
	{0.00000060338, 5.44643531231, 3894.18182954220},
	{0.00000060977, 1.33676776514, 1748.01641306700},
	{0.00000049313, 2.50941274343, 6681.20759974740},
	{0.00000049853, 0.26909559157, 3723.50895892300},
	{0.00000049313, 4.54018424365, 6681.24210705180},
	{0.00000056626, 1.06789339618, 155.42039943420},
	{0.00000047447, 5.64332397974, 6489.77658728800},
	{0.00000037363, 0.07393316577, 3553.91152213780},
	{0.00000041874, 2.94784781040, 1349.86740965880},
	{0.00000036019, 2.84922399832, 3127.31333126180},
	{0.00000035314, 2.80430917536, 6525.80445396540},
	{0.00000032357, 4.45790537173, 951.71840625060},
	{0.00000032811, 5.05742629063, 3333.49887969900},
	{0.00000039137, 5.37813466087, 7477.52286021600},
	{0.00000029434, 5.34740413798, 6254.62666252360},
	{0.00000029948, 5.91717139203, 553.56940284240},
	{0.00000027640, 3.75118803663, 12303.06777661000},
	{0.00000027492, 2.19308010261, 4933.20844033260},
	{0.00000028209, 4.24849741016, 3347.72597370060},
	{0.00000024027, 2.99666997180, 2810.92146160520},
	{0.00000024446, 6.22777959925, 1066.49547719000},
	{0.00000029268, 2.65797242705, 639.89728631400},
	{0.00000021284, 3.84563390414, 4929.68532198360},
	{0.00000022160, 5.38045378366, 2281.23049651060},
	{0.00000024653, 0.71737818564, 382.89653222320},
	{0.00000024832, 3.86595587444, 2118.76386037840},
	{0.00000019156, 5.97786462687, 529.69096509460},
	{0.00000019368, 0.65233184104, 242.72860397400},
	{0.00000018361, 0.61249454438, 9623.68827669120},
	{0.00000017087, 2.30909423712, 3320.25710730100},
	{0.00000016973, 0.67405360149, 3360.96774609859},
	{0.00000016990, 0.50198426834, 23384.28698689860},
	{0.00000016240, 0.58693834825, 6681.15754309680},
	{0.00000016010, 0.45122114069, 1052.26838318840},
	{0.00000017059, 2.70322688862, 6674.11130639880},
	{0.00000014616, 1.92148810610, 10018.31416175040},
	{0.00000016065, 4.24982817116, 3325.35995551480},
	{0.00000016701, 0.67061213764, 7210.91581849420},
	{0.00000017710, 4.03786343224, 7740.60678358880},
	{0.00000015982, 5.01800237749, 3355.86489788480},
	{0.00000016240, 0.17847274471, 6681.29216370240},
	{0.00000013777, 1.54970744605, 12832.75874170460},
	{0.00000014497, 0.51986042995, 2274.11694950980},
	{0.00000012485, 4.09460712678, 6682.20517446780},
	{0.00000012683, 0.77128314603, 5331.35744374080},
	{0.00000013623, 0.04061937918, 2288.34404351140},
	{0.00000013051, 4.49310483339, 3767.21061757580},
	{0.00000011614, 2.36759996260, 6438.49624942560},
	{0.00000014620, 5.34262285752, 4562.46099302120},
	{0.00000012264, 1.92472095959, 536.80451209540},
	{0.00000011399, 2.44490119447, 522.57741809380},
	{0.00000010305, 3.95759369406, 7875.67186362420},
	{0.00000010643, 3.06544565234, 5614.72937620960},
	{0.00000012504, 1.00423358318, 10419.98628350760},
	{0.00000010339, 4.87442511701, 10021.85453375160},
	{0.00000008822, 1.53728617245, 3205.54734666440},
	{0.00000011354, 0.31954807551, 6041.32756708560},
	{0.00000008406, 1.44447794642, 3475.67750673520},
	{0.00000010339, 2.84366026063, 10021.82002644720},
	{0.00000009717, 0.73258032600, 6836.64525283380},
	{0.00000008014, 4.35110324867, 2700.71514038580},
	{0.00000008107, 0.81975962806, 13365.97282514820},
	{0.00000007381, 4.07383581901, 15643.68020330980},
	{0.00000007807, 4.22077494831, 6127.65545055720},
	{0.00000007065, 4.75207941589, 213.29909543800},
	{0.00000007035, 2.52904374075, 5628.95647021120},
	{0.00000007636, 4.05071436432, 1751.53953141600},
	{0.00000006709, 4.61324201649, 3178.14579056760},
	{0.00000006272, 3.10587190159, 6298.32832117640},
	{0.00000006332, 4.65004753478, 3503.07906283200},
	{0.00000006358, 5.59134223888, 3316.73398895200},
	{0.00000007875, 5.63977989179, 5729.50644714900},
	{0.00000006284, 3.67192363783, 3364.49086444760},
	{0.00000008239, 4.85475989069, 8962.45534991020},
	{0.00000006726, 6.02428284097, 9830.38901398780},
	{0.00000006038, 3.27619332020, 398.14900340820},
	{0.00000007269, 0.63965217204, 6894.52394883760},
	{0.00000006024, 1.64197757257, 853.19638175200},
	{0.00000005538, 5.78612814784, 3.52311834900},
	{0.00000005603, 5.72285881440, 10818.13528691580},
	{0.00000005542, 0.97325944065, 1758.65307841680},
	{0.00000005314, 4.22360413803, 2648.45482547300},
	{0.00000006512, 5.82435708254, 6680.24453233140},
	{0.00000005502, 1.39010072925, 6923.95345737360},
	{0.00000005061, 6.24728437319, 1596.18644228460},
	{0.00000004841, 0.46251219835, 6158.64743530580},
	{0.00000005019, 3.60025928930, 433.71173787680},
	{0.00000004333, 0.94382312112, 12964.30070339100},
	{0.00000004783, 1.03608770138, 6144.42034130420},
	{0.00000004730, 4.22311630120, 2914.01423582380},
	{0.00000003970, 0.34201626027, 3312.16323923200},
	{0.00000003932, 2.64182103921, 3369.06161416760},
	{0.00000005131, 5.75816121607, 8432.76438481560},
	{0.00000003924, 5.52177794448, 640.87760738220},
	{0.00000004288, 5.22939982526, 6151.53388830500},
	{0.00000003722, 4.67114753737, 3335.08950239240},
	{0.00000003721, 4.59533823527, 3346.13535100720},
	{0.00000004830, 4.64482449524, 6688.33840040040},
	{0.00000004066, 4.97310263007, 4032.77002792660},
	{0.00000003565, 2.53670247107, 8273.82086703240},
	{0.00000004116, 3.14698296281, 9866.41688066520},
	{0.00000003629, 1.25762240997, 3304.58456002240},
	{0.00000003622, 5.99791431215, 1581.95934828300},
	{0.00000003577, 1.72457020044, 3376.64029337720},
	{0.00000004006, 3.50175662034, 2699.73481931760},
	{0.00000003816, 2.98894730062, 8969.56889691100},
	{0.00000003417, 0.51900593403, 10021.90459040220},
	{0.00000004071, 3.46038113099, 3863.18984479360},
	{0.00000004326, 4.09031704505, 11773.37681151540},
	{0.00000004227, 5.72754081349, 2818.03500860600},
	{0.00000003928, 3.43504403516, 8955.34180290940},
	{0.00000003567, 0.89902213787, 1744.42598441520},
	{0.00000003247, 0.50731005475, 149.56319713460},
	{0.00000003163, 3.19092536309, 3980.50971301380},
	{0.00000003117, 3.81812196204, 3336.73109134180},
	{0.00000003104, 5.44232475906, 3344.49376205780},
	{0.00000003427, 0.92910700550, 10021.76996979660},
	{0.00000003818, 1.63069738341, 6283.07584999140},
	{0.00000003018, 1.27275373599, 10551.52824519400},
	{0.00000003094, 1.78971291511, 13358.92658845020},
	{0.00000002972, 4.06477836275, 419.48464387520},
	{0.00000002930, 5.29397937918, 2487.41604494780},
	{0.00000002859, 4.14824445170, 8270.29774868340},
	{0.00000002618, 4.59592591602, 1221.84856632140},
	{0.00000003149, 4.07090669467, 5459.37628707820},
	{0.00000003452, 3.58033884806, 9225.53927328300},
	{0.00000002662, 0.62485553999, 7632.94325965020},
	{0.00000002528, 5.78755929713, 3333.56619000180},
	{0.00000002421, 5.22954368274, 8429.24126646660},
	{0.00000002453, 5.65563006765, 8031.09226305840},
	{0.00000002458, 0.21740426116, 2766.26762836500},
	{0.00000003009, 5.91932692843, 3981.49003408200},
	{0.00000002328, 0.84599472286, 9381.93999378540},
	{0.00000002424, 0.82684290604, 9808.53818466140},
	{0.00000002276, 1.56667324357, 5828.02847164760},
	{0.00000002192, 0.31892596039, 4407.10790388980},
	{0.00000002225, 2.88561251745, 3914.95722503460},
	{0.00000002514, 1.88526284735, 16173.37116840440},
	{0.00000002437, 4.37264449561, 11081.21921028860},
	{0.00000002753, 3.46421789134, 7064.12138562280},
	{0.00000002044, 3.91789079559, 6040.34724601740},
	{0.00000002107, 3.63278010781, 15113.98923821520},
	{0.00000002669, 3.69099558382, 6467.92575796160},
	{0.00000001887, 0.17011382442, 76.26607127560},
	{0.00000001846, 2.79006302906, 1692.16566950240},
	{0.00000002140, 3.22050811027, 3347.65866339780},
	{0.00000001867, 1.35298978219, 13760.59871020740},
	{0.00000001870, 5.25845310749, 220.41264243880},
	{0.00000001717, 5.21576113138, 13362.46696045140},
	{0.00000001788, 2.45204273441, 6660.44945790720},
	{0.00000001744, 1.79434186275, 6816.28993343500},
	{0.00000002248, 2.21497893636, 7234.79425624200},
	{0.00000001717, 3.18498950602, 13362.43245314700},
	{0.00000001739, 3.64902335469, 3281.23856478620},
	{0.00000002059, 0.84035144431, 26724.89941359840},
	{0.00000001824, 5.65759439478, 6247.51311552280},
	{0.00000001569, 3.26028020530, 574.34479833480},
	{0.00000001698, 5.61637635354, 3399.98628861340},
	{0.00000002119, 1.71301547740, 6872.67311951120},
	{0.00000001532, 3.04023559365, 3877.41693879520},
	{0.00000001628, 4.45153470682, 10022.81760116760},
	{0.00000001807, 5.37059107698, 6696.47732458460},
	{0.00000001767, 2.64991278616, 6660.86953400080},
	{0.00000001384, 4.29310139885, 11216.28429032400},
	{0.00000001690, 4.89931132759, 7107.82304427560},
	{0.00000001593, 5.81218827514, 206.18554843720},
	{0.00000001473, 3.94656024828, 8439.87793181640},
	{0.00000001360, 2.27641913726, 3074.00538497800},
	{0.00000001302, 4.55773849708, 6665.97238221460},
	{0.00000001593, 1.11307060368, 8671.96987044060},
	{0.00000001305, 0.97554521194, 6701.58017279840},
	{0.00000001657, 5.40650209199, 8827.39026987480},
	{0.00000001529, 0.56980933614, 3546.79797513700},
	{0.00000001527, 2.39970013340, 3134.42687826260},
	{0.00000001234, 1.35920832366, 1228.96211332220},
	{0.00000001498, 3.04227517263, 10014.72373309860},
	{0.00000001192, 1.27460239384, 110.20632121940},
	{0.00000001367, 3.02383204600, 9779.10867612540},
	{0.00000001230, 0.29260201065, 11371.70468975820},
	{0.00000001403, 4.40495727981, 18984.29263000960},
	{0.00000001219, 0.70589188231, 3607.21946842160},
	{0.00000001203, 1.93922605595, 3319.83703120740},
	{0.00000001400, 4.52326043784, 5099.26550511660},
	{0.00000001148, 1.04852148563, 3361.38782219220},
	{0.00000001515, 4.61278775683, 6702.00024889200},
	{0.00000001157, 1.07615224761, 10235.13637553740},
	{0.00000001086, 3.25980753881, 12935.85151592320},
	{0.00000001089, 2.28518675051, 3169.93955608060},
	{0.00000001068, 3.73801386165, 6684.81528205140},
	{0.00000001340, 5.45392652944, 2803.80791460440},
	{0.00000001057, 0.81408234263, 10973.55568635000},
	{0.00000001071, 2.45426009627, 6531.66165626500},
	{0.00000001124, 3.24778689268, 2906.90068882300},
	{0.00000001358, 4.09029594688, 1039.02661079040},
	{0.00000001416, 2.61990974907, 647.01083331480},
	{0.00000001027, 5.30953853640, 6261.74020952440},
	{0.00000001082, 3.32074909820, 6677.63442474780},
	{0.00000001020, 0.69684985470, 3511.28529731900},
	{0.00000001123, 1.64413797832, 2921.12778282460},
	{0.00000000982, 0.25720172165, 4989.05918389720},
	{0.00000000977, 3.76387167528, 8425.65083781480},
	{0.00000000922, 4.56445665593, 9468.26787725700},
	{0.00000000916, 0.04652972552, 3561.02506913860},
	{0.00000000918, 0.10710061200, 13171.00144068760},
	{0.00000001078, 1.88392074727, 10575.40668294180},
	{0.00000000887, 2.35910251121, 3760.09707057500},
	{0.00000000878, 1.69416917623, 956.28915597060},
	{0.00000000872, 2.78538821999, 3120.19978426100},
	{0.00000000930, 5.98147253164, 9070.11887384880},
	{0.00000000840, 0.12611650681, 2125.87740737920},
	{0.00000000880, 2.47516759962, 3313.21087060300},
	{0.00000001010, 1.04763118283, 3253.30422216000},
	{0.00000000870, 0.50700932774, 3368.01398279660},
	{0.00000001000, 4.48123094738, 9595.23908922340},
	{0.00000000822, 2.58495071013, 1861.74585263540},
	{0.00000000974, 1.93461985334, 3427.92063123960},
	{0.00000001121, 1.14643572651, 16706.58525184800},
	{0.00000000790, 2.77256344629, 3443.70520091840},
	{0.00000000790, 4.02400070641, 10404.73381232260},
	{0.00000000777, 1.90608277320, 9168.64089834740},
	{0.00000000768, 4.93323770287, 11769.85369316640},
	{0.00000000917, 5.01587421292, 3340.62968035200},
	{0.00000000759, 6.06112515589, 14158.74771361560},
	{0.00000000756, 3.17480517462, 632.78373931320},
	{0.00000000769, 3.45170371859, 9638.94074787620},
	{0.00000000917, 2.98510265793, 3340.59517304760},
	{0.00000000800, 4.79154115035, 6518.75821726740},
	{0.00000000725, 3.17641441624, 6475.03930496240},
	{0.00000000721, 5.76834431293, 7903.07341972100},
	{0.00000000730, 3.02102816704, 6709.67404086740},
	{0.00000000925, 5.09004861088, 11243.68584642080},
	{0.00000000753, 5.41546929401, 5642.19824260920},
	{0.00000000797, 1.29224453150, 16304.91313009080},
	{0.00000000689, 4.67900398399, 7910.18696672180},
	{0.00000000750, 6.08088730030, 3296.89351439480},
	{0.00000000688, 5.00398855432, 10028.95082710020},
	{0.00000000660, 1.31849975129, 1214.73501932060},
	{0.00000000737, 3.18448728107, 3384.33133900480},
	{0.00000000896, 5.14258755707, 2301.58581590939},
	{0.00000000674, 2.97036744718, 2807.39834325620},
	{0.00000000845, 0.83947970783, 9499.25986200560},
	{0.00000000627, 1.11034276522, 13149.15061136120},
	{0.00000000633, 2.81432845663, 6604.95878212400},
	{0.00000000612, 0.29523233872, 3237.51965248120},
	{0.00000000611, 2.72870079822, 12566.15169998280},
	{0.00000000710, 3.89492785518, 6460.81221096080},
	{0.00000000701, 0.38714381576, 3311.18291816379},
	{0.00000000701, 2.59503044929, 3370.04193523580},
	{0.00000000605, 6.16661321134, 949.17560896980},
	{0.00000000721, 3.39819016368, 12310.18132361080},
	{0.00000000634, 5.13698921586, 692.15760122680},
	{0.00000000570, 4.29687682063, 2693.60159338500},
	{0.00000000646, 5.77545650923, 2111.65031337760},
	{0.00000000544, 1.97116952941, 16699.53901514999},
	{0.00000000573, 2.69510600136, 1437.17561419860},
	{0.00000000623, 1.72892894707, 10264.56588407340},
	{0.00000000539, 0.82065219960, 3490.17562383440},
	{0.00000000557, 0.85462599459, 13362.51701710200},
	{0.00000000647, 0.93841423909, 4392.88080988820},
	{0.00000000618, 2.21502067098, 10177.25767953360},
	{0.00000000527, 6.20891297659, 1375.77379984580},
	{0.00000000537, 0.00969918132, 3873.82651014340},
	{0.00000000584, 3.00944725913, 5085.03841111500},
	{0.00000000511, 3.07543364583, 13517.87010623340},
	{0.00000000584, 2.12241430212, 4193.80880845180},
	{0.00000000506, 1.37728449479, 9485.03276800400},
	{0.00000000500, 2.93933452214, 224.34479570190},
	{0.00000000670, 5.94569787504, 6657.34641565180},
	{0.00000000513, 4.94015312303, 3232.94890276120},
	{0.00000000489, 4.17658939709, 3774.32416457660},
	{0.00000000600, 3.74402912289, 2707.82868738660},
	{0.00000000475, 2.23223934897, 2178.13772229200},
	{0.00000000613, 4.40036999883, 5989.06725217280},
	{0.00000000492, 4.32513664928, 3448.27595063840},
	{0.00000000463, 1.38849137815, 3229.42578441220},
	{0.00000000533, 3.77079193810, 18454.60166491500},
	{0.00000000472, 3.67184386612, 12295.95422960920},
	{0.00000000540, 0.51844562567, 6034.21402008480},
	{0.00000000444, 3.95877289512, 6705.10329114740},
	{0.00000000443, 1.59365772526, 3451.79906898740},
	{0.00000000557, 1.26314936469, 13362.38239649640},
	{0.00000000551, 3.37214913132, 263.08392337280},
	{0.00000000494, 3.48539252825, 13207.02930736500},
	{0.00000000402, 1.71992380217, 6571.01853218020},
	{0.00000000413, 4.34479957368, 8799.98871377800},
	{0.00000000488, 2.98223801931, 2221.85663459700},
	{0.00000000421, 4.49848554474, 4379.63903749020},
	{0.00000000472, 0.33922281030, 4936.79886898440},
	{0.00000000515, 5.18562869638, 6675.70192909220},
	{0.00000000477, 5.07324050899, 7895.95987272020},
	{0.00000000407, 1.25884679916, 3289.33208883739},
	{0.00000000407, 1.72332746589, 3391.89276456221},
	{0.00000000474, 1.74796870608, 13892.14067189380},
	{0.00000000478, 4.16158691668, 13119.72110282519},
	{0.00000000427, 2.86195707217, 11614.43329373220},
	{0.00000000369, 5.02545575221, 135.06508003540},
	{0.00000000384, 5.80577939754, 6685.10618875760},
	{0.00000000392, 4.39337463856, 6843.69148953180},
	{0.00000000370, 1.36094569476, 3274.12501778540},
	{0.00000000388, 0.03030103193, 6048.44111408640},
	{0.00000000363, 1.24603804228, 20.35531939880},
	{0.00000000360, 1.62130663873, 3407.09983561420},
	{0.00000000345, 4.59132625278, 15.25247118500},
	{0.00000000347, 1.29475122047, 5724.93569742900},
	{0.00000000453, 2.09914090460, 3113.13629391080},
	{0.00000000389, 6.08882765883, 9588.12554222260},
	{0.00000000422, 2.19336420550, 19513.98359510420},
	{0.00000000373, 6.01149621113, 10020.85695903120},
	{0.00000000344, 5.71003719613, 12721.57209941700},
	{0.00000000359, 5.00080130209, 9380.95967271720},
	{0.00000000375, 4.47591732608, 11610.91017538320},
	{0.00000000335, 4.55690899534, 2938.94030494260},
	{0.00000000315, 4.72280053136, 2384.32327072920},
	{0.00000000340, 3.64508189959, 7321.12213971360},
	{0.00000000412, 0.88247746034, 3568.08855948880},
	{0.00000000374, 4.02425919317, 3415.39402526710},
	{0.00000000310, 4.70848762021, 14421.83163698840},
	{0.00000000344, 0.47873990239, 1903.43681250120},
	{0.00000000309, 6.17856568800, 4569.57454002200},
	{0.00000000330, 2.06620388834, 3318.76159737340},
	{0.00000000330, 0.91597037671, 3362.46325602620},
	{0.00000000346, 5.60772621945, 9602.35263622420},
	{0.00000000329, 4.94303630669, 10042.61267559180},
	{0.00000000308, 4.74792571468, 16460.33352952499},
	{0.00000000301, 0.64905373192, 3340.67973700260},
	{0.00000000311, 5.54347060615, 323.50541665740},
	{0.00000000340, 4.78541899020, 22324.90505670940},
	{0.00000000294, 4.55140151748, 10596.18207843420},
	{0.00000000390, 2.10755320496, 6717.25272007700},
	{0.00000000298, 0.56249511314, 3416.87849797540},
	{0.00000000291, 1.54713222563, 6645.19698672220},
	{0.00000000360, 0.57790692476, 5244.04923920100},
	{0.00000000399, 2.01329403322, 13916.01910964160},
	{0.00000000293, 3.68949232970, 2675.85638156980},
	{0.00000000327, 6.16735333216, 4459.36821880260},
	{0.00000000337, 5.55760049578, 162.46663613220},
	{0.00000000304, 3.91898402784, 7203.80227149340},
	{0.00000000280, 1.62615107581, 3397.51080163540},
	{0.00000000280, 1.35602318924, 3283.71405176420},
	{0.00000000275, 3.08102921005, 5732.04924442980},
	{0.00000000301, 1.05608440560, 3340.54511639700},
	{0.00000000284, 3.95421107268, 14584.29827312060},
	{0.00000000280, 3.40896567674, 6688.27109009760},
	{0.00000000356, 3.25540777340, 1162.47470440780},
	{0.00000000363, 2.79281358783, 10001.06188460700},
	{0.00000000285, 2.02354216491, 14314.16811304980},
	{0.00000000305, 5.21825469861, 3265.83082813250},
	{0.00000000259, 3.13103994929, 5032.77809620220},
	{0.00000000253, 1.68801838224, 17101.21113690720},
	{0.00000000251, 3.23448365420, 11766.26326451460},
	{0.00000000253, 3.52319644222, 16703.04487984680},
	{0.00000000253, 1.08130162107, 6947.83189512140},
	{0.00000000278, 6.24528874374, 7322.10246078180},
	{0.00000000282, 1.66194895980, 860.30992875280},
	{0.00000000278, 1.07336593399, 74.78159856730},
	{0.00000000253, 5.55396848472, 16703.07938715119},
	{0.00000000246, 2.73029636009, 3304.00706139560},
	{0.00000000246, 0.25187790496, 3377.21779200400},
	{0.00000000239, 3.57219156566, 16276.46394262300},
	{0.00000000239, 3.66509719573, 11780.49035851620},
	{0.00000000225, 3.64551843619, 10018.24685144760},
	{0.00000000239, 4.78918105736, 13936.79450513400},
	{0.00000000284, 2.13762517288, 10156.90236013480},
	{0.00000000238, 4.98437875568, 7255.56965173440},
	{0.00000000243, 1.17853314043, 30065.51184029820},
	{0.00000000219, 2.93870106015, 5305.45105355380},
	{0.00000000218, 3.34948255670, 3029.77162783140},
	{0.00000000240, 1.35327460265, 2075.04494807340},
	{0.00000000221, 5.57663616389, 4005.36847182980},
	{0.00000000223, 4.35090669349, 23.87843774780},
	{0.00000000224, 4.07746567192, 10025.42770875120},
	{0.00000000216, 5.71759573965, 10037.08975128440},
	{0.00000000213, 5.27835961911, 10448.43547097540},
	{0.00000000210, 1.47694443779, 4555.34744602040},
	{0.00000000211, 3.90222929747, 6944.30877677240},
	{0.00000000215, 4.18959076854, 3212.59358336240},
	{0.00000000234, 0.76568079767, 3185.25933756840},
	{0.00000000215, 6.24541228185, 1545.35398297880},
	{0.00000000212, 5.30591163701, 3230.40610548040},
	{0.00000000253, 6.20740369502, 16062.18452611680},
	{0.00000000201, 1.28338790475, 1835.32461760680},
	{0.00000000209, 3.36887494837, 16858.48253293320},
	{0.00000000198, 0.22514658211, 6578.13207918100},
	{0.00000000204, 5.07565396807, 3468.63127003720},
	{0.00000000213, 0.67649924264, 7747.72033058960},
	{0.00000000266, 5.05292569149, 2277.70737816160},
	{0.00000000198, 1.16597531015, 15508.61512327440},
	{0.00000000193, 5.91462315638, 3651.45322556820},
	{0.00000000199, 2.92332691428, 17924.91069982040},
	{0.00000000242, 3.82869102683, 6621.85099148600},
	{0.00000000220, 2.24714438581, 3495.96551583120},
	{0.00000000190, 0.88866953545, 12323.42309600880},
	{0.00000000192, 5.22444181613, 2480.30249794700},
	{0.00000000197, 1.26232029421, 15664.03552270859},
	{0.00000000189, 0.28835038064, 19402.79695281660},
	{0.00000000192, 4.92154638435, 14054.60730802600},
	{0.00000000183, 5.56570381896, 8542.97070603500},
	{0.00000000200, 4.07950076032, 6677.34351804160},
	{0.00000000249, 1.63875770688, 699.27114822760},
	{0.00000000184, 2.06454534852, 4845.90023579280},
	{0.00000000183, 5.88258668238, 533.21408344360},
	{0.00000000202, 1.49099779688, 12012.58229714040},
	{0.00000000177, 5.39113553042, 7380.49600162720},
	{0.00000000178, 0.04214387699, 6456.88005769770},
	{0.00000000205, 1.56638102938, 2945.98654164060},
	{0.00000000239, 0.56549194814, 6106.88005506480},
	{0.00000000200, 2.99049384035, 10001.48196070061},
	{0.00000000171, 4.43743888209, 6756.00645196690},
	{0.00000000182, 1.09754108002, 6887.41040183680},
	{0.00000000174, 3.24224963289, 6418.14093002680},
	{0.00000000168, 1.47006471713, 13575.74880223720},
	{0.00000000184, 3.93810691590, 7218.02936549500},
	{0.00000000166, 3.82858624226, 15650.79375031060},
	{0.00000000168, 1.24963985652, 5618.31980486140},
	{0.00000000212, 4.80268839794, 13363.43002786740},
	{0.00000000169, 0.37714459018, 2655.56837247380},
	{0.00000000168, 1.37312305288, 7314.00859271280},
	{0.00000000207, 6.11286992514, 14712.31711645800},
	{0.00000000159, 2.63556274864, 2008.55753915900},
	{0.00000000177, 5.21096301825, 6686.74777770700},
	{0.00000000192, 3.27974426286, 2751.54759969160},
	{0.00000000153, 4.85804008745, 3347.29609057390},
	{0.00000000153, 4.40731948478, 3333.92876282570},
	{0.00000000151, 2.78026590654, 103.09277421860},
	{0.00000000154, 1.98358917407, 3499.55594448300},
	{0.00000000151, 5.45564580430, 10713.99488132620},
	{0.00000000169, 1.72784795263, 19645.52555679060},
	{0.00000000175, 0.52130528553, 8982.81066930900},
	{0.00000000188, 2.80365997800, 1332.05488754080},
	{0.00000000195, 0.42819289586, 6546.15977336420},
	{0.00000000153, 1.34899298445, 12722.55242048520},
	{0.00000000158, 4.60986821977, 14556.89671702380},
	{0.00000000173, 3.36956475760, 14.22709400160},
	{0.00000000171, 4.49567777458, 1062.90504853820},
	{0.00000000171, 0.56475191630, 2391.43681773000},
	{0.00000000185, 4.33527974597, 2409.24933984800},
	{0.00000000179, 6.25811741113, 20.77539549240},
	{0.00000000143, 2.17166434379, 1505.28780909299},
	{0.00000000149, 1.03739270255, 735.87651353180},
	{0.00000000152, 0.66722406763, 9389.05354078620},
	{0.00000000148, 3.00263900859, 3053.65006557920},
	{0.00000000140, 0.90450305556, 6691.86151874940},
	{0.00000000135, 4.10212923465, 2604.73591316800},
	{0.00000000135, 5.16323033758, 4076.48894023160},
	{0.00000000134, 2.23334811023, 3191.04922956520},
	{0.00000000177, 1.67456433042, 8958.93223156120},
	{0.00000000178, 1.87772953896, 2284.75361485960},
	{0.00000000132, 2.81820003351, 846.08283475120},
	{0.00000000175, 4.86229323516, 8965.97846825920},
	{0.00000000160, 4.45487960287, 2494.52959194860},
	{0.00000000138, 1.47418494330, 20047.19767854780},
	{0.00000000128, 0.92352133267, 9374.82644678460},
	{0.00000000132, 5.64348485151, 7366.26890762560},
	{0.00000000152, 1.23461889422, 4672.66731424060},
	{0.00000000173, 1.67113077977, 19004.64794940840},
	{0.00000000158, 5.98697230845, 3929.67725370800},
	{0.00000000126, 4.78413400650, 6148.01076995600},
	{0.00000000126, 4.40104234637, 11670.28403729680},
	{0.00000000133, 1.12155584770, 12839.87228870540},
	{0.00000000137, 5.81509659853, 6674.17861670160},
	{0.00000000149, 4.52388789068, 3077.52850332700},
	{0.00000000125, 1.44691455296, 36.02786667740},
	{0.00000000146, 2.09359464470, 3397.41568886960},
	{0.00000000146, 0.88857962035, 3283.80916453000},
	{0.00000000157, 3.39004226467, 3450.81874791920},
	{0.00000000154, 5.27624866771, 12168.00269657460},
	{0.00000000162, 5.99305553804, 5518.75014899180},
	{0.00000000126, 5.23539499383, 13553.89797291080},
	{0.00000000133, 6.26348452529, 3627.57478782039},
	{0.00000000124, 1.40431448992, 6593.91664885980},
	{0.00000000123, 1.97465918753, 1485.98012106520},
	{0.00000000125, 3.06728736345, 18606.49894600020},
	{0.00000000123, 2.92428130894, 15906.76412668260},
	{0.00000000146, 4.34004130421, 1478.86657406440},
	{0.00000000117, 2.48675823285, 3337.10656200300},
	{0.00000000117, 3.63700868579, 3344.11829139661},
	{0.00000000147, 2.64686332853, 6510.55198278040},
	{0.00000000119, 2.67568218000, 15265.88651930040},
	{0.00000000117, 5.66778031729, 3344.15279870100},
	{0.00000000117, 0.45598660135, 3337.07205469860},
	{0.00000000118, 5.77425794908, 9886.77220006400},
	{0.00000000154, 2.03792935277, 3133.91168940320},
	{0.00000000118, 0.07858750158, 3317.84393009040},
	{0.00000000118, 2.90358676347, 3363.38092330920},
	{0.00000000158, 3.42513552451, 0.98032106820},
	{0.00000000117, 2.63259162370, 3184.21170619740},
	{0.00000000117, 0.34958264135, 3497.01314720220},
	{0.00000000115, 3.42928363203, 6724.94376570460},
	{0.00000000114, 1.78485255818, 5820.91492464680},
	{0.00000000114, 1.36878094205, 9065.54812412880},
	{0.00000000124, 4.75081143126, 2631.62262442320},
	{0.00000000118, 2.00813775574, 4025.65648092580},
	{0.00000000135, 4.74860182927, 3603.69635007260},
	{0.00000000119, 0.46273681956, 16511.61386738740},
	{0.00000000155, 2.36780510491, 6155.05700665400},
	{0.00000000115, 4.80039490722, 6997.61672305620},
	{0.00000000119, 3.37046808379, 4447.75123238460},
	{0.00000000114, 3.09767238718, 3987.62326001460},
	{0.00000000110, 1.50396104090, 87.30820453981},
	{0.00000000138, 6.15843764702, 2233.47362101500},
	{0.00000000131, 0.53786654009, 6901.63749583840},
	{0.00000000112, 2.08380141682, 22345.26037610820},
	{0.00000000108, 4.30979711000, 2973.38809773740},
	{0.00000000115, 2.50244363406, 36.60536530420},
	{0.00000000111, 1.81433997961, 316.39186965660},
	{0.00000000130, 1.42012740400, 10213.28554621100},
	{0.00000000108, 5.05364311472, 19800.94595622480},
	{0.00000000111, 3.72624023806, 6357.71943674220},
	{0.00000000145, 0.99358639575, 2060.81785407180},
	{0.00000000112, 3.97083451330, 2574.81936225340},
	{0.00000000139, 0.94728626821, 3547.31316399640},
	{0.00000000122, 4.41872868475, 3346.46962899940},
	{0.00000000122, 4.84663088748, 3334.75522440020},
	{0.00000000140, 6.09857806608, 6670.58818804980},
	{0.00000000100, 2.58315361675, 17917.79715281959},
	{0.00000000106, 3.77034034448, 13745.34623902240},
	{0.00000000120, 2.98017967977, 3370.10424500320},
	{0.00000000120, 0.00199458528, 3311.12060839640},
	{0.00000000118, 2.40172384456, 6606.44325483230},
	{0.00000000132, 5.74618131270, 3050.12694723020},
	{0.00000000106, 5.77400557563, 2641.34127847220},
	{0.00000000096, 5.75684065935, 1118.75579210280},
	{0.00000000101, 3.76810604314, 10124.93005431800},
	{0.00000000104, 1.92319744263, 4296.90158267040},
	{0.00000000111, 1.28913302911, 10042.19259949820},
	{0.00000000094, 1.36125916148, 17468.85519794540},
	{0.00000000096, 4.84024975949, 10006.58480891440},
	{0.00000000094, 0.85293916684, 2679.37949991880},
	{0.00000000108, 1.41232833732, 3735.23831175900},
	{0.00000000092, 4.97009844077, 3707.83675566220},
	{0.00000000097, 3.70150649705, 2922.10810389280},
	{0.00000000109, 3.81691606800, 11250.79939342160},
	{0.00000000092, 6.04182543036, 2540.79130153440},
	{0.00000000126, 4.88607866833, 4271.97551355160},
	{0.00000000095, 0.10422807800, 59.37386191360},
	{0.00000000110, 5.54106438691, 4106.40549114620},
	{0.00000000115, 3.52051514601, 9815.65173166220},
	{0.00000000093, 3.71904554876, 2771.79055267240},
	{0.00000000100, 1.66203445799, 26887.36604973060},
	{0.00000000104, 2.35767081244, 11925.27409260060},
	{0.00000000113, 0.21883124871, 4922.57177498280},
	{0.00000000109, 4.06648304067, 21795.21409161479},
	{0.00000000094, 4.82179990259, 1272.68102562720},
	{0.00000000091, 4.41382868784, 4049.60222897640},
	{0.00000000086, 0.86878584025, 17654.78053974960},
	{0.00000000119, 3.51878936510, 3631.09790616940},
	{0.00000000117, 6.22334083160, 1905.46476494040},
	{0.00000000098, 2.27543509085, 6768.53305793940},
	{0.00000000095, 4.80180777978, 10706.88133432540},
	{0.00000000084, 0.40663774606, 3152.68727893721},
	{0.00000000093, 2.83658856377, 2538.24850425360},
	{0.00000000085, 1.40832176676, 16489.76303806100},
	{0.00000000094, 6.05010322728, 12942.96506292400},
	{0.00000000107, 1.79283820861, 6286.59896834040},
	{0.00000000081, 2.07730423259, 3326.38533269820},
	{0.00000000081, 0.90487003246, 3354.83952070140},
	{0.00000000082, 5.23339031416, 1442.26120876020},
	{0.00000000079, 4.56396980209, 18208.34994259200},
	{0.00000000079, 3.07988237612, 4777.78804089840},
	{0.00000000083, 5.56382700928, 3759.11674950680},
	{0.00000000085, 4.56854166929, 42942.50433914939},
	{0.00000000079, 4.26906442068, 3378.74546233760},
	{0.00000000079, 4.99629515155, 3302.47939106200},
	{0.00000000080, 6.17200069363, 4142.97634914600},
	{0.00000000079, 2.75167670672, 9947.05568153210},
	{0.00000000109, 5.81788706036, 765.79306444640},
	{0.00000000102, 4.48912094824, 10721.10842832700},
	{0.00000000106, 3.49629147004, 21947.11137270000},
	{0.00000000087, 0.74054571271, 3181.66890891660},
	{0.00000000092, 0.03551083643, 2171.02417529120},
	{0.00000000106, 0.39435918202, 7214.43893684320},
	{0.00000000080, 4.89623642688, 21548.96236929180},
	{0.00000000095, 3.86710302337, 1655.56030419820},
	{0.00000000079, 3.24890951492, 5562.46906129680},
	{0.00000000079, 0.57799144801, 1169.58825140860},
	{0.00000000090, 1.80974604093, 685.04405422600},
	{0.00000000077, 2.05069186337, 4001.84535348080},
	{0.00000000083, 2.81952591797, 18451.07854656599},
	{0.00000000103, 4.88584162251, 6279.55273164240},
	{0.00000000076, 3.67755551442, 1107.13880568480},
	{0.00000000075, 2.93994155162, 6710.65436193560},
	{0.00000000075, 5.60783359680, 3528.53757446240},
	{0.00000000100, 2.80459580595, 6653.82329730280},
	{0.00000000085, 4.61572252590, 3649.89074935560},
	{0.00000000085, 4.64963704633, 3031.33410404400},
	{0.00000000077, 5.54299564494, 3909.43430072720},
	{0.00000000102, 4.85789296676, 3282.73373069600},
	{0.00000000102, 4.40746660547, 3398.49112270360},
	{0.00000000079, 5.10886333624, 12725.45343477500},
	{0.00000000077, 0.97230677876, 20199.02764933019},
	{0.00000000073, 5.35302732038, 13369.56325380000},
	{0.00000000097, 1.78236800999, 6784.31762761820},
	{0.00000000076, 2.30483356242, 42153.96900304900},
	{0.00000000092, 2.49268078499, 3492.50970778500},
	{0.00000000076, 2.72692408287, 19403.77727388480},
	{0.00000000080, 4.32028390750, 8756.26980147300},
	{0.00000000073, 2.28908779860, 6364.83298374300},
	{0.00000000077, 2.43358799510, 6549.68289171320},
	{0.00000000088, 1.61112169044, 7373.38245462640},
	{0.00000000088, 6.05418512374, 11883.58313273480},
	{0.00000000076, 2.05515548312, 1648.44675719740},
	{0.00000000093, 3.37029033662, 10050.28646756720},
	{0.00000000069, 3.45210180674, 45088.66975562460},
	{0.00000000071, 1.53845739804, 2067.93140107260},
	{0.00000000069, 6.03997221898, 1279.79457262800},
	{0.00000000077, 1.09192682751, 14128.24277124560},
	{0.00000000077, 0.47271097966, 5466.48983407900},
	{0.00000000079, 1.37643636344, 3329.56672643590},
	{0.00000000079, 1.60573790161, 3351.65812696370},
	{0.00000000074, 4.22088803290, 25135.82651831460},
	{0.00000000073, 5.09768244843, 10177.19036923080},
	{0.00000000067, 4.84562417862, 5401.43028077160},
	{0.00000000074, 5.01417193973, 15636.56665630900},
	{0.00000000069, 5.04985271939, 11353.89216764020},
	{0.00000000070, 1.71545157762, 20809.46762464520},
	{0.00000000070, 3.89845786360, 35707.71008290740},
	{0.00000000076, 3.13060444340, 41748.05732892480},
	{0.00000000092, 6.14040930433, 3613.28538405140},
	{0.00000000093, 2.21933485500, 8584.66166590080},
	{0.00000000068, 3.93351376319, 25287.72379939980},
	{0.00000000066, 5.64046802071, 2011.10033643980},
	{0.00000000088, 3.09948179111, 3067.93946934820},
	{0.00000000074, 2.14829362492, 3264.34635542420},
	{0.00000000065, 5.23756710566, 8859.36257569160},
	{0.00000000069, 1.59516547033, 43738.80234596580},
	{0.00000000068, 4.77227301127, 44959.54767599020},
	{0.00000000065, 0.76344895489, 6708.62640949640},
	{0.00000000090, 5.15547486786, 6740.59871531320},
	{0.00000000064, 4.35344254893, 9801.42463766060},
	{0.00000000065, 0.10650340635, 4140.43355186520},
	{0.00000000079, 0.61232080062, 2125.81009707640},
	{0.00000000087, 5.05289595532, 9859.37064396720},
	{0.00000000065, 0.93949119244, 6680.80477730600},
	{0.00000000064, 1.91199168938, 4356.27544458400},
	{0.00000000064, 2.03767686794, 169.58018313300},
	{0.00000000067, 3.96144093290, 11236.57229942000},
	{0.00000000066, 1.08249803836, 3414.21338261500},
	{0.00000000066, 1.89967622669, 3267.01147078460},
	{0.00000000072, 1.91502043985, 16858.41522263039},
	{0.00000000064, 0.70379327004, 3193.80074017620},
	{0.00000000064, 2.27838099501, 3487.42411322340},
	{0.00000000084, 3.00203948568, 43340.65334255760},
	{0.00000000062, 3.24790025898, 18461.71521191579},
	{0.00000000068, 4.85546258492, 12808.88030395680},
	{0.00000000068, 1.99986373490, 6614.73744448520},
	{0.00000000085, 3.13403835930, 10730.82708237599},
	{0.00000000066, 0.00739681430, 9997.95884235160},
	{0.00000000065, 6.00702384673, 40796.33892267419},
	{0.00000000060, 1.33665515740, 31022.75317085620},
	{0.00000000078, 4.87574960971, 5202.35827933520},
	{0.00000000062, 2.19007422012, 20040.15144184979},
	{0.00000000062, 4.40813798952, 931.36308685180},
	{0.00000000067, 3.79488721755, 17256.63153634140},
	{0.00000000063, 4.58199428968, 25841.29320224219},
	{0.00000000083, 1.19841622691, 40398.18991926600},
	{0.00000000059, 3.38669312921, 15121.10278521600},
	{0.00000000063, 1.57226486603, 20742.94570842640},
	{0.00000000060, 5.59502027006, 10016.31435579200},
	{0.00000000059, 1.02843579673, 4039.88357492740},
	{0.00000000077, 3.19342928141, 24606.13555322000},
	{0.00000000067, 4.66236805003, 9329.67967887260},
	{0.00000000077, 3.07641411027, 4775.76008845920},
	{0.00000000064, 0.87689051214, 22743.40937951640},
	{0.00000000080, 2.57223661352, 27417.05701482520},
	{0.00000000057, 0.14845243910, 12928.73796892240},
	{0.00000000057, 6.14189596874, 3116.26763099790},
	{0.00000000072, 0.71597283003, 20213.25474333179},
	{0.00000000062, 1.28366951998, 12988.11183083600},
	{0.00000000059, 1.99226268966, 5945.34833986780},
	{0.00000000058, 0.15519898436, 15423.26756087100},
	{0.00000000063, 2.24244167800, 9161.52735134660},
	{0.00000000062, 2.96487774215, 3357.44462774959},
	{0.00000000062, 0.01729652290, 3323.78022565000},
	{0.00000000056, 3.18297061340, 2978.49128996900},
	{0.00000000056, 6.08238895883, 3702.73356343060},
	{0.00000000058, 0.08427617394, 45884.96776244100},
	{0.00000000055, 0.16321552353, 21150.81336588360},
	{0.00000000055, 5.55880158727, 12715.43887348440},
	{0.00000000055, 4.28741629288, 23539.70738633280},
	{0.00000000068, 4.10576652903, 14867.73751589219},
	{0.00000000054, 1.14764721709, 5607.61582920880},
	{0.00000000053, 4.66773371614, 6788.88837733820},
	{0.00000000058, 1.79522116123, 3412.66816005460},
	{0.00000000058, 1.18695310382, 3268.55669334500},
	{0.00000000053, 3.76957096107, 14481.20549890200},
	{0.00000000052, 4.72089853524, 6812.76681508600},
	{0.00000000054, 1.09546286956, 18849.22754997420},
	{0.00000000059, 0.84746741291, 5223.69391980220},
	{0.00000000052, 1.21145236574, 4885.96640967860},
	{0.00000000072, 2.61949743639, 3339.12795399150},
	{0.00000000072, 0.36267682866, 3342.09689940810},
	{0.00000000051, 1.67605837812, 45486.81875903279},
	{0.00000000056, 3.58453638929, 8742.04270747140},
	{0.00000000051, 0.67722361596, 16328.72425753579},
	{0.00000000056, 3.08675956518, 38252.02450279080},
	{0.00000000051, 6.16661497571, 12410.73130054860},
	{0.00000000051, 2.81432959139, 8226.57883637840},
	{0.00000000054, 3.63357334815, 2735.76268599500},
	{0.00000000050, 4.57016485329, 37895.42629036740},
	{0.00000000052, 0.45515480683, 24491.42579258340},
	{0.00000000061, 4.37761588455, 2655.50106217100},
	{0.00000000059, 5.82888387525, 12516.36687204800},
	{0.00000000050, 1.66655026369, 1727.66109366820},
	{0.00000000066, 5.34326577091, 24889.57479599160},
	{0.00000000050, 0.17458517639, 39048.32250960720},
	{0.00000000050, 3.27629040044, 3564.95722240170},
	{0.00000000054, 1.32205785496, 20426.57109242200},
	{0.00000000049, 2.48409394399, 20597.24396304120},
	{0.00000000049, 4.63364250237, 24341.52831745660},
	{0.00000000050, 3.76507954507, 3742.28454845700},
	{0.00000000048, 1.55434770619, 1883.08149310240},
	{0.00000000049, 3.03989562226, 55516.41870984820},
	{0.00000000061, 3.94494596275, 19617.07636932279},
	{0.00000000048, 1.52458359680, 19190.47817844680},
	{0.00000000058, 5.44186494913, 6850.80503653260},
	{0.00000000048, 1.96356727887, 32765.24665961580},
	{0.00000000047, 2.93243058228, 33163.39566302400},
	{0.00000000048, 4.86897928188, 10191.41746323240},
	{0.00000000051, 4.70671034765, 5749.86176654780},
	{0.00000000048, 3.54075354094, 8186.51266249260},
	{0.00000000056, 3.12983717848, 21265.52312652020},
	{0.00000000047, 0.77055080600, 11876.46958573400},
	{0.00000000047, 5.80552800681, 2257.35205876280},
	{0.00000000047, 0.45636881038, 17412.05193577560},
	{0.00000000046, 4.54640434990, 16865.52876963120},
	{0.00000000052, 0.28783495350, 1971.95217385480},
	{0.00000000046, 1.52797216731, 44768.09940987860},
	{0.00000000051, 4.39123984507, 5408.54382777240},
	{0.00000000064, 3.04718021414, 1329.51209026000},
	{0.00000000049, 4.82698586048, 41194.48792608240},
	{0.00000000046, 0.27726411537, 1795.25844372100},
	{0.00000000055, 4.04641676667, 4403.51747523800},
	{0.00000000048, 0.33955507055, 14955.04572043200},
	{0.00000000059, 2.13527332496, 4289.78803566960},
	{0.00000000048, 1.20681354241, 7799.98064550240},
	{0.00000000048, 0.93062224202, 1859.20305535460},
	{0.00000000052, 2.17634391560, 2963.23881878400},
	{0.00000000052, 0.80583034945, 3717.98603461560},
	{0.00000000055, 5.22964407608, 41236.03871706720},
	{0.00000000060, 5.46859138107, 10184.30391623160},
	{0.00000000054, 1.04311727476, 1055.85881184020},
	{0.00000000045, 3.15304645241, 3973.39616601300},
	{0.00000000046, 0.11011885467, 5881.40372823420},
	{0.00000000044, 5.80928344240, 3436.59165391760},
	{0.00000000044, 3.45607612983, 3244.63319948200},
	{0.00000000045, 4.67010491199, 1265.56747862640},
	{0.00000000044, 6.06741551089, 17499.36014031540},
	{0.00000000045, 2.74401480845, 16063.16484718500},
	{0.00000000043, 5.89567366882, 97670.38771289718},
	{0.00000000059, 5.12096194189, 2523.95910048460},
	{0.00000000053, 0.56190542057, 8336.78515759780},
	{0.00000000046, 1.93691391876, 48827.43118573260},
	{0.00000000043, 5.31424179395, 12199.97500239140},
	{0.00000000045, 1.21490188964, 15849.86575174700},
	{0.00000000054, 4.78336772882, 46283.11676584919},
	{0.00000000046, 1.35241852548, 9175.75444534820},
	{0.00000000042, 5.91236045456, 12729.66596748600},
	{0.00000000043, 1.90861231305, 8123.48606215980},
	{0.00000000046, 1.99777333547, 2324.94940881560},
	{0.00000000043, 0.22627419016, 3826.58447948940},
	{0.00000000043, 2.75590007489, 2854.64037391020},
	{0.00000000042, 3.52116061372, 15106.87569121440},
	{0.00000000042, 0.81055569531, 2651.97794382200},
	{0.00000000048, 1.95445508213, 12825.64519470380},
	{0.00000000052, 5.96852999978, 6666.99775939800},
	{0.00000000041, 5.80749281310, 28230.18722269139},
	{0.00000000041, 0.71986367040, 3385.26625994000},
	{0.00000000041, 2.26231059465, 3295.95859345960},
	{0.00000000043, 3.41912327203, 46681.26576925740},
	{0.00000000040, 1.93891342372, 20728.71861442479},
	{0.00000000044, 0.93617830235, 29698.28751133580},
	{0.00000000052, 4.86200797685, 3382.16321768460},
	{0.00000000052, 4.40335159538, 3299.06163571500},
	{0.00000000041, 3.51246679511, 4670.12451695980},
	{0.00000000055, 4.06333971351, 11527.12508919240},
	{0.00000000046, 3.58080161750, 19247.37655338240},
	{0.00000000049, 3.97694940593, 17660.30346405700},
	{0.00000000039, 3.67004654616, 742.99006053260},
	{0.00000000041, 5.43088708578, 14469.58851248400},
	{0.00000000049, 4.88920858356, 4025.72379122860},
	{0.00000000052, 4.89208735007, 1854.63230563460},
	{0.00000000040, 0.34615539895, 22487.37169284160},
	{0.00000000039, 4.73492562151, 36105.85908631560},
	{0.00000000048, 5.93890351626, 17810.20093918380},
	{0.00000000052, 2.35533747956, 1461.05405194640},
	{0.00000000045, 1.15223938219, 3966.28261901220},
	{0.00000000045, 1.82993488286, 2714.94223438740},
	{0.00000000039, 3.39974448088, 2714.98729050260},
	{0.00000000038, 0.95007899496, 3017.10701004240},
	{0.00000000041, 0.93833632650, 29580.05463235019},
	{0.00000000040, 5.63094433725, 3945.46216740460},
	{0.00000000039, 1.83440091550, 5511.63660199100},
	{0.00000000038, 0.92745494032, 19683.56377823720},
	{0.00000000037, 2.01049423891, 24093.27678917520},
	{0.00000000037, 3.25942117402, 34115.11406927460},
	{0.00000000038, 3.03103285294, 1484.93248969420},
	{0.00000000036, 4.01044559220, 2089.78223039900},
	{0.00000000048, 4.51776273502, 3337.02199804800},
	{0.00000000050, 3.78005099607, 526.16784674560},
	{0.00000000037, 5.37456678141, 9384.84100807520},
	{0.00000000049, 1.45163270526, 19406.67828817460},
	{0.00000000041, 4.75007748416, 7788.36365908440},
	{0.00000000049, 0.82675139376, 10787.63034454580},
	{0.00000000036, 2.23324188355, 3762.63986785580},
	{0.00000000036, 0.74893238150, 2918.58498554380},
	{0.00000000046, 4.61984768217, 33716.96506586640},
	{0.00000000036, 2.78855553852, 4555.41475632320},
	{0.00000000035, 5.14747937595, 38086.87455647900},
	{0.00000000046, 0.18369837651, 12995.22537783680},
	{0.00000000039, 4.40871687727, 3337.15661865360},
	{0.00000000039, 1.71505004137, 3344.06823474600},
	{0.00000000035, 2.98972560975, 1685.05212250160},
	{0.00000000042, 2.75958322656, 20235.12282631040},
	{0.00000000038, 0.87453118322, 3070.48226662900},
	{0.00000000038, 2.10764308183, 3610.74258677060},
	{0.00000000035, 0.28028637947, 4716.38622654560},
	{0.00000000036, 3.71936683570, 6644.61948809540},
	{0.00000000034, 0.98572990463, 7483.58877584580},
	{0.00000000034, 2.54855926411, 17013.90293236740},
	{0.00000000035, 4.67041494149, 15010.89646399660},
	{0.00000000039, 3.55482379885, 11567.19126307820},
	{0.00000000034, 2.21874368771, 35066.83247552520},
	{0.00000000034, 3.41493668202, 13355.33615979840},
	{0.00000000035, 2.19172942691, 24076.44458812540},
	{0.00000000038, 2.60968429334, 38407.44490222499},
	{0.00000000034, 6.10754117263, 3370.49447031000},
	{0.00000000034, 3.15781839960, 3310.73038308960},
	{0.00000000034, 3.37432102293, 35863.13048234160},
	{0.00000000034, 2.23479435038, 27433.88921587499},
	{0.00000000033, 0.02993950047, 12502.13977804640},
	{0.00000000036, 2.64058681926, 12082.65513417120},
	{0.00000000034, 1.60125162195, 16702.99482319620},
	{0.00000000033, 4.31458198768, 14164.81362924540},
	{0.00000000033, 1.25769705892, 3723.49170527080},
	{0.00000000033, 1.72447720613, 2957.73314812880},
	{0.00000000045, 4.14510215726, 4157.26575291499},
	{0.00000000036, 2.71350040422, 25685.87280280800},
	{0.00000000033, 1.50589018147, 7447.01791784600},
	{0.00000000041, 3.99160574782, 13532.02988993220},
	{0.00000000032, 3.45719416276, 4423.87279463680},
	{0.00000000035, 1.62135425259, 36261.27948574980},
	{0.00000000032, 4.56663489191, 1197.97012857360},
	{0.00000000032, 2.17440447339, 4029.24690957760},
	{0.00000000035, 0.39535447916, 16335.83780453660},
	{0.00000000033, 4.72062621160, 48300.16010269000},
	{0.00000000034, 5.01181553881, 8329.67161059700},
	{0.00000000042, 3.79728412833, 12979.55317457600},
	{0.00000000031, 3.59075365022, 3101.40694107480},
	{0.00000000031, 5.67460592201, 3579.81791232480},
	{0.00000000043, 0.82862094100, 27832.03821928320},
	{0.00000000034, 4.39751248435, 41349.90832551659},
	{0.00000000043, 5.43675272730, 13524.91634293140},
	{0.00000000031, 2.07097435521, 13605.17831077320},
	{0.00000000037, 2.07977700827, 39601.89191244960},
	{0.00000000035, 4.56839370692, 21393.54196985760},
	{0.00000000033, 0.82205966845, 31405.64970307940},
	{0.00000000039, 2.12497217177, 27490.69247804480},
	{0.00000000030, 3.44459112109, 32769.12799497380},
	{0.00000000034, 2.17000850508, 17932.02424682120},
	{0.00000000035, 5.88545521905, 8013.27974094040},
	{0.00000000030, 0.12554648686, 9918.74450588080},
	{0.00000000030, 2.43888170119, 14577.18472611980},
	{0.00000000040, 0.81846047046, 25827.98411954140},
	{0.00000000031, 4.29031124486, 16872.64231663200},
	{0.00000000029, 5.30776430092, 51371.74560561599},
	{0.00000000032, 3.68482314695, 37455.72649597440},
	{0.00000000031, 5.07041841878, 20995.39296644940},
	{0.00000000039, 0.37839660841, 49225.58018914080},
	{0.00000000040, 4.64409927989, 3524.48201360179},
	{0.00000000040, 4.62126029234, 3156.74283979780},
	{0.00000000029, 4.08340266458, 13002.33892483760},
	{0.00000000030, 5.88423372643, 3966.23756289700},
	{0.00000000029, 3.75228066304, 27035.74021246680},
	{0.00000000031, 3.28649465397, 9072.66167112960},
	{0.00000000034, 4.02588507696, 39203.74290904139},
	{0.00000000031, 2.79021094717, 6836.57794253100},
	{0.00000000031, 2.80265827190, 32522.51805564180},
	{0.00000000030, 5.02614281951, 48031.13317891620},
	{0.00000000035, 5.83659262134, 52175.80628314840},
	{0.00000000030, 2.21054451262, 17232.75309859360},
	{0.00000000029, 4.31668048941, 13517.80279593060},
	{0.00000000036, 4.88412474614, 13673.29050566760},
	{0.00000000029, 4.73853919399, 20206.14119633100},
	{0.00000000038, 4.73546246413, 44690.52075221639},
	{0.00000000028, 1.14267246129, 4953.56375973140},
	{0.00000000028, 4.59940622354, 27682.14074415640},
	{0.00000000037, 1.43444323103, 20752.66436247540},
	{0.00000000029, 2.04719144598, 4822.02179804500},
	{0.00000000032, 4.95467699991, 4503.08713110760},
	{0.00000000035, 6.09811364462, 5351.71276313960},
	{0.00000000028, 1.88347587403, 5835.14201864840},
	{0.00000000032, 4.75015473737, 33561.54466643220},
	{0.00000000028, 4.73177992569, 21000.91589075680},
	{0.00000000032, 1.13197722780, 6830.78805053420},
	{0.00000000028, 1.79662683475, 38813.35657634920},
	{0.00000000035, 3.61429802237, 3303.61683608880},
	{0.00000000035, 5.65106154986, 3377.60801731080},
	{0.00000000028, 5.46343987576, 3348.37509741580},
	{0.00000000028, 3.80191969647, 3332.84975598380},
	{0.00000000029, 1.90513835738, 41990.78593289880},
	{0.00000000028, 5.47234972246, 7345.98089852960},
	{0.00000000030, 4.27109031036, 30376.35263916660},
	{0.00000000031, 0.45001645109, 23937.85638974100},
	{0.00000000032, 0.28043081427, 36659.42848915800},
	{0.00000000027, 2.52697440495, 7534.42123515160},
	{0.00000000028, 2.02156853747, 3517.30615683360},
	{0.00000000028, 0.96060572758, 3163.91869656600},
	{0, 0, 0}
};

struct vsop87_term mars_x2[] = {
	{0.00056323939, 0.00000000000, 0.00000000000},
	{0.00022122528, 3.54372113272, 6681.22485339960},
	{0.00006091409, 3.93272649649, 10021.83728009940},
	{0.00001451998, 3.64655666460, 3340.61242669980},
	{0.00001130613, 4.28827023222, 13362.44970679920},
	{0.00000182610, 4.63522660125, 16703.06213349900},
	{0.00000168904, 4.68797825494, 3344.13554504880},
	{0.00000168384, 4.57974326642, 3337.08930835080},
	{0.00000094103, 0.94931392640, 3185.19202726560},
	{0.00000089578, 2.03782745090, 3496.03282613400},
	{0.00000040689, 5.03331696992, 6684.74797174860},
	{0.00000036711, 1.77362889167, 1059.38193018920},
	{0.00000027549, 4.97859663329, 20043.67456019880},
	{0.00000024699, 3.63560534183, 3149.16416058820},
	{0.00000023325, 5.63009151781, 3532.06069281140},
	{0.00000024321, 5.77247656014, 2544.31441988340},
	{0.00000020394, 3.48794506814, 4136.91043351620},
	{0.00000018400, 3.45575979446, 3097.88382272579},
	{0.00000017395, 4.34131723760, 2942.46342329160},
	{0.00000016954, 5.82560293948, 3583.34103067380},
	{0.00000015902, 1.21784323807, 5621.84292321040},
	{0.00000015422, 4.94008572158, 3738.76143010800},
	{0.00000016238, 1.67605938145, 1194.44701022460},
	{0.00000013282, 5.16082361704, 1990.74501704100},
	{0.00000016878, 2.35542567714, 2787.04302385740},
	{0.00000012675, 3.75990218127, 2388.89402044920},
	{0.00000011826, 3.08038008170, 796.29800681640},
	{0.00000015232, 0.27850117251, 1592.59601363280},
	{0.00000012328, 2.14974361562, 3341.59274776800},
	{0.00000011303, 1.30198187106, 6525.80445396540},
	{0.00000012311, 0.83471101077, 3339.63210563160},
	{0.00000013670, 2.56874755004, 155.42039943420},
	{0.00000010589, 2.17033819409, 4399.99435688900},
	{0.00000014260, 0.66247586522, 3894.18182954220},
	{0.00000009461, 5.56716533452, 4292.33083295040},
	{0.00000008649, 4.16531779363, 4690.47983635860},
	{0.00000011404, 0.98319348386, 2146.16541647520},
	{0.00000008129, 5.35446918646, 10025.36039844840},
	{0.00000007991, 1.31255637184, 5486.77784317500},
	{0.00000008339, 1.24221111371, 2957.71589447660},
	{0.00000007581, 2.30465249120, 1589.07289528380},
	{0.00000007544, 1.76180463973, 3723.50895892300},
	{0.00000008875, 2.08456580754, 4535.05943692440},
	{0.00000008569, 2.73774413655, 5088.62883976680},
	{0.00000006135, 5.37763512493, 7079.37385680780},
	{0.00000006874, 2.67519964091, 1748.01641306700},
	{0.00000006049, 1.12213947386, 553.56940284240},
	{0.00000005340, 5.92227683481, 951.71840625060},
	{0.00000005445, 5.43458926991, 242.72860397400},
	{0.00000005288, 6.18849260834, 5884.92684658320},
	{0.00000005585, 4.35867442726, 1349.86740965880},
	{0.00000005880, 5.02337312439, 7.11354700080},
	{0.00000005051, 2.18016149522, 2274.11694950980},
	{0.00000004770, 0.36305129741, 3333.49887969900},
	{0.00000005307, 4.06785486332, 6489.77658728800},
	{0.00000004333, 0.67828219297, 4933.20844033260},
	{0.00000004470, 4.63122002595, 2288.34404351140},
	{0.00000004148, 2.67721083071, 3347.72597370060},
	{0.00000003987, 5.31786407967, 23384.28698689860},
	{0.00000003806, 0.70901266883, 5092.15195811580},
	{0.00000003796, 4.08302538124, 3870.30339179440},
	{0.00000004621, 3.86854740775, 7477.52286021600},
	{0.00000003278, 2.34853927305, 426.59819087600},
	{0.00000003200, 3.85010217010, 6438.49624942560},
	{0.00000002521, 5.54898285357, 5331.35744374080},
	{0.00000002884, 2.21782307080, 382.89653222320},
	{0.00000002413, 2.12409000894, 6836.64525283380},
	{0.00000002207, 5.89775318087, 9492.14631500480},
	{0.00000002187, 2.71871082697, 6127.65545055720},
	{0.00000002008, 2.54296252495, 6682.20517446780},
	{0.00000002221, 4.91976640295, 6677.70173505060},
	{0.00000001902, 2.46234315280, 4929.68532198360},
	{0.00000001953, 6.12037277662, 191.44826611160},
	{0.00000002413, 1.00871676783, 639.89728631400},
	{0.00000002001, 5.03378923195, 529.69096509460},
	{0.00000001728, 4.75687645108, 3553.91152213780},
	{0.00000001979, 0.95853558190, 6681.20759974740},
	{0.00000001979, 2.98858272913, 6681.24210705180},
	{0.00000002141, 2.54328094713, 7740.60678358880},
	{0.00000001573, 4.50508275022, 3127.31333126180},
	{0.00000001631, 2.45741148102, 7875.67186362420},
	{0.00000001962, 6.17211726959, 6923.95345737360},
	{0.00000001572, 1.33560962556, 8969.56889691100},
	{0.00000001543, 2.83169859596, 2118.76386037840},
	{0.00000001559, 5.18172013638, 8955.34180290940},
	{0.00000001881, 4.13165877159, 5729.50644714900},
	{0.00000001727, 4.42641584826, 6674.11130639880},
	{0.00000001676, 5.72375329917, 2810.92146160520},
	{0.00000001464, 5.67833036033, 13365.97282514820},
	{0.00000001275, 4.01216375228, 640.87760738220},
	{0.00000001483, 1.65051486293, 9866.41688066520},
	{0.00000001159, 1.60356675965, 6298.32832117640},
	{0.00000001157, 0.66416438123, 6254.62666252360},
	{0.00000001402, 4.97495321039, 2699.73481931760},
	{0.00000001138, 0.03863142059, 12832.75874170460},
	{0.00000001484, 5.76685527102, 10419.98628350760},
	{0.00000001215, 2.93903722849, 3767.21061757580},
	{0.00000001077, 2.14986202491, 12303.06777661000},
	{0.00000000882, 2.07935042219, 1751.53953141600},
	{0.00000001105, 5.02445488391, 7210.91581849420},
	{0.00000000990, 4.46834463877, 9830.38901398780},
	{0.00000000950, 0.25861778749, 4562.46099302120},
	{0.00000000877, 4.22488301555, 10818.13528691580},
	{0.00000000851, 1.35694652573, 2281.23049651060},
	{0.00000001036, 4.41287380431, 3981.49003408200},
	{0.00000000757, 5.33473650413, 9623.68827669120},
	{0.00000000821, 3.38181893763, 10021.85453375160},
	{0.00000000734, 0.75626361104, 10018.31416175040},
	{0.00000000821, 1.35115496598, 10021.82002644720},
	{0.00000000723, 6.19867522224, 853.19638175200},
	{0.00000000685, 1.03149651000, 8273.82086703240},
	{0.00000000814, 4.08251134670, 6151.53388830500},
	{0.00000000646, 5.31818662100, 6681.15754309680},
	{0.00000000651, 2.20345414604, 398.14900340820},
	{0.00000000633, 5.38632263801, 6040.34724601740},
	{0.00000000842, 3.04071354856, 6688.33840040040},
	{0.00000000812, 1.96701783661, 6041.32756708560},
	{0.00000000641, 4.90029509996, 6681.29216370240},
	{0.00000000570, 2.58703838149, 15643.68020330980},
	{0.00000000717, 3.64604387479, 3178.14579056760},
	{0.00000000662, 5.29879326411, 6894.52394883760},
	{0.00000000545, 4.98617588325, 2766.26762836500},
	{0.00000000673, 5.61896089419, 3503.07906283200},
	{0.00000000617, 2.56762538604, 3253.30422216000},
	{0.00000000596, 0.41458038468, 3427.92063123960},
	{0.00000000487, 4.38031296303, 3914.95722503460},
	{0.00000000477, 4.13956608042, 7234.79425624200},
	{0.00000000442, 2.68822569790, 7632.94325965020},
	{0.00000000545, 1.03912974763, 6680.24453233140},
	{0.00000000410, 1.58251527013, 3980.50971301380},
	{0.00000000561, 5.66150369412, 26724.89941359840},
	{0.00000000411, 5.74366010527, 12964.30070339100},
	{0.00000000395, 6.12652819236, 2700.71514038580},
	{0.00000000425, 3.27320432841, 2648.45482547300},
	{0.00000000495, 6.06448586655, 2914.01423582380},
	{0.00000000493, 2.58878000047, 1039.02661079040},
	{0.00000000367, 0.62535956369, 8962.45534991020},
	{0.00000000369, 2.74592799154, 8270.29774868340},
	{0.00000000380, 2.89275122673, 11081.21921028860},
	{0.00000000372, 5.87272930494, 4032.77002792660},
	{0.00000000338, 5.22015252880, 8432.76438481560},
	{0.00000000371, 5.28554270239, 7064.12138562280},
	{0.00000000305, 4.77209265653, 574.34479833480},
	{0.00000000300, 2.85385783473, 5459.37628707820},
	{0.00000000306, 4.36534167614, 6872.67311951120},
	{0.00000000326, 2.91789777501, 10022.81760116760},
	{0.00000000280, 2.83230906425, 11216.28429032400},
	{0.00000000333, 0.28199543333, 2301.58581590939},
	{0.00000000283, 6.13788451705, 13760.59871020740},
	{0.00000000272, 5.85293220428, 10551.52824519400},
	{0.00000000358, 5.91039820815, 8671.96987044060},
	{0.00000000278, 3.16173504794, 5828.02847164760},
	{0.00000000268, 5.30012147929, 10021.90459040220},
	{0.00000000263, 3.04875074455, 9468.26787725700},
	{0.00000000341, 1.55199717015, 8031.09226305840},
	{0.00000000315, 0.38937613087, 16173.37116840440},
	{0.00000000268, 0.82005853572, 2487.41604494780},
	{0.00000000242, 0.66542784607, 13358.92658845020},
	{0.00000000251, 4.82083845476, 1066.49547719000},
	{0.00000000318, 2.39959337988, 213.29909543800},
	{0.00000000245, 0.65336059003, 8429.24126646660},
	{0.00000000267, 5.70853737597, 10021.76996979660},
	{0.00000000246, 0.23564126000, 10264.56588407340},
	{0.00000000260, 0.59900554651, 5642.19824260920},
	{0.00000000285, 1.73071428119, 12310.18132361080},
	{0.00000000289, 4.38737249371, 9779.10867612540},
	{0.00000000266, 2.96358399628, 18984.29263000960},
	{0.00000000209, 1.26589578723, 5614.72937620960},
	{0.00000000199, 3.73362043961, 13362.46696045140},
	{0.00000000199, 1.70289925386, 13362.43245314700},
	{0.00000000239, 6.00441886993, 16706.58525184800},
	{0.00000000252, 3.28817243007, 6283.07584999140},
	{0.00000000212, 3.41540373108, 7107.82304427560},
	{0.00000000193, 4.43872802342, 9070.11887384880},
	{0.00000000175, 2.59247166948, 9381.93999378540},
	{0.00000000172, 4.84769425281, 13171.00144068760},
	{0.00000000196, 1.99723494678, 13207.02930736500},
	{0.00000000167, 1.99111732387, 1052.26838318840},
	{0.00000000177, 1.94927710769, 9638.94074787620},
	{0.00000000170, 2.99514353373, 4379.63903749020},
	{0.00000000157, 0.16247582139, 8827.39026987480},
	{0.00000000155, 5.48638933162, 12295.95422960920},
	{0.00000000205, 2.22623702131, 1221.84856632140},
	{0.00000000148, 5.75360559500, 10235.13637553740},
	{0.00000000141, 3.42339195893, 10028.95082710020},
	{0.00000000139, 1.20065333201, 1437.17561419860},
	{0.00000000131, 1.82249875902, 3029.77162783140},
	{0.00000000134, 1.93761929722, 1903.43681250120},
	{0.00000000140, 3.87848331743, 10575.40668294180},
	{0.00000000118, 5.24296149967, 149.56319713460},
	{0.00000000116, 1.15955870554, 3651.45322556820},
	{0.00000000121, 2.84740298536, 10973.55568635000},
	{0.00000000129, 3.90779149886, 6696.47732458460},
	{0.00000000117, 5.84379077675, 6701.58017279840},
	{0.00000000119, 3.78788917836, 9168.64089834740},
	{0.00000000107, 5.14404131798, 4407.10790388980},
	{0.00000000114, 4.75737830221, 7322.10246078180},
	{0.00000000104, 3.13487730948, 6665.97238221460},
	{0.00000000105, 1.90361221217, 11371.70468975820},
	{0.00000000101, 4.46463007865, 14158.74771361560},
	{0.00000000131, 1.19699573376, 6660.86953400080},
	{0.00000000114, 3.72019854011, 6518.75821726740},
	{0.00000000108, 2.10333523773, 5244.04923920100},
	{0.00000000095, 0.30620246397, 6816.28993343500},
	{0.00000000101, 6.03126082039, 11769.85369316640},
	{0.00000000101, 2.84466352346, 11773.37681151540},
	{0.00000000088, 6.06292314661, 1835.32461760680},
	{0.00000000090, 5.51420018615, 17256.63153634140},
	{0.00000000092, 4.73502476982, 10014.72373309860},
	{0.00000000083, 3.76185545661, 1505.28780909299},
	{0.00000000082, 3.24275708402, 6467.92575796160},
	{0.00000000078, 5.60819903790, 10404.73381232260},
	{0.00000000096, 6.09589552170, 16304.91313009080},
	{0.00000000094, 5.30244568575, 9808.53818466140},
	{0.00000000085, 0.45449951855, 4193.80880845180},
	{0.00000000073, 0.88325190137, 6660.44945790720},
	{0.00000000091, 1.87876020582, 25287.72379939980},
	{0.00000000093, 6.03033210386, 20752.66436247540},
	{0.00000000071, 2.10260204323, 15113.98923821520},
	{0.00000000066, 2.12551225679, 30376.35263916660},
	{0.00000000067, 2.69564372543, 692.15760122680},
	{0.00000000069, 6.00365908535, 30065.51184029820},
	{0.00000000065, 5.49865044582, 17412.05193577560},
	{0.00000000076, 0.17812622824, 9380.95967271720},
	{0.00000000072, 1.80564509293, 27035.74021246680},
	{0.00000000063, 4.77495740709, 13517.87010623340},
	{0.00000000065, 3.24454700037, 2631.62262442320},
	{0.00000000065, 1.04135638320, 20199.09495963300},
	{0.00000000061, 1.62141559661, 12935.85151592320},
	{0.00000000063, 5.65699508407, 13362.51701710200},
	{0.00000000080, 2.35381700251, 21795.21409161479},
	{0.00000000064, 0.76110443806, 6768.53305793940},
	{0.00000000073, 1.22356246246, 14712.31711645800},
	{0.00000000062, 3.23287490977, 5989.06725217280},
	{0.00000000057, 0.75475068767, 16699.53901514999},
	{0.00000000071, 5.54884103647, 14128.24277124560},
	{0.00000000056, 3.23324962674, 11128.97608578420},
	{0.00000000052, 4.10828089558, 11243.68584642080},
	{0.00000000068, 3.30032043676, 3340.62968035200},
	{0.00000000067, 4.65098163449, 2233.47362101500},
	{0.00000000064, 5.71360304099, 13119.72110282519},
	{0.00000000068, 1.26993098899, 3340.59517304760},
	{0.00000000049, 3.23999076412, 14421.83163698840},
	{0.00000000050, 2.88028372970, 6593.91664885980},
	{0.00000000065, 5.34149579962, 6106.88005506480},
	{0.00000000048, 3.22386624541, 10177.25767953360},
	{0.00000000050, 6.02031448574, 4049.60222897640},
	{0.00000000063, 4.41039120987, 22743.40937951640},
	{0.00000000051, 1.08977299741, 12721.57209941700},
	{0.00000000056, 5.66089176987, 9499.25986200560},
	{0.00000000049, 1.47188446727, 14584.29827312060},
	{0.00000000056, 6.06513078770, 13362.38239649640},
	{0.00000000046, 5.89343604493, 13149.15061136120},
	{0.00000000051, 0.76284557905, 19513.98359510420},
	{0.00000000047, 2.03226039424, 7321.12213971360},
	{0.00000000047, 1.30702855110, 21265.52312652020},
	{0.00000000047, 2.87487572007, 23141.55838292460},
	{0.00000000043, 3.08890328263, 8799.98871377800},
	{0.00000000043, 2.18897814596, 6684.81528205140},
	{0.00000000042, 6.24718113814, 9485.03276800400},
	{0.00000000043, 2.56622033374, 6705.10329114740},
	{0.00000000045, 5.21894773261, 6843.69148953180},
	{0.00000000053, 0.96281646589, 8425.65083781480},
	{0.00000000049, 2.87124368812, 4845.90023579280},
	{0.00000000053, 5.33119034498, 7903.07341972100},
	{0.00000000041, 0.09690752852, 16460.33352952499},
	{0.00000000056, 3.04529553480, 6702.00024889200},
	{0.00000000040, 0.61605943900, 14054.60730802600},
	{0.00000000043, 1.52605536241, 6709.67404086740},
	{0.00000000043, 1.75785472218, 6677.63442474780},
	{0.00000000050, 0.16634326697, 13892.14067189380},
	{0.00000000039, 3.68543277913, 13553.89797291080},
	{0.00000000045, 3.41167094956, 28230.18722269139},
	{0.00000000052, 1.41393169635, 16062.18452611680},
	{0.00000000049, 4.48594234475, 6657.34641565180},
	{0.00000000038, 4.01715778747, 6531.66165626500},
	{0.00000000049, 3.05979125217, 11610.91017538320},
	{0.00000000036, 2.52534740273, 12323.42309600880},
	{0.00000000036, 4.69220073966, 6158.64743530580},
	{0.00000000038, 1.09153073828, 11614.43329373220},
	{0.00000000038, 3.33065203106, 22324.90505670940},
	{0.00000000046, 0.03302786718, 3333.56619000180},
	{0.00000000046, 6.09073905146, 3347.65866339780},
	{0.00000000040, 2.10576578753, 8982.81066930900},
	{0.00000000043, 0.78042917903, 7255.56965173440},
	{0.00000000034, 4.19221759757, 13916.01910964160},
	{0.00000000037, 3.11625027243, 27433.88921587499},
	{0.00000000043, 2.33975731781, 18454.60166491500},
	{0.00000000042, 3.27968491376, 13363.43002786740},
	{0.00000000046, 6.20852644411, 25685.87280280800},
	{0.00000000042, 4.41766590611, 4447.75123238460},
	{0.00000000033, 1.58447809959, 4777.78804089840},
	{0.00000000034, 4.72972168190, 26084.02180621620},
	{0.00000000032, 0.47359068270, 30774.50164257480},
	{0.00000000033, 4.58693776960, 18606.49894600020},
	{0.00000000035, 3.48982518412, 17654.78053974960},
	{0.00000000036, 1.40291642973, 24606.13555322000},
	{0.00000000032, 2.13345131081, 5099.26550511660},
	{0.00000000035, 1.28107458867, 23695.12778576700},
	{0.00000000041, 3.50737470856, 31570.79964939120},
	{0.00000000033, 5.09020911058, 31172.65064598300},
	{0.00000000031, 0.01163916655, 8186.51266249260},
	{0.00000000032, 2.87432086256, 15664.03552270859},
	{0.00000000031, 0.53878733876, 4106.40549114620},
	{0.00000000031, 2.44338692629, 2574.81936225340},
	{0.00000000029, 6.21158248008, 2803.80791460440},
	{0.00000000028, 1.67663019512, 12509.25332504720},
	{0.00000000031, 5.50562593007, 9225.53927328300},
	{0.00000000030, 2.07590180724, 16276.46394262300},
	{0.00000000030, 0.66979072957, 24076.44458812540},
	{0.00000000030, 3.99443582500, 1744.42598441520},
	{0.00000000028, 2.16725568934, 15650.79375031060},
	{0.00000000027, 4.40428978967, 15265.88651930040},
	{0.00000000029, 0.28036663014, 29026.48522950779},
	{0.00000000029, 3.70344382503, 33318.81606245820},
	{0.00000000027, 0.10774552280, 17101.21113690720},
	{0.00000000027, 0.45485812543, 17810.20093918380},
	{0.00000000029, 4.03990214859, 1758.65307841680},
	{0.00000000026, 0.25887939770, 20735.83216142559},
	{0.00000000025, 0.89364920475, 20354.51535906720},
	{0.00000000026, 0.94849562976, 16066.06586147480},
	{0.00000000033, 1.67236797949, 28628.33622609960},
	{0.00000000027, 3.09588567120, 26637.59120905859},
	{0.00000000027, 4.83042372893, 22747.29071487440},
	{0.00000000026, 2.23319975287, 5628.95647021120},
	{0.00000000024, 3.95136673509, 36659.42848915800},
	{0.00000000025, 0.20244605774, 21548.96236929180},
	{0.00000000024, 2.00009707302, 19402.79695281660},
	{0.00000000034, 3.20409325901, 19004.64794940840},
	{0.00000000026, 3.99199460654, 11925.27409260060},
	{0.00000000031, 5.64870400603, 2818.03500860600},
	{0.00000000025, 4.93162407170, 14071.43950907579},
	{0.00000000030, 3.41289002407, 29978.20363575840},
	{0.00000000029, 2.76627287372, 24093.27678917520},
	{0.00000000028, 5.02089948874, 13745.34623902240},
	{0.00000000024, 0.83608961696, 3877.41693879520},
	{0.00000000022, 0.07496012955, 8439.87793181640},
	{0.00000000021, 2.03101495598, 5085.03841111500},
	{0.00000000021, 2.71551636844, 23296.97878235879},
	{0.00000000024, 0.33554415228, 10596.18207843420},
	{0.00000000022, 1.41039428822, 12722.55242048520},
	{0.00000000021, 5.62805203791, 3340.54511639700},
	{0.00000000027, 3.83951649814, 8584.66166590080},
	{0.00000000022, 5.50509868914, 36261.27948574980},
	{0.00000000022, 5.32605738110, 20597.24396304120},
	{0.00000000020, 5.20493781467, 3340.67973700260},
	{0.00000000020, 5.68477147752, 3.52311834900},
	{0.00000000021, 4.89299498591, 29580.05463235019},
	{0.00000000020, 3.28509846447, 1062.90504853820},
	{0.00000000020, 3.94333468581, 34911.41207609100},
	{0.00000000019, 4.12121274193, 40000.04091585779},
	{0.00000000021, 0.48221374471, 17013.90293236740},
	{0.00000000018, 6.19988275445, 18208.34994259200},
	{0.00000000021, 2.62497335635, 24341.52831745660},
	{0.00000000018, 1.39329207850, 3863.18984479360},
	{0.00000000020, 5.27137395105, 10787.63034454580},
	{0.00000000020, 2.63246111294, 7788.36365908440},
	{0.00000000023, 5.70498713267, 4392.88080988820},
	{0.00000000018, 2.03105441179, 24491.42579258340},
	{0.00000000023, 0.89003486538, 37455.72649597440},
	{0.00000000017, 2.31724671612, 23937.85638974100},
	{0.00000000022, 5.13679401812, 21947.11137270000},
	{0.00000000020, 4.93672081814, 10213.28554621100},
	{0.00000000018, 3.83484681339, 3492.50970778500},
	{0.00000000018, 2.28892010525, 3188.71514561460},
	{0.00000000023, 5.21964251169, 32920.66705904999},
	{0.00000000021, 2.37477641594, 21000.91589075680},
	{0.00000000017, 2.84721386608, 5618.31980486140},
	{0.00000000016, 2.80865119459, 31022.75317085620},
	{0.00000000017, 0.94803978582, 23539.70738633280},
	{0.00000000017, 2.64977779529, 27682.14074415640},
	{0.00000000016, 3.84383924684, 22345.26037610820},
	{0.00000000016, 3.77900213334, 10448.43547097540},
	{0.00000000018, 2.23058952100, 18451.07854656599},
	{0.00000000015, 5.97152986197, 23546.75362303080},
	{0.00000000016, 0.42132719394, 32522.51805564180},
	{0.00000000017, 5.85701735803, 7373.38245462640},
	{0.00000000021, 0.73975045388, 35863.13048234160},
	{0.00000000015, 2.56824204430, 17277.40693183380},
	{0.00000000015, 5.89343669938, 2938.94030494260},
	{0.00000000015, 0.23033021926, 3742.28454845700},
	{0.00000000018, 0.72384948957, 24889.57479599160},
	{0.00000000015, 1.37917033437, 20809.46762464520},
	{0.00000000016, 1.02347429666, 39203.74290904139},
	{0.00000000015, 2.21611077272, 35464.98147893340},
	{0.00000000016, 3.41121610919, 12808.88030395680},
	{0.00000000018, 5.62217102143, 14867.73751589219},
	{0, 0, 0}
};

struct vsop87_term mars_x3[] = {
	{0.00000849999, 0.00000000000, 0.00000000000},
	{0.00000560133, 1.94007552058, 6681.22485339960},
	{0.00000318062, 2.39391695789, 10021.83728009940},
	{0.00000113458, 2.75680104109, 3340.61242669980},
	{0.00000088769, 2.77668742127, 13362.44970679920},
	{0.00000019119, 3.13835323002, 16703.06213349900},
	{0.00000017277, 3.54319327296, 3496.03282613400},
	{0.00000017102, 5.72328990016, 3185.19202726560},
	{0.00000007980, 3.07682330325, 3344.13554504880},
	{0.00000007938, 6.19210789752, 3337.08930835080},
	{0.00000003600, 3.49057256397, 20043.67456019880},
	{0.00000003738, 4.31798545325, 3583.34103067380},
	{0.00000003701, 4.94786426602, 3097.88382272579},
	{0.00000002871, 3.51063041661, 6684.74797174860},
	{0.00000002396, 6.08123425918, 6525.80445396540},
	{0.00000002381, 2.14011753266, 3894.18182954220},
	{0.00000002366, 0.84278889817, 2787.04302385740},
	{0.00000002217, 4.10105217005, 155.42039943420},
	{0.00000001294, 0.74157779671, 4292.33083295040},
	{0.00000001278, 2.24302936863, 2388.89402044920},
	{0.00000001161, 0.92511464092, 3532.06069281140},
	{0.00000001156, 2.06329715393, 3149.16416058820},
	{0.00000001158, 1.96104793934, 4136.91043351620},
	{0.00000001026, 1.02332579752, 2544.31441988340},
	{0.00000000999, 2.40817781393, 3339.63210563160},
	{0.00000000908, 5.64113657397, 4690.47983635860},
	{0.00000000996, 0.57020320129, 3341.59274776800},
	{0.00000000887, 3.64548622051, 1990.74501704100},
	{0.00000000778, 3.86898632712, 10025.36039844840},
	{0.00000000798, 3.26335116909, 3723.50895892300},
	{0.00000000794, 6.01017762336, 2957.71589447660},
	{0.00000000730, 0.57139245110, 4535.05943692440},
	{0.00000000625, 3.83967243505, 23384.28698689860},
	{0.00000000621, 5.05943953438, 1592.59601363280},
	{0.00000000632, 4.24328042236, 5088.62883976680},
	{0.00000000600, 2.38992409628, 2146.16541647520},
	{0.00000000450, 3.39897011554, 3738.76143010800},
	{0.00000000449, 1.93928115298, 3333.49887969900},
	{0.00000000411, 5.89788210301, 2942.46342329160},
	{0.00000000419, 1.08676442942, 3347.72597370060},
	{0.00000000399, 0.63956537359, 4399.99435688900},
	{0.00000000373, 3.38557300464, 6836.64525283380},
	{0.00000000488, 4.67092863003, 6923.95345737360},
	{0.00000000356, 0.24201359347, 1059.38193018920},
	{0.00000000356, 1.20127683127, 6127.65545055720},
	{0.00000000397, 2.50087314910, 6489.77658728800},
	{0.00000000295, 2.81028621304, 5621.84292321040},
	{0.00000000357, 0.15120327086, 9866.41688066520},
	{0.00000000295, 3.82251899304, 7079.37385680780},
	{0.00000000346, 2.35310156551, 7477.52286021600},
	{0.00000000237, 5.19318533864, 6438.49624942560},
	{0.00000000214, 0.98789182009, 6682.20517446780},
	{0.00000000178, 4.00441831249, 5331.35744374080},
	{0.00000000163, 5.43763088786, 4933.20844033260},
	{0.00000000215, 2.60375409797, 5729.50644714900},
	{0.00000000154, 0.93377729776, 7875.67186362420},
	{0.00000000149, 0.09387386327, 6298.32832117640},
	{0.00000000173, 4.21364045474, 13365.97282514820},
	{0.00000000143, 2.35553703991, 7234.79425624200},
	{0.00000000154, 6.09739962901, 6677.70173505060},
	{0.00000000156, 1.03056149319, 7740.60678358880},
	{0.00000000100, 2.91327592181, 9830.38901398780},
	{0.00000000108, 4.23921245691, 10419.98628350760},
	{0.00000000084, 2.71984208341, 10818.13528691580},
	{0.00000000099, 4.18630770421, 26724.89941359840},
	{0.00000000074, 1.02672478927, 4929.68532198360},
	{0.00000000074, 0.93262918684, 7632.94325965020},
	{0.00000000065, 5.02060335506, 10264.56588407340},
	{0.00000000082, 1.47502451340, 6688.33840040040},
	{0.00000000061, 2.88294088094, 796.29800681640},
	{0.00000000057, 1.55246581721, 9468.26787725700},
	{0.00000000057, 4.79655567701, 12832.75874170460},
	{0.00000000057, 3.21328791407, 7210.91581849420},
	{0.00000000051, 5.82726745850, 8273.82086703240},
	{0.00000000054, 4.16556830133, 9492.14631500480},
	{0.00000000050, 0.50123821286, 13207.02930736500},
	{0.00000000044, 2.82124972690, 3870.30339179440},
	{0.00000000049, 5.67213966976, 6681.20759974740},
	{0.00000000045, 5.78754564915, 8031.09226305840},
	{0.00000000049, 1.41972425612, 6681.24210705180},
	{0.00000000046, 4.10060372779, 398.14900340820},
	{0.00000000042, 1.83928464694, 10021.85453375160},
	{0.00000000043, 1.37745223660, 10022.81760116760},
	{0.00000000037, 0.19254777844, 8827.39026987480},
	{0.00000000042, 6.09184233156, 10021.82002644720},
	{0.00000000036, 1.39675249646, 11081.21921028860},
	{0.00000000035, 2.96862453735, 9070.11887384880},
	{0.00000000033, 1.01120243621, 15643.68020330980},
	{0.00000000032, 6.00543460913, 2281.23049651060},
	{0.00000000037, 5.84186470726, 10018.31416175040},
	{0.00000000031, 1.56543336145, 1194.44701022460},
	{0.00000000036, 3.37855270463, 7064.12138562280},
	{0.00000000034, 3.80029922412, 2810.92146160520},
	{0.00000000036, 0.21597015085, 12303.06777661000},
	{0.00000000026, 1.29835056088, 11216.28429032400},
	{0.00000000026, 3.71876071236, 9623.68827669120},
	{0.00000000031, 2.51169108456, 6680.24453233140},
	{0.00000000025, 2.90245233493, 10575.40668294180},
	{0.00000000025, 4.61989520769, 13760.59871020740},
	{0.00000000033, 4.38991518046, 8671.96987044060},
	{0.00000000023, 3.82777479464, 1349.86740965880},
	{0.00000000027, 4.53977736871, 16706.58525184800},
	{0.00000000024, 5.30269642578, 8432.76438481560},
	{0.00000000024, 1.32036606678, 8270.29774868340},
	{0.00000000023, 2.78297162236, 5486.77784317500},
	{0.00000000021, 5.90538406185, 8962.45534991020},
	{0.00000000025, 3.69837020561, 6894.52394883760},
	{0.00000000019, 5.82090139161, 951.71840625060},
	{0.00000000021, 2.58836852861, 1748.01641306700},
	{0.00000000020, 0.45032113933, 9638.94074787620},
	{0.00000000020, 1.23809651087, 3767.21061757580},
	{0.00000000018, 2.11942127084, 6674.11130639880},
	{0.00000000018, 2.98453883646, 10177.25767953360},
	{0.00000000021, 1.55166742516, 10973.55568635000},
	{0.00000000017, 3.28202056136, 13171.00144068760},
	{0.00000000018, 3.69940774861, 5614.72937620960},
	{0.00000000016, 3.70893898662, 6681.15754309680},
	{0.00000000016, 4.99486486759, 2914.01423582380},
	{0.00000000016, 4.02902153406, 10551.52824519400},
	{0.00000000015, 1.47023666677, 5459.37628707820},
	{0.00000000018, 0.90284270729, 553.56940284240},
	{0.00000000016, 3.30044259977, 6681.29216370240},
	{0.00000000014, 1.85591826294, 10028.95082710020},
	{0.00000000014, 0.24763128548, 12310.18132361080},
	{0.00000000010, 5.93147033577, 5628.95647021120},
	{0.00000000010, 5.70249322961, 242.72860397400},
	{0.00000000013, 0.37523695539, 191.44826611160},
	{0.00000000009, 4.72832434298, 8429.24126646660},
	{0.00000000009, 4.10495051503, 12295.95422960920},
	{0.00000000010, 3.23426688850, 10014.72373309860},
	{0.00000000010, 5.19144085400, 16173.37116840440},
	{0.00000000009, 1.56489034516, 1751.53953141600},
	{0.00000000009, 1.90233913976, 3340.62968035200},
	{0.00000000007, 3.08364199209, 14158.74771361560},
	{0.00000000009, 6.15595082739, 3340.59517304760},
	{0, 0, 0}
};

struct vsop87_term mars_x4[] = {
	{0.00000025349, 3.14159265359, 0.00000000000},
	{0.00000012260, 0.83414775886, 10021.83728009940},
	{0.00000010035, 0.40425836057, 6681.22485339960},
	{0.00000005198, 1.24299509979, 13362.44970679920},
	{0.00000003431, 0.85852911695, 3340.61242669980},
	{0.00000002427, 5.05444549984, 3496.03282613400},
	{0.00000002418, 4.21420537167, 3185.19202726560},
	{0.00000001497, 1.62269036988, 16703.06213349900},
	{0.00000000595, 2.81076120796, 3583.34103067380},
	{0.00000000592, 0.17219890479, 3097.88382272579},
	{0.00000000382, 4.57534940813, 6525.80445396540},
	{0.00000000352, 1.98630568244, 20043.67456019880},
	{0.00000000286, 5.62185554893, 2787.04302385740},
	{0.00000000286, 3.64530816060, 3894.18182954220},
	{0.00000000256, 1.53997671854, 3337.08930835080},
	{0.00000000259, 1.46295781638, 3344.13554504880},
	{0.00000000151, 1.94542778624, 6684.74797174860},
	{0.00000000128, 5.25790457100, 6836.64525283380},
	{0.00000000088, 3.16739635428, 6923.95345737360},
	{0.00000000071, 2.34364246842, 23384.28698689860},
	{0.00000000056, 2.35055343144, 10025.36039844840},
	{0.00000000049, 5.98001416469, 6127.65545055720},
	{0.00000000063, 4.93024120102, 9866.41688066520},
	{0.00000000034, 0.39772363794, 6438.49624942560},
	{0.00000000018, 0.96034807462, 6489.77658728800},
	{0.00000000015, 0.82846675812, 7477.52286021600},
	{0.00000000012, 5.75575668169, 6682.20517446780},
	{0.00000000012, 5.37191984330, 4399.99435688900},
	{0.00000000013, 5.72126392176, 10177.25767953360},
	{0.00000000014, 3.82771110265, 7234.79425624200},
	{0.00000000011, 3.51933198406, 10264.56588407340},
	{0.00000000011, 2.26503455301, 7079.37385680780},
	{0.00000000012, 1.11898359111, 5729.50644714900},
	{0.00000000013, 2.72384207552, 13365.97282514820},
	{0.00000000010, 2.51049102387, 5331.35744374080},
	{0.00000000011, 2.67531582625, 26724.89941359840},
	{0.00000000008, 4.88874609130, 6298.32832117640},
	{0.00000000007, 5.72637498363, 7875.67186362420},
	{0.00000000007, 3.90588497604, 4933.20844033260},
	{0.00000000004, 5.28325791601, 13207.02930736500},
	{0.00000000004, 0.05439896723, 9468.26787725700},
	{0, 0, 0}
};

struct vsop87_term mars_x5[] = {
	{0.00000000360, 5.54721578166, 10021.83728009940},
	{0.00000000274, 2.70467042100, 3185.19202726560},
	{0.00000000274, 0.28001490932, 3496.03282613400},
	{0.00000000240, 5.97967755050, 13362.44970679920},
	{0.00000000160, 5.82127895853, 3340.61242669980},
	{0.00000000092, 0.08533910188, 16703.06213349900},
	{0.00000000077, 1.68294648354, 3097.88382272579},
	{0.00000000077, 1.29922778151, 3583.34103067380},
	{0.00000000069, 5.21105165761, 6681.22485339960},
	{0.00000000087, 3.14159265359, 0.00000000000},
	{0.00000000049, 3.06464731556, 6525.80445396540},
	{0.00000000027, 0.47343416859, 20043.67456019880},
	{0.00000000026, 5.17377669672, 3894.18182954220},
	{0.00000000026, 4.09158287551, 2787.04302385740},
	{0.00000000013, 0.44755146347, 6836.64525283380},
	{0.00000000013, 1.66080594610, 6923.95345737360},
	{0.00000000006, 0.38635391847, 6684.74797174860},
	{0.00000000007, 3.42143669327, 9866.41688066520},
	{0.00000000005, 4.46712294634, 6127.65545055720},
	{0.00000000005, 0.84565489791, 23384.28698689860},
	{0.00000000004, 1.88610464642, 6438.49624942560},
	{0, 0, 0}
};

struct vsop87_term mars_y0[] = {
	{1.51558976277, 4.63212206588, 3340.61242669980},
	{0.07064550239, 4.97051892902, 6681.22485339960},
	{0.08655481102, 0.00000000000, 0.00000000000},
	{0.00493872848, 5.30877806694, 10021.83728009940},
	{0.00040917422, 5.64698263703, 13362.44970679920},
	{0.00021036784, 0.23240270955, 3337.08930835080},
	{0.00021012921, 5.89022773653, 3344.13554504880},
	{0.00011370034, 3.26131408801, 1059.38193018920},
	{0.00013324177, 5.34259389724, 529.69096509460},
	{0.00006764653, 4.07671230062, 3340.62968035200},
	{0.00006764700, 2.04594066912, 3340.59517304760},
	{0.00008346220, 3.42464704002, 2281.23049651060},
	{0.00005400042, 5.81507793194, 2942.46342329160},
	{0.00004809528, 0.27875310553, 3738.76143010800},
	{0.00004849523, 2.85190987550, 5621.84292321040},
	{0.00005263268, 0.75811089992, 6151.53388830500},
	{0.00003609527, 4.53244488294, 796.29800681640},
	{0.00003724293, 5.98516013322, 16703.06213349900},
	{0.00003805073, 5.94234296399, 398.14900340820},
	{0.00002394490, 5.34678816191, 3149.16416058820},
	{0.00002251027, 0.76938193892, 3532.06069281140},
	{0.00001975769, 0.56949816579, 6677.70173505060},
	{0.00002226030, 5.99867316288, 3340.67973700260},
	{0.00002226089, 0.12398424247, 3340.54511639700},
	{0.00002177591, 0.12334436516, 6283.07584999140},
	{0.00001690439, 1.58331163985, 5884.92684658320},
	{0.00002234121, 3.24909113765, 8962.45534991020},
	{0.00001628395, 4.95250906888, 4136.91043351620},
	{0.00001956411, 6.23095843554, 6684.74797174860},
	{0.00001697214, 0.81869636263, 2544.31441988340},
	{0.00001385946, 3.73437191158, 1751.53953141600},
	{0.00001439619, 5.19505958438, 2810.92146160520},
	{0.00001281890, 3.13035275682, 1194.44701022460},
	{0.00001469783, 0.30415060688, 3870.30339179440},
	{0.00001571880, 3.27679498650, 1589.07289528380},
	{0.00001575854, 2.78266835243, 5092.15195811580},
	{0.00000955007, 3.80044052913, 426.59819087600},
	{0.00000819149, 3.58786440540, 4399.99435688900},
	{0.00000709907, 4.50556127152, 191.44826611160},
	{0.00000719204, 1.08354735050, 9492.14631500480},
	{0.00000630626, 2.38434217274, 6681.20759974740},
	{0.00000630626, 4.41511380423, 6681.24210705180},
	{0.00000699407, 5.71737497910, 213.29909543800},
	{0.00000592563, 2.82214112368, 5486.77784317500},
	{0.00000581408, 2.38087976114, 3185.19202726560},
	{0.00000551361, 3.73720813913, 3496.03282613400},
	{0.00000491736, 0.60462673907, 7079.37385680780},
	{0.00000403176, 3.49532014869, 8432.76438481560},
	{0.00000532702, 1.72629618682, 1592.59601363280},
	{0.00000417187, 2.39288855164, 3339.63210563160},
	{0.00000417083, 3.72975291794, 3341.59274776800},
	{0.00000392731, 1.39110771836, 2146.16541647520},
	{0.00000359894, 0.04010740278, 20043.67456019880},
	{0.00000352248, 2.32029465959, 6254.62666252360},
	{0.00000351559, 3.59860692655, 12303.06777661000},
	{0.00000321064, 0.37146017150, 3553.91152213780},
	{0.00000313108, 5.61766202779, 3127.31333126180},
	{0.00000266755, 2.88006209994, 4562.46099302120},
	{0.00000281855, 0.42150291554, 7.11354700080},
	{0.00000259253, 0.32102915510, 1990.74501704100},
	{0.00000313501, 3.53468286874, 4535.05943692440},
	{0.00000265807, 4.13657205734, 5088.62883976680},
	{0.00000271152, 0.37550883198, 6467.92575796160},
	{0.00000223029, 1.98134328602, 3319.83703120740},
	{0.00000221308, 4.14094711258, 3361.38782219220},
	{0.00000233740, 0.46548637345, 9623.68827669120},
	{0.00000212622, 2.22578594563, 1748.01641306700},
	{0.00000207526, 0.46238962685, 6681.15754309680},
	{0.00000205079, 0.28680735926, 10025.36039844840},
	{0.00000207717, 0.90733952000, 10018.31416175040},
	{0.00000193140, 3.36083067358, 2118.76386037840},
	{0.00000244575, 2.80556071941, 2914.01423582380},
	{0.00000218542, 5.68744233165, 6489.77658728800},
	{0.00000207526, 0.05389324000, 6681.29216370240},
	{0.00000178369, 4.10543898205, 1221.84856632140},
	{0.00000156876, 5.19786609301, 2388.89402044920},
	{0.00000146513, 5.54868179527, 4690.47983635860},
	{0.00000176877, 2.69854646339, 2957.71589447660},
	{0.00000147659, 0.90344856519, 7210.91581849420},
	{0.00000164583, 5.28781848597, 7477.52286021600},
	{0.00000153824, 2.87500720379, 639.89728631400},
	{0.00000148488, 3.34244341315, 3723.50895892300},
	{0.00000146666, 2.84397856099, 3337.02199804800},
	{0.00000166545, 1.59865996295, 10213.28554621100},
	{0.00000146054, 3.27515242640, 3344.20285535160},
	{0.00000123680, 2.52811225465, 7903.07341972100},
	{0.00000120116, 3.09142091867, 11773.37681151540},
	{0.00000132007, 3.42890155754, 1349.86740965880},
	{0.00000143810, 3.78998571160, 2787.04302385740},
	{0.00000115489, 1.95561523091, 3333.49887969900},
	{0.00000111935, 4.78148495483, 3205.54734666440},
	{0.00000118091, 3.61471499659, 4929.68532198360},
	{0.00000106593, 1.33768476661, 3475.67750673520},
	{0.00000120156, 1.83813184657, 9225.53927328300},
	{0.00000104155, 0.75138682237, 4292.33083295040},
	{0.00000103341, 0.82609816627, 382.89653222320},
	{0.00000095750, 4.24181219758, 3347.72597370060},
	{0.00000088744, 1.41592655082, 12832.75874170460},
	{0.00000110471, 1.21942577303, 155.42039943420},
	{0.00000084990, 5.11937799314, 3097.88382272579},
	{0.00000114691, 2.26053594900, 3894.18182954220},
	{0.00000080587, 0.97053595716, 3583.34103067380},
	{0.00000085293, 2.11362771170, 4933.20844033260},
	{0.00000086745, 4.75160801779, 951.71840625060},
	{0.00000084319, 5.69047773316, 6674.11130639880},
	{0.00000072943, 3.45974237107, 1052.26838318840},
	{0.00000074027, 4.31857883803, 3767.21061757580},
	{0.00000068071, 6.11774649834, 553.56940284240},
	{0.00000091809, 2.68866263038, 9595.23908922340},
	{0.00000073606, 3.91527582136, 7740.60678358880},
	{0.00000064894, 3.02584743891, 6041.32756708560},
	{0.00000066066, 0.03236682162, 1066.49547719000},
	{0.00000066771, 3.82875505983, 2700.71514038580},
	{0.00000054123, 2.72119014356, 6525.80445396540},
	{0.00000066161, 4.75332288251, 10021.85453375160},
	{0.00000049846, 3.52262872498, 3312.16323923200},
	{0.00000049143, 2.60082752399, 3369.06161416760},
	{0.00000047251, 3.94147277349, 15643.68020330980},
	{0.00000066161, 2.72255125102, 10021.82002644720},
	{0.00000043247, 0.37556254004, 149.56319713460},
	{0.00000053311, 0.93765731929, 10419.98628350760},
	{0.00000046825, 2.48327781591, 8429.24126646660},
	{0.00000038910, 4.06810437323, 6682.20517446780},
	{0.00000038629, 3.82156635464, 8031.09226305840},
	{0.00000043007, 1.13946411806, 3325.35995551480},
	{0.00000049389, 0.37266734023, 2274.11694950980},
	{0.00000042804, 4.98193512793, 3355.86489788480},
	{0.00000045414, 3.29703568928, 2288.34404351140},
	{0.00000036267, 0.37822711569, 23384.28698689860},
	{0.00000039750, 2.86822975445, 4032.77002792660},
	{0.00000040833, 2.03724184335, 536.80451209540},
	{0.00000038416, 5.50718482024, 522.57741809380},
	{0.00000044799, 2.74299278394, 3077.52850332700},
	{0.00000031454, 2.64713766872, 5628.95647021120},
	{0.00000031440, 0.69172824614, 5331.35744374080},
	{0.00000036126, 0.70225541331, 9808.53818466140},
	{0.00000031627, 3.54155757104, 2648.45482547300},
	{0.00000032887, 0.52877756255, 242.72860397400},
	{0.00000029779, 1.13126848611, 7064.12138562280},
	{0.00000039043, 2.73213911386, 6680.24453233140},
	{0.00000032361, 3.86902085523, 7875.67186362420},
	{0.00000030949, 5.83140858910, 3.52311834900},
	{0.00000038473, 0.77890834630, 6894.52394883760},
	{0.00000040037, 3.38427304732, 3603.69635007260},
	{0.00000027656, 0.80781446139, 12964.30070339100},
	{0.00000027767, 2.59284816570, 7373.38245462640},
	{0.00000027615, 6.03842471271, 5614.72937620960},
	{0.00000027209, 3.09945915500, 11243.68584642080},
	{0.00000029756, 3.84776340814, 3178.14579056760},
	{0.00000028657, 2.32631705170, 3503.07906283200},
	{0.00000023678, 2.22043284741, 3320.25710730100},
	{0.00000023510, 3.90077126172, 3360.96774609859},
	{0.00000024414, 0.04911627531, 76.26607127560},
	{0.00000022360, 3.29132317156, 15113.98923821520},
	{0.00000022672, 0.62541647411, 13365.97282514820},
	{0.00000029996, 3.59488057957, 103.09277421860},
	{0.00000023118, 2.67406939478, 1692.16566950240},
	{0.00000024697, 4.51176067682, 692.15760122680},
	{0.00000021808, 0.39209935673, 10021.90459040220},
	{0.00000021387, 2.33304379441, 6660.44945790720},
	{0.00000020715, 2.52216424761, 1581.95934828300},
	{0.00000021808, 0.80059574357, 10021.76996979660},
	{0.00000025137, 5.06242825009, 3335.08950239240},
	{0.00000025085, 1.05978392516, 3346.13535100720},
	{0.00000024344, 5.15348656249, 7632.94325965020},
	{0.00000022802, 6.02803412581, 9830.38901398780},
	{0.00000025142, 4.04165606796, 1648.44675719740},
	{0.00000019246, 5.68073325802, 3329.97576135000},
	{0.00000019171, 0.43949269085, 3351.24909204960},
	{0.00000018713, 5.45372592751, 6438.49624942560},
	{0.00000017629, 5.62148452536, 6872.67311951120},
	{0.00000023406, 4.38193206835, 1758.65307841680},
	{0.00000019932, 5.89893308094, 2818.03500860600},
	{0.00000018896, 0.12478161870, 3863.18984479360},
	{0.00000020614, 1.58112721470, 10713.99488132620},
	{0.00000020199, 3.63716191406, 9381.93999378540},
	{0.00000020392, 1.69497220340, 10404.73381232260},
	{0.00000022995, 1.24532174509, 13358.92658845020},
	{0.00000018341, 4.17761073049, 11371.70468975820},
	{0.00000020656, 4.47723827677, 6702.00024889200},
	{0.00000017462, 5.47626814223, 3074.00538497800},
	{0.00000019538, 5.36428737888, 2707.82868738660},
	{0.00000016274, 1.33418754245, 10551.52824519400},
	{0.00000016226, 3.03590297335, 6298.32832117640},
	{0.00000017152, 3.69045512260, 6836.64525283380},
	{0.00000017718, 5.62526789753, 10818.13528691580},
	{0.00000016186, 0.64022063667, 3607.21946842160},
	{0.00000015103, 5.67174037306, 10973.55568635000},
	{0.00000016513, 0.57398291904, 6158.64743530580},
	{0.00000019594, 1.94488622867, 853.19638175200},
	{0.00000014987, 3.20375305228, 5099.26550511660},
	{0.00000014941, 5.74767895336, 6531.66165626500},
	{0.00000013625, 0.78468384069, 419.48464387520},
	{0.00000015679, 2.89209321078, 3333.56619000180},
	{0.00000014418, 0.21259774344, 7234.79425624200},
	{0.00000013479, 3.61192484167, 6684.81528205140},
	{0.00000016142, 5.55386288400, 5729.50644714900},
	{0.00000013923, 3.03761491100, 12935.85151592320},
	{0.00000016080, 4.06222327337, 6144.42034130420},
	{0.00000012795, 0.72051055394, 3336.73109134180},
	{0.00000012778, 5.40972437724, 3344.49376205780},
	{0.00000016730, 0.87141658782, 3973.39616601300},
	{0.00000017426, 3.89104366040, 74.78159856730},
	{0.00000015187, 3.70157240216, 5459.37628707820},
	{0.00000013731, 3.68029494669, 433.71173787680},
	{0.00000013717, 4.13705109844, 6127.65545055720},
	{0.00000012455, 4.85280703682, 2487.41604494780},
	{0.00000012109, 3.30084266721, 3980.50971301380},
	{0.00000012180, 3.07347183013, 3281.23856478620},
	{0.00000013697, 3.17688013290, 6677.63442474780},
	{0.00000011920, 3.05684725811, 3399.98628861340},
	{0.00000012440, 3.47218242490, 4989.05918389720},
	{0.00000011984, 0.71488214373, 1744.42598441520},
	{0.00000013476, 0.01515226059, 1596.18644228460},
	{0.00000013602, 4.01636834736, 3415.39402526710},
	{0.00000013560, 6.04193914571, 5085.03841111500},
	{0.00000011119, 3.94896791447, 8270.29774868340},
	{0.00000011044, 1.24284218830, 110.20632121940},
	{0.00000011077, 1.67963136830, 6816.28993343500},
	{0.00000012942, 3.09428514061, 8969.56889691100},
	{0.00000010572, 0.49111944928, 2921.12778282460},
	{0.00000012672, 2.10673786116, 3265.83082813250},
	{0.00000013864, 5.14485151295, 6546.15977336420},
	{0.00000013089, 0.23087557907, 8955.34180290940},
	{0.00000013108, 0.46269227053, 3443.70520091840},
	{0.00000010887, 5.60860774504, 3316.73398895200},
	{0.00000013658, 3.07674640526, 3347.65866339780},
	{0.00000010779, 0.52098721533, 3364.49086444760},
	{0.00000010586, 3.70485484511, 5828.02847164760},
	{0.00000012245, 1.07572499863, 135.06508003540},
	{0.00000010723, 1.74814138432, 16173.37116840440},
	{0.00000013097, 4.64132274437, 6688.33840040040},
	{0.00000011398, 5.58264073154, 3237.51965248120},
	{0.00000009456, 1.78215703758, 11769.85369316640},
	{0.00000009867, 2.38731218242, 14584.29827312060},
	{0.00000009346, 4.47625335129, 3304.58456002240},
	{0.00000009214, 1.65436128537, 3376.64029337720},
	{0.00000008918, 2.45020419452, 8273.82086703240},
	{0.00000012157, 6.01959905524, 10014.72373309860},
	{0.00000011461, 1.82889516132, 3024.22055704320},
	{0.00000008958, 0.47938419982, 3340.19235060619},
	{0.00000008958, 5.65082995747, 3341.03250279340},
	{0.00000008219, 3.15133566986, 8827.39026987480},
	{0.00000009305, 0.78791668509, 10575.40668294180},
	{0.00000010555, 0.77207843626, 12168.00269657460},
	{0.00000010404, 4.29473071484, 3657.00429635640},
	{0.00000007752, 4.94195070566, 162.46663613220},
	{0.00000008284, 6.07424265191, 6604.95878212400},
	{0.00000007693, 5.84469694248, 1861.74585263540},
	{0.00000007330, 5.44972077375, 3760.09707057500},
	{0.00000007360, 5.09396940186, 13362.46696045140},
	{0.00000009027, 3.31681299907, 6784.31762761820},
	{0.00000007581, 2.57329415226, 3134.42687826260},
	{0.00000007340, 3.06011730362, 13362.43245314700},
	{0.00000006923, 2.23261982586, 3169.93955608060},
	{0.00000007281, 3.49687859929, 3546.79797513700},
	{0.00000008392, 1.78654425962, 12566.15169998280},
	{0.00000007558, 1.86612263411, 3209.07046501340},
	{0.00000007302, 4.88716898503, 2178.13772229200},
	{0.00000007609, 3.51290319043, 3304.00706139560},
	{0.00000006549, 4.33945759933, 1118.75579210280},
	{0.00000007465, 1.30260145767, 6923.95345737360},
	{0.00000006446, 4.21304551726, 3341.04230982650},
	{0.00000006446, 1.91072140138, 3340.18254357310},
	{0.00000007519, 2.61412619102, 3377.21779200400},
	{0.00000006453, 3.89234671045, 3511.28529731900},
	{0.00000006649, 6.12912980173, 1375.77379984580},
	{0.00000006449, 0.76654877575, 1478.86657406440},
	{0.00000006210, 1.34955480867, 13916.01910964160},
	{0.00000007639, 4.24282694614, 11081.21921028860},
	{0.00000006261, 1.27002340476, 956.28915597060},
	{0.00000006940, 4.25393907229, 3472.15438838620},
	{0.00000005874, 5.41165981323, 640.87760738220},
	{0.00000006250, 4.38016536772, 1162.47470440780},
	{0.00000005775, 1.73266094244, 10184.30391623160},
	{0.00000005575, 2.93082058921, 949.17560896980},
	{0.00000006003, 1.27473547429, 13760.59871020740},
	{0.00000007296, 5.67050147545, 632.78373931320},
	{0.00000006054, 4.28573981877, 18984.29263000960},
	{0.00000005577, 2.97071984834, 6843.69148953180},
	{0.00000005413, 3.06854044437, 206.18554843720},
	{0.00000005393, 4.75504693723, 1228.96211332220},
	{0.00000006299, 6.14054511367, 14314.16811304980},
	{0.00000006835, 2.30456930250, 6606.44325483230},
	{0.00000006855, 0.22567806033, 263.08392337280},
	{0.00000005362, 0.17026677933, 2766.26762836500},
	{0.00000006934, 3.87163883253, 8329.67161059700},
	{0.00000005259, 2.86146113485, 224.34479570190},
	{0.00000005178, 1.81202672403, 3274.12501778540},
	{0.00000005616, 3.05432126136, 9866.41688066520},
	{0.00000006375, 4.15539245029, 8439.87793181640},
	{0.00000006110, 5.44128420245, 220.41264243880},
	{0.00000006512, 3.37621294675, 4459.36821880260},
	{0.00000005006, 4.31127259045, 3407.09983561420},
	{0.00000006280, 2.70715143719, 2221.85663459700},
	{0.00000006493, 3.80339809861, 38.13303563780},
	{0.00000006520, 3.29969103437, 3296.89351439480},
	{0.00000004789, 0.36397268503, 4407.10790388980},
	{0.00000006362, 2.82772481424, 3384.33133900480},
	{0.00000005692, 3.59213239655, 4569.57454002200},
	{0.00000006474, 4.73026165299, 7107.82304427560},
	{0.00000006259, 0.59256971500, 1964.83862685400},
	{0.00000005039, 2.44093002341, 6247.51311552280},
	{0.00000004722, 5.47235333233, 6261.74020952440},
	{0.00000004586, 2.93638012393, 6709.67404086740},
	{0.00000006292, 2.83360154696, 26087.90314157420},
	{0.00000004872, 3.87415179950, 4392.88080988820},
	{0.00000004383, 1.48980757344, 6665.97238221460},
	{0.00000004390, 1.03231511278, 13149.15061136120},
	{0.00000004312, 6.19144471077, 2807.39834325620},
	{0.00000004360, 1.15230731273, 10235.13637553740},
	{0.00000004314, 3.26868649565, 3877.41693879520},
	{0.00000004046, 2.20583477320, 14054.60730802600},
	{0.00000004008, 3.35863378745, 574.34479833480},
	{0.00000004107, 3.07058211212, 10020.85695903120},
	{0.00000004044, 2.81163214967, 13517.87010623340},
	{0.00000003822, 0.64521458656, 3490.17562383440},
	{0.00000004095, 4.40659363743, 10022.81760116760},
	{0.00000003703, 4.80251536531, 6571.01853218020},
	{0.00000004450, 0.89168729077, 13524.91634293140},
	{0.00000004526, 6.09427525593, 3191.04922956520},
	{0.00000004702, 2.45248932708, 2111.65031337760},
	{0.00000003986, 0.10375744687, 6048.44111408640},
	{0.00000003482, 4.20107395689, 11216.28429032400},
	{0.00000003592, 6.26752744572, 3873.82651014340},
	{0.00000003903, 5.74518224407, 3914.95722503460},
	{0.00000004495, 2.48902481892, 10177.25767953360},
	{0.00000003444, 0.47927514937, 8425.65083781480},
	{0.00000004220, 0.00535283025, 2699.73481931760},
	{0.00000003954, 3.83351128588, 6652.77566593180},
	{0.00000003984, 5.84008311937, 3981.49003408200},
	{0.00000003410, 4.75624627275, 13936.79450513400},
	{0.00000003767, 0.71635417612, 26724.89941359840},
	{0.00000003387, 3.58149706956, 18454.60166491500},
	{0.00000003961, 5.31040335152, 2384.32327072920},
	{0.00000003109, 6.13038417362, 4555.34744602040},
	{0.00000004007, 0.19405096418, 266.60704172180},
	{0.00000004019, 5.32092159727, 6696.47732458460},
	{0.00000003264, 1.14586868700, 16304.91313009080},
	{0.00000003093, 6.28077187263, 5305.45105355380},
	{0.00000003019, 5.35351440247, 5202.35827933520},
	{0.00000003273, 1.65076758838, 5518.75014899180},
	{0.00000002877, 4.90074910311, 1332.05488754080},
	{0.00000002905, 3.25849505328, 16858.48253293320},
	{0.00000003297, 1.02769227988, 8671.96987044060},
	{0.00000003680, 2.91690167677, 2906.90068882300},
	{0.00000002950, 3.68236929509, 6944.30877677240},
	{0.00000003359, 2.27893480688, 2803.80791460440},
	{0.00000002717, 4.19241426109, 6518.75821726740},
	{0.00000002747, 4.88163693950, 5724.93569742900},
	{0.00000002645, 3.89691136061, 5989.06725217280},
	{0.00000003227, 2.76073562282, 647.01083331480},
	{0.00000002528, 0.08271917291, 13171.00144068760},
	{0.00000002511, 5.88222082993, 533.21408344360},
	{0.00000002483, 2.30179531677, 3313.21087060300},
	{0.00000002456, 3.82204754724, 3368.01398279660},
	{0.00000002623, 1.58355072138, 16699.53901514999},
	{0.00000003010, 1.80622472085, 2008.55753915900},
	{0.00000002405, 4.84605046787, 9168.64089834740},
	{0.00000002398, 2.56649522216, 17924.91069982040},
	{0.00000002423, 3.17994958247, 5732.04924442980},
	{0.00000003339, 5.12360857553, 17277.40693183380},
	{0.00000002435, 4.41312658080, 9485.03276800400},
	{0.00000002416, 0.73041207552, 13362.51701710200},
	{0.00000002405, 0.20257003589, 3561.02506913860},
	{0.00000002532, 3.29260787559, 6475.03930496240},
	{0.00000002392, 4.34374406796, 10596.18207843420},
	{0.00000002432, 2.40533150763, 3171.03224356680},
	{0.00000002274, 1.39549918259, 6686.74777770700},
	{0.00000002400, 4.57758726706, 4672.66731424060},
	{0.00000002448, 3.02028279202, 6418.14093002680},
	{0.00000002366, 1.05045564841, 15508.61512327440},
	{0.00000002427, 0.38892764633, 6040.34724601740},
	{0.00000002247, 0.65129974134, 3343.36393731080},
	{0.00000002247, 5.47246717730, 3337.86091608880},
	{0.00000002377, 3.75701877252, 3510.19260983280},
	{0.00000002167, 0.11767854689, 2125.87740737920},
	{0.00000002861, 0.41825730841, 3342.09689940810},
	{0.00000002948, 5.86605020349, 6414.61781167780},
	{0.00000002139, 4.06717048102, 7799.98064550240},
	{0.00000002827, 5.70543977377, 3339.12795399150},
	{0.00000002582, 0.96409333017, 16706.58525184800},
	{0.00000002546, 3.54027578863, 12722.55242048520},
	{0.00000002160, 4.92254263405, 9779.10867612540},
	{0.00000002155, 3.68774197983, 1795.25844372100},
	{0.00000002100, 3.35707551610, 3929.67725370800},
	{0.00000002903, 4.69260400410, 661.23292678100},
	{0.00000002222, 1.26294843768, 7314.00859271280},
	{0.00000002127, 5.81675710469, 3120.19978426100},
	{0.00000002352, 5.40138877221, 6675.70192909220},
	{0.00000002072, 4.69329841596, 16460.33352952499},
	{0.00000002771, 6.09091685365, 9872.27408296480},
	{0.00000001996, 0.01333352875, 792.77488846740},
	{0.00000002523, 2.01463124837, 846.08283475120},
	{0.00000001980, 5.95709631826, 14158.74771361560},
	{0.00000002065, 0.49388965272, 12295.95422960920},
	{0.00000002016, 4.23253734433, 6701.58017279840},
	{0.00000002042, 3.11100955297, 1545.35398297880},
	{0.00000001975, 5.70749246997, 8542.97070603500},
	{0.00000002040, 1.07943023634, 1214.73501932060},
	{0.00000002428, 1.78991515376, 17256.63153634140},
	{0.00000002221, 2.56014240865, 6660.86953400080},
	{0.00000002648, 2.51945261752, 15110.46611986620},
	{0.00000002185, 4.81676561022, 10042.61267559180},
	{0.00000002357, 0.65442854372, 6460.81221096080},
	{0.00000001933, 2.11467335200, 3230.40610548040},
	{0.00000001855, 0.40013387410, 3416.87849797540},
	{0.00000001878, 2.82996512240, 2751.54759969160},
	{0.00000001838, 3.38443937909, 16276.46394262300},
	{0.00000002273, 2.67716254538, 10001.06188460700},
	{0.00000001861, 1.26573645480, 2945.98654164060},
	{0.00000002216, 0.91630812456, 9499.25986200560},
	{0.00000001805, 0.77929673675, 6691.86151874940},
	{0.00000002360, 2.94494997079, 14712.31711645800},
	{0.00000002416, 1.13890846236, 13362.38239649640},
	{0.00000002281, 2.28712289600, 6643.09181776180},
	{0.00000002101, 0.26512458923, 14.22709400160},
	{0.00000001770, 5.39660970180, 323.50541665740},
	{0.00000001855, 5.11046704890, 13553.89797291080},
	{0.00000001748, 3.00019460001, 5032.77809620220},
	{0.00000001715, 3.81102983458, 4039.88357492740},
	{0.00000001721, 3.21935371748, 6456.88005769770},
	{0.00000001966, 3.45968546817, 12310.18132361080},
	{0.00000002109, 0.54415878969, 7203.80227149340},
	{0.00000001672, 0.98005371506, 6947.83189512140},
	{0.00000002199, 5.30054419513, 28.44918746780},
	{0.00000001702, 0.53249868858, 2675.85638156980},
	{0.00000001669, 0.92596345981, 1435.14766175940},
	{0.00000001651, 4.33968588892, 6756.00645196690},
	{0.00000001660, 3.37483790709, 9638.94074787620},
	{0.00000001892, 5.79856399350, 799.82112516540},
	{0.00000002194, 3.25078967175, 20.77539549240},
	{0.00000002096, 4.33264269742, 13119.72110282519},
	{0.00000001589, 2.00183365150, 2494.52959194860},
	{0.00000001547, 3.73595833668, 742.99006053260},
	{0.00000001639, 4.23392283443, 2679.37949991880},
	{0.00000001532, 5.50075240690, 4005.36847182980},
	{0.00000001548, 6.24678563405, 6578.13207918100},
	{0.00000001844, 4.01089057973, 1039.02661079040},
	{0.00000001555, 4.98628025111, 10028.95082710020},
	{0.00000001553, 2.32867697517, 4193.80880845180},
	{0.00000001869, 5.29702557581, 3113.13629391080},
	{0.00000001547, 0.07021288134, 13355.33615979840},
	{0.00000001463, 4.98430780024, 3318.76159737340},
	{0.00000001463, 1.13945911840, 3362.46325602620},
	{0.00000001867, 1.75650236110, 13892.14067189380},
	{0.00000001484, 4.23315329914, 2604.73591316800},
	{0.00000001444, 3.51978992540, 10018.24685144760},
	{0.00000001862, 6.02925087361, 6670.58818804980},
	{0.00000001434, 4.87139095958, 2075.04494807340},
	{0.00000001428, 4.47987818809, 9468.26787725700},
	{0.00000001440, 2.33078495148, 2641.34127847220},
	{0.00000001516, 2.83788149379, 4922.57177498280},
	{0.00000001429, 1.03218970015, 12995.22537783680},
	{0.00000001637, 5.89268196003, 9070.11887384880},
	{0.00000001434, 4.16617594484, 3283.71405176420},
	{0.00000001552, 5.46766076359, 9886.77220006400},
	{0.00000001443, 5.12250897854, 19800.94595622480},
	{0.00000001430, 3.95481187554, 10025.42770875120},
	{0.00000001411, 5.78666438291, 7895.95987272020},
	{0.00000001403, 1.95715148848, 3397.51080163540},
	{0.00000001477, 5.05923233039, 664.75604513000},
	{0.00000001422, 1.73849339140, 17395.21973472580},
	{0.00000001893, 3.78808072052, 7255.56965173440},
	{0.00000001455, 3.95724694508, 2693.60159338500},
	{0.00000001700, 0.82628421144, 3568.08855948880},
	{0.00000001599, 3.45368152649, 3212.59358336240},
	{0.00000001492, 2.02335847018, 6155.05700665400},
	{0.00000001330, 4.10649504401, 5625.36604155940},
	{0.00000001458, 4.17345665885, 1015.66301788420},
	{0.00000001556, 5.03343705939, 699.27114822760},
	{0.00000001329, 1.62600812826, 3347.29609057390},
	{0.00000001329, 4.49775879038, 3333.92876282570},
	{0.00000001502, 4.97796968434, 3378.74546233760},
	{0.00000001522, 2.67171739921, 3468.63127003720},
	{0.00000001395, 4.73053455402, 589.06482700820},
	{0.00000001286, 0.30379131125, 3152.68727893721},
	{0.00000001682, 6.22849241635, 4775.76008845920},
	{0.00000001600, 6.11925303848, 1905.46476494040},
	{0.00000001563, 3.16953602104, 6674.17861670160},
	{0.00000001454, 4.05003779520, 8799.98871377800},
	{0.00000001260, 1.69516681295, 3742.28454845700},
	{0.00000001361, 3.13054556500, 6034.21402008480},
	{0.00000001702, 0.42639470325, 8646.06348025360},
	{0.00000001307, 4.86294984681, 1190.92389187560},
	{0.00000001582, 3.59667619676, 3450.81874791920},
	{0.00000001272, 4.68635069953, 6997.61672305620},
	{0.00000001293, 3.67069504345, 10124.93005431800},
	{0.00000001157, 2.59571504503, 4885.96640967860},
	{0.00000001193, 5.74461193872, 6685.10618875760},
	{0.00000001175, 1.89791109723, 4076.48894023160},
	{0.00000001273, 5.05031878952, 66.48740891440},
	{0.00000001419, 5.98233231598, 3.93215326310},
	{0.00000001127, 4.03094666313, 17654.78053974960},
	{0.00000001325, 5.10332504416, 59.37386191360},
	{0.00000001205, 3.32707601504, 6688.27109009760},
	{0.00000001183, 4.18544310209, 11670.28403729680},
	{0.00000001415, 2.81550588094, 9588.12554222260},
	{0.00000001569, 0.42718737380, 1.48447270830},
	{0.00000001112, 4.50778167602, 15.25247118500},
	{0.00000001136, 0.27209358118, 19402.79695281660},
	{0.00000001102, 2.41369298606, 6364.83298374300},
	{0.00000001104, 1.71931758367, 6148.01076995600},
	{0.00000001171, 3.63619587357, 2771.79055267240},
	{0.00000001128, 3.40922804025, 6621.85099148600},
	{0.00000001312, 3.60055878901, 3311.18291816379},
	{0.00000001312, 2.52320812963, 3370.04193523580},
	{0.00000001101, 4.21878444844, 3774.32416457660},
	{0.00000001229, 0.96680072191, 3145.64104223920},
	{0.00000001266, 4.04475782677, 6887.41040183680},
	{0.00000001197, 4.66589167515, 2284.75361485960},
	{0.00000001097, 0.74070558229, 13745.34623902240},
	{0.00000001222, 2.97118716033, 3184.21170619740},
	{0.00000001052, 4.36133521546, 1197.97012857360},
	{0.00000001086, 2.74984967665, 2324.94940881560},
	{0.00000001116, 4.29110122176, 11610.91017538320},
	{0.00000001218, 2.02574751453, 10156.90236013480},
	{0.00000001068, 5.67373061677, 12721.57209941700},
	{0.00000001106, 2.77068073078, 2597.62236616720},
	{0.00000001093, 4.53871388488, 5618.31980486140},
	{0.00000001024, 0.06601478472, 11766.26326451460},
	{0.00000001193, 1.05540356619, 6677.34351804160},
	{0.00000001102, 3.69331514825, 7321.12213971360},
	{0.00000000990, 4.38326935686, 3181.66890891660},
	{0.00000000992, 6.20838604911, 4140.43355186520},
	{0.00000001146, 3.15309955963, 3497.01314720220},
	{0.00000001269, 3.62847699186, 3188.71514561460},
	{0.00000001009, 4.15469691601, 4142.97634914600},
	{0.00000001311, 0.82653092367, 3302.47939106200},
	{0.00000001268, 3.68256833294, 6740.59871531320},
	{0.00000001371, 0.13077559897, 9945.57120882380},
	{0.00000001109, 1.53029152367, 394.62588505920},
	{0.00000000977, 5.76688159627, 3361.94806716680},
	{0.00000000977, 0.35688532238, 3319.27678623280},
	{0.00000000969, 4.50338632333, 1272.68102562720},
	{0.00000001185, 5.73396555500, 9602.35263622420},
	{0.00000001013, 5.48278778939, 2277.70737816160},
	{0.00000001079, 0.61021915360, 9389.05354078620},
	{0.00000001347, 2.06223654324, 19513.98359510420},
	{0.00000000986, 1.69206195363, 20809.46762464520},
	{0.00000001106, 0.06094765066, 3264.34635542420},
	{0.00000000968, 4.43227430163, 931.36308685180},
	{0.00000001187, 4.34414977303, 5835.14201864840},
	{0.00000000957, 4.82126145069, 6645.19698672220},
	{0.00000001198, 5.16932600912, 9065.54812412880},
	{0.00000000943, 5.33537557967, 3344.15279870100},
	{0.00000000943, 3.92998399256, 3337.07205469860},
	{0.00000000929, 2.07677392189, 4001.84535348080},
	{0.00000000977, 2.12311397363, 2538.24850425360},
	{0.00000000960, 2.48503648557, 3909.43430072720},
	{0.00000000909, 2.06833342083, 3326.38533269820},
	{0.00000001071, 4.54619279368, 5195.24473233440},
	{0.00000000943, 5.96075562405, 3337.10656200300},
	{0.00000000943, 3.30460394818, 3344.11829139661},
	{0.00000000902, 5.15672426526, 169.58018313300},
	{0.00000000888, 1.43117252150, 16865.52876963120},
	{0.00000000919, 2.04701224910, 2067.93140107260},
	{0.00000000884, 5.16952206002, 36.60536530420},
	{0.00000000925, 1.82707454475, 1485.98012106520},
	{0.00000000879, 4.09361898695, 3354.83952070140},
	{0.00000001201, 6.09845178677, 16062.18452611680},
	{0.00000000963, 2.78734439237, 11614.43329373220},
	{0.00000000856, 0.80926398517, 6705.10329114740},
	{0.00000000969, 5.16633148001, 8958.93223156120},
	{0.00000001200, 3.92847129115, 2970.91261075940},
	{0.00000001039, 0.35365785785, 4936.79886898440},
	{0.00000000897, 3.73527891349, 11780.49035851620},
	{0.00000000995, 0.26138866358, 16335.83780453660},
	{0.00000000868, 2.65649534956, 9947.05568153210},
	{0.00000000890, 4.75712150390, 6747.71226231400},
	{0.00000001141, 0.97184844335, 131.54196168640},
	{0.00000000834, 0.81428487363, 6680.80477730600},
	{0.00000000884, 1.87315288737, 3232.94890276120},
	{0.00000000818, 5.38279925907, 9380.95967271720},
	{0.00000000818, 4.78663456281, 8013.27974094040},
	{0.00000000814, 3.39899123402, 16703.04487984680},
	{0.00000001043, 2.49681718942, 3492.50970778500},
	{0.00000000814, 5.42976286552, 16703.07938715119},
	{0.00000000900, 4.50924525053, 8965.97846825920},
	{0.00000000821, 6.16771533756, 3358.42494881780},
	{0.00000000821, 6.23923688826, 3322.79990458180},
	{0.00000000805, 3.69471748733, 1045.15483618760},
	{0.00000000787, 3.77976750586, 735.87651353180},
	{0.00000000967, 1.92764202530, 9654.61295113700},
	{0.00000000792, 5.67450968586, 7100.70949727480},
	{0.00000000779, 1.71729257907, 3499.55594448300},
	{0.00000000841, 4.23759405799, 3448.27595063840},
	{0.00000000788, 4.57983605830, 14421.83163698840},
	{0.00000000836, 1.41619053095, 170.67287061920},
	{0.00000000844, 3.21239075987, 4356.27544458400},
	{0.00000000989, 3.67005329922, 20199.09495963300},
	{0.00000000900, 1.00211769457, 401.67212175720},
	{0.00000001013, 4.38954237559, 8859.36257569160},
	{0.00000001009, 5.94344429551, 6657.34641565180},
	{0.00000000819, 4.90700253923, 802.36392244620},
	{0.00000001030, 2.19496889171, 3710.31224264020},
	{0.00000000787, 3.72966883127, 3308.64012088300},
	{0.00000000787, 2.39409808737, 3372.58473251660},
	{0.00000000725, 4.63532264917, 3229.42578441220},
	{0.00000000812, 1.13677065033, 11.04570026390},
	{0.00000000825, 4.27026639346, 3253.30422216000},
	{0.00000000838, 3.66947874674, 3116.26763099790},
	{0.00000000864, 1.98924766986, 6717.25272007700},
	{0.00000000729, 0.68449736491, 22743.40937951640},
	{0.00000000720, 5.55705118503, 20597.24396304120},
	{0.00000000700, 3.77746305049, 3613.28538405140},
	{0.00000000889, 3.55978260808, 7910.18696672180},
	{0.00000000720, 3.79227419390, 1062.90504853820},
	{0.00000000694, 1.48841585184, 3451.79906898740},
	{0.00000000692, 2.36882551276, 3067.93946934820},
	{0.00000000730, 1.00727748667, 6016.46880826960},
	{0.00000000795, 1.85354458694, 3427.92063123960},
	{0.00000000688, 2.41477495597, 20426.57109242200},
	{0.00000000876, 5.35866130411, 2391.43681773000},
	{0.00000000723, 3.92475752469, 3735.23831175900},
	{0.00000000722, 2.23341954634, 15906.76412668260},
	{0.00000000661, 3.51665460883, 7270.28968040780},
	{0.00000000651, 0.78545063650, 6357.71943674220},
	{0.00000000790, 1.64323479127, 10264.56588407340},
	{0.00000000694, 0.87755088753, 1265.56747862640},
	{0.00000000652, 1.55852371558, 3212.66089366520},
	{0.00000000711, 1.63332630369, 5642.19824260920},
	{0.00000000634, 1.60298193598, 17101.21113690720},
	{0.00000000652, 4.45799464174, 485.97205278960},
	{0.00000000666, 1.27481108934, 15664.03552270859},
	{0.00000000625, 2.36814325199, 5938.23479286700},
	{0.00000000639, 1.93449381766, 5408.54382777240},
	{0.00000000621, 1.42292756920, 17468.85519794540},
	{0.00000000684, 2.60266690573, 1437.17561419860},
	{0.00000000631, 3.77351547579, 3329.56672643590},
	{0.00000000631, 2.35025144285, 3351.65812696370},
	{0.00000000631, 4.86274156896, 3343.15522398060},
	{0.00000000834, 5.98573063128, 6681.64492949320},
	{0.00000000619, 4.56322346372, 3468.56395973440},
	{0.00000000779, 4.63356167618, 22324.90505670940},
	{0.00000000683, 4.49253838209, 3336.68027343670},
	{0.00000000683, 1.63122853655, 3344.54457996290},
	{0.00000000637, 5.57552696396, 151.04766984290},
	{0.00000000600, 1.07842896250, 3338.06962941900},
	{0.00000000834, 2.11901816690, 24150.08005134500},
	{0.00000000735, 1.11347228352, 2409.24933984800},
	{0.00000000621, 5.11737417220, 10448.43547097540},
	{0.00000000649, 4.60015667511, 148.07872442630},
	{0.00000000776, 1.37472992157, 6019.99192661860},
	{0.00000000706, 2.94874370922, 6717.83021870380},
	{0.00000000638, 3.48875178863, 3826.58447948940},
	{0.00000000586, 5.86003431075, 3528.53757446240},
	{0.00000000586, 2.19200605264, 22345.26037610820},
	{0.00000000615, 0.51970504765, 1169.58825140860},
	{0.00000000597, 5.87197147428, 2540.79130153440},
	{0.00000000589, 3.65950730930, 7380.49600162720},
	{0.00000000704, 1.04297020980, 3547.31316399640},
	{0.00000000663, 0.71782437194, 2301.58581590939},
	{0.00000000602, 4.55116981040, 6681.65473652630},
	{0.00000000672, 5.83404606009, 6666.99775939800},
	{0.00000000691, 5.87625321159, 6679.74038069130},
	{0.00000000644, 0.37433972538, 4289.78803566960},
	{0.00000000559, 2.62955480222, 6314.00052443720},
	{0.00000000613, 2.81666478638, 18451.07854656599},
	{0.00000000584, 0.31894691338, 2171.02417529120},
	{0.00000000648, 1.07818407115, 4133.38731516720},
	{0.00000000610, 5.23007688005, 9911.63095888000},
	{0.00000000716, 1.72986045966, 19004.64794940840},
	{0.00000000602, 2.63805578157, 2854.64037391020},
	{0.00000000600, 3.16504307436, 6724.94376570460},
	{0.00000000584, 2.96924262775, 8226.57883637840},
	{0.00000000742, 3.68753265144, 2547.83753823240},
	{0.00000000589, 1.36560850845, 20.35531939880},
	{0.00000000613, 2.32622469131, 6549.68289171320},
	{0.00000000634, 2.56923863836, 6510.55198278040},
	{0.00000000602, 2.24884569451, 6680.79497027290},
	{0.00000000527, 3.82884166493, 11140.59307220220},
	{0.00000000522, 2.26977914970, 3341.79306935190},
	{0.00000000522, 3.85398776894, 3339.43178404770},
	{0.00000000625, 5.85233423648, 52175.80628314840},
	{0.00000000546, 3.96156394907, 3193.80074017620},
	{0.00000000533, 0.72901836770, 12323.42309600880},
	{0.00000000553, 2.12191066592, 3487.42411322340},
	{0.00000000513, 5.35876783758, 299.12639426920},
	{0.00000000714, 6.24453003731, 4503.08713110760},
	{0.00000000557, 4.09014460295, 316.39186965660},
	{0.00000000584, 4.99460272910, 3133.91168940320},
	{0.00000000649, 0.91092905161, 1641.33321019660},
	{0.00000000511, 1.27411646883, 16489.76303806100},
	{0.00000000505, 3.26910073568, 1063.31408345230},
	{0.00000000694, 4.54072508194, 43.71891230500},
	{0.00000000542, 2.95211033167, 1596.11913198180},
	{0.00000000530, 5.77886387642, 1699.27921650320},
	{0.00000000509, 4.40726650224, 6812.76681508600},
	{0.00000000489, 1.49622890471, 13575.74880223720},
	{0.00000000535, 3.39733194552, 9072.66167112960},
	{0.00000000536, 4.94177551833, 3198.43379966360},
	{0.00000000478, 4.20263049199, 114.39910691340},
	{0.00000000619, 3.39724967275, 13207.02930736500},
	{0.00000000474, 0.14710048229, 4246.06912336460},
	{0.00000000527, 4.43881694959, 3289.33208883739},
	{0.00000000527, 1.68494996905, 3391.89276456221},
	{0.00000000491, 6.12686543849, 3288.35211178700},
	{0.00000000491, 6.28008678733, 3392.87274161260},
	{0.00000000532, 0.09481122914, 1055.44977692610},
	{0.00000000473, 1.65549875820, 4296.90158267040},
	{0.00000000533, 5.15285623089, 3535.58381116040},
	{0.00000000483, 3.77260927689, 3346.67834232960},
	{0.00000000483, 2.35115764175, 3334.54651107000},
	{0.00000000460, 2.87294253141, 2281.24775016280},
	{0.00000000460, 0.84217089992, 2281.21324285840},
	{0.00000000604, 5.04411661351, 2373.64154926420},
	{0.00000000455, 2.71347773637, 8962.47260356240},
	{0.00000000455, 0.68270610488, 8962.43809625800},
	{0.00000000506, 1.18178617794, 3482.79105373600},
	{0.00000000520, 4.81778266341, 382.87927857100},
	{0.00000000453, 2.02135344772, 2957.73314812880},
	{0.00000000633, 5.05090698547, 2963.23881878400},
	{0.00000000502, 3.05307431011, 5562.46906129680},
	{0.00000000475, 4.42459668952, 23.87843774780},
	{0.00000000604, 2.76951680562, 3370.10424500320},
	{0.00000000604, 3.35425011302, 3311.12060839640},
	{0.00000000448, 3.40867489514, 13361.46938573100},
	{0.00000000500, 0.96736492114, 4819.47900076420},
	{0.00000000440, 3.12274959821, 3564.95722240170},
	{0.00000000442, 0.45808507261, 227.47613278900},
	{0.00000000477, 4.42611192431, 4379.63903749020},
	{0.00000000492, 3.86744898089, 11250.79939342160},
	{0.00000000476, 3.15928705457, 2295.45759051220},
	{0.00000000468, 3.75342375537, 4186.69526145100},
	{0.00000000430, 0.16981325181, 4716.38622654560},
	{0.00000000505, 5.41670810903, 3495.96551583120},
	{0.00000000450, 0.92683652577, 8116.37251515900},
	{0.00000000561, 4.79003110975, 4271.97551355160},
	{0.00000000535, 1.82320232215, 860.30992875280},
	{0.00000000422, 1.90347011233, 5753.38488489680},
	{0.00000000427, 2.36223136799, 1574.84580128220},
	{0.00000000456, 1.82684055018, 10006.58480891440},
	{0.00000000422, 4.38918966666, 5223.69391980220},
	{0.00000000539, 0.59509723540, 3185.25933756840},
	{0.00000000425, 6.16545314121, 5888.44996493220},
	{0.00000000436, 1.02599155499, 23539.70738633280},
	{0.00000000478, 4.03784097782, 5095.67507646480},
	{0.00000000443, 5.24107173006, 1854.63230563460},
	{0.00000000475, 4.30595945262, 6850.80503653260},
	{0.00000000433, 2.49733426085, 3376.17516116840},
	{0.00000000433, 3.62643265779, 3305.04969223120},
	{0.00000000410, 5.02461670016, 2480.30249794700},
	{0.00000000558, 6.20652192769, 4025.65648092580},
	{0.00000000423, 5.65906920843, 10037.08975128440},
	{0.00000000407, 1.22583553247, 18849.22754997420},
	{0.00000000481, 5.74335395262, 6685.15700666270},
	{0.00000000402, 0.22199197504, 6151.55114195720},
	{0.00000000402, 4.47440565072, 6151.51663465280},
	{0.00000000425, 2.89229866320, 21265.52312652020},
	{0.00000000430, 0.28354344501, 2655.56837247380},
	{0.00000000531, 3.22678253563, 6637.50594109460},
	{0.00000000477, 2.15054075988, 6614.73744448520},
	{0.00000000555, 1.07136034497, 3717.98603461560},
	{0.00000000425, 4.00058546704, 7218.02936549500},
	{0.00000000402, 2.74134740638, 1685.05212250160},
	{0.00000000456, 3.63646339661, 9374.82644678460},
	{0.00000000392, 4.13330005973, 3723.49170527080},
	{0.00000000430, 4.01774033971, 7696.88787128380},
	{0.00000000486, 3.27620484219, 10050.28646756720},
	{0.00000000413, 4.62181012252, 7483.58877584580},
	{0.00000000403, 3.03715170877, 18606.49894600020},
	{0.00000000388, 4.53563064046, 8564.30634650200},
	{0.00000000394, 0.17224799893, 4981.94563689640},
	{0.00000000487, 3.89276175312, 1655.56030419820},
	{0.00000000404, 3.65562985264, 6644.61948809540},
	{0.00000000382, 0.83080012585, 3017.10701004240},
	{0.00000000414, 0.69798224448, 7747.72033058960},
	{0.00000000376, 1.97925827985, 20735.83216142559},
	{0.00000000395, 5.71525673304, 515.46387109300},
	{0.00000000378, 1.07650858210, 9801.42463766060},
	{0.00000000432, 1.20025313626, 905.45669666480},
	{0.00000000448, 3.40168164363, 2277.29834324750},
	{0.00000000366, 3.33686353957, 912.57024366560},
	{0.00000000437, 0.33111846337, 2285.16264977370},
	{0.00000000364, 0.19370376341, 15806.14683944200},
	{0.00000000509, 4.47318747635, 1765.76662541760},
	{0.00000000424, 0.31309571718, 5881.40372823420},
	{0.00000000475, 2.97743590747, 1329.51209026000},
	{0.00000000363, 2.53252878777, 25685.87280280800},
	{0.00000000379, 5.77822316957, 7366.26890762560},
	{0.00000000355, 2.42667156551, 5636.07001721200},
	{0.00000000475, 3.89107293655, 21795.21409161479},
	{0.00000000351, 4.13578832624, 6851.89772401880},
	{0.00000000452, 0.50803184514, 6106.88005506480},
	{0.00000000344, 5.37144778531, 16894.51039961060},
	{0.00000000364, 0.71572042055, 6682.70932610790},
	{0.00000000388, 2.20834855471, 20618.01935853360},
	{0.00000000452, 1.07313020826, 4307.58330413540},
	{0.00000000339, 4.53065010744, 1883.08149310240},
	{0.00000000361, 5.00906964184, 27682.14074415640},
	{0.00000000351, 2.80463066915, 5452.26274007740},
	{0.00000000335, 0.80197784093, 15636.56665630900},
	{0.00000000434, 0.32563509977, 7214.43893684320},
	{0.00000000395, 4.16776570158, 9993.38809263160},
	{0.00000000352, 2.61512238463, 1250.83019630080},
	{0.00000000394, 3.54014449716, 9797.49248439750},
	{0.00000000327, 4.04880436765, 3353.85419909779},
	{0.00000000327, 2.07496255099, 3327.37065430180},
	{0.00000000351, 0.12561529818, 13212.88650966460},
	{0.00000000328, 6.15057253277, 2435.15573003500},
	{0.00000000415, 3.58472859131, 21947.11137270000},
	{0.00000000447, 4.74470130101, 13363.43002786740},
	{0.00000000336, 2.93237714822, 0.98032106820},
	{0.00000000389, 1.05447612688, 30065.51184029820},
	{0.00000000361, 1.50116564732, 5749.86176654780},
	{0.00000000444, 0.28150228175, 8982.81066930900},
	{0.00000000395, 1.75358681150, 3337.15661865360},
	{0.00000000327, 4.40197406437, 146.81168652360},
	{0.00000000320, 4.04485044014, 25287.72379939980},
	{0.00000000339, 4.51129199209, 14556.89671702380},
	{0.00000000389, 4.52937583175, 18052.92954315780},
	{0.00000000408, 6.10449821431, 11883.58313273480},
	{0.00000000384, 4.30166402202, 7733.49323658800},
	{0.00000000333, 1.83073454084, 543.91805909620},
	{0.00000000335, 2.75369658972, 3060.82592234740},
	{0.00000000344, 0.16236119441, 568.82187402740},
	{0.00000000314, 2.59903777963, 15265.88651930040},
	{0.00000000355, 6.17242188932, 7322.10246078180},
	{0.00000000316, 5.59149424389, 3440.18208256940},
	{0.00000000316, 0.53227267475, 3241.04277083020},
	{0.00000000354, 0.64235154390, 4606.17990532620},
	{0.00000000310, 5.64297192066, 6453.74872061060},
	{0.00000000317, 2.40423598623, 2973.38809773740},
	{0.00000000300, 2.21725287793, 1987.22189869200},
	{0.00000000299, 4.05930436366, 10284.92120347220},
	{0.00000000342, 1.05396519831, 14128.24277124560},
	{0.00000000379, 2.27965866856, 1461.05405194640},
	{0.00000000294, 1.92173439518, 20040.15144184979},
	{0.00000000360, 3.42990211925, 16063.16484718500},
	{0.00000000313, 1.30391208259, 6286.59896834040},
	{0.00000000307, 6.22295802105, 9755.23023837760},
	{0.00000000306, 4.47697327581, 8756.26980147300},
	{0.00000000361, 1.45253410618, 685.04405422600},
	{0.00000000392, 1.48127453453, 19645.52555679060},
	{0.00000000328, 2.03910800196, 3397.41568886960},
	{0.00000000328, 4.08465891668, 3283.80916453000},
	{0.00000000316, 2.32828995492, 5621.86017686260},
	{0.00000000397, 5.55627760256, 23141.55838292460},
	{0.00000000294, 1.44129558600, 5483.25472482600},
	{0.00000000291, 0.90595258507, 11986.67590695340},
	{0.00000000307, 2.00013192821, 8749.15625447220},
	{0.00000000314, 2.64774700056, 9983.70424446160},
	{0.00000000340, 3.83856139387, 12509.25332504720},
	{0.00000000339, 0.25931753019, 3856.07629779280},
	{0.00000000339, 5.86444938845, 2825.14855560680},
	{0.00000000283, 3.01099503487, 5244.04923920100},
	{0.00000000383, 3.28640230880, 2921.68802779920},
	{0.00000000282, 3.52940833364, 5106.37905211740},
	{0.00000000302, 4.91996410033, 12825.64519470380},
	{0.00000000287, 2.38824152806, 194.97138446060},
	{0.00000000310, 0.61972171326, 2060.81785407180},
	{0.00000000330, 6.18492026237, 1073.60902419080},
	{0.00000000382, 1.17991122952, 3267.31530084080},
	{0.00000000382, 4.94385568912, 3413.90955255880},
	{0.00000000304, 3.37219185052, 3620.39893105220},
	{0.00000000285, 4.10904023674, 279.78650435240},
	{0.00000000316, 0.29751832342, 5621.82566955820},
	{0.00000000325, 5.36152471767, 533.62311835770},
	{0.00000000283, 1.21247425709, 12839.87228870540},
	{0.00000000296, 3.06136390749, 187.92514776260},
	{0.00000000283, 4.53197273536, 9859.37064396720},
	{0.00000000281, 3.88336320291, 596.17837400900},
	{0.00000000271, 0.22764063317, 1368.66025284500},
	{0.00000000280, 0.42006444847, 16511.61386738740},
	{0.00000000298, 0.08485122631, 11236.57229942000},
	{0.00000000285, 0.56726195027, 206.70073729660},
	{0.00000000300, 3.90419594378, 5820.91492464680},
	{0.00000000321, 0.39004570182, 2267.00340250900},
	{0.00000000261, 1.23435301369, 20206.14119633100},
	{0.00000000316, 1.01160877914, 5490.30096152400},
	{0.00000000269, 2.88944214463, 2744.43405269080},
	{0.00000000316, 2.18472195162, 525.75881183150},
	{0.00000000271, 3.84708232270, 3336.04167697980},
	{0.00000000271, 2.27668459594, 3345.18317641980},
	{0.00000000268, 5.19560766387, 2149.68853482420},
	{0.00000000251, 2.15515665308, 3337.50938444440},
	{0.00000000251, 3.96861026556, 3343.71546895520},
	{0.00000000251, 3.37137074296, 9758.75335672660},
	{0.00000000251, 1.54323704062, 1903.43681250120},
	{0.00000000291, 4.03266591834, 367.22432896240},
	{0.00000000250, 0.13361485614, 2142.64229812620},
	{0.00000000267, 0.96036007447, 6830.78805053420},
	{0.00000000306, 1.35986909253, 12012.58229714040},
	{0.00000000255, 3.17215031285, 12928.73796892240},
	{0.00000000286, 4.90376441028, 1898.35121793960},
	{0.00000000290, 1.30201044096, 20047.19767854780},
	{0.00000000268, 1.47703232305, 16702.99482319620},
	{0.00000000250, 0.95280868140, 9698.33186344200},
	{0.00000000246, 3.89830112418, 15650.79375031060},
	{0.00000000247, 5.73950808020, 10016.31435579200},
	{0.00000000257, 3.56657939800, 5430.39465709880},
	{0.00000000255, 4.87354006866, 21548.96236929180},
	{0.00000000269, 1.11468463011, 36.02786667740},
	{0.00000000255, 2.82393072524, 26482.17080962440},
	{0.00000000255, 1.56711743342, 1727.66109366820},
	{0.00000000276, 4.96569192497, 6670.17915313570},
	{0.00000000320, 5.04391570277, 11904.91877320180},
	{0.00000000280, 5.37126197378, 5401.43028077160},
	{0.00000000258, 2.68846300150, 9488.62319665580},
	{0.00000000269, 1.83867958993, 3866.78027344540},
	{0.00000000265, 2.90618128587, 3053.65006557920},
	{0.00000000240, 1.73397693635, 10027.36020440680},
	{0.00000000321, 2.82885605337, 3759.53682560040},
	{0.00000000319, 3.59122436698, 9815.65173166220},
	{0.00000000301, 3.63843739254, 95.97922721780},
	{0.00000000251, 0.12300198308, 1279.79457262800},
	{0.00000000251, 5.02021336588, 2790.56614220640},
	{0.00000000322, 4.83706419059, 17085.95866572220},
	{0.00000000326, 4.20517834971, 3707.83675566220},
	{0.00000000311, 5.99598016839, 3391.44488600560},
	{0.00000000311, 0.12778675025, 3289.77996739400},
	{0.00000000272, 4.72506446876, 10706.88133432540},
	{0.00000000230, 1.62590974520, 10654.62101941260},
	{0.00000000292, 5.65389851248, 3050.12694723020},
	{0.00000000235, 2.10330649321, 5945.34833986780},
	{0.00000000301, 2.35277176785, 9495.66943335380},
	{0.00000000227, 5.71659702017, 1868.85939963620},
	{0.00000000233, 3.39950183393, 4996.17273089800},
	{0.00000000225, 2.61344044624, 2938.94030494260},
	{0.00000000225, 4.67024091816, 24341.52831745660},
	{0.00000000312, 4.22328014540, 4403.51747523800},
	{0.00000000224, 4.82206915571, 5.52292430740},
	{0.00000000222, 1.20460555062, 1835.32461760680},
	{0.00000000289, 0.65812694051, 6901.63749583840},
	{0.00000000244, 2.21530907924, 5349.16996585880},
	{0.00000000268, 1.06853593620, 16703.12944380180},
	{0.00000000243, 1.91517218823, 1442.26120876020},
	{0.00000000220, 2.74511541811, 6511.64467026660},
	{0.00000000234, 0.06116213374, 17499.36014031540},
	{0.00000000224, 6.22254343881, 3542.86582187390},
	{0.00000000224, 6.18440878701, 3138.35903152570},
	{0.00000000272, 3.51708444353, 2428.04218303420},
	{0.00000000218, 5.88781974409, 6283.09310364360},
	{0.00000000218, 3.85704811260, 6283.05859633920},
	{0.00000000256, 6.05446717792, 151.89728108520},
	{0.00000000220, 3.19711314225, 3987.62326001460},
	{0.00000000219, 1.56460932980, 8584.66166590080},
	{0.00000000215, 5.15532893112, 13383.22510229160},
	{0.00000000215, 5.16313544064, 5511.63660199100},
	{0.00000000224, 2.11540642784, 77.75054398390},
	{0.00000000215, 2.86756714739, 5617.91076994730},
	{0.00000000244, 5.85362027072, 2814.44457995420},
	{0.00000000211, 0.74742043486, 19676.45023123640},
	{0.00000000227, 2.59606896980, 9278.84721956680},
	{0.00000000211, 5.04144285274, 12199.97500239140},
	{0.00000000212, 0.14538044968, 2392.41713879820},
	{0.00000000237, 3.21759075914, 3627.57478782039},
	{0.00000000287, 1.05955224588, 12465.53441274220},
	{0.00000000220, 0.54828486823, 6530.17718355670},
	{0.00000000263, 5.32330172342, 4531.53631857540},
	{0.00000000249, 2.58328462618, 3084.64205032780},
	{0.00000000252, 3.03997100024, 3382.16321768460},
	{0.00000000252, 3.08379591840, 3299.06163571500},
	{0.00000000267, 5.74809850023, 5415.65737477320},
	{0.00000000239, 1.63889533266, 3344.06823474600},
	{0.00000000262, 0.46948508418, 3631.09790616940},
	{0.00000000206, 1.80117058552, 7082.89697515680},
	{0.00000000210, 5.81059147043, 6678.47334278860},
	{0.00000000255, 1.55350830983, 1994.26813539000},
	{0.00000000210, 6.25153793027, 1484.93248969420},
	{0.00000000274, 4.79336564976, 12306.59089495900},
	{0.00000000204, 0.76733899172, 6382.09845913040},
	{0.00000000223, 3.13516948674, 3336.25039031000},
	{0.00000000223, 2.98859743190, 3344.97446308960},
	{0.00000000255, 5.28908452900, 2942.48067694380},
	{0.00000000224, 1.52427347828, 6533.14612897330},
	{0.00000000233, 5.90676932856, 19146.75926614180},
	{0.00000000201, 5.35533176059, 9360.60435331840},
	{0.00000000211, 1.15148869397, 3890.65871119319},
	{0.00000000227, 6.03580433993, 5625.77507647350},
	{0.00000000200, 6.26289082650, 7586.68155006440},
	{0.00000000199, 3.26137019616, 3029.77162783140},
	{0.00000000243, 4.23643794604, 9329.67967887260},
	{0.00000000199, 3.94721644624, 2089.78223039900},
	{0.00000000250, 5.43333163998, 24889.57479599160},
	{0.00000000197, 1.15409232210, 3436.59165391760},
	{0.00000000197, 4.96967459654, 3244.63319948200},
	{0.00000000223, 0.34944239276, 3.59042865180},
	{0.00000000197, 0.20677207241, 15106.87569121440},
	{0.00000000231, 2.63984097637, 6653.82329730280},
	{0.00000000198, 3.92131152950, 3094.36070437679},
	{0.00000000223, 3.01290266414, 13341.67431130680},
	{0.00000000198, 4.43881610804, 18208.34994259200},
	{0.00000000191, 5.50522939133, 3752.98352357420},
	{0.00000000191, 0.61853752731, 2928.24132982540},
	{0.00000000192, 3.48407799837, 15121.10278521600},
	{0.00000000221, 0.94687593506, 3649.89074935560},
	{0.00000000212, 4.83879513966, 4538.58255527340},
	{0.00000000192, 2.00799170950, 3315.75366788380},
	{0.00000000192, 4.11577520914, 3365.47118551580},
	{0.00000000226, 3.54050854737, 3596.58280307180},
	{0.00000000191, 1.07856532421, 117.31986822020},
	{0.00000000255, 3.25831289751, 2942.44616963940},
	{0.00000000191, 0.88273497404, 10544.41469819320},
	{0.00000000205, 0.67759896423, 1059.36467653700},
	{0.00000000188, 0.18939361921, 3363.38092330920},
	{0.00000000188, 5.93437329943, 3317.84393009040},
	{0.00000000231, 2.52066042702, 9093.99731159660},
	{0.00000000228, 2.13919737338, 369.69981594040},
	{0.00000000182, 1.33127974270, 5960.08562219340},
	{0.00000000183, 1.25274653764, 4878.85286267780},
	{0.00000000193, 2.43223658328, 7417.10136693140},
	{0.00000000188, 0.40235506847, 2735.76268599500},
	{0.00000000189, 5.13510234469, 11353.89216764020},
	{0.00000000180, 5.03093948829, 1755.06264976500},
	{0.00000000222, 6.00721433544, 3070.41495632620},
	{0.00000000233, 3.17507790219, 5351.71276313960},
	{0.00000000177, 2.86226760448, 3651.45322556820},
	{0.00000000232, 3.46445207879, 3163.91869656600},
	{0.00000000232, 2.65931483985, 3517.30615683360},
	{0.00000000176, 3.48010790145, 6342.98215441660},
	{0.00000000180, 5.30008115245, 3332.51855863080},
	{0.00000000180, 0.82368576619, 3348.70629476880},
	{0.00000000179, 2.20235361692, 3586.86414902280},
	{0.00000000185, 5.05060067762, 4061.75165790600},
	{0.00000000205, 2.70837059572, 1059.39918384140},
	{0.00000000187, 1.04746838799, 2619.47319549360},
	{0.00000000176, 3.90353461991, 13465.54248101780},
	{0.00000000208, 2.66589443408, 4253.18267036540},
	{0.00000000174, 4.55814413103, 10096.61887866670},
	{0.00000000188, 3.92958586943, 2574.81936225340},
	{0.00000000175, 5.69635587487, 12299.54465826100},
	{0.00000000240, 2.78491358774, 5085.10572141780},
	{0.00000000208, 1.23374873483, 10721.10842832700},
	{0.00000000242, 2.13161585563, 11925.27409260060},
	{0.00000000173, 5.89789471349, 28230.18722269139},
	{0.00000000177, 5.31666142975, 2572.76360735120},
	{0.00000000225, 1.90849387608, 23958.63178523340},
	{0.00000000231, 5.40468485650, 31022.75317085620},
	{0.00000000210, 0.98942403448, 6683.97636401060},
	{0.00000000175, 4.13281638704, 6708.62640949640},
	{0.00000000174, 4.83665165671, 3155.76251872960},
	{0.00000000169, 3.90681440181, 4694.00295470760},
	{0.00000000169, 3.54733614920, 6684.73071809641},
	{0.00000000169, 5.57810778070, 6684.76522540080},
	{0.00000000191, 3.61332015676, 11567.19126307820},
	{0.00000000207, 2.89825036062, 10001.48196070061},
	{0.00000000185, 3.07114551783, 3936.79080070880},
	{0.00000000189, 5.77291316706, 2783.51990550840},
	{0.00000000197, 5.75026594358, 8166.15734309380},
	{0.00000000203, 3.16676623170, 4466.48176580340},
	{0.00000000167, 5.13944886262, 158.94351778320},
	{0.00000000165, 1.89458907755, 6566.82574648620},
	{0.00000000219, 4.30567311434, 3070.48226662900},
	{0.00000000177, 3.00242387112, 2978.49128996900},
	{0.00000000179, 2.14367659492, 17232.75309859360},
	{0.00000000169, 0.26354444683, 11456.98494185880},
	{0.00000000184, 6.11553659620, 12942.96506292400},
	{0.00000000214, 5.24745003905, 604.84974070480},
	{0.00000000168, 1.24832202487, 1111.64224510200},
	{0.00000000162, 0.40163918127, 16695.94858649819},
	{0.00000000167, 0.42456512338, 24491.42579258340},
	{0.00000000200, 0.11649489032, 3610.80989707340},
	{0.00000000188, 0.87790891193, 2385.37090210020},
	{0.00000000185, 0.38071563992, 4452.25467180180},
	{0.00000000170, 4.45477263786, 28628.33622609960},
	{0.00000000168, 0.43144821098, 6165.76098230660},
	{0.00000000201, 3.99164016173, 3738.74417645580},
	{0.00000000188, 1.10311001587, 1744.49329471800},
	{0.00000000159, 3.67101894096, 14481.20549890200},
	{0.00000000162, 5.14005106474, 272.67295735160},
	{0.00000000156, 5.01784452685, 8436.28750316460},
	{0.00000000170, 5.97804289682, 4825.54491639400},
	{0.00000000163, 0.14934835314, 3345.81161786560},
	{0.00000000163, 5.97441856550, 3335.41323553400},
	{0.00000000165, 0.42827361678, 10.63666534980},
	{0.00000000174, 0.55658276896, 10787.63034454580},
	{0.00000000175, 5.91625467468, 2757.61351532140},
	{0.00000000153, 0.22099888781, 7447.01791784600},
	{0.00000000184, 3.91518117795, 5220.17080145320},
	{0.00000000214, 2.37690992241, 1385.89527633620},
	{0.00000000171, 0.07657131354, 10011.20061474960},
	{0.00000000163, 0.47065867853, 13286.18363552360},
	{0.00000000152, 2.34971090866, 2011.10033643980},
	{0.00000000154, 3.98395343557, 8771.00708379860},
	{0.00000000151, 4.45990869608, 15010.89646399660},
	{0.00000000153, 5.74866858603, 9153.90361602180},
	{0.00000000171, 4.58339007555, 21393.54196985760},
	{0.00000000169, 4.62232700739, 7064.10413197060},
	{0.00000000166, 5.48604111479, 6719.35788903740},
	{0.00000000151, 4.33106068620, 10228.02282853660},
	{0.00000000151, 1.25876714050, 3525.46233467000},
	{0.00000000149, 0.32471999674, 3664.11784335720},
	{0.00000000196, 1.82164041147, 3610.74258677060},
	{0.00000000166, 0.46106393944, 5466.48983407900},
	{0.00000000167, 1.32101864186, 10288.44432182120},
	{0.00000000167, 5.49820703705, 5813.29118932200},
	{0.00000000147, 0.61292233753, 1898.33396428740},
	{0.00000000166, 1.16464294435, 6908.70098618860},
	{0.00000000172, 3.82515637777, 19617.07636932279},
	{0.00000000182, 4.81327110244, 8535.85715903420},
	{0.00000000154, 2.09016136698, 1346.34429130980},
	{0.00000000145, 5.82715197678, 14577.18472611980},
	{0.00000000201, 6.02241179322, 3738.77868376020},
	{0.00000000146, 5.33364778234, 13369.56325380000},
	{0.00000000170, 4.17129374991, 6677.68448139840},
	{0.00000000147, 0.30529245684, 9918.74450588080},
	{0.00000000159, 1.38117514790, 3346.46962899940},
	{0.00000000159, 4.74259177074, 3334.75522440020},
	{0.00000000144, 1.48919516907, 8322.55806359620},
	{0.00000000143, 5.81404981785, 13227.38462676380},
	{0.00000000189, 4.57066567683, 10042.19259949820},
	{0.00000000153, 3.12132749782, 3702.73356343060},
	{0.00000000170, 6.22747964368, 5607.61582920880},
	{0.00000000168, 1.11741682536, 10032.47394544920},
	{0.00000000151, 0.91764249974, 1859.20305535460},
	{0.00000000163, 6.13290323794, 2964.84669512960},
	{0.00000000149, 5.64340451890, 12406.16055082860},
	{0.00000000168, 5.38234820743, 27490.69247804480},
	{0.00000000179, 5.09214529715, 2714.94223438740},
	{0.00000000179, 1.03162162149, 3966.28261901220},
	{0.00000000155, 4.37389063339, 4686.95671800959},
	{0.00000000140, 3.29233960935, 18461.71521191579},
	{0.00000000183, 5.08915245987, 6791.43117461900},
	{0.00000000150, 3.63195159063, 2922.10810389280},
	{0.00000000146, 0.34180400613, 2714.98729050260},
	{0.00000000165, 5.85179950459, 7345.98089852960},
	{0.00000000191, 0.62441184949, 3202.02422831540},
	{0.00000000191, 5.49935506915, 3479.20062508420},
	{0.00000000160, 3.89847950064, 3287.30448041600},
	{0.00000000160, 2.22528741800, 3393.92037298360},
	{0.00000000143, 4.66819102175, 5298.33750655300},
	{0.00000000193, 4.93382263995, 3031.33410404400},
	{0.00000000137, 1.10831878106, 1538.24043597800},
	{0.00000000189, 0.82918253553, 27832.03821928320},
	{0.00000000161, 0.41487404103, 3897.70494789120},
	{0.00000000136, 4.94904122324, 4665.55376723980},
	{0.00000000146, 4.58946121962, 29424.63423291600},
	{0.00000000144, 5.67407580544, 3945.46216740460},
	{0.00000000155, 4.11300986064, 25135.82651831460},
	{0.00000000170, 6.20206538140, 6677.71898870279},
	{0.00000000141, 2.26693908625, 6279.55273164240},
	{0.00000000136, 5.68923166061, 4288.80771460140},
	{0.00000000167, 3.71126958427, 8336.78515759780},
	{0.00000000151, 4.63496418774, 8962.52266021300},
	{0.00000000151, 4.79490046168, 2281.29780681340},
	{0.00000000159, 3.23471035128, 8958.52319664710},
	{0.00000000151, 5.20339684853, 2281.16318620780},
	{0.00000000137, 1.47758341153, 6703.07568272600},
	{0.00000000151, 5.04346057458, 8962.38803960740},
	{0.00000000133, 5.72069663156, 4295.85395129940},
	{0.00000000159, 0.16407854844, 8966.38750317330},
	{0.00000000137, 0.73335617283, 12729.66596748600},
	{0.00000000132, 4.69707830142, 12171.52581492360},
	{0.00000000136, 4.02213961750, 8695.84830818840},
	{0.00000000132, 4.38025942738, 10824.20120254560},
	{0.00000000130, 2.78423915943, 529.67371144240},
	{0.00000000132, 5.86985041939, 2472.67876262220},
	{0.00000000133, 4.50452650479, 6624.32647846400},
	{0.00000000164, 4.60687101666, 1155.36115740700},
	{0.00000000148, 2.40612364993, 7050.92466934000},
	{0.00000000130, 3.08795138602, 7593.79509706520},
	{0.00000000160, 3.35966837618, 10081.21114201300},
	{0.00000000130, 4.81501079092, 529.70821874680},
	{0.00000000143, 3.29046013826, 10014.79104340140},
	{0.00000000158, 3.17182640229, 6092.16002639140},
	{0.00000000133, 6.23099356596, 21150.81336588360},
	{0.00000000148, 2.44769901406, 1505.28780909299},
	{0.00000000137, 1.98411709382, 34554.81386366760},
	{0.00000000134, 4.61132825315, 2954.19277612760},
	{0.00000000129, 3.37544159152, 11527.12508919240},
	{0.00000000145, 3.33531716268, 8373.39052290200},
	{0.00000000172, 1.36733410756, 1086.78348628600},
	{0.00000000141, 1.22591570561, 3041.48603243060},
	{0.00000000137, 4.29535110956, 6137.30679430340},
	{0.00000000166, 3.85823242782, 107.66352393860},
	{0.00000000127, 3.67470240475, 10294.51023745100},
	{0.00000000137, 3.89019601730, 14580.77515477160},
	{0.00000000130, 0.80714408434, 4108.46124604840},
	{0.00000000141, 2.61333516815, 5088.21980485270},
	{0.00000000165, 3.99987517019, 8006.16619393960},
	{0.00000000144, 5.56354727307, 1802.37199072180},
	{0.00000000124, 4.81729498841, 10177.19036923080},
	{0.00000000126, 0.28235988406, 18447.48811791419},
	{0.00000000141, 6.27649569910, 3716.37815827000},
	{0.00000000124, 1.96413242139, 6687.90851727370},
	{0.00000000121, 4.72300940105, 3090.70796595760},
	{0.00000000121, 1.40075751759, 3590.51688744200},
	{0.00000000141, 5.98008002738, 5096.08411137890},
	{0.00000000122, 5.79431680023, 2257.35205876280},
	{0.00000000123, 2.86133242277, 6710.65436193560},
	{0.00000000166, 3.56556372747, 6553.20601006220},
	{0.00000000123, 2.97984792859, 14591.41182012140},
	{0.00000000128, 5.37813947668, 3600.17323172360},
	{0.00000000128, 0.74562744196, 3081.05162167600},
	{0.00000000122, 4.85419345520, 1236.07566032300},
	{0.00000000138, 4.02406657968, 7167.19690618920},
	{0.00000000127, 2.49182650403, 3759.11674950680},
	{0.00000000143, 5.81188741430, 2228.97018159780},
	{0.00000000152, 3.52185876402, 3340.64693400420},
	{0.00000000152, 5.74350080821, 3340.57791939540},
	{0.00000000140, 6.07921710613, 2233.47362101500},
	{0.00000000118, 2.67439157216, 7534.42123515160},
	{0.00000000137, 3.22022096656, 14587.82139146960},
	{0.00000000124, 2.27970099563, 9124.92198604240},
	{0.00000000161, 3.75731973309, 4576.68808702280},
	{0.00000000116, 5.02262371793, 10338.22914975600},
	{0.00000000126, 4.15150267519, 4083.60248723240},
	{0.00000000133, 0.20063412038, 3923.61133807820},
	{0.00000000139, 1.28995256706, 4782.87363546000},
	{0.00000000122, 6.02851032493, 6836.57794253100},
	{0.00000000121, 2.88286714942, 4179.58171445020},
	{0.00000000162, 5.96659239053, 8852.24902869080},
	{0.00000000153, 3.50724335550, 49225.58018914080},
	{0.00000000137, 1.59056057693, 8219.46528937760},
	{0.00000000134, 5.30662276999, 6659.37402407320},
	{0.00000000133, 0.75283219591, 6147.60173504190},
	{0.00000000113, 5.67984864041, 4782.89088911220},
	{0.00000000119, 0.88310894308, 1471.75302706360},
	{0.00000000112, 1.64583106043, 4106.40549114620},
	{0.00000000116, 1.51226089331, 3727.03207727200},
	{0.00000000115, 2.23873164969, 27433.88921587499},
	{0.00000000111, 3.49092955755, 6837.62557390200},
	{0.00000000122, 4.66180533919, 4953.56375973140},
	{0.00000000110, 4.24429487321, 2980.50164473820},
	{0.00000000130, 5.53821276618, 14267.90640346400},
	{0.00000000114, 5.78198829675, 3966.23756289700},
	{0.00000000129, 3.09576574234, 3101.40694107480},
	{0.00000000129, 3.02800117630, 3579.81791232480},
	{0.00000000133, 2.29548900012, 6738.12322833520},
	{0.00000000109, 3.91214172233, 6953.89781075120},
	{0.00000000114, 4.23798377032, 13517.80279593060},
	{0.00000000146, 1.72637612424, 3282.73373069600},
	{0.00000000146, 4.39739079440, 3398.49112270360},
	{0.00000000142, 2.28691321864, 1879.55837475340},
	{0.00000000115, 3.13902228769, 2501.64313894940},
	{0.00000000130, 3.94430245099, 6155.46604156810},
	{0.00000000123, 4.36600516245, 2185.25126929280},
	{0.00000000112, 1.26819666087, 27.40155609680},
	{0.00000000116, 2.98356645564, 8976.68244391180},
	{0.00000000105, 3.84139235085, 17821.81792560179},
	{0.00000000144, 4.28618515178, 8446.99147881720},
	{0.00000000103, 5.03658750394, 1059.31461988640},
	{0.00000000107, 2.17771924213, 7075.85073845880},
	{0.00000000105, 3.92288350713, 6961.01135775200},
	{0.00000000129, 2.19437663723, 3719.98584057399},
	{0.00000000129, 3.92939028141, 2961.23901282560},
	{0.00000000103, 4.84437874080, 550.04628449340},
	{0.00000000140, 4.00106611918, 14867.73751589219},
	{0.00000000121, 1.12112792863, 27676.61781984900},
	{0.00000000136, 5.86999649219, 765.79306444640},
	{0.00000000115, 4.67040651182, 2631.62262442320},
	{0.00000000104, 4.68807983986, 31449.82704275180},
	{0.00000000127, 4.38747549084, 2655.50106217100},
	{0.00000000101, 3.19137230221, 21791.69097326579},
	{0.00000000103, 6.01933155949, 18617.06830104720},
	{0.00000000138, 3.24007735232, 3480.31056622260},
	{0.00000000138, 2.88368956632, 3200.91428717700},
	{0.00000000099, 6.15309320274, 4555.41475632320},
	{0.00000000106, 0.15103316185, 32367.09765620760},
	{0.00000000100, 0.79624016231, 2651.97794382200},
	{0.00000000100, 5.44381740844, 3340.69699065480},
	{0.00000000100, 3.82154216379, 3340.52786274481},
	{0.00000000108, 4.12360777653, 249.90446074220},
	{0.00000000099, 5.78300785457, 5312.56460055460},
	{0.00000000115, 4.25203314320, 21000.91589075680},
	{0.00000000097, 1.57959120195, 31214.20143696780},
	{0.00000000103, 5.89679813880, 2125.81009707640},
	{0.00000000095, 3.12474282092, 3370.49447031000},
	{0.00000000095, 2.99902409772, 3310.73038308960},
	{0.00000000100, 5.85231379528, 3340.56237004920},
	{0.00000000100, 3.41304577695, 3340.66248335040},
	{0.00000000130, 1.10368790224, 26084.02180621620},
	{0.00000000102, 2.99188532210, 34115.11406927460},
	{0.00000000098, 0.97971049082, 1784.04427974440},
	{0.00000000101, 0.76366487468, 987.74627292800},
	{0.00000000129, 2.93910550678, 4591.44262300060},
	{0.00000000099, 0.66802090434, 1755.47168467910},
	{0.00000000124, 0.43401574548, 3532.07794646360},
	{0.00000000098, 5.40084312405, 24768.60218935220},
	{0.00000000104, 0.45494263259, 25827.98411954140},
	{0.00000000125, 1.84276822733, 30227.97847643040},
	{0.00000000102, 3.13389184379, 2214.74308759620},
	{0.00000000092, 1.71227607177, 1382.88734684660},
	{0.00000000095, 3.71389775515, 16975.73509085060},
	{0.00000000118, 5.39174563560, 3343.58137211640},
	{0.00000000118, 0.73202128304, 3337.64348128320},
	{0.00000000095, 0.21486058971, 11506.76976979360},
	{0.00000000105, 3.93832329439, 42388.93493630700},
	{0.00000000092, 1.91807045515, 155.35308913140},
	{0.00000000118, 5.04524690579, 2523.95910048460},
	{0.00000000124, 4.68642942116, 3532.04343915920},
	{0.00000000092, 1.46728426349, 31172.65064598300},
	{0.00000000102, 3.49211510967, 27946.74797991980},
	{0.00000000103, 2.64209634100, 20235.12282631040},
	{0.00000000120, 4.14012588910, 4845.90023579280},
	{0.00000000091, 5.12604154487, 14469.58851248400},
	{0.00000000118, 4.07684778770, 3396.99561277600},
	{0.00000000118, 2.04691913094, 3284.22924062360},
	{0.00000000112, 1.33743249046, 20995.39296644940},
	{0.00000000113, 3.43964396126, 948.19528790160},
	{0.00000000104, 4.79113313233, 3149.18141424040},
	{0.00000000121, 2.63871762078, 30774.50164257480},
	{0.00000000094, 3.66066776842, 10610.90210710760},
	{0.00000000112, 3.12304973052, 24606.13555322000},
	{0.00000000091, 2.73155116325, 78263.70942472259},
	{0.00000000094, 2.34382286871, 3346.74565263240},
	{0.00000000094, 3.77994404993, 3334.47920076720},
	{0.00000000090, 5.67779575724, 15746.77297752840},
	{0.00000000091, 1.14441655193, 50818.17620277360},
	{0.00000000091, 1.77732756353, 24093.27678917520},
	{0.00000000092, 1.72406156484, 12892.13260361820},
	{0.00000000092, 4.79118378192, 1957.72507985320},
	{0.00000000104, 3.56887817242, 440.82528487760},
	{0.00000000111, 2.46277729789, 27417.05701482520},
	{0.00000000098, 0.78906971914, 24532.97658356820},
	{0.00000000089, 0.64518470975, 3368.08129309939},
	{0.00000000089, 5.47858220889, 3313.14356030020},
	{0.00000000103, 4.62809111709, 1059.44924049200},
	{0.00000000092, 0.19061509302, 32509.20897294100},
	{0.00000000086, 5.37692725135, 11375.22780810720},
	{0.00000000095, 0.84451353118, 529.62365479180},
	{0.00000000120, 6.10556233132, 3202.09492982910},
	{0.00000000120, 0.01820458732, 3479.12992357050},
	{0.00000000086, 5.35131508131, 3762.63986785580},
	{0.00000000086, 0.77245183733, 2918.58498554380},
	{0.00000000090, 1.59914115894, 23546.75362303080},
	{0.00000000099, 4.06854104969, 3222.79962380780},
	{0.00000000099, 2.05522586895, 3458.42522959180},
	{0.00000000089, 1.74434664412, 22531.09060514659},
	{0.00000000107, 2.43223672203, 3369.59405667920},
	{0.00000000107, 3.69153019661, 3311.63079672040},
	{0.00000000095, 1.39752616185, 11560.07771607740},
	{0.00000000095, 2.86255032254, 8186.51266249260},
	{0.00000000091, 4.99433536381, 11876.46958573400},
	{0.00000000090, 3.38202540962, 4670.12451695980},
	{0.00000000106, 0.31966498575, 44535.10035278220},
	{0.00000000094, 1.95436076350, 796.28075316420},
	{0.00000000085, 5.95986051189, 809.47746944700},
	{0.00000000089, 1.64580481078, 6534.41316687600},
	{0.00000000084, 3.00387278181, 4777.78804089840},
	{0.00000000104, 2.76036150084, 3149.14690693600},
	{0.00000000116, 5.49068681139, 14694.50459434000},
	{0.00000000087, 6.08931791750, 12410.73130054860},
	{0.00000000089, 6.17341366104, 3332.93863472440},
	{0.00000000089, 6.23353856478, 3348.28621867520},
	{0.00000000087, 0.07344243508, 13105.43169905620},
	{0.00000000083, 3.79093953875, 1107.13880568480},
	{0.00000000115, 3.71714517813, 1971.95217385480},
	{0.00000000084, 0.92785811250, 2942.53073359440},
	{0.00000000082, 5.47710092100, 3330.04307165280},
	{0.00000000082, 0.64666599764, 3351.18178174680},
	{0.00000000112, 1.67391351043, 14900.69014277720},
	{0.00000000082, 0.58327444061, 22317.79150970859},
	{0.00000000084, 2.91538822338, 3083.59441895680},
	{0.00000000084, 3.20837869526, 3597.63043444280},
	{0.00000000095, 0.43601714434, 529.75827539740},
	{0.00000000085, 4.86833452232, 1055.85881184020},
	{0.00000000114, 1.28659258054, 3063.57743295840},
	{0.00000000114, 4.83717433810, 3617.64742044120},
	{0.00000000085, 2.68073374708, 54789.93668997800},
	{0.00000000086, 3.41488083723, 23009.94911093539},
	{0.00000000112, 3.74867220051, 5295.32957706340},
	{0.00000000083, 2.23224723099, 20103.04842211240},
	{0.00000000081, 2.93799035242, 1552.46752997960},
	{0.00000000081, 5.44968688605, 3190.71495157300},
	{0.00000000081, 0.67408003259, 3490.50990182660},
	{0.00000000094, 3.98513239500, 796.31526046860},
	{0.00000000096, 1.55756600347, 4049.60222897640},
	{0.00000000099, 5.83523223269, 309.27832265580},
	{0.00000000097, 5.98857826070, 45494.58142974879},
	{0.00000000106, 2.45927282558, 10191.41746323240},
	{0.00000000086, 4.76571809299, 2544.29716623120},
	{0.00000000089, 4.15046971529, 6311.52503745920},
	{0.00000000099, 1.41761453417, 19683.56377823720},
	{0.00000000085, 4.83661771107, 14715.84023480700},
	{0.00000000079, 5.53486573340, 31979.51800784640},
	{0.00000000102, 1.61863937790, 3524.48201360179},
	{0.00000000102, 4.50512754074, 3156.74283979780},
	{0.00000000084, 1.33635449934, 2942.39611298880},
	{0.00000000084, 2.73273226011, 4801.66647864620},
	{0.00000000079, 0.32952937845, 4423.87279463680},
	{0.00000000108, 5.38483133748, 52168.04361243240},
	{0.00000000081, 4.34146156368, 3347.74322735280},
	{0.00000000081, 1.78230535496, 3333.48162604680},
	{0.00000000088, 3.92710525226, 7277.40322740860},
	{0.00000000085, 4.58541459533, 2810.93871525740},
	{0.00000000096, 6.24098010472, 3357.44462774959},
	{0.00000000096, 6.16597212110, 3323.78022565000},
	{0.00000000106, 4.55137556149, 8692.32518983940},
	{0.00000000081, 1.10617868654, 1353.39052800780},
	{0.00000000082, 4.35697165540, 12988.11183083600},
	{0.00000000099, 2.09862978450, 3305.00463611600},
	{0.00000000099, 4.02513713414, 3376.22021728360},
	{0.00000000086, 3.61229605629, 3385.26625994000},
	{0.00000000086, 2.51147086235, 3295.95859345960},
	{0.00000000085, 1.07447319780, 3193.81799382840},
	{0.00000000085, 5.04929372084, 3487.40685957120},
	{0.00000000090, 4.06898880743, 18028.00347403899},
	{0.00000000088, 0.27514934792, 2751.01515718000},
	{0.00000000097, 1.73632170713, 4025.72379122860},
	{0.00000000093, 5.35390246552, 6474.52411610300},
	{0.00000000079, 1.18833525802, 50973.59660220779},
	{0.00000000099, 2.66906203023, 1481.40937134520},
	{0.00000000077, 0.70689947434, 430.53034413910},
	{0.00000000079, 3.73801262005, 1593.00504854690},
	{0.00000000078, 1.40210015770, 26887.36604973060},
	{0.00000000078, 4.43940167712, 8830.91338822380},
	{0.00000000077, 0.22206990977, 45088.66975562460},
	{0.00000000098, 3.09177354933, 3930.20969621960},
	{0.00000000076, 5.38805653575, 4029.24690957760},
	{0.00000000103, 3.41208170979, 6777.20408061740},
	{0.00000000080, 3.38163988195, 1954.71715036360},
	{0.00000000076, 5.18112770840, 9090.47419324760},
	{0.00000000086, 0.51330441730, 2544.33167353560},
	{0.00000000075, 0.45110684632, 14797.59736855860},
	{0.00000000078, 0.59621100214, 1324.94134054000},
	{0.00000000076, 4.03831555772, 30376.35263916660},
	{0.00000000081, 5.17054650880, 3404.34832500320},
	{0.00000000081, 0.95322040984, 3276.87652839640},
	{0.00000000084, 5.75075232210, 45331.39835959860},
	{0.00000000076, 0.82488746308, 26357.67508463600},
	{0.00000000085, 2.55464296384, 2810.90420795300},
	{0.00000000089, 3.18335652264, 1747.60737815290},
	{0.00000000076, 4.43291941041, 1125.86933910360},
	{0.00000000094, 4.04056491567, 9175.75444534820},
	{0.00000000073, 4.21658059964, 7476.47522884500},
	{0.00000000087, 4.26062486606, 15117.51235656420},
	{0.00000000095, 0.27332852104, 41592.63692949060},
	{0.00000000083, 5.84013662886, 4447.75123238460},
	{0.00000000081, 0.96354720612, 2917.53735417280},
	{0.00000000081, 1.65905428280, 2910.49111747480},
	{0.00000000072, 3.99322730607, 9384.84100807520},
	{0.00000000072, 4.77598503185, 4822.02179804500},
	{0.00000000078, 2.91014980690, 12715.43887348440},
	{0.00000000073, 3.00898976422, 6809.24369673700},
	{0.00000000076, 0.92136957038, 1008.54947088340},
	{0.00000000076, 0.09408730171, 81604.32185142238},
	{0.00000000078, 0.78353401757, 7768.00833968560},
	{0.00000000097, 1.67274419323, 13002.33892483760},
	{0.00000000080, 2.13855823313, 6151.60119860780},
	{0.00000000072, 4.24635867271, 927.83996850280},
	{0.00000000074, 4.00818928999, 6603.47430941570},
	{0.00000000073, 3.74531354996, 13635.12266415080},
	{0.00000000071, 4.21907550981, 5621.91023351320},
	{0.00000000071, 4.30769103159, 23539.64007603000},
	{0.00000000081, 1.38154115877, 19573.35745701780},
	{0.00000000083, 2.17147557718, 32522.51805564180},
	{0.00000000071, 4.38622964414, 12140.60114047780},
	{0.00000000092, 6.00108691734, 51371.74560561599},
	{0.00000000087, 0.00040074144, 24336.00539314920},
	{0.00000000074, 3.37129667806, 14061.72085502680},
	{0.00000000072, 3.85658396360, 3.54037200120},
	{0.00000000070, 3.54219776569, 5784.30955934260},
	{0.00000000087, 3.04532728173, 19403.77727388480},
	{0.00000000078, 1.21083630287, 36105.85908631560},
	{0.00000000073, 0.64702279583, 6493.29970563701},
	{0.00000000074, 5.24335831663, 5209.47182633600},
	{0.00000000074, 3.42555900934, 1214.80232962340},
	{0.00000000069, 0.17833800470, 51769.89460902420},
	{0.00000000095, 2.31307632185, 2104.53676637680},
	{0.00000000076, 1.79020883454, 3412.66816005460},
	{0.00000000076, 4.33355808410, 3268.55669334500},
	{0.00000000069, 2.65375644259, 21272.63667352099},
	{0.00000000071, 0.24644595466, 58857.03113654799},
	{0.00000000080, 2.54705461998, 6151.46657800220},
	{0.00000000069, 3.00854983951, 942.06206196900},
	{0.00000000089, 3.32856757738, 30639.85663863300},
	{0.00000000093, 5.84360510867, 17810.20093918380},
	{0.00000000072, 1.82581233210, 3.50586469680},
	{0.00000000068, 5.53841894464, 8550.08425303580},
	{0.00000000078, 3.75570725284, 422.66603761290},
	{0.00000000070, 5.89803541335, 2332.06295581640},
	{0.00000000071, 0.58121523893, 3371.60441144840},
	{0.00000000071, 5.54255167971, 3309.62044195120},
	{0.00000000090, 5.52634430161, 68241.87214462319},
	{0.00000000080, 3.39848386880, 9705.44541044280},
	{0.00000000072, 4.79564183453, 7899.55030137200},
	{0.00000000068, 0.73828510395, 8948.22825590860},
	{0.00000000067, 3.43458904912, 398.13174975600},
	{0.00000000070, 0.92757117435, 7843.69955780740},
	{0.00000000081, 2.34208554485, 94329.77528619739},
	{0.00000000077, 3.41420973216, 10507.80933288900},
	{0.00000000067, 4.00518542359, 6112.40297937220},
	{0.00000000075, 0.08956980412, 1585.14074202070},
	{0.00000000083, 4.29774312697, 11776.89992986440},
	{0.00000000067, 5.46536068061, 398.16625706040},
	{0.00000000069, 1.03119962025, 23553.86717003160},
	{0.00000000072, 0.53306813481, 3414.24788991940},
	{0.00000000072, 5.59069878383, 3266.97696348020},
	{0.00000000069, 0.16208433765, 3186.68719317540},
	{0.00000000069, 5.96168258099, 3494.53766022420},
	{0.00000000067, 6.25396245813, 26239.44220565039},
	{0.00000000068, 5.50719753243, 21957.68072774700},
	{0.00000000066, 4.30536092690, 11247.20896476980},
	{0.00000000077, 2.39444593371, 24076.44458812540},
	{0.00000000076, 1.01053497246, 13532.02988993220},
	{0.00000000084, 5.20101914018, 16858.41522263039},
	{0.00000000067, 2.23270360930, 38813.35657634920},
	{0.00000000077, 0.08344942418, 11368.18157140920},
	{0.00000000085, 1.07856400767, 4157.26575291499},
	{0.00000000089, 3.34177814481, 10817.08765554480},
	{0.00000000092, 5.18283466364, 1826.32112998330},
	{0.00000000066, 4.17657583502, 290.48547946960},
	{0.00000000070, 4.20909283675, 19669.33668423559},
	{0.00000000066, 1.79193621921, 225.82926841020},
	{0.00000000066, 2.30726767440, 16056.05130018419},
	{0.00000000068, 5.14021990728, 4897.18057365520},
	{0.00000000065, 3.86492506381, 3357.37731744680},
	{0.00000000065, 2.25884185483, 3323.84753595280},
	{0.00000000066, 2.06968124023, 3738.69411980520},
	{0.00000000066, 5.64719418861, 415.55249061210},
	{0.00000000066, 3.64570463979, 176.69373013380},
	{0.00000000069, 2.89405612412, 1442.27846241240},
	{0.00000000090, 0.09722302162, 2885.70306017250},
	{0.00000000090, 6.02654389702, 3795.52179322710},
	{0.00000000067, 3.85822640732, 13358.85927814740},
	{0.00000000064, 1.18618912997, 27579.52365095740},
	{0.00000000064, 3.92685739724, 16328.72425753579},
	{0.00000000064, 0.63002697211, 17412.05193577560},
	{0.00000000064, 6.13628411805, 12082.65513417120},
	{0.00000000081, 4.01871554294, 5135.87087042080},
	{0.00000000076, 4.53170041047, 6677.29270013650},
	{0.00000000064, 5.04465453700, 6563.90498517940},
	{0.00000000070, 3.08875495537, 12192.86145539060},
	{0.00000000086, 3.10176252564, 5355.23588148860},
	{0.00000000066, 2.24942817672, 19247.37655338240},
	{0.00000000067, 5.44247958738, 4396.47123854000},
	{0.00000000066, 3.60520160489, 12725.45343477500},
	{0.00000000066, 4.17490589025, 3348.78056328220},
	{0.00000000066, 1.94886102839, 3332.44429011740},
	{0.00000000066, 2.82536431302, 3377.60801731080},
	{0.00000000066, 3.29840260562, 3303.61683608880},
	{0.00000000062, 5.68273338954, 423.07507252700},
	{0.00000000073, 6.20381465446, 7250.04672742700},
	{0.00000000063, 2.65135900114, 15003.78291699580},
	{0.00000000066, 1.66118485339, 3738.82874041080},
	{0.00000000065, 3.73508000020, 3226.88298713140},
	{0.00000000065, 2.38868691844, 3454.34186626820},
	{0.00000000069, 1.02583344251, 5884.94410023539},
	{0.00000000074, 2.34087857776, 34363.36559755600},
	{0.00000000082, 2.24915344259, 6573.56132946100},
	{0.00000000070, 1.13818844355, 18977.17908300880},
	{0.00000000078, 3.71449046077, 12979.55317457600},
	{0.00000000062, 5.79908679635, 7056.99058496980},
	{0.00000000063, 5.86259871722, 379.37341387420},
	{0.00000000078, 4.78076869333, 17078.82786506920},
	{0.00000000064, 5.94075179050, 21258.40957951939},
	{0.00000000066, 4.07415031049, 1083.26036793700},
	{0.00000000061, 4.25199542760, 3870.28613814220},
	{0.00000000069, 0.74102855275, 6757.49092467520},
	{0.00000000061, 6.28276705909, 3870.32064544660},
	{0.00000000072, 6.22961111336, 3343.51344098960},
	{0.00000000072, 6.17734111246, 3337.71141241000},
	{0.00000000080, 2.74969157442, 58513.44564890100},
	{0.00000000061, 4.70971444185, 111.18664228760},
	{0.00000000081, 3.28784248765, 17498.31250894439},
	{0.00000000083, 0.44139928271, 15276.45587434740},
	{0.00000000062, 2.20405994372, 628.85158605010},
	{0.00000000074, 3.49171238880, 23937.85638974100},
	{0.00000000069, 2.20872117455, 1612.95133303160},
	{0.00000000071, 4.62757189666, 5621.77561290760},
	{0.00000000069, 5.05915612890, 4558.93787467220},
	{0.00000000079, 4.44340905126, 33716.96506586640},
	{0.00000000059, 5.27626474644, 11964.82507762700},
	{0.00000000065, 2.28717244651, 955.24152459960},
	{0.00000000073, 4.45773042596, 6695.45194740120},
	{0.00000000060, 5.88543199039, 11663.17049029600},
	{0.00000000066, 3.15140979990, 2899.78714182220},
	{0.00000000068, 4.39166177600, 16066.06586147480},
	{0.00000000069, 5.27824711820, 5884.90959293100},
	{0.00000000061, 4.50028976319, 2711.76084064970},
	{0.00000000082, 5.82155435799, 2636.97924208240},
	{0.00000000059, 3.94027260088, 9661.72649813780},
	{0.00000000058, 4.37436027757, 4565.98411137020},
	{0.00000000064, 1.28296566956, 48273.86178289020},
	{0.00000000061, 2.21724913476, 17013.90293236740},
	{0.00000000058, 3.58812622576, 14319.69103735720},
	{0.00000000061, 5.23380071753, 9161.52735134660},
	{0.00000000058, 3.67174690995, 27035.74021246680},
	{0.00000000080, 1.66405985109, 3377.26098962930},
	{0.00000000080, 4.45970706755, 3303.96386377030},
	{0.00000000063, 1.06524234771, 9722.71088583020},
	{0.00000000058, 5.44375722328, 16070.27839418580},
	{0.00000000070, 2.49172817408, 11787.60390551700},
	{0.00000000058, 2.63104479377, 37703.97802425580},
	{0.00000000057, 2.38086104702, 8294.17618643120},
	{0.00000000071, 1.30058846825, 6486.25346893900},
	{0.00000000062, 5.09860243429, 437.64389113990},
	{0.00000000058, 0.02736564724, 4712.02419015580},
	{0.00000000058, 6.09640127140, 1969.20066324380},
	{0.00000000065, 1.66267988598, 5525.86369599260},
	{0.00000000062, 4.76740419366, 37057.57749256620},
	{0.00000000056, 4.38558900981, 1619.99756972960},
	{0.00000000073, 2.03298379782, 3192.53370227350},
	{0.00000000059, 2.44348231635, 22854.59602180400},
	{0.00000000067, 6.18127021051, 41748.05732892480},
	{0.00000000060, 3.70695466613, 3348.19110590940},
	{0.00000000060, 2.41681225251, 3333.03374749019},
	{0.00000000056, 4.86250840352, 127.95153303460},
	{0.00000000056, 4.54875701369, 669.38910461740},
	{0.00000000070, 6.23515306355, 418.50432280700},
	{0.00000000073, 1.03020384035, 3189.56475685690},
	{0.00000000055, 1.77445448768, 3325.87514437420},
	{0.00000000055, 4.34931243097, 3355.34970902540},
	{0.00000000057, 4.00512521652, 1022.77656488500},
	{0.00000000065, 5.63019442143, 41236.03871706720},
	{0.00000000057, 1.32005258528, 15842.75220474620},
	{0.00000000062, 3.76071367297, 222.86032299360},
	{0.00000000058, 4.55616432881, 26637.59120905859},
	{0.00000000063, 4.40389547553, 4136.92768716840},
	{0.00000000055, 5.67519189985, 13738.21543836940},
	{0.00000000055, 5.08574798354, 25665.51748340920},
	{0.00000000057, 5.20075468392, 41427.48698317880},
	{0.00000000061, 0.88840285577, 7630.40046236940},
	{0.00000000055, 1.23041444279, 838.96928775040},
	{0.00000000062, 0.84993046181, 11030.38675098280},
	{0.00000000054, 3.91709923051, 8528.74361203340},
	{0.00000000059, 3.56862936961, 16342.95135153740},
	{0.00000000067, 4.29317097897, 13366.04013545100},
	{0.00000000057, 5.77490231900, 33163.39566302400},
	{0, 0, 0}
};

struct vsop87_term mars_y1[] = {
	{0.01427324210, 3.14159265359, 0.00000000000},
	{0.00551063753, 3.52128320402, 6681.22485339960},
	{0.00077091913, 3.86082685753, 10021.83728009940},
	{0.00037310491, 1.16016958445, 3340.61242669980},
	{0.00009582122, 4.19942354479, 13362.44970679920},
	{0.00002617695, 1.47284555520, 3337.08930835080},
	{0.00002611572, 4.65030772498, 3344.13554504880},
	{0.00001162955, 4.53778503576, 16703.06213349900},
	{0.00000900678, 1.74256260709, 1059.38193018920},
	{0.00000431990, 1.20122419783, 2942.46342329160},
	{0.00000389982, 4.38779713561, 5621.84292321040},
	{0.00000380122, 4.93073729444, 3738.76143010800},
	{0.00000394355, 4.91119397796, 6684.74797174860},
	{0.00000336661, 3.63990879619, 3149.16416058820},
	{0.00000333604, 0.88647104051, 3185.19202726560},
	{0.00000318324, 2.48122345477, 3532.06069281140},
	{0.00000316743, 5.23316524269, 3496.03282613400},
	{0.00000311468, 2.66149474204, 2544.31441988340},
	{0.00000283006, 3.01270555394, 796.29800681640},
	{0.00000259715, 3.45285007540, 4136.91043351620},
	{0.00000204277, 1.62196956205, 1194.44701022460},
	{0.00000140506, 4.87611060370, 20043.67456019880},
	{0.00000159094, 2.00474963161, 1589.07289528380},
	{0.00000133054, 3.06497749499, 5884.92684658320},
	{0.00000132221, 2.12903733409, 4399.99435688900},
	{0.00000126748, 1.25031299906, 6677.70173505060},
	{0.00000103023, 4.48653117588, 5486.77784317500},
	{0.00000128526, 0.22328095820, 1592.59601363280},
	{0.00000101352, 3.97061208738, 3339.63210563160},
	{0.00000101253, 2.15203295056, 3341.59274776800},
	{0.00000090029, 4.30631925657, 3870.30339179440},
	{0.00000083977, 5.10438299040, 1990.74501704100},
	{0.00000079143, 2.34466378410, 426.59819087600},
	{0.00000078865, 3.69323302292, 2146.16541647520},
	{0.00000077132, 5.35293989072, 7079.37385680780},
	{0.00000081297, 4.10751911033, 5092.15195811580},
	{0.00000063835, 3.70028305724, 2388.89402044920},
	{0.00000057287, 5.21462580599, 10025.36039844840},
	{0.00000056119, 0.33784373101, 3097.88382272579},
	{0.00000069177, 5.81634207831, 5088.62883976680},
	{0.00000075448, 2.03864215811, 4535.05943692440},
	{0.00000055487, 5.92856755611, 9492.14631500480},
	{0.00000052915, 5.76012128769, 3583.34103067380},
	{0.00000070493, 2.29434635167, 2787.04302385740},
	{0.00000050121, 0.89975887576, 4690.47983635860},
	{0.00000056817, 4.97137861156, 7.11354700080},
	{0.00000054006, 1.17848219667, 2957.71589447660},
	{0.00000049131, 6.22165192434, 191.44826611160},
	{0.00000049195, 0.93502149184, 6681.20759974740},
	{0.00000057046, 3.78172576129, 3894.18182954220},
	{0.00000043884, 2.32328576357, 4292.33083295040},
	{0.00000049195, 2.96579325551, 6681.24210705180},
	{0.00000046747, 4.90372286627, 3723.50895892300},
	{0.00000053525, 2.72772193635, 155.42039943420},
	{0.00000047371, 4.07058844113, 6489.77658728800},
	{0.00000037259, 4.77560729076, 3553.91152213780},
	{0.00000036147, 1.35491513022, 3127.31333126180},
	{0.00000035282, 1.23254843453, 6525.80445396540},
	{0.00000033179, 3.51707222671, 3333.49887969900},
	{0.00000034809, 4.18192362595, 1748.01641306700},
	{0.00000039091, 3.80640955175, 7477.52286021600},
	{0.00000029410, 3.77101802200, 6254.62666252360},
	{0.00000030407, 5.07104519098, 1349.86740965880},
	{0.00000027239, 1.35659219412, 553.56940284240},
	{0.00000027517, 2.17565128432, 12303.06777661000},
	{0.00000027442, 0.62028270680, 4933.20844033260},
	{0.00000028052, 2.66985509990, 3347.72597370060},
	{0.00000025853, 1.75047537209, 2810.92146160520},
	{0.00000027323, 0.02095781900, 951.71840625060},
	{0.00000024444, 4.65604652875, 1066.49547719000},
	{0.00000029191, 1.08806577148, 639.89728631400},
	{0.00000021261, 2.27370365360, 4929.68532198360},
	{0.00000023424, 2.34960187821, 382.89653222320},
	{0.00000024778, 2.29327452220, 2118.76386037840},
	{0.00000018679, 5.30877056453, 242.72860397400},
	{0.00000018299, 5.31873037196, 9623.68827669120},
	{0.00000017050, 0.73617668321, 3320.25710730100},
	{0.00000016932, 5.38596885509, 3360.96774609859},
	{0.00000016989, 5.21435353899, 23384.28698689860},
	{0.00000016202, 5.29675788446, 6681.15754309680},
	{0.00000015998, 5.16249823288, 1052.26838318840},
	{0.00000017035, 1.13076170583, 6674.11130639880},
	{0.00000014564, 0.35017458981, 10018.31416175040},
	{0.00000016726, 5.37963018761, 7210.91581849420},
	{0.00000017704, 2.46673313442, 7740.60678358880},
	{0.00000016030, 2.67705196127, 3325.35995551480},
	{0.00000015941, 3.44411402721, 3355.86489788480},
	{0.00000016202, 4.88823057997, 6681.29216370240},
	{0.00000013784, 6.26149521160, 12832.75874170460},
	{0.00000012927, 4.16022928360, 2281.23049651060},
	{0.00000016504, 3.81227944624, 4562.46099302120},
	{0.00000014766, 2.06347095335, 2274.11694950980},
	{0.00000012471, 2.52252246459, 6682.20517446780},
	{0.00000012672, 5.48550960002, 5331.35744374080},
	{0.00000013354, 1.61202229522, 2288.34404351140},
	{0.00000013054, 2.91942689347, 3767.21061757580},
	{0.00000010891, 0.68185023633, 6438.49624942560},
	{0.00000010802, 6.26800346088, 529.69096509460},
	{0.00000011971, 0.35152568832, 536.80451209540},
	{0.00000011249, 0.90083527171, 522.57741809380},
	{0.00000010294, 2.38590207291, 7875.67186362420},
	{0.00000009941, 5.46223635331, 398.14900340820},
	{0.00000010388, 1.43082762360, 5614.72937620960},
	{0.00000012500, 5.71657132706, 10419.98628350760},
	{0.00000010337, 3.30570903459, 10021.85453375160},
	{0.00000009227, 5.18749993680, 6836.64525283380},
	{0.00000008846, 6.25668148581, 3205.54734666440},
	{0.00000011308, 5.02952138409, 6041.32756708560},
	{0.00000008356, 6.14980327580, 3475.67750673520},
	{0.00000010337, 1.27493070103, 10021.82002644720},
	{0.00000007741, 5.02756320298, 1751.53953141600},
	{0.00000007737, 5.74646451299, 2700.71514038580},
	{0.00000008096, 5.53364318065, 13365.97282514820},
	{0.00000007402, 2.50809887388, 15643.68020330980},
	{0.00000007789, 2.64751868576, 6127.65545055720},
	{0.00000007616, 3.55216836649, 6151.53388830500},
	{0.00000006888, 0.93821376086, 5628.95647021120},
	{0.00000006653, 3.04079800434, 3178.14579056760},
	{0.00000006214, 1.52971949909, 6298.32832117640},
	{0.00000006257, 3.08467357092, 3503.07906283200},
	{0.00000006358, 4.02054439730, 3316.73398895200},
	{0.00000007832, 4.06330977332, 5729.50644714900},
	{0.00000006311, 2.10530552076, 3364.49086444760},
	{0.00000006743, 4.45650314997, 9830.38901398780},
	{0.00000005783, 4.93861223005, 213.29909543800},
	{0.00000007061, 3.40544179657, 8962.45534991020},
	{0.00000007288, 5.34922729060, 6894.52394883760},
	{0.00000006005, 0.07486054185, 853.19638175200},
	{0.00000005569, 4.14856676480, 10818.13528691580},
	{0.00000005114, 5.13541858012, 8031.09226305840},
	{0.00000005536, 2.55163508803, 1758.65307841680},
	{0.00000005305, 2.64975260653, 2648.45482547300},
	{0.00000006551, 4.25238620522, 6680.24453233140},
	{0.00000005494, 6.10090252680, 6923.95345737360},
	{0.00000004643, 1.64332559992, 7234.79425624200},
	{0.00000005078, 4.68151022722, 1596.18644228460},
	{0.00000004842, 5.16943706039, 6158.64743530580},
	{0.00000004542, 2.44702860525, 7064.12138562280},
	{0.00000005003, 2.03413689759, 433.71173787680},
	{0.00000004336, 5.65658515228, 12964.30070339100},
	{0.00000004779, 5.76036610082, 6144.42034130420},
	{0.00000004652, 2.63332997018, 2914.01423582380},
	{0.00000004580, 1.41608119487, 5085.03841111500},
	{0.00000003970, 5.05439636873, 3312.16323923200},
	{0.00000005474, 0.24241650562, 7632.94325965020},
	{0.00000004214, 3.49717782339, 4032.77002792660},
	{0.00000003894, 1.06212840662, 3369.06161416760},
	{0.00000003817, 3.90998982450, 640.87760738220},
	{0.00000003721, 3.02454190848, 3346.13535100720},
	{0.00000003720, 3.09809824482, 3335.08950239240},
	{0.00000004799, 3.06592497293, 6688.33840040040},
	{0.00000004128, 1.57312639696, 9866.41688066520},
	{0.00000003556, 0.96329089902, 8273.82086703240},
	{0.00000003629, 5.96999972361, 3304.58456002240},
	{0.00000003622, 4.42683813801, 1581.95934828300},
	{0.00000003577, 0.15378568235, 3376.64029337720},
	{0.00000004442, 2.50701068861, 11773.37681151540},
	{0.00000003832, 1.42518467938, 8969.56889691100},
	{0.00000003410, 5.22584770856, 10021.90459040220},
	{0.00000004071, 1.88545339582, 3863.18984479360},
	{0.00000003884, 1.89998927465, 8955.34180290940},
	{0.00000004357, 4.12849233981, 2818.03500860600},
	{0.00000003574, 2.44194831685, 1744.42598441520},
	{0.00000003245, 5.21748676321, 149.56319713460},
	{0.00000003156, 1.61783457949, 3980.50971301380},
	{0.00000003130, 3.88131318196, 3344.49376205780},
	{0.00000003117, 2.24732563525, 3336.73109134180},
	{0.00000003400, 5.63288877479, 10021.76996979660},
	{0.00000003019, 2.47972483962, 419.48464387520},
	{0.00000003128, 3.75424825002, 8432.76438481560},
	{0.00000003010, 5.98032518225, 10551.52824519400},
	{0.00000003084, 0.21639027416, 13358.92658845020},
	{0.00000002934, 0.51109476282, 2487.41604494780},
	{0.00000002876, 2.58450457222, 8270.29774868340},
	{0.00000003502, 1.28355216461, 5099.26550511660},
	{0.00000003129, 2.49440075955, 5459.37628707820},
	{0.00000003208, 1.56658459531, 2699.73481931760},
	{0.00000002528, 4.21676297033, 3333.56619000180},
	{0.00000003353, 2.01774997575, 9225.53927328300},
	{0.00000002447, 4.92763323216, 2766.26762836500},
	{0.00000002993, 4.34648489293, 3981.49003408200},
	{0.00000002323, 5.60449935667, 9381.93999378540},
	{0.00000002315, 3.69144185016, 8429.24126646660},
	{0.00000002186, 5.03043655370, 4407.10790388980},
	{0.00000002333, 3.51432934451, 8827.39026987480},
	{0.00000002510, 0.31296140818, 16173.37116840440},
	{0.00000002391, 5.51442084031, 9808.53818466140},
	{0.00000002153, 6.04353805522, 1221.84856632140},
	{0.00000002428, 2.80037448528, 11081.21921028860},
	{0.00000002711, 5.83797793809, 5828.02847164760},
	{0.00000002751, 2.14536436215, 6467.92575796160},
	{0.00000002111, 2.06365035238, 15113.98923821520},
	{0.00000002486, 0.24395631995, 6283.07584999140},
	{0.00000001887, 4.88255979507, 76.26607127560},
	{0.00000001842, 1.21823822975, 1692.16566950240},
	{0.00000002114, 1.63888168497, 3347.65866339780},
	{0.00000001862, 6.06481817113, 13760.59871020740},
	{0.00000001717, 3.64496480459, 13362.46696045140},
	{0.00000001744, 0.22355971935, 6816.28993343500},
	{0.00000001781, 0.87193778743, 6660.44945790720},
	{0.00000001717, 1.61419317923, 13362.43245314700},
	{0.00000001771, 0.59857555923, 10973.55568635000},
	{0.00000001856, 1.06629718188, 3914.95722503460},
	{0.00000001668, 0.60430699219, 3340.62968035200},
	{0.00000001738, 2.07820814390, 3281.23856478620},
	{0.00000001612, 5.64202929021, 3.52311834900},
	{0.00000002059, 5.55274042469, 26724.89941359840},
	{0.00000002154, 0.15347526650, 6872.67311951120},
	{0.00000001831, 4.08960877991, 6247.51311552280},
	{0.00000001814, 3.79433881585, 220.41264243880},
	{0.00000001698, 4.04559929798, 3399.98628861340},
	{0.00000001668, 4.85673659823, 3340.59517304760},
	{0.00000001533, 1.46147125549, 3877.41693879520},
	{0.00000001638, 1.96384800147, 6040.34724601740},
	{0.00000001500, 4.88545461881, 574.34479833480},
	{0.00000001628, 2.88073838002, 10022.81760116760},
	{0.00000001499, 4.57008817883, 206.18554843720},
	{0.00000001807, 3.79979610143, 6696.47732458460},
	{0.00000001592, 4.82870996320, 2921.12778282460},
	{0.00000001767, 1.07911448965, 6660.86953400080},
	{0.00000001540, 2.31576232583, 8439.87793181640},
	{0.00000001378, 2.72606150117, 11216.28429032400},
	{0.00000001685, 3.32579486669, 7107.82304427560},
	{0.00000001849, 2.11621487275, 10575.40668294180},
	{0.00000001360, 0.70553844479, 3074.00538497800},
	{0.00000001302, 2.98694021349, 6665.97238221460},
	{0.00000001305, 5.68793695675, 6701.58017279840},
	{0.00000001584, 5.82704739199, 8671.96987044060},
	{0.00000001529, 5.28219831652, 3546.79797513700},
	{0.00000001498, 1.47147884583, 10014.72373309860},
	{0.00000001231, 2.92458380429, 1228.96211332220},
	{0.00000001494, 0.80790809310, 3134.42687826260},
	{0.00000001411, 2.84106148241, 18984.29263000960},
	{0.00000001219, 5.41837474083, 3607.21946842160},
	{0.00000001195, 5.80939850807, 3361.38782219220},
	{0.00000001122, 5.95969052898, 110.20632121940},
	{0.00000001159, 5.00834942258, 11371.70468975820},
	{0.00000001161, 0.30017004686, 3319.83703120740},
	{0.00000001108, 1.71153266675, 12935.85151592320},
	{0.00000001503, 3.03363878314, 6702.00024889200},
	{0.00000001157, 5.78852492425, 10235.13637553740},
	{0.00000001089, 0.71433907378, 3169.93955608060},
	{0.00000001068, 2.16721753485, 6684.81528205140},
	{0.00000001093, 0.92444199357, 6531.66165626500},
	{0.00000001373, 2.53168716711, 1039.02661079040},
	{0.00000001415, 1.04970568569, 647.01083331480},
	{0.00000001037, 1.46452965647, 4555.34744602040},
	{0.00000001104, 1.77456576036, 4569.57454002200},
	{0.00000001029, 3.75910353418, 6261.74020952440},
	{0.00000001002, 0.43098035565, 9779.10867612540},
	{0.00000001020, 5.40929385267, 3511.28529731900},
	{0.00000001063, 1.72982874710, 6677.63442474780},
	{0.00000001245, 4.07589616535, 10177.25767953360},
	{0.00000000993, 2.20093983157, 8425.65083781480},
	{0.00000000938, 4.81919246949, 4989.05918389720},
	{0.00000000922, 2.99264828336, 9468.26787725700},
	{0.00000000918, 4.81951639068, 13171.00144068760},
	{0.00000000889, 4.77878515126, 3561.02506913860},
	{0.00000000887, 0.78830636358, 3760.09707057500},
	{0.00000000998, 3.90126093816, 11769.85369316640},
	{0.00000000874, 0.12089365253, 956.28915597060},
	{0.00000001056, 4.56585915944, 2906.90068882300},
	{0.00000000928, 4.41590375701, 9070.11887384880},
	{0.00000000840, 4.83825664806, 2125.87740737920},
	{0.00000000880, 0.90436253322, 3313.21087060300},
	{0.00000001010, 5.75999052682, 3253.30422216000},
	{0.00000000870, 5.21940713846, 3368.01398279660},
	{0.00000000967, 2.95682389977, 9595.23908922340},
	{0.00000000825, 4.16526325583, 1861.74585263540},
	{0.00000000819, 1.28139939096, 3120.19978426100},
	{0.00000000812, 0.30945449993, 9168.64089834740},
	{0.00000000974, 0.36385416352, 3427.92063123960},
	{0.00000001092, 4.03195323532, 2803.80791460440},
	{0.00000001121, 5.85882470690, 16706.58525184800},
	{0.00000000757, 4.49953469679, 14158.74771361560},
	{0.00000000744, 1.14486727666, 3443.70520091840},
	{0.00000000769, 1.88091883970, 9638.94074787620},
	{0.00000000727, 2.52800596414, 10404.73381232260},
	{0.00000000800, 3.22072343557, 6518.75821726740},
	{0.00000000725, 1.60568151338, 6475.03930496240},
	{0.00000000730, 1.45023184025, 6709.67404086740},
	{0.00000000782, 1.30886254759, 632.78373931320},
	{0.00000000794, 5.99496548901, 16304.91313009080},
	{0.00000000750, 4.51007684915, 3296.89351439480},
	{0.00000000688, 3.43319222752, 10028.95082710020},
	{0.00000000737, 1.61370530514, 3384.33133900480},
	{0.00000000646, 4.99729356736, 3237.51965248120},
	{0.00000000674, 1.39940720264, 2807.39834325620},
	{0.00000000845, 5.55182215578, 9499.25986200560},
	{0.00000000627, 5.82304741654, 13149.15061136120},
	{0.00000000629, 2.87628485086, 1214.73501932060},
	{0.00000000687, 4.23661989758, 13517.87010623340},
	{0.00000000630, 1.23559488085, 6604.95878212400},
	{0.00000000710, 2.32420903412, 6460.81221096080},
	{0.00000000701, 5.09953279615, 3311.18291816379},
	{0.00000000701, 1.02423412249, 3370.04193523580},
	{0.00000000608, 4.60746109269, 949.17560896980},
	{0.00000000596, 1.14907377568, 12566.15169998280},
	{0.00000000716, 1.82681889911, 12310.18132361080},
	{0.00000000633, 0.43972121001, 692.15760122680},
	{0.00000000576, 2.64908131601, 13916.01910964160},
	{0.00000000646, 4.20443037448, 2111.65031337760},
	{0.00000000544, 0.40037320261, 16699.53901514999},
	{0.00000000548, 2.52376915314, 3340.67973700260},
	{0.00000000539, 3.72942723734, 2178.13772229200},
	{0.00000000623, 0.15818615271, 10264.56588407340},
	{0.00000000539, 5.53271145759, 3490.17562383440},
	{0.00000000557, 5.56701497497, 13362.51701710200},
	{0.00000000563, 1.10897333902, 1437.17561419860},
	{0.00000000536, 5.69295314880, 2693.60159338500},
	{0.00000000647, 5.65118044969, 4392.88080988820},
	{0.00000000530, 4.63403553551, 1375.77379984580},
	{0.00000000538, 4.72229720906, 3873.82651014340},
	{0.00000000584, 0.55159339980, 4193.80880845180},
	{0.00000000630, 2.13231136184, 11243.68584642080},
	{0.00000000505, 6.09305482682, 9485.03276800400},
	{0.00000000501, 1.36918398108, 224.34479570190},
	{0.00000000669, 5.22911771220, 2707.82868738660},
	{0.00000000670, 4.37490154824, 6657.34641565180},
	{0.00000000491, 2.60376575150, 3774.32416457660},
	{0.00000000513, 3.36932239157, 3232.94890276120},
	{0.00000000590, 4.86990668927, 6034.21402008480},
	{0.00000000577, 2.26728370057, 18454.60166491500},
	{0.00000000613, 2.82948093577, 5989.06725217280},
	{0.00000000535, 3.23990732356, 5642.19824260920},
	{0.00000000492, 2.75437635016, 3448.27595063840},
	{0.00000000477, 2.98529100201, 6843.69148953180},
	{0.00000000483, 2.08187058985, 12295.95422960920},
	{0.00000000463, 6.10084466162, 3229.42578441220},
	{0.00000000506, 2.38698988700, 2301.58581590939},
	{0.00000000540, 3.87479718518, 7903.07341972100},
	{0.00000000446, 4.30997409674, 6048.44111408640},
	{0.00000000444, 2.38797656832, 6705.10329114740},
	{0.00000000443, 0.02289876855, 3451.79906898740},
	{0.00000000530, 5.18892175358, 7255.56965173440},
	{0.00000000557, 5.97553834508, 13362.38239649640},
	{0.00000000548, 2.93176743519, 3340.54511639700},
	{0.00000000494, 1.91461298039, 13207.02930736500},
	{0.00000000402, 0.14917407616, 6571.01853218020},
	{0.00000000413, 2.77393455325, 8799.98871377800},
	{0.00000000488, 1.41120383831, 2221.85663459700},
	{0.00000000398, 1.17032491098, 7895.95987272020},
	{0.00000000421, 2.92811239290, 4379.63903749020},
	{0.00000000419, 0.51900494769, 135.06508003540},
	{0.00000000472, 5.05179451193, 4936.79886898440},
	{0.00000000515, 5.86680894517, 13119.72110282519},
	{0.00000000515, 3.61483236959, 6675.70192909220},
	{0.00000000407, 5.97123577955, 3289.33208883739},
	{0.00000000407, 0.15253113909, 3391.89276456221},
	{0.00000000474, 0.17715160287, 13892.14067189380},
	{0.00000000385, 5.77663237032, 10596.18207843420},
	{0.00000000366, 6.20989798780, 2384.32327072920},
	{0.00000000384, 4.23498307074, 6685.10618875760},
	{0.00000000425, 1.30634943039, 11614.43329373220},
	{0.00000000370, 6.07331404337, 3274.12501778540},
	{0.00000000361, 0.89534079814, 12721.57209941700},
	{0.00000000400, 4.53551800839, 9588.12554222260},
	{0.00000000360, 0.05053136141, 3407.09983561420},
	{0.00000000453, 0.52827133920, 3113.13629391080},
	{0.00000000338, 0.67656842155, 9380.95967271720},
	{0.00000000337, 3.00609814338, 15.25247118500},
	{0.00000000422, 0.62250110261, 19513.98359510420},
	{0.00000000353, 2.87159892794, 20.35531939880},
	{0.00000000373, 4.44069988433, 10020.85695903120},
	{0.00000000375, 2.90507995378, 11610.91017538320},
	{0.00000000318, 6.01470564020, 5724.93569742900},
	{0.00000000335, 2.98604214434, 2938.94030494260},
	{0.00000000374, 2.47243769504, 3415.39402526710},
	{0.00000000340, 2.07425079531, 7321.12213971360},
	{0.00000000328, 6.22461934829, 16460.33352952499},
	{0.00000000369, 2.13551229622, 14584.29827312060},
	{0.00000000412, 5.59494780647, 3568.08855948880},
	{0.00000000310, 3.13767541137, 14421.83163698840},
	{0.00000000330, 0.49540756155, 3318.76159737340},
	{0.00000000330, 5.62835935709, 3362.46325602620},
	{0.00000000350, 4.05599588288, 9602.35263622420},
	{0.00000000329, 3.37223997989, 10042.61267559180},
	{0.00000000313, 3.98991353862, 323.50541665740},
	{0.00000000340, 3.21395005886, 22324.90505670940},
	{0.00000000352, 0.51052280975, 263.08392337280},
	{0.00000000390, 0.53675687816, 6717.25272007700},
	{0.00000000298, 5.27506560855, 3416.87849797540},
	{0.00000000387, 3.10555839309, 7373.38245462640},
	{0.00000000291, 6.25952120602, 6645.19698672220},
	{0.00000000293, 2.11849465997, 2675.85638156980},
	{0.00000000346, 3.68559919908, 3265.83082813250},
	{0.00000000282, 1.51830354780, 5732.04924442980},
	{0.00000000304, 2.34810025389, 7203.80227149340},
	{0.00000000280, 0.05535474901, 3397.51080163540},
	{0.00000000280, 6.06841216963, 3283.71405176420},
	{0.00000000338, 4.73513321530, 4459.36821880260},
	{0.00000000280, 1.83816934995, 6688.27109009760},
	{0.00000000268, 1.68224981136, 11766.26326451460},
	{0.00000000271, 2.02912231281, 11780.49035851620},
	{0.00000000363, 1.22201726104, 10001.06188460700},
	{0.00000000265, 1.44919316453, 7910.18696672180},
	{0.00000000274, 0.01061104159, 13936.79450513400},
	{0.00000000357, 1.63911041022, 1162.47470440780},
	{0.00000000259, 1.56009469393, 5032.77809620220},
	{0.00000000253, 0.12054819282, 17101.21113690720},
	{0.00000000253, 1.95240011543, 16703.04487984680},
	{0.00000000253, 5.79374784837, 6947.83189512140},
	{0.00000000278, 4.67472382984, 7322.10246078180},
	{0.00000000282, 0.09141768691, 860.30992875280},
	{0.00000000252, 4.72342010347, 533.21408344360},
	{0.00000000322, 0.95155923546, 162.46663613220},
	{0.00000000253, 3.98317215792, 16703.07938715119},
	{0.00000000243, 4.59637992289, 5244.04923920100},
	{0.00000000246, 1.15950003329, 3304.00706139560},
	{0.00000000246, 4.96426688535, 3377.21779200400},
	{0.00000000246, 2.02033156272, 16276.46394262300},
	{0.00000000235, 4.67612716033, 16858.48253293320},
	{0.00000000239, 1.58157022935, 5305.45105355380},
	{0.00000000225, 2.07472210939, 10018.24685144760},
	{0.00000000248, 2.91218176275, 2075.04494807340},
	{0.00000000284, 0.56682884608, 10156.90236013480},
	{0.00000000272, 5.85412476416, 14712.31711645800},
	{0.00000000226, 2.11036808486, 4039.88357492740},
	{0.00000000243, 5.89092212082, 30065.51184029820},
	{0.00000000218, 1.77859119613, 3029.77162783140},
	{0.00000000230, 0.86938411789, 103.09277421860},
	{0.00000000221, 4.00610570086, 4005.36847182980},
	{0.00000000216, 2.67268933641, 15664.03552270859},
	{0.00000000228, 1.42035440998, 17924.91069982040},
	{0.00000000224, 2.50666934513, 10025.42770875120},
	{0.00000000216, 4.14679941286, 10037.08975128440},
	{0.00000000213, 3.70755457019, 10448.43547097540},
	{0.00000000211, 2.33158804950, 6944.30877677240},
	{0.00000000215, 2.61875466736, 3212.59358336240},
	{0.00000000222, 2.20339233927, 12323.42309600880},
	{0.00000000222, 0.48962551079, 14314.16811304980},
	{0.00000000288, 1.38313040903, 16062.18452611680},
	{0.00000000234, 5.47802199777, 3185.25933756840},
	{0.00000000215, 5.96415874701, 23.87843774780},
	{0.00000000213, 1.54853404609, 1545.35398297880},
	{0.00000000201, 5.99546009327, 1835.32461760680},
	{0.00000000198, 4.93753556250, 6578.13207918100},
	{0.00000000222, 0.61578505780, 3495.96551583120},
	{0.00000000204, 3.50489963320, 3468.63127003720},
	{0.00000000213, 5.38883317666, 7747.72033058960},
	{0.00000000209, 3.74698259846, 3230.40610548040},
	{0.00000000195, 3.20214800961, 1903.43681250120},
	{0.00000000193, 4.34393649097, 3651.45322556820},
	{0.00000000242, 2.25789470004, 6621.85099148600},
	{0.00000000190, 0.52807642845, 2480.30249794700},
	{0.00000000182, 3.98767129842, 8542.97070603500},
	{0.00000000200, 2.50870443352, 6677.34351804160},
	{0.00000000249, 3.21268045476, 699.27114822760},
	{0.00000000202, 6.20004176432, 12012.58229714040},
	{0.00000000205, 6.27860457332, 2945.98654164060},
	{0.00000000183, 5.82529586360, 15508.61512327440},
	{0.00000000222, 1.76032428059, 8982.81066930900},
	{0.00000000239, 5.27791146118, 6106.88005506480},
	{0.00000000200, 1.41969751355, 10001.48196070061},
	{0.00000000171, 2.86664255530, 6756.00645196690},
	{0.00000000174, 1.67207569825, 6418.14093002680},
	{0.00000000182, 5.80987770417, 6887.41040183680},
	{0.00000000171, 5.86062733644, 5618.31980486140},
	{0.00000000170, 4.73099425239, 6456.88005769770},
	{0.00000000168, 6.18245369751, 13575.74880223720},
	{0.00000000184, 2.36721526307, 7218.02936549500},
	{0.00000000166, 2.25679462872, 15650.79375031060},
	{0.00000000212, 3.23189207115, 13363.43002786740},
	{0.00000000169, 5.08935042454, 2655.56837247380},
	{0.00000000168, 6.08539442812, 7314.00859271280},
	{0.00000000159, 1.06451661811, 2008.55753915900},
	{0.00000000177, 3.64016669145, 6686.74777770700},
	{0.00000000156, 1.91880783576, 19402.79695281660},
	{0.00000000192, 1.70878546664, 2751.54759969160},
	{0.00000000153, 3.28724376065, 3347.29609057390},
	{0.00000000153, 2.83652315799, 3333.92876282570},
	{0.00000000154, 0.41279284728, 3499.55594448300},
	{0.00000000169, 0.15684943582, 19645.52555679060},
	{0.00000000167, 3.08668060635, 931.36308685180},
	{0.00000000195, 5.14066365776, 6546.15977336420},
	{0.00000000183, 4.39590374650, 1332.05488754080},
	{0.00000000186, 1.43141139959, 4025.65648092580},
	{0.00000000158, 3.03919160267, 14556.89671702380},
	{0.00000000143, 3.74906711980, 13553.89797291080},
	{0.00000000171, 2.92431770122, 1062.90504853820},
	{0.00000000140, 2.99678875427, 8584.66166590080},
	{0.00000000150, 5.75275864312, 735.87651353180},
	{0.00000000148, 1.43175701702, 3053.65006557920},
	{0.00000000189, 2.84693993450, 2409.24933984800},
	{0.00000000140, 5.61689203595, 6691.86151874940},
	{0.00000000135, 2.53133290785, 2604.73591316800},
	{0.00000000135, 3.59243401079, 4076.48894023160},
	{0.00000000175, 4.87680231442, 20.77539549240},
	{0.00000000177, 0.10410066671, 8958.93223156120},
	{0.00000000178, 3.44819299296, 2284.75361485960},
	{0.00000000131, 0.64621084098, 3191.04922956520},
	{0.00000000177, 4.22515628202, 4672.66731424060},
	{0.00000000131, 2.84299146166, 11670.28403729680},
	{0.00000000133, 4.52679079571, 18606.49894600020},
	{0.00000000136, 5.45594231263, 9374.82644678460},
	{0.00000000133, 5.74550598907, 5195.24473233440},
	{0.00000000169, 1.71248734234, 14.22709400160},
	{0.00000000175, 3.29046570107, 8965.97846825920},
	{0.00000000161, 6.02169024946, 2494.52959194860},
	{0.00000000138, 6.18657392368, 20047.19767854780},
	{0.00000000128, 3.58997483094, 8859.36257569160},
	{0.00000000126, 3.21322516874, 6148.01076995600},
	{0.00000000151, 2.93942995560, 3077.52850332700},
	{0.00000000133, 5.83386254701, 12839.87228870540},
	{0.00000000137, 4.24430027174, 6674.17861670160},
	{0.00000000169, 4.97651092293, 9389.05354078620},
	{0.00000000132, 4.07654693615, 15265.88651930040},
	{0.00000000165, 3.26928756084, 19004.64794940840},
	{0.00000000146, 0.52279831791, 3397.41568886960},
	{0.00000000146, 5.60096860073, 3283.80916453000},
	{0.00000000153, 4.43481405976, 3929.67725370800},
	{0.00000000145, 3.13103384589, 13745.34623902240},
	{0.00000000133, 4.69278266341, 3627.57478782039},
	{0.00000000165, 1.99476868352, 3450.81874791920},
	{0.00000000124, 6.11670347030, 6593.91664885980},
	{0.00000000123, 0.40352769609, 1485.98012106520},
	{0.00000000146, 2.76891699205, 1478.86657406440},
	{0.00000000117, 0.91596190605, 3337.10656200300},
	{0.00000000117, 2.06621235900, 3344.11829139661},
	{0.00000000120, 0.73600487058, 14054.60730802600},
	{0.00000000147, 1.07606700174, 6510.55198278040},
	{0.00000000117, 4.09698399049, 3344.15279870100},
	{0.00000000117, 5.16837558174, 3337.07205469860},
	{0.00000000118, 4.20346162229, 9886.77220006400},
	{0.00000000157, 5.69136299054, 5820.91492464680},
	{0.00000000158, 4.02596829239, 1648.44675719740},
	{0.00000000154, 0.46704906665, 3133.91168940320},
	{0.00000000118, 3.61740536581, 169.58018313300},
	{0.00000000118, 4.79097648197, 3317.84393009040},
	{0.00000000118, 1.33279043667, 3363.38092330920},
	{0.00000000117, 1.06179529690, 3184.21170619740},
	{0.00000000117, 5.06197162174, 3497.01314720220},
	{0.00000000116, 1.22222105263, 15906.76412668260},
	{0.00000000115, 1.85848730524, 6724.94376570460},
	{0.00000000157, 0.17397913596, 12722.55242048520},
	{0.00000000124, 3.17983191905, 2631.62262442320},
	{0.00000000135, 3.17789391939, 3603.69635007260},
	{0.00000000119, 5.17512579994, 16511.61386738740},
	{0.00000000155, 0.79719420494, 6155.05700665400},
	{0.00000000115, 3.22959858043, 6997.61672305620},
	{0.00000000111, 6.21075063523, 87.30820453981},
	{0.00000000111, 6.13183853822, 9065.54812412880},
	{0.00000000114, 1.52684026531, 3987.62326001460},
	{0.00000000138, 4.58738400697, 2233.47362101500},
	{0.00000000131, 5.25025552048, 6901.63749583840},
	{0.00000000145, 1.83381548553, 0.98032106820},
	{0.00000000119, 3.96125292511, 1505.28780909299},
	{0.00000000107, 2.70035870913, 2973.38809773740},
	{0.00000000144, 2.57852789272, 2060.81785407180},
	{0.00000000111, 2.15559505693, 6357.71943674220},
	{0.00000000106, 0.16426574878, 12509.25332504720},
	{0.00000000112, 2.39983700427, 2574.81936225340},
	{0.00000000139, 5.65976385263, 3547.31316399640},
	{0.00000000122, 2.84793235795, 3346.46962899940},
	{0.00000000122, 3.27583456069, 3334.75522440020},
	{0.00000000105, 2.94616046913, 10184.30391623160},
	{0.00000000140, 4.52778173929, 6670.58818804980},
	{0.00000000102, 2.83477159707, 17468.85519794540},
	{0.00000000099, 1.01104081470, 17917.79715281959},
	{0.00000000099, 2.31748689016, 10713.99488132620},
	{0.00000000120, 1.40938335297, 3370.10424500320},
	{0.00000000120, 4.71438356567, 3311.12060839640},
	{0.00000000118, 0.83092751777, 6606.44325483230},
	{0.00000000097, 4.80367378338, 74.78159856730},
	{0.00000000123, 3.59177506566, 11925.27409260060},
	{0.00000000129, 1.38615714913, 7366.26890762560},
	{0.00000000132, 4.17530089524, 3050.12694723020},
	{0.00000000106, 4.20303552484, 2641.34127847220},
	{0.00000000101, 2.19730971635, 10124.93005431800},
	{0.00000000126, 1.43242174074, 7380.49600162720},
	{0.00000000098, 5.71279251280, 2679.37949991880},
	{0.00000000098, 1.64590778764, 59.37386191360},
	{0.00000000104, 0.35230601699, 4296.90158267040},
	{0.00000000115, 2.20406459405, 11250.79939342160},
	{0.00000000111, 6.00152200950, 10042.19259949820},
	{0.00000000096, 3.26945343269, 10006.58480891440},
	{0.00000000093, 3.57205898509, 316.39186965660},
	{0.00000000108, 6.12508679330, 3735.23831175900},
	{0.00000000093, 4.23458272510, 3528.53757446240},
	{0.00000000092, 3.39944116355, 3707.83675566220},
	{0.00000000097, 2.13059348085, 2922.10810389280},
	{0.00000000127, 3.31567374097, 4271.97551355160},
	{0.00000000097, 4.65833476763, 5835.14201864840},
	{0.00000000094, 3.19086921862, 35464.98147893340},
	{0.00000000113, 1.01321609658, 5401.43028077160},
	{0.00000000125, 0.05016495563, 10213.28554621100},
	{0.00000000115, 1.94984091716, 9815.65173166220},
	{0.00000000093, 2.14810622027, 2771.79055267240},
	{0.00000000115, 4.92888947995, 21947.11137270000},
	{0.00000000102, 3.03180744336, 4049.60222897640},
	{0.00000000100, 0.08917971251, 26887.36604973060},
	{0.00000000090, 3.65721451906, 664.75604513000},
	{0.00000000093, 0.23047883797, 10706.88133432540},
	{0.00000000113, 4.93121887014, 4922.57177498280},
	{0.00000000094, 3.25068318985, 1272.68102562720},
	{0.00000000097, 1.89933290057, 17654.78053974960},
	{0.00000000111, 2.46536345909, 21795.21409161479},
	{0.00000000087, 4.40897064967, 2540.79130153440},
	{0.00000000119, 1.94808743738, 3631.09790616940},
	{0.00000000101, 1.61168636694, 2171.02417529120},
	{0.00000000117, 4.65224960653, 1905.46476494040},
	{0.00000000098, 0.70463876405, 6768.53305793940},
	{0.00000000084, 5.11902672644, 3152.68727893721},
	{0.00000000084, 4.83188308723, 11527.12508919240},
	{0.00000000085, 0.07731863530, 21548.96236929180},
	{0.00000000117, 4.51077566996, 5518.75014899180},
	{0.00000000083, 3.81620714151, 22345.26037610820},
	{0.00000000093, 1.26560426088, 2538.24850425360},
	{0.00000000085, 6.12091736058, 16489.76303806100},
	{0.00000000092, 0.03950789229, 2277.70737816160},
	{0.00000000085, 5.91600131489, 18208.34994259200},
	{0.00000000094, 4.47767830246, 12942.96506292400},
	{0.00000000107, 0.22163493976, 6286.59896834040},
	{0.00000000081, 0.50650790580, 3326.38533269820},
	{0.00000000081, 5.61725901284, 3354.83952070140},
	{0.00000000079, 1.50975699375, 4777.78804089840},
	{0.00000000079, 1.00513556613, 1118.75579210280},
	{0.00000000083, 3.99316690617, 3759.11674950680},
	{0.00000000093, 3.39442497787, 685.04405422600},
	{0.00000000109, 1.11061888688, 765.79306444640},
	{0.00000000079, 2.69826809389, 3378.74546233760},
	{0.00000000079, 3.42549882475, 3302.47939106200},
	{0.00000000079, 1.18088037992, 9947.05568153210},
	{0.00000000080, 0.54798761722, 1442.26120876020},
	{0.00000000078, 5.30952786068, 26357.67508463600},
	{0.00000000087, 5.45293469310, 3181.66890891660},
	{0.00000000106, 5.10677964557, 7214.43893684320},
	{0.00000000107, 5.78696398530, 4845.90023579280},
	{0.00000000079, 1.67795651281, 5562.46906129680},
	{0.00000000096, 1.84507576066, 11236.57229942000},
	{0.00000000083, 3.97986520401, 42153.96900304900},
	{0.00000000079, 5.29007388312, 1169.58825140860},
	{0.00000000094, 5.43325086005, 1655.56030419820},
	{0.00000000077, 0.48016044263, 4001.84535348080},
	{0.00000000103, 3.31518454680, 6279.55273164240},
	{0.00000000075, 1.36914522483, 6710.65436193560},
	{0.00000000100, 1.23379947915, 6653.82329730280},
	{0.00000000085, 3.04492619910, 3649.89074935560},
	{0.00000000085, 3.07884071954, 3031.33410404400},
	{0.00000000076, 3.19773799012, 20809.46762464520},
	{0.00000000074, 5.28765123522, 1107.13880568480},
	{0.00000000077, 3.97237865801, 3909.43430072720},
	{0.00000000073, 2.57751806041, 42942.50433914939},
	{0.00000000085, 3.82359953731, 42146.20633233299},
	{0.00000000102, 3.28709663996, 3282.73373069600},
	{0.00000000102, 2.83667027868, 3398.49112270360},
	{0.00000000073, 3.23527061256, 2067.93140107260},
	{0.00000000077, 5.68309610758, 20199.02764933019},
	{0.00000000072, 1.29867546702, 20206.14119633100},
	{0.00000000082, 3.69322064361, 20597.24396304120},
	{0.00000000073, 3.78223099359, 13369.56325380000},
	{0.00000000097, 0.21157168319, 6784.31762761820},
	{0.00000000083, 1.14457241650, 4447.75123238460},
	{0.00000000092, 0.92188445820, 3492.50970778500},
	{0.00000000076, 1.15437371557, 19403.77727388480},
	{0.00000000073, 0.71840007075, 6364.83298374300},
	{0.00000000071, 1.82715162268, 15121.10278521600},
	{0.00000000080, 2.74785809382, 8756.26980147300},
	{0.00000000077, 0.86279166830, 6549.68289171320},
	{0.00000000088, 4.48241968748, 11883.58313273480},
	{0.00000000074, 4.29411598595, 2011.10033643980},
	{0.00000000093, 1.79949400982, 10050.28646756720},
	{0.00000000069, 4.46882579153, 1279.79457262800},
	{0.00000000081, 3.29992061540, 15636.56665630900},
	{0.00000000068, 3.31942545345, 4106.40549114620},
	{0.00000000075, 1.30266865618, 7447.01791784600},
	{0.00000000077, 5.18502579516, 5466.48983407900},
	{0.00000000079, 6.08882534383, 3329.56672643590},
	{0.00000000079, 0.03494157481, 3351.65812696370},
	{0.00000000075, 2.41908956194, 32124.36905223359},
	{0.00000000074, 2.64861748980, 25135.82651831460},
	{0.00000000069, 3.47699248800, 11353.89216764020},
	{0.00000000087, 1.38741665452, 43340.65334255760},
	{0.00000000066, 6.18253618298, 13517.80279593060},
	{0.00000000072, 5.32558972032, 25287.72379939980},
	{0.00000000085, 0.02377577064, 1854.63230563460},
	{0.00000000088, 1.52868546432, 3067.93946934820},
	{0.00000000075, 2.26613010488, 15110.46611986620},
	{0.00000000069, 0.02278259907, 43738.80234596580},
	{0.00000000078, 5.07801637655, 34363.36559755600},
	{0.00000000082, 1.79056505886, 4885.96640967860},
	{0.00000000065, 5.47583793528, 6708.62640949640},
	{0.00000000070, 0.39852574719, 12725.45343477500},
	{0.00000000090, 3.58467854106, 6740.59871531320},
	{0.00000000065, 4.81926081363, 4140.43355186520},
	{0.00000000064, 2.78199198599, 9801.42463766060},
	{0.00000000087, 3.48209962852, 9859.37064396720},
	{0.00000000070, 5.58621397360, 35707.71008290740},
	{0.00000000084, 4.62280003448, 3613.28538405140},
	{0.00000000084, 3.13048289620, 5202.35827933520},
	{0.00000000065, 5.65188017283, 6680.80477730600},
	{0.00000000074, 0.70811376982, 19800.94595622480},
	{0.00000000066, 5.79488701874, 3414.21338261500},
	{0.00000000066, 0.32887989990, 3267.01147078460},
	{0.00000000064, 5.41618225042, 3193.80074017620},
	{0.00000000064, 0.70758466822, 3487.42411322340},
	{0.00000000080, 5.83125066323, 9175.75444534820},
	{0.00000000069, 0.45288984585, 10177.19036923080},
	{0.00000000078, 2.47729712704, 14128.24277124560},
	{0.00000000068, 3.28509813085, 12808.88030395680},
	{0.00000000068, 0.42906740811, 6614.73744448520},
	{0.00000000062, 1.67556973000, 18461.71521191579},
	{0.00000000073, 4.93443664690, 10730.82708237599},
	{0.00000000066, 4.71978579468, 9997.95884235160},
	{0.00000000062, 1.47129847545, 18451.07854656599},
	{0.00000000064, 4.43457293456, 40796.33892267419},
	{0.00000000078, 4.80114448945, 35309.56107949920},
	{0.00000000062, 0.61927789333, 20040.15144184979},
	{0.00000000064, 2.03965634077, 10787.63034454580},
	{0.00000000069, 0.35279777025, 16858.41522263039},
	{0.00000000075, 5.80439292359, 40398.18991926600},
	{0.00000000078, 5.47505498554, 14867.73751589219},
	{0.00000000062, 4.44452076035, 799.82112516540},
	{0.00000000063, 6.28310501390, 20742.94570842640},
	{0.00000000061, 1.46903295029, 14591.41182012140},
	{0.00000000060, 4.02422394326, 10016.31435579200},
	{0.00000000069, 0.07133537091, 10721.10842832700},
	{0.00000000063, 0.32856760942, 12082.65513417120},
	{0.00000000061, 0.87700826571, 36.60536530420},
	{0.00000000080, 3.82715184041, 12168.00269657460},
	{0.00000000068, 4.35850169699, 8186.51266249260},
	{0.00000000067, 3.09157172324, 9329.67967887260},
	{0.00000000064, 5.61072669942, 5223.69391980220},
	{0.00000000064, 1.96539963912, 7799.98064550240},
	{0.00000000058, 5.32198378648, 41748.05732892480},
	{0.00000000078, 1.64083896570, 24606.13555322000},
	{0.00000000057, 4.85968404475, 12928.73796892240},
	{0.00000000080, 0.99981693234, 27417.05701482520},
	{0.00000000072, 0.47301045978, 24889.57479599160},
	{0.00000000080, 1.29024393938, 14047.49376102520},
	{0.00000000062, 2.85518372165, 12988.11183083600},
	{0.00000000067, 3.88281422282, 41427.48698317880},
	{0.00000000057, 1.87370499430, 24491.42579258340},
	{0.00000000059, 0.42163716106, 5945.34833986780},
	{0.00000000074, 1.15958679714, 17395.21973472580},
	{0.00000000057, 2.71055933927, 42544.35533574120},
	{0.00000000070, 1.62633648043, 21265.52312652020},
	{0.00000000058, 4.86596352164, 15423.26756087100},
	{0.00000000062, 1.39408141536, 3357.44462774959},
	{0.00000000062, 4.72968550328, 3323.78022565000},
	{0.00000000056, 1.12816132291, 16063.16484718500},
	{0.00000000056, 1.61217428661, 2978.49128996900},
	{0.00000000056, 4.51159263204, 3702.73356343060},
	{0.00000000058, 1.36447893952, 8226.57883637840},
	{0.00000000055, 3.98578162953, 12715.43887348440},
	{0.00000000054, 2.71910253259, 5607.61582920880},
	{0.00000000073, 1.42919585711, 4775.76008845920},
	{0.00000000053, 3.09693738935, 6788.88837733820},
	{0.00000000058, 0.22442483444, 3412.66816005460},
	{0.00000000058, 5.89934208420, 3268.55669334500},
	{0.00000000053, 2.19689791795, 14481.20549890200},
	{0.00000000053, 0.15615144357, 25841.29320224219},
	{0.00000000052, 3.15010220845, 6812.76681508600},
	{0.00000000053, 1.40676144190, 2391.43681773000},
	{0.00000000053, 0.46935053804, 44959.54767599020},
	{0.00000000054, 5.80670820759, 18849.22754997420},
	{0.00000000052, 4.45343178668, 45884.96776244100},
	{0.00000000057, 2.86057303027, 5408.54382777240},
	{0.00000000053, 2.93504488248, 37895.42629036740},
	{0.00000000072, 1.04870110960, 3339.12795399150},
	{0.00000000072, 5.07506580904, 3342.09689940810},
	{0.00000000056, 5.29729400428, 17660.30346405700},
	{0.00000000054, 5.90243120665, 13532.02988993220},
	{0.00000000060, 1.10585615388, 5511.63660199100},
	{0.00000000052, 1.45564798177, 22487.37169284160},
	{0.00000000055, 5.86720570151, 3344.20285535160},
	{0.00000000051, 4.59732093524, 12410.73130054860},
	{0.00000000054, 1.41387939355, 21150.81336588360},
	{0.00000000070, 6.26592499392, 40000.04091585779},
	{0.00000000058, 1.90611100788, 29580.05463235019},
	{0.00000000054, 2.06257459061, 2735.76268599500},
	{0.00000000056, 5.51147391507, 23539.70738633280},
	{0.00000000049, 6.08800383828, 16865.52876963120},
	{0.00000000061, 2.80664860295, 2655.50106217100},
	{0.00000000050, 0.09542687607, 1727.66109366820},
	{0.00000000059, 4.25647242104, 12516.36687204800},
	{0.00000000050, 1.70549407364, 3564.95722240170},
	{0.00000000049, 1.47890962284, 55516.41870984820},
	{0.00000000056, 1.83267921871, 16328.72425753579},
	{0.00000000050, 6.13050078847, 44768.09940987860},
	{0.00000000050, 2.19360927774, 3742.28454845700},
	{0.00000000048, 3.12373703961, 1883.08149310240},
	{0.00000000068, 5.14882675659, 4142.97634914600},
	{0.00000000059, 4.61160954089, 4356.27544458400},
	{0.00000000061, 2.37259677368, 19617.07636932279},
	{0.00000000048, 6.23507805833, 19190.47817844680},
	{0.00000000055, 1.90836976863, 1971.95217385480},
	{0.00000000065, 5.33022366023, 20213.25474333179},
	{0.00000000054, 6.06383097361, 20426.57109242200},
	{0.00000000051, 3.13636139120, 5749.86176654780},
	{0.00000000058, 1.55579966471, 1015.66301788420},
	{0.00000000053, 6.07174122305, 38086.87455647900},
	{0.00000000048, 6.09265191924, 24341.52831745660},
	{0.00000000048, 1.37017477535, 846.08283475120},
	{0.00000000047, 5.48131029950, 11876.46958573400},
	{0.00000000047, 4.23447844874, 2257.35205876280},
	{0.00000000048, 0.75363318363, 3264.34635542420},
	{0.00000000064, 1.47602449306, 1329.51209026000},
	{0.00000000046, 4.98949021014, 1795.25844372100},
	{0.00000000055, 2.47607337246, 4403.51747523800},
	{0.00000000048, 5.05047802604, 14955.04572043200},
	{0.00000000059, 0.56447699816, 4289.78803566960},
	{0.00000000048, 5.64269937258, 1859.20305535460},
	{0.00000000052, 3.85502826049, 32765.24665961580},
	{0.00000000052, 0.60554758880, 2963.23881878400},
	{0.00000000052, 5.51821932984, 3717.98603461560},
	{0.00000000054, 5.75638873525, 1055.85881184020},
	{0.00000000045, 1.58216758277, 3973.39616601300},
	{0.00000000060, 3.26313473570, 46283.11676584919},
	{0.00000000049, 2.80004822014, 31214.20143696780},
	{0.00000000044, 0.54252101929, 14469.58851248400},
	{0.00000000046, 4.82251602641, 5881.40372823420},
	{0.00000000044, 0.39621574967, 14061.72085502680},
	{0.00000000044, 4.23848711560, 3436.59165391760},
	{0.00000000044, 1.88527980304, 3244.63319948200},
	{0.00000000045, 3.09899613679, 1265.56747862640},
	{0.00000000044, 4.49857181022, 17499.36014031540},
	{0.00000000058, 3.38424006936, 5625.36604155940},
	{0.00000000045, 4.80756715462, 39048.32250960720},
	{0.00000000043, 1.18491417532, 97670.38771289718},
	{0.00000000046, 3.97050301429, 18052.92954315780},
	{0.00000000059, 3.54996675378, 2523.95910048460},
	{0.00000000053, 5.27381050235, 8336.78515759780},
	{0.00000000048, 4.20516196539, 2125.81009707640},
	{0.00000000043, 3.74169704813, 12199.97500239140},
	{0.00000000043, 1.95551974467, 15106.87569121440},
	{0.00000000042, 4.34126456452, 12729.66596748600},
	{0.00000000043, 0.33738122272, 8123.48606215980},
	{0.00000000046, 0.42675039162, 2324.94940881560},
	{0.00000000043, 4.93866317055, 3826.58447948940},
	{0.00000000043, 1.18510374809, 2854.64037391020},
	{0.00000000049, 5.73530227247, 15849.86575174700},
	{0.00000000045, 0.86869575514, 28230.18722269139},
	{0.00000000042, 5.52275728942, 2651.97794382200},
	{0.00000000048, 0.38320382112, 12825.64519470380},
	{0.00000000052, 4.39773367298, 6666.99775939800},
	{0.00000000041, 5.43225265078, 3385.26625994000},
	{0.00000000041, 0.69151426786, 3295.95859345960},
	{0.00000000050, 5.89153916228, 7788.36365908440},
	{0.00000000045, 4.22332404514, 3116.26763099790},
	{0.00000000048, 3.25825537595, 39601.89191244960},
	{0.00000000040, 1.42664872496, 26239.44220565039},
	{0.00000000043, 1.84674416334, 46681.26576925740},
	{0.00000000040, 1.11930161769, 14577.18472611980},
	{0.00000000040, 4.72158737154, 2814.44457995420},
	{0.00000000040, 0.36674922708, 20728.71861442479},
	{0.00000000041, 1.94224224037, 4670.12451695980},
	{0.00000000052, 3.29121165005, 3382.16321768460},
	{0.00000000052, 2.83255526859, 3299.06163571500},
	{0.00000000044, 5.64683761753, 29698.28751133580},
	{0.00000000041, 5.62926912301, 30220.93223973240},
	{0.00000000042, 0.62187667623, 24076.44458812540},
	{0.00000000046, 2.01012132100, 19247.37655338240},
	{0.00000000039, 3.61794457591, 27433.88921587499},
	{0.00000000045, 6.00306408589, 227.47613278900},
	{0.00000000047, 2.23693969795, 27832.03821928320},
	{0.00000000039, 2.09880635074, 742.99006053260},
	{0.00000000042, 0.41661355281, 10191.41746323240},
	{0.00000000049, 3.31862583605, 4025.72379122860},
	{0.00000000039, 1.23955681764, 33163.39566302400},
	{0.00000000040, 0.83205528677, 38252.02450279080},
	{0.00000000051, 1.01939482770, 17810.20093918380},
	{0.00000000052, 0.78418608920, 1461.05405194640},
	{0.00000000045, 5.86462836257, 3966.28261901220},
	{0.00000000045, 0.25913855607, 2714.94223438740},
	{0.00000000039, 1.82873904075, 2714.98729050260},
	{0.00000000043, 4.46734154880, 48835.19385644859},
	{0.00000000038, 2.82290648987, 41194.48792608240},
	{0.00000000042, 3.18950244700, 24093.27678917520},
	{0.00000000045, 5.90009306113, 33716.96506586640},
	{0.00000000038, 4.52300714521, 8742.04270747140},
	{0.00000000040, 4.06041894809, 3945.46216740460},
	{0.00000000041, 3.68161811197, 17013.90293236740},
	{0.00000000037, 2.53315491999, 3017.10701004240},
	{0.00000000043, 0.40070595587, 16872.64231663200},
	{0.00000000037, 2.86323683483, 36261.27948574980},
	{0.00000000037, 0.04021979736, 48827.43118573260},
	{0.00000000038, 4.60085089797, 1484.93248969420},
	{0.00000000036, 5.58209344400, 2089.78223039900},
	{0.00000000050, 2.20944186253, 526.16784674560},
	{0.00000000036, 5.37022099013, 19676.45023123640},
	{0.00000000037, 0.66378563362, 9384.84100807520},
	{0.00000000047, 5.53299461316, 21000.91589075680},
	{0.00000000047, 1.09162082178, 20735.83216142559},
	{0.00000000036, 0.66244555675, 3762.63986785580},
	{0.00000000036, 5.46132136189, 2918.58498554380},
	{0.00000000037, 5.70989317039, 20995.39296644940},
	{0.00000000036, 6.05334429212, 27682.14074415640},
	{0.00000000038, 5.25536340407, 28628.33622609960},
	{0.00000000036, 1.21817478744, 4555.41475632320},
	{0.00000000047, 4.16379978009, 8013.27974094040},
	{0.00000000039, 2.83792055047, 3337.15661865360},
	{0.00000000039, 0.14425371458, 3344.06823474600},
	{0.00000000035, 1.41870103931, 1685.05212250160},
	{0.00000000042, 1.18769542614, 20235.12282631040},
	{0.00000000038, 5.58692016360, 3070.48226662900},
	{0.00000000038, 0.53684675504, 3610.74258677060},
	{0.00000000035, 4.99234317683, 4716.38622654560},
	{0.00000000036, 2.14857050891, 6644.61948809540},
	{0.00000000047, 5.94900036662, 45088.66975562460},
	{0.00000000034, 3.27231840809, 29181.90562894200},
	{0.00000000034, 6.09046934997, 21.85082932640},
	{0.00000000035, 3.09787661627, 15010.89646399660},
	{0.00000000040, 4.30328275800, 52175.80628314840},
	{0.00000000034, 1.84414035522, 13355.33615979840},
	{0.00000000034, 1.39702945228, 6836.57794253100},
	{0.00000000039, 1.98242424074, 11567.19126307820},
	{0.00000000034, 4.53674484583, 3370.49447031000},
	{0.00000000034, 1.58702207281, 3310.73038308960},
	{0.00000000034, 1.21354379250, 23937.85638974100},
	{0.00000000041, 6.10721750623, 11128.97608578420},
	{0.00000000033, 4.73943199387, 12502.13977804640},
	{0.00000000038, 4.44432609762, 34115.11406927460},
	{0.00000000034, 2.89935386730, 7483.58877584580},
	{0.00000000034, 0.03045529516, 16702.99482319620},
	{0.00000000040, 2.64332877474, 6850.80503653260},
	{0.00000000033, 5.97008603930, 3723.49170527080},
	{0.00000000033, 0.15368087934, 2957.73314812880},
	{0.00000000033, 2.74215617399, 14164.81362924540},
	{0.00000000033, 4.89399844372, 37455.72649597440},
	{0.00000000045, 2.57456746730, 4157.26575291499},
	{0.00000000035, 0.70040109787, 17932.02424682120},
	{0.00000000032, 1.88677077871, 4423.87279463680},
	{0.00000000032, 3.30721989272, 5415.65737477320},
	{0.00000000032, 3.90121054115, 20354.51535906720},
	{0.00000000032, 2.99569421537, 1197.97012857360},
	{0.00000000032, 3.04108622570, 36105.85908631560},
	{0.00000000032, 0.60384612281, 4029.24690957760},
	{0.00000000034, 4.21263525801, 3337.02199804800},
	{0.00000000042, 2.22648780153, 12979.55317457600},
	{0.00000000033, 1.19151639747, 16342.95135153740},
	{0.00000000031, 2.01995732343, 3101.40694107480},
	{0.00000000031, 4.10380959521, 3579.81791232480},
	{0.00000000032, 2.71500667131, 41236.03871706720},
	{0.00000000033, 6.17834375458, 4953.56375973140},
	{0.00000000033, 2.25400995114, 24532.97658356820},
	{0.00000000031, 0.50017802841, 13605.17831077320},
	{0.00000000038, 4.78366250308, 5351.71276313960},
	{0.00000000035, 4.91227370595, 27035.74021246680},
	{0.00000000030, 1.87215947062, 32769.12799497380},
	{0.00000000030, 4.83793546724, 9918.74450588080},
	{0.00000000039, 5.08918951879, 49225.58018914080},
	{0.00000000040, 3.07330295310, 3524.48201360179},
	{0.00000000040, 3.05046396554, 3156.74283979780},
	{0.00000000033, 5.50115850078, 19956.36635565900},
	{0.00000000030, 4.31368171539, 3966.23756289700},
	{0.00000000029, 5.37757078512, 30376.35263916660},
	{0.00000000031, 1.71406884029, 9072.66167112960},
	{0.00000000029, 3.01545415354, 26880.31981303260},
	{0.00000000030, 0.63974818582, 17232.75309859360},
	{0.00000000030, 0.47691051204, 4822.02179804500},
	{0.00000000032, 3.38388067312, 4503.08713110760},
	{0.00000000032, 3.17796658527, 33561.54466643220},
	{0.00000000030, 1.29590585399, 12995.22537783680},
	{0.00000000035, 6.27959027284, 23017.06265793620},
	{0.00000000032, 5.84436620819, 6830.78805053420},
	{0.00000000035, 2.04350169558, 3303.61683608880},
	{0.00000000035, 4.08026522307, 3377.60801731080},
	{0.00000000028, 3.36920945356, 38813.35657634920},
	{0.00000000037, 5.53201883072, 45486.81875903279},
	{0.00000000028, 3.89264354896, 3348.37509741580},
	{0.00000000028, 2.23112336968, 3332.84975598380},
	{0.00000000032, 1.38638703068, 36659.42848915800},
	{0.00000000028, 3.90155339567, 7345.98089852960},
	{0.00000000029, 0.33271254369, 41990.78593289880},
	{0.00000000027, 0.95617807815, 7534.42123515160},
	{0.00000000029, 0.58910694177, 33318.81606245820},
	{0.00000000028, 0.45077221068, 3517.30615683360},
	{0.00000000028, 5.67299470796, 3163.91869656600},
	{0, 0, 0}
};

struct vsop87_term mars_y2[] = {
	{0.00035396765, 3.14159265359, 0.00000000000},
	{0.00021950759, 1.96291594946, 6681.22485339960},
	{0.00006075990, 2.35864321001, 10021.83728009940},
	{0.00002571425, 5.64795745327, 3340.61242669980},
	{0.00001129099, 2.71576248963, 13362.44970679920},
	{0.00000182443, 3.06335050462, 16703.06213349900},
	{0.00000168357, 3.01017878073, 3337.08930835080},
	{0.00000167747, 3.10922702911, 3344.13554504880},
	{0.00000093890, 5.65913038458, 3185.19202726560},
	{0.00000089244, 0.46137270696, 3496.03282613400},
	{0.00000040563, 3.45931070999, 6684.74797174860},
	{0.00000036611, 0.19723333298, 1059.38193018920},
	{0.00000027526, 3.40697584132, 20043.67456019880},
	{0.00000024574, 2.05709261735, 3149.16416058820},
	{0.00000023302, 4.06054703458, 3532.06069281140},
	{0.00000024401, 4.20197858679, 2544.31441988340},
	{0.00000020299, 1.91147990337, 4136.91043351620},
	{0.00000018006, 1.85198728948, 3097.88382272579},
	{0.00000017221, 2.74161867582, 2942.46342329160},
	{0.00000016902, 4.25136186320, 3583.34103067380},
	{0.00000015777, 5.91718781131, 5621.84292321040},
	{0.00000015856, 0.06841918410, 1194.44701022460},
	{0.00000015264, 3.35254931189, 3738.76143010800},
	{0.00000013171, 3.57877335400, 1990.74501704100},
	{0.00000016812, 0.77954286997, 2787.04302385740},
	{0.00000012593, 2.18013310837, 2388.89402044920},
	{0.00000015019, 4.97047493091, 1592.59601363280},
	{0.00000011289, 6.01290979033, 6525.80445396540},
	{0.00000012302, 5.54713651711, 3339.63210563160},
	{0.00000012284, 0.57411575365, 3341.59274776800},
	{0.00000011117, 1.40530378545, 796.29800681640},
	{0.00000013747, 5.31116419768, 3894.18182954220},
	{0.00000010577, 0.59752271504, 4399.99435688900},
	{0.00000012705, 4.25802747859, 155.42039943420},
	{0.00000010098, 5.47747691225, 2146.16541647520},
	{0.00000008863, 3.88169637617, 4292.33083295040},
	{0.00000008121, 3.78260601575, 10025.36039844840},
	{0.00000008120, 2.48132497663, 4690.47983635860},
	{0.00000008061, 6.02603958883, 5486.77784317500},
	{0.00000008308, 5.94980766794, 2957.71589447660},
	{0.00000007546, 0.72982074611, 1589.07289528380},
	{0.00000008863, 0.51480663563, 4535.05943692440},
	{0.00000007306, 0.15133585090, 3723.50895892300},
	{0.00000008322, 1.11264211549, 5088.62883976680},
	{0.00000006121, 3.80547694913, 7079.37385680780},
	{0.00000005292, 2.91159592616, 553.56940284240},
	{0.00000005260, 4.61737050810, 5884.92684658320},
	{0.00000005181, 3.78652084191, 242.72860397400},
	{0.00000004788, 5.08946784428, 3333.49887969900},
	{0.00000004994, 3.77687231272, 2274.11694950980},
	{0.00000005294, 2.49424280894, 6489.77658728800},
	{0.00000005700, 3.23668454093, 7.11354700080},
	{0.00000004310, 5.38385773303, 4933.20844033260},
	{0.00000004451, 6.20023805343, 2288.34404351140},
	{0.00000004108, 1.09332741074, 3347.72597370060},
	{0.00000003907, 5.34892103731, 5092.15195811580},
	{0.00000004168, 1.63291442825, 951.71840625060},
	{0.00000003986, 3.74911328925, 23384.28698689860},
	{0.00000004160, 0.01637628167, 1748.01641306700},
	{0.00000003853, 2.50327269341, 3870.30339179440},
	{0.00000003509, 0.57679733808, 1349.86740965880},
	{0.00000004609, 2.29503773584, 7477.52286021600},
	{0.00000003221, 0.80341863927, 426.59819087600},
	{0.00000003076, 2.19921948725, 6438.49624942560},
	{0.00000002496, 3.96886138858, 5331.35744374080},
	{0.00000002377, 0.38140430638, 6836.64525283380},
	{0.00000002686, 3.87569148850, 382.89653222320},
	{0.00000002208, 4.32192232999, 9492.14631500480},
	{0.00000002174, 1.14140386023, 6127.65545055720},
	{0.00000002254, 5.32326617203, 2281.23049651060},
	{0.00000002234, 3.34034105089, 6677.70173505060},
	{0.00000002008, 0.97233813710, 6682.20517446780},
	{0.00000001886, 0.88359569638, 4929.68532198360},
	{0.00000002399, 5.71798195089, 639.89728631400},
	{0.00000001966, 5.66277094404, 6681.20759974740},
	{0.00000001709, 3.15485228182, 3553.91152213780},
	{0.00000001623, 2.91176858936, 3127.31333126180},
	{0.00000001966, 1.40934384205, 6681.24210705180},
	{0.00000002129, 0.96593329639, 7740.60678358880},
	{0.00000001613, 0.87522364052, 7875.67186362420},
	{0.00000001959, 4.59967067607, 6923.95345737360},
	{0.00000001707, 1.58055507525, 191.44826611160},
	{0.00000001563, 6.04825312520, 8969.56889691100},
	{0.00000001562, 3.60601030893, 8955.34180290940},
	{0.00000001521, 1.24699713469, 2118.76386037840},
	{0.00000001856, 2.55647948443, 5729.50644714900},
	{0.00000001727, 2.85561952146, 6674.11130639880},
	{0.00000001467, 4.10525560389, 13365.97282514820},
	{0.00000001489, 0.07763972898, 9866.41688066520},
	{0.00000001241, 2.40154751214, 640.87760738220},
	{0.00000001216, 5.32666382225, 6254.62666252360},
	{0.00000001163, 0.02680352381, 6298.32832117640},
	{0.00000001127, 4.74702347824, 12832.75874170460},
	{0.00000001479, 4.19328625081, 10419.98628350760},
	{0.00000001110, 0.62876661717, 12303.06777661000},
	{0.00000001201, 1.35027812980, 3767.21061757580},
	{0.00000001209, 4.02724556737, 529.69096509460},
	{0.00000001277, 4.14556116975, 2810.92146160520},
	{0.00000000996, 4.74526775741, 4562.46099302120},
	{0.00000001177, 3.11858509884, 2699.73481931760},
	{0.00000001107, 3.43598182944, 7210.91581849420},
	{0.00000000980, 4.10189301724, 1751.53953141600},
	{0.00000000992, 2.89543127786, 9830.38901398780},
	{0.00000000879, 2.65396505074, 10818.13528691580},
	{0.00000000801, 3.12247047301, 7234.79425624200},
	{0.00000000750, 5.47332571883, 10018.31416175040},
	{0.00000001020, 2.84383580823, 3981.49003408200},
	{0.00000000752, 3.75998155147, 9623.68827669120},
	{0.00000000817, 1.80163831596, 10021.85453375160},
	{0.00000000980, 2.36639419833, 6151.53388830500},
	{0.00000000722, 4.62906876375, 853.19638175200},
	{0.00000000816, 6.05414506463, 10021.82002644720},
	{0.00000000920, 0.39289007555, 6041.32756708560},
	{0.00000000685, 5.75193209744, 8273.82086703240},
	{0.00000000647, 3.74908813669, 6681.15754309680},
	{0.00000000850, 1.47881746342, 6688.33840040040},
	{0.00000000652, 3.34981557701, 6681.29216370240},
	{0.00000000700, 1.67530129882, 7632.94325965020},
	{0.00000000577, 1.04070762372, 15643.68020330980},
	{0.00000000717, 2.07519839097, 3178.14579056760},
	{0.00000000652, 3.70253626949, 6894.52394883760},
	{0.00000000545, 3.41522137104, 2766.26762836500},
	{0.00000000673, 4.04821743411, 3503.07906283200},
	{0.00000000617, 0.99680091352, 3253.30422216000},
	{0.00000000536, 3.52327599023, 6040.34724601740},
	{0.00000000596, 5.12699846907, 3427.92063123960},
	{0.00000000588, 3.96278469025, 213.29909543800},
	{0.00000000475, 0.27257730049, 8031.09226305840},
	{0.00000000452, 3.92413733398, 7064.12138562280},
	{0.00000000545, 5.75151872801, 6680.24453233140},
	{0.00000000410, 0.01129204844, 3980.50971301380},
	{0.00000000407, 3.71457448004, 398.14900340820},
	{0.00000000561, 4.09070736733, 26724.89941359840},
	{0.00000000394, 4.16793050853, 12964.30070339100},
	{0.00000000424, 1.70223257043, 2648.45482547300},
	{0.00000000494, 4.49655447960, 2914.01423582380},
	{0.00000000406, 2.58759397313, 3914.95722503460},
	{0.00000000495, 1.02025723901, 1039.02661079040},
	{0.00000000369, 1.17514057075, 8270.29774868340},
	{0.00000000380, 1.32206670955, 11081.21921028860},
	{0.00000000362, 0.90947170771, 2700.71514038580},
	{0.00000000328, 2.75210171118, 6872.67311951120},
	{0.00000000402, 4.93492106682, 8962.45534991020},
	{0.00000000348, 0.42381697714, 5614.72937620960},
	{0.00000000300, 1.28282479527, 5459.37628707820},
	{0.00000000326, 1.34710144821, 10022.81760116760},
	{0.00000000289, 0.11523060708, 574.34479833480},
	{0.00000000277, 1.25004682191, 11216.28429032400},
	{0.00000000272, 4.28209348126, 10551.52824519400},
	{0.00000000281, 4.56486810428, 13760.59871020740},
	{0.00000000353, 4.32675452202, 8671.96987044060},
	{0.00000000268, 3.72932515250, 10021.90459040220},
	{0.00000000297, 1.37206169767, 5828.02847164760},
	{0.00000000263, 1.47811633236, 9468.26787725700},
	{0.00000000315, 5.10166124248, 16173.37116840440},
	{0.00000000265, 2.25319243195, 2487.41604494780},
	{0.00000000271, 3.92820739547, 8432.76438481560},
	{0.00000000253, 3.25996630819, 1066.49547719000},
	{0.00000000242, 5.37781682645, 13358.92658845020},
	{0.00000000297, 4.56177638218, 4032.77002792660},
	{0.00000000233, 2.05217226701, 9779.10867612540},
	{0.00000000267, 4.13774104917, 10021.76996979660},
	{0.00000000246, 4.94804916890, 10264.56588407340},
	{0.00000000285, 0.15954661286, 12310.18132361080},
	{0.00000000244, 3.99455029761, 1221.84856632140},
	{0.00000000266, 1.39174746943, 18984.29263000960},
	{0.00000000199, 2.16282411281, 13362.46696045140},
	{0.00000000199, 0.13210292707, 13362.43245314700},
	{0.00000000202, 4.05984593475, 2301.58581590939},
	{0.00000000239, 4.43362254313, 16706.58525184800},
	{0.00000000200, 5.38904642432, 8429.24126646660},
	{0.00000000212, 1.84457939183, 7107.82304427560},
	{0.00000000226, 3.49275518587, 10575.40668294180},
	{0.00000000193, 2.86847666295, 9070.11887384880},
	{0.00000000172, 3.27689792601, 13171.00144068760},
	{0.00000000198, 4.83262833047, 5642.19824260920},
	{0.00000000196, 0.42643861999, 13207.02930736500},
	{0.00000000167, 0.41792207348, 1052.26838318840},
	{0.00000000177, 0.37846184022, 9638.94074787620},
	{0.00000000170, 1.42477887702, 4379.63903749020},
	{0.00000000204, 5.68029274716, 10177.25767953360},
	{0.00000000155, 3.91618675743, 12295.95422960920},
	{0.00000000211, 1.76754517424, 6283.07584999140},
	{0.00000000148, 4.18280926820, 10235.13637553740},
	{0.00000000141, 1.85259563214, 10028.95082710020},
	{0.00000000136, 5.89922987098, 1437.17561419860},
	{0.00000000131, 0.25161165723, 3029.77162783140},
	{0.00000000153, 1.90910985368, 10973.55568635000},
	{0.00000000120, 3.67319977433, 149.56319713460},
	{0.00000000116, 5.87205002685, 3651.45322556820},
	{0.00000000121, 5.22121986472, 3340.62968035200},
	{0.00000000129, 2.33699517207, 6696.47732458460},
	{0.00000000117, 4.27299444995, 6701.58017279840},
	{0.00000000121, 3.19272980929, 3340.59517304760},
	{0.00000000107, 3.57431869370, 4407.10790388980},
	{0.00000000114, 3.18684723749, 7322.10246078180},
	{0.00000000136, 0.83727417601, 15113.98923821520},
	{0.00000000104, 1.56408098268, 6665.97238221460},
	{0.00000000114, 2.24681555636, 9168.64089834740},
	{0.00000000101, 2.89480529792, 14158.74771361560},
	{0.00000000100, 5.74151572110, 17924.91069982040},
	{0.00000000104, 5.03602136971, 8827.39026987480},
	{0.00000000131, 5.90938471415, 6660.86953400080},
	{0.00000000100, 1.58394187969, 6467.92575796160},
	{0.00000000114, 2.14940221332, 6518.75821726740},
	{0.00000000114, 1.16549646319, 11773.37681151540},
	{0.00000000095, 5.01859144435, 6816.28993343500},
	{0.00000000088, 4.49180629006, 1835.32461760680},
	{0.00000000091, 0.68664247876, 9381.93999378540},
	{0.00000000092, 3.16422844303, 10014.72373309860},
	{0.00000000088, 0.28956834699, 7255.56965173440},
	{0.00000000089, 0.16636618973, 11371.70468975820},
	{0.00000000080, 4.02168669717, 10404.73381232260},
	{0.00000000078, 2.06677323042, 27433.88921587499},
	{0.00000000096, 4.52498397749, 16304.91313009080},
	{0.00000000075, 2.28006075482, 9380.95967271720},
	{0.00000000094, 3.73226580941, 9808.53818466140},
	{0.00000000078, 5.39451215886, 1505.28780909299},
	{0.00000000074, 4.85473384301, 1903.43681250120},
	{0.00000000082, 1.64454329520, 20752.66436247540},
	{0.00000000072, 0.22271495096, 19800.94595622480},
	{0.00000000085, 5.16678830189, 4193.80880845180},
	{0.00000000073, 5.59564088175, 6660.44945790720},
	{0.00000000080, 0.85355076616, 13119.72110282519},
	{0.00000000094, 3.63777789316, 7903.07341972100},
	{0.00000000075, 5.77675923540, 13517.87010623340},
	{0.00000000067, 0.10543129344, 12935.85151592320},
	{0.00000000066, 1.89459556834, 4845.90023579280},
	{0.00000000067, 6.03101420173, 5244.04923920100},
	{0.00000000069, 4.43286275856, 30065.51184029820},
	{0.00000000065, 2.27540626241, 12721.57209941700},
	{0.00000000079, 3.75639786511, 9225.53927328300},
	{0.00000000070, 3.03096982456, 5628.95647021120},
	{0.00000000065, 1.67356767606, 2631.62262442320},
	{0.00000000065, 5.74828882968, 20199.09495963300},
	{0.00000000063, 4.08619875728, 13362.51701710200},
	{0.00000000057, 3.94042480034, 27035.74021246680},
	{0.00000000080, 0.78152072903, 21795.21409161479},
	{0.00000000064, 5.47349341844, 6768.53305793940},
	{0.00000000062, 1.66193360966, 5989.06725217280},
	{0.00000000063, 1.04268183515, 14128.24277124560},
	{0.00000000059, 4.57660740933, 25287.72379939980},
	{0.00000000057, 5.46713966805, 16699.53901514999},
	{0.00000000058, 1.21995619161, 27832.03821928320},
	{0.00000000062, 5.98946104494, 8425.65083781480},
	{0.00000000057, 1.09390665574, 17412.05193577560},
	{0.00000000058, 2.47846050317, 22743.40937951640},
	{0.00000000067, 3.07992916082, 2233.47362101500},
	{0.00000000060, 2.73711498745, 16062.18452611680},
	{0.00000000049, 5.08147417610, 11128.97608578420},
	{0.00000000049, 1.66916016303, 14421.83163698840},
	{0.00000000050, 2.94640653891, 14584.29827312060},
	{0.00000000057, 3.23516782078, 8982.81066930900},
	{0.00000000050, 1.30948740291, 6593.91664885980},
	{0.00000000065, 3.77065948973, 6106.88005506480},
	{0.00000000050, 4.44975506045, 4049.60222897640},
	{0.00000000050, 6.04891397878, 21265.52312652020},
	{0.00000000056, 4.09019049345, 9499.25986200560},
	{0.00000000056, 4.49433446090, 13362.38239649640},
	{0.00000000046, 4.32277657100, 13149.15061136120},
	{0.00000000045, 4.42820214061, 8584.66166590080},
	{0.00000000051, 5.47523455944, 19513.98359510420},
	{0.00000000048, 1.25598529065, 23141.55838292460},
	{0.00000000047, 0.46146406745, 7321.12213971360},
	{0.00000000052, 3.19972838822, 4447.75123238460},
	{0.00000000058, 0.80841286660, 18454.60166491500},
	{0.00000000043, 1.51803973261, 8799.98871377800},
	{0.00000000043, 0.61818181916, 6684.81528205140},
	{0.00000000046, 0.99074391135, 10713.99488132620},
	{0.00000000042, 4.67651911489, 9485.03276800400},
	{0.00000000050, 5.47854915740, 8186.51266249260},
	{0.00000000043, 0.99542400694, 6705.10329114740},
	{0.00000000047, 3.65366177977, 12323.42309600880},
	{0.00000000048, 0.80944904899, 10596.18207843420},
	{0.00000000048, 1.24802855734, 16460.33352952499},
	{0.00000000056, 1.47449920800, 6702.00024889200},
	{0.00000000043, 6.23844434280, 6709.67404086740},
	{0.00000000040, 2.13905875018, 13553.89797291080},
	{0.00000000043, 0.18705839538, 6677.63442474780},
	{0.00000000043, 3.41309849056, 7373.38245462640},
	{0.00000000050, 4.87873224736, 13892.14067189380},
	{0.00000000048, 2.99107811521, 17654.78053974960},
	{0.00000000038, 4.13769543996, 15664.03552270859},
	{0.00000000038, 0.87505173893, 3340.67973700260},
	{0.00000000044, 4.36036807845, 25685.87280280800},
	{0.00000000049, 2.91514601795, 6657.34641565180},
	{0.00000000038, 2.44636146068, 6531.66165626500},
	{0.00000000038, 0.17112950159, 5099.26550511660},
	{0.00000000049, 1.48899492537, 11610.91017538320},
	{0.00000000037, 5.99921778091, 18606.49894600020},
	{0.00000000036, 3.12140441287, 6158.64743530580},
	{0.00000000038, 5.80724401811, 11614.43329373220},
	{0.00000000038, 1.75887029490, 22324.90505670940},
	{0.00000000045, 4.50061115897, 30376.35263916660},
	{0.00000000035, 5.17758129009, 20735.83216142559},
	{0.00000000038, 2.84376159594, 10213.28554621100},
	{0.00000000046, 4.74541684756, 3333.56619000180},
	{0.00000000046, 4.51994272467, 3347.65866339780},
	{0.00000000043, 1.88067652530, 31570.79964939120},
	{0.00000000042, 1.70888858696, 13363.43002786740},
	{0.00000000036, 3.06997899410, 26084.02180621620},
	{0.00000000033, 0.01439307540, 4777.78804089840},
	{0.00000000036, 6.11394649079, 24606.13555322000},
	{0.00000000039, 1.28072614128, 3340.54511639700},
	{0.00000000037, 4.59423799549, 19004.64794940840},
	{0.00000000030, 5.15711969407, 8439.87793181640},
	{0.00000000031, 5.25117631915, 4106.40549114620},
	{0.00000000031, 0.87259059949, 2574.81936225340},
	{0.00000000031, 0.98186586659, 28230.18722269139},
	{0.00000000028, 0.10419361626, 12509.25332504720},
	{0.00000000029, 0.50244127169, 16276.46394262300},
	{0.00000000035, 0.12378304174, 3.52311834900},
	{0.00000000030, 5.37981269791, 24076.44458812540},
	{0.00000000034, 4.37235683472, 11769.85369316640},
	{0.00000000028, 0.59603557040, 15650.79375031060},
	{0.00000000027, 6.26048737681, 11527.12508919240},
	{0.00000000027, 1.20265931007, 20809.46762464520},
	{0.00000000027, 4.82118994609, 17101.21113690720},
	{0.00000000031, 3.11642365383, 19402.79695281660},
	{0.00000000034, 0.07900082872, 28628.33622609960},
	{0.00000000026, 1.55966729504, 21548.96236929180},
	{0.00000000030, 5.04089195924, 11925.27409260060},
	{0.00000000026, 4.11559858625, 13916.01910964160},
	{0.00000000031, 3.85373149878, 6843.69148953180},
	{0.00000000026, 5.44448128332, 13745.34623902240},
	{0.00000000026, 2.52360223364, 16066.06586147480},
	{0.00000000028, 5.50723877314, 15265.88651930040},
	{0.00000000025, 3.73793787048, 23695.12778576700},
	{0.00000000032, 4.88973346842, 20597.24396304120},
	{0.00000000026, 6.04122572180, 12722.55242048520},
	{0.00000000025, 4.91085018100, 29026.48522950779},
	{0.00000000023, 2.87587036440, 31172.65064598300},
	{0.00000000022, 0.59265034235, 22747.29071487440},
	{0.00000000026, 0.10826980097, 21947.11137270000},
	{0.00000000022, 5.95022215185, 16858.48253293320},
	{0.00000000024, 5.54824366988, 3877.41693879520},
	{0.00000000024, 0.26293436197, 23539.70738633280},
	{0.00000000021, 5.54933439149, 1744.42598441520},
	{0.00000000020, 0.82610997828, 33318.81606245820},
	{0.00000000020, 3.65831642481, 30774.50164257480},
	{0.00000000020, 5.61098973994, 26637.59120905859},
	{0.00000000020, 1.71404094069, 1062.90504853820},
	{0.00000000020, 4.05235689782, 33716.96506586640},
	{0.00000000020, 2.37108711004, 34911.41207609100},
	{0.00000000019, 2.54881450162, 40000.04091585779},
	{0.00000000018, 1.11985216685, 23937.85638974100},
	{0.00000000019, 0.02851954732, 5085.03841111500},
	{0.00000000018, 6.10539374379, 3863.18984479360},
	{0.00000000020, 0.56057892003, 10787.63034454580},
	{0.00000000018, 0.84708374416, 14071.43950907579},
	{0.00000000023, 4.13400956412, 4392.88080988820},
	{0.00000000017, 3.29558481475, 24491.42579258340},
	{0.00000000023, 5.60082876800, 37455.72649597440},
	{0.00000000020, 1.91977177100, 24889.57479599160},
	{0.00000000019, 2.81301749154, 2803.80791460440},
	{0.00000000020, 4.93008492333, 22345.26037610820},
	{0.00000000018, 1.66720271102, 14469.58851248400},
	{0.00000000020, 0.02728239137, 29978.20363575840},
	{0.00000000018, 2.26405048660, 3492.50970778500},
	{0.00000000018, 0.71812377845, 3188.71514561460},
	{0.00000000021, 2.40469497179, 2818.03500860600},
	{0.00000000017, 1.10170947030, 13936.79450513400},
	{0.00000000017, 1.27632047280, 5618.31980486140},
	{0.00000000019, 0.99992364561, 18208.34994259200},
	{0.00000000016, 3.95588187950, 39601.89191244960},
	{0.00000000016, 2.20820580655, 10448.43547097540},
	{0.00000000016, 2.13707939759, 21150.81336588360},
	{0.00000000018, 0.65926982752, 18451.07854656599},
	{0.00000000015, 4.39788737346, 23546.75362303080},
	{0.00000000015, 1.00397038267, 17277.40693183380},
	{0.00000000015, 2.73448744057, 36261.27948574980},
	{0.00000000015, 4.32264037258, 2938.94030494260},
	{0.00000000015, 4.94271919965, 3742.28454845700},
	{0.00000000015, 2.68088184593, 17013.90293236740},
	{0.00000000018, 0.65056538408, 14867.73751589219},
	{0.00000000015, 1.23424327221, 29580.05463235019},
	{0.00000000019, 3.20578535726, 20354.51535906720},
	{0.00000000018, 3.99911093876, 17468.85519794540},
	{0.00000000015, 0.11814963122, 26239.44220565039},
	{0.00000000019, 1.67249955547, 36659.42848915800},
	{0.00000000014, 4.63973555900, 27490.69247804480},
	{0.00000000014, 5.84585102698, 11243.68584642080},
	{0.00000000016, 1.84041978240, 12808.88030395680},
	{0.00000000014, 3.69123561689, 9595.23908922340},
	{0, 0, 0}
};

struct vsop87_term mars_y3[] = {
	{0.00001448778, 0.00000000000, 0.00000000000},
	{0.00000548277, 0.33360423382, 6681.22485339960},
	{0.00000316422, 0.81609547752, 10021.83728009940},
	{0.00000121864, 4.21281448757, 3340.61242669980},
	{0.00000088558, 1.20276993071, 13362.44970679920},
	{0.00000019088, 1.56560410465, 16703.06213349900},
	{0.00000017293, 1.97503775578, 3496.03282613400},
	{0.00000017050, 4.14879086475, 3185.19202726560},
	{0.00000007913, 4.62482643997, 3337.08930835080},
	{0.00000007879, 1.48801834339, 3344.13554504880},
	{0.00000003598, 1.91971055963, 20043.67456019880},
	{0.00000003724, 2.74263177823, 3583.34103067380},
	{0.00000003706, 3.37952847105, 3097.88382272579},
	{0.00000002859, 1.93515168613, 6684.74797174860},
	{0.00000002392, 4.50849572151, 6525.80445396540},
	{0.00000002389, 0.57456638903, 3894.18182954220},
	{0.00000002357, 5.54957319553, 2787.04302385740},
	{0.00000002125, 5.75979360774, 155.42039943420},
	{0.00000001301, 5.46343073746, 4292.33083295040},
	{0.00000001265, 0.65832369520, 2388.89402044920},
	{0.00000001160, 5.63751190575, 3532.06069281140},
	{0.00000001144, 0.47525689968, 3149.16416058820},
	{0.00000001140, 0.36648108968, 4136.91043351620},
	{0.00000001033, 5.74652285578, 2544.31441988340},
	{0.00000000999, 0.83738148713, 3339.63210563160},
	{0.00000000903, 4.06289414325, 4690.47983635860},
	{0.00000000993, 5.28170605059, 3341.59274776800},
	{0.00000000866, 2.03957182186, 1990.74501704100},
	{0.00000000780, 2.29915840069, 10025.36039844840},
	{0.00000000795, 1.68810281929, 3723.50895892300},
	{0.00000000781, 4.42878840709, 2957.71589447660},
	{0.00000000626, 2.26722464083, 23384.28698689860},
	{0.00000000718, 5.26216518522, 4535.05943692440},
	{0.00000000630, 2.66594816549, 5088.62883976680},
	{0.00000000619, 0.87185440690, 2146.16541647520},
	{0.00000000591, 3.41961730120, 1592.59601363280},
	{0.00000000450, 0.35535293147, 3333.49887969900},
	{0.00000000426, 1.74413244329, 3738.76143010800},
	{0.00000000411, 4.29235402771, 2942.46342329160},
	{0.00000000413, 5.78184272155, 3347.72597370060},
	{0.00000000398, 5.34760414214, 4399.99435688900},
	{0.00000000372, 1.83526632397, 6836.64525283380},
	{0.00000000489, 3.10015454635, 6923.95345737360},
	{0.00000000356, 5.91358813779, 6127.65545055720},
	{0.00000000348, 4.92198363334, 1059.38193018920},
	{0.00000000399, 0.93216820629, 6489.77658728800},
	{0.00000000280, 1.14071288830, 5621.84292321040},
	{0.00000000357, 4.86358566470, 9866.41688066520},
	{0.00000000293, 2.25152589204, 7079.37385680780},
	{0.00000000338, 0.77428089130, 7477.52286021600},
	{0.00000000238, 3.64302943603, 6438.49624942560},
	{0.00000000214, 5.70028080048, 6682.20517446780},
	{0.00000000176, 2.42829974834, 5331.35744374080},
	{0.00000000215, 1.03281362505, 5729.50644714900},
	{0.00000000157, 3.81392312629, 4933.20844033260},
	{0.00000000153, 5.64157477710, 7875.67186362420},
	{0.00000000149, 4.80621690834, 6298.32832117640},
	{0.00000000173, 2.64284412795, 13365.97282514820},
	{0.00000000144, 0.84473821034, 7234.79425624200},
	{0.00000000156, 5.74300569044, 7740.60678358880},
	{0.00000000142, 4.53500950354, 6677.70173505060},
	{0.00000000100, 1.34247959502, 9830.38901398780},
	{0.00000000108, 2.66869708217, 10419.98628350760},
	{0.00000000083, 5.73181738271, 4929.68532198360},
	{0.00000000084, 1.14929842944, 10818.13528691580},
	{0.00000000099, 2.61551137742, 26724.89941359840},
	{0.00000000076, 5.73955552897, 7632.94325965020},
	{0.00000000084, 3.85936136739, 796.29800681640},
	{0.00000000065, 3.44980702826, 10264.56588407340},
	{0.00000000082, 6.18741349378, 6688.33840040040},
	{0.00000000057, 6.26483235290, 9468.26787725700},
	{0.00000000057, 3.22569928236, 12832.75874170460},
	{0.00000000057, 1.64237063245, 7210.91581849420},
	{0.00000000056, 2.67589330508, 9492.14631500480},
	{0.00000000053, 5.43922764587, 398.14900340820},
	{0.00000000051, 4.25693864007, 8273.82086703240},
	{0.00000000050, 2.51240818090, 1194.44701022460},
	{0.00000000050, 5.21362719324, 13207.02930736500},
	{0.00000000044, 5.38376440301, 12303.06777661000},
	{0.00000000047, 4.01504004134, 6681.20759974740},
	{0.00000000043, 1.11183270113, 3870.30339179440},
	{0.00000000047, 6.04581305192, 6681.24210705180},
	{0.00000000046, 4.32857993306, 8031.09226305840},
	{0.00000000042, 0.26848832014, 10021.85453375160},
	{0.00000000043, 6.08984121699, 10022.81760116760},
	{0.00000000037, 4.08178891841, 1349.86740965880},
	{0.00000000042, 4.52104600477, 10021.82002644720},
	{0.00000000035, 4.87091729626, 8827.39026987480},
	{0.00000000036, 6.10910831551, 11081.21921028860},
	{0.00000000035, 1.39789454098, 9070.11887384880},
	{0.00000000033, 5.71992391629, 15643.68020330980},
	{0.00000000037, 4.27106838047, 10018.31416175040},
	{0.00000000031, 5.50269500344, 951.71840625060},
	{0.00000000037, 1.88071119483, 7064.12138562280},
	{0.00000000026, 6.01108995623, 11216.28429032400},
	{0.00000000026, 1.55191904155, 10575.40668294180},
	{0.00000000031, 0.94089475776, 6680.24453233140},
	{0.00000000026, 2.14397962255, 9623.68827669120},
	{0.00000000028, 4.00361922136, 8432.76438481560},
	{0.00000000025, 3.04909888089, 13760.59871020740},
	{0.00000000033, 2.81930816477, 8671.96987044060},
	{0.00000000025, 5.31993147893, 8962.45534991020},
	{0.00000000030, 0.63584180471, 553.56940284240},
	{0.00000000027, 2.96898104191, 16706.58525184800},
	{0.00000000026, 3.11614471488, 1748.01641306700},
	{0.00000000024, 6.03259958940, 8270.29774868340},
	{0.00000000025, 2.12757387882, 6894.52394883760},
	{0.00000000020, 5.94324542589, 3767.21061757580},
	{0.00000000020, 5.16271011972, 9638.94074787620},
	{0.00000000018, 2.62494525957, 2281.23049651060},
	{0.00000000018, 0.54862494405, 6674.11130639880},
	{0.00000000017, 1.71122423456, 13171.00144068760},
	{0.00000000019, 1.19709776876, 5486.77784317500},
	{0.00000000023, 0.12198032175, 10973.55568635000},
	{0.00000000016, 2.13814265982, 6681.15754309680},
	{0.00000000017, 5.90592241107, 242.72860397400},
	{0.00000000019, 0.71454311343, 2810.92146160520},
	{0.00000000016, 2.45822520726, 10551.52824519400},
	{0.00000000015, 6.18242140747, 5459.37628707820},
	{0.00000000016, 1.72964627298, 6681.29216370240},
	{0.00000000014, 0.28512193614, 10028.95082710020},
	{0.00000000013, 1.74759770781, 10177.25767953360},
	{0.00000000014, 5.31424135483, 191.44826611160},
	{0.00000000014, 4.95938607846, 12310.18132361080},
	{0.00000000011, 3.23427487345, 8429.24126646660},
	{0.00000000011, 1.66323689163, 382.89653222320},
	{0.00000000009, 5.15345625366, 11773.37681151540},
	{0.00000000012, 3.27957281574, 6872.67311951120},
	{0.00000000009, 2.53500018649, 12295.95422960920},
	{0.00000000010, 1.66347056171, 10014.72373309860},
	{0.00000000010, 3.62064452721, 16173.37116840440},
	{0.00000000008, 3.32449323761, 2914.01423582380},
	{0.00000000009, 3.47289021148, 3340.62968035200},
	{0.00000000007, 1.51284566529, 14158.74771361560},
	{0.00000000009, 1.44225445435, 3340.59517304760},
	{0.00000000008, 6.23704450936, 1751.53953141600},
	{0, 0, 0}
};

struct vsop87_term mars_y4[] = {
	{0.00000012136, 5.53171096923, 10021.83728009940},
	{0.00000014558, 0.00000000000, 0.00000000000},
	{0.00000009397, 5.00023134055, 6681.22485339960},
	{0.00000003728, 2.31744309373, 3340.61242669980},
	{0.00000005176, 5.94994449818, 13362.44970679920},
	{0.00000002424, 3.48212983820, 3496.03282613400},
	{0.00000002408, 2.63869857743, 3185.19202726560},
	{0.00000001495, 0.04984648713, 16703.06213349900},
	{0.00000000596, 4.88542666193, 3097.88382272579},
	{0.00000000591, 1.23338318291, 3583.34103067380},
	{0.00000000380, 2.99761351607, 6525.80445396540},
	{0.00000000354, 0.41910666274, 20043.67456019880},
	{0.00000000286, 2.07451183380, 3894.18182954220},
	{0.00000000285, 4.04744586305, 2787.04302385740},
	{0.00000000253, 6.13013788772, 3344.13554504880},
	{0.00000000256, 6.25236569892, 3337.08930835080},
	{0.00000000152, 0.37871347738, 6684.74797174860},
	{0.00000000128, 3.68714753439, 6836.64525283380},
	{0.00000000088, 1.59660002748, 6923.95345737360},
	{0.00000000071, 0.77284614163, 23384.28698689860},
	{0.00000000056, 0.77975710465, 10025.36039844840},
	{0.00000000049, 4.40921783790, 6127.65545055720},
	{0.00000000063, 3.35944487422, 9866.41688066520},
	{0.00000000034, 5.11011261832, 6438.49624942560},
	{0.00000000018, 5.67273705500, 6489.77658728800},
	{0.00000000015, 5.54124089005, 7477.52286021600},
	{0.00000000012, 4.18496035489, 6682.20517446780},
	{0.00000000012, 3.79977496971, 4399.99435688900},
	{0.00000000013, 4.15046759496, 10177.25767953360},
	{0.00000000014, 2.25691477586, 7234.79425624200},
	{0.00000000011, 1.94853565727, 10264.56588407340},
	{0.00000000011, 0.69449787915, 7079.37385680780},
	{0.00000000012, 5.83137257150, 5729.50644714900},
	{0.00000000013, 1.15304574873, 13365.97282514820},
	{0.00000000010, 0.93942138709, 5331.35744374080},
	{0.00000000011, 1.10451949945, 26724.89941359840},
	{0.00000000008, 3.31794976450, 6298.32832117640},
	{0.00000000007, 4.15606002322, 7875.67186362420},
	{0.00000000007, 2.33508864924, 4933.20844033260},
	{0.00000000004, 1.39676497267, 1194.44701022460},
	{0.00000000004, 2.20893905344, 1349.86740965880},
	{0.00000000004, 5.94715857693, 382.89653222320},
	{0.00000000004, 3.71246158922, 13207.02930736500},
	{0.00000000004, 4.76678794761, 9468.26787725700},
	{0, 0, 0}
};

struct vsop87_term mars_y5[] = {
	{0.00000000353, 3.94830849426, 10021.83728009940},
	{0.00000000274, 4.99240388971, 3496.03282613400},
	{0.00000000272, 1.12308951649, 3185.19202726560},
	{0.00000000238, 4.40065412405, 13362.44970679920},
	{0.00000000151, 1.08010493938, 3340.61242669980},
	{0.00000000170, 3.14159265359, 0.00000000000},
	{0.00000000093, 4.81201084553, 16703.06213349900},
	{0.00000000077, 0.11215015675, 3097.88382272579},
	{0.00000000077, 6.01161676189, 3583.34103067380},
	{0.00000000059, 2.67997407478, 6681.22485339960},
	{0.00000000049, 1.49385098876, 6525.80445396540},
	{0.00000000027, 5.18582314898, 20043.67456019880},
	{0.00000000026, 3.60298036992, 3894.18182954220},
	{0.00000000026, 2.52078654872, 2787.04302385740},
	{0.00000000013, 5.15994044385, 6836.64525283380},
	{0.00000000013, 0.09000961930, 6923.95345737360},
	{0.00000000006, 5.09874289885, 6684.74797174860},
	{0.00000000007, 1.85064036647, 9866.41688066520},
	{0.00000000005, 2.89632661954, 6127.65545055720},
	{0.00000000005, 5.55804387830, 23384.28698689860},
	{0.00000000004, 0.31530831962, 6438.49624942560},
	{0, 0, 0}
};

struct vsop87_term mars_z0[] = {
	{0.04901207220, 3.76712324286, 3340.61242669980},
	{0.00660669541, 0.00000000000, 0.00000000000},
	{0.00228333904, 4.10544022266, 6681.22485339960},
	{0.00015958402, 4.44367058261, 10021.83728009940},
	{0.00001321976, 4.78186604114, 13362.44970679920},
	{0.00000679660, 5.65109977813, 3337.08930835080},
	{0.00000679219, 5.02527030899, 3344.13554504880},
	{0.00000531140, 3.86748390045, 2281.23049651060},
	{0.00000374993, 4.33338216773, 529.69096509460},
	{0.00000325315, 2.24562508217, 1059.38193018920},
	{0.00000218762, 1.18094849702, 3340.59517304760},
	{0.00000218761, 3.21172012852, 3340.62968035200},
	{0.00000152333, 6.08109566130, 6151.53388830500},
	{0.00000146631, 5.09927022855, 398.14900340820},
	{0.00000152443, 2.13254535850, 5621.84292321040},
	{0.00000120328, 5.12010663983, 16703.06213349900},
	{0.00000126016, 3.67803475473, 796.29800681640},
	{0.00000116766, 4.86913583010, 2942.46342329160},
	{0.00000112925, 5.76548397681, 3738.76143010800},
	{0.00000074290, 2.43508234938, 8962.45534991020},
	{0.00000071989, 5.54217679275, 3340.54511639700},
	{0.00000068644, 5.54532471548, 6283.07584999140},
	{0.00000071987, 5.13368040597, 3340.67973700260},
	{0.00000063219, 5.36590967098, 6684.74797174860},
	{0.00000075858, 4.51645136094, 3149.16416058820},
	{0.00000063502, 4.16748385740, 1751.53953141600},
	{0.00000063828, 5.98786823499, 6677.70173505060},
	{0.00000059355, 0.72879549961, 5884.92684658320},
	{0.00000050332, 1.96033823263, 2810.92146160520},
	{0.00000051292, 2.64769056433, 2914.01423582380},
	{0.00000044615, 5.88956380171, 3532.06069281140},
	{0.00000045001, 2.29942389620, 1589.07289528380},
	{0.00000045526, 2.27415776311, 1194.44701022460},
	{0.00000045098, 4.08200115074, 4136.91043351620},
	{0.00000033148, 2.01609063016, 5486.77784317500},
	{0.00000029003, 2.64937555759, 426.59819087600},
	{0.00000033968, 0.46851841759, 2544.31441988340},
	{0.00000027697, 5.54319865094, 191.44826611160},
	{0.00000030473, 4.98782051819, 3870.30339179440},
	{0.00000022262, 0.19101027284, 9492.14631500480},
	{0.00000021566, 2.45059201892, 3333.49887969900},
	{0.00000019900, 4.78493597626, 213.29909543800},
	{0.00000019445, 3.36733718353, 5088.62883976680},
	{0.00000022415, 2.80792353370, 3496.03282613400},
	{0.00000019109, 0.86825937304, 1592.59601363280},
	{0.00000024101, 2.57371991774, 4399.99435688900},
	{0.00000020382, 3.55004736979, 6681.24210705180},
	{0.00000019188, 1.51640815942, 3185.19202726560},
	{0.00000020382, 1.51927573830, 6681.20759974740},
	{0.00000013488, 2.86475891587, 3341.59274776800},
	{0.00000013492, 1.52791184830, 3339.63210563160},
	{0.00000011777, 4.79772279974, 3553.91152213780},
	{0.00000012741, 6.05559229749, 7079.37385680780},
	{0.00000011907, 1.65033513222, 6254.62666252360},
	{0.00000011511, 2.75835305381, 12303.06777661000},
	{0.00000011629, 5.45832237690, 20043.67456019880},
	{0.00000011780, 4.75307421274, 4690.47983635860},
	{0.00000010587, 6.14125670809, 7.11354700080},
	{0.00000008746, 1.07533372055, 9225.53927328300},
	{0.00000009300, 5.74426412364, 1990.74501704100},
	{0.00000009010, 5.91031650213, 9623.68827669120},
	{0.00000009099, 4.14734627288, 3127.31333126180},
	{0.00000008399, 2.65942772730, 4535.05943692440},
	{0.00000009575, 0.26669816734, 10213.28554621100},
	{0.00000011208, 2.64763421097, 8432.76438481560},
	{0.00000008425, 5.67806346712, 6467.92575796160},
	{0.00000007879, 6.16301318418, 4292.33083295040},
	{0.00000006986, 1.31599425886, 3894.18182954220},
	{0.00000007013, 4.83160093113, 6489.77658728800},
	{0.00000006707, 5.47201048198, 6681.29216370240},
	{0.00000008732, 5.94456391651, 5092.15195811580},
	{0.00000006427, 6.10941025846, 4562.46099302120},
	{0.00000008234, 3.68630710748, 2700.71514038580},
	{0.00000007214, 1.11647593098, 3319.83703120740},
	{0.00000006128, 4.51741845562, 1221.84856632140},
	{0.00000006627, 5.70488581385, 10025.36039844840},
	{0.00000006712, 0.04223488375, 10018.31416175040},
	{0.00000007157, 3.27593626835, 3361.38782219220},
	{0.00000005667, 1.84572324920, 2957.71589447660},
	{0.00000006707, 5.88050686882, 6681.15754309680},
	{0.00000004916, 2.93046960145, 2787.04302385740},
	{0.00000004722, 2.41041908083, 3344.20285535160},
	{0.00000004650, 1.71276888306, 639.89728631400},
	{0.00000004742, 1.97920373919, 3337.02199804800},
	{0.00000004597, 4.41002877977, 7477.52286021600},
	{0.00000005433, 4.33760555117, 2388.89402044920},
	{0.00000005641, 2.43527331240, 2118.76386037840},
	{0.00000004363, 2.24320799714, 11773.37681151540},
	{0.00000004127, 2.04411881734, 2146.16541647520},
	{0.00000003613, 3.61081984797, 8429.24126646660},
	{0.00000003478, 2.64660968975, 4929.68532198360},
	{0.00000003714, 1.76418965622, 382.89653222320},
	{0.00000003331, 6.17753431621, 7210.91581849420},
	{0.00000003580, 3.90470994536, 7903.07341972100},
	{0.00000003111, 2.03406809335, 155.42039943420},
	{0.00000003351, 0.47359753009, 3475.67750673520},
	{0.00000003025, 1.91083270977, 9595.23908922340},
	{0.00000003493, 2.25666784516, 3723.50895892300},
	{0.00000003509, 3.91758478184, 3205.54734666440},
	{0.00000003007, 0.81247341820, 2274.11694950980},
	{0.00000002982, 3.68257004005, 2288.34404351140},
	{0.00000002567, 4.96092533051, 8031.09226305840},
	{0.00000002649, 2.98742483865, 3767.21061757580},
	{0.00000002322, 1.23249592342, 4933.20844033260},
	{0.00000002733, 0.51395284395, 12832.75874170460},
	{0.00000002136, 3.88842223350, 10021.85453375160},
	{0.00000002136, 1.85765060200, 10021.82002644720},
	{0.00000002772, 2.43968968772, 8827.39026987480},
	{0.00000002162, 3.01828376513, 6041.32756708560},
	{0.00000002091, 3.80489059877, 6872.67311951120},
	{0.00000002233, 2.94758000961, 7740.60678358880},
	{0.00000002614, 4.45694073527, 6674.11130639880},
	{0.00000001930, 5.30759100687, 1066.49547719000},
	{0.00000002513, 0.10458597053, 3583.34103067380},
	{0.00000002104, 2.45809927011, 1052.26838318840},
	{0.00000001861, 4.13522134185, 1349.86740965880},
	{0.00000001728, 2.95584201533, 12168.00269657460},
	{0.00000001840, 0.20978853293, 4032.77002792660},
	{0.00000001669, 5.50497155791, 951.71840625060},
	{0.00000001911, 2.94107630035, 1748.01641306700},
	{0.00000001442, 1.87731237490, 3077.52850332700},
	{0.00000001589, 1.73601297200, 3369.06161416760},
	{0.00000001379, 0.09013023527, 10419.98628350760},
	{0.00000001392, 0.27504136647, 3325.35995551480},
	{0.00000001580, 4.48665176300, 3.52311834900},
	{0.00000001766, 1.85661467458, 6525.80445396540},
	{0.00000001292, 2.51829136056, 3603.69635007260},
	{0.00000001297, 5.48481699939, 11371.70468975820},
	{0.00000001613, 0.62341029242, 553.56940284240},
	{0.00000001384, 4.11719633248, 3355.86489788480},
	{0.00000001261, 1.86730474733, 6680.24453233140},
	{0.00000001610, 2.65671079949, 3312.16323923200},
	{0.00000001274, 0.55350948232, 3191.04922956520},
	{0.00000001704, 4.50757815133, 3097.88382272579},
	{0.00000001460, 0.04101454115, 7632.94325965020},
	{0.00000001242, 5.75816506092, 149.56319713460},
	{0.00000001230, 1.10948154340, 536.80451209540},
	{0.00000001216, 2.98306649362, 6836.64525283380},
	{0.00000001161, 4.60505013406, 1648.44675719740},
	{0.00000001579, 3.09053337023, 15643.68020330980},
	{0.00000001118, 6.05429252683, 9808.53818466140},
	{0.00000001376, 0.81116680514, 3503.07906283200},
	{0.00000001101, 4.62263227757, 522.57741809380},
	{0.00000001320, 3.23812050004, 3347.72597370060},
	{0.00000001419, 0.32932000507, 3264.34635542420},
	{0.00000001103, 5.79565205719, 6894.52394883760},
	{0.00000001257, 3.20326473314, 6682.20517446780},
	{0.00000000968, 4.43650051215, 103.09277421860},
	{0.00000001004, 4.71380449727, 2487.41604494780},
	{0.00000001014, 0.55883970461, 10973.55568635000},
	{0.00000000950, 2.98201757904, 3178.14579056760},
	{0.00000000958, 1.45300862079, 12566.15169998280},
	{0.00000000964, 5.98684645223, 242.72860397400},
	{0.00000000925, 5.46131905325, 5614.72937620960},
	{0.00000000935, 4.94933845312, 1758.65307841680},
	{0.00000001171, 5.79646129252, 23384.28698689860},
	{0.00000000969, 2.65689194156, 2648.45482547300},
	{0.00000000853, 4.81086337808, 15110.46611986620},
	{0.00000000901, 5.67928823390, 2921.12778282460},
	{0.00000001125, 6.27341969245, 12964.30070339100},
	{0.00000000844, 2.97906384874, 7875.67186362420},
	{0.00000000811, 0.19379046862, 3346.13535100720},
	{0.00000000812, 4.19639785587, 3335.08950239240},
	{0.00000000774, 1.38696439205, 7234.79425624200},
	{0.00000000761, 1.99221081181, 26087.90314157420},
	{0.00000000742, 0.37908087243, 13358.92658845020},
	{0.00000000732, 5.16784948008, 9830.38901398780},
	{0.00000000946, 1.88936722079, 5628.95647021120},
	{0.00000000820, 4.37824637524, 7373.38245462640},
	{0.00000000671, 5.25224406605, 76.26607127560},
	{0.00000000785, 4.59990880607, 6438.49624942560},
	{0.00000000668, 3.61130377946, 6702.00024889200},
	{0.00000000655, 2.60002275981, 11243.68584642080},
	{0.00000000760, 3.03501058836, 3360.96774609859},
	{0.00000000764, 4.37581912554, 11769.85369316640},
	{0.00000000704, 5.80908299008, 10021.90459040220},
	{0.00000000840, 6.11799044851, 5331.35744374080},
	{0.00000000641, 1.73269627789, 1692.16566950240},
	{0.00000000629, 1.09880202633, 14314.16811304980},
	{0.00000000704, 6.21757937692, 10021.76996979660},
	{0.00000000646, 3.01919436853, 9381.93999378540},
	{0.00000000612, 3.40750819704, 10713.99488132620},
	{0.00000000732, 6.04237219046, 13365.97282514820},
	{0.00000000771, 2.47252701375, 15113.98923821520},
	{0.00000000621, 5.85690842904, 3351.24909204960},
	{0.00000000767, 1.35441792357, 3320.25710730100},
	{0.00000000586, 0.79051565116, 853.19638175200},
	{0.00000000692, 1.46718257115, 6660.44945790720},
	{0.00000000669, 0.51352618116, 7064.12138562280},
	{0.00000000528, 3.12611933096, 74.78159856730},
	{0.00000000600, 5.04547651146, 692.15760122680},
	{0.00000000630, 1.58386830258, 1581.95934828300},
	{0.00000000623, 4.81491846507, 3329.97576135000},
	{0.00000000661, 2.79286199869, 2906.90068882300},
	{0.00000000570, 4.61307898923, 3074.00538497800},
	{0.00000000524, 6.05770135572, 3607.21946842160},
	{0.00000000516, 2.43629649577, 13916.01910964160},
	{0.00000000507, 2.02939502894, 3333.56619000180},
	{0.00000000605, 1.93804011864, 10575.40668294180},
	{0.00000000488, 4.67812564849, 5729.50644714900},
	{0.00000000465, 5.56224766580, 8955.34180290940},
	{0.00000000467, 3.02812406788, 6144.42034130420},
	{0.00000000524, 2.17529898104, 6298.32832117640},
	{0.00000000449, 4.27905913954, 6546.15977336420},
	{0.00000000442, 2.21279250958, 3347.65866339780},
	{0.00000000442, 0.35835774849, 18052.92954315780},
	{0.00000000452, 4.74868579573, 5828.02847164760},
	{0.00000000444, 2.31126753824, 6677.63442474780},
	{0.00000000454, 5.96502230469, 419.48464387520},
	{0.00000000457, 2.76482172070, 5459.37628707820},
	{0.00000000452, 2.18667537557, 12935.85151592320},
	{0.00000000440, 2.28024553720, 8969.56889691100},
	{0.00000000439, 3.26823913184, 6127.65545055720},
	{0.00000000417, 2.62418009712, 433.71173787680},
	{0.00000000450, 4.97549718782, 6531.66165626500},
	{0.00000000467, 5.81074791371, 6158.64743530580},
	{0.00000000430, 4.78793443738, 3863.18984479360},
	{0.00000000409, 1.99836071636, 3980.50971301380},
	{0.00000000399, 4.74255258433, 10818.13528691580},
	{0.00000000453, 6.26634249241, 14712.31711645800},
	{0.00000000437, 2.74634913436, 6684.81528205140},
	{0.00000000400, 2.77865299135, 4989.05918389720},
	{0.00000000506, 1.18461823734, 1744.42598441520},
	{0.00000000403, 5.36937826882, 1596.18644228460},
	{0.00000000380, 4.97818849120, 10014.72373309860},
	{0.00000000371, 3.33405966002, 10177.25767953360},
	{0.00000000361, 5.24088703687, 2178.13772229200},
	{0.00000000400, 1.62063267593, 14584.29827312060},
	{0.00000000403, 1.82423390219, 3399.98628861340},
	{0.00000000410, 4.54392931383, 3344.49376205780},
	{0.00000000418, 4.88395861492, 3443.70520091840},
	{0.00000000341, 3.76526341028, 6688.33840040040},
	{0.00000000387, 2.20624213901, 3281.23856478620},
	{0.00000000328, 1.60706573380, 3546.79797513700},
	{0.00000000346, 5.93876607715, 3364.49086444760},
	{0.00000000427, 0.42766619939, 10551.52824519400},
	{0.00000000333, 2.97391198780, 17256.63153634140},
	{0.00000000351, 0.89374033083, 16173.37116840440},
	{0.00000000387, 5.50555914948, 3973.39616601300},
	{0.00000000410, 6.13790219128, 3336.73109134180},
	{0.00000000349, 4.74282066857, 3316.73398895200},
	{0.00000000366, 0.54436256149, 110.20632121940},
	{0.00000000284, 2.49529211057, 6784.31762761820},
	{0.00000000338, 3.01411006339, 8270.29774868340},
	{0.00000000279, 0.15295518242, 135.06508003540},
	{0.00000000290, 4.30595018325, 16858.48253293320},
	{0.00000000277, 3.21266616465, 8329.67161059700},
	{0.00000000303, 4.39325865345, 2818.03500860600},
	{0.00000000302, 5.76020823903, 2384.32327072920},
	{0.00000000360, 0.81576341528, 6816.28993343500},
	{0.00000000287, 5.89677690833, 3340.19235060619},
	{0.00000000300, 3.61030466166, 3304.58456002240},
	{0.00000000264, 5.45859266580, 6604.95878212400},
	{0.00000000330, 3.81421832191, 13517.87010623340},
	{0.00000000287, 4.78503735880, 3341.03250279340},
	{0.00000000343, 1.02525479822, 3230.40610548040},
	{0.00000000246, 2.64795288862, 3304.00706139560},
	{0.00000000310, 1.76905174573, 10404.73381232260},
	{0.00000000241, 3.33235757149, 11081.21921028860},
	{0.00000000245, 1.00254307216, 3209.07046501340},
	{0.00000000295, 0.78856158130, 3376.64029337720},
	{0.00000000247, 4.74687572675, 9779.10867612540},
	{0.00000000241, 1.74832761256, 3377.21779200400},
	{0.00000000264, 1.82146900201, 17654.78053974960},
	{0.00000000274, 2.60650323538, 3657.00429635640},
	{0.00000000238, 0.43806562773, 6923.95345737360},
	{0.00000000227, 2.88048108848, 3415.39402526710},
	{0.00000000300, 0.70241789966, 3134.42687826260},
	{0.00000000237, 2.19737291235, 13362.43245314700},
	{0.00000000220, 1.43836209680, 6606.44325483230},
	{0.00000000222, 3.39627559384, 3472.15438838620},
	{0.00000000217, 2.18530503085, 20995.39296644940},
	{0.00000000254, 2.93819031378, 5085.03841111500},
	{0.00000000236, 4.23042638023, 13362.46696045140},
	{0.00000000242, 0.41755696147, 1861.74585263540},
	{0.00000000285, 0.10171887281, 17085.95866572220},
	{0.00000000218, 0.33151885058, 16304.91313009080},
	{0.00000000215, 5.26457047836, 1375.77379984580},
	{0.00000000207, 3.60591178333, 7107.82304427560},
	{0.00000000196, 3.34505476799, 8439.87793181640},
	{0.00000000192, 5.08475415071, 13119.72110282519},
	{0.00000000269, 0.19698472851, 3024.22055704320},
	{0.00000000194, 4.52507414451, 220.41264243880},
	{0.00000000186, 1.75940958561, 2221.85663459700},
	{0.00000000194, 3.41534671398, 18984.29263000960},
	{0.00000000208, 3.02738720944, 3511.28529731900},
	{0.00000000204, 6.00463791835, 162.46663613220},
	{0.00000000183, 3.62962279261, 9168.64089834740},
	{0.00000000175, 4.04165128738, 3760.09707057500},
	{0.00000000174, 4.51117927233, 23539.70738633280},
	{0.00000000193, 5.88968824988, 2803.80791460440},
	{0.00000000190, 6.17637484900, 13745.34623902240},
	{0.00000000208, 3.34809361979, 3341.04230982650},
	{0.00000000198, 0.97311347960, 3265.83082813250},
	{0.00000000205, 4.20157952693, 6843.69148953180},
	{0.00000000222, 1.37049171707, 3169.93955608060},
	{0.00000000183, 2.19041678580, 9866.41688066520},
	{0.00000000225, 0.32450219510, 13149.15061136120},
	{0.00000000211, 4.38136759956, 640.87760738220},
	{0.00000000200, 3.00112781370, 1162.47470440780},
	{0.00000000208, 6.18496348629, 1478.86657406440},
	{0.00000000173, 3.90520749444, 5099.26550511660},
	{0.00000000175, 0.38064797785, 956.28915597060},
	{0.00000000158, 2.98574812713, 13524.91634293140},
	{0.00000000170, 3.37406232659, 15508.61512327440},
	{0.00000000184, 2.09449845330, 949.17560896980},
	{0.00000000171, 4.75570011379, 6261.74020952440},
	{0.00000000188, 5.56241899175, 16460.33352952499},
	{0.00000000205, 5.01940138208, 1118.75579210280},
	{0.00000000156, 3.68058177082, 13553.89797291080},
	{0.00000000170, 2.00050957424, 224.34479570190},
	{0.00000000208, 1.04576950390, 3340.18254357310},
	{0.00000000156, 4.90620162208, 20199.09495963300},
	{0.00000000174, 5.58778318130, 2766.26762836500},
	{0.00000000169, 3.71127165203, 10184.30391623160},
	{0.00000000171, 3.60600294119, 20597.24396304120},
	{0.00000000140, 1.54110979029, 2111.65031337760},
	{0.00000000145, 6.17161140540, 19800.94595622480},
	{0.00000000156, 0.43599559375, 4459.36821880260},
	{0.00000000143, 0.19892133285, 10235.13637553740},
	{0.00000000184, 1.58017928752, 8273.82086703240},
	{0.00000000133, 2.86759235449, 20618.01935853360},
	{0.00000000151, 1.59809012076, 13892.14067189380},
	{0.00000000133, 6.14918807002, 17277.40693183380},
	{0.00000000167, 0.94707767481, 3274.12501778540},
	{0.00000000143, 4.48621138334, 632.78373931320},
	{0.00000000126, 4.54286582844, 3914.95722503460},
	{0.00000000145, 2.88581037055, 4392.88080988820},
	{0.00000000165, 5.44939669734, 1228.96211332220},
	{0.00000000124, 2.73197400851, 3407.09983561420},
	{0.00000000145, 5.65866985683, 4407.10790388980},
	{0.00000000164, 2.20529053904, 38.13303563780},
	{0.00000000158, 1.72206104768, 3296.89351439480},
	{0.00000000116, 0.02904609570, 26482.17080962440},
	{0.00000000156, 1.25691413032, 3384.33133900480},
	{0.00000000117, 4.96153079924, 3981.49003408200},
	{0.00000000154, 2.17255031800, 1964.83862685400},
	{0.00000000113, 3.06854044437, 206.18554843720},
	{0.00000000117, 2.13763640035, 29424.63423291600},
	{0.00000000129, 2.20198223551, 3450.81874791920},
	{0.00000000115, 5.24850953150, 3237.51965248120},
	{0.00000000112, 6.26358102825, 2125.87740737920},
	{0.00000000112, 4.67861613977, 2807.39834325620},
	{0.00000000115, 0.38603739544, 12721.57209941700},
	{0.00000000113, 1.36558076768, 6709.67404086740},
	{0.00000000144, 0.22567806033, 263.08392337280},
	{0.00000000109, 5.27187307952, 5518.75014899180},
	{0.00000000125, 2.20397088123, 30220.93223973240},
	{0.00000000108, 6.20219802547, 6665.97238221460},
	{0.00000000127, 2.68652319514, 7321.12213971360},
	{0.00000000110, 0.18586807658, 29822.78323632420},
	{0.00000000107, 0.50226646577, 22743.40937951640},
	{0.00000000107, 3.59856046864, 5989.06725217280},
	{0.00000000106, 5.69966166034, 33561.54466643220},
	{0.00000000105, 3.97375976080, 9380.95967271720},
	{0, 0, 0}
};

struct vsop87_term mars_z1[] = {
	{0.00331842958, 6.05027773492, 3340.61242669980},
	{0.00047930411, 3.14159265359, 0.00000000000},
	{0.00009896501, 1.61155844715, 6681.22485339960},
	{0.00001700147, 2.63703242065, 10021.83728009940},
	{0.00000240176, 3.12712303414, 13362.44970679920},
	{0.00000114908, 0.95987621952, 3337.08930835080},
	{0.00000045174, 3.39965147567, 3344.13554504880},
	{0.00000041579, 2.22748839237, 2281.23049651060},
	{0.00000031106, 3.52760107307, 16703.06213349900},
	{0.00000022409, 3.73415090010, 5621.84292321040},
	{0.00000024694, 0.56373112343, 529.69096509460},
	{0.00000020211, 6.13722966551, 1059.38193018920},
	{0.00000016081, 0.74382156251, 2942.46342329160},
	{0.00000014813, 5.49499542641, 3340.62968035200},
	{0.00000014813, 3.46422358566, 3340.59517304760},
	{0.00000016942, 1.91917177965, 3532.06069281140},
	{0.00000011449, 6.22900609249, 2810.92146160520},
	{0.00000011579, 0.76965497835, 398.14900340820},
	{0.00000012609, 4.39901271761, 3496.03282613400},
	{0.00000013077, 2.01113624837, 2544.31441988340},
	{0.00000009983, 6.22961426585, 3185.19202726560},
	{0.00000009112, 3.83699360404, 6684.74797174860},
	{0.00000009113, 3.13081230007, 3738.76143010800},
	{0.00000008702, 2.50173196599, 5884.92684658320},
	{0.00000009628, 2.17998735640, 6151.53388830500},
	{0.00000008141, 2.28833672455, 3149.16416058820},
	{0.00000005865, 1.21189730830, 6677.70173505060},
	{0.00000005111, 2.48436031878, 1751.53953141600},
	{0.00000005432, 1.11528937942, 796.29800681640},
	{0.00000004878, 1.13276481337, 3340.67973700260},
	{0.00000005354, 2.17844612869, 4136.91043351620},
	{0.00000004937, 4.54706347937, 8962.45534991020},
	{0.00000004817, 0.99936257717, 2914.01423582380},
	{0.00000004978, 0.42028381998, 1194.44701022460},
	{0.00000004388, 4.00376892513, 5092.15195811580},
	{0.00000004016, 3.25291411222, 3339.63210563160},
	{0.00000004876, 1.53898509406, 3340.54511639700},
	{0.00000004597, 1.56379087387, 6283.07584999140},
	{0.00000004674, 3.93431019327, 5486.77784317500},
	{0.00000003907, 3.89954335391, 20043.67456019880},
	{0.00000003595, 5.45219310813, 1592.59601363280},
	{0.00000003375, 3.44635837371, 2146.16541647520},
	{0.00000003336, 5.20503259965, 5088.62883976680},
	{0.00000003313, 2.58038243859, 3870.30339179440},
	{0.00000002887, 2.94891175550, 3894.18182954220},
	{0.00000002995, 0.74761803993, 4399.99435688900},
	{0.00000002657, 1.05973335133, 3341.59274776800},
	{0.00000002425, 4.10643839121, 1990.74501704100},
	{0.00000002707, 0.21082942855, 4690.47983635860},
	{0.00000002437, 1.55037887709, 4292.33083295040},
	{0.00000002669, 0.40877211523, 1589.07289528380},
	{0.00000002154, 1.34196532034, 2787.04302385740},
	{0.00000002375, 5.44579536089, 3127.31333126180},
	{0.00000001753, 3.92388178094, 7.11354700080},
	{0.00000001650, 4.24815484143, 3723.50895892300},
	{0.00000001595, 0.91889240925, 4535.05943692440},
	{0.00000001929, 2.73824451634, 2388.89402044920},
	{0.00000001444, 0.15895080264, 2957.71589447660},
	{0.00000001405, 3.64849603977, 155.42039943420},
	{0.00000001453, 0.57347650924, 426.59819087600},
	{0.00000001471, 4.20495798401, 10025.36039844840},
	{0.00000001318, 0.40890394627, 213.29909543800},
	{0.00000001523, 4.04272530212, 7079.37385680780},
	{0.00000001553, 5.95800074808, 3097.88382272579},
	{0.00000001436, 3.01319373979, 6254.62666252360},
	{0.00000001520, 4.82580321630, 3583.34103067380},
	{0.00000001347, 1.63836991777, 191.44826611160},
	{0.00000001178, 4.84813144707, 1748.01641306700},
	{0.00000001068, 4.78083964620, 8432.76438481560},
	{0.00000001207, 2.94341645482, 6489.77658728800},
	{0.00000000884, 5.30840180453, 6681.20759974740},
	{0.00000000900, 2.90436997781, 3553.91152213780},
	{0.00000000922, 2.71708263246, 7477.52286021600},
	{0.00000000884, 1.05598798263, 6681.24210705180},
	{0.00000001004, 2.08646328422, 2288.34404351140},
	{0.00000000821, 0.50918826840, 6674.11130639880},
	{0.00000001013, 4.01590051998, 9492.14631500480},
	{0.00000000969, 1.31742925335, 3333.49887969900},
	{0.00000000766, 2.75216606760, 9225.53927328300},
	{0.00000001056, 0.30211067524, 6525.80445396540},
	{0.00000000721, 4.45548872348, 4562.46099302120},
	{0.00000000657, 3.57584237140, 1066.49547719000},
	{0.00000000637, 2.65140853163, 2274.11694950980},
	{0.00000000710, 5.97976165391, 639.89728631400},
	{0.00000000696, 3.46051409766, 382.89653222320},
	{0.00000000608, 5.86051939698, 4933.20844033260},
	{0.00000000667, 6.06355547392, 1349.86740965880},
	{0.00000000573, 0.99737613450, 951.71840625060},
	{0.00000000591, 1.92029762929, 3325.35995551480},
	{0.00000000711, 2.28848181506, 553.56940284240},
	{0.00000000515, 5.51446088347, 3361.38782219220},
	{0.00000000541, 4.53250433908, 6836.64525283380},
	{0.00000000546, 2.64939261840, 1221.84856632140},
	{0.00000000578, 4.59190674427, 3360.96774609859},
	{0.00000000511, 4.39136424744, 242.72860397400},
	{0.00000000493, 1.51453356449, 6467.92575796160},
	{0.00000000487, 5.76370767302, 3205.54734666440},
	{0.00000000463, 0.99068109709, 4929.68532198360},
	{0.00000000604, 4.38767184707, 1052.26838318840},
	{0.00000000462, 3.45792563670, 3319.83703120740},
	{0.00000000442, 4.14870457392, 6041.32756708560},
	{0.00000000479, 1.97057249483, 10213.28554621100},
	{0.00000000477, 1.29132635006, 3347.72597370060},
	{0.00000000424, 0.17271442573, 522.57741809380},
	{0.00000000447, 2.44807015440, 3355.86489788480},
	{0.00000000395, 0.74904985730, 5614.72937620960},
	{0.00000000516, 6.08458990599, 3320.25710730100},
	{0.00000000438, 1.29035103833, 7740.60678358880},
	{0.00000000484, 4.25897353296, 23384.28698689860},
	{0.00000000477, 0.34212243439, 2700.71514038580},
	{0.00000000415, 0.30661716598, 12303.06777661000},
	{0.00000000396, 1.10712980146, 2118.76386037840},
	{0.00000000435, 3.69772502222, 7210.91581849420},
	{0.00000000388, 6.25800132393, 6438.49624942560},
	{0.00000000469, 3.94488775543, 8827.39026987480},
	{0.00000000341, 1.37941086735, 3767.21061757580},
	{0.00000000341, 1.49962309683, 6682.20517446780},
	{0.00000000338, 5.55906074360, 536.80451209540},
	{0.00000000291, 3.38716490010, 6681.15754309680},
	{0.00000000286, 4.61337372260, 10419.98628350760},
	{0.00000000298, 5.02335774639, 12832.75874170460},
	{0.00000000278, 3.96374902099, 2921.12778282460},
	{0.00000000271, 3.64021714596, 6680.24453233140},
	{0.00000000317, 4.41640100211, 3337.02199804800},
	{0.00000000316, 4.84749260614, 3344.20285535160},
	{0.00000000238, 1.69500091019, 6127.65545055720},
	{0.00000000229, 1.25926585958, 7875.67186362420},
	{0.00000000311, 4.47336599498, 5331.35744374080},
	{0.00000000227, 2.07959309341, 10021.85453375160},
	{0.00000000291, 2.97870352125, 6681.29216370240},
	{0.00000000281, 5.09122041999, 7903.07341972100},
	{0.00000000227, 0.04882339645, 10021.82002644720},
	{0.00000000283, 3.18659167678, 9623.68827669120},
	{0.00000000217, 3.07439801130, 5729.50644714900},
	{0.00000000221, 4.53139041634, 3312.16323923200},
	{0.00000000204, 4.52559015591, 12168.00269657460},
	{0.00000000207, 2.80641141402, 6872.67311951120},
	{0.00000000219, 1.31943624453, 3364.49086444760},
	{0.00000000211, 3.18975604764, 1758.65307841680},
	{0.00000000187, 3.39876387294, 9830.38901398780},
	{0.00000000225, 4.53161555673, 13365.97282514820},
	{0.00000000240, 4.10377804654, 11773.37681151540},
	{0.00000000181, 5.02103622915, 6144.42034130420},
	{0.00000000170, 3.82076107858, 9595.23908922340},
	{0.00000000179, 0.52534002868, 6298.32832117640},
	{0.00000000197, 3.29154622691, 17654.78053974960},
	{0.00000000173, 6.17700699189, 5628.95647021120},
	{0.00000000185, 1.76841265719, 3.52311834900},
	{0.00000000164, 5.16565812417, 6923.95345737360},
	{0.00000000212, 2.49710874752, 3503.07906283200},
	{0.00000000191, 3.06147941687, 3316.73398895200},
	{0.00000000149, 3.09964766740, 10818.13528691580},
	{0.00000000199, 3.91203195189, 6894.52394883760},
	{0.00000000146, 0.99908711721, 433.71173787680},
	{0.00000000164, 0.87273677571, 2487.41604494780},
	{0.00000000142, 0.91426251678, 2699.73481931760},
	{0.00000000147, 1.13949466990, 8955.34180290940},
	{0.00000000161, 1.29304586194, 15643.68020330980},
	{0.00000000141, 0.78662586077, 10018.31416175040},
	{0.00000000170, 2.30475590800, 3346.13535100720},
	{0.00000000156, 4.25533461379, 3475.67750673520},
	{0.00000000168, 5.22254805054, 853.19638175200},
	{0.00000000184, 5.78264875545, 11769.85369316640},
	{0.00000000147, 3.65896907438, 1596.18644228460},
	{0.00000000143, 3.63049733530, 1581.95934828300},
	{0.00000000130, 1.31377876815, 7632.94325965020},
	{0.00000000130, 2.61778742289, 7234.79425624200},
	{0.00000000152, 2.12818166833, 3178.14579056760},
	{0.00000000125, 0.64246695673, 9866.41688066520},
	{0.00000000118, 1.97713868087, 6688.33840040040},
	{0.00000000139, 1.48720938048, 14712.31711645800},
	{0.00000000127, 4.40635089709, 12964.30070339100},
	{0.00000000130, 5.22946780555, 3304.58456002240},
	{0.00000000140, 4.09411983665, 6158.64743530580},
	{0.00000000110, 2.96313731510, 10575.40668294180},
	{0.00000000108, 1.42758307106, 7064.12138562280},
	{0.00000000116, 1.77024829602, 3335.08950239240},
	{0.00000000103, 3.53764086090, 1744.42598441520},
	{0.00000000120, 1.56367501585, 3336.73109134180},
	{0.00000000098, 0.18721764890, 3980.50971301380},
	{0.00000000098, 1.72351303556, 18052.92954315780},
	{0.00000000110, 0.34606761114, 8969.56889691100},
	{0.00000000108, 1.51716677058, 419.48464387520},
	{0.00000000100, 1.71152868829, 2648.45482547300},
	{0.00000000119, 2.97602189356, 640.87760738220},
	{0.00000000096, 1.41608119487, 5085.03841111500},
	{0.00000000089, 0.38926679495, 5459.37628707820},
	{0.00000000082, 3.96541084548, 10021.90459040220},
	{0.00000000084, 2.77343761472, 3344.49376205780},
	{0.00000000080, 4.57789872343, 11243.68584642080},
	{0.00000000081, 4.51984392790, 9381.93999378540},
	{0.00000000102, 5.43466097744, 3376.64029337720},
	{0.00000000076, 4.59412107241, 10177.25767953360},
	{0.00000000074, 0.46347570603, 8429.24126646660},
	{0.00000000078, 1.36874721918, 11081.21921028860},
	{0.00000000080, 5.47863871673, 3369.06161416760},
	{0.00000000071, 0.91306168512, 8270.29774868340},
	{0.00000000072, 4.45423986754, 17256.63153634140},
	{0.00000000097, 4.31072201688, 3077.52850332700},
	{0.00000000071, 4.62498165607, 10551.52824519400},
	{0.00000000066, 0.13337760475, 15110.46611986620},
	{0.00000000067, 2.62252809221, 692.15760122680},
	{0.00000000080, 1.32412177054, 21393.54196985760},
	{0.00000000065, 2.49553722094, 10973.55568635000},
	{0.00000000083, 3.48044851764, 13916.01910964160},
	{0.00000000077, 0.30886632738, 3863.18984479360},
	{0.00000000076, 6.15364247126, 8273.82086703240},
	{0.00000000087, 4.95360412434, 3603.69635007260},
	{0.00000000066, 2.39362487170, 76.26607127560},
	{0.00000000061, 3.16734182399, 2766.26762836500},
	{0.00000000076, 4.86164511219, 20597.24396304120},
	{0.00000000082, 4.37174958841, 10021.76996979660},
	{0.00000000066, 0.21946862187, 8031.09226305840},
	{0.00000000062, 3.45689005120, 13517.87010623340},
	{0.00000000077, 4.77622965669, 4032.77002792660},
	{0.00000000069, 4.07458572512, 4407.10790388980},
	{0.00000000057, 5.01958511504, 5828.02847164760},
	{0.00000000063, 5.03373398018, 1692.16566950240},
	{0.00000000074, 2.77773427484, 3981.49003408200},
	{0.00000000059, 2.42227935458, 12566.15169998280},
	{0.00000000056, 3.55730072615, 10713.99488132620},
	{0.00000000055, 6.23004856059, 3914.95722503460},
	{0.00000000055, 5.34452429591, 13358.92658845020},
	{0.00000000055, 0.80155920044, 11371.70468975820},
	{0.00000000056, 4.79027072937, 16173.37116840440},
	{0.00000000063, 4.38809621285, 7373.38245462640},
	{0.00000000065, 1.83461015336, 14314.16811304980},
	{0.00000000061, 3.35711733735, 20995.39296644940},
	{0.00000000054, 0.51358052231, 6702.00024889200},
	{0.00000000053, 6.24589101777, 20199.09495963300},
	{0.00000000059, 4.96649103229, 3191.04922956520},
	{0.00000000052, 4.94957858677, 24734.15439655740},
	{0, 0, 0}
};

struct vsop87_term mars_z2[] = {
	{0.00013705360, 1.04212852598, 3340.61242669980},
	{0.00005931596, 3.14159265359, 0.00000000000},
	{0.00000716728, 0.12154825255, 6681.22485339960},
	{0.00000138514, 0.78090653399, 10021.83728009940},
	{0.00000025745, 1.39077449077, 13362.44970679920},
	{0.00000012181, 2.58732834908, 3337.08930835080},
	{0.00000004371, 1.87368859535, 16703.06213349900},
	{0.00000004536, 1.36770001683, 3344.13554504880},
	{0.00000003737, 6.00280902795, 3496.03282613400},
	{0.00000002587, 4.62868565055, 3185.19202726560},
	{0.00000001722, 0.98795977798, 2281.23049651060},
	{0.00000001615, 5.66791333096, 5621.84292321040},
	{0.00000001520, 3.54344603378, 3532.06069281140},
	{0.00000001037, 2.63342459156, 2942.46342329160},
	{0.00000001068, 4.66536326031, 1059.38193018920},
	{0.00000000905, 2.04669399323, 6684.74797174860},
	{0.00000001041, 3.88701726221, 2544.31441988340},
	{0.00000000976, 1.98493465010, 529.69096509460},
	{0.00000000770, 5.10113036277, 2810.92146160520},
	{0.00000000688, 4.59085360596, 3894.18182954220},
	{0.00000000713, 4.16328040173, 5884.92684658320},
	{0.00000000689, 2.29465541114, 20043.67456019880},
	{0.00000000622, 4.93952624143, 3339.63210563160},
	{0.00000000696, 5.39983895631, 5486.77784317500},
	{0.00000000567, 0.51314316796, 5088.62883976680},
	{0.00000000610, 0.49406493231, 3340.62968035200},
	{0.00000000610, 4.74647860799, 3340.59517304760},
	{0.00000000647, 1.17822960287, 3097.88382272579},
	{0.00000000515, 0.52495804247, 3149.16416058820},
	{0.00000000462, 6.01031568571, 2787.04302385740},
	{0.00000000439, 0.29884669602, 4136.91043351620},
	{0.00000000503, 2.83961174727, 6677.70173505060},
	{0.00000000446, 3.21959306381, 4292.33083295040},
	{0.00000000393, 5.15600015824, 2146.16541647520},
	{0.00000000384, 4.87193587713, 5092.15195811580},
	{0.00000000390, 1.91255819503, 4690.47983635860},
	{0.00000000374, 4.80085008370, 1194.44701022460},
	{0.00000000430, 3.34783108483, 3583.34103067380},
	{0.00000000375, 3.66085423366, 1592.59601363280},
	{0.00000000337, 5.84337571937, 3723.50895892300},
	{0.00000000325, 2.38085319573, 1990.74501704100},
	{0.00000000323, 5.28429586359, 155.42039943420},
	{0.00000000361, 0.94089120900, 2388.89402044920},
	{0.00000000295, 5.53803343526, 3341.59274776800},
	{0.00000000332, 5.85499743580, 796.29800681640},
	{0.00000000342, 2.58974309074, 398.14900340820},
	{0.00000000315, 1.39878115260, 3738.76143010800},
	{0.00000000348, 3.88712290311, 6151.53388830500},
	{0.00000000257, 5.22188438508, 4399.99435688900},
	{0.00000000265, 0.10458265918, 1748.01641306700},
	{0.00000000309, 4.99847336546, 6525.80445396540},
	{0.00000000222, 5.92527218350, 8962.45534991020},
	{0.00000000201, 2.41602653811, 3340.67973700260},
	{0.00000000202, 4.74840488839, 2957.71589447660},
	{0.00000000187, 2.54789510015, 6283.07584999140},
	{0.00000000222, 4.45800445697, 3333.49887969900},
	{0.00000000189, 2.01790380490, 7.11354700080},
	{0.00000000190, 5.71991161418, 2914.01423582380},
	{0.00000000187, 2.55575861239, 10025.36039844840},
	{0.00000000201, 2.82452292485, 3340.54511639700},
	{0.00000000181, 5.40590734087, 4535.05943692440},
	{0.00000000167, 0.66523343049, 2288.34404351140},
	{0.00000000175, 1.38046108142, 1349.86740965880},
	{0.00000000146, 2.68515136013, 951.71840625060},
	{0.00000000144, 5.14515012962, 6254.62666252360},
	{0.00000000147, 2.71904898461, 242.72860397400},
	{0.00000000189, 4.99333577473, 1589.07289528380},
	{0.00000000149, 4.80676029564, 2274.11694950980},
	{0.00000000129, 2.21550319598, 7079.37385680780},
	{0.00000000118, 1.29196638351, 3127.31333126180},
	{0.00000000145, 3.92808522801, 553.56940284240},
	{0.00000000119, 1.55095338268, 6438.49624942560},
	{0.00000000104, 4.20382366423, 4933.20844033260},
	{0.00000000102, 6.08136575732, 6836.64525283380},
	{0.00000000122, 1.15508040838, 6489.77658728800},
	{0.00000000088, 2.28726712369, 6674.11130639880},
	{0.00000000096, 5.11710185609, 426.59819087600},
	{0.00000000095, 0.97194852729, 7477.52286021600},
	{0.00000000098, 0.37829296009, 3870.30339179440},
	{0.00000000081, 2.95324470602, 213.29909543800},
	{0.00000000100, 2.67089921368, 23384.28698689860},
	{0.00000000099, 6.15770796955, 3347.72597370060},
	{0.00000000082, 0.88675647815, 1751.53953141600},
	{0.00000000077, 2.58299228393, 9492.14631500480},
	{0.00000000064, 3.82120225839, 6681.20759974740},
	{0.00000000064, 5.85173773053, 6681.24210705180},
	{0.00000000061, 0.07710122678, 6127.65545055720},
	{0.00000000061, 5.00961469844, 4562.46099302120},
	{0.00000000057, 2.83943419184, 8955.34180290940},
	{0.00000000054, 3.61966169219, 6923.95345737360},
	{0.00000000066, 2.79752228075, 5331.35744374080},
	{0.00000000051, 2.71026300250, 191.44826611160},
	{0.00000000067, 5.17453941928, 382.89653222320},
	{0.00000000052, 0.06163024115, 1066.49547719000},
	{0.00000000051, 5.98427244306, 6682.20517446780},
	{0.00000000052, 1.39967850157, 5729.50644714900},
	{0.00000000047, 1.96623457652, 10419.98628350760},
	{0.00000000043, 0.76139880953, 6681.29216370240},
	{0.00000000050, 3.77884547078, 7210.91581849420},
	{0.00000000039, 5.87950681446, 7875.67186362420},
	{0.00000000039, 1.40731285611, 3553.91152213780},
	{0.00000000051, 4.11907833593, 639.89728631400},
	{0.00000000046, 5.03496308376, 8969.56889691100},
	{0.00000000051, 5.75564577567, 7740.60678358880},
	{0.00000000037, 2.30909423712, 3320.25710730100},
	{0.00000000037, 0.67405360149, 3360.96774609859},
	{0.00000000036, 5.69385236083, 4929.68532198360},
	{0.00000000038, 2.50888031088, 10018.31416175040},
	{0.00000000035, 0.45122114069, 1052.26838318840},
	{0.00000000037, 4.54908428517, 9866.41688066520},
	{0.00000000033, 5.95090153832, 6041.32756708560},
	{0.00000000035, 2.08435955688, 2699.73481931760},
	{0.00000000032, 0.60244035710, 640.87760738220},
	{0.00000000036, 5.01009549942, 12303.06777661000},
	{0.00000000034, 5.99924292309, 3767.21061757580},
	{0.00000000035, 4.24982817116, 3325.35995551480},
	{0.00000000035, 5.01800237749, 3355.86489788480},
	{0.00000000029, 3.61321450446, 10021.82002644720},
	{0.00000000036, 2.91699961934, 13365.97282514820},
	{0.00000000029, 5.64395801617, 10021.85453375160},
	{0.00000000028, 3.21594452948, 12832.75874170460},
	{0.00000000031, 4.28897734330, 6298.32832117640},
	{0, 0, 0}
};

struct vsop87_term mars_z3[] = {
	{0.00000489822, 2.06392886831, 3340.61242669980},
	{0.00000212575, 0.00000000000, 0.00000000000},
	{0.00000008245, 4.91827993759, 6681.22485339960},
	{0.00000007509, 5.39641448313, 10021.83728009940},
	{0.00000002012, 5.97751013737, 13362.44970679920},
	{0.00000000894, 4.14160765510, 3337.08930835080},
	{0.00000000738, 1.31585722361, 3496.03282613400},
	{0.00000000438, 0.21206488997, 16703.06213349900},
	{0.00000000433, 3.01442752205, 3185.19202726560},
	{0.00000000189, 6.19720760024, 3344.13554504880},
	{0.00000000154, 2.72447562109, 3097.88382272579},
	{0.00000000104, 6.24240951231, 3894.18182954220},
	{0.00000000118, 5.13964237695, 3532.06069281140},
	{0.00000000101, 3.84221865764, 2942.46342329160},
	{0.00000000095, 0.71711229332, 5621.84292321040},
	{0.00000000113, 5.32734880412, 2544.31441988340},
	{0.00000000086, 0.66972591039, 20043.67456019880},
	{0.00000000096, 1.67496098296, 3583.34103067380},
	{0.00000000067, 0.38442120869, 6684.74797174860},
	{0.00000000065, 0.30552815689, 3339.63210563160},
	{0.00000000057, 0.60718635813, 155.42039943420},
	{0.00000000055, 4.34004913784, 2787.04302385740},
	{0.00000000060, 4.89147405929, 4292.33083295040},
	{0.00000000048, 2.88857868688, 529.69096509460},
	{0.00000000049, 0.41339413590, 2146.16541647520},
	{0.00000000048, 3.55422009987, 4690.47983635860},
	{0.00000000061, 3.43120186635, 6525.80445396540},
	{0.00000000041, 1.23015429434, 3723.50895892300},
	{0.00000000040, 2.30430764194, 5088.62883976680},
	{0.00000000028, 4.95849994924, 3149.16416058820},
	{0.00000000027, 5.04320678135, 4136.91043351620},
	{0.00000000027, 5.55557540179, 2388.89402044920},
	{0.00000000024, 3.81281177380, 3341.59274776800},
	{0.00000000021, 0.32087488984, 1990.74501704100},
	{0.00000000019, 0.93486196404, 3340.62968035200},
	{0.00000000019, 5.18727563972, 3340.59517304760},
	{0.00000000019, 3.01047939751, 2957.71589447660},
	{0.00000000018, 1.32103617334, 1592.59601363280},
	{0.00000000018, 1.66958194924, 1194.44701022460},
	{0.00000000017, 0.16564148066, 23384.28698689860},
	{0.00000000023, 0.28320385867, 2281.23049651060},
	{0.00000000018, 6.04232503139, 7079.37385680780},
	{0.00000000018, 3.82519107334, 4535.05943692440},
	{0.00000000018, 1.08925641141, 5486.77784317500},
	{0.00000000015, 5.86641996435, 5884.92684658320},
	{0.00000000021, 2.78318267000, 398.14900340820},
	{0.00000000016, 0.95206290089, 10025.36039844840},
	{0.00000000015, 4.77431089840, 6489.77658728800},
	{0.00000000015, 4.15953675017, 6677.70173505060},
	{0.00000000015, 5.82992617855, 3333.49887969900},
	{0.00000000015, 1.48303517461, 1059.38193018920},
	{0, 0, 0}
};

struct vsop87_term mars_z4[] = {
	{0.00000015141, 0.00000000000, 0.00000000000},
	{0.00000010395, 3.33271505543, 3340.61242669980},
	{0.00000000256, 3.76243173590, 10021.83728009940},
	{0.00000000201, 0.78166958626, 6681.22485339960},
	{0.00000000116, 2.88209375806, 3496.03282613400},
	{0.00000000117, 4.32489294756, 13362.44970679920},
	{0.00000000060, 1.43227319487, 3185.19202726560},
	{0.00000000047, 5.67989354532, 3337.08930835080},
	{0.00000000033, 4.85494204968, 16703.06213349900},
	{0.00000000026, 4.32019018052, 3097.88382272579},
	{0.00000000015, 0.04553834693, 3583.34103067380},
	{0.00000000009, 5.34528843607, 20043.67456019880},
	{0.00000000008, 1.15875671922, 3894.18182954220},
	{0.00000000008, 1.82884997572