/*
 * iau2000a_data.c - Series of terms in the IAU2000A nutation theory
 * Copyright (C) 2010 Shiva Iyer <shiva.iyer AT g m a i l DOT c o m>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <kepler.h>
#include <iau2000a_nutation.h>

struct iau2000a_term1 iau2000a_lunisolar[] = {
	{0,0,0,0,1,-17206.4161,-17.4666,3.3386,9205.2331,0.9086,1.5377},
	{0,0,2,-2,2,-1317.0906,-0.1675,-1.3696,573.0336,-0.3015,-0.4587},
	{0,0,2,0,2,-227.6413,-0.0234,0.2796,97.8459,-0.0485,0.1374},
	{0,0,0,0,2,207.4554,0.0207,-0.0698,-89.7492,0.0470,-0.0291},
	{0,1,0,0,0,147.5877,-0.3633,1.1817,7.3871,-0.0184,-0.1924},
	{0,1,2,-2,2,-51.6821,0.1226,-0.0524,22.4386,-0.0677,-0.0174},
	{1,0,0,0,0,71.1159,0.0073,-0.0872,-0.6750,0.0000,0.0358},
	{0,0,2,0,1,-38.7298,-0.0367,0.0380,20.0728,0.0018,0.0318},
	{1,0,2,0,2,-30.1461,-0.0036,0.0816,12.9025,-0.0063,0.0367},
	{0,-1,2,-2,2,21.5829,-0.0494,0.0111,-9.5929,0.0299,0.0132},
	{0,0,2,-2,1,12.8227,0.0137,0.0181,-6.8982,-0.0009,0.0039},
	{-1,0,2,0,2,12.3457,0.0011,0.0019,-5.3311,0.0032,-0.0004},
	{-1,0,0,2,0,15.6994,0.0010,-0.0168,-0.1235,0.0000,0.0082},
	{1,0,0,0,1,6.3110,0.0063,0.0027,-3.3228,0.0000,-0.0009},
	{-1,0,0,0,1,-5.7976,-0.0063,-0.0189,3.1429,0.0000,-0.0075},
	{-1,0,2,2,2,-5.9641,-0.0011,0.0149,2.5543,-0.0011,0.0066},
	{1,0,2,0,1,-5.1613,-0.0042,0.0129,2.6366,0.0000,0.0078},
	{-2,0,2,0,1,4.5893,0.0050,0.0031,-2.4236,-0.0010,0.0020},
	{0,0,0,2,0,6.3384,0.0011,-0.0150,-0.1220,0.0000,0.0029},
	{0,0,2,2,2,-3.8571,-0.0001,0.0158,1.6452,-0.0011,0.0068},
	{0,-2,2,-2,2,3.2481,0.0000,0.0000,-1.3870,0.0000,0.0000},
	{-2,0,0,2,0,-4.7722,0.0000,-0.0018,0.0477,0.0000,-0.0025},
	{2,0,2,0,2,-3.1046,-0.0001,0.0131,1.3238,-0.0011,0.0059},
	{1,0,2,-2,2,2.8593,0.0000,-0.0001,-1.2338,0.0010,-0.0003},
	{-1,0,2,0,1,2.0441,0.0021,0.0010,-1.0758,0.0000,-0.0003},
	{2,0,0,0,0,2.9243,0.0000,-0.0074,-0.0609,0.0000,0.0013},
	{0,0,2,0,0,2.5887,0.0000,-0.0066,-0.0550,0.0000,0.0011},
	{0,1,0,0,1,-1.4053,-0.0025,0.0079,0.8551,-0.0002,-0.0045},
	{-1,0,0,2,1,1.5164,0.0010,0.0011,-0.8001,0.0000,-0.0001},
	{0,2,2,-2,2,-1.5794,0.0072,-0.0016,0.6850,-0.0042,-0.0005},
	{0,0,-2,2,0,2.1783,0.0000,0.0013,-0.0167,0.0000,0.0013},
	{1,0,0,-2,1,-1.2873,-0.0010,-0.0037,0.6953,0.0000,-0.0014},
	{0,-1,0,0,1,-1.2654,0.0011,0.0063,0.6415,0.0000,0.0026},
	{-1,0,2,2,1,-1.0204,0.0000,0.0025,0.5222,0.0000,0.0015},
	{0,2,0,0,0,1.6707,-0.0085,-0.0010,0.0168,-0.0001,0.0010},
	{1,0,2,2,2,-0.7691,0.0000,0.0044,0.3268,0.0000,0.0019},
	{-2,0,2,0,0,-1.1024,0.0000,-0.0014,0.0104,0.0000,0.0002},
	{0,1,2,0,2,0.7566,-0.0021,-0.0011,-0.3250,0.0000,-0.0005},
	{0,0,2,2,1,-0.6637,-0.0011,0.0025,0.3353,0.0000,0.0014},
	{0,-1,2,0,2,-0.7141,0.0021,0.0008,0.3070,0.0000,0.0004},
	{0,0,0,2,1,-0.6302,-0.0011,0.0002,0.3272,0.0000,0.0004},
	{1,0,2,-2,1,0.5800,0.0010,0.0002,-0.3045,0.0000,-0.0001},
	{2,0,2,-2,2,0.6443,0.0000,-0.0007,-0.2768,0.0000,-0.0004},
	{-2,0,0,2,1,-0.5774,-0.0011,-0.0015,0.3041,0.0000,-0.0005},
	{2,0,2,0,1,-0.5350,0.0000,0.0021,0.2695,0.0000,0.0012},
	{0,-1,2,-2,1,-0.4752,-0.0011,-0.0003,0.2719,0.0000,-0.0003},
	{0,0,0,-2,1,-0.4940,-0.0011,-0.0021,0.2720,0.0000,-0.0009},
	{-1,-1,0,2,0,0.7350,0.0000,-0.0008,-0.0051,0.0000,0.0004},
	{2,0,0,-2,1,0.4065,0.0000,0.0006,-0.2206,0.0000,0.0001},
	{1,0,0,2,0,0.6579,0.0000,-0.0024,-0.0199,0.0000,0.0002},
	{0,1,2,-2,1,0.3579,0.0000,0.0005,-0.1900,0.0000,0.0001},
	{1,-1,0,0,0,0.4725,0.0000,-0.0006,-0.0041,0.0000,0.0003},
	{-2,0,2,0,2,-0.3075,0.0000,-0.0002,0.1313,0.0000,-0.0001},
	{3,0,2,0,2,-0.2904,0.0000,0.0015,0.1233,0.0000,0.0007},
	{0,-1,0,2,0,0.4348,0.0000,-0.0010,-0.0081,0.0000,0.0002},
	{1,-1,2,0,2,-0.2878,0.0000,0.0008,0.1232,0.0000,0.0004},
	{0,0,0,1,0,-0.4230,0.0000,0.0005,-0.0020,0.0000,-0.0002},
	{-1,-1,2,2,2,-0.2819,0.0000,0.0007,0.1207,0.0000,0.0003},
	{-1,0,2,0,0,-0.4056,0.0000,0.0005,0.0040,0.0000,-0.0002},
	{0,-1,2,2,2,-0.2647,0.0000,0.0011,0.1129,0.0000,0.0005},
	{-2,0,0,0,1,-0.2294,0.0000,-0.0010,0.1266,0.0000,-0.0004},
	{1,1,2,0,2,0.2481,0.0000,-0.0007,-0.1062,0.0000,-0.0003},
	{2,0,0,0,1,0.2179,0.0000,-0.0002,-0.1129,0.0000,-0.0002},
	{-1,1,0,1,0,0.3276,0.0000,0.0001,-0.0009,0.0000,0.0000},
	{1,1,0,0,0,-0.3389,0.0000,0.0005,0.0035,0.0000,-0.0002},
	{1,0,2,0,0,0.3339,0.0000,-0.0013,-0.0107,0.0000,0.0001},
	{-1,0,2,-2,1,-0.1987,0.0000,-0.0006,0.1073,0.0000,-0.0002},
	{1,0,0,0,2,-0.1981,0.0000,0.0000,0.0854,0.0000,0.0000},
	{-1,0,0,1,0,0.4026,0.0000,-0.0353,-0.0553,0.0000,-0.0139},
	{0,0,2,1,2,0.1660,0.0000,-0.0005,-0.0710,0.0000,-0.0002},
	{-1,0,2,4,2,-0.1521,0.0000,0.0009,0.0647,0.0000,0.0004},
	{-1,1,0,1,1,0.1314,0.0000,0.0000,-0.0700,0.0000,0.0000},
	{0,-2,2,-2,1,-0.1283,0.0000,0.0000,0.0672,0.0000,0.0000},
	{1,0,2,2,1,-0.1331,0.0000,0.0008,0.0663,0.0000,0.0004},
	{-2,0,2,2,2,0.1383,0.0000,-0.0002,-0.0594,0.0000,-0.0002},
	{-1,0,0,0,2,0.1405,0.0000,0.0004,-0.0610,0.0000,0.0002},
	{1,1,2,-2,2,0.1290,0.0000,0.0000,-0.0556,0.0000,0.0000},
	{-2,0,2,4,2,-0.1214,0.0000,0.0005,0.0518,0.0000,0.0002},
	{-1,0,4,0,2,0.1146,0.0000,-0.0003,-0.0490,0.0000,-0.0001},
	{2,0,2,-2,1,0.1019,0.0000,-0.0001,-0.0527,0.0000,-0.0001},
	{2,0,2,2,2,-0.1100,0.0000,0.0009,0.0465,0.0000,0.0004},
	{1,0,0,2,1,-0.0970,0.0000,0.0002,0.0496,0.0000,0.0001},
	{3,0,0,0,0,0.1575,0.0000,-0.0006,-0.0050,0.0000,0.0000},
	{3,0,2,-2,2,0.0934,0.0000,-0.0003,-0.0399,0.0000,-0.0001},
	{0,0,4,-2,2,0.0922,0.0000,-0.0001,-0.0395,0.0000,-0.0001},
	{0,1,2,0,1,0.0815,0.0000,-0.0001,-0.0422,0.0000,-0.0001},
	{0,0,-2,2,1,0.0834,0.0000,0.0002,-0.0440,0.0000,0.0001},
	{0,0,2,-2,3,0.1248,0.0000,0.0000,-0.0170,0.0000,0.0001},
	{-1,0,0,4,0,0.1338,0.0000,-0.0005,-0.0039,0.0000,0.0000},
	{2,0,-2,0,1,0.0716,0.0000,-0.0002,-0.0389,0.0000,-0.0001},
	{-2,0,0,4,0,0.1282,0.0000,-0.0003,-0.0023,0.0000,0.0001},
	{-1,-1,0,2,1,0.0742,0.0000,0.0001,-0.0391,0.0000,0.0000},
	{-1,0,0,1,1,0.1020,0.0000,-0.0025,-0.0495,0.0000,-0.0010},
	{0,1,0,0,2,0.0715,0.0000,-0.0004,-0.0326,0.0000,0.0002},
	{0,0,-2,0,1,-0.0666,0.0000,-0.0003,0.0369,0.0000,-0.0001},
	{0,-1,2,0,1,-0.0667,0.0000,0.0001,0.0346,0.0000,0.0001},
	{0,0,2,-1,2,-0.0704,0.0000,0.0000,0.0304,0.0000,0.0000},
	{0,0,2,4,2,-0.0694,0.0000,0.0005,0.0294,0.0000,0.0002},
	{-2,-1,0,2,0,-0.1014,0.0000,-0.0001,0.0004,0.0000,-0.0001},
	{1,1,0,-2,1,-0.0585,0.0000,-0.0002,0.0316,0.0000,-0.0001},
	{-1,1,0,2,0,-0.0949,0.0000,0.0001,0.0008,0.0000,-0.0001},
	{-1,1,0,1,2,-0.0595,0.0000,0.0000,0.0258,0.0000,0.0000},
	{1,-1,0,0,1,0.0528,0.0000,0.0000,-0.0279,0.0000,0.0000},
	{1,-1,2,2,2,-0.0590,0.0000,0.0004,0.0252,0.0000,0.0002},
	{-1,1,2,2,2,0.0570,0.0000,-0.0002,-0.0244,0.0000,-0.0001},
	{3,0,2,0,1,-0.0502,0.0000,0.0003,0.0250,0.0000,0.0002},
	{0,1,-2,2,0,-0.0875,0.0000,0.0001,0.0029,0.0000,0.0000},
	{-1,0,0,-2,1,-0.0492,0.0000,-0.0003,0.0275,0.0000,-0.0001},
	{0,1,2,2,2,0.0535,0.0000,-0.0002,-0.0228,0.0000,-0.0001},
	{-1,-1,2,2,1,-0.0467,0.0000,0.0001,0.0240,0.0000,0.0001},
	{0,-1,0,0,2,0.0591,0.0000,0.0000,-0.0253,0.0000,0.0000},
	{1,0,2,-4,1,-0.0453,0.0000,-0.0001,0.0244,0.0000,-0.0001},
	{-1,0,-2,2,0,0.0766,0.0000,0.0001,0.0009,0.0000,0.0000},
	{0,-1,2,2,1,-0.0446,0.0000,0.0002,0.0225,0.0000,0.0001},
	{2,-1,2,0,2,-0.0488,0.0000,0.0002,0.0207,0.0000,0.0001},
	{0,0,0,2,2,-0.0468,0.0000,0.0000,0.0201,0.0000,0.0000},
	{1,-1,2,0,1,-0.0421,0.0000,0.0001,0.0216,0.0000,0.0001},
	{-1,1,2,0,2,0.0463,0.0000,0.0000,-0.0200,0.0000,0.0000},
	{0,1,0,2,0,-0.0673,0.0000,0.0002,0.0014,0.0000,0.0000},
	{0,-1,-2,2,0,0.0658,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{0,3,2,-2,2,-0.0438,0.0000,0.0000,0.0188,0.0000,0.0000},
	{0,0,0,1,1,-0.0390,0.0000,0.0000,0.0205,0.0000,0.0000},
	{-1,0,2,2,0,0.0639,-0.0011,-0.0002,-0.0019,0.0000,0.0000},
	{2,1,2,0,2,0.0412,0.0000,-0.0002,-0.0176,0.0000,-0.0001},
	{1,1,0,0,1,-0.0361,0.0000,0.0000,0.0189,0.0000,0.0000},
	{1,1,2,0,1,0.0360,0.0000,-0.0001,-0.0185,0.0000,-0.0001},
	{2,0,0,2,0,0.0588,0.0000,-0.0003,-0.0024,0.0000,0.0000},
	{1,0,-2,2,0,-0.0578,0.0000,0.0001,0.0005,0.0000,0.0000},
	{-1,0,0,2,2,-0.0396,0.0000,0.0000,0.0171,0.0000,0.0000},
	{0,1,0,1,0,0.0565,0.0000,-0.0001,-0.0006,0.0000,0.0000},
	{0,1,0,-2,1,-0.0335,0.0000,-0.0001,0.0184,0.0000,-0.0001},
	{-1,0,2,-2,2,0.0357,0.0000,0.0001,-0.0154,0.0000,0.0000},
	{0,0,0,-1,1,0.0321,0.0000,0.0001,-0.0174,0.0000,0.0000},
	{-1,1,0,0,1,-0.0301,0.0000,-0.0001,0.0162,0.0000,0.0000},
	{1,0,2,-1,2,-0.0334,0.0000,0.0000,0.0144,0.0000,0.0000},
	{1,-1,0,2,0,0.0493,0.0000,-0.0002,-0.0015,0.0000,0.0000},
	{0,0,0,4,0,0.0494,0.0000,-0.0002,-0.0019,0.0000,0.0000},
	{1,0,2,1,2,0.0337,0.0000,-0.0001,-0.0143,0.0000,-0.0001},
	{0,0,2,1,1,0.0280,0.0000,-0.0001,-0.0144,0.0000,0.0000},
	{1,0,0,-2,2,0.0309,0.0000,0.0001,-0.0134,0.0000,0.0000},
	{-1,0,2,4,1,-0.0263,0.0000,0.0002,0.0131,0.0000,0.0001},
	{1,0,-2,0,1,0.0253,0.0000,0.0001,-0.0138,0.0000,0.0000},
	{1,1,2,-2,1,0.0245,0.0000,0.0000,-0.0128,0.0000,0.0000},
	{0,0,2,2,0,0.0416,0.0000,-0.0002,-0.0017,0.0000,0.0000},
	{-1,0,2,-1,1,-0.0229,0.0000,0.0000,0.0128,0.0000,0.0000},
	{-2,0,2,2,1,0.0231,0.0000,0.0000,-0.0120,0.0000,0.0000},
	{4,0,2,0,2,-0.0259,0.0000,0.0002,0.0109,0.0000,0.0001},
	{2,-1,0,0,0,0.0375,0.0000,-0.0001,-0.0008,0.0000,0.0000},
	{2,1,2,-2,2,0.0252,0.0000,0.0000,-0.0108,0.0000,0.0000},
	{0,1,2,1,2,-0.0245,0.0000,0.0001,0.0104,0.0000,0.0000},
	{1,0,4,-2,2,0.0243,0.0000,-0.0001,-0.0104,0.0000,0.0000},
	{-1,-1,0,0,1,0.0208,0.0000,0.0001,-0.0112,0.0000,0.0000},
	{0,1,0,2,1,0.0199,0.0000,0.0000,-0.0102,0.0000,0.0000},
	{-2,0,2,4,1,-0.0208,0.0000,0.0001,0.0105,0.0000,0.0000},
	{2,0,2,0,0,0.0335,0.0000,-0.0002,-0.0014,0.0000,0.0000},
	{1,0,0,1,0,-0.0325,0.0000,0.0001,0.0007,0.0000,0.0000},
	{-1,0,0,4,1,-0.0187,0.0000,0.0000,0.0096,0.0000,0.0000},
	{-1,0,4,0,1,0.0197,0.0000,-0.0001,-0.0100,0.0000,0.0000},
	{2,0,2,2,1,-0.0192,0.0000,0.0002,0.0094,0.0000,0.0001},
	{0,0,2,-3,2,-0.0188,0.0000,0.0000,0.0083,0.0000,0.0000},
	{-1,-2,0,2,0,0.0276,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{2,1,0,0,0,-0.0286,0.0000,0.0001,0.0006,0.0000,0.0000},
	{0,0,4,0,2,0.0186,0.0000,-0.0001,-0.0079,0.0000,0.0000},
	{0,0,0,0,3,-0.0219,0.0000,0.0000,0.0043,0.0000,0.0000},
	{0,3,0,0,0,0.0276,0.0000,0.0000,0.0002,0.0000,0.0000},
	{0,0,2,-4,1,-0.0153,0.0000,-0.0001,0.0084,0.0000,0.0000},
	{0,-1,0,2,1,-0.0156,0.0000,0.0000,0.0081,0.0000,0.0000},
	{0,0,0,4,1,-0.0154,0.0000,0.0001,0.0078,0.0000,0.0000},
	{-1,-1,2,4,2,-0.0174,0.0000,0.0001,0.0075,0.0000,0.0000},
	{1,0,2,4,2,-0.0163,0.0000,0.0002,0.0069,0.0000,0.0001},
	{-2,2,0,2,0,-0.0228,0.0000,0.0000,0.0001,0.0000,0.0000},
	{-2,-1,2,0,1,0.0091,0.0000,-0.0004,-0.0054,0.0000,-0.0002},
	{-2,0,0,2,2,0.0175,0.0000,0.0000,-0.0075,0.0000,0.0000},
	{-1,-1,2,0,2,-0.0159,0.0000,0.0000,0.0069,0.0000,0.0000},
	{0,0,4,-2,1,0.0141,0.0000,0.0000,-0.0072,0.0000,0.0000},
	{3,0,2,-2,1,0.0147,0.0000,0.0000,-0.0075,0.0000,0.0000},
	{-2,-1,0,2,1,-0.0132,0.0000,0.0000,0.0069,0.0000,0.0000},
	{1,0,0,-1,1,0.0159,0.0000,-0.0028,-0.0054,0.0000,0.0011},
	{0,-2,0,2,0,0.0213,0.0000,0.0000,-0.0004,0.0000,0.0000},
	{-2,0,0,4,1,0.0123,0.0000,0.0000,-0.0064,0.0000,0.0000},
	{-3,0,0,0,1,-0.0118,0.0000,-0.0001,0.0066,0.0000,0.0000},
	{1,1,2,2,2,0.0144,0.0000,-0.0001,-0.0061,0.0000,0.0000},
	{0,0,2,4,1,-0.0121,0.0000,0.0001,0.0060,0.0000,0.0000},
	{3,0,2,2,2,-0.0134,0.0000,0.0001,0.0056,0.0000,0.0001},
	{-1,1,2,-2,1,-0.0105,0.0000,0.0000,0.0057,0.0000,0.0000},
	{2,0,0,-4,1,-0.0102,0.0000,0.0000,0.0056,0.0000,0.0000},
	{0,0,0,-2,2,0.0120,0.0000,0.0000,-0.0052,0.0000,0.0000},
	{2,0,2,-4,1,0.0101,0.0000,0.0000,-0.0054,0.0000,0.0000},
	{-1,1,0,2,1,-0.0113,0.0000,0.0000,0.0059,0.0000,0.0000},
	{0,0,2,-1,1,-0.0106,0.0000,0.0000,0.0061,0.0000,0.0000},
	{0,-2,2,2,2,-0.0129,0.0000,0.0001,0.0055,0.0000,0.0000},
	{2,0,0,2,1,-0.0114,0.0000,0.0000,0.0057,0.0000,0.0000},
	{4,0,2,-2,2,0.0113,0.0000,-0.0001,-0.0049,0.0000,0.0000},
	{2,0,0,-2,2,-0.0102,0.0000,0.0000,0.0044,0.0000,0.0000},
	{0,2,0,0,1,-0.0094,0.0000,0.0000,0.0051,0.0000,0.0000},
	{1,0,0,-4,1,-0.0100,0.0000,-0.0001,0.0056,0.0000,0.0000},
	{0,2,2,-2,1,0.0087,0.0000,0.0000,-0.0047,0.0000,0.0000},
	{-3,0,0,4,0,0.0161,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{-1,1,2,0,1,0.0096,0.0000,0.0000,-0.0050,0.0000,0.0000},
	{-1,-1,0,4,0,0.0151,0.0000,-0.0001,-0.0005,0.0000,0.0000},
	{-1,-2,2,2,2,-0.0104,0.0000,0.0000,0.0044,0.0000,0.0000},
	{-2,-1,2,4,2,-0.0110,0.0000,0.0000,0.0048,0.0000,0.0000},
	{1,-1,2,2,1,-0.0100,0.0000,0.0001,0.0050,0.0000,0.0000},
	{-2,1,0,2,0,0.0092,0.0000,-0.0005,0.0012,0.0000,-0.0002},
	{-2,1,2,0,1,0.0082,0.0000,0.0000,-0.0045,0.0000,0.0000},
	{2,1,0,-2,1,0.0082,0.0000,0.0000,-0.0045,0.0000,0.0000},
	{-3,0,2,0,1,-0.0078,0.0000,0.0000,0.0041,0.0000,0.0000},
	{-2,0,2,-2,1,-0.0077,0.0000,0.0000,0.0043,0.0000,0.0000},
	{-1,1,0,2,2,0.0002,0.0000,0.0000,0.0054,0.0000,0.0000},
	{0,-1,2,-1,2,0.0094,0.0000,0.0000,-0.0040,0.0000,0.0000},
	{-1,0,4,-2,2,-0.0093,0.0000,0.0000,0.0040,0.0000,0.0000},
	{0,-2,2,0,2,-0.0083,0.0000,0.0010,0.0040,0.0000,-0.0002},
	{-1,0,2,1,2,0.0083,0.0000,0.0000,-0.0036,0.0000,0.0000},
	{2,0,0,0,2,-0.0091,0.0000,0.0000,0.0039,0.0000,0.0000},
	{0,0,2,0,3,0.0128,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{-2,0,4,0,2,-0.0079,0.0000,0.0000,0.0034,0.0000,0.0000},
	{-1,0,-2,0,1,-0.0083,0.0000,0.0000,0.0047,0.0000,0.0000},
	{-1,1,2,2,1,0.0084,0.0000,0.0000,-0.0044,0.0000,0.0000},
	{3,0,0,0,1,0.0083,0.0000,0.0000,-0.0043,0.0000,0.0000},
	{-1,0,2,3,2,0.0091,0.0000,0.0000,-0.0039,0.0000,0.0000},
	{2,-1,2,0,1,-0.0077,0.0000,0.0000,0.0039,0.0000,0.0000},
	{0,1,2,2,1,0.0084,0.0000,0.0000,-0.0043,0.0000,0.0000},
	{0,-1,2,4,2,-0.0092,0.0000,0.0001,0.0039,0.0000,0.0000},
	{2,-1,2,2,2,-0.0092,0.0000,0.0001,0.0039,0.0000,0.0000},
	{0,2,-2,2,0,-0.0094,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,-1,2,-1,1,0.0068,0.0000,0.0000,-0.0036,0.0000,0.0000},
	{0,-2,0,0,1,-0.0061,0.0000,0.0000,0.0032,0.0000,0.0000},
	{1,0,2,-4,2,0.0071,0.0000,0.0000,-0.0031,0.0000,0.0000},
	{1,-1,0,-2,1,0.0062,0.0000,0.0000,-0.0034,0.0000,0.0000},
	{-1,-1,2,0,1,-0.0063,0.0000,0.0000,0.0033,0.0000,0.0000},
	{1,-1,2,-2,2,-0.0073,0.0000,0.0000,0.0032,0.0000,0.0000},
	{-2,-1,0,4,0,0.0115,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-1,0,0,3,0,-0.0103,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-2,-1,2,2,2,0.0063,0.0000,0.0000,-0.0028,0.0000,0.0000},
	{0,2,2,0,2,0.0074,0.0000,0.0000,-0.0032,0.0000,0.0000},
	{1,1,0,2,0,-0.0103,0.0000,-0.0003,0.0003,0.0000,-0.0001},
	{2,0,2,-1,2,-0.0069,0.0000,0.0000,0.0030,0.0000,0.0000},
	{1,0,2,1,1,0.0057,0.0000,0.0000,-0.0029,0.0000,0.0000},
	{4,0,0,0,0,0.0094,0.0000,0.0000,-0.0004,0.0000,0.0000},
	{2,1,2,0,1,0.0064,0.0000,0.0000,-0.0033,0.0000,0.0000},
	{3,-1,2,0,2,-0.0063,0.0000,0.0000,0.0026,0.0000,0.0000},
	{-2,2,0,2,1,-0.0038,0.0000,0.0000,0.0020,0.0000,0.0000},
	{1,0,2,-3,1,-0.0043,0.0000,0.0000,0.0024,0.0000,0.0000},
	{1,1,2,-4,1,-0.0045,0.0000,0.0000,0.0023,0.0000,0.0000},
	{-1,-1,2,-2,1,0.0047,0.0000,0.0000,-0.0024,0.0000,0.0000},
	{0,-1,0,-1,1,-0.0048,0.0000,0.0000,0.0025,0.0000,0.0000},
	{0,-1,0,-2,1,0.0045,0.0000,0.0000,-0.0026,0.0000,0.0000},
	{-2,0,0,0,2,0.0056,0.0000,0.0000,-0.0025,0.0000,0.0000},
	{-2,0,-2,2,0,0.0088,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-1,0,-2,4,0,-0.0075,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,-2,0,0,0,0.0085,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,1,0,1,1,0.0049,0.0000,0.0000,-0.0026,0.0000,0.0000},
	{-1,2,0,2,0,-0.0074,0.0000,-0.0003,-0.0001,0.0000,-0.0001},
	{1,-1,2,-2,1,-0.0039,0.0000,0.0000,0.0021,0.0000,0.0000},
	{1,2,2,-2,2,0.0045,0.0000,0.0000,-0.0020,0.0000,0.0000},
	{2,-1,2,-2,2,0.0051,0.0000,0.0000,-0.0022,0.0000,0.0000},
	{1,0,2,-1,1,-0.0040,0.0000,0.0000,0.0021,0.0000,0.0000},
	{2,1,2,-2,1,0.0041,0.0000,0.0000,-0.0021,0.0000,0.0000},
	{-2,0,0,-2,1,-0.0042,0.0000,0.0000,0.0024,0.0000,0.0000},
	{1,-2,2,0,2,-0.0051,0.0000,0.0000,0.0022,0.0000,0.0000},
	{0,1,2,1,1,-0.0042,0.0000,0.0000,0.0022,0.0000,0.0000},
	{1,0,4,-2,1,0.0039,0.0000,0.0000,-0.0021,0.0000,0.0000},
	{-2,0,4,2,2,0.0046,0.0000,0.0000,-0.0018,0.0000,0.0000},
	{1,1,2,1,2,-0.0053,0.0000,0.0000,0.0022,0.0000,0.0000},
	{1,0,0,4,0,0.0082,0.0000,0.0000,-0.0004,0.0000,0.0000},
	{1,0,2,2,0,0.0081,0.0000,-0.0001,-0.0004,0.0000,0.0000},
	{2,0,2,1,2,0.0047,0.0000,0.0000,-0.0019,0.0000,0.0000},
	{3,1,2,0,2,0.0053,0.0000,0.0000,-0.0023,0.0000,0.0000},
	{4,0,2,0,1,-0.0045,0.0000,0.0000,0.0022,0.0000,0.0000},
	{-2,-1,2,0,0,-0.0044,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{0,1,-2,2,1,-0.0033,0.0000,0.0000,0.0016,0.0000,0.0000},
	{1,0,-2,1,0,-0.0061,0.0000,0.0000,0.0001,0.0000,0.0000},
	{0,-1,-2,2,1,0.0028,0.0000,0.0000,-0.0015,0.0000,0.0000},
	{2,-1,0,-2,1,-0.0038,0.0000,0.0000,0.0019,0.0000,0.0000},
	{-1,0,2,-1,2,-0.0033,0.0000,0.0000,0.0021,0.0000,0.0000},
	{1,0,2,-3,2,-0.0060,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,1,2,-2,3,0.0048,0.0000,0.0000,-0.0010,0.0000,0.0000},
	{0,0,2,-3,1,0.0027,0.0000,0.0000,-0.0014,0.0000,0.0000},
	{-1,0,-2,2,1,0.0038,0.0000,0.0000,-0.0020,0.0000,0.0000},
	{0,0,2,-4,2,0.0031,0.0000,0.0000,-0.0013,0.0000,0.0000},
	{-2,1,0,0,1,-0.0029,0.0000,0.0000,0.0015,0.0000,0.0000},
	{-1,0,0,-1,1,0.0028,0.0000,0.0000,-0.0015,0.0000,0.0000},
	{2,0,2,-4,2,-0.0032,0.0000,0.0000,0.0015,0.0000,0.0000},
	{0,0,4,-4,4,0.0045,0.0000,0.0000,-0.0008,0.0000,0.0000},
	{0,0,4,-4,2,-0.0044,0.0000,0.0000,0.0019,0.0000,0.0000},
	{-1,-2,0,2,1,0.0028,0.0000,0.0000,-0.0015,0.0000,0.0000},
	{-2,0,0,3,0,-0.0051,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,0,-2,2,1,-0.0036,0.0000,0.0000,0.0020,0.0000,0.0000},
	{-3,0,2,2,2,0.0044,0.0000,0.0000,-0.0019,0.0000,0.0000},
	{-3,0,2,2,1,0.0026,0.0000,0.0000,-0.0014,0.0000,0.0000},
	{-2,0,2,2,0,-0.0060,0.0000,0.0000,0.0002,0.0000,0.0000},
	{2,-1,0,0,1,0.0035,0.0000,0.0000,-0.0018,0.0000,0.0000},
	{-2,1,2,2,2,-0.0027,0.0000,0.0000,0.0011,0.0000,0.0000},
	{1,1,0,1,0,0.0047,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{0,1,4,-2,2,0.0036,0.0000,0.0000,-0.0015,0.0000,0.0000},
	{-1,1,0,-2,1,-0.0036,0.0000,0.0000,0.0020,0.0000,0.0000},
	{0,0,0,-4,1,-0.0035,0.0000,0.0000,0.0019,0.0000,0.0000},
	{1,-1,0,2,1,-0.0037,0.0000,0.0000,0.0019,0.0000,0.0000},
	{1,1,0,2,1,0.0032,0.0000,0.0000,-0.0016,0.0000,0.0000},
	{-1,2,2,2,2,0.0035,0.0000,0.0000,-0.0014,0.0000,0.0000},
	{3,1,2,-2,2,0.0032,0.0000,0.0000,-0.0013,0.0000,0.0000},
	{0,-1,0,4,0,0.0065,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{2,-1,0,2,0,0.0047,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{0,0,4,0,1,0.0032,0.0000,0.0000,-0.0016,0.0000,0.0000},
	{2,0,4,-2,2,0.0037,0.0000,0.0000,-0.0016,0.0000,0.0000},
	{-1,-1,2,4,1,-0.0030,0.0000,0.0000,0.0015,0.0000,0.0000},
	{1,0,0,4,1,-0.0032,0.0000,0.0000,0.0016,0.0000,0.0000},
	{1,-2,2,2,2,-0.0031,0.0000,0.0000,0.0013,0.0000,0.0000},
	{0,0,2,3,2,0.0037,0.0000,0.0000,-0.0016,0.0000,0.0000},
	{-1,1,2,4,2,0.0031,0.0000,0.0000,-0.0013,0.0000,0.0000},
	{3,0,0,2,0,0.0049,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-1,0,4,2,2,0.0032,0.0000,0.0000,-0.0013,0.0000,0.0000},
	{1,1,2,2,1,0.0023,0.0000,0.0000,-0.0012,0.0000,0.0000},
	{-2,0,2,6,2,-0.0043,0.0000,0.0000,0.0018,0.0000,0.0000},
	{2,1,2,2,2,0.0026,0.0000,0.0000,-0.0011,0.0000,0.0000},
	{-1,0,2,6,2,-0.0032,0.0000,0.0000,0.0014,0.0000,0.0000},
	{1,0,2,4,1,-0.0029,0.0000,0.0000,0.0014,0.0000,0.0000},
	{2,0,2,4,2,-0.0027,0.0000,0.0000,0.0012,0.0000,0.0000},
	{1,1,-2,1,0,0.0030,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-3,1,2,1,2,-0.0011,0.0000,0.0000,0.0005,0.0000,0.0000},
	{2,0,-2,0,2,-0.0021,0.0000,0.0000,0.0010,0.0000,0.0000},
	{-1,0,0,1,2,-0.0034,0.0000,0.0000,0.0015,0.0000,0.0000},
	{-4,0,2,2,1,-0.0010,0.0000,0.0000,0.0006,0.0000,0.0000},
	{-1,-1,0,1,0,-0.0036,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,0,-2,2,2,-0.0009,0.0000,0.0000,0.0004,0.0000,0.0000},
	{1,0,0,-1,2,-0.0012,0.0000,0.0000,0.0005,0.0000,0.0000},
	{0,-1,2,-2,3,-0.0021,0.0000,0.0000,0.0005,0.0000,0.0000},
	{-2,1,2,0,0,-0.0029,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{0,0,2,-2,4,-0.0015,0.0000,0.0000,0.0003,0.0000,0.0000},
	{-2,-2,0,2,0,-0.0020,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-2,0,-2,4,0,0.0028,0.0000,0.0000,0.0000,0.0000,-0.0002},
	{0,-2,-2,2,0,0.0017,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,2,0,-2,1,-0.0022,0.0000,0.0000,0.0012,0.0000,0.0000},
	{3,0,0,-4,1,-0.0014,0.0000,0.0000,0.0007,0.0000,0.0000},
	{-1,1,2,-2,2,0.0024,0.0000,0.0000,-0.0011,0.0000,0.0000},
	{1,-1,2,-4,1,0.0011,0.0000,0.0000,-0.0006,0.0000,0.0000},
	{1,1,0,-2,2,0.0014,0.0000,0.0000,-0.0006,0.0000,0.0000},
	{-3,0,2,0,0,0.0024,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-3,0,2,0,2,0.0018,0.0000,0.0000,-0.0008,0.0000,0.0000},
	{-2,0,0,1,0,-0.0038,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,0,-2,1,0,-0.0031,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-3,0,0,2,1,-0.0016,0.0000,0.0000,0.0008,0.0000,0.0000},
	{-1,-1,-2,2,0,0.0029,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,1,2,-4,1,-0.0018,0.0000,0.0000,0.0010,0.0000,0.0000},
	{2,1,0,-4,1,-0.0010,0.0000,0.0000,0.0005,0.0000,0.0000},
	{0,2,0,-2,1,-0.0017,0.0000,0.0000,0.0010,0.0000,0.0000},
	{1,0,0,-3,1,0.0009,0.0000,0.0000,-0.0004,0.0000,0.0000},
	{-2,0,2,-2,2,0.0016,0.0000,0.0000,-0.0006,0.0000,0.0000},
	{-2,-1,0,0,1,0.0022,0.0000,0.0000,-0.0012,0.0000,0.0000},
	{-4,0,0,2,0,0.0020,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,1,0,-4,1,-0.0013,0.0000,0.0000,0.0006,0.0000,0.0000},
	{-1,0,2,-4,1,-0.0017,0.0000,0.0000,0.0009,0.0000,0.0000},
	{0,0,4,-4,1,-0.0014,0.0000,0.0000,0.0008,0.0000,0.0000},
	{0,3,2,-2,2,0.0000,0.0000,0.0000,-0.0007,0.0000,0.0000},
	{-3,-1,0,4,0,0.0014,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-3,0,0,4,1,0.0019,0.0000,0.0000,-0.0010,0.0000,0.0000},
	{1,-1,-2,2,0,-0.0034,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,-1,0,2,2,-0.0020,0.0000,0.0000,0.0008,0.0000,0.0000},
	{1,-2,0,0,1,0.0009,0.0000,0.0000,-0.0005,0.0000,0.0000},
	{1,-1,0,0,2,-0.0018,0.0000,0.0000,0.0007,0.0000,0.0000},
	{0,0,0,1,2,0.0013,0.0000,0.0000,-0.0006,0.0000,0.0000},
	{-1,-1,2,0,0,0.0017,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,-2,2,-2,2,-0.0012,0.0000,0.0000,0.0005,0.0000,0.0000},
	{0,-1,2,-1,1,0.0015,0.0000,0.0000,-0.0008,0.0000,0.0000},
	{-1,0,2,0,3,-0.0011,0.0000,0.0000,0.0003,0.0000,0.0000},
	{1,1,0,0,2,0.0013,0.0000,0.0000,-0.0005,0.0000,0.0000},
	{-1,1,2,0,0,-0.0018,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,2,0,0,0,-0.0035,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,2,2,0,2,0.0009,0.0000,0.0000,-0.0004,0.0000,0.0000},
	{-1,0,4,-2,1,-0.0019,0.0000,0.0000,0.0010,0.0000,0.0000},
	{3,0,2,-4,2,-0.0026,0.0000,0.0000,0.0011,0.0000,0.0000},
	{1,2,2,-2,1,0.0008,0.0000,0.0000,-0.0004,0.0000,0.0000},
	{1,0,4,-4,2,-0.0010,0.0000,0.0000,0.0004,0.0000,0.0000},
	{-2,-1,0,4,1,0.0010,0.0000,0.0000,-0.0006,0.0000,0.0000},
	{0,-1,0,2,2,-0.0021,0.0000,0.0000,0.0009,0.0000,0.0000},
	{-2,1,0,4,0,-0.0015,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-2,-1,2,2,1,0.0009,0.0000,0.0000,-0.0005,0.0000,0.0000},
	{2,0,-2,2,0,-0.0029,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,0,0,1,1,-0.0019,0.0000,0.0000,0.0010,0.0000,0.0000},
	{0,1,0,2,2,0.0012,0.0000,0.0000,-0.0005,0.0000,0.0000},
	{1,-1,2,-1,2,0.0022,0.0000,0.0000,-0.0009,0.0000,0.0000},
	{-2,0,4,0,1,-0.0010,0.0000,0.0000,0.0005,0.0000,0.0000},
	{2,1,0,0,1,-0.0020,0.0000,0.0000,0.0011,0.0000,0.0000},
	{0,1,2,0,0,-0.0020,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,-1,4,-2,2,-0.0017,0.0000,0.0000,0.0007,0.0000,0.0000},
	{0,0,4,-2,4,0.0015,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{0,2,2,0,1,0.0008,0.0000,0.0000,-0.0004,0.0000,0.0000},
	{-3,0,0,6,0,0.0014,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,-1,0,4,1,-0.0012,0.0000,0.0000,0.0006,0.0000,0.0000},
	{1,-2,0,2,0,0.0025,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,0,0,4,2,-0.0013,0.0000,0.0000,0.0006,0.0000,0.0000},
	{-1,-2,2,2,1,-0.0014,0.0000,0.0000,0.0008,0.0000,0.0000},
	{-1,0,0,-2,2,0.0013,0.0000,0.0000,-0.0005,0.0000,0.0000},
	{1,0,-2,-2,1,-0.0017,0.0000,0.0000,0.0009,0.0000,0.0000},
	{0,0,-2,-2,1,-0.0012,0.0000,0.0000,0.0006,0.0000,0.0000},
	{-2,0,-2,0,1,-0.0010,0.0000,0.0000,0.0005,0.0000,0.0000},
	{0,0,0,3,1,0.0010,0.0000,0.0000,-0.0006,0.0000,0.0000},
	{0,0,0,3,0,-0.0015,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,1,0,4,0,-0.0022,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,-1,2,2,0,0.0028,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{-2,0,2,3,2,0.0015,0.0000,0.0000,-0.0007,0.0000,0.0000},
	{1,0,0,2,2,0.0023,0.0000,0.0000,-0.0010,0.0000,0.0000},
	{0,-1,2,1,2,0.0012,0.0000,0.0000,-0.0005,0.0000,0.0000},
	{3,-1,0,0,0,0.0029,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{2,0,0,1,0,-0.0025,0.0000,0.0000,0.0001,0.0000,0.0000},
	{1,-1,2,0,0,0.0022,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,0,2,1,0,-0.0018,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,0,2,0,3,0.0015,0.0000,0.0000,0.0003,0.0000,0.0000},
	{3,1,0,0,0,-0.0023,0.0000,0.0000,0.0000,0.0000,0.0000},
	{3,-1,2,-2,2,0.0012,0.0000,0.0000,-0.0005,0.0000,0.0000},
	{2,0,2,-1,1,-0.0008,0.0000,0.0000,0.0004,0.0000,0.0000},
	{1,1,2,0,0,-0.0019,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,0,4,-1,2,-0.0010,0.0000,0.0000,0.0004,0.0000,0.0000},
	{1,2,2,0,2,0.0021,0.0000,0.0000,-0.0009,0.0000,0.0000},
	{-2,0,0,6,0,0.0023,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{0,-1,0,4,1,-0.0016,0.0000,0.0000,0.0008,0.0000,0.0000},
	{-2,-1,2,4,1,-0.0019,0.0000,0.0000,0.0009,0.0000,0.0000},
	{0,-2,2,2,1,-0.0022,0.0000,0.0000,0.0010,0.0000,0.0000},
	{0,-1,2,2,0,0.0027,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{-1,0,2,3,1,0.0016,0.0000,0.0000,-0.0008,0.0000,0.0000},
	{-2,1,2,4,2,0.0019,0.0000,0.0000,-0.0008,0.0000,0.0000},
	{2,0,0,2,2,0.0009,0.0000,0.0000,-0.0004,0.0000,0.0000},
	{2,-2,2,0,2,-0.0009,0.0000,0.0000,0.0004,0.0000,0.0000},
	{-1,1,2,3,2,-0.0009,0.0000,0.0000,0.0004,0.0000,0.0000},
	{3,0,2,-1,2,-0.0008,0.0000,0.0000,0.0004,0.0000,0.0000},
	{4,0,2,-2,1,0.0018,0.0000,0.0000,-0.0009,0.0000,0.0000},
	{-1,0,0,6,0,0.0016,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{-1,-2,2,4,2,-0.0010,0.0000,0.0000,0.0004,0.0000,0.0000},
	{-3,0,2,6,2,-0.0023,0.0000,0.0000,0.0009,0.0000,0.0000},
	{-1,0,2,4,0,0.0016,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{3,0,0,2,1,-0.0012,0.0000,0.0000,0.0006,0.0000,0.0000},
	{3,-1,2,0,1,-0.0008,0.0000,0.0000,0.0004,0.0000,0.0000},
	{3,0,2,0,0,0.0030,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{1,0,4,0,2,0.0024,0.0000,0.0000,-0.0010,0.0000,0.0000},
	{5,0,2,-2,2,0.0010,0.0000,0.0000,-0.0004,0.0000,0.0000},
	{0,-1,2,4,1,-0.0016,0.0000,0.0000,0.0007,0.0000,0.0000},
	{2,-1,2,2,1,-0.0016,0.0000,0.0000,0.0007,0.0000,0.0000},
	{0,1,2,4,2,0.0017,0.0000,0.0000,-0.0007,0.0000,0.0000},
	{1,-1,2,4,2,-0.0024,0.0000,0.0000,0.0010,0.0000,0.0000},
	{3,-1,2,2,2,-0.0012,0.0000,0.0000,0.0005,0.0000,0.0000},
	{3,0,2,2,1,-0.0024,0.0000,0.0000,0.0011,0.0000,0.0000},
	{5,0,2,0,2,-0.0023,0.0000,0.0000,0.0009,0.0000,0.0000},
	{0,0,2,6,2,-0.0013,0.0000,0.0000,0.0005,0.0000,0.0000},
	{4,0,2,2,2,-0.0015,0.0000,0.0000,0.0007,0.0000,0.0000},
	{0,-1,1,-1,1,0.0000,0.0000,-0.1988,0.0000,0.0000,-0.1679},
	{-1,0,1,0,3,0.0000,0.0000,-0.0063,0.0000,0.0000,-0.0027},
	{0,-2,2,-2,3,-0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,0,-1,0,1,0.0000,0.0000,0.0005,0.0000,0.0000,0.0004},
	{2,-2,0,-2,1,0.0005,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{-1,0,1,0,2,0.0000,0.0000,0.0364,0.0000,0.0000,0.0176},
	{-1,0,1,0,1,0.0000,0.0000,-0.1044,0.0000,0.0000,-0.0891},
	{-1,-1,2,-1,2,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{-2,2,0,2,2,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-1,0,1,0,0,0.0000,0.0000,0.0330,0.0000,0.0000,0.0000},
	{-4,1,2,2,2,0.0005,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-3,0,2,1,1,0.0003,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-2,-1,2,0,2,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{1,0,-2,1,1,-0.0005,0.0000,0.0000,0.0002,0.0000,0.0000},
	{2,-1,-2,0,1,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{-4,0,2,2,0,0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-3,1,0,3,0,0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,0,-1,2,0,0.0000,0.0000,0.0005,0.0000,0.0000,0.0000},
	{0,-2,0,0,2,0.0000,0.0000,0.0000,0.0001,0.0000,0.0000},
	{0,-2,0,0,2,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-3,0,0,3,0,0.0006,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-2,-1,0,2,2,0.0005,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-1,0,-2,3,0,-0.0007,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-4,0,0,4,0,-0.0012,0.0000,0.0000,0.0000,0.0000,0.0000},
	{2,1,-2,0,1,0.0005,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{2,-1,0,-2,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{0,0,1,-1,0,-0.0005,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,2,0,1,0,0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-2,1,2,0,2,-0.0007,0.0000,0.0000,0.0003,0.0000,0.0000},
	{1,1,0,-1,1,0.0007,0.0000,0.0000,-0.0004,0.0000,0.0000},
	{1,0,1,-2,1,0.0000,0.0000,-0.0012,0.0000,0.0000,-0.0010},
	{0,2,0,0,2,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{1,-1,2,-3,1,0.0003,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-1,1,2,-1,1,-0.0003,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-2,0,4,-2,2,-0.0007,0.0000,0.0000,0.0003,0.0000,0.0000},
	{-2,0,4,-2,1,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-2,-2,0,2,1,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{-2,0,-2,4,0,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,2,2,-4,1,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{1,1,2,-4,2,0.0007,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{-1,2,2,-2,1,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{2,0,0,-3,1,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-1,2,0,0,1,-0.0005,0.0000,0.0000,0.0003,0.0000,0.0000},
	{0,0,0,-2,0,0.0005,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,-1,2,-2,2,-0.0005,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-1,1,0,0,2,0.0005,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{0,0,0,-1,2,-0.0008,0.0000,0.0000,0.0003,0.0000,0.0000},
	{-2,1,0,1,0,0.0009,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,-2,0,-2,1,0.0006,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{1,0,-2,0,2,-0.0005,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-3,1,0,2,0,0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,1,-2,2,0,-0.0007,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,-1,0,0,2,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{-3,0,0,2,0,0.0005,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-3,-1,0,2,0,0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{2,0,2,-6,1,-0.0003,0.0000,0.0000,0.0002,0.0000,0.0000},
	{0,1,2,-4,2,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{2,0,0,-4,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{-2,1,2,-2,1,-0.0005,0.0000,0.0000,0.0002,0.0000,0.0000},
	{0,-1,2,-4,1,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{0,1,0,-2,2,0.0009,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{-1,0,0,-2,0,0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{2,0,-2,-2,1,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-4,0,2,0,1,-0.0003,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-1,-1,0,-1,1,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{0,0,-2,0,2,0.0009,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{-3,0,0,1,0,-0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,0,-2,1,0,-0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-2,0,-2,2,1,0.0003,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{0,0,-4,2,0,0.0008,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-2,-1,-2,2,0,0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,0,2,-6,1,-0.0003,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-1,0,2,-4,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{1,0,0,-4,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{2,1,2,-4,2,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{2,1,2,-4,1,0.0006,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{0,1,4,-4,4,0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,1,4,-4,2,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{-1,-1,-2,4,0,-0.0007,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,-3,0,2,0,0.0009,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,0,-2,4,1,-0.0003,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-2,-1,0,3,0,-0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,0,-2,3,0,-0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-2,0,0,3,1,-0.0005,0.0000,0.0000,0.0003,0.0000,0.0000},
	{0,-1,0,1,0,-0.0013,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-3,0,2,2,0,-0.0007,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,1,-2,2,0,0.0010,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,1,0,2,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{1,-2,2,-2,1,0.0010,0.0000,0.0013,0.0006,0.0000,-0.0005},
	{0,0,1,0,2,0.0000,0.0000,0.0030,0.0000,0.0000,0.0014},
	{0,0,1,0,1,0.0000,0.0000,-0.0162,0.0000,0.0000,-0.0138},
	{0,0,1,0,0,0.0000,0.0000,0.0075,0.0000,0.0000,0.0000},
	{-1,2,0,2,1,-0.0007,0.0000,0.0000,0.0004,0.0000,0.0000},
	{0,0,2,0,2,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-2,0,2,0,2,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{2,0,0,-1,1,0.0005,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{3,0,0,-2,1,0.0005,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{1,0,2,-2,3,-0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,2,0,0,1,-0.0003,0.0000,0.0000,0.0002,0.0000,0.0000},
	{2,0,2,-3,2,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-1,1,4,-2,2,-0.0005,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-2,-2,0,4,0,0.0006,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,-3,0,2,0,0.0009,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,0,-2,4,0,0.0005,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,-1,0,3,0,-0.0007,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-2,0,0,4,2,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{-1,0,0,3,1,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{2,-2,0,0,0,0.0007,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,-1,0,1,0,-0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,0,0,2,0,0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,-2,2,0,1,-0.0006,0.0000,-0.0003,0.0003,0.0000,0.0001},
	{-1,0,1,2,1,0.0000,0.0000,-0.0003,0.0000,0.0000,-0.0002},
	{-1,1,0,3,0,0.0011,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,-1,2,1,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{0,-1,2,0,0,0.0011,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-2,1,2,2,1,-0.0003,0.0000,0.0000,0.0002,0.0000,0.0000},
	{2,-2,2,-2,2,-0.0001,0.0000,0.0003,0.0003,0.0000,-0.0001},
	{1,1,0,1,1,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{1,0,1,0,1,0.0000,0.0000,-0.0013,0.0000,0.0000,-0.0011},
	{1,0,1,0,0,0.0003,0.0000,0.0006,0.0000,0.0000,0.0000},
	{0,2,0,2,0,-0.0007,0.0000,0.0000,0.0000,0.0000,0.0000},
	{2,-1,2,-2,1,0.0005,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{0,-1,4,-2,1,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{0,0,4,-2,3,0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,1,4,-2,1,0.0005,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{4,0,2,-4,2,-0.0007,0.0000,0.0000,0.0003,0.0000,0.0000},
	{2,2,2,-2,2,0.0008,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{2,0,4,-4,2,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-1,-2,0,4,0,0.0011,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,-3,2,2,2,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{-3,0,2,4,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{-3,0,2,-2,1,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-1,-1,0,-2,1,0.0008,0.0000,0.0000,-0.0004,0.0000,0.0000},
	{-3,0,0,0,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{-3,0,-2,2,0,0.0011,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,1,0,-4,1,-0.0006,0.0000,0.0000,0.0003,0.0000,0.0000},
	{-2,1,0,-2,1,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-4,0,0,0,1,-0.0008,0.0000,0.0000,0.0004,0.0000,0.0000},
	{-1,0,0,-4,1,-0.0007,0.0000,0.0000,0.0003,0.0000,0.0000},
	{-3,0,0,-2,1,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{0,0,0,3,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{-1,1,0,4,1,0.0006,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{1,-2,2,0,1,-0.0006,0.0000,0.0000,0.0003,0.0000,0.0000},
	{0,1,0,3,0,0.0006,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-1,0,2,2,3,0.0006,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{0,0,2,2,2,0.0005,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-2,0,2,2,2,-0.0005,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-1,1,2,2,0,-0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{3,0,0,0,2,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{2,1,0,1,0,0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{2,-1,2,-1,2,0.0006,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{0,0,2,0,1,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{0,0,3,0,3,0.0000,0.0000,-0.0026,0.0000,0.0000,-0.0011},
	{0,0,3,0,2,0.0000,0.0000,-0.0010,0.0000,0.0000,-0.0005},
	{-1,2,2,2,1,0.0005,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{-1,0,4,0,0,-0.0013,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,2,2,0,1,0.0003,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{3,1,2,-2,1,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{1,1,4,-2,2,0.0007,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{-2,-1,0,6,0,0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,-2,0,4,0,0.0005,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-2,0,0,6,1,-0.0003,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-2,-2,2,4,2,-0.0006,0.0000,0.0000,0.0002,0.0000,0.0000},
	{0,-3,2,2,2,-0.0005,0.0000,0.0000,0.0002,0.0000,0.0000},
	{0,0,0,4,2,-0.0007,0.0000,0.0000,0.0003,0.0000,0.0000},
	{-1,-1,2,3,2,0.0005,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-2,0,2,4,0,0.0013,0.0000,0.0000,0.0000,0.0000,0.0000},
	{2,-1,0,2,1,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{1,0,0,3,0,-0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,1,0,4,1,0.0005,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{0,1,0,4,0,-0.0011,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,-1,2,1,2,0.0005,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{0,0,2,2,3,0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,0,2,2,2,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-1,0,2,2,2,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-2,0,4,2,1,0.0006,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{2,1,0,2,1,0.0003,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{2,1,0,2,0,-0.0012,0.0000,0.0000,0.0000,0.0000,0.0000},
	{2,-1,2,0,0,0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,0,2,1,0,-0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,1,2,2,0,-0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{2,0,2,0,3,0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{3,0,2,0,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{1,0,2,0,2,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{1,0,3,0,3,0.0000,0.0000,-0.0005,0.0000,0.0000,-0.0002},
	{1,1,2,1,1,-0.0007,0.0000,0.0000,0.0004,0.0000,0.0000},
	{0,2,2,2,2,0.0006,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{2,1,2,0,0,-0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{2,0,4,-2,1,0.0005,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{4,1,2,-2,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{-1,-1,0,6,0,0.0003,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-3,-1,2,6,2,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{-1,0,0,6,1,-0.0005,0.0000,0.0000,0.0003,0.0000,0.0000},
	{-3,0,2,6,1,-0.0003,0.0000,0.0000,0.0002,0.0000,0.0000},
	{1,-1,0,4,1,-0.0003,0.0000,0.0000,0.0002,0.0000,0.0000},
	{1,-1,0,4,0,0.0012,0.0000,0.0000,0.0000,0.0000,0.0000},
	{-2,0,2,5,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{1,-2,2,2,1,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{3,-1,0,2,0,0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,-1,2,2,0,0.0006,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,0,2,3,1,0.0005,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{-1,1,2,4,1,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{0,1,2,3,2,-0.0006,0.0000,0.0000,0.0003,0.0000,0.0000},
	{-1,0,4,2,1,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{2,0,2,1,1,0.0006,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{5,0,0,0,0,0.0006,0.0000,0.0000,0.0000,0.0000,0.0000},
	{2,1,2,1,2,-0.0006,0.0000,0.0000,0.0003,0.0000,0.0000},
	{1,0,4,0,1,0.0003,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{3,1,2,0,1,0.0007,0.0000,0.0000,-0.0004,0.0000,0.0000},
	{3,0,4,-2,2,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-2,-1,2,6,2,-0.0005,0.0000,0.0000,0.0002,0.0000,0.0000},
	{0,0,0,6,0,0.0005,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,-2,2,4,2,-0.0006,0.0000,0.0000,0.0003,0.0000,0.0000},
	{-2,0,2,6,1,-0.0006,0.0000,0.0000,0.0003,0.0000,0.0000},
	{2,0,0,4,1,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{2,0,0,4,0,0.0010,0.0000,0.0000,0.0000,0.0000,0.0000},
	{2,-2,2,2,2,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{0,0,2,4,0,0.0007,0.0000,0.0000,0.0000,0.0000,0.0000},
	{1,0,2,3,2,0.0007,0.0000,0.0000,-0.0003,0.0000,0.0000},
	{4,0,0,2,0,0.0004,0.0000,0.0000,0.0000,0.0000,0.0000},
	{2,0,2,2,0,0.0011,0.0000,0.0000,0.0000,0.0000,0.0000},
	{0,0,4,2,2,0.0005,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{4,-1,2,0,2,-0.0006,0.0000,0.0000,0.0002,0.0000,0.0000},
	{3,0,2,1,2,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{2,1,2,2,1,0.0003,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{4,1,2,0,2,0.0005,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{-1,-1,2,6,2,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{-1,0,2,6,1,-0.0004,0.0000,0.0000,0.0002,0.0000,0.0000},
	{1,-1,2,4,1,-0.0003,0.0000,0.0000,0.0002,0.0000,0.0000},
	{1,1,2,4,2,0.0004,0.0000,0.0000,-0.0002,0.0000,0.0000},
	{3,1,2,2,2,0.0003,0.0000,0.0000,-0.0001,0.0000,0.0000},
	{5,0,2,0,1,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{2,-1,2,4,2,-0.0003,0.0000,0.0000,0.0001,0.0000,0.0000},
	{2,0,2,4,1,-0.0003,0.0000,0.0000,0.0002,0.0000,0.0000},
	{0,0,0,0,0,0,0,0,0,0,0}
};

struct iau2000a_term2 iau2000a_planetary[] = {
	{0,0,2,0,-2,0,0,0,0,0,0,2,2,2,0.0003,0.0000,0.0000,-0.0001},
	{0,1,-1,0,0,0,0,0,0,1,0,2,0,2,0.0003,0.0000,0.0000,-0.0001},
	{0,3,-3,0,0,0,0,0,0,-1,0,2,2,2,0.0007,0.0000,0.0000,-0.0003},
	{0,0,2,0,-2,0,0,0,0,-1,0,2,2,2,0.0013,0.0000,0.0000,-0.0006},
	{0,0,1,0,0,0,0,0,0,2,0,2,0,1,0.0004,0.0000,-0.0001,-0.0002},
	{0,0,1,0,0,0,0,0,0,0,0,2,0,2,-0.0024,-0.0012,-0.0005,0.0010},
	{0,0,1,0,0,0,0,0,0,1,0,1,1,1,0.0000,0.0003,0.0002,0.0000},
	{0,0,4,-8,3,0,0,0,0,1,0,2,0,2,0.0000,0.0003,0.0001,0.0000},
	{0,0,-4,8,-3,0,0,0,0,1,0,2,0,2,0.0000,0.0003,0.0001,0.0000},
	{0,0,2,0,-3,0,0,0,0,2,0,2,0,2,0.0024,-0.0012,-0.0005,-0.0011},
	{0,0,2,0,-3,0,0,0,0,-1,0,2,2,2,-0.0005,0.0000,0.0000,0.0002},
	{0,-1,1,0,0,0,0,0,0,1,0,2,0,2,-0.0003,0.0000,0.0000,0.0001},
	{0,0,-1,0,1,0,0,0,0,-1,0,2,2,2,0.0003,0.0000,0.0000,-0.0001},
	{0,2,-2,0,0,0,0,0,0,0,0,2,0,2,-0.0003,0.0000,0.0000,0.0001},
	{0,0,1,0,-1,0,0,0,0,0,0,2,0,2,-0.0006,0.0000,0.0000,0.0003},
	{0,1,-1,0,0,0,0,0,0,0,0,2,0,2,0.0008,0.0000,0.0000,-0.0004},
	{0,2,-3,0,0,0,0,0,0,0,0,2,0,2,0.0000,0.0003,0.0001,0.0000},
	{0,0,2,0,-2,0,0,0,0,-2,0,2,2,2,-0.0003,0.0000,0.0000,0.0001},
	{0,0,1,0,0,0,0,0,0,-1,0,2,0,1,-0.0021,-0.0011,-0.0006,0.0011},
	{0,0,1,0,0,0,0,0,0,0,0,1,1,0,0.0000,-0.0004,0.0000,0.0000},
	{0,0,-2,0,3,0,0,0,0,1,0,2,0,1,0.0021,-0.0011,-0.0006,-0.0011},
	{0,0,-2,0,3,0,0,0,0,2,0,2,-2,2,0.0003,0.0000,0.0000,-0.0001},
	{0,0,-4,8,-3,0,0,0,0,-1,0,2,0,2,-0.0126,-0.0063,-0.0027,0.0055},
	{0,0,-4,8,-3,0,0,0,0,0,0,2,0,2,0.0000,0.0009,0.0004,-0.0001},
	{0,0,4,-8,3,0,0,0,0,0,0,2,0,2,0.0000,0.0009,0.0004,0.0001},
	{0,0,1,0,0,0,0,0,0,1,0,2,0,2,0.0005,0.0000,0.0001,-0.0002},
	{0,0,1,0,0,0,0,0,0,0,0,1,1,1,-0.0003,0.0028,0.0015,0.0002},
	{0,10,-3,0,0,0,0,0,0,-1,0,2,0,2,-0.0005,0.0000,0.0001,0.0002},
	{0,0,1,0,0,0,0,0,0,1,0,2,0,2,0.0126,-0.0063,-0.0027,-0.0055},
	{0,0,1,0,0,0,0,0,0,0,0,1,1,2,0.0000,-0.0003,-0.0002,0.0000},
	{0,0,2,0,-2,0,0,0,0,0,0,0,2,0,-0.0003,0.0000,0.0000,0.0000},
	{0,-2,3,0,0,0,0,0,0,0,0,2,0,2,0.0000,0.0003,0.0001,0.0000},
	{0,-1,1,0,0,0,0,0,0,0,0,2,0,2,-0.0008,0.0000,0.0000,0.0003},
	{0,0,-1,0,1,0,0,0,0,0,0,2,0,2,0.0006,0.0000,0.0000,-0.0003},
	{0,-2,2,0,0,0,0,0,0,0,0,2,0,2,0.0003,0.0000,0.0000,-0.0001},
	{0,0,1,0,-1,0,0,0,0,0,0,0,-2,0,0.0004,0.0000,0.0000,0.0000},
	{0,2,-2,0,0,0,0,0,0,0,0,0,-2,0,0.0003,0.0000,0.0000,0.0000},
	{0,0,1,0,-1,0,0,0,0,1,0,0,0,0,0.0003,0.0000,0.0000,0.0000},
	{0,1,-1,0,0,0,0,0,0,1,0,0,0,0,-0.0004,0.0000,0.0000,0.0000},
	{0,0,-2,0,2,0,0,0,0,1,0,2,-2,2,-0.0006,0.0000,0.0000,0.0003},
	{0,-3,3,0,0,0,0,0,0,1,0,2,-2,2,-0.0003,0.0000,0.0000,0.0001},
	{0,0,-2,0,2,0,0,0,0,1,0,0,-2,1,0.0003,0.0000,0.0000,-0.0002},
	{0,3,-3,0,0,0,0,0,0,-1,0,0,2,0,-0.0019,0.0000,0.0000,0.0000},
	{0,0,2,0,-2,0,0,0,0,-1,0,0,2,0,-0.0034,0.0000,0.0000,0.0000},
	{0,0,2,0,-2,0,0,0,0,0,0,0,0,0,0.0020,0.0010,0.0000,0.0000},
	{0,0,2,0,-2,0,0,0,0,-1,0,0,2,1,-0.0003,0.0000,0.0000,0.0002},
	{0,0,4,-8,3,0,0,0,0,-1,0,0,0,0,0.0000,-0.0005,0.0000,0.0000},
	{0,0,-1,0,0,0,0,0,0,1,0,1,-1,1,0.0000,0.0005,0.0003,0.0000},
	{0,0,-1,0,0,0,0,0,0,-1,0,1,-1,1,0.0000,-0.0005,-0.0002,0.0000},
	{0,0,4,-8,3,0,0,0,0,1,0,0,0,0,0.0000,-0.0005,0.0000,0.0000},
	{0,0,2,0,-3,0,0,0,0,-2,0,0,0,0,0.0021,0.0011,0.0000,0.0000},
	{0,0,2,0,-3,0,0,0,0,-1,0,0,2,0,0.0013,0.0000,0.0000,0.0000},
	{0,0,1,0,0,0,0,0,0,1,0,-1,1,0,0.0000,0.0003,0.0000,0.0000},
	{0,2,-2,0,0,0,0,0,0,-1,0,0,2,0,0.0004,0.0000,0.0000,0.0000},
	{0,1,-1,0,0,0,0,0,0,-1,0,0,0,0,-0.0005,0.0000,0.0000,0.0000},
	{0,0,1,0,-1,0,0,0,0,-1,0,0,0,0,0.0004,0.0000,0.0000,0.0000},
	{0,0,2,0,-3,0,0,0,0,-1,0,0,0,0,-0.0003,0.0000,0.0000,0.0000},
	{0,0,4,-8,3,0,0,0,0,-2,0,0,2,0,0.0005,0.0000,0.0000,0.0000},
	{0,0,4,-8,3,0,0,0,0,1,0,0,-2,0,0.0000,-0.0004,0.0000,0.0000},
	{0,0,4,-8,3,0,0,0,0,-1,0,0,2,0,0.0000,-0.0004,0.0000,0.0000},
	{0,0,2,0,-2,0,0,0,0,-1,0,0,0,0,0.0006,0.0000,0.0000,0.0000},
	{0,3,-3,0,0,0,0,0,0,-1,0,0,0,0,0.0004,0.0000,0.0000,0.0000},
	{0,1,-1,0,0,0,0,0,0,1,0,0,-2,0,-0.0004,0.0000,0.0000,0.0000},
	{0,0,1,0,-1,0,0,0,0,1,0,0,-2,0,0.0007,0.0000,0.0000,0.0000},
	{0,2,-2,0,0,0,0,0,0,1,0,0,-2,0,0.0006,0.0000,0.0000,0.0000},
	{0,0,2,0,-2,0,0,0,0,1,0,0,-2,0,-0.0003,0.0000,0.0000,0.0000},
	{0,0,0,0,0,0,0,0,2,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0001},
	{0,0,6,0,0,0,0,0,2,0,0,0,0,0,0.0005,0.0000,0.0000,-0.0002},
	{0,0,6,0,0,0,0,0,1,0,0,0,0,0,0.0000,0.0003,0.0001,0.0000},
	{0,0,6,0,0,0,0,0,0,0,0,0,0,0,0.0006,0.0000,0.0000,0.0000},
	{0,0,6,0,0,0,0,0,2,0,0,0,0,0,0.0006,0.0000,0.0000,-0.0003},
	{0,0,6,0,0,0,0,0,1,0,0,0,0,0,0.0000,0.0004,0.0002,0.0000},
	{0,0,6,0,0,0,0,0,0,0,0,0,0,0,0.0008,0.0000,0.0000,0.0000},
	{0,0,6,0,0,0,0,0,0,0,0,0,0,0,0.0000,0.0000,0.0000,-0.0004},
	{0,0,6,0,0,0,0,0,2,0,0,0,0,0,0.0002,0.0009,0.0004,0.0003},
	{0,6,-4,0,0,0,0,0,1,0,0,0,0,0,0.0000,-0.0003,-0.0002,0.0000},
	{0,9,-9,0,0,0,0,0,0,0,0,0,0,0,0.0013,0.0000,0.0000,0.0000},
	{0,-9,9,0,0,0,0,0,1,0,0,0,0,0,0.0000,0.0005,0.0003,0.0000},
	{0,-9,9,0,0,0,0,0,1,0,0,0,0,0,0.0000,0.0000,0.0000,-0.0005},
	{0,-9,9,0,0,0,0,0,1,0,0,0,0,0,0.0000,0.0000,-0.0001,0.0000},
	{0,5,-3,0,0,0,0,0,2,0,0,0,0,0,0.0014,-0.0003,0.0000,-0.0001},
	{0,5,-3,0,0,0,0,0,1,0,0,0,0,0,0.0000,-0.0005,-0.0003,0.0000},
	{0,8,-8,0,0,0,0,0,0,0,0,0,0,0,0.0019,0.0000,0.0000,0.0000},
	{0,-8,8,0,0,0,0,0,1,0,0,0,0,0,0.0000,0.0007,0.0004,0.0000},
	{0,3,0,0,0,0,0,0,2,0,0,0,0,0,0.0017,-0.0003,-0.0001,0.0000},
	{0,0,5,0,-2,0,0,0,2,0,0,0,0,0,0.0003,0.0012,0.0005,-0.0001},
	{0,0,5,0,-3,0,0,0,2,0,0,0,0,0,-0.0009,0.0000,0.0001,0.0004},
	{0,0,5,0,-4,0,0,0,2,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0001},
	{0,4,-2,0,0,0,0,0,0,0,0,0,0,0,0.0000,0.0003,0.0000,0.0000},
	{0,4,-2,0,0,0,0,0,0,0,0,0,0,0,0.0000,0.0000,-0.0002,0.0000},
	{0,4,-2,0,0,0,0,0,2,0,0,0,0,0,0.0008,-0.0004,0.0000,-0.0004},
	{0,4,-2,0,0,0,0,0,1,0,0,0,0,0,0.0000,-0.0007,-0.0004,0.0000},
	{0,7,-7,0,0,0,0,0,0,0,0,0,0,0,0.0028,0.0000,0.0000,0.0000},
	{0,-7,7,0,0,0,0,0,1,0,0,0,0,0,0.0000,0.0009,0.0005,-0.0001},
	{0,2,1,0,0,0,0,0,1,0,0,0,0,0,0.0000,0.0003,0.0002,0.0000},
	{0,2,1,0,0,0,0,0,1,0,0,0,0,0,0.0000,0.0000,0.0000,-0.0010},
	{0,2,1,0,0,0,0,0,2,0,0,0,0,0,0.0019,-0.0023,-0.0010,0.0002},
	{0,5,-4,0,0,0,0,0,2,0,0,0,0,0,0.0000,0.0003,0.0001,0.0000},
	{0,8,-9,0,0,0,0,0,0,0,0,0,0,0,0.0000,0.0004,0.0000,0.0000},
	{0,0,4,0,0,0,0,0,0,0,0,0,0,0,0.0003,-0.0004,0.0000,0.0000},
	{0,0,5,-2,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0008,-0.0004,0.0000},
	{0,0,4,0,0,-2,0,0,2,0,0,0,0,0,-0.0007,0.0000,0.0000,0.0003},
	{0,0,4,0,-1,0,0,0,2,0,0,0,0,0,-0.0003,-0.0032,-0.0014,0.0001},
	{0,3,-1,0,0,0,0,0,2,0,0,0,0,0,0.0031,-0.0006,0.0000,-0.0013},
	{0,3,-1,0,0,0,0,0,1,0,0,0,0,0,0.0000,-0.0010,-0.0006,-0.0001},
	{0,3,-1,0,0,0,0,0,0,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0000},
	{0,0,6,-4,0,0,0,0,2,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0001},
	{0,0,4,0,-2,0,0,0,2,0,0,0,0,0,-0.0184,-0.0003,-0.0001,0.0080},
	{0,6,-6,0,0,0,0,0,1,0,0,0,0,0,0.0000,-0.0003,-0.0002,0.0000},
	{0,6,-6,0,0,0,0,0,0,0,0,0,0,0,0.0040,0.0000,0.0000,0.0000},
	{0,-6,6,0,0,0,0,0,1,0,0,0,0,0,0.0003,0.0013,0.0007,-0.0002},
	{0,0,4,0,-3,0,0,0,2,0,0,0,0,0,-0.0037,-0.0007,-0.0003,0.0016},
	{0,0,4,0,-4,0,0,0,2,0,0,0,0,0,-0.0005,0.0000,0.0000,0.0002},
	{0,-9,11,0,0,0,0,0,1,0,0,0,0,0,0.0000,0.0005,0.0003,0.0000},
	{0,-9,11,0,0,0,0,0,2,0,0,0,0,0,0.0034,0.0000,0.0000,-0.0015},
	{0,1,2,0,0,0,0,0,2,0,0,0,0,0,0.0004,0.0017,0.0007,-0.0002},
	{0,4,-3,0,0,0,0,0,2,0,0,0,0,0,0.0000,0.0009,0.0004,0.0000},
	{0,0,5,-3,0,0,0,0,2,0,0,0,0,0,-0.0010,0.0000,0.0000,0.0004},
	{0,7,-8,0,0,0,0,0,0,0,0,0,0,0,0.0000,0.0006,0.0000,0.0000},
	{0,0,6,-5,0,0,0,0,2,0,0,0,0,0,-0.0006,0.0003,0.0001,0.0003},
	{0,0,7,-7,0,0,0,0,2,0,0,0,0,0,0.0000,0.0003,0.0001,0.0000},
	{0,0,7,-7,0,0,0,0,2,0,0,0,0,0,0.0000,0.0000,-0.0003,0.0000},
	{0,2,0,0,0,0,0,0,2,0,0,0,0,0,0.0370,-0.0008,0.0000,-0.0160},
	{0,2,0,0,0,0,0,0,1,0,0,0,0,0,0.0004,-0.0015,-0.0008,-0.0002},
	{0,2,0,0,0,0,0,0,0,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0000},
	{0,5,-5,0,0,0,0,0,2,0,0,0,0,0,-0.0008,0.0000,0.0000,0.0004},
	{0,5,-5,0,0,0,0,0,1,0,0,0,0,0,0.0000,-0.0004,-0.0002,0.0000},
	{0,5,-5,0,0,0,0,0,0,0,0,0,0,0,0.0059,0.0000,0.0000,0.0000},
	{0,-5,5,0,0,0,0,0,1,0,0,0,0,0,0.0004,0.0017,0.0009,-0.0002},
	{0,-3,8,0,0,0,0,0,2,0,0,0,0,0,0.0000,0.0004,0.0002,0.0000},
	{0,0,3,0,1,0,0,0,2,0,0,0,0,0,-0.0005,-0.0011,-0.0005,0.0002},
	{0,0,2,2,0,0,0,0,2,0,0,0,0,0,-0.0004,0.0004,0.0002,0.0002},
	{0,-8,10,0,0,0,0,0,2,0,0,0,0,0,0.0000,0.0003,0.0001,0.0000},
	{0,-8,10,0,0,0,0,0,1,0,0,0,0,0,0.0000,0.0007,0.0004,0.0000},
	{0,-8,10,0,0,0,0,0,2,0,0,0,0,0,0.0050,0.0000,0.0000,-0.0022},
	{0,0,-1,8,-3,0,0,0,2,0,0,0,0,0,-0.0022,0.0012,0.0005,0.0010},
	{0,0,3,0,0,0,0,0,2,0,0,0,0,0,0.0000,0.0004,0.0002,0.0000},
	{0,0,-5,16,-4,-5,0,0,2,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0001},
	{0,0,7,-8,3,0,0,0,2,0,0,0,0,0,-0.0025,0.0000,0.0000,0.0011},
	{0,0,3,0,2,-5,0,0,2,0,0,0,0,0,0.0005,0.0012,0.0005,-0.0002},
	{0,-8,16,0,0,0,0,0,2,0,0,0,0,0,-0.0006,0.0000,0.0000,0.0003},
	{0,0,1,0,-1,0,0,0,0,0,0,2,-2,1,-0.0004,0.0000,0.0000,0.0002},
	{0,0,3,0,0,-1,0,0,2,0,0,0,0,0,0.0029,0.0000,0.0000,-0.0013},
	{0,0,4,-2,0,0,0,0,2,0,0,0,0,0,0.0143,-0.0003,-0.0001,-0.0062},
	{0,0,3,0,0,-2,0,0,2,0,0,0,0,0,0.0000,-0.0007,-0.0003,0.0000},
	{0,0,3,0,-1,0,0,0,2,0,0,0,0,0,0.0517,0.0016,0.0007,-0.0224},
	{0,0,3,0,-1,0,0,0,2,0,0,0,0,0,0.0000,0.0000,0.0000,0.0023},
	{0,3,-2,0,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0114,-0.0050,0.0000},
	{0,3,-2,0,0,0,0,0,0,0,0,0,0,0,0.0000,0.0000,0.0000,0.0000},
	{0,0,5,-4,0,0,0,0,2,0,0,0,0,0,0.0030,-0.0018,-0.0008,-0.0013},
	{0,0,3,0,-2,0,0,0,2,0,0,0,0,0,0.0067,-0.0091,-0.0039,-0.0029},
	{0,0,3,0,-2,0,0,0,0,0,0,0,0,0,-0.0004,-0.0012,0.0000,0.0000},
	{0,0,6,-6,0,0,0,0,2,0,0,0,0,0,0.0006,-0.0009,-0.0004,-0.0002},
	{0,6,-7,0,0,0,0,0,0,0,0,0,0,0,0.0000,0.0009,0.0000,0.0000},
	{0,-6,7,0,0,0,0,0,1,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0001},
	{0,-2,6,0,0,0,0,0,2,0,0,0,0,0,-0.0008,0.0000,0.0000,0.0004},
	{0,0,3,0,-3,0,0,0,2,0,0,0,0,0,0.0009,-0.0011,-0.0005,-0.0004},
	{0,0,3,0,-3,0,0,0,0,0,0,0,0,0,0.0018,-0.0003,0.0000,0.0000},
	{0,0,7,-8,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0004,-0.0002,0.0000},
	{0,1,-1,0,0,0,0,0,0,0,0,2,-2,1,0.0003,0.0000,0.0000,-0.0001},
	{0,0,3,0,-4,0,0,0,0,0,0,0,0,0,0.0005,0.0000,0.0000,0.0000},
	{0,-9,12,0,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0010,-0.0005,0.0000},
	{0,1,1,0,0,0,0,0,2,0,0,0,0,0,-0.0339,0.0000,0.0000,0.0147},
	{0,1,1,0,0,0,0,0,1,0,0,0,0,0,0.0005,-0.0023,-0.0012,-0.0003},
	{0,1,1,0,0,0,0,0,0,0,0,0,0,0,-0.0004,0.0000,0.0000,0.0000},
	{0,0,-3,0,5,0,0,0,2,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0001},
	{0,0,2,1,0,0,0,0,2,0,0,0,0,0,0.0003,0.0000,0.0001,-0.0001},
	{0,4,-4,0,0,0,0,0,2,0,0,0,0,0,0.0011,-0.0003,-0.0001,-0.0005},
	{0,4,-4,0,0,0,0,0,1,0,0,0,0,0,0.0000,-0.0010,-0.0005,0.0000},
	{0,4,-4,0,0,0,0,0,0,0,0,0,0,0,0.0083,0.0000,0.0000,0.0000},
	{0,-4,4,0,0,0,0,0,1,0,0,0,0,0,0.0006,0.0024,0.0013,-0.0003},
	{0,0,3,-1,0,0,0,0,2,0,0,0,0,0,0.0019,0.0000,0.0000,-0.0008},
	{0,0,4,-3,0,0,0,0,2,0,0,0,0,0,0.0026,-0.0014,-0.0006,-0.0011},
	{0,-7,9,0,0,0,0,0,1,0,0,0,0,0,-0.0003,0.0012,0.0006,0.0002},
	{0,-7,9,0,0,0,0,0,2,0,0,0,0,0,0.0074,0.0000,0.0000,-0.0032},
	{0,-1,4,0,0,0,0,0,2,0,0,0,0,0,0.0003,-0.0004,-0.0002,-0.0001},
	{0,-1,4,0,0,0,0,0,1,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0002},
	{0,0,5,-5,0,0,0,0,2,0,0,0,0,0,0.0007,-0.0012,-0.0005,-0.0003},
	{0,0,6,-7,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0007,-0.0003,0.0000},
	{0,2,-1,0,0,0,0,0,2,0,0,0,0,0,0.0005,-0.0173,-0.0075,-0.0002},
	{0,2,-1,0,0,0,0,0,0,0,0,0,0,0,0.0006,0.0019,0.0000,0.0000},
	{0,0,7,-9,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0004,-0.0002,0.0000},
	{0,0,-1,6,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0007,-0.0003,0.0000},
	{0,0,2,0,2,0,0,0,2,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0001},
	{0,5,-6,0,0,0,0,0,2,0,0,0,0,0,0.0003,0.0010,0.0004,-0.0001},
	{0,5,-6,0,0,0,0,0,0,0,0,0,0,0,0.0000,0.0008,0.0000,0.0000},
	{0,-5,6,0,0,0,0,0,1,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0002},
	{0,-5,6,0,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0003,-0.0001,0.0000},
	{0,0,0,4,0,0,0,0,2,0,0,0,0,0,-0.0021,-0.0032,-0.0014,0.0009},
	{0,-3,7,0,0,0,0,0,2,0,0,0,0,0,-0.0063,-0.0016,-0.0007,0.0028},
	{0,0,2,0,1,0,0,0,2,0,0,0,0,0,0.0163,-0.0012,-0.0005,-0.0072},
	{0,0,1,2,0,0,0,0,2,0,0,0,0,0,-0.0085,-0.0070,-0.0031,0.0037},
	{0,0,-4,8,-3,0,0,0,0,0,0,2,-2,1,0.0000,0.0004,0.0002,0.0000},
	{0,0,1,0,0,0,0,0,0,0,0,1,-1,0,0.0000,0.0003,0.0000,0.0000},
	{0,0,4,-8,3,0,0,0,0,0,0,2,-2,1,0.0000,0.0004,0.0002,0.0000},
	{0,3,-3,0,2,0,0,0,2,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0001},
	{0,0,2,0,0,1,0,0,2,0,0,0,0,0,0.0000,-0.0019,-0.0008,0.0000},
	{0,0,11,0,0,0,0,0,2,0,0,0,0,0,-0.0011,0.0005,0.0002,0.0005},
	{0,-8,11,0,0,0,0,0,2,0,0,0,0,0,-0.0062,-0.0097,-0.0042,0.0027},
	{0,-8,11,0,0,0,0,0,1,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0001},
	{0,-8,11,0,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0015,-0.0007,0.0000},
	{0,3,-5,4,0,0,0,0,2,0,0,0,0,0,-0.0013,0.0009,0.0004,0.0006},
	{0,0,2,0,-2,5,0,0,2,0,0,0,0,0,0.0012,-0.0006,-0.0003,-0.0005},
	{0,0,6,-8,1,5,0,0,2,0,0,0,0,0,0.0000,-0.0003,-0.0001,0.0000},
	{0,0,-2,8,-3,0,0,0,2,0,0,0,0,0,-0.0123,-0.0416,-0.0180,0.0053},
	{0,0,-2,8,-3,0,0,0,2,0,0,0,0,0,0.0000,0.0000,-0.0019,0.0006},
	{0,0,-6,16,-4,-5,0,0,2,0,0,0,0,0,0.0000,-0.0086,-0.0019,-0.0006},
	{0,0,2,0,0,0,0,0,2,0,0,0,0,0,-0.0089,0.0000,0.0000,0.0038},
	{0,0,2,0,0,0,0,0,1,0,0,0,0,0,0.0000,-0.0004,0.0002,0.0000},
	{0,0,1,0,0,0,0,0,0,0,0,1,-1,1,0.0000,-0.0009,-0.0005,0.0000},
	{0,0,2,0,0,0,0,0,1,0,0,0,0,0,0.0007,-0.0032,-0.0017,-0.0004},
	{0,0,2,0,0,0,0,0,0,0,0,0,0,0,-0.0005,0.0000,0.0000,0.0000},
	{0,0,2,0,0,0,0,0,0,0,0,0,0,0,0.0000,0.0000,0.0000,-0.0035},
	{0,0,6,-8,3,0,0,0,2,0,0,0,0,0,0.0123,-0.0415,-0.0180,-0.0053},
	{0,0,-2,8,-1,-5,0,0,2,0,0,0,0,0,0.0000,-0.0003,-0.0001,0.0000},
	{0,0,2,0,2,-5,0,0,2,0,0,0,0,0,-0.0011,-0.0006,-0.0003,0.0005},
	{0,-3,9,-4,0,0,0,0,2,0,0,0,0,0,0.0014,0.0009,0.0004,-0.0006},
	{0,-8,15,0,0,0,0,0,2,0,0,0,0,0,0.0061,-0.0096,-0.0042,-0.0027},
	{0,0,-6,15,0,0,0,0,2,0,0,0,0,0,0.0011,0.0005,0.0002,-0.0005},
	{0,0,2,0,0,-1,0,0,2,0,0,0,0,0,0.0000,-0.0020,-0.0009,0.0000},
	{0,0,3,-2,0,0,0,0,2,0,0,0,0,0,0.0080,-0.0071,-0.0031,-0.0035},
	{0,0,3,-2,0,0,0,0,0,0,0,0,0,0,0.0000,0.0009,0.0000,0.0000},
	{0,0,2,0,0,-2,0,0,1,0,0,0,0,0,0.0000,0.0004,0.0002,0.0000},
	{0,0,2,0,0,-2,0,0,0,0,0,0,0,0,0.0015,0.0000,0.0000,0.0000},
	{0,0,2,0,-1,0,0,0,2,0,0,0,0,0,-0.0154,-0.0030,-0.0013,0.0067},
	{0,0,2,0,-1,0,0,0,0,0,0,0,0,0,0.0000,0.0035,0.0000,0.0000},
	{0,0,-5,13,0,0,0,0,2,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0001},
	{0,0,2,0,0,-3,0,0,0,0,0,0,0,0,0.0000,0.0003,0.0000,0.0000},
	{0,3,-3,0,0,0,0,0,2,0,0,0,0,0,0.0054,-0.0015,-0.0007,-0.0024},
	{0,3,-3,0,0,0,0,0,1,0,0,0,0,0,0.0003,0.0012,0.0006,-0.0001},
	{0,3,-3,0,0,0,0,0,0,0,0,0,0,0,0.0089,0.0000,0.0000,0.0000},
	{0,-3,3,0,0,0,0,0,1,0,0,0,0,0,0.0008,0.0034,0.0018,-0.0004},
	{0,0,4,-4,0,0,0,0,2,0,0,0,0,0,0.0018,-0.0029,-0.0013,-0.0008},
	{0,0,4,-4,0,0,0,0,0,0,0,0,0,0,0.0008,0.0000,0.0000,0.0000},
	{0,-5,10,0,0,0,0,0,2,0,0,0,0,0,-0.0003,0.0008,0.0004,0.0001},
	{0,0,2,0,-2,0,0,0,2,0,0,0,0,0,-0.0006,0.0000,-0.0001,0.0003},
	{0,0,2,0,-2,0,0,0,1,0,0,0,0,0,-0.0004,0.0021,0.0011,0.0002},
	{0,0,2,0,-2,0,0,0,0,0,0,0,0,0,0.0393,0.0003,0.0000,0.0000},
	{0,0,5,-6,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0006,-0.0002,0.0000},
	{0,0,5,-6,0,0,0,0,0,0,0,0,0,0,0.0003,0.0000,0.0000,0.0000},
	{0,0,-3,9,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0003,-0.0001,0.0000},
	{0,0,2,0,-2,0,0,0,0,0,0,0,0,1,-0.0003,0.0000,0.0000,0.0002},
	{0,6,-8,0,0,0,0,0,0,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0000},
	{0,-6,8,0,0,0,0,0,1,0,0,0,0,0,-0.0005,0.0019,0.0010,0.0002},
	{0,-6,8,0,0,0,0,0,2,0,0,0,0,0,0.0117,0.0000,0.0000,-0.0051},
	{0,-2,5,0,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0114,-0.0049,0.0000},
	{0,-2,5,0,0,0,0,0,1,0,0,0,0,0,-0.0004,0.0000,0.0000,0.0002},
	{0,0,2,0,-3,0,0,0,0,0,0,0,0,0,0.0083,0.0015,0.0000,0.0000},
	{0,0,-2,7,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0006,-0.0002,0.0000},
	{0,0,2,0,-4,0,0,0,0,0,0,0,0,0,0.0011,0.0004,0.0000,0.0000},
	{0,0,-2,0,4,0,0,0,2,0,0,0,0,0,0.0017,0.0000,0.0000,-0.0007},
	{0,0,-1,5,0,0,0,0,2,0,0,0,0,0,-0.0005,-0.0009,-0.0004,0.0002},
	{0,-9,13,0,0,0,0,0,2,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0001},
	{0,1,0,0,0,0,0,0,2,0,0,0,0,0,-0.0005,0.0006,0.0003,0.0002},
	{0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.0004,-0.0028,0.0000,0.0000},
	{0,0,0,3,0,0,0,0,2,0,0,0,0,0,-0.0018,-0.0010,-0.0004,0.0008},
	{0,0,-2,0,5,0,0,0,2,0,0,0,0,0,0.0005,0.0000,0.0000,-0.0002},
	{0,0,1,1,0,0,0,0,2,0,0,0,0,0,-0.0013,0.0000,0.0000,0.0006},
	{0,4,-5,0,0,0,0,0,0,0,0,0,0,0,0.0000,-0.0003,0.0000,0.0000},
	{0,-4,5,0,0,0,0,0,1,0,0,0,0,0,0.0005,0.0000,0.0000,-0.0002},
	{0,-4,5,0,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0004,-0.0002,0.0000},
	{0,-4,8,0,0,0,0,0,2,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0001},
	{0,0,3,-3,0,0,0,0,0,0,0,0,0,0,0.0027,0.0000,0.0000,0.0000},
	{0,-7,10,0,0,0,0,0,1,0,0,0,0,0,0.0004,0.0000,0.0000,-0.0002},
	{0,-7,10,0,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0024,-0.0010,0.0000},
	{0,-1,3,0,0,0,0,0,2,0,0,0,0,0,0.0113,0.0000,0.0000,-0.0049},
	{0,-1,2,0,0,0,0,0,0,0,0,1,-1,1,0.0000,0.0003,0.0001,0.0000},
	{0,-1,3,0,0,0,0,0,1,0,0,0,0,0,0.0008,-0.0031,-0.0016,-0.0004},
	{0,1,-3,0,0,0,0,0,0,0,0,0,0,0,0.0008,-0.0003,0.0000,0.0000},
	{0,0,4,-5,0,0,0,0,0,0,0,0,0,0,0.0016,-0.0006,0.0000,0.0000},
	{0,-2,2,0,0,0,0,0,0,0,0,0,0,1,0.0004,0.0000,0.0000,-0.0002},
	{0,0,5,-7,0,0,0,0,0,0,0,0,0,0,0.0005,-0.0007,0.0000,0.0000},
	{0,0,-5,7,0,0,0,0,2,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0001},
	{0,0,1,0,3,0,0,0,2,0,0,0,0,0,-0.0005,-0.0007,-0.0003,0.0002},
	{0,2,-2,0,0,0,0,0,1,0,0,0,0,0,-0.0003,-0.0013,-0.0007,0.0001},
	{0,2,-2,0,0,0,0,0,0,0,0,0,0,0,-0.0598,0.0000,0.0000,0.0000},
	{0,-2,1,0,0,0,0,0,0,0,0,1,-1,1,0.0000,0.0005,0.0003,0.0000},
	{0,-2,2,0,0,0,0,0,1,0,0,0,0,0,0.0012,0.0055,0.0029,-0.0006},
	{0,0,6,-9,0,0,0,0,0,0,0,0,0,0,0.0000,-0.0005,0.0000,0.0000},
	{0,0,-6,9,0,0,0,0,2,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0001},
	{0,2,-2,0,0,0,0,0,0,0,0,0,0,1,0.0006,0.0000,0.0000,-0.0003},
	{0,0,-2,6,0,0,0,0,2,0,0,0,0,0,-0.0003,-0.0005,-0.0002,0.0001},
	{0,0,1,0,2,0,0,0,2,0,0,0,0,0,-0.0035,-0.0048,-0.0021,0.0015},
	{-1,0,3,0,0,0,0,0,2,0,0,0,0,0,0.0001,0.0000,0.0000,0.0000},
	{0,0,-1,0,1,0,0,0,0,0,0,0,0,0,0.0000,-0.0003,0.0000,0.0000},
	{0,0,-1,0,1,0,0,0,0,0,0,2,-2,1,0.0005,0.0000,0.0000,-0.0003},
	{0,5,-7,0,0,0,0,0,0,0,0,0,0,0,0.0016,-0.0005,0.0000,0.0000},
	{0,-5,6,0,0,0,0,0,0,0,0,1,-1,1,0.0000,0.0004,0.0002,0.0000},
	{0,-5,7,0,0,0,0,0,1,0,0,0,0,0,-0.0008,0.0035,0.0019,0.0005},
	{0,-5,7,0,0,0,0,0,2,0,0,0,0,0,0.0202,0.0000,0.0000,-0.0087},
	{0,0,-1,4,0,0,0,0,2,0,0,0,0,0,-0.0019,-0.0008,-0.0004,0.0008},
	{0,-3,6,0,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0027,-0.0012,0.0000},
	{0,-3,6,0,0,0,0,0,1,0,0,0,0,0,-0.0007,0.0000,0.0000,0.0004},
	{0,3,-6,0,0,0,0,0,0,0,0,0,0,0,0.0000,-0.0004,0.0000,0.0000},
	{0,0,1,0,1,0,0,0,2,0,0,0,0,0,-0.0262,0.0000,0.0000,0.0114},
	{0,0,1,0,1,0,0,0,1,0,0,0,0,0,0.0000,0.0003,0.0002,0.0000},
	{0,0,1,0,1,0,0,0,0,0,0,0,0,0,0.0008,0.0011,0.0000,0.0000},
	{0,-5,5,0,0,0,0,0,0,0,0,2,-2,1,0.0004,0.0000,0.0000,-0.0002},
	{0,0,1,0,0,2,0,0,2,0,0,0,0,0,0.0000,-0.0003,-0.0001,0.0000},
	{0,0,0,2,0,0,0,0,2,0,0,0,0,0,-0.0074,0.0000,0.0000,0.0032},
	{0,0,0,2,0,0,0,0,0,0,0,0,0,0,0.0006,0.0000,0.0000,0.0000},
	{0,0,1,0,0,1,0,0,2,0,0,0,0,0,-0.0014,0.0000,0.0000,0.0006},
	{0,0,1,0,1,-2,0,0,0,0,0,0,0,0,-0.0001,0.0000,0.0000,0.0000},
	{0,-8,12,0,0,0,0,0,0,0,0,0,0,0,-0.0008,0.0000,0.0000,0.0000},
	{0,-8,12,0,0,0,0,0,2,0,0,0,0,0,-0.0006,0.0000,0.0000,0.0002},
	{0,0,1,0,-2,5,0,0,2,0,0,0,0,0,0.0000,0.0005,0.0002,0.0000},
	{0,0,-3,8,-3,0,0,0,2,0,0,0,0,0,-0.0004,0.0000,0.0000,0.0002},
	{0,0,3,-8,3,0,0,0,0,0,0,0,0,0,-0.0019,-0.0011,0.0000,0.0000},
	{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0.0008,-0.0027,0.0000,0.0000},
	{0,0,-1,0,0,0,0,0,1,0,0,0,0,0,-0.0004,0.0000,0.0000,0.0002},
	{0,0,5,-8,3,0,0,0,2,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0001},
	{0,0,5,-8,3,0,0,0,0,0,0,0,0,0,0.0021,0.0003,0.0000,0.0000},
	{0,0,1,0,2,-5,0,0,0,0,0,0,0,0,-0.0013,-0.0030,0.0000,0.0000},
	{0,-8,14,0,0,0,0,0,2,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0001},
	{0,0,-2,2,0,0,0,0,0,0,0,0,0,1,0.0003,0.0000,0.0000,-0.0002},
	{0,0,-1,0,1,0,0,0,0,0,0,0,0,1,0.0011,0.0000,0.0000,-0.0006},
	{0,0,1,0,0,-1,0,0,0,0,0,0,0,0,-0.0075,0.0000,0.0000,0.0000},
	{0,0,2,-2,0,0,0,0,0,0,0,0,0,0,-0.0368,0.0000,0.0000,0.0000},
	{0,0,1,0,0,-2,0,0,0,0,0,0,0,0,-0.0006,0.0020,0.0000,0.0000},
	{0,-3,4,0,0,0,0,0,0,0,0,0,0,1,0.0000,0.0003,0.0002,0.0000},
	{0,0,1,0,-3,5,0,0,0,0,0,0,0,0,0.0003,0.0000,0.0000,0.0000},
	{0,0,1,0,-1,0,0,0,1,0,0,0,0,0,0.0000,0.0007,0.0003,0.0000},
	{0,0,1,0,-1,0,0,0,0,0,0,0,0,0,-0.1223,-0.0026,0.0000,0.0000},
	{0,0,-1,0,1,0,0,0,1,0,0,0,0,0,0.0000,-0.0004,-0.0002,0.0000},
	{0,0,1,0,1,-5,0,0,0,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0000},
	{0,0,1,0,0,-3,0,0,0,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0000},
	{0,0,-1,0,2,0,0,0,0,0,0,0,0,1,0.0000,0.0003,0.0001,0.0000},
	{0,0,2,-2,0,0,0,0,0,0,0,0,0,1,0.0005,0.0000,0.0000,-0.0002},
	{0,3,-4,0,0,0,0,0,1,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0002},
	{0,3,-4,0,0,0,0,0,0,0,0,0,0,0,-0.0005,0.0328,0.0000,0.0000},
	{0,-3,4,0,0,0,0,0,1,0,0,0,0,0,0.0007,0.0000,0.0000,-0.0004},
	{0,-3,4,0,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0005,-0.0002,0.0000},
	{0,0,3,-4,0,0,0,0,0,0,0,0,0,0,-0.0078,0.0045,0.0000,0.0000},
	{0,-5,9,0,0,0,0,0,2,0,0,0,0,0,0.0010,0.0000,0.0000,-0.0004},
	{0,0,1,0,-1,0,0,0,0,0,0,0,0,1,0.0015,0.0000,0.0000,-0.0008},
	{0,0,1,0,-2,0,0,0,0,0,0,0,0,0,-0.0166,0.0269,0.0000,0.0000},
	{0,0,-1,0,2,0,0,0,2,0,0,0,0,0,-0.0005,0.0000,0.0000,0.0002},
	{0,3,-4,0,0,0,0,0,0,0,0,0,0,1,0.0000,-0.0004,-0.0002,0.0000},
	{0,0,4,-6,0,0,0,0,0,0,0,0,0,0,-0.0016,0.0023,0.0000,0.0000},
	{0,0,-4,6,0,0,0,0,2,0,0,0,0,0,0.0006,0.0000,0.0000,-0.0002},
	{0,-2,2,0,0,0,0,0,0,0,0,2,-2,1,0.0011,0.0000,0.0000,-0.0006},
	{0,0,1,0,-2,0,0,0,0,0,0,0,0,1,0.0000,-0.0004,-0.0002,-0.0001},
	{0,6,-9,0,0,0,0,0,0,0,0,0,0,0,0.0000,-0.0003,0.0000,0.0000},
	{0,-6,9,0,0,0,0,0,1,0,0,0,0,0,0.0009,0.0000,0.0000,-0.0005},
	{0,-6,9,0,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0045,-0.0020,0.0000},
	{0,-2,4,0,0,0,0,0,2,0,0,0,0,0,-0.0458,0.0000,0.0000,0.0198},
	{0,-2,3,0,0,0,0,0,0,0,0,1,-1,1,0.0000,0.0009,0.0005,0.0001},
	{0,-2,4,0,0,0,0,0,1,0,0,0,0,0,0.0014,-0.0059,-0.0031,-0.0008},
	{0,2,-4,0,0,0,0,0,0,0,0,0,0,0,0.0005,-0.0005,0.0000,0.0000},
	{0,0,1,0,-3,0,0,0,0,0,0,0,0,0,-0.0028,0.0036,0.0000,0.0000},
	{0,0,-1,0,3,0,0,0,1,0,0,0,0,0,0.0000,-0.0005,-0.0003,0.0000},
	{0,0,-1,0,3,0,0,0,2,0,0,0,0,0,0.0118,0.0000,0.0000,-0.0052},
	{0,0,5,-8,0,0,0,0,0,0,0,0,0,0,0.0000,0.0011,0.0000,0.0000},
	{0,0,-5,8,0,0,0,0,2,0,0,0,0,0,0.0005,0.0003,0.0001,-0.0002},
	{0,4,-4,0,0,0,0,0,0,-2,0,0,2,0,-0.0003,0.0000,0.0000,0.0000},
	{0,0,-3,7,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0003,-0.0001,0.0000},
	{0,0,-3,0,3,0,0,0,0,0,0,2,-2,1,0.0004,0.0000,0.0000,-0.0002},
	{0,0,-6,10,0,0,0,0,0,0,0,0,0,0,0.0000,0.0003,0.0000,0.0000},
	{0,0,-6,10,0,0,0,0,2,0,0,0,0,0,0.0000,0.0004,0.0002,-0.0001},
	{0,-1,1,0,0,0,0,0,0,0,0,0,0,1,-0.0019,0.0000,0.0000,0.0010},
	{0,0,1,0,-4,0,0,0,0,0,0,0,0,0,-0.0004,0.0004,0.0000,0.0000},
	{0,0,-1,0,4,0,0,0,2,0,0,0,0,0,0.0030,-0.0006,-0.0002,-0.0013},
	{0,0,-2,5,0,0,0,0,2,0,0,0,0,0,-0.0006,-0.0003,-0.0002,0.0003},
	{0,1,-2,0,0,0,0,0,0,0,0,1,-1,1,0.0000,0.0005,0.0003,0.0000},
	{0,1,-1,0,0,0,0,0,1,0,0,0,0,0,-0.0007,-0.0032,-0.0017,0.0004},
	{0,1,-1,0,0,0,0,0,0,0,0,0,0,0,0.1485,0.0000,0.0000,0.0000},
	{0,-1,0,0,0,0,0,0,0,0,0,1,-1,1,0.0005,0.0021,0.0011,-0.0003},
	{0,-1,1,0,0,0,0,0,1,0,0,0,0,0,0.0025,0.0106,0.0057,-0.0013},
	{0,-1,1,0,0,0,0,0,2,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0001},
	{0,0,-7,12,0,0,0,0,2,0,0,0,0,0,0.0000,0.0003,0.0001,0.0000},
	{0,0,-1,3,0,0,0,0,2,0,0,0,0,0,-0.0011,0.0000,0.0000,0.0005},
	{0,0,1,-3,0,0,0,0,0,0,0,0,0,0,0.0000,0.0003,0.0000,0.0000},
	{0,0,-1,0,5,0,0,0,2,0,0,0,0,0,0.0005,0.0000,0.0000,-0.0002},
	{0,1,-1,0,0,0,0,0,0,0,0,0,0,1,-0.0028,0.0000,0.0000,0.0015},
	{0,1,0,0,0,0,0,0,0,0,0,-1,1,0,0.0000,-0.0003,0.0000,0.0000},
	{0,0,0,1,0,0,0,0,0,0,0,0,0,0,0.0002,0.0001,0.0000,0.0000},
	{0,2,-2,0,0,0,0,0,0,-2,0,0,2,0,-0.0005,0.0000,0.0000,0.0000},
	{0,4,-6,0,0,0,0,0,0,0,0,0,0,0,-0.0046,0.0014,0.0000,0.0000},
	{0,-4,6,0,0,0,0,0,1,0,0,0,0,0,-0.0003,0.0013,0.0007,0.0002},
	{0,-4,5,0,0,0,0,0,0,0,0,1,-1,1,-0.0007,0.0028,0.0015,0.0004},
	{0,-4,6,0,0,0,0,0,1,0,0,0,0,0,-0.0022,0.0093,0.0049,0.0012},
	{0,-4,6,0,0,0,0,0,2,0,0,0,0,0,0.0490,0.0000,0.0000,-0.0213},
	{0,-4,7,0,0,0,0,0,2,0,0,0,0,0,0.0003,0.0066,0.0029,-0.0001},
	{0,-4,6,0,0,0,0,0,0,0,0,1,-1,1,0.0003,0.0000,0.0000,-0.0001},
	{0,-4,7,0,0,0,0,0,1,0,0,0,0,0,-0.0012,-0.0003,-0.0002,0.0006},
	{0,0,1,-1,0,0,0,0,0,0,0,0,0,0,-0.0025,0.0000,0.0000,0.0000},
	{0,4,-5,0,0,0,0,0,0,0,0,-1,1,0,0.0000,-0.0004,0.0000,0.0000},
	{0,-4,4,0,0,0,0,0,0,0,0,2,-2,1,0.0027,0.0000,0.0000,-0.0014},
	{0,0,2,-3,0,0,0,0,0,0,0,0,0,0,-0.0068,0.0039,0.0000,0.0000},
	{0,4,-4,0,0,0,0,0,0,0,0,-2,2,0,0.0004,0.0000,0.0000,0.0000},
	{0,-7,11,0,0,0,0,0,1,0,0,0,0,0,0.0000,-0.0003,-0.0002,0.0000},
	{0,-7,11,0,0,0,0,0,2,0,0,0,0,0,-0.0016,-0.0003,-0.0001,0.0007},
	{0,-1,2,0,0,0,0,0,2,0,0,0,0,0,-0.0003,-0.0006,-0.0002,0.0001},
	{0,-1,2,0,0,0,0,0,1,0,0,0,0,0,-0.0004,0.0000,0.0000,0.0002},
	{0,1,-2,0,0,0,0,0,0,0,0,0,0,0,0.0022,-0.0087,0.0000,0.0000},
	{0,1,-3,0,0,0,0,0,0,0,0,1,-1,1,-0.0004,0.0000,0.0000,0.0002},
	{0,1,-2,0,0,0,0,0,1,0,0,0,0,0,-0.0010,0.0000,0.0001,0.0005},
	{0,0,3,-5,0,0,0,0,0,0,0,0,0,0,-0.0020,0.0034,0.0000,0.0000},
	{0,0,-3,5,0,0,0,0,1,0,0,0,0,0,0.0000,-0.0003,-0.0002,-0.0001},
	{0,0,-3,5,0,0,0,0,2,0,0,0,0,0,0.0017,0.0000,0.0000,-0.0007},
	{0,0,0,0,4,0,0,0,2,0,0,0,0,0,-0.0009,0.0003,0.0001,0.0004},
	{0,-1,2,0,0,0,0,0,0,0,0,0,0,1,0.0000,0.0003,0.0001,0.0000},
	{0,0,-5,10,0,0,0,0,2,0,0,0,0,0,0.0000,-0.0005,-0.0002,0.0000},
	{0,0,-2,0,3,0,0,0,0,0,0,2,-2,1,0.0007,0.0000,0.0000,-0.0004},
	{0,-2,3,0,0,0,0,0,0,0,0,0,0,1,0.0000,0.0019,0.0010,0.0000},
	{0,0,4,-7,0,0,0,0,0,0,0,0,0,0,0.0000,0.0022,0.0000,0.0000},
	{0,0,-4,7,0,0,0,0,1,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0002},
	{0,0,-4,7,0,0,0,0,2,0,0,0,0,0,0.0016,0.0009,0.0004,-0.0007},
	{0,0,2,0,-2,0,0,0,0,0,0,-2,2,0,0.0005,0.0000,0.0000,0.0000},
	{0,0,-4,8,0,0,0,0,2,0,0,0,0,0,-0.0006,-0.0010,-0.0004,0.0003},
	{0,0,4,-8,0,0,0,0,0,0,0,0,0,0,0.0003,0.0005,0.0000,0.0000},
	{0,0,0,0,3,0,0,0,2,0,0,0,0,0,-0.0127,0.0021,0.0009,0.0055},
	{0,0,0,0,3,0,0,0,1,0,0,0,0,0,0.0000,0.0006,0.0003,-0.0001},
	{0,0,-1,0,3,0,0,0,0,0,0,1,-1,1,-0.0003,-0.0009,-0.0005,0.0002},
	{0,0,0,0,3,0,0,0,1,0,0,0,0,0,0.0006,0.0017,0.0009,-0.0003},
	{0,2,-3,0,0,0,0,0,1,0,0,0,0,0,0.0003,-0.0003,-0.0001,-0.0002},
	{0,2,-3,0,0,0,0,0,0,0,0,0,0,0,0.0008,0.0614,0.0000,0.0000},
	{0,-2,2,0,0,0,0,0,0,0,0,1,-1,1,0.0018,0.0000,0.0000,-0.0009},
	{0,-2,3,0,0,0,0,0,1,0,0,0,0,0,0.0030,-0.0003,-0.0002,-0.0016},
	{0,-2,3,0,0,0,0,0,2,0,0,0,0,0,0.0005,-0.0011,-0.0005,-0.0002},
	{0,-6,10,0,0,0,0,0,2,0,0,0,0,0,0.0024,0.0005,0.0002,-0.0011},
	{0,-6,10,0,0,0,0,0,1,0,0,0,0,0,0.0000,0.0005,0.0003,0.0001},
	{0,3,-3,0,0,0,0,0,0,0,0,-2,2,0,0.0013,0.0000,0.0000,0.0000},
	{0,0,1,0,0,0,0,0,0,-2,0,1,1,1,0.0000,-0.0005,-0.0003,0.0000},
	{0,0,-2,0,2,0,0,0,0,0,0,2,-2,1,0.0050,0.0000,0.0000,-0.0027},
	{0,0,1,0,-2,0,0,0,0,0,0,-1,1,0,-0.0003,0.0016,0.0000,0.0000},
	{0,0,5,-9,0,0,0,0,0,0,0,0,0,0,0.0007,0.0013,0.0000,0.0000},
	{0,0,-5,9,0,0,0,0,1,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0001},
	{0,0,-5,9,0,0,0,0,2,0,0,0,0,0,0.0008,0.0012,0.0005,-0.0003},
	{0,2,-3,0,0,0,0,0,0,0,0,0,0,1,0.0000,-0.0032,-0.0017,0.0000},
	{0,2,-2,0,0,0,0,0,0,0,0,-1,1,0,0.0003,0.0000,0.0000,0.0000},
	{0,0,-3,6,0,0,0,0,2,0,0,0,0,0,-0.0024,-0.0013,-0.0006,0.0010},
	{0,0,-3,6,0,0,0,0,1,0,0,0,0,0,-0.0004,0.0000,0.0000,0.0002},
	{0,0,-4,6,0,0,0,0,0,0,0,1,-1,1,0.0004,0.0000,0.0000,-0.0002},
	{0,0,-3,6,0,0,0,0,1,0,0,0,0,0,-0.0005,0.0000,0.0001,0.0003},
	{0,0,3,-6,0,0,0,0,0,0,0,0,0,0,0.0000,0.0031,0.0000,0.0000},
	{0,-5,7,0,0,0,0,0,0,0,0,1,-1,2,-0.0005,0.0000,0.0000,0.0002},
	{0,0,-4,4,0,0,0,0,0,0,0,2,-2,1,0.0003,0.0000,0.0000,-0.0002},
	{0,0,2,-4,0,0,0,0,0,0,0,0,0,1,-0.0004,0.0008,0.0004,0.0002},
	{0,-3,3,0,0,0,0,0,0,0,0,2,-2,1,0.0117,0.0000,0.0000,-0.0063},
	{0,3,-4,0,0,0,0,0,0,0,0,-1,1,0,0.0000,-0.0004,0.0000,0.0000},
	{0,3,-5,0,0,0,0,0,0,0,0,0,0,1,-0.0008,0.0000,0.0001,0.0004},
	{0,0,0,0,0,5,0,0,2,0,0,0,0,0,-0.0006,0.0000,0.0000,0.0003},
	{0,0,-2,0,2,0,0,0,0,0,0,2,-2,2,-0.0005,0.0000,0.0000,0.0002},
	{0,0,0,0,2,0,0,0,2,0,0,0,0,0,-0.1166,0.0000,0.0000,0.0505},
	{0,0,0,0,2,0,0,0,1,0,0,0,0,0,0.0009,0.0049,0.0026,-0.0005},
	{0,0,-1,0,2,0,0,0,0,0,0,1,-1,1,-0.0027,-0.0143,-0.0077,0.0014},
	{0,0,0,0,2,0,0,0,1,0,0,0,0,0,0.0042,0.0223,0.0119,-0.0022},
	{0,0,0,0,2,0,0,0,0,0,0,0,0,0,-0.0025,0.0022,0.0000,0.0000},
	{0,0,0,0,4,-5,0,0,2,0,0,0,0,0,0.0007,0.0000,0.0000,-0.0003},
	{0,0,-7,9,0,0,0,0,0,0,0,2,-2,1,0.0000,0.0003,0.0002,-0.0001},
	{0,0,2,0,0,-2,0,0,0,-2,0,0,2,0,-0.0003,0.0000,0.0000,0.0000},
	{0,-3,3,0,0,0,0,0,0,2,0,0,-2,1,0.0016,0.0000,0.0000,-0.0009},
	{1,0,-4,0,0,0,0,0,0,0,0,0,0,0,0.0005,0.0003,0.0000,0.0000},
	{-1,0,4,0,0,0,0,0,2,0,0,0,0,0,-0.0004,0.0010,0.0004,0.0002},
	{0,0,6,-11,0,0,0,0,0,0,0,0,0,0,0.0009,0.0006,0.0000,0.0000},
	{0,0,-6,11,0,0,0,0,2,0,0,0,0,0,0.0000,0.0011,0.0005,0.0000},
	{0,0,-2,0,1,0,0,0,0,0,0,2,-2,1,-0.0003,0.0000,0.0000,0.0001},
	{0,0,1,0,-1,0,0,0,0,0,0,-1,1,0,0.0000,0.0004,0.0000,0.0000},
	{0,0,0,0,-1,0,0,0,0,0,0,0,0,1,0.0004,0.0015,0.0008,-0.0002},
	{0,0,-1,0,-1,0,0,0,0,0,0,1,-1,2,0.0000,-0.0006,-0.0002,0.0000},
	{0,5,-8,0,0,0,0,0,0,0,0,0,0,0,-0.0014,-0.0039,0.0000,0.0000},
	{0,-5,8,0,0,0,0,0,1,0,0,0,0,0,0.0057,0.0011,0.0006,-0.0030},
	{0,-5,7,0,0,0,0,0,0,0,0,1,-1,1,0.0140,0.0027,0.0014,-0.0075},
	{0,-5,8,0,0,0,0,0,1,0,0,0,0,0,0.0031,0.0006,0.0003,-0.0017},
	{0,-5,8,0,0,0,0,0,2,0,0,0,0,0,0.0000,0.0007,0.0003,0.0000},
	{0,-5,6,0,0,0,0,0,0,0,0,2,-2,2,0.0000,0.0012,0.0005,0.0000},
	{0,-5,8,0,0,0,0,0,2,0,0,0,0,0,-0.0011,-0.0268,-0.0116,0.0005},
	{0,0,-2,4,0,0,0,0,2,0,0,0,0,0,-0.0051,0.0000,0.0000,0.0022},
	{0,0,-2,4,0,0,0,0,1,0,0,0,0,0,-0.0008,0.0012,0.0006,0.0004},
	{0,0,-3,4,0,0,0,0,0,0,0,1,-1,1,0.0009,-0.0013,-0.0007,-0.0005},
	{0,0,-2,4,0,0,0,0,1,0,0,0,0,0,-0.0006,0.0009,0.0005,0.0003},
	{0,0,2,-4,0,0,0,0,0,0,0,0,0,0,-0.0086,0.0153,0.0000,0.0000},
	{0,0,1,-4,0,0,0,0,0,0,0,1,-1,1,0.0003,0.0000,0.0000,-0.0002},
	{0,0,2,-4,0,0,0,0,1,0,0,0,0,0,0.0004,0.0000,0.0000,-0.0002},
	{0,-3,5,0,0,0,0,0,2,0,0,0,0,0,0.0085,0.0000,0.0000,-0.0037},
	{0,-3,3,0,0,0,0,0,0,0,0,2,-2,2,-0.0012,0.0000,0.0000,0.0005},
	{0,-3,5,0,0,0,0,0,2,0,0,0,0,0,-0.2150,0.0000,0.0000,0.0932},
	{0,-3,5,0,0,0,0,0,1,0,0,0,0,0,0.0011,-0.0049,-0.0026,-0.0007},
	{0,-3,4,0,0,0,0,0,0,0,0,1,-1,1,-0.0010,0.0040,0.0021,0.0005},
	{0,3,-5,0,0,0,0,0,0,0,0,0,0,0,-0.0145,0.0047,0.0000,0.0000},
	{0,3,-5,0,0,0,0,0,1,0,0,0,0,0,-0.0003,-0.0009,-0.0005,0.0003},
	{0,3,-6,0,0,0,0,0,0,0,0,1,-1,1,-0.0009,-0.0014,-0.0008,0.0005},
	{0,0,-2,0,0,2,0,0,0,0,0,2,-2,1,0.0008,0.0000,0.0000,-0.0004},
	{0,0,1,0,0,-2,0,0,0,0,0,-1,1,0,-0.0004,0.0009,0.0000,0.0000},
	{0,0,2,-2,0,0,0,0,0,0,0,-1,1,0,0.0000,0.0004,0.0000,0.0000},
	{0,0,1,-2,0,0,0,0,0,0,0,0,0,1,-0.0037,0.0035,0.0019,0.0020},
	{0,0,0,-2,0,0,0,0,0,0,0,1,-1,2,-0.0007,0.0000,0.0000,0.0003},
	{0,0,-1,0,2,0,0,0,0,0,0,1,-1,2,0.0000,0.0010,0.0004,0.0000},
	{0,0,-2,0,2,0,0,0,0,2,0,0,-2,1,0.0054,0.0000,0.0000,-0.0029},
	{0,0,4,-8,3,0,0,0,0,0,0,0,0,2,0.0000,-0.0007,-0.0003,0.0000},
	{0,0,-4,8,-3,0,0,0,0,0,0,0,0,2,0.0000,-0.0007,-0.0003,0.0000},
	{0,3,-3,0,0,0,0,0,0,-2,0,0,2,0,-0.0138,0.0000,0.0000,0.0000},
	{0,0,0,0,0,3,0,0,2,0,0,0,0,0,0.0000,0.0015,0.0007,0.0000},
	{0,0,0,0,0,3,0,0,1,0,0,0,0,0,0.0008,-0.0004,-0.0002,-0.0004},
	{0,0,-1,0,0,3,0,0,0,0,0,1,-1,1,-0.0008,0.0004,0.0002,0.0004},
	{0,0,0,0,2,-2,0,0,0,0,0,0,0,0,-0.0004,0.0000,0.0000,0.0000},
	{0,0,4,-4,0,0,0,0,0,-2,0,0,2,0,-0.0004,0.0000,0.0000,0.0000},
	{-1,0,2,0,0,0,0,0,0,0,0,2,-2,1,0.0000,0.0008,0.0004,0.0001},
	{0,0,-8,11,0,0,0,0,0,0,0,2,-2,1,0.0000,0.0008,0.0004,0.0000},
	{0,0,-5,6,0,0,0,0,0,2,0,0,-2,1,0.0003,0.0000,0.0000,-0.0002},
	{0,0,7,-13,0,0,0,0,0,0,0,0,0,0,0.0010,0.0000,0.0000,0.0000},
	{0,0,-7,13,0,0,0,0,2,0,0,0,0,0,-0.0004,0.0008,0.0003,0.0002},
	{0,0,1,0,0,-1,0,0,0,0,0,-1,1,0,-0.0004,0.0000,0.0000,0.0000},
	{0,0,0,0,0,-1,0,0,0,0,0,0,0,1,0.0000,0.0005,0.0003,0.0000},
	{0,0,-1,0,0,-1,0,0,0,0,0,1,-1,2,-0.0003,0.0000,0.0000,0.0001},
	{0,0,0,0,1,0,0,0,2,0,0,0,0,0,0.0052,0.0023,0.0010,-0.0023},
	{0,0,0,0,1,0,0,0,1,0,0,0,0,0,0.0000,0.0005,0.0003,0.0000},
	{0,0,-1,0,1,0,0,0,0,0,0,1,-1,1,-0.0006,-0.0047,-0.0025,0.0003},
	{0,0,0,0,1,0,0,0,1,0,0,0,0,0,0.0006,0.0049,0.0026,-0.0003},
	{0,0,0,0,1,0,0,0,0,0,0,0,0,0,-0.0091,0.0248,0.0000,0.0000},
	{0,0,0,0,-1,0,0,0,1,0,0,0,0,0,-0.0013,0.0052,0.0028,0.0007},
	{0,0,-1,0,-1,0,0,0,0,0,0,1,-1,1,-0.0050,0.0194,0.0103,0.0027},
	{0,0,0,0,3,-5,0,0,0,0,0,0,0,0,0.0000,-0.0004,0.0000,0.0000},
	{0,0,-1,0,1,0,0,0,0,1,0,0,-1,1,0.0004,0.0000,0.0000,-0.0002},
	{0,0,6,-8,0,0,0,0,0,-2,0,0,2,1,0.0000,0.0003,0.0002,0.0001},
	{0,0,2,0,-3,0,0,0,0,-2,0,0,2,1,-0.0053,-0.0009,-0.0005,0.0028},
	{0,0,-8,15,0,0,0,0,0,0,0,0,0,1,-0.0005,-0.0003,-0.0001,0.0003},
	{0,6,-8,0,0,0,0,0,0,-2,0,0,2,1,0.0011,-0.0003,-0.0001,-0.0006},
	{0,5,-8,0,0,0,0,0,0,0,0,0,0,1,0.0000,0.0005,0.0003,0.0000},
	{0,5,-7,0,0,0,0,0,0,0,0,-1,1,0,0.0035,-0.0007,0.0000,0.0000},
	{0,-5,6,0,0,0,0,0,0,0,0,2,-2,1,-0.0018,-0.0436,-0.0233,0.0009},
	{0,0,-2,4,0,0,0,0,0,0,0,0,0,1,-0.0011,-0.0021,-0.0011,0.0006},
	{0,-3,4,0,0,0,0,0,0,0,0,1,-1,2,0.0000,-0.0003,-0.0001,0.0000},
	{0,-3,5,0,0,0,0,0,0,0,0,0,0,1,-0.0021,-0.0006,-0.0003,0.0011},
	{0,3,-6,0,0,0,0,0,0,0,0,1,-1,0,0.0000,0.0004,0.0000,0.0000},
	{0,0,0,0,0,2,0,0,2,0,0,0,0,0,-0.0133,0.0000,0.0000,0.0057},
	{0,0,0,0,0,2,0,0,1,0,0,0,0,0,0.0051,0.0114,0.0061,-0.0027},
	{0,0,-1,0,0,2,0,0,0,0,0,1,-1,1,-0.0048,-0.0110,-0.0059,0.0026},
	{0,0,-1,0,0,-2,0,0,0,0,0,1,-1,1,0.0003,-0.0004,-0.0002,-0.0002},
	{0,0,3,-4,0,0,0,0,0,-1,0,0,1,1,-0.0003,0.0000,0.0000,0.0002},
	{0,3,-4,0,0,0,0,0,0,-1,0,0,1,1,0.0000,0.0023,0.0013,0.0000},
	{0,0,-1,2,0,0,0,0,1,0,0,0,0,0,0.0006,0.0047,0.0025,-0.0003},
	{0,0,-2,2,0,0,0,0,0,0,0,1,-1,1,-0.0008,-0.0047,-0.0025,0.0004},
	{0,0,1,-2,0,0,0,0,0,0,0,0,0,0,-0.0449,0.0430,0.0000,0.0000},
	{0,0,0,-2,0,0,0,0,0,0,0,1,-1,1,0.0273,0.0080,0.0043,-0.0146},
	{0,0,1,-2,0,0,0,0,1,0,0,0,0,0,0.0023,0.0007,0.0003,-0.0013},
	{0,-8,13,0,0,0,0,0,0,0,0,0,0,1,-0.0040,0.0057,0.0030,0.0021},
	{0,-8,12,0,0,0,0,0,0,0,0,1,-1,2,-0.0004,0.0000,0.0000,0.0002},
	{0,0,1,0,-2,0,0,0,0,-2,0,1,1,1,0.0000,-0.0006,-0.0003,0.0000},
	{0,-18,16,0,0,0,0,0,0,1,0,0,0,1,0.0057,-0.0028,-0.0015,-0.0030},
	{0,0,2,0,-2,0,0,0,0,-2,0,0,2,0,-0.0439,0.0000,0.0000,0.0000},
	{0,-3,7,-4,0,0,0,0,0,0,0,0,0,1,-0.0009,-0.0005,-0.0003,0.0005},
	{0,0,2,0,0,-5,0,0,0,-2,0,0,2,0,-0.0003,0.0000,0.0000,0.0000},
	{0,0,3,-7,0,0,0,0,0,2,0,-1,-1,1,0.0003,0.0000,-0.0001,-0.0002},
	{0,0,1,0,2,-5,0,0,0,0,0,-1,1,0,-0.0009,-0.0016,0.0000,0.0000},
	{0,0,0,0,2,-5,0,0,0,0,0,0,0,1,-0.0073,0.0017,0.0009,0.0039},
	{0,0,4,-8,3,0,0,0,0,0,0,0,0,1,-0.0082,0.0292,0.0156,0.0044},
	{0,10,-3,0,0,0,0,0,0,-1,0,0,0,1,-0.0003,0.0000,0.0000,0.0001},
	{0,0,-2,0,0,0,0,0,0,0,0,2,-2,1,-0.0003,0.0000,0.0000,0.0002},
	{0,-10,3,0,0,0,0,0,0,1,0,0,0,1,0.0003,0.0000,0.0000,-0.0001},
	{0,0,-4,8,-3,0,0,0,0,0,0,0,0,1,0.0084,0.0298,0.0159,-0.0045},
	{0,0,0,0,-2,5,0,0,0,0,0,0,0,1,0.0076,0.0017,0.0009,-0.0041},
	{0,0,-1,0,-2,5,0,0,0,0,0,1,-1,2,-0.0003,0.0005,0.0002,0.0001},
	{0,0,-3,7,0,0,0,0,0,-2,0,1,1,1,-0.0005,-0.0004,-0.0002,0.0003},
	{0,3,-7,4,0,0,0,0,0,0,0,0,0,1,0.0010,-0.0006,-0.0003,-0.0005},
	{0,0,-1,0,-1,1,0,0,0,0,0,1,-1,1,0.0000,0.0014,0.0007,0.0000},
	{0,18,-16,0,0,0,0,0,0,-1,0,0,0,1,-0.0068,-0.0034,-0.0018,0.0036},
	{0,0,2,-2,0,0,0,0,0,-1,0,0,1,0,-0.0005,0.0000,0.0000,0.0000},
	{0,-8,11,0,0,0,0,0,0,0,0,2,-2,1,0.0000,0.0003,0.0002,0.0000},
	{0,8,-12,0,0,0,0,0,0,0,0,-1,1,0,-0.0014,0.0007,0.0000,0.0000},
	{0,8,-13,0,0,0,0,0,0,0,0,0,0,1,0.0046,0.0066,0.0035,-0.0025},
	{0,3,-3,0,0,0,0,0,0,-2,0,0,2,1,-0.0005,0.0000,0.0000,0.0003},
	{0,0,2,0,-3,1,0,0,0,-2,0,0,2,1,0.0003,0.0000,0.0000,-0.0002},
	{0,3,-5,0,2,0,0,0,0,0,0,0,0,0,0.0010,0.0000,0.0000,0.0000},
	{1,0,-2,0,0,0,0,0,0,0,0,-2,2,0,0.0000,-0.0003,0.0000,0.0000},
	{0,0,0,2,0,0,0,0,0,0,0,-1,1,1,0.0008,-0.0003,-0.0001,-0.0005},
	{0,0,-1,2,0,0,0,0,0,0,0,0,0,2,-0.0005,-0.0004,-0.0002,0.0002},
	{0,-3,4,0,0,0,0,0,0,1,0,0,-1,1,0.0000,0.0029,0.0015,0.0000},
	{0,0,-3,4,0,0,0,0,0,1,0,0,-1,1,0.0004,0.0003,0.0001,-0.0002},
	{0,0,-9,17,0,0,0,0,2,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0002},
	{0,0,9,-17,0,0,0,0,0,0,0,0,0,0,0.0005,-0.0006,0.0000,0.0000},
	{0,0,5,-6,0,0,0,0,0,-2,0,0,2,0,-0.0024,0.0012,0.0000,0.0000},
	{0,0,7,-13,0,0,0,0,0,0,0,0,0,1,-0.0003,0.0000,0.0000,0.0002},
	{0,0,-9,13,0,0,0,0,0,0,0,2,-2,1,0.0010,-0.0022,-0.0012,-0.0005},
	{0,0,0,0,0,1,0,0,2,0,0,0,0,0,0.0000,0.0008,0.0004,0.0000},
	{0,0,0,0,0,1,0,0,1,0,0,0,0,0,0.0047,0.0008,0.0004,-0.0025},
	{0,0,-1,0,0,1,0,0,0,0,0,1,-1,1,-0.0066,-0.0012,-0.0006,0.0035},
	{0,0,0,0,0,1,0,0,0,0,0,0,0,0,0.0011,0.0056,0.0000,0.0000},
	{0,0,-1,0,0,-1,0,0,0,0,0,1,-1,1,0.0174,0.0084,0.0045,-0.0093},
	{0,0,0,0,0,-1,0,0,1,0,0,0,0,0,0.0032,0.0015,-0.0008,0.0017},
	{0,5,-6,0,0,0,0,0,0,0,0,-2,2,1,0.0000,0.0006,0.0003,0.0000},
	{0,-6,8,0,0,0,0,0,0,2,0,0,-2,1,-0.0017,-0.0004,-0.0002,0.0009},
	{0,0,-1,0,-2,4,0,0,0,0,0,1,-1,1,0.0005,0.0003,0.0002,-0.0002},
	{0,0,-1,0,1,0,0,0,0,0,0,1,-1,2,0.0000,0.0006,0.0003,0.0000},
	{0,0,0,0,1,0,0,0,0,0,0,0,0,1,0.0020,-0.0070,-0.0037,-0.0011},
	{0,0,1,0,1,0,0,0,0,0,0,-1,1,0,-0.0021,-0.0078,0.0000,0.0000},
	{0,0,-10,15,0,0,0,0,0,0,0,2,-2,1,-0.0003,0.0000,0.0000,0.0001},
	{0,0,8,-15,0,0,0,0,0,0,0,0,0,1,0.0015,-0.0007,-0.0004,-0.0008},
	{0,20,-21,0,0,0,0,0,0,1,0,0,-2,0,0.0000,-0.0008,0.0000,0.0000},
	{0,-20,20,0,0,0,0,0,0,-1,0,1,1,1,0.0005,0.0000,0.0000,-0.0003},
	{0,0,1,0,-1,0,0,0,0,-1,0,0,1,0,-0.0053,0.0000,0.0000,0.0000},
	{0,0,2,0,-1,-5,0,0,0,-2,0,0,2,0,-0.0003,0.0000,0.0000,0.0000},
	{0,0,6,-8,0,0,0,0,0,-2,0,0,2,0,-0.0015,0.0022,0.0000,0.0000},
	{0,0,2,0,-3,0,0,0,0,-2,0,0,2,0,-0.0349,-0.0062,0.0000,0.0000},
	{0,0,1,0,-3,0,0,0,0,-2,0,1,1,1,-0.0003,0.0007,0.0004,0.0002},
	{0,0,1,0,-3,0,0,0,0,-2,0,1,1,0,0.0000,0.0003,0.0000,0.0000},
	{0,0,-2,0,3,0,0,0,0,2,0,0,-2,1,0.0089,-0.0016,-0.0009,-0.0048},
	{0,0,-6,8,0,0,0,0,0,2,0,0,-2,1,0.0003,0.0005,0.0003,-0.0002},
	{0,0,2,0,-5,5,0,0,0,-2,0,0,2,0,0.0000,0.0003,0.0000,0.0000},
	{0,2,-5,0,0,0,0,0,0,2,0,0,-2,0,0.0000,-0.0003,0.0000,0.0000},
	{0,0,8,-15,0,0,0,0,0,1,0,-1,-1,0,-0.0003,0.0000,0.0000,0.0000},
	{0,0,8,-15,0,0,0,0,0,0,0,0,0,0,0.0045,-0.0022,0.0000,0.0000},
	{0,0,-9,15,0,0,0,0,0,0,0,1,-1,1,0.0000,0.0019,0.0010,0.0000},
	{0,0,-8,15,0,0,0,0,1,0,0,0,0,0,0.0000,0.0008,-0.0004,0.0000},
	{0,0,-8,15,0,0,0,0,2,0,0,0,0,0,-0.0014,0.0008,0.0003,0.0006},
	{0,0,0,0,0,0,2,0,2,0,0,0,0,0,-0.0007,0.0000,0.0000,0.0003},
	{0,0,0,0,0,0,2,0,1,0,0,0,0,0,0.0000,-0.0005,0.0003,0.0000},
	{0,0,-1,0,0,0,2,0,0,0,0,1,-1,1,0.0000,-0.0008,-0.0004,-0.0001},
	{0,0,1,0,1,0,0,0,0,0,0,-1,1,1,0.0000,-0.0004,-0.0002,0.0001},
	{0,0,0,0,1,0,0,0,0,0,0,0,0,2,0.0000,-0.0003,-0.0001,0.0000},
	{0,-6,7,0,0,0,0,0,0,2,0,1,-3,1,0.0000,0.0003,0.0001,0.0000},
	{0,6,-8,0,0,0,0,0,0,-2,0,0,2,0,0.0078,-0.0018,0.0000,0.0000},
	{0,5,-7,0,0,0,0,0,0,0,0,-1,1,1,-0.0003,0.0000,0.0000,0.0001},
	{0,5,-6,0,0,0,0,0,0,0,0,-2,2,0,-0.0010,0.0233,0.0000,0.0000},
	{0,0,1,0,0,1,0,0,0,0,0,-1,1,0,-0.0042,0.0020,0.0000,0.0000},
	{0,0,0,0,0,1,0,0,0,0,0,0,0,1,0.0004,0.0024,0.0013,-0.0002},
	{0,0,-1,0,0,1,0,0,0,0,0,1,-1,2,-0.0005,0.0000,0.0000,0.0002},
	{0,0,9,-13,0,0,0,0,0,0,0,-2,2,0,-0.0003,-0.0005,0.0000,0.0000},
	{0,0,5,-6,0,0,0,0,0,-2,0,0,2,1,-0.0006,0.0004,0.0002,0.0003},
	{0,0,-1,0,1,-3,0,0,0,0,0,1,-1,1,0.0000,0.0003,0.0002,0.0000},
	{0,17,-16,0,-2,0,0,0,0,1,0,0,-2,0,0.0000,0.0005,0.0000,0.0000},
	{0,0,0,0,1,-2,0,0,0,0,0,0,0,0,0.0000,0.0003,0.0000,0.0000},
	{0,0,-1,0,-1,2,0,0,0,0,0,1,-1,1,0.0000,-0.0008,-0.0004,0.0000},
	{0,-3,5,0,0,0,0,0,0,0,0,0,0,2,0.0003,0.0000,0.0000,-0.0001},
	{0,0,-9,17,0,0,0,0,0,0,0,0,0,1,-0.0003,-0.0004,-0.0002,0.0001},
	{0,0,-1,0,0,2,0,0,0,0,0,1,-1,2,0.0011,0.0024,0.0011,-0.0005},
	{0,0,1,0,0,2,0,0,0,0,0,-1,1,0,0.0000,0.0003,0.0000,0.0000},
	{0,0,3,-4,0,0,0,0,0,-1,0,0,1,0,-0.0016,0.0008,0.0000,0.0000},
	{0,0,0,0,0,0,0,2,2,0,0,0,0,0,-0.0006,0.0000,0.0000,0.0003},
	{0,0,0,0,0,0,0,2,1,0,0,0,0,0,-0.0009,-0.0011,0.0006,-0.0005},
	{0,0,-1,0,0,0,0,2,0,0,0,1,-1,1,-0.0017,-0.0019,-0.0010,0.0009},
	{0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.0000,0.0003,0.0000,0.0000},
	{0,0,-1,0,0,0,-1,0,0,0,0,1,-1,1,0.0000,0.0004,0.0002,0.0000},
	{0,0,-5,9,0,0,0,0,0,-2,0,2,0,2,0.0000,0.0003,0.0000,0.0000},
	{0,0,2,0,-2,-2,0,0,0,-2,0,0,2,0,0.0004,0.0000,0.0000,0.0000},
	{0,3,-4,0,0,0,0,0,0,-1,0,0,1,0,0.0000,0.0131,0.0000,0.0000},
	{0,3,-5,0,0,0,0,0,0,-1,0,1,0,1,-0.0003,0.0000,0.0000,0.0002},
	{0,0,-2,2,0,0,0,0,0,0,0,1,-1,2,0.0000,0.0015,0.0007,0.0000},
	{0,0,-1,2,0,0,0,0,0,0,0,0,0,1,-0.0460,-0.0435,-0.0232,0.0246},
	{0,0,0,2,0,0,0,0,0,0,0,-1,1,0,0.0266,-0.0078,0.0000,0.0000},
	{0,0,2,0,-4,3,0,0,0,-2,0,0,2,0,-0.0006,-0.0009,0.0000,0.0000},
	{0,3,-5,0,2,0,0,0,0,0,0,0,0,1,0.0013,0.0000,0.0000,-0.0007},
	{0,0,2,0,-3,1,0,0,0,-2,0,0,2,0,0.0015,0.0000,0.0000,0.0000},
	{0,3,-3,0,0,0,0,0,0,-2,0,0,2,2,0.0006,0.0000,0.0000,-0.0003},
	{0,0,2,0,-4,5,0,0,0,-2,0,0,2,1,-0.0005,0.0000,0.0000,0.0003},
	{0,8,-13,0,0,0,0,0,1,0,0,0,0,0,0.0005,-0.0006,0.0003,0.0003},
	{0,8,-14,0,0,0,0,0,0,0,0,1,-1,1,0.0011,-0.0012,-0.0007,-0.0006},
	{0,8,-13,0,0,0,0,0,0,0,0,0,0,0,0.0235,0.0334,0.0000,0.0000},
	{0,-8,12,0,0,0,0,0,0,0,0,1,-1,1,0.1200,0.0598,0.0319,-0.0641},
	{0,-8,13,0,0,0,0,0,1,0,0,0,0,0,0.0425,0.0212,-0.0133,0.0269},
	{0,-8,11,0,0,0,0,0,0,0,0,2,-2,2,0.0000,0.0015,0.0006,0.0000},
	{0,-8,13,0,0,0,0,0,2,0,0,0,0,0,-0.0041,0.0175,0.0076,0.0017},
	{0,0,2,-2,0,0,0,0,0,-1,0,0,1,1,0.0005,0.0000,0.0000,-0.0003},
	{0,18,-17,0,0,0,0,0,0,-1,0,1,-1,1,0.0000,-0.0006,-0.0003,0.0000},
	{0,0,1,0,-2,0,0,0,0,-2,0,1,1,2,0.0000,-0.0008,-0.0002,0.0000},
	{0,18,-16,0,0,0,0,0,0,-1,0,0,0,0,0.0226,0.0101,0.0000,0.0000},
	{0,0,2,0,-2,0,0,0,0,-2,0,0,2,1,0.0284,0.0000,0.0000,-0.0151},
	{0,0,1,0,1,-1,0,0,0,0,0,-1,1,0,0.0000,0.0024,0.0000,0.0000},
	{0,3,-7,4,0,0,0,0,0,0,0,0,0,0,-0.0007,0.0000,0.0000,0.0000},
	{0,0,2,0,0,-5,0,0,0,-2,0,0,2,1,0.0012,0.0000,0.0000,-0.0006},
	{0,0,-1,0,-4,10,0,0,0,0,0,1,-1,1,0.0009,-0.0027,-0.0014,-0.0005},
	{0,0,-1,0,2,0,0,0,0,1,0,0,-1,1,-0.0026,-0.0029,-0.0016,0.0014},
	{0,2,-4,0,-3,0,0,0,0,0,0,1,-1,1,0.0000,-0.0013,-0.0007,0.0000},
	{0,19,-21,3,0,0,0,0,0,1,0,0,-2,0,0.0103,-0.0060,0.0000,0.0000},
	{0,0,3,-7,0,0,0,0,0,2,0,-1,-1,0,0.0026,-0.0009,0.0000,0.0000},
	{0,0,0,0,-2,5,0,0,2,0,0,0,0,0,0.0011,-0.0024,-0.0011,-0.0009},
	{0,0,0,0,-2,5,0,0,1,0,0,0,0,0,-0.1444,0.2409,-0.1286,-0.0771},
	{0,0,-1,0,-2,5,0,0,0,0,0,1,-1,1,-0.3084,0.5123,0.2735,0.1647},
	{0,0,0,0,2,-5,0,0,0,0,0,0,0,0,-0.0491,0.0128,0.0000,0.0000},
	{0,0,-1,0,2,-5,0,0,0,0,0,1,-1,1,0.0031,-0.0481,-0.0257,-0.0017},
	{0,0,0,0,2,-5,0,0,1,0,0,0,0,0,0.0014,-0.0218,0.0117,0.0008},
	{0,0,0,0,2,-5,0,0,2,0,0,0,0,0,-0.0012,0.0000,0.0000,0.0000},
	{0,-5,6,4,0,0,0,0,2,0,0,0,0,0,0.0003,0.0000,0.0000,0.0000},
	{0,0,4,-8,1,5,0,0,2,0,0,0,0,0,0.0000,0.0006,0.0002,0.0000},
	{0,0,-4,8,-3,0,0,0,1,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0002},
	{0,0,-5,8,-3,0,0,0,0,0,0,1,-1,1,0.0099,0.0000,0.0000,-0.0053},
	{0,0,4,-8,3,0,0,0,0,0,0,0,0,0,-0.0462,0.1604,0.0000,0.0000},
	{0,0,0,0,-2,6,-3,0,2,0,0,0,0,0,-0.0003,0.0000,0.0000,0.0000},
	{0,10,-3,0,0,0,0,0,0,-1,0,0,0,0,-0.0219,0.0089,0.0000,0.0000},
	{0,0,3,-8,3,0,0,0,0,0,0,1,-1,1,-0.0114,0.0000,0.0000,0.0061},
	{0,0,4,-8,3,0,0,0,1,0,0,0,0,0,0.0003,0.0000,0.0000,-0.0002},
	{0,0,-4,8,-1,-5,0,0,2,0,0,0,0,0,0.0003,-0.0007,-0.0003,0.0000},
	{0,0,0,0,0,0,-1,2,2,0,0,0,0,0,0.0000,0.0005,0.0000,0.0000},
	{0,0,8,-16,4,5,0,0,2,0,0,0,0,0,0.0125,-0.0043,0.0000,-0.0054},
	{0,0,-8,16,-4,-5,0,0,2,0,0,0,0,0,0.0056,-0.0117,-0.0042,-0.0040},
	{0,0,8,-16,4,5,0,0,0,0,0,0,0,0,0.1440,0.0000,0.0000,0.0000},
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};

u_short iau2000a_lunisolar_count = sizeof(iau2000a_lunisolar) / sizeof(iau2000a_lunisolar[0]) - 1;

u_short iau2000a_planetary_count = sizeof(iau2000a_planetary) / sizeof(iau2000a_planetary[0]) - 1;

