/*
 * elp82b_data.c - Series of terms in the ELP 2000-82B theory
 * Copyright (C) 2010 Shiva Iyer <shiva.iyer AT g m a i l DOT c o m>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <kepler.h>
#include <elp82b.h>

struct elp82b_term1 elp1[] = {
	{0,0,0,2,-411.60287,168.48,0.007208554584046647679962,-0.000010548487837491322860,-0.000000249756615960388545,-0.18},
	{0,0,0,4,0.42034,-0.39,-0.000014723059426638131436,0.000000049437905503782707,-0.000000000000000000000000,0.00},
	{0,0,0,6,-0.00059,0.00,0.000000031284057214636136,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,1,-6,0.00016,0.00,-0.000000007821014303659034,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,1,-4,-0.08019,0.77,0.000002823386163620911397,-0.000000126630424623724138,-0.000000000000000000000000,0.00},
	{0,0,1,-2,39.53393,-395.24,-0.000699327725483128020967,0.000062526807818828056143,0.000001623418003742525357,0.90},
	{0,0,1,0,22639.55000,0.00,-0.000000000000000000000000,0.035779999783670766999588,-0.000000000000000000000000,0.00},
	{0,0,1,2,-45.10032,17.41,0.000789836413512222217104,-0.000072005875700421775702,-0.000000056195238591087415,-0.02},
	{0,0,1,4,0.09092,-0.07,-0.000003183152821589227175,0.000000150048379862358043,-0.000000000000000000000000,0.00},
	{0,0,1,6,-0.00019,0.00,0.000000007821014303659034,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,2,-4,0.00068,0.07,-0.000000023463042910977102,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{0,0,2,-2,-1.37259,-7.58,0.000024436759191782652783,-0.000004347066357630858381,0.000000043707407793067991,0.00},
	{0,0,2,0,769.02326,-257.51,0.000018531893392520080912,0.002429308422590166667565,0.000004264594217523633535,-0.56},
	{0,0,2,2,-3.99767,2.40,0.000069974614974837375404,-0.000012678654432531503144,-0.000000031219576995048568,0.00},
	{0,0,2,4,0.01297,-0.01,-0.000000453618829612223922,0.000000041631920424238072,-0.000000000000000000000000,0.00},
	{0,0,2,6,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,3,-4,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,3,-2,-0.05684,0.38,0.000001036284395234822064,-0.000000271474814433052451,-0.000000000000000000000000,0.00},
	{0,0,3,0,36.12364,-28.42,0.000001994358647433053576,0.000171101988953565442965,0.000000580684132107903358,-0.08},
	{0,0,3,2,-0.32866,0.32,0.000005748445513189389919,-0.000001560329684233422602,-0.000000000000000000000000,0.00},
	{0,0,3,4,0.00153,0.00,-0.000000054747100125613245,0.000000006938653404039679,-0.000000000000000000000000,0.00},
	{0,0,4,-2,-0.00354,0.04,0.000000066478621581101789,-0.000000022550623563128957,-0.000000000000000000000000,0.00},
	{0,0,4,0,1.93367,-2.65,0.000000172062314680498749,0.000012207693332732309937,0.000000062439153990097136,0.00},
	{0,0,4,2,-0.02602,0.04,0.000000453618829612223922,-0.000000164793018345942362,-0.000000000000000000000000,0.00},
	{0,0,4,4,0.00016,0.00,-0.000000003910507151829517,0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{0,0,5,-2,-0.00023,0.00,0.000000003910507151829517,-0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{0,0,5,0,0.11100,-0.23,0.000000015642028607318068,0.000000876004992260009428,-0.000000000000000000000000,0.00},
	{0,0,5,2,-0.00201,0.00,0.000000035194564366465653,-0.000000015611970159089276,-0.000000000000000000000000,0.00},
	{0,0,5,4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,6,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,6,0,0.00665,-0.02,-0.000000000000000000000000,0.000000063315212311862069,-0.000000000000000000000000,0.00},
	{0,0,6,2,-0.00015,0.00,-0.000000000000000000000000,-0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{0,0,7,0,0.00041,0.00,-0.000000000000000000000000,0.000000004336658377524799,-0.000000000000000000000000,0.00},
	{0,0,7,2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,8,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-7,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-6,0,-0.00024,0.00,-0.000000000000000000000000,-0.000000002601995026514880,0.000000006243915399009713,0.00},
	{0,1,-5,-2,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-5,0,-0.00332,-0.07,-0.000000000000000000000000,-0.000000026019950265148796,0.000000124878307980194272,0.00},
	{0,1,-4,-2,0.00064,0.01,-0.000000011731521455488551,0.000000004336658377524799,-0.000000024975661596038853,0.00},
	{0,1,-4,0,-0.04702,-1.04,-0.000000011731521455488551,-0.000000296627433022696283,0.000001760784142520738927,0.00},
	{0,1,-4,2,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-3,-4,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-3,-2,0.00623,0.14,-0.000000109494200251226490,0.000000029489276967168638,-0.000000231024869763359374,0.00},
	{0,1,-3,0,-0.66940,-15.55,-0.000000148599271769521647,-0.000003168362610619618704,0.000025038100750028948626,-0.02},
	{0,1,-3,2,0.00106,0.02,-0.000000019552535759147585,0.000000005203990053029759,-0.000000043707407793067991,0.00},
	{0,1,-2,-4,-0.00017,0.00,0.000000007821014303659034,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{0,1,-2,-2,0.05165,1.17,-0.000000895506137768959451,0.000000163925686670437411,-0.000001929369858294001151,0.00},
	{0,1,-2,0,-9.67938,-235.29,-0.000001916148504396463448,-0.000030575176224900846723,0.000362109629650169296145,-0.15},
	{0,1,-2,2,0.02429,0.74,-0.000000426245279549417409,0.000000077192519119941424,-0.000000911611648255418012,0.00},
	{0,1,-2,4,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-1,-4,-0.00063,-0.01,0.000000023463042910977102,-0.000000000867331675504960,0.000000024975661596038853,0.00},
	{0,1,-1,-2,0.30157,6.60,-0.000005216616540540576028,0.000000486573069958282530,-0.000011282755126010550489,0.00},
	{0,1,-1,0,-147.32654,-3778.62,-0.000026857363118765125674,-0.000233184722954534991504,0.005512859052347458994892,-0.76},
	{0,1,-1,2,-0.08049,0.25,0.000001419514096114114627,-0.000000120559102895189405,0.000003009567222322681705,-0.01},
	{0,1,-1,4,0.00013,0.00,-0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,0,-4,-0.00023,0.01,0.000000007821014303659034,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{0,1,0,-2,0.07501,-6.72,-0.000001188794174156173175,0.000000073723192417921582,-0.000002784786267958332072,0.00},
	{0,1,0,0,-666.44186,-5206.84,-0.000101200014582196080328,-0.000048221906494724761140,0.024905598621346565491042,1.73},
	{0,1,0,2,0.41342,1.50,-0.000007097570480570572499,0.000000103212469385090220,-0.000015434958866352009208,0.01},
	{0,1,0,4,-0.00083,0.00,0.000000027373550062806622,0.000000000000000000000000,0.000000031219576995048568,0.00},
	{0,1,1,-4,0.00011,0.00,-0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,1,-2,-0.08282,1.73,0.000001458619167632409903,-0.000000130099751325743967,0.000003090738122509807866,0.00},
	{0,1,1,0,-109.38419,-2193.78,-0.000020193858932047626547,-0.000175038807428682481257,0.004093573374744758318344,0.54},
	{0,1,1,2,0.26338,4.53,-0.000004555740831881387598,0.000000436267832778994813,-0.000009852898499637326957,0.00},
	{0,1,1,4,-0.00062,0.00,0.000000023463042910977102,-0.000000000867331675504960,0.000000024975661596038853,0.00},
	{0,1,2,-4,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,2,-2,0.02677,1.10,-0.000000469260858219542043,0.000000084131172523981109,-0.000000999026463841554180,0.00},
	{0,1,2,0,-7.63041,-156.07,-0.000001599397425098272304,-0.000024275746265708321079,0.000285602934266103263266,0.12},
	{0,1,2,2,0.04338,0.81,-0.000000750817373151267269,0.000000139640399756298556,-0.000001623418003742525357,0.00},
	{0,1,2,4,-0.00015,0.00,0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,3,-2,0.00166,0.06,-0.000000031284057214636136,0.000000007805985079544638,-0.000000062439153990097136,0.00},
	{0,1,3,0,-0.54594,-11.18,-0.000000132957243162203579,-0.000002599393031488364755,0.000020436335100958787254,0.01},
	{0,1,3,2,0.00526,0.10,-0.000000089941664492078892,0.000000025152618589643836,-0.000000199805292768310825,0.00},
	{0,1,3,4,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,4,-2,0.00014,0.00,-0.000000000000000000000000,0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{0,1,4,0,-0.03947,-0.80,-0.000000011731521455488551,-0.000000250658854220933425,0.000001479807949565302098,0.00},
	{0,1,4,2,0.00055,0.01,-0.000000007821014303659034,0.000000003469326702019840,-0.000000018731746197029138,0.00},
	{0,1,5,-2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,5,0,-0.00287,-0.06,-0.000000000000000000000000,-0.000000022550623563128957,0.000000106146561783165128,0.00},
	{0,1,5,2,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,6,0,-0.00021,0.00,-0.000000000000000000000000,-0.000000001734663351009920,0.000000006243915399009713,0.00},
	{0,1,7,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,-5,0,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{0,2,-4,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,-4,0,-0.00119,-0.04,-0.000000000000000000000000,-0.000000007805985079544638,0.000000087414815586135983,0.00},
	{0,2,-3,-2,0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{0,2,-3,0,-0.01514,-0.50,-0.000000003910507151829517,-0.000000071988529066911668,0.000001130148687220758061,0.00},
	{0,2,-3,2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,-2,-2,0.00100,0.03,-0.000000015642028607318068,0.000000003469326702019840,-0.000000074926984788116553,0.00},
	{0,2,-2,0,-0.19311,-6.23,-0.000000050836592973783721,-0.000000610601499555491790,0.000014442176317909465987,0.00},
	{0,2,-2,2,0.00060,0.02,-0.000000011731521455488551,0.000000001734663351009920,-0.000000043707407793067991,0.00},
	{0,2,-1,-2,0.00473,0.12,-0.000000082120650188419858,0.000000007805985079544638,-0.000000355903177743553620,0.00},
	{0,2,-1,0,-2.56813,-81.06,-0.000000563113029863450451,-0.000004071254884820281654,0.000192075325504336802233,0.00},
	{0,2,-1,2,0.00013,0.05,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{0,2,0,-2,-0.00355,-0.26,0.000000062568114429272272,0.000000001734663351009920,0.000000262244446758407922,0.00},
	{0,2,0,0,-7.44804,-12.64,-0.000001165331131245195967,-0.000000808353121570622645,0.000556501447767538694709,0.03},
	{0,2,0,2,0.00519,-0.03,-0.000000089941664492078892,0.000000001734663351009920,-0.000000387122754738602168,0.00},
	{0,2,0,4,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,1,-2,-0.00040,0.08,0.000000007821014303659034,0.000000000000000000000000,0.000000031219576995048568,0.00},
	{0,2,1,0,-1.16177,-19.75,-0.000000168151807528669232,-0.000001866497765686673606,0.000086871594946422126763,0.00},
	{0,2,1,2,0.00270,0.03,-0.000000046926085821954204,0.000000004336658377524799,-0.000000199805292768310825,0.00},
	{0,2,2,-2,0.00040,0.02,-0.000000007821014303659034,0.000000001734663351009920,-0.000000031219576995048568,0.00},
	{0,2,2,0,-0.06513,-0.79,-0.000000007821014303659034,-0.000000207292270445685418,0.000004870254011227575647,0.00},
	{0,2,2,2,0.00035,0.00,-0.000000007821014303659034,0.000000000867331675504960,-0.000000024975661596038853,0.00},
	{0,2,3,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,3,0,-0.00341,0.00,-0.000000000000000000000000,-0.000000016479301834594237,0.000000256000531359398233,0.00},
	{0,2,3,2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,4,0,-0.00015,0.00,-0.000000000000000000000000,-0.000000000867331675504960,0.000000012487830798019427,0.00},
	{0,3,-4,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,-3,0,-0.00035,-0.01,-0.000000000000000000000000,-0.000000001734663351009920,0.000000037463492394058276,0.00},
	{0,3,-2,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,-2,0,-0.00416,-0.15,-0.000000000000000000000000,-0.000000013009975132574398,0.000000468293654925728436,0.00},
	{0,3,-2,2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,-1,-2,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{0,3,-1,0,-0.05142,-1.82,-0.000000011731521455488551,-0.000000081529177497466217,0.000005769377828684975023,0.00},
	{0,3,-1,2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,0,-2,-0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000018731746197029138,0.00},
	{0,3,0,0,-0.10136,1.16,-0.000000015642028607318068,-0.000000017346633510099197,0.000011357682110798667598,0.00},
	{0,3,0,2,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{0,3,1,0,-0.01796,-0.30,-0.000000000000000000000000,-0.000000028621945291663678,0.000002016784673880137213,0.00},
	{0,3,1,2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,2,0,-0.00095,-0.01,-0.000000000000000000000000,-0.000000002601995026514880,0.000000106146561783165128,0.00},
	{0,3,3,0,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,4,-2,0,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{0,4,-1,0,-0.00108,-0.04,-0.000000000000000000000000,-0.000000001734663351009920,0.000000162341800374252536,0.00},
	{0,4,0,0,-0.00128,0.06,-0.000000000000000000000000,0.000000000000000000000000,0.000000187317461970291369,0.00},
	{0,4,1,0,-0.00032,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000049951323192077706,0.00},
	{0,4,2,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,5,-1,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-4,0,0,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000018731746197029138,0.04},
	{1,-3,-2,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-3,-1,0,0.00020,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,0.08},
	{1,-3,0,0,0.00254,0.03,-0.000000000000000000000000,0.000000000000000000000000,-0.000000280976192955437093,0.99},
	{1,-3,1,0,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.03},
	{1,-3,2,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-2,-3,0,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{1,-2,-2,0,0.00025,0.00,-0.000000000000000000000000,0.000000000867331675504960,-0.000000018731746197029138,0.10},
	{1,-2,-1,-2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{1,-2,-1,0,0.00229,0.06,-0.000000000000000000000000,0.000000004336658377524799,-0.000000168585715773262251,0.89},
	{1,-2,0,-2,-0.00032,0.00,0.000000003910507151829517,0.000000000000000000000000,0.000000024975661596038853,-0.12},
	{1,-2,0,0,0.04304,-0.01,-0.000000000000000000000000,0.000000005203990053029759,-0.000003209372515090992159,16.74},
	{1,-2,0,2,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{1,-2,1,-2,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{1,-2,1,0,-0.00033,-0.16,-0.000000000000000000000000,-0.000000000867331675504960,0.000000024975661596038853,-0.13},
	{1,-2,2,0,-0.00037,-0.03,-0.000000000000000000000000,-0.000000001734663351009920,0.000000024975661596038853,-0.14},
	{1,-2,3,0,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{1,-1,-5,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-1,-4,0,0.00014,0.00,-0.000000000000000000000000,0.000000000867331675504960,-0.000000000000000000000000,0.05},
	{1,-1,-3,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-1,-3,0,0.00069,0.02,-0.000000000000000000000000,0.000000003469326702019840,-0.000000024975661596038853,0.27},
	{1,-1,-3,2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-1,-2,-2,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.04},
	{1,-1,-2,0,-0.00694,-0.25,-0.000000000000000000000000,-0.000000019948628536614079,0.000000262244446758407922,-2.70},
	{1,-1,-2,2,0.00013,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.05},
	{1,-1,-1,-2,-0.00100,0.00,0.000000015642028607318068,-0.000000001734663351009920,0.000000037463492394058276,-0.39},
	{1,-1,-1,0,-0.13636,-3.24,-0.000000074299635884760823,-0.000000209026933796695346,0.000005101278880990935603,-53.02},
	{1,-1,-1,2,0.00013,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.05},
	{1,-1,0,-4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-1,0,-2,-0.01281,-0.13,0.000000222898907654282444,0.000000000000000000000000,0.000000480781485723747919,-4.98},
	{1,-1,0,0,-0.55694,-40.23,-0.000000664786215811017894,-0.000000000867331675504960,0.000020992043571470651858,-216.55},
	{1,-1,0,2,0.00155,0.09,-0.000000027373550062806622,0.000000000000000000000000,-0.000000056195238591087415,0.60},
	{1,-1,1,-2,-0.00212,-0.02,0.000000035194564366465653,-0.000000003469326702019840,0.000000081170900187126268,-0.83},
	{1,-1,1,0,-0.12073,-6.32,-0.000000097762678795737926,-0.000000206424938770180441,0.000004514350833484022769,-46.94},
	{1,-1,1,2,0.00060,0.03,-0.000000011731521455488551,0.000000000867331675504960,-0.000000024975661596038853,0.23},
	{1,-1,2,-2,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.05},
	{1,-1,2,0,-0.01483,-0.72,-0.000000011731521455488551,-0.000000048570573828277757,0.000000555708470511864498,-5.77},
	{1,-1,2,2,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.05},
	{1,-1,3,-2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-1,3,0,-0.00149,-0.07,-0.000000000000000000000000,-0.000000006938653404039679,0.000000056195238591087415,-0.58},
	{1,-1,3,2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-1,4,0,-0.00014,0.00,-0.000000000000000000000000,-0.000000000867331675504960,-0.000000000000000000000000,-0.05},
	{1,-1,5,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,0,-6,0,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{1,0,-5,-2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,0,-5,0,-0.00072,-0.02,-0.000000000000000000000000,-0.000000005203990053029759,-0.000000000000000000000000,-0.28},
	{1,0,-4,-2,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.04},
	{1,0,-4,0,-0.00955,-0.28,-0.000000003910507151829517,-0.000000060713217285347191,-0.000000000000000000000000,-3.71},
	{1,0,-4,2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,0,-3,-2,0.00069,0.02,-0.000000011731521455488551,0.000000003469326702019840,-0.000000000000000000000000,0.27},
	{1,0,-3,0,-0.12812,-3.66,-0.000000050836592973783721,-0.000000609734167879986787,0.000000031219576995048568,-49.82},
	{1,0,-3,2,0.00038,0.06,-0.000000007821014303659034,0.000000002601995026514880,-0.000000000000000000000000,0.14},
	{1,0,-2,-4,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,0,-2,-2,0.00289,0.14,-0.000000046926085821954204,0.000000009540648430554559,-0.000000000000000000000000,1.12},
	{1,0,-2,0,-1.75296,-48.87,-0.000000653054694355529290,-0.000005575208010145882413,0.000000318439685349495383,-681.60},
	{1,0,-2,2,-0.00142,0.05,0.000000027373550062806622,-0.000000004336658377524799,-0.000000000000000000000000,-0.55},
	{1,0,-1,-4,0.00019,0.00,-0.000000007821014303659034,0.000000000000000000000000,-0.000000000000000000000000,0.07},
	{1,0,-1,-2,-0.02379,0.12,0.000000426245279549417409,-0.000000036427930371208316,-0.000000000000000000000000,-9.25},
	{1,0,-1,0,-18.58467,-437.66,-0.000007394769024109616428,-0.000030053909887922363310,0.000000624391539900971283,-7226.22},
	{1,0,-1,2,0.01598,0.32,-0.000000269824993476236675,0.000000026019950265148796,-0.000000000000000000000000,6.21},
	{1,0,-1,4,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.04},
	{1,0,0,-4,0.00123,0.01,-0.000000043015578670124687,0.000000000000000000000000,-0.000000000000000000000000,0.48},
	{1,0,0,-2,-0.58332,-5.89,0.000010159497580453084699,-0.000000010407980106059518,-0.000000000000000000000000,-226.81},
	{1,0,0,0,-124.98806,-2831.88,-0.000053253286393614362938,-0.000007511092309872952068,0.000001673369326934603076,-48598.15},
	{1,0,0,2,0.25429,5.73,-0.000004344573445682593361,0.000000022550623563128957,-0.000000000000000000000000,98.87},
	{1,0,0,4,-0.00054,-0.01,0.000000019552535759147585,0.000000000000000000000000,-0.000000000000000000000000,-0.21},
	{1,0,1,-4,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.04},
	{1,0,1,-2,-0.04012,-0.22,0.000000703891287329313064,-0.000000062447880636357105,-0.000000000000000000000000,-15.60},
	{1,0,1,0,-8.45308,-187.78,-0.000003949612223347812300,-0.000013757615036859673343,-0.000000480781485723747919,-3286.75},
	{1,0,1,2,0.04450,0.98,-0.000000758638387454926303,0.000000072855860742416632,-0.000000000000000000000000,17.30},
	{1,0,1,4,-0.00015,0.00,0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,-0.06},
	{1,0,2,-2,-0.00077,0.03,0.000000011731521455488551,-0.000000002601995026514880,-0.000000000000000000000000,-0.30},
	{1,0,2,0,-0.58399,-12.36,-0.000000293288036387213777,-0.000001866497765686673606,-0.000000081170900187126268,-227.07},
	{1,0,2,2,0.00540,0.12,-0.000000093852171643908409,0.000000017346633510099197,-0.000000000000000000000000,2.10},
	{1,0,2,4,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{1,0,3,-2,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{1,0,3,0,-0.04074,-0.81,-0.000000023463042910977102,-0.000000194282295313111027,-0.000000012487830798019427,-15.84},
	{1,0,3,2,0.00056,0.01,-0.000000007821014303659034,0.000000002601995026514880,-0.000000000000000000000000,0.22},
	{1,0,4,0,-0.00285,-0.05,-0.000000000000000000000000,-0.000000018213965185604158,-0.000000000000000000000000,-1.11},
	{1,0,4,2,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{1,0,5,0,-0.00020,0.00,-0.000000000000000000000000,-0.000000001734663351009920,-0.000000000000000000000000,-0.08},
	{1,0,6,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,1,-5,0,0.00011,0.00,-0.000000000000000000000000,0.000000000867331675504960,-0.000000000000000000000000,0.04},
	{1,1,-4,-2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,1,-4,0,0.00155,0.02,-0.000000000000000000000000,0.000000009540648430554559,-0.000000056195238591087415,0.60},
	{1,1,-3,-2,-0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.05},
	{1,1,-3,0,0.02296,0.30,-0.000000000000000000000000,0.000000109283791113624941,-0.000000861660325063340292,8.93},
	{1,1,-3,2,-0.00006,0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{1,1,-2,-2,-0.00071,0.00,0.000000011731521455488551,-0.000000002601995026514880,0.000000024975661596038853,-0.27},
	{1,1,-2,0,0.34966,5.36,0.000000043015578670124687,0.000001112786539672863431,-0.000013081002760925347547,135.95},
	{1,1,-2,2,0.00063,0.00,-0.000000011731521455488551,0.000000001734663351009920,-0.000000024975661596038853,0.25},
	{1,1,-1,-2,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{1,1,-1,0,1.07773,9.38,0.000000449708322460394405,0.000001863895770660158596,-0.000040110912523238389550,418.88},
	{1,1,-1,2,0.00000,0.03,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,1,0,-2,0.00017,0.03,-0.000000000000000000000000,0.000000006071321728534720,-0.000000000000000000000000,0.07},
	{1,1,0,0,17.95512,6.59,0.000004551830324729558451,0.000001894252379302832237,-0.000670746367823219424506,6981.34},
	{1,1,0,2,-0.03587,0.00,0.000000617860129989063690,-0.000000004336658377524799,0.000001342441810787088105,-13.95},
	{1,1,0,4,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{1,1,1,-2,-0.00157,0.36,0.000000015642028607318068,-0.000000003469326702019840,0.000000043707407793067991,-0.56},
	{1,1,1,0,1.26186,1.83,0.000000351945643664656532,0.000002124962604987151533,-0.000047141561262523329692,490.64},
	{1,1,1,2,-0.00659,0.00,0.000000113404707403055980,-0.000000011275311781564479,0.000000243512700561378804,-2.56},
	{1,1,1,4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,1,2,-2,0.00028,0.03,-0.000000003910507151829517,0.000000000000000000000000,-0.000000012487830798019427,0.11},
	{1,1,2,0,0.09205,0.22,0.000000027373550062806622,0.000000300096759724716086,-0.000003440397384854351692,35.79},
	{1,1,2,2,-0.00084,0.00,0.000000015642028607318068,-0.000000002601995026514880,0.000000031219576995048568,-0.33},
	{1,1,3,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,1,3,0,0.00679,0.02,-0.000000000000000000000000,0.000000032958603669188474,-0.000000256000531359398233,2.64},
	{1,1,3,2,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.04},
	{1,1,4,0,0.00050,0.00,-0.000000000000000000000000,0.000000003469326702019840,-0.000000018731746197029138,0.20},
	{1,1,5,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{1,2,-4,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{1,2,-3,0,0.00038,0.02,-0.000000000000000000000000,0.000000001734663351009920,-0.000000031219576995048568,0.15},
	{1,2,-2,0,0.00361,0.16,-0.000000000000000000000000,0.000000011275311781564479,-0.000000268488362157417663,1.40},
	{1,2,-1,0,-0.00300,-0.18,-0.000000000000000000000000,-0.000000004336658377524799,0.000000224780954364349659,-1.16},
	{1,2,-1,2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,2,0,-2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.01},
	{1,2,0,0,-0.03968,-0.61,-0.000000015642028607318068,-0.000000006071321728534720,0.000002965859814529613673,-15.43},
	{1,2,0,2,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.04},
	{1,2,1,-2,0.00002,-0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,2,1,0,-0.00849,-0.16,-0.000000000000000000000000,-0.000000014744638483584319,0.000000636879370698990766,-3.30},
	{1,2,1,2,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{1,2,2,0,-0.00102,-0.02,-0.000000000000000000000000,-0.000000003469326702019840,0.000000074926984788116553,-0.40},
	{1,2,2,2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,2,3,0,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,-0.04},
	{1,2,4,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,3,-2,0,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.03},
	{1,3,-1,0,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.04},
	{1,3,0,-2,0.00000,0.02,0.000000003910507151829517,0.000000000867331675504960,-0.000000012487830798019427,0.00},
	{1,3,0,0,-0.00056,-0.01,-0.000000000000000000000000,0.000000000000000000000000,0.000000062439153990097136,-0.22},
	{1,3,1,0,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.03},
	{1,4,0,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-6,0,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-5,-2,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-5,-1,0,0.00027,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000049951323192077706,0.00},
	{2,-5,0,0,0.00050,0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000093658730985145685,0.00},
	{2,-5,1,0,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{2,-4,-3,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-4,-2,0,0.00032,0.01,-0.000000000000000000000000,0.000000000867331675504960,-0.000000049951323192077706,0.00},
	{2,-4,-1,0,0.00812,0.24,-0.000000000000000000000000,0.000000013009975132574398,-0.000001211319587407884223,0.00},
	{2,-4,-1,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-4,0,-2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-4,0,0,0.01331,0.58,-0.000000000000000000000000,0.000000001734663351009920,-0.000001985565096885088983,0.00},
	{2,-4,0,2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-4,1,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-4,1,0,0.00133,0.06,-0.000000000000000000000000,0.000000002601995026514880,-0.000000199805292768310825,0.00},
	{2,-4,2,0,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000018731746197029138,0.00},
	{2,-4,3,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,-4,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,-3,0,0.00049,0.01,-0.000000000000000000000000,0.000000002601995026514880,-0.000000056195238591087415,0.00},
	{2,-3,-2,-2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,-2,0,0.00965,0.26,-0.000000000000000000000000,0.000000030356608642673595,-0.000001080197364028680342,0.00},
	{2,-3,-2,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,-1,-2,-0.00021,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000024975661596038853,0.00},
	{2,-3,-1,0,0.24697,6.33,0.000000011731521455488551,0.000000392033917328241803,-0.000027673033048411047752,0.00},
	{2,-3,-1,2,-0.00052,-0.01,0.000000007821014303659034,0.000000000000000000000000,0.000000056195238591087415,0.00},
	{2,-3,0,-2,0.00163,0.00,-0.000000027373550062806622,0.000000000000000000000000,-0.000000181073546571281654,0.00},
	{2,-3,0,0,0.33983,13.41,0.000000046926085821954204,0.000000064182543987367033,-0.000038075396103161227295,0.00},
	{2,-3,0,2,-0.00075,-0.03,0.000000011731521455488551,0.000000000000000000000000,0.000000081170900187126268,0.00},
	{2,-3,1,-2,-0.00065,-0.02,0.000000011731521455488551,-0.000000000867331675504960,0.000000074926984788116553,0.00},
	{2,-3,1,0,0.03300,1.42,0.000000007821014303659034,0.000000058111222258832313,-0.000003696397916213749978,0.00},
	{2,-3,1,2,-0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000018731746197029138,0.00},
	{2,-3,2,-2,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{2,-3,2,0,0.00295,0.14,-0.000000000000000000000000,0.000000009540648430554559,-0.000000330927516147514813,0.00},
	{2,-3,2,2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,3,0,0.00026,0.01,-0.000000000000000000000000,0.000000000867331675504960,-0.000000031219576995048568,0.00},
	{2,-3,4,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,-5,0,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,-4,-2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,-4,0,0.00088,0.01,-0.000000000000000000000000,0.000000005203990053029759,-0.000000062439153990097136,0.00},
	{2,-2,-3,-2,-0.00013,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{2,-2,-3,0,0.01544,0.29,-0.000000000000000000000000,0.000000072855860742416632,-0.000001155124348816797027,0.00},
	{2,-2,-2,-2,-0.00111,-0.03,0.000000019552535759147585,-0.000000003469326702019840,0.000000081170900187126268,0.00},
	{2,-2,-2,0,0.29422,6.88,0.000000011731521455488551,0.000000930646887816822004,-0.000021984826119913198467,0.00},
	{2,-2,-2,2,-0.00072,0.00,0.000000011731521455488551,-0.000000002601995026514880,0.000000056195238591087415,0.00},
	{2,-2,-1,-2,-0.00434,-0.20,0.000000074299635884760823,-0.000000006938653404039679,0.000000324683600748505071,0.00},
	{2,-2,-1,0,7.37173,165.38,0.000000414513758093928805,0.000011690763654131353235,-0.000550644655123267573460,-0.04},
	{2,-2,-1,2,-0.01541,-0.33,0.000000269824993476236675,-0.000000025152618589643836,0.000001148880433417787127,0.00},
	{2,-2,-1,4,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,0,-4,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,0,-2,0.06314,0.43,-0.000001102763016815923695,-0.000000003469326702019840,-0.000004714156126252332800,0.00},
	{2,-2,0,0,8.05076,289.14,0.000001227899245674468451,0.000001829202503639960360,-0.000601232857686044195288,-0.06},
	{2,-2,0,2,-0.01816,-0.62,0.000000316751079298190879,-0.000000010407980106059518,0.000001354929641585107694,0.00},
	{2,-2,0,4,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,1,-4,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,1,-2,-0.01644,-0.38,0.000000289377529235384260,-0.000000026019950265148796,0.000001230051333604913500,0.00},
	{2,-2,1,0,0.75173,29.04,0.000000168151807528669232,0.000001341762102006172932,-0.000056132799437097321757,0.00},
	{2,-2,1,2,-0.00378,-0.14,0.000000066478621581101789,-0.000000007805985079544638,0.000000280976192955437093,0.00},
	{2,-2,1,4,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,2,-2,-0.00133,-0.03,0.000000023463042910977102,-0.000000004336658377524799,0.000000099902646384155413,0.00},
	{2,-2,2,0,0.06439,2.63,0.000000019552535759147585,0.000000216832918876239980,-0.000004807814857237479186,0.00},
	{2,-2,2,2,-0.00055,-0.02,0.000000007821014303659034,-0.000000001734663351009920,0.000000043707407793067991,0.00},
	{2,-2,3,-2,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{2,-2,3,0,0.00538,0.23,-0.000000000000000000000000,0.000000026887281940653757,-0.000000399610585536621651,0.00},
	{2,-2,3,2,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,4,0,0.00044,0.02,-0.000000000000000000000000,0.000000002601995026514880,-0.000000031219576995048568,0.00},
	{2,-2,5,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-6,0,0.00010,0.00,-0.000000000000000000000000,0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{2,-1,-5,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-5,0,0.00178,0.01,-0.000000000000000000000000,0.000000013877306808079359,-0.000000068683069389106838,0.00},
	{2,-1,-4,-2,-0.00036,0.00,0.000000007821014303659034,-0.000000002601995026514880,0.000000012487830798019427,0.00},
	{2,-1,-4,0,0.02949,0.41,-0.000000000000000000000000,0.000000186476310233566365,-0.000001105173025624719096,0.00},
	{2,-1,-4,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-3,-4,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-3,-2,-0.00365,-0.08,0.000000062568114429272272,-0.000000017346633510099197,0.000000137366138778213676,0.00},
	{2,-1,-3,0,0.47842,8.72,0.000000019552535759147585,0.000002268072331445469918,-0.000017876329787364808626,0.00},
	{2,-1,-3,2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-2,-4,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-2,-2,-0.02804,-0.74,0.000000488813393978689681,-0.000000089335162577010865,0.000001048977787033631688,0.00},
	{2,-1,-2,0,8.60582,187.04,0.000000445797815308564888,0.000027221204635723167425,-0.000321580374795197231844,0.02},
	{2,-1,-2,2,-0.02157,-0.21,0.000000379319193727463151,-0.000000068519202364891839,0.000000805465086472252990,0.00},
	{2,-1,-2,4,0.00012,0.00,-0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-1,-4,-0.00015,0.00,0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-1,-2,-0.06103,-3.57,0.000001063657945297628631,-0.000000105814464411605099,0.000002279029120638544976,0.00},
	{2,-1,-1,0,205.44315,4157.78,0.000012900763093885578091,0.000325373406743957149356,-0.007670475238052259711607,-0.13},
	{2,-1,-1,2,-0.42624,-8.30,0.000007433874095627912127,-0.000000687794018675433188,0.000015909496436676749768,0.00},
	{2,-1,-1,4,0.00093,0.02,-0.000000031284057214636136,0.000000001734663351009920,-0.000000037463492394058276,0.00},
	{2,-1,0,-4,-0.00286,-0.02,0.000000101673185947567443,0.000000000000000000000000,0.000000106146561783165128,0.00},
	{2,-1,0,-2,2.14619,18.77,-0.000037466569021678602024,-0.000000072855860742416632,-0.000080059483246102531011,0.05},
	{2,-1,0,0,164.73458,5378.28,0.000030279056876615951534,0.000047331156863981166546,-0.006146603977516146635751,-0.18},
	{2,-1,0,2,-0.38215,-11.75,0.000006624399115199202580,-0.000000268872819406537546,0.000014261102771338183539,0.00},
	{2,-1,0,4,0.00089,0.03,-0.000000031284057214636136,0.000000000867331675504960,-0.000000031219576995048568,0.00},
	{2,-1,1,-4,0.00018,0.00,-0.000000007821014303659034,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{2,-1,1,-2,-0.37453,-6.50,0.000006604846579440054306,-0.000000599326187773927273,0.000013961394832185716798,0.00},
	{2,-1,1,0,14.53078,497.46,0.000003668055708416087074,0.000026648765729889892191,-0.000541965612718644097583,0.00},
	{2,-1,1,2,-0.07373,-2.45,0.000001274825331496422444,-0.000000153517706564377898,0.000002747322775564273941,0.00},
	{2,-1,1,4,0.00025,0.00,-0.000000007821014303659034,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{2,-1,2,-4,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,2,-2,-0.02887,-0.54,0.000000508365929737837213,-0.000000091937157603525757,0.000001073953448629670653,0.00},
	{2,-1,2,0,1.17704,41.72,0.000000375408686575633634,0.000004009674335859428943,-0.000043882237424240259178,0.00},
	{2,-1,2,2,-0.01007,-0.35,0.000000172062314680498749,-0.000000036427930371208316,0.000000374634923940582738,0.00},
	{2,-1,2,4,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,3,-2,-0.00232,-0.05,0.000000039105071518295170,-0.000000011275311781564479,0.000000087414815586135983,0.00},
	{2,-1,3,0,0.09320,3.39,0.000000035194564366465653,0.000000464889778070658500,-0.000003471616961849399922,0.00},
	{2,-1,3,2,-0.00117,-0.04,0.000000019552535759147585,-0.000000006071321728534720,0.000000043707407793067991,0.00},
	{2,-1,4,-2,-0.00019,0.00,-0.000000000000000000000000,-0.000000000867331675504960,0.000000006243915399009713,0.00},
	{2,-1,4,0,0.00730,0.27,-0.000000000000000000000000,0.000000047703242152772799,-0.000000274732277556427352,0.00},
	{2,-1,4,2,-0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,5,-2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,5,0,0.00057,0.02,-0.000000000000000000000000,0.000000004336658377524799,-0.000000018731746197029138,0.00},
	{2,-1,5,2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,6,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-8,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-7,0,0.00036,0.00,-0.000000000000000000000000,0.000000004336658377524799,-0.000000000000000000000000,0.00},
	{2,0,-6,-2,-0.00011,0.00,-0.000000000000000000000000,-0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{2,0,-6,0,0.00497,0.10,-0.000000000000000000000000,0.000000046835910477267836,-0.000000000000000000000000,0.00},
	{2,0,-5,-2,-0.00111,-0.02,0.000000019552535759147585,-0.000000008673316755049599,-0.000000000000000000000000,0.00},
	{2,0,-5,0,0.06850,1.40,0.000000011731521455488551,0.000000541214965515095001,-0.000000000000000000000000,0.00},
	{2,0,-5,2,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-4,-4,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-4,-2,-0.01077,-0.24,0.000000187704343287816817,-0.000000068519202364891839,-0.000000000000000000000000,0.00},
	{2,0,-4,0,0.94827,19.71,0.000000117315214554885511,0.000005994129209414777949,-0.000000037463492394058276,0.00},
	{2,0,-4,2,-0.00054,0.00,0.000000011731521455488551,-0.000000003469326702019840,-0.000000000000000000000000,0.00},
	{2,0,-3,-4,0.00024,0.00,-0.000000007821014303659034,0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{2,0,-3,-2,-0.09154,-2.11,0.000001595486917946442946,-0.000000436267832778994813,-0.000000000000000000000000,0.00},
	{2,0,-3,0,13.19400,279.87,0.000001247451781433615878,0.000062559766422497253054,-0.000000405854500935631339,0.14},
	{2,0,-3,2,0.00467,0.38,-0.000000078210143036590340,0.000000020815960212119036,-0.000000000000000000000000,0.00},
	{2,0,-3,4,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-2,-4,0.00037,0.03,-0.000000011731521455488551,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{2,0,-2,-2,-0.56065,-14.54,0.000009772357372421962778,-0.000001794509236619762124,0.000000006243915399009713,0.00},
	{2,0,-2,0,211.65487,4685.54,0.000016447593080594950191,0.000669201896879308903536,-0.000004907717503621634201,2.12},
	{2,0,-2,2,-0.53572,-4.50,0.000009432143250212795697,-0.000001691296767234671784,-0.000000024975661596038853,-0.01},
	{2,0,-2,4,0.00282,0.02,-0.000000097762678795737926,0.000000008673316755049599,-0.000000000000000000000000,0.00},
	{2,0,-1,-6,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-1,-4,-0.00850,0.00,0.000000297198543539043294,-0.000000012142643457069439,-0.000000000000000000000000,0.00},
	{2,0,-1,-2,0.17903,-34.06,-0.000003120584707159954903,0.000000087600499226000951,-0.000000018731746197029138,0.18},
	{2,0,-1,0,4586.43061,87132.46,0.000329311628269867275130,0.007249694154845915707031,0.000119364930682868666725,20.31},
	{2,0,-1,2,-9.36601,-173.58,0.000163326241703311622741,-0.000015065551203521152619,-0.000000299707939152466212,-0.06},
	{2,0,-1,4,0.01993,0.36,-0.000000696070273025654030,0.000000033825935344693438,-0.000000000000000000000000,0.00},
	{2,0,-1,6,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,0,-6,0.00015,0.00,-0.000000007821014303659034,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,0,-4,-0.07518,-0.70,0.000002627860806029435440,0.000000005203990053029759,-0.000000000000000000000000,0.00},
	{2,0,0,-2,55.17801,530.97,-0.000963372989388960724623,-0.000001331354121900113313,0.000004345765117710760121,1.20},
	{2,0,0,0,2369.91227,69551.14,0.000575822178106896341229,0.000938198744715443614349,0.000159444623629112041925,22.07},
	{2,0,0,2,-5.74170,-155.85,0.000099326881656469731986,-0.000005184041424493145297,-0.000000399610585536621651,-0.10},
	{2,0,0,4,0.01372,0.35,-0.000000477081872523201077,0.000000018213965185604158,-0.000000000000000000000000,0.00},
	{2,0,0,6,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,1,-6,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,1,-4,0.00056,0.10,-0.000000019552535759147585,0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{2,0,1,-2,-6.38325,-72.70,0.000112822041837433391159,-0.000010188545192156763330,-0.000000724294186285126616,0.00},
	{2,0,1,0,191.95575,5619.27,0.000059865953987358080620,0.000368663665331760744947,0.000018794185351019238126,2.78},
	{2,0,1,2,-0.99023,-27.73,0.000017088916253494991195,-0.000002196951134054063016,-0.000000099902646384155413,-0.02},
	{2,0,1,4,0.00344,0.09,-0.000000121225721706715028,0.000000008673316755049599,-0.000000000000000000000000,0.00},
	{2,0,1,6,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,2,-4,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,2,-2,-0.45380,-4.94,0.000008024360675554169145,-0.000001442372576364748261,-0.000000062439153990097136,0.00},
	{2,0,2,0,14.37964,417.80,0.000005361305305158267999,0.000050085802265384922276,0.000001923125942894991674,0.28},
	{2,0,2,2,-0.12386,-3.49,0.000002131226397747086831,-0.000000457951124666618843,-0.000000018731746197029138,0.00},
	{2,0,2,4,0.00059,0.02,-0.000000019552535759147585,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{2,0,3,-4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,3,-2,-0.03336,-0.35,0.000000590486579926257124,-0.000000158721696617407655,-0.000000000000000000000000,0.00},
	{2,0,3,0,1.05949,30.46,0.000000453618829612223922,0.000005354905764567622524,0.000000187317461970291369,0.03},
	{2,0,3,2,-0.01332,-0.37,0.000000230719921957941504,-0.000000069386534040396790,-0.000000000000000000000000,0.00},
	{2,0,3,4,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,4,-2,-0.00247,-0.03,0.000000043015578670124687,-0.000000015611970159089276,-0.000000000000000000000000,0.00},
	{2,0,4,0,0.07765,2.20,0.000000039105071518295170,0.000000514327683574441161,0.000000018731746197029138,0.00},
	{2,0,4,2,-0.00131,-0.04,0.000000023463042910977102,-0.000000008673316755049599,-0.000000000000000000000000,0.00},
	{2,0,4,4,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,5,-2,-0.00018,0.00,-0.000000000000000000000000,-0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{2,0,5,0,0.00568,0.16,-0.000000000000000000000000,0.000000046835910477267836,-0.000000000000000000000000,0.00},
	{2,0,5,2,-0.00012,0.00,-0.000000000000000000000000,-0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{2,0,6,-2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,6,0,0.00041,0.01,-0.000000000000000000000000,0.000000004336658377524799,-0.000000000000000000000000,0.00},
	{2,0,6,2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,7,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-7,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-6,0,0.00015,0.01,-0.000000000000000000000000,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{2,1,-5,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-5,0,0.00173,0.12,-0.000000000000000000000000,0.000000013877306808079359,-0.000000062439153990097136,0.00},
	{2,1,-4,-2,-0.00020,-0.02,-0.000000000000000000000000,-0.000000000867331675504960,0.000000006243915399009713,0.00},
	{2,1,-4,0,0.01819,1.37,0.000000007821014303659034,0.000000114487781166654711,-0.000000686830693891068485,0.00},
	{2,1,-4,2,-0.00003,0.04,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{2,1,-3,-2,-0.00116,-0.10,0.000000019552535759147585,-0.000000005203990053029759,0.000000043707407793067991,0.00},
	{2,1,-3,0,0.17624,15.80,0.000000089941664492078892,0.000000831771076809256471,-0.000006637282069147325321,0.05},
	{2,1,-3,2,-0.00024,0.00,0.000000003910507151829517,-0.000000001734663351009920,0.000000012487830798019427,0.00},
	{2,1,-2,-4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-2,-2,-0.00346,-0.43,0.000000058657607277442755,-0.000000011275311781564479,0.000000131122223379203961,0.00},
	{2,1,-2,0,2.48897,257.30,0.000001454708660480580333,0.000007780832460954993770,-0.000093777365377726873983,0.26},
	{2,1,-2,2,-0.00001,-0.34,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-1,-4,0.00017,0.00,-0.000000007821014303659034,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{2,1,-1,-2,-0.00228,0.76,0.000000043015578670124687,-0.000000004336658377524799,0.000000081170900187126268,0.00},
	{2,1,-1,0,-28.39810,915.46,0.000006530546943555292901,-0.000045858427678973745067,0.001057282194514314694819,-0.38},
	{2,1,-1,2,0.06742,-1.63,-0.000001188794174156173175,0.000000111885786140139832,-0.000002510053990401904085,0.00},
	{2,1,-1,4,-0.00016,0.00,0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,0,-4,0.00198,0.03,-0.000000070389128732931306,0.000000000000000000000000,-0.000000074926984788116553,0.00},
	{2,1,0,-2,-1.43724,-23.32,0.000025070261350379033800,-0.000000013877306808079359,0.000053716404177680560246,-0.04},
	{2,1,0,0,-24.35910,-661.00,-0.000011391307333279381873,-0.000011107049436516516343,0.000910119352475054709493,-5.21},
	{2,1,0,2,0.06541,1.46,-0.000001118405045423241763,0.000000065049875662871984,-0.000002441370921012797724,0.03},
	{2,1,0,4,-0.00017,0.00,0.000000007821014303659034,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{2,1,1,-4,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,1,-2,0.08472,-0.38,-0.000001505545253454364107,0.000000137905736405288628,-0.000003153177276499904751,0.00},
	{2,1,1,0,-2.91464,-100.96,-0.000001665876046679374146,-0.000005735664370114299599,0.000108950079797320490251,-0.75},
	{2,1,1,2,0.01605,0.51,-0.000000273735500628066192,0.000000036427930371208316,-0.000000599415878304932423,0.00},
	{2,1,1,4,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,2,-2,0.00889,0.07,-0.000000156420286073180681,0.000000028621945291663678,-0.000000330927516147514813,0.00},
	{2,1,2,0,-0.29023,-11.13,-0.000000183793836135987300,-0.000001023451377095852725,0.000010851924963478880502,-0.08},
	{2,1,2,2,0.00262,0.10,-0.000000043015578670124687,0.000000009540648430554559,-0.000000099902646384155413,0.00},
	{2,1,2,4,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,3,-2,0.00085,0.01,-0.000000015642028607318068,0.000000004336658377524799,-0.000000031219576995048568,0.00},
	{2,1,3,0,-0.02676,-1.08,-0.000000019552535759147585,-0.000000136171073054278701,0.000000999026463841554180,0.00},
	{2,1,3,2,0.00035,0.01,-0.000000007821014303659034,0.000000001734663351009920,-0.000000012487830798019427,0.00},
	{2,1,4,-2,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,4,0,-0.00236,-0.10,-0.000000000000000000000000,-0.000000015611970159089276,0.000000087414815586135983,0.00},
	{2,1,4,2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,5,0,-0.00020,0.00,-0.000000000000000000000000,-0.000000001734663351009920,0.000000006243915399009713,0.00},
	{2,1,6,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-5,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-4,0,-0.00049,0.00,-0.000000000000000000000000,-0.000000003469326702019840,0.000000037463492394058276,0.00},
	{2,2,-3,-2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-3,0,-0.00944,-0.26,-0.000000000000000000000000,-0.000000045968578801762878,0.000000711806355487107239,0.00},
	{2,2,-3,2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-2,-2,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-2,0,-0.24990,-10.76,-0.000000043015578670124687,-0.000000797945141464563026,0.000018656819212241021168,-0.02},
	{2,2,-2,2,0.00060,0.02,-0.000000011731521455488551,0.000000001734663351009920,-0.000000043707407793067991,0.00},
	{2,2,-1,-4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-1,-2,-0.00654,-0.24,0.000000113404707403055980,-0.000000007805985079544638,0.000000487025401122757607,0.00},
	{2,2,-1,0,-2.52138,-84.66,-0.000000289377529235384260,-0.000003995797029051349734,0.000188647415950280442814,0.07},
	{2,2,-1,2,0.00515,0.17,-0.000000089941664492078892,0.000000008673316755049599,-0.000000387122754738602168,0.00},
	{2,2,-1,4,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,0,-4,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,0,-2,-0.02349,-0.29,0.000000351945643664656532,0.000000042499252099743030,0.000001717076734727671108,0.04},
	{2,2,0,0,-0.18576,-6.48,-0.000000129046736010374062,-0.000000568969579131253632,0.000013898955678195622031,0.39},
	{2,2,0,2,0.00096,0.03,-0.000000015642028607318068,0.000000002601995026514880,-0.000000068683069389106838,0.00},
	{2,2,1,-2,-0.00200,-0.12,0.000000027373550062806622,0.000000000000000000000000,0.000000143610054177223391,0.00},
	{2,2,1,0,-0.01343,-0.46,-0.000000011731521455488551,-0.000000061580548960852141,0.000001005270379240563868,0.06},
	{2,2,1,2,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{2,2,2,-2,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{2,2,2,0,-0.00066,-0.01,-0.000000000000000000000000,-0.000000005203990053029759,0.000000049951323192077706,0.00},
	{2,2,3,-2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,3,-3,0,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{2,3,-2,0,-0.00093,-0.06,-0.000000000000000000000000,-0.000000002601995026514880,0.000000106146561783165128,0.00},
	{2,3,-1,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,3,-1,0,-0.00188,-0.12,-0.000000000000000000000000,-0.000000002601995026514880,0.000000212293123566330255,0.00},
	{2,3,0,-2,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{2,3,0,0,0.00038,0.03,-0.000000000000000000000000,0.000000001734663351009920,-0.000000043707407793067991,0.00},
	{2,3,1,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,3,1,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,4,-2,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,4,-1,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-4,-1,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-4,0,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-3,-2,0,-0.00017,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000018731746197029138,-0.07},
	{3,-3,-1,0,-0.00053,-0.02,-0.000000000000000000000000,0.000000000000000000000000,0.000000056195238591087415,-0.21},
	{3,-3,0,-2,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,-3,0,0,0.00030,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000031219576995048568,0.12},
	{3,-3,1,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{3,-2,-3,0,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.06},
	{3,-2,-2,0,-0.00399,-0.10,-0.000000000000000000000000,-0.000000013009975132574398,0.000000299707939152466212,-1.55},
	{3,-2,-1,-2,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{3,-2,-1,0,-0.01182,-0.50,-0.000000000000000000000000,-0.000000019948628536614079,0.000000880392071260369463,-4.60},
	{3,-2,-1,2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{3,-2,0,-2,-0.00102,-0.02,0.000000019552535759147585,0.000000000000000000000000,0.000000074926984788116553,-0.40},
	{3,-2,0,0,0.00518,0.05,-0.000000000000000000000000,-0.000000004336658377524799,-0.000000387122754738602168,2.01},
	{3,-2,1,-2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,-2,1,0,0.00037,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,0.15},
	{3,-1,-4,0,-0.00013,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.05},
	{3,-1,-3,0,-0.00297,-0.06,-0.000000000000000000000000,-0.000000013877306808079359,0.000000112390477182174829,-1.16},
	{3,-1,-2,0,-0.08311,-1.91,-0.000000007821014303659034,-0.000000263668829353507790,0.000003109469868706837144,-32.32},
	{3,-1,-2,2,0.00020,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.08},
	{3,-1,-1,-2,-0.00189,-0.02,0.000000031284057214636136,-0.000000002601995026514880,0.000000068683069389106838,-0.73},
	{3,-1,-1,0,-0.23141,-9.24,-0.000000074299635884760823,-0.000000388564590626222053,0.000008604115419835384180,-89.98},
	{3,-1,-1,2,0.00075,0.03,-0.000000011731521455488551,0.000000001734663351009920,-0.000000031219576995048568,0.29},
	{3,-1,0,-4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-1,0,-2,-0.01948,-0.34,0.000000340214122209167981,0.000000000000000000000000,0.000000724294186285126616,-7.57},
	{3,-1,0,0,0.06507,-0.18,-0.000000062568114429272272,-0.000000090202494252515829,-0.000002453858751810817101,25.30},
	{3,-1,0,2,0.00020,0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.08},
	{3,-1,1,-2,-0.00084,0.00,0.000000015642028607318068,-0.000000000867331675504960,0.000000031219576995048568,-0.33},
	{3,-1,1,0,0.00330,-0.25,-0.000000011731521455488551,-0.000000004336658377524799,-0.000000131122223379203961,1.28},
	{3,-1,1,2,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{3,-1,2,-2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,-1,2,0,-0.00011,-0.05,-0.000000000000000000000000,-0.000000000867331675504960,-0.000000000000000000000000,-0.04},
	{3,-1,2,2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-1,3,0,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,0,-5,0,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,0,-4,-2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,0,-4,0,-0.00174,0.00,-0.000000000000000000000000,-0.000000011275311781564479,-0.000000000000000000000000,-0.68},
	{3,0,-3,-2,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.04},
	{3,0,-3,0,-0.04442,-0.91,-0.000000000000000000000000,-0.000000210761597147705273,0.000000018731746197029138,-17.27},
	{3,0,-3,2,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.04},
	{3,0,-2,-2,-0.00028,0.02,0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,-0.11},
	{3,0,-2,0,-1.22412,-28.10,-0.000000164241300376839715,-0.000003879574584533685188,0.000000093658730985145685,-475.97},
	{3,0,-2,2,0.00298,0.07,-0.000000050836592973783721,0.000000009540648430554559,-0.000000000000000000000000,1.16},
	{3,0,-2,4,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,0,-1,-4,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{3,0,-1,-2,-0.02979,-0.39,0.000000520097451193325817,-0.000000046835910477267836,-0.000000000000000000000000,-11.59},
	{3,0,-1,0,-3.20968,-121.62,-0.000001208346709915320602,-0.000005411282323475444367,-0.000001005270379240563868,-1248.01},
	{3,0,-1,2,0.01215,0.48,-0.000000207256879046964402,0.000000021683291887623997,-0.000000000000000000000000,4.72},
	{3,0,-1,4,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{3,0,0,-4,0.00025,0.00,-0.000000007821014303659034,0.000000000000000000000000,-0.000000000000000000000000,0.10},
	{3,0,0,-2,-0.25304,-3.60,0.000004407141560111865633,0.000000008673316755049599,-0.000000049951323192077706,-98.39},
	{3,0,0,0,0.40423,-12.92,-0.000000891595630617129776,-0.000001229008984190528189,-0.000000655611116896019831,157.17},
	{3,0,0,2,0.00375,0.24,-0.000000062568114429272272,0.000000009540648430554559,-0.000000000000000000000000,1.46},
	{3,0,0,4,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,0,1,-4,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{3,0,1,-2,-0.01062,-0.05,0.000000183793836135987300,-0.000000015611970159089276,-0.000000000000000000000000,-4.13},
	{3,0,1,0,0.00037,-3.59,-0.000000140778257465862613,-0.000000117957107868674553,-0.000000112390477182174829,0.14},
	{3,0,1,2,0.00083,0.06,-0.000000011731521455488551,0.000000002601995026514880,-0.000000000000000000000000,0.32},
	{3,0,2,-2,-0.00051,0.00,0.000000007821014303659034,-0.000000001734663351009920,-0.000000000000000000000000,-0.20},
	{3,0,2,0,-0.00389,-0.50,-0.000000015642028607318068,-0.000000022550623563128957,-0.000000012487830798019427,-1.51},
	{3,0,2,2,0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.05},
	{3,0,3,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,0,3,0,-0.00062,-0.05,-0.000000000000000000000000,-0.000000003469326702019840,-0.000000000000000000000000,-0.24},
	{3,0,3,2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,0,4,0,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{3,1,-5,0,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,1,-4,0,-0.00059,-0.02,-0.000000000000000000000000,-0.000000003469326702019840,0.000000024975661596038853,-0.23},
	{3,1,-3,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,1,-3,0,-0.00623,-0.30,-0.000000000000000000000000,-0.000000029489276967168638,0.000000231024869763359374,-2.42},
	{3,1,-3,2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,1,-2,-2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,1,-2,0,-0.04189,-2.51,-0.000000007821014303659034,-0.000000130099751325743967,0.000001573466680550447637,-16.29},
	{3,1,-2,2,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{3,1,-1,-2,0.00116,0.02,-0.000000019552535759147585,0.000000001734663351009920,-0.000000043707407793067991,0.45},
	{3,1,-1,0,0.27377,5.06,0.000000093852171643908409,0.000000452747134613589033,-0.000010215045592779890159,106.45},
	{3,1,-1,2,-0.00138,-0.02,0.000000023463042910977102,-0.000000002601995026514880,0.000000049951323192077706,-0.53},
	{3,1,0,-2,0.00891,0.14,-0.000000156420286073180681,-0.000000000867331675504960,-0.000000330927516147514813,3.46},
	{3,1,0,0,0.14990,4.45,0.000000105583693099396973,0.000000139640399756298556,-0.000005588304282113692575,58.29},
	{3,1,0,2,-0.00096,-0.03,0.000000015642028607318068,-0.000000000867331675504960,0.000000037463492394058276,-0.37},
	{3,1,1,-2,0.00020,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.08},
	{3,1,1,0,0.02244,0.70,0.000000015642028607318068,0.000000051172568854792628,-0.000000836684663467301538,8.73},
	{3,1,1,2,-0.00022,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,-0.09},
	{3,1,2,-2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,1,2,0,0.00256,0.08,-0.000000000000000000000000,0.000000009540648430554559,-0.000000093658730985145685,1.00},
	{3,1,2,2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{3,1,3,0,0.00026,0.00,-0.000000000000000000000000,0.000000001734663351009920,-0.000000012487830798019427,0.10},
	{3,1,4,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,2,-4,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,2,-3,0,-0.00020,0.00,-0.000000000000000000000000,-0.000000000867331675504960,0.000000012487830798019427,-0.08},
	{3,2,-2,0,-0.00036,-0.06,-0.000000000000000000000000,-0.000000000867331675504960,0.000000024975661596038853,-0.14},
	{3,2,-1,-2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,2,-1,0,-0.00127,0.07,-0.000000000000000000000000,-0.000000002601995026514880,0.000000093658730985145685,-0.49},
	{3,2,0,-2,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.04},
	{3,2,0,0,-0.00191,-0.05,-0.000000000000000000000000,-0.000000001734663351009920,0.000000143610054177223391,-0.74},
	{3,2,0,2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,2,1,0,-0.00039,-0.01,-0.000000000000000000000000,0.000000000000000000000000,0.000000031219576995048568,-0.15},
	{3,2,2,0,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,3,-3,0,0.00000,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.03},
	{3,3,-2,-2,0.00000,-0.03,-0.000000003910507151829517,-0.000000002601995026514880,-0.000000000000000000000000,-0.08},
	{3,3,-2,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{3,3,-1,0,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.05},
	{3,3,0,-2,-0.00002,-0.09,-0.000000027373550062806622,-0.000000006938653404039679,0.000000049951323192077706,0.05},
	{3,3,0,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-5,-2,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-5,-1,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{4,-5,0,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-4,-3,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-4,-2,0,0.00033,0.02,-0.000000000000000000000000,0.000000000867331675504960,-0.000000049951323192077706,0.00},
	{4,-4,-1,0,0.00086,0.05,-0.000000000000000000000000,0.000000001734663351009920,-0.000000131122223379203961,0.00},
	{4,-4,0,0,0.00054,0.04,-0.000000000000000000000000,0.000000000000000000000000,-0.000000081170900187126268,0.00},
	{4,-4,1,0,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{4,-4,2,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-3,-3,0,0.00027,0.01,-0.000000000000000000000000,0.000000000867331675504960,-0.000000031219576995048568,0.00},
	{4,-3,-2,0,0.00755,0.33,-0.000000000000000000000000,0.000000024285286914138878,-0.000000842928578866311333,0.00},
	{4,-3,-2,2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-3,-1,-2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-3,-1,0,0.01741,0.97,0.000000003910507151829517,0.000000031223940318178553,-0.000001948101604491030428,0.00},
	{4,-3,-1,2,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{4,-3,0,-2,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{4,-3,0,0,0.00971,0.65,-0.000000000000000000000000,0.000000009540648430554559,-0.000001086441279427690030,0.00},
	{4,-3,0,2,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-3,1,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-3,1,0,0.00160,0.11,-0.000000000000000000000000,0.000000003469326702019840,-0.000000181073546571281654,0.00},
	{4,-3,1,2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-3,2,0,0.00020,0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,0.00},
	{4,-3,3,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-5,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-4,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-3,0,0.00560,0.27,-0.000000000000000000000000,0.000000026887281940653757,-0.000000418342331733650769,0.00},
	{4,-2,-3,2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-2,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-2,0,0.15781,6.46,0.000000023463042910977102,0.000000500450376766361846,-0.000011782268357931328955,0.00},
	{4,-2,-2,2,-0.00090,-0.04,0.000000015642028607318068,-0.000000002601995026514880,0.000000068683069389106838,0.00},
	{4,-2,-1,-2,0.00108,0.00,-0.000000019552535759147585,0.000000001734663351009920,-0.000000081170900187126268,0.00},
	{4,-2,-1,0,0.30874,16.37,0.000000089941664492078892,0.000000562898257402718924,-0.000023040047822345838149,0.00},
	{4,-2,-1,2,-0.00160,-0.08,0.000000027373550062806622,-0.000000003469326702019840,0.000000118634392581184544,0.00},
	{4,-2,0,-2,0.00091,0.07,-0.000000015642028607318068,-0.000000001734663351009920,-0.000000068683069389106838,0.00},
	{4,-2,0,0,0.15227,9.62,0.000000066478621581101789,0.000000163058354994932434,-0.000011357682110798667598,0.01},
	{4,-2,0,2,-0.00089,-0.05,0.000000015642028607318068,-0.000000001734663351009920,0.000000068683069389106838,0.00},
	{4,-2,1,-2,-0.00052,-0.02,0.000000007821014303659034,-0.000000000867331675504960,0.000000037463492394058276,0.00},
	{4,-2,1,0,0.02411,1.58,0.000000011731521455488551,0.000000057243890583327355,-0.000001798247634914797269,0.00},
	{4,-2,1,2,-0.00021,-0.01,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{4,-2,2,-2,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{4,-2,2,0,0.00290,0.20,-0.000000000000000000000000,0.000000011275311781564479,-0.000000218537038965339944,0.00},
	{4,-2,2,2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,3,-2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,3,0,0.00031,0.02,-0.000000000000000000000000,0.000000001734663351009920,-0.000000024975661596038853,0.00},
	{4,-2,4,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-6,0,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-5,0,-0.00034,-0.01,-0.000000000000000000000000,-0.000000002601995026514880,0.000000012487830798019427,0.00},
	{4,-1,-4,-2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-4,0,-0.00020,0.00,-0.000000000000000000000000,-0.000000000867331675504960,0.000000006243915399009713,0.00},
	{4,-1,-3,-2,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-3,0,0.09982,4.58,0.000000015642028607318068,0.000000473563094825708059,-0.000003733861408607808533,0.02},
	{4,-1,-3,2,-0.00078,-0.03,0.000000015642028607318068,-0.000000003469326702019840,0.000000031219576995048568,0.00},
	{4,-1,-2,-4,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-2,-2,0.00043,0.00,-0.000000007821014303659034,0.000000001734663351009920,-0.000000018731746197029138,0.00},
	{4,-1,-2,0,2.73198,106.73,0.000000406692743790269770,0.000008658572116566015005,-0.000101900699311838508973,0.11},
	{4,-1,-2,2,-0.01533,-0.59,0.000000265914486324407158,-0.000000049437905503782707,0.000000574440216708893563,0.00},
	{4,-1,-2,4,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-1,-4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-1,-2,0.02289,0.27,-0.000000398871729486610736,0.000000035560598695703352,-0.000000849172494265321021,0.02},
	{4,-1,-1,0,4.37416,221.00,0.000001450798153328750763,0.000008141642437965058304,-0.000162959947998754511997,-0.05},
	{4,-1,-1,2,-0.02273,-1.12,0.000000391050715182951702,-0.000000048570573828277757,0.000000849172494265321021,0.00},
	{4,-1,-1,4,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,0,-4,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,0,-2,0.00666,0.75,-0.000000101673185947567443,-0.000000023417955238633918,-0.000000243512700561378804,0.02},
	{4,-1,0,0,1.87083,111.80,0.000000918969180679936554,0.000002224705747670221859,-0.000069613412783559285978,0.16},
	{4,-1,0,2,-0.01114,-0.64,0.000000191614850439646334,-0.000000019948628536614079,0.000000412098416334641081,0.00},
	{4,-1,0,4,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,1,-4,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,1,-2,-0.00732,-0.28,0.000000129046736010374062,-0.000000015611970159089276,0.000000274732277556427352,0.00},
	{4,-1,1,0,0.28251,17.39,0.000000164241300376839715,0.000000698201998781492807,-0.000010502265701134337947,0.02},
	{4,-1,1,2,-0.00251,-0.15,0.000000043015578670124687,-0.000000006938653404039679,0.000000093658730985145685,0.00},
	{4,-1,1,4,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,2,-2,-0.00121,-0.05,0.000000019552535759147585,-0.000000004336658377524799,0.000000043707407793067991,0.00},
	{4,-1,2,0,0.03274,2.05,0.000000023463042910977102,0.000000129232419650239016,-0.000001217563502806893912,0.00},
	{4,-1,2,2,-0.00041,-0.03,0.000000007821014303659034,-0.000000001734663351009920,0.000000012487830798019427,0.00},
	{4,-1,3,-2,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,3,0,0.00336,0.21,-0.000000000000000000000000,0.000000018213965185604158,-0.000000124878307980194272,0.00},
	{4,-1,3,2,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,4,-2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,4,0,0.00032,0.02,-0.000000000000000000000000,0.000000002601995026514880,-0.000000012487830798019427,0.00},
	{4,-1,5,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-7,0,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-6,-2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-6,0,-0.00062,-0.03,-0.000000000000000000000000,-0.000000006071321728534720,-0.000000000000000000000000,0.00},
	{4,0,-5,-2,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-5,0,-0.00431,-0.18,-0.000000000000000000000000,-0.000000033825935344693438,-0.000000000000000000000000,0.00},
	{4,0,-4,-2,0.00042,0.02,-0.000000007821014303659034,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{4,0,-4,0,-0.00070,0.03,-0.000000000000000000000000,-0.000000004336658377524799,-0.000000000000000000000000,0.00},
	{4,0,-4,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-3,-4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-3,-2,0.00023,0.02,-0.000000003910507151829517,0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{4,0,-3,0,1.18682,52.89,0.000000195525357591475851,0.000005627247910676179238,-0.000000137366138778213676,0.25},
	{4,0,-3,2,-0.00934,-0.29,0.000000164241300376839715,-0.000000044233915450752957,-0.000000000000000000000000,0.00},
	{4,0,-3,4,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-2,-4,0.00013,0.00,-0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-2,-2,0.00662,0.09,-0.000000113404707403055980,0.000000020815960212119036,-0.000000000000000000000000,0.00},
	{4,0,-2,0,30.77247,1164.74,0.000004856849882572259826,0.000097431703767849656942,0.000002653664044579127979,1.18},
	{4,0,-2,2,-0.16977,-6.36,0.000002948522392479455942,-0.000000542949628866104902,-0.000000018731746197029138,0.00},
	{4,0,-2,4,0.00061,0.02,-0.000000019552535759147585,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{4,0,-1,-4,0.00017,0.01,-0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-1,-2,0.30086,5.06,-0.000005228348061996064314,0.000000467491773097173352,0.000000118634392581184544,0.15},
	{4,0,-1,0,38.42974,1853.28,0.000014805180076826551135,0.000073703243789384969382,0.000006144012752625557179,0.08},
	{4,0,-1,2,-0.20134,-9.45,0.000003460798829369122407,-0.000000447543144560559329,-0.000000031219576995048568,0.00},
	{4,0,-1,4,0.00072,0.03,-0.000000023463042910977102,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{4,0,0,-4,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,0,-2,-0.02391,4.23,0.000000574844551318938950,-0.000000217700250551744905,0.000000024975661596038853,0.16},
	{4,0,0,0,13.89903,782.37,0.000007774088217837080055,0.000018711813567344004559,0.000003259323838283070091,1.37},
	{4,0,0,2,-0.08500,-4.56,0.000001450798153328750763,-0.000000170864340074477095,-0.000000018731746197029138,0.00},
	{4,0,0,4,0.00035,0.02,-0.000000011731521455488551,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,1,-4,-0.00061,0.00,0.000000019552535759147585,-0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{4,0,1,-2,-0.06601,-2.12,0.000001165331131245195967,-0.000000140507731431803507,-0.000000018731746197029138,0.02},
	{4,0,1,0,1.97772,113.34,0.000001294377867255570082,0.000005135470850664867639,0.000000586928047506912940,0.18},
	{4,0,1,2,-0.01781,-0.99,0.000000301109050690872811,-0.000000054641895556812470,-0.000000000000000000000000,0.00},
	{4,0,1,4,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,2,-4,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,2,-2,-0.00980,-0.35,0.000000172062314680498749,-0.000000035560598695703352,-0.000000000000000000000000,0.00},
	{4,0,2,0,0.21853,12.57,0.000000160330793225010198,0.000000883810977339554036,0.000000081170900187126268,0.02},
	{4,0,2,2,-0.00274,-0.15,0.000000046926085821954204,-0.000000012142643457069439,-0.000000000000000000000000,0.00},
	{4,0,2,4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,3,-2,-0.00109,-0.04,0.000000019552535759147585,-0.000000006071321728534720,-0.000000000000000000000000,0.00},
	{4,0,3,0,0.02149,1.24,0.000000015642028607318068,0.000000119691771219684454,0.000000012487830798019427,0.00},
	{4,0,3,2,-0.00036,-0.02,0.000000007821014303659034,-0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{4,0,4,-2,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,4,0,0.00198,0.11,-0.000000000000000000000000,0.000000013877306808079359,-0.000000000000000000000000,0.00},
	{4,0,4,2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,5,0,0.00017,0.01,-0.000000000000000000000000,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{4,0,6,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-6,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-5,0,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-4,0,0.00064,0.06,-0.000000000000000000000000,0.000000004336658377524799,-0.000000024975661596038853,0.00},
	{4,1,-3,-2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-3,0,0.02682,3.50,0.000000019552535759147585,0.000000125763092948219188,-0.000000999026463841554180,0.02},
	{4,1,-3,2,-0.00003,-0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-2,-2,-0.00039,-0.02,0.000000007821014303659034,-0.000000000867331675504960,0.000000012487830798019427,0.00},
	{4,1,-2,0,-0.35759,7.75,0.000000070389128732931306,-0.000001138806489938012479,0.000013418174192471871148,-0.04},
	{4,1,-2,2,0.00220,-0.03,-0.000000039105071518295170,0.000000006938653404039679,-0.000000081170900187126268,0.00},
	{4,1,-1,-2,-0.01875,-0.68,0.000000324572093601849913,-0.000000030356608642673595,0.000000699318524689087862,0.00},
	{4,1,-1,0,-0.63523,-17.62,-0.000000289377529235384260,-0.000001242018959323102606,0.000023795561585626016172,-0.21},
	{4,1,-1,2,0.00353,0.09,-0.000000058657607277442755,0.000000007805985079544638,-0.000000131122223379203961,0.00},
	{4,1,-1,4,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,0,-2,0.00051,-0.28,-0.000000015642028607318068,0.000000001734663351009920,-0.000000018731746197029138,-0.01},
	{4,1,0,0,-0.28911,-15.10,-0.000000230719921957941504,-0.000000410247882513846030,0.000010801973640286802994,-0.06},
	{4,1,0,2,0.00186,0.09,-0.000000031284057214636136,0.000000004336658377524799,-0.000000068683069389106838,0.00},
	{4,1,1,-4,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,1,-2,0.00183,0.03,-0.000000031284057214636136,0.000000003469326702019840,-0.000000068683069389106838,0.00},
	{4,1,1,0,-0.05070,-2.99,-0.000000046926085821954204,-0.000000134436409703268773,0.000001891906365899942808,-0.01},
	{4,1,1,2,0.00048,0.03,-0.000000007821014303659034,0.000000001734663351009920,-0.000000018731746197029138,0.00},
	{4,1,2,-2,0.00032,0.01,-0.000000003910507151829517,0.000000000867331675504960,-0.000000012487830798019427,0.00},
	{4,1,2,0,-0.00668,-0.42,-0.000000007821014303659034,-0.000000027754613616158717,0.000000249756615960388545,0.00},
	{4,1,2,2,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,3,-2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,3,0,-0.00077,-0.05,-0.000000000000000000000000,-0.000000004336658377524799,0.000000031219576995048568,0.00},
	{4,1,3,2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,4,0,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,-4,0,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,-3,0,-0.00369,-0.24,-0.000000000000000000000000,-0.000000017346633510099197,0.000000274732277556427352,0.00},
	{4,2,-3,2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,-2,-2,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,-2,0,-0.03514,-2.04,-0.000000007821014303659034,-0.000000111885786140139832,0.000002628688382983089225,0.00},
	{4,2,-2,2,0.00019,0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{4,2,-1,-2,0.00090,0.06,-0.000000015642028607318068,0.000000001734663351009920,-0.000000068683069389106838,0.00},
	{4,2,-1,0,-0.02171,-1.51,-0.000000011731521455488551,-0.000000049437905503782707,0.000001623418003742525357,0.01},
	{4,2,-1,2,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{4,2,0,-2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,0,0,-0.00208,-0.16,-0.000000000000000000000000,-0.000000010407980106059518,0.000000156097884975242821,0.00},
	{4,2,0,2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,1,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,1,0,-0.00008,0.00,-0.000000000000000000000000,-0.000000000867331675504960,0.000000006243915399009713,0.00},
	{4,2,2,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,3,-2,0,0.00020,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,0.00},
	{4,3,-1,0,0.00023,0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,0.00},
	{4,3,0,0,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,4,-2,-2,0.00000,-0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,-0.06},
	{5,-3,-2,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{5,-3,0,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-2,-3,0,-0.00013,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.05},
	{5,-2,-2,0,-0.00052,-0.03,-0.000000000000000000000000,-0.000000001734663351009920,0.000000037463492394058276,-0.20},
	{5,-2,-1,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{5,-2,-1,0,-0.00011,-0.02,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,-0.04},
	{5,-2,0,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-2,0,0,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.05},
	{5,-2,1,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-1,-4,0,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,-1,-3,0,-0.00189,-0.08,-0.000000000000000000000000,-0.000000008673316755049599,0.000000068683069389106838,-0.73},
	{5,-1,-3,2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-1,-2,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{5,-1,-2,0,-0.00693,-0.40,-0.000000000000000000000000,-0.000000022550623563128957,0.000000256000531359398233,-2.70},
	{5,-1,-2,2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{5,-1,-1,-2,-0.00040,-0.02,0.000000007821014303659034,0.000000000000000000000000,0.000000012487830798019427,-0.16},
	{5,-1,-1,0,-0.00154,-0.21,-0.000000003910507151829517,-0.000000006938653404039679,0.000000056195238591087415,-0.60},
	{5,-1,-1,2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{5,-1,0,-2,-0.00021,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,-0.08},
	{5,-1,0,0,0.00102,0.01,-0.000000000000000000000000,-0.000000001734663351009920,-0.000000037463492394058276,0.40},
	{5,-1,1,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{5,-1,1,0,0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.05},
	{5,0,-4,0,-0.00059,-0.03,-0.000000000000000000000000,-0.000000003469326702019840,-0.000000000000000000000000,-0.23},
	{5,0,-3,0,-0.01686,-0.72,-0.000000000000000000000000,-0.000000079794514146456316,-0.000000000000000000000000,-6.56},
	{5,0,-3,2,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.04},
	{5,0,-2,-2,-0.00031,0.00,0.000000003910507151829517,-0.000000000867331675504960,-0.000000000000000000000000,-0.12},
	{5,0,-2,0,-0.05725,-3.18,-0.000000027373550062806622,-0.000000189078305260081270,-0.000000031219576995048568,-22.26},
	{5,0,-2,2,0.00039,0.02,-0.000000007821014303659034,0.000000001734663351009920,-0.000000000000000000000000,0.15},
	{5,0,-1,-2,-0.00335,-0.11,0.000000058657607277442755,-0.000000005203990053029759,-0.000000000000000000000000,-1.30},
	{5,0,-1,0,-0.01350,-1.57,-0.000000035194564366465653,-0.000000055509227232317434,-0.000000037463492394058276,-5.25},
	{5,0,-1,2,0.00024,0.02,-0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.09},
	{5,0,0,-4,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,0,0,-2,-0.00137,-0.06,0.000000023463042910977102,0.000000000000000000000000,-0.000000000000000000000000,-0.53},
	{5,0,0,0,0.00439,-0.05,-0.000000011731521455488551,-0.000000015611970159089276,-0.000000018731746197029138,1.71},
	{5,0,0,2,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{5,0,1,-2,-0.00019,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.07},
	{5,0,1,0,0.00050,-0.03,-0.000000000000000000000000,-0.000000001734663351009920,-0.000000000000000000000000,0.20},
	{5,0,1,2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,0,2,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,0,2,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,1,-4,0,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,1,-3,0,-0.00046,-0.05,-0.000000000000000000000000,-0.000000001734663351009920,0.000000018731746197029138,-0.18},
	{5,1,-2,-2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,1,-2,0,0.00392,0.12,-0.000000000000000000000000,0.000000013009975132574398,-0.000000143610054177223391,1.52},
	{5,1,-2,2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{5,1,-1,-2,0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.06},
	{5,1,-1,0,0.00475,0.24,0.000000003910507151829517,0.000000010407980106059518,-0.000000174829631172271966,1.85},
	{5,1,-1,2,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,1,0,-2,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{5,1,0,0,0.00181,0.11,-0.000000000000000000000000,0.000000004336658377524799,-0.000000068683069389106838,0.70},
	{5,1,0,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,1,1,0,0.00035,0.02,-0.000000000000000000000000,0.000000000867331675504960,-0.000000012487830798019427,0.14},
	{5,1,2,0,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{5,2,-3,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,2,-2,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,2,-1,0,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,-0.03},
	{5,2,0,0,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,2,1,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,3,-2,-2,0.00000,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{6,-4,-3,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-4,-2,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-4,-1,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-4,0,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-3,-3,0,0.00020,0.01,-0.000000000000000000000000,0.000000000867331675504960,-0.000000018731746197029138,0.00},
	{6,-3,-2,0,0.00059,0.04,-0.000000000000000000000000,0.000000001734663351009920,-0.000000068683069389106838,0.00},
	{6,-3,-1,0,0.00059,0.05,-0.000000000000000000000000,0.000000001734663351009920,-0.000000068683069389106838,0.00},
	{6,-3,0,0,0.00024,0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,0.00},
	{6,-3,1,0,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,-4,0,0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{6,-2,-3,0,0.00312,0.19,-0.000000000000000000000000,0.000000014744638483584319,-0.000000231024869763359374,0.00},
	{6,-2,-3,2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,-2,-2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,-2,0,0.00836,0.59,-0.000000000000000000000000,0.000000028621945291663678,-0.000000624391539900971283,0.00},
	{6,-2,-2,2,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,-1,-2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,-1,0,0.00744,0.61,0.000000003910507151829517,0.000000018213965185604158,-0.000000555708470511864498,0.00},
	{6,-2,-1,2,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,0,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,0,0,0.00285,0.26,-0.000000000000000000000000,0.000000006071321728534720,-0.000000212293123566330255,0.00},
	{6,-2,0,2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,1,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,1,0,0.00056,0.05,-0.000000000000000000000000,0.000000001734663351009920,-0.000000043707407793067991,0.00},
	{6,-2,2,0,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,3,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-5,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-4,0,0.00176,0.11,-0.000000000000000000000000,0.000000011275311781564479,-0.000000068683069389106838,0.00},
	{6,-1,-4,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-3,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-3,0,0.03900,2.28,0.000000007821014303659034,0.000000185608978558061415,-0.000001454832287969263133,0.00},
	{6,-1,-3,2,-0.00039,-0.02,0.000000007821014303659034,-0.000000001734663351009920,0.000000012487830798019427,0.00},
	{6,-1,-2,-2,0.00044,0.01,-0.000000007821014303659034,0.000000001734663351009920,-0.000000018731746197029138,0.00},
	{6,-1,-2,0,0.09033,6.23,0.000000043015578670124687,0.000000311372071506280602,-0.000003359226484667225530,0.00},
	{6,-1,-2,2,-0.00080,-0.05,0.000000015642028607318068,-0.000000002601995026514880,0.000000031219576995048568,0.00},
	{6,-1,-1,-2,0.00018,0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{6,-1,-1,0,0.07142,5.64,0.000000046926085821954204,0.000000177802993478516753,-0.000002653664044579127979,0.00},
	{6,-1,-1,2,-0.00064,-0.05,0.000000011731521455488551,-0.000000001734663351009920,0.000000024975661596038853,0.00},
	{6,-1,0,-2,-0.00025,0.00,0.000000003910507151829517,-0.000000000867331675504960,0.000000006243915399009713,0.00},
	{6,-1,0,0,0.02510,2.16,0.000000019552535759147585,0.000000057243890583327355,-0.000000930343394452447183,0.00},
	{6,-1,0,2,-0.00026,-0.02,0.000000003910507151829517,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{6,-1,1,-2,-0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,1,0,0.00477,0.42,0.000000003910507151829517,0.000000015611970159089276,-0.000000174829631172271966,0.00},
	{6,-1,1,2,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,2,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,2,0,0.00069,0.06,-0.000000000000000000000000,0.000000003469326702019840,-0.000000024975661596038853,0.00},
	{6,-1,2,2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,3,0,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-5,0,0.00020,0.01,-0.000000000000000000000000,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{6,0,-4,0,0.01376,0.88,-0.000000000000000000000000,0.000000086733167550495987,-0.000000000000000000000000,0.00},
	{6,0,-4,2,-0.00017,0.00,-0.000000000000000000000000,-0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{6,0,-3,-2,0.00018,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-3,0,0.29255,16.72,0.000000074299635884760823,0.000001391200007509955593,0.000000049951323192077706,0.03},
	{6,0,-3,2,-0.00287,-0.16,0.000000050836592973783721,-0.000000013877306808079359,-0.000000000000000000000000,0.00},
	{6,0,-3,4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-2,-2,0.00364,0.13,-0.000000062568114429272272,0.000000011275311781564479,-0.000000000000000000000000,0.00},
	{6,0,-2,0,0.57156,38.34,0.000000293288036387213777,0.000001992260858634892767,0.000000162341800374252536,0.02},
	{6,0,-2,2,-0.00509,-0.34,0.000000086031157340249375,-0.000000019081296861109118,-0.000000000000000000000000,0.00},
	{6,0,-2,4,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-1,-2,0.00007,0.08,-0.000000000000000000000000,-0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{6,0,-1,0,0.39451,30.10,0.000000289377529235384260,0.000001022584045420347509,0.000000156097884975242821,0.03},
	{6,0,-1,2,-0.00359,-0.27,0.000000062568114429272272,-0.000000011275311781564479,-0.000000000000000000000000,0.00},
	{6,0,-1,4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,0,-4,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,0,-2,-0.00214,-0.07,0.000000039105071518295170,-0.000000006071321728534720,-0.000000000000000000000000,0.00},
	{6,0,0,0,0.12616,10.43,0.000000113404707403055980,0.000000309637408155270648,0.000000062439153990097136,0.02},
	{6,0,0,2,-0.00132,-0.11,0.000000023463042910977102,-0.000000004336658377524799,-0.000000000000000000000000,0.00},
	{6,0,1,-4,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,1,-2,-0.00094,-0.05,0.000000015642028607318068,-0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{6,0,1,0,0.02285,1.93,0.000000023463042910977102,0.000000078927182470951352,0.000000012487830798019427,0.00},
	{6,0,1,2,-0.00031,-0.02,0.000000003910507151829517,-0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{6,0,2,-2,-0.00018,-0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,2,0,0.00318,0.27,-0.000000000000000000000000,0.000000015611970159089276,-0.000000000000000000000000,0.00},
	{6,0,2,2,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,3,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,3,0,0.00038,0.03,-0.000000000000000000000000,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{6,0,4,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,-5,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,-4,0,0.00028,0.05,-0.000000000000000000000000,0.000000001734663351009920,-0.000000012487830798019427,0.00},
	{6,1,-3,0,-0.00478,0.05,-0.000000000000000000000000,-0.000000022550623563128957,0.000000181073546571281654,0.00},
	{6,1,-3,2,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,-2,-2,-0.00026,-0.01,0.000000003910507151829517,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{6,1,-2,0,-0.01282,-0.47,-0.000000007821014303659034,-0.000000045101247126257915,0.000000480781485723747919,0.00},
	{6,1,-2,2,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,-1,-2,-0.00007,-0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,-1,0,-0.01064,-0.66,-0.000000007821014303659034,-0.000000027754613616158717,0.000000399610585536621651,0.00},
	{6,1,-1,2,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,0,-2,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,0,0,-0.00396,-0.31,-0.000000003910507151829517,-0.000000010407980106059518,0.000000149853969576233106,0.00},
	{6,1,0,2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,1,-2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,1,0,-0.00083,-0.07,-0.000000000000000000000000,-0.000000002601995026514880,0.000000031219576995048568,0.00},
	{6,1,1,2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,2,0,-0.00013,-0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,3,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,2,-4,0,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,2,-3,0,-0.00051,-0.04,-0.000000000000000000000000,-0.000000002601995026514880,0.000000037463492394058276,0.00},
	{6,2,-2,-2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,2,-2,0,-0.00061,-0.06,-0.000000000000000000000000,-0.000000002601995026514880,0.000000043707407793067991,0.00},
	{6,2,-1,-2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,2,-1,0,-0.00021,-0.02,-0.000000000000000000000000,0.000000000000000000000000,0.000000018731746197029138,0.00},
	{6,2,0,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,3,-2,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,-2,-3,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,-2,-2,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,-1,-4,0,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{7,-1,-3,0,-0.00016,-0.01,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,-0.06},
	{7,-1,-2,0,-0.00012,-0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.05},
	{7,-1,0,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,0,-5,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,0,-4,0,-0.00025,-0.02,-0.000000000000000000000000,-0.000000001734663351009920,-0.000000000000000000000000,-0.10},
	{7,0,-3,0,-0.00098,-0.07,-0.000000000000000000000000,-0.000000005203990053029759,-0.000000000000000000000000,-0.38},
	{7,0,-3,2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,0,-2,-2,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{7,0,-2,0,-0.00068,-0.07,-0.000000000000000000000000,-0.000000002601995026514880,-0.000000000000000000000000,-0.26},
	{7,0,-2,2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,0,-1,-2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{7,0,-1,0,-0.00005,-0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{7,0,0,-2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,0,0,0,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{7,1,-3,0,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{7,1,-2,0,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.04},
	{7,1,-1,0,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{7,1,0,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{8,-3,-3,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-3,-2,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-3,-1,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,-4,0,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,-3,0,0.00019,0.02,-0.000000000000000000000000,0.000000000867331675504960,-0.000000012487830798019427,0.00},
	{8,-2,-2,0,0.00025,0.03,-0.000000000000000000000000,0.000000000867331675504960,-0.000000018731746197029138,0.00},
	{8,-2,-1,0,0.00015,0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{8,-2,0,0,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,1,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,-5,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,-4,0,0.00058,0.04,-0.000000000000000000000000,0.000000003469326702019840,-0.000000018731746197029138,0.00},
	{8,-1,-3,0,0.00170,0.15,-0.000000000000000000000000,0.000000008673316755049599,-0.000000062439153990097136,0.00},
	{8,-1,-3,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,-2,0,0.00196,0.19,-0.000000000000000000000000,0.000000007805985079544638,-0.000000074926984788116553,0.00},
	{8,-1,-2,2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,-1,0,0.00112,0.12,-0.000000000000000000000000,0.000000003469326702019840,-0.000000043707407793067991,0.00},
	{8,-1,-1,2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,0,0,0.00037,0.04,-0.000000000000000000000000,0.000000001734663351009920,-0.000000012487830798019427,0.00},
	{8,-1,1,0,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,2,0,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-5,0,0.00018,0.01,-0.000000000000000000000000,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{8,0,-4,0,0.00324,0.25,-0.000000000000000000000000,0.000000020815960212119036,-0.000000000000000000000000,0.00},
	{8,0,-4,2,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-3,-2,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-3,0,0.00840,0.72,0.000000003910507151829517,0.000000042499252099743030,-0.000000000000000000000000,0.00},
	{8,0,-3,2,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-2,-2,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-2,0,0.00866,0.83,0.000000007821014303659034,0.000000034693267020198395,-0.000000000000000000000000,0.00},
	{8,0,-2,2,-0.00011,-0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-1,-2,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-1,0,0.00455,0.47,0.000000003910507151829517,0.000000015611970159089276,-0.000000000000000000000000,0.00},
	{8,0,-1,2,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,0,-2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,0,0,0.00139,0.15,-0.000000000000000000000000,0.000000005203990053029759,-0.000000000000000000000000,0.00},
	{8,0,0,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,1,-2,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,1,0,0.00029,0.03,-0.000000000000000000000000,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{8,0,2,0,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,-4,0,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,-3,0,-0.00024,-0.01,-0.000000000000000000000000,-0.000000000867331675504960,0.000000006243915399009713,0.00},
	{8,1,-2,0,-0.00029,-0.02,-0.000000000000000000000000,-0.000000000867331675504960,0.000000012487830798019427,0.00},
	{8,1,-1,0,-0.00017,-0.02,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{8,1,0,0,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,1,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,2,-3,0,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{9,0,-4,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{9,0,-3,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,-1,-4,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,-1,-3,0,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,-1,-2,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,-1,-1,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-5,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-4,0,0.00012,0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-3,0,0.00017,0.02,-0.000000000000000000000000,0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{10,0,-2,0,0.00013,0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-1,0,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,0,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,0,0,0,0,0,0,0,0}
};

struct elp82b_term1 elp2[] = {
	{0,0,0,1,18461.40000,0.00,-0.161319999024644139540285,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,0,3,-6.29664,7.68,0.000165277584772074537071,-0.000001145745143342052083,-0.000000012487830798019427,-0.02},
	{0,0,0,5,0.00592,0.00,-0.000000258093472020748124,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{0,0,1,-5,-0.00236,0.02,0.000000101673185947567443,-0.000000004336658377524799,-0.000000000000000000000000,0.00},
	{0,0,1,-3,2.79871,-17.13,-0.000073783448940719324879,0.000004404310248214186074,0.000000068683069389106838,0.04},
	{0,0,1,-1,999.70079,-563.82,-0.008801980664724075309469,0.001587114621036367009821,0.000000574440216708893563,-0.21},
	{0,0,1,1,1010.17430,-93.16,-0.008826730264488005794909,0.001594707242523737533019,0.000000474537570324738177,-0.17},
	{0,0,1,3,-1.01941,0.95,0.000026755689932817556007,-0.000001724255370903860225,-0.000000000000000000000000,0.00},
	{0,0,1,5,0.00156,0.00,-0.000000066478621581101789,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{0,0,2,-5,-0.00044,0.00,0.000000019552535759147585,-0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{0,0,2,-3,-0.13035,-0.40,0.000003433425279306315841,-0.000000413717209215865832,-0.000000000000000000000000,0.00},
	{0,0,2,-1,31.75985,-167.64,-0.000283101165256697878334,0.000100607872363548837618,0.000000680586778492058797,0.22},
	{0,0,2,1,61.91229,-23.73,-0.000540588508668912487605,0.000195425438461426529075,0.000000387122754738602168,-0.06},
	{0,0,2,3,-0.11787,0.11,0.000003093211157097147913,-0.000000382493268897687293,-0.000000000000000000000000,0.00},
	{0,0,2,5,0.00026,0.00,-0.000000011731521455488551,0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{0,0,3,-5,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,3,-3,-0.00146,0.04,0.000000039105071518295170,-0.000000006938653404039679,-0.000000000000000000000000,0.00},
	{0,0,3,-1,1.58131,-10.25,-0.000014101288789497238706,0.000007505020988144417890,0.000000049951323192077706,0.00},
	{0,0,3,1,3.98407,-3.30,-0.000034748766551157090287,0.000018858392620504343381,0.000000068683069389106838,-0.01},
	{0,0,3,3,-0.01181,0.01,0.000000308930064994531845,-0.000000056376558907822391,-0.000000000000000000000000,0.00},
	{0,0,3,5,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,4,-3,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,4,-1,0.09157,-0.70,-0.000000817295994732369005,0.000000579377559237313145,-0.000000000000000000000000,0.00},
	{0,0,4,1,0.26325,-0.37,-0.000002291557190972097082,0.000001660940158591997931,0.000000006243915399009713,0.00},
	{0,0,4,3,-0.00109,0.00,0.000000027373550062806622,-0.000000006938653404039679,-0.000000000000000000000000,0.00},
	{0,0,5,-1,0.00566,-0.05,-0.000000050836592973783721,0.000000044233915450752957,-0.000000000000000000000000,0.00},
	{0,0,5,1,0.01768,-0.04,-0.000000152509778921351164,0.000000139640399756298556,-0.000000000000000000000000,0.00},
	{0,0,5,3,-0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,6,-1,0.00036,0.00,-0.000000000000000000000000,0.000000003469326702019840,-0.000000000000000000000000,0.00},
	{0,0,6,1,0.00120,0.00,-0.000000011731521455488551,0.000000011275311781564479,-0.000000000000000000000000,0.00},
	{0,0,7,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,7,1,0.00008,0.00,-0.000000000000000000000000,0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{0,1,-6,-1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-6,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-5,-1,-0.00053,-0.01,0.000000003910507151829517,-0.000000004336658377524799,0.000000018731746197029138,0.00},
	{0,1,-5,1,-0.00014,0.00,-0.000000000000000000000000,-0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{0,1,-4,-3,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-4,-1,-0.00646,-0.14,0.000000054747100125613245,-0.000000040764588748733109,0.000000243512700561378804,0.00},
	{0,1,-4,1,-0.00186,-0.02,0.000000015642028607318068,-0.000000012142643457069439,0.000000068683069389106838,0.00},
	{0,1,-3,-3,0.00023,0.00,-0.000000003910507151829517,0.000000000867331675504960,-0.000000006243915399009713,0.00},
	{0,1,-3,-1,-0.07479,-1.69,0.000000637412665748211222,-0.000000353871323606023658,0.000002797274098756351449,0.00},
	{0,1,-3,1,-0.02365,-0.35,0.000000207256879046964402,-0.000000111885786140139832,0.000000886635986659379152,0.00},
	{0,1,-3,3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-2,-3,0.00154,0.03,-0.000000039105071518295170,0.000000005203990053029759,-0.000000056195238591087415,0.00},
	{0,1,-2,-1,-0.79322,-18.59,0.000006772998386968723697,-0.000002503119215507314020,0.000029671085976094158229,-0.01},
	{0,1,-2,1,-0.30129,-4.79,0.000002623950298877605870,-0.000000954932174730960833,0.000011264023379813521212,-0.01},
	{0,1,-2,3,0.00191,0.06,-0.000000050836592973783721,0.000000006071321728534720,-0.000000074926984788116553,0.00},
	{0,1,-1,-5,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-1,-3,0.00679,0.14,-0.000000175972821832328266,0.000000012142643457069439,-0.000000256000531359398233,0.00},
	{0,1,-1,-1,-6.73173,-159.36,0.000057460992088982920927,-0.000010658638960280451534,0.000251854571534455807472,-0.03},
	{0,1,-1,1,-5.63260,-148.81,0.000048474646654078690276,-0.000008916169624190987505,0.000210807071701365930346,-0.04},
	{0,1,-1,3,-0.00911,-0.20,0.000000238540936261600538,-0.000000013009975132574398,0.000000343415346945534243,0.00},
	{0,1,0,-3,0.00010,-0.17,-0.000000000000000000000000,0.000000005203990053029759,-0.000000000000000000000000,0.00},
	{0,1,0,-1,-4.83983,70.86,0.000039484390712022634715,-0.000000758047884391334981,0.000180480374608375766050,0.02},
	{0,1,0,1,-6.46036,28.14,0.000053280659943677171199,-0.000001752877316195524071,0.000241071329640365984628,0.29},
	{0,1,0,3,0.01157,0.06,-0.000000301109050690872811,0.000000003469326702019840,-0.000000430830162531670146,0.00},
	{0,1,0,5,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,1,-3,-0.00703,-0.04,0.000000183793836135987300,-0.000000011275311781564479,0.000000262244446758407922,0.00},
	{0,1,1,-1,-5.07614,-113.16,0.000043887621764982668660,-0.000008076592562302186426,0.000189989857761067523507,0.00},
	{0,1,1,1,-5.31151,-99.03,0.000045346240932615074963,-0.000008603062889333696473,0.000198743827150479163927,0.06},
	{0,1,1,3,0.00668,0.10,-0.000000175972821832328266,0.000000011275311781564479,-0.000000249756615960388545,0.00},
	{0,1,1,5,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,2,-3,0.00141,0.04,-0.000000035194564366465653,0.000000004336658377524799,-0.000000049951323192077706,0.00},
	{0,1,2,-1,-0.31292,-4.92,0.000002721712977673343849,-0.000000994829431804189090,0.000011707341373143211847,0.00},
	{0,1,2,1,-0.63884,-12.56,0.000005455157476802175984,-0.000002039096769112160841,0.000023907952062808188447,0.01},
	{0,1,2,3,0.00135,0.02,-0.000000035194564366465653,0.000000004336658377524799,-0.000000049951323192077706,0.00},
	{0,1,3,-3,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,3,-1,-0.02419,-0.36,0.000000211167386198793946,-0.000000115355112842159674,0.000000905367732856408323,0.00},
	{0,1,3,1,-0.06176,-1.23,0.000000527918465496984851,-0.000000294892769671686329,0.000002310248697633594054,0.00},
	{0,1,3,3,0.00020,0.00,-0.000000003910507151829517,0.000000000867331675504960,-0.000000006243915399009713,0.00},
	{0,1,4,-1,-0.00191,-0.03,0.000000015642028607318068,-0.000000012142643457069439,0.000000068683069389106838,0.00},
	{0,1,4,1,-0.00548,-0.11,0.000000046926085821954204,-0.000000034693267020198395,0.000000206049208167320540,0.00},
	{0,1,4,3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,5,-1,-0.00015,0.00,-0.000000000000000000000000,-0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{0,1,5,1,-0.00046,0.00,0.000000003910507151829517,-0.000000003469326702019840,0.000000018731746197029138,0.00},
	{0,1,6,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,6,1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,-5,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,-4,-1,-0.00016,0.00,-0.000000000000000000000000,-0.000000000867331675504960,0.000000012487830798019427,0.00},
	{0,2,-4,1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,-3,-1,-0.00169,-0.05,0.000000015642028607318068,-0.000000007805985079544638,0.000000124878307980194272,0.00},
	{0,2,-3,1,-0.00049,-0.01,0.000000003910507151829517,-0.000000002601995026514880,0.000000037463492394058276,0.00},
	{0,2,-2,-3,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,-2,-1,-0.01571,-0.49,0.000000132957243162203579,-0.000000049437905503782707,0.000001173856095013825881,0.00},
	{0,2,-2,1,-0.00536,-0.12,0.000000046926085821954204,-0.000000017346633510099197,0.000000399610585536621651,0.00},
	{0,2,-2,3,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,-1,-3,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{0,2,-1,-1,-0.11335,-3.25,0.000000961984759350061082,-0.000000179537656829526681,0.000008479237111855189563,0.00},
	{0,2,-1,1,-0.09511,-3.17,0.000000813385487580539541,-0.000000150048379862358043,0.000007111819639472063340,0.00},
	{0,2,-1,3,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{0,2,0,-3,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{0,2,0,-1,-0.01801,3.13,0.000000129046736010374062,-0.000000012142643457069439,0.000001336197895388078628,0.00},
	{0,2,0,1,-0.05729,2.09,0.000000465350351067712526,-0.000000033825935344693438,0.000004270838132922643859,0.00},
	{0,2,0,3,0.00016,0.00,-0.000000003910507151829517,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{0,2,1,-3,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,1,-1,-0.06187,-1.29,0.000000535739479800643885,-0.000000098008479332060451,0.000004626741310666197585,0.00},
	{0,2,1,1,-0.05504,-0.81,0.000000473171365371371560,-0.000000090202494252515829,0.000004114740247947401012,0.00},
	{0,2,1,3,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,2,-3,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,2,-1,-0.00284,-0.02,0.000000023463042910977102,-0.000000008673316755049599,0.000000212293123566330255,0.00},
	{0,2,2,1,-0.00528,-0.06,0.000000046926085821954204,-0.000000016479301834594237,0.000000393366670137611909,0.00},
	{0,2,2,3,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,3,-1,-0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{0,2,3,1,-0.00037,0.00,-0.000000000000000000000000,-0.000000001734663351009920,0.000000024975661596038853,0.00},
	{0,2,4,1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,-3,-1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,-3,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,-2,-1,-0.00033,-0.01,-0.000000000000000000000000,-0.000000000867331675504960,0.000000037463492394058276,0.00},
	{0,3,-2,1,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{0,3,-1,-1,-0.00216,-0.07,0.000000019552535759147585,-0.000000003469326702019840,0.000000243512700561378804,0.00},
	{0,3,-1,1,-0.00190,-0.07,0.000000015642028607318068,-0.000000002601995026514880,0.000000212293123566330255,0.00},
	{0,3,0,-1,0.00066,0.11,-0.000000007821014303659034,0.000000000000000000000000,-0.000000074926984788116553,0.00},
	{0,3,0,1,-0.00031,0.08,-0.000000000000000000000000,0.000000000000000000000000,0.000000037463492394058276,0.00},
	{0,3,1,-1,-0.00109,-0.02,0.000000007821014303659034,-0.000000001734663351009920,0.000000118634392581184544,0.00},
	{0,3,1,1,-0.00083,-0.01,0.000000007821014303659034,-0.000000001734663351009920,0.000000093658730985145685,0.00},
	{0,3,2,-1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,2,1,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{0,4,-1,-1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{0,4,-1,1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,4,0,-1,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,4,0,1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,4,1,-1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,4,1,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-3,-1,-1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{1,-3,0,-1,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.04},
	{1,-3,0,1,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.05},
	{1,-3,1,-1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-2,-2,-1,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{1,-2,-2,1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{1,-2,-1,-1,0.00064,0.00,-0.000000003910507151829517,0.000000000867331675504960,-0.000000049951323192077706,0.25},
	{1,-2,-1,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-2,0,-1,0.00204,0.02,-0.000000019552535759147585,0.000000000000000000000000,-0.000000149853969576233106,0.79},
	{1,-2,0,1,0.00214,0.00,-0.000000019552535759147585,0.000000000000000000000000,-0.000000162341800374252536,0.83},
	{1,-2,1,-1,-0.00060,-0.01,0.000000003910507151829517,-0.000000000867331675504960,0.000000043707407793067991,-0.23},
	{1,-2,1,1,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{1,-2,2,-1,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{1,-2,2,1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{1,-1,-4,-1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{1,-1,-3,-1,0.00018,0.00,-0.000000000000000000000000,0.000000000867331675504960,-0.000000006243915399009713,0.07},
	{1,-1,-3,1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{1,-1,-2,-1,0.00096,0.00,-0.000000007821014303659034,0.000000003469326702019840,-0.000000037463492394058276,0.37},
	{1,-1,-2,1,-0.00137,-0.03,0.000000011731521455488551,-0.000000004336658377524799,0.000000049951323192077706,-0.53},
	{1,-1,-1,-3,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{1,-1,-1,-1,0.01031,0.07,-0.000000089941664492078892,0.000000017346633510099197,-0.000000387122754738602168,4.01},
	{1,-1,-1,1,0.00080,0.04,-0.000000011731521455488551,0.000000000000000000000000,-0.000000031219576995048568,0.31},
	{1,-1,0,-3,-0.00052,0.00,0.000000011731521455488551,0.000000000000000000000000,0.000000018731746197029138,-0.20},
	{1,-1,0,-1,-0.01346,-1.07,0.000000105583693099396973,0.000000000000000000000000,0.000000512001062718796467,-5.23},
	{1,-1,0,1,-0.01829,-1.52,0.000000129046736010374062,0.000000000000000000000000,0.000000693074609290078174,-7.11},
	{1,-1,0,3,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{1,-1,1,-3,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{1,-1,1,-1,-0.02012,-0.42,0.000000175972821832328266,-0.000000032958603669188474,0.000000749269847881165476,-7.83},
	{1,-1,1,1,-0.00845,-0.45,0.000000066478621581101789,-0.000000014744638483584319,0.000000318439685349495383,-3.29},
	{1,-1,1,3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-1,2,-1,-0.00175,-0.04,0.000000015642028607318068,-0.000000005203990053029759,0.000000062439153990097136,-0.68},
	{1,-1,2,1,-0.00146,-0.07,0.000000011731521455488551,-0.000000005203990053029759,0.000000056195238591087415,-0.57},
	{1,-1,3,-1,-0.00015,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.06},
	{1,-1,3,1,-0.00018,0.00,-0.000000000000000000000000,-0.000000000867331675504960,0.000000006243915399009713,-0.07},
	{1,-1,4,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-1,4,1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,0,-5,-1,-0.00011,0.00,-0.000000000000000000000000,-0.000000000867331675504960,-0.000000000000000000000000,-0.04},
	{1,0,-5,1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{1,0,-4,-1,-0.00122,-0.04,0.000000011731521455488551,-0.000000007805985079544638,-0.000000000000000000000000,-0.47},
	{1,0,-4,1,-0.00043,0.00,-0.000000000000000000000000,-0.000000002601995026514880,-0.000000000000000000000000,-0.17},
	{1,0,-3,-1,-0.01255,-0.37,0.000000105583693099396973,-0.000000059845885609842227,-0.000000000000000000000000,-4.88},
	{1,0,-3,1,-0.00537,-0.12,0.000000046926085821954204,-0.000000025152618589643836,-0.000000000000000000000000,-2.09},
	{1,0,-3,3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,0,-2,-3,-0.00025,0.00,0.000000007821014303659034,0.000000000000000000000000,-0.000000000000000000000000,-0.10},
	{1,0,-2,-1,-0.10964,-3.19,0.000000911148166376277520,-0.000000349534665228498852,0.000000012487830798019427,-42.63},
	{1,0,-2,1,-0.07846,-2.00,0.000000672607230114676928,-0.000000248924190869923470,0.000000018731746197029138,-30.51},
	{1,0,-2,3,-0.00020,0.00,0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,-0.08},
	{1,0,-1,-3,-0.00369,-0.04,0.000000097762678795737926,-0.000000006071321728534720,-0.000000000000000000000000,-1.44},
	{1,0,-1,-1,-0.42989,-13.13,0.000003452977815065463691,-0.000000706875315536542313,0.000000006243915399009713,-167.15},
	{1,0,-1,1,0.13928,1.86,-0.000001317840910166547290,0.000000213363592174220125,-0.000000024975661596038853,54.16},
	{1,0,-1,3,0.00234,0.05,-0.000000062568114429272272,0.000000003469326702019840,-0.000000000000000000000000,0.91},
	{1,0,0,-5,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{1,0,0,-3,-0.03226,-0.41,0.000000840759037643346107,0.000000000000000000000000,-0.000000000000000000000000,-12.54},
	{1,0,0,-1,-4.80578,-102.50,0.000040430733442765374552,-0.000000270607482757547500,0.000000056195238591087415,-1868.59},
	{1,0,0,1,-5.36844,-119.82,0.000044525034430730881364,-0.000000274076809459567356,0.000000049951323192077706,-2087.37},
	{1,0,0,3,0.00645,0.15,-0.000000168151807528669232,0.000000001734663351009920,-0.000000000000000000000000,2.51},
	{1,0,0,5,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,0,1,-5,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,0,1,-3,-0.00019,0.01,0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,-0.07},
	{1,0,1,-1,-0.58893,-7.87,0.000005122764368896667196,-0.000000945391526300406323,-0.000000018731746197029138,-228.99},
	{1,0,1,1,-0.66741,-14.68,0.000005533367619838766536,-0.000001081562599354684998,-0.000000043707407793067991,-259.50},
	{1,0,1,3,0.00142,0.03,-0.000000035194564366465653,0.000000002601995026514880,-0.000000000000000000000000,0.55},
	{1,0,2,-1,-0.03636,-0.40,0.000000316751079298190879,-0.000000116222444517664625,-0.000000000000000000000000,-14.14},
	{1,0,2,1,-0.06383,-1.35,0.000000527918465496984851,-0.000000203822943743665589,-0.000000012487830798019427,-24.82},
	{1,0,2,3,0.00021,0.00,-0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.08},
	{1,0,3,-1,-0.00247,-0.02,0.000000019552535759147585,-0.000000012142643457069439,-0.000000000000000000000000,-0.96},
	{1,0,3,1,-0.00553,-0.11,0.000000046926085821954204,-0.000000026019950265148796,-0.000000000000000000000000,-2.15},
	{1,0,3,3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,0,4,-1,-0.00017,0.00,-0.000000000000000000000000,-0.000000000867331675504960,-0.000000000000000000000000,-0.07},
	{1,0,4,1,-0.00045,0.00,-0.000000000000000000000000,-0.000000002601995026514880,-0.000000000000000000000000,-0.18},
	{1,0,5,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,0,5,1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{1,1,-5,-1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,1,-4,-1,0.00017,0.00,-0.000000000000000000000000,0.000000000867331675504960,-0.000000006243915399009713,0.07},
	{1,1,-4,1,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{1,1,-3,-1,0.00186,0.02,-0.000000015642028607318068,0.000000008673316755049599,-0.000000068683069389106838,0.72},
	{1,1,-3,1,0.00093,0.00,-0.000000007821014303659034,0.000000004336658377524799,-0.000000037463492394058276,0.36},
	{1,1,-2,-3,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,1,-2,-1,0.01597,0.20,-0.000000136867750314033096,0.000000051172568854792628,-0.000000599415878304932423,6.21},
	{1,1,-2,1,0.01680,0.23,-0.000000148599271769521647,0.000000052907232205802549,-0.000000630635455299980971,6.53},
	{1,1,-2,3,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{1,1,-1,-3,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{1,1,-1,-1,0.00635,-0.38,-0.000000027373550062806622,0.000000017346633510099197,-0.000000224780954364349659,2.46},
	{1,1,-1,1,-0.05590,-0.18,0.000000504455422586007749,-0.000000084131172523981109,0.000002097955574067263375,-21.74},
	{1,1,-1,3,-0.00021,0.00,0.000000003910507151829517,0.000000000000000000000000,0.000000006243915399009713,-0.08},
	{1,1,0,-3,0.00080,0.00,-0.000000019552535759147585,0.000000000000000000000000,-0.000000031219576995048568,0.31},
	{1,1,0,-1,0.80426,0.22,-0.000006855119037157143396,0.000000096273815981050549,-0.000030045720900034736996,312.71},
	{1,1,0,1,0.80263,0.34,-0.000006808192951335189403,0.000000073723192417921582,-0.000029983281746044643923,312.08},
	{1,1,0,3,-0.00083,0.00,0.000000023463042910977102,0.000000000000000000000000,0.000000031219576995048568,-0.32},
	{1,1,1,-3,-0.00021,0.01,0.000000003910507151829517,0.000000000000000000000000,0.000000006243915399009713,-0.08},
	{1,1,1,-1,0.03465,0.09,-0.000000293288036387213777,0.000000061580548960852141,-0.000001292490487595010385,13.48},
	{1,1,1,1,0.10176,0.15,-0.000000860311573402493851,0.000000170864340074477095,-0.000003802544477996914894,39.57},
	{1,1,1,3,-0.00020,0.00,0.000000003910507151829517,0.000000000000000000000000,0.000000006243915399009713,-0.08},
	{1,1,2,-3,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,1,2,-1,0.00317,0.00,-0.000000027373550062806622,0.000000010407980106059518,-0.000000118634392581184544,1.23},
	{1,1,2,1,0.01016,0.03,-0.000000086031157340249375,0.000000032958603669188474,-0.000000380878839339592479,3.95},
	{1,1,2,3,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{1,1,3,-1,0.00027,0.00,-0.000000000000000000000000,0.000000001734663351009920,-0.000000012487830798019427,0.11},
	{1,1,3,1,0.00093,0.00,-0.000000007821014303659034,0.000000004336658377524799,-0.000000037463492394058276,0.36},
	{1,1,4,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,1,4,1,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{1,2,-3,-1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{1,2,-3,1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,2,-2,-1,0.00017,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.06},
	{1,2,-2,1,0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.06},
	{1,2,-1,-1,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,-0.03},
	{1,2,-1,1,-0.00039,-0.02,-0.000000000000000000000000,0.000000000000000000000000,0.000000031219576995048568,-0.15},
	{1,2,0,-1,-0.00170,-0.03,0.000000015642028607318068,0.000000000000000000000000,0.000000124878307980194272,-0.66},
	{1,2,0,1,-0.00204,-0.03,0.000000015642028607318068,0.000000000000000000000000,0.000000149853969576233106,-0.79},
	{1,2,1,-1,-0.00022,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000018731746197029138,-0.09},
	{1,2,1,1,-0.00072,-0.01,0.000000007821014303659034,-0.000000000867331675504960,0.000000056195238591087415,-0.28},
	{1,2,2,-1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{1,2,2,1,-0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,-0.05},
	{1,2,3,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,3,0,-1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{1,3,0,1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{2,-5,-1,-1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-5,-1,1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-5,0,-1,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{2,-5,0,1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-4,-2,-1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-4,-1,-1,0.00031,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000043707407793067991,0.00},
	{2,-4,-1,1,0.00034,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000049951323192077706,0.00},
	{2,-4,0,-1,0.00118,0.03,-0.000000011731521455488551,0.000000000000000000000000,-0.000000174829631172271966,0.00},
	{2,-4,0,1,0.00062,0.03,-0.000000003910507151829517,0.000000000000000000000000,-0.000000093658730985145685,0.00},
	{2,-4,1,-1,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{2,-4,1,1,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{2,-4,2,1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,-3,-1,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{2,-3,-2,-1,0.00077,0.02,-0.000000007821014303659034,0.000000002601995026514880,-0.000000087414815586135983,0.00},
	{2,-3,-2,1,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,-1,-1,0.00914,0.25,-0.000000078210143036590340,0.000000014744638483584319,-0.000001024002125437592934,0.00},
	{2,-3,-1,1,0.01042,0.25,-0.000000089941664492078892,0.000000016479301834594237,-0.000001167612179614816404,0.00},
	{2,-3,-1,3,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,0,-3,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{2,-3,0,-1,0.03647,0.91,-0.000000316751079298190879,0.000000001734663351009920,-0.000004083520670952351934,0.00},
	{2,-3,0,1,0.01603,0.62,-0.000000136867750314033096,0.000000005203990053029759,-0.000001798247634914797269,0.00},
	{2,-3,0,3,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,1,-3,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,1,-1,0.00240,0.07,-0.000000019552535759147585,0.000000004336658377524799,-0.000000268488362157417663,0.00},
	{2,-3,1,1,0.00256,0.11,-0.000000023463042910977102,0.000000004336658377524799,-0.000000287220108354446782,0.00},
	{2,-3,2,-1,0.00021,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,0.00},
	{2,-3,2,1,0.00031,0.01,-0.000000000000000000000000,0.000000000867331675504960,-0.000000037463492394058276,0.00},
	{2,-3,3,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,3,1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,-4,-1,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{2,-2,-4,1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,-3,-1,0.00178,0.03,-0.000000015642028607318068,0.000000008673316755049599,-0.000000131122223379203961,0.00},
	{2,-2,-3,1,0.00030,0.00,-0.000000000000000000000000,0.000000001734663351009920,-0.000000024975661596038853,0.00},
	{2,-2,-2,-1,0.02285,0.53,-0.000000199435864743305368,0.000000071988529066911668,-0.000001704588903929651519,0.00},
	{2,-2,-2,1,-0.00192,0.00,0.000000015642028607318068,-0.000000006071321728534720,0.000000143610054177223391,0.00},
	{2,-2,-2,3,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{2,-2,-1,-3,0.00024,0.00,-0.000000007821014303659034,0.000000000000000000000000,-0.000000018731746197029138,0.00},
	{2,-2,-1,-1,0.26865,6.32,-0.000002334572769642221504,0.000000425859852672935300,-0.000020067944092417218811,0.00},
	{2,-2,-1,1,0.31474,6.78,-0.000002725623484825173419,0.000000498715713415351944,-0.000023508341477271568385,0.00},
	{2,-2,-1,3,-0.00045,0.00,0.000000011731521455488551,0.000000000000000000000000,0.000000031219576995048568,0.00},
	{2,-2,0,-3,0.00273,0.03,-0.000000070389128732931306,0.000000000000000000000000,-0.000000206049208167320540,0.00},
	{2,-2,0,-1,1.08587,23.51,-0.000009482979843186578836,0.000000040764588748733109,-0.000081089729286939142951,0.00},
	{2,-2,0,1,0.38353,13.48,-0.000003304378543295941726,0.000000149181048186853092,-0.000028640839935257549677,0.00},
	{2,-2,0,3,-0.00044,-0.01,0.000000011731521455488551,0.000000000000000000000000,0.000000031219576995048568,0.00},
	{2,-2,1,-3,-0.00072,-0.02,0.000000019552535759147585,-0.000000000867331675504960,0.000000056195238591087415,0.00},
	{2,-2,1,-1,0.06915,1.69,-0.000000590486579926257124,0.000000113620449491149747,-0.000005163718034981032064,0.00},
	{2,-2,1,1,0.05848,2.24,-0.000000500544915434178179,0.000000109283791113624941,-0.000004364496863907789398,0.00},
	{2,-2,1,3,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{2,-2,2,-3,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,2,-1,0.00555,0.16,-0.000000046926085821954204,0.000000018213965185604158,-0.000000412098416334641081,0.00},
	{2,-2,2,1,0.00677,0.27,-0.000000058657607277442755,0.000000023417955238633918,-0.000000505757147319786778,0.00},
	{2,-2,2,3,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,3,-1,0.00046,0.01,-0.000000000000000000000000,0.000000002601995026514880,-0.000000037463492394058276,0.00},
	{2,-2,3,1,0.00070,0.03,-0.000000007821014303659034,0.000000003469326702019840,-0.000000049951323192077706,0.00},
	{2,-2,4,-1,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,4,1,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-6,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-5,-1,0.00029,0.00,-0.000000000000000000000000,0.000000002601995026514880,-0.000000012487830798019427,0.00},
	{2,-1,-5,1,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-4,-1,0.00416,0.06,-0.000000035194564366465653,0.000000026019950265148796,-0.000000156097884975242821,0.00},
	{2,-1,-4,1,0.00080,0.00,-0.000000007821014303659034,0.000000005203990053029759,-0.000000031219576995048568,0.00},
	{2,-1,-3,-3,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-3,-1,0.05502,0.99,-0.000000480992379675030541,0.000000261066834326992885,-0.000002054248166274195344,0.00},
	{2,-1,-3,1,0.00935,0.12,-0.000000082120650188419858,0.000000044233915450752957,-0.000000349659262344543931,0.00},
	{2,-1,-3,3,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-2,-3,0.00033,-0.01,-0.000000007821014303659034,0.000000000867331675504960,-0.000000012487830798019427,0.00},
	{2,-1,-2,-1,0.65025,13.75,-0.000005654593341545481934,0.000002055576070946754638,-0.000024295074817546791251,0.00},
	{2,-1,-2,1,-0.06208,-0.48,0.000000547471001256132383,-0.000000196884290339625905,0.000002316492613032603531,0.00},
	{2,-1,-2,3,-0.00267,-0.03,0.000000070389128732931306,-0.000000008673316755049599,0.000000099902646384155413,0.00},
	{2,-1,-1,-5,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-1,-3,0.01034,0.06,-0.000000269824993476236675,0.000000014744638483584319,-0.000000387122754738602168,0.00},
	{2,-1,-1,-1,7.43488,154.99,-0.000064578115105312641699,0.000011787037470112405241,-0.000277610722555370862015,-0.02},
	{2,-1,-1,1,8.86853,174.25,-0.000076774986911868912443,0.000014023018529564192569,-0.000331108589694086030437,-0.01},
	{2,-1,-1,3,-0.01177,-0.23,0.000000308930064994531845,-0.000000020815960212119036,0.000000437074077930679887,0.00},
	{2,-1,-1,5,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,0,-5,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,0,-3,0.08815,0.98,-0.000002307199219579415362,-0.000000011275311781564479,-0.000003290543415278118321,0.00},
	{2,-1,0,-1,29.57794,553.39,-0.000258734795193648172210,0.000001078093272652665195,-0.001103562095451774728583,0.16},
	{2,-1,0,1,7.95891,253.11,-0.000068515995807204969101,0.000003846615980864496747,-0.000296960616376901968133,0.00},
	{2,-1,0,3,-0.00944,-0.28,0.000000246361950565259573,-0.000000009540648430554559,0.000000349659262344543931,0.00},
	{2,-1,0,5,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,1,-5,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,1,-3,-0.01669,-0.30,0.000000437976801004905960,-0.000000026887281940653757,0.000000624391539900971283,0.00},
	{2,-1,1,-1,1.76606,35.98,-0.000015145394199035718216,0.000002899489791213080735,-0.000065873307459552471357,0.02},
	{2,-1,1,1,1.13466,38.36,-0.000009729341793751837932,0.000002205624450809113051,-0.000042321258574487834094,0.00},
	{2,-1,1,3,-0.00224,-0.07,0.000000058657607277442755,-0.000000005203990053029759,0.000000081170900187126268,0.00},
	{2,-1,2,-3,-0.00061,-0.01,0.000000015642028607318068,-0.000000001734663351009920,0.000000024975661596038853,0.00},
	{2,-1,2,-1,0.12897,2.89,-0.000001087120988208605627,0.000000418053867593390691,-0.000004807814857237479186,0.00},
	{2,-1,2,1,0.12387,4.35,-0.000001059747438145799061,0.000000431063842725965056,-0.000004620497395267188108,0.00},
	{2,-1,2,3,-0.00036,-0.01,0.000000007821014303659034,-0.000000001734663351009920,0.000000012487830798019427,0.00},
	{2,-1,3,-3,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,3,-1,0.00985,0.24,-0.000000082120650188419858,0.000000047703242152772799,-0.000000368391008541573050,0.00},
	{2,-1,3,1,0.01211,0.44,-0.000000101673185947567443,0.000000060713217285347191,-0.000000449561908728699317,0.00},
	{2,-1,3,3,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,4,-1,0.00076,0.02,-0.000000007821014303659034,0.000000005203990053029759,-0.000000031219576995048568,0.00},
	{2,-1,4,1,0.00111,0.04,-0.000000007821014303659034,0.000000006938653404039679,-0.000000043707407793067991,0.00},
	{2,-1,5,-1,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,5,1,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-7,-1,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-7,1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-6,-1,0.00092,0.02,-0.000000007821014303659034,0.000000008673316755049599,-0.000000000000000000000000,0.00},
	{2,0,-6,1,0.00020,0.00,-0.000000000000000000000000,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{2,0,-5,-3,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-5,-1,0.01127,0.23,-0.000000097762678795737926,0.000000089335162577010865,-0.000000000000000000000000,0.00},
	{2,0,-5,1,0.00230,0.03,-0.000000019552535759147585,0.000000018213965185604158,-0.000000000000000000000000,0.00},
	{2,0,-4,-3,-0.00014,0.00,-0.000000000000000000000000,-0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{2,0,-4,-1,0.13381,2.77,-0.000001157510116941537039,0.000000845648383617335892,-0.000000000000000000000000,0.00},
	{2,0,-4,1,0.02496,0.39,-0.000000218988400502452980,0.000000157854364941902704,-0.000000000000000000000000,0.00},
	{2,0,-4,3,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-3,-3,0.00023,-0.02,-0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-3,-1,1.51564,31.76,-0.000013135393522995348901,0.000007184975599883087676,-0.000000043707407793067991,0.00},
	{2,0,-3,1,0.25408,3.88,-0.000002248541612301972236,0.000001207325692302904159,-0.000000000000000000000000,0.01},
	{2,0,-3,3,0.00232,0.05,-0.000000062568114429272272,0.000000011275311781564479,-0.000000000000000000000000,0.00},
	{2,0,-3,5,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-2,-5,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-2,-3,0.02045,0.10,-0.000000535739479800643885,0.000000060713217285347191,-0.000000000000000000000000,0.00},
	{2,0,-2,-1,15.56635,330.35,-0.000134908586230966510934,0.000049218470589879959390,-0.000000143610054177223391,0.03},
	{2,0,-2,1,-1.62443,-20.88,0.000014226425018355783251,-0.000005134603518989362636,-0.000000112390477182174829,-0.02},
	{2,0,-2,3,-0.06561,-0.77,0.000001724533653956817061,-0.000000206424938770180441,-0.000000000000000000000000,0.00},
	{2,0,-2,5,0.00012,0.00,-0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-1,-5,-0.00046,0.00,0.000000019552535759147585,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-1,-3,0.32907,3.62,-0.000008614847255480427010,0.000000489175064984797329,0.000000012487830798019427,0.01},
	{2,0,-1,-1,166.57528,3219.29,-0.001445284338244671226009,0.000263911682222649224012,0.000003740105324006818009,0.39},
	{2,0,-1,1,199.48515,3726.28,-0.001725804568781161545815,0.000314615024640993641049,0.000005419718566340430774,0.73},
	{2,0,-1,3,-0.24484,-4.55,0.000006409321221848578349,-0.000000428461847699450204,-0.000000012487830798019427,0.00},
	{2,0,-1,5,0.00038,0.00,-0.000000015642028607318068,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,0,-5,-0.00221,-0.02,0.000000097762678795737926,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,0,-3,2.18637,23.85,-0.000057269377238543269881,-0.000000206424938770180441,0.000000168585715773262251,0.03},
	{2,0,0,-1,623.65783,9963.62,-0.005466181196463183906975,0.000021263503356679596236,0.000043869749593442245307,5.00},
	{2,0,0,1,117.26161,3313.25,-0.001007213685068121230073,0.000075849889686259748122,0.000007898552979747287052,1.79},
	{2,0,0,3,-0.14453,-3.71,0.000003769728894363654623,-0.000000177802993478516753,-0.000000012487830798019427,0.00},
	{2,0,0,5,0.00026,0.00,-0.000000011731521455488551,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,1,-5,-0.00075,0.00,0.000000031284057214636136,-0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{2,0,1,-3,-0.29116,-3.49,0.000007676325539041342077,-0.000000464889778070658500,-0.000000031219576995048568,0.00},
	{2,0,1,-1,33.35743,512.77,-0.000287719474203008539898,0.000054668782838753123834,0.000003253079922884060190,0.43},
	{2,0,1,1,15.12165,433.44,-0.000129535549404352753802,0.000031154553784138155209,0.000001498539695762330952,0.31},
	{2,0,1,3,-0.03038,-0.82,0.000000789922444669562439,-0.000000073723192417921582,-0.000000000000000000000000,0.00},
	{2,0,1,5,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,2,-5,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,2,-3,-0.00995,-0.12,0.000000265914486324407158,-0.000000031223940318178553,-0.000000000000000000000000,0.00},
	{2,0,2,-1,2.14618,33.22,-0.000018230784341829206989,0.000006949061384145738570,0.000000280976192955437093,0.04},
	{2,0,2,1,1.51976,43.48,-0.000012986794251225826090,0.000005439036937091603633,0.000000206049208167320540,0.04},
	{2,0,2,3,-0.00451,-0.12,0.000000117315214554885511,-0.000000017346633510099197,-0.000000000000000000000000,0.00},
	{2,0,2,5,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,3,-3,-0.00093,0.00,0.000000023463042910977102,-0.000000004336658377524799,-0.000000000000000000000000,0.00},
	{2,0,3,-1,0.14642,2.28,-0.000001223988738522638881,0.000000707742647212047317,0.000000024975661596038853,0.00},
	{2,0,3,1,0.13795,3.92,-0.000001177062652700684465,0.000000706875315536542313,0.000000024975661596038853,0.00},
	{2,0,3,3,-0.00056,-0.02,0.000000015642028607318068,-0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{2,0,4,-3,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,4,-1,0.01027,0.16,-0.000000086031157340249375,0.000000065917207338376947,-0.000000000000000000000000,0.00},
	{2,0,4,1,0.01186,0.33,-0.000000101673185947567443,0.000000078927182470951352,-0.000000000000000000000000,0.00},
	{2,0,4,3,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,5,-1,0.00073,0.01,-0.000000007821014303659034,0.000000006071321728534720,-0.000000000000000000000000,0.00},
	{2,0,5,1,0.00099,0.03,-0.000000007821014303659034,0.000000007805985079544638,-0.000000000000000000000000,0.00},
	{2,0,6,-1,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,6,1,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-6,-1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-5,-1,0.00028,0.02,-0.000000000000000000000000,0.000000002601995026514880,-0.000000012487830798019427,0.00},
	{2,1,-5,1,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-4,-1,0.00247,0.19,-0.000000019552535759147585,0.000000015611970159089276,-0.000000093658730985145685,0.00},
	{2,1,-4,1,0.00034,0.03,-0.000000000000000000000000,0.000000002601995026514880,-0.000000012487830798019427,0.00},
	{2,1,-3,-3,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-3,-1,0.01818,1.67,-0.000000148599271769521647,0.000000085865835874991023,-0.000000686830693891068485,0.00},
	{2,1,-3,1,0.00162,0.17,-0.000000011731521455488551,0.000000007805985079544638,-0.000000062439153990097136,0.00},
	{2,1,-2,-3,-0.00015,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-2,-1,0.07913,12.08,-0.000000613949622837234226,0.000000246322195843408566,-0.000002997079391524661904,0.00},
	{2,1,-2,1,0.05429,3.18,-0.000000453618829612223922,0.000000170864340074477095,-0.000002035516420077166067,0.00},
	{2,1,-2,3,0.00017,-0.03,-0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-1,-3,-0.00342,0.05,0.000000089941664492078892,-0.000000005203990053029759,0.000000124878307980194272,0.00},
	{2,1,-1,-1,-0.79105,41.53,0.000007195333159366310477,-0.000001293191528177895274,0.000029402597613936741413,-0.01},
	{2,1,-1,1,-1.31788,39.71,0.000011723700441184892356,-0.000002131901258391191138,0.000049070931120817333384,0.00},
	{2,1,-1,3,0.00192,-0.03,-0.000000050836592973783721,0.000000003469326702019840,-0.000000068683069389106838,0.00},
	{2,1,0,-5,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,0,-3,-0.05457,-0.95,0.000001427335110417773767,0.000000000867331675504960,0.000002041760335476175967,0.00},
	{2,1,0,-1,-12.09470,-205.76,0.000105998206857490891099,-0.000000272342146108557401,0.000451959572241919093228,-0.31},
	{2,1,0,1,-1.26433,-30.65,0.000010706968581709217718,-0.000000918504244359752484,0.000047235219993508481160,-0.41},
	{2,1,0,3,0.00177,0.04,-0.000000046926085821954204,0.000000002601995026514880,-0.000000068683069389106838,0.00},
	{2,1,1,-5,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,1,-3,0.00465,0.02,-0.000000121225721706715028,0.000000007805985079544638,-0.000000174829631172271966,0.00},
	{2,1,1,-1,-0.82275,-17.02,0.000007117123016329720772,-0.000001336558111953143122,0.000030751283340122832430,-0.04},
	{2,1,1,1,-0.23702,-7.85,0.000001994358647433053576,-0.000000502185040117371747,0.000008860115951194782042,-0.08},
	{2,1,1,3,0.00052,0.02,-0.000000011731521455488551,0.000000001734663351009920,-0.000000018731746197029138,0.00},
	{2,1,2,-3,0.00021,0.00,-0.000000003910507151829517,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{2,1,2,-1,-0.06283,-1.47,0.000000535739479800643885,-0.000000202955612068160586,0.000002347712190027651761,0.00},
	{2,1,2,1,-0.03142,-1.17,0.000000262003979172577641,-0.000000113620449491149747,0.000001173856095013825881,-0.01},
	{2,1,2,3,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,3,-3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,3,-1,-0.00496,-0.13,0.000000043015578670124687,-0.000000024285286914138878,0.000000187317461970291369,0.00},
	{2,1,3,1,-0.00355,-0.14,0.000000031284057214636136,-0.000000018213965185604158,0.000000131122223379203961,0.00},
	{2,1,3,3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,4,-1,-0.00040,-0.01,-0.000000000000000000000000,-0.000000002601995026514880,0.000000012487830798019427,0.00},
	{2,1,4,1,-0.00037,-0.02,-0.000000000000000000000000,-0.000000002601995026514880,0.000000012487830798019427,0.00},
	{2,1,5,-1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,5,1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-4,-1,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-4,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-3,-1,-0.00102,-0.03,0.000000007821014303659034,-0.000000005203990053029759,0.000000074926984788116553,0.00},
	{2,2,-3,1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-2,-3,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-2,-1,-0.01262,-0.47,0.000000109494200251226490,-0.000000039897257073228158,0.000000942831225250466666,0.00},
	{2,2,-2,1,-0.00504,-0.27,0.000000043015578670124687,-0.000000016479301834594237,0.000000374634923940582738,0.00},
	{2,2,-2,3,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-1,-3,-0.00046,-0.02,0.000000011731521455488551,0.000000000000000000000000,0.000000037463492394058276,0.00},
	{2,2,-1,-1,-0.10535,-3.66,0.000000915058673528106878,-0.000000165660350021447339,0.000007879821233550257775,0.00},
	{2,2,-1,1,-0.11330,-3.82,0.000000977626787957379362,-0.000000180404988505031658,0.000008479237111855189563,0.00},
	{2,2,-1,3,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{2,2,0,-3,-0.00103,-0.02,0.000000023463042910977102,0.000000001734663351009920,0.000000074926984788116553,0.00},
	{2,2,0,-1,-0.13415,-2.41,0.000001188794174156173175,-0.000000022550623563128957,0.000010033972046208609405,0.00},
	{2,2,0,1,-0.01482,-0.52,0.000000125136228858544545,-0.000000045968578801762878,0.000001111416941023728996,0.03},
	{2,2,0,3,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,1,-3,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,1,-1,-0.00617,-0.08,0.000000054747100125613245,-0.000000011275311781564479,0.000000462049739526718747,0.00},
	{2,2,1,1,-0.00145,-0.05,0.000000011731521455488551,-0.000000006938653404039679,0.000000106146561783165128,0.00},
	{2,2,2,-1,-0.00025,0.00,-0.000000000000000000000000,-0.000000000867331675504960,0.000000018731746197029138,0.00},
	{2,2,2,1,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{2,3,-2,-1,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{2,3,-2,1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,3,-1,-1,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{2,3,-1,1,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,3,0,-1,0.00037,0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000043707407793067991,0.00},
	{2,3,0,1,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,3,1,-1,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{3,-3,-1,-1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,-3,-1,1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{3,-3,0,-1,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,-2,-3,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-2,-2,-1,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.06},
	{3,-2,-2,1,-0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.06},
	{3,-2,-1,-1,-0.00101,-0.03,0.000000007821014303659034,-0.000000001734663351009920,0.000000074926984788116553,-0.39},
	{3,-2,-1,1,-0.00063,-0.03,0.000000003910507151829517,-0.000000000867331675504960,0.000000049951323192077706,-0.25},
	{3,-2,0,-3,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,-2,0,-1,-0.00131,-0.05,0.000000011731521455488551,0.000000000000000000000000,0.000000099902646384155413,-0.51},
	{3,-2,0,1,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{3,-2,1,-1,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.06},
	{3,-2,2,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-1,-4,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-1,-3,-1,-0.00022,0.00,-0.000000000000000000000000,-0.000000000867331675504960,0.000000006243915399009713,-0.08},
	{3,-1,-2,-1,-0.00282,-0.07,0.000000023463042910977102,-0.000000008673316755049599,0.000000106146561783165128,-1.10},
	{3,-1,-2,1,-0.00329,-0.07,0.000000027373550062806622,-0.000000010407980106059518,0.000000124878307980194272,-1.28},
	{3,-1,-1,-3,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.04},
	{3,-1,-1,-1,-0.02104,-0.53,0.000000183793836135987300,-0.000000033825935344693438,0.000000786733340275223819,-8.18},
	{3,-1,-1,1,-0.01356,-0.55,0.000000113404707403055980,-0.000000023417955238633918,0.000000505757147319786778,-5.27},
	{3,-1,-1,3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-1,0,-3,-0.00076,-0.01,0.000000019552535759147585,0.000000000000000000000000,0.000000031219576995048568,-0.30},
	{3,-1,0,-1,-0.02572,-0.94,0.000000234630429109771021,-0.000000006071321728534720,0.000000955319056048486149,-10.00},
	{3,-1,0,1,-0.00042,-0.19,-0.000000000000000000000000,-0.000000008673316755049599,0.000000012487830798019427,-0.16},
	{3,-1,0,3,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-1,1,-1,-0.00275,-0.11,0.000000023463042910977102,-0.000000005203990053029759,0.000000099902646384155413,-1.07},
	{3,-1,1,1,-0.00030,-0.05,-0.000000000000000000000000,-0.000000001734663351009920,0.000000012487830798019427,-0.12},
	{3,-1,2,-1,-0.00027,-0.01,-0.000000000000000000000000,-0.000000000867331675504960,0.000000012487830798019427,-0.10},
	{3,-1,2,1,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{3,-1,3,-1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-1,3,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,0,-4,-1,-0.00016,0.00,-0.000000000000000000000000,-0.000000000867331675504960,-0.000000000000000000000000,-0.06},
	{3,0,-4,1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{3,0,-3,-1,-0.00287,-0.04,0.000000023463042910977102,-0.000000013877306808079359,-0.000000000000000000000000,-1.12},
	{3,0,-3,1,0.00015,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.06},
	{3,0,-3,3,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,0,-2,-3,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{3,0,-2,-1,-0.03941,-0.88,0.000000340214122209167981,-0.000000124895761272714211,-0.000000000000000000000000,-15.32},
	{3,0,-2,1,-0.04852,-1.04,0.000000414513758093928805,-0.000000153517706564377898,-0.000000000000000000000000,-18.87},
	{3,0,-2,3,0.00016,0.00,-0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.06},
	{3,0,-1,-3,-0.00128,-0.01,0.000000035194564366465653,-0.000000001734663351009920,-0.000000000000000000000000,-0.50},
	{3,0,-1,-1,-0.30517,-7.43,0.000002635681820333094580,-0.000000490909728335807336,-0.000000049951323192077706,-118.66},
	{3,0,-1,1,-0.20593,-7.88,0.000001716712639653157921,-0.000000351269328579508754,-0.000000074926984788116553,-80.07},
	{3,0,-1,3,0.00038,0.02,-0.000000007821014303659034,0.000000000000000000000000,-0.000000000000000000000000,0.15},
	{3,0,0,-3,-0.01009,-0.13,0.000000265914486324407158,0.000000000000000000000000,-0.000000000000000000000000,-3.92},
	{3,0,0,-1,-0.35183,-11.87,0.000003187063328741056322,-0.000000085865835874991023,-0.000000137366138778213676,-136.80},
	{3,0,0,1,-0.02840,-2.77,0.000000191614850439646334,-0.000000118824439544179517,-0.000000062439153990097136,-11.04},
	{3,0,0,3,0.00016,0.00,-0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.06},
	{3,0,1,-3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,0,1,-1,-0.03611,-1.26,0.000000324572093601849913,-0.000000065049875662871984,-0.000000018731746197029138,-14.04},
	{3,0,1,1,-0.00658,-0.56,0.000000046926085821954204,-0.000000025152618589643836,-0.000000012487830798019427,-2.56},
	{3,0,1,3,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{3,0,2,-1,-0.00322,-0.12,0.000000027373550062806622,-0.000000011275311781564479,-0.000000000000000000000000,-1.25},
	{3,0,2,1,-0.00108,-0.08,0.000000007821014303659034,-0.000000005203990053029759,-0.000000000000000000000000,-0.42},
	{3,0,3,-1,-0.00027,-0.01,-0.000000000000000000000000,-0.000000001734663351009920,-0.000000000000000000000000,-0.11},
	{3,0,3,1,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.05},
	{3,0,4,-1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,0,4,1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,1,-4,-1,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{3,1,-4,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,1,-3,-1,-0.00044,-0.02,-0.000000000000000000000000,-0.000000001734663351009920,0.000000018731746197029138,-0.17},
	{3,1,-3,1,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{3,1,-2,-1,-0.00152,-0.09,0.000000011731521455488551,-0.000000005203990053029759,0.000000056195238591087415,-0.59},
	{3,1,-2,1,-0.00261,-0.12,0.000000023463042910977102,-0.000000007805985079544638,0.000000099902646384155413,-1.02},
	{3,1,-1,-3,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.01},
	{3,1,-1,-1,0.01321,0.23,-0.000000113404707403055980,0.000000021683291887623997,-0.000000493269316521767296,5.14},
	{3,1,-1,1,0.02083,0.37,-0.000000175972821832328266,0.000000033825935344693438,-0.000000774245509477204336,8.10},
	{3,1,-1,3,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,1,0,-3,0.00031,0.00,-0.000000007821014303659034,0.000000000000000000000000,-0.000000012487830798019427,0.12},
	{3,1,0,-1,0.03436,0.68,-0.000000301109050690872811,0.000000007805985079544638,-0.000001280002656796991008,13.36},
	{3,1,0,1,0.01351,0.39,-0.000000113404707403055980,0.000000014744638483584319,-0.000000505757147319786778,5.25},
	{3,1,0,3,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{3,1,1,-1,0.00426,0.09,-0.000000035194564366465653,0.000000007805985079544638,-0.000000156097884975242821,1.66},
	{3,1,1,1,0.00258,0.08,-0.000000019552535759147585,0.000000006071321728534720,-0.000000093658730985145685,1.00},
	{3,1,2,-1,0.00044,0.00,-0.000000000000000000000000,0.000000001734663351009920,-0.000000018731746197029138,0.17},
	{3,1,2,1,0.00035,0.01,-0.000000000000000000000000,0.000000001734663351009920,-0.000000012487830798019427,0.14},
	{3,1,3,-1,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{3,1,3,1,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{3,2,-2,-1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,2,-2,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,2,-1,-1,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,2,-1,1,-0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,-0.04},
	{3,2,0,-1,-0.00056,0.00,0.000000003910507151829517,0.000000000000000000000000,0.000000043707407793067991,-0.22},
	{3,2,0,1,-0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.06},
	{3,2,1,-1,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,-0.03},
	{3,2,1,1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,2,2,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,3,-1,-3,0.00001,0.00,-0.000000000000000000000000,-0.000000001734663351009920,0.000000006243915399009713,0.03},
	{3,3,-1,-1,0.00000,-0.01,-0.000000000000000000000000,-0.000000000867331675504960,0.000000012487830798019427,0.01},
	{3,3,-1,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-4,-2,1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-4,-1,-1,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{4,-4,-1,1,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{4,-4,0,-1,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{4,-4,0,1,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{4,-4,1,-1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-3,-2,-1,0.00013,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{4,-3,-2,1,0.00059,0.03,-0.000000003910507151829517,0.000000001734663351009920,-0.000000068683069389106838,0.00},
	{4,-3,-1,-1,0.00165,0.07,-0.000000015642028607318068,0.000000002601995026514880,-0.000000187317461970291369,0.00},
	{4,-3,-1,1,0.00134,0.07,-0.000000011731521455488551,0.000000002601995026514880,-0.000000149853969576233106,0.00},
	{4,-3,0,-3,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-3,0,-1,0.00161,0.08,-0.000000015642028607318068,0.000000000000000000000000,-0.000000181073546571281654,0.00},
	{4,-3,0,1,0.00080,0.05,-0.000000007821014303659034,0.000000000867331675504960,-0.000000087414815586135983,0.00},
	{4,-3,1,-1,0.00024,0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,0.00},
	{4,-3,1,1,0.00017,0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000018731746197029138,0.00},
	{4,-3,2,-1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-3,2,1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-4,-1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-3,-1,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-3,1,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{4,-2,-2,-3,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-2,-1,0.00283,0.11,-0.000000023463042910977102,0.000000008673316755049599,-0.000000212293123566330255,0.00},
	{4,-2,-2,1,0.01230,0.50,-0.000000105583693099396973,0.000000039029925397723194,-0.000000917855563654427806,0.00},
	{4,-2,-2,3,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-1,-3,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-1,-1,0.03462,1.29,-0.000000301109050690872811,0.000000056376558907822391,-0.000002584980975190020770,0.00},
	{4,-2,-1,1,0.02380,1.25,-0.000000203346371895134885,0.000000045968578801762878,-0.000001779515888717768204,0.00},
	{4,-2,-1,3,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,0,-3,0.00029,0.00,-0.000000007821014303659034,0.000000000000000000000000,-0.000000024975661596038853,0.00},
	{4,-2,0,-1,0.02899,1.41,-0.000000254182964868918607,0.000000015611970159089276,-0.000002160394728057360683,0.00},
	{4,-2,0,1,0.01270,0.79,-0.000000105583693099396973,0.000000017346633510099197,-0.000000949075140649476354,0.00},
	{4,-2,0,3,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,1,-3,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,1,-1,0.00417,0.21,-0.000000035194564366465653,0.000000008673316755049599,-0.000000312195769950485641,0.00},
	{4,-2,1,1,0.00255,0.17,-0.000000023463042910977102,0.000000006938653404039679,-0.000000187317461970291369,0.00},
	{4,-2,2,-1,0.00047,0.03,-0.000000003910507151829517,0.000000001734663351009920,-0.000000037463492394058276,0.00},
	{4,-2,2,1,0.00037,0.03,-0.000000000000000000000000,0.000000001734663351009920,-0.000000024975661596038853,0.00},
	{4,-2,3,-1,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,3,1,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-6,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-5,-1,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-4,-1,-0.00058,-0.02,0.000000003910507151829517,-0.000000003469326702019840,0.000000018731746197029138,0.00},
	{4,-1,-4,1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-3,-3,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-3,-1,-0.00090,-0.03,0.000000007821014303659034,-0.000000004336658377524799,0.000000031219576995048568,0.00},
	{4,-1,-3,1,0.00191,0.12,-0.000000015642028607318068,0.000000008673316755049599,-0.000000068683069389106838,0.00},
	{4,-1,-3,3,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-2,-3,-0.00033,-0.01,0.000000007821014303659034,-0.000000000867331675504960,0.000000012487830798019427,0.00},
	{4,-1,-2,-1,0.05251,1.99,-0.000000453618829612223922,0.000000166527681696952290,-0.000001960589435289049805,0.00},
	{4,-1,-2,1,0.21376,8.24,-0.000001830117347056213755,0.000000676518706893868671,-0.000007973479964535402467,0.00},
	{4,-1,-2,3,-0.00060,-0.02,0.000000015642028607318068,-0.000000001734663351009920,0.000000024975661596038853,0.00},
	{4,-1,-1,-3,-0.00065,-0.04,0.000000015642028607318068,-0.000000000867331675504960,0.000000024975661596038853,0.00},
	{4,-1,-1,-1,0.59580,21.19,-0.000005189242990477768614,0.000000967942149863535251,-0.000022184631412681511887,0.02},
	{4,-1,-1,1,0.33882,16.92,-0.000002878133263746524530,0.000000671314716840838968,-0.000012618953021398629329,0.00},
	{4,-1,-1,3,-0.00075,-0.04,0.000000019552535759147585,-0.000000001734663351009920,0.000000024975661596038853,0.00},
	{4,-1,0,-5,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,0,-3,0.00534,0.13,-0.000000140778257465862613,0.000000000000000000000000,-0.000000199805292768310825,0.00},
	{4,-1,0,-1,0.41496,19.00,-0.000003609398101138644372,0.000000248924190869923470,-0.000015428714950953002273,0.00},
	{4,-1,0,1,0.15791,9.24,-0.000001333482938773865358,0.000000236781547412854030,-0.000005875524390468139515,0.00},
	{4,-1,0,3,-0.00037,-0.02,0.000000007821014303659034,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{4,-1,1,-3,-0.00062,-0.02,0.000000015642028607318068,-0.000000000867331675504960,0.000000024975661596038853,0.00},
	{4,-1,1,-1,0.05686,2.69,-0.000000484902886826860111,0.000000117089776193169589,-0.000002110443404865282752,0.00},
	{4,-1,1,1,0.03009,1.83,-0.000000254182964868918607,0.000000080661845821961266,-0.000001117660856422738684,0.00},
	{4,-1,1,3,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,2,-3,-0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,2,-1,0.00614,0.30,-0.000000050836592973783721,0.000000021683291887623997,-0.000000231024869763359374,0.00},
	{4,-1,2,1,0.00421,0.26,-0.000000035194564366465653,0.000000017346633510099197,-0.000000156097884975242821,0.00},
	{4,-1,2,3,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,3,-3,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,3,-1,0.00060,0.03,-0.000000003910507151829517,0.000000003469326702019840,-0.000000024975661596038853,0.00},
	{4,-1,3,1,0.00050,0.03,-0.000000003910507151829517,0.000000002601995026514880,-0.000000018731746197029138,0.00},
	{4,-1,4,-1,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,4,1,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-7,-1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-6,-1,-0.00015,0.00,-0.000000000000000000000000,-0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{4,0,-6,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-5,-1,-0.00116,-0.05,0.000000011731521455488551,-0.000000009540648430554559,-0.000000000000000000000000,0.00},
	{4,0,-4,-3,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-4,-1,-0.00680,-0.28,0.000000058657607277442755,-0.000000043366583775247993,-0.000000000000000000000000,0.00},
	{4,0,-4,1,0.00029,0.00,-0.000000000000000000000000,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{4,0,-4,3,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-3,-3,-0.00066,-0.02,0.000000015642028607318068,-0.000000003469326702019840,-0.000000000000000000000000,0.00},
	{4,0,-3,-1,-0.00771,-0.29,0.000000066478621581101789,-0.000000036427930371208316,-0.000000000000000000000000,0.00},
	{4,0,-3,1,0.02174,1.30,-0.000000183793836135987300,0.000000103212469385090220,-0.000000012487830798019427,0.00},
	{4,0,-3,3,-0.00127,-0.04,0.000000035194564366465653,-0.000000006071321728534720,-0.000000000000000000000000,0.00},
	{4,0,-2,-3,-0.00390,-0.14,0.000000101673185947567443,-0.000000012142643457069439,-0.000000000000000000000000,0.00},
	{4,0,-2,-1,0.63371,23.67,-0.000005470799505409494264,0.000002008740160469486988,0.000000018731746197029138,0.08},
	{4,0,-2,1,2.41389,90.53,-0.000020663119790267168166,0.000007628182086066122464,0.000000218537038965339944,0.07},
	{4,0,-2,3,-0.00632,-0.24,0.000000164241300376839715,-0.000000020815960212119036,-0.000000000000000000000000,0.00},
	{4,0,-2,5,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-1,-5,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-1,-3,-0.00554,-0.34,0.000000144688764617692130,-0.000000008673316755049599,-0.000000000000000000000000,0.00},
	{4,0,-1,-1,6.57962,223.57,-0.000057386692453098159521,0.000010674250930439539904,0.000001211319587407884223,0.26},
	{4,0,-1,1,2.99850,142.57,-0.000025426117501195517466,0.000006168462876191275191,0.000000487025401122757607,0.06},
	{4,0,-1,3,-0.00664,-0.31,0.000000172062314680498749,-0.000000016479301834594237,-0.000000000000000000000000,0.00},
	{4,0,-1,5,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,0,-5,-0.00013,0.00,0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,0,-3,0.06257,1.51,-0.000001638502496616567792,-0.000000003469326702019840,0.000000018731746197029138,0.02},
	{4,0,0,-1,3.67449,157.55,-0.000031921469880384345508,0.000002564699764468166307,0.000001005270379240563868,0.06},
	{4,0,0,1,1.19188,65.39,-0.000010034361351594540154,0.000002004403502091962393,0.000000280976192955437093,0.08},
	{4,0,0,3,-0.00288,-0.15,0.000000074299635884760823,-0.000000006938653404039679,-0.000000000000000000000000,0.00},
	{4,0,1,-3,-0.00552,-0.15,0.000000148599271769521647,-0.000000009540648430554559,-0.000000000000000000000000,0.00},
	{4,0,1,-1,0.47338,20.49,-0.000004035643380688061992,0.000001005237411910248497,0.000000156097884975242821,0.02},
	{4,0,1,1,0.21259,11.97,-0.000001783191261234259551,0.000000600193519449432171,0.000000062439153990097136,0.01},
	{4,0,1,3,-0.00068,-0.04,0.000000015642028607318068,-0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{4,0,2,-3,-0.00090,-0.02,0.000000023463042910977102,-0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{4,0,2,-1,0.04834,2.10,-0.000000402782236638440253,0.000000176935661803011829,0.000000018731746197029138,0.00},
	{4,0,2,1,0.02828,1.60,-0.000000234630429109771021,0.000000118824439544179517,0.000000012487830798019427,0.00},
	{4,0,2,3,-0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,3,-3,-0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,3,-1,0.00449,0.20,-0.000000035194564366465653,0.000000023417955238633918,-0.000000000000000000000000,0.00},
	{4,0,3,1,0.00323,0.18,-0.000000027373550062806622,0.000000018213965185604158,-0.000000000000000000000000,0.00},
	{4,0,3,3,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,4,-1,0.00040,0.02,-0.000000000000000000000000,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{4,0,4,1,0.00034,0.02,-0.000000000000000000000000,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{4,0,5,-1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,5,1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-5,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-4,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-4,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-3,-1,0.00063,0.05,-0.000000003910507151829517,0.000000002601995026514880,-0.000000024975661596038853,0.00},
	{4,1,-3,1,0.00192,0.19,-0.000000015642028607318068,0.000000008673316755049599,-0.000000068683069389106838,0.00},
	{4,1,-2,-3,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-2,-1,-0.00203,0.57,0.000000019552535759147585,-0.000000006938653404039679,0.000000074926984788116553,0.00},
	{4,1,-2,1,-0.02957,0.54,0.000000262003979172577641,-0.000000093671820954535671,0.000001111416941023728996,0.00},
	{4,1,-2,3,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-1,-3,-0.00015,-0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-1,-1,-0.17191,-3.93,0.000001521187282061682175,-0.000000277546136161587158,0.000006431232860980004966,-0.02},
	{4,1,-1,1,-0.05097,-1.36,0.000000434066293853076443,-0.000000107549127762615026,0.000001910638112096972297,-0.02},
	{4,1,-1,3,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,0,-3,-0.00304,-0.09,0.000000078210143036590340,0.000000000000000000000000,0.000000112390477182174829,0.00},
	{4,1,0,-1,-0.11308,-4.83,0.000000981537295109208720,-0.000000080661845821961266,0.000004220886809730565504,-0.02},
	{4,1,0,1,-0.02549,-1.26,0.000000211167386198793946,-0.000000045101247126257915,0.000000955319056048486149,0.00},
	{4,1,0,3,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,1,-3,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,1,-1,-0.01692,-0.79,0.000000144688764617692130,-0.000000036427930371208316,0.000000630635455299980971,0.00},
	{4,1,1,1,-0.00558,-0.32,0.000000046926085821954204,-0.000000016479301834594237,0.000000206049208167320540,0.00},
	{4,1,1,3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,2,-3,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,2,-1,-0.00196,-0.10,0.000000015642028607318068,-0.000000006938653404039679,0.000000074926984788116553,0.00},
	{4,1,2,1,-0.00088,-0.05,0.000000007821014303659034,-0.000000003469326702019840,0.000000031219576995048568,0.00},
	{4,1,3,-1,-0.00020,-0.01,-0.000000000000000000000000,-0.000000000867331675504960,0.000000006243915399009713,0.00},
	{4,1,3,1,-0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,4,-1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,4,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,-3,-1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,-3,1,-0.00020,-0.01,-0.000000000000000000000000,-0.000000000867331675504960,0.000000012487830798019427,0.00},
	{4,2,-2,-3,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,-2,-1,-0.00114,-0.07,0.000000007821014303659034,-0.000000003469326702019840,0.000000087414815586135983,0.00},
	{4,2,-2,1,-0.00277,-0.16,0.000000023463042910977102,-0.000000008673316755049599,0.000000206049208167320540,0.00},
	{4,2,-1,-3,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,-1,-1,-0.00438,-0.25,0.000000035194564366465653,-0.000000006938653404039679,0.000000324683600748505071,0.00},
	{4,2,-1,1,-0.00179,-0.12,0.000000015642028607318068,-0.000000004336658377524799,0.000000131122223379203961,0.00},
	{4,2,0,-1,-0.00056,-0.03,0.000000003910507151829517,-0.000000001734663351009920,0.000000043707407793067991,0.00},
	{4,2,0,1,-0.00025,-0.02,-0.000000000000000000000000,-0.000000000867331675504960,0.000000018731746197029138,0.00},
	{4,2,1,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,1,1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,3,-2,1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,3,-1,-1,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{4,3,-1,1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,3,0,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-2,-2,-1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,-2,-2,1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,-2,-1,-1,-0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,-0.04},
	{5,-2,-1,1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-2,0,-1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-1,-3,-1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{5,-1,-3,1,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.05},
	{5,-1,-2,-1,-0.00057,-0.02,0.000000003910507151829517,-0.000000001734663351009920,0.000000018731746197029138,-0.22},
	{5,-1,-2,1,-0.00061,-0.04,0.000000003910507151829517,-0.000000001734663351009920,0.000000024975661596038853,-0.24},
	{5,-1,-1,-3,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-1,-1,-1,-0.00127,-0.07,0.000000011731521455488551,-0.000000002601995026514880,0.000000049951323192077706,-0.50},
	{5,-1,-1,1,-0.00029,-0.03,-0.000000000000000000000000,-0.000000000867331675504960,0.000000012487830798019427,-0.11},
	{5,-1,0,-3,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,-1,0,-1,-0.00032,-0.03,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.12},
	{5,-1,1,-1,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,0,-4,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,0,-3,-1,-0.00033,-0.01,-0.000000000000000000000000,-0.000000001734663351009920,-0.000000000000000000000000,-0.13},
	{5,0,-3,1,-0.00124,-0.05,0.000000011731521455488551,-0.000000006071321728534720,-0.000000000000000000000000,-0.48},
	{5,0,-2,-1,-0.00505,-0.21,0.000000043015578670124687,-0.000000016479301834594237,-0.000000000000000000000000,-1.96},
	{5,0,-2,1,-0.00519,-0.29,0.000000043015578670124687,-0.000000017346633510099197,-0.000000000000000000000000,-2.02},
	{5,0,-2,3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,0,-1,-3,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.04},
	{5,0,-1,-1,-0.01049,-0.54,0.000000093852171643908409,-0.000000019081296861109118,-0.000000006243915399009713,-4.08},
	{5,0,-1,1,-0.00245,-0.21,0.000000019552535759147585,-0.000000007805985079544638,-0.000000000000000000000000,-0.95},
	{5,0,-1,3,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,0,0,-3,-0.00041,-0.01,0.000000011731521455488551,0.000000000000000000000000,-0.000000000000000000000000,-0.16},
	{5,0,0,-1,-0.00254,-0.19,0.000000023463042910977102,-0.000000006071321728534720,-0.000000000000000000000000,-0.99},
	{5,0,0,1,-0.00027,-0.05,-0.000000000000000000000000,-0.000000002601995026514880,-0.000000000000000000000000,-0.10},
	{5,0,1,-3,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{5,0,1,-1,-0.00045,-0.03,0.000000003910507151829517,-0.000000001734663351009920,-0.000000000000000000000000,-0.17},
	{5,0,1,1,-0.00006,-0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,0,2,-1,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,0,2,1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,1,-3,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,1,-3,1,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,1,-2,-1,0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.06},
	{5,1,-2,1,0.00041,0.01,-0.000000000000000000000000,0.000000001734663351009920,-0.000000012487830798019427,0.16},
	{5,1,-1,-1,0.00097,0.04,-0.000000007821014303659034,0.000000001734663351009920,-0.000000037463492394058276,0.38},
	{5,1,-1,1,0.00053,0.03,-0.000000003910507151829517,0.000000000867331675504960,-0.000000018731746197029138,0.21},
	{5,1,0,-3,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,1,0,-1,0.00051,0.02,-0.000000003910507151829517,0.000000000000000000000000,-0.000000018731746197029138,0.20},
	{5,1,0,1,0.00023,0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.09},
	{5,1,1,-1,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.04},
	{5,1,1,1,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{5,1,2,-1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,2,-1,-1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,2,0,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-3,-3,1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-3,-2,-1,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-3,-2,1,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{6,-3,-1,-1,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{6,-3,-1,1,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{6,-3,0,-1,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-3,0,1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-3,1,-1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,-3,-1,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,-3,1,0.00033,0.02,-0.000000000000000000000000,0.000000001734663351009920,-0.000000024975661596038853,0.00},
	{6,-2,-2,-1,0.00088,0.05,-0.000000007821014303659034,0.000000002601995026514880,-0.000000062439153990097136,0.00},
	{6,-2,-2,1,0.00087,0.06,-0.000000007821014303659034,0.000000003469326702019840,-0.000000062439153990097136,0.00},
	{6,-2,-1,-3,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,-1,-1,0.00137,0.09,-0.000000011731521455488551,0.000000002601995026514880,-0.000000099902646384155413,0.00},
	{6,-2,-1,1,0.00078,0.06,-0.000000007821014303659034,0.000000001734663351009920,-0.000000056195238591087415,0.00},
	{6,-2,0,-1,0.00067,0.05,-0.000000003910507151829517,0.000000000867331675504960,-0.000000049951323192077706,0.00},
	{6,-2,0,1,0.00032,0.03,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,0.00},
	{6,-2,1,-1,0.00013,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{6,-2,1,1,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,2,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,2,1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-4,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-4,1,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-3,-1,0.00089,0.05,-0.000000007821014303659034,0.000000004336658377524799,-0.000000031219576995048568,0.00},
	{6,-1,-3,1,0.00415,0.24,-0.000000035194564366465653,0.000000019948628536614079,-0.000000156097884975242821,0.00},
	{6,-1,-3,3,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-2,-1,0.01091,0.59,-0.000000093852171643908409,0.000000034693267020198395,-0.000000405854500935631339,0.00},
	{6,-1,-2,1,0.00939,0.64,-0.000000078210143036590340,0.000000032958603669188474,-0.000000349659262344543931,0.00},
	{6,-1,-2,3,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-1,-3,0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-1,-1,0.01486,0.96,-0.000000129046736010374062,0.000000030356608642673595,-0.000000549464555112854704,0.00},
	{6,-1,-1,1,0.00757,0.59,-0.000000062568114429272272,0.000000020815960212119036,-0.000000280976192955437093,0.00},
	{6,-1,-1,3,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,0,-3,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,0,-1,0.00652,0.47,-0.000000054747100125613245,0.000000010407980106059518,-0.000000243512700561378804,0.00},
	{6,-1,0,1,0.00288,0.24,-0.000000023463042910977102,0.000000007805985079544638,-0.000000106146561783165128,0.00},
	{6,-1,0,3,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,1,-1,0.00122,0.09,-0.000000011731521455488551,0.000000003469326702019840,-0.000000043707407793067991,0.00},
	{6,-1,1,1,0.00063,0.06,-0.000000003910507151829517,0.000000002601995026514880,-0.000000024975661596038853,0.00},
	{6,-1,2,-1,0.00017,0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000006243915399009713,0.00},
	{6,-1,2,1,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,3,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,3,1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-4,-1,0.00014,0.00,-0.000000000000000000000000,0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{6,0,-4,1,0.00072,0.05,-0.000000007821014303659034,0.000000004336658377524799,-0.000000000000000000000000,0.00},
	{6,0,-4,3,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-3,-1,0.00702,0.40,-0.000000058657607277442755,0.000000032958603669188474,-0.000000000000000000000000,0.00},
	{6,0,-3,1,0.03118,1.77,-0.000000265914486324407158,0.000000148313716511348142,-0.000000000000000000000000,0.00},
	{6,0,-3,3,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-2,-3,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-2,-1,0.08096,4.28,-0.000000699980780177483600,0.000000260199502651487934,0.000000024975661596038853,0.00},
	{6,0,-2,1,0.05963,3.97,-0.000000500544915434178179,0.000000213363592174220125,0.000000018731746197029138,0.00},
	{6,0,-2,3,-0.00021,-0.01,0.000000003910507151829517,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-1,-3,0.00107,0.04,-0.000000027373550062806622,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{6,0,-1,-1,0.09403,5.84,-0.000000813385487580539541,0.000000197751622015130829,0.000000043707407793067991,0.00},
	{6,0,-1,1,0.04217,3.17,-0.000000348035136512827015,0.000000118824439544179517,0.000000018731746197029138,0.00},
	{6,0,-1,3,-0.00014,-0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,0,-3,0.00060,0.04,-0.000000015642028607318068,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,0,-1,0.03674,2.54,-0.000000312840572146361362,0.000000063315212311862069,0.000000018731746197029138,0.00},
	{6,0,0,1,0.01465,1.19,-0.000000121225721706715028,0.000000040764588748733109,0.000000006243915399009713,0.00},
	{6,0,0,3,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,1,-3,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,1,-1,0.00654,0.46,-0.000000054747100125613245,0.000000019081296861109118,-0.000000000000000000000000,0.00},
	{6,0,1,1,0.00305,0.25,-0.000000023463042910977102,0.000000011275311781564479,-0.000000000000000000000000,0.00},
	{6,0,1,3,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,2,-3,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,2,-1,0.00088,0.06,-0.000000007821014303659034,0.000000003469326702019840,-0.000000000000000000000000,0.00},
	{6,0,2,1,0.00048,0.04,-0.000000003910507151829517,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{6,0,3,-1,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,3,1,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,4,-1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,-4,1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,-3,-1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,-3,1,-0.00054,0.00,0.000000003910507151829517,-0.000000002601995026514880,0.000000018731746197029138,0.00},
	{6,1,-2,-1,-0.00256,-0.08,0.000000023463042910977102,-0.000000007805985079544638,0.000000093658730985145685,0.00},
	{6,1,-2,1,-0.00137,-0.05,0.000000011731521455488551,-0.000000005203990053029759,0.000000049951323192077706,0.00},
	{6,1,-1,-3,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,-1,-1,-0.00350,-0.19,0.000000031284057214636136,-0.000000006938653404039679,0.000000131122223379203961,0.00},
	{6,1,-1,1,-0.00116,-0.07,0.000000007821014303659034,-0.000000003469326702019840,0.000000043707407793067991,0.00},
	{6,1,0,-3,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,0,-1,-0.00153,-0.10,0.000000011731521455488551,-0.000000002601995026514880,0.000000056195238591087415,0.00},
	{6,1,0,1,-0.00047,-0.04,-0.000000000000000000000000,-0.000000001734663351009920,0.000000018731746197029138,0.00},
	{6,1,1,-1,-0.00031,-0.02,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{6,1,1,1,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,2,-1,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,2,1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,2,-3,-1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,2,-3,1,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,2,-2,-1,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000006243915399009713,0.00},
	{6,2,-2,1,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,2,-1,-1,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,2,-1,1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,-1,-3,-1,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,-1,-3,1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,-1,-2,-1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{7,-1,-2,1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,-1,-1,-1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,0,-4,1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,0,-3,-1,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{7,0,-3,1,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.04},
	{7,0,-2,-1,-0.00024,-0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.09},
	{7,0,-2,1,-0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.04},
	{7,0,-1,-3,-0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,0,-1,-1,-0.00013,-0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.05},
	{7,0,-1,1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{7,0,0,-1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.01},
	{7,1,-2,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,1,-2,1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,1,-1,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,1,-1,1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,-3,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,-3,1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,-2,-1,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,-2,1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,-1,-1,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,-1,1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,0,-1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,-4,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,-4,1,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,-3,-1,0.00019,0.01,-0.000000000000000000000000,0.000000000867331675504960,-0.000000006243915399009713,0.00},
	{8,-1,-3,1,0.00022,0.02,-0.000000000000000000000000,0.000000000867331675504960,-0.000000006243915399009713,0.00},
	{8,-1,-2,-1,0.00038,0.03,-0.000000000000000000000000,0.000000001734663351009920,-0.000000012487830798019427,0.00},
	{8,-1,-2,1,0.00025,0.02,-0.000000000000000000000000,0.000000000867331675504960,-0.000000006243915399009713,0.00},
	{8,-1,-1,-1,0.00029,0.03,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{8,-1,-1,1,0.00015,0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,0,-1,0.00011,0.01,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,0,1,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,1,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,1,1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-5,1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-4,-1,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-4,1,0.00042,0.03,-0.000000000000000000000000,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{8,0,-3,-1,0.00107,0.08,-0.000000007821014303659034,0.000000005203990053029759,-0.000000000000000000000000,0.00},
	{8,0,-3,1,0.00108,0.09,-0.000000007821014303659034,0.000000005203990053029759,-0.000000000000000000000000,0.00},
	{8,0,-2,-3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-2,-1,0.00189,0.15,-0.000000015642028607318068,0.000000006938653404039679,-0.000000000000000000000000,0.00},
	{8,0,-2,1,0.00111,0.11,-0.000000007821014303659034,0.000000004336658377524799,-0.000000000000000000000000,0.00},
	{8,0,-1,-3,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-1,-1,0.00130,0.12,-0.000000011731521455488551,0.000000003469326702019840,-0.000000000000000000000000,0.00},
	{8,0,-1,1,0.00060,0.06,-0.000000003910507151829517,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{8,0,0,-1,0.00045,0.04,-0.000000000000000000000000,0.000000000867331675504960,-0.000000000000000000000000,0.00},
	{8,0,0,1,0.00020,0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,1,-1,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,1,1,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,2,-1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,-3,-1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,-3,1,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,-2,-1,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,-2,1,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,-1,-1,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,-1,1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,0,-1,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-4,-1,0.00001,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-4,1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-3,-1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-3,1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-2,-1,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-2,1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-1,-1,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,0,0,0,0,0,0,0,0}
};

struct elp82b_term1 elp3[] = {
	{0,0,0,0,385000.52719,-7992.63,0.000004325020909923445934,0.001871535228058006632840,0.000002828493675751400103,11.39},
	{0,0,0,2,-3.14837,-204.48,0.000054332586367519305614,0.000013846082867761178622,0.000000243512700561378804,0.12},
	{0,0,0,4,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,1,-4,0.00038,0.03,-0.000000011731521455488551,-0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{0,0,1,-2,79.66183,-359.45,-0.001401443642565510395298,0.000126111760281772175953,0.000001479807949565302098,0.85},
	{0,0,1,0,-20905.32206,6888.23,0.000014011347125005159020,-0.032987376530191674095516,-0.000013930175255190668568,1.77},
	{0,0,1,2,-0.10326,-9.14,0.000001771459739778771265,0.000000700803993808007606,-0.000000000000000000000000,0.02},
	{0,0,2,-4,-0.00837,0.07,0.000000293288036387213777,-0.000000026887281940653757,-0.000000000000000000000000,0.00},
	{0,0,2,-2,-4.42124,18.29,0.000077783897757040918624,-0.000014042099826425300953,-0.000000087414815586135983,-0.04},
	{0,0,2,0,-569.92332,374.44,0.000000778190923214073835,-0.001798614317439927020800,-0.000003615227016026623816,0.44},
	{0,0,2,2,-0.00102,-0.37,0.000000015642028607318068,0.000000053774563881307513,-0.000000000000000000000000,0.00},
	{0,0,3,-4,0.00033,0.00,-0.000000011731521455488551,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{0,0,3,-2,-0.00111,0.00,-0.000000000000000000000000,-0.000000004336658377524799,-0.000000000000000000000000,0.00},
	{0,0,3,0,-23.21032,26.49,0.000000054747100125613245,-0.000109859699346160239472,-0.000000393366670137611909,0.05},
	{0,0,3,2,0.00026,0.00,-0.000000000000000000000000,0.000000005203990053029759,-0.000000000000000000000000,0.00},
	{0,0,4,-4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,4,-2,0.00027,0.00,-0.000000000000000000000000,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{0,0,4,0,-1.11693,1.98,-0.000000000000000000000000,-0.000007047937195153304739,-0.000000037463492394058276,0.00},
	{0,0,4,2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,5,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,5,0,-0.05888,0.15,-0.000000000000000000000000,-0.000000464022446395153497,-0.000000000000000000000000,0.00},
	{0,0,6,0,-0.00329,0.00,-0.000000000000000000000000,-0.000000031223940318178553,-0.000000000000000000000000,0.00},
	{0,0,7,0,-0.00019,0.00,-0.000000000000000000000000,-0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{0,1,-6,0,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-5,0,-0.00174,-0.03,-0.000000000000000000000000,-0.000000013877306808079359,0.000000062439153990097136,0.00},
	{0,1,-4,0,-0.02674,-0.56,-0.000000000000000000000000,-0.000000168262345047962217,0.000000999026463841554180,0.00},
	{0,1,-3,0,-0.42242,-9.35,-0.000000078210143036590340,-0.000001998332180363427369,0.000015797105959494574105,0.00},
	{0,1,-3,2,0.00015,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-2,-2,-0.00019,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-2,0,-7.00293,-161.63,-0.000001286556852951911154,-0.000022097876428515368988,0.000261963470565452528904,-0.12},
	{0,1,-2,2,-0.05020,-1.17,0.000000875953602009811919,-0.000000158721696617407655,0.000001879418535101923431,0.00},
	{0,1,-2,4,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,-1,-2,-0.00769,-0.15,0.000000132957243162203579,-0.000000003469326702019840,0.000000287220108354446782,0.00},
	{0,1,-1,0,-129.62476,-3122.77,-0.000024166934198306415420,-0.000204903639011344747018,0.004850173579304360715891,-0.74},
	{0,1,-1,2,0.33465,7.26,-0.000005830566163377809618,0.000000519531673627470971,-0.000012525294290413482943,0.00},
	{0,1,-1,4,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,0,-2,-0.18568,-4.48,0.000003241810428866669454,0.000000046835910477267836,0.000006943233923698799845,0.00},
	{0,1,0,0,48.89010,1082.40,0.000010163408087604914692,0.000013598026008566761161,-0.001827281841520192549183,-3.76},
	{0,1,0,2,-0.15803,-3.35,0.000002760818049191638701,-0.000000006938653404039679,0.000005906743967463188593,-0.03},
	{0,1,1,-4,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,1,-2,-0.24811,-2.72,0.000004332841924227105074,-0.000000390299253977231954,0.000009284702198327441706,0.00},
	{0,1,1,0,104.75896,2165.07,0.000018621835057012158904,0.000167316953521661810787,-0.003920598186445991423232,-0.60},
	{0,1,1,2,-0.00682,-0.05,0.000000121225721706715028,-0.000000014744638483584319,0.000000256000531359398233,0.00},
	{0,1,2,-4,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,2,-2,0.03265,0.36,-0.000000567023537015279916,0.000000104079801060595184,-0.000001223807418205903600,0.00},
	{0,1,2,0,5.75105,119.47,0.000001024552873779333566,0.000018279882392942533123,-0.000215265227296258847495,-0.09},
	{0,1,2,2,-0.00030,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,3,-2,-0.00080,-0.04,0.000000015642028607318068,-0.000000003469326702019840,0.000000031219576995048568,0.00},
	{0,1,3,0,0.35509,7.33,0.000000062568114429272272,0.000001689562103883661777,-0.000013293295884491678225,0.00},
	{0,1,4,-2,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,1,4,0,0.02304,0.47,-0.000000000000000000000000,0.000000145711721484833263,-0.000000861660325063340292,0.00},
	{0,1,5,0,0.00153,0.03,-0.000000000000000000000000,0.000000012142643457069439,-0.000000056195238591087415,0.00},
	{0,1,6,0,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,-5,0,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,-4,0,-0.00066,-0.02,-0.000000000000000000000000,-0.000000004336658377524799,0.000000049951323192077706,0.00},
	{0,2,-3,0,-0.00938,-0.29,-0.000000000000000000000000,-0.000000044233915450752957,0.000000699318524689087862,0.00},
	{0,2,-2,0,-0.13618,-4.10,-0.000000035194564366465653,-0.000000430196511050460106,0.000010183826015784840235,0.00},
	{0,2,-2,2,-0.00099,-0.03,0.000000015642028607318068,-0.000000003469326702019840,0.000000074926984788116553,0.00},
	{0,2,-1,-2,-0.00031,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000024975661596038853,0.00},
	{0,2,-1,0,-2.11728,-59.78,-0.000000477081872523201077,-0.000003356573584204194732,0.000158351938434285347077,0.00},
	{0,2,-1,2,0.00450,0.12,-0.000000078210143036590340,0.000000006938653404039679,-0.000000337171431546524501,0.00},
	{0,2,0,-2,-0.00558,-0.14,0.000000097762678795737926,0.000000000000000000000000,0.000000418342331733650769,0.00},
	{0,2,0,0,1.06575,16.47,0.000000234630429109771021,0.000000284484789565626816,-0.000079634896998969883206,0.00},
	{0,2,0,2,-0.00342,-0.07,0.000000058657607277442755,0.000000000000000000000000,0.000000256000531359398233,0.00},
	{0,2,1,-2,-0.00237,0.00,0.000000043015578670124687,-0.000000003469326702019840,0.000000174829631172271966,0.00},
	{0,2,1,0,1.16562,22.20,0.000000152509778921351164,0.000001863895770660158596,-0.000087165058970175581486,0.00},
	{0,2,1,2,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,2,2,-2,0.00018,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{0,2,2,0,0.05072,0.70,-0.000000000000000000000000,0.000000161323691643922533,-0.000003790056647198895941,0.00},
	{0,2,3,0,0.00228,0.00,-0.000000000000000000000000,0.000000011275311781564479,-0.000000168585715773262251,0.00},
	{0,2,4,0,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,-3,0,-0.00021,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000024975661596038853,0.00},
	{0,3,-2,0,-0.00287,-0.10,-0.000000000000000000000000,-0.000000008673316755049599,0.000000318439685349495383,0.00},
	{0,3,-2,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,-1,0,-0.03894,-1.14,-0.000000011731521455488551,-0.000000061580548960852141,0.000004364496863907789398,0.00},
	{0,3,-1,2,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,0,-2,-0.00017,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000018731746197029138,0.00},
	{0,3,0,0,0.02127,0.03,-0.000000000000000000000000,0.000000006938653404039679,-0.000002385175682421710316,0.00},
	{0,3,0,2,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,1,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,3,1,0,0.01912,0.39,-0.000000000000000000000000,0.000000030356608642673595,-0.000002141662981860331406,0.00},
	{0,3,2,0,0.00078,0.00,-0.000000000000000000000000,0.000000002601995026514880,-0.000000087414815586135983,0.00},
	{0,3,3,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,4,-2,0,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,4,-1,0,-0.00073,-0.02,-0.000000000000000000000000,0.000000000000000000000000,0.000000106146561783165128,0.00},
	{0,4,0,0,0.00034,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000049951323192077706,0.00},
	{0,4,1,0,0.00037,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000056195238591087415,0.00},
	{1,-4,0,0,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{1,-3,-1,0,0.00035,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000037463492394058276,0.13},
	{1,-3,0,0,-0.00161,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000181073546571281654,-0.63},
	{1,-2,-3,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-2,-2,0,0.00029,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,0.11},
	{1,-2,-1,0,0.00844,0.10,-0.000000000000000000000000,0.000000014744638483584319,-0.000000630635455299980971,3.28},
	{1,-2,0,-2,-0.00024,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000018731746197029138,-0.09},
	{1,-2,0,0,-0.02948,0.18,-0.000000000000000000000000,-0.000000002601995026514880,0.000002197858220451418814,-11.46},
	{1,-2,0,2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-2,1,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-2,1,0,0.00159,0.16,-0.000000000000000000000000,0.000000002601995026514880,-0.000000118634392581184544,0.62},
	{1,-2,2,0,0.00036,0.03,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,0.14},
	{1,-2,3,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-1,-4,0,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.04},
	{1,-1,-3,0,0.00065,0.00,-0.000000000000000000000000,0.000000003469326702019840,-0.000000024975661596038853,0.25},
	{1,-1,-2,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-1,-2,0,-0.00422,-0.24,-0.000000000000000000000000,-0.000000011275311781564479,0.000000162341800374252536,-1.64},
	{1,-1,-2,2,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{1,-1,-1,-2,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.04},
	{1,-1,-1,0,0.11411,0.00,0.000000007821014303659034,0.000000200353617041645734,-0.000004245862471326604258,44.37},
	{1,-1,-1,2,0.00021,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.08},
	{1,-1,0,-2,-0.01366,-0.21,0.000000238540936261600538,0.000000000000000000000000,0.000000512001062718796467,-5.31},
	{1,-1,0,0,0.49757,32.61,0.000000555292015559791417,0.000000012142643457069439,-0.000018731746197029138277,193.46},
	{1,-1,0,2,-0.00074,-0.03,0.000000011731521455488551,0.000000000000000000000000,0.000000024975661596038853,-0.29},
	{1,-1,1,-2,0.00044,0.00,-0.000000007821014303659034,0.000000000000000000000000,-0.000000018731746197029138,0.17},
	{1,-1,1,0,0.10998,5.32,0.000000066478621581101789,0.000000185608978558061415,-0.000004114740247947401012,42.76},
	{1,-1,1,2,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{1,-1,2,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,-1,2,0,0.01121,0.52,-0.000000000000000000000000,0.000000036427930371208316,-0.000000418342331733650769,4.36},
	{1,-1,3,0,0.00097,0.04,-0.000000000000000000000000,0.000000004336658377524799,-0.000000037463492394058276,0.38},
	{1,-1,4,0,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{1,0,-6,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,0,-5,0,-0.00043,0.00,-0.000000000000000000000000,-0.000000003469326702019840,-0.000000000000000000000000,-0.17},
	{1,0,-4,0,-0.00636,-0.18,-0.000000000000000000000000,-0.000000039897257073228158,-0.000000000000000000000000,-2.47},
	{1,0,-3,-2,-0.00019,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.07},
	{1,0,-3,0,-0.09938,-2.83,-0.000000035194564366465653,-0.000000472695763150203162,0.000000024975661596038853,-38.64},
	{1,0,-3,2,-0.00048,0.00,0.000000007821014303659034,-0.000000002601995026514880,-0.000000000000000000000000,-0.19},
	{1,0,-2,-2,-0.00278,-0.04,0.000000046926085821954204,-0.000000008673316755049599,-0.000000000000000000000000,-1.08},
	{1,0,-2,0,-1.73852,-48.13,-0.000000621770637140893260,-0.000005525770104642099752,0.000000312195769950485641,-675.99},
	{1,0,-2,2,0.00457,0.03,-0.000000078210143036590340,0.000000013877306808079359,-0.000000000000000000000000,1.78},
	{1,0,-1,-2,-0.04232,-0.60,0.000000731264837392119736,-0.000000066784539013881911,-0.000000000000000000000000,-16.45},
	{1,0,-1,0,-8.37909,-219.27,-0.000003726713315693529353,-0.000013536445459605907603,0.000000524488893516815844,-3257.99},
	{1,0,-1,2,-0.02471,-0.50,0.000000422334772397587892,-0.000000039897257073228158,-0.000000000000000000000000,-9.61},
	{1,0,0,-2,-0.79564,-11.23,0.000013780627203047218204,-0.000000019081296861109118,-0.000000000000000000000000,-309.37},
	{1,0,0,0,108.74265,2351.06,0.000047113790165242021952,0.000006055709758375628966,-0.000001255026995200952043,42281.56},
	{1,0,0,2,-0.01874,-0.51,0.000000324572093601849913,-0.000000011275311781564479,-0.000000000000000000000000,-7.29},
	{1,0,1,-4,0.00017,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.06},
	{1,0,1,-2,0.06055,0.87,-0.000001044105409538480992,0.000000098875811007565414,-0.000000000000000000000000,23.54},
	{1,0,1,0,6.32199,138.54,0.000002635681820333094580,0.000010243187087713575165,0.000000349659262344543931,2458.13},
	{1,0,1,2,-0.00164,-0.05,0.000000027373550062806622,-0.000000003469326702019840,-0.000000000000000000000000,-0.64},
	{1,0,2,-2,0.00203,0.00,-0.000000035194564366465653,0.000000006071321728534720,-0.000000000000000000000000,0.79},
	{1,0,2,0,0.37852,7.87,0.000000156420286073180681,0.000001207325692302904159,0.000000056195238591087415,147.18},
	{1,0,2,2,-0.00013,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.05},
	{1,0,3,-2,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.04},
	{1,0,3,0,0.02368,0.46,0.000000007821014303659034,0.000000112753117815644783,-0.000000000000000000000000,9.21},
	{1,0,4,0,0.00152,0.03,-0.000000000000000000000000,0.000000009540648430554559,-0.000000000000000000000000,0.59},
	{1,0,5,0,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.04},
	{1,1,-5,0,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{1,1,-4,0,0.00101,0.00,-0.000000000000000000000000,0.000000006071321728534720,-0.000000037463492394058276,0.39},
	{1,1,-3,0,0.01729,0.21,-0.000000000000000000000000,0.000000082396509172971181,-0.000000649367201497010143,6.72},
	{1,1,-3,2,0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.05},
	{1,1,-2,-2,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{1,1,-2,0,0.33226,4.67,0.000000039105071518295170,0.000001057277312440545957,-0.000012425391644029327927,129.18},
	{1,1,-2,2,-0.00148,0.00,0.000000027373550062806622,-0.000000004336658377524799,0.000000056195238591087415,-0.58},
	{1,1,-1,-2,0.00156,0.00,-0.000000027373550062806622,0.000000002601995026514880,-0.000000056195238591087415,0.61},
	{1,1,-1,0,0.85127,-2.92,0.000000195525357591475851,0.000001382526690754905981,-0.000031787773296358444528,330.99},
	{1,1,-1,2,0.00331,-0.02,-0.000000058657607277442755,0.000000005203990053029759,-0.000000124878307980194272,1.29},
	{1,1,0,-2,0.03379,0.04,-0.000000578755058470768520,0.000000009540648430554559,-0.000001261270910599961943,13.14},
	{1,1,0,0,-16.67533,-4.78,-0.000004227258231127707956,-0.000001679154123777602158,0.000622936707613001980008,-6483.73},
	{1,1,0,2,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{1,1,1,-2,-0.00562,0.00,0.000000097762678795737926,-0.000000009540648430554559,0.000000212293123566330255,-2.18},
	{1,1,1,0,-0.93335,-1.07,-0.000000250272457717089090,-0.000001568135669312967210,0.000034866023588070239371,-362.91},
	{1,1,2,-2,-0.00037,-0.02,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.14},
	{1,1,2,0,-0.05904,-0.12,-0.000000015642028607318068,-0.000000192547631962101099,0.000002204102135850428715,-22.96},
	{1,1,3,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,1,3,0,-0.00392,0.00,-0.000000000000000000000000,-0.000000019081296861109118,0.000000143610054177223391,-1.52},
	{1,1,4,0,-0.00027,0.00,-0.000000000000000000000000,-0.000000001734663351009920,-0.000000000000000000000000,-0.10},
	{1,2,-4,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,2,-3,0,0.00028,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000018731746197029138,0.11},
	{1,2,-2,0,0.00324,0.14,-0.000000000000000000000000,0.000000010407980106059518,-0.000000243512700561378804,1.26},
	{1,2,-1,0,0.00438,0.14,-0.000000000000000000000000,0.000000006938653404039679,-0.000000324683600748505071,1.70},
	{1,2,0,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,2,0,0,0.03729,0.60,0.000000011731521455488551,0.000000006071321728534720,-0.000002791030183357341549,14.50},
	{1,2,1,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{1,2,1,0,0.00646,0.12,-0.000000000000000000000000,0.000000011275311781564479,-0.000000480781485723747919,2.51},
	{1,2,2,0,0.00067,0.00,-0.000000000000000000000000,0.000000002601995026514880,-0.000000049951323192077706,0.26},
	{1,2,3,0,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{1,3,-2,0,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{1,3,-1,0,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{1,3,0,0,0.00054,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000062439153990097136,0.21},
	{1,3,1,0,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{2,-6,0,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-5,-1,0,-0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000024975661596038853,0.00},
	{2,-5,0,0,-0.00058,-0.03,-0.000000000000000000000000,0.000000000000000000000000,0.000000106146561783165128,0.00},
	{2,-5,1,0,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-4,-2,0,0.00036,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000056195238591087415,0.00},
	{2,-4,-1,0,-0.00426,-0.08,-0.000000000000000000000000,-0.000000006938653404039679,0.000000636879370698990766,0.00},
	{2,-4,0,-2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-4,0,0,-0.01578,-0.66,-0.000000000000000000000000,0.000000000000000000000000,0.000002360200020825671138,0.00},
	{2,-4,1,0,-0.00113,-0.05,-0.000000000000000000000000,-0.000000001734663351009920,0.000000168585715773262251,0.00},
	{2,-4,2,0,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{2,-3,-4,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,-3,0,0.00046,0.00,-0.000000000000000000000000,0.000000001734663351009920,-0.000000049951323192077706,0.00},
	{2,-3,-2,0,0.01116,0.26,-0.000000000000000000000000,0.000000035560598695703352,-0.000001248783079801942566,0.00},
	{2,-3,-2,2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,-1,-2,0.00026,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000031219576995048568,0.00},
	{2,-3,-1,0,-0.14808,-2.64,-0.000000011731521455488551,-0.000000235046884061844128,0.000016596327130567814230,0.00},
	{2,-3,-1,2,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,0,-2,0.00104,0.03,-0.000000019552535759147585,0.000000000000000000000000,-0.000000118634392581184544,0.00},
	{2,-3,0,0,-0.41076,-15.67,-0.000000035194564366465653,-0.000000044233915450752957,0.000046023900406100586773,0.00},
	{2,-3,1,-2,0.00027,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000031219576995048568,0.00},
	{2,-3,1,0,-0.02855,-1.20,-0.000000000000000000000000,-0.000000048570573828277757,0.000003196884684292973206,0.00},
	{2,-3,2,-2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-3,2,0,-0.00209,-0.10,-0.000000000000000000000000,-0.000000006938653404039679,0.000000237268785162369089,0.00},
	{2,-3,3,0,-0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000018731746197029138,0.00},
	{2,-2,-5,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,-4,0,0.00067,0.00,-0.000000000000000000000000,0.000000004336658377524799,-0.000000049951323192077706,0.00},
	{2,-2,-3,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,-3,0,0.01517,0.23,-0.000000000000000000000000,0.000000071988529066911668,-0.000001130148687220758061,0.00},
	{2,-2,-2,-2,0.00041,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000031219576995048568,0.00},
	{2,-2,-2,0,0.34304,6.87,0.000000011731521455488551,0.000001084164594381199796,-0.000025625028797535861461,0.00},
	{2,-2,-2,2,0.00099,0.00,-0.000000015642028607318068,0.000000003469326702019840,-0.000000074926984788116553,0.00},
	{2,-2,-1,-2,0.00957,0.13,-0.000000168151807528669232,0.000000014744638483584319,-0.000000718050270886116928,0.00},
	{2,-2,-1,0,-4.95049,-84.90,-0.000000355856150816486049,-0.000007836341688187312303,0.000369789645590951228642,0.03},
	{2,-2,-1,2,0.00168,0.04,-0.000000031284057214636136,0.000000003469326702019840,-0.000000124878307980194272,0.00},
	{2,-2,0,-2,0.02839,0.78,-0.000000496634408282348715,-0.000000009540648430554559,-0.000002122931235663302129,0.00},
	{2,-2,0,0,-9.88519,-346.35,-0.000000778190923214073835,-0.000001255896266131182028,0.000738224361540317322063,0.07},
	{2,-2,1,-4,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,1,-2,0.00792,0.09,-0.000000140778257465862613,0.000000012142643457069439,-0.000000593171962905922735,0.00},
	{2,-2,1,0,-0.65758,-25.02,-0.000000070389128732931306,-0.000001133602499884982669,0.000049102150697812381615,0.00},
	{2,-2,2,-2,0.00084,0.02,-0.000000015642028607318068,0.000000002601995026514880,-0.000000062439153990097136,0.00},
	{2,-2,2,0,-0.04608,-1.86,-0.000000000000000000000000,-0.000000152650374888872948,0.000003440397384854351692,0.00},
	{2,-2,3,-2,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-2,3,0,-0.00335,-0.14,-0.000000000000000000000000,-0.000000016479301834594237,0.000000249756615960388545,0.00},
	{2,-2,4,0,-0.00025,0.00,-0.000000000000000000000000,-0.000000001734663351009920,0.000000018731746197029138,0.00},
	{2,-2,5,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-6,0,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-5,0,0.00119,0.00,-0.000000000000000000000000,0.000000009540648430554559,-0.000000043707407793067991,0.00},
	{2,-1,-4,-2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,-4,0,0.02334,0.28,-0.000000000000000000000000,0.000000147446384835843164,-0.000000874148155861359775,0.00},
	{2,-1,-3,-2,0.00079,0.00,-0.000000015642028607318068,0.000000003469326702019840,-0.000000031219576995048568,0.00},
	{2,-1,-3,0,0.49506,7.68,-0.000000000000000000000000,0.000002345264850565411422,-0.000018494477411866769691,0.00},
	{2,-1,-3,2,-0.00046,0.00,0.000000007821014303659034,-0.000000001734663351009920,0.000000018731746197029138,0.00},
	{2,-1,-2,-2,0.01518,0.17,-0.000000265914486324407158,0.000000046835910477267836,-0.000000568196301309883875,0.00},
	{2,-1,-2,0,10.05654,188.87,0.000000504455422586007749,0.000031775563263799710642,-0.000375615218658227308438,-0.03},
	{2,-1,-2,2,0.03024,0.36,-0.000000531828972648814315,0.000000095406484305545599,-0.000001130148687220758061,0.00},
	{2,-1,-1,-2,0.32336,4.56,-0.000005638951312938163654,0.000000496981050064342043,-0.000012075732381684783678,0.00},
	{2,-1,-1,0,-152.14314,-2564.20,-0.000011887941741561731753,-0.000240401789826411716030,0.005680614327372652920534,0.06},
	{2,-1,-1,2,0.03734,0.84,-0.000000656965201507358860,0.000000073723192417921582,-0.000001392393133979166036,0.00},
	{2,-1,0,-4,-0.00035,0.00,0.000000011731521455488551,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{2,-1,0,-2,0.65710,17.83,-0.000011457785954860484986,-0.000000253260849247448276,-0.000024513611856512132253,0.00},
	{2,-1,0,0,-204.59357,-6583.80,-0.000015168857241946696483,-0.000032780800675709958927,0.007633698576352092313169,0.27},
	{2,-1,0,2,0.00108,-0.09,-0.000000019552535759147585,0.000000018213965185604158,-0.000000037463492394058276,0.00},
	{2,-1,1,-4,-0.00085,0.00,0.000000031284057214636136,0.000000000000000000000000,0.000000031219576995048568,0.00},
	{2,-1,1,-2,0.20942,1.81,-0.000003699339765630723634,0.000000331320700042894678,-0.000007804894248762140666,0.00},
	{2,-1,1,0,-12.83185,-434.14,-0.000001165331131245195967,-0.000022552358226479963740,0.000478602359249493498547,0.02},
	{2,-1,1,2,0.00000,0.00,-0.000000000000000000000000,0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{2,-1,2,-4,0.00013,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,2,-2,0.01804,0.34,-0.000000316751079298190879,0.000000057243890583327355,-0.000000674342863093049003,0.00},
	{2,-1,2,0,-0.84883,-29.75,-0.000000086031157340249375,-0.000002844847895656268052,0.000031644163242181224023,0.00},
	{2,-1,3,-2,0.00127,0.03,-0.000000023463042910977102,0.000000006071321728534720,-0.000000049951323192077706,0.00},
	{2,-1,3,0,-0.05850,-2.10,-0.000000000000000000000000,-0.000000288821447943151622,0.000002179126474254389961,0.00},
	{2,-1,4,-2,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,-1,4,0,-0.00413,-0.15,-0.000000000000000000000000,-0.000000026887281940653757,0.000000156097884975242821,0.00},
	{2,-1,5,0,-0.00030,0.00,-0.000000000000000000000000,-0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{2,-1,6,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-7,0,0.00020,0.00,-0.000000000000000000000000,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{2,0,-6,0,0.00304,0.06,-0.000000000000000000000000,0.000000028621945291663678,-0.000000000000000000000000,0.00},
	{2,0,-5,-2,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-5,0,0.04740,0.93,-0.000000000000000000000000,0.000000374687283818142685,-0.000000000000000000000000,0.00},
	{2,0,-5,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-4,-2,0.00188,0.03,-0.000000031284057214636136,0.000000012142643457069439,-0.000000000000000000000000,0.00},
	{2,0,-4,0,0.77854,15.43,0.000000050836592973783721,0.000004918637931788627765,-0.000000031219576995048568,0.00},
	{2,0,-4,2,0.00048,0.02,-0.000000007821014303659034,0.000000003469326702019840,-0.000000000000000000000000,0.00},
	{2,0,-3,-2,0.02910,0.44,-0.000000508365929737837213,0.000000136171073054278701,-0.000000000000000000000000,0.00},
	{2,0,-3,0,14.40262,282.85,0.000000918969180679936554,0.000068258135530564834959,-0.000000362147093142563308,0.14},
	{2,0,-3,2,-0.02008,-0.43,0.000000348035136512827015,-0.000000094539152630040635,-0.000000000000000000000000,0.00},
	{2,0,-3,4,-0.00018,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-2,-4,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-2,-2,0.47263,7.20,-0.000008235528061752961688,0.000001467525194954392305,-0.000000000000000000000000,0.00},
	{2,0,-2,0,246.15768,4806.36,0.000020248606032173239680,0.000777381574770015927427,0.000000268488362157417663,1.11},
	{2,0,-2,2,0.77405,9.68,-0.000013549907281089275694,0.000002443273329897472164,0.000000024975661596038853,0.00},
	{2,0,-2,4,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-1,-4,-0.00039,0.00,0.000000015642028607318068,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,-1,-2,8.75170,133.45,-0.000152513689428502983341,0.000013528639474526362572,0.000000174829631172271966,0.20},
	{2,0,-1,0,-3699.10468,-63127.05,-0.000319879485019654503149,-0.005831655435969135617413,-0.000092322533089757627791,-15.95},
	{2,0,-1,2,0.59633,12.13,-0.000010464517138295788615,0.000001254161602780172021,0.000000049951323192077706,0.03},
	{2,0,0,-4,-0.00745,-0.11,0.000000262003979172577641,-0.000000008673316755049599,-0.000000000000000000000000,0.00},
	{2,0,0,-2,10.32129,282.08,-0.000179945897098587051987,-0.000005269907260368136412,0.000000805465086472252990,0.06},
	{2,0,0,0,-2955.96651,-86674.51,-0.000198649852805787645836,-0.000658971719766727830579,-0.000202015638819560261865,-19.09},
	{2,0,0,2,0.03143,-0.69,-0.000000559202522711620881,0.000000259332170975983037,-0.000000000000000000000000,0.00},
	{2,0,1,-4,-0.01866,-0.11,0.000000653054694355529290,-0.000000028621945291663678,-0.000000000000000000000000,0.00},
	{2,0,1,-2,4.13118,20.86,-0.000073075647146238182457,0.000006512793551366743811,0.000000474537570324738177,0.00},
	{2,0,1,0,-170.73274,-4963.30,-0.000011622027255237324384,-0.000310431883970033195303,-0.000016746181100144048447,-1.82},
	{2,0,1,2,0.00181,-0.12,-0.000000031284057214636136,0.000000027754613616158717,-0.000000000000000000000000,0.00},
	{2,0,2,-4,0.00219,0.00,-0.000000078210143036590340,0.000000006938653404039679,-0.000000000000000000000000,0.00},
	{2,0,2,-2,0.28399,2.90,-0.000005017180675797270077,0.000000897688284147633458,0.000000037463492394058276,0.00},
	{2,0,2,0,-10.44472,-300.48,-0.000000707801794481142634,-0.000035625648571366228250,-0.000001398637049378175725,-0.17},
	{2,0,2,2,0.00014,0.00,-0.000000000000000000000000,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{2,0,3,-4,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,3,-2,0.01811,0.19,-0.000000320661586450020396,0.000000085865835874991023,-0.000000000000000000000000,0.00},
	{2,0,3,0,-0.66968,-19.02,-0.000000046926085821954204,-0.000003347032935773640540,-0.000000118634392581184544,0.00},
	{2,0,4,-2,0.00119,0.00,-0.000000019552535759147585,0.000000007805985079544638,-0.000000000000000000000000,0.00},
	{2,0,4,0,-0.04422,-1.24,-0.000000000000000000000000,-0.000000291423442969666527,-0.000000000000000000000000,0.00},
	{2,0,5,-2,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,0,5,0,-0.00298,-0.08,-0.000000000000000000000000,-0.000000024285286914138878,-0.000000000000000000000000,0.00},
	{2,0,6,0,-0.00020,0.00,-0.000000000000000000000000,-0.000000001734663351009920,-0.000000000000000000000000,0.00},
	{2,1,-6,0,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-5,0,0.00116,0.08,-0.000000000000000000000000,0.000000009540648430554559,-0.000000043707407793067991,0.00},
	{2,1,-4,-2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-4,0,0.01417,1.08,-0.000000000000000000000000,0.000000089335162577010865,-0.000000530732808915825532,0.00},
	{2,1,-3,-2,0.00021,0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,-3,0,0.16858,15.79,0.000000093852171643908409,0.000000794475814762543224,-0.000006350061960792877534,0.05},
	{2,1,-3,2,0.00030,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{2,1,-2,-2,0.00052,0.27,-0.000000007821014303659034,0.000000000000000000000000,-0.000000018731746197029138,0.00},
	{2,1,-2,0,0.14368,122.13,0.000000746906865999437699,0.000000397237907381271612,-0.000005763133913285965546,0.13},
	{2,1,-2,2,-0.00203,0.31,0.000000039105071518295170,-0.000000006938653404039679,0.000000074926984788116553,0.00},
	{2,1,-1,-2,-0.04736,2.58,0.000000844669544795175783,-0.000000077192519119941424,0.000001760784142520738927,0.00},
	{2,1,-1,0,24.20935,-837.26,-0.000005200974511933257748,0.000038972681507139864132,-0.000901277968270057039737,0.26},
	{2,1,-1,2,-0.00588,-0.10,0.000000101673185947567443,-0.000000012142643457069439,0.000000218537038965339944,0.00},
	{2,1,0,-4,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,0,-2,-0.13572,-4.94,0.000002361946319705028494,0.000000046835910477267836,0.000005076303219394896849,0.03},
	{2,1,0,0,30.82498,873.36,0.000003284826007536794300,0.000008187611016766821798,-0.001151733902755134588899,3.86},
	{2,1,0,2,-0.00143,-0.04,0.000000023463042910977102,-0.000000003469326702019840,0.000000056195238591087415,0.00},
	{2,1,1,-4,0.00040,0.00,-0.000000015642028607318068,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{2,1,1,-2,-0.05527,1.02,0.000000985447802261038290,-0.000000088467830901505915,0.000002054248166274195344,0.00},
	{2,1,1,0,2.61650,90.88,0.000000394961222334781219,0.000004858792046178785061,-0.000097804690810088129615,0.49},
	{2,1,1,2,-0.00015,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,2,-4,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,2,-2,-0.00537,-0.03,0.000000093852171643908409,-0.000000017346633510099197,0.000000199805292768310825,0.00},
	{2,1,2,0,0.21252,8.11,0.000000035194564366465653,0.000000732895265801691043,-0.000007942260387540355930,0.05},
	{2,1,3,-2,-0.00044,0.00,0.000000007821014303659034,-0.000000001734663351009920,0.000000018731746197029138,0.00},
	{2,1,3,0,0.01704,0.68,-0.000000000000000000000000,0.000000085865835874991023,-0.000000636879370698990766,0.00},
	{2,1,4,-2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,1,4,0,0.00135,0.06,-0.000000000000000000000000,0.000000008673316755049599,-0.000000049951323192077706,0.00},
	{2,1,5,0,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-4,0,-0.00041,0.00,-0.000000000000000000000000,-0.000000002601995026514880,0.000000031219576995048568,0.00},
	{2,2,-3,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,-3,0,-0.01036,-0.29,-0.000000000000000000000000,-0.000000050305237179287671,0.000000780489424876214130,0.00},
	{2,2,-2,-2,-0.00055,0.00,0.000000007821014303659034,-0.000000001734663351009920,0.000000043707407793067991,0.00},
	{2,2,-2,0,-0.10888,-2.72,-0.000000000000000000000000,-0.000000343463343499964092,0.000008148309595707676285,0.00},
	{2,2,-2,2,-0.00046,0.00,0.000000007821014303659034,0.000000000000000000000000,0.000000037463492394058276,0.00},
	{2,2,-1,-2,-0.01072,-0.37,0.000000183793836135987300,-0.000000014744638483584319,0.000000799221171073243301,0.00},
	{2,2,-1,0,2.35380,79.52,0.000000281556514931725226,0.000003717383561214257996,-0.000176109633829068959552,-0.06},
	{2,2,-1,2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,0,-2,0.00080,0.02,-0.000000015642028607318068,0.000000003469326702019840,-0.000000062439153990097136,0.00},
	{2,2,0,0,0.14764,4.88,0.000000019552535759147585,0.000000424992520997430349,-0.000011045486340848183597,-0.29},
	{2,2,1,-2,0.00187,0.11,-0.000000027373550062806622,0.000000000000000000000000,-0.000000137366138778213676,0.00},
	{2,2,1,0,0.00912,0.29,-0.000000000000000000000000,0.000000039897257073228158,-0.000000680586778492058797,-0.04},
	{2,2,2,-2,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,2,2,0,0.00036,0.00,-0.000000000000000000000000,0.000000002601995026514880,-0.000000024975661596038853,0.00},
	{2,3,-3,0,-0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,3,-2,0,-0.00052,-0.02,-0.000000000000000000000000,-0.000000001734663351009920,0.000000056195238591087415,0.00},
	{2,3,-1,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{2,3,-1,0,0.00208,0.14,-0.000000000000000000000000,0.000000002601995026514880,-0.000000231024869763359374,0.00},
	{2,3,0,0,-0.00024,-0.02,-0.000000000000000000000000,0.000000000000000000000000,0.000000024975661596038853,0.00},
	{2,4,-1,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-4,-1,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-4,0,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-3,-2,0,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{3,-3,-1,0,0.00065,0.03,-0.000000000000000000000000,0.000000000000000000000000,-0.000000074926984788116553,0.25},
	{3,-3,0,-2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-3,0,0,-0.00055,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000062439153990097136,-0.21},
	{3,-3,1,0,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-2,-3,0,-0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.06},
	{3,-2,-2,0,0.00224,0.03,-0.000000000000000000000000,0.000000006938653404039679,-0.000000168585715773262251,0.87},
	{3,-2,-1,-2,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,-2,-1,0,0.01389,0.55,-0.000000000000000000000000,0.000000022550623563128957,-0.000001036489956235612311,5.40},
	{3,-2,0,-2,0.00070,0.00,-0.000000011731521455488551,0.000000000000000000000000,-0.000000049951323192077706,0.27},
	{3,-2,0,0,-0.01048,-0.23,-0.000000000000000000000000,0.000000003469326702019840,0.000000780489424876214130,-4.07},
	{3,-2,1,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-2,1,0,-0.00067,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000049951323192077706,-0.26},
	{3,-2,2,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-1,-4,0,-0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.05},
	{3,-1,-3,0,-0.00334,-0.05,-0.000000000000000000000000,-0.000000015611970159089276,0.000000124878307980194272,-1.30},
	{3,-1,-2,-2,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.05},
	{3,-1,-2,0,0.05293,0.92,-0.000000000000000000000000,0.000000167395013372457240,-0.000001979321181486079082,20.58},
	{3,-1,-2,2,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,-1,-1,-2,-0.00089,0.00,0.000000015642028607318068,0.000000000000000000000000,0.000000031219576995048568,-0.34},
	{3,-1,-1,0,0.25561,9.61,0.000000058657607277442755,0.000000418921199268895642,-0.000009515727068090801662,99.38},
	{3,-1,0,-2,0.01441,0.21,-0.000000250272457717089090,0.000000000000000000000000,-0.000000536976724314835327,5.61},
	{3,-1,0,0,-0.15708,-2.88,0.000000015642028607318068,0.000000071988529066911668,0.000005881768305867149839,-61.08},
	{3,-1,1,-2,0.00049,0.00,-0.000000007821014303659034,0.000000000000000000000000,-0.000000018731746197029138,0.19},
	{3,-1,1,0,-0.00887,-0.03,-0.000000000000000000000000,-0.000000007805985079544638,0.000000337171431546524501,-3.45},
	{3,-1,2,-2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,-1,2,0,-0.00030,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.12},
	{3,0,-5,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,0,-4,0,-0.00170,0.00,-0.000000000000000000000000,-0.000000010407980106059518,-0.000000000000000000000000,-0.66},
	{3,0,-3,-2,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,0,-3,0,-0.04843,-0.72,-0.000000000000000000000000,-0.000000229842894008814345,0.000000018731746197029138,-18.83},
	{3,0,-3,2,-0.00013,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.05},
	{3,0,-2,-2,-0.00206,0.00,0.000000035194564366465653,-0.000000006071321728534720,-0.000000000000000000000000,-0.80},
	{3,0,-2,0,0.86243,16.64,0.000000132957243162203579,0.000002730360114489613514,-0.000000081170900187126268,335.34},
	{3,0,-2,2,-0.00101,-0.03,0.000000015642028607318068,-0.000000003469326702019840,-0.000000000000000000000000,-0.39},
	{3,0,-1,-2,-0.00868,0.00,0.000000152509778921351164,-0.000000012142643457069439,-0.000000000000000000000000,-3.38},
	{3,0,-1,0,3.25823,117.77,0.000000887685123465300417,0.000005369650403051205891,0.000000836684663467301538,1266.88},
	{3,0,-1,2,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{3,0,0,-4,-0.00018,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.07},
	{3,0,0,-2,0.20099,2.46,-0.000003499903900887417260,-0.000000003469326702019840,0.000000043707407793067991,78.15},
	{3,0,0,0,-1.41893,-19.43,0.000000269824993476236675,0.000000933248882843336803,0.000000393366670137611909,-551.71},
	{3,0,0,2,-0.00015,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.06},
	{3,0,1,-4,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{3,0,1,-2,0.00671,0.02,-0.000000117315214554885511,0.000000010407980106059518,-0.000000000000000000000000,2.61},
	{3,0,1,0,-0.06545,0.72,0.000000039105071518295170,-0.000000027754613616158717,0.000000068683069389106838,-25.45},
	{3,0,1,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,0,2,-2,0.00035,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.14},
	{3,0,2,0,-0.00111,0.21,-0.000000000000000000000000,0.000000002601995026514880,-0.000000000000000000000000,-0.43},
	{3,0,3,0,0.00016,0.03,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.06},
	{3,0,4,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,1,-5,0,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,1,-4,0,-0.00065,-0.03,-0.000000000000000000000000,-0.000000004336658377524799,0.000000024975661596038853,-0.25},
	{3,1,-3,0,-0.00680,-0.29,-0.000000000000000000000000,-0.000000032091271993683516,0.000000256000531359398233,-2.64},
	{3,1,-3,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,1,-2,-2,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.04},
	{3,1,-2,0,0.03810,2.03,-0.000000000000000000000000,0.000000118824439544179517,-0.000001429856626373224167,14.82},
	{3,1,-2,2,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{3,1,-1,-2,-0.00023,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.09},
	{3,1,-1,0,-0.21259,-4.00,-0.000000066478621581101789,-0.000000349534665228498852,0.000007929772556742335283,-82.66},
	{3,1,-1,2,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{3,1,0,-2,-0.00808,-0.12,0.000000140778257465862613,0.000000000000000000000000,0.000000299707939152466212,-3.14},
	{3,1,0,0,-0.10766,-3.22,-0.000000046926085821954204,-0.000000094539152630040635,0.000004008593686164235673,-41.86},
	{3,1,1,-2,-0.00018,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.07},
	{3,1,1,0,-0.01448,-0.44,-0.000000000000000000000000,-0.000000032091271993683516,0.000000536976724314835327,-5.63},
	{3,1,2,0,-0.00150,-0.05,-0.000000000000000000000000,-0.000000006071321728534720,0.000000056195238591087415,-0.58},
	{3,1,3,0,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.06},
	{3,2,-3,0,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{3,2,-2,0,0.00032,0.05,-0.000000000000000000000000,0.000000000000000000000000,-0.000000024975661596038853,0.12},
	{3,2,-1,0,0.00099,-0.05,-0.000000000000000000000000,0.000000001734663351009920,-0.000000074926984788116553,0.39},
	{3,2,0,-2,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.04},
	{3,2,0,0,0.00162,0.04,-0.000000000000000000000000,0.000000000000000000000000,-0.000000118634392581184544,0.63},
	{3,2,1,0,0.00028,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000018731746197029138,0.11},
	{3,2,2,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,3,-2,-2,0.00000,-0.03,-0.000000000000000000000000,-0.000000002601995026514880,-0.000000000000000000000000,-0.07},
	{3,3,-2,0,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{3,3,-1,0,0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.04},
	{3,3,0,-2,0.00002,0.08,0.000000023463042910977102,0.000000006071321728534720,-0.000000049951323192077706,-0.05},
	{4,-5,-1,0,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-5,0,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-4,-2,0,-0.00022,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000031219576995048568,0.00},
	{4,-4,-1,0,-0.00078,-0.05,-0.000000000000000000000000,0.000000000000000000000000,0.000000118634392581184544,0.00},
	{4,-4,0,0,-0.00045,-0.03,-0.000000000000000000000000,0.000000000000000000000000,0.000000068683069389106838,0.00},
	{4,-4,1,0,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-3,-3,0,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{4,-3,-2,0,-0.00513,-0.22,-0.000000000000000000000000,-0.000000016479301834594237,0.000000574440216708893563,0.00},
	{4,-3,-1,-2,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-3,-1,0,-0.01571,-0.87,-0.000000000000000000000000,-0.000000026887281940653757,0.000001760784142520738927,0.00},
	{4,-3,0,-2,-0.00022,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000024975661596038853,0.00},
	{4,-3,0,0,-0.00817,-0.54,-0.000000000000000000000000,-0.000000006938653404039679,0.000000917855563654427806,0.00},
	{4,-3,1,0,-0.00114,-0.08,-0.000000000000000000000000,-0.000000002601995026514880,0.000000131122223379203961,0.00},
	{4,-3,2,0,-0.00013,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{4,-2,-5,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-4,0,-0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-3,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-3,0,-0.00239,-0.12,-0.000000000000000000000000,-0.000000011275311781564479,0.000000181073546571281654,0.00},
	{4,-2,-3,2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-2,-2,-0.00036,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000024975661596038853,0.00},
	{4,-2,-2,0,-0.10834,-4.38,-0.000000015642028607318068,-0.000000342596011824459142,0.000008092114357116588454,0.00},
	{4,-2,-2,2,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,-1,-2,-0.00145,-0.04,0.000000023463042910977102,-0.000000002601995026514880,0.000000106146561783165128,0.00},
	{4,-2,-1,0,-0.27906,-14.76,-0.000000043015578670124687,-0.000000486573069958282530,0.000020829701771096400381,0.00},
	{4,-2,-1,2,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,0,-2,-0.00403,-0.18,0.000000070389128732931306,0.000000000000000000000000,0.000000299707939152466212,0.00},
	{4,-2,0,0,-0.12806,-8.09,-0.000000019552535759147585,-0.000000117089776193169589,0.000009553190560484861910,-0.02},
	{4,-2,1,-2,0.00023,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000018731746197029138,0.00},
	{4,-2,1,0,-0.01728,-1.13,-0.000000000000000000000000,-0.000000039029925397723194,0.000001286246572196000909,0.00},
	{4,-2,2,-2,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-2,2,0,-0.00184,-0.12,-0.000000000000000000000000,-0.000000006938653404039679,0.000000137366138778213676,0.00},
	{4,-2,3,0,-0.00018,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{4,-1,-6,0,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-5,0,-0.00041,0.00,-0.000000000000000000000000,-0.000000003469326702019840,0.000000012487830798019427,0.00},
	{4,-1,-4,-2,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-4,0,-0.00230,-0.06,-0.000000000000000000000000,-0.000000014744638483584319,0.000000087414815586135983,0.00},
	{4,-1,-3,-2,-0.00059,-0.02,0.000000011731521455488551,-0.000000002601995026514880,0.000000024975661596038853,0.00},
	{4,-1,-3,0,-0.04316,-2.19,-0.000000007821014303659034,-0.000000204690275419170513,0.000001617174088343515457,0.00},
	{4,-1,-3,2,0.00077,0.02,-0.000000011731521455488551,0.000000003469326702019840,-0.000000031219576995048568,0.00},
	{4,-1,-2,-2,-0.00661,-0.25,0.000000113404707403055980,-0.000000020815960212119036,0.000000249756615960388545,0.00},
	{4,-1,-2,0,-1.89710,-73.13,-0.000000308930064994531845,-0.000005999333199467807970,0.000070768537132376090840,-0.12},
	{4,-1,-2,2,0.00160,0.07,-0.000000027373550062806622,0.000000005203990053029759,-0.000000062439153990097136,0.00},
	{4,-1,-1,-4,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,-1,-2,-0.02698,-0.67,0.000000469260858219542043,-0.000000043366583775247993,0.000001005270379240563868,0.00},
	{4,-1,-1,0,-3.95812,-199.78,-0.000000602218101381745622,-0.000007003703279702551252,0.000147456306063013385839,0.15},
	{4,-1,-1,2,0.00069,0.03,-0.000000011731521455488551,0.000000002601995026514880,-0.000000024975661596038853,0.00},
	{4,-1,0,-4,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,0,-2,-0.05789,-2.54,0.000001005000338020185716,0.000000012142643457069439,0.000002147906897259341307,-0.02},
	{4,-1,0,0,-1.57145,-94.02,-0.000000230719921957941504,-0.000001602828936333165870,0.000058474267711725966159,-0.26},
	{4,-1,0,2,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,1,-4,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,1,-2,0.00272,0.12,-0.000000046926085821954204,0.000000006071321728534720,-0.000000099902646384155413,0.00},
	{4,-1,1,0,-0.20286,-12.45,-0.000000031284057214636136,-0.000000477899753203232918,0.000007542649802003733327,-0.03},
	{4,-1,2,-2,0.00055,0.02,-0.000000007821014303659034,0.000000001734663351009920,-0.000000018731746197029138,0.00},
	{4,-1,2,0,-0.02079,-1.29,-0.000000000000000000000000,-0.000000079794514146456316,0.000000774245509477204336,0.00},
	{4,-1,3,-2,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,-1,3,0,-0.00194,-0.12,-0.000000000000000000000000,-0.000000010407980106059518,0.000000074926984788116553,0.00},
	{4,-1,4,0,-0.00017,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-7,0,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-6,0,-0.00055,-0.02,-0.000000000000000000000000,-0.000000005203990053029759,-0.000000000000000000000000,0.00},
	{4,0,-5,-2,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-5,0,-0.00542,-0.21,-0.000000000000000000000000,-0.000000042499252099743030,-0.000000000000000000000000,0.00},
	{4,0,-4,-2,-0.00072,-0.03,0.000000011731521455488551,-0.000000004336658377524799,-0.000000000000000000000000,0.00},
	{4,0,-4,0,-0.02939,-0.87,-0.000000000000000000000000,-0.000000185608978558061415,-0.000000000000000000000000,0.00},
	{4,0,-4,2,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-3,-2,-0.00744,-0.27,0.000000129046736010374062,-0.000000035560598695703352,-0.000000000000000000000000,0.00},
	{4,0,-3,0,-0.51423,-25.81,-0.000000109494200251226490,-0.000002437202008168937563,0.000000118634392581184544,-0.15},
	{4,0,-3,2,0.00925,0.29,-0.000000160330793225010198,0.000000043366583775247993,-0.000000000000000000000000,0.00},
	{4,0,-2,-4,-0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-2,-2,-0.07982,-2.91,0.000001384319531747649132,-0.000000252393517571943326,-0.000000000000000000000000,0.00},
	{4,0,-2,0,-21.63627,-808.81,-0.000003703250272782552781,-0.000068346603361466338545,-0.000001729564565525690484,-1.21},
	{4,0,-2,2,0.01483,0.60,-0.000000258093472020748124,0.000000052907232205802549,-0.000000000000000000000000,0.00},
	{4,0,-1,-4,-0.00080,-0.02,0.000000027373550062806622,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,-1,-2,-0.32176,-7.98,0.000005588114719964379668,-0.000000516062346925451168,-0.000000093658730985145685,-0.11},
	{4,0,-1,0,-34.78245,-1678.73,-0.000005279184654969848300,-0.000062901495102646204122,-0.000005600792112911713222,0.88},
	{4,0,-1,2,0.00550,0.25,-0.000000097762678795737926,0.000000018213965185604158,-0.000000000000000000000000,0.00},
	{4,0,0,-4,0.00032,0.00,-0.000000011731521455488551,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,0,-2,-0.50793,-21.44,0.000008818193627375561260,0.000000118824439544179517,-0.000000174829631172271966,-0.17},
	{4,0,0,0,-11.64993,-657.42,-0.000001615039453705590584,-0.000013495680870857175825,-0.000002759810606362292895,-2.17},
	{4,0,0,2,0.00067,0.02,-0.000000011731521455488551,0.000000004336658377524799,-0.000000000000000000000000,0.00},
	{4,0,1,-4,0.00050,0.00,-0.000000015642028607318068,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,1,-2,0.01938,0.76,-0.000000348035136512827015,0.000000049437905503782707,-0.000000000000000000000000,0.00},
	{4,0,1,0,-1.42255,-81.30,-0.000000195525357591475851,-0.000003510091290768572313,-0.000000424586247132660511,-0.21},
	{4,0,1,2,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,2,-2,0.00400,0.16,-0.000000070389128732931306,0.000000014744638483584319,-0.000000000000000000000000,0.00},
	{4,0,2,0,-0.13922,-7.97,-0.000000019552535759147585,-0.000000549020950594639609,-0.000000049951323192077706,0.00},
	{4,0,3,-2,0.00044,0.00,-0.000000007821014303659034,0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{4,0,3,0,-0.01243,-0.71,-0.000000000000000000000000,-0.000000067651870689386875,-0.000000000000000000000000,0.00},
	{4,0,4,-2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,0,4,0,-0.00106,-0.06,-0.000000000000000000000000,-0.000000007805985079544638,-0.000000000000000000000000,0.00},
	{4,0,5,0,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-5,0,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-4,0,0.00093,0.05,-0.000000000000000000000000,0.000000006071321728534720,-0.000000037463492394058276,0.00},
	{4,1,-3,0,-0.02399,-2.48,-0.000000011731521455488551,-0.000000112753117815644783,0.000000892879902058388946,0.00},
	{4,1,-3,2,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-2,-2,0.00036,-0.05,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{4,1,-2,0,0.23696,-7.25,-0.000000046926085821954204,0.000000753711226013810069,-0.000008897579443588840597,0.02},
	{4,1,-2,2,-0.00022,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,-1,-2,0.01551,0.50,-0.000000269824993476236675,0.000000025152618589643836,-0.000000574440216708893563,0.00},
	{4,1,-1,0,0.57881,16.49,0.000000039105071518295170,0.000001064215965844585774,-0.000021678874265361723097,0.13},
	{4,1,-1,2,-0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,0,-2,0.01969,0.95,-0.000000340214122209167981,0.000000000000000000000000,-0.000000736782017083146099,0.00},
	{4,1,0,0,0.24453,12.94,0.000000039105071518295170,0.000000298362096373706184,-0.000009134848228751210876,0.04},
	{4,1,0,2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,1,-4,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,1,-2,0.00013,0.03,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,1,0,0.03682,2.17,0.000000007821014303659034,0.000000092804489279030707,-0.000001373661387782136971,0.00},
	{4,1,2,-2,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,1,2,0,0.00430,0.27,-0.000000000000000000000000,0.000000017346633510099197,-0.000000162341800374252536,0.00},
	{4,1,3,0,0.00045,0.03,-0.000000000000000000000000,0.000000002601995026514880,-0.000000018731746197029138,0.00},
	{4,1,4,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,-4,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,-3,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,-3,0,0.00252,0.17,-0.000000000000000000000000,0.000000012142643457069439,-0.000000187317461970291369,0.00},
	{4,2,-2,-2,0.00021,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000018731746197029138,0.00},
	{4,2,-2,0,0.02658,1.57,-0.000000000000000000000000,0.000000084131172523981109,-0.000001985565096885088983,0.00},
	{4,2,-1,-2,-0.00064,-0.04,0.000000011731521455488551,0.000000000000000000000000,0.000000049951323192077706,0.00},
	{4,2,-1,0,0.01868,1.31,-0.000000000000000000000000,0.000000039029925397723194,-0.000001398637049378175725,0.00},
	{4,2,0,-2,0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,2,0,0,0.00136,0.11,-0.000000000000000000000000,0.000000007805985079544638,-0.000000099902646384155413,0.00},
	{4,2,1,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{4,3,-2,0,-0.00015,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000018731746197029138,0.00},
	{4,3,-1,0,-0.00020,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000024975661596038853,0.00},
	{4,3,0,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-3,-2,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-2,-3,0,0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{5,-2,-2,0,0.00044,0.03,-0.000000000000000000000000,0.000000000000000000000000,-0.000000031219576995048568,0.17},
	{5,-2,-1,-2,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-2,-1,0,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,-2,0,0,-0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,-0.06},
	{5,-2,1,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-1,-4,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-1,-3,0,0.00128,0.06,-0.000000000000000000000000,0.000000006071321728534720,-0.000000049951323192077706,0.50},
	{5,-1,-2,-2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-1,-2,0,0.00573,0.32,-0.000000000000000000000000,0.000000019081296861109118,-0.000000212293123566330255,2.23},
	{5,-1,-1,-2,0.00034,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.13},
	{5,-1,-1,0,-0.00056,0.07,-0.000000000000000000000000,0.000000001734663351009920,0.000000024975661596038853,-0.22},
	{5,-1,0,-2,0.00021,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.08},
	{5,-1,0,0,-0.00153,-0.06,-0.000000000000000000000000,0.000000000000000000000000,0.000000056195238591087415,-0.60},
	{5,-1,1,-2,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,-1,1,0,-0.00019,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.07},
	{5,0,-4,0,0.00026,0.00,-0.000000000000000000000000,0.000000001734663351009920,-0.000000000000000000000000,0.10},
	{5,0,-3,-2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,0,-3,0,0.01149,0.49,-0.000000000000000000000000,0.000000054641895556812470,-0.000000000000000000000000,4.47},
	{5,0,-3,2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,0,-2,-2,0.00030,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.12},
	{5,0,-2,0,0.04591,2.50,0.000000015642028607318068,0.000000150048379862358043,0.000000018731746197029138,17.85},
	{5,0,-1,-2,0.00281,0.10,-0.000000046926085821954204,0.000000004336658377524799,-0.000000000000000000000000,1.09},
	{5,0,-1,0,-0.00248,0.57,0.000000007821014303659034,0.000000019081296861109118,0.000000024975661596038853,-0.96},
	{5,0,0,-2,0.00142,0.07,-0.000000023463042910977102,0.000000000000000000000000,-0.000000000000000000000000,0.55},
	{5,0,0,0,-0.00814,-0.25,-0.000000000000000000000000,0.000000006071321728534720,-0.000000000000000000000000,-3.17},
	{5,0,1,-2,0.00020,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.08},
	{5,0,1,0,-0.00089,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.35},
	{5,0,2,0,-0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.02},
	{5,1,-4,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,1,-3,0,0.00038,0.04,-0.000000000000000000000000,0.000000001734663351009920,-0.000000012487830798019427,0.15},
	{5,1,-2,0,-0.00256,-0.07,-0.000000000000000000000000,-0.000000008673316755049599,0.000000093658730985145685,-1.00},
	{5,1,-1,-2,-0.00015,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.06},
	{5,1,-1,0,-0.00311,-0.16,-0.000000000000000000000000,-0.000000006938653404039679,0.000000118634392581184544,-1.21},
	{5,1,0,-2,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{5,1,0,0,-0.00111,-0.07,-0.000000000000000000000000,-0.000000002601995026514880,0.000000043707407793067991,-0.43},
	{5,1,1,0,-0.00020,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.08},
	{5,1,2,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{5,2,-1,0,0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.03},
	{5,2,0,0,0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-4,-2,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-4,-1,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-3,-3,0,-0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{6,-3,-2,0,-0.00044,-0.03,-0.000000000000000000000000,0.000000000000000000000000,0.000000049951323192077706,0.00},
	{6,-3,-1,0,-0.00043,-0.04,-0.000000000000000000000000,0.000000000000000000000000,0.000000049951323192077706,0.00},
	{6,-3,0,0,-0.00017,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000018731746197029138,0.00},
	{6,-3,1,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,-4,0,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,-3,0,-0.00195,-0.12,-0.000000000000000000000000,-0.000000009540648430554559,0.000000143610054177223391,0.00},
	{6,-2,-2,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,-2,0,-0.00618,-0.44,-0.000000000000000000000000,-0.000000020815960212119036,0.000000462049739526718747,0.00},
	{6,-2,-1,-2,-0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,-1,0,-0.00541,-0.44,-0.000000000000000000000000,-0.000000012142643457069439,0.000000405854500935631339,0.00},
	{6,-2,0,-2,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-2,0,0,-0.00194,-0.17,-0.000000000000000000000000,-0.000000003469326702019840,0.000000143610054177223391,0.00},
	{6,-2,1,0,-0.00035,-0.03,-0.000000000000000000000000,0.000000000000000000000000,0.000000024975661596038853,0.00},
	{6,-2,2,0,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-4,0,-0.00085,-0.06,-0.000000000000000000000000,-0.000000005203990053029759,0.000000031219576995048568,0.00},
	{6,-1,-3,-2,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-3,0,-0.02436,-1.43,-0.000000000000000000000000,-0.000000115355112842159674,0.000000905367732856408323,0.00},
	{6,-1,-3,2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-2,-2,-0.00041,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{6,-1,-2,0,-0.06678,-4.61,-0.000000015642028607318068,-0.000000225506235631289566,0.000002485078328805865755,0.00},
	{6,-1,-2,2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,-1,-1,-2,-0.00121,-0.07,0.000000019552535759147585,-0.000000001734663351009920,0.000000043707407793067991,0.00},
	{6,-1,-1,0,-0.05191,-4.10,-0.000000011731521455488551,-0.000000123161097921704283,0.000001929369858294001151,0.00},
	{6,-1,0,-2,-0.00049,-0.04,0.000000007821014303659034,0.000000000000000000000000,0.000000018731746197029138,0.00},
	{6,-1,0,0,-0.01709,-1.47,-0.000000000000000000000000,-0.000000036427930371208316,0.000000630635455299980971,0.00},
	{6,-1,1,0,-0.00296,-0.26,-0.000000000000000000000000,-0.000000009540648430554559,0.000000112390477182174829,0.00},
	{6,-1,2,0,-0.00039,-0.04,-0.000000000000000000000000,-0.000000001734663351009920,0.000000012487830798019427,0.00},
	{6,-1,3,0,-0.00005,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-5,0,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-4,0,-0.00659,-0.45,-0.000000000000000000000000,-0.000000041631920424238072,-0.000000000000000000000000,0.00},
	{6,0,-4,2,0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-3,-2,-0.00027,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-3,0,-0.18316,-10.48,-0.000000046926085821954204,-0.000000869066338855969717,-0.000000031219576995048568,-0.02},
	{6,0,-3,2,0.00028,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-2,-2,-0.00326,-0.13,0.000000054747100125613245,-0.000000010407980106059518,-0.000000000000000000000000,0.00},
	{6,0,-2,0,-0.42250,-28.36,-0.000000101673185947567443,-0.000001438035917987223243,-0.000000118634392581184544,0.00},
	{6,0,-2,2,0.00020,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,-1,-2,-0.00785,-0.44,0.000000136867750314033096,-0.000000011275311781564479,-0.000000000000000000000000,0.00},
	{6,0,-1,0,-0.28663,-21.86,-0.000000062568114429272272,-0.000000704273320510027302,-0.000000112390477182174829,-0.03},
	{6,0,-1,2,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,0,-4,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,0,-2,-0.00270,-0.19,0.000000046926085821954204,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,0,0,-0.08587,-7.10,-0.000000019552535759147585,-0.000000195149626988615977,-0.000000043707407793067991,-0.02},
	{6,0,1,0,-0.01420,-1.20,-0.000000000000000000000000,-0.000000047703242152772799,-0.000000000000000000000000,0.00},
	{6,0,2,-2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,2,0,-0.00182,-0.16,-0.000000000000000000000000,-0.000000008673316755049599,-0.000000000000000000000000,0.00},
	{6,0,3,0,-0.00020,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,0,4,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,-4,0,-0.00024,-0.04,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,-3,0,0.00278,-0.06,-0.000000000000000000000000,0.000000013009975132574398,-0.000000106146561783165128,0.00},
	{6,1,-2,-2,0.00019,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,-2,0,0.00948,0.35,-0.000000000000000000000000,0.000000032091271993683516,-0.000000355903177743553620,0.00},
	{6,1,-1,-2,0.00042,0.03,-0.000000000000000000000000,0.000000000000000000000000,-0.000000012487830798019427,0.00},
	{6,1,-1,0,0.00780,0.49,-0.000000000000000000000000,0.000000019081296861109118,-0.000000293464023753456470,0.00},
	{6,1,0,-2,0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,1,0,0,0.00272,0.21,-0.000000000000000000000000,0.000000006071321728534720,-0.000000099902646384155413,0.00},
	{6,1,1,0,0.00052,0.04,-0.000000000000000000000000,0.000000001734663351009920,-0.000000018731746197029138,0.00},
	{6,1,2,0,0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,2,-4,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{6,2,-3,0,0.00034,0.03,-0.000000000000000000000000,0.000000001734663351009920,-0.000000024975661596038853,0.00},
	{6,2,-2,0,0.00044,0.04,-0.000000000000000000000000,0.000000000000000000000000,-0.000000031219576995048568,0.00},
	{6,2,-1,0,0.00014,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,-1,-4,0,0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,-1,-3,0,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.04},
	{7,-1,-2,0,0.00006,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.02},
	{7,-1,-1,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,0,-4,0,0.00015,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.06},
	{7,0,-3,0,0.00066,0.05,-0.000000000000000000000000,0.000000003469326702019840,-0.000000000000000000000000,0.26},
	{7,0,-2,-2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,0,-2,0,0.00032,0.04,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.13},
	{7,0,-1,-2,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,0,-1,0,-0.00008,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{7,0,0,0,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{7,1,-3,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{7,1,-2,0,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,-0.03},
	{7,1,-1,0,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,-4,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,-3,0,-0.00013,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,-2,0,-0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,0.000000012487830798019427,0.00},
	{8,-2,-1,0,-0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-2,0,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,-4,0,-0.00033,-0.03,-0.000000000000000000000000,-0.000000001734663351009920,0.000000012487830798019427,0.00},
	{8,-1,-3,0,-0.00109,-0.10,-0.000000000000000000000000,-0.000000005203990053029759,0.000000043707407793067991,0.00},
	{8,-1,-2,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,-2,0,-0.00126,-0.12,-0.000000000000000000000000,-0.000000005203990053029759,0.000000049951323192077706,0.00},
	{8,-1,-1,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,-1,0,-0.00070,-0.08,-0.000000000000000000000000,-0.000000002601995026514880,0.000000024975661596038853,0.00},
	{8,-1,0,0,-0.00022,-0.02,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,-1,1,0,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-5,0,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-4,0,-0.00184,-0.14,-0.000000000000000000000000,-0.000000011275311781564479,-0.000000000000000000000000,0.00},
	{8,0,-3,-2,-0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-3,0,-0.00539,-0.46,-0.000000000000000000000000,-0.000000026887281940653757,-0.000000000000000000000000,0.00},
	{8,0,-2,-2,-0.00012,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-2,0,-0.00559,-0.53,-0.000000000000000000000000,-0.000000021683291887623997,-0.000000000000000000000000,0.00},
	{8,0,-1,-2,-0.00009,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,-1,0,-0.00285,-0.29,-0.000000000000000000000000,-0.000000009540648430554559,-0.000000000000000000000000,0.00},
	{8,0,0,-2,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,0,0,-0.00083,-0.09,-0.000000000000000000000000,-0.000000002601995026514880,-0.000000000000000000000000,0.00},
	{8,0,1,0,-0.00016,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,0,2,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,-4,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,-3,0,0.00015,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,-2,0,0.00019,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,-1,0,0.00011,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{8,1,0,0,0.00004,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,-1,-3,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,-1,-2,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-5,0,-0.00002,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-4,0,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-3,0,-0.00010,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-2,0,-0.00007,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{10,0,-1,0,-0.00003,0.00,-0.000000000000000000000000,0.000000000000000000000000,-0.000000000000000000000000,0.00},
	{0,0,0,0,0,0,0,0,0,0}
};

struct elp82b_term2 elp4[] = {
	{0,0,0,0,1,4.712388980384689673996945,0.00003},
	{0,0,0,0,2,0.000000000000000000000000,0.00037},
	{0,0,0,1,-2,3.141592653589793115997963,0.00480},
	{0,0,0,1,-1,1.570796326794896557998982,0.00001},
	{0,0,0,2,-2,0.000000000000000000000000,0.00085},
	{0,0,0,2,0,3.141592653589793115997963,0.00025},
	{0,0,0,3,-2,0.000000000000000000000000,0.00003},
	{0,0,0,3,0,3.141592653589793115997963,0.00002},
	{0,0,0,4,0,3.141592653589793115997963,0.00001},
	{0,0,1,-2,0,3.141592653589793115997963,0.00003},
	{0,0,1,-1,0,3.141592653589793115997963,0.00048},
	{0,0,1,-1,2,3.141592653589793115997963,0.00001},
	{0,0,1,0,0,3.141592653589793115997963,0.00047},
	{0,0,1,1,-2,3.141592653589793115997963,0.00005},
	{0,0,1,1,0,3.141592653589793115997963,0.00019},
	{0,0,1,2,0,3.141592653589793115997963,0.00001},
	{0,0,2,-1,0,3.141592653589793115997963,0.00003},
	{0,1,-1,-1,0,3.141592653589793115997963,0.00001},
	{0,1,-1,0,0,3.141592653589793115997963,0.00015},
	{0,1,-1,1,0,3.141592653589793115997963,0.00001},
	{0,1,0,-2,0,3.141592653589793115997963,0.00001},
	{0,1,0,-1,0,3.141592653589793115997963,0.00004},
	{0,1,0,0,-2,0.000000000000000000000000,0.00001},
	{0,1,0,0,0,3.141592653589793115997963,0.00100},
	{0,1,0,1,0,3.141592653589793115997963,0.00006},
	{0,1,1,-1,0,0.000000000000000000000000,0.00019},
	{0,1,1,0,0,3.141592653589793115997963,0.00070},
	{0,1,1,1,0,3.141592653589793115997963,0.00005},
	{0,2,-1,-2,0,3.141592653589793115997963,0.00002},
	{0,2,-1,-1,0,0.000000000000000000000000,0.00061},
	{0,2,-1,0,-2,0.000000000000000000000000,0.00002},
	{0,2,-1,0,0,0.000000000000000000000000,0.00001},
	{0,2,-1,1,-2,0.000000000000000000000000,0.00004},
	{0,2,0,-3,2,3.141592653589793115997963,0.00001},
	{0,2,0,-2,0,3.141592653589793115997963,0.00077},
	{0,2,0,-2,2,0.000000000000000000000000,0.00006},
	{0,2,0,-1,-2,3.141592653589793115997963,0.00005},
	{0,2,0,-1,0,0.000000000000000000000000,0.02206},
	{0,2,0,0,-2,0.000000000000000000000000,0.00064},
	{0,2,0,0,0,0.000000000000000000000000,0.00102},
	{0,2,0,1,-2,0.000000000000000000000000,0.00089},
	{0,2,0,1,0,0.000000000000000000000000,0.00004},
	{0,2,0,2,-2,0.000000000000000000000000,0.00007},
	{0,2,1,-2,0,0.000000000000000000000000,0.00006},
	{0,2,1,-1,0,3.141592653589793115997963,0.00006},
	{0,2,1,0,-2,3.141592653589793115997963,0.00002},
	{0,2,1,0,0,3.141592653589793115997963,0.00001},
	{0,2,2,-1,0,0.000000000000000000000000,0.00009},
	{0,3,0,-1,0,3.141592653589793115997963,0.00001},
	{0,4,-1,-2,0,0.000000000000000000000000,0.00002},
	{0,4,-1,-1,0,0.000000000000000000000000,0.00002},
	{0,4,0,-2,0,0.000000000000000000000000,0.00026},
	{0,4,0,-1,-2,0.000000000000000000000000,0.00002},
	{0,4,0,-1,0,0.000000000000000000000000,0.00019},
	{0,4,0,0,-2,0.000000000000000000000000,0.00002},
	{0,4,0,0,0,0.000000000000000000000000,0.00002},
	{0,4,0,1,-2,0.000000000000000000000000,0.00001},
	{1,-6,0,0,-1,0.000017453292519943296450,0.00001},
	{1,-6,0,1,-1,0.000017453292519943296450,0.00003},
	{1,-6,0,2,-1,0.000011868238913561442399,0.00003},
	{1,-6,0,3,-1,0.000006283185307179586654,0.00001},
	{1,-4,-1,0,-1,3.141610630481088684007318,0.00001},
	{1,-4,-1,1,-1,3.141606790756734213232448,0.00002},
	{1,-4,-1,1,1,3.141605219960407424650839,0.00002},
	{1,-4,0,-2,-1,0.000017278759594743861182,0.00002},
	{1,-4,0,-2,1,3.141601380236052953875969,0.00001},
	{1,-4,0,-1,-1,0.000019024088846738193537,0.00014},
	{1,-4,0,-1,1,3.141601380236052953875969,0.00009},
	{1,-4,0,0,-1,0.000017453292519943296450,0.00075},
	{1,-4,0,0,1,3.141595620649521691802875,0.00011},
	{1,-4,0,1,-3,3.141608885151836894067401,0.00002},
	{1,-4,0,1,-1,0.000013962634015954636821,0.00141},
	{1,-4,0,1,1,0.000015882496193148399363,0.00022},
	{1,-4,0,2,-3,3.141608536085986447261575,0.00001},
	{1,-4,0,2,-1,0.000005061454830783555869,0.00065},
	{1,-4,1,-1,-1,0.000017104226669544429301,0.00002},
	{1,-4,1,0,-1,0.000017278759594743861182,0.00010},
	{1,-4,1,1,-1,0.000013962634015954636821,0.00017},
	{1,-4,1,1,1,0.000014311699866353502276,0.00002},
	{1,-4,1,2,-1,0.000005235987755982988596,0.00006},
	{1,-4,2,0,-1,0.000016406094968746698392,0.00001},
	{1,-4,2,1,-1,0.000017104226669544429301,0.00001},
	{1,-3,0,0,-1,0.000014311699866353502276,0.00004},
	{1,-3,0,0,1,3.141605394493332870098357,0.00023},
	{1,-3,0,1,-1,3.141604521828706531039188,0.00006},
	{1,-3,0,1,1,3.141605219960407424650839,0.00003},
	{1,-3,1,0,1,3.141605219960407424650839,0.00002},
	{1,-2,-2,1,-1,3.141598064110474375354443,0.00002},
	{1,-2,-2,1,1,3.141597715044623928548617,0.00001},
	{1,-2,-1,-2,-1,3.141614121139592707976362,0.00002},
	{1,-2,-1,-2,1,0.000009773843811168244589,0.00001},
	{1,-2,-1,-1,-1,3.141613423007892258453921,0.00012},
	{1,-2,-1,-1,1,0.000011344640137963141676,0.00009},
	{1,-2,-1,0,-1,3.141611677678640024424794,0.00053},
	{1,-2,-1,0,1,3.141605918092108762351700,0.00123},
	{1,-2,-1,1,-1,3.141600856637277505711836,0.00053},
	{1,-2,-1,2,-1,3.141618484462722626915365,0.00006},
	{1,-2,0,-3,-1,0.000021293016874330818146,0.00009},
	{1,-2,0,-3,1,3.141600333038502057547703,0.00005},
	{1,-2,0,-2,-3,3.141608885151836894067401,0.00001},
	{1,-2,0,-2,-1,0.000020769418098732522505,0.00097},
	{1,-2,0,-2,1,3.141601380236052953875969,0.00065},
	{1,-2,0,-1,-3,3.141610281415238681290703,0.00008},
	{1,-2,0,-1,-1,0.000019722220547535921058,0.00913},
	{1,-2,0,-1,1,3.141601205703128396606871,0.00887},
	{1,-2,0,0,-3,3.141608710618911448619883,0.00037},
	{1,-2,0,0,-1,0.000017453292519943296450,0.06569},
	{1,-2,0,0,0,1.570796326794896557998982,0.00006},
	{1,-2,0,0,1,0.000013264502315156905912,0.04746},
	{1,-2,0,0,3,3.141606092625033319620798,0.00013},
	{1,-2,0,1,-3,3.141605394493332870098357,0.00044},
	{1,-2,0,1,-1,0.000005061454830783555869,0.04962},
	{1,-2,0,1,1,0.000007853981633974482047,0.00026},
	{1,-2,0,1,3,3.141605918092108762351700,0.00001},
	{1,-2,0,2,-3,3.141600158505576612100185,0.00001},
	{1,-2,0,2,-1,3.141628956438234698822498,0.00249},
	{1,-2,0,2,1,3.141604870894556977845014,0.00048},
	{1,-2,0,3,-1,3.141619706193199412780359,0.00045},
	{1,-2,0,3,1,3.141605394493332870098357,0.00008},
	{1,-2,0,4,-1,3.141617960863947178751232,0.00005},
	{1,-2,1,-2,-1,0.000020594885173533090624,0.00008},
	{1,-2,1,-2,1,3.141601205703128396606871,0.00004},
	{1,-2,1,-1,-1,0.000019373154697137060686,0.00072},
	{1,-2,1,-1,1,3.141601729301903400681795,0.00049},
	{1,-2,1,0,-3,3.141608536085986447261575,0.00003},
	{1,-2,1,0,-1,0.000017104226669544429301,0.00482},
	{1,-2,1,0,1,0.000013089969389957472338,0.00187},
	{1,-2,1,1,-3,3.141608187020136000455750,0.00002},
	{1,-2,1,1,-1,0.000005410520681182421324,0.00225},
	{1,-2,1,1,1,3.141606267157958765068315,0.00005},
	{1,-2,1,2,-1,3.141631923497963274627409,0.00009},
	{1,-2,1,2,1,3.141605045427482423292531,0.00003},
	{1,-2,1,3,-1,3.141621276989526201361969,0.00001},
	{1,-2,2,-1,-1,0.000019373154697137060686,0.00004},
	{1,-2,2,-1,1,3.141602078367753847487620,0.00002},
	{1,-2,2,0,-1,0.000016929693744344997421,0.00024},
	{1,-2,2,0,1,0.000012566370614359173309,0.00006},
	{1,-2,2,1,-1,0.000005410520681182421324,0.00008},
	{1,-2,3,0,-1,0.000016406094968746698392,0.00001},
	{1,-1,-1,-1,-1,0.000021293016874330818146,0.00004},
	{1,-1,-1,0,-1,0.000018675022996339326389,0.00019},
	{1,-1,-1,0,1,0.000000000000000000000000,0.00001},
	{1,-1,-1,1,-1,3.141618658995647628273673,0.00001},
	{1,-1,0,-2,-1,3.141615517402994051110454,0.00003},
	{1,-1,0,-1,-1,3.141615517402994051110454,0.00023},
	{1,-1,0,-1,1,3.141613946606667262528845,0.00002},
	{1,-1,0,0,-3,0.000016231562043547266512,0.00001},
	{1,-1,0,0,-1,3.141616041001769943363797,0.00075},
	{1,-1,0,0,1,3.141604347295781973770090,0.00056},
	{1,-1,0,1,-1,0.000022165681500327987711,0.00028},
	{1,-1,0,1,1,3.141605219960407424650839,0.00002},
	{1,-1,0,2,-1,0.000022514747350726848084,0.00006},
	{1,-1,1,0,-1,3.141590908260541326058046,0.00004},
	{1,-1,1,0,1,3.141605219960407424650839,0.00001},
	{1,0,-2,-1,-1,3.141616739133470836975448,0.00002},
	{1,0,-2,0,-1,0.000012566370614359173309,0.00003},
	{1,0,-2,1,-1,0.000020245819323134223476,0.00007},
	{1,0,-1,-3,-1,3.141615866468844497916280,0.00003},
	{1,0,-1,-2,-1,3.141615866468844497916280,0.00029},
	{1,0,-1,-2,1,0.000004363323129985824113,0.00003},
	{1,0,-1,-1,-3,0.000015707963267948964095,0.00001},
	{1,0,-1,-1,-1,3.141617262732246285139581,0.00187},
	{1,0,-1,-1,1,6.283172740808971923343051,0.00008},
	{1,0,-1,0,-3,0.000016057029118347831243,0.00001},
	{1,0,-1,0,-1,0.000011693705988362008825,0.00282},
	{1,0,-1,0,1,0.000007853981633974482047,0.00010},
	{1,0,-1,1,-1,0.000020594885173533090624,0.00387},
	{1,0,-1,1,1,0.000012217304763960306160,0.00026},
	{1,0,-1,2,-1,0.000021293016874330818146,0.00047},
	{1,0,-1,2,1,0.000012217304763960306160,0.00004},
	{1,0,-1,3,-1,0.000021293016874330818146,0.00005},
	{1,0,0,-5,-1,0.000022165681500327987711,0.00001},
	{1,0,0,-4,-1,0.000022514747350726848084,0.00016},
	{1,0,0,-3,-3,3.141612375810340473947235,0.00003},
	{1,0,0,-3,-1,0.000022514747350726848084,0.00228},
	{1,0,0,-3,1,3.141597715044623928548617,0.00013},
	{1,0,0,-2,-3,3.141611677678640024424794,0.00032},
	{1,0,0,-2,-1,0.000022340214425527419592,0.03279},
	{1,0,0,-2,1,3.141596842379998033578659,0.00387},
	{1,0,0,-1,-3,3.141610455948163682649010,0.00261},
	{1,0,0,-1,-1,0.000022165681500327987711,0.49141},
	{1,0,0,-1,0,1.570796326794896557998982,0.00010},
	{1,0,0,-1,1,0.000008901179185171081799,0.05036},
	{1,0,0,-1,3,3.141603125565305187905096,0.00017},
	{1,0,0,0,-5,0.000015009831567151233185,0.00003},
	{1,0,0,0,-3,3.141607663421360108202407,0.01492},
	{1,0,0,0,-1,0.000016406094968746698392,7.06304},
	{1,0,0,0,0,4.712388980384689673996945,0.00027},
	{1,0,0,0,1,0.000012391837689159739734,0.36061},
	{1,0,0,0,3,3.141605045427482423292531,0.00074},
	{1,0,0,1,-3,3.141602078367753847487620,0.00050},
	{1,0,0,1,-1,0.000022165681500327987711,0.49331},
	{1,0,0,1,0,4.712388980384689673996945,0.00002},
	{1,0,0,1,1,0.000012217304763960306160,0.03838},
	{1,0,0,1,3,3.141605569026257871456664,0.00015},
	{1,0,0,2,-3,3.141603300098230189263404,0.00004},
	{1,0,0,2,-1,0.000021991148575128552443,0.03402},
	{1,0,0,2,1,0.000012042771838760872585,0.00331},
	{1,0,0,2,3,3.141605394493332870098357,0.00002},
	{1,0,0,3,-1,0.000021816615649929120563,0.00242},
	{1,0,0,3,1,0.000011693705988362008825,0.00027},
	{1,0,0,4,-1,0.000021816615649929120563,0.00017},
	{1,0,0,4,1,0.000011693705988362008825,0.00002},
	{1,0,0,5,-1,0.000022165681500327987711,0.00001},
	{1,0,1,-3,-1,0.000023212879051524582381,0.00004},
	{1,0,1,-2,-1,0.000023561944901923449530,0.00037},
	{1,0,1,-2,1,3.141601380236052953875969,0.00003},
	{1,0,1,-1,-3,3.141608361553061001814058,0.00001},
	{1,0,1,-1,-1,0.000024958208303518914737,0.00249},
	{1,0,1,-1,1,0.000047472955654245769597,0.00002},
	{1,0,1,0,-1,3.141606441690883766426623,0.00240},
	{1,0,1,0,1,3.141605918092108762351700,0.00034},
	{1,0,1,1,-1,3.141612899409116366200578,0.00292},
	{1,0,1,1,1,3.141605394493332870098357,0.00022},
	{1,0,1,2,-1,3.141613772073742261170537,0.00037},
	{1,0,1,2,1,3.141605045427482423292531,0.00004},
	{1,0,1,3,-1,3.141613946606667262528845,0.00004},
	{1,0,2,-1,-1,0.000025481807079117210378,0.00004},
	{1,0,2,0,-1,3.141605219960407424650839,0.00003},
	{1,0,2,1,-1,3.141613423007892258453921,0.00003},
	{1,1,-1,0,-1,3.141606616223809211874141,0.00003},
	{1,1,0,-2,-1,0.000031764992386296798726,0.00003},
	{1,1,0,-1,-1,3.141580261752104252792606,0.00011},
	{1,1,0,-1,1,3.141601729301903400681795,0.00002},
	{1,1,0,0,-1,3.141608012487210555008232,0.00342},
	{1,1,0,0,1,3.141605219960407424650839,0.00021},
	{1,1,0,1,-1,3.141610805014013685365626,0.00043},
	{1,1,0,1,1,3.141605045427482423292531,0.00004},
	{1,1,0,2,-1,3.141611852211565469872312,0.00004},
	{1,1,1,-1,-1,3.141593875320269457773747,0.00006},
	{1,1,1,0,-1,0.000010297442586766545312,0.00064},
	{1,1,1,0,1,0.000012566370614359173309,0.00003},
	{1,1,1,1,-1,0.000014835298641951799611,0.00007},
	{1,2,-3,0,-1,0.000016406094968746698392,0.00001},
	{1,2,-2,-1,-1,0.000006981317007977318411,0.00010},
	{1,2,-2,-1,1,0.000012566370614359173309,0.00001},
	{1,2,-2,0,-1,0.000015707963267948964095,0.00031},
	{1,2,-2,0,1,0.000012566370614359173309,0.00002},
	{1,2,-2,1,-1,0.000018151424220741027359,0.00005},
	{1,2,-1,-3,-1,3.141620927923675754556143,0.00001},
	{1,2,-1,-2,-1,3.141644315335652137832767,0.00006},
	{1,2,-1,-2,1,0.000008901179185171081799,0.00003},
	{1,2,-1,-1,-1,0.000007155849933176751138,0.00288},
	{1,2,-1,-1,1,0.000012042771838760872585,0.00037},
	{1,2,-1,0,-1,0.000015882496193148399363,0.00646},
	{1,2,-1,0,1,0.000012566370614359173309,0.00031},
	{1,2,-1,1,-1,0.000017976891295541595479,0.00091},
	{1,2,-1,1,1,0.000012042771838760872585,0.00006},
	{1,2,-1,2,-1,0.000018500490071139891120,0.00010},
	{1,2,0,-4,-1,3.141619357127348521885324,0.00005},
	{1,2,0,-3,-1,3.141622847785852989943578,0.00037},
	{1,2,0,-3,1,3.141593177188569008251307,0.00005},
	{1,2,0,-2,-3,0.000021118483949131386265,0.00002},
	{1,2,0,-2,-1,3.141648853191707502219288,0.00142},
	{1,2,0,-2,1,0.000009075712110370513680,0.00067},
	{1,2,0,-1,-1,0.000007330382858376184712,0.06456},
	{1,2,0,-1,1,0.000012391837689159739734,0.00815},
	{1,2,0,-1,3,3.141598936775100270324401,0.00004},
	{1,2,0,0,-3,3.141562459393733686141559,0.00006},
	{1,2,0,0,-1,0.000015707963267948964095,0.09642},
	{1,2,0,0,1,0.000012217304763960306160,0.00480},
	{1,2,0,0,3,3.141599285840950717130227,0.00002},
	{1,2,0,1,-3,3.141612550343265919394753,0.00014},
	{1,2,0,1,-1,0.000017802358370342163599,0.01234},
	{1,2,0,1,1,0.000012217304763960306160,0.00080},
	{1,2,0,2,-3,3.141613248474966813006404,0.00002},
	{1,2,0,2,-1,0.000018675022996339326389,0.00126},
	{1,2,0,2,1,0.000012740903539558605189,0.00009},
	{1,2,0,3,-1,0.000019373154697137060686,0.00012},
	{1,2,0,3,1,0.000010821041362364842647,0.00001},
	{1,2,1,-1,-1,3.141593351721494009609614,0.00017},
	{1,2,1,-1,1,3.141605394493332870098357,0.00006},
	{1,2,1,0,-1,3.141608012487210555008232,0.00113},
	{1,2,1,0,1,3.141605394493332870098357,0.00005},
	{1,2,1,1,-1,3.141609757816462789037359,0.00021},
	{1,2,1,1,1,3.141609932349387790395667,0.00001},
	{1,2,1,2,-1,3.141610979546939130813143,0.00003},
	{1,2,2,-1,-1,3.141598413176324822160268,0.00005},
	{1,3,0,-2,-1,3.141585846805710069418183,0.00001},
	{1,3,0,-1,-1,3.141604870894556977845014,0.00013},
	{1,3,0,-1,1,3.141605219960407424650839,0.00001},
	{1,3,1,-1,-1,0.000012740903539558605189,0.00001},
	{1,3,1,0,-1,0.000015358897417550100334,0.00001},
	{1,4,-2,-1,-1,0.000015882496193148399363,0.00002},
	{1,4,-2,0,-1,0.000016406094968746698392,0.00001},
	{1,4,-1,-2,-1,0.000007155849933176751138,0.00008},
	{1,4,-1,-2,1,0.000016057029118347831243,0.00001},
	{1,4,-1,-1,-1,0.000013439035240356336098,0.00024},
	{1,4,-1,-1,1,0.000012391837689159739734,0.00002},
	{1,4,-1,0,-1,0.000015707963267948964095,0.00015},
	{1,4,-1,1,-1,0.000015882496193148399363,0.00003},
	{1,4,0,-3,-1,6.283153542187199569468703,0.00001},
	{1,4,0,-3,1,0.000009773843811168244589,0.00001},
	{1,4,0,-2,-1,0.000007330382858376184712,0.00088},
	{1,4,0,-2,1,0.000012217304763960306160,0.00014},
	{1,4,0,-1,-1,0.000013613568165555769673,0.00217},
	{1,4,0,-1,1,0.000012391837689159739734,0.00016},
	{1,4,0,0,-1,0.000015707963267948964095,0.00115},
	{1,4,0,0,1,0.000012566370614359173309,0.00006},
	{1,4,0,1,-1,0.000017104226669544429301,0.00021},
	{1,4,0,1,1,0.000006632251157578452956,0.00001},
	{1,4,0,2,-1,0.000016231562043547266512,0.00003},
	{1,4,1,-1,-1,3.141606092625033319620798,0.00004},
	{1,4,1,0,-1,3.141608187020136000455750,0.00003},
	{1,6,0,-3,-1,0.000006457718232379019382,0.00001},
	{1,6,0,-2,-1,0.000011693705988362008825,0.00004},
	{1,6,0,-1,-1,0.000015707963267948964095,0.00004},
	{1,6,0,0,-1,0.000015707963267948964095,0.00002},
	{2,-2,-1,0,0,0.000000000000000000000000,0.00001},
	{2,-2,0,-1,-2,3.141592653589793115997963,0.00004},
	{2,-2,0,-1,0,0.000000000000000000000000,0.00013},
	{2,-2,0,0,-2,3.141592653589793115997963,0.00027},
	{2,-2,0,0,0,3.141592653589793115997963,0.00043},
	{2,-2,0,1,-2,3.141592653589793115997963,0.00025},
	{2,-2,0,1,0,3.141592653589793115997963,0.00002},
	{2,-2,0,2,-2,0.000000000000000000000000,0.00001},
	{2,-2,1,0,-2,3.141592653589793115997963,0.00002},
	{2,-2,1,0,0,3.141592653589793115997963,0.00003},
	{2,-2,1,1,-2,3.141592653589793115997963,0.00001},
	{2,0,-1,0,-2,3.141592653589793115997963,0.00003},
	{2,0,-1,1,-2,3.141592653589793115997963,0.00002},
	{2,0,0,-2,-2,3.141592653589793115997963,0.00016},
	{2,0,0,-2,0,0.000000000000000000000000,0.00009},
	{2,0,0,-1,-4,0.000000000000000000000000,0.00001},
	{2,0,0,-1,-2,3.141592653589793115997963,0.00239},
	{2,0,0,-1,-1,4.712388980384689673996945,0.00001},
	{2,0,0,-1,0,3.141592653589793115997963,0.00080},
	{2,0,0,0,-4,0.000000000000000000000000,0.00007},
	{2,0,0,0,-2,3.141592653589793115997963,0.03638},
	{2,0,0,0,-1,1.570796326794896557998982,0.00003},
	{2,0,0,0,0,3.141592653589793115997963,0.00239},
	{2,0,0,1,-2,3.141592653589793115997963,0.00241},
	{2,0,0,1,0,3.141592653589793115997963,0.00025},
	{2,0,0,2,-2,3.141592653589793115997963,0.00017},
	{2,0,0,2,0,3.141592653589793115997963,0.00002},
	{2,0,1,0,-2,0.000000000000000000000000,0.00002},
	{2,0,1,1,-2,0.000000000000000000000000,0.00001},
	{2,1,0,0,-2,0.000000000000000000000000,0.00002},
	{2,1,1,0,-2,3.141592653589793115997963,0.00004},
	{2,2,-1,-1,-2,3.141592653589793115997963,0.00002},
	{2,2,-1,0,-2,3.141592653589793115997963,0.00004},
	{2,2,0,-1,-2,3.141592653589793115997963,0.00039},
	{2,2,0,-1,0,3.141592653589793115997963,0.00006},
	{2,2,0,0,-2,3.141592653589793115997963,0.00057},
	{2,2,0,0,0,3.141592653589793115997963,0.00003},
	{2,2,0,1,-2,3.141592653589793115997963,0.00007},
	{2,4,0,-1,-2,3.141592653589793115997963,0.00001},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp5[] = {
	{0,0,0,0,3,0.000000000000000000000000,0.00003},
	{0,0,0,1,-3,3.141592653589793115997963,0.00021},
	{0,0,0,1,-1,0.000000000000000000000000,0.00056},
	{0,0,0,1,1,0.000000000000000000000000,0.00047},
	{0,0,0,2,-3,0.000000000000000000000000,0.00004},
	{0,0,0,2,-1,3.141592653589793115997963,0.00144},
	{0,0,0,2,1,0.000000000000000000000000,0.00003},
	{0,0,0,3,-1,3.141592653589793115997963,0.00007},
	{0,0,1,-1,-1,3.141592653589793115997963,0.00002},
	{0,0,1,-1,1,3.141592653589793115997963,0.00002},
	{0,0,1,0,-1,3.141592653589793115997963,0.00004},
	{0,0,1,0,1,3.141592653589793115997963,0.00004},
	{0,0,1,1,-1,3.141592653589793115997963,0.00001},
	{0,0,1,1,1,3.141592653589793115997963,0.00002},
	{0,1,0,0,-1,3.141592653589793115997963,0.00004},
	{0,1,0,0,1,3.141592653589793115997963,0.00005},
	{0,1,1,-1,-1,0.000000000000000000000000,0.00001},
	{0,1,1,-1,1,0.000000000000000000000000,0.00001},
	{0,1,1,0,-1,3.141592653589793115997963,0.00003},
	{0,1,1,0,1,3.141592653589793115997963,0.00003},
	{0,2,-1,-1,-1,0.000000000000000000000000,0.00003},
	{0,2,-1,-1,1,0.000000000000000000000000,0.00004},
	{0,2,-1,0,-1,3.141592653589793115997963,0.00006},
	{0,2,0,-2,-1,3.141592653589793115997963,0.00005},
	{0,2,0,-2,1,3.141592653589793115997963,0.00021},
	{0,2,0,-1,-1,0.000000000000000000000000,0.00126},
	{0,2,0,-1,1,0.000000000000000000000000,0.00108},
	{0,2,0,0,-3,0.000000000000000000000000,0.00004},
	{0,2,0,0,-1,3.141592653589793115997963,0.00217},
	{0,2,0,0,1,0.000000000000000000000000,0.00013},
	{0,2,0,1,-3,0.000000000000000000000000,0.00003},
	{0,2,0,1,-1,3.141592653589793115997963,0.00008},
	{0,2,0,2,-1,3.141592653589793115997963,0.00002},
	{0,2,1,-1,-1,3.141592653589793115997963,0.00001},
	{0,2,1,0,-1,0.000000000000000000000000,0.00009},
	{0,2,2,0,-1,0.000000000000000000000000,0.00001},
	{0,4,0,-2,1,0.000000000000000000000000,0.00003},
	{0,4,0,-1,-1,0.000000000000000000000000,0.00001},
	{0,4,0,-1,1,0.000000000000000000000000,0.00002},
	{0,4,0,0,-1,3.141592653589793115997963,0.00001},
	{1,-6,0,0,0,0.000013264502315156905912,0.00002},
	{1,-6,0,1,0,0.000013089969389957472338,0.00005},
	{1,-6,0,2,0,0.000013089969389957472338,0.00004},
	{1,-4,-1,0,0,3.141605743559183316904182,0.00006},
	{1,-4,-1,1,0,3.141605569026257871456664,0.00008},
	{1,-4,0,-2,0,0.000013264502315156905912,0.00003},
	{1,-4,0,-1,-2,0.000016580627893946130272,0.00002},
	{1,-4,0,-1,0,0.000013089969389957472338,0.00025},
	{1,-4,0,-1,2,3.141600682104352504353528,0.00001},
	{1,-4,0,0,-2,0.000016406094968746698392,0.00009},
	{1,-4,0,0,0,0.000012740903539558605189,0.00188},
	{1,-4,0,0,2,0.000012566370614359173309,0.00009},
	{1,-4,0,1,-2,0.000014486232791552935850,0.00017},
	{1,-4,0,1,0,0.000012391837689159739734,0.00322},
	{1,-4,0,2,-2,0.000009599310885968812709,0.00009},
	{1,-4,0,2,0,0.000012217304763960306160,0.00029},
	{1,-4,1,-1,0,0.000013089969389957472338,0.00003},
	{1,-4,1,0,-2,0.000016406094968746698392,0.00001},
	{1,-4,1,0,0,0.000013089969389957472338,0.00021},
	{1,-4,1,1,-2,0.000016406094968746698392,0.00002},
	{1,-4,1,1,0,0.000012566370614359173309,0.00029},
	{1,-4,1,2,-2,0.000016231562043547266512,0.00001},
	{1,-4,1,2,0,0.000012566370614359173309,0.00002},
	{1,-4,2,0,0,0.000012566370614359173309,0.00001},
	{1,-4,2,1,0,0.000012566370614359173309,0.00002},
	{1,-3,-1,0,0,0.000012566370614359173309,0.00002},
	{1,-3,0,-1,0,3.141605219960407424650839,0.00002},
	{1,-3,0,0,0,3.141605569026257871456664,0.00017},
	{1,-3,0,0,2,3.141605219960407424650839,0.00001},
	{1,-3,0,1,0,3.141605394493332870098357,0.00014},
	{1,-3,0,2,0,3.141605219960407424650839,0.00002},
	{1,-3,1,0,0,3.141605219960407424650839,0.00001},
	{1,-2,-2,0,0,3.141599111308025715771919,0.00013},
	{1,-2,-2,1,0,3.141605219960407424650839,0.00005},
	{1,-2,-1,-2,0,3.141605743559183316904182,0.00003},
	{1,-2,-1,-1,-2,3.141609234217686896784016,0.00001},
	{1,-2,-1,-1,0,3.141605394493332870098357,0.00041},
	{1,-2,-1,0,-2,3.141609059684762339514918,0.00006},
	{1,-2,-1,0,0,3.141605045427482423292531,0.00589},
	{1,-2,-1,0,2,3.141606441690883766426623,0.00007},
	{1,-2,-1,1,-2,3.141604172762856528322573,0.00005},
	{1,-2,-1,1,0,3.141605569026257871456664,0.00034},
	{1,-2,-1,2,0,0.000012566370614359173309,0.00003},
	{1,-2,0,-3,-2,0.000016406094968746698392,0.00001},
	{1,-2,0,-3,0,0.000013439035240356336098,0.00007},
	{1,-2,0,-2,-2,0.000019373154697137060686,0.00014},
	{1,-2,0,-2,0,0.000013439035240356336098,0.00110},
	{1,-2,0,-2,2,3.141600856637277505711836,0.00002},
	{1,-2,0,-1,-2,0.000018151424220741027359,0.00104},
	{1,-2,0,-1,0,0.000013089969389957472338,0.01647},
	{1,-2,0,-1,2,3.141602951032379742457579,0.00048},
	{1,-2,0,0,-4,3.141608361553061001814058,0.00001},
	{1,-2,0,0,-2,0.000016231562043547266512,0.00562},
	{1,-2,0,0,0,0.000012566370614359173309,0.29854},
	{1,-2,0,0,2,0.000013439035240356336098,0.00273},
	{1,-2,0,1,-4,3.141608012487210555008232,0.00002},
	{1,-2,0,1,-2,0.000011344640137963141676,0.00562},
	{1,-2,0,1,0,0.000012391837689159739734,0.07332},
	{1,-2,0,1,2,0.000012566370614359173309,0.00043},
	{1,-2,0,2,-2,3.141584101476458279478265,0.00002},
	{1,-2,0,2,0,0.000011519173063162575251,0.00672},
	{1,-2,0,2,2,0.000012566370614359173309,0.00003},
	{1,-2,0,3,0,0.000010995574287564276221,0.00063},
	{1,-2,0,4,0,0.000010646508437165409073,0.00005},
	{1,-2,1,-2,-2,0.000016406094968746698392,0.00001},
	{1,-2,1,-2,0,0.000013089969389957472338,0.00006},
	{1,-2,1,-1,-2,0.000018151424220741027359,0.00008},
	{1,-2,1,-1,0,0.000013089969389957472338,0.00086},
	{1,-2,1,-1,2,3.141603125565305187905096,0.00003},
	{1,-2,1,0,-2,0.000016406094968746698392,0.00038},
	{1,-2,1,0,0,0.000012566370614359173309,0.01404},
	{1,-2,1,0,2,0.000013264502315156905912,0.00011},
	{1,-2,1,1,-2,0.000011344640137963141676,0.00025},
	{1,-2,1,1,0,0.000012391837689159739734,0.00328},
	{1,-2,1,1,2,0.000012740903539558605189,0.00001},
	{1,-2,1,2,0,0.000011868238913561442399,0.00028},
	{1,-2,1,3,0,0.000012566370614359173309,0.00002},
	{1,-2,2,-1,0,0.000012915436464758038763,0.00003},
	{1,-2,2,0,-2,0.000016231562043547266512,0.00002},
	{1,-2,2,0,0,0.000012740903539558605189,0.00051},
	{1,-2,2,1,-2,0.000015882496193148399363,0.00001},
	{1,-2,2,1,0,0.000012566370614359173309,0.00012},
	{1,-2,2,2,0,0.000012566370614359173309,0.00001},
	{1,-2,3,0,0,0.000012566370614359173309,0.00002},
	{1,-1,-1,-1,0,0.000012566370614359173309,0.00002},
	{1,-1,-1,0,-2,0.000016406094968746698392,0.00002},
	{1,-1,-1,0,0,0.000012566370614359173309,0.00036},
	{1,-1,0,-2,0,3.141605219960407424650839,0.00002},
	{1,-1,0,-1,-2,3.141612201277415472588928,0.00003},
	{1,-1,0,-1,0,3.141605219960407424650839,0.00029},
	{1,-1,0,0,-2,3.141609932349387790395667,0.00013},
	{1,-1,0,0,0,3.141605394493332870098357,0.00212},
	{1,-1,0,0,2,3.141604696361631976486706,0.00005},
	{1,-1,0,1,0,3.141605569026257871456664,0.00017},
	{1,-1,0,2,0,3.141605045427482423292531,0.00004},
	{1,0,-2,-1,0,3.141605219960407424650839,0.00003},
	{1,0,-2,1,0,3.141605045427482423292531,0.00005},
	{1,0,-1,-3,0,3.141605219960407424650839,0.00001},
	{1,0,-1,-2,-2,3.141613423007892258453921,0.00004},
	{1,0,-1,-2,0,3.141606616223809211874141,0.00014},
	{1,0,-1,-1,-2,3.141612550343265919394753,0.00018},
	{1,0,-1,-1,0,3.141605918092108762351700,0.00227},
	{1,0,-1,0,-2,3.141626163911431568465105,0.00002},
	{1,0,-1,0,0,3.141602776499455185188481,0.00252},
	{1,0,-1,1,-2,0.000035255650890285456661,0.00004},
	{1,0,-1,1,0,3.141604521828706531039188,0.00276},
	{1,0,-1,2,0,3.141603998229931082875055,0.00031},
	{1,0,-1,3,0,3.141604696361631976486706,0.00003},
	{1,0,0,-4,-2,0.000021118483949131386265,0.00003},
	{1,0,0,-4,0,0.000011170107212763709796,0.00005},
	{1,0,0,-3,-2,0.000020769418098732522505,0.00033},
	{1,0,0,-3,0,0.000012042771838760872585,0.00091},
	{1,0,0,-2,-4,3.141608187020136000455750,0.00001},
	{1,0,0,-2,-2,0.000020245819323134223476,0.00377},
	{1,0,0,-2,0,0.000011693705988362008825,0.01745},
	{1,0,0,-2,2,3.141599285840950717130227,0.00033},
	{1,0,0,-1,-4,3.141609757816462789037359,0.00008},
	{1,0,0,-1,-2,0.000019024088846738193537,0.03977},
	{1,0,0,-1,0,0.000013089969389957472338,0.45586},
	{1,0,0,-1,2,0.000010821041362364842647,0.00437},
	{1,0,0,0,-4,3.141607663421360108202407,0.00034},
	{1,0,0,0,-2,0.000015009831567151233185,0.32622},
	{1,0,0,0,-1,4.712388980384689673996945,0.00001},
	{1,0,0,0,0,3.141605045427482423292531,8.04508},
	{1,0,0,0,1,4.712388980384689673996945,0.00001},
	{1,0,0,0,2,0.000012391837689159739734,0.00834},
	{1,0,0,0,4,3.141598238643399376712750,0.00002},
	{1,0,0,1,-4,3.141604347295781973770090,0.00009},
	{1,0,0,1,-2,0.000080983277292536893902,0.00239},
	{1,0,0,1,0,3.141604696361631976486706,0.41571},
	{1,0,0,1,2,0.000012217304763960306160,0.00133},
	{1,0,0,2,-2,0.000025656340004316642258,0.00079},
	{1,0,0,2,0,3.141604172762856528322573,0.02403},
	{1,0,0,2,2,0.000012391837689159739734,0.00015},
	{1,0,0,3,-2,0.000023911010752322313291,0.00007},
	{1,0,0,3,0,3.141603474631155634710922,0.00146},
	{1,0,0,3,2,0.000013089969389957472338,0.00002},
	{1,0,0,4,0,3.141602776499455185188481,0.00009},
	{1,0,1,-3,0,0.000012566370614359173309,0.00001},
	{1,0,1,-2,-2,0.000020769418098732522505,0.00004},
	{1,0,1,-2,0,0.000013439035240356336098,0.00014},
	{1,0,1,-1,-2,0.000019896753472735356327,0.00023},
	{1,0,1,-1,0,0.000012915436464758038763,0.00257},
	{1,0,1,-1,2,0.000015184364492350666760,0.00001},
	{1,0,1,0,-2,0.000012391837689159739734,0.00003},
	{1,0,1,0,0,0.000016580627893946130272,0.00206},
	{1,0,1,0,2,3.141605219960407424650839,0.00002},
	{1,0,1,1,-2,3.141630527234561487404108,0.00003},
	{1,0,1,1,0,0.000012217304763960306160,0.00212},
	{1,0,1,2,0,0.000011344640137963141676,0.00025},
	{1,0,1,3,0,0.000012042771838760872585,0.00002},
	{1,0,2,-1,0,0.000012566370614359173309,0.00004},
	{1,0,2,0,0,0.000015358897417550100334,0.00002},
	{1,0,2,1,0,0.000012566370614359173309,0.00002},
	{1,1,0,-2,0,0.000012566370614359173309,0.00004},
	{1,1,0,-1,0,3.141616564600545835617140,0.00003},
	{1,1,0,0,-2,3.141610455948163682649010,0.00003},
	{1,1,0,0,0,0.000012391837689159739734,0.00218},
	{1,1,0,1,-2,3.141615517402994051110454,0.00001},
	{1,1,0,1,0,0.000011693705988362008825,0.00026},
	{1,1,0,2,0,0.000011868238913561442399,0.00002},
	{1,1,1,-1,0,0.000003839724354387525084,0.00008},
	{1,1,1,0,-2,0.000004886921905584122295,0.00001},
	{1,1,1,0,0,3.141605394493332870098357,0.00032},
	{1,1,1,1,0,3.141604870894556977845014,0.00004},
	{1,2,-2,-1,0,3.141605045427482423292531,0.00013},
	{1,2,-2,0,-2,0.000017802358370342163599,0.00002},
	{1,2,-2,0,0,3.141604870894556977845014,0.00015},
	{1,2,-2,1,0,3.141604696361631976486706,0.00002},
	{1,2,-1,-2,-2,3.141618135396872624198750,0.00002},
	{1,2,-1,-2,0,0.000015882496193148399363,0.00002},
	{1,2,-1,-1,-2,3.141636810419868641730545,0.00003},
	{1,2,-1,-1,0,3.141605394493332870098357,0.00371},
	{1,2,-1,-1,2,0.000012566370614359173309,0.00002},
	{1,2,-1,0,-2,0.000017627825445142728330,0.00049},
	{1,2,-1,0,0,3.141604870894556977845014,0.00315},
	{1,2,-1,0,2,0.000012740903539558605189,0.00001},
	{1,2,-1,1,-2,0.000019547687622336489178,0.00008},
	{1,2,-1,1,0,3.141604172762856528322573,0.00043},
	{1,2,-1,2,0,3.141604347295781973770090,0.00004},
	{1,2,0,-4,0,3.141605219960407424650839,0.00001},
	{1,2,0,-3,-2,3.141616739133470836975448,0.00007},
	{1,2,0,-3,0,3.141605569026257871456664,0.00013},
	{1,2,0,-2,-2,3.141618833528573073721191,0.00038},
	{1,2,0,-2,0,0.000028623399732707004552,0.00033},
	{1,2,0,-2,2,0.000010821041362364842647,0.00010},
	{1,2,0,-1,-4,3.141607139822584660038274,0.00001},
	{1,2,0,-1,-2,3.141634541491840959537285,0.00066},
	{1,2,0,-1,0,3.141605394493332870098357,0.08350},
	{1,2,0,-1,2,0.000012042771838760872585,0.00033},
	{1,2,0,0,-4,3.141605219960407424650839,0.00004},
	{1,2,0,0,-2,0.000017802358370342163599,0.01005},
	{1,2,0,0,0,3.141604870894556977845014,0.04638},
	{1,2,0,0,2,0.000012740903539558605189,0.00018},
	{1,2,0,1,-2,0.000019547687622336489178,0.00139},
	{1,2,0,1,0,3.141604347295781973770090,0.00563},
	{1,2,0,1,2,0.000012566370614359173309,0.00004},
	{1,2,0,2,-2,0.000020071286397934788207,0.00014},
	{1,2,0,2,0,3.141603474631155634710922,0.00054},
	{1,2,0,3,-2,0.000016231562043547266512,0.00001},
	{1,2,0,3,0,3.141604172762856528322573,0.00005},
	{1,2,1,-2,0,3.141605219960407424650839,0.00002},
	{1,2,1,-1,-2,0.000021118483949131386265,0.00001},
	{1,2,1,-1,0,0.000012915436464758038763,0.00055},
	{1,2,1,0,-2,3.141610630481088684007318,0.00019},
	{1,2,1,0,0,0.000012391837689159739734,0.00049},
	{1,2,1,1,-2,3.141612550343265919394753,0.00003},
	{1,2,1,1,0,0.000012042771838760872585,0.00009},
	{1,2,1,2,0,0.000011693705988362008825,0.00001},
	{1,2,2,-1,0,0.000012391837689159739734,0.00005},
	{1,3,0,-2,0,0.000012566370614359173309,0.00002},
	{1,3,0,-1,0,0.000012217304763960306160,0.00008},
	{1,3,0,0,0,0.000012566370614359173309,0.00001},
	{1,4,-2,-1,0,3.141605219960407424650839,0.00001},
	{1,4,-1,-2,0,3.141604870894556977845014,0.00008},
	{1,4,-1,-1,-2,0.000012915436464758038763,0.00002},
	{1,4,-1,-1,0,3.141604696361631976486706,0.00013},
	{1,4,-1,0,-2,0.000016755160819145565541,0.00002},
	{1,4,-1,0,0,3.141604347295781973770090,0.00006},
	{1,4,-1,1,0,3.141604172762856528322573,0.00001},
	{1,4,0,-3,0,3.141598587709249823518576,0.00001},
	{1,4,0,-2,0,3.141605569026257871456664,0.00097},
	{1,4,0,-1,-2,0.000012915436464758038763,0.00019},
	{1,4,0,-1,0,3.141605045427482423292531,0.00113},
	{1,4,0,-1,2,0.000009773843811168244589,0.00001},
	{1,4,0,0,-2,0.000016755160819145565541,0.00019},
	{1,4,0,0,0,3.141604347295781973770090,0.00043},
	{1,4,0,1,-2,0.000017976891295541595479,0.00004},
	{1,4,0,1,0,3.141604172762856528322573,0.00007},
	{1,4,1,-2,0,0.000012566370614359173309,0.00001},
	{1,4,1,-1,0,0.000012042771838760872585,0.00002},
	{1,6,0,-3,0,3.141604696361631976486706,0.00001},
	{1,6,0,-2,0,3.141604347295781973770090,0.00002},
	{1,6,0,-1,0,3.141604172762856528322573,0.00001},
	{2,-4,0,0,-1,3.141592653589793115997963,0.00002},
	{2,-4,0,1,-1,3.141592653589793115997963,0.00003},
	{2,-2,-1,0,-1,0.000000000000000000000000,0.00006},
	{2,-2,0,-2,-1,3.141592653589793115997963,0.00001},
	{2,-2,0,-1,-1,3.141592653589793115997963,0.00016},
	{2,-2,0,0,-3,3.141592653589793115997963,0.00003},
	{2,-2,0,0,-1,3.141592653589793115997963,0.00293},
	{2,-2,0,0,1,3.141592653589793115997963,0.00014},
	{2,-2,0,1,-3,3.141592653589793115997963,0.00003},
	{2,-2,0,1,-1,3.141592653589793115997963,0.00072},
	{2,-2,0,1,1,3.141592653589793115997963,0.00001},
	{2,-2,0,2,-1,3.141592653589793115997963,0.00007},
	{2,-2,1,0,-1,3.141592653589793115997963,0.00014},
	{2,-2,1,1,-1,3.141592653589793115997963,0.00003},
	{2,-1,0,0,-1,0.000000000000000000000000,0.00002},
	{2,0,-1,-1,-1,0.000000000000000000000000,0.00002},
	{2,0,-1,0,-1,0.000000000000000000000000,0.00003},
	{2,0,-1,1,-1,0.000000000000000000000000,0.00003},
	{2,0,0,-3,-1,3.141592653589793115997963,0.00001},
	{2,0,0,-2,-3,3.141592653589793115997963,0.00002},
	{2,0,0,-2,-1,3.141592653589793115997963,0.00020},
	{2,0,0,-2,1,3.141592653589793115997963,0.00005},
	{2,0,0,-1,-3,3.141592653589793115997963,0.00019},
	{2,0,0,-1,-1,3.141592653589793115997963,0.00441},
	{2,0,0,-1,1,3.141592653589793115997963,0.00006},
	{2,0,0,0,-3,3.141592653589793115997963,0.00156},
	{2,0,0,0,-1,0.000000000000000000000000,0.08042},
	{2,0,0,0,1,3.141592653589793115997963,0.00003},
	{2,0,0,1,-1,0.000000000000000000000000,0.00425},
	{2,0,0,2,-1,0.000000000000000000000000,0.00026},
	{2,0,0,3,-1,0.000000000000000000000000,0.00002},
	{2,0,1,-1,-1,3.141592653589793115997963,0.00002},
	{2,0,1,1,-1,3.141592653589793115997963,0.00002},
	{2,1,0,0,-1,3.141592653589793115997963,0.00002},
	{2,1,1,-1,-1,3.141592653589793115997963,0.00002},
	{2,2,-1,-1,-1,0.000000000000000000000000,0.00004},
	{2,2,-1,0,-1,0.000000000000000000000000,0.00003},
	{2,2,0,-1,-1,0.000000000000000000000000,0.00085},
	{2,2,0,0,-3,3.141592653589793115997963,0.00005},
	{2,2,0,0,-1,0.000000000000000000000000,0.00049},
	{2,2,0,1,-1,0.000000000000000000000000,0.00006},
	{2,4,0,-1,-1,0.000000000000000000000000,0.00001},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp6[] = {
	{0,0,0,0,0,1.570796326794896557998982,0.04301},
	{0,0,0,0,1,3.141592653589793115997963,0.00003},
	{0,0,0,0,2,4.712388980384689673996945,0.00004},
	{0,0,0,1,-2,4.712388980384689673996945,0.00444},
	{0,0,0,1,0,1.570796326794896557998982,0.00531},
	{0,0,0,2,-2,1.570796326794896557998982,0.00026},
	{0,0,0,2,0,1.570796326794896557998982,0.00042},
	{0,0,0,2,2,4.712388980384689673996945,0.00004},
	{0,0,0,3,-2,4.712388980384689673996945,0.00002},
	{0,0,0,3,0,1.570796326794896557998982,0.00003},
	{0,0,1,-2,0,4.712388980384689673996945,0.00004},
	{0,0,1,-1,0,4.712388980384689673996945,0.00037},
	{0,0,1,0,0,1.570796326794896557998982,0.00009},
	{0,0,1,1,-2,4.712388980384689673996945,0.00005},
	{0,0,1,1,0,1.570796326794896557998982,0.00017},
	{0,0,1,2,0,1.570796326794896557998982,0.00002},
	{0,0,2,0,0,4.712388980384689673996945,0.00002},
	{0,1,-1,0,0,1.570796326794896557998982,0.00012},
	{0,1,0,-1,0,4.712388980384689673996945,0.00005},
	{0,1,0,0,0,1.570796326794896557998982,0.00088},
	{0,1,0,1,0,1.570796326794896557998982,0.00006},
	{0,1,1,-1,0,4.712388980384689673996945,0.00004},
	{0,1,1,0,0,1.570796326794896557998982,0.00064},
	{0,1,1,1,0,1.570796326794896557998982,0.00004},
	{0,2,-1,-1,0,4.712388980384689673996945,0.00053},
	{0,2,-1,1,-2,4.712388980384689673996945,0.00003},
	{0,2,0,-3,0,1.570796326794896557998982,0.00003},
	{0,2,0,-2,0,1.570796326794896557998982,0.00082},
	{0,2,0,-2,2,4.712388980384689673996945,0.00003},
	{0,2,0,-1,0,4.712388980384689673996945,0.01961},
	{0,2,0,-1,2,4.712388980384689673996945,0.00003},
	{0,2,0,0,-2,1.570796326794896557998982,0.00021},
	{0,2,0,0,0,4.712388980384689673996945,0.00047},
	{0,2,0,1,-2,4.712388980384689673996945,0.00071},
	{0,2,0,2,-2,4.712388980384689673996945,0.00005},
	{0,2,1,-1,0,1.570796326794896557998982,0.00008},
	{0,2,1,0,0,1.570796326794896557998982,0.00003},
	{0,2,2,-1,0,4.712388980384689673996945,0.00009},
	{0,4,-1,-1,0,4.712388980384689673996945,0.00002},
	{0,4,0,-2,0,4.712388980384689673996945,0.00017},
	{0,4,0,-1,0,4.712388980384689673996945,0.00017},
	{0,4,0,0,0,4.712388980384689673996945,0.00002},
	{1,-6,0,1,-1,1.570812732889865337426727,0.00002},
	{1,-6,0,2,-1,1.570808544099660419846032,0.00003},
	{1,-4,-1,1,-1,4.712405386479658453424690,0.00003},
	{1,-4,0,-1,-1,1.570814303686192126008336,0.00012},
	{1,-4,0,-1,1,4.712393692773670039741774,0.00005},
	{1,-4,0,0,-1,1.570813081955715784232552,0.00075},
	{1,-4,0,0,1,1.570811336626463772248030,0.00040},
	{1,-4,0,1,-1,1.570810114895987208427641,0.00149},
	{1,-4,0,1,1,1.570810114895987208427641,0.00027},
	{1,-4,0,2,-1,1.570801213716802147146723,0.00046},
	{1,-4,0,2,1,1.570808020500884971681899,0.00008},
	{1,-4,1,0,-1,1.570812907422790560829640,0.00010},
	{1,-4,1,0,1,1.570808893165510866651857,0.00005},
	{1,-4,1,1,-1,1.570810114895987208427641,0.00017},
	{1,-4,1,1,1,1.570808893165510866651857,0.00002},
	{1,-4,1,2,-1,1.570801388249727592594240,0.00004},
	{1,-3,0,0,-1,1.570812383824014890620901,0.00008},
	{1,-3,0,0,1,4.712401546755303982649821,0.00018},
	{1,-3,0,1,-1,4.712401023156528978574897,0.00007},
	{1,-2,-2,1,-1,4.712393169174895035666850,0.00002},
	{1,-2,-1,-1,-1,4.712408004473536138334566,0.00014},
	{1,-2,-1,-1,1,1.570806624237483406503202,0.00006},
	{1,-2,-1,0,-1,4.712405910078434345678033,0.00096},
	{1,-2,-1,0,1,1.570808893165510866651857,0.00012},
	{1,-2,-1,1,-1,4.712397183432174507800028,0.00044},
	{1,-2,-1,1,1,1.570807671435034524876073,0.00005},
	{1,-2,-1,2,-1,1.570808893165510866651857,0.00002},
	{1,-2,0,-3,-1,1.570816747147145031604509,0.00007},
	{1,-2,0,-3,1,4.712397183432174507800028,0.00003},
	{1,-2,0,-2,-1,1.570816049015444137992858,0.00080},
	{1,-2,0,-2,1,4.712396659833398615546685,0.00044},
	{1,-2,0,-1,-1,1.570815176350818243022900,0.00925},
	{1,-2,0,-1,1,4.712397008899248618263300,0.00617},
	{1,-2,0,-1,3,1.570809242231361313457683,0.00003},
	{1,-2,0,0,-1,1.570813081955715784232552,0.09554},
	{1,-2,0,0,0,3.141592653589793115997963,0.00005},
	{1,-2,0,0,1,4.712402768485780768514815,0.00854},
	{1,-2,0,1,-3,4.712404339282107557096424,0.00003},
	{1,-2,0,1,-1,1.570801213716802147146723,0.03855},
	{1,-2,0,1,1,4.712401197689453979933205,0.00785},
	{1,-2,0,2,-3,4.712394216372445043816697,0.00002},
	{1,-2,0,2,-1,1.570834025906739706002213,0.00280},
	{1,-2,0,2,1,4.712401372222378981291513,0.00040},
	{1,-2,0,3,-1,1.570824077530003082259213,0.00047},
	{1,-2,0,3,1,4.712404862880882561171347,0.00002},
	{1,-2,0,4,-1,1.570822332200751292319296,0.00004},
	{1,-2,1,-2,-1,1.570815874482518914589946,0.00007},
	{1,-2,1,-2,1,4.712397707030949511874951,0.00002},
	{1,-2,1,-1,-1,1.570815350883743466425813,0.00069},
	{1,-2,1,-1,1,4.712397357965098620979916,0.00028},
	{1,-2,1,0,-1,1.570813081955715784232552,0.00657},
	{1,-2,1,0,1,4.712402419419929877619779,0.00056},
	{1,-2,1,1,-1,1.570801388249727592594240,0.00160},
	{1,-2,1,1,1,4.712401372222378981291513,0.00029},
	{1,-2,1,2,-1,1.570835945768916719345043,0.00011},
	{1,-2,2,-1,-1,1.570812732889865337426727,0.00003},
	{1,-2,2,0,-1,1.570812907422790560829640,0.00032},
	{1,-2,2,0,1,4.712401546755303982649821,0.00003},
	{1,-2,2,1,-1,1.570801562782652593952548,0.00005},
	{1,-1,-1,-1,-1,1.570817445278845703171555,0.00003},
	{1,-1,-1,0,-1,1.570815001817892797575382,0.00018},
	{1,-1,-1,0,1,4.712398056096800402769986,0.00004},
	{1,-1,0,-1,-1,4.712411320599115605034513,0.00018},
	{1,-1,0,-1,1,4.712401546755303982649821,0.00005},
	{1,-1,0,0,-1,4.712412891395442393616122,0.00063},
	{1,-1,0,0,1,1.570808195033810195084811,0.00075},
	{1,-1,0,1,-1,4.712410447934489710064554,0.00014},
	{1,-1,0,1,1,1.570808893165510866651857,0.00004},
	{1,-1,0,2,-1,4.712411495132040606392820,0.00006},
	{1,-1,1,0,-1,4.712387584121287886773644,0.00003},
	{1,0,-2,-1,-1,4.712412891395442393616122,0.00002},
	{1,0,-2,1,-1,4.712409051671087922841252,0.00006},
	{1,0,-1,-3,-1,4.712411146066189715497785,0.00002},
	{1,0,-1,-2,-1,4.712412367796667389541199,0.00022},
	{1,0,-1,-2,1,4.712401721288228984008128,0.00003},
	{1,0,-1,-1,-1,4.712413414994217397691045,0.00181},
	{1,0,-1,-1,1,1.570824601128778974512556,0.00010},
	{1,0,-1,0,-1,1.570808020500884971681899,0.00028},
	{1,0,-1,0,1,1.570811511159388995650943,0.00013},
	{1,0,-1,1,-1,4.712409575269862926916176,0.00341},
	{1,0,-1,1,1,4.712388980384689673996945,0.00003},
	{1,0,-1,2,-1,4.712410098868638819169519,0.00034},
	{1,0,-1,3,-1,4.712411146066189715497785,0.00003},
	{1,0,0,-4,-1,1.570818667009322044947339,0.00010},
	{1,0,0,-3,-1,1.570818667009322044947339,0.00150},
	{1,0,0,-3,1,4.712388980384689673996945,0.00006},
	{1,0,0,-2,-1,1.570818667009322044947339,0.02469},
	{1,0,0,-2,1,1.570807147836258854667335,0.00485},
	{1,0,0,-1,-1,1.570818667009322044947339,0.45276},
	{1,0,0,-1,1,4.712399626893127191351596,0.08508},
	{1,0,0,0,-3,1.570808020500884971681899,0.00012},
	{1,0,0,0,-1,1.570796501327821781401894,0.02809},
	{1,0,0,0,0,3.141592653589793115997963,0.00025},
	{1,0,0,0,1,1.570805053441156617921592,0.00390},
	{1,0,0,1,-3,4.712395438102921829681691,0.00108},
	{1,0,0,1,-1,4.712410971533264714139477,0.45648},
	{1,0,0,1,1,1.570800515585101475579677,0.00025},
	{1,0,0,2,-3,4.712437849603745121385145,0.00004},
	{1,0,0,2,-1,4.712410971533264714139477,0.02488},
	{1,0,0,2,1,1.570796326794896557998982,0.00002},
	{1,0,0,3,-1,4.712410971533264714139477,0.00153},
	{1,0,0,3,1,4.712388980384689673996945,0.00002},
	{1,0,0,4,-1,4.712410971533264714139477,0.00010},
	{1,0,1,-3,-1,1.570818492476397043589031,0.00003},
	{1,0,1,-2,-1,1.570819714206873385364815,0.00027},
	{1,0,1,-2,1,1.570808893165510866651857,0.00005},
	{1,0,1,-1,-1,1.570821285003200173946425,0.00218},
	{1,0,1,-1,1,4.712403641150406663484773,0.00025},
	{1,0,1,0,-1,1.570810289428912431830554,0.00024},
	{1,0,1,0,1,1.570807496902109523517765,0.00015},
	{1,0,1,1,-1,1.570816572614219808201597,0.00279},
	{1,0,1,2,-1,1.570817445278845703171555,0.00028},
	{1,0,1,3,-1,1.570818492476397043589031,0.00002},
	{1,0,2,-1,-1,1.570821983134900845513471,0.00003},
	{1,0,2,1,-1,1.570817270745920479768643,0.00003},
	{1,1,-1,0,-1,1.570810289428912431830554,0.00002},
	{1,1,0,-2,-1,1.570827742721432551675775,0.00003},
	{1,1,0,-1,-1,4.712380777337204840193863,0.00006},
	{1,1,0,-1,1,1.570808893165510866651857,0.00002},
	{1,1,0,0,-1,1.570811685692313997009251,0.00299},
	{1,1,0,0,1,1.570805227974081841324505,0.00002},
	{1,1,0,1,-1,1.570814478219117349411249,0.00031},
	{1,1,0,2,-1,1.570812034758164665859681,0.00002},
	{1,1,1,0,-1,4.712399103294351299098253,0.00059},
	{1,1,1,1,-1,4.712403815683331664843081,0.00005},
	{1,2,-2,-1,-1,4.712396136234622723293342,0.00007},
	{1,2,-2,0,-1,4.712405211946733452066383,0.00036},
	{1,2,-2,1,-1,4.712405386479658453424690,0.00003},
	{1,2,-1,-2,-1,4.712438024136671010921873,0.00008},
	{1,2,-1,-2,1,4.712399277827276300456560,0.00003},
	{1,2,-1,-1,-1,4.712396310767548612830069,0.00218},
	{1,2,-1,-1,1,4.712395787168771832398306,0.00006},
	{1,2,-1,0,-1,4.712405037413808450708075,0.00745},
	{1,2,-1,0,1,4.712388980384689673996945,0.00002},
	{1,2,-1,1,-1,4.712407306341836132901335,0.00075},
	{1,2,-1,2,-1,4.712408528072312030587909,0.00007},
	{1,2,0,-4,-1,4.712414811257619184914347,0.00004},
	{1,2,0,-3,-1,4.712418301916123652972601,0.00042},
	{1,2,0,-3,1,1.570800515585101475579677,0.00006},
	{1,2,0,-2,-3,4.712410273401563820527826,0.00002},
	{1,2,0,-2,-1,4.712441340262249589443400,0.00177},
	{1,2,0,-2,1,4.712400150491902195426519,0.00078},
	{1,2,0,-1,-3,4.712409924335713817811211,0.00018},
	{1,2,0,-1,-1,4.712396485300473614188377,0.05343},
	{1,2,0,-1,1,4.712399801426052192709903,0.00059},
	{1,2,0,0,-1,4.712405037413808450708075,0.10689},
	{1,2,0,0,1,4.712405561012583454782998,0.00002},
	{1,2,0,1,-3,1.570815001817892797575382,0.00010},
	{1,2,0,1,-1,4.712407306341836132901335,0.00992},
	{1,2,0,2,-1,4.712408353539387029229601,0.00084},
	{1,2,0,3,-1,4.712409051671087922841252,0.00007},
	{1,2,1,-2,-1,1.570808893165510866651857,0.00002},
	{1,2,1,-1,-1,1.570797723058298123177678,0.00016},
	{1,2,1,0,-1,1.570812383824014890620901,0.00115},
	{1,2,1,1,-1,1.570814478219117349411249,0.00016},
	{1,2,2,-1,-1,1.570802086381428264161286,0.00005},
	{1,3,0,-1,-1,1.570808544099660419846032,0.00012},
	{1,3,0,0,-1,4.712405735545509344319726,0.00007},
	{1,4,-1,-2,-1,4.712396310767548612830069,0.00006},
	{1,4,-1,-1,-1,4.712402593952855767156507,0.00020},
	{1,4,-1,0,-1,4.712405211946733452066383,0.00011},
	{1,4,0,-2,-1,4.712396310767548612830069,0.00063},
	{1,4,0,-1,-1,4.712402593952855767156507,0.00176},
	{1,4,0,0,-1,4.712405211946733452066383,0.00084},
	{1,4,0,1,-1,4.712407306341836132901335,0.00013},
	{1,4,1,-1,-1,1.570812732889865337426727,0.00003},
	{1,6,0,-2,-1,4.712401197689453979933205,0.00003},
	{1,6,0,-1,-1,4.712405386479658453424690,0.00002},
	{2,-2,0,-1,-2,4.712388980384689673996945,0.00005},
	{2,-2,0,-1,0,1.570796326794896557998982,0.00009},
	{2,-2,0,0,-2,4.712388980384689673996945,0.00047},
	{2,-2,0,0,0,1.570796326794896557998982,0.00004},
	{2,-2,0,1,-2,4.712388980384689673996945,0.00019},
	{2,-2,1,0,-2,4.712388980384689673996945,0.00004},
	{2,0,-1,0,0,1.570796326794896557998982,0.00002},
	{2,0,0,-2,-2,4.712388980384689673996945,0.00012},
	{2,0,0,-2,0,4.712388980384689673996945,0.00005},
	{2,0,0,-1,-2,4.712388980384689673996945,0.00219},
	{2,0,0,-1,0,1.570796326794896557998982,0.00077},
	{2,0,0,0,-2,4.712388980384689673996945,0.00028},
	{2,0,0,0,-1,0.000000000000000000000000,0.00003},
	{2,0,0,0,0,1.570796326794896557998982,0.00448},
	{2,0,0,1,-2,1.570796326794896557998982,0.00223},
	{2,0,0,1,0,1.570796326794896557998982,0.00050},
	{2,0,0,2,-2,1.570796326794896557998982,0.00012},
	{2,0,0,2,0,1.570796326794896557998982,0.00006},
	{2,1,0,0,-2,4.712388980384689673996945,0.00002},
	{2,1,0,0,0,1.570796326794896557998982,0.00003},
	{2,1,1,0,-2,1.570796326794896557998982,0.00004},
	{2,2,-1,0,-2,1.570796326794896557998982,0.00004},
	{2,2,0,-1,-2,1.570796326794896557998982,0.00032},
	{2,2,0,-1,0,1.570796326794896557998982,0.00009},
	{2,2,0,0,-2,1.570796326794896557998982,0.00056},
	{2,2,0,0,0,1.570796326794896557998982,0.00005},
	{2,2,0,1,-2,1.570796326794896557998982,0.00005},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp7[] = {
	{1,-2,0,0,-1,3.141592653589793115997963,0.00003},
	{1,-2,0,0,1,3.141592653589793115997963,0.00002},
	{1,-2,0,1,-1,3.141592653589793115997963,0.00002},
	{1,0,0,-2,-1,3.141592653589793115997963,0.00001},
	{1,0,0,-1,-1,3.141592653589793115997963,0.00021},
	{1,0,0,-1,1,3.141592653589793115997963,0.00002},
	{1,0,0,0,-1,3.141592653589793115997963,0.00300},
	{1,0,0,0,1,3.141592653589793115997963,0.00015},
	{1,0,0,1,-1,3.141592653589793115997963,0.00021},
	{1,0,0,1,1,3.141592653589793115997963,0.00002},
	{1,0,0,2,-1,3.141592653589793115997963,0.00002},
	{1,2,0,-1,-1,3.141592653589793115997963,0.00003},
	{1,2,0,0,-1,3.141592653589793115997963,0.00004},
	{2,0,0,0,-2,0.000000000000000000000000,0.00004},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp8[] = {
	{1,-2,0,0,0,3.141592653589793115997963,0.00012},
	{1,-2,0,1,0,3.141592653589793115997963,0.00003},
	{1,0,0,-1,-2,3.141592653589793115997963,0.00001},
	{1,0,0,-1,0,3.141592653589793115997963,0.00019},
	{1,0,0,0,-2,3.141592653589793115997963,0.00014},
	{1,0,0,0,0,0.000000000000000000000000,0.00342},
	{1,0,0,1,0,0.000000000000000000000000,0.00018},
	{1,0,0,2,0,0.000000000000000000000000,0.00001},
	{1,2,0,-1,0,0.000000000000000000000000,0.00004},
	{1,2,0,0,0,0.000000000000000000000000,0.00002},
	{2,0,0,0,-1,3.141592653589793115997963,0.00009},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp9[] = {
	{0,0,0,0,0,4.712388980384689673996945,0.00004},
	{1,-2,0,0,-1,4.712388980384689673996945,0.00004},
	{1,-2,0,1,-1,4.712388980384689673996945,0.00002},
	{1,0,0,-1,-1,4.712388980384689673996945,0.00019},
	{1,0,0,-1,1,1.570796326794896557998982,0.00003},
	{1,0,0,1,-1,1.570796326794896557998982,0.00019},
	{1,2,0,-1,-1,1.570796326794896557998982,0.00002},
	{1,2,0,0,-1,1.570796326794896557998982,0.00004},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp22[] = {
	{0,1,1,-1,-1,3.367379790267917449853030,0.00004},
	{0,1,1,0,-1,3.367379790267917449853030,0.00082},
	{0,1,1,1,-1,3.367379790267917449853030,0.00004},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp23[] = {
	{0,1,1,0,-2,3.367379441202067447136415,0.00004},
	{0,1,1,0,0,3.367379615734992448494722,0.00004},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp24[] = {
	{0,1,1,-1,-1,4.938176117062814007852012,0.00004},
	{0,1,1,1,-1,1.796583463473021113898653,0.00004},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp25[] = {
	{0,0,0,1,0,0.000000000000000000000000,0.00058},
	{0,0,0,2,0,0.000000000000000000000000,0.00004},
	{0,2,0,-2,0,0.000000000000000000000000,0.00002},
	{0,2,0,-1,0,0.000000000000000000000000,0.00021},
	{0,2,0,0,0,0.000000000000000000000000,0.00009},
	{0,2,0,1,0,0.000000000000000000000000,0.00001},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp26[] = {
	{0,0,0,0,1,3.141592653589793115997963,0.00005},
	{0,0,0,1,-1,0.000000000000000000000000,0.00003},
	{0,0,0,1,1,0.000000000000000000000000,0.00003},
	{0,2,0,0,-1,0.000000000000000000000000,0.00001},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp27[] = {
	{0,0,0,0,0,1.570796326794896557998982,0.00356},
	{0,0,0,1,0,4.712388980384689673996945,0.00072},
	{0,0,0,2,0,4.712388980384689673996945,0.00003},
	{0,2,0,-1,0,4.712388980384689673996945,0.00019},
	{0,2,0,0,0,4.712388980384689673996945,0.00013},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp28[] = {
	{0,0,0,0,1,5.305135082953126079985395,0.00004},
	{0,0,0,1,-1,4.535830251522467548852546,0.00016},
	{0,0,0,2,-2,0.007508406442079606016304,0.00040},
	{0,0,0,3,-2,0.007571063762226202566163,0.00002},
	{0,0,1,-1,0,6.283160523504208505585211,0.00014},
	{0,0,1,0,0,6.283182165586932654832708,0.00223},
	{0,0,1,1,0,6.283178500395504073594566,0.00014},
	{0,1,0,-1,0,6.283068544652627984703486,0.00009},
	{0,1,0,0,0,6.283104498435219120722195,0.00001},
	{0,1,1,-1,0,0.001120152313929960712774,0.00003},
	{0,2,-1,-1,0,3.141609234217686896784016,0.00004},
	{0,2,-1,0,0,3.141595097050745799549532,0.00003},
	{0,2,0,-3,0,3.141265578887969311949746,0.00001},
	{0,2,0,-2,0,3.141307466790017155489068,0.00025},
	{0,2,0,-1,0,3.141529472670870681838551,0.00014},
	{0,2,0,0,-2,3.140870785411168597534015,0.00003},
	{0,2,0,0,0,3.141575898428974333853603,0.00002},
	{0,2,1,-2,0,3.141450234722830359146428,0.00002},
	{0,2,1,-1,0,0.000054628805587422513959,0.00002},
	{0,2,1,0,0,6.283179198527204079027797,0.00002},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp29[] = {
	{0,0,0,1,-1,0.000383797902513553052754,0.00003},
	{0,0,0,1,0,4.293347120686839879510899,0.00001},
	{0,0,0,1,1,0.000092502450355699472541,0.00001},
	{0,0,0,2,-3,0.007379775676207623626157,0.00002},
	{0,0,0,2,-1,0.013003575591983751805203,0.00001},
	{0,0,1,-1,-1,6.283182165586932654832708,0.00001},
	{0,0,1,0,-1,6.283182165586932654832708,0.00010},
	{0,0,1,0,1,6.283182165586932654832708,0.00010},
	{0,0,1,1,1,6.283182165586932654832708,0.00001},
	{0,2,0,-2,-1,3.141305721460765365549150,0.00001},
	{0,2,0,-2,1,3.141305197861989917385017,0.00001},
	{0,2,0,0,-1,3.141501547402838934175406,0.00005},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp30[] = {
	{0,0,0,0,0,1.570796326794896557998982,0.00130},
	{0,0,0,0,1,3.734257598348011519817646,0.00003},
	{0,0,0,0,2,4.713042606189561389840037,0.00002},
	{0,0,0,1,0,1.572122253427636673350776,0.00004},
	{0,0,0,3,-2,4.719968770793175671940389,0.00002},
	{0,0,1,-1,0,1.570782189627955460764497,0.00013},
	{0,0,1,0,0,4.712390202115166459861939,0.00022},
	{0,0,1,1,0,4.712372050690945890494277,0.00011},
	{0,2,-1,-1,0,1.570764038203734669352230,0.00002},
	{0,2,-1,0,0,1.570805402507006842682813,0.00003},
	{0,2,0,-2,0,4.712142016295532975789229,0.00005},
	{0,2,0,-1,0,1.570772415784144282469015,0.00013},
	{0,2,1,-1,0,4.712385838792036096833726,0.00002},
	{0,2,1,0,0,4.712385838792036096833726,0.00003},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp31[] = {
	{0,0,1,-1,0,3.140453477187016506633199,0.00006},
	{0,0,1,0,0,3.141336439255600243569688,0.00081},
	{0,0,1,1,0,3.140950896023835259285306,0.00005},
	{0,1,0,0,0,0.000000174532925199432966,0.00013},
	{0,1,1,0,0,3.141990937725098298471949,0.00001},
	{0,2,-1,-1,0,0.000395142542651516243558,0.00002},
	{0,2,0,-1,0,6.282980405525402822775050,0.00002},
	{0,2,0,0,0,3.141595969715372138608700,0.00055},
	{0,2,0,1,0,3.141595620649521691802875,0.00006},
	{0,2,1,-1,0,3.154674594465191272973925,0.00001},
	{0,4,0,-1,0,3.141598762242175268966093,0.00001},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp32[] = {
	{0,0,1,0,-1,3.141558270603528768560864,0.00004},
	{0,0,1,0,1,3.141557397938903317680115,0.00004},
	{0,2,0,0,-1,6.283152145923798670423821,0.00002},
	{0,2,0,0,1,3.141597191445848480384484,0.00002},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp33[] = {
	{0,0,0,0,0,4.712388980384689673996945,0.00828},
	{0,0,0,1,0,1.570795279597345217581505,0.00043},
	{0,0,1,-1,0,4.711218213522452735730894,0.00005},
	{0,0,1,0,0,4.712547456280770319381190,0.00009},
	{0,0,1,1,0,1.570057179856676921048120,0.00005},
	{0,1,0,0,0,4.712389329450540564891980,0.00006},
	{0,2,-1,0,0,1.570285119856987376962820,0.00002},
	{0,2,0,-1,0,4.712278501043038581030942,0.00003},
	{0,2,0,0,0,1.570798770255849463595155,0.00106},
	{0,2,0,1,0,1.570798072124148569983504,0.00008},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp34[] = {
	{0,0,1,-2,0,0.000000000000000000000000,0.00007},
	{0,0,1,-1,0,0.000000000000000000000000,0.00108},
	{0,0,1,0,0,0.000000000000000000000000,0.00487},
	{0,0,1,1,0,0.000000000000000000000000,0.00080},
	{0,0,1,2,0,0.000000000000000000000000,0.00006},
	{0,0,2,-1,0,0.000000000000000000000000,0.00004},
	{0,0,2,0,0,0.000000000000000000000000,0.00011},
	{0,0,2,1,0,0.000000000000000000000000,0.00002},
	{0,1,1,0,0,3.141592653589793115997963,0.00013},
	{0,2,-2,-1,0,3.141592653589793115997963,0.00011},
	{0,2,-2,0,0,3.141592653589793115997963,0.00012},
	{0,2,-2,1,0,3.141592653589793115997963,0.00001},
	{0,2,-1,-2,0,3.141592653589793115997963,0.00006},
	{0,2,-1,-1,0,3.141592653589793115997963,0.00150},
	{0,2,-1,0,-2,3.141592653589793115997963,0.00002},
	{0,2,-1,0,0,3.141592653589793115997963,0.00120},
	{0,2,-1,1,0,3.141592653589793115997963,0.00011},
	{0,2,0,-1,0,0.000000000000000000000000,0.00002},
	{0,2,0,0,0,0.000000000000000000000000,0.00003},
	{0,2,1,-2,0,3.141592653589793115997963,0.00002},
	{0,2,1,-1,0,0.000000000000000000000000,0.00021},
	{0,2,1,0,-2,0.000000000000000000000000,0.00001},
	{0,2,1,0,0,0.000000000000000000000000,0.00018},
	{0,2,1,1,0,0.000000000000000000000000,0.00002},
	{0,2,2,-1,0,0.000000000000000000000000,0.00004},
	{0,4,-1,-2,0,3.141592653589793115997963,0.00002},
	{0,4,-1,-1,0,3.141592653589793115997963,0.00003},
	{0,4,-1,0,0,3.141592653589793115997963,0.00001},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp35[] = {
	{0,0,1,-1,-1,0.000000000000000000000000,0.00005},
	{0,0,1,-1,1,0.000000000000000000000000,0.00004},
	{0,0,1,0,-1,0.000000000000000000000000,0.00004},
	{0,0,1,0,1,0.000000000000000000000000,0.00005},
	{0,0,1,1,-1,0.000000000000000000000000,0.00004},
	{0,0,1,1,1,0.000000000000000000000000,0.00004},
	{0,2,-2,0,-1,3.141592653589793115997963,0.00002},
	{0,2,-1,-1,-1,3.141592653589793115997963,0.00005},
	{0,2,-1,-1,1,3.141592653589793115997963,0.00006},
	{0,2,-1,0,-1,3.141592653589793115997963,0.00022},
	{0,2,-1,0,1,3.141592653589793115997963,0.00006},
	{0,2,-1,1,-1,3.141592653589793115997963,0.00001},
	{0,2,1,0,-1,0.000000000000000000000000,0.00009},
	{0,0,0,0,0,0,0}
};

struct elp82b_term2 elp36[] = {
	{0,0,1,-2,0,1.570796326794896557998982,0.00005},
	{0,0,1,-1,0,1.570796326794896557998982,0.00095},
	{0,0,1,0,0,4.712388980384689673996945,0.00036},
	{0,0,1,1,0,4.712388980384689673996945,0.00077},
	{0,0,1,2,0,4.712388980384689673996945,0.00004},
	{0,0,2,-1,0,1.570796326794896557998982,0.00003},
	{0,1,1,0,0,1.570796326794896557998982,0.00012},
	{0,2,-2,-1,0,1.570796326794896557998982,0.00007},
	{0,2,-2,0,0,1.570796326794896557998982,0.00014},
	{0,2,-1,-2,0,4.712388980384689673996945,0.00007},
	{0,2,-1,-1,0,1.570796326794896557998982,0.00111},
	{0,2,-1,0,0,1.570796326794896557998982,0.00149},
	{0,2,-1,1,0,1.570796326794896557998982,0.00009},
	{0,2,0,0,0,4.712388980384689673996945,0.00004},
	{0,2,1,-1,0,4.712388980384689673996945,0.00018},
	{0,2,1,0,0,4.712388980384689673996945,0.00023},
	{0,2,1,1,0,4.712388980384689673996945,0.00002},
	{0,2,2,-1,0,4.712388980384689673996945,0.00003},
	{0,4,-1,-1,0,1.570796326794896557998982,0.00003},
	{0,0,0,0,0,0,0}
};

struct elp82b_term3 elp10[] = {
	{0,0,0,0,0,0,0,0,0,0,2,6.283155811115228139840383,0.00020},
	{0,0,0,0,0,0,0,0,0,1,-2,6.282880572692187470806857,0.00007},
	{0,0,0,0,0,0,0,0,0,1,0,6.282081211894774419590703,0.00962},
	{0,0,0,0,0,0,0,0,0,1,2,3.142204915091392880555077,0.00002},
	{0,0,0,0,0,0,0,0,0,2,0,6.282463439000961713531979,0.00048},
	{0,0,0,0,0,0,0,0,0,3,0,6.282203559475339815776351,0.00005},
	{0,0,0,0,0,0,0,0,1,-2,0,3.141623196851702992660194,0.00004},
	{0,0,0,0,0,0,0,0,1,-1,0,3.141908558184404398616607,0.00071},
	{0,0,0,0,0,0,0,0,1,0,-1,1.693285279029110634851918,0.00011},
	{0,0,0,0,0,0,0,0,1,0,0,3.141859514432423061691679,0.00414},
	{0,0,0,0,0,0,0,0,1,0,1,4.339689801117494027948851,0.00002},
	{0,0,0,0,0,0,0,0,1,1,-1,4.528570903564647309735847,0.00001},
	{0,0,0,0,0,0,0,0,1,1,0,3.141897039011340986291998,0.00029},
	{0,0,0,0,0,0,0,0,2,-4,0,3.158089854745494307053377,0.00001},
	{0,0,0,0,0,0,0,0,2,-3,0,3.232934634525841399721457,0.00003},
	{0,0,0,0,0,0,0,0,2,-2,-2,0.000734434549239213851739,0.00001},
	{0,0,0,0,0,0,0,0,2,-2,0,0.001369210798189551608547,0.00212},
	{0,0,0,0,0,0,0,0,2,-1,0,0.002129999819133879691152,0.03726},
	{0,0,0,0,0,0,0,0,2,-1,2,3.143380917941386520908509,0.00008},
	{0,0,0,0,0,0,0,0,2,0,-2,0.004131019806545378758589,0.00024},
	{0,0,0,0,0,0,0,0,2,0,0,0.001744282054443132938537,0.01585},
	{0,0,0,0,0,0,0,0,2,0,2,3.143546200621550656961745,0.00005},
	{0,0,0,0,0,0,0,0,2,1,-2,3.141870684539636027210463,0.00007},
	{0,0,0,0,0,0,0,0,2,1,0,0.002039940829730972366579,0.00135},
	{0,0,0,0,0,0,0,0,2,2,0,6.282022045233132345742888,0.00009},
	{0,0,0,0,0,0,0,0,3,-1,0,3.143766635706077394729618,0.00006},
	{0,0,0,0,0,0,0,0,3,0,-1,3.750727746900306414090664,0.00001},
	{0,0,0,0,0,0,0,0,4,-3,0,0.009844006047098416076202,0.00006},
	{0,0,0,0,0,0,0,0,4,-2,0,0.002140995393421443997867,0.00049},
	{0,0,0,0,0,0,0,0,4,-1,0,0.002002939849588692387827,0.00057},
	{0,0,0,0,0,0,0,0,4,0,-2,0.000354999969855646633262,0.00002},
	{0,0,0,0,0,0,0,0,4,0,0,0.002975437308799932720205,0.00020},
	{0,0,0,0,0,0,0,0,4,1,0,0.001923178302772551601790,0.00005},
	{0,0,0,0,0,0,0,0,6,-1,0,0.002159321350567384653618,0.00001},
	{0,0,0,0,0,0,0,1,-2,0,0,5.582225823927773333821278,0.00002},
	{0,0,0,0,0,0,0,1,-2,1,0,0.858196544629832525075130,0.00005},
	{0,0,0,0,0,0,0,1,0,-2,0,4.558601736806162207926718,0.00002},
	{0,0,0,0,0,0,0,1,0,-1,0,4.556213079191882897589494,0.00031},
	{0,0,0,0,0,0,0,1,0,0,0,4.540241396673956764118429,0.00074},
	{0,0,0,0,0,0,0,1,0,1,0,4.556213079191882897589494,0.00031},
	{0,0,0,0,0,0,0,1,0,2,0,4.558601736806162207926718,0.00002},
	{0,0,0,0,0,0,0,1,2,-1,0,0.827252555123673904979853,0.00004},
	{0,0,0,0,0,0,0,1,2,0,0,5.491683378322063546761456,0.00002},
	{0,0,0,0,0,0,0,2,-2,1,0,2.680065116575271133569913,0.00003},
	{0,0,0,0,0,0,0,2,0,-1,0,5.822142448098342804030381,0.00015},
	{0,0,0,0,0,0,0,2,0,0,0,5.825340938485547681580101,0.00035},
	{0,0,0,0,0,0,0,2,0,1,0,5.822142448098342804030381,0.00015},
	{0,0,0,0,0,0,0,2,2,-1,0,2.680065116575271133569913,0.00003},
	{0,0,0,0,0,0,1,-2,-2,0,0,2.551985700213993624174691,0.00007},
	{0,0,0,0,0,0,1,-2,-2,1,0,4.453876920231671476813062,0.00018},
	{0,0,0,0,0,0,1,-2,-2,2,0,4.930451638859338459042192,0.00002},
	{0,0,0,0,0,0,1,-2,0,-2,0,1.763821364485059994819949,0.00008},
	{0,0,0,0,0,0,1,-2,0,-1,0,1.765349749311031501974867,0.00125},
	{0,0,0,0,0,0,1,-2,0,0,0,1.659761169289728721665256,0.00297},
	{0,0,0,0,0,0,1,-2,0,1,0,1.765349749311031501974867,0.00125},
	{0,0,0,0,0,0,1,-2,0,2,0,1.649987674544410864996280,0.00008},
	{0,0,0,0,0,0,1,-2,2,-2,0,4.930451464326412569505464,0.00002},
	{0,0,0,0,0,0,1,-2,2,-1,0,4.455666406313741667588602,0.00018},
	{0,0,0,0,0,0,1,-2,2,0,0,2.556057727891821951260454,0.00007},
	{0,0,0,0,0,0,1,0,-2,-1,0,3.217899321151611147229232,0.00003},
	{0,0,0,0,0,0,1,0,-2,0,0,3.280023094145872786242535,0.00017},
	{0,0,0,0,0,0,1,0,-2,1,0,3.025508885177473406002946,0.00030},
	{0,0,0,0,0,0,1,0,0,-2,0,4.140429400141655946754327,0.00003},
	{0,0,0,0,0,0,1,0,0,-1,0,4.191322328465184376966590,0.00047},
	{0,0,0,0,0,0,1,0,0,0,0,4.229434210676358496527882,0.00110},
	{0,0,0,0,0,0,1,0,0,1,0,4.194055339540882165749736,0.00047},
	{0,0,0,0,0,0,1,0,0,2,0,4.139935122897490771265439,0.00003},
	{0,0,0,0,0,0,1,0,2,-1,0,3.059631468317363545139642,0.00030},
	{0,0,0,0,0,0,1,0,2,0,0,3.308987880280270132971054,0.00017},
	{0,0,0,0,0,0,1,0,2,1,0,3.247466245877946633413558,0.00003},
	{0,0,0,0,0,0,2,-4,0,0,0,6.087237541124032702555269,0.00001},
	{0,0,0,0,0,0,2,-2,0,0,0,6.277849486590389105344912,0.00005},
	{0,0,0,0,0,0,2,0,-2,1,0,2.826241153818776385975298,0.00002},
	{0,0,0,0,0,0,2,0,0,-1,0,5.966856423027453004692688,0.00013},
	{0,0,0,0,0,0,2,0,0,0,0,5.960213699894362449072105,0.00030},
	{0,0,0,0,0,0,2,0,0,1,0,5.966856423027453004692688,0.00013},
	{0,0,0,0,0,0,2,0,2,-1,0,2.826241153818776385975298,0.00002},
	{0,0,0,0,0,0,3,0,0,-1,0,2.664526275711840419546661,0.00001},
	{0,0,0,0,0,0,3,0,0,0,0,2.959597747706383952248643,0.00002},
	{0,0,0,0,0,0,3,0,0,1,0,2.664526275711840419546661,0.00001},
	{0,0,0,0,0,1,-3,0,-2,0,0,5.063285855701823656715987,0.00001},
	{0,0,0,0,0,1,-3,0,-2,1,0,2.194802497997027757037358,0.00001},
	{0,0,0,0,0,1,-3,0,0,-1,0,5.348505118601783792087190,0.00008},
	{0,0,0,0,0,1,-3,0,0,0,0,5.455242997935524584818268,0.00015},
	{0,0,0,0,0,1,-3,0,0,1,0,5.348505118601783792087190,0.00008},
	{0,0,0,0,0,1,-3,0,2,-1,0,2.194802497997027757037358,0.00001},
	{0,0,0,0,0,1,-3,0,2,0,0,5.058133818282861682291696,0.00001},
	{0,0,0,0,0,1,-2,0,0,0,0,4.747238842223886479132489,0.00001},
	{0,0,0,0,0,1,0,0,-4,0,0,4.675839516919900518132636,0.00005},
	{0,0,0,0,0,1,0,0,-4,1,0,4.689064051195187765586070,0.00011},
	{0,0,0,0,0,1,0,0,-4,2,0,4.710988528192889823742462,0.00006},
	{0,0,0,0,0,1,0,0,-3,0,0,4.678169880537164537770423,0.00001},
	{0,0,0,0,0,1,0,0,-2,-2,0,4.655819368669050106745999,0.00006},
	{0,0,0,0,0,1,0,0,-2,-1,0,4.647313157493605295655925,0.00039},
	{0,0,0,0,0,1,0,0,-2,-1,2,1.533243822608986617339610,0.00001},
	{0,0,0,0,0,1,0,0,-2,0,-2,4.676480576354158813501272,0.00001},
	{0,0,0,0,0,1,0,0,-2,0,0,4.671936960712441688770014,0.00390},
	{0,0,0,0,0,1,0,0,-2,0,2,4.675048184637046411182837,0.00008},
	{0,0,0,0,0,1,0,0,-2,1,0,4.698390916184919774423179,0.00584},
	{0,0,0,0,0,1,0,0,-2,1,2,1.533243822608986617339610,0.00001},
	{0,0,0,0,0,1,0,0,-2,2,0,4.753638440992174807320225,0.00020},
	{0,0,0,0,0,1,0,0,-1,0,0,1.526326035585781726311438,0.00012},
	{0,0,0,0,0,1,0,0,-1,1,0,1.533243822608986617339610,0.00002},
	{0,0,0,0,0,1,0,0,0,-3,0,4.545828195609591837467178,0.00003},
	{0,0,0,0,0,1,0,0,0,-2,0,4.553209367549200692337763,0.00058},
	{0,0,0,0,0,1,0,0,0,-1,-2,1.422615429839625189600838,0.00002},
	{0,0,0,0,0,1,0,0,0,-1,0,4.551594239859405810477710,0.00854},
	{0,0,0,0,0,1,0,0,0,-1,2,4.564208083429418749688011,0.00001},
	{0,0,0,0,0,1,0,0,0,0,0,4.541592630580851164268097,0.01901},
	{0,0,0,0,0,1,0,0,0,1,-2,4.564208083429418749688011,0.00001},
	{0,0,0,0,0,1,0,0,0,1,0,4.551057202048566452390332,0.00850},
	{0,0,0,0,0,1,0,0,0,1,2,1.422615429839625189600838,0.00002},
	{0,0,0,0,0,1,0,0,0,2,0,4.552296909416257975067310,0.00058},
	{0,0,0,0,0,1,0,0,0,3,0,4.544391964168124964373874,0.00003},
	{0,0,0,0,0,1,0,0,1,-1,0,1.522792965580969770655884,0.00002},
	{0,0,0,0,0,1,0,0,1,0,-1,1.155025388648208917174998,0.00002},
	{0,0,0,0,0,1,0,0,1,0,0,1.530503481150430333812551,0.00010},
	{0,0,0,0,0,1,0,0,2,-2,0,4.762302953530775262436237,0.00019},
	{0,0,0,0,0,1,0,0,2,-1,-2,1.522794361844371335834580,0.00001},
	{0,0,0,0,0,1,0,0,2,-1,0,4.692522072042163649996382,0.00583},
	{0,0,0,0,0,1,0,0,2,0,-2,4.664191014959165215714165,0.00008},
	{0,0,0,0,0,1,0,0,2,0,0,4.661894510729391427616974,0.00392},
	{0,0,0,0,0,1,0,0,2,0,2,4.662805921664783248559161,0.00001},
	{0,0,0,0,0,1,0,0,2,1,-2,1.522794361844371335834580,0.00001},
	{0,0,0,0,0,1,0,0,2,1,0,4.644298275743709680796201,0.00038},
	{0,0,0,0,0,1,0,0,2,2,0,4.647841992256959819940221,0.00005},
	{0,0,0,0,0,1,0,0,3,-2,0,4.661608974863765908480673,0.00001},
	{0,0,0,0,0,1,0,0,3,0,0,4.661502335246468398111119,0.00001},
	{0,0,0,0,0,1,0,0,4,-2,0,4.703627776605528332254380,0.00006},
	{0,0,0,0,0,1,0,0,4,-1,0,4.684808240347123842184374,0.00011},
	{0,0,0,0,0,1,0,0,4,0,0,4.659233930817650914946171,0.00005},
	{0,0,0,0,0,2,-3,0,0,0,0,3.696771591206602813883819,0.00003},
	{0,0,0,0,0,2,0,0,-2,-1,0,2.897315847881891226478501,0.00004},
	{0,0,0,0,0,2,0,0,-2,0,0,2.938411719515200193342253,0.00022},
	{0,0,0,0,0,2,0,0,-2,1,0,2.841559908663530809036502,0.00049},
	{0,0,0,0,0,2,0,0,-2,2,0,2.863066030239529879963811,0.00001},
	{0,0,0,0,0,2,0,0,-1,0,1,5.671824744539854634695075,0.00001},
	{0,0,0,0,0,2,0,0,0,-2,0,5.672397736133285128801163,0.00003},
	{0,0,0,0,0,2,0,0,0,-1,0,5.692483857829861548793815,0.00050},
	{0,0,0,0,0,2,0,0,0,0,0,5.704318935487634689707193,0.00111},
	{0,0,0,0,0,2,0,0,0,1,0,5.697132891358398509851213,0.00051},
	{0,0,0,0,0,2,0,0,0,2,0,5.671596106407844395391749,0.00003},
	{0,0,0,0,0,2,0,0,2,-2,0,2.890374673446709508084496,0.00001},
	{0,0,0,0,0,2,0,0,2,-1,0,2.862284995399262399473628,0.00043},
	{0,0,0,0,0,2,0,0,2,0,0,3.103956548132712711662862,0.00014},
	{0,0,0,0,0,2,0,0,2,1,0,2.962619610773286726868037,0.00003},
	{0,0,0,0,0,3,0,0,-2,0,0,0.850800711924506569694415,0.00003},
	{0,0,0,0,0,3,0,0,-2,1,0,1.132404525278960960577024,0.00003},
	{0,0,0,0,0,3,0,0,0,-1,0,4.526272654005620843520319,0.00003},
	{0,0,0,0,0,3,0,0,0,0,0,4.760512071185303284437396,0.00010},
	{0,0,0,0,0,3,0,0,0,1,0,4.526272654005620843520319,0.00003},
	{0,0,0,0,0,3,0,0,2,0,0,0.851379812170318328590213,0.00001},
	{0,0,0,0,0,5,0,0,0,-1,0,5.402727437006416444376100,0.00002},
	{0,0,0,0,0,5,0,0,0,0,0,5.371234366917580160816215,0.00004},
	{0,0,0,0,0,5,0,0,0,1,0,5.402727437006416444376100,0.00002},
	{0,0,0,0,1,-5,0,0,-2,0,0,3.496831559020038060481284,0.00008},
	{0,0,0,0,1,-5,0,0,-2,1,0,3.378214445198448157015036,0.00016},
	{0,0,0,0,1,-5,0,0,0,-1,0,4.503136743974109457155919,0.00012},
	{0,0,0,0,1,-5,0,0,0,0,0,4.701094082130408580155745,0.00022},
	{0,0,0,0,1,-5,0,0,0,1,0,4.402225122749375607611455,0.00012},
	{0,0,0,0,1,-5,0,0,2,-1,0,3.267819926548853892711577,0.00017},
	{0,0,0,0,1,-5,0,0,2,0,0,3.378163307051364583344366,0.00009},
	{0,0,0,0,1,-4,0,0,0,0,0,3.326945747486964588546243,0.00002},
	{0,0,0,0,1,-3,0,0,-2,0,0,2.354247749944670786703682,0.00005},
	{0,0,0,0,1,-3,0,0,-2,1,0,2.154438966517855380544688,0.00009},
	{0,0,0,0,1,-3,0,0,0,-1,0,4.110469950866547428347531,0.00010},
	{0,0,0,0,1,-3,0,0,0,0,0,4.791882270094798279558290,0.00040},
	{0,0,0,0,1,-3,0,0,0,1,0,4.110469950866547428347531,0.00010},
	{0,0,0,0,1,-3,0,0,2,-1,0,2.103426308607640127235072,0.00009},
	{0,0,0,0,1,-3,0,0,2,0,0,2.301813521358705649788590,0.00005},
	{0,0,0,0,1,-2,0,0,-2,-1,0,6.205854480412698492841628,0.00004},
	{0,0,0,0,1,-2,0,0,-2,0,0,6.149630443888952413544757,0.00025},
	{0,0,0,0,1,-2,0,0,-2,1,0,0.107918245506864574068118,0.00046},
	{0,0,0,0,1,-2,0,0,-2,2,0,0.606990956324438335478533,0.00001},
	{0,0,0,0,1,-2,0,0,0,-2,0,5.205594243322908987181563,0.00004},
	{0,0,0,0,1,-2,0,0,0,-1,0,5.110238877771899446145198,0.00062},
	{0,0,0,0,1,-2,0,0,0,0,0,4.780043178179746554690155,0.00129},
	{0,0,0,0,1,-2,0,0,0,1,0,5.107250874092485126709562,0.00063},
	{0,0,0,0,1,-2,0,0,0,2,0,5.196441038593750505469870,0.00004},
	{0,0,0,0,1,-2,0,0,2,-2,0,0.542235750416944717322565,0.00001},
	{0,0,0,0,1,-2,0,0,2,-1,0,0.069079259129309567022403,0.00046},
	{0,0,0,0,1,-2,0,0,2,0,0,6.114514070272976553610533,0.00025},
	{0,0,0,0,1,-2,0,0,2,1,0,6.172425840183400680416526,0.00004},
	{0,0,0,0,1,-1,0,0,-2,-1,0,3.091777640612296540467696,0.00003},
	{0,0,0,0,1,-1,0,0,-2,0,0,3.091777640612296540467696,0.00017},
	{0,0,0,0,1,-1,0,0,-2,1,0,3.093838874458901599950877,0.00032},
	{0,0,0,0,1,-1,0,0,-2,2,0,3.091777640612296540467696,0.00001},
	{0,0,0,0,1,-1,0,0,0,-2,0,3.071327966832529288154774,0.00001},
	{0,0,0,0,1,-1,0,0,0,-1,0,3.082138012620606382085953,0.00012},
	{0,0,0,0,1,-1,0,0,0,0,0,6.086907673895406212238868,0.00022},
	{0,0,0,0,1,-1,0,0,0,1,0,3.078957848190547519351412,0.00012},
	{0,0,0,0,1,-1,0,0,0,2,0,3.071627814398021794062288,0.00001},
	{0,0,0,0,1,-1,0,0,2,-2,0,3.087021792933537067682437,0.00001},
	{0,0,0,0,1,-1,0,0,2,-1,0,3.088450868525069559211715,0.00032},
	{0,0,0,0,1,-1,0,0,2,0,0,3.087021967466462069040745,0.00016},
	{0,0,0,0,1,-1,0,0,2,1,0,3.087021967466462069040745,0.00003},
	{0,0,0,0,1,0,0,0,-6,0,0,3.106290053342628976196238,0.00001},
	{0,0,0,0,1,0,0,0,-6,1,0,6.193880300013540285419822,0.00002},
	{0,0,0,0,1,0,0,0,-6,2,0,6.190364683301248227564884,0.00002},
	{0,0,0,0,1,0,0,0,-4,-2,0,3.081542506279825843762410,0.00001},
	{0,0,0,0,1,0,0,0,-4,-1,0,6.086563145901062732434639,0.00006},
	{0,0,0,0,1,0,0,0,-4,0,0,0.004695459286640345057673,0.00040},
	{0,0,0,0,1,0,0,0,-4,1,0,0.003438124093503629619822,0.00102},
	{0,0,0,0,1,0,0,0,-4,1,2,6.212955177941512197037355,0.00002},
	{0,0,0,0,1,0,0,0,-4,2,0,0.025765597615491488830974,0.00078},
	{0,0,0,0,1,0,0,0,-4,3,0,6.135892608280654414443234,0.00003},
	{0,0,0,0,1,0,0,0,-3,0,0,4.880923208945017854887283,0.00005},
	{0,0,0,0,1,0,0,0,-3,1,0,3.561371914896610757494955,0.00005},
	{0,0,0,0,1,0,0,0,-3,2,0,1.243917799979083582684325,0.00003},
	{0,0,0,0,1,0,0,0,-2,-3,0,6.205851687885894918395024,0.00002},
	{0,0,0,0,1,0,0,0,-2,-2,0,6.013797402325690377722367,0.00021},
	{0,0,0,0,1,0,0,0,-2,-1,-2,3.056418491697367567638821,0.00002},
	{0,0,0,0,1,0,0,0,-2,-1,0,6.116648782481091117801952,0.00286},
	{0,0,0,0,1,0,0,0,-2,-1,2,2.952088643132603440477624,0.00008},
	{0,0,0,0,1,0,0,0,-2,0,-2,3.046363998942478445997040,0.00005},
	{0,0,0,0,1,0,0,0,-2,0,0,6.198267010555503553348444,0.03309},
	{0,0,0,0,1,0,0,0,-2,0,2,6.195912735927487702269900,0.00072},
	{0,0,0,0,1,0,0,0,-2,1,-2,3.148765084150864090872801,0.00013},
	{0,0,0,0,1,0,0,0,-2,1,0,6.279859756822836480694150,0.05756},
	{0,0,0,0,1,0,0,0,-2,1,2,6.168371789396867477250908,0.00003},
	{0,0,0,0,1,0,0,0,-2,2,0,0.090676137826412595011050,0.00253},
	{0,0,0,0,1,0,0,0,-2,3,0,0.371260329831851809689880,0.00012},
	{0,0,0,0,1,0,0,0,-1,-1,0,3.428032425235673308350215,0.00010},
	{0,0,0,0,1,0,0,0,-1,-1,1,1.370137218956509972400681,0.00007},
	{0,0,0,0,1,0,0,0,-1,0,-1,4.518274333642506412900275,0.00008},
	{0,0,0,0,1,0,0,0,-1,0,0,3.286945069959282594851402,0.00100},
	{0,0,0,0,1,0,0,0,-1,0,1,1.377140352580137339089106,0.00034},
	{0,0,0,0,1,0,0,0,-1,1,-1,4.512303562271434032027173,0.00008},
	{0,0,0,0,1,0,0,0,-1,1,0,3.355335273099905091243045,0.00016},
	{0,0,0,0,1,0,0,0,-1,1,1,1.369793563626792387566411,0.00005},
	{0,0,0,0,1,0,0,0,-1,2,0,2.721770457183376734633384,0.00002},
	{0,0,0,0,1,0,0,0,0,-4,0,5.051834052347787817893732,0.00001},
	{0,0,0,0,1,0,0,0,0,-3,0,5.110030136393361566149451,0.00019},
	{0,0,0,0,1,0,0,0,0,-2,-2,2.138108444305720112765812,0.00001},
	{0,0,0,0,1,0,0,0,0,-2,0,5.164275493144120154909160,0.00273},
	{0,0,0,0,1,0,0,0,0,-1,-2,1.980789352452857032815814,0.00008},
	{0,0,0,0,1,0,0,0,0,-1,0,5.148444484163905876528133,0.04046},
	{0,0,0,0,1,0,0,0,0,-1,2,5.100753013287310899670501,0.00006},
	{0,0,0,0,1,0,0,0,0,0,-2,4.494132066764294997085472,0.00003},
	{0,0,0,0,1,0,0,0,0,0,-1,4.482965973808810566936245,0.00002},
	{0,0,0,0,1,0,0,0,0,0,0,5.003794039219569000920274,0.08634},
	{0,0,0,0,1,0,0,0,0,0,2,3.697311945143020306403514,0.00003},
	{0,0,0,0,1,0,0,0,0,1,-2,5.121848807956165927635084,0.00010},
	{0,0,0,0,1,0,0,0,0,1,0,5.125527612953519884797515,0.04040},
	{0,0,0,0,1,0,0,0,0,1,2,1.964137515125429445106420,0.00008},
	{0,0,0,0,1,0,0,0,0,2,0,5.115375207227593534753396,0.00279},
	{0,0,0,0,1,0,0,0,0,2,2,2.137604916816520095323995,0.00001},
	{0,0,0,0,1,0,0,0,0,3,0,5.090272311129083959713171,0.00019},
	{0,0,0,0,1,0,0,0,0,4,0,5.040271420586249995210437,0.00001},
	{0,0,0,0,1,0,0,0,1,-2,0,3.630106646031576733690827,0.00001},
	{0,0,0,0,1,0,0,0,1,-1,-1,1.152944432581056277697940,0.00006},
	{0,0,0,0,1,0,0,0,1,-1,0,3.258937073320828936573434,0.00013},
	{0,0,0,0,1,0,0,0,1,-1,1,4.512598173849170279936516,0.00010},
	{0,0,0,0,1,0,0,0,1,0,-1,1.344408796854086096672631,0.00041},
	{0,0,0,0,1,0,0,0,1,0,0,3.105870825256300093997197,0.00074},
	{0,0,0,0,1,0,0,0,1,0,1,4.512631509637882842866929,0.00009},
	{0,0,0,0,1,0,0,0,1,1,-1,1.840082129887550488334114,0.00006},
	{0,0,0,0,1,0,0,0,1,1,0,3.042784154113713057654422,0.00007},
	{0,0,0,0,1,0,0,0,1,2,-1,1.347400465724929663480225,0.00001},
	{0,0,0,0,1,0,0,0,2,-3,0,0.469031754666396905051329,0.00012},
	{0,0,0,0,1,0,0,0,2,-2,0,0.138046642653566281611077,0.00237},
	{0,0,0,0,1,0,0,0,2,-1,-2,6.148790067854116969670031,0.00003},
	{0,0,0,0,1,0,0,0,2,-1,0,6.215766379767699412184356,0.05274},
	{0,0,0,0,1,0,0,0,2,-1,2,3.095660649132133457328564,0.00012},
	{0,0,0,0,1,0,0,0,2,0,-2,6.027482354457653457302513,0.00069},
	{0,0,0,0,1,0,0,0,2,0,0,6.043529260666338664975683,0.02848},
	{0,0,0,0,1,0,0,0,2,0,2,3.036392583859984561911460,0.00004},
	{0,0,0,0,1,0,0,0,2,1,-2,2.853449615126891991678804,0.00007},
	{0,0,0,0,1,0,0,0,2,1,0,5.898334272995380267445853,0.00255},
	{0,0,0,0,1,0,0,0,2,1,2,3.002651704227504936284276,0.00001},
	{0,0,0,0,1,0,0,0,2,2,0,5.777294991237871712996821,0.00020},
	{0,0,0,0,1,0,0,0,2,3,0,6.216325583260037923594155,0.00002},
	{0,0,0,0,1,0,0,0,3,-1,-1,6.260667592769131317709252,0.00001},
	{0,0,0,0,1,0,0,0,3,-1,0,2.705791618815517995955133,0.00004},
	{0,0,0,0,1,0,0,0,3,0,-1,3.113864258697509157514105,0.00002},
	{0,0,0,0,1,0,0,0,3,0,0,0.390104126166859022095679,0.00002},
	{0,0,0,0,1,0,0,0,4,-3,0,6.115584480703224024011888,0.00003},
	{0,0,0,0,1,0,0,0,4,-2,0,6.205538575818087210222984,0.00070},
	{0,0,0,0,1,0,0,0,4,-1,-2,6.086600670479980657034957,0.00002},
	{0,0,0,0,1,0,0,0,4,-1,0,6.070922028743464871070046,0.00089},
	{0,0,0,0,1,0,0,0,4,0,-2,6.056832334757965341509589,0.00001},
	{0,0,0,0,1,0,0,0,4,0,0,5.983808980584998771234950,0.00034},
	{0,0,0,0,1,0,0,0,4,1,0,6.217314835880069168183581,0.00006},
	{0,0,0,0,1,0,0,0,4,2,0,2.908628373961617885612441,0.00001},
	{0,0,0,0,1,0,0,0,6,-2,0,6.127823078484059493575842,0.00002},
	{0,0,0,0,1,0,0,0,6,-1,0,5.999962002812206485202751,0.00001},
	{0,0,0,0,1,1,0,0,0,0,0,4.757576427383448880448213,0.00002},
	{0,0,0,0,1,2,0,0,0,0,0,1.650461705969252568237948,0.00004},
	{0,0,0,0,1,3,0,0,0,0,0,0.647663934679988950726681,0.00002},
	{0,0,0,0,2,-7,0,0,0,-1,0,0.027632925382200222014228,0.00001},
	{0,0,0,0,2,-7,0,0,0,0,0,6.200371354034632354057521,0.00008},
	{0,0,0,0,2,-7,0,0,0,1,0,0.027632925382200222014228,0.00001},
	{0,0,0,0,2,-6,0,0,-2,0,0,1.765975449847871248110209,0.00003},
	{0,0,0,0,2,-6,0,0,-2,1,0,1.765975100782020801304384,0.00004},
	{0,0,0,0,2,-6,0,0,0,-1,0,1.893918905060417934294037,0.00004},
	{0,0,0,0,2,-6,0,0,0,0,0,1.921137663811119944412553,0.00004},
	{0,0,0,0,2,-6,0,0,0,1,0,1.893918905060417934294037,0.00004},
	{0,0,0,0,2,-6,0,0,2,-1,0,1.752351584239728810032943,0.00004},
	{0,0,0,0,2,-6,0,0,2,0,0,1.752351584239728810032943,0.00003},
	{0,0,0,0,2,-6,3,0,-2,0,0,0.263409104968263807489137,0.00003},
	{0,0,0,0,2,-6,3,0,-2,1,0,2.989477086368825808904148,0.00008},
	{0,0,0,0,2,-6,3,0,-2,2,0,3.145395726029888372465848,0.00001},
	{0,0,0,0,2,-6,3,0,0,-2,0,0.000766374074550710011194,0.00004},
	{0,0,0,0,2,-6,3,0,0,-1,0,6.280528217926350187383377,0.00064},
	{0,0,0,0,2,-6,3,0,0,0,0,6.256493463330061288729667,0.00146},
	{0,0,0,0,2,-6,3,0,0,1,0,6.280528217926350187383377,0.00064},
	{0,0,0,0,2,-6,3,0,0,2,0,0.000766374074550710011194,0.00004},
	{0,0,0,0,2,-6,3,0,2,-2,0,3.145396424161589710166709,0.00001},
	{0,0,0,0,2,-6,3,0,2,-1,0,2.987889360348286782453897,0.00008},
	{0,0,0,0,2,-6,3,0,2,0,0,0.259623311287762892352049,0.00004},
	{0,0,0,0,2,-6,4,-2,0,0,0,0.007173128692771495520941,0.00001},
	{0,0,0,0,2,-5,0,0,-4,0,0,4.469344028062844920157204,0.00002},
	{0,0,0,0,2,-5,0,0,-4,1,0,3.318491198057379243380183,0.00012},
	{0,0,0,0,2,-5,0,0,-4,2,0,3.089680976581875349040729,0.00018},
	{0,0,0,0,2,-5,0,0,-2,-2,0,5.781375047430259428438148,0.00008},
	{0,0,0,0,2,-5,0,0,-2,-1,0,5.840680986347176251172186,0.00060},
	{0,0,0,0,2,-5,0,0,-2,-1,2,2.896565007237683175844722,0.00002},
	{0,0,0,0,2,-5,0,0,-2,0,0,4.530855539555507682791813,0.00155},
	{0,0,0,0,2,-5,0,0,-2,0,2,4.898776007330742920942157,0.00003},
	{0,0,0,0,2,-5,0,0,-2,1,-2,6.013392311406302148668601,0.00001},
	{0,0,0,0,2,-5,0,0,-2,1,0,3.119124681063019988158658,0.01400},
	{0,0,0,0,2,-5,0,0,-2,2,0,3.022466252692471488927595,0.00131},
	{0,0,0,0,2,-5,0,0,-2,3,0,2.967256252464134824720077,0.00011},
	{0,0,0,0,2,-5,0,0,-2,4,0,2.910942331483911793554853,0.00001},
	{0,0,0,0,2,-5,0,0,-1,-1,0,2.896565007237683175844722,0.00002},
	{0,0,0,0,2,-5,0,0,-1,0,0,1.086489799580895754260723,0.00005},
	{0,0,0,0,2,-5,0,0,-1,1,0,6.168584370499760716199944,0.00006},
	{0,0,0,0,2,-5,0,0,0,-4,0,6.038157660827477180021106,0.00002},
	{0,0,0,0,2,-5,0,0,0,-3,0,6.050211253707599823314922,0.00033},
	{0,0,0,0,2,-5,0,0,0,-2,-2,2.896565007237683175844722,0.00002},
	{0,0,0,0,2,-5,0,0,0,-2,0,6.046867028327853610392140,0.00463},
	{0,0,0,0,2,-5,0,0,0,-1,-2,2.902602799252032461652107,0.00013},
	{0,0,0,0,2,-5,0,0,0,-1,0,6.047339663489292860276691,0.06826},
	{0,0,0,0,2,-5,0,0,0,-1,2,6.040039300294051116679839,0.00012},
	{0,0,0,0,2,-5,0,0,0,0,-2,5.975796523054943243380421,0.00004},
	{0,0,0,0,2,-5,0,0,0,0,0,6.069670976735635825605186,0.16376},
	{0,0,0,0,2,-5,0,0,0,0,2,5.975796523054943243380421,0.00004},
	{0,0,0,0,2,-5,0,0,0,1,-2,6.040039300294051116679839,0.00012},
	{0,0,0,0,2,-5,0,0,0,1,0,6.047386438313246515008359,0.06826},
	{0,0,0,0,2,-5,0,0,0,1,2,2.902602799252032461652107,0.00013},
	{0,0,0,0,2,-5,0,0,0,2,0,6.046901236781192956470932,0.00463},
	{0,0,0,0,2,-5,0,0,0,2,2,2.896565007237683175844722,0.00002},
	{0,0,0,0,2,-5,0,0,0,3,0,6.050230452329371289010851,0.00033},
	{0,0,0,0,2,-5,0,0,0,4,0,6.038157660827477180021106,0.00002},
	{0,0,0,0,2,-5,0,0,1,-1,0,6.167473817496716748109975,0.00006},
	{0,0,0,0,2,-5,0,0,1,0,0,1.261244207062406808006472,0.00005},
	{0,0,0,0,2,-5,0,0,1,1,0,2.896565007237683175844722,0.00002},
	{0,0,0,0,2,-5,0,0,2,-4,0,2.911453712954746197993927,0.00001},
	{0,0,0,0,2,-5,0,0,2,-3,0,2.966637533244302904478218,0.00012},
	{0,0,0,0,2,-5,0,0,2,-2,0,3.021782083625689452333063,0.00132},
	{0,0,0,0,2,-5,0,0,2,-1,0,3.117307095179993048361666,0.01408},
	{0,0,0,0,2,-5,0,0,2,-1,2,6.013392311406302148668601,0.00001},
	{0,0,0,0,2,-5,0,0,2,0,-2,4.855320276015812730463495,0.00003},
	{0,0,0,0,2,-5,0,0,2,0,0,4.459902669474182346220914,0.00155},
	{0,0,0,0,2,-5,0,0,2,1,-2,2.896565007237683175844722,0.00002},
	{0,0,0,0,2,-5,0,0,2,1,0,5.839516502670246467232573,0.00059},
	{0,0,0,0,2,-5,0,0,2,2,0,5.770523986404760385937607,0.00008},
	{0,0,0,0,2,-5,0,0,4,-2,0,3.093062552007614041116312,0.00018},
	{0,0,0,0,2,-5,0,0,4,-1,0,3.313639706335610668475056,0.00013},
	{0,0,0,0,2,-5,0,0,4,0,0,4.422942355503473699229744,0.00002},
	{0,0,0,0,2,-4,0,0,-2,-1,0,4.377032865793164084777800,0.00001},
	{0,0,0,0,2,-4,0,0,-2,0,0,4.377032691260239971597912,0.00011},
	{0,0,0,0,2,-4,0,0,-2,1,0,4.365794516206648268052959,0.00020},
	{0,0,0,0,2,-4,0,0,0,-1,0,4.584972440073319610576164,0.00005},
	{0,0,0,0,2,-4,0,0,0,0,0,5.504037865965230480469472,0.00006},
	{0,0,0,0,2,-4,0,0,0,1,0,4.590907781260577635862319,0.00005},
	{0,0,0,0,2,-4,0,0,2,-1,0,4.370405850623342303151730,0.00020},
	{0,0,0,0,2,-4,0,0,2,0,0,4.381337545860283455567696,0.00010},
	{0,0,0,0,2,-4,0,0,2,1,0,4.381337545860283455567696,0.00001},
	{0,0,0,0,2,-3,0,0,-2,-1,0,5.243043598550025663485030,0.00002},
	{0,0,0,0,2,-3,0,0,-2,0,0,5.243043598550025663485030,0.00013},
	{0,0,0,0,2,-3,0,0,-2,1,0,5.242011934429172903548988,0.00022},
	{0,0,0,0,2,-3,0,0,0,-2,0,5.248544527286461480741764,0.00001},
	{0,0,0,0,2,-3,0,0,0,-1,0,5.250739104287919900571069,0.00021},
	{0,0,0,0,2,-3,0,0,0,0,0,5.270800965907893598227929,0.00028},
	{0,0,0,0,2,-3,0,0,0,1,0,5.250691980398115354944366,0.00021},
	{0,0,0,0,2,-3,0,0,0,2,0,5.248543131023060581696882,0.00001},
	{0,0,0,0,2,-3,0,0,2,-1,0,5.241149392712837418173422,0.00020},
	{0,0,0,0,2,-3,0,0,2,0,0,5.242446346879993335221570,0.00012},
	{0,0,0,0,2,-3,0,0,2,1,0,5.242443903419040651670002,0.00001},
	{0,0,0,0,2,-2,0,0,-4,1,0,6.268902579778816708255818,0.00001},
	{0,0,0,0,2,-2,0,0,-2,-1,0,6.268821072902747815192015,0.00005},
	{0,0,0,0,2,-2,0,0,-2,0,0,6.268789482443287042201518,0.00029},
	{0,0,0,0,2,-2,0,0,-2,1,0,6.272564804148275108275357,0.00054},
	{0,0,0,0,2,-2,0,0,-2,2,0,6.268902579778816708255818,0.00002},
	{0,0,0,0,2,-2,0,0,0,-2,0,6.227113463366615420113703,0.00002},
	{0,0,0,0,2,-2,0,0,0,-1,0,6.225878119322053372286518,0.00022},
	{0,0,0,0,2,-2,0,0,0,0,0,6.229836526065575696975429,0.00034},
	{0,0,0,0,2,-2,0,0,0,1,0,6.215350642339873665775940,0.00020},
	{0,0,0,0,2,-2,0,0,0,2,0,6.227947730749068711020300,0.00002},
	{0,0,0,0,2,-2,0,0,2,-2,0,6.259691255585565272667736,0.00002},
	{0,0,0,0,2,-2,0,0,2,-1,0,6.262342410719345053848883,0.00049},
	{0,0,0,0,2,-2,0,0,2,0,0,6.259569257070851655555543,0.00026},
	{0,0,0,0,2,-2,0,0,2,1,0,6.259690557453864379056085,0.00004},
	{0,0,0,0,2,-1,0,0,-2,0,0,2.885704695967148403212832,0.00002},
	{0,0,0,0,2,-1,0,0,0,0,0,6.197982870953278933257025,0.00007},
	{0,0,0,0,2,-1,0,0,2,0,0,2.797573073657218412080283,0.00002},
	{0,0,0,0,2,0,0,0,-4,1,0,2.345483753638706314603724,0.00004},
	{0,0,0,0,2,0,0,0,-4,2,0,2.094206955899830635559056,0.00002},
	{0,0,0,0,2,0,0,0,-2,-1,0,0.197754181831367115140807,0.00008},
	{0,0,0,0,2,0,0,0,-2,0,0,0.314756342496086582993797,0.00065},
	{0,0,0,0,2,0,0,0,-2,0,2,0.384244881334988797050300,0.00002},
	{0,0,0,0,2,0,0,0,-2,1,-1,2.319366472178937321757530,0.00003},
	{0,0,0,0,2,0,0,0,-2,1,0,0.607075604793160139571739,0.00099},
	{0,0,0,0,2,0,0,0,-2,2,-1,2.301430945186668353130699,0.00002},
	{0,0,0,0,2,0,0,0,-2,2,0,1.008687908448893999491247,0.00005},
	{0,0,0,0,2,0,0,0,-1,0,0,2.460277200135026820504436,0.00008},
	{0,0,0,0,2,0,0,0,-1,0,1,0.804728208462061056494008,0.00005},
	{0,0,0,0,2,0,0,0,-1,1,-1,5.873712913237495669704913,0.00003},
	{0,0,0,0,2,0,0,0,0,-3,0,5.569020139208408437525577,0.00002},
	{0,0,0,0,2,0,0,0,0,-2,0,5.541746577119194050453643,0.00028},
	{0,0,0,0,2,0,0,0,0,-1,-1,2.326780456308484179572815,0.00002},
	{0,0,0,0,2,0,0,0,0,-1,0,5.560589151723725365172868,0.00426},
	{0,0,0,0,2,0,0,0,0,0,-1,2.324275210700171623301458,0.00035},
	{0,0,0,0,2,0,0,0,0,0,0,5.518330192676886625235966,0.00817},
	{0,0,0,0,2,0,0,0,0,1,-1,2.319366472178937321757530,0.00228},
	{0,0,0,0,2,0,0,0,0,1,0,5.547396033374974777530042,0.00425},
	{0,0,0,0,2,0,0,0,0,2,-1,2.333032225689128047463328,0.00014},
	{0,0,0,0,2,0,0,0,0,2,0,5.516858705584530397914023,0.00030},
	{0,0,0,0,2,0,0,0,0,3,-1,2.326780456308484179572815,0.00002},
	{0,0,0,0,2,0,0,0,0,3,0,5.588701169985596628464464,0.00002},
	{0,0,0,0,2,0,0,0,1,0,-1,1.903355551260100808619313,0.00009},
	{0,0,0,0,2,0,0,0,1,0,0,2.688223658163718443603329,0.00003},
	{0,0,0,0,2,0,0,0,2,-3,0,4.313635351510797022456245,0.00001},
	{0,0,0,0,2,0,0,0,2,-2,0,1.409084939346464393494784,0.00005},
	{0,0,0,0,2,0,0,0,2,-1,0,6.170878431268581820745567,0.00124},
	{0,0,0,0,2,0,0,0,2,0,-2,5.840365430818415859448578,0.00004},
	{0,0,0,0,2,0,0,0,2,0,-1,5.477647265944599830334028,0.00002},
	{0,0,0,0,2,0,0,0,2,0,0,5.827537435349182892707631,0.00127},
	{0,0,0,0,2,0,0,0,2,1,-1,2.319366472178937321757530,0.00003},
	{0,0,0,0,2,0,0,0,2,1,0,5.766434505434412827185042,0.00014},
	{0,0,0,0,2,0,0,0,4,-2,0,0.155588248833660514058863,0.00001},
	{0,0,0,0,2,0,0,0,4,-1,0,5.604896429180703520955831,0.00002},
	{0,0,0,0,2,0,0,0,4,0,0,6.119017892407748071548212,0.00001},
	{0,0,0,0,2,5,0,0,2,-3,0,2.090705476354479674938602,0.00002},
	{0,0,0,0,2,5,0,0,2,-2,0,2.090705476354479674938602,0.00002},
	{0,0,0,0,2,5,0,0,2,-1,0,2.090705476354479674938602,0.00002},
	{0,0,0,0,2,5,0,0,2,0,0,2.090705476354479674938602,0.00002},
	{0,0,0,0,3,-7,0,0,0,0,0,0.982024862532027142947300,0.00005},
	{0,0,0,0,3,-6,0,0,0,0,0,0.429903043633010906177105,0.00002},
	{0,0,0,0,3,-5,0,0,-2,-1,0,1.475907138687094777296238,0.00004},
	{0,0,0,0,3,-5,0,0,-2,0,0,1.461029428544319497262904,0.00021},
	{0,0,0,0,3,-5,0,0,-2,1,0,1.474669002115730265245475,0.00038},
	{0,0,0,0,3,-5,0,0,0,-2,0,1.547146242765747414793509,0.00002},
	{0,0,0,0,3,-5,0,0,0,-1,0,1.538100550318511228198304,0.00028},
	{0,0,0,0,3,-5,0,0,0,0,0,1.504980484300965981603326,0.00051},
	{0,0,0,0,3,-5,0,0,0,1,0,1.537811523794381018959143,0.00028},
	{0,0,0,0,3,-5,0,0,0,2,0,1.528327753704894265140979,0.00002},
	{0,0,0,0,3,-5,0,0,2,-2,0,1.480075159473782431263089,0.00002},
	{0,0,0,0,3,-5,0,0,2,-1,0,1.471567552034936277038923,0.00038},
	{0,0,0,0,3,-5,0,0,2,0,0,1.480066607360447816787996,0.00021},
	{0,0,0,0,3,-5,0,0,2,1,0,1.480075857605483324874740,0.00003},
	{0,0,0,0,3,-4,0,0,-2,0,0,2.110731384191862680665963,0.00003},
	{0,0,0,0,3,-4,0,0,-2,1,0,2.110704855187231832047701,0.00005},
	{0,0,0,0,3,-4,0,0,0,-1,0,2.142257441003561080350437,0.00002},
	{0,0,0,0,3,-4,0,0,0,0,0,2.826636121828502989927756,0.00002},
	{0,0,0,0,3,-4,0,0,0,1,0,2.142257441003561080350437,0.00002},
	{0,0,0,0,3,-4,0,0,2,-1,0,2.103185453170864693817066,0.00004},
	{0,0,0,0,3,-4,0,0,2,0,0,2.103185453170864693817066,0.00003},
	{0,0,0,0,3,-3,0,0,-2,0,0,5.970316014670756565863030,0.00004},
	{0,0,0,0,3,-3,0,0,-2,1,0,5.970316014670756565863030,0.00006},
	{0,0,0,0,3,-3,0,0,0,-1,0,6.114595926214894561212532,0.00002},
	{0,0,0,0,3,-3,0,0,0,0,0,1.218052718596228212177834,0.00004},
	{0,0,0,0,3,-3,0,0,0,1,0,6.114595926214894561212532,0.00002},
	{0,0,0,0,3,-3,0,0,2,-1,0,5.887783932199999625822784,0.00004},
	{0,0,0,0,3,-3,0,0,2,0,0,5.887784281265849628539399,0.00003},
	{0,0,0,0,3,-2,0,0,-2,0,0,6.227518728818927762347357,0.00003},
	{0,0,0,0,3,-2,0,0,-2,1,0,6.227518728818927762347357,0.00004},
	{0,0,0,0,3,-2,0,0,0,-1,0,5.860843378932065306230470,0.00004},
	{0,0,0,0,3,-2,0,0,0,0,0,5.797791788907443510936446,0.00009},
	{0,0,0,0,3,-2,0,0,0,1,0,5.860843378932065306230470,0.00004},
	{0,0,0,0,3,-2,0,0,2,-1,0,6.047867974653872380486064,0.00004},
	{0,0,0,0,3,-2,0,0,2,0,0,6.072818678041607576290062,0.00002},
	{0,0,0,0,3,0,0,0,-4,2,0,5.658285876466284669561446,0.00002},
	{0,0,0,0,3,0,0,0,-2,0,0,1.930221229903124502413903,0.00010},
	{0,0,0,0,3,0,0,0,-2,1,0,1.533591666728909119754576,0.00008},
	{0,0,0,0,3,0,0,0,-1,1,-1,5.696638439581309221182437,0.00002},
	{0,0,0,0,3,0,0,0,0,-2,0,5.486456640811116614031562,0.00002},
	{0,0,0,0,3,0,0,0,0,-1,0,5.472218419306271286473020,0.00032},
	{0,0,0,0,3,0,0,0,0,0,0,5.414346268369868653280719,0.00052},
	{0,0,0,0,3,0,0,0,0,1,0,5.513405746192384881965154,0.00036},
	{0,0,0,0,3,0,0,0,0,2,0,5.482493521678612147240983,0.00002},
	{0,0,0,0,3,0,0,0,1,0,-1,2.010630642937605738751472,0.00001},
	{0,0,0,0,3,0,0,0,2,-1,0,0.033030879692768286282067,0.00004},
	{0,0,0,0,3,0,0,0,2,0,0,5.679610134734225823649467,0.00005},
	{0,0,0,0,4,-11,3,0,0,0,0,0.835499235839347043075520,0.00005},
	{0,0,0,0,4,-10,0,0,-2,0,0,0.684057714775500036452627,0.00002},
	{0,0,0,0,4,-10,0,0,-2,1,0,0.233304793365239626634633,0.00007},
	{0,0,0,0,4,-10,0,0,0,-2,0,3.096110071414521769384010,0.00002},
	{0,0,0,0,4,-10,0,0,0,-1,0,3.115803668562325157154191,0.00027},
	{0,0,0,0,4,-10,0,0,0,0,0,3.223433585676760415594799,0.00075},
	{0,0,0,0,4,-10,0,0,0,1,0,3.115803668562325157154191,0.00027},
	{0,0,0,0,4,-10,0,0,0,2,0,3.096110071414521769384010,0.00002},
	{0,0,0,0,4,-10,0,0,2,-1,0,0.228964857647230513038039,0.00007},
	{0,0,0,0,4,-10,0,0,2,0,0,0.661503348450752870490987,0.00002},
	{0,0,0,0,4,-9,0,0,0,0,0,4.598768744211559678092271,0.00002},
	{0,0,0,0,4,-8,0,0,0,0,0,5.428600372370905979835243,0.00003},
	{0,0,0,0,4,-7,0,0,0,0,0,3.286907719913290115698601,0.00003},
	{0,0,0,0,4,-6,0,0,0,0,0,0.955035440045037042899878,0.00002},
	{0,0,0,0,4,-5,0,0,-2,0,0,1.303231069278858678117672,0.00002},
	{0,0,0,0,4,-5,0,0,-2,1,0,1.303231069278858678117672,0.00003},
	{0,0,0,0,4,-5,0,0,0,-1,0,1.670036446194995027880736,0.00002},
	{0,0,0,0,4,-5,0,0,0,0,0,4.329940915514629118376888,0.00005},
	{0,0,0,0,4,-5,0,0,0,1,-1,6.025711717931505617684707,0.00007},
	{0,0,0,0,4,-5,0,0,0,1,0,1.670036446194995027880736,0.00002},
	{0,0,0,0,4,-5,0,0,2,-1,0,1.419665474337904464974258,0.00003},
	{0,0,0,0,4,-5,0,0,2,0,0,1.419828488090040474745024,0.00002},
	{0,0,0,0,4,-4,0,0,0,0,0,0.046401672559371644199988,0.00003},
	{0,0,0,0,4,-3,0,0,0,0,0,0.244517312078826765109341,0.00001},
	{0,0,0,0,4,0,0,0,-2,0,0,1.989731197809599727577279,0.00001},
	{0,0,0,0,4,0,0,0,0,-1,0,5.344736429147951994877985,0.00001},
	{0,0,0,0,4,0,0,0,0,0,0,5.245340277312725341118949,0.00002},
	{0,0,0,0,4,0,0,0,0,1,0,5.344736429147951994877985,0.00001},
	{0,0,0,0,4,0,0,0,0,2,-2,2.053117018385978376215917,0.00002},
	{0,0,0,0,6,-5,0,0,2,-3,0,5.585435309889265731442265,0.00002},
	{0,0,0,0,6,-5,0,0,2,-2,0,5.585435309889265731442265,0.00002},
	{0,0,0,0,6,-5,0,0,2,-1,0,5.585435309889265731442265,0.00002},
	{0,0,0,0,6,-5,0,0,2,0,0,5.585435309889265731442265,0.00002},
	{0,0,0,1,-2,0,0,0,-2,0,0,2.620682034105416224889495,0.00002},
	{0,0,0,1,-2,0,0,0,-2,1,0,5.763466747574321757952021,0.00003},
	{0,0,0,1,-1,0,0,0,-2,0,0,6.233676250419963871252094,0.00001},
	{0,0,0,1,-1,0,0,0,0,-1,0,3.062237419423516904259941,0.00001},
	{0,0,0,1,-1,0,0,0,0,1,0,3.062237419423516904259941,0.00001},
	{0,0,0,1,0,-1,0,0,0,0,0,2.998360637728551658653942,0.00001},
	{0,0,0,1,0,0,0,0,-4,0,0,0.687865499604575991732247,0.00001},
	{0,0,0,1,0,0,0,0,-4,2,0,0.679122621782560775827164,0.00001},
	{0,0,0,1,0,0,0,0,-2,-1,0,0.682094044834081203454446,0.00008},
	{0,0,0,1,0,0,0,0,-2,0,0,0.713875268782421468216626,0.00088},
	{0,0,0,1,0,0,0,0,-2,0,2,0.673247668987422609454541,0.00002},
	{0,0,0,1,0,0,0,0,-2,1,0,0.684266281621113248156973,0.00130},
	{0,0,0,1,0,0,0,0,-2,2,0,0.678362705426242440509554,0.00008},
	{0,0,0,1,0,0,0,0,-1,-1,1,2.246386576704346271782242,0.00002},
	{0,0,0,1,0,0,0,0,-1,0,-1,5.382148783394927527012896,0.00001},
	{0,0,0,1,0,0,0,0,-1,0,1,2.239832865363107217149263,0.00008},
	{0,0,0,1,0,0,0,0,-1,2,-1,5.382148783394927527012896,0.00001},
	{0,0,0,1,0,0,0,0,0,-1,0,0.351182585715684614235954,0.00009},
	{0,0,0,1,0,0,0,0,0,0,0,3.609854543523135284033287,0.00165},
	{0,0,0,1,0,0,0,0,0,1,0,6.055114407175227420054853,0.00005},
	{0,0,0,1,0,0,0,0,0,2,0,0.174073729073233235409290,0.00001},
	{0,0,0,1,0,0,0,0,1,-2,1,5.388856956374967310807733,0.00001},
	{0,0,0,1,0,0,0,0,1,-1,-1,2.245990212431217880606482,0.00003},
	{0,0,0,1,0,0,0,0,1,-1,1,5.387979230294138943690996,0.00012},
	{0,0,0,1,0,0,0,0,1,0,-1,2.248076928084902448290450,0.00023},
	{0,0,0,1,0,0,0,0,1,0,0,0.518781143264018917982128,0.00004},
	{0,0,0,1,0,0,0,0,1,0,1,5.389103920464124897193869,0.00005},
	{0,0,0,1,0,0,0,0,1,1,-1,2.245990212431217880606482,0.00003},
	{0,0,0,1,0,0,0,0,2,-2,0,0.597845081978137571354637,0.00006},
	{0,0,0,1,0,0,0,0,2,-1,0,0.529421019450026730801540,0.00087},
	{0,0,0,1,0,0,0,0,2,0,-2,0.461092426431999935498851,0.00001},
	{0,0,0,1,0,0,0,0,2,0,0,0.463400973433612861640540,0.00033},
	{0,0,0,1,0,0,0,0,2,1,0,0.532724404125276440602477,0.00004},
	{0,0,0,1,0,0,0,0,4,-1,0,0.502218666794293611133071,0.00001},
	{0,0,0,2,-3,0,0,0,0,0,0,0.230501969119461913582114,0.00001},
	{0,0,0,2,-2,0,0,0,-2,0,0,0.082809240755973359537911,0.00001},
	{0,0,0,2,-2,0,0,0,0,0,0,0.002903878809468165601848,0.00005},
	{0,0,0,2,-1,0,0,0,-2,0,0,0.454420556300401234928188,0.00001},
	{0,0,0,2,0,-2,0,0,-2,0,0,0.473808371763255020692185,0.00003},
	{0,0,0,2,0,-2,0,0,-2,1,0,0.473808371763255020692185,0.00004},
	{0,0,0,2,0,-2,0,0,0,-1,0,0.411719505354033177280115,0.00001},
	{0,0,0,2,0,-2,0,0,0,0,0,0.276167112734491959624705,0.00007},
	{0,0,0,2,0,-2,0,0,0,1,0,0.411719505354033177280115,0.00001},
	{0,0,0,2,0,0,0,0,-4,-1,0,5.401840460680553235306434,0.00001},
	{0,0,0,2,0,0,0,0,-4,0,0,2.180042772111687288116855,0.00005},
	{0,0,0,2,0,0,0,0,-4,1,0,2.190395018036966234831198,0.00009},
	{0,0,0,2,0,0,0,0,-4,2,0,2.261653844336166674366950,0.00004},
	{0,0,0,2,0,0,0,0,-3,2,-1,6.000360286947511667676736,0.00001},
	{0,0,0,2,0,0,0,0,-2,-2,0,2.363019600232268757622478,0.00002},
	{0,0,0,2,0,0,0,0,-2,-1,0,2.259171637073980054566391,0.00024},
	{0,0,0,2,0,0,0,0,-2,0,0,2.320181366406693701520680,0.00224},
	{0,0,0,2,0,0,0,0,-2,0,2,2.334722751602609669419053,0.00003},
	{0,0,0,2,0,0,0,0,-2,1,0,2.355808597894728961819055,0.00218},
	{0,0,0,2,0,0,0,0,-2,2,0,2.389488391003388834121779,0.00007},
	{0,0,0,2,0,0,0,0,-1,-2,-1,2.857836151135928925981489,0.00002},
	{0,0,0,2,0,0,0,0,-1,-1,-1,2.857768257828026126077248,0.00015},
	{0,0,0,2,0,0,0,0,-1,-1,1,2.858007367935549769555337,0.00003},
	{0,0,0,2,0,0,0,0,-1,0,-1,2.857310807031078869755447,0.00081},
	{0,0,0,2,0,0,0,0,-1,0,1,6.008737692824158926896416,0.00027},
	{0,0,0,2,0,0,0,0,-1,1,-1,6.000403396580035852991841,0.00076},
	{0,0,0,2,0,0,0,0,-1,2,-1,5.999753785032442721103507,0.00014},
	{0,0,0,2,0,0,0,0,-1,3,-1,5.999757275690947189161761,0.00001},
	{0,0,0,2,0,0,0,0,0,-2,0,2.581474608722765129442678,0.00010},
	{0,0,0,2,0,0,0,0,0,-1,0,2.754491715466841128545639,0.00103},
	{0,0,0,2,0,0,0,0,0,0,-1,5.999080437007024535489563,0.00002},
	{0,0,0,2,0,0,0,0,0,0,0,3.200111274481135303915380,0.00321},
	{0,0,0,2,0,0,0,0,0,1,0,3.675106993734522209393845,0.00043},
	{0,0,0,2,0,0,0,0,0,2,0,4.577258957444130693659190,0.00004},
	{0,0,0,2,0,0,0,0,1,-3,-1,2.857947852208056360723276,0.00005},
	{0,0,0,2,0,0,0,0,1,-2,-1,2.857947852208056360723276,0.00074},
	{0,0,0,2,0,0,0,0,1,-1,-3,5.999935997406351972927041,0.00003},
	{0,0,0,2,0,0,0,0,1,-1,-1,2.857921846802201848447567,0.01093},
	{0,0,0,2,0,0,0,0,1,-1,1,5.995932561168126895267960,0.00020},
	{0,0,0,2,0,0,0,0,1,0,-3,6.000890168908417088289298,0.00008},
	{0,0,0,2,0,0,0,0,1,0,-1,2.857487783417230975402390,0.06369},
	{0,0,0,2,0,0,0,0,1,0,0,0.812864235303157878220759,0.00002},
	{0,0,0,2,0,0,0,0,1,0,1,5.999682750131888120392887,0.00172},
	{0,0,0,2,0,0,0,0,1,1,-3,2.857199804090651884536101,0.00002},
	{0,0,0,2,0,0,0,0,1,1,-1,2.857973857613911761177405,0.01090},
	{0,0,0,2,0,0,0,0,1,1,1,5.999560228018397722848931,0.00021},
	{0,0,0,2,0,0,0,0,1,2,-1,2.857947852208056360723276,0.00074},
	{0,0,0,2,0,0,0,0,1,3,-1,2.857947852208056360723276,0.00005},
	{0,0,0,2,0,0,0,0,2,-2,0,0.329750640632895053450113,0.00002},
	{0,0,0,2,0,0,0,0,2,-1,0,5.590130245577130452261372,0.00009},
	{0,0,0,2,0,0,0,0,2,0,-2,4.911554435449219546683253,0.00001},
	{0,0,0,2,0,0,0,0,2,0,-1,5.999080437007024535489563,0.00002},
	{0,0,0,2,0,0,0,0,2,0,0,4.886135460223174575844496,0.00019},
	{0,0,0,2,0,0,0,0,2,1,0,5.381012050453103157110490,0.00003},
	{0,0,0,2,0,0,0,0,3,-3,-1,5.999757275690947189161761,0.00001},
	{0,0,0,2,0,0,0,0,3,-2,-1,5.999757275690947189161761,0.00014},
	{0,0,0,2,0,0,0,0,3,-1,-1,6.000321191572266954494808,0.00083},
	{0,0,0,2,0,0,0,0,3,-1,1,5.999600719657043335075741,0.00004},
	{0,0,0,2,0,0,0,0,3,0,-1,2.857446593646884025474719,0.00067},
	{0,0,0,2,0,0,0,0,3,0,1,5.999601243255819227329084,0.00002},
	{0,0,0,2,0,0,0,0,3,1,-1,2.857768257828026126077248,0.00015},
	{0,0,0,2,0,0,0,0,3,2,-1,2.857836151135928925981489,0.00002},
	{0,0,0,2,0,0,0,0,5,-2,-1,6.000360286947511667676736,0.00001},
	{0,0,0,3,-2,0,0,0,-2,0,0,3.629563674101281112172046,0.00001},
	{0,0,0,3,-2,0,0,0,2,-1,0,0.542959887523597140024378,0.00003},
	{0,0,0,3,0,0,0,0,-2,0,0,5.689935328056098917670624,0.00003},
	{0,0,0,3,0,0,0,0,-2,1,0,5.688741871913586045650391,0.00003},
	{0,0,0,3,0,0,0,0,0,-1,0,4.879542129907915359865456,0.00003},
	{0,0,0,3,0,0,0,0,0,0,0,4.682050096530197436095477,0.00016},
	{0,0,0,3,0,0,0,0,0,1,0,5.120642610910112857425247,0.00001},
	{0,0,0,3,0,0,0,0,1,0,-1,0.043964145726036359118627,0.00002},
	{0,0,0,3,0,0,0,0,2,-3,0,2.558431550207459714840752,0.00001},
	{0,0,0,3,0,0,0,0,2,-2,0,1.316326100123646813955247,0.00001},
	{0,0,0,3,0,0,0,0,2,-1,0,1.578170168351647362214862,0.00011},
	{0,0,0,3,1,0,0,0,2,-3,0,1.836506997447765465736325,0.00001},
	{0,0,0,3,1,0,0,0,2,-1,0,4.978099651037559247868103,0.00001},
	{0,0,0,4,-2,0,0,0,2,-1,0,4.132112382657126659069036,0.00002},
	{0,0,0,4,-1,0,0,0,0,0,0,4.479735543896294025500993,0.00001},
	{0,0,0,4,0,0,0,0,-2,0,0,0.646059278965705363617644,0.00005},
	{0,0,0,4,0,0,0,0,-2,1,0,0.653282847673859468073942,0.00005},
	{0,0,0,4,0,0,0,0,0,0,0,6.105191917672224910518253,0.00002},
	{0,0,0,4,0,0,0,0,2,0,-2,2.481637237652634109252858,0.00001},
	{0,0,1,-8,3,0,0,0,-3,1,2,4.111811236396704316575779,0.00001},
	{0,0,1,-8,3,0,0,0,2,-1,0,4.112647074575484396063985,0.00001},
	{0,0,1,-8,3,0,0,0,2,0,0,4.112688613411682680975900,0.00003},
	{0,0,1,-7,2,0,0,0,-2,0,0,0.903513669592014956322146,0.00001},
	{0,0,1,-7,2,0,0,0,-2,2,0,0.903513669592014956322146,0.00001},
	{0,0,1,-6,0,0,0,0,2,0,0,2.092744369986659247473426,0.00002},
	{0,0,1,-6,1,0,0,0,-2,0,2,1.348199302923567266532245,0.00002},
	{0,0,1,-5,-2,0,0,0,-2,1,0,6.217124245925750969377077,0.00001},
	{0,0,1,-5,-2,0,0,0,-2,3,0,3.075531592335957409289904,0.00001},
	{0,0,1,-5,-1,0,0,0,-2,1,0,3.646697396835184346031156,0.00002},
	{0,0,1,-5,0,0,0,0,-2,1,0,1.425905375479634473734336,0.00004},
	{0,0,1,-5,0,0,0,0,0,0,0,4.311750919517418623172489,0.00004},
	{0,0,1,-5,2,0,0,0,-2,1,0,1.970745331673479983081165,0.00002},
	{0,0,1,-4,-1,0,0,0,-2,1,0,0.916405718644796252192464,0.00001},
	{0,0,1,-4,-1,0,0,0,-2,3,0,0.916405718644796252192464,0.00001},
	{0,0,1,-4,0,0,0,0,-2,0,0,3.927158717661283660049776,0.00003},
	{0,0,1,-4,0,0,0,0,-2,1,0,3.038041920003119233939515,0.00003},
	{0,0,1,-4,0,0,0,0,-2,2,0,0.835458220601925205528460,0.00001},
	{0,0,1,-4,0,0,0,0,-1,-1,1,6.024258033197519068835390,0.00006},
	{0,0,1,-4,0,0,0,0,-1,0,-1,2.892269053816824531111251,0.00003},
	{0,0,1,-4,0,0,0,0,-1,0,1,6.036532933826794788956249,0.00038},
	{0,0,1,-4,0,0,0,0,-1,1,1,6.024258033197519068835390,0.00006},
	{0,0,1,-4,0,0,0,0,0,-1,0,0.174047200068602941902540,0.00009},
	{0,0,1,-4,0,0,0,0,0,0,0,0.263756600022335863098277,0.00083},
	{0,0,1,-4,0,0,0,0,0,1,0,0.549714137195890018006139,0.00035},
	{0,0,1,-4,0,0,0,0,0,2,0,0.323493635264495371650639,0.00002},
	{0,0,1,-4,0,0,0,0,1,0,-1,2.929443345153827316096340,0.00001},
	{0,0,1,-4,0,0,0,0,2,-2,0,0.729172905143226635082954,0.00004},
	{0,0,1,-4,0,0,0,0,2,-1,0,0.729288969538484099786046,0.00085},
	{0,0,1,-4,0,0,0,0,2,0,-2,0.724326300343363427280963,0.00001},
	{0,0,1,-4,0,0,0,0,2,0,0,0.696115496445828041416348,0.00078},
	{0,0,1,-4,0,0,0,0,2,1,0,0.718193038818930262756624,0.00011},
	{0,0,1,-4,0,0,0,0,4,-1,0,0.761996963319633513478379,0.00002},
	{0,0,1,-4,0,0,0,0,4,0,0,0.753075712848064515725355,0.00002},
	{0,0,1,-4,0,2,0,0,-1,0,1,4.207321238119440920399938,0.00001},
	{0,0,1,-4,1,0,0,0,2,-2,0,4.840711870176619413541630,0.00001},
	{0,0,1,-4,1,0,0,0,2,0,0,4.840711870176619413541630,0.00001},
	{0,0,1,-4,2,0,0,0,0,0,0,2.141959164234395363024532,0.00004},
	{0,0,1,-4,2,0,0,0,2,-1,0,2.019801999090985233920037,0.00002},
	{0,0,1,-4,2,0,0,0,2,0,0,1.784776660149129723365036,0.00002},
	{0,0,1,-4,3,0,0,0,0,0,0,2.395175546371012487156804,0.00003},
	{0,0,1,-4,3,0,0,0,2,0,0,2.399238498336729641380316,0.00001},
	{0,0,1,-3,0,0,0,0,-2,-2,0,3.994417074781987153642149,0.00001},
	{0,0,1,-3,0,0,0,0,-2,0,0,4.126309337427170653711528,0.00005},
	{0,0,1,-3,0,0,0,0,-2,1,0,2.204523807397710921662792,0.00015},
	{0,0,1,-3,0,0,0,0,-2,2,0,0.149872295533379079612857,0.00001},
	{0,0,1,-3,0,0,0,0,-2,3,0,5.275871321917862566408530,0.00002},
	{0,0,1,-3,0,0,0,0,-1,0,-1,3.509536159711155178797526,0.00002},
	{0,0,1,-3,0,0,0,0,-1,0,0,2.136792116983865952306587,0.00002},
	{0,0,1,-3,0,0,0,0,-1,0,1,0.365897980238024445043266,0.00014},
	{0,0,1,-3,0,0,0,0,-1,1,-1,3.513079876224404429763126,0.00009},
	{0,0,1,-3,0,0,0,0,0,-1,0,4.887251074681048912395909,0.00028},
	{0,0,1,-3,0,0,0,0,0,0,0,5.270522236826350237492989,0.00159},
	{0,0,1,-3,0,0,0,0,0,1,0,5.125004537776696622586314,0.00022},
	{0,0,1,-3,0,0,0,0,1,0,-1,0.423687402567883508730517,0.00006},
	{0,0,1,-3,0,0,0,0,1,1,-1,0.371487222634611036209407,0.00002},
	{0,0,1,-3,0,0,0,0,2,-2,0,6.221654422532227002307081,0.00001},
	{0,0,1,-3,0,0,0,0,2,-1,0,1.419650115440487025963989,0.00045},
	{0,0,1,-3,0,0,0,0,2,0,0,1.306453121610965384391534,0.00032},
	{0,0,1,-3,0,0,0,0,2,1,0,1.406249128377824009206165,0.00004},
	{0,0,1,-3,0,0,0,0,4,-1,0,1.414550612432009968344460,0.00001},
	{0,0,1,-3,0,0,0,0,4,0,0,4.584168192354001192256874,0.00002},
	{0,0,1,-3,1,0,0,0,0,0,0,2.820507049094274520939507,0.00002},
	{0,0,1,-2,-3,0,0,0,0,0,0,1.810477156983521851429941,0.00002},
	{0,0,1,-2,0,0,0,0,-6,2,0,5.567166948608640808515702,0.00001},
	{0,0,1,-2,0,0,0,0,-4,-1,0,5.561309449106023095055207,0.00005},
	{0,0,1,-2,0,0,0,0,-4,0,0,5.579034314857576504209646,0.00026},
	{0,0,1,-2,0,0,0,0,-4,0,2,5.558544149439162751491494,0.00003},
	{0,0,1,-2,0,0,0,0,-4,1,0,5.555102883753005649225543,0.00066},
	{0,0,1,-2,0,0,0,0,-4,1,2,5.557654555119421857511952,0.00001},
	{0,0,1,-2,0,0,0,0,-4,2,0,5.604257289608622905063839,0.00043},
	{0,0,1,-2,0,0,0,0,-3,0,0,5.536906953636338890589741,0.00002},
	{0,0,1,-2,0,0,0,0,-3,0,1,4.770701826957221669545106,0.00005},
	{0,0,1,-2,0,0,0,0,-3,1,0,2.408352607690644298088500,0.00002},
	{0,0,1,-2,0,0,0,0,-3,1,1,1.627829323426941421359970,0.00004},
	{0,0,1,-2,0,0,0,0,-2,-3,0,5.564639537318828210743504,0.00002},
	{0,0,1,-2,0,0,0,0,-2,-2,0,5.534369419436863779537816,0.00021},
	{0,0,1,-2,0,0,0,0,-2,-1,0,5.531039505756984553386246,0.00241},
	{0,0,1,-2,0,0,0,0,-2,-1,2,2.391540549137883608921129,0.00007},
	{0,0,1,-2,0,0,0,0,-2,0,-2,2.436871636734081913999717,0.00004},
	{0,0,1,-2,0,0,0,0,-2,0,0,5.554151330244818218773162,0.02301},
	{0,0,1,-2,0,0,0,0,-2,0,2,5.550148766671219924262459,0.00054},
	{0,0,1,-2,0,0,0,0,-2,1,-2,2.462343669969387693896579,0.00007},
	{0,0,1,-2,0,0,0,0,-2,1,0,5.601108541105099369872278,0.03194},
	{0,0,1,-2,0,0,0,0,-2,1,2,5.575653786629389152551539,0.00002},
	{0,0,1,-2,0,0,0,0,-2,2,0,5.719040438662356784504937,0.00088},
	{0,0,1,-2,0,0,0,0,-2,3,0,5.989857942706560578471908,0.00003},
	{0,0,1,-2,0,0,0,0,-1,-1,0,2.394626640321260158117411,0.00007},
	{0,0,1,-2,0,0,0,0,-1,-1,1,4.770241758166396728313430,0.00007},
	{0,0,1,-2,0,0,0,0,-1,0,-1,4.066390089811103614181320,0.00003},
	{0,0,1,-2,0,0,0,0,-1,0,0,2.427408985128544305354126,0.00057},
	{0,0,1,-2,0,0,0,0,-1,0,1,0.989961572772546039011843,0.00012},
	{0,0,1,-2,0,0,0,0,-1,1,-1,4.066237373501554230870170,0.00001},
	{0,0,1,-2,0,0,0,0,-1,1,0,2.525672418279226949522354,0.00005},
	{0,0,1,-2,0,0,0,0,-1,1,1,1.628649104576602946181652,0.00005},
	{0,0,1,-2,0,0,0,0,-1,3,-1,4.066237373501554230870170,0.00001},
	{0,0,1,-2,0,0,0,0,0,-4,0,5.427232383303192797541215,0.00001},
	{0,0,1,-2,0,0,0,0,0,-3,0,5.467286816971836493905812,0.00030},
	{0,0,1,-2,0,0,0,0,0,-2,-2,2.351139667612718753275658,0.00003},
	{0,0,1,-2,0,0,0,0,0,-2,0,5.467620174858967452280467,0.00431},
	{0,0,1,-2,0,0,0,0,0,-1,-2,2.353197585333745678326522,0.00015},
	{0,0,1,-2,0,0,0,0,0,-1,0,5.468177109423279169675425,0.06323},
	{0,0,1,-2,0,0,0,0,0,-1,2,5.467082613449353090118166,0.00012},
	{0,0,1,-2,0,0,0,0,0,0,-2,2.501107083590331292555220,0.00015},
	{0,0,1,-2,0,0,0,0,0,0,0,5.552551386919515330475861,0.32455},
	{0,0,1,-2,0,0,0,0,0,0,2,2.537444838616853992618871,0.00013},
	{0,0,1,-2,0,0,0,0,0,1,-2,5.453738175054454906387491,0.00009},
	{0,0,1,-2,0,0,0,0,0,1,0,5.471244176517807922266456,0.06406},
	{0,0,1,-2,0,0,0,0,0,1,2,2.353197585333745678326522,0.00015},
	{0,0,1,-2,0,0,0,0,0,2,0,5.472072509780804949741650,0.00433},
	{0,0,1,-2,0,0,0,0,0,2,2,2.351157469971089319926705,0.00003},
	{0,0,1,-2,0,0,0,0,0,3,0,5.466159683340898745029790,0.00030},
	{0,0,1,-2,0,0,0,0,0,4,0,5.430418830918558370512983,0.00001},
	{0,0,1,-2,0,0,0,0,1,-1,0,2.505254684024770917005753,0.00007},
	{0,0,1,-2,0,0,0,0,1,-1,1,4.272810878576173365672730,0.00003},
	{0,0,1,-2,0,0,0,0,1,0,-1,0.918969607315975989259016,0.00012},
	{0,0,1,-2,0,0,0,0,1,0,0,2.472498519156266283403056,0.00067},
	{0,0,1,-2,0,0,0,0,1,1,0,2.393404211713162865748927,0.00009},
	{0,0,1,-2,0,0,0,0,2,-3,0,5.955033562674443281537151,0.00003},
	{0,0,1,-2,0,0,0,0,2,-2,0,5.675861167500943160746374,0.00111},
	{0,0,1,-2,0,0,0,0,2,-1,-2,5.582261952243290359376715,0.00002},
	{0,0,1,-2,0,0,0,0,2,-1,0,5.619283876336593763767269,0.03549},
	{0,0,1,-2,0,0,0,0,2,-1,2,2.477465377141591762466533,0.00008},
	{0,0,1,-2,0,0,0,0,2,0,-2,5.585852792646343267790598,0.00054},
	{0,0,1,-2,0,0,0,0,2,0,0,5.588502027917945369495101,0.02513},
	{0,0,1,-2,0,0,0,0,2,0,2,2.440081646294349759784836,0.00004},
	{0,0,1,-2,0,0,0,0,2,1,-2,2.411866130007834119197696,0.00007},
	{0,0,1,-2,0,0,0,0,2,1,0,5.568337366405028632243557,0.00255},
	{0,0,1,-2,0,0,0,0,2,1,2,2.445638251033924515098761,0.00001},
	{0,0,1,-2,0,0,0,0,2,2,0,5.542593934471037542266458,0.00022},
	{0,0,1,-2,0,0,0,0,3,-1,0,2.443952437509423258887864,0.00003},
	{0,0,1,-2,0,0,0,0,3,0,0,5.609230256246330093006236,0.00002},
	{0,0,1,-2,0,0,0,0,4,-3,0,5.650892836287761511471217,0.00001},
	{0,0,1,-2,0,0,0,0,4,-2,0,5.620032448052773688118577,0.00049},
	{0,0,1,-2,0,0,0,0,4,-1,-2,5.589628114351331333864437,0.00001},
	{0,0,1,-2,0,0,0,0,4,-1,0,5.606612785967114653828958,0.00070},
	{0,0,1,-2,0,0,0,0,4,0,0,5.569079654935902290446847,0.00030},
	{0,0,1,-2,0,0,0,0,4,1,0,5.572906987452600269250524,0.00006},
	{0,0,1,-2,0,0,0,0,6,-2,0,5.585459395432943452419750,0.00002},
	{0,0,1,-2,0,0,0,0,6,-1,0,5.578298134979084998974486,0.00001},
	{0,0,1,-2,0,2,0,0,-2,-1,0,0.590356397756605644211447,0.00003},
	{0,0,1,-2,0,2,0,0,-2,0,0,0.586592944290530105000414,0.00021},
	{0,0,1,-2,0,2,0,0,-2,1,0,0.609173141488206892901758,0.00035},
	{0,0,1,-2,0,2,0,0,-2,2,0,0.590356397756605644211447,0.00001},
	{0,0,1,-2,0,2,0,0,0,-2,0,0.459801929983075341468179,0.00002},
	{0,0,1,-2,0,2,0,0,0,-1,0,0.480399433150486443455662,0.00036},
	{0,0,1,-2,0,2,0,0,0,0,0,0.555607765014024423955163,0.00197},
	{0,0,1,-2,0,2,0,0,0,1,0,0.480012144589468836564095,0.00036},
	{0,0,1,-2,0,2,0,0,0,2,0,0.459871917686080322607012,0.00002},
	{0,0,1,-2,0,2,0,0,2,-2,0,0.589484780328159652107445,0.00001},
	{0,0,1,-2,0,2,0,0,2,-1,0,0.608306061915816043139671,0.00035},
	{0,0,1,-2,0,2,0,0,2,0,0,0.585777351931073275714823,0.00021},
	{0,0,1,-2,0,2,0,0,2,1,0,0.589484780328159652107445,0.00003},
	{0,0,1,-2,1,0,0,0,-2,0,0,3.406165893169136982265854,0.00004},
	{0,0,1,-2,1,0,0,0,-2,1,0,3.416615353933752707860094,0.00005},
	{0,0,1,-2,1,0,0,0,0,-1,0,3.370334981757394654522386,0.00006},
	{0,0,1,-2,1,0,0,0,0,0,0,3.436349617253127153304604,0.00026},
	{0,0,1,-2,1,0,0,0,0,1,0,3.370334981757394654522386,0.00006},
	{0,0,1,-2,1,0,0,0,2,-1,0,3.390019852258937760325352,0.00005},
	{0,0,1,-2,1,0,0,0,2,0,0,3.420987752775848544928294,0.00003},
	{0,0,1,-2,2,0,0,0,0,0,0,0.126146115148842968833875,0.00001},
	{0,0,1,-2,3,0,0,0,0,0,0,3.475338178347577855475947,0.00001},
	{0,0,1,-1,-2,0,0,0,-2,0,0,2.113597563889487496169295,0.00002},
	{0,0,1,-1,-2,0,0,0,0,-1,0,5.267260740053147927142163,0.00001},
	{0,0,1,-1,-2,0,0,0,0,1,0,5.267260740053147927142163,0.00001},
	{0,0,1,-1,0,0,0,0,-6,2,0,0.011327186845443199328387,0.00001},
	{0,0,1,-1,0,0,0,0,-4,0,0,0.012834104121615102361842,0.00005},
	{0,0,1,-1,0,0,0,0,-4,1,0,0.011450407090633997822526,0.00015},
	{0,0,1,-1,0,0,0,0,-4,2,0,0.011438364318795237947746,0.00009},
	{0,0,1,-1,0,0,0,0,-3,2,0,0.010557322112388500476299,0.00001},
	{0,0,1,-1,0,0,0,0,-2,-2,0,0.011280935620265348379165,0.00003},
	{0,0,1,-1,0,0,0,0,-2,-1,0,0.011310431684624052892096,0.00039},
	{0,0,1,-1,0,0,0,0,-2,-1,2,3.152543023849730730034935,0.00001},
	{0,0,1,-1,0,0,0,0,-2,0,-2,3.152903434340267541102776,0.00001},
	{0,0,1,-1,0,0,0,0,-2,0,0,0.011439062450496036149605,0.00466},
	{0,0,1,-1,0,0,0,0,-2,0,2,0.011126299448538651618024,0.00009},
	{0,0,1,-1,0,0,0,0,-2,1,0,0.011874347565943420973467,0.00692},
	{0,0,1,-1,0,0,0,0,-2,1,2,3.152543023849730730034935,0.00001},
	{0,0,1,-1,0,0,0,0,-2,2,0,0.011941542742145204100690,0.00032},
	{0,0,1,-1,0,0,0,0,-2,3,0,0.011081619019687596189305,0.00002},
	{0,0,1,-1,0,0,0,0,-1,0,0,3.149812281702060179355840,0.00017},
	{0,0,1,-1,0,0,0,0,-1,0,1,1.619138805482485787834435,0.00004},
	{0,0,1,-1,0,0,0,0,-1,1,0,3.152543023849730730034935,0.00001},
	{0,0,1,-1,0,0,0,0,0,-2,0,0.009220399905360844236557,0.00022},
	{0,0,1,-1,0,0,0,0,0,-1,0,0.009412560656005418760484,0.00342},
	{0,0,1,-1,0,0,0,0,0,0,0,0.015427663390078675403894,0.01051},
	{0,0,1,-1,0,0,0,0,0,1,-2,3.160989370231832129576333,0.00002},
	{0,0,1,-1,0,0,0,0,0,1,0,0.007555181266033053448516,0.00296},
	{0,0,1,-1,0,0,0,0,0,2,0,0.006878691647960052078792,0.00019},
	{0,0,1,-1,0,0,0,0,0,3,-2,3.160989370231832129576333,0.00002},
	{0,0,1,-1,0,0,0,0,0,3,0,0.005008920420298526923752,0.00001},
	{0,0,1,-1,0,0,0,0,1,-1,1,4.786397223854557125832798,0.00004},
	{0,0,1,-1,0,0,0,0,1,0,-1,1.650264134697926765582565,0.00013},
	{0,0,1,-1,0,0,0,0,1,0,0,0.004944517770899935736606,0.00013},
	{0,0,1,-1,0,0,0,0,1,0,1,4.790320549480114209472958,0.00002},
	{0,0,1,-1,0,0,0,0,2,-2,0,6.280668018799435259325037,0.00015},
	{0,0,1,-1,0,0,0,0,2,-1,0,0.006097482274767389819059,0.00450},
	{0,0,1,-1,0,0,0,0,2,0,-2,0.004378332961552975667596,0.00007},
	{0,0,1,-1,0,0,0,0,2,0,0,0.005677206990887155059478,0.00218},
	{0,0,1,-1,0,0,0,0,2,1,0,0.005898165674189637629199,0.00022},
	{0,0,1,-1,0,0,0,0,2,2,0,0.005039812748058826105679,0.00002},
	{0,0,1,-1,0,0,0,0,3,-2,0,3.145038457132005582650436,0.00001},
	{0,0,1,-1,0,0,0,0,4,-2,0,0.007321481679191012802155,0.00007},
	{0,0,1,-1,0,0,0,0,4,-1,0,0.006151587481579214033989,0.00007},
	{0,0,1,-1,0,0,0,0,4,0,0,0.005345768965933432072257,0.00005},
	{0,0,1,-1,1,0,0,0,2,0,0,3.701264941365861815825156,0.00001},
	{0,0,1,-1,3,0,0,0,1,-2,1,2.228341443035051661070156,0.00003},
	{0,0,1,0,-6,0,0,0,0,0,0,5.832111594252809005922700,0.00003},
	{0,0,1,0,-6,5,0,0,0,0,0,3.471370346826093911118960,0.00004},
	{0,0,1,0,-5,0,0,0,-2,0,0,5.714073231611181746814054,0.00005},
	{0,0,1,0,-5,0,0,0,-2,1,0,5.725890855976435211971420,0.00006},
	{0,0,1,0,-5,0,0,0,0,-1,0,5.644624311746298417347134,0.00007},
	{0,0,1,0,-5,0,0,0,0,0,0,5.635181033295459052112619,0.00030},
	{0,0,1,0,-5,0,0,0,0,1,0,5.644624311746298417347134,0.00007},
	{0,0,1,0,-5,0,0,0,2,-1,0,5.705162627648048712103446,0.00002},
	{0,0,1,0,-5,0,0,0,2,0,0,5.688457732311361425558971,0.00002},
	{0,0,1,0,-5,2,0,0,-2,0,0,5.452346449508914005832594,0.00001},
	{0,0,1,0,-5,2,0,0,0,0,0,5.274371211425773253722582,0.00007},
	{0,0,1,0,-5,3,0,0,-2,0,0,5.426296188692422362009893,0.00002},
	{0,0,1,0,-5,3,0,0,0,0,0,5.402045187801811643169003,0.00005},
	{0,0,1,0,-5,4,0,0,0,0,0,3.247588244392661138704170,0.00002},
	{0,0,1,0,-5,5,0,0,-2,0,0,3.208792542180554985264962,0.00004},
	{0,0,1,0,-5,5,0,0,-2,1,0,3.222068214602924918210647,0.00004},
	{0,0,1,0,-5,5,0,0,0,-1,0,3.145835199935540948956714,0.00004},
	{0,0,1,0,-5,5,0,0,0,0,0,3.017604812593966290279468,0.00018},
	{0,0,1,0,-5,5,0,0,0,1,0,3.145835199935540948956714,0.00004},
	{0,0,1,0,-5,5,0,0,2,-1,0,5.884446688137260572659670,0.00003},
	{0,0,1,0,-5,7,0,0,0,0,0,2.925415823371924961548984,0.00002},
	{0,0,1,0,-5,10,0,0,0,0,0,5.989850612323702527817204,0.00002},
	{0,0,1,0,-4,0,0,0,-4,1,0,5.543312486524083482208880,0.00002},
	{0,0,1,0,-4,0,0,0,-2,-1,0,5.536638871063233047209451,0.00005},
	{0,0,1,0,-4,0,0,0,-2,0,0,5.545366389987830046948147,0.00045},
	{0,0,1,0,-4,0,0,0,-2,1,0,5.540565163748519594832942,0.00064},
	{0,0,1,0,-4,0,0,0,-2,2,0,5.546159467599935943837863,0.00002},
	{0,0,1,0,-4,0,0,0,-1,-1,1,2.115424749083400168814251,0.00002},
	{0,0,1,0,-4,0,0,0,-1,0,1,2.133875846336708903550061,0.00002},
	{0,0,1,0,-4,0,0,0,0,-2,0,5.471370712888577791943590,0.00004},
	{0,0,1,0,-4,0,0,0,0,-1,0,5.472785302247319627610977,0.00059},
	{0,0,1,0,-4,0,0,0,0,0,0,5.463911350198479510709149,0.00267},
	{0,0,1,0,-4,0,0,0,0,1,0,5.462771650196927453180251,0.00050},
	{0,0,1,0,-4,0,0,0,0,2,0,5.471885061419140328098365,0.00004},
	{0,0,1,0,-4,0,0,0,1,-2,1,5.261212126997436122621821,0.00004},
	{0,0,1,0,-4,0,0,0,1,-1,1,5.257016879074417836648081,0.00012},
	{0,0,1,0,-4,0,0,0,1,0,-1,2.104156728899599482218719,0.00010},
	{0,0,1,0,-4,0,0,0,1,0,0,5.469738131906262346149106,0.00002},
	{0,0,1,0,-4,0,0,0,1,0,1,5.247193293379567080592096,0.00002},
	{0,0,1,0,-4,0,0,0,2,-2,0,2.241021609116640611603088,0.00002},
	{0,0,1,0,-4,0,0,0,2,-1,0,5.794698541874134356532977,0.00012},
	{0,0,1,0,-4,0,0,0,2,0,0,5.520798262772132147802040,0.00014},
	{0,0,1,0,-4,0,0,0,2,1,0,5.532612571011806146259460,0.00001},
	{0,0,1,0,-4,2,0,0,-2,0,0,5.467040201948529798414711,0.00006},
	{0,0,1,0,-4,2,0,0,-2,1,0,5.475199267135752556612260,0.00007},
	{0,0,1,0,-4,2,0,0,0,-1,0,5.381553451587071990047662,0.00006},
	{0,0,1,0,-4,2,0,0,0,0,0,5.312383609869583800389137,0.00027},
	{0,0,1,0,-4,2,0,0,0,1,0,5.381553451587071990047662,0.00006},
	{0,0,1,0,-4,2,0,0,1,-3,1,4.909644696181687528735438,0.00001},
	{0,0,1,0,-4,2,0,0,1,-2,1,4.905979330219573775195840,0.00012},
	{0,0,1,0,-4,2,0,0,1,-1,1,1.763736192417562742562609,0.00006},
	{0,0,1,0,-4,2,0,0,1,0,-1,1.762644139904589568601523,0.00001},
	{0,0,1,0,-4,2,0,0,2,-1,0,0.264022413667414634907971,0.00001},
	{0,0,1,0,-4,2,0,0,2,0,0,5.493078245460258024479572,0.00001},
	{0,0,1,0,-4,3,0,0,-2,0,0,0.104872471429209274118577,0.00004},
	{0,0,1,0,-4,3,0,0,-2,1,0,0.104872296896284078471240,0.00003},
	{0,0,1,0,-4,3,0,0,0,-1,0,0.098304797453954623209782,0.00002},
	{0,0,1,0,-4,3,0,0,0,0,0,6.217643830444069763530024,0.00013},
	{0,0,1,0,-4,3,0,0,0,1,0,0.098304797453954623209782,0.00002},
	{0,0,1,0,-4,3,0,0,2,-1,0,2.793995672289405707289234,0.00003},
	{0,0,1,0,-4,4,0,0,-2,0,0,4.182086569662406105862829,0.00002},
	{0,0,1,0,-4,4,0,0,0,0,0,4.170754146829207087421310,0.00005},
	{0,0,1,0,-4,5,0,0,-2,0,0,2.053187006088983412865900,0.00008},
	{0,0,1,0,-4,5,0,0,-2,1,0,2.065101670760647767366436,0.00011},
	{0,0,1,0,-4,5,0,0,0,-1,0,1.952683442843366368180114,0.00011},
	{0,0,1,0,-4,5,0,0,0,0,0,1.881322340249999447436835,0.00055},
	{0,0,1,0,-4,5,0,0,0,1,0,1.923658791915625609902918,0.00009},
	{0,0,1,0,-4,5,0,0,1,0,-1,4.745817097015212482347124,0.00007},
	{0,0,1,0,-4,5,0,0,2,-3,0,5.241294604106602861293140,0.00002},
	{0,0,1,0,-4,5,0,0,2,-2,0,4.791405969741929560257176,0.00001},
	{0,0,1,0,-4,5,0,0,2,-1,0,1.712336769545105052969802,0.00004},
	{0,0,1,0,-4,5,0,0,2,0,0,2.227882072375926725271711,0.00003},
	{0,0,1,0,-3,0,0,0,-4,0,0,5.391809180804715495582968,0.00005},
	{0,0,1,0,-3,0,0,0,-4,1,0,5.396619482756137564649634,0.00013},
	{0,0,1,0,-3,0,0,0,-4,2,0,5.417962066981224289463626,0.00006},
	{0,0,1,0,-3,0,0,0,-3,0,0,5.464731131348140813486225,0.00001},
	{0,0,1,0,-3,0,0,0,-2,-2,0,5.392732285446094842029652,0.00004},
	{0,0,1,0,-3,0,0,0,-2,-1,0,5.397476439418865901131994,0.00039},
	{0,0,1,0,-3,0,0,0,-2,0,-2,2.248230866124928617466594,0.00001},
	{0,0,1,0,-3,0,0,0,-2,0,0,5.400968843252107021157826,0.00436},
	{0,0,1,0,-3,0,0,0,-2,0,2,5.403831706824154146318051,0.00007},
	{0,0,1,0,-3,0,0,0,-2,1,0,5.400087626512775074161254,0.00587},
	{0,0,1,0,-3,0,0,0,-2,2,0,5.374879137994520661436582,0.00027},
	{0,0,1,0,-3,0,0,0,-2,3,0,5.373014079155838729207062,0.00002},
	{0,0,1,0,-3,0,0,0,-1,-2,1,5.073000532851348332030739,0.00005},
	{0,0,1,0,-3,0,0,0,-1,-1,1,5.072526326893581405386158,0.00051},
	{0,0,1,0,-3,0,0,0,-1,0,-1,5.093659995207205248846094,0.00003},
	{0,0,1,0,-3,0,0,0,-1,0,0,2.246144674070019942035970,0.00020},
	{0,0,1,0,-3,0,0,0,-1,0,1,1.957831989603824318635361,0.00009},
	{0,0,1,0,-3,0,0,0,-1,1,-1,5.086779383697067835612415,0.00005},
	{0,0,1,0,-3,0,0,0,-1,1,0,2.289188333148554299611988,0.00002},
	{0,0,1,0,-3,0,0,0,-1,1,1,1.943618202708507824993944,0.00003},
	{0,0,1,0,-3,0,0,0,0,-2,0,5.347741711586960988711326,0.00031},
	{0,0,1,0,-3,0,0,0,0,-1,-2,2.185692751966243019268177,0.00002},
	{0,0,1,0,-3,0,0,0,0,-1,0,5.350450462586056055158679,0.00458},
	{0,0,1,0,-3,0,0,0,0,0,0,5.316394900089441932777845,0.02314},
	{0,0,1,0,-3,0,0,0,0,1,0,5.321324408028774932688520,0.00415},
	{0,0,1,0,-3,0,0,0,0,1,2,2.185692751966243019268177,0.00002},
	{0,0,1,0,-3,0,0,0,0,2,0,5.316720927593714840497796,0.00027},
	{0,0,1,0,-3,0,0,0,1,-3,1,5.072307462605381012110684,0.00007},
	{0,0,1,0,-3,0,0,0,1,-2,-1,5.077552351540550290565079,0.00002},
	{0,0,1,0,-3,0,0,0,1,-2,1,5.072710284596741558971189,0.00158},
	{0,0,1,0,-3,0,0,0,1,-1,-1,1.937756514415684971908149,0.00016},
	{0,0,1,0,-3,0,0,0,1,-1,0,5.322543869577143205162884,0.00012},
	{0,0,1,0,-3,0,0,0,1,-1,1,1.931530401375045169487521,0.00247},
	{0,0,1,0,-3,0,0,0,1,0,-1,1.936211025363043791713835,0.00119},
	{0,0,1,0,-3,0,0,0,1,0,0,5.376137869451058648451180,0.00033},
	{0,0,1,0,-3,0,0,0,1,0,1,5.089803341159074179245181,0.00006},
	{0,0,1,0,-3,0,0,0,1,1,-1,1.937756514415684971908149,0.00016},
	{0,0,1,0,-3,0,0,0,1,1,0,5.375494541088773559067704,0.00002},
	{0,0,1,0,-3,0,0,0,1,1,1,5.077582545736609276332274,0.00002},
	{0,0,1,0,-3,0,0,0,2,-3,0,5.131818477709408021780746,0.00003},
	{0,0,1,0,-3,0,0,0,2,-2,0,1.952872985600132782479932,0.00031},
	{0,0,1,0,-3,0,0,0,2,-1,0,1.540399847075088590742098,0.00147},
	{0,0,1,0,-3,0,0,0,2,0,-2,5.390853613039248592997410,0.00005},
	{0,0,1,0,-3,0,0,0,2,0,0,5.535809839668535126122606,0.00083},
	{0,0,1,0,-3,0,0,0,2,1,0,5.489542033862790937348564,0.00010},
	{0,0,1,0,-3,0,0,0,3,-3,1,5.073001230983049225642390,0.00002},
	{0,0,1,0,-3,0,0,0,3,-2,1,1.932039862983702560583765,0.00002},
	{0,0,1,0,-3,0,0,0,3,-1,1,1.931550298128518194928915,0.00002},
	{0,0,1,0,-3,0,0,0,4,-3,0,1.971380107922430235944944,0.00020},
	{0,0,1,0,-3,0,0,0,4,-2,0,1.959606814920177297878467,0.00050},
	{0,0,1,0,-3,0,0,0,4,-1,0,1.945122501990801611171378,0.00030},
	{0,0,1,0,-3,0,0,0,4,0,0,1.840396463685834760326543,0.00003},
	{0,0,1,0,-3,0,0,0,6,-3,0,1.971945245534226121009169,0.00002},
	{0,0,1,0,-3,0,0,0,6,-2,0,1.972566233682085723444288,0.00001},
	{0,0,1,0,-3,1,0,0,-2,0,0,2.274464211979954519904368,0.00002},
	{0,0,1,0,-3,1,0,0,0,0,0,2.023606293261557720342125,0.00008},
	{0,0,1,0,-3,1,0,0,2,-1,0,1.821689152098333597251667,0.00004},
	{0,0,1,0,-3,2,0,0,-2,-1,0,6.218355226647181765997630,0.00001},
	{0,0,1,0,-3,2,0,0,-2,0,0,6.218355401180107655534357,0.00014},
	{0,0,1,0,-3,2,0,0,-2,1,0,6.219220037291544933566456,0.00018},
	{0,0,1,0,-3,2,0,0,0,-1,0,6.199536912119254061792617,0.00015},
	{0,0,1,0,-3,2,0,0,0,0,0,6.166267794983588679258446,0.00059},
	{0,0,1,0,-3,2,0,0,0,1,0,6.196326204427285766485056,0.00011},
	{0,0,1,0,-3,2,0,0,2,-3,0,0.011202744869776003547313,0.00002},
	{0,0,1,0,-3,2,0,0,2,-2,0,0.020343732294171103930358,0.00002},
	{0,0,1,0,-3,2,0,0,2,-1,0,6.242324182330671433760472,0.00006},
	{0,0,1,0,-3,2,0,0,2,0,0,6.241498990660327983448497,0.00005},
	{0,0,1,0,-3,2,0,0,4,-3,0,3.105040048532350827059645,0.00001},
	{0,0,1,0,-3,2,0,0,4,-2,0,3.097831315122838713449482,0.00001},
	{0,0,1,0,-3,3,0,0,-2,0,0,1.055711092754900715107169,0.00007},
	{0,0,1,0,-3,3,0,0,-2,1,0,1.055961198436711656611919,0.00007},
	{0,0,1,0,-3,3,0,0,0,-1,0,1.053423664237236989649205,0.00005},
	{0,0,1,0,-3,3,0,0,0,0,0,1.052560773455051057467813,0.00021},
	{0,0,1,0,-3,3,0,0,0,1,0,1.053423664237236989649205,0.00005},
	{0,0,1,0,-3,3,0,0,2,-1,0,1.006012842304362386869343,0.00002},
	{0,0,1,0,-3,3,0,0,2,0,0,1.020867863166861733148494,0.00001},
	{0,0,1,0,-3,4,0,0,-2,0,0,5.179431932368439461811249,0.00002},
	{0,0,1,0,-3,4,0,0,0,0,0,5.095587885898957836161571,0.00003},
	{0,0,1,0,-3,5,0,0,-4,1,0,3.010980939016797641727408,0.00001},
	{0,0,1,0,-3,5,0,0,-2,-1,0,3.011656555970244397713032,0.00004},
	{0,0,1,0,-3,5,0,0,-2,0,0,3.011910501376409587948046,0.00041},
	{0,0,1,0,-3,5,0,0,-2,1,0,3.010067782752154030845304,0.00055},
	{0,0,1,0,-3,5,0,0,-2,2,0,3.010977797424144064564189,0.00002},
	{0,0,1,0,-3,5,0,0,-1,0,0,3.012121686215901039673781,0.00003},
	{0,0,1,0,-3,5,0,0,0,-2,0,3.020113199794932423714044,0.00002},
	{0,0,1,0,-3,5,0,0,0,-1,0,3.017012796911689775924970,0.00038},
	{0,0,1,0,-3,5,0,0,0,0,0,3.007662195444130048826992,0.00171},
	{0,0,1,0,-3,5,0,0,0,1,0,3.018444839562951287348369,0.00025},
	{0,0,1,0,-3,5,0,0,0,2,0,3.019561850284227855212293,0.00002},
	{0,0,1,0,-3,5,0,0,1,-1,0,3.012211570672378435631344,0.00006},
	{0,0,1,0,-3,5,0,0,1,0,-1,0.213956422343480889836087,0.00001},
	{0,0,1,0,-3,5,0,0,1,0,0,6.153714339805694599760955,0.00017},
	{0,0,1,0,-3,5,0,0,2,-3,0,0.026899188964661806255929,0.00001},
	{0,0,1,0,-3,5,0,0,2,-1,0,2.990114131545803743961187,0.00012},
	{0,0,1,0,-3,5,0,0,2,0,0,3.009822913058099569383330,0.00008},
	{0,0,1,0,-3,6,-3,0,0,0,0,6.099897461386299291064006,0.00002},
	{0,0,1,0,-2,-5,0,0,0,0,0,5.605389659227316911938033,0.00003},
	{0,0,1,0,-2,-2,0,0,0,0,0,1.699830612789939632278902,0.00003},
	{0,0,1,0,-2,0,0,0,-6,1,0,5.345782754034522632480275,0.00002},
	{0,0,1,0,-2,0,0,0,-6,2,0,5.339211065801988453927152,0.00003},
	{0,0,1,0,-2,0,0,0,-4,-1,0,5.334866068629148472268753,0.00007},
	{0,0,1,0,-2,0,0,0,-4,0,0,5.352255656631394131750312,0.00038},
	{0,0,1,0,-2,0,0,0,-4,1,0,5.351289267824564710451796,0.00090},
	{0,0,1,0,-2,0,0,0,-4,1,2,5.346894179702192495540203,0.00001},
	{0,0,1,0,-2,0,0,0,-4,2,0,5.337727012339017917952333,0.00060},
	{0,0,1,0,-2,0,0,0,-4,3,0,5.264007446327431338772840,0.00003},
	{0,0,1,0,-2,0,0,0,-3,0,0,5.379235828873349056777897,0.00001},
	{0,0,1,0,-2,0,0,0,-3,1,0,2.201994825311571091219776,0.00006},
	{0,0,1,0,-2,0,0,0,-3,1,1,4.898092187329812219331870,0.00001},
	{0,0,1,0,-2,0,0,0,-2,-3,0,5.336628676640737367620204,0.00003},
	{0,0,1,0,-2,0,0,0,-2,-2,0,5.315560283641138639154633,0.00026},
	{0,0,1,0,-2,0,0,0,-2,-1,-2,2.191946615741989567993642,0.00002},
	{0,0,1,0,-2,0,0,0,-2,-1,0,5.332918455716848527004004,0.00313},
	{0,0,1,0,-2,0,0,0,-2,-1,2,2.193748493661748177885329,0.00007},
	{0,0,1,0,-2,0,0,0,-2,0,-2,2.175385361002740491898066,0.00007},
	{0,0,1,0,-2,0,0,0,-2,0,0,5.341196901424907217403870,0.03474},
	{0,0,1,0,-2,0,0,0,-2,0,2,5.345454283069297929387176,0.00050},
	{0,0,1,0,-2,0,0,0,-2,1,-2,2.192239132924623579157242,0.00013},
	{0,0,1,0,-2,0,0,0,-2,1,0,5.340605583874332040750232,0.04570},
	{0,0,1,0,-2,0,0,0,-2,1,2,5.329769707213324991812442,0.00002},
	{0,0,1,0,-2,0,0,0,-2,2,0,5.340198747625692021756549,0.00196},
	{0,0,1,0,-2,0,0,0,-2,3,0,5.378330352057413499267113,0.00010},
	{0,0,1,0,-2,0,0,0,-1,-2,1,4.895931818781693145581357,0.00005},
	{0,0,1,0,-2,0,0,0,-1,-1,-1,4.895756238658942827157716,0.00003},
	{0,0,1,0,-2,0,0,0,-1,-1,0,2.195340583005417567363793,0.00015},
	{0,0,1,0,-2,0,0,0,-1,-1,1,4.895973881216666434568197,0.00069},
	{0,0,1,0,-2,0,0,0,-1,0,-1,4.895793065106159858146384,0.00016},
	{0,0,1,0,-2,0,0,0,-1,0,0,2.196619734814204250028524,0.00233},
	{0,0,1,0,-2,0,0,0,-1,0,1,1.754102847611179960551908,0.00104},
	{0,0,1,0,-2,0,0,0,-1,1,-1,4.896327135857269752250431,0.00040},
	{0,0,1,0,-2,0,0,0,-1,1,0,2.198800000115795683086617,0.00025},
	{0,0,1,0,-2,0,0,0,-1,1,1,1.754933798868054228847768,0.00018},
	{0,0,1,0,-2,0,0,0,-1,2,-1,4.895934960374346722744576,0.00003},
	{0,0,1,0,-2,0,0,0,-1,2,0,2.195797510203589375521460,0.00002},
	{0,0,1,0,-2,0,0,0,0,-3,0,5.236724983059031224286173,0.00020},
	{0,0,1,0,-2,0,0,0,0,-2,0,5.237996106353258518595339,0.00261},
	{0,0,1,0,-2,0,0,0,0,-1,-2,2.133965381727336296791009,0.00009},
	{0,0,1,0,-2,0,0,0,0,-1,0,5.253470195501440009877570,0.03780},
	{0,0,1,0,-2,0,0,0,0,-1,2,5.092414528252982464096021,0.00002},
	{0,0,1,0,-2,0,0,0,0,0,-2,2.074318754540430020938402,0.00002},
	{0,0,1,0,-2,0,0,0,0,0,-1,1.754308621929990152921164,0.00002},
	{0,0,1,0,-2,0,0,0,0,0,0,5.253545593725126749973242,0.16425},
	{0,0,1,0,-2,0,0,0,0,0,2,2.119602194648048776315363,0.00011},
	{0,0,1,0,-2,0,0,0,0,1,0,5.262127203124257412980569,0.02889},
	{0,0,1,0,-2,0,0,0,0,1,2,2.129900160833591016285027,0.00008},
	{0,0,1,0,-2,0,0,0,0,2,0,5.258096016150926033105861,0.00202},
	{0,0,1,0,-2,0,0,0,0,3,0,5.262564233568956417741447,0.00013},
	{0,0,1,0,-2,0,0,0,1,-3,0,5.380048977771852314333501,0.00001},
	{0,0,1,0,-2,0,0,0,1,-3,1,4.896355235658226057182674,0.00002},
	{0,0,1,0,-2,0,0,0,1,-2,-1,1.754449295467700897788177,0.00008},
	{0,0,1,0,-2,0,0,0,1,-2,0,5.420621250629563014911128,0.00018},
	{0,0,1,0,-2,0,0,0,1,-2,1,4.896298686990461668244734,0.00055},
	{0,0,1,0,-2,0,0,0,1,-1,-1,1.754462559970015878008098,0.00155},
	{0,0,1,0,-2,0,0,0,1,-1,0,5.338794630242462702085504,0.00327},
	{0,0,1,0,-2,0,0,0,1,-1,1,1.754482980322264129569021,0.00445},
	{0,0,1,0,-2,0,0,0,1,0,-3,4.948149801073336462309271,0.00001},
	{0,0,1,0,-2,0,0,0,1,0,-1,1.754581242359151582732579,0.01183},
	{0,0,1,0,-2,0,0,0,1,0,0,5.344078963618725808260024,0.00697},
	{0,0,1,0,-2,0,0,0,1,0,1,4.895755016928466041292722,0.00203},
	{0,0,1,0,-2,0,0,0,1,1,-1,1.754477744334508093615455,0.00165},
	{0,0,1,0,-2,0,0,0,1,1,0,5.343128980906865166389252,0.00047},
	{0,0,1,0,-2,0,0,0,1,1,1,4.895770550358808037572089,0.00024},
	{0,0,1,0,-2,0,0,0,1,2,-1,1.754460989173689089426489,0.00011},
	{0,0,1,0,-2,0,0,0,1,2,0,5.342280925423320780964787,0.00003},
	{0,0,1,0,-2,0,0,0,1,2,1,4.895777357142891972330290,0.00002},
	{0,0,1,0,-2,0,0,0,2,-4,0,5.107617393235404534834743,0.00001},
	{0,0,1,0,-2,0,0,0,2,-3,0,4.799883208451792171445049,0.00004},
	{0,0,1,0,-2,0,0,0,2,-2,0,5.034749373365865920959550,0.00049},
	{0,0,1,0,-2,0,0,0,2,-1,0,5.265851212149237348114639,0.01819},
	{0,0,1,0,-2,0,0,0,2,-1,2,2.282805838606936088552857,0.00003},
	{0,0,1,0,-2,0,0,0,2,0,-2,5.323011966882528867017754,0.00040},
	{0,0,1,0,-2,0,0,0,2,0,0,5.305242420702123595788180,0.00872},
	{0,0,1,0,-2,0,0,0,2,0,2,2.195780056911069699765449,0.00002},
	{0,0,1,0,-2,0,0,0,2,1,-2,2.181835399786410611966403,0.00002},
	{0,0,1,0,-2,0,0,0,2,1,0,5.292584594834959688114395,0.00099},
	{0,0,1,0,-2,0,0,0,2,2,0,5.324562517389999527495092,0.00010},
	{0,0,1,0,-2,0,0,0,3,-2,-1,4.895969692426461072898292,0.00002},
	{0,0,1,0,-2,0,0,0,3,-2,0,5.332749856911105368340031,0.00003},
	{0,0,1,0,-2,0,0,0,3,-2,1,1.754476522604031973884275,0.00006},
	{0,0,1,0,-2,0,0,0,3,-1,-1,4.895164746575441760967351,0.00007},
	{0,0,1,0,-2,0,0,0,3,-1,0,5.339366749171266413043213,0.00012},
	{0,0,1,0,-2,0,0,0,3,0,-1,1.756857151703752117910540,0.00003},
	{0,0,1,0,-2,0,0,0,3,0,0,5.338943157761807611905169,0.00008},
	{0,0,1,0,-2,0,0,0,3,0,1,4.895774564616088397883686,0.00003},
	{0,0,1,0,-2,0,0,0,4,-3,0,1.799182258729240535544136,0.00018},
	{0,0,1,0,-2,0,0,0,4,-2,0,5.052396222899854905108441,0.00069},
	{0,0,1,0,-2,0,0,0,4,-1,0,5.048012653950546102521457,0.00098},
	{0,0,1,0,-2,0,0,0,4,0,0,5.189916648783944985723338,0.00019},
	{0,0,1,0,-2,0,0,0,4,1,0,5.322548756499049460444439,0.00001},
	{0,0,1,0,-2,0,0,0,6,-3,0,4.995005782837001362395313,0.00002},
	{0,0,1,0,-2,0,0,0,6,-2,0,4.944358596872153732704191,0.00004},
	{0,0,1,0,-2,0,0,0,6,-1,0,4.940309956606302677073472,0.00001},
	{0,0,1,0,-2,1,0,0,-2,0,0,3.193550930888739092239348,0.00006},
	{0,0,1,0,-2,1,0,0,-2,1,0,3.193550930888739092239348,0.00007},
	{0,0,1,0,-2,1,0,0,0,-1,0,3.185804112470837168302751,0.00005},
	{0,0,1,0,-2,1,0,0,0,0,0,3.169897705266936149826051,0.00019},
	{0,0,1,0,-2,1,0,0,0,1,0,3.185804112470837168302751,0.00005},
	{0,0,1,0,-2,1,0,0,2,-1,0,3.160954463646792333975100,0.00003},
	{0,0,1,0,-2,1,0,0,2,0,0,3.160954812712642780780925,0.00002},
	{0,0,1,0,-2,2,0,0,-2,-1,0,0.501363280927891064031598,0.00001},
	{0,0,1,0,-2,2,0,0,-2,0,0,0.501363280927891064031598,0.00010},
	{0,0,1,0,-2,2,0,0,-2,1,0,0.513206387100223815345146,0.00013},
	{0,0,1,0,-2,2,0,0,0,-1,0,0.403856971606723846868192,0.00010},
	{0,0,1,0,-2,2,0,0,0,0,0,0.399293284678609139426442,0.00039},
	{0,0,1,0,-2,2,0,0,0,1,0,0.359706250183649323126645,0.00007},
	{0,0,1,0,-2,2,0,0,1,-1,0,0.223492726843452671481316,0.00008},
	{0,0,1,0,-2,2,0,0,1,0,-1,2.004844178335543514180017,0.00002},
	{0,0,1,0,-2,2,0,0,1,0,0,3.334690820575614722542923,0.00007},
	{0,0,1,0,-2,2,0,0,2,-1,0,0.061344308950321092821500,0.00003},
	{0,0,1,0,-2,2,0,0,2,0,0,0.170589702820402172589453,0.00002},
	{0,0,1,0,-2,3,0,0,-2,0,0,3.089762832523794244821147,0.00002},
	{0,0,1,0,-2,3,0,0,0,0,0,4.139526192253748959615223,0.00006},
	{0,0,1,0,-2,3,0,0,1,0,-1,1.897301004084932740667568,0.00004},
	{0,0,1,0,-2,4,0,0,-2,0,0,6.075851362149872869622413,0.00006},
	{0,0,1,0,-2,4,0,0,-2,1,0,6.075851536682797870980721,0.00007},
	{0,0,1,0,-2,4,0,0,0,-1,0,6.093533118268902093461747,0.00005},
	{0,0,1,0,-2,4,0,0,0,0,0,6.118362870339474568481819,0.00026},
	{0,0,1,0,-2,4,0,0,0,1,0,6.093533118268902093461747,0.00005},
	{0,0,1,0,-2,4,0,0,1,0,-1,3.262081807567071667364189,0.00001},
	{0,0,1,0,-2,4,0,0,2,-1,0,6.143352669102454477467745,0.00003},
	{0,0,1,0,-2,4,0,0,2,0,0,6.047221504698933713939368,0.00001},
	{0,0,1,0,-2,5,0,0,-4,1,0,4.261031476921538718727334,0.00002},
	{0,0,1,0,-2,5,0,0,-4,2,0,4.706357122489797539799383,0.00001},
	{0,0,1,0,-2,5,0,0,-2,-1,0,2.239390598930651954390214,0.00005},
	{0,0,1,0,-2,5,0,0,-2,0,0,3.376335074659900570281934,0.00028},
	{0,0,1,0,-2,5,0,0,-2,1,0,4.265102108335964814500585,0.00078},
	{0,0,1,0,-2,5,0,0,-2,2,0,4.433081671260009848367645,0.00006},
	{0,0,1,0,-2,5,0,0,0,-2,0,1.704915629565625367902726,0.00006},
	{0,0,1,0,-2,5,0,0,0,-1,0,1.964474014605213980644294,0.00042},
	{0,0,1,0,-2,5,0,0,0,0,0,3.501304663359974256309215,0.00068},
	{0,0,1,0,-2,5,0,0,0,1,0,4.472143536183044609799708,0.00037},
	{0,0,1,0,-2,5,0,0,0,2,0,4.529940987027462284686408,0.00003},
	{0,0,1,0,-2,5,0,0,1,0,-1,4.646607171811172776187959,0.00004},
	{0,0,1,0,-2,5,0,0,1,0,1,1.506206229034641630448732,0.00005},
	{0,0,1,0,-2,5,0,0,2,-3,0,5.999539284067373579034665,0.00001},
	{0,0,1,0,-2,5,0,0,2,-2,0,3.754660846369675564204726,0.00001},
	{0,0,1,0,-2,5,0,0,2,-1,0,1.501963333623043572728761,0.00007},
	{0,0,1,0,-2,5,0,0,2,0,0,3.171944627413675110716440,0.00003},
	{0,0,1,0,-2,6,0,0,1,0,-1,1.578801104876243366348376,0.00003},
	{0,0,1,0,-2,7,0,0,1,0,-1,0.845756884919168228087472,0.00001},
	{0,0,1,0,-1,-5,0,0,-2,0,0,5.553764914348427339518821,0.00004},
	{0,0,1,0,-1,-5,0,0,-2,1,0,5.553770848467883602950224,0.00005},
	{0,0,1,0,-1,-5,0,0,0,-1,0,5.489166788073612579523797,0.00004},
	{0,0,1,0,-1,-5,0,0,0,0,0,5.421753620248257021785321,0.00019},
	{0,0,1,0,-1,-5,0,0,0,1,0,5.489166788073612579523797,0.00004},
	{0,0,1,0,-1,-5,0,0,2,0,0,5.571818774663981344019703,0.00001},
	{0,0,1,0,-1,-3,0,0,0,0,0,5.913158576063044513659861,0.00001},
	{0,0,1,0,-1,-2,0,0,-2,0,0,1.867841242574669768927720,0.00003},
	{0,0,1,0,-1,-2,0,0,-2,1,0,1.867841591640520437778150,0.00002},
	{0,0,1,0,-1,-2,0,0,0,-1,0,1.867844558700248791538456,0.00001},
	{0,0,1,0,-1,-2,0,0,0,0,0,1.856070043967519511696196,0.00012},
	{0,0,1,0,-1,-2,0,0,0,1,0,1.867844558700248791538456,0.00001},
	{0,0,1,0,-1,-1,0,0,-2,0,0,5.414131069273096841243387,0.00001},
	{0,0,1,0,-1,-1,0,0,0,0,0,5.363009153751706392654341,0.00005},
	{0,0,1,0,-1,-1,0,0,1,0,-1,5.129227187368971208059065,0.00001},
	{0,0,1,0,-1,0,0,0,-6,-1,0,0.033089522755635293604914,0.00001},
	{0,0,1,0,-1,0,0,0,-6,0,0,0.008585274590560106403037,0.00003},
	{0,0,1,0,-1,0,0,0,-6,1,0,0.023642928179215986356221,0.00008},
	{0,0,1,0,-1,0,0,0,-6,2,0,0.118603849319274659568357,0.00009},
	{0,0,1,0,-1,0,0,0,-6,3,0,0.030177091832832358270222,0.00004},
	{0,0,1,0,-1,0,0,0,-5,1,0,0.036697292852432769616478,0.00001},
	{0,0,1,0,-1,0,0,0,-4,-2,0,0.018635578555244253218248,0.00005},
	{0,0,1,0,-1,0,0,0,-4,-1,0,6.282976042202271571568417,0.00028},
	{0,0,1,0,-1,0,0,0,-4,-1,2,0.030863529827641726643872,0.00001},
	{0,0,1,0,-1,0,0,0,-4,0,0,0.049680273559242996150864,0.00188},
	{0,0,1,0,-1,0,0,0,-4,0,2,0.031107701389995735113958,0.00005},
	{0,0,1,0,-1,0,0,0,-4,1,-2,3.171236023737365794517018,0.00002},
	{0,0,1,0,-1,0,0,0,-4,1,0,0.042292120302625801908647,0.00443},
	{0,0,1,0,-1,0,0,0,-4,1,2,0.037333988963560299501054,0.00002},
	{0,0,1,0,-1,0,0,0,-4,2,-2,3.170724467733605944630426,0.00001},
	{0,0,1,0,-1,0,0,0,-4,2,0,0.038215729301667840378531,0.00282},
	{0,0,1,0,-1,0,0,0,-4,3,0,0.028675236011491238297122,0.00007},
	{0,0,1,0,-1,0,0,0,-3,-2,0,0.032103237195333297893107,0.00001},
	{0,0,1,0,-1,0,0,0,-3,-1,0,0.029234963102605818902058,0.00004},
	{0,0,1,0,-1,0,0,0,-3,0,0,0.025837505180673656784984,0.00015},
	{0,0,1,0,-1,0,0,0,-3,1,0,3.209672886255261481380785,0.00009},
	{0,0,1,0,-1,0,0,0,-3,2,0,3.180859769232862621635149,0.00008},
	{0,0,1,0,-1,0,0,0,-2,-3,0,0.028487962182752242512596,0.00011},
	{0,0,1,0,-1,0,0,0,-2,-2,0,0.027917239517350096733583,0.00119},
	{0,0,1,0,-1,0,0,0,-2,-2,2,3.173339843617720035240382,0.00002},
	{0,0,1,0,-1,0,0,0,-2,-1,-2,3.170412228330424575517554,0.00007},
	{0,0,1,0,-1,0,0,0,-2,-1,0,0.034297465130940570088303,0.01455},
	{0,0,1,0,-1,0,0,0,-2,-1,2,3.169682680703090671414657,0.00035},
	{0,0,1,0,-1,0,0,0,-2,0,-2,3.170676296646250946764667,0.00040},
	{0,0,1,0,-1,0,0,0,-2,0,0,0.031464795754953769901796,0.16497},
	{0,0,1,0,-1,0,0,0,-2,0,2,0.031453276581890614316261,0.00228},
	{0,0,1,0,-1,0,0,0,-2,1,-2,3.171535173171157406812881,0.00045},
	{0,0,1,0,-1,0,0,0,-2,1,0,0.030426848448792745416291,0.21118},
	{0,0,1,0,-1,0,0,0,-2,1,2,3.170212562663996536116429,0.00006},
	{0,0,1,0,-1,0,0,0,-2,2,-2,3.168476832722887603921436,0.00003},
	{0,0,1,0,-1,0,0,0,-2,2,0,0.029828549581209087143696,0.00889},
	{0,0,1,0,-1,0,0,0,-2,2,2,3.171862247872981210861099,0.00005},
	{0,0,1,0,-1,0,0,0,-2,3,0,0.038144170802336077596983,0.00053},
	{0,0,1,0,-1,0,0,0,-2,4,0,0.038586786300641828795221,0.00004},
	{0,0,1,0,-1,0,0,0,-1,-2,0,0.011380070321778627123743,0.00008},
	{0,0,1,0,-1,0,0,0,-1,-1,0,0.009778905265999027554558,0.00080},
	{0,0,1,0,-1,0,0,0,-1,-1,1,4.850142058658070354226766,0.00004},
	{0,0,1,0,-1,0,0,0,-1,0,-2,3.153987632871606550111210,0.00003},
	{0,0,1,0,-1,0,0,0,-1,0,-1,4.792953727722598422644751,0.00001},
	{0,0,1,0,-1,0,0,0,-1,0,0,0.010840414517061981378165,0.00978},
	{0,0,1,0,-1,0,0,0,-1,0,1,1.687107686141676721192084,0.00008},
	{0,0,1,0,-1,0,0,0,-1,1,-1,4.810855046261528045192790,0.00003},
	{0,0,1,0,-1,0,0,0,-1,1,0,0.009047437776488205518621,0.00074},
	{0,0,1,0,-1,0,0,0,-1,1,1,1.623999547449290314915515,0.00001},
	{0,0,1,0,-1,0,0,0,-1,2,0,0.012804433524331198732127,0.00008},
	{0,0,1,0,-1,0,0,0,0,-4,0,0.016900197679986291715570,0.00004},
	{0,0,1,0,-1,0,0,0,0,-3,0,0.015581077831328978347547,0.00067},
	{0,0,1,0,-1,0,0,0,0,-2,-2,3.161922772315798546571841,0.00006},
	{0,0,1,0,-1,0,0,0,0,-2,0,0.021937916032942726685118,0.00943},
	{0,0,1,0,-1,0,0,0,0,-2,2,3.172161571839698268604479,0.00003},
	{0,0,1,0,-1,0,0,0,0,-1,-2,3.165226156991048256372778,0.00031},
	{0,0,1,0,-1,0,0,0,0,-1,0,0.021569127961996323317173,0.14347},
	{0,0,1,0,-1,0,0,0,0,-1,2,6.250663540029624876126491,0.00006},
	{0,0,1,0,-1,0,0,0,0,0,-2,3.198602786408636600157251,0.00008},
	{0,0,1,0,-1,0,0,0,0,0,0,0.021448351177758315927457,0.63880},
	{0,0,1,0,-1,0,0,0,0,0,2,3.162608163113056924942157,0.00032},
	{0,0,1,0,-1,0,0,0,0,1,-2,6.078319955843894284441831,0.00004},
	{0,0,1,0,-1,0,0,0,0,1,0,0.019402476228570563615561,0.10993},
	{0,0,1,0,-1,0,0,0,0,1,2,3.161865350983408262663943,0.00027},
	{0,0,1,0,-1,0,0,0,0,2,-2,3.196047798916642257438525,0.00002},
	{0,0,1,0,-1,0,0,0,0,2,0,0.018088068768893635074324,0.00766},
	{0,0,1,0,-1,0,0,0,0,2,2,3.157980422601394110415640,0.00004},
	{0,0,1,0,-1,0,0,0,0,3,0,0.019422896580818894973763,0.00055},
	{0,0,1,0,-1,0,0,0,0,4,0,0.018570477774144864696604,0.00004},
	{0,0,1,0,-1,0,0,0,1,-3,0,3.161448217292181617210645,0.00005},
	{0,0,1,0,-1,0,0,0,1,-2,-1,1.693098528799147350909493,0.00001},
	{0,0,1,0,-1,0,0,0,1,-2,0,3.156650481711374300886064,0.00049},
	{0,0,1,0,-1,0,0,0,1,-2,1,4.841352056946251813940307,0.00001},
	{0,0,1,0,-1,0,0,0,1,-1,-2,3.160209557122040990861933,0.00003},
	{0,0,1,0,-1,0,0,0,1,-1,-1,1.686736280076852390052977,0.00021},
	{0,0,1,0,-1,0,0,0,1,-1,0,0.012171228071707656387401,0.02338},
	{0,0,1,0,-1,0,0,0,1,-1,1,1.687298625161844922715204,0.00024},
	{0,0,1,0,-1,0,0,0,1,-1,2,3.160209557122040990861933,0.00003},
	{0,0,1,0,-1,0,0,0,1,0,-2,3.154409129885963114503511,0.00011},
	{0,0,1,0,-1,0,0,0,1,0,-1,1.689315702178374678510409,0.00160},
	{0,0,1,0,-1,0,0,0,1,0,0,3.153969306914460535296030,0.06711},
	{0,0,1,0,-1,0,0,0,1,0,1,4.831933562170789286938088,0.00035},
	{0,0,1,0,-1,0,0,0,1,0,2,0.012395153814738529146622,0.00014},
	{0,0,1,0,-1,0,0,0,1,1,-1,1.686736280076852390052977,0.00021},
	{0,0,1,0,-1,0,0,0,1,1,0,3.154009100421406142089609,0.00460},
	{0,0,1,0,-1,0,0,0,1,1,1,4.831253058295436275670909,0.00004},
	{0,0,1,0,-1,0,0,0,1,1,2,0.012395153814738529146622,0.00002},
	{0,0,1,0,-1,0,0,0,1,2,-2,3.149639843171963438095418,0.00001},
	{0,0,1,0,-1,0,0,0,1,2,0,3.153954995214594436703237,0.00033},
	{0,0,1,0,-1,0,0,0,1,3,0,3.153987807404531995558727,0.00002},
	{0,0,1,0,-1,0,0,0,2,-4,0,3.183116654488616248386279,0.00001},
	{0,0,1,0,-1,0,0,0,2,-3,0,3.179426853916975215241791,0.00008},
	{0,0,1,0,-1,0,0,0,2,-2,0,3.136207440182764649705405,0.00083},
	{0,0,1,0,-1,0,0,0,2,-1,-2,0.028437347634444408439602,0.00003},
	{0,0,1,0,-1,0,0,0,2,-1,0,0.010108947027551157607506,0.05108},
	{0,0,1,0,-1,0,0,0,2,-1,2,3.155848502920082676581615,0.00011},
	{0,0,1,0,-1,0,0,0,2,0,-2,0.005431115566355954570044,0.00162},
	{0,0,1,0,-1,0,0,0,2,0,0,0.007574030821954592755663,0.03111},
	{0,0,1,0,-1,0,0,0,2,0,2,3.168056731971932826752436,0.00005},
	{0,0,1,0,-1,0,0,0,2,1,-2,3.127680634122146585696100,0.00008},
	{0,0,1,0,-1,0,0,0,2,1,0,0.007456744696220573773160,0.00346},
	{0,0,1,0,-1,0,0,0,2,2,0,0.024924697981880621078243,0.00031},
	{0,0,1,0,-1,0,0,0,2,3,0,0.011440982312673228168953,0.00003},
	{0,0,1,0,-1,0,0,0,3,-3,0,0.012869010706654989903419,0.00003},
	{0,0,1,0,-1,0,0,0,3,-2,0,0.012989438425042599059567,0.00061},
	{0,0,1,0,-1,0,0,0,3,-1,0,3.153653925918625144930729,0.00066},
	{0,0,1,0,-1,0,0,0,3,0,0,3.154602337834158554130681,0.00060},
	{0,0,1,0,-1,0,0,0,3,1,0,3.153987109272831101947077,0.00009},
	{0,0,1,0,-1,0,0,0,4,-3,0,3.166541088049501073697911,0.00002},
	{0,0,1,0,-1,0,0,0,4,-2,0,0.022961551639237402777649,0.00069},
	{0,0,1,0,-1,0,0,0,4,-1,-2,0.003869744017521827353367,0.00003},
	{0,0,1,0,-1,0,0,0,4,-1,0,6.279190073988845988139929,0.00093},
	{0,0,1,0,-1,0,0,0,4,0,-2,0.004950626423281916099750,0.00002},
	{0,0,1,0,-1,0,0,0,4,0,0,0.028694783699113574071404,0.00037},
	{0,0,1,0,-1,0,0,0,4,1,0,0.011041301913966527353805,0.00008},
	{0,0,1,0,-1,0,0,0,5,-1,0,3.153972099441264109742633,0.00002},
	{0,0,1,0,-1,0,0,0,6,-2,0,0.014172248059119155888519,0.00002},
	{0,0,1,0,-1,1,0,0,-2,0,0,3.934988264685729930647540,0.00004},
	{0,0,1,0,-1,1,0,0,-2,1,0,3.934988264685729930647540,0.00004},
	{0,0,1,0,-1,1,0,0,0,-1,0,3.832355748818530027932638,0.00001},
	{0,0,1,0,-1,1,0,0,0,0,0,3.606791490685885559486223,0.00009},
	{0,0,1,0,-1,1,0,0,0,1,0,3.832355748818530027932638,0.00001},
	{0,0,1,0,-1,1,0,0,1,0,-1,4.857897254656382557413963,0.00001},
	{0,0,1,0,-1,2,0,0,-2,0,0,0.870695371002139562044420,0.00003},
	{0,0,1,0,-1,2,0,0,-2,1,0,0.840622998924426823030842,0.00004},
	{0,0,1,0,-1,2,0,0,0,-1,0,0.639079183688204488511531,0.00001},
	{0,0,1,0,-1,2,0,0,0,0,0,0.257859307012772265288447,0.00007},
	{0,0,1,0,-1,2,0,0,0,1,0,0.639079183688204488511531,0.00001},
	{0,0,1,0,-1,3,0,0,0,0,0,3.306359763492617176439126,0.00002},
	{0,0,1,0,-1,4,0,0,1,0,-1,0.764352459678125040198893,0.00003},
	{0,0,1,0,-1,5,0,0,-2,0,0,4.100378457131515830269564,0.00001},
	{0,0,1,0,-1,5,0,0,0,0,0,3.888479952509061199350526,0.00002},
	{0,0,1,0,-1,5,0,0,1,0,-1,1.846017122008957178636024,0.00004},
	{0,0,1,0,0,-5,0,0,-2,-1,0,5.495151173012851053556460,0.00003},
	{0,0,1,0,0,-5,0,0,-2,0,0,5.489970163128305991051548,0.00018},
	{0,0,1,0,0,-5,0,0,-2,1,0,5.495436534345552459512874,0.00025},
	{0,0,1,0,0,-5,0,0,0,-1,0,5.440346089170977172955190,0.00023},
	{0,0,1,0,0,-5,0,0,0,0,0,5.369952597114915349152398,0.00093},
	{0,0,1,0,0,-5,0,0,0,1,0,5.419016420382353871332271,0.00017},
	{0,0,1,0,0,-5,0,0,0,2,0,5.452938116125340961559687,0.00001},
	{0,0,1,0,0,-5,0,0,1,-1,1,1.907101551433656450029730,0.00002},
	{0,0,1,0,0,-5,0,0,1,0,-1,1.905001396744731456678323,0.00007},
	{0,0,1,0,0,-5,0,0,1,0,0,5.409957987031578596770487,0.00003},
	{0,0,1,0,0,-5,0,0,2,-3,0,3.462685413935244760352816,0.00001},
	{0,0,1,0,0,-5,0,0,2,-1,0,5.209755457325513816613238,0.00011},
	{0,0,1,0,0,-5,0,0,2,0,0,5.468273975196764169481867,0.00004},
	{0,0,1,0,0,-4,0,0,-2,0,0,1.898571254714533917962171,0.00004},
	{0,0,1,0,0,-4,0,0,-2,1,0,1.903186254322657422477505,0.00005},
	{0,0,1,0,0,-4,0,0,0,-1,0,1.927840426270479134984726,0.00004},
	{0,0,1,0,0,-4,0,0,0,0,0,1.977029215112360294170912,0.00019},
	{0,0,1,0,0,-4,0,0,0,1,0,1.927840426270479134984726,0.00004},
	{0,0,1,0,0,-4,0,0,1,-1,0,1.926590595993125765161835,0.00001},
	{0,0,1,0,0,-4,0,0,1,0,-1,5.222684681891363034367259,0.00003},
	{0,0,1,0,0,-4,0,0,2,-1,0,1.898329875678983258424637,0.00002},
	{0,0,1,0,0,-3,0,0,-4,1,0,0.293788480461402323751230,0.00001},
	{0,0,1,0,0,-3,0,0,-2,-1,0,0.291217959539065041063566,0.00004},
	{0,0,1,0,0,-3,0,0,-2,0,0,0.288143212995826625277829,0.00038},
	{0,0,1,0,0,-3,0,0,-2,1,0,0.297325215657643582289893,0.00046},
	{0,0,1,0,0,-3,0,0,-2,2,0,0.297503762840122643051899,0.00001},
	{0,0,1,0,0,-3,0,0,-1,0,0,0.296961838107378361950595,0.00008},
	{0,0,1,0,0,-3,0,0,-1,0,1,3.604938474619043375923866,0.00004},
	{0,0,1,0,0,-3,0,0,0,-2,0,0.295466090938419245759405,0.00002},
	{0,0,1,0,0,-3,0,0,0,-1,0,0.293914144167545854369195,0.00037},
	{0,0,1,0,0,-3,0,0,0,0,0,0.288807310776210524050356,0.00172},
	{0,0,1,0,0,-3,0,0,0,1,0,0.292654540046381583806578,0.00027},
	{0,0,1,0,0,-3,0,0,0,2,0,0.295517403618427876299535,0.00002},
	{0,0,1,0,0,-3,0,0,1,-1,-1,3.604640023316952213150444,0.00005},
	{0,0,1,0,0,-3,0,0,1,-1,0,0.296252710832293097986678,0.00045},
	{0,0,1,0,0,-3,0,0,1,-1,1,3.604640895981578108120402,0.00007},
	{0,0,1,0,0,-3,0,0,1,0,-1,3.604472122642909948098122,0.00037},
	{0,0,1,0,0,-3,0,0,1,0,0,3.438601964652825859758423,0.00037},
	{0,0,1,0,0,-3,0,0,1,0,1,0.462909837782101651892930,0.00008},
	{0,0,1,0,0,-3,0,0,1,1,-1,3.604640023316952213150444,0.00005},
	{0,0,1,0,0,-3,0,0,1,1,0,3.438554666230096756862622,0.00003},
	{0,0,1,0,0,-3,0,0,2,-1,0,0.293116528699384482070656,0.00013},
	{0,0,1,0,0,-3,0,0,2,0,0,0.295738013235879948492624,0.00007},
	{0,0,1,0,0,-2,0,0,-4,0,0,4.990773533933841044074597,0.00003},
	{0,0,1,0,0,-2,0,0,-4,1,0,4.988536894497410223436873,0.00007},
	{0,0,1,0,0,-2,0,0,-4,2,0,4.990712971008796294825061,0.00005},
	{0,0,1,0,0,-2,0,0,-2,-2,0,4.991743238866249043894641,0.00003},
	{0,0,1,0,0,-2,0,0,-2,-1,0,4.986084183299581695791858,0.00021},
	{0,0,1,0,0,-2,0,0,-2,0,0,4.986696270268256903079873,0.00245},
	{0,0,1,0,0,-2,0,0,-2,0,2,4.996480411522012055058894,0.00004},
	{0,0,1,0,0,-2,0,0,-2,1,0,4.991408135649866295580068,0.00312},
	{0,0,1,0,0,-2,0,0,-2,2,0,4.998766967375049219413086,0.00014},
	{0,0,1,0,0,-2,0,0,-1,-1,1,5.129910309238202792414540,0.00005},
	{0,0,1,0,0,-2,0,0,-1,0,-1,5.129905247783371535774677,0.00002},
	{0,0,1,0,0,-2,0,0,-1,0,0,4.996879393789017242966111,0.00008},
	{0,0,1,0,0,-2,0,0,-1,0,1,1.988315561253306773537020,0.00018},
	{0,0,1,0,0,-2,0,0,-1,1,-1,5.129908214843100111579588,0.00006},
	{0,0,1,0,0,-2,0,0,-1,1,1,1.988317132049633562118629,0.00004},
	{0,0,1,0,0,-2,0,0,0,-2,0,4.984917081628773338763949,0.00017},
	{0,0,1,0,0,-2,0,0,0,-1,0,4.985654657770666631222412,0.00245},
	{0,0,1,0,0,-2,0,0,0,0,0,4.983892398824927738587576,0.01096},
	{0,0,1,0,0,-2,0,0,0,1,0,4.986278438445328475836504,0.00186},
	{0,0,1,0,0,-2,0,0,0,2,0,4.985240491139167673395605,0.00012},
	{0,0,1,0,0,-2,0,0,0,3,0,1.849644788859227340083180,0.00001},
	{0,0,1,0,0,-2,0,0,1,-2,-1,1.988316957516708338715716,0.00003},
	{0,0,1,0,0,-2,0,0,1,-2,0,1.928879595307116501246014,0.00001},
	{0,0,1,0,0,-2,0,0,1,-2,1,5.129912054567454582354458,0.00002},
	{0,0,1,0,0,-2,0,0,1,-1,-1,1.988316957516708338715716,0.00039},
	{0,0,1,0,0,-2,0,0,1,-1,0,4.990416265035957366080765,0.00010},
	{0,0,1,0,0,-2,0,0,1,-1,1,1.988317306582559007566147,0.00038},
	{0,0,1,0,0,-2,0,0,1,0,-1,1.988317830181334455730280,0.00307},
	{0,0,1,0,0,-2,0,0,1,0,0,1.854812185175606975562346,0.00066},
	{0,0,1,0,0,-2,0,0,1,0,1,5.129910483771127793772848,0.00073},
	{0,0,1,0,0,-2,0,0,1,1,-1,1.988316957516708338715716,0.00039},
	{0,0,1,0,0,-2,0,0,1,1,0,1.854812534241457422368171,0.00004},
	{0,0,1,0,0,-2,0,0,1,1,1,5.129910309238202792414540,0.00008},
	{0,0,1,0,0,-2,0,0,1,2,-1,1.988316957516708338715716,0.00003},
	{0,0,1,0,0,-2,0,0,2,-2,0,1.875626807301966403329629,0.00002},
	{0,0,1,0,0,-2,0,0,2,-1,0,5.003706772756968845783376,0.00062},
	{0,0,1,0,0,-2,0,0,2,0,-2,4.998740961969194707137376,0.00002},
	{0,0,1,0,0,-2,0,0,2,0,0,4.996015281276354969008935,0.00042},
	{0,0,1,0,0,-2,0,0,2,1,0,4.992927095697876183066910,0.00006},
	{0,0,1,0,0,-2,0,0,3,-1,-1,5.129907865777250108862972,0.00003},
	{0,0,1,0,0,-2,0,0,3,-1,1,5.129910309238202792414540,0.00002},
	{0,0,1,0,0,-2,0,0,4,-2,0,4.941311950129872343495663,0.00001},
	{0,0,1,0,0,-2,0,0,4,-1,0,5.000362896443072635577209,0.00001},
	{0,0,1,0,0,-1,0,0,-4,-2,0,0.012604069726202250106839,0.00001},
	{0,0,1,0,0,-1,0,0,-4,0,0,0.003853861521328679103082,0.00012},
	{0,0,1,0,0,-1,0,0,-4,1,0,0.011677474426318461622754,0.00027},
	{0,0,1,0,0,-1,0,0,-4,2,0,0.012231616463826660082259,0.00013},
	{0,0,1,0,0,-1,0,0,-3,0,0,0.014737909269690516872453,0.00002},
	{0,0,1,0,0,-1,0,0,-2,-2,0,0.011953585513983963975471,0.00009},
	{0,0,1,0,0,-1,0,0,-2,-1,0,0.011238873185292284906378,0.00085},
	{0,0,1,0,0,-1,0,0,-2,-1,2,3.153763358062725341568466,0.00002},
	{0,0,1,0,0,-1,0,0,-2,0,-2,3.153138704723436713805995,0.00002},
	{0,0,1,0,0,-1,0,0,-2,0,0,0.012654684274510085914556,0.00959},
	{0,0,1,0,0,-1,0,0,-2,0,2,0.012435819986309997950413,0.00014},
	{0,0,1,0,0,-1,0,0,-2,1,0,0.011954109112759561325823,0.01211},
	{0,0,1,0,0,-1,0,0,-2,1,2,3.153763358062725341568466,0.00002},
	{0,0,1,0,0,-1,0,0,-2,2,0,0.013180202912285578914497,0.00053},
	{0,0,1,0,0,-1,0,0,-2,3,0,0.014159681688504795193939,0.00003},
	{0,0,1,0,0,-1,0,0,-1,-1,0,0.005174552166312788858971,0.00002},
	{0,0,1,0,0,-1,0,0,-1,0,0,6.257118465735200807387173,0.00004},
	{0,0,1,0,0,-1,0,0,-1,0,1,2.955917546445628651952120,0.00003},
	{0,0,1,0,0,-1,0,0,0,-3,0,0.007818900516009396825523,0.00003},
	{0,0,1,0,0,-1,0,0,0,-2,0,0.008450360639380944532961,0.00058},
	{0,0,1,0,0,-1,0,0,0,-1,-2,3.149554147505690515629340,0.00003},
	{0,0,1,0,0,-1,0,0,0,-1,0,0.007993433441208829329239,0.00863},
	{0,0,1,0,0,-1,0,0,0,-1,2,0.008108974237690854541816,0.00001},
	{0,0,1,0,0,-1,0,0,0,0,-2,3.150784081029571304100045,0.00003},
	{0,0,1,0,0,-1,0,0,0,0,0,0.007556577529434648984874,0.03897},
	{0,0,1,0,0,-1,0,0,0,0,2,3.152057822317676727408298,0.00002},
	{0,0,1,0,0,-1,0,0,0,1,-2,0.008108974237690854541816,0.00001},
	{0,0,1,0,0,-1,0,0,0,1,0,0.007064569213297447990152,0.00654},
	{0,0,1,0,0,-1,0,0,0,1,2,3.149554147505690515629340,0.00003},
	{0,0,1,0,0,-1,0,0,0,2,0,0.007165100178212321403726,0.00044},
	{0,0,1,0,0,-1,0,0,0,3,0,0.005007000558121333169681,0.00003},
	{0,0,1,0,0,-1,0,0,1,-2,0,3.174519511659142700921166,0.00002},
	{0,0,1,0,0,-1,0,0,1,-1,-1,2.968919725774210593982616,0.00008},
	{0,0,1,0,0,-1,0,0,1,-1,0,3.166810566886009148390713,0.00001},
	{0,0,1,0,0,-1,0,0,1,-1,1,2.969870406617772129465038,0.00006},
	{0,0,1,0,0,-1,0,0,1,0,-1,2.969264428301479519234363,0.00066},
	{0,0,1,0,0,-1,0,0,1,0,0,3.147049076430303404805500,0.00154},
	{0,0,1,0,0,-1,0,0,1,0,1,6.110801231355208251727618,0.00020},
	{0,0,1,0,0,-1,0,0,1,1,-1,2.968919725774210593982616,0.00008},
	{0,0,1,0,0,-1,0,0,1,1,0,3.147149083796442425864370,0.00011},
	{0,0,1,0,0,-1,0,0,1,1,1,6.110801231355208251727618,0.00002},
	{0,0,1,0,0,-1,0,0,2,-2,0,3.141523014952638970243015,0.00011},
	{0,0,1,0,0,-1,0,0,2,-1,0,0.003179117232507671503283,0.00225},
	{0,0,1,0,0,-1,0,0,2,0,-2,0.003977256299444678448729,0.00009},
	{0,0,1,0,0,-1,0,0,2,0,0,0.002519731841104213502375,0.00164},
	{0,0,1,0,0,-1,0,0,2,1,0,0.007162482184334330315156,0.00020},
	{0,0,1,0,0,-1,0,0,3,-1,0,3.146767205756106022818130,0.00002},
	{0,0,1,0,0,-1,0,0,4,-2,0,0.004732983865558222820458,0.00002},
	{0,0,1,0,0,-1,0,0,4,-1,0,0.007743851358173640432592,0.00003},
	{0,0,1,0,0,-1,0,0,4,0,0,0.002565634000431664483305,0.00002},
	{0,0,1,0,0,0,-3,0,-2,0,0,1.621333033418093094724100,0.00002},
	{0,0,1,0,0,0,-3,0,0,0,0,1.622309545134584141123923,0.00007},
	{0,0,1,0,0,0,-3,2,0,0,0,1.757637837478169151594898,0.00001},
	{0,0,1,0,0,0,-2,0,-2,-1,0,4.834540211408642207402409,0.00002},
	{0,0,1,0,0,0,-2,0,-2,0,0,4.834536197151362735269231,0.00013},
	{0,0,1,0,0,0,-2,0,-2,1,0,4.834497276309043911624030,0.00018},
	{0,0,1,0,0,0,-2,0,0,-1,0,4.834794854946509623516704,0.00015},
	{0,0,1,0,0,0,-2,0,0,0,0,4.834560806293816348500059,0.00068},
	{0,0,1,0,0,0,-2,0,0,1,0,4.834897829372376776291276,0.00011},
	{0,0,1,0,0,0,-2,0,1,0,-1,1.292851247151398208501405,0.00004},
	{0,0,1,0,0,0,-2,0,1,0,1,4.434446867800919456215070,0.00002},
	{0,0,1,0,0,0,-2,0,2,-1,0,4.820304782430601342468890,0.00002},
	{0,0,1,0,0,0,-2,0,2,0,0,4.831528296718476944704435,0.00002},
	{0,0,1,0,0,0,-1,-2,0,0,0,4.766262058405998480736798,0.00001},
	{0,0,1,0,0,0,-1,0,-2,-1,0,6.172259335772760202587506,0.00004},
	{0,0,1,0,0,0,-1,0,-2,0,0,6.173707260920214601185307,0.00023},
	{0,0,1,0,0,0,-1,0,-2,1,0,6.171012472555134742435712,0.00031},
	{0,0,1,0,0,0,-1,0,0,-1,0,6.194952106707190431222898,0.00025},
	{0,0,1,0,0,0,-1,0,0,0,0,6.214614462461383048719199,0.00104},
	{0,0,1,0,0,0,-1,0,0,1,0,6.204052951558788997488136,0.00017},
	{0,0,1,0,0,0,-1,0,0,2,0,6.190836969396837474732820,0.00001},
	{0,0,1,0,0,0,-1,0,1,0,0,3.083012946174631174756087,0.00002},
	{0,0,1,0,0,0,-1,0,2,-1,0,0.126915107217271672102044,0.00004},
	{0,0,1,0,0,0,-1,0,2,0,0,6.256099717050811470642202,0.00004},
	{0,0,1,0,0,0,0,-2,-2,0,0,4.949657241948282937471504,0.00009},
	{0,0,1,0,0,0,0,-2,-2,1,0,4.949665794061618662169622,0.00012},
	{0,0,1,0,0,0,0,-2,0,-1,0,4.949521106266628223124826,0.00010},
	{0,0,1,0,0,0,0,-2,0,0,0,4.949285137751758156809956,0.00042},
	{0,0,1,0,0,0,0,-2,0,1,0,4.949504874704583556876969,0.00009},
	{0,0,1,0,0,0,0,-2,1,0,-1,2.300084598201680208262587,0.00006},
	{0,0,1,0,0,0,0,-2,1,0,1,5.441677077258547434723823,0.00003},
	{0,0,1,0,0,0,0,-2,2,-1,0,4.948564840369460426927617,0.00001},
	{0,0,1,0,0,0,0,-2,2,0,0,4.949206423402493726371176,0.00001},
	{0,0,1,0,0,0,0,-1,-2,0,0,0.029664663164446821580489,0.00009},
	{0,0,1,0,0,0,0,-1,-2,1,0,0.029952118892250287340850,0.00011},
	{0,0,1,0,0,0,0,-1,0,-1,0,0.024059363738741835342383,0.00009},
	{0,0,1,0,0,0,0,-1,0,0,0,0.015342665855506552874399,0.00041},
	{0,0,1,0,0,0,0,-1,0,1,0,0.024059363738741835342383,0.00009},
	{0,0,1,0,0,0,0,-1,2,-1,0,6.251815631868866240949956,0.00001},
	{0,0,1,0,0,0,0,-1,2,0,0,0.006076538323743458508419,0.00002},
	{0,0,1,0,0,0,0,0,-4,0,0,1.261526950401229862919195,0.00012},
	{0,0,1,0,0,0,0,0,-4,1,0,1.168217808865258389161568,0.00012},
	{0,0,1,0,0,0,0,0,-4,2,0,1.187936887820141063087931,0.00007},
	{0,0,1,0,0,0,0,0,-2,-2,0,1.052392872781009236504701,0.00003},
	{0,0,1,0,0,0,0,0,-2,-1,0,1.185870417985779523561973,0.00030},
	{0,0,1,0,0,0,0,0,-2,0,0,1.128017814736998358782216,0.00309},
	{0,0,1,0,0,0,0,0,-2,0,1,1.803739837004973534106966,0.00002},
	{0,0,1,0,0,0,0,0,-2,0,2,1.081593801963201206817189,0.00004},
	{0,0,1,0,0,0,0,0,-2,1,0,1.102276477198109727595465,0.00390},
	{0,0,1,0,0,0,0,0,-2,2,0,1.057065642787373693778363,0.00019},
	{0,0,1,0,0,0,0,0,-2,3,0,1.562341777365310990788316,0.00004},
	{0,0,1,0,0,0,0,0,-1,-2,1,1.962121310773525806325779,0.00001},
	{0,0,1,0,0,0,0,0,-1,-1,-1,1.660396469137454644737772,0.00002},
	{0,0,1,0,0,0,0,0,-1,-1,0,1.481475088066807277442649,0.00002},
	{0,0,1,0,0,0,0,0,-1,-1,1,4.858872195576546815232177,0.00010},
	{0,0,1,0,0,0,0,0,-1,0,-1,1.600793300648923001006096,0.00022},
	{0,0,1,0,0,0,0,0,-1,0,0,1.901035659618349971111684,0.00004},
	{0,0,1,0,0,0,0,0,-1,0,1,4.880514627367126045953682,0.00112},
	{0,0,1,0,0,0,0,0,-1,1,-1,1.599471562806388025279603,0.00044},
	{0,0,1,0,0,0,0,0,-1,1,1,5.016608421120636762680078,0.00021},
	{0,0,1,0,0,0,0,0,-1,2,-1,1.551670659785692185650419,0.00003},
	{0,0,1,0,0,0,0,0,-1,2,1,5.450263049980808460759363,0.00003},
	{0,0,1,0,0,0,0,0,0,-3,0,1.599460043633324612954993,0.00001},
	{0,0,1,0,0,0,0,0,0,-2,0,1.576882988028301735283776,0.00025},
	{0,0,1,0,0,0,0,0,0,-1,0,1.575994091840260846737465,0.00355},
	{0,0,1,0,0,0,0,0,0,0,-1,4.909412043792396040942094,0.00010},
	{0,0,1,0,0,0,0,0,0,0,0,1.664763806524720113344529,0.01699},
	{0,0,1,0,0,0,0,0,0,0,1,1.803829372395600705303309,0.00008},
	{0,0,1,0,0,0,0,0,0,1,-1,4.945413997470835099079522,0.00001},
	{0,0,1,0,0,0,0,0,0,1,0,1.543032327185871466213030,0.00267},
	{0,0,1,0,0,0,0,0,0,2,0,1.568231739992016038343081,0.00019},
	{0,0,1,0,0,0,0,0,1,-2,-1,4.819325478187307609800882,0.00007},
	{0,0,1,0,0,0,0,0,1,-1,-1,4.789659942358234445691778,0.00091},
	{0,0,1,0,0,0,0,0,1,-1,0,4.576151196967890300015824,0.00008},
	{0,0,1,0,0,0,0,0,1,-1,1,5.030061942593784252153455,0.00085},
	{0,0,1,0,0,0,0,0,1,0,-1,5.218174052972508469849799,0.00456},
	{0,0,1,0,0,0,0,0,1,0,0,4.625041534507681184607009,0.00116},
	{0,0,1,0,0,0,0,0,1,0,1,1.959934238687851326687905,0.00625},
	{0,0,1,0,0,0,0,0,1,1,-1,4.784786459487891718822539,0.00100},
	{0,0,1,0,0,0,0,0,1,1,0,4.621685091823169777569547,0.00008},
	{0,0,1,0,0,0,0,0,1,1,1,1.953460987025129824701253,0.00070},
	{0,0,1,0,0,0,0,0,1,2,-1,4.737475295855305468251117,0.00006},
	{0,0,1,0,0,0,0,0,1,2,1,1.907433687590310844583996,0.00007},
	{0,0,1,0,0,0,0,0,2,-3,0,5.126601164976421820540509,0.00002},
	{0,0,1,0,0,0,0,0,2,-2,0,5.289295870925426967801286,0.00020},
	{0,0,1,0,0,0,0,0,2,-1,0,0.280326930473695223877684,0.00242},
	{0,0,1,0,0,0,0,0,2,0,-2,0.918325057223214336055150,0.00004},
	{0,0,1,0,0,0,0,0,2,0,-1,1.742492568361063032256197,0.00006},
	{0,0,1,0,0,0,0,0,2,0,0,0.792987378583895230477196,0.00093},
	{0,0,1,0,0,0,0,0,2,1,0,1.007662178447496836852793,0.00012},
	{0,0,1,0,0,0,0,0,3,-3,-1,1.345004303194866412951569,0.00002},
	{0,0,1,0,0,0,0,0,3,-2,-1,1.496258550429974576445602,0.00001},
	{0,0,1,0,0,0,0,0,3,-2,1,5.049187784135913403815721,0.00002},
	{0,0,1,0,0,0,0,0,3,-1,-1,1.686031167059046653733390,0.00022},
	{0,0,1,0,0,0,0,0,3,-1,0,4.623067741656600837529822,0.00002},
	{0,0,1,0,0,0,0,0,3,-1,1,1.954092098082650830193074,0.00014},
	{0,0,1,0,0,0,0,0,3,0,-1,1.944955997580161355386963,0.00021},
	{0,0,1,0,0,0,0,0,3,0,1,1.954091923549725606790162,0.00009},
	{0,0,1,0,0,0,0,0,3,1,-1,1.954139571038305156491788,0.00003},
	{0,0,1,0,0,0,0,0,4,-2,0,0.622526830128140695741479,0.00004},
	{0,0,1,0,0,0,0,0,4,-1,0,0.099628280625741916232130,0.00003},
	{0,0,1,0,0,0,0,0,4,0,0,6.181109725876697602586773,0.00002},
	{0,0,1,0,0,0,1,-2,-2,0,0,2.858698518319339409998747,0.00002},
	{0,0,1,0,0,0,1,-2,0,0,0,3.086343383453286737250210,0.00006},
	{0,0,1,0,0,0,1,0,-2,0,0,1.461695620719805965848082,0.00003},
	{0,0,1,0,0,0,1,0,0,-1,0,1.473495268193763862996093,0.00001},
	{0,0,1,0,0,0,1,0,0,0,0,1.518025249663296882829400,0.00004},
	{0,0,1,0,0,0,1,0,0,1,0,1.473495268193763862996093,0.00001},
	{0,0,1,0,0,1,-3,0,-2,0,0,0.431642438765548419610241,0.00002},
	{0,0,1,0,0,1,-3,0,0,0,0,0.406898207828324032231393,0.00003},
	{0,0,1,0,0,1,0,0,-4,1,0,2.891795895056608944884147,0.00001},
	{0,0,1,0,0,1,0,0,-2,-1,0,2.892370631979290340751731,0.00004},
	{0,0,1,0,0,1,0,0,-2,0,0,2.886107168892658503267512,0.00044},
	{0,0,1,0,0,1,0,0,-2,1,0,2.908150677345346934998815,0.00047},
	{0,0,1,0,0,1,0,0,-2,2,0,2.891191836602493570040906,0.00003},
	{0,0,1,0,0,1,0,0,-1,0,-1,5.835639951868640373788821,0.00004},
	{0,0,1,0,0,1,0,0,-1,0,1,5.845195629523310287822824,0.00004},
	{0,0,1,0,0,1,0,0,-1,1,-1,2.689078345898420430160058,0.00010},
	{0,0,1,0,0,1,0,0,-1,2,-1,2.690334808426931179070607,0.00001},
	{0,0,1,0,0,1,0,0,0,-1,0,2.872905323897648077746680,0.00022},
	{0,0,1,0,0,1,0,0,0,0,0,2.916120548841653725702372,0.00066},
	{0,0,1,0,0,1,0,0,0,1,0,2.992239418975957132573740,0.00006},
	{0,0,1,0,0,1,0,0,1,-2,-1,5.832571663043634835332796,0.00007},
	{0,0,1,0,0,1,0,0,1,-1,-1,5.832571663043634835332796,0.00099},
	{0,0,1,0,0,1,0,0,1,-1,1,5.834606367885609934376134,0.00002},
	{0,0,1,0,0,1,0,0,1,0,-1,5.834222395450171738673362,0.00507},
	{0,0,1,0,0,1,0,0,1,0,1,5.832681967852360926940491,0.00057},
	{0,0,1,0,0,1,0,0,1,1,-1,5.832571663043634835332796,0.00099},
	{0,0,1,0,0,1,0,0,1,1,1,5.832708671389917221006272,0.00006},
	{0,0,1,0,0,1,0,0,1,2,-1,5.832571663043634835332796,0.00007},
	{0,0,1,0,0,1,0,0,2,-1,0,6.091195075202930908631060,0.00002},
	{0,0,1,0,0,1,0,0,2,0,0,6.080226553518772725226427,0.00002},
	{0,0,1,0,0,1,0,0,3,-2,-1,2.690334808426931179070607,0.00001},
	{0,0,1,0,0,1,0,0,3,-1,-1,2.688579181732349887568034,0.00007},
	{0,0,1,0,0,1,0,0,3,0,-1,5.833612053810749209503683,0.00008},
	{0,0,1,0,0,2,0,0,-2,0,0,1.105316491689233293627126,0.00003},
	{0,0,1,0,0,2,0,0,-2,1,0,1.106763020573286127046231,0.00002},
	{0,0,1,0,0,2,0,0,-1,0,-1,4.124054546566519263706141,0.00001},
	{0,0,1,0,0,2,0,0,-1,1,-1,1.002740873555648670745200,0.00001},
	{0,0,1,0,0,2,0,0,0,0,0,1.153575718171502506592674,0.00004},
	{0,0,1,0,0,2,0,0,1,-1,-1,4.131706244540188421865423,0.00017},
	{0,0,1,0,0,2,0,0,1,0,-1,4.124054546566519263706141,0.00095},
	{0,0,1,0,0,2,0,0,1,0,1,0.970232545440927296453992,0.00003},
	{0,0,1,0,0,2,0,0,1,1,-1,4.131706244540188421865423,0.00017},
	{0,0,1,0,0,2,0,0,3,-1,-1,1.002740873555648670745200,0.00001},
	{0,0,1,0,0,2,0,0,3,0,-1,4.124054546566519263706141,0.00001},
	{0,0,1,0,0,3,0,0,1,0,-1,2.437392617515802495375965,0.00001},
	{0,0,1,0,1,-6,3,0,0,0,0,3.357886595400469964545209,0.00002},
	{0,0,1,0,1,-5,0,0,-4,1,0,0.203645191655623586379775,0.00002},
	{0,0,1,0,1,-5,0,0,-2,-1,0,0.204097580997740501995708,0.00005},
	{0,0,1,0,1,-5,0,0,-2,0,0,0.204295501334916668190189,0.00045},
	{0,0,1,0,1,-5,0,0,-2,1,0,0.202829599296166618316306,0.00061},
	{0,0,1,0,1,-5,0,0,-2,2,0,0.203822342574700998696358,0.00002},
	{0,0,1,0,1,-5,0,0,-1,0,0,0.195609695779441677965238,0.00004},
	{0,0,1,0,1,-5,0,0,0,-2,0,0.208242912504152249963951,0.00002},
	{0,0,1,0,1,-5,0,0,0,-1,0,0.206477337432834778807589,0.00041},
	{0,0,1,0,1,-5,0,0,0,0,0,0.195104597493914511119328,0.00182},
	{0,0,1,0,1,-5,0,0,0,1,0,0.204993982101564803377514,0.00029},
	{0,0,1,0,1,-5,0,0,0,2,0,0.208752723178659754799114,0.00002},
	{0,0,1,0,1,-5,0,0,1,-1,0,0.190519792081850602993853,0.00007},
	{0,0,1,0,1,-5,0,0,1,0,0,3.337202698435085324035754,0.00019},
	{0,0,1,0,1,-5,0,0,2,-3,0,3.312458816563711216929278,0.00001},
	{0,0,1,0,1,-5,0,0,2,-1,0,0.153362430438592128867370,0.00012},
	{0,0,1,0,1,-5,0,0,2,0,0,0.181220852360150036508557,0.00007},
	{0,0,1,0,1,-4,0,0,-2,0,0,4.181982722571912169939878,0.00002},
	{0,0,1,0,1,-4,0,0,0,0,0,4.181912036737206683767454,0.00003},
	{0,0,1,0,1,-3,0,0,-2,-1,0,5.391335847511574463908346,0.00002},
	{0,0,1,0,1,-3,0,0,-2,0,0,5.391335847511574463908346,0.00009},
	{0,0,1,0,1,-3,0,0,-2,1,0,5.391445105122749659187775,0.00012},
	{0,0,1,0,1,-3,0,0,0,-1,0,5.382117367468390867202288,0.00009},
	{0,0,1,0,1,-3,0,0,0,0,0,5.354988144108316028280115,0.00040},
	{0,0,1,0,1,-3,0,0,0,1,0,5.378276421383526795239050,0.00007},
	{0,0,1,0,1,-3,0,0,1,0,-1,2.385106392850406820116405,0.00001},
	{0,0,1,0,1,-3,0,0,2,-1,0,5.216443209953305348847152,0.00001},
	{0,0,1,0,1,-3,0,0,2,0,0,5.327243692186914181263546,0.00001},
	{0,0,1,0,1,-2,0,0,-4,1,0,3.198005360205679270535484,0.00001},
	{0,0,1,0,1,-2,0,0,-2,-1,0,3.197661530343036240253696,0.00005},
	{0,0,1,0,1,-2,0,0,-2,0,0,3.196705613511718890862312,0.00045},
	{0,0,1,0,1,-2,0,0,-2,1,0,3.197947938873288098449166,0.00057},
	{0,0,1,0,1,-2,0,0,-2,2,0,3.198597550420880786248290,0.00003},
	{0,0,1,0,1,-2,0,0,0,-2,0,3.181008296752207087365605,0.00002},
	{0,0,1,0,1,-2,0,0,0,-1,0,3.177741913057099854000853,0.00043},
	{0,0,1,0,1,-2,0,0,0,0,0,3.160004830000782138910154,0.00186},
	{0,0,1,0,1,-2,0,0,0,1,0,3.169461722019788041393440,0.00027},
	{0,0,1,0,1,-2,0,0,0,2,0,3.182912800031983291404458,0.00002},
	{0,0,1,0,1,-2,0,0,1,0,-1,1.381988004577551665263968,0.00002},
	{0,0,1,0,1,-2,0,0,1,0,0,0.009971589615419202898283,0.00003},
	{0,0,1,0,1,-2,0,0,2,-1,0,3.063377119425068517699629,0.00007},
	{0,0,1,0,1,-2,0,0,2,0,0,3.126812332819279394158229,0.00006},
	{0,0,1,0,1,-1,0,0,-2,0,0,1.158255469494875011804425,0.00002},
	{0,0,1,0,1,-1,0,0,-2,1,0,1.158255469494875011804425,0.00002},
	{0,0,1,0,1,-1,0,0,-1,0,-1,4.777581042203957295555483,0.00006},
	{0,0,1,0,1,-1,0,0,-1,1,-1,1.644088461672670087310166,0.00007},
	{0,0,1,0,1,-1,0,0,-1,2,-1,1.640442643398179134450743,0.00001},
	{0,0,1,0,1,-1,0,0,0,0,0,0.599911202746648553052466,0.00004},
	{0,0,1,0,1,-1,0,0,1,-2,-1,4.780652821687467302069763,0.00006},
	{0,0,1,0,1,-1,0,0,1,-1,-1,4.780652821687467302069763,0.00087},
	{0,0,1,0,1,-1,0,0,1,0,-1,4.777581042203957295555483,0.00491},
	{0,0,1,0,1,-1,0,0,1,0,1,4.789492041684193068817876,0.00005},
	{0,0,1,0,1,-1,0,0,1,1,-1,4.780652821687467302069763,0.00087},
	{0,0,1,0,1,-1,0,0,1,2,-1,4.780652821687467302069763,0.00006},
	{0,0,1,0,1,-1,0,0,3,-2,-1,1.640442643398179134450743,0.00001},
	{0,0,1,0,1,-1,0,0,3,-1,-1,1.644088461672670087310166,0.00007},
	{0,0,1,0,1,-1,0,0,3,0,-1,4.777581042203957295555483,0.00006},
	{0,0,1,0,1,0,0,0,-4,-1,0,1.266724017314893258046027,0.00002},
	{0,0,1,0,1,0,0,0,-4,0,0,4.298275406895696093556580,0.00009},
	{0,0,1,0,1,0,0,0,-4,1,0,4.352446761686170617622338,0.00017},
	{0,0,1,0,1,0,0,0,-4,2,0,4.392262434313141561403881,0.00009},
	{0,0,1,0,1,0,0,0,-3,0,0,4.320596946298227436500383,0.00001},
	{0,0,1,0,1,0,0,0,-2,-2,0,4.270442117715367302821505,0.00003},
	{0,0,1,0,1,0,0,0,-2,-1,0,4.206603558731020875427475,0.00035},
	{0,0,1,0,1,0,0,0,-2,0,0,4.269551301665148734798549,0.00408},
	{0,0,1,0,1,0,0,0,-2,0,2,4.284511391348618580821039,0.00006},
	{0,0,1,0,1,0,0,0,-2,1,0,4.319870365730621664113187,0.00474},
	{0,0,1,0,1,0,0,0,-2,2,0,4.393215733150580781796180,0.00022},
	{0,0,1,0,1,0,0,0,-1,-1,-1,1.318361154031472359804411,0.00006},
	{0,0,1,0,1,0,0,0,-1,-1,1,1.342126953390028853974059,0.00003},
	{0,0,1,0,1,0,0,0,-1,0,-1,1.318559248901573832668532,0.00041},
	{0,0,1,0,1,0,0,0,-1,0,0,1.045127241637882065106169,0.00003},
	{0,0,1,0,1,0,0,0,-1,0,1,4.469666739441538361177209,0.00036},
	{0,0,1,0,1,0,0,0,-1,1,-1,4.466194755960547269069139,0.00022},
	{0,0,1,0,1,0,0,0,-1,1,1,4.441948118393066025078042,0.00002},
	{0,0,1,0,1,0,0,0,-1,2,-1,4.457162328015625618604645,0.00006},
	{0,0,1,0,1,0,0,0,0,-2,0,3.952199829104271699975470,0.00014},
	{0,0,1,0,1,0,0,0,0,-1,0,3.969346816340490136099106,0.00188},
	{0,0,1,0,1,0,0,0,0,0,0,4.107753869484593423067054,0.00720},
	{0,0,1,0,1,0,0,0,0,1,0,4.209016825487752910817107,0.00109},
	{0,0,1,0,1,0,0,0,0,2,0,4.287540933864230296990172,0.00005},
	{0,0,1,0,1,0,0,0,1,-3,-1,1.319947483788610043120570,0.00001},
	{0,0,1,0,1,0,0,0,1,-2,-1,1.315208042204819349763056,0.00029},
	{0,0,1,0,1,0,0,0,1,-1,-1,1.319047766559206857905906,0.00426},
	{0,0,1,0,1,0,0,0,1,-1,0,1.007111003469717047664744,0.00002},
	{0,0,1,0,1,0,0,0,1,-1,1,4.464532504380946953403964,0.00029},
	{0,0,1,0,1,0,0,0,1,0,-3,4.494871562768365080842159,0.00003},
	{0,0,1,0,1,0,0,0,1,0,-1,1.317231751472506706690524,0.02540},
	{0,0,1,0,1,0,0,0,1,0,0,0.679392798750769522087012,0.00007},
	{0,0,1,0,1,0,0,0,1,0,1,4.459583623286917486439052,0.00153},
	{0,0,1,0,1,0,0,0,1,1,-1,1.319096635778262749383316,0.00424},
	{0,0,1,0,1,0,0,0,1,1,1,4.459464940897781559669966,0.00016},
	{0,0,1,0,1,0,0,0,1,2,-1,1.319072201168734803644611,0.00029},
	{0,0,1,0,1,0,0,0,1,3,-1,1.319947483788610043120570,0.00001},
	{0,0,1,0,1,0,0,0,2,-2,0,0.346465309813394350957338,0.00004},
	{0,0,1,0,1,0,0,0,2,-1,0,1.056598767212465039833091,0.00017},
	{0,0,1,0,1,0,0,0,2,0,0,1.691616395198353606232899,0.00010},
	{0,0,1,0,1,0,0,0,3,-2,-1,4.461540137378403159118534,0.00005},
	{0,0,1,0,1,0,0,0,3,-1,-1,4.463513406630707613942377,0.00033},
	{0,0,1,0,1,0,0,0,3,-1,1,4.459466511694108348251575,0.00003},
	{0,0,1,0,1,0,0,0,3,0,-1,1.317325301120413794109254,0.00023},
	{0,0,1,0,1,0,0,0,3,0,1,4.459469827819687814951521,0.00002},
	{0,0,1,0,1,0,0,0,3,1,-1,1.318361154031472359804411,0.00006},
	{0,0,1,0,1,0,0,0,4,-1,0,1.170021257581344231724074,0.00001},
	{0,0,1,0,1,5,0,0,0,-1,0,5.228029229126819998896281,0.00002},
	{0,0,1,0,1,5,0,0,0,1,0,5.228029229126819998896281,0.00002},
	{0,0,1,0,1,5,0,0,2,-2,0,5.230515276113360201293290,0.00001},
	{0,0,1,0,1,5,0,0,2,0,0,5.230515276113360201293290,0.00001},
	{0,0,1,0,2,-8,0,0,0,0,0,3.582993228203241731222306,0.00003},
	{0,0,1,0,2,-7,0,0,-2,0,0,1.985599130805502987584532,0.00004},
	{0,0,1,0,2,-7,0,0,-2,1,0,1.985599130805502987584532,0.00005},
	{0,0,1,0,2,-7,0,0,0,-1,0,1.983904590634741671451025,0.00003},
	{0,0,1,0,2,-7,0,0,0,0,0,1.981972162086933497704422,0.00016},
	{0,0,1,0,2,-7,0,0,0,1,0,1.983904590634741671451025,0.00003},
	{0,0,1,0,2,-7,0,0,1,0,-1,5.281970200456030717361955,0.00004},
	{0,0,1,0,2,-6,0,0,-2,0,0,3.337513192509015347297918,0.00008},
	{0,0,1,0,2,-6,0,0,-2,1,0,3.337596444714335142123218,0.00008},
	{0,0,1,0,2,-6,0,0,0,-1,0,3.335295402628505989639507,0.00006},
	{0,0,1,0,2,-6,0,0,0,0,0,3.331147976726991366547281,0.00028},
	{0,0,1,0,2,-6,0,0,0,1,0,3.335295402628505989639507,0.00006},
	{0,0,1,0,2,-6,0,0,2,-1,0,3.314272388189458684593092,0.00002},
	{0,0,1,0,2,-6,0,0,2,0,0,3.321884118123255902332858,0.00002},
	{0,0,1,0,2,-6,3,0,-2,0,0,4.491212654524484371165727,0.00003},
	{0,0,1,0,2,-6,3,0,-2,1,0,4.491212654524484371165727,0.00002},
	{0,0,1,0,2,-6,3,0,0,-1,0,4.491212654524484371165727,0.00001},
	{0,0,1,0,2,-6,3,0,0,0,0,4.463498047733290619021318,0.00009},
	{0,0,1,0,2,-6,3,0,0,1,0,4.491212654524484371165727,0.00001},
	{0,0,1,0,2,-5,0,0,-4,-1,0,1.169642870199512074691484,0.00001},
	{0,0,1,0,2,-5,0,0,-4,0,0,1.143766793242369184113727,0.00005},
	{0,0,1,0,2,-5,0,0,-4,1,0,1.161116238671819012040487,0.00014},
	{0,0,1,0,2,-5,0,0,-4,2,0,1.168637386017437940211039,0.00008},
	{0,0,1,0,2,-5,0,0,-2,-2,0,1.168161260197494000223628,0.00004},
	{0,0,1,0,2,-5,0,0,-2,-1,0,1.174006891461198520687503,0.00032},
	{0,0,1,0,2,-5,0,0,-2,0,-2,4.307826197628458864130607,0.00001},
	{0,0,1,0,2,-5,0,0,-2,0,0,1.172356857186362955047798,0.00423},
	{0,0,1,0,2,-5,0,0,-2,0,2,1.170860062819852887017191,0.00006},
	{0,0,1,0,2,-5,0,0,-2,1,0,1.164646865215678062099869,0.00586},
	{0,0,1,0,2,-5,0,0,-2,2,0,1.161989426896591570681494,0.00029},
	{0,0,1,0,2,-5,0,0,-2,3,0,1.173249593098758314368979,0.00002},
	{0,0,1,0,2,-5,0,0,-1,-1,1,1.029728725246311649144104,0.00002},
	{0,0,1,0,2,-5,0,0,-1,0,0,4.455876369422756333449342,0.00001},
	{0,0,1,0,2,-5,0,0,-1,0,1,4.172110616723856857390729,0.00003},
	{0,0,1,0,2,-5,0,0,0,-3,0,1.146421613567577768577621,0.00001},
	{0,0,1,0,2,-5,0,0,0,-2,0,1.163446951354932146216470,0.00019},
	{0,0,1,0,2,-5,0,0,0,-1,0,1.150125202240309674195373,0.00331},
	{0,0,1,0,2,-5,0,0,0,0,0,1.145798007425840037143416,0.01696},
	{0,0,1,0,2,-5,0,0,0,1,0,1.141281967986304879403292,0.00313},
	{0,0,1,0,2,-5,0,0,0,2,0,1.133820336368178693930986,0.00022},
	{0,0,1,0,2,-5,0,0,1,-1,-1,4.172301381211100057555541,0.00001},
	{0,0,1,0,2,-5,0,0,1,-1,0,4.304083688113407468733840,0.00004},
	{0,0,1,0,2,-5,0,0,1,-1,1,4.172269267152862504133282,0.00008},
	{0,0,1,0,2,-5,0,0,1,0,-1,4.172317438240217946088251,0.00070},
	{0,0,1,0,2,-5,0,0,1,0,0,4.281439960930958577023375,0.00046},
	{0,0,1,0,2,-5,0,0,1,0,1,1.030778889857236757521264,0.00064},
	{0,0,1,0,2,-5,0,0,1,1,-1,4.172301381211100057555541,0.00001},
	{0,0,1,0,2,-5,0,0,1,1,0,4.282199179155576906907754,0.00003},
	{0,0,1,0,2,-5,0,0,1,1,1,1.030780286120638322699961,0.00007},
	{0,0,1,0,2,-5,0,0,2,-2,0,4.524538494860839143996145,0.00005},
	{0,0,1,0,2,-5,0,0,2,-1,0,1.137730397491421685529644,0.00063},
	{0,0,1,0,2,-5,0,0,2,0,-2,1.128129515809126015568609,0.00004},
	{0,0,1,0,2,-5,0,0,2,0,0,1.086033745047349619028410,0.00065},
	{0,0,1,0,2,-5,0,0,2,1,0,1.127415501612134995923498,0.00010},
	{0,0,1,0,2,-5,0,0,3,0,-1,1.030806815125268505184408,0.00002},
	{0,0,1,0,2,-5,0,0,4,-2,0,1.361358736417754400349622,0.00001},
	{0,0,1,0,2,-5,0,0,4,-1,0,1.125237679771496468461578,0.00002},
	{0,0,1,0,2,-4,0,0,-2,0,0,4.946026957104134424980657,0.00002},
	{0,0,1,0,2,-4,0,0,0,0,0,5.165118487172833283693762,0.00010},
	{0,0,1,0,2,-4,0,0,1,-1,-1,5.626663652012800831414552,0.00002},
	{0,0,1,0,2,-4,0,0,1,0,-1,5.640421558907496191181963,0.00013},
	{0,0,1,0,2,-4,0,0,1,0,1,5.640766785033541452776262,0.00002},
	{0,0,1,0,2,-4,0,0,1,1,-1,5.626663652012800831414552,0.00002},
	{0,0,1,0,2,-3,0,0,-2,0,0,3.207481276313531637356391,0.00004},
	{0,0,1,0,2,-3,0,0,-2,1,0,3.207481276313531637356391,0.00004},
	{0,0,1,0,2,-3,0,0,0,-1,0,3.207481276313531637356391,0.00001},
	{0,0,1,0,2,-3,0,0,0,0,0,3.061091610769582249673704,0.00009},
	{0,0,1,0,2,-3,0,0,0,1,0,3.207481276313531637356391,0.00001},
	{0,0,1,0,2,-3,0,0,1,-1,-1,0.523964247543666439277388,0.00003},
	{0,0,1,0,2,-3,0,0,1,0,-1,0.528665815482688872251060,0.00018},
	{0,0,1,0,2,-3,0,0,1,1,-1,0.523964247543666439277388,0.00003},
	{0,0,1,0,2,-2,0,0,-2,0,0,4.194443500766525723122413,0.00005},
	{0,0,1,0,2,-2,0,0,-2,1,0,4.194443500766525723122413,0.00006},
	{0,0,1,0,2,-2,0,0,0,-1,0,4.113187952110677336747813,0.00002},
	{0,0,1,0,2,-2,0,0,0,0,0,3.972471828366186397119009,0.00009},
	{0,0,1,0,2,-2,0,0,0,1,0,4.113187952110677336747813,0.00002},
	{0,0,1,0,2,-2,0,0,1,-1,-1,1.633948971383208936813958,0.00002},
	{0,0,1,0,2,-2,0,0,1,0,-1,1.664857181639701755315741,0.00016},
	{0,0,1,0,2,-2,0,0,1,1,-1,1.633948971383208936813958,0.00002},
	{0,0,1,0,2,0,0,0,-2,-1,0,4.333664400940834049436035,0.00002},
	{0,0,1,0,2,0,0,0,-2,0,0,4.311667492779173826988881,0.00010},
	{0,0,1,0,2,0,0,0,-2,1,0,4.502030903360044966632358,0.00010},
	{0,0,1,0,2,0,0,0,0,-1,0,4.010827009475088189560665,0.00010},
	{0,0,1,0,2,0,0,0,0,0,0,4.012489261054687617047421,0.00022},
	{0,0,1,0,2,0,0,0,0,1,0,4.055925968280771343188462,0.00003},
	{0,0,1,0,2,0,0,0,1,-1,-1,1.322875099075905280798793,0.00001},
	{0,0,1,0,2,0,0,0,1,0,-1,1.421156160052032602081340,0.00009},
	{0,0,1,0,2,0,0,0,1,1,-1,1.322875099075905280798793,0.00001},
	{0,0,1,0,2,0,0,0,2,-3,0,3.722797766479416736729036,0.00001},
	{0,0,1,0,2,0,0,0,2,-1,0,0.736958644403448048798566,0.00002},
	{0,0,1,0,2,5,0,0,2,-2,0,1.922660638116410192210992,0.00001},
	{0,0,1,0,2,5,0,0,2,0,0,1.922660638116410192210992,0.00001},
	{0,0,1,0,3,-10,0,0,0,0,0,3.506898618145541046686731,0.00002},
	{0,0,1,0,3,-7,0,0,-2,0,0,0.217605556743550587750491,0.00002},
	{0,0,1,0,3,-7,0,0,0,0,0,0.185942317052645078589990,0.00004},
	{0,0,1,0,3,-5,0,0,-2,0,0,5.740915697375153392556513,0.00003},
	{0,0,1,0,3,-5,0,0,-2,1,0,5.755559707931086066423632,0.00003},
	{0,0,1,0,3,-5,0,0,0,-1,0,5.660723926898396207718633,0.00001},
	{0,0,1,0,3,-5,0,0,0,0,0,5.504925191356944580434174,0.00005},
	{0,0,1,0,3,-5,0,0,0,1,0,5.660723926898396207718633,0.00001},
	{0,0,1,0,3,-5,0,0,1,-1,-1,2.979926819234838042405045,0.00003},
	{0,0,1,0,3,-5,0,0,1,0,-1,3.002224622159542111177188,0.00019},
	{0,0,1,0,3,-5,0,0,1,1,-1,2.979926819234838042405045,0.00003},
	{0,0,1,0,3,-4,0,0,0,0,0,6.211226254784485867332933,0.00002},
	{0,0,1,0,4,-10,0,0,-2,0,0,4.505398865217618897816010,0.00004},
	{0,0,1,0,4,-10,0,0,-2,1,0,4.505398865217618897816010,0.00004},
	{0,0,1,0,4,-10,0,0,0,-1,0,4.505398865217618897816010,0.00002},
	{0,0,1,0,4,-10,0,0,0,0,0,4.476782795867770836650834,0.00013},
	{0,0,1,0,4,-10,0,0,0,1,0,4.505398865217618897816010,0.00002},
	{0,0,1,0,4,-1,0,0,2,-3,0,5.357270685704074608679548,0.00001},
	{0,0,1,0,4,-1,0,0,2,-1,0,5.357270685704074608679548,0.00001},
	{0,0,1,0,5,-5,0,0,0,-1,0,2.439573755482019379314806,0.00002},
	{0,0,1,0,5,-5,0,0,0,1,0,2.439573755482019379314806,0.00002},
	{0,0,1,0,5,-5,0,0,2,-2,0,2.425273400255804290281958,0.00001},
	{0,0,1,0,5,-5,0,0,2,0,0,2.425273400255804290281958,0.00001},
	{0,0,1,0,5,-3,0,0,2,-3,0,1.196439957402932074970181,0.00001},
	{0,0,1,0,5,-3,0,0,2,-1,0,1.196439957402932074970181,0.00001},
	{0,0,1,0,5,-2,0,0,2,-2,0,2.219032031337838883899849,0.00002},
	{0,0,1,0,5,-2,0,0,2,0,0,2.219032031337838883899849,0.00002},
	{0,0,1,0,6,-5,0,0,2,-2,0,5.417390471651196470759260,0.00001},
	{0,0,1,0,6,-5,0,0,2,0,0,5.417390471651196470759260,0.00001},
	{0,0,1,0,6,-2,0,0,2,-3,0,2.055256093917222415257129,0.00001},
	{0,0,1,0,6,-2,0,0,2,-1,0,2.055256093917222415257129,0.00001},
	{0,0,1,0,10,-2,0,0,2,-2,0,4.535301416759113024568251,0.00002},
	{0,0,1,0,14,-12,0,0,2,-2,0,4.587806331179783647655768,0.00002},
	{0,0,1,1,-2,0,0,0,2,-3,0,6.250988694869271000698063,0.00001},
	{0,0,1,1,-2,0,0,0,2,-1,0,6.250988694869271000698063,0.00001},
	{0,0,1,1,-1,0,0,0,2,-1,0,0.456745160331132493691797,0.00002},
	{0,0,1,1,0,0,0,0,-2,-1,0,4.784448389211779506524636,0.00002},
	{0,0,1,1,0,0,0,0,-2,0,0,4.744792763277216884887366,0.00014},
	{0,0,1,1,0,0,0,0,-2,1,0,4.868233618085468172864694,0.00012},
	{0,0,1,1,0,0,0,0,-1,0,1,2.740037073134748979441611,0.00001},
	{0,0,1,1,0,0,0,0,0,-1,0,4.408403937367286751225492,0.00015},
	{0,0,1,1,0,0,0,0,0,0,0,4.303990138465501047448925,0.00053},
	{0,0,1,1,0,0,0,0,0,1,0,4.475745546693310039643166,0.00009},
	{0,0,1,1,0,0,0,0,1,0,-1,5.848147330354283468523136,0.00005},
	{0,0,1,1,0,0,0,0,2,-2,0,1.013452133708062863348687,0.00002},
	{0,0,1,1,0,0,0,0,2,-1,0,1.078055146904782546357637,0.00028},
	{0,0,1,1,0,0,0,0,2,0,0,1.040211696332565161071670,0.00004},
	{0,0,1,1,1,0,0,0,2,-1,0,4.785983406288909058901027,0.00002},
	{0,0,1,1,2,0,0,0,2,-2,0,5.279770038400966924996283,0.00001},
	{0,0,1,1,3,0,0,0,2,-2,0,4.968075701544579558799342,0.00001},
	{0,0,1,2,-3,0,0,0,2,-2,0,1.045129685098834970702342,0.00002},
	{0,0,1,2,-3,0,0,0,2,-1,0,4.267708408507967732248289,0.00004},
	{0,0,1,2,-2,0,0,0,0,0,0,3.652743740962868468358238,0.00001},
	{0,0,1,2,-1,0,0,0,2,-1,0,4.202658067423961973929636,0.00002},
	{0,0,1,2,0,0,0,0,-2,-1,0,0.722898621015232167863473,0.00001},
	{0,0,1,2,0,0,0,0,-2,0,0,0.663347114272559656988903,0.00015},
	{0,0,1,2,0,0,0,0,-2,1,0,0.748339587389852733956275,0.00010},
	{0,0,1,2,0,0,0,0,-1,0,-1,1.060899433022304494400601,0.00005},
	{0,0,1,2,0,0,0,0,-1,1,-1,4.203772111085510410077859,0.00004},
	{0,0,1,2,0,0,0,0,0,-1,0,0.898825889754083395821738,0.00003},
	{0,0,1,2,0,0,0,0,0,1,0,1.203715013324019977858370,0.00001},
	{0,0,1,2,0,0,0,0,1,-1,-1,1.061359501813130101766092,0.00007},
	{0,0,1,2,0,0,0,0,1,0,-1,0.593892085755295728866088,0.00002},
	{0,0,1,2,0,0,0,0,1,1,-1,4.202952155402923217764055,0.00005},
	{0,0,1,2,1,0,0,0,2,0,-2,4.917774963436252200210674,0.00001},
	{0,0,1,3,-2,0,0,0,2,-1,0,4.357855711571025913997346,0.00002},
	{0,0,1,3,0,0,0,0,2,-3,0,5.423581678106796033489445,0.00001},
	{0,0,1,3,0,0,0,0,2,-1,0,5.423581678106796033489445,0.00001},
	{0,0,1,4,-2,0,0,0,2,-1,0,4.866303807531537906072572,0.00002},
	{0,0,1,4,-2,0,0,0,2,0,0,1.728206524834714041816142,0.00002},
	{0,0,1,4,-1,0,0,0,2,0,0,2.188940984237129683265266,0.00001},
	{0,0,1,5,-2,0,0,0,2,-1,0,5.372661522646936305136478,0.00002},
	{0,0,1,5,-2,0,0,0,2,0,0,5.376979292683444988654173,0.00001},
	{0,0,2,-8,0,0,0,0,-2,1,0,3.029409696055680889514861,0.00001},
	{0,0,2,-8,0,0,0,0,-2,3,0,3.029409696055680889514861,0.00001},
	{0,0,2,-8,2,0,0,0,-2,0,0,0.901168470676110167083550,0.00002},
	{0,0,2,-8,3,0,0,0,-2,1,0,2.629570821452897888548250,0.00002},
	{0,0,2,-8,3,0,0,0,-2,3,0,2.608280946171220637808119,0.00002},
	{0,0,2,-8,3,0,0,0,0,0,0,2.316102531944783216033557,0.00024},
	{0,0,2,-8,3,0,0,0,0,1,0,2.312563004221738882648651,0.00009},
	{0,0,2,-8,3,0,0,0,2,-2,0,2.315987165681226311875207,0.00002},
	{0,0,2,-8,3,0,0,0,2,-1,0,2.318736757384817881444405,0.00047},
	{0,0,2,-8,3,0,0,0,2,0,0,2.314935779339825305811473,0.00056},
	{0,0,2,-8,3,0,0,0,2,1,0,2.315895710428421683246825,0.00006},
	{0,0,2,-8,3,0,0,0,4,-1,0,2.315845619478889449993630,0.00004},
	{0,0,2,-8,5,0,0,0,-2,1,0,5.026570236892244025739274,0.00003},
	{0,0,2,-7,0,0,0,0,-2,1,0,1.876738756568411936598295,0.00001},
	{0,0,2,-7,0,0,0,0,-2,2,0,3.532880112989503995635232,0.00003},
	{0,0,2,-7,0,0,0,0,-2,3,0,1.876738756568411936598295,0.00001},
	{0,0,2,-7,0,0,0,0,0,0,0,3.875960356718655575036792,0.00002},
	{0,0,2,-7,0,0,0,0,1,1,-1,4.307127367795961170315877,0.00002},
	{0,0,2,-7,0,0,0,0,1,2,-1,4.317527435742745112179364,0.00001},
	{0,0,2,-6,0,0,0,0,-2,1,0,0.972720163223794842544123,0.00003},
	{0,0,2,-6,0,0,0,0,-2,3,0,1.107964505230359053555844,0.00001},
	{0,0,2,-6,0,0,0,0,-1,0,1,5.415224168983621133577344,0.00002},
	{0,0,2,-6,0,0,0,0,0,-1,0,5.829950178507139924022340,0.00001},
	{0,0,2,-6,0,0,0,0,0,0,0,5.817750501568625054460426,0.00016},
	{0,0,2,-6,0,0,0,0,0,1,0,0.131626449000105144593320,0.00008},
	{0,0,2,-6,0,0,0,0,2,-1,0,0.291804564700660296061585,0.00015},
	{0,0,2,-6,0,0,0,0,2,0,0,0.282937593968828393631298,0.00017},
	{0,0,2,-6,0,0,0,0,2,1,0,0.282471591058545856700590,0.00001},
	{0,0,2,-6,0,4,0,0,-1,0,1,5.413508510328910894315868,0.00004},
	{0,0,2,-6,2,0,0,0,0,-1,0,1.185975486806749801260707,0.00001},
	{0,0,2,-6,2,0,0,0,0,0,0,1.282397423063652786012767,0.00007},
	{0,0,2,-6,2,0,0,0,0,1,0,1.185975486806749801260707,0.00001},
	{0,0,2,-6,2,0,0,0,2,-1,0,1.292649661622792711668239,0.00005},
	{0,0,2,-6,2,0,0,0,2,0,0,1.290227144621024502058049,0.00005},
	{0,0,2,-6,3,0,0,0,0,0,0,1.875334115586406724673907,0.00006},
	{0,0,2,-6,3,0,0,0,2,0,0,1.847496986681723241119357,0.00002},
	{0,0,2,-5,0,0,0,0,-2,0,0,4.291856085906860407419572,0.00003},
	{0,0,2,-5,0,0,0,0,-2,1,0,2.030043765674613087668376,0.00002},
	{0,0,2,-5,0,0,0,0,-1,0,1,6.134786244067815808023170,0.00007},
	{0,0,2,-5,0,0,0,0,-1,1,-1,3.001287205818296222048502,0.00008},
	{0,0,2,-5,0,0,0,0,-1,2,-1,2.997928843271608023712815,0.00002},
	{0,0,2,-5,0,0,0,0,0,-1,0,4.709067095219368503933310,0.00018},
	{0,0,2,-5,0,0,0,0,0,0,0,4.872313150679079996052678,0.00109},
	{0,0,2,-5,0,0,0,0,0,1,0,4.895402285886637727685411,0.00019},
	{0,0,2,-5,0,0,0,0,1,0,-1,6.165799523145278904223687,0.00003},
	{0,0,2,-5,0,0,0,0,2,-1,0,0.154639138786425989202655,0.00017},
	{0,0,2,-5,0,0,0,0,2,0,0,0.090057942205356206200051,0.00015},
	{0,0,2,-5,0,0,0,0,2,1,0,0.036350495930061503535580,0.00001},
	{0,0,2,-5,3,0,0,0,0,0,0,2.404054210808832969803461,0.00002},
	{0,0,2,-4,0,0,0,0,-4,0,0,5.228916554518534098860982,0.00008},
	{0,0,2,-4,0,0,0,0,-4,1,0,5.271292974224030203345137,0.00020},
	{0,0,2,-4,0,0,0,0,-4,2,0,5.288195789897895515707660,0.00012},
	{0,0,2,-4,0,0,0,0,-3,0,0,5.248198603028717101892653,0.00002},
	{0,0,2,-4,0,0,0,0,-2,-2,0,5.197797857554250278155905,0.00009},
	{0,0,2,-4,0,0,0,0,-2,-1,0,5.234111876102945259958688,0.00071},
	{0,0,2,-4,0,0,0,0,-2,-1,2,2.115638202850919302733246,0.00001},
	{0,0,2,-4,0,0,0,0,-2,0,-2,2.129740812272884031841613,0.00001},
	{0,0,2,-4,0,0,0,0,-2,0,0,5.250301899310295006273464,0.00691},
	{0,0,2,-4,0,0,0,0,-2,0,2,5.252613587904560787933406,0.00017},
	{0,0,2,-4,0,0,0,0,-2,1,-2,2.126947063739216492450623,0.00002},
	{0,0,2,-4,0,0,0,0,-2,1,0,5.280625075201519358358837,0.01024},
	{0,0,2,-4,0,0,0,0,-2,2,0,5.355546649468954534256682,0.00032},
	{0,0,2,-4,0,0,0,0,-2,3,0,5.396826478805423654705464,0.00002},
	{0,0,2,-4,0,0,0,0,-1,0,0,2.096725116944607947289114,0.00016},
	{0,0,2,-4,0,0,0,0,-1,0,1,0.407854473725491717406300,0.00006},
	{0,0,2,-4,0,0,0,0,-1,1,0,2.148837681349430095423259,0.00002},
	{0,0,2,-4,0,0,0,0,0,-3,0,5.194829052496607424416197,0.00008},
	{0,0,2,-4,0,0,0,0,0,-2,0,5.200009364249451593309459,0.00116},
	{0,0,2,-4,0,0,0,0,0,-1,-2,2.074035487602831295816941,0.00004},
	{0,0,2,-4,0,0,0,0,0,-1,0,5.198032778871568559964089,0.01712},
	{0,0,2,-4,0,0,0,0,0,-1,2,5.196671422055013422891534,0.00003},
	{0,0,2,-4,0,0,0,0,0,0,-2,2.149183605607175362450789,0.00004},
	{0,0,2,-4,0,0,0,0,0,0,0,5.238416032571288738495241,0.09178},
	{0,0,2,-4,0,0,0,0,0,0,1,0.407114454122646074463177,0.00002},
	{0,0,2,-4,0,0,0,0,0,0,2,2.149183605607175362450789,0.00004},
	{0,0,2,-4,0,0,0,0,0,1,-2,5.196671422055013422891534,0.00003},
	{0,0,2,-4,0,0,0,0,0,1,0,5.201793788876691415623554,0.01770},
	{0,0,2,-4,0,0,0,0,0,1,2,2.074035487602831295816941,0.00004},
	{0,0,2,-4,0,0,0,0,0,2,0,5.198963213895806845243897,0.00118},
	{0,0,2,-4,0,0,0,0,0,3,0,5.194053777242872094177528,0.00008},
	{0,0,2,-4,0,0,0,0,1,-1,0,2.159839713355226731295033,0.00003},
	{0,0,2,-4,0,0,0,0,1,0,-1,0.421093668766494677591083,0.00007},
	{0,0,2,-4,0,0,0,0,1,0,0,1.963073387880488462897688,0.00031},
	{0,0,2,-4,0,0,0,0,1,1,0,2.125935121838910202285433,0.00002},
	{0,0,2,-4,0,0,0,0,2,-3,0,5.382173043471530249348689,0.00002},
	{0,0,2,-4,0,0,0,0,2,-2,0,5.330039011516907621057726,0.00045},
	{0,0,2,-4,0,0,0,0,2,-1,0,5.295523903828244449698559,0.01284},
	{0,0,2,-4,0,0,0,0,2,-1,2,2.139243431918292248639091,0.00003},
	{0,0,2,-4,0,0,0,0,2,0,-2,5.279847007420979565495145,0.00019},
	{0,0,2,-4,0,0,0,0,2,0,0,5.283381124623343083612781,0.00874},
	{0,0,2,-4,0,0,0,0,2,0,2,2.140784732180728067163500,0.00002},
	{0,0,2,-4,0,0,0,0,2,1,-2,2.142759397696434753299854,0.00001},
	{0,0,2,-4,0,0,0,0,2,1,0,5.264511148349556357572965,0.00086},
	{0,0,2,-4,0,0,0,0,2,2,0,5.260493924010241073574434,0.00009},
	{0,0,2,-4,0,0,0,0,3,-1,0,1.663443290412661035304609,0.00002},
	{0,0,2,-4,0,0,0,0,3,0,0,5.293660590318815195587376,0.00002},
	{0,0,2,-4,0,0,0,0,4,-2,0,5.296262003568911858053525,0.00015},
	{0,0,2,-4,0,0,0,0,4,-1,0,5.284966930781705762854017,0.00026},
	{0,0,2,-4,0,0,0,0,4,0,0,5.276940859683484141839926,0.00011},
	{0,0,2,-4,0,0,0,0,4,1,0,5.282860143841623390414952,0.00002},
	{0,0,2,-4,0,1,0,0,0,0,0,3.476810363571635420498751,0.00001},
	{0,0,2,-4,0,2,0,0,0,0,0,0.010964332893953578074164,0.00006},
	{0,0,2,-4,1,0,0,0,-2,0,0,2.710167508316117856992378,0.00007},
	{0,0,2,-4,1,0,0,0,-2,1,0,2.717306777621400826205900,0.00011},
	{0,0,2,-4,1,0,0,0,0,-1,0,2.676305502833550065133750,0.00012},
	{0,0,2,-4,1,0,0,0,0,0,0,2.698504520122591010533597,0.00077},
	{0,0,2,-4,1,0,0,0,0,1,0,2.677106434427290349020723,0.00012},
	{0,0,2,-4,1,0,0,0,2,-1,0,2.722688151304074821723589,0.00012},
	{0,0,2,-4,1,0,0,0,2,0,0,2.713469671260891225017531,0.00007},
	{0,0,2,-4,2,0,0,0,-2,-1,0,0.010726968115682349036444,0.00003},
	{0,0,2,-4,2,0,0,0,-2,0,0,0.009643991314819867419206,0.00019},
	{0,0,2,-4,2,0,0,0,-2,1,0,0.014869856161141288553029,0.00031},
	{0,0,2,-4,2,0,0,0,-2,2,0,0.010727142648607549887951,0.00001},
	{0,0,2,-4,2,0,0,0,0,-2,0,6.265947737355189950392287,0.00002},
	{0,0,2,-4,2,0,0,0,0,-1,0,6.269965659826206128002468,0.00034},
	{0,0,2,-4,2,0,0,0,0,0,0,0.000613657765001206245183,0.00176},
	{0,0,2,-4,2,0,0,0,0,1,0,6.268885999150922039291345,0.00033},
	{0,0,2,-4,2,0,0,0,0,2,0,6.266070084935754458399515,0.00002},
	{0,0,2,-4,2,0,0,0,2,-2,0,0.008882504162174741785263,0.00001},
	{0,0,2,-4,2,0,0,0,2,-1,0,0.012664458118321255536420,0.00027},
	{0,0,2,-4,2,0,0,0,2,0,0,0.008871508587887176611186,0.00019},
	{0,0,2,-4,2,0,0,0,2,1,0,0.009404357608521046393846,0.00002},
	{0,0,2,-4,3,0,0,0,0,0,0,3.075866521019415156246168,0.00005},
	{0,0,2,-3,0,0,0,0,-4,-1,0,5.775499396503421145609991,0.00001},
	{0,0,2,-3,0,0,0,0,-4,0,0,5.775273376365287703038121,0.00008},
	{0,0,2,-3,0,0,0,0,-4,1,0,5.773884617879475378288134,0.00022},
	{0,0,2,-3,0,0,0,0,-4,2,0,5.775700109367400081339383,0.00013},
	{0,0,2,-3,0,0,0,0,-3,0,0,5.779110308192871414689762,0.00002},
	{0,0,2,-3,0,0,0,0,-2,-2,0,5.789301809294042477915809,0.00006},
	{0,0,2,-3,0,0,0,0,-2,-1,0,5.771474841781246922778337,0.00068},
	{0,0,2,-3,0,0,0,0,-2,0,-2,2.631369906845853812171754,0.00002},
	{0,0,2,-3,0,0,0,0,-2,0,0,5.776647299552457148763551,0.00739},
	{0,0,2,-3,0,0,0,0,-2,0,2,5.777064607776608795575157,0.00014},
	{0,0,2,-3,0,0,0,0,-2,1,-2,2.631943945636834758516898,0.00002},
	{0,0,2,-3,0,0,0,0,-2,1,0,5.775712501205089388633951,0.01085},
	{0,0,2,-3,0,0,0,0,-2,2,0,5.778377968038734380229471,0.00047},
	{0,0,2,-3,0,0,0,0,-2,3,0,5.783557058061102651436158,0.00003},
	{0,0,2,-3,0,0,0,0,-1,0,0,2.629781133627763445304026,0.00025},
	{0,0,2,-3,0,0,0,0,-1,0,1,0.922418028852066251843667,0.00006},
	{0,0,2,-3,0,0,0,0,-1,1,0,2.631302013537951012267513,0.00004},
	{0,0,2,-3,0,0,0,0,0,-3,0,5.754969088512210895203225,0.00004},
	{0,0,2,-3,0,0,0,0,0,-2,0,5.756296062342502573017100,0.00057},
	{0,0,2,-3,0,0,0,0,0,-1,-2,2.618749954623458275904113,0.00003},
	{0,0,2,-3,0,0,0,0,0,-1,0,5.756995241240852045905285,0.00849},
	{0,0,2,-3,0,0,0,0,0,-1,2,5.756090811622468272901187,0.00001},
	{0,0,2,-3,0,0,0,0,0,0,-2,2.631021190061304970697620,0.00002},
	{0,0,2,-3,0,0,0,0,0,0,0,5.764594753869885401798001,0.04014},
	{0,0,2,-3,0,0,0,0,0,0,2,2.631021190061304970697620,0.00002},
	{0,0,2,-3,0,0,0,0,0,1,-2,2.701740709621638814041944,0.00003},
	{0,0,2,-3,0,0,0,0,0,1,0,5.755771939968128414477633,0.00753},
	{0,0,2,-3,0,0,0,0,0,1,2,2.618749954623458275904113,0.00003},
	{0,0,2,-3,0,0,0,0,0,2,-2,2.680058658857038533795958,0.00001},
	{0,0,2,-3,0,0,0,0,0,2,0,5.755085676506244141137358,0.00052},
	{0,0,2,-3,0,0,0,0,0,3,0,5.753583471619053035794877,0.00003},
	{0,0,2,-3,0,0,0,0,1,-1,-1,0.934315938362911602155236,0.00002},
	{0,0,2,-3,0,0,0,0,1,-1,1,4.073340514491320618617465,0.00007},
	{0,0,2,-3,0,0,0,0,1,0,-1,0.932289785634271450653898,0.00022},
	{0,0,2,-3,0,0,0,0,1,0,0,5.778947119907810403560688,0.00006},
	{0,0,2,-3,0,0,0,0,1,0,1,4.073514698350669149817804,0.00003},
	{0,0,2,-3,0,0,0,0,1,1,-1,0.934315938362911602155236,0.00002},
	{0,0,2,-3,0,0,0,0,2,-2,0,5.777806721774557452420140,0.00022},
	{0,0,2,-3,0,0,0,0,2,-1,-2,2.627112699734388989725176,0.00001},
	{0,0,2,-3,0,0,0,0,2,-1,0,5.781084799175652655378599,0.00653},
	{0,0,2,-3,0,0,0,0,2,0,-2,5.768330282067928749256680,0.00010},
	{0,0,2,-3,0,0,0,0,2,0,0,5.766854431652442158906524,0.00368},
	{0,0,2,-3,0,0,0,0,2,1,-2,2.627112699734388989725176,0.00001},
	{0,0,2,-3,0,0,0,0,2,1,0,5.767591658728484560469951,0.00038},
	{0,0,2,-3,0,0,0,0,2,2,0,5.767248003398766975635681,0.00004},
	{0,0,2,-3,0,0,0,0,4,-2,0,5.778492461637665833507072,0.00007},
	{0,0,2,-3,0,0,0,0,4,-1,0,5.772365308765614599906257,0.00012},
	{0,0,2,-3,0,0,0,0,4,0,0,5.774212565245925077306310,0.00005},
	{0,0,2,-3,1,0,0,0,0,0,0,6.167409938446093420338912,0.00002},
	{0,0,2,-3,1,0,0,0,2,0,0,3.194119384626113777869705,0.00001},
	{0,0,2,-3,2,0,0,0,2,-3,0,3.662408676228712689493250,0.00001},
	{0,0,2,-3,2,0,0,0,2,-1,0,3.662408676228712689493250,0.00001},
	{0,0,2,-3,2,0,0,0,2,0,0,0.519715767078461898798025,0.00001},
	{0,0,2,-3,3,0,0,0,0,0,0,6.143026117999406565672871,0.00001},
	{0,0,2,-2,-3,0,0,0,0,0,0,5.597692931758946777165420,0.00001},
	{0,0,2,-2,-2,0,0,0,-2,0,0,2.110759309459894428329108,0.00001},
	{0,0,2,-2,0,0,0,0,-6,0,0,3.093494870063333568310782,0.00001},
	{0,0,2,-2,0,0,0,0,-6,1,0,6.266464703879631059635358,0.00002},
	{0,0,2,-2,0,0,0,0,-6,2,0,6.264529657337943646666645,0.00004},
	{0,0,2,-2,0,0,0,0,-4,-1,0,0.017024988721503885730213,0.00009},
	{0,0,2,-2,0,0,0,0,-4,0,0,6.233804706652911420405871,0.00051},
	{0,0,2,-2,0,0,0,0,-4,0,2,6.259997386336364932901688,0.00001},
	{0,0,2,-2,0,0,0,0,-4,1,0,6.241628668623751430288848,0.00119},
	{0,0,2,-2,0,0,0,0,-4,1,2,6.260400382860651369298921,0.00002},
	{0,0,2,-2,0,0,0,0,-4,2,0,6.256156789317350863655065,0.00077},
	{0,0,2,-2,0,0,0,0,-4,3,0,6.268873781846157733355085,0.00003},
	{0,0,2,-2,0,0,0,0,-3,-1,0,6.252850088516522575332601,0.00001},
	{0,0,2,-2,0,0,0,0,-3,0,0,6.264506618991818598374266,0.00004},
	{0,0,2,-2,0,0,0,0,-3,1,0,3.077827922032806640117997,0.00002},
	{0,0,2,-2,0,0,0,0,-2,-3,0,6.262453413659771150889810,0.00004},
	{0,0,2,-2,0,0,0,0,-2,-2,0,6.267291466346300410350523,0.00033},
	{0,0,2,-2,0,0,0,0,-2,-1,-2,3.122629651266874972748155,0.00002},
	{0,0,2,-2,0,0,0,0,-2,-1,0,6.250568245052465776723238,0.00404},
	{0,0,2,-2,0,0,0,0,-2,-1,2,3.119426623023615174901124,0.00007},
	{0,0,2,-2,0,0,0,0,-2,0,-2,3.125877534471911189939419,0.00009},
	{0,0,2,-2,0,0,0,0,-2,0,0,6.258397268478137043246079,0.04612},
	{0,0,2,-2,0,0,0,0,-2,0,2,6.261667142831749188758295,0.00064},
	{0,0,2,-2,0,0,0,0,-2,1,-2,3.122381989046016936839578,0.00017},
	{0,0,2,-2,0,0,0,0,-2,1,0,6.263440920950550605539320,0.05904},
	{0,0,2,-2,0,0,0,0,-2,1,2,6.270730288571504829064907,0.00002},
	{0,0,2,-2,0,0,0,0,-2,2,0,6.267760261783386077638625,0.00254},
	{0,0,2,-2,0,0,0,0,-2,3,0,6.252225260644308946211822,0.00013},
	{0,0,2,-2,0,0,0,0,-1,-1,0,0.038313467739779519249943,0.00004},
	{0,0,2,-2,0,0,0,0,-1,-1,1,4.878407491361193670798002,0.00003},
	{0,0,2,-2,0,0,0,0,-1,0,-1,1.746850306437442545970384,0.00001},
	{0,0,2,-2,0,0,0,0,-1,0,0,0.008202523885597751140963,0.00119},
	{0,0,2,-2,0,0,0,0,-1,0,1,1.723649470157756713462049,0.00006},
	{0,0,2,-2,0,0,0,0,-1,1,0,0.028332453346399548432810,0.00007},
	{0,0,2,-2,0,0,0,0,0,-3,0,6.280544973087169857706158,0.00021},
	{0,0,2,-2,0,0,0,0,0,-2,0,6.270701665171771743700901,0.00274},
	{0,0,2,-2,0,0,0,0,0,-1,-2,3.133859972338832289295851,0.00011},
	{0,0,2,-2,0,0,0,0,0,-1,0,6.274744371318166535900218,0.04213},
	{0,0,2,-2,0,0,0,0,0,0,-2,3.115772252635788941432793,0.00002},
	{0,0,2,-2,0,0,0,0,0,0,0,6.279081514509371686472150,0.19443},
	{0,0,2,-2,0,0,0,0,0,0,2,3.136218959355828062030014,0.00014},
	{0,0,2,-2,0,0,0,0,0,1,0,0.001242150828644364305223,0.03259},
	{0,0,2,-2,0,0,0,0,0,1,2,3.135738295679828535611477,0.00009},
	{0,0,2,-2,0,0,0,0,0,2,0,0.007020761449072389880077,0.00229},
	{0,0,2,-2,0,0,0,0,0,2,2,3.135791179156163899222065,0.00001},
	{0,0,2,-2,0,0,0,0,0,3,0,6.282733441436245236388913,0.00015},
	{0,0,2,-2,0,0,0,0,1,-3,0,3.149205954319917566408549,0.00002},
	{0,0,2,-2,0,0,0,0,1,-2,0,3.150362234949364292901919,0.00017},
	{0,0,2,-2,0,0,0,0,1,-1,-1,1.733815489451848268487311,0.00014},
	{0,0,2,-2,0,0,0,0,1,-1,0,0.004808033023393979213389,0.00139},
	{0,0,2,-2,0,0,0,0,1,-1,1,1.737170012274181329914313,0.00013},
	{0,0,2,-2,0,0,0,0,1,0,-2,3.145692082936877742582737,0.00002},
	{0,0,2,-2,0,0,0,0,1,0,-1,1.737060405597155909873663,0.00113},
	{0,0,2,-2,0,0,0,0,1,0,0,3.146410285924072791630124,0.01201},
	{0,0,2,-2,0,0,0,0,1,0,1,4.877219096673511167239212,0.00028},
	{0,0,2,-2,0,0,0,0,1,0,2,0.004099080281233882273872,0.00002},
	{0,0,2,-2,0,0,0,0,1,1,-1,1.733815489451848268487311,0.00014},
	{0,0,2,-2,0,0,0,0,1,1,0,3.145622444299722708649369,0.00083},
	{0,0,2,-2,0,0,0,0,1,1,1,4.876610674896264541189339,0.00003},
	{0,0,2,-2,0,0,0,0,1,2,0,3.145692257469802743941045,0.00006},
	{0,0,2,-2,0,0,0,0,2,-3,0,3.204660998775234137525558,0.00001},
	{0,0,2,-2,0,0,0,0,2,-2,0,3.153596155520383970127796,0.00035},
	{0,0,2,-2,0,0,0,0,2,-1,0,0.007881208770305594274452,0.01315},
	{0,0,2,-2,0,0,0,0,2,-1,2,3.140948801628732578450354,0.00003},
	{0,0,2,-2,0,0,0,0,2,0,-2,0.014734942209962126682954,0.00049},
	{0,0,2,-2,0,0,0,0,2,0,0,0.015546869377989889007829,0.00875},
	{0,0,2,-2,0,0,0,0,2,0,2,3.133356444849631827764824,0.00002},
	{0,0,2,-2,0,0,0,0,2,1,-2,3.155445680928722573810319,0.00002},
	{0,0,2,-2,0,0,0,0,2,1,0,0.018172193638839762019899,0.00101},
	{0,0,2,-2,0,0,0,0,2,2,0,6.276504535868801859521682,0.00012},
	{0,0,2,-2,0,0,0,0,3,-2,0,0.006987600193284497843149,0.00006},
	{0,0,2,-2,0,0,0,0,3,-1,0,3.145511615892221168877541,0.00014},
	{0,0,2,-2,0,0,0,0,3,0,0,3.141909430849029849497356,0.00009},
	{0,0,2,-2,0,0,0,0,4,-2,0,6.282985816046083193953109,0.00016},
	{0,0,2,-2,0,0,0,0,4,-1,0,0.024289049068304285894371,0.00027},
	{0,0,2,-2,0,0,0,0,4,0,0,0.013718287920675430874295,0.00009},
	{0,0,2,-2,0,2,0,0,-2,0,0,5.077553049672251184176730,0.00002},
	{0,0,2,-2,0,2,0,0,-2,1,0,5.077553049672251184176730,0.00002},
	{0,0,2,-2,0,2,0,0,0,0,0,5.077957616992862632798733,0.00003},
	{0,0,2,-2,1,0,0,0,0,0,0,1.706459896887789762232046,0.00001},
	{0,0,2,-2,1,0,0,0,1,0,-1,2.110685307499609475456737,0.00001},
	{0,0,2,-2,1,0,0,0,2,-3,0,3.573030714299933130462250,0.00001},
	{0,0,2,-2,1,0,0,0,2,-1,0,3.573030714299933130462250,0.00001},
	{0,0,2,-2,2,0,0,0,1,0,-1,2.885986741174270786558509,0.00001},
	{0,0,2,-1,0,0,0,0,-4,1,0,4.463236771944266934042389,0.00002},
	{0,0,2,-1,0,0,0,0,-2,-1,0,4.459929373011737752108274,0.00005},
	{0,0,2,-1,0,0,0,0,-2,0,0,4.450697977532088955854306,0.00050},
	{0,0,2,-1,0,0,0,0,-2,1,0,4.492674891371804868356321,0.00053},
	{0,0,2,-1,0,0,0,0,-2,2,0,4.542441733261946446020829,0.00003},
	{0,0,2,-1,0,0,0,0,0,-1,0,4.094960955133324809196438,0.00039},
	{0,0,2,-1,0,0,0,0,0,0,0,3.992434031685871076433614,0.00140},
	{0,0,2,-1,0,0,0,0,0,1,0,4.063819568888765942915597,0.00017},
	{0,0,2,-1,0,0,0,0,1,-1,-1,5.392061904480404344042199,0.00002},
	{0,0,2,-1,0,0,0,0,1,-1,1,2.263552588029411172243499,0.00002},
	{0,0,2,-1,0,0,0,0,1,0,-1,5.394054197821555263203663,0.00017},
	{0,0,2,-1,0,0,0,0,1,0,0,3.667481650232559342583727,0.00002},
	{0,0,2,-1,0,0,0,0,1,0,1,2.250764211534198366848614,0.00002},
	{0,0,2,-1,0,0,0,0,1,1,-1,5.392061904480404344042199,0.00002},
	{0,0,2,-1,0,0,0,0,2,-2,0,0.773459064116255867737948,0.00007},
	{0,0,2,-1,0,0,0,0,2,-1,0,0.693162573884378852007160,0.00055},
	{0,0,2,-1,0,0,0,0,2,0,0,0.764042489202970798167769,0.00009},
	{0,0,2,-1,2,0,0,0,2,-1,0,4.920414424864042679530485,0.00002},
	{0,0,2,0,-7,0,0,0,0,0,0,4.073795521827315191387697,0.00001},
	{0,0,2,0,-7,3,0,0,0,0,0,3.455632712960861052664541,0.00001},
	{0,0,2,0,-7,5,0,0,-2,0,0,1.782247328997139668160798,0.00002},
	{0,0,2,0,-7,5,0,0,0,0,0,1.788678169159037878443996,0.00003},
	{0,0,2,0,-7,10,0,0,2,-3,0,4.326974204852088945472133,0.00002},
	{0,0,2,0,-7,10,0,0,2,-2,0,1.346847545417897640263050,0.00003},
	{0,0,2,0,-7,10,0,0,2,-1,0,1.185381551262296051518774,0.00002},
	{0,0,2,0,-6,0,0,0,-2,0,0,3.813895401320186007154689,0.00004},
	{0,0,2,0,-6,0,0,0,-2,1,0,3.817998495858699659066815,0.00004},
	{0,0,2,0,-6,0,0,0,0,-1,0,3.832814944944729962372776,0.00001},
	{0,0,2,0,-6,0,0,0,0,0,0,3.848923461276011703802169,0.00010},
	{0,0,2,0,-6,0,0,0,0,1,0,3.832814944944729962372776,0.00001},
	{0,0,2,0,-6,0,0,0,2,-1,0,0.716701480440175897612676,0.00005},
	{0,0,2,0,-6,2,0,0,-2,0,0,3.477729453955735294812257,0.00002},
	{0,0,2,0,-6,2,0,0,0,0,0,3.506061383703359624064433,0.00003},
	{0,0,2,0,-6,3,0,0,-2,0,0,3.795625120177384292929901,0.00001},
	{0,0,2,0,-6,3,0,0,0,0,0,3.826080592025909332676292,0.00003},
	{0,0,2,0,-6,3,0,0,2,-1,0,3.675676669202373236799986,0.00002},
	{0,0,2,0,-6,4,0,0,-2,0,0,2.263849294002250100987794,0.00002},
	{0,0,2,0,-6,4,0,0,0,0,0,2.266463971754662853896889,0.00002},
	{0,0,2,0,-6,4,0,0,2,-1,0,2.286393362884410418445214,0.00002},
	{0,0,2,0,-6,5,0,0,-2,0,0,1.396601646404500129960979,0.00005},
	{0,0,2,0,-6,5,0,0,-2,1,0,1.396602344536200801528025,0.00004},
	{0,0,2,0,-6,5,0,0,0,-1,0,1.383612906111158391553317,0.00005},
	{0,0,2,0,-6,5,0,0,0,0,0,1.411668724771116822935824,0.00010},
	{0,0,2,0,-6,5,0,0,0,1,0,1.396612118380012201868112,0.00001},
	{0,0,2,0,-6,5,0,0,2,-3,0,2.428655150214468427805059,0.00002},
	{0,0,2,0,-6,5,0,0,2,-2,0,4.457603372717604983677120,0.00003},
	{0,0,2,0,-6,5,0,0,2,-1,0,4.521725024106624246655883,0.00019},
	{0,0,2,0,-6,7,0,0,0,0,0,6.175564465777261702328360,0.00001},
	{0,0,2,0,-6,8,0,0,2,-2,0,4.046265396338057485081663,0.00003},
	{0,0,2,0,-6,10,0,0,0,0,0,2.821701203368488730660602,0.00001},
	{0,0,2,0,-6,10,0,0,2,-3,0,5.850927465319784914754564,0.00002},
	{0,0,2,0,-6,10,0,0,2,-1,0,2.709334811729991798756600,0.00002},
	{0,0,2,0,-5,0,0,0,-2,-1,0,3.649440356287618758557301,0.00003},
	{0,0,2,0,-5,0,0,0,-2,0,0,3.650740626580354586394606,0.00028},
	{0,0,2,0,-5,0,0,0,-2,1,0,3.649565496394986841011132,0.00032},
	{0,0,2,0,-5,0,0,0,0,-2,0,3.664646013796843959653415,0.00002},
	{0,0,2,0,-5,0,0,0,0,-1,0,3.663317992769001385511274,0.00039},
	{0,0,2,0,-5,0,0,0,0,0,0,3.667874698380108267059541,0.00084},
	{0,0,2,0,-5,0,0,0,0,1,0,3.678367443310172735237984,0.00014},
	{0,0,2,0,-5,0,0,0,1,0,-1,5.210699505917917306874187,0.00001},
	{0,0,2,0,-5,0,0,0,2,-2,0,0.512097404893506635836786,0.00012},
	{0,0,2,0,-5,0,0,0,2,-1,0,0.515012279277262341459220,0.00078},
	{0,0,2,0,-5,0,0,0,2,0,0,0.520735213894551796087740,0.00008},
	{0,0,2,0,-5,2,0,0,-2,0,0,3.320649123144544745400708,0.00007},
	{0,0,2,0,-5,2,0,0,-2,1,0,3.320649123144544745400708,0.00006},
	{0,0,2,0,-5,2,0,0,0,-1,0,3.336746120302763518594702,0.00008},
	{0,0,2,0,-5,2,0,0,0,0,0,3.330924050983961048899573,0.00016},
	{0,0,2,0,-5,2,0,0,0,1,0,3.327637246936605119884689,0.00003},
	{0,0,2,0,-5,2,0,0,2,-3,0,3.523550106407117965545694,0.00001},
	{0,0,2,0,-5,2,0,0,2,-2,0,0.180476469434174446870855,0.00003},
	{0,0,2,0,-5,2,0,0,2,-1,0,0.200466598021891484471269,0.00024},
	{0,0,2,0,-5,3,0,0,-2,0,0,3.735126423249654603608860,0.00004},
	{0,0,2,0,-5,3,0,0,-2,1,0,3.735126423249654603608860,0.00004},
	{0,0,2,0,-5,3,0,0,0,-2,0,0.586656823341153210726873,0.00001},
	{0,0,2,0,-5,3,0,0,0,-1,0,3.708600734744919247276584,0.00004},
	{0,0,2,0,-5,3,0,0,0,0,0,3.712264355377780766787055,0.00008},
	{0,0,2,0,-5,3,0,0,2,-3,0,1.789189376096947059480158,0.00002},
	{0,0,2,0,-5,3,0,0,2,-2,0,0.605525403351538593632597,0.00003},
	{0,0,2,0,-5,3,0,0,2,-1,0,0.560295544851955984455572,0.00016},
	{0,0,2,0,-5,4,0,0,-2,0,0,1.117263968550835206983152,0.00002},
	{0,0,2,0,-5,4,0,0,0,-1,0,1.017312802013474515305802,0.00003},
	{0,0,2,0,-5,4,0,0,0,0,0,1.087991131803461186677850,0.00005},
	{0,0,2,0,-5,4,0,0,2,-3,0,1.286954652273535115725167,0.00003},
	{0,0,2,0,-5,4,0,0,2,-2,0,4.176305864646875143364468,0.00005},
	{0,0,2,0,-5,4,0,0,2,-1,0,4.158900917747212488961850,0.00016},
	{0,0,2,0,-5,5,0,0,-2,-1,0,0.990166474426730225388837,0.00002},
	{0,0,2,0,-5,5,0,0,-2,0,0,0.990299643048657363131326,0.00014},
	{0,0,2,0,-5,5,0,0,-2,1,0,0.990420245299970081198637,0.00015},
	{0,0,2,0,-5,5,0,0,0,-2,0,0.938992722626555642584378,0.00002},
	{0,0,2,0,-5,5,0,0,0,-1,0,0.951082094756344753605504,0.00087},
	{0,0,2,0,-5,5,0,0,0,0,0,0.976148338940562187993066,0.00048},
	{0,0,2,0,-5,5,0,0,0,1,0,0.985803674895520010146299,0.00006},
	{0,0,2,0,-5,5,0,0,2,-3,0,4.326206085448286664529860,0.00004},
	{0,0,2,0,-5,5,0,0,2,-2,0,4.082901777199595905187834,0.00271},
	{0,0,2,0,-5,5,0,0,2,-1,0,4.087989586502084549124447,0.00410},
	{0,0,2,0,-5,5,0,0,2,0,0,4.038140190538323182067870,0.00028},
	{0,0,2,0,-5,5,0,0,2,1,0,4.087861479334987890865705,0.00002},
	{0,0,2,0,-5,5,0,0,4,-3,0,4.049689557797545802486638,0.00005},
	{0,0,2,0,-5,5,0,0,4,-2,0,4.086407271002226337941465,0.00008},
	{0,0,2,0,-5,5,0,0,4,-1,0,4.087616260575082982597905,0.00004},
	{0,0,2,0,-5,6,0,0,2,-3,0,2.942733154743137902187300,0.00002},
	{0,0,2,0,-5,6,0,0,2,-2,0,3.109841798370437615517403,0.00007},
	{0,0,2,0,-5,6,0,0,2,-1,0,6.084325808332931906363683,0.00002},
	{0,0,2,0,-4,0,0,0,-4,0,0,3.488776166390382904580747,0.00003},
	{0,0,2,0,-4,0,0,0,-4,1,0,3.488924519376802813042104,0.00006},
	{0,0,2,0,-4,0,0,0,-4,2,0,3.488956109836263586032601,0.00004},
	{0,0,2,0,-4,0,0,0,-2,-2,0,3.475336782084176512341855,0.00001},
	{0,0,2,0,-4,0,0,0,-2,-1,0,3.488210505179811793396993,0.00023},
	{0,0,2,0,-4,0,0,0,-2,0,0,3.479785800880434987192302,0.00248},
	{0,0,2,0,-4,0,0,0,-2,0,2,3.484524544332525231027375,0.00003},
	{0,0,2,0,-4,0,0,0,-2,1,0,3.487379379390012079653616,0.00258},
	{0,0,2,0,-4,0,0,0,-2,2,0,3.482836112814145401728183,0.00011},
	{0,0,2,0,-4,0,0,0,-1,0,0,0.352651629347088269028632,0.00003},
	{0,0,2,0,-4,0,0,0,-1,0,1,5.153046742868490071032284,0.00001},
	{0,0,2,0,-4,0,0,0,0,-3,0,3.488377009590452271226013,0.00001},
	{0,0,2,0,-4,0,0,0,0,-2,0,3.495216954929017738606944,0.00025},
	{0,0,2,0,-4,0,0,0,0,-1,0,3.495031600962456241887821,0.00425},
	{0,0,2,0,-4,0,0,0,0,0,0,3.498933808104065068533828,0.00672},
	{0,0,2,0,-4,0,0,0,0,1,0,3.508346368760070443926224,0.00112},
	{0,0,2,0,-4,0,0,0,0,2,0,3.508878345116078545373739,0.00007},
	{0,0,2,0,-4,0,0,0,1,0,-1,5.049952761947062995773194,0.00008},
	{0,0,2,0,-4,0,0,0,1,0,0,0.374063154077629522742399,0.00004},
	{0,0,2,0,-4,0,0,0,2,-3,0,0.347732593383267452047392,0.00010},
	{0,0,2,0,-4,0,0,0,2,-2,0,0.346185184468449258510248,0.00273},
	{0,0,2,0,-4,0,0,0,2,-1,-2,0.348018652847669307526246,0.00002},
	{0,0,2,0,-4,0,0,0,2,-1,0,0.344884739642788262781181,0.01312},
	{0,0,2,0,-4,0,0,0,2,-1,2,3.489611306437462534546512,0.00003},
	{0,0,2,0,-4,0,0,0,2,0,-2,0.349304960506389150509676,0.00001},
	{0,0,2,0,-4,0,0,0,2,0,0,0.376630009808537558058106,0.00105},
	{0,0,2,0,-4,0,0,0,2,1,0,0.349928043049351100712840,0.00008},
	{0,0,2,0,-4,0,0,0,4,-3,0,0.342768527924745158852460,0.00004},
	{0,0,2,0,-4,0,0,0,4,-2,0,0.346410506474881751959316,0.00020},
	{0,0,2,0,-4,0,0,0,4,-1,0,0.349246666509372472031458,0.00013},
	{0,0,2,0,-4,1,0,0,-2,0,0,0.267106934054464173478038,0.00002},
	{0,0,2,0,-4,1,0,0,0,0,0,0.273240719177673063722267,0.00004},
	{0,0,2,0,-4,1,0,0,2,-3,0,0.476941761369360450739663,0.00001},
	{0,0,2,0,-4,1,0,0,2,-2,0,3.357222323087161175436677,0.00002},
	{0,0,2,0,-4,1,0,0,2,-1,0,3.311291540359977414453851,0.00006},
	{0,0,2,0,-4,2,0,0,-2,-1,0,3.188788276425897016963518,0.00002},
	{0,0,2,0,-4,2,0,0,-2,0,0,3.188952860974359815315893,0.00018},
	{0,0,2,0,-4,2,0,0,-2,1,0,3.189103308355881960522993,0.00019},
	{0,0,2,0,-4,2,0,0,0,-2,0,3.179867724086029134866749,0.00002},
	{0,0,2,0,-4,2,0,0,0,-1,0,3.183760680982602231381406,0.00072},
	{0,0,2,0,-4,2,0,0,0,0,0,3.181507984517053078121762,0.00057},
	{0,0,2,0,-4,2,0,0,0,1,0,3.184558645516613939463468,0.00008},
	{0,0,2,0,-4,2,0,0,2,-2,0,0.039756331432403237136075,0.00129},
	{0,0,2,0,-4,2,0,0,2,-1,0,0.041586309153119289938605,0.00304},
	{0,0,2,0,-4,2,0,0,2,0,0,0.039395222810165608784416,0.00022},
	{0,0,2,0,-4,2,0,0,4,-3,0,6.267610512533564381953965,0.00003},
	{0,0,2,0,-4,2,0,0,4,-2,0,0.039170249869583534385598,0.00005},
	{0,0,2,0,-4,2,0,0,4,-1,0,0.041345628249269274212541,0.00003},
	{0,0,2,0,-4,3,0,0,-2,0,0,4.174170279774135572381510,0.00007},
	{0,0,2,0,-4,3,0,0,-2,1,0,4.174170279774135572381510,0.00007},
	{0,0,2,0,-4,3,0,0,0,-2,0,0.998924362080312544520666,0.00003},
	{0,0,2,0,-4,3,0,0,0,-1,0,4.139733362835960051029360,0.00085},
	{0,0,2,0,-4,3,0,0,0,0,0,4.153064187662693029778893,0.00026},
	{0,0,2,0,-4,3,0,0,0,1,0,4.167000641739868171953276,0.00003},
	{0,0,2,0,-4,3,0,0,2,-4,0,0.918744459842468663701709,0.00002},
	{0,0,2,0,-4,3,0,0,2,-3,0,0.918231333042382247278113,0.00023},
	{0,0,2,0,-4,3,0,0,2,-2,0,1.000478054180437892384248,0.00819},
	{0,0,2,0,-4,3,0,0,2,-1,0,0.997691461496703846378864,0.00495},
	{0,0,2,0,-4,3,0,0,2,0,0,0.998654359645029021663731,0.00034},
	{0,0,2,0,-4,3,0,0,2,1,0,0.997401911373797966930965,0.00002},
	{0,0,2,0,-4,3,0,0,4,-3,0,1.028260554279534000343688,0.00014},
	{0,0,2,0,-4,3,0,0,4,-2,0,1.000937948438338498391431,0.00016},
	{0,0,2,0,-4,3,0,0,4,-1,0,0.998403206765667072808412,0.00005},
	{0,0,2,0,-4,4,-2,0,2,-2,0,3.051882031905583936293169,0.00040},
	{0,0,2,0,-4,4,0,0,-2,0,0,2.052199673331130291842328,0.00002},
	{0,0,2,0,-4,4,0,0,0,-1,0,5.182550312142978121698889,0.00004},
	{0,0,2,0,-4,4,0,0,0,0,0,2.047072768653396934723787,0.00003},
	{0,0,2,0,-4,4,0,0,2,-2,0,5.155067310543524072841137,0.00012},
	{0,0,2,0,-4,4,0,0,2,-1,0,2.040959229349510906104115,0.00020},
	{0,0,2,0,-4,5,0,0,-4,1,0,6.130091657445801978099098,0.00002},
	{0,0,2,0,-4,5,0,0,-2,-1,0,6.130074378686207303701394,0.00005},
	{0,0,2,0,-4,5,0,0,-2,0,0,6.130234076312763846772214,0.00047},
	{0,0,2,0,-4,5,0,0,-2,1,0,6.130215924888543277404551,0.00050},
	{0,0,2,0,-4,5,0,0,-2,2,0,6.130123073372337749731287,0.00001},
	{0,0,2,0,-4,5,0,0,0,-2,0,2.984237607954338677984651,0.00009},
	{0,0,2,0,-4,5,0,0,0,-1,0,2.987965456703673527982801,0.00103},
	{0,0,2,0,-4,5,0,0,0,0,0,6.134258631034938069603868,0.00105},
	{0,0,2,0,-4,5,0,0,0,1,0,6.131216696681637046140168,0.00017},
	{0,0,2,0,-4,5,0,0,0,2,0,6.093814465344324027284983,0.00003},
	{0,0,2,0,-4,5,0,0,2,-3,0,2.594136274314283063802122,0.00005},
	{0,0,2,0,-4,5,0,0,2,-2,0,2.982126108625275939800758,0.00133},
	{0,0,2,0,-4,5,0,0,2,-1,0,6.130269855562429981432615,0.00632},
	{0,0,2,0,-4,5,0,0,2,0,-2,2.925105852896770830540163,0.00001},
	{0,0,2,0,-4,5,0,0,2,0,0,6.134672274067661135177332,0.00035},
	{0,0,2,0,-4,5,0,0,2,1,0,6.129853594535829230949275,0.00003},
	{0,0,2,0,-4,5,0,0,2,2,0,2.936397260492547900412319,0.00001},
	{0,0,2,0,-4,5,0,0,4,-3,0,3.198069064723377152859030,0.00002},
	{0,0,2,0,-4,5,0,0,4,-2,0,6.117172032190838493193041,0.00007},
	{0,0,2,0,-4,5,0,0,4,-1,0,6.129542053264348311358845,0.00006},
	{0,0,2,0,-4,6,-3,0,0,0,0,2.945462151561556662926478,0.00001},
	{0,0,2,0,-4,6,-3,0,2,-1,0,3.023606825358649885515661,0.00003},
	{0,0,2,0,-3,-5,0,0,0,0,0,3.829214330697865431574201,0.00001},
	{0,0,2,0,-3,-1,0,0,0,0,0,2.701042752453766571107963,0.00001},
	{0,0,2,0,-3,0,0,0,-6,1,0,3.317294600322211906018310,0.00001},
	{0,0,2,0,-3,0,0,0,-4,-1,0,3.316098700718745462268089,0.00004},
	{0,0,2,0,-3,0,0,0,-4,0,0,3.300867561402441197060398,0.00019},
	{0,0,2,0,-3,0,0,0,-4,0,2,3.320235305578897122558146,0.00002},
	{0,0,2,0,-3,0,0,0,-4,1,0,3.327059542954195148212193,0.00043},
	{0,0,2,0,-3,0,0,0,-4,2,0,3.322076977005601783332622,0.00023},
	{0,0,2,0,-3,0,0,0,-3,0,0,3.319491620784622121220764,0.00002},
	{0,0,2,0,-3,0,0,0,-3,1,0,0.178193229706715472460132,0.00002},
	{0,0,2,0,-3,0,0,0,-2,-3,0,3.318164472421405886137791,0.00002},
	{0,0,2,0,-3,0,0,0,-2,-2,0,3.321002552318073952619670,0.00020},
	{0,0,2,0,-3,0,0,0,-2,-1,0,3.321226652594030159804106,0.00220},
	{0,0,2,0,-3,0,0,0,-2,-1,2,0.178900088053773165253091,0.00002},
	{0,0,2,0,-3,0,0,0,-2,0,-2,0.181618438363754325370891,0.00004},
	{0,0,2,0,-3,0,0,0,-2,0,0,3.319747311520039989574116,0.01841},
	{0,0,2,0,-3,0,0,0,-2,0,2,3.319976996849602457473338,0.00016},
	{0,0,2,0,-3,0,0,0,-2,1,-2,0.181180884320279372845519,0.00004},
	{0,0,2,0,-3,0,0,0,-2,1,0,3.321324216499216053222199,0.01814},
	{0,0,2,0,-3,0,0,0,-2,2,0,3.323202539840212743627035,0.00075},
	{0,0,2,0,-3,0,0,0,-2,3,0,3.321869282824614355575932,0.00005},
	{0,0,2,0,-3,0,0,0,-1,-1,0,0.176029894098868489038523,0.00006},
	{0,0,2,0,-3,0,0,0,-1,-1,1,3.276555473988010724895048,0.00002},
	{0,0,2,0,-3,0,0,0,-1,0,0,0.192653282559488492342581,0.00032},
	{0,0,2,0,-3,0,0,0,-1,0,1,5.105952174596076531543076,0.00004},
	{0,0,2,0,-3,0,0,0,-1,1,0,0.182019340492937442554933,0.00004},
	{0,0,2,0,-3,0,0,0,0,-3,0,3.323698911479480155861665,0.00011},
	{0,0,2,0,-3,0,0,0,0,-2,-2,0.176507241649288937335172,0.00002},
	{0,0,2,0,-3,0,0,0,0,-2,0,3.320815103956409775065595,0.00320},
	{0,0,2,0,-3,0,0,0,0,-2,2,0.175474879396734284586756,0.00004},
	{0,0,2,0,-3,0,0,0,0,-1,-2,0.177557929858989521632040,0.00019},
	{0,0,2,0,-3,0,0,0,0,-1,0,3.319261935455060097410751,0.09518},
	{0,0,2,0,-3,0,0,0,0,-1,2,3.328241479923645496086237,0.00001},
	{0,0,2,0,-3,0,0,0,0,0,-2,0.150626103237315428495791,0.00002},
	{0,0,2,0,-3,0,0,0,0,0,0,3.323735214327921738686200,0.05167},
	{0,0,2,0,-3,0,0,0,0,0,2,0.181407777123038627120621,0.00006},
	{0,0,2,0,-3,0,0,0,0,1,0,3.325126590807610860167642,0.00813},
	{0,0,2,0,-3,0,0,0,0,1,2,0.185271936086954053246600,0.00003},
	{0,0,2,0,-3,0,0,0,0,2,0,3.327951580734889613921723,0.00058},
	{0,0,2,0,-3,0,0,0,0,3,0,3.329490612069297750252872,0.00004},
	{0,0,2,0,-3,0,0,0,1,-2,0,3.327441246461606105810915,0.00004},
	{0,0,2,0,-3,0,0,0,1,-1,-1,4.817339642564388846324164,0.00003},
	{0,0,2,0,-3,0,0,0,1,-1,0,0.178155530594872407723628,0.00044},
	{0,0,2,0,-3,0,0,0,1,-1,1,1.734476620172503702477229,0.00003},
	{0,0,2,0,-3,0,0,0,1,0,-1,4.857008533001266670225959,0.00031},
	{0,0,2,0,-3,0,0,0,1,0,0,0.139823736897946915291868,0.00039},
	{0,0,2,0,-3,0,0,0,1,0,1,1.754125711424381117709004,0.00002},
	{0,0,2,0,-3,0,0,0,1,1,-1,4.817339642564388846324164,0.00003},
	{0,0,2,0,-3,0,0,0,1,1,0,0.141320007665681646180644,0.00003},
	{0,0,2,0,-3,0,0,0,2,-5,0,0.177205722415937072522496,0.00005},
	{0,0,2,0,-3,0,0,0,2,-4,0,0.177218986918252219275871,0.00064},
	{0,0,2,0,-3,0,0,0,2,-3,-2,3.317482921348501978542345,0.00004},
	{0,0,2,0,-3,0,0,0,2,-3,0,0.177180589674708344194443,0.00936},
	{0,0,2,0,-3,0,0,0,2,-2,-2,3.316313899815515942037791,0.00024},
	{0,0,2,0,-3,0,0,0,2,-2,0,0.175202258967572771508614,0.28281},
	{0,0,2,0,-3,0,0,0,2,-2,2,3.316899632312485746155062,0.00029},
	{0,0,2,0,-3,0,0,0,2,-1,-2,0.175877003256393771302157,0.00070},
	{0,0,2,0,-3,0,0,0,2,-1,0,0.175754830208754181386510,0.44532},
	{0,0,2,0,-3,0,0,0,2,-1,2,3.317566348086747218815162,0.00092},
	{0,0,2,0,-3,0,0,0,2,0,-2,0.204147497414347539601565,0.00014},
	{0,0,2,0,-3,0,0,0,2,0,0,0.176030417697644103736110,0.03174},
	{0,0,2,0,-3,0,0,0,2,0,2,3.317571758607428922260851,0.00016},
	{0,0,2,0,-3,0,0,0,2,1,-2,3.319724273173913164924898,0.00005},
	{0,0,2,0,-3,0,0,0,2,1,0,0.174422096791931324766267,0.00223},
	{0,0,2,0,-3,0,0,0,2,1,2,3.317624293017913839065614,0.00002},
	{0,0,2,0,-3,0,0,0,2,2,0,0.176301292797553604829730,0.00017},
	{0,0,2,0,-3,0,0,0,3,-2,0,3.316353344256611102025545,0.00013},
	{0,0,2,0,-3,0,0,0,3,-1,0,3.317571584074503476813334,0.00017},
	{0,0,2,0,-3,0,0,0,3,0,0,3.317623943952062948170578,0.00002},
	{0,0,2,0,-3,0,0,0,4,-4,0,0.172371160387912780720399,0.00012},
	{0,0,2,0,-3,0,0,0,4,-3,0,0.174389982733694604011276,0.00440},
	{0,0,2,0,-3,0,0,0,4,-3,2,3.316568717886307471331975,0.00002},
	{0,0,2,0,-3,0,0,0,4,-2,-2,0.175441543608021222055982,0.00004},
	{0,0,2,0,-3,0,0,0,4,-2,0,0.173962377066955997673148,0.00897},
	{0,0,2,0,-3,0,0,0,4,-2,2,3.317328983308476253455410,0.00005},
	{0,0,2,0,-3,0,0,0,4,-1,-2,3.316996149020120743244888,0.00011},
	{0,0,2,0,-3,0,0,0,4,-1,0,0.175955368539808337802199,0.00447},
	{0,0,2,0,-3,0,0,0,4,-1,2,3.317615217305803554381782,0.00002},
	{0,0,2,0,-3,0,0,0,4,0,0,0.177310791236907128176625,0.00066},
	{0,0,2,0,-3,0,0,0,4,1,0,0.181025899082702251829957,0.00006},
	{0,0,2,0,-3,0,0,0,6,-4,0,0.174426111049210907921747,0.00006},
	{0,0,2,0,-3,0,0,0,6,-3,0,0.175397212245020528431638,0.00017},
	{0,0,2,0,-3,0,0,0,6,-2,0,0.175536140453479289069705,0.00015},
	{0,0,2,0,-3,0,0,0,6,-1,0,0.176018374925805326514094,0.00005},
	{0,0,2,0,-3,0,1,0,2,-3,0,0.012755389772350158444914,0.00001},
	{0,0,2,0,-3,0,1,0,2,-2,0,3.154464282290326160307359,0.00002},
	{0,0,2,0,-3,0,1,0,2,-1,0,3.154348043362143361179051,0.00001},
	{0,0,2,0,-3,0,2,0,2,-2,0,6.104413675358760116296253,0.00030},
	{0,0,2,0,-3,0,2,0,2,-1,0,6.104777052909025059079795,0.00007},
	{0,0,2,0,-3,1,0,0,-2,0,0,0.062868854051938150018231,0.00007},
	{0,0,2,0,-3,1,0,0,-2,1,0,0.062868854051938150018231,0.00007},
	{0,0,2,0,-3,1,0,0,0,-3,0,3.160061902267322420101436,0.00002},
	{0,0,2,0,-3,1,0,0,0,-2,0,3.164528897954876907050448,0.00020},
	{0,0,2,0,-3,1,0,0,0,-1,0,3.165987295077842933466172,0.00121},
	{0,0,2,0,-3,1,0,0,0,0,0,0.103851802882642993419715,0.00005},
	{0,0,2,0,-3,1,0,0,0,1,0,0.062868854051938150018231,0.00001},
	{0,0,2,0,-3,1,0,0,2,-4,0,3.138375662712516778185545,0.00002},
	{0,0,2,0,-3,1,0,0,2,-3,0,3.138487538317570102464060,0.00037},
	{0,0,2,0,-3,1,0,0,2,-2,0,3.164240744095372370736641,0.01126},
	{0,0,2,0,-3,1,0,0,2,-1,0,0.025418626160195016694399,0.00479},
	{0,0,2,0,-3,1,0,0,2,0,0,0.025521251520212281244104,0.00031},
	{0,0,2,0,-3,1,0,0,2,1,0,0.025102896098509241973318,0.00003},
	{0,0,2,0,-3,1,0,0,4,-3,0,3.175080984079509338613434,0.00018},
	{0,0,2,0,-3,1,0,0,4,-2,0,3.163426547999316884585141,0.00006},
	{0,0,2,0,-3,1,0,0,4,-1,0,0.025978527784234796416118,0.00003},
	{0,0,2,0,-3,2,0,0,-2,0,0,3.541142327135520240233291,0.00008},
	{0,0,2,0,-3,2,0,0,-2,1,0,3.541142327135520240233291,0.00008},
	{0,0,2,0,-3,2,0,0,0,-2,0,0.197074201554790134904849,0.00001},
	{0,0,2,0,-3,2,0,0,0,-1,0,0.185835502902423010951338,0.00018},
	{0,0,2,0,-3,2,0,0,0,0,0,3.449367679077902426598712,0.00015},
	{0,0,2,0,-3,2,0,0,0,1,0,3.419337718501013423377799,0.00003},
	{0,0,2,0,-3,2,0,0,2,-3,0,0.025262244659216323561246,0.00004},
	{0,0,2,0,-3,2,0,0,2,-2,0,0.183499030632778198368626,0.00033},
	{0,0,2,0,-3,2,0,0,2,-1,0,3.341704426174754605227690,0.00106},
	{0,0,2,0,-3,2,0,0,2,0,0,3.376472083006182511866200,0.00006},
	{0,0,2,0,-3,2,0,0,4,-2,0,3.336057936978702453956203,0.00001},
	{0,0,2,0,-3,3,0,0,0,0,0,0.179086838283736560217818,0.00001},
	{0,0,2,0,-3,3,0,0,2,-3,0,4.449056146304737779928473,0.00002},
	{0,0,2,0,-3,3,0,0,2,-1,0,5.830712363791485941533210,0.00002},
	{0,0,2,0,-3,5,0,0,-2,0,0,1.333158579028655976728146,0.00005},
	{0,0,2,0,-3,5,0,0,-2,1,0,1.326807151347723312539983,0.00004},
	{0,0,2,0,-3,5,0,0,0,-1,0,1.352728257799567401775676,0.00001},
	{0,0,2,0,-3,5,0,0,0,0,0,1.463001999664923724608911,0.00004},
	{0,0,2,0,-3,5,0,0,0,1,0,1.352728257799567401775676,0.00001},
	{0,0,2,0,-3,5,0,0,2,-2,0,2.782017128567118469106845,0.00002},
	{0,0,2,0,-3,5,0,0,2,-1,0,2.272742270139936682227244,0.00005},
	{0,0,2,0,-3,5,0,0,2,0,0,2.782017128567118469106845,0.00002},
	{0,0,2,0,-2,-5,0,0,-2,0,0,3.636481461124486003200218,0.00003},
	{0,0,2,0,-2,-5,0,0,-2,1,0,3.636419152870189908099974,0.00003},
	{0,0,2,0,-2,-5,0,0,0,-1,0,3.654928718653440267161159,0.00002},
	{0,0,2,0,-2,-5,0,0,0,0,0,3.655762986035893558067755,0.00007},
	{0,0,2,0,-2,-5,0,0,2,-3,0,3.663179762692243102151224,0.00002},
	{0,0,2,0,-2,-5,0,0,2,-2,0,0.495630223400940150835225,0.00001},
	{0,0,2,0,-2,-5,0,0,2,-1,0,0.513335890530721816737980,0.00011},
	{0,0,2,0,-2,-3,0,0,0,0,0,3.160703310767430274097478,0.00001},
	{0,0,2,0,-2,-3,0,0,2,-3,0,3.122562805156523513261391,0.00002},
	{0,0,2,0,-2,-3,0,0,2,-1,0,6.264155458746317073348564,0.00002},
	{0,0,2,0,-2,-2,0,0,-2,0,0,5.879399021407568426411672,0.00001},
	{0,0,2,0,-2,-2,0,0,0,-1,0,6.033487159749140182896099,0.00015},
	{0,0,2,0,-2,-2,0,0,0,0,0,5.916835635731145792703956,0.00003},
	{0,0,2,0,-2,-2,0,0,2,-3,0,3.182853633370340773467433,0.00001},
	{0,0,2,0,-2,-2,0,0,2,-2,0,2.886026011082440945187955,0.00141},
	{0,0,2,0,-2,-2,0,0,2,-1,0,2.890895130629654197207401,0.00091},
	{0,0,2,0,-2,-2,0,0,2,0,0,2.891350137965649214066843,0.00006},
	{0,0,2,0,-2,-2,0,0,4,-3,0,2.858700612714442090833700,0.00003},
	{0,0,2,0,-2,-2,0,0,4,-2,0,2.886278560225204348199668,0.00003},
	{0,0,2,0,-2,-1,0,0,-2,0,0,2.565200635178394250601741,0.00002},
	{0,0,2,0,-2,-1,0,0,0,-1,0,6.075187787968264530036322,0.00004},
	{0,0,2,0,-2,-1,0,0,0,0,0,2.627090359519963502776818,0.00002},
	{0,0,2,0,-2,-1,0,0,2,-3,0,2.799527144287751401208197,0.00004},
	{0,0,2,0,-2,-1,0,0,2,-2,0,6.100129241110963995708971,0.00010},
	{0,0,2,0,-2,-1,0,0,2,-1,0,2.933592865450443731845098,0.00019},
	{0,0,2,0,-2,0,0,0,-6,1,0,3.158725154593220008081289,0.00004},
	{0,0,2,0,-2,0,0,0,-6,2,0,3.165196486393764274680507,0.00003},
	{0,0,2,0,-2,0,0,0,-6,3,0,3.156681897637910516607462,0.00001},
	{0,0,2,0,-2,0,0,0,-4,-1,0,3.116011886342088033075015,0.00012},
	{0,0,2,0,-2,0,0,0,-4,0,0,3.174712196008562692384203,0.00093},
	{0,0,2,0,-2,0,0,0,-4,1,-2,0.015058526253281875537104,0.00002},
	{0,0,2,0,-2,0,0,0,-4,1,0,3.166360446471919498634406,0.00211},
	{0,0,2,0,-2,0,0,0,-4,1,2,3.157622804637660429705193,0.00002},
	{0,0,2,0,-2,0,0,0,-4,2,0,3.163944561721308890156479,0.00121},
	{0,0,2,0,-2,0,0,0,-4,3,0,3.157219109981673987874728,0.00004},
	{0,0,2,0,-2,0,0,0,-3,-1,0,3.161026545744899607370826,0.00004},
	{0,0,2,0,-2,0,0,0,-3,0,0,3.165962162336614316160421,0.00005},
	{0,0,2,0,-2,0,0,0,-3,1,0,0.016643110681167527786783,0.00012},
	{0,0,2,0,-2,0,0,0,-3,2,0,0.019901116795865342323779,0.00002},
	{0,0,2,0,-2,0,0,0,-2,-3,0,3.171092034074076249083873,0.00003},
	{0,0,2,0,-2,0,0,0,-2,-2,0,3.169292599615269878654544,0.00022},
	{0,0,2,0,-2,0,0,0,-2,-1,-2,0.014214834092867816711658,0.00004},
	{0,0,2,0,-2,0,0,0,-2,-1,0,3.166039480422477847554319,0.00527},
	{0,0,2,0,-2,0,0,0,-2,-1,2,0.015121881705129269421461,0.00016},
	{0,0,2,0,-2,0,0,0,-2,0,-2,0.013971884260990205528508,0.00019},
	{0,0,2,0,-2,0,0,0,-2,0,0,3.158333502709072426739567,0.08408},
	{0,0,2,0,-2,0,0,0,-2,0,2,3.157312659629580853248854,0.00079},
	{0,0,2,0,-2,0,0,0,-2,1,-2,0.014368597599968517888880,0.00024},
	{0,0,2,0,-2,0,0,0,-2,1,0,3.156621683778716214163751,0.08911},
	{0,0,2,0,-2,0,0,0,-2,1,2,0.016803680972351006661647,0.00004},
	{0,0,2,0,-2,0,0,0,-2,2,0,3.156604055953271537049432,0.00380},
	{0,0,2,0,-2,0,0,0,-2,3,0,3.158801949080307647221844,0.00025},
	{0,0,2,0,-2,0,0,0,-2,4,0,3.156895176872503760989730,0.00002},
	{0,0,2,0,-2,0,0,0,-1,-2,0,3.147334786828854813478529,0.00003},
	{0,0,2,0,-2,0,0,0,-1,-1,0,3.133087140546049642608750,0.00006},
	{0,0,2,0,-2,0,0,0,-1,-1,1,3.099481000331823388194152,0.00004},
	{0,0,2,0,-2,0,0,0,-1,0,0,0.023346222206376950059070,0.00129},
	{0,0,2,0,-2,0,0,0,-1,0,1,6.171449852065684638091625,0.00006},
	{0,0,2,0,-2,0,0,0,-1,1,0,0.008078780041631353561749,0.00015},
	{0,0,2,0,-2,0,0,0,-1,2,0,0.003247359606260649764892,0.00002},
	{0,0,2,0,-2,0,0,0,0,-4,0,0.001231678853132398216222,0.00009},
	{0,0,2,0,-2,0,0,0,0,-3,0,0.000248883951334391399519,0.00107},
	{0,0,2,0,-2,0,0,0,0,-2,-2,3.142660969624938793742785,0.00009},
	{0,0,2,0,-2,0,0,0,0,-2,0,6.282930838174645593596779,0.01434},
	{0,0,2,0,-2,0,0,0,0,-1,-2,3.140881257386680225351938,0.00037},
	{0,0,2,0,-2,0,0,0,0,-1,0,6.282914781145527705064069,0.18256},
	{0,0,2,0,-2,0,0,0,0,-1,2,0.042936670395387302456847,0.00002},
	{0,0,2,0,-2,0,0,0,0,0,-2,3.143314944495661400480913,0.00007},
	{0,0,2,0,-2,0,0,0,0,0,0,3.149203685391890328304498,0.18457},
	{0,0,2,0,-2,0,0,0,0,0,2,0.007463551480303351470802,0.00011},
	{0,0,2,0,-2,0,0,0,0,1,-2,0.006405881953594787757422,0.00014},
	{0,0,2,0,-2,0,0,0,0,1,0,3.148735762619430111897145,0.03337},
	{0,0,2,0,-2,0,0,0,0,1,2,0.005434606224859942977257,0.00007},
	{0,0,2,0,-2,0,0,0,0,2,0,3.147487328605478751342162,0.00230},
	{0,0,2,0,-2,0,0,0,0,2,2,0.008946034146947334786404,0.00001},
	{0,0,2,0,-2,0,0,0,0,3,0,3.148748328990044420550021,0.00015},
	{0,0,2,0,-2,0,0,0,1,-2,0,3.143288764556881442757685,0.00016},
	{0,0,2,0,-2,0,0,0,1,-1,-1,3.010658402171028757976501,0.00001},
	{0,0,2,0,-2,0,0,0,1,-1,0,3.142645087128745906568383,0.00068},
	{0,0,2,0,-2,0,0,0,1,-1,1,3.099481000331823388194152,0.00002},
	{0,0,2,0,-2,0,0,0,1,0,-1,3.557354865090220474854732,0.00007},
	{0,0,2,0,-2,0,0,0,1,0,0,0.010499202648297088769080,0.00128},
	{0,0,2,0,-2,0,0,0,1,1,-1,3.010658402171028757976501,0.00001},
	{0,0,2,0,-2,0,0,0,1,1,0,0.003219434338228740338783,0.00011},
	{0,0,2,0,-2,0,0,0,2,-5,0,0.000958534825195285727743,0.00002},
	{0,0,2,0,-2,0,0,0,2,-4,0,0.000979304243294018246860,0.00035},
	{0,0,2,0,-2,0,0,0,2,-3,-2,3.142483295107085794484192,0.00003},
	{0,0,2,0,-2,0,0,0,2,-3,0,0.001158549557473835794202,0.00553},
	{0,0,2,0,-2,0,0,0,2,-2,-2,3.142942316700360283476812,0.00029},
	{0,0,2,0,-2,0,0,0,2,-2,0,0.001508313539573499437174,0.24515},
	{0,0,2,0,-2,0,0,0,2,-2,2,3.142544207097980546450344,0.00011},
	{0,0,2,0,-2,0,0,0,2,-1,-2,3.143679369243477683681931,0.00251},
	{0,0,2,0,-2,0,0,0,2,-1,0,3.143683034434906709009283,1.14307},
	{0,0,2,0,-2,0,0,0,2,-1,2,0.002136632070291458272010,0.00227},
	{0,0,2,0,-2,0,0,0,2,0,-2,0.001795245668601367196662,0.00158},
	{0,0,2,0,-2,0,0,0,2,0,0,3.143892823010996373511716,0.06863},
	{0,0,2,0,-2,0,0,0,2,0,2,0.002502802147359868382981,0.00038},
	{0,0,2,0,-2,0,0,0,2,1,-2,3.143395055108328062232204,0.00045},
	{0,0,2,0,-2,0,0,0,2,1,0,3.144703528448547835694171,0.00504},
	{0,0,2,0,-2,0,0,0,2,1,2,0.002126334627704691733474,0.00005},
	{0,0,2,0,-2,0,0,0,2,2,-2,3.143577442015160983146416,0.00004},
	{0,0,2,0,-2,0,0,0,2,2,0,3.140974807034587090726063,0.00034},
	{0,0,2,0,-2,0,0,0,2,3,0,3.140683860648279868144073,0.00003},
	{0,0,2,0,-2,0,0,0,3,-2,0,0.003181560693460463475069,0.00004},
	{0,0,2,0,-2,0,0,0,3,-1,0,0.002161241212744578407690,0.00047},
	{0,0,2,0,-2,0,0,0,3,0,0,0.002493377369399099163089,0.00005},
	{0,0,2,0,-2,0,0,0,4,-5,0,0.001745503784919528924430,0.00001},
	{0,0,2,0,-2,0,0,0,4,-4,0,0.001739744198387947879056,0.00015},
	{0,0,2,0,-2,0,0,0,4,-3,0,0.001573239787747688625194,0.00429},
	{0,0,2,0,-2,0,0,0,4,-3,2,3.142949298017368331414900,0.00002},
	{0,0,2,0,-2,0,0,0,4,-2,-2,0.002005208777616285242829,0.00008},
	{0,0,2,0,-2,0,0,0,4,-2,0,3.143840114067586455348646,0.01229},
	{0,0,2,0,-2,0,0,0,4,-2,2,0.002254616327726274589011,0.00007},
	{0,0,2,0,-2,0,0,0,4,-1,-2,0.002156005224988595363189,0.00043},
	{0,0,2,0,-2,0,0,0,4,-1,0,3.143796829902136824586023,0.01038},
	{0,0,2,0,-2,0,0,0,4,-1,2,0.002126683693555090400723,0.00006},
	{0,0,2,0,-2,0,0,0,4,0,-2,0.004687954370856769158171,0.00002},
	{0,0,2,0,-2,0,0,0,4,0,0,3.143599607696661468736465,0.00141},
	{0,0,2,0,-2,0,0,0,4,1,0,3.143858963623507918327959,0.00012},
	{0,0,2,0,-2,0,0,0,5,-2,0,0.002128952621582683255724,0.00002},
	{0,0,2,0,-2,0,0,0,6,-4,0,0.001551423172097759562230,0.00006},
	{0,0,2,0,-2,0,0,0,6,-3,0,3.144054789565581931043425,0.00013},
	{0,0,2,0,-2,0,0,0,6,-2,0,3.143831038355476170664815,0.00026},
	{0,0,2,0,-2,0,0,0,6,-1,0,3.143855472965003894358915,0.00012},
	{0,0,2,0,-2,0,0,0,6,0,0,3.143719337283348291833818,0.00003},
	{0,0,2,0,-2,0,0,0,8,-3,0,3.143721606211375974027078,0.00002},
	{0,0,2,0,-2,1,0,0,-2,0,0,0.728371973549486462218283,0.00002},
	{0,0,2,0,-2,1,0,0,0,0,0,0.588922435243167008422915,0.00003},
	{0,0,2,0,-2,1,0,0,2,-3,0,5.779346451240666482362940,0.00002},
	{0,0,2,0,-2,1,0,0,2,-1,0,0.104758501429054046161227,0.00005},
	{0,0,2,0,-2,2,0,0,-2,0,0,4.947816094120354613039581,0.00005},
	{0,0,2,0,-2,2,0,0,-2,1,0,4.947861472680906480547947,0.00005},
	{0,0,2,0,-2,2,0,0,0,-1,0,1.747095699730272899685701,0.00004},
	{0,0,2,0,-2,2,0,0,0,0,0,4.932841867269943669782606,0.00009},
	{0,0,2,0,-2,2,0,0,0,1,0,4.941742697389265082108523,0.00001},
	{0,0,2,0,-2,2,0,0,2,-2,0,1.830577939445815260910422,0.00002},
	{0,0,2,0,-2,2,0,0,2,-1,0,4.903577931701755154847433,0.00024},
	{0,0,2,0,-2,3,0,0,-2,0,0,2.952679611617328614414646,0.00006},
	{0,0,2,0,-2,3,0,0,-2,1,0,2.952568085078126181031166,0.00005},
	{0,0,2,0,-2,3,0,0,0,-1,0,6.134156703806621813157562,0.00004},
	{0,0,2,0,-2,3,0,0,0,0,0,2.972337429515465867524426,0.00011},
	{0,0,2,0,-2,3,0,0,0,1,0,2.959177123356653282826301,0.00002},
	{0,0,2,0,-2,3,0,0,2,-2,0,6.074863331260318410897980,0.00002},
	{0,0,2,0,-2,3,0,0,2,-1,0,2.983360754538136649927083,0.00027},
	{0,0,2,0,-2,3,0,0,2,0,0,2.983360754538136649927083,0.00002},
	{0,0,2,0,-2,5,0,0,-2,0,0,1.866684787412298485165252,0.00003},
	{0,0,2,0,-2,5,0,0,-2,1,0,2.935036252741843210145589,0.00002},
	{0,0,2,0,-2,5,0,0,0,0,0,1.665913454903008794616426,0.00002},
	{0,0,2,0,-2,5,0,0,2,-3,0,2.456831920191589802016097,0.00003},
	{0,0,2,0,-2,5,0,0,2,-1,0,2.340068695101468865260586,0.00003},
	{0,0,2,0,-1,-5,0,0,-2,-1,0,3.469388001861679171611286,0.00001},
	{0,0,2,0,-1,-5,0,0,-2,0,0,3.469090597757139349255340,0.00013},
	{0,0,2,0,-1,-5,0,0,-2,1,0,3.469081696577954065929816,0.00014},
	{0,0,2,0,-1,-5,0,0,0,-2,0,3.470677451113052036646422,0.00002},
	{0,0,2,0,-1,-5,0,0,0,-1,0,3.472958596445409273911764,0.00078},
	{0,0,2,0,-1,-5,0,0,0,0,0,3.478052514400279626727297,0.00046},
	{0,0,2,0,-1,-5,0,0,0,1,0,3.474997839143439293252413,0.00006},
	{0,0,2,0,-1,-5,0,0,2,-3,0,0.951652119290046116795168,0.00002},
	{0,0,2,0,-1,-5,0,0,2,-2,0,0.325712995941331351357206,0.00224},
	{0,0,2,0,-1,-5,0,0,2,-1,0,0.330958059409424742991490,0.00362},
	{0,0,2,0,-1,-5,0,0,2,0,0,0.330803597770623236673515,0.00026},
	{0,0,2,0,-1,-5,0,0,4,-3,0,0.266500083073545779299707,0.00005},
	{0,0,2,0,-1,-5,0,0,4,-2,0,0.326687762328570219239054,0.00007},
	{0,0,2,0,-1,-5,0,0,4,-1,0,0.330754728551567400707256,0.00003},
	{0,0,2,0,-1,-4,0,0,2,-3,0,3.430476584320166111297112,0.00002},
	{0,0,2,0,-1,-4,0,0,2,-2,0,5.230635180232972913927370,0.00011},
	{0,0,2,0,-1,-4,0,0,2,-1,0,2.730028831605038064367363,0.00005},
	{0,0,2,0,-1,-3,0,0,0,0,0,2.401254702688633724250167,0.00001},
	{0,0,2,0,-1,-3,0,0,2,-3,0,5.393868145723293316962099,0.00003},
	{0,0,2,0,-1,-3,0,0,2,-2,0,5.186293170723879519812272,0.00001},
	{0,0,2,0,-1,-3,0,0,2,-1,0,4.401761737832971199679832,0.00001},
	{0,0,2,0,-1,-2,0,0,-2,0,0,6.142134952883337994933299,0.00006},
	{0,0,2,0,-1,-2,0,0,-2,1,0,6.142134952883337994933299,0.00005},
	{0,0,2,0,-1,-2,0,0,0,-1,0,2.960543192562189229732894,0.00008},
	{0,0,2,0,-1,-2,0,0,0,0,0,6.126793159692457635401297,0.00011},
	{0,0,2,0,-1,-2,0,0,0,1,0,6.142135127416263884470027,0.00001},
	{0,0,2,0,-1,-2,0,0,2,-3,0,2.551967897855623945702064,0.00001},
	{0,0,2,0,-1,-2,0,0,2,-2,0,2.989289288941311184544247,0.00007},
	{0,0,2,0,-1,-2,0,0,2,-1,0,6.107052438654849702004412,0.00046},
	{0,0,2,0,-1,-2,0,0,2,0,0,6.107055231181653276451016,0.00003},
	{0,0,2,0,-1,-1,0,0,-2,0,0,3.025260699357839477841026,0.00002},
	{0,0,2,0,-1,-1,0,0,0,0,0,3.027297149529066366824281,0.00003},
	{0,0,2,0,-1,-1,0,0,2,-3,0,6.251382266615595817427220,0.00002},
	{0,0,2,0,-1,-1,0,0,2,-2,0,0.055450681132186645239113,0.00001},
	{0,0,2,0,-1,-1,0,0,2,-1,0,2.960098133602930836616451,0.00004},
	{0,0,2,0,-1,0,0,0,-6,1,0,4.569068650863297165187760,0.00002},
	{0,0,2,0,-1,0,0,0,-6,2,0,4.572505378693398903067191,0.00001},
	{0,0,2,0,-1,0,0,0,-6,3,0,4.543926659389543765144026,0.00001},
	{0,0,2,0,-1,0,0,0,-4,-1,0,4.561844209490517165761503,0.00009},
	{0,0,2,0,-1,0,0,0,-4,0,0,4.563798105588125153531109,0.00028},
	{0,0,2,0,-1,0,0,0,-4,1,0,4.580320963083829965967197,0.00063},
	{0,0,2,0,-1,0,0,0,-4,2,0,4.586328211836269375112352,0.00030},
	{0,0,2,0,-1,0,0,0,-3,0,0,4.588484915192958979446303,0.00002},
	{0,0,2,0,-1,0,0,0,-3,1,0,1.509146759758401845630260,0.00002},
	{0,0,2,0,-1,0,0,0,-2,-2,0,4.606504217989323635151777,0.00014},
	{0,0,2,0,-1,0,0,0,-2,-1,0,4.595219617177630055948612,0.00154},
	{0,0,2,0,-1,0,0,0,-2,-1,2,1.478965828201215026993509,0.00003},
	{0,0,2,0,-1,0,0,0,-2,0,-2,1.489221906484709423423851,0.00004},
	{0,0,2,0,-1,0,0,0,-2,0,0,4.614281405136210878481506,0.01644},
	{0,0,2,0,-1,0,0,0,-2,0,2,4.614282975932537667063116,0.00014},
	{0,0,2,0,-1,0,0,0,-2,1,-2,1.483423922709584230616997,0.00002},
	{0,0,2,0,-1,0,0,0,-2,1,0,4.622192459036725153964653,0.01537},
	{0,0,2,0,-1,0,0,0,-2,1,2,1.480992329995705514278370,0.00003},
	{0,0,2,0,-1,0,0,0,-2,2,0,4.624205172730124324687040,0.00064},
	{0,0,2,0,-1,0,0,0,-2,3,0,4.612625785807768608037804,0.00006},
	{0,0,2,0,-1,0,0,0,-1,-2,0,4.581537632105395552173377,0.00001},
	{0,0,2,0,-1,0,0,0,-1,-1,0,4.498891754167408940645601,0.00006},
	{0,0,2,0,-1,0,0,0,-1,0,0,4.434408994156151528898135,0.00053},
	{0,0,2,0,-1,0,0,0,-1,0,1,4.774395641786143507090401,0.00003},
	{0,0,2,0,-1,0,0,0,-1,1,0,4.262425820460956416013687,0.00003},
	{0,0,2,0,-1,0,0,0,0,-3,0,3.971948229590588130832884,0.00001},
	{0,0,2,0,-1,0,0,0,0,-2,0,4.325475490623401420009486,0.00038},
	{0,0,2,0,-1,0,0,0,0,-1,0,4.284041374181056127667944,0.00456},
	{0,0,2,0,-1,0,0,0,0,0,-2,1.577326476191233339818609,0.00001},
	{0,0,2,0,-1,0,0,0,0,0,0,4.715189186636589369072681,0.01589},
	{0,0,2,0,-1,0,0,0,0,1,0,4.747011425822352137515736,0.00251},
	{0,0,2,0,-1,0,0,0,0,2,0,4.826058085776876005468239,0.00015},
	{0,0,2,0,-1,0,0,0,0,3,0,4.120335948062220587928550,0.00002},
	{0,0,2,0,-1,0,0,0,1,-2,0,1.472522596201627509415744,0.00002},
	{0,0,2,0,-1,0,0,0,1,-1,-1,4.497164227273784398164480,0.00003},
	{0,0,2,0,-1,0,0,0,1,-1,0,4.344923694478374009975141,0.00004},
	{0,0,2,0,-1,0,0,0,1,-1,1,1.388459161845171152549483,0.00003},
	{0,0,2,0,-1,0,0,0,1,0,-1,4.501771372900273959771766,0.00028},
	{0,0,2,0,-1,0,0,0,1,0,0,4.416486731666196874357411,0.00032},
	{0,0,2,0,-1,0,0,0,1,0,1,1.375225377324849285187724,0.00002},
	{0,0,2,0,-1,0,0,0,1,1,-1,4.497164227273784398164480,0.00003},
	{0,0,2,0,-1,0,0,0,1,1,0,4.498992110599398408510297,0.00005},
	{0,0,2,0,-1,0,0,0,2,-3,0,4.546768579010565858311566,0.00002},
	{0,0,2,0,-1,0,0,0,2,-2,0,3.513610979915786192151472,0.00062},
	{0,0,2,0,-1,0,0,0,2,-1,-2,5.591607841321869720729865,0.00004},
	{0,0,2,0,-1,0,0,0,2,-1,-1,1.394396597427530526402961,0.00003},
	{0,0,2,0,-1,0,0,0,2,-1,0,5.362505975328357266107560,0.01299},
	{0,0,2,0,-1,0,0,0,2,-1,2,2.193342181011884051144989,0.00003},
	{0,0,2,0,-1,0,0,0,2,0,-2,3.400254986591408012941429,0.00004},
	{0,0,2,0,-1,0,0,0,2,0,-1,1.405958531057367011385395,0.00004},
	{0,0,2,0,-1,0,0,0,2,0,0,5.228950588438946667224627,0.00072},
	{0,0,2,0,-1,0,0,0,2,1,-2,5.918939630144425478874837,0.00002},
	{0,0,2,0,-1,0,0,0,2,1,0,4.931380852153099070278586,0.00005},
	{0,0,2,0,-1,0,0,0,3,-1,0,4.498976402636130522694202,0.00001},
	{0,0,2,0,-1,0,0,0,4,-2,0,5.319433518317164377720019,0.00017},
	{0,0,2,0,-1,0,0,0,4,-1,0,5.334322398567152845316741,0.00011},
	{0,0,2,0,-1,0,0,0,4,0,0,5.748683808809929018934781,0.00002},
	{0,0,2,0,-1,5,0,0,2,-2,0,2.244862904267355130372152,0.00002},
	{0,0,2,0,-1,5,0,0,2,0,0,2.244862904267355130372152,0.00002},
	{0,0,2,0,0,-7,0,0,2,-2,0,0.265270324082590547298821,0.00004},
	{0,0,2,0,0,-7,0,0,2,-1,0,0.147705643799953323380691,0.00002},
	{0,0,2,0,0,-6,0,0,2,-2,0,0.143718439123772273591229,0.00002},
	{0,0,2,0,0,-6,0,0,2,-1,0,3.338567196844294482360738,0.00003},
	{0,0,2,0,0,-6,3,0,0,0,0,0.209880380408373312661752,0.00001},
	{0,0,2,0,0,-6,3,0,2,-1,0,0.139086509821904513728441,0.00003},
	{0,0,2,0,0,-5,0,0,-4,1,0,3.278458406471459696263082,0.00002},
	{0,0,2,0,0,-5,0,0,-2,-1,0,3.266507264418429201668914,0.00005},
	{0,0,2,0,0,-5,0,0,-2,0,0,3.244553465889293164536866,0.00047},
	{0,0,2,0,0,-5,0,0,-2,1,0,3.299710408108369019686279,0.00052},
	{0,0,2,0,0,-5,0,0,-2,2,0,3.300489872152309711594853,0.00001},
	{0,0,2,0,0,-5,0,0,0,-2,0,0.132952026566994840894864,0.00010},
	{0,0,2,0,0,-5,0,0,0,-1,0,0.128696041186006665535402,0.00111},
	{0,0,2,0,0,-5,0,0,0,0,0,3.276415847647851098400906,0.00108},
	{0,0,2,0,0,-5,0,0,0,1,0,3.289844934511470864180183,0.00017},
	{0,0,2,0,0,-5,0,0,0,2,0,3.295077606141875392609109,0.00003},
	{0,0,2,0,0,-5,0,0,2,-3,0,0.278633961099260696325786,0.00004},
	{0,0,2,0,0,-5,0,0,2,-2,0,0.138836404140093738757145,0.00149},
	{0,0,2,0,0,-5,0,0,2,-1,0,3.275092015410213885928670,0.00675},
	{0,0,2,0,0,-5,0,0,2,0,-2,0.150778819546864922829243,0.00001},
	{0,0,2,0,0,-5,0,0,2,0,0,3.267756745629931458552164,0.00038},
	{0,0,2,0,0,-5,0,0,2,1,0,3.275377376742914403706664,0.00003},
	{0,0,2,0,0,-5,0,0,2,2,0,0.151778893208257659175331,0.00001},
	{0,0,2,0,0,-5,0,0,4,-3,0,0.089803822266265834195487,0.00002},
	{0,0,2,0,0,-5,0,0,4,-2,0,3.276355459255732238688097,0.00007},
	{0,0,2,0,0,-5,0,0,4,-1,0,3.275458883618982852681256,0.00006},
	{0,0,2,0,0,-4,0,0,-2,0,0,0.093778635104757715468260,0.00009},
	{0,0,2,0,0,-4,0,0,-2,1,0,0.093778984170608120640722,0.00010},
	{0,0,2,0,0,-4,0,0,0,-2,0,3.261772709756543875414536,0.00001},
	{0,0,2,0,0,-4,0,0,0,-1,0,3.250352671394894699119504,0.00013},
	{0,0,2,0,0,-4,0,0,0,0,0,0.132704538879062056144775,0.00025},
	{0,0,2,0,0,-4,0,0,0,1,0,0.105702375488532590575019,0.00005},
	{0,0,2,0,0,-4,0,0,2,-3,0,4.681520040036367014124608,0.00001},
	{0,0,2,0,0,-4,0,0,2,-2,0,3.238247591301837591259982,0.00010},
	{0,0,2,0,0,-4,0,0,2,-1,0,0.107942331050542100756573,0.00085},
	{0,0,2,0,0,-4,0,0,2,0,0,0.114049761702045865385813,0.00004},
	{0,0,2,0,0,-4,0,0,4,-2,0,0.120767708525897229931978,0.00001},
	{0,0,2,0,0,-3,0,0,-4,1,0,4.763666404742432192165325,0.00003},
	{0,0,2,0,0,-3,0,0,-2,-1,0,4.765568813627107047636855,0.00008},
	{0,0,2,0,0,-3,0,0,-2,0,0,4.767903366034574652587708,0.00071},
	{0,0,2,0,0,-3,0,0,-2,1,0,4.760142584982656188685723,0.00071},
	{0,0,2,0,0,-3,0,0,-2,2,0,4.759869091888869085948954,0.00004},
	{0,0,2,0,0,-3,0,0,0,-2,0,1.625367361984078051762026,0.00004},
	{0,0,2,0,0,-3,0,0,0,-1,0,1.622142168059317768324945,0.00050},
	{0,0,2,0,0,-3,0,0,0,0,0,4.765063366275728462539973,0.00150},
	{0,0,2,0,0,-3,0,0,0,1,0,4.761842186608248539414490,0.00026},
	{0,0,2,0,0,-3,0,0,0,2,0,4.760348882900242273308322,0.00002},
	{0,0,2,0,0,-3,0,0,1,0,-1,5.138601874380209544312947,0.00002},
	{0,0,2,0,0,-3,0,0,2,-3,0,2.042915045309295685171946,0.00003},
	{0,0,2,0,0,-3,0,0,2,-2,0,1.618863392526521227665626,0.00030},
	{0,0,2,0,0,-3,0,0,2,-1,0,4.762577493822113261501272,0.00457},
	{0,0,2,0,0,-3,0,0,2,0,-2,1.618239786384783718276026,0.00002},
	{0,0,2,0,0,-3,0,0,2,0,0,4.763907085646282624225023,0.00022},
	{0,0,2,0,0,-3,0,0,4,-2,0,4.765109792033833002733445,0.00006},
	{0,0,2,0,0,-3,0,0,4,-1,0,4.762753946609489474894872,0.00004},
	{0,0,2,0,0,-2,0,0,-4,-1,0,0.003783873818323706204186,0.00001},
	{0,0,2,0,0,-2,0,0,-4,0,0,3.145130261450660213995434,0.00005},
	{0,0,2,0,0,-2,0,0,-4,1,0,3.145171800286858054818140,0.00008},
	{0,0,2,0,0,-2,0,0,-4,2,0,3.145304619842934634732501,0.00004},
	{0,0,2,0,0,-2,0,0,-2,-2,0,3.145511615892221168877541,0.00003},
	{0,0,2,0,0,-2,0,0,-2,-1,0,3.145617906443667344262849,0.00024},
	{0,0,2,0,0,-2,0,0,-2,0,0,3.145677596704085754453217,0.00358},
	{0,0,2,0,0,-2,0,0,-2,0,2,3.145650020501904453595898,0.00001},
	{0,0,2,0,0,-2,0,0,-2,1,0,3.145287166550414958976489,0.00358},
	{0,0,2,0,0,-2,0,0,-2,2,0,3.145752471328996158206337,0.00016},
	{0,0,2,0,0,-2,0,0,-1,0,0,6.281801435615680162527497,0.00004},
	{0,0,2,0,0,-2,0,0,-1,0,1,0.183722258244108288538499,0.00001},
	{0,0,2,0,0,-2,0,0,0,-3,0,0.007926063732081848819955,0.00002},
	{0,0,2,0,0,-2,0,0,0,-2,0,6.280599776425681568525761,0.00008},
	{0,0,2,0,0,-2,0,0,0,-1,0,6.281146413547406659461103,0.00168},
	{0,0,2,0,0,-2,0,0,0,0,0,3.143430659825068307355878,0.00731},
	{0,0,2,0,0,-2,0,0,0,1,0,3.143267820605857298943420,0.00131},
	{0,0,2,0,0,-2,0,0,0,2,0,3.141912223375833423943959,0.00009},
	{0,0,2,0,0,-2,0,0,0,3,0,0.004327892946170338976664,0.00001},
	{0,0,2,0,0,-2,0,0,1,0,-1,3.312305925721236388170610,0.00001},
	{0,0,2,0,0,-2,0,0,1,0,0,6.281947519674072388795594,0.00005},
	{0,0,2,0,0,-2,0,0,2,-3,0,3.023302090871251568415801,0.00003},
	{0,0,2,0,0,-2,0,0,2,-2,0,6.282943928144035794502997,0.00078},
	{0,0,2,0,0,-2,0,0,2,-1,-2,3.141904543927124482394220,0.00008},
	{0,0,2,0,0,-2,0,0,2,-1,-1,3.311096936148380187603379,0.00001},
	{0,0,2,0,0,-2,0,0,2,-1,0,3.142177862487987027861891,0.01873},
	{0,0,2,0,0,-2,0,0,2,-1,2,0.000598647933434054988280,0.00004},
	{0,0,2,0,0,-2,0,0,2,0,-2,6.281287959749743521342680,0.00007},
	{0,0,2,0,0,-2,0,0,2,0,0,3.142724674142636676066331,0.00088},
	{0,0,2,0,0,-2,0,0,2,1,-2,3.141689519363279003982825,0.00004},
	{0,0,2,0,0,-2,0,0,2,1,0,3.141689519363279003982825,0.00004},
	{0,0,2,0,0,-2,0,0,4,-3,0,6.234832181983560595028848,0.00001},
	{0,0,2,0,0,-2,0,0,4,-2,0,3.142356235137540476642926,0.00025},
	{0,0,2,0,0,-2,0,0,4,-1,0,3.142289389027189017156161,0.00015},
	{0,0,2,0,0,-2,0,0,4,0,0,3.142441930803813843198213,0.00002},
	{0,0,2,0,0,-1,0,0,-4,0,0,4.512792254461992058622855,0.00001},
	{0,0,2,0,0,-1,0,0,-4,1,0,4.504627778754088041068826,0.00002},
	{0,0,2,0,0,-1,0,0,-2,-1,0,4.509551527106888890727987,0.00012},
	{0,0,2,0,0,-1,0,0,-2,0,0,4.510333260078858153008241,0.00101},
	{0,0,2,0,0,-1,0,0,-2,0,2,4.510764007338250003442681,0.00001},
	{0,0,2,0,0,-1,0,0,-2,1,0,4.510958262483996783487328,0.00098},
	{0,0,2,0,0,-1,0,0,-2,2,0,4.511353754092499279693129,0.00005},
	{0,0,2,0,0,-1,0,0,0,-1,0,4.476790475316478890022154,0.00027},
	{0,0,2,0,0,-1,0,0,0,0,0,4.521822064413035135999053,0.00107},
	{0,0,2,0,0,-1,0,0,0,1,0,4.531353307458175549982116,0.00015},
	{0,0,2,0,0,-1,0,0,1,0,-1,4.299134283420602109515585,0.00002},
	{0,0,2,0,0,-1,0,0,2,-2,0,4.441563098760076044868583,0.00002},
	{0,0,2,0,0,-1,0,0,2,-1,0,4.583991739566624090684854,0.00077},
	{0,0,2,0,0,-1,0,0,2,0,0,4.524786331614622625352240,0.00004},
	{0,0,2,0,0,-1,0,0,4,-2,0,4.580081503910456319772493,0.00001},
	{0,0,2,0,0,0,-3,0,-2,0,0,6.171603615572784917731042,0.00003},
	{0,0,2,0,0,0,-3,0,0,0,0,6.173225724579588735707603,0.00003},
	{0,0,2,0,0,0,-3,0,2,-1,0,6.179895500316085588110582,0.00003},
	{0,0,2,0,0,0,-2,0,-2,0,0,3.120621649962455279592177,0.00009},
	{0,0,2,0,0,0,-2,0,-2,1,0,3.120621649962455279592177,0.00008},
	{0,0,2,0,0,0,-2,0,0,-1,0,0.023931082038720252053166,0.00004},
	{0,0,2,0,0,0,-2,0,0,0,0,3.131051563039448204506243,0.00015},
	{0,0,2,0,0,0,-2,0,0,1,0,3.086578828369380467222527,0.00002},
	{0,0,2,0,0,0,-2,0,2,-1,0,3.137415557090995399391886,0.00028},
	{0,0,2,0,0,0,-2,0,2,0,0,6.282957018113425107230796,0.00002},
	{0,0,2,0,0,0,-1,0,-2,0,0,4.346693807405746845518024,0.00003},
	{0,0,2,0,0,0,-1,0,0,0,0,4.315390105540751974899649,0.00002},
	{0,0,2,0,0,0,0,-2,-2,0,0,3.145415797316287065399365,0.00003},
	{0,0,2,0,0,0,0,-2,0,0,0,3.143777805813290360248402,0.00005},
	{0,0,2,0,0,0,0,-2,2,-1,0,3.141923742548896392179358,0.00007},
	{0,0,2,0,0,0,0,-1,-2,0,0,4.517704483641730384135826,0.00002},
	{0,0,2,0,0,0,0,-1,0,0,0,4.514817359993081424818229,0.00001},
	{0,0,2,0,0,0,0,0,-4,0,0,6.234801464188723940651471,0.00002},
	{0,0,2,0,0,0,0,0,-4,1,0,0.015668693359779092832973,0.00002},
	{0,0,2,0,0,0,0,0,-2,-1,0,6.100951640254503871574343,0.00005},
	{0,0,2,0,0,0,0,0,-2,0,0,0.029487163179518997152551,0.00062},
	{0,0,2,0,0,0,0,0,-2,1,0,0.016505578736110373960777,0.00055},
	{0,0,2,0,0,0,0,0,-2,2,0,0.199796042523275263480542,0.00006},
	{0,0,2,0,0,0,0,0,-1,0,-1,0.194663727324860730272249,0.00005},
	{0,0,2,0,0,0,0,0,-1,0,0,3.552840047381161880934997,0.00004},
	{0,0,2,0,0,0,0,0,-1,0,1,3.392533300914734706310583,0.00011},
	{0,0,2,0,0,0,0,0,-1,1,-1,0.181466420185905613626787,0.00001},
	{0,0,2,0,0,0,0,0,0,-1,0,6.228968573828559840421804,0.00014},
	{0,0,2,0,0,0,0,0,0,0,0,0.365447510758084681548041,0.00316},
	{0,0,2,0,0,0,0,0,0,1,0,0.356135306534068940553794,0.00035},
	{0,0,2,0,0,0,0,0,0,2,0,0.804159231125910922699518,0.00002},
	{0,0,2,0,0,0,0,0,1,-1,0,3.569838681630960408597275,0.00001},
	{0,0,2,0,0,0,0,0,1,0,-1,0.141220349365392766616267,0.00024},
	{0,0,2,0,0,0,0,0,1,0,0,3.571368986319109151139628,0.00007},
	{0,0,2,0,0,0,0,0,1,0,1,3.249018192648819969292617,0.00005},
	{0,0,2,0,0,0,0,0,2,-3,0,3.679620240647254014731971,0.00003},
	{0,0,2,0,0,0,0,0,2,-1,0,0.404043198237911682646484,0.00203},
	{0,0,2,0,0,0,0,0,2,0,-2,0.425121714147172369280270,0.00002},
	{0,0,2,0,0,0,0,0,2,0,-1,3.363461177031339843779278,0.00008},
	{0,0,2,0,0,0,0,0,2,0,0,0.171133198349473214516792,0.00009},
	{0,0,2,0,0,0,0,0,2,1,0,3.529747072449249234438184,0.00001},
	{0,0,2,0,0,0,0,0,4,-2,0,0.364311126882111202540671,0.00003},
	{0,0,2,0,0,0,0,0,4,-1,0,0.402334695433134437170253,0.00002},
	{0,0,2,0,0,1,0,0,-2,0,0,1.105149463679817367633973,0.00003},
	{0,0,2,0,0,1,0,0,-2,1,0,1.104624817706667982974977,0.00001},
	{0,0,2,0,0,1,0,0,0,0,0,1.164879866670819330565223,0.00001},
	{0,0,2,0,0,2,0,0,2,-1,0,5.374778607029605304035158,0.00002},
	{0,0,2,0,1,-9,0,0,2,-2,0,1.509850651045731018129459,0.00001},
	{0,0,2,0,1,-5,0,0,-2,0,0,5.009593419258095536861219,0.00004},
	{0,0,2,0,1,-5,0,0,-2,1,0,5.050259416296637660082069,0.00004},
	{0,0,2,0,1,-5,0,0,0,-1,0,4.368636610360595362578806,0.00001},
	{0,0,2,0,1,-5,0,0,0,0,0,5.501519704920453612828624,0.00004},
	{0,0,2,0,1,-5,0,0,2,-3,0,4.915011409098645422943719,0.00001},
	{0,0,2,0,1,-5,0,0,2,-2,0,0.128122002395025746945834,0.00002},
	{0,0,2,0,1,-5,0,0,2,-1,0,0.325171594807362795975791,0.00008},
	{0,0,2,0,1,-2,0,0,-2,0,0,1.382699400780664555909993,0.00005},
	{0,0,2,0,1,-2,0,0,-2,1,0,1.382723486324342054842873,0.00004},
	{0,0,2,0,1,-2,0,0,0,-1,0,1.375895060158839555697341,0.00001},
	{0,0,2,0,1,-2,0,0,0,0,0,1.358623805479879154134437,0.00004},
	{0,0,2,0,1,-2,0,0,0,1,0,1.375895060158839555697341,0.00001},
	{0,0,2,0,1,-2,0,0,2,-3,0,4.510470442958064651861605,0.00001},
	{0,0,2,0,1,-2,0,0,2,-1,0,1.368877789368271091774432,0.00001},
	{0,0,2,0,1,0,0,0,-4,0,0,5.640897161128664905049845,0.00001},
	{0,0,2,0,1,0,0,0,-4,2,0,2.496385967963686614012886,0.00001},
	{0,0,2,0,1,0,0,0,-2,-1,0,2.434472332611365530397052,0.00004},
	{0,0,2,0,1,0,0,0,-2,0,0,2.439684932955371365892461,0.00025},
	{0,0,2,0,1,0,0,0,-2,1,0,2.475719349757897091990344,0.00024},
	{0,0,2,0,1,0,0,0,-1,0,-1,5.803872865087241983417243,0.00002},
	{0,0,2,0,1,0,0,0,-1,1,-1,2.667491066512203357063981,0.00001},
	{0,0,2,0,1,0,0,0,0,-1,0,2.385166257643750231665081,0.00009},
	{0,0,2,0,1,0,0,0,0,0,0,2.331192474124600622076287,0.00015},
	{0,0,2,0,1,0,0,0,1,-1,-1,5.805669157953394332594144,0.00003},
	{0,0,2,0,1,0,0,0,1,0,-1,5.811479533566209276784775,0.00002},
	{0,0,2,0,1,0,0,0,1,1,-1,2.664951786983476900161349,0.00001},
	{0,0,2,0,1,0,0,0,2,-1,0,1.171318560814351705801073,0.00007},
	{0,0,2,0,1,0,0,0,2,0,-2,2.904001680647505967414190,0.00002},
	{0,0,2,0,1,2,0,0,2,-3,0,2.368359958677521248660014,0.00002},
	{0,0,2,0,1,2,0,0,2,-1,0,2.368359958677521248660014,0.00002},
	{0,0,2,0,1,5,0,0,2,-3,0,1.920876911620871929642362,0.00002},
	{0,0,2,0,1,5,0,0,2,-2,0,1.927683172104874387287055,0.00002},
	{0,0,2,0,1,5,0,0,2,-1,0,1.920876911620871929642362,0.00002},
	{0,0,2,0,1,5,0,0,2,0,0,1.927683172104874387287055,0.00002},
	{0,0,2,0,2,-10,0,0,2,-3,0,3.449049680088189351323535,0.00002},
	{0,0,2,0,2,-10,0,0,2,-2,0,3.450161105755858770294253,0.00001},
	{0,0,2,0,2,-10,0,0,2,-1,0,0.307457026498395902258665,0.00002},
	{0,0,2,0,2,-8,0,0,-2,0,0,1.776220008958302232215942,0.00002},
	{0,0,2,0,2,-8,0,0,0,0,0,1.775635149125959211247050,0.00004},
	{0,0,2,0,2,-8,0,0,2,-1,0,1.769925828076835072621975,0.00007},
	{0,0,2,0,2,-7,0,0,-2,0,0,0.144394754208920089721957,0.00006},
	{0,0,2,0,2,-7,0,0,-2,1,0,0.144394754208920089721957,0.00006},
	{0,0,2,0,2,-7,0,0,0,-1,0,3.296146969374572410771407,0.00004},
	{0,0,2,0,2,-7,0,0,0,0,0,0.144706819079176679521126,0.00012},
	{0,0,2,0,2,-7,0,0,0,1,0,0.144394754208920089721957,0.00001},
	{0,0,2,0,2,-7,0,0,2,-2,0,3.294287495589497627435094,0.00002},
	{0,0,2,0,2,-7,0,0,2,-1,0,0.152455557359255894356309,0.00028},
	{0,0,2,0,2,-7,0,0,2,0,0,0.152455033760480279658722,0.00002},
	{0,0,2,0,2,-6,0,0,2,-3,0,4.690455602207802776604240,0.00001},
	{0,0,2,0,2,-6,0,0,2,-1,0,4.690455602207802776604240,0.00001},
	{0,0,2,0,2,-5,0,0,-4,1,0,5.643832106798818415427377,0.00001},
	{0,0,2,0,2,-5,0,0,-2,-1,0,5.642953682586290042877408,0.00004},
	{0,0,2,0,2,-5,0,0,-2,0,0,5.643866664318007764222784,0.00039},
	{0,0,2,0,2,-5,0,0,-2,1,0,5.641323719597852281992800,0.00040},
	{0,0,2,0,2,-5,0,0,-2,2,0,5.643738906216761996859077,0.00002},
	{0,0,2,0,2,-5,0,0,0,-1,0,5.616923493056195759720595,0.00013},
	{0,0,2,0,2,-5,0,0,0,0,0,5.626849180512287773581193,0.00039},
	{0,0,2,0,2,-5,0,0,0,1,0,5.632446102357583583852829,0.00005},
	{0,0,2,0,2,-5,0,0,2,-3,0,6.076591207219792956095716,0.00003},
	{0,0,2,0,2,-5,0,0,2,-2,0,5.649610542886321695732477,0.00001},
	{0,0,2,0,2,-5,0,0,2,-1,0,5.738966513666525770531734,0.00015},
	{0,0,2,0,2,0,0,0,-2,0,0,2.413155579259207428322043,0.00002},
	{0,0,2,0,2,0,0,0,2,-3,0,2.239669677078045761930980,0.00003},
	{0,0,2,0,2,0,0,0,2,-1,0,5.381262330667839322018153,0.00003},
	{0,0,2,0,3,-5,0,0,2,-2,0,5.739592737802141186875815,0.00002},
	{0,0,2,0,3,-5,0,0,2,0,0,5.733813079984162008884141,0.00003},
	{0,0,2,0,3,-2,0,0,2,-3,0,5.519051013657960247371648,0.00001},
	{0,0,2,0,3,-2,0,0,2,-1,0,5.519051013657960247371648,0.00001},
	{0,0,2,0,3,-1,0,0,2,-3,0,2.215514494763369590657476,0.00002},
	{0,0,2,0,3,-1,0,0,2,-1,0,2.215514494763369590657476,0.00002},
	{0,0,2,0,4,-3,0,0,2,-3,0,4.337869248174738068257739,0.00002},
	{0,0,2,0,4,-3,0,0,2,-1,0,4.337869248174738068257739,0.00002},
	{0,0,2,0,4,-3,0,0,2,0,0,4.337869248174738068257739,0.00001},
	{0,0,2,0,4,-2,0,0,2,-3,0,2.222458287192428993961357,0.00002},
	{0,0,2,0,4,-2,0,0,2,-2,0,2.218868493986926981875740,0.00003},
	{0,0,2,0,4,-2,0,0,2,-1,0,2.222458287192428993961357,0.00002},
	{0,0,2,0,4,-2,0,0,2,0,-2,5.359500518356422382737492,0.00001},
	{0,0,2,0,4,-2,0,0,2,0,0,2.218868493986926981875740,0.00003},
	{0,0,2,0,5,-5,0,0,2,-3,0,4.623673719972893003671288,0.00002},
	{0,0,2,0,5,-5,0,0,2,-2,0,5.422413005639659999701507,0.00001},
	{0,0,2,0,5,-5,0,0,2,-1,0,4.623673719972893003671288,0.00002},
	{0,0,2,0,5,-5,0,0,2,0,0,5.422413005639659999701507,0.00001},
	{0,0,2,1,-1,0,0,0,0,0,0,3.989824764454140026970208,0.00001},
	{0,0,2,1,0,0,0,0,0,0,0,4.417602869722847991340586,0.00002},
	{0,0,2,1,0,0,0,0,2,-3,0,4.949388810309327091374598,0.00001},
	{0,0,2,1,0,0,0,0,2,-1,0,4.949388810309327091374598,0.00001},
	{0,0,2,2,-1,0,0,0,2,-3,0,1.789684351472812684491487,0.00001},
	{0,0,2,2,-1,0,0,0,2,-1,0,1.789684351472812684491487,0.00001},
	{0,0,2,2,-1,0,0,0,2,0,0,4.931277005062606022534055,0.00002},
	{0,0,3,-10,2,0,0,0,-2,0,0,0.392898223766376730736738,0.00001},
	{0,0,3,-10,2,0,0,0,-2,2,0,3.534490877356170290823911,0.00001},
	{0,0,3,-9,0,0,0,0,-2,1,0,3.623598836849665438819557,0.00009},
	{0,0,3,-9,0,0,0,0,-2,2,0,0.468409370255135737437513,0.00010},
	{0,0,3,-9,0,0,0,0,0,1,0,0.482000249140415615300981,0.00002},
	{0,0,3,-9,0,0,0,2,-2,2,0,0.784888003657090438380806,0.00001},
	{0,0,3,-9,0,0,1,0,-2,2,0,0.001292765376952199896099,0.00004},
	{0,0,3,-9,2,0,0,0,-2,0,0,0.899186649310470542673102,0.00003},
	{0,0,3,-8,0,0,0,0,0,-1,0,6.086524225058743020611018,0.00001},
	{0,0,3,-8,0,0,0,0,0,0,0,5.316148459599061126823472,0.00004},
	{0,0,3,-8,0,0,0,0,0,1,0,6.086524225058743020611018,0.00001},
	{0,0,3,-8,0,0,0,0,2,-1,0,6.102785283166649143993254,0.00004},
	{0,0,3,-8,0,0,0,0,2,0,0,6.102663633717785529597677,0.00004},
	{0,0,3,-8,1,5,0,0,0,-1,0,0.381597740458488987602692,0.00001},
	{0,0,3,-8,1,5,0,0,0,0,0,0.380931548283002741062120,0.00009},
	{0,0,3,-8,1,5,0,0,0,1,0,0.381597740458488987602692,0.00001},
	{0,0,3,-8,1,5,0,0,2,-1,0,0.389486628677503388118453,0.00007},
	{0,0,3,-8,1,5,0,0,2,0,0,0.383957774673035767687423,0.00007},
	{0,0,3,-8,3,0,0,0,-4,0,0,3.660416033821710435347541,0.00002},
	{0,0,3,-8,3,0,0,0,-4,1,0,3.660244118890389142251252,0.00004},
	{0,0,3,-8,3,0,0,0,-4,2,0,3.660250053009845849771864,0.00002},
	{0,0,3,-8,3,0,0,0,-2,-2,0,3.660227014663719469211856,0.00002},
	{0,0,3,-8,3,0,0,0,-2,-1,0,3.643629980674804702545089,0.00007},
	{0,0,3,-8,3,0,0,0,-2,0,0,3.656352383724291943423168,0.00053},
	{0,0,3,-8,3,0,0,0,-2,0,2,3.660258256057330239485736,0.00003},
	{0,0,3,-8,3,0,0,0,-2,1,0,3.672001878462299195859941,0.00037},
	{0,0,3,-8,3,0,0,0,-2,2,0,0.560236378190313355496244,0.00003},
	{0,0,3,-8,3,0,0,0,-1,0,0,0.505082926629741413293573,0.00004},
	{0,0,3,-8,3,0,0,0,0,-2,0,0.667085784063256692633104,0.00003},
	{0,0,3,-8,3,0,0,0,0,-1,0,0.546466777589629360001311,0.00101},
	{0,0,3,-8,3,0,0,0,0,0,0,0.520063960264234736996514,0.01121},
	{0,0,3,-8,3,0,0,0,0,1,0,0.509947682853825190463226,0.00360},
	{0,0,3,-8,3,0,0,0,0,2,0,0.504641183796061709720959,0.00031},
	{0,0,3,-8,3,0,0,0,0,3,0,0.487221750663607011677669,0.00001},
	{0,0,3,-8,3,0,0,0,1,-2,0,0.521960085963601438940884,0.00001},
	{0,0,3,-8,3,0,0,0,2,-3,0,0.530023681640740429443781,0.00003},
	{0,0,3,-8,3,0,0,0,2,-2,0,0.528878047519731331327364,0.00038},
	{0,0,3,-8,3,0,0,0,2,-1,-2,3.660774349917144565580429,0.00002},
	{0,0,3,-8,3,0,0,0,2,-1,0,0.522922460513151055039316,0.00971},
	{0,0,3,-8,3,0,0,0,2,0,-2,0.519139459359453381281924,0.00013},
	{0,0,3,-8,3,0,0,0,2,0,0,0.518032222481988102735784,0.00905},
	{0,0,3,-8,3,0,0,0,2,0,2,3.660810827298511593852481,0.00002},
	{0,0,3,-8,3,0,0,0,2,1,-2,3.660765972336735174508249,0.00001},
	{0,0,3,-8,3,0,0,0,2,1,0,0.514260042369652836669047,0.00089},
	{0,0,3,-8,3,0,0,0,2,2,0,0.512484693454524187217203,0.00010},
	{0,0,3,-8,3,0,0,0,3,-1,0,3.660657587390186318287988,0.00001},
	{0,0,3,-8,3,0,0,0,3,0,0,0.519064933800393202290024,0.00002},
	{0,0,3,-8,3,0,0,0,4,-2,0,0.524092878309538434677961,0.00019},
	{0,0,3,-8,3,0,0,0,4,-1,0,0.520268512852568476567683,0.00039},
	{0,0,3,-8,3,0,0,0,4,0,0,0.517575993415516855122860,0.00016},
	{0,0,3,-8,3,0,0,0,4,1,0,0.518926354657784805191056,0.00004},
	{0,0,3,-8,5,-5,0,0,2,0,0,2.896421366640244077217403,0.00002},
	{0,0,3,-7,0,0,0,0,-3,2,-1,2.522854758734807134601397,0.00019},
	{0,0,3,-7,0,0,0,0,-3,3,-1,2.520427529344058559246378,0.00023},
	{0,0,3,-7,0,0,0,0,-2,0,0,3.555089602254057457031422,0.00003},
	{0,0,3,-7,0,0,0,0,-1,0,-1,5.622782214289291147224503,0.00005},
	{0,0,3,-7,0,0,0,0,-1,0,1,5.624758974200099181928181,0.00004},
	{0,0,3,-7,0,0,0,0,-1,1,-1,5.622797049587932249892219,0.00070},
	{0,0,3,-7,0,0,0,0,-1,2,-3,5.732249439507300259322164,0.00001},
	{0,0,3,-7,0,0,0,0,-1,2,-1,2.520939085347817965043760,0.01806},
	{0,0,3,-7,0,0,0,0,-1,2,1,5.732249439507300259322164,0.00001},
	{0,0,3,-7,0,0,0,0,-1,3,-1,2.521609466313508907120422,0.00086},
	{0,0,3,-7,0,0,0,0,-1,4,-1,2.521619240157320085415904,0.00006},
	{0,0,3,-7,0,0,0,0,0,-1,0,4.371494237944885341562440,0.00008},
	{0,0,3,-7,0,0,0,0,0,0,0,4.457348380113888453024629,0.00040},
	{0,0,3,-7,0,0,0,0,0,1,0,4.388975630265785632388997,0.00008},
	{0,0,3,-7,0,0,0,0,1,0,-1,2.498905699804791158413764,0.00002},
	{0,0,3,-7,0,0,0,0,1,1,-1,2.510543031658313939402660,0.00054},
	{0,0,3,-7,0,0,0,0,1,2,-1,2.519367416356397271215428,0.00023},
	{0,0,3,-7,0,0,0,0,1,3,-1,2.520153512651495564256265,0.00003},
	{0,0,3,-7,0,0,0,0,2,-1,0,6.142422408611142081724665,0.00009},
	{0,0,3,-7,0,0,0,0,2,0,0,5.965251069181467968860488,0.00009},
	{0,0,3,-7,1,0,0,0,0,0,0,1.620493879113734214669762,0.00001},
	{0,0,3,-7,2,0,0,0,0,0,0,5.246396201510181711569203,0.00001},
	{0,0,3,-6,0,0,0,0,-4,0,0,4.746883667721105481973609,0.00002},
	{0,0,3,-6,0,0,0,0,-4,2,0,4.767571404410844593257934,0.00002},
	{0,0,3,-6,0,0,0,0,-2,-1,0,4.747439555087865414861881,0.00013},
	{0,0,3,-6,0,0,0,0,-2,0,0,4.736026672576149287863245,0.00113},
	{0,0,3,-6,0,0,0,0,-2,0,2,4.742872028435397346868285,0.00003},
	{0,0,3,-6,0,0,0,0,-2,1,0,4.776007976949135702682270,0.00165},
	{0,0,3,-6,0,0,0,0,-2,2,0,4.903323288163888626911557,0.00004},
	{0,0,3,-6,0,0,0,0,-1,0,0,1.627312007836650309400284,0.00002},
	{0,0,3,-6,0,0,0,0,-1,0,1,6.148998634699730736485890,0.00003},
	{0,0,3,-6,0,0,0,0,0,-2,0,4.689104193767983375096264,0.00020},
	{0,0,3,-6,0,0,0,0,0,-1,0,4.693478861538107338446935,0.00310},
	{0,0,3,-6,0,0,0,0,0,-1,1,2.978554466843994941172014,0.00002},
	{0,0,3,-6,0,0,0,0,0,0,0,4.735820723724414094135682,0.01673},
	{0,0,3,-6,0,0,0,0,0,1,0,4.697684755969563141775325,0.00325},
	{0,0,3,-6,0,0,0,0,0,2,0,4.699217678651589125138344,0.00022},
	{0,0,3,-6,0,0,0,0,0,3,0,4.686817637914945322563653,0.00001},
	{0,0,3,-6,0,0,0,0,1,-2,0,1.642537562099348091848583,0.00001},
	{0,0,3,-6,0,0,0,0,1,0,-1,6.172302619938209389260919,0.00003},
	{0,0,3,-6,0,0,0,0,1,0,0,1.623656241185422732797861,0.00003},
	{0,0,3,-6,0,0,0,0,2,-2,0,4.861961079286725606607433,0.00008},
	{0,0,3,-6,0,0,0,0,2,-1,0,4.803789778916530472940849,0.00234},
	{0,0,3,-6,0,0,0,0,2,0,-2,4.795214627235631965618268,0.00003},
	{0,0,3,-6,0,0,0,0,2,0,0,4.799038469093826364542110,0.00162},
	{0,0,3,-6,0,0,0,0,2,1,0,4.773226096654380690154085,0.00017},
	{0,0,3,-6,0,0,0,0,4,-2,0,4.791515750951880647789949,0.00003},
	{0,0,3,-6,0,0,0,0,4,-1,0,4.791362511043555372225455,0.00003},
	{0,0,3,-6,0,0,0,0,4,0,0,4.794171094875864014284161,0.00002},
	{0,0,3,-6,0,2,0,0,0,0,0,5.778376920841184372079624,0.00002},
	{0,0,3,-6,1,0,0,0,-2,0,0,2.179719886200068401649332,0.00001},
	{0,0,3,-6,1,0,0,0,0,0,0,2.206979485655266692845089,0.00009},
	{0,0,3,-6,1,0,0,0,2,0,0,2.189519735417090995355238,0.00002},
	{0,0,3,-6,2,0,0,0,-4,1,0,5.779824671455712881140698,0.00001},
	{0,0,3,-6,2,0,0,0,-2,-1,0,5.779824496922787879782391,0.00005},
	{0,0,3,-6,2,0,0,0,-2,0,0,5.778355802357234338728631,0.00046},
	{0,0,3,-6,2,0,0,0,-2,0,2,5.779824671455712881140698,0.00001},
	{0,0,3,-6,2,0,0,0,-2,1,0,5.783377638213997862237647,0.00072},
	{0,0,3,-6,2,0,0,0,-2,2,0,5.779732692604133248437392,0.00003},
	{0,0,3,-6,2,0,0,0,0,-2,0,5.758041740660347684865883,0.00006},
	{0,0,3,-6,2,0,0,0,0,-1,0,5.758879673234229557010622,0.00092},
	{0,0,3,-6,2,0,0,0,0,0,0,5.767861835696693084685194,0.00491},
	{0,0,3,-6,2,0,0,0,0,1,0,5.759031342346228043993506,0.00092},
	{0,0,3,-6,2,0,0,0,0,2,0,5.758242977123102512848618,0.00006},
	{0,0,3,-6,2,0,0,0,2,-2,0,5.789717372188941446609078,0.00002},
	{0,0,3,-6,2,0,0,0,2,-1,0,5.784726079594088687940712,0.00073},
	{0,0,3,-6,2,0,0,0,2,0,-2,5.781077119726943713828859,0.00001},
	{0,0,3,-6,2,0,0,0,2,0,0,5.779178201500774214594003,0.00047},
	{0,0,3,-6,2,0,0,0,2,1,0,5.780856161043641527896852,0.00005},
	{0,0,3,-6,2,0,0,0,4,-2,0,5.784091826943913439151856,0.00001},
	{0,0,3,-6,2,0,0,0,4,-1,0,5.781077119726943713828859,0.00002},
	{0,0,3,-6,3,0,0,0,0,0,0,4.113108365096787011339075,0.00005},
	{0,0,3,-5,-4,0,0,0,-2,0,0,2.228144918961277198832249,0.00001},
	{0,0,3,-5,-4,0,0,0,-2,1,0,2.228144918961277198832249,0.00002},
	{0,0,3,-5,-4,0,0,0,0,0,0,3.132036277803423640619940,0.00001},
	{0,0,3,-5,-4,0,0,0,2,-1,0,2.230013119392611820046568,0.00002},
	{0,0,3,-5,-4,0,0,0,2,0,0,2.230013119392611820046568,0.00001},
	{0,0,3,-5,0,0,0,0,-4,0,0,5.262831268944512252971890,0.00004},
	{0,0,3,-5,0,0,0,0,-4,1,0,5.263785265913651478797419,0.00011},
	{0,0,3,-5,0,0,0,0,-4,2,0,5.267360572886362390931936,0.00006},
	{0,0,3,-5,0,0,0,0,-2,-2,0,5.266169560204801314284850,0.00003},
	{0,0,3,-5,0,0,0,0,-2,-1,0,5.260368958435797992478911,0.00030},
	{0,0,3,-5,0,0,0,0,-2,0,0,5.268239520697666655735247,0.00341},
	{0,0,3,-5,0,0,0,0,-2,0,2,5.268953360361732229932841,0.00006},
	{0,0,3,-5,0,0,0,0,-2,1,0,5.267276273483491699778369,0.00510},
	{0,0,3,-5,0,0,0,0,-2,2,0,5.271739254913765826415784,0.00022},
	{0,0,3,-5,0,0,0,0,-2,3,0,5.266218953022632653926394,0.00001},
	{0,0,3,-5,0,0,0,0,-1,0,0,2.120736658661845019935299,0.00011},
	{0,0,3,-5,0,0,0,0,-1,0,1,0.398319390955996277536855,0.00003},
	{0,0,3,-5,0,0,0,0,-1,1,0,2.126440743723212900562203,0.00001},
	{0,0,3,-5,0,0,0,0,0,-3,0,5.230665374429031899694564,0.00001},
	{0,0,3,-5,0,0,0,0,0,-2,0,5.239662197657212416856964,0.00029},
	{0,0,3,-5,0,0,0,0,0,-1,0,5.238956561040630788284034,0.00410},
	{0,0,3,-5,0,0,0,0,0,0,0,5.250017934240995387540352,0.02009},
	{0,0,3,-5,0,0,0,0,0,1,-2,2.067626987655358572482100,0.00018},
	{0,0,3,-5,0,0,0,0,0,1,0,5.237183655586454378294547,0.00374},
	{0,0,3,-5,0,0,0,0,0,2,-2,2.061696533390006802477501,0.00037},
	{0,0,3,-5,0,0,0,0,0,2,0,5.235193456640406139968036,0.00024},
	{0,0,3,-5,0,0,0,0,0,3,-2,2.011834047456855678603915,0.00001},
	{0,0,3,-5,0,0,0,0,0,3,0,5.228166412006026497749644,0.00001},
	{0,0,3,-5,0,0,0,0,1,-1,0,2.115034842528504821501656,0.00001},
	{0,0,3,-5,0,0,0,0,1,-1,1,3.546093128091727830764057,0.00003},
	{0,0,3,-5,0,0,0,0,1,0,-1,0.401639705324990325951973,0.00013},
	{0,0,3,-5,0,0,0,0,1,0,0,5.293952409369747869050116,0.00001},
	{0,0,3,-5,0,0,0,0,1,0,1,3.543398339726648416103671,0.00002},
	{0,0,3,-5,0,0,0,0,2,-2,0,5.270160953671187975544399,0.00011},
	{0,0,3,-5,0,0,0,0,2,-1,0,5.272143996767303164574514,0.00341},
	{0,0,3,-5,0,0,0,0,2,0,-2,5.257674170070719021907735,0.00005},
	{0,0,3,-5,0,0,0,0,2,0,0,5.255826739057482654970954,0.00196},
	{0,0,3,-5,0,0,0,0,2,1,-2,5.209991949439159775181452,0.00003},
	{0,0,3,-5,0,0,0,0,2,1,0,5.256650010865648425806285,0.00020},
	{0,0,3,-5,0,0,0,0,2,2,0,5.260117980089361822138017,0.00002},
	{0,0,3,-5,0,0,0,0,4,-2,0,5.265596743144296709715491,0.00004},
	{0,0,3,-5,0,0,0,0,4,-1,0,5.260901109324731983463153,0.00007},
	{0,0,3,-5,0,0,0,0,4,0,0,5.264362795363136449111607,0.00004},
	{0,0,3,-5,2,0,0,0,0,0,0,0.007092494481329356982580,0.00002},
	{0,0,3,-5,2,0,0,0,2,0,0,0.017194111126022138674729,0.00001},
	{0,0,3,-4,0,0,0,0,-4,-1,0,5.762398431539176080207199,0.00003},
	{0,0,3,-4,0,0,0,0,-4,0,0,5.742302535998788037829854,0.00013},
	{0,0,3,-4,0,0,0,0,-4,1,0,5.715318873098328644744015,0.00029},
	{0,0,3,-4,0,0,0,0,-4,2,0,5.732881946828222829992683,0.00018},
	{0,0,3,-4,0,0,0,0,-3,1,0,2.623603191674479084838367,0.00004},
	{0,0,3,-4,0,0,0,0,-2,-2,0,5.738681675932600256828664,0.00009},
	{0,0,3,-4,0,0,0,0,-2,-1,0,5.716905726454243108491937,0.00097},
	{0,0,3,-4,0,0,0,0,-2,-1,2,2.593819497055046330302730,0.00001},
	{0,0,3,-4,0,0,0,0,-2,0,-2,2.596116350350670565205746,0.00003},
	{0,0,3,-4,0,0,0,0,-2,0,0,5.729773864496271684743078,0.01099},
	{0,0,3,-4,0,0,0,0,-2,0,2,5.732588382448037478411607,0.00015},
	{0,0,3,-4,0,0,0,0,-2,1,-2,2.595986846920172563812912,0.00003},
	{0,0,3,-4,0,0,0,0,-2,1,0,5.736473834428827522913252,0.01431},
	{0,0,3,-4,0,0,0,0,-2,2,0,5.749513363803401944096549,0.00063},
	{0,0,3,-4,0,0,0,0,-2,3,0,5.727660619837956268440848,0.00004},
	{0,0,3,-4,0,0,0,0,-1,-1,1,4.098302737052119226746072,0.00005},
	{0,0,3,-4,0,0,0,0,-1,0,-1,0.951663114864333747888736,0.00001},
	{0,0,3,-4,0,0,0,0,-1,0,0,2.636009166530579594933670,0.00227},
	{0,0,3,-4,0,0,0,0,-1,0,1,0.951510049488933806749458,0.00006},
	{0,0,3,-4,0,0,0,0,-1,1,0,2.632258628500969255270547,0.00024},
	{0,0,3,-4,0,0,0,0,-1,2,0,2.637426024817349112794318,0.00002},
	{0,0,3,-4,0,0,0,0,0,-3,0,5.760639488719015766093889,0.00004},
	{0,0,3,-4,0,0,0,0,0,-2,0,5.753696045355806809595833,0.00066},
	{0,0,3,-4,0,0,0,0,0,-1,-2,2.616435648035313921155876,0.00002},
	{0,0,3,-4,0,0,0,0,0,-1,0,5.752846593608861525126486,0.00994},
	{0,0,3,-4,0,0,0,0,0,-1,2,5.758468997261235067242069,0.00001},
	{0,0,3,-4,0,0,0,0,0,0,-2,2.615359652551459301861314,0.00003},
	{0,0,3,-4,0,0,0,0,0,0,0,5.761107411491474650233613,0.04667},
	{0,0,3,-4,0,0,0,0,0,0,2,2.613357410833571314867640,0.00003},
	{0,0,3,-4,0,0,0,0,0,1,0,5.770585421994431030157102,0.00789},
	{0,0,3,-4,0,0,0,0,0,1,2,2.616435648035313921155876,0.00002},
	{0,0,3,-4,0,0,0,0,0,2,0,5.776706466214100110789786,0.00055},
	{0,0,3,-4,0,0,0,0,0,3,0,5.777787174086935095829176,0.00004},
	{0,0,3,-4,0,0,0,0,1,-3,0,5.786722038126669964697157,0.00004},
	{0,0,3,-4,0,0,0,0,1,-2,0,5.786752406855653951822660,0.00061},
	{0,0,3,-4,0,0,0,0,1,-1,-2,2.646808914876070506494443,0.00001},
	{0,0,3,-4,0,0,0,0,1,-1,-1,0.956354908959544780522322,0.00012},
	{0,0,3,-4,0,0,0,0,1,-1,0,5.781465804551363163454880,0.01425},
	{0,0,3,-4,0,0,0,0,1,-1,1,0.956677445805313442228623,0.00022},
	{0,0,3,-4,0,0,0,0,1,-1,2,2.646808914876070506494443,0.00001},
	{0,0,3,-4,0,0,0,0,1,0,-2,5.781151994351854561671189,0.00002},
	{0,0,3,-4,0,0,0,0,1,0,-1,0.957291627169090220128567,0.00095},
	{0,0,3,-4,0,0,0,0,1,0,0,5.781105219527901795117941,0.01126},
	{0,0,3,-4,0,0,0,0,1,0,1,4.098728248323754819182341,0.00018},
	{0,0,3,-4,0,0,0,0,1,0,2,2.639557944498660102539134,0.00002},
	{0,0,3,-4,0,0,0,0,1,1,-1,0.956354908959544780522322,0.00012},
	{0,0,3,-4,0,0,0,0,1,1,0,5.781173985500429601813721,0.00076},
	{0,0,3,-4,0,0,0,0,1,1,1,4.098698228660620834773454,0.00002},
	{0,0,3,-4,0,0,0,0,1,2,0,5.781152168884779563029497,0.00005},
	{0,0,3,-4,0,0,0,0,2,-2,0,5.501399800800841788372963,0.00004},
	{0,0,3,-4,0,0,0,0,2,-1,-2,2.641384431560871881572439,0.00001},
	{0,0,3,-4,0,0,0,0,2,-1,0,5.761565036821348684270561,0.00475},
	{0,0,3,-4,0,0,0,0,2,0,-2,5.781119880293617896427349,0.00013},
	{0,0,3,-4,0,0,0,0,2,0,0,5.788500877700302638118046,0.00260},
	{0,0,3,-4,0,0,0,0,2,1,-2,2.641384431560871881572439,0.00001},
	{0,0,3,-4,0,0,0,0,2,1,0,5.796982479733293835977292,0.00029},
	{0,0,3,-4,0,0,0,0,2,2,0,5.765325872293545650393298,0.00003},
	{0,0,3,-4,0,0,0,0,3,-2,0,5.778074978880588297158738,0.00019},
	{0,0,3,-4,0,0,0,0,3,-1,0,5.781184108410092115093448,0.00030},
	{0,0,3,-4,0,0,0,0,3,0,0,5.781180268685736756140159,0.00012},
	{0,0,3,-4,0,0,0,0,4,-2,0,5.627242228659837586235426,0.00007},
	{0,0,3,-4,0,0,0,0,4,-1,0,5.769868789803561881512906,0.00008},
	{0,0,3,-4,0,0,0,0,4,0,0,5.853450862352318928572004,0.00003},
	{0,0,3,-4,1,0,0,0,-2,0,0,2.766888440077905908509592,0.00001},
	{0,0,3,-4,1,0,0,0,0,0,0,3.084123150111825140129440,0.00006},
	{0,0,3,-4,2,0,0,0,-2,0,0,4.131642714555415096810975,0.00003},
	{0,0,3,-4,2,0,0,0,-2,1,0,4.131642714555415096810975,0.00004},
	{0,0,3,-4,2,0,0,0,0,-1,0,4.064754018170283700328582,0.00001},
	{0,0,3,-4,2,0,0,0,0,0,0,3.884617887940248426303924,0.00008},
	{0,0,3,-4,2,0,0,0,0,1,0,4.064754018170283700328582,0.00001},
	{0,0,3,-4,2,0,0,0,2,0,0,0.514900927270985131478653,0.00001},
	{0,0,3,-3,-3,0,0,0,0,0,0,5.359349023777349785291335,0.00001},
	{0,0,3,-3,-2,0,0,0,-2,0,0,2.109100374005873579363879,0.00001},
	{0,0,3,-3,0,0,0,0,-4,0,0,3.339004925420694824822476,0.00005},
	{0,0,3,-3,0,0,0,0,-4,1,0,3.323407092428546594220506,0.00010},
	{0,0,3,-3,0,0,0,0,-4,2,0,3.262363329175418602545733,0.00005},
	{0,0,3,-3,0,0,0,0,-2,-2,0,3.271525784149613258477984,0.00004},
	{0,0,3,-3,0,0,0,0,-2,-1,0,3.285185079941571384409826,0.00032},
	{0,0,3,-3,0,0,0,0,-2,0,0,3.277024094892170946735632,0.00405},
	{0,0,3,-3,0,0,0,0,-2,0,2,3.282299003490473765509705,0.00003},
	{0,0,3,-3,0,0,0,0,-2,1,0,3.269777313304965460361018,0.00445},
	{0,0,3,-3,0,0,0,0,-2,2,0,3.278981132582432511668458,0.00020},
	{0,0,3,-3,0,0,0,0,-1,0,0,0.102233533600193840507053,0.00007},
	{0,0,3,-3,0,0,0,0,-1,2,0,0.018390534328264252633689,0.00001},
	{0,0,3,-3,0,0,0,0,0,-3,0,3.181038665481191518580317,0.00001},
	{0,0,3,-3,0,0,0,0,0,-2,0,3.194846314259569108884307,0.00032},
	{0,0,3,-3,0,0,0,0,0,-1,0,3.196555340663122635191939,0.00455},
	{0,0,3,-3,0,0,0,0,0,0,0,3.187776683591441173604153,0.01454},
	{0,0,3,-3,0,0,0,0,0,1,0,3.183777959742196461689900,0.00228},
	{0,0,3,-3,0,0,0,0,0,2,0,3.185061823939963954188670,0.00015},
	{0,0,3,-3,0,0,0,0,1,-2,0,0.046375492620591728110124,0.00002},
	{0,0,3,-3,0,0,0,0,1,-1,-1,4.875838715768108677650616,0.00001},
	{0,0,3,-3,0,0,0,0,1,-1,0,0.067579846768921245092621,0.00001},
	{0,0,3,-3,0,0,0,0,1,0,-1,4.845770183414749965322699,0.00014},
	{0,0,3,-3,0,0,0,0,1,0,0,0.146170103124048711418226,0.00004},
	{0,0,3,-3,0,0,0,0,1,1,-1,4.875838715768108677650616,0.00001},
	{0,0,3,-3,0,0,0,0,2,-3,0,6.203696206259681211747647,0.00003},
	{0,0,3,-3,0,0,0,0,2,-2,0,0.019378216151967841279768,0.00072},
	{0,0,3,-3,0,0,0,0,2,-1,0,0.015140731261050810463331,0.00639},
	{0,0,3,-3,0,0,0,0,2,0,-2,6.267660952548947506102195,0.00002},
	{0,0,3,-3,0,0,0,0,2,0,0,0.018303791464440131997460,0.00062},
	{0,0,3,-3,0,0,0,0,2,1,0,6.225019591862997359044130,0.00004},
	{0,0,3,-3,0,0,0,0,4,-2,0,0.009784315786680210583204,0.00008},
	{0,0,3,-3,0,0,0,0,4,-1,0,0.009985028650659560911507,0.00008},
	{0,0,3,-3,2,0,0,0,2,-3,0,1.061915738245740703504794,0.00001},
	{0,0,3,-3,2,0,0,0,2,-1,0,1.061915738245740703504794,0.00001},
	{0,0,3,-2,-2,0,0,0,2,-2,0,4.494671373503160261009270,0.00003},
	{0,0,3,-2,-2,0,0,0,2,-1,0,3.491670096823115354567335,0.00002},
	{0,0,3,-2,-1,0,0,0,2,-2,0,0.209284001402966851612675,0.00002},
	{0,0,3,-2,0,0,0,0,-4,-1,0,1.325364811253875174656969,0.00003},
	{0,0,3,-2,0,0,0,0,-4,0,0,4.487390208929690871286766,0.00011},
	{0,0,3,-2,0,0,0,0,-4,1,0,4.475388801394202253902677,0.00018},
	{0,0,3,-2,0,0,0,0,-4,2,0,4.477274804183907441768042,0.00009},
	{0,0,3,-2,0,0,0,0,-3,0,0,4.476478759512072969073415,0.00001},
	{0,0,3,-2,0,0,0,0,-2,-2,0,4.483126544099994781333862,0.00003},
	{0,0,3,-2,0,0,0,0,-2,-1,0,4.478719762271634152739352,0.00039},
	{0,0,3,-2,0,0,0,0,-2,0,0,4.476622225576586622253217,0.00459},
	{0,0,3,-2,0,0,0,0,-2,0,2,4.482780270776397735232877,0.00004},
	{0,0,3,-2,0,0,0,0,-2,1,0,4.484208124637454773164791,0.00423},
	{0,0,3,-2,0,0,0,0,-2,2,0,4.483880351803930963683342,0.00019},
	{0,0,3,-2,0,0,0,0,-1,0,0,4.490997629960637560486703,0.00008},
	{0,0,3,-2,0,0,0,0,-1,2,0,4.490134041046752066961290,0.00001},
	{0,0,3,-2,0,0,0,0,0,-3,0,1.348370345190262886703181,0.00001},
	{0,0,3,-2,0,0,0,0,0,-2,0,4.469415935628027192194622,0.00012},
	{0,0,3,-2,0,0,0,0,0,-1,0,4.464927646923598558714730,0.00138},
	{0,0,3,-2,0,0,0,0,0,0,-1,5.425263302841092816208857,0.00003},
	{0,0,3,-2,0,0,0,0,0,0,0,4.440046582173017952754890,0.00459},
	{0,0,3,-2,0,0,0,0,0,1,0,4.468457575335757603340880,0.00074},
	{0,0,3,-2,0,0,0,0,0,2,0,4.473738418053516241457146,0.00004},
	{0,0,3,-2,0,0,0,0,1,0,-1,5.369727973240184581982248,0.00009},
	{0,0,3,-2,0,0,0,0,1,0,0,4.489560351321621567421971,0.00007},
	{0,0,3,-2,0,0,0,0,2,-3,0,4.139067170660474026533393,0.00001},
	{0,0,3,-2,0,0,0,0,2,-2,0,4.460739729383438323395694,0.00014},
	{0,0,3,-2,0,0,0,0,2,-1,-1,2.274792508412254221639159,0.00064},
	{0,0,3,-2,0,0,0,0,2,-1,0,4.520844680031919082807690,0.00196},
	{0,0,3,-2,0,0,0,0,2,0,-1,2.282164953705603682720948,0.00021},
	{0,0,3,-2,0,0,0,0,2,0,0,4.530341016492019257100310,0.00017},
	{0,0,3,-2,0,0,0,0,4,-2,0,4.522362767415303075324573,0.00003},
	{0,0,3,-2,0,0,0,0,4,-1,0,4.520254758744743917020514,0.00002},
	{0,0,3,-2,2,0,0,0,2,0,-2,5.938856629436482847950174,0.00001},
	{0,0,3,-1,-2,0,0,0,0,0,0,3.144391987177066916103740,0.00001},
	{0,0,3,-1,-2,0,0,0,2,-3,0,0.026425855671520944584207,0.00001},
	{0,0,3,-1,-2,0,0,0,2,-1,0,3.168018509261314452629676,0.00001},
	{0,0,3,-1,0,0,0,0,-2,0,0,2.775489422631734370838785,0.00004},
	{0,0,3,-1,0,0,0,0,-2,1,0,2.774469975815644140482163,0.00002},
	{0,0,3,-1,0,0,0,0,0,0,0,3.858616147276962227152808,0.00007},
	{0,0,3,-1,0,0,0,0,1,0,-1,5.917467793986218360657858,0.00002},
	{0,0,3,-1,0,0,0,0,2,-1,0,4.075879619487121630072579,0.00003},
	{0,0,3,0,-6,0,0,0,-2,0,0,3.568349566713159060071803,0.00005},
	{0,0,3,0,-6,0,0,0,-2,1,0,3.573581016613087246724945,0.00002},
	{0,0,3,0,-6,0,0,0,0,-1,0,0.564971456450974018892452,0.00002},
	{0,0,3,0,-6,0,0,0,0,0,0,3.650400636442066026887687,0.00007},
	{0,0,3,0,-6,0,0,0,0,1,0,3.642224117962322704755707,0.00001},
	{0,0,3,0,-6,0,0,0,2,-1,0,3.676351588024119543263168,0.00013},
	{0,0,3,0,-6,0,0,0,2,0,0,0.559349925463225483568408,0.00003},
	{0,0,3,0,-6,2,0,0,0,0,0,3.234756060133223254382528,0.00001},
	{0,0,3,0,-6,2,0,0,2,-3,0,0.183169861535852074307940,0.00001},
	{0,0,3,0,-6,2,0,0,2,-1,0,3.324762515125645023772449,0.00001},
	{0,0,3,0,-6,5,0,0,-2,0,0,0.558616538111537441757548,0.00002},
	{0,0,3,0,-6,5,0,0,0,0,0,0.648058204558014550045186,0.00003},
	{0,0,3,0,-6,5,0,0,2,-3,0,4.261672536355796125917550,0.00001},
	{0,0,3,0,-6,5,0,0,2,-2,0,1.204851397199993456865741,0.00002},
	{0,0,3,0,-6,5,0,0,2,-1,0,0.815704235062003069067771,0.00005},
	{0,0,3,0,-5,0,0,0,-2,-1,0,3.386214685423739378933305,0.00004},
	{0,0,3,0,-5,0,0,0,-2,0,0,3.384696248974504495521387,0.00026},
	{0,0,3,0,-5,0,0,0,-2,1,0,3.383121612923355669977354,0.00023},
	{0,0,3,0,-5,0,0,0,0,-1,0,0.715531586242564077160466,0.00002},
	{0,0,3,0,-5,0,0,0,0,0,0,3.457439477802525917837784,0.00044},
	{0,0,3,0,-5,0,0,0,0,1,0,3.466890261169150111442150,0.00009},
	{0,0,3,0,-5,0,0,0,0,2,0,3.471981037531366887094464,0.00001},
	{0,0,3,0,-5,0,0,0,1,0,-1,5.074741673313138079493001,0.00002},
	{0,0,3,0,-5,0,0,0,2,-2,0,3.501035184523466181616413,0.00003},
	{0,0,3,0,-5,0,0,0,2,-1,0,3.482371331634339650662469,0.00103},
	{0,0,3,0,-5,0,0,0,2,0,-2,3.501173065534373574081428,0.00004},
	{0,0,3,0,-5,0,0,0,2,0,0,0.376407305795983082585821,0.00012},
	{0,0,3,0,-5,0,0,0,2,1,0,0.360277321914901860200331,0.00003},
	{0,0,3,0,-5,0,0,0,4,-2,0,3.480138008323487852635481,0.00001},
	{0,0,3,0,-5,0,0,0,4,0,0,3.501153168780901214773849,0.00002},
	{0,0,3,0,-5,2,0,0,-2,0,0,2.901743922727126001603892,0.00002},
	{0,0,3,0,-5,2,0,0,0,0,0,3.039471344660502616363829,0.00003},
	{0,0,3,0,-5,2,0,0,2,-3,0,0.026644196360945435197998,0.00001},
	{0,0,3,0,-5,2,0,0,2,-2,0,3.163439812501632086849668,0.00001},
	{0,0,3,0,-5,2,0,0,2,-1,0,3.162468187707046851642190,0.00005},
	{0,0,3,0,-5,3,0,0,2,-3,0,1.041950218800476779534847,0.00001},
	{0,0,3,0,-5,3,0,0,2,-2,0,4.183542872390270339622020,0.00001},
	{0,0,3,0,-5,3,0,0,2,-1,0,4.183542872390270339622020,0.00001},
	{0,0,3,0,-5,3,0,0,2,0,0,1.041950218800476779534847,0.00001},
	{0,0,3,0,-5,5,0,0,-2,0,0,5.987863031371531086222149,0.00008},
	{0,0,3,0,-5,5,0,0,-2,1,0,5.990107001190820845692997,0.00006},
	{0,0,3,0,-5,5,0,0,0,-1,0,4.557372850479832315784279,0.00002},
	{0,0,3,0,-5,5,0,0,0,0,0,6.058365257439992213051028,0.00011},
	{0,0,3,0,-5,5,0,0,0,1,0,5.971693428516429591468295,0.00002},
	{0,0,3,0,-5,5,0,0,0,2,0,6.079879756596400675050518,0.00001},
	{0,0,3,0,-5,5,0,0,2,-3,0,5.912246816061801801822639,0.00001},
	{0,0,3,0,-5,5,0,0,2,-1,0,6.030009940280391056433018,0.00020},
	{0,0,3,0,-5,5,0,0,2,0,0,2.937246712239494073060087,0.00006},
	{0,0,3,0,-5,5,0,0,2,2,0,2.940441013836494033029112,0.00001},
	{0,0,3,0,-4,0,0,0,-4,0,0,3.185082244292212205749593,0.00003},
	{0,0,3,0,-4,0,0,0,-4,1,0,3.186044618841761710825722,0.00003},
	{0,0,3,0,-4,0,0,0,-4,2,0,3.185016968978187978933647,0.00001},
	{0,0,3,0,-4,0,0,0,-2,-1,0,3.182870039465309108805968,0.00014},
	{0,0,3,0,-4,0,0,0,-2,0,0,3.170424794701038884170430,0.00167},
	{0,0,3,0,-4,0,0,0,-2,0,2,3.176975713515474364356805,0.00001},
	{0,0,3,0,-4,0,0,0,-2,1,0,3.183533090048142000227926,0.00145},
	{0,0,3,0,-4,0,0,0,-2,2,0,3.145629949215506648840801,0.00006},
	{0,0,3,0,-4,0,0,0,0,-2,0,0.683200409046920364986022,0.00002},
	{0,0,3,0,-4,0,0,0,0,-1,0,0.842483170841202388956503,0.00030},
	{0,0,3,0,-4,0,0,0,0,0,0,3.256963105936823144048731,0.00241},
	{0,0,3,0,-4,0,0,0,0,1,0,3.265955740374798743630436,0.00067},
	{0,0,3,0,-4,0,0,0,0,2,0,3.365862750082083909575204,0.00003},
	{0,0,3,0,-4,0,0,0,1,-3,0,0.252547222901402301786788,0.00005},
	{0,0,3,0,-4,0,0,0,1,-2,0,0.246724106385048408407457,0.00018},
	{0,0,3,0,-4,0,0,0,1,0,-1,4.890254437257881114931024,0.00006},
	{0,0,3,0,-4,0,0,0,2,-3,0,3.262434887674750871866536,0.00003},
	{0,0,3,0,-4,0,0,0,2,-2,0,3.222245190989077023857590,0.00017},
	{0,0,3,0,-4,0,0,0,2,-1,0,3.304860700198079204170654,0.00593},
	{0,0,3,0,-4,0,0,0,2,0,-2,3.323629098309400120569990,0.00023},
	{0,0,3,0,-4,0,0,0,2,0,0,0.218661480941007180245350,0.00088},
	{0,0,3,0,-4,0,0,0,2,1,0,0.180485719679210010468751,0.00009},
	{0,0,3,0,-4,0,0,0,2,2,0,0.178483652494247302389141,0.00002},
	{0,0,3,0,-4,0,0,0,3,-4,0,0.255485310164209555860992,0.00014},
	{0,0,3,0,-4,0,0,0,3,-3,0,0.252547222901402301786788,0.00452},
	{0,0,3,0,-4,0,0,0,3,-2,0,3.380710615094649984513353,0.00038},
	{0,0,3,0,-4,0,0,0,3,-1,0,3.380708869765398194573436,0.00003},
	{0,0,3,0,-4,0,0,0,4,-2,0,3.288729145520671082181252,0.00009},
	{0,0,3,0,-4,0,0,0,4,-1,0,3.312726201005116610787127,0.00005},
	{0,0,3,0,-4,0,0,0,4,0,0,0.124872722926587895186934,0.00003},
	{0,0,3,0,-4,0,0,0,5,-4,0,0.251393734798759260762324,0.00007},
	{0,0,3,0,-4,0,0,0,5,-3,0,0.252547222901402301786788,0.00005},
	{0,0,3,0,-4,1,0,0,2,-3,0,3.164333595611578786588325,0.00001},
	{0,0,3,0,-4,1,0,0,2,-1,0,0.022740942021785313237325,0.00001},
	{0,0,3,0,-4,2,0,0,-2,0,0,1.714620358338414529697502,0.00002},
	{0,0,3,0,-4,2,0,0,0,-1,0,1.386610858167309112687349,0.00003},
	{0,0,3,0,-4,2,0,0,0,0,0,1.980528076663833347836885,0.00002},
	{0,0,3,0,-4,2,0,0,2,-3,0,0.311878120026622740468270,0.00001},
	{0,0,3,0,-4,2,0,0,2,-1,0,3.420010717460582050364337,0.00001},
	{0,0,3,0,-4,3,0,0,0,-1,0,2.342413021352747204417710,0.00004},
	{0,0,3,0,-4,3,0,0,2,-1,0,2.342435187034247245918550,0.00002},
	{0,0,3,0,-4,5,0,0,-2,0,0,4.295620586570486842958871,0.00006},
	{0,0,3,0,-4,5,0,0,-2,1,0,4.296210507857661120567627,0.00004},
	{0,0,3,0,-4,5,0,0,0,-1,0,1.191667703629203822757177,0.00006},
	{0,0,3,0,-4,5,0,0,0,0,0,4.264404674766868019730737,0.00003},
	{0,0,3,0,-4,5,0,0,2,-1,0,1.191651123001310041971124,0.00003},
	{0,0,3,0,-3,0,0,0,-4,0,0,2.618554477747234709994473,0.00009},
	{0,0,3,0,-3,0,0,0,-4,1,0,2.835235009987228771421996,0.00017},
	{0,0,3,0,-3,0,0,0,-4,2,0,2.894596101308508639959882,0.00006},
	{0,0,3,0,-3,0,0,0,-3,0,0,2.807712040347903670323149,0.00001},
	{0,0,3,0,-3,0,0,0,-2,-2,0,2.677475047965311549802436,0.00006},
	{0,0,3,0,-3,0,0,0,-2,-1,0,2.675373147947134544466508,0.00053},
	{0,0,3,0,-3,0,0,0,-2,0,-2,6.044823422306693672112488,0.00002},
	{0,0,3,0,-3,0,0,0,-2,0,0,2.855777535283201551408183,0.00655},
	{0,0,3,0,-3,0,0,0,-2,0,2,2.902661093249049084619173,0.00005},
	{0,0,3,0,-3,0,0,0,-2,1,0,2.884377722136857613577376,0.00556},
	{0,0,3,0,-3,0,0,0,-2,2,0,2.884650691631869268150012,0.00025},
	{0,0,3,0,-3,0,0,0,-2,3,0,2.884147513208519253424811,0.00002},
	{0,0,3,0,-3,0,0,0,-1,0,0,6.073727645516046713680680,0.00009},
	{0,0,3,0,-3,0,0,0,0,-2,0,1.261976721749468843825071,0.00010},
	{0,0,3,0,-3,0,0,0,0,-1,0,1.322435974236103373158357,0.00442},
	{0,0,3,0,-3,0,0,0,0,0,-2,6.139463551930235851727957,0.00001},
	{0,0,3,0,-3,0,0,0,0,0,0,2.963289642673127222138874,0.00851},
	{0,0,3,0,-3,0,0,0,0,1,-2,3.143188931723667423057123,0.00001},
	{0,0,3,0,-3,0,0,0,0,1,0,3.055907459292383610005572,0.00246},
	{0,0,3,0,-3,0,0,0,0,2,0,3.048971346312032704162220,0.00017},
	{0,0,3,0,-3,0,0,0,0,3,0,3.096479208551318418329856,0.00001},
	{0,0,3,0,-3,0,0,0,1,0,0,6.196492010706225350702425,0.00008},
	{0,0,3,0,-3,0,0,0,2,-3,0,3.910510370992359430175611,0.00008},
	{0,0,3,0,-3,0,0,0,2,-2,0,2.643066579893943668366774,0.00069},
	{0,0,3,0,-3,0,0,0,2,-1,-2,3.136076365955939859730961,0.00003},
	{0,0,3,0,-3,0,0,0,2,-1,0,3.031951419045359585879851,0.02166},
	{0,0,3,0,-3,0,0,0,2,-1,2,6.272811244638657690586570,0.00005},
	{0,0,3,0,-3,0,0,0,2,0,-2,3.150467478303259127869751,0.00083},
	{0,0,3,0,-3,0,0,0,2,0,0,0.094955336086452304944494,0.00368},
	{0,0,3,0,-3,0,0,0,2,0,2,3.135174379798509214367641,0.00002},
	{0,0,3,0,-3,0,0,0,2,1,-2,6.264755852009002978775243,0.00002},
	{0,0,3,0,-3,0,0,0,2,1,0,0.110376192692448193977128,0.00032},
	{0,0,3,0,-3,0,0,0,2,2,0,6.281771241419620288581882,0.00007},
	{0,0,3,0,-3,0,0,0,3,-4,0,3.143245654924356813353370,0.00001},
	{0,0,3,0,-3,0,0,0,3,-2,0,3.689968995914029381566479,0.00005},
	{0,0,3,0,-3,0,0,0,3,-1,0,4.662626850883528462077265,0.00002},
	{0,0,3,0,-3,0,0,0,4,-3,0,1.376516571905474606296593,0.00003},
	{0,0,3,0,-3,0,0,0,4,-2,0,2.806234444603165734122285,0.00032},
	{0,0,3,0,-3,0,0,0,4,-1,-2,3.143188931723667423057123,0.00001},
	{0,0,3,0,-3,0,0,0,4,-1,0,2.552154299019736338749453,0.00011},
	{0,0,3,0,-3,0,0,0,4,0,0,6.278417765794838345527751,0.00004},
	{0,0,3,0,-3,0,0,0,4,2,0,0.000613657765001206245183,0.00001},
	{0,0,3,0,-3,1,0,0,0,-1,0,1.370104581299497858992709,0.00005},
	{0,0,3,0,-3,1,0,0,2,-1,0,1.370096203719088245875923,0.00003},
	{0,0,3,0,-2,-5,0,0,-2,0,0,3.323184912014767622423506,0.00002},
	{0,0,3,0,-2,-5,0,0,0,0,0,3.402277648661544251496025,0.00003},
	{0,0,3,0,-2,-5,0,0,2,-3,0,0.368743914116326343410890,0.00002},
	{0,0,3,0,-2,-5,0,0,2,-2,0,3.483765500640832790679724,0.00001},
	{0,0,3,0,-2,-5,0,0,2,-1,0,3.475016688699360756231727,0.00005},
	{0,0,3,0,-2,-5,0,0,3,-3,0,0.315763572007412451903008,0.00018},
	{0,0,3,0,-2,-2,0,0,2,-3,0,3.011480975847494079289390,0.00001},
	{0,0,3,0,-2,-2,0,0,2,-1,0,6.153073629437286307108934,0.00001},
	{0,0,3,0,-2,0,0,0,-4,0,0,1.324423555188274814753413,0.00016},
	{0,0,3,0,-2,0,0,0,-4,1,0,1.331840680910475027687312,0.00033},
	{0,0,3,0,-2,0,0,0,-4,2,0,1.319601734063789777451348,0.00010},
	{0,0,3,0,-2,0,0,0,-3,0,0,1.331473638168780393442603,0.00002},
	{0,0,3,0,-2,0,0,0,-3,3,0,4.472648285402721413106519,0.00001},
	{0,0,3,0,-2,0,0,0,-2,-3,0,4.491300968184634534452471,0.00001},
	{0,0,3,0,-2,0,0,0,-2,-2,0,1.309293121369810686260848,0.00005},
	{0,0,3,0,-2,0,0,0,-2,-1,0,1.313470217868608624911531,0.00053},
	{0,0,3,0,-2,0,0,0,-2,0,-2,4.458765761999432974960200,0.00002},
	{0,0,3,0,-2,0,0,0,-2,0,0,1.321494892703428236657714,0.00860},
	{0,0,3,0,-2,0,0,0,-2,0,2,1.321423683269946858231947,0.00006},
	{0,0,3,0,-2,0,0,0,-2,1,0,1.320647709884510190292417,0.00702},
	{0,0,3,0,-2,0,0,0,-2,2,0,1.339425707306717283628927,0.00034},
	{0,0,3,0,-2,0,0,0,-2,3,0,1.346430935325446887063094,0.00002},
	{0,0,3,0,-2,0,0,0,-1,0,0,4.440236648528560259308051,0.00006},
	{0,0,3,0,-2,0,0,0,0,-3,0,4.475848695652103081954465,0.00008},
	{0,0,3,0,-2,0,0,0,0,-2,0,4.483540361665641960087214,0.00076},
	{0,0,3,0,-2,0,0,0,0,-1,-2,1.347130637822571141981598,0.00002},
	{0,0,3,0,-2,0,0,0,0,-1,0,4.482585142966025948396691,0.00813},
	{0,0,3,0,-2,0,0,0,0,0,0,1.291244322509086828176805,0.00487},
	{0,0,3,0,-2,0,0,0,0,1,0,1.275494471339089885830731,0.00095},
	{0,0,3,0,-2,0,0,0,0,2,0,1.229667884768250507576681,0.00006},
	{0,0,3,0,-2,0,0,0,1,-2,-1,1.326407296416091341484389,0.00002},
	{0,0,3,0,-2,0,0,0,1,-1,-1,1.345579040117548474952969,0.00012},
	{0,0,3,0,-2,0,0,0,1,0,-1,4.527884465569838035037264,0.00006},
	{0,0,3,0,-2,0,0,0,2,-3,0,4.579337470050330871629285,0.00003},
	{0,0,3,0,-2,0,0,0,2,-2,0,4.531863990797309504898749,0.00060},
	{0,0,3,0,-2,0,0,0,2,-1,0,4.693861786775994637821441,0.00452},
	{0,0,3,0,-2,0,0,0,2,0,-2,5.522176898348281959272299,0.00004},
	{0,0,3,0,-2,0,0,0,2,0,0,4.222858857252394848558197,0.00063},
	{0,0,3,0,-2,0,0,0,2,1,0,3.984294863252120677543644,0.00006},
	{0,0,3,0,-2,0,0,0,3,-3,-1,1.044718834592915257530876,0.00001},
	{0,0,3,0,-2,0,0,0,3,-2,-1,1.326407296416091341484389,0.00161},
	{0,0,3,0,-2,0,0,0,3,-2,0,1.347477958343718196232430,0.00002},
	{0,0,3,0,-2,0,0,0,3,-1,-1,4.495193052416581735997170,0.00042},
	{0,0,3,0,-2,0,0,0,3,-1,0,1.347130637822571141981598,0.00007},
	{0,0,3,0,-2,0,0,0,3,0,-1,4.490489739148308068195092,0.00003},
	{0,0,3,0,-2,0,0,0,4,-3,0,1.360898144028152900730788,0.00001},
	{0,0,3,0,-2,0,0,0,4,-2,0,4.591270809744992575929246,0.00013},
	{0,0,3,0,-2,0,0,0,4,-1,0,4.482744666059658378287622,0.00016},
	{0,0,3,0,-2,0,0,0,4,0,0,4.598303090367128476145808,0.00003},
	{0,0,3,0,-2,0,0,0,5,-3,-1,1.348644885481601551902031,0.00003},
	{0,0,3,0,-2,0,0,0,5,-2,-1,1.326407296416091341484389,0.00002},
	{0,0,3,0,-2,5,0,0,2,-3,0,5.391478091845612219401573,0.00001},
	{0,0,3,0,-2,5,0,0,2,-1,0,5.391478091845612219401573,0.00001},
	{0,0,3,0,-1,-5,0,0,-2,0,0,2.988250992569299491208312,0.00007},
	{0,0,3,0,-1,-5,0,0,-2,1,0,3.027024878165755605863296,0.00005},
	{0,0,3,0,-1,-5,0,0,0,-1,0,0.787396914456832131001818,0.00005},
	{0,0,3,0,-1,-5,0,0,0,0,0,3.194516097965091727672871,0.00011},
	{0,0,3,0,-1,-5,0,0,0,2,0,3.293956232097468905806181,0.00001},
	{0,0,3,0,-1,-5,0,0,2,-3,0,3.285238661549607641632065,0.00002},
	{0,0,3,0,-1,-5,0,0,2,-1,0,3.195101830462061531790141,0.00018},
	{0,0,3,0,-1,-5,0,0,2,0,0,0.146436963966678629356366,0.00006},
	{0,0,3,0,-1,-5,0,0,2,2,0,0.151987809119721400952230,0.00001},
	{0,0,3,0,-1,0,0,0,-4,0,0,2.912355350046326396551422,0.00003},
	{0,0,3,0,-1,0,0,0,-4,1,0,2.849092051583437257278320,0.00004},
	{0,0,3,0,-1,0,0,0,-2,-1,0,2.879229873508100112644570,0.00012},
	{0,0,3,0,-1,0,0,0,-2,0,0,2.880835052821158814850833,0.00105},
	{0,0,3,0,-1,0,0,0,-2,1,0,2.888521482846942323163830,0.00078},
	{0,0,3,0,-1,0,0,0,-2,2,0,2.897569095156355967191075,0.00004},
	{0,0,3,0,-1,0,0,0,-1,0,0,2.702403760204471705463902,0.00002},
	{0,0,3,0,-1,0,0,0,0,-2,0,0.257512510090400936757504,0.00001},
	{0,0,3,0,-1,0,0,0,0,-1,0,2.512722947894054925654928,0.00015},
	{0,0,3,0,-1,0,0,0,0,0,0,3.043971327070919663526638,0.00035},
	{0,0,3,0,-1,0,0,0,0,1,0,3.180952620749068149308414,0.00005},
	{0,0,3,0,-1,0,0,0,2,-1,0,0.928456518998116320240399,0.00003},
	{0,0,3,0,0,-5,0,0,-2,0,0,1.305606811456673455040800,0.00006},
	{0,0,3,0,0,-5,0,0,-2,1,0,1.449413215174746083491186,0.00005},
	{0,0,3,0,0,-5,0,0,0,-1,0,4.620382901668256714344807,0.00006},
	{0,0,3,0,0,-5,0,0,0,0,0,1.116637395349369343833246,0.00004},
	{0,0,3,0,0,-5,0,0,2,-1,0,5.317745086798784548420826,0.00004},
	{0,0,3,0,0,-5,0,0,2,0,0,3.237002997012240257390658,0.00002},
	{0,0,3,0,0,-5,0,0,3,-2,-1,2.996097294754565432128857,0.00004},
	{0,0,3,0,0,-4,0,0,-2,0,0,4.718961366748924746161720,0.00006},
	{0,0,3,0,0,-4,0,0,-2,1,0,4.725973750617587398892283,0.00002},
	{0,0,3,0,0,-4,0,0,0,0,0,4.736734229054908595912821,0.00005},
	{0,0,3,0,0,-4,0,0,0,1,0,4.711886849158890555600010,0.00002},
	{0,0,3,0,0,-4,0,0,2,-1,0,4.759995977325488958342703,0.00012},
	{0,0,3,0,0,-4,0,0,2,0,0,1.618403323735695620300135,0.00005},
	{0,0,3,0,0,-3,0,0,-2,-1,0,3.085743339256451278629356,0.00002},
	{0,0,3,0,0,-3,0,0,-2,0,0,3.085234575779494559100158,0.00020},
	{0,0,3,0,0,-3,0,0,-2,1,0,3.082724268716351634367356,0.00016},
	{0,0,3,0,0,-3,0,0,0,-1,0,6.160280792050472520315907,0.00003},
	{0,0,3,0,0,-3,0,0,0,0,0,3.099872303150120522730049,0.00021},
	{0,0,3,0,0,-3,0,0,0,1,0,3.107956493712433321263688,0.00007},
	{0,0,3,0,0,-3,0,0,2,-2,0,3.141745020833492496592498,0.00002},
	{0,0,3,0,0,-3,0,0,2,-1,0,3.149348722252730770065909,0.00044},
	{0,0,3,0,0,-3,0,0,2,0,-2,3.141745020833492496592498,0.00001},
	{0,0,3,0,0,-3,0,0,2,0,0,0.000097738438111682449279,0.00009},
	{0,0,3,0,0,-3,0,0,2,1,0,6.282616504376361099559745,0.00003},
	{0,0,3,0,0,-2,0,0,-4,1,0,1.343068733054404884086352,0.00001},
	{0,0,3,0,0,-2,0,0,-2,-1,0,1.342869416453827069446447,0.00005},
	{0,0,3,0,0,-2,0,0,-2,0,0,1.342979372196702936292922,0.00033},
	{0,0,3,0,0,-2,0,0,-2,1,0,1.342988447908812998932149,0.00026},
	{0,0,3,0,0,-2,0,0,0,-2,0,4.487337674519205954482004,0.00001},
	{0,0,3,0,0,-2,0,0,0,-1,0,4.495074195494521696048196,0.00005},
	{0,0,3,0,0,-2,0,0,0,0,0,1.337831523567945657404721,0.00022},
	{0,0,3,0,0,-2,0,0,0,1,0,1.337850024058016673578209,0.00003},
	{0,0,3,0,0,-2,0,0,2,-2,0,4.487583591410811756361454,0.00001},
	{0,0,3,0,0,-2,0,0,2,-1,0,4.486956843676420447764031,0.00007},
	{0,0,3,0,0,-2,0,0,2,0,0,1.418969786098059460144327,0.00001},
	{0,0,3,0,0,-1,0,0,-2,0,0,2.720798657855865609889179,0.00010},
	{0,0,3,0,0,-1,0,0,-2,1,0,2.720918038376702430269916,0.00006},
	{0,0,3,0,0,-1,0,0,0,0,0,2.750071145537389405433260,0.00002},
	{0,0,3,0,0,0,0,0,-2,0,0,4.690486494535561767804666,0.00008},
	{0,0,3,0,0,0,0,0,-2,1,0,5.078011198600898445931762,0.00004},
	{0,0,3,0,0,0,0,0,-1,0,1,2.108718495965537620406849,0.00002},
	{0,0,3,0,0,0,0,0,0,-1,0,5.381955749979656644654824,0.00002},
	{0,0,3,0,0,0,0,0,0,0,0,5.107688602668885913260510,0.00021},
	{0,0,3,0,0,0,0,0,0,1,0,5.139169629985882004064024,0.00003},
	{0,0,3,0,0,0,0,0,1,0,-1,5.308134780338527924925529,0.00003},
	{0,0,3,0,0,0,0,0,2,-3,0,3.772624124097051723225604,0.00003},
	{0,0,3,0,0,0,0,0,2,-2,0,0.682395114130050162160046,0.00003},
	{0,0,3,0,0,0,0,0,2,-1,0,5.304800852401369226640782,0.00004},
	{0,0,3,0,0,0,0,0,2,0,0,1.363560992867920651505642,0.00003},
	{0,0,3,0,0,0,0,0,4,0,0,0.892921091828736135376232,0.00002},
	{0,0,3,0,1,0,0,0,-2,0,0,0.680211358169954816155212,0.00002},
	{0,0,3,0,1,0,0,0,2,-3,0,5.355841610112541673061060,0.00001},
	{0,0,3,0,1,0,0,0,2,-2,0,2.214250178253224898838880,0.00001},
	{0,0,3,0,1,0,0,0,2,-1,0,2.214248956522748557063096,0.00001},
	{0,0,3,0,1,0,0,0,2,0,0,5.329987349771048599222922,0.00002},
	{0,0,3,0,2,-5,0,0,-2,0,0,3.845116898177411535186820,0.00003},
	{0,0,3,0,2,-5,0,0,0,0,0,3.822844926125637421421288,0.00001},
	{0,0,3,0,2,-5,0,0,2,-3,0,2.603022618200812043909309,0.00001},
	{0,0,3,0,2,-5,0,0,2,-1,0,2.603022618200812043909309,0.00001},
	{0,0,3,0,3,-2,0,0,2,-3,0,5.360297610225808639938805,0.00001},
	{0,0,3,0,3,-2,0,0,2,-2,0,2.218704956636015079851632,0.00001},
	{0,0,3,0,3,-2,0,0,2,-1,0,5.360297610225808639938805,0.00001},
	{0,0,3,0,3,-2,0,0,2,0,0,2.218704956636015079851632,0.00001},
	{0,0,3,0,4,-5,0,0,2,0,0,3.361695951025872819428741,0.00001},
	{0,0,3,2,0,0,0,0,2,-2,0,2.949101686650740017370254,0.00002},
	{0,0,3,2,0,0,0,0,2,0,0,2.948292202943665341052792,0.00003},
	{0,0,3,3,0,0,0,0,2,-2,0,3.223417179581791192077844,0.00001},
	{0,0,3,3,0,0,0,0,2,0,0,3.223417179581791192077844,0.00001},
	{0,0,4,-11,0,0,0,0,-2,1,0,5.798468627591367052787064,0.00005},
	{0,0,4,-11,0,0,0,0,-2,3,0,5.640380718202999688060117,0.00001},
	{0,0,4,-11,0,2,0,0,-2,2,0,6.230592079098764557443246,0.00001},
	{0,0,4,-11,1,0,0,0,-2,1,0,6.118473873279900665522746,0.00002},
	{0,0,4,-11,1,0,0,0,-2,2,0,3.820080324590478415558437,0.00002},
	{0,0,4,-10,0,0,0,0,0,0,0,4.522191899681533122645760,0.00001},
	{0,0,4,-10,0,0,0,0,2,0,0,5.638697522672377004937516,0.00002},
	{0,0,4,-10,2,0,0,0,-2,0,0,0.895729326595195107785230,0.00002},
	{0,0,4,-10,2,0,0,0,-2,1,0,0.898995884823227675575197,0.00001},
	{0,0,4,-10,2,0,0,0,-2,2,0,4.035918037334684349559666,0.00001},
	{0,0,4,-10,2,0,0,0,-2,3,0,0.898995884823227675575197,0.00001},
	{0,0,4,-9,0,0,0,0,-1,0,1,5.120488847403012577785830,0.00002},
	{0,0,4,-9,0,0,0,0,0,-1,0,4.452537903629541382599655,0.00002},
	{0,0,4,-9,0,0,0,0,0,0,0,4.041336411997500377424331,0.00016},
	{0,0,4,-9,0,0,0,0,0,1,0,4.731347619384478342396960,0.00003},
	{0,0,4,-9,0,0,0,0,2,-1,0,5.684661641188273328850755,0.00006},
	{0,0,4,-9,0,0,0,0,2,0,0,5.464854351593332104641831,0.00005},
	{0,0,4,-8,0,0,0,0,-2,-1,0,4.234348359718273613339079,0.00003},
	{0,0,4,-8,0,0,0,0,-2,0,0,4.246588353762509981947915,0.00023},
	{0,0,4,-8,0,0,0,0,-2,1,0,4.276344646712686881073751,0.00032},
	{0,0,4,-8,0,0,0,0,0,-2,0,4.201458153563216058046237,0.00005},
	{0,0,4,-8,0,0,0,0,0,-1,0,4.189203847819113590844609,0.00069},
	{0,0,4,-8,0,0,0,0,0,0,0,4.238990935528578418711732,0.00373},
	{0,0,4,-8,0,0,0,0,0,1,0,4.202215626458581709812279,0.00074},
	{0,0,4,-8,0,0,0,0,0,2,0,4.210438047097651903527549,0.00006},
	{0,0,4,-8,0,0,0,0,1,0,-1,5.664583024407479960871115,0.00001},
	{0,0,4,-8,0,0,0,0,2,-2,0,4.313096742903631763965677,0.00002},
	{0,0,4,-8,0,0,0,0,2,-1,0,4.332965571108335467442885,0.00053},
	{0,0,4,-8,0,0,0,0,2,0,0,4.302568044190976159768525,0.00038},
	{0,0,4,-8,0,0,0,0,2,1,0,4.309642910846860353046850,0.00004},
	{0,0,4,-8,0,0,0,0,4,-1,0,4.310032119270054806747794,0.00001},
	{0,0,4,-8,1,0,0,0,0,0,0,1.642095470199817608403237,0.00001},
	{0,0,4,-8,1,5,0,0,-4,0,0,1.730901487732718457834835,0.00001},
	{0,0,4,-8,1,5,0,0,-4,1,0,4.872494141322512462011218,0.00003},
	{0,0,4,-8,1,5,0,0,-4,2,0,4.872496410250539256026059,0.00001},
	{0,0,4,-8,1,5,0,0,-2,-1,0,4.870108450767959951122066,0.00007},
	{0,0,4,-8,1,5,0,0,-2,0,0,4.870280714765132579202600,0.00064},
	{0,0,4,-8,1,5,0,0,-2,0,2,4.872494141322512462011218,0.00002},
	{0,0,4,-8,1,5,0,0,-2,1,0,4.880100635268552977663603,0.00099},
	{0,0,4,-8,1,5,0,0,-2,2,0,4.872497806513941043249361,0.00004},
	{0,0,4,-8,1,5,0,0,0,-2,0,4.829642817527546760913992,0.00008},
	{0,0,4,-8,1,5,0,0,0,-1,0,4.831673333579317386465846,0.00125},
	{0,0,4,-8,1,5,0,0,0,0,0,4.853476335661080831584968,0.00650},
	{0,0,4,-8,1,5,0,0,0,1,0,4.831655705753871821173107,0.00125},
	{0,0,4,-8,1,5,0,0,0,2,0,4.829633741815436032140951,0.00008},
	{0,0,4,-8,1,5,0,0,2,-2,0,4.872435847325494506776522,0.00004},
	{0,0,4,-8,1,5,0,0,2,-1,0,4.880040421409360007487521,0.00099},
	{0,0,4,-8,1,5,0,0,2,0,-2,4.872439337983998974834776,0.00002},
	{0,0,4,-8,1,5,0,0,2,0,0,4.870229402085123560084412,0.00064},
	{0,0,4,-8,1,5,0,0,2,1,0,4.870058185285502716510564,0.00007},
	{0,0,4,-8,1,5,0,0,4,-2,0,4.872437243588897182178243,0.00001},
	{0,0,4,-8,1,5,0,0,4,-1,0,4.872439337983998974834776,0.00003},
	{0,0,4,-8,1,5,0,0,4,0,0,1.730846684394205858836813,0.00001},
	{0,0,4,-8,2,0,0,0,-2,0,0,5.261365192372836396828006,0.00002},
	{0,0,4,-8,2,0,0,0,-2,1,0,5.256773056577913827425164,0.00001},
	{0,0,4,-8,2,0,0,0,0,-1,0,5.262427225222674920246391,0.00005},
	{0,0,4,-8,2,0,0,0,0,0,0,5.239795017213289440860535,0.00018},
	{0,0,4,-8,2,0,0,0,0,1,0,5.262427225222674920246391,0.00005},
	{0,0,4,-8,2,0,0,0,2,-1,0,5.262734752236876367703644,0.00001},
	{0,0,4,-8,2,0,0,0,2,0,0,5.264683586879653987011807,0.00002},
	{0,0,4,-8,3,0,0,0,-6,0,0,5.005254530737637708170951,0.00002},
	{0,0,4,-8,3,0,0,0,-6,1,0,5.005270762299680598061968,0.00004},
	{0,0,4,-8,3,0,0,0,-6,2,0,5.005290659053153845547968,0.00005},
	{0,0,4,-8,3,0,0,0,-6,3,0,5.005292578915331525024612,0.00002},
	{0,0,4,-8,3,0,0,0,-4,-1,0,5.001159290180757999166872,0.00017},
	{0,0,4,-8,3,0,0,0,-4,0,0,5.003655111011109823948573,0.00106},
	{0,0,4,-8,3,0,0,0,-4,0,2,5.005258719527842181662436,0.00002},
	{0,0,4,-8,3,0,0,0,-4,1,-2,1.863687009889072987434133,0.00002},
	{0,0,4,-8,3,0,0,0,-4,1,0,5.006960939147312217301078,0.00264},
	{0,0,4,-8,3,0,0,0,-4,1,2,5.005237950109743927384898,0.00002},
	{0,0,4,-8,3,0,0,0,-4,2,0,5.011016735263097210406613,0.00189},
	{0,0,4,-8,3,0,0,0,-4,3,0,5.021227434986038851150170,0.00005},
	{0,0,4,-8,3,0,0,0,-3,-1,0,5.005264130048523441018915,0.00003},
	{0,0,4,-8,3,0,0,0,-3,0,0,5.005188557291912587743354,0.00003},
	{0,0,4,-8,3,0,0,0,-3,1,0,1.866505018499343027116311,0.00017},
	{0,0,4,-8,3,0,0,0,-3,2,0,1.872708965858482121902284,0.00006},
	{0,0,4,-8,3,0,0,0,-2,-3,0,4.995319767569434965537312,0.00008},
	{0,0,4,-8,3,0,0,0,-2,-2,0,4.995144361979609648471978,0.00076},
	{0,0,4,-8,3,0,0,0,-2,-2,2,1.863677934176962480705697,0.00001},
	{0,0,4,-8,3,0,0,0,-2,-1,-2,1.861111427511904947706967,0.00006},
	{0,0,4,-8,3,0,0,0,-2,-1,0,4.998786165996821573287434,0.00876},
	{0,0,4,-8,3,0,0,0,-2,-1,2,1.856625058669653549614509,0.00027},
	{0,0,4,-8,3,0,0,0,-2,0,-2,1.862426009504507096181669,0.00024},
	{0,0,4,-8,3,0,0,0,-2,0,0,5.003676927626759862732797,0.09002},
	{0,0,4,-8,3,0,0,0,-2,0,2,5.003510074150268494008742,0.00210},
	{0,0,4,-8,3,0,0,0,-2,1,-2,1.868870986833346403699352,0.00033},
	{0,0,4,-8,3,0,0,0,-2,1,0,5.011052514512763345067015,0.13960},
	{0,0,4,-8,3,0,0,0,-2,2,-2,1.863720345677786216498362,0.00002},
	{0,0,4,-8,3,0,0,0,-2,2,0,5.023322004621357805831394,0.00484},
	{0,0,4,-8,3,0,0,0,-2,2,2,1.863689278817100669627393,0.00003},
	{0,0,4,-8,3,0,0,0,-2,3,0,5.043821594817731401860783,0.00022},
	{0,0,4,-8,3,0,0,0,-2,4,0,5.057521556781260585466953,0.00001},
	{0,0,4,-8,3,0,0,0,-1,-1,0,1.853417841636188834186783,0.00022},
	{0,0,4,-8,3,0,0,0,-1,0,0,1.862105043455065223056977,0.00237},
	{0,0,4,-8,3,0,0,0,-1,1,0,1.881508915947037507976347,0.00021},
	{0,0,4,-8,3,0,0,0,-1,2,0,1.910668829891807529719472,0.00002},
	{0,0,4,-8,3,0,0,0,0,-4,0,4.971123570017337733872864,0.00005},
	{0,0,4,-8,3,0,0,0,0,-3,0,4.973098933664744869531660,0.00080},
	{0,0,4,-8,3,0,0,0,0,-2,-2,1.833083359587053262629297,0.00006},
	{0,0,4,-8,3,0,0,0,0,-2,0,4.974001617953875964417421,0.01162},
	{0,0,4,-8,3,0,0,0,0,-2,2,1.826969296684391785845492,0.00002},
	{0,0,4,-8,3,0,0,0,0,-1,-2,1.836786250128084274635398,0.00039},
	{0,0,4,-8,3,0,0,0,0,-1,0,4.973974739883394668993333,0.17083},
	{0,0,4,-8,3,0,0,0,0,-1,2,4.964619949625630468403870,0.00024},
	{0,0,4,-8,3,0,0,0,0,0,-2,1.871411488092549424422373,0.00034},
	{0,0,4,-8,3,0,0,0,0,0,0,4.991415989631500238488115,0.90114},
	{0,0,4,-8,3,0,0,0,0,0,2,1.871457041186026515333651,0.00034},
	{0,0,4,-8,3,0,0,0,0,1,-2,4.964197405413723451772512,0.00023},
	{0,0,4,-8,3,0,0,0,0,1,0,4.973973169087067880411723,0.17082},
	{0,0,4,-8,3,0,0,0,0,1,2,1.836797420235297240154182,0.00039},
	{0,0,4,-8,3,0,0,0,0,2,-2,1.826980117725754304558450,0.00002},
	{0,0,4,-8,3,0,0,0,0,2,0,4.974010519133060803653734,0.01162},
	{0,0,4,-8,3,0,0,0,0,2,2,1.833089468239435193552822,0.00006},
	{0,0,4,-8,3,0,0,0,0,3,0,4.973106787646378812439707,0.00080},
	{0,0,4,-8,3,0,0,0,0,4,0,4.971130376801419892274225,0.00005},
	{0,0,4,-8,3,0,0,0,1,-2,0,1.910696755159839499427221,0.00002},
	{0,0,4,-8,3,0,0,0,1,-1,0,1.881485877600911127416339,0.00022},
	{0,0,4,-8,3,0,0,0,1,0,0,1.862108010514793576817283,0.00237},
	{0,0,4,-8,3,0,0,0,1,1,0,1.853438087455511862344792,0.00022},
	{0,0,4,-8,3,0,0,0,2,-4,0,5.057499391099760543966113,0.00001},
	{0,0,4,-8,3,0,0,0,2,-3,0,5.043824038278684085412351,0.00022},
	{0,0,4,-8,3,0,0,0,2,-2,-2,1.863735180976427985299892,0.00003},
	{0,0,4,-8,3,0,0,0,2,-2,0,5.023326018878637277964572,0.00485},
	{0,0,4,-8,3,0,0,0,2,-2,2,1.863724359935065688631539,0.00002},
	{0,0,4,-8,3,0,0,0,2,-1,0,5.011082534175896441297482,0.13971},
	{0,0,4,-8,3,0,0,0,2,-1,2,1.868901530095256280361582,0.00033},
	{0,0,4,-8,3,0,0,0,2,0,-2,5.003555452710821249695528,0.00210},
	{0,0,4,-8,3,0,0,0,2,0,0,5.003731381899422459014204,0.09009},
	{0,0,4,-8,3,0,0,0,2,0,2,1.862452189443287053904896,0.00024},
	{0,0,4,-8,3,0,0,0,2,1,-2,1.856668866433878628541265,0.00027},
	{0,0,4,-8,3,0,0,0,2,1,0,4.998804666486893033550132,0.00875},
	{0,0,4,-8,3,0,0,0,2,1,2,1.861141272642114152802151,0.00006},
	{0,0,4,-8,3,0,0,0,2,2,-2,1.863733435647175973315370,0.00001},
	{0,0,4,-8,3,0,0,0,2,2,0,4.995168971122062373524386,0.00076},
	{0,0,4,-8,3,0,0,0,2,3,0,4.995358513878829676002624,0.00008},
	{0,0,4,-8,3,0,0,0,3,-2,0,1.872775811968833359344444,0.00006},
	{0,0,4,-8,3,0,0,0,3,-1,0,1.866545510137989305476935,0.00017},
	{0,0,4,-8,3,0,0,0,3,0,0,5.005390840952218312054356,0.00003},
	{0,0,4,-8,3,0,0,0,3,1,0,5.005333070553978025429842,0.00003},
	{0,0,4,-8,3,0,0,0,4,-3,0,5.021190259472971817444886,0.00005},
	{0,0,4,-8,3,0,0,0,4,-2,0,5.011047278525006198890424,0.00189},
	{0,0,4,-8,3,0,0,0,4,-1,-2,5.005339353739285179756280,0.00002},
	{0,0,4,-8,3,0,0,0,4,-1,0,5.006996369331127461066444,0.00264},
	{0,0,4,-8,3,0,0,0,4,-1,2,1.863730817653298066360890,0.00002},
	{0,0,4,-8,3,0,0,0,4,0,-2,5.005323471243091404403458,0.00002},
	{0,0,4,-8,3,0,0,0,4,0,0,5.003736966953028719728991,0.00107},
	{0,0,4,-8,3,0,0,0,4,1,0,5.001209206597365231061758,0.00017},
	{0,0,4,-8,3,0,0,0,6,-3,0,5.005318409788260147763594,0.00002},
	{0,0,4,-8,3,0,0,0,6,-2,0,5.005320504183362828598547,0.00005},
	{0,0,4,-8,3,0,0,0,6,-1,0,5.005321900446764615821849,0.00004},
	{0,0,4,-8,3,0,0,0,6,0,0,5.005322773111390510791807,0.00002},
	{0,0,4,-8,5,-5,0,0,-2,0,0,1.069908648088174096812963,0.00007},
	{0,0,4,-8,5,-5,0,0,-2,1,0,1.069908648088174096812963,0.00015},
	{0,0,4,-8,5,-5,0,0,0,-1,0,4.211485942780549329711448,0.00002},
	{0,0,4,-8,5,-5,0,0,0,0,0,4.211493622229258271261187,0.00001},
	{0,0,4,-8,5,-5,0,0,0,1,0,4.211501301677967212810927,0.00002},
	{0,0,4,-8,5,-5,0,0,2,-1,0,1.069893289190756435758090,0.00015},
	{0,0,4,-8,5,-5,0,0,2,0,0,1.069893289190756435758090,0.00007},
	{0,0,4,-7,-2,0,0,0,0,0,0,0.588106842883710179137324,0.00001},
	{0,0,4,-7,-1,0,0,0,0,0,0,3.842946755785482171319245,0.00001},
	{0,0,4,-7,0,0,0,0,-4,0,0,4.759709219729385765162988,0.00003},
	{0,0,4,-7,0,0,0,0,-4,1,0,4.756409674778490526136920,0.00002},
	{0,0,4,-7,0,0,0,0,-4,2,0,4.757349709113614544264692,0.00003},
	{0,0,4,-7,0,0,0,0,-3,2,-1,0.724350734952891484041970,0.00001},
	{0,0,4,-7,0,0,0,0,-3,3,-1,0.723862217295258236759992,0.00001},
	{0,0,4,-7,0,0,0,0,-2,-2,0,4.760851886790667286675216,0.00002},
	{0,0,4,-7,0,0,0,0,-2,-1,0,4.754638514653566794265771,0.00015},
	{0,0,4,-7,0,0,0,0,-2,0,0,4.765113457225261583971587,0.00170},
	{0,0,4,-7,0,0,0,0,-2,0,2,4.761764170390684114408941,0.00004},
	{0,0,4,-7,0,0,0,0,-2,1,0,4.761506385260164009309847,0.00261},
	{0,0,4,-7,0,0,0,0,-2,2,0,4.762667901877366105622968,0.00010},
	{0,0,4,-7,0,0,0,0,-1,0,0,1.611110989055012820969637,0.00003},
	{0,0,4,-7,0,0,0,0,-1,0,1,6.170028106857010641306260,0.00001},
	{0,0,4,-7,0,0,0,0,-1,2,0,1.616643857316760080067297,0.00001},
	{0,0,4,-7,0,0,0,0,0,-2,0,4.722224957917228849169078,0.00014},
	{0,0,4,-7,0,0,0,0,0,-1,0,4.722881725314754142175389,0.00219},
	{0,0,4,-7,0,0,0,0,0,0,0,4.737633946284312003172090,0.01099},
	{0,0,4,-7,0,0,0,0,0,1,0,4.719517777714460571303334,0.00201},
	{0,0,4,-7,0,0,0,0,0,2,0,4.717989392888489064148416,0.00013},
	{0,0,4,-7,0,0,0,0,0,3,0,1.614991205048046607473111,0.00001},
	{0,0,4,-7,0,0,0,0,1,-2,0,4.750257040099360672513740,0.00001},
	{0,0,4,-7,0,0,0,0,1,0,-1,6.168240540637118130007366,0.00007},
	{0,0,4,-7,0,0,0,0,1,0,0,1.608664386509567112426566,0.00001},
	{0,0,4,-7,0,0,0,0,2,-2,0,4.748103827401174648059623,0.00007},
	{0,0,4,-7,0,0,0,0,2,-1,0,4.760770554447524283148141,0.00189},
	{0,0,4,-7,0,0,0,0,2,0,-2,4.750257040099360672513740,0.00003},
	{0,0,4,-7,0,0,0,0,2,0,0,4.750595633974247000708147,0.00109},
	{0,0,4,-7,0,0,0,0,2,1,0,4.747118589038424651960213,0.00013},
	{0,0,4,-7,0,0,0,0,4,-2,0,4.753229684881356220671478,0.00002},
	{0,0,4,-7,0,0,0,0,4,0,0,4.753975289537809345574715,0.00002},
	{0,0,4,-7,1,0,0,0,0,0,0,5.554078026416235047690861,0.00001},
	{0,0,4,-7,2,0,0,0,0,0,0,5.781465630018438162096572,0.00002},
	{0,0,4,-6,0,0,0,0,-4,0,0,5.245398047710966515921882,0.00004},
	{0,0,4,-6,0,0,0,0,-4,1,0,5.245239048216109978284294,0.00008},
	{0,0,4,-6,0,0,0,0,-4,2,0,5.243190729805968786081394,0.00005},
	{0,0,4,-6,0,0,0,0,-2,-2,0,5.245016169670630112875642,0.00003},
	{0,0,4,-6,0,0,0,0,-2,-1,0,5.246458335231553249400349,0.00028},
	{0,0,4,-6,0,0,0,0,-2,0,0,5.242783020892703760296172,0.00332},
	{0,0,4,-6,0,0,0,0,-2,0,2,5.243985378214402359731139,0.00004},
	{0,0,4,-6,0,0,0,0,-2,1,0,5.246743172965478763103420,0.00439},
	{0,0,4,-6,0,0,0,0,-2,2,0,5.243468935288736254562991,0.00020},
	{0,0,4,-6,0,0,0,0,-1,-1,1,3.560505533455920801344519,0.00004},
	{0,0,4,-6,0,0,0,0,-1,0,0,2.122077420593226904088624,0.00021},
	{0,0,4,-6,0,0,0,0,-1,0,1,0.410505279793420663203563,0.00004},
	{0,0,4,-6,0,0,0,0,0,-2,0,5.251707238424001111809503,0.00021},
	{0,0,4,-6,0,0,0,0,0,-1,0,5.239443158836086134044763,0.00296},
	{0,0,4,-6,0,0,0,0,0,0,0,5.257233648967516437267022,0.01410},
	{0,0,4,-6,0,0,0,0,0,1,0,5.260310315372930922706018,0.00237},
	{0,0,4,-6,0,0,0,0,0,2,0,5.258339315048653261897016,0.00015},
	{0,0,4,-6,0,0,0,0,1,-2,0,5.231299452546281258946692,0.00002},
	{0,0,4,-6,0,0,0,0,1,-2,1,3.560675877590915305859198,0.00003},
	{0,0,4,-6,0,0,0,0,1,-1,-1,0.418717053924054005697997,0.00005},
	{0,0,4,-6,0,0,0,0,1,-1,0,5.258406510224855168189606,0.00023},
	{0,0,4,-6,0,0,0,0,1,-1,1,0.418912879866127796368858,0.00022},
	{0,0,4,-6,0,0,0,0,1,0,-1,0.419247983082510655705732,0.00042},
	{0,0,4,-6,0,0,0,0,1,0,0,5.274748900675904295098917,0.00061},
	{0,0,4,-6,0,0,0,0,1,0,1,3.560730157330652900782297,0.00008},
	{0,0,4,-6,0,0,0,0,1,1,-1,0.418717053924054005697997,0.00005},
	{0,0,4,-6,0,0,0,0,1,1,0,5.275101457184806719169501,0.00004},
	{0,0,4,-6,0,0,0,0,2,-2,0,4.929866255428218657641537,0.00006},
	{0,0,4,-6,0,0,0,0,2,-1,0,5.167843993332748020463896,0.00209},
	{0,0,4,-6,0,0,0,0,2,0,-2,5.272807570948911504160606,0.00004},
	{0,0,4,-6,0,0,0,0,2,0,0,5.254511807999030281735031,0.00099},
	{0,0,4,-6,0,0,0,0,2,1,0,5.267144850190815574819680,0.00013},
	{0,0,4,-6,0,0,0,0,4,-3,0,1.305827595607050639614499,0.00001},
	{0,0,4,-6,0,0,0,0,4,-2,0,4.961312376160176285111447,0.00004},
	{0,0,4,-6,0,0,0,0,4,-1,0,4.822669354501203820007049,0.00005},
	{0,0,4,-6,0,0,0,0,4,0,0,5.274990977843155626203497,0.00002},
	{0,0,4,-6,1,0,0,0,0,0,0,2.630573862174018895387917,0.00002},
	{0,0,4,-6,1,0,0,0,2,0,0,2.680325868765518926295499,0.00001},
	{0,0,4,-6,2,0,0,0,-2,0,0,4.913728068499653822698292,0.00004},
	{0,0,4,-6,2,0,0,0,-2,1,0,5.055233081066046629814537,0.00004},
	{0,0,4,-6,2,0,0,0,0,-1,0,5.736445385562019438907555,0.00001},
	{0,0,4,-6,2,0,0,0,0,0,0,5.768085935972649735958839,0.00010},
	{0,0,4,-6,2,0,0,0,0,1,0,5.736445385562019438907555,0.00001},
	{0,0,4,-6,2,0,0,0,2,0,0,0.010112786751905545115648,0.00002},
	{0,0,4,-5,0,0,0,0,-4,0,0,2.627467525171319540078230,0.00003},
	{0,0,4,-5,0,0,0,0,-4,1,0,2.720587996615150050416787,0.00007},
	{0,0,4,-5,0,0,0,0,-4,2,0,2.725479456376789233473801,0.00004},
	{0,0,4,-5,0,0,0,0,-2,-2,0,2.733752317031242995426510,0.00002},
	{0,0,4,-5,0,0,0,0,-2,-1,0,2.716310020085586973692671,0.00021},
	{0,0,4,-5,0,0,0,0,-2,0,0,2.731353711040226617257076,0.00253},
	{0,0,4,-5,0,0,0,0,-2,0,2,2.733199396724210750164730,0.00003},
	{0,0,4,-5,0,0,0,0,-2,1,0,2.726185965657996757016690,0.00282},
	{0,0,4,-5,0,0,0,0,-2,2,0,2.739291643011222188164311,0.00012},
	{0,0,4,-5,0,0,0,0,-1,0,0,5.867122899047815920425819,0.00004},
	{0,0,4,-5,0,0,0,0,0,-2,0,2.672166279979520275844607,0.00019},
	{0,0,4,-5,0,0,0,0,0,-1,0,2.673251351175485179822999,0.00292},
	{0,0,4,-5,0,0,0,0,0,0,0,2.666181022375656350931195,0.00948},
	{0,0,4,-5,0,0,0,0,0,1,0,2.663058453810913217552070,0.00152},
	{0,0,4,-5,0,0,0,0,0,2,0,2.664151902587287512602643,0.00010},
	{0,0,4,-5,0,0,0,0,1,-2,0,5.880787605360454861624930,0.00002},
	{0,0,4,-5,0,0,0,0,1,-1,-1,4.120327570481810752767160,0.00003},
	{0,0,4,-5,0,0,0,0,1,-1,1,0.985260179366448940463385,0.00002},
	{0,0,4,-5,0,0,0,0,1,0,-1,4.120510131921569119128890,0.00026},
	{0,0,4,-5,0,0,0,0,1,0,0,5.880787605360454861624930,0.00002},
	{0,0,4,-5,0,0,0,0,1,0,1,0.978209398254242246117940,0.00003},
	{0,0,4,-5,0,0,0,0,1,1,-1,4.120327570481810752767160,0.00003},
	{0,0,4,-5,0,0,0,0,2,-2,0,5.791332848944588107542586,0.00040},
	{0,0,4,-5,0,0,0,0,2,-1,0,5.782886677095411265270286,0.00382},
	{0,0,4,-5,0,0,0,0,2,0,-2,5.802819907949513300593480,0.00002},
	{0,0,4,-5,0,0,0,0,2,0,0,5.816380941704584195406369,0.00041},
	{0,0,4,-5,0,0,0,0,2,1,0,5.759806094001188370157251,0.00003},
	{0,0,4,-5,0,0,0,0,4,-2,0,5.780610767750811618270745,0.00005},
	{0,0,4,-5,0,0,0,0,4,-1,0,5.784341234494023709089561,0.00005},
	{0,0,4,-5,2,0,0,0,2,0,0,0.511047938414282421071277,0.00001},
	{0,0,4,-4,-2,0,0,0,2,-2,0,5.319960084152491219811054,0.00001},
	{0,0,4,-4,0,-3,0,0,2,-1,0,0.758371565397390923202181,0.00002},
	{0,0,4,-4,0,0,0,0,-4,0,0,3.719434866076674506274458,0.00004},
	{0,0,4,-4,0,0,0,0,-4,1,0,3.691618681123014500400359,0.00004},
	{0,0,4,-4,0,0,0,0,-4,2,0,3.581590158017563751968737,0.00003},
	{0,0,4,-4,0,0,0,0,-2,-2,0,3.582305044879180222494597,0.00001},
	{0,0,4,-4,0,0,0,0,-2,-1,0,3.779939846189711349921936,0.00012},
	{0,0,4,-4,0,0,0,0,-2,0,0,3.608041844562014155428642,0.00175},
	{0,0,4,-4,0,0,0,0,-2,0,2,3.600119795087211915785019,0.00002},
	{0,0,4,-4,0,0,0,0,-2,1,0,3.589645027048443015615931,0.00173},
	{0,0,4,-4,0,0,0,0,-2,2,0,3.617697180516972199626480,0.00007},
	{0,0,4,-4,0,0,0,0,-1,-1,0,3.984877454156436904497696,0.00001},
	{0,0,4,-4,0,0,0,0,-1,0,0,0.842945334027130566134645,0.00009},
	{0,0,4,-4,0,0,0,0,0,-3,0,0.041517543180590713025602,0.00002},
	{0,0,4,-4,0,0,0,0,0,-2,0,6.235661038845331738400546,0.00022},
	{0,0,4,-4,0,0,0,0,0,-1,0,6.224843488141471148367145,0.00303},
	{0,0,4,-4,0,0,0,0,0,0,0,3.336842462477473958415430,0.00404},
	{0,0,4,-4,0,0,0,0,0,1,0,3.313769384299034115315408,0.00068},
	{0,0,4,-4,0,0,0,0,0,2,0,3.281465783305571370931375,0.00005},
	{0,0,4,-4,0,0,0,0,1,0,-1,4.868069382602855377228934,0.00007},
	{0,0,4,-4,0,0,0,0,1,0,0,0.842969245037882841664612,0.00005},
	{0,0,4,-4,0,0,0,0,2,-3,0,6.115746098191959134737772,0.00004},
	{0,0,4,-4,0,0,0,0,2,-2,0,0.005876174525614508148408,0.00214},
	{0,0,4,-4,0,0,0,0,2,-1,-2,3.166856469045336019974002,0.00006},
	{0,0,4,-4,0,0,0,0,2,-1,0,3.174976613390239954526351,0.02008},
	{0,0,4,-4,0,0,0,0,2,-1,2,0.034461351547702835651510,0.00004},
	{0,0,4,-4,0,0,0,0,2,0,-2,6.245606623054896111568723,0.00007},
	{0,0,4,-4,0,0,0,0,2,0,0,3.184126152927969854999901,0.00104},
	{0,0,4,-4,0,0,0,0,2,1,-2,3.152811804554537911116086,0.00002},
	{0,0,4,-4,0,0,0,0,2,1,0,3.152713193451800233191307,0.00003},
	{0,0,4,-4,0,0,0,0,4,-3,0,0.042193858265738515278542,0.00004},
	{0,0,4,-4,0,0,0,0,4,-2,0,3.179083722186033078571654,0.00024},
	{0,0,4,-4,0,0,0,0,4,-1,0,3.180433908895375694214636,0.00016},
	{0,0,4,-4,0,0,0,0,4,0,0,3.173373877538133491782446,0.00003},
	{0,0,4,-4,2,0,0,0,2,-1,0,4.222463191110967350994088,0.00002},
	{0,0,4,-3,-2,0,0,0,0,0,0,2.645789642592905721585339,0.00001},
	{0,0,4,-3,0,0,0,0,-4,0,0,4.516707726105916975711807,0.00002},
	{0,0,4,-3,0,0,0,0,-4,1,0,1.340989696849429257952124,0.00001},
	{0,0,4,-3,0,0,0,0,-2,-1,0,1.334608773104137835474603,0.00004},
	{0,0,4,-3,0,0,0,0,-2,0,0,1.343394411492827122955873,0.00037},
	{0,0,4,-3,0,0,0,0,-2,1,0,1.344297095781958439886239,0.00034},
	{0,0,4,-3,0,0,0,0,0,-1,0,1.515051906749599108792381,0.00018},
	{0,0,4,-3,0,0,0,0,0,0,0,1.614958392858109048617621,0.00025},
	{0,0,4,-3,0,0,0,0,0,1,0,1.235999590228635591770967,0.00004},
	{0,0,4,-3,0,0,0,0,1,0,-1,5.410852642806150747389893,0.00006},
	{0,0,4,-3,0,0,0,0,2,-2,0,1.276927386654977292224089,0.00001},
	{0,0,4,-3,0,0,0,0,2,-1,0,0.732460058256432677836756,0.00026},
	{0,0,4,-3,0,0,0,0,2,0,0,3.408454194351427268827592,0.00003},
	{0,0,4,-2,0,0,0,0,-2,-1,0,2.699824338102949194961866,0.00003},
	{0,0,4,-2,0,0,0,0,-2,0,0,2.698772951761547744808922,0.00026},
	{0,0,4,-2,0,0,0,0,-2,1,0,2.711812132070272607364814,0.00022},
	{0,0,4,-2,0,0,0,0,0,-1,0,2.701351501198444360341000,0.00005},
	{0,0,4,-2,0,0,0,0,0,0,0,2.882221018780168009243425,0.00010},
	{0,0,4,-2,0,0,0,0,0,1,0,2.783956887497784915552757,0.00001},
	{0,0,4,-2,0,0,0,0,2,-3,0,3.256752968294883032740472,0.00001},
	{0,0,4,-2,0,0,0,0,2,-1,0,3.256752968294883032740472,0.00001},
	{0,0,4,0,-7,0,0,0,0,0,0,3.659767644004594533413410,0.00001},
	{0,0,4,0,-7,0,0,0,2,-1,0,3.688205689770740036692587,0.00004},
	{0,0,4,0,-7,0,0,0,2,0,0,0.537218103350386222416546,0.00002},
	{0,0,4,0,-7,5,0,0,2,-2,0,0.306767970509708498560997,0.00001},
	{0,0,4,0,-7,5,0,0,2,0,0,3.448360624099501947625868,0.00001},
	{0,0,4,0,-6,0,0,0,-2,0,0,3.409659169667003997261645,0.00006},
	{0,0,4,0,-6,0,0,0,-2,1,0,3.410701654829220164089065,0.00003},
	{0,0,4,0,-6,0,0,0,0,-1,0,0.399710418369835784879740,0.00002},
	{0,0,4,0,-6,0,0,0,0,0,0,3.464425856265334058292638,0.00005},
	{0,0,4,0,-6,0,0,0,0,1,0,3.463749366647260963247845,0.00002},
	{0,0,4,0,-6,0,0,0,2,-2,0,3.501564717418521155423150,0.00001},
	{0,0,4,0,-6,0,0,0,2,-1,0,3.501598053207234162442774,0.00021},
	{0,0,4,0,-6,0,0,0,2,0,0,0.358008219354384094046395,0.00009},
	{0,0,4,0,-6,0,0,0,2,1,0,0.359457715298165392248109,0.00002},
	{0,0,4,0,-6,2,0,0,2,-2,0,3.156717676887576207178654,0.00001},
	{0,0,4,0,-6,2,0,0,2,0,0,0.015125023297782860462468,0.00001},
	{0,0,4,0,-6,5,0,0,-2,0,0,5.954041168461759347962925,0.00002},
	{0,0,4,0,-6,5,0,0,0,0,0,6.024046848358027617109656,0.00001},
	{0,0,4,0,-6,5,0,0,2,-2,0,6.080493937960177674995066,0.00002},
	{0,0,4,0,-6,5,0,0,2,-1,0,6.077048832549666101954244,0.00004},
	{0,0,4,0,-6,5,0,0,2,0,0,2.941440912964961462705560,0.00001},
	{0,0,4,0,-5,0,0,0,-2,-1,0,3.201689401190788597517667,0.00003},
	{0,0,4,0,-5,0,0,0,-2,0,0,3.200485822138613212217706,0.00024},
	{0,0,4,0,-5,0,0,0,-2,1,0,3.192775481102077872463951,0.00019},
	{0,0,4,0,-5,0,0,0,0,-1,0,0.269876771577379159783305,0.00006},
	{0,0,4,0,-5,0,0,0,0,0,0,3.257470996749153524518761,0.00019},
	{0,0,4,0,-5,0,0,0,0,1,0,3.327189220917618595052545,0.00010},
	{0,0,4,0,-5,0,0,0,0,2,0,3.315571611284642727923710,0.00001},
	{0,0,4,0,-5,0,0,0,1,0,-1,4.879042093077218922303473,0.00001},
	{0,0,4,0,-5,0,0,0,2,-2,0,3.321515504585235145640354,0.00003},
	{0,0,4,0,-5,0,0,0,2,-1,0,3.321026288795900782702120,0.00103},
	{0,0,4,0,-5,0,0,0,2,0,-2,3.321951313299457808625448,0.00003},
	{0,0,4,0,-5,0,0,0,2,0,0,0.180165975360244645653296,0.00038},
	{0,0,4,0,-5,0,0,0,2,1,0,0.179816909509845773706971,0.00007},
	{0,0,4,0,-5,0,0,0,4,-2,0,3.319526701902587806358724,0.00002},
	{0,0,4,0,-5,0,0,0,4,-1,0,0.179810626324538619380533,0.00001},
	{0,0,4,0,-4,0,0,0,-4,1,0,2.907673678860776877996841,0.00003},
	{0,0,4,0,-4,0,0,0,-2,-1,0,2.911665421393013097883795,0.00008},
	{0,0,4,0,-4,0,0,0,-2,0,0,2.879094086892294512836088,0.00076},
	{0,0,4,0,-4,0,0,0,-2,1,0,2.897899835049608352477435,0.00054},
	{0,0,4,0,-4,0,0,0,-2,2,0,2.879456417245009003380574,0.00002},
	{0,0,4,0,-4,0,0,0,0,-2,0,0.114840919451974901588365,0.00001},
	{0,0,4,0,-4,0,0,0,0,-1,0,6.211566593988624873645676,0.00020},
	{0,0,4,0,-4,0,0,0,0,0,0,2.971147987630231579458950,0.00044},
	{0,0,4,0,-4,0,0,0,0,1,0,3.067349837868458273248962,0.00034},
	{0,0,4,0,-4,0,0,0,0,2,0,3.122103259964473576104638,0.00002},
	{0,0,4,0,-4,0,0,0,2,-2,0,3.143752673072061298853441,0.00010},
	{0,0,4,0,-4,0,0,0,2,-1,0,3.139314998915940346790876,0.00308},
	{0,0,4,0,-4,0,0,0,2,0,-2,3.138018044748783541564308,0.00010},
	{0,0,4,0,-4,0,0,0,2,0,0,0.011555824977454456914394,0.00125},
	{0,0,4,0,-4,0,0,0,2,1,0,6.276829865241373873629982,0.00013},
	{0,0,4,0,-4,0,0,0,2,2,0,0.012184492574022813549117,0.00001},
	{0,0,4,0,-4,0,0,0,4,-2,0,3.127748701962973942869439,0.00005},
	{0,0,4,0,-4,0,0,0,4,0,0,6.272410691575323937740905,0.00003},
	{0,0,4,0,-4,0,0,0,4,1,0,3.138018044748783541564308,0.00001},
	{0,0,4,0,-3,-5,0,0,2,-2,0,3.459286210684060947073704,0.00001},
	{0,0,4,0,-3,-5,0,0,2,0,0,0.317693557094267831075740,0.00001},
	{0,0,4,0,-3,0,0,0,-4,0,0,4.238197857916472521822016,0.00002},
	{0,0,4,0,-3,0,0,0,-4,1,0,1.108925832582357440259102,0.00003},
	{0,0,4,0,-3,0,0,0,-2,-1,0,1.120137129565468292469177,0.00007},
	{0,0,4,0,-3,0,0,0,-2,0,0,1.116495325548257033787536,0.00069},
	{0,0,4,0,-3,0,0,0,-2,1,0,1.117152965610408443808410,0.00050},
	{0,0,4,0,-3,0,0,0,-2,2,0,1.118712068231215051028471,0.00003},
	{0,0,4,0,-3,0,0,0,0,-3,0,3.841725897973712111621580,0.00001},
	{0,0,4,0,-3,0,0,0,0,-2,0,4.625908439547146144832368,0.00002},
	{0,0,4,0,-3,0,0,0,0,-1,0,5.926532510522300789546080,0.00015},
	{0,0,4,0,-3,0,0,0,0,0,0,1.120067490928313702625019,0.00025},
	{0,0,4,0,-3,0,0,0,0,1,0,1.101732807136113434509639,0.00006},
	{0,0,4,0,-3,0,0,0,1,0,-1,4.522307964076790476326551,0.00001},
	{0,0,4,0,-3,0,0,0,2,-2,0,0.089140422617582801279035,0.00001},
	{0,0,4,0,-3,0,0,0,2,-1,0,0.038330921032299465622817,0.00025},
	{0,0,4,0,-3,0,0,0,2,0,0,3.060794730263818319571101,0.00009},
	{0,0,4,0,-3,0,0,0,2,1,0,3.570794423929352756630351,0.00002},
	{0,0,4,0,-2,-5,0,0,2,-3,0,0.149864267018819885546321,0.00001},
	{0,0,4,0,-2,-5,0,0,2,-2,0,3.291445401435549644730827,0.00001},
	{0,0,4,0,-2,-5,0,0,2,-1,0,3.289913176885224110890249,0.00004},
	{0,0,4,0,-2,-5,0,0,2,0,0,0.148603266634254022049433,0.00001},
	{0,0,4,0,-2,0,0,0,-4,1,0,5.792950769161186563849242,0.00003},
	{0,0,4,0,-2,0,0,0,-4,3,0,2.686348825481226221256748,0.00002},
	{0,0,4,0,-2,0,0,0,-2,-1,0,5.778322815634371778514833,0.00006},
	{0,0,4,0,-2,0,0,0,-2,0,0,5.785612357788251891577147,0.00056},
	{0,0,4,0,-2,0,0,0,-2,1,0,5.778137112601958946811465,0.00038},
	{0,0,4,0,-2,0,0,0,-2,2,0,5.787694710118805652143692,0.00002},
	{0,0,4,0,-2,0,0,0,0,-2,0,2.690223107354803300239610,0.00004},
	{0,0,4,0,-2,0,0,0,0,-1,0,2.681691588905204426396267,0.00029},
	{0,0,4,0,-2,0,0,0,0,0,0,5.747960544367903601425951,0.00010},
	{0,0,4,0,-2,0,0,0,2,-3,0,2.681539221661505489890942,0.00001},
	{0,0,4,0,-2,0,0,0,2,-2,0,2.693045479288203480905395,0.00001},
	{0,0,4,0,-2,0,0,0,2,-1,0,2.732150453843762427652564,0.00004},
	{0,0,4,0,-2,5,0,0,2,-3,0,2.084324901675038255177697,0.00002},
	{0,0,4,0,-2,5,0,0,2,-2,0,2.081840600017749842720605,0.00002},
	{0,0,4,0,-2,5,0,0,2,-1,0,2.084324901675038255177697,0.00002},
	{0,0,4,0,-1,0,0,0,-2,0,0,1.153991281066402363464363,0.00006},
	{0,0,4,0,-1,0,0,0,-2,1,0,1.129772568766953533270225,0.00003},
	{0,0,4,0,-1,0,0,0,0,0,0,1.287794504709594889391155,0.00001},
	{0,0,4,0,-1,0,0,0,2,-1,0,5.548617763851369844019246,0.00003},
	{0,0,4,0,-1,0,0,0,2,0,0,2.933017953994836890529996,0.00007},
	{0,0,4,0,0,-5,0,0,2,0,0,1.617456308083563332189669,0.00001},
	{0,0,4,0,0,-4,0,0,-2,0,0,3.074769581584536837226551,0.00003},
	{0,0,4,0,0,-4,0,0,0,0,0,3.097890481784481231386508,0.00001},
	{0,0,4,0,0,-4,0,0,2,-1,0,3.139624096726469026918949,0.00005},
	{0,0,4,0,0,-4,0,0,2,0,0,6.281216924849187144275220,0.00003},
	{0,0,4,0,0,-3,0,0,-2,0,0,1.308022347141433394668297,0.00002},
	{0,0,4,0,0,-2,0,0,-2,0,0,5.826506294827105136846512,0.00003},
	{0,0,4,0,0,-2,0,0,0,0,0,5.836847719711021120758687,0.00001},
	{0,0,4,0,0,0,0,0,0,0,0,3.505050139934753783421684,0.00003},
	{0,0,4,0,0,0,0,0,2,-3,0,5.350164926720430536022377,0.00003},
	{0,0,4,0,0,0,0,0,2,-2,0,2.235151019644632253147165,0.00004},
	{0,0,4,0,0,0,0,0,2,0,-2,5.379518048613395997392672,0.00003},
	{0,0,4,0,0,0,0,0,2,0,0,2.236518659646495432724578,0.00008},
	{0,0,4,0,0,0,0,0,2,2,0,2.237789084809021833422094,0.00002},
	{0,0,4,0,0,0,0,0,4,-2,0,5.377696099407238250478258,0.00001},
	{0,0,4,0,1,0,0,0,2,-1,0,2.088995577286300697750221,0.00004},
	{0,0,4,0,1,0,0,0,2,0,0,5.189631287451243579766924,0.00006},
	{0,0,4,0,2,-5,0,0,2,-3,0,5.562247912644820324601369,0.00002},
	{0,0,4,0,2,-5,0,0,2,-2,0,5.576581952725599755638086,0.00002},
	{0,0,4,0,2,-5,0,0,2,-1,0,5.562247912644820324601369,0.00002},
	{0,0,4,1,-2,0,0,0,2,0,0,1.721280360231099759715789,0.00002},
	{0,0,4,1,-1,0,0,0,2,0,0,5.328514815481140587394293,0.00002},
	{0,0,4,2,-2,0,0,0,2,0,0,2.233626300010090215408809,0.00002},
	{0,0,5,-14,4,0,0,0,-2,0,2,4.516887669551797657163661,0.00002},
	{0,0,5,-12,0,0,0,0,-2,1,0,5.661744595444961447583410,0.00002},
	{0,0,5,-11,0,0,0,0,0,0,0,4.029727179944934789546096,0.00005},
	{0,0,5,-11,0,0,0,0,2,-1,0,5.336980535017938898079137,0.00005},
	{0,0,5,-11,0,0,0,0,2,0,0,5.356871877969994422130640,0.00005},
	{0,0,5,-11,1,0,0,0,0,0,0,3.786892190732105145656305,0.00001},
	{0,0,5,-10,0,0,0,0,-2,0,0,3.713197059330046290170912,0.00006},
	{0,0,5,-10,0,0,0,0,-2,1,0,3.708718893535279725881537,0.00008},
	{0,0,5,-10,0,0,0,0,0,-1,0,3.702458048442525573307194,0.00017},
	{0,0,5,-10,0,0,0,0,0,0,0,3.740957742813492803435338,0.00093},
	{0,0,5,-10,0,0,0,0,0,1,0,3.724161741289850446889886,0.00019},
	{0,0,5,-10,0,0,0,0,2,-1,0,3.863758410852113023281618,0.00012},
	{0,0,5,-10,0,0,0,0,2,0,0,3.822368102173992809866832,0.00010},
	{0,0,5,-10,0,0,0,0,2,1,0,3.834028472373641527326527,0.00002},
	{0,0,5,-10,2,0,0,0,0,0,0,4.773353854755626457517792,0.00002},
	{0,0,5,-10,3,0,0,0,0,0,0,0.696198748651148058286253,0.00003},
	{0,0,5,-9,-2,0,0,0,0,-1,0,3.118785738122282769069216,0.00002},
	{0,0,5,-9,-2,0,0,0,0,0,0,6.250950297625728069306206,0.00001},
	{0,0,5,-9,-2,0,0,0,0,1,0,3.118785738122282769069216,0.00002},
	{0,0,5,-9,-1,0,0,0,0,-1,0,0.424128970868637988900218,0.00001},
	{0,0,5,-9,-1,0,0,0,0,1,0,0.424128970868637988900218,0.00001},
	{0,0,5,-9,0,0,0,0,-4,0,0,4.255565105704292250266008,0.00002},
	{0,0,5,-9,0,0,0,0,-4,2,0,4.253424284843796421284878,0.00002},
	{0,0,5,-9,0,0,0,0,-2,-1,0,4.248350089109472982329407,0.00010},
	{0,0,5,-9,0,0,0,0,-2,0,0,4.254229579760666624110854,0.00095},
	{0,0,5,-9,0,0,0,0,-2,0,2,4.255836329870052558987936,0.00002},
	{0,0,5,-9,0,0,0,0,-2,1,0,4.259402037531876850096069,0.00146},
	{0,0,5,-9,0,0,0,0,-2,2,0,4.256340031892177577788061,0.00006},
	{0,0,5,-9,0,0,0,0,-1,0,0,1.104558844260942640502776,0.00001},
	{0,0,5,-9,0,0,0,0,-1,2,0,1.104558844260942640502776,0.00001},
	{0,0,5,-9,0,0,0,0,0,-2,0,4.196421307874885542332777,0.00007},
	{0,0,5,-9,0,0,0,0,0,-1,0,4.209430643053400977748879,0.00130},
	{0,0,5,-9,0,0,0,0,0,0,0,4.228875007184019985118084,0.00676},
	{0,0,5,-9,0,0,0,0,0,1,0,4.205460542603889351198632,0.00125},
	{0,0,5,-9,0,0,0,0,0,2,0,4.202271302461720203780260,0.00008},
	{0,0,5,-9,0,0,0,0,1,0,-1,5.667899324519194870219962,0.00002},
	{0,0,5,-9,0,0,0,0,2,-2,0,4.241367724903944314007731,0.00005},
	{0,0,5,-9,0,0,0,0,2,-1,0,4.250327372619057797464848,0.00115},
	{0,0,5,-9,0,0,0,0,2,0,-2,4.243922712395939100815667,0.00002},
	{0,0,5,-9,0,0,0,0,2,0,0,4.243539787158051801441161,0.00068},
	{0,0,5,-9,0,0,0,0,2,1,0,4.239408243752730953701757,0.00008},
	{0,0,5,-9,0,0,0,0,4,-2,0,4.244126566852571613708278,0.00001},
	{0,0,5,-9,0,0,0,0,4,-1,0,4.244876011233378321207965,0.00002},
	{0,0,5,-9,1,0,0,0,0,0,0,4.799083847654377343872056,0.00001},
	{0,0,5,-9,2,0,0,0,0,0,0,5.272881223843345566137941,0.00001},
	{0,0,5,-8,0,0,0,0,-4,0,0,4.746921541365873409290543,0.00002},
	{0,0,5,-8,0,0,0,0,-4,1,0,4.747140580186999692102745,0.00001},
	{0,0,5,-8,0,0,0,0,-4,2,0,4.748807718688504486692636,0.00002},
	{0,0,5,-8,0,0,0,0,-2,-1,0,4.746912465653763568695922,0.00010},
	{0,0,5,-8,0,0,0,0,-2,0,0,4.747012822085753036560618,0.00110},
	{0,0,5,-8,0,0,0,0,-2,0,2,4.746857662315250969697900,0.00002},
	{0,0,5,-8,0,0,0,0,-2,1,0,4.747320174567029482659564,0.00151},
	{0,0,5,-8,0,0,0,0,-2,2,0,4.746850506465317032223084,0.00005},
	{0,0,5,-8,0,0,0,0,-1,-1,1,3.042045356241343867509386,0.00007},
	{0,0,5,-8,0,0,0,0,-1,0,0,1.619991398822085093556211,0.00002},
	{0,0,5,-8,0,0,0,0,-1,0,1,6.183989170076638508533051,0.00001},
	{0,0,5,-8,0,0,0,0,0,-2,0,4.745250214074164141209167,0.00006},
	{0,0,5,-8,0,0,0,0,0,-1,0,4.773907298661434595032915,0.00092},
	{0,0,5,-8,0,0,0,0,0,0,0,4.748255845579024025937542,0.00474},
	{0,0,5,-8,0,0,0,0,0,1,0,4.745303621149275841162307,0.00080},
	{0,0,5,-8,0,0,0,0,0,2,0,4.744756984027550750226965,0.00005},
	{0,0,5,-8,0,0,0,0,1,-3,1,3.045114692263900746382888,0.00001},
	{0,0,5,-8,0,0,0,0,1,-2,1,3.042136287895372603884425,0.00022},
	{0,0,5,-8,0,0,0,0,1,-1,0,4.767392682695440697671074,0.00003},
	{0,0,5,-8,0,0,0,0,1,-1,1,6.183634693705558404985823,0.00034},
	{0,0,5,-8,0,0,0,0,1,0,-1,6.183864728100971319690871,0.00017},
	{0,0,5,-8,0,0,0,0,1,0,0,4.761583877878953430240472,0.00012},
	{0,0,5,-8,0,0,0,0,2,-2,0,0.039284394402663971868073,0.00002},
	{0,0,5,-8,0,0,0,0,2,-1,0,5.015666641456260066433970,0.00066},
	{0,0,5,-8,0,0,0,0,2,0,0,4.822382073306325622752411,0.00035},
	{0,0,5,-8,0,0,0,0,2,1,0,4.765642466521540221435771,0.00004},
	{0,0,5,-8,0,0,0,0,4,-3,0,0.780326411124077967684798,0.00001},
	{0,0,5,-8,0,0,0,0,4,-2,0,0.784905980548385895367858,0.00004},
	{0,0,5,-8,0,0,0,0,4,-1,0,0.306811603741008409595992,0.00002},
	{0,0,5,-8,1,0,0,0,0,0,0,5.386615430016631123066873,0.00001},
	{0,0,5,-8,1,5,0,0,-2,0,0,3.048525763753998862881645,0.00007},
	{0,0,5,-8,1,5,0,0,-2,1,0,3.050577049223867742711036,0.00007},
	{0,0,5,-8,1,5,0,0,0,-1,0,3.017485781138980360793767,0.00001},
	{0,0,5,-8,1,5,0,0,0,0,0,3.006136952210812118835292,0.00010},
	{0,0,5,-8,1,5,0,0,0,1,0,3.017485781138980360793767,0.00001},
	{0,0,5,-8,2,0,0,0,0,0,0,5.717023536178752252112645,0.00002},
	{0,0,5,-8,3,0,0,0,-6,1,0,3.220677187189085355356610,0.00001},
	{0,0,5,-8,3,0,0,0,-4,-2,0,3.218891017232594187191808,0.00002},
	{0,0,5,-8,3,0,0,0,-4,-1,0,3.214055931605794391714426,0.00003},
	{0,0,5,-8,3,0,0,0,-4,0,0,3.217706287736340264871160,0.00017},
	{0,0,5,-8,3,0,0,0,-4,1,0,3.221778839012944484210266,0.00040},
	{0,0,5,-8,3,0,0,0,-4,2,0,3.227989942222016406248031,0.00017},
	{0,0,5,-8,3,0,0,0,-3,0,0,3.223381923930901393759996,0.00002},
	{0,0,5,-8,3,0,0,0,-3,1,0,0.081789270341107875306186,0.00001},
	{0,0,5,-8,3,0,0,0,-3,3,0,0.081789270341107875306186,0.00001},
	{0,0,5,-8,3,0,0,0,-2,-2,0,3.216400432389998620408278,0.00011},
	{0,0,5,-8,3,0,0,0,-2,-1,0,3.220056373574151198369009,0.00088},
	{0,0,5,-8,3,0,0,0,-2,-1,2,0.086735358908334600491763,0.00001},
	{0,0,5,-8,3,0,0,0,-2,0,-2,0.088987706308033293067794,0.00002},
	{0,0,5,-8,3,0,0,0,-2,0,0,3.225674762969246156529834,0.00897},
	{0,0,5,-8,3,0,0,0,-2,0,2,3.224902803841088960723482,0.00014},
	{0,0,5,-8,3,0,0,0,-2,1,0,3.233441827206471330669046,0.00962},
	{0,0,5,-8,3,0,0,0,-2,1,2,0.086735358908334600491763,0.00001},
	{0,0,5,-8,3,0,0,0,-2,2,0,3.242958758551746090148526,0.00037},
	{0,0,5,-8,3,0,0,0,-2,3,0,3.246300889536389622236356,0.00003},
	{0,0,5,-8,3,0,0,0,-1,0,0,0.160113363985306178527424,0.00004},
	{0,0,5,-8,3,0,0,0,-1,1,0,0.079738857535864932080116,0.00001},
	{0,0,5,-8,3,0,0,0,0,-3,0,3.209837121737873832927335,0.00001},
	{0,0,5,-8,3,0,0,0,0,-2,0,3.227010463445797228132506,0.00031},
	{0,0,5,-8,3,0,0,0,0,-1,0,3.239956792238315674836713,0.00353},
	{0,0,5,-8,3,0,0,0,0,0,0,3.268717549383154175046684,0.01091},
	{0,0,5,-8,3,0,0,0,0,1,0,3.347705566274811861404714,0.00097},
	{0,0,5,-8,3,0,0,0,0,2,0,4.676873100902931845723742,0.00001},
	{0,0,5,-8,3,0,0,0,1,0,0,2.764205170885889906173816,0.00004},
	{0,0,5,-8,3,0,0,0,2,-2,0,3.156606848480074667406825,0.00003},
	{0,0,5,-8,3,0,0,0,2,-1,0,0.009413258787706216962343,0.00040},
	{0,0,5,-8,3,0,0,0,2,0,-2,0.030288269306184396889581,0.00004},
	{0,0,5,-8,3,0,0,0,2,0,0,0.017899922275528643705877,0.00052},
	{0,0,5,-8,3,0,0,0,2,1,0,0.029192900667632755429270,0.00004},
	{0,0,5,-8,3,0,0,0,2,2,0,0.065042836168222276094220,0.00002},
	{0,0,5,-8,3,0,0,0,4,-2,0,0.065553519507355814677219,0.00002},
	{0,0,5,-8,3,0,0,0,4,-1,0,0.057865693218171199152522,0.00004},
	{0,0,5,-8,3,0,0,0,4,0,0,0.106859005183829222640490,0.00001},
	{0,0,5,-8,5,-5,0,0,-2,0,0,5.579342540003478845278551,0.00002},
	{0,0,5,-7,0,0,0,0,-4,0,0,2.207540259943932881014916,0.00002},
	{0,0,5,-7,0,0,0,0,-4,1,0,2.205724942988933623411185,0.00002},
	{0,0,5,-7,0,0,0,0,-4,2,0,2.212117211374362568676588,0.00002},
	{0,0,5,-7,0,0,0,0,-2,-2,0,2.209734487879539965859976,0.00002},
	{0,0,5,-7,0,0,0,0,-2,-1,0,2.205366975959349495894912,0.00011},
	{0,0,5,-7,0,0,0,0,-2,0,0,2.222995674069117910676141,0.00141},
	{0,0,5,-7,0,0,0,0,-2,0,2,2.211193408601281884529044,0.00002},
	{0,0,5,-7,0,0,0,0,-2,1,0,2.202848640381646738717336,0.00158},
	{0,0,5,-7,0,0,0,0,-2,2,0,2.220253412748384391761647,0.00007},
	{0,0,5,-7,0,0,0,0,-1,0,1,3.595709697133272708668983,0.00001},
	{0,0,5,-7,0,0,0,0,0,-2,0,2.173880712654596258914808,0.00011},
	{0,0,5,-7,0,0,0,0,0,-1,0,2.166403024007351518775977,0.00159},
	{0,0,5,-7,0,0,0,0,0,0,0,2.154966405017808117605682,0.00534},
	{0,0,5,-7,0,0,0,0,0,1,0,2.149274188195354096109213,0.00086},
	{0,0,5,-7,0,0,0,0,0,2,0,2.151441887126330776425220,0.00006},
	{0,0,5,-7,0,0,0,0,1,-1,-1,3.568205926115719961444483,0.00003},
	{0,0,5,-7,0,0,0,0,1,-1,1,0.433268911095481934481199,0.00002},
	{0,0,5,-7,0,0,0,0,1,0,-1,3.568499315962979867578042,0.00026},
	{0,0,5,-7,0,0,0,0,1,0,1,0.426378002142757894787906,0.00003},
	{0,0,5,-7,0,0,0,0,1,1,-1,3.568205926115719961444483,0.00003},
	{0,0,5,-7,0,0,0,0,2,-3,0,5.211286983744138900931375,0.00001},
	{0,0,5,-7,0,0,0,0,2,-2,0,5.308190456341667307071930,0.00018},
	{0,0,5,-7,0,0,0,0,2,-1,0,5.267693930773492461128171,0.00178},
	{0,0,5,-7,0,0,0,0,2,0,-2,5.278754780375082056309566,0.00002},
	{0,0,5,-7,0,0,0,0,2,0,0,5.287416500386878936978974,0.00019},
	{0,0,5,-7,0,0,0,0,2,1,0,5.284730089602209801569188,0.00002},
	{0,0,5,-7,0,0,0,0,4,-2,0,5.259658434897310996802844,0.00002},
	{0,0,5,-7,2,0,0,0,2,0,0,0.009145001681674688742696,0.00001},
	{0,0,5,-7,3,0,0,0,2,-1,0,2.393104189614745358483106,0.00002},
	{0,0,5,-6,-2,0,0,0,2,-1,0,4.782887541261721331409262,0.00003},
	{0,0,5,-6,-1,0,0,0,2,-3,0,4.692643197892252260317036,0.00001},
	{0,0,5,-6,-1,0,0,0,2,-2,0,5.259564012584778680547970,0.00001},
	{0,0,5,-6,-1,0,0,0,2,-1,0,5.162141304534781482971084,0.00003},
	{0,0,5,-6,0,-1,0,0,2,-2,0,4.700336260169192925673087,0.00006},
	{0,0,5,-6,0,0,0,0,-4,1,0,2.895869668063688617820617,0.00002},
	{0,0,5,-6,0,0,0,0,-2,-2,0,5.761365894753695648944358,0.00001},
	{0,0,5,-6,0,0,0,0,-2,-1,0,4.107287168442610436613904,0.00002},
	{0,0,5,-6,0,0,0,0,-2,0,0,2.954106592813758869198182,0.00073},
	{0,0,5,-6,0,0,0,0,-2,1,0,2.910659413612163071150007,0.00085},
	{0,0,5,-6,0,0,0,0,-2,2,0,2.960170913832738559534619,0.00003},
	{0,0,5,-6,0,0,0,0,0,-3,0,5.791878089802910523076207,0.00006},
	{0,0,5,-6,0,0,0,0,0,-2,0,5.784962746240659647867233,0.00072},
	{0,0,5,-6,0,0,0,0,0,-1,-2,2.648394721034432297557260,0.00002},
	{0,0,5,-6,0,0,0,0,0,-1,0,5.780071984610720470243450,0.00838},
	{0,0,5,-6,0,0,0,0,0,0,0,2.749608633285610892471595,0.00195},
	{0,0,5,-6,0,0,0,0,0,1,0,2.723230250569744104183201,0.00038},
	{0,0,5,-6,0,0,0,0,0,2,0,2.694773529780602583372229,0.00003},
	{0,0,5,-6,0,0,0,0,1,-1,0,2.648395244633208189810603,0.00004},
	{0,0,5,-6,0,0,0,0,1,0,-1,4.141812748106786123969414,0.00010},
	{0,0,5,-6,0,0,0,0,1,0,0,2.600880226543989426346570,0.00002},
	{0,0,5,-6,0,0,0,0,2,-4,0,5.808339511708945579471219,0.00003},
	{0,0,5,-6,0,0,0,0,2,-3,0,5.807812945873619625558604,0.00044},
	{0,0,5,-6,0,0,0,0,2,-2,-2,2.653851143874942586364796,0.00001},
	{0,0,5,-6,0,0,0,0,2,-2,0,5.788958852096024898514770,0.01682},
	{0,0,5,-6,0,0,0,0,2,-2,2,2.653851143874942586364796,0.00001},
	{0,0,5,-6,0,0,0,0,2,-1,-2,2.647768671431742326660697,0.00009},
	{0,0,5,-6,0,0,0,0,2,-1,0,2.648229961953044497846577,0.04282},
	{0,0,5,-6,0,0,0,0,2,-1,2,5.789986676492524964032782,0.00009},
	{0,0,5,-6,0,0,0,0,2,0,-2,5.786800228877158502882594,0.00006},
	{0,0,5,-6,0,0,0,0,2,0,0,2.649166156563814045199479,0.00263},
	{0,0,5,-6,0,0,0,0,2,0,2,5.789985978360824070421131,0.00002},
	{0,0,5,-6,0,0,0,0,2,1,-2,2.644279932789930676051426,0.00001},
	{0,0,5,-6,0,0,0,0,2,1,0,2.647758548522080257470179,0.00016},
	{0,0,5,-6,0,0,0,0,3,-1,0,5.789988596354702643509427,0.00002},
	{0,0,5,-6,0,0,0,0,4,-3,0,5.782897323603848782624937,0.00028},
	{0,0,5,-6,0,0,0,0,4,-2,0,2.649261800606823147319346,0.00038},
	{0,0,5,-6,0,0,0,0,4,-1,0,2.648599273622766148150731,0.00037},
	{0,0,5,-6,0,0,0,0,4,0,0,2.648209716133721247643962,0.00006},
	{0,0,5,-6,0,0,0,0,6,-2,0,2.648597528293513914121604,0.00001},
	{0,0,5,-6,1,0,0,0,0,0,0,0.094023155732962118702467,0.00001},
	{0,0,5,-6,2,0,0,0,2,-2,0,3.648256324923065729848304,0.00002},
	{0,0,5,-5,-1,0,0,0,-2,0,0,5.714882889851181424489823,0.00001},
	{0,0,5,-5,0,0,0,0,-2,-1,0,2.393708597134711180132172,0.00004},
	{0,0,5,-5,0,0,0,0,-2,0,0,2.329784167951166384824546,0.00024},
	{0,0,5,-5,0,0,0,0,-2,1,0,2.378638551708366133397021,0.00021},
	{0,0,5,-5,0,0,0,0,0,-2,0,0.072220677249974163380841,0.00002},
	{0,0,5,-5,0,0,0,0,0,-1,0,0.334952769001389316638750,0.00028},
	{0,0,5,-5,0,0,0,0,0,0,0,3.032394907208291190414684,0.00128},
	{0,0,5,-5,0,0,0,0,0,1,0,3.068071706047083679891330,0.00022},
	{0,0,5,-5,0,0,0,0,0,2,0,3.001326475726465492499528,0.00002},
	{0,0,5,-5,0,0,0,0,1,0,-1,4.928019173480833181599792,0.00004},
	{0,0,5,-5,0,0,0,0,2,-2,0,3.128360963464574151515762,0.00005},
	{0,0,5,-5,0,0,0,0,2,-1,0,3.129504154124629788924494,0.00261},
	{0,0,5,-5,0,0,0,0,2,0,-2,3.153878898859207247085124,0.00018},
	{0,0,5,-5,0,0,0,0,2,0,0,0.041199020592101745497082,0.00020},
	{0,0,5,-5,0,0,0,0,2,1,0,0.006666634143842740077568,0.00005},
	{0,0,5,-5,0,0,0,0,4,-2,0,3.133333755569356338099851,0.00004},
	{0,0,5,-5,0,0,0,0,4,-1,0,3.107986687908492751120093,0.00001},
	{0,0,5,-5,2,0,0,0,0,0,0,1.001281080169280413016963,0.00001},
	{0,0,5,-4,-2,0,0,0,-2,0,0,2.603036231768977692979661,0.00001},
	{0,0,5,-4,0,0,0,0,-2,-1,0,1.511220734508546437169230,0.00002},
	{0,0,5,-4,0,0,0,0,-2,0,0,1.545233885504337267846608,0.00017},
	{0,0,5,-4,0,0,0,0,-2,1,0,1.519298990951402306137652,0.00013},
	{0,0,5,-4,0,0,0,0,0,-2,0,4.460717912767788284611470,0.00001},
	{0,0,5,-4,0,0,0,0,0,-1,0,4.358241254802791786460148,0.00016},
	{0,0,5,-4,0,0,0,0,0,0,0,1.511557932120031866318755,0.00008},
	{0,0,5,-4,0,0,0,0,0,1,0,1.186153510390453025280522,0.00004},
	{0,0,5,-4,0,0,0,0,1,0,-1,5.409650809083227152029849,0.00004},
	{0,0,5,-4,0,0,0,0,2,-1,0,6.257758652504832319607431,0.00013},
	{0,0,5,-4,0,0,0,0,2,0,0,3.603693531263595151159507,0.00005},
	{0,0,5,-4,0,0,0,0,3,-1,-1,5.409475578026326836322824,0.00003},
	{0,0,5,-3,-1,0,0,0,0,0,0,3.454496852683663465910513,0.00001},
	{0,0,5,-3,0,0,0,0,-2,0,0,5.718019246517015652386817,0.00003},
	{0,0,5,-3,0,0,0,0,0,0,0,5.513653757479093364679557,0.00001},
	{0,0,5,-2,0,0,0,0,-2,0,0,0.886650821958021362334534,0.00002},
	{0,0,5,-2,0,0,0,0,2,-2,0,4.649297945918973162804377,0.00002},
	{0,0,5,-2,0,0,0,0,2,0,0,4.649297945918973162804377,0.00002},
	{0,0,5,0,-8,0,0,0,2,0,0,0.537184243962897545188184,0.00001},
	{0,0,5,0,-7,0,0,0,-2,0,0,3.405956977257673656822590,0.00002},
	{0,0,5,0,-7,0,0,0,2,-1,0,3.499509068625522356654756,0.00005},
	{0,0,5,0,-7,0,0,0,2,0,0,0.357916415035729185145641,0.00005},
	{0,0,5,0,-7,5,0,0,2,-2,0,6.068333356396906630436661,0.00001},
	{0,0,5,0,-7,5,0,0,2,0,0,2.926740702807113958527907,0.00001},
	{0,0,5,0,-6,0,0,0,-2,0,0,3.186358079975420309892797,0.00005},
	{0,0,5,0,-6,0,0,0,-2,1,0,3.188048605888901931848523,0.00002},
	{0,0,5,0,-6,0,0,0,0,-1,0,0.175434911356863620923718,0.00002},
	{0,0,5,0,-6,0,0,0,0,0,0,3.145036886335678794068826,0.00001},
	{0,0,5,0,-6,0,0,0,0,1,0,3.317027739479581960324595,0.00001},
	{0,0,5,0,-6,0,0,0,2,-2,0,3.317027564946656958966287,0.00001},
	{0,0,5,0,-6,0,0,0,2,-1,0,3.317027564946656958966287,0.00021},
	{0,0,5,0,-6,0,0,0,2,0,0,0.172322989300557727343488,0.00012},
	{0,0,5,0,-6,0,0,0,2,1,0,0.175434911356863620923718,0.00003},
	{0,0,5,0,-5,0,0,0,-2,0,0,2.881367203710092361745865,0.00014},
	{0,0,5,0,-5,0,0,0,-2,1,0,2.879785760874860489622051,0.00006},
	{0,0,5,0,-5,0,0,0,0,-1,0,0.357108676657906132234643,0.00002},
	{0,0,5,0,-5,0,0,0,0,0,0,2.442692833388258932814097,0.00002},
	{0,0,5,0,-5,0,0,0,0,1,0,3.044303812293424282842125,0.00005},
	{0,0,5,0,-5,0,0,0,2,-2,0,3.172334184902720455312419,0.00001},
	{0,0,5,0,-5,0,0,0,2,-1,0,3.124098171299502624265187,0.00050},
	{0,0,5,0,-5,0,0,0,2,0,-2,3.126632040307548265900550,0.00002},
	{0,0,5,0,-5,0,0,0,2,0,0,6.271235735922881637804949,0.00032},
	{0,0,5,0,-5,0,0,0,2,1,0,6.267567577433965197997168,0.00006},
	{0,0,5,0,-5,0,0,0,4,-1,0,6.268224519364416380540206,0.00003},
	{0,0,5,0,-4,0,0,0,-2,0,0,1.096462261860940756719174,0.00011},
	{0,0,5,0,-4,0,0,0,-2,1,0,1.098697330501044788775289,0.00007},
	{0,0,5,0,-4,0,0,0,0,-1,0,4.298012909376196510891077,0.00002},
	{0,0,5,0,-4,0,0,0,0,0,0,1.141688280636169228188237,0.00002},
	{0,0,5,0,-4,0,0,0,0,1,0,1.015378453603489106171764,0.00001},
	{0,0,5,0,-4,0,0,0,2,-1,0,0.322849783303434667569576,0.00006},
	{0,0,5,0,-4,0,0,0,2,0,0,3.420740963219616848078886,0.00006},
	{0,0,5,0,-3,-5,0,0,2,-2,0,3.279880151680135025316076,0.00001},
	{0,0,5,0,-3,-5,0,0,2,0,0,0.138287498090341520740054,0.00001},
	{0,0,5,0,-3,0,0,0,-2,0,0,5.571443528874802098016517,0.00006},
	{0,0,5,0,-3,0,0,0,-2,1,0,5.501442212301665080076418,0.00003},
	{0,0,5,0,-3,0,0,0,0,0,0,5.517969782186350258257335,0.00001},
	{0,0,5,0,-3,5,0,0,2,0,0,5.216365891867441817453255,0.00001},
	{0,0,5,0,-2,0,0,0,-2,0,0,3.986304260819942157922924,0.00004},
	{0,0,5,0,-2,0,0,0,-2,1,0,3.974428167924746624350973,0.00001},
	{0,0,5,0,-2,0,0,0,2,-1,0,4.329169829051098261629704,0.00002},
	{0,0,5,0,-2,0,0,0,2,0,0,4.373029255022014893938831,0.00005},
	{0,0,5,0,-1,0,0,0,0,-1,0,5.402326360344308575633931,0.00001},
	{0,0,5,0,-1,0,0,0,0,1,0,5.402326360344308575633931,0.00001},
	{0,0,5,0,-1,0,0,0,2,-3,0,2.276113722656014193290730,0.00001},
	{0,0,5,0,-1,0,0,0,2,-2,0,5.410092202851057407997359,0.00004},
	{0,0,5,0,-1,0,0,0,2,0,0,5.428492161957282569062500,0.00004},
	{0,0,5,0,0,0,0,0,-2,0,0,5.273569581700331632134748,0.00002},
	{0,0,5,0,0,0,0,0,-2,2,0,5.273569581700331632134748,0.00002},
	{0,0,5,0,0,0,0,0,0,-2,0,2.757946943787013882598558,0.00001},
	{0,0,5,0,0,0,0,0,0,0,0,0.259480368822024576314078,0.00004},
	{0,0,5,0,0,0,0,0,0,2,0,0.652156412174622501787269,0.00001},
	{0,0,5,0,0,0,0,0,2,-2,0,3.454886933771483814581416,0.00003},
	{0,0,5,0,0,0,0,0,4,0,0,3.762708035951845886302181,0.00003},
	{0,0,5,0,1,-5,0,0,2,0,0,2.413439369795581601607637,0.00001},
	{0,0,6,-16,4,5,0,0,0,0,0,1.720096852465322179170926,0.00003},
	{0,0,6,-16,4,5,0,0,2,-1,0,1.720096852465322179170926,0.00006},
	{0,0,6,-16,4,5,0,0,2,0,0,1.720096852465322179170926,0.00007},
	{0,0,6,-15,0,0,0,0,2,0,0,0.013705896082986271031223,0.00002},
	{0,0,6,-13,0,0,0,0,0,-1,0,4.795162441890997051530121,0.00001},
	{0,0,6,-13,0,0,0,0,0,0,0,4.718985801358452469855820,0.00006},
	{0,0,6,-13,0,0,0,0,0,1,0,4.795162441890997051530121,0.00001},
	{0,0,6,-13,0,0,0,0,2,-1,0,4.946126789937349776948849,0.00006},
	{0,0,6,-13,0,0,0,0,2,0,0,4.946126789937349776948849,0.00005},
	{0,0,6,-12,0,0,0,0,-2,0,0,3.181819700321459443159711,0.00001},
	{0,0,6,-12,0,0,0,0,-2,1,0,3.181865602480786758832210,0.00002},
	{0,0,6,-12,0,0,0,0,0,-1,0,3.214929817962268288056293,0.00005},
	{0,0,6,-12,0,0,0,0,0,0,0,3.248246233520662773486265,0.00028},
	{0,0,6,-12,0,0,0,0,0,1,0,3.214929817962268288056293,0.00005},
	{0,0,6,-12,0,0,0,0,2,-1,0,3.384894343844605746340903,0.00003},
	{0,0,6,-12,0,0,0,0,2,0,0,3.384894343844605746340903,0.00003},
	{0,0,6,-12,2,0,0,0,0,-1,0,4.010988277897972409391514,0.00001},
	{0,0,6,-12,2,0,0,0,0,1,0,4.010988277897972409391514,0.00001},
	{0,0,6,-12,3,0,0,0,0,0,0,0.804566940039176836663160,0.00005},
	{0,0,6,-11,-2,0,0,0,0,-1,0,5.805274015410743615461797,0.00001},
	{0,0,6,-11,-2,0,0,0,0,0,0,2.628168274865995357458814,0.00001},
	{0,0,6,-11,-2,0,0,0,0,1,0,5.805274015410743615461797,0.00001},
	{0,0,6,-11,0,0,0,0,-4,1,0,3.749563263223375741972632,0.00001},
	{0,0,6,-11,0,0,0,0,-4,2,0,3.749882833009416049918627,0.00001},
	{0,0,6,-11,0,0,0,0,-2,-1,0,3.749624524280120940744609,0.00007},
	{0,0,6,-11,0,0,0,0,-2,0,0,3.747583536252838687374833,0.00064},
	{0,0,6,-11,0,0,0,0,-2,0,2,3.749880564081388367725367,0.00001},
	{0,0,6,-11,0,0,0,0,-2,1,0,3.756995747842993615961404,0.00099},
	{0,0,6,-11,0,0,0,0,-2,2,0,3.750399799533856715072488,0.00004},
	{0,0,6,-11,0,0,0,0,0,-2,0,3.713952088764459258385386,0.00006},
	{0,0,6,-11,0,0,0,0,0,-1,0,3.697687539998049111034106,0.00096},
	{0,0,6,-11,0,0,0,0,0,0,0,3.719825819829121194004529,0.00506},
	{0,0,6,-11,0,0,0,0,0,1,0,3.693745015750719229430388,0.00092},
	{0,0,6,-11,0,0,0,0,0,2,0,3.683056095812730301730653,0.00005},
	{0,0,6,-11,0,0,0,0,1,0,-1,5.160055287012798252987977,0.00001},
	{0,0,6,-11,0,0,0,0,2,-2,0,3.736959717095949429221946,0.00003},
	{0,0,6,-11,0,0,0,0,2,-1,0,3.746920834735856686847910,0.00082},
	{0,0,6,-11,0,0,0,0,2,0,-2,3.739000356057380791696687,0.00001},
	{0,0,6,-11,0,0,0,0,2,0,0,3.737935181614889135204294,0.00050},
	{0,0,6,-11,0,0,0,0,2,1,0,3.740121031970086384887964,0.00005},
	{0,0,6,-11,0,0,0,0,4,-2,0,3.739731299948116038933676,0.00001},
	{0,0,6,-11,0,0,0,0,4,-1,0,3.739714893853147703595141,0.00002},
	{0,0,6,-11,3,0,0,0,0,0,0,1.368735719567158781728722,0.00002},
	{0,0,6,-10,0,0,0,0,-4,1,0,4.245596657681526941985339,0.00001},
	{0,0,6,-10,0,0,0,0,-2,-1,0,4.245582695047510846109162,0.00004},
	{0,0,6,-10,0,0,0,0,-2,0,0,4.245485654741099956765993,0.00039},
	{0,0,6,-10,0,0,0,0,-2,1,0,4.246901814896168581014990,0.00054},
	{0,0,6,-10,0,0,0,0,-2,2,0,4.245613761908196615024735,0.00003},
	{0,0,6,-10,0,0,0,0,-1,-1,1,5.671136037617018565981653,0.00002},
	{0,0,6,-10,0,0,0,0,0,-2,0,4.204842521515757880479214,0.00001},
	{0,0,6,-10,0,0,0,0,0,-1,0,4.230337069498415480950371,0.00033},
	{0,0,6,-10,0,0,0,0,0,0,0,4.240674829190902883624403,0.00175},
	{0,0,6,-10,0,0,0,0,0,1,0,4.229410648731456667803741,0.00027},
	{0,0,6,-10,0,0,0,0,0,2,0,4.230196395960704514038753,0.00002},
	{0,0,6,-10,0,0,0,0,1,-2,1,2.529624192771592117168211,0.00006},
	{0,0,6,-10,0,0,0,0,1,-1,1,2.529543384027225005894479,0.00011},
	{0,0,6,-10,0,0,0,0,1,0,-1,5.671088041062588125384991,0.00007},
	{0,0,6,-10,0,0,0,0,1,0,0,4.208342430264782940696477,0.00002},
	{0,0,6,-10,0,0,0,0,2,-1,0,4.338040115908508909114971,0.00031},
	{0,0,6,-10,0,0,0,0,2,0,0,4.258030906871510090638822,0.00017},
	{0,0,6,-10,0,0,0,0,2,1,0,4.259270614239201613315799,0.00001},
	{0,0,6,-10,2,0,0,0,0,0,0,2.146082155526381374244238,0.00001},
	{0,0,6,-10,3,0,0,0,-2,0,0,1.882450521078488536730333,0.00001},
	{0,0,6,-10,3,0,0,0,0,0,0,1.889919657612398218304861,0.00006},
	{0,0,6,-9,0,0,0,0,-4,1,0,1.701479599867224079545736,0.00003},
	{0,0,6,-9,0,0,0,0,-2,-1,0,1.700303247951379770341873,0.00008},
	{0,0,6,-9,0,0,0,0,-2,0,0,1.712029242530903827557154,0.00078},
	{0,0,6,-9,0,0,0,0,-2,0,2,1.702664678429328004582999,0.00001},
	{0,0,6,-9,0,0,0,0,-2,1,0,1.696773494072146615252450,0.00091},
	{0,0,6,-9,0,0,0,0,-2,2,0,1.692182230941850162864171,0.00005},
	{0,0,6,-9,0,0,0,0,0,-2,0,1.657559610971263142076282,0.00004},
	{0,0,6,-9,0,0,0,0,0,-1,0,1.662877454669164478673338,0.00087},
	{0,0,6,-9,0,0,0,0,0,0,0,1.649829722247105445731563,0.00297},
	{0,0,6,-9,0,0,0,0,0,1,0,1.650121017699263337163984,0.00049},
	{0,0,6,-9,0,0,0,0,0,2,0,1.646886049930691875431421,0.00003},
	{0,0,6,-9,0,0,0,0,1,-2,0,4.743453397609235899778923,0.00001},
	{0,0,6,-9,0,0,0,0,1,-1,-1,3.042842797176580127427314,0.00003},
	{0,0,6,-9,0,0,0,0,1,0,-1,3.043250855155696488196782,0.00021},
	{0,0,6,-9,0,0,0,0,1,0,0,1.601860744019442783780960,0.00001},
	{0,0,6,-9,0,0,0,0,1,0,1,6.184319037305264998849452,0.00002},
	{0,0,6,-9,0,0,0,0,1,1,-2,1.646119152257365492175722,0.00004},
	{0,0,6,-9,0,0,0,0,1,1,-1,3.042842797176580127427314,0.00003},
	{0,0,6,-9,0,0,0,0,2,-2,0,4.787032523702283270949920,0.00006},
	{0,0,6,-9,0,0,0,0,2,-1,0,4.757886048792753008740419,0.00076},
	{0,0,6,-9,0,0,0,0,2,0,0,4.801532370062000509847167,0.00006},
	{0,0,6,-8,-2,0,0,0,0,0,0,4.259107949552915606261649,0.00001},
	{0,0,6,-8,0,0,0,0,-4,1,0,2.315208225236061068130766,0.00001},
	{0,0,6,-8,0,0,0,0,-2,-1,0,2.207675348428037143122538,0.00010},
	{0,0,6,-8,0,0,0,0,-2,0,0,2.296391656037385597954881,0.00050},
	{0,0,6,-8,0,0,0,0,-2,1,0,2.327520824977180602388671,0.00039},
	{0,0,6,-8,0,0,0,0,-2,2,0,2.395368579786282481336457,0.00002},
	{0,0,6,-8,0,0,0,0,0,-2,0,2.141691256194214076913340,0.00021},
	{0,0,6,-8,0,0,0,0,0,-1,0,2.140285044415882520496552,0.00664},
	{0,0,6,-8,0,0,0,0,0,0,0,2.173242096681291535276159,0.00206},
	{0,0,6,-8,0,0,0,0,0,1,0,2.191149174806752863986503,0.00031},
	{0,0,6,-8,0,0,0,0,0,2,0,2.217286178487068770692758,0.00002},
	{0,0,6,-8,0,0,0,0,1,-1,0,5.276766501291210609281279,0.00003},
	{0,0,6,-8,0,0,0,0,1,0,-1,3.583065135768424003259724,0.00009},
	{0,0,6,-8,0,0,0,0,1,0,0,2.133507407331612704126655,0.00002},
	{0,0,6,-8,0,0,0,0,2,-4,0,5.262236809801282610976614,0.00005},
	{0,0,6,-8,0,0,0,0,2,-3,0,5.262021610704511687117702,0.00067},
	{0,0,6,-8,0,0,0,0,2,-2,-2,2.135197584179244323365765,0.00002},
	{0,0,6,-8,0,0,0,0,2,-2,0,5.277115741674534454830336,0.02023},
	{0,0,6,-8,0,0,0,0,2,-2,2,2.135197584179244323365765,0.00002},
	{0,0,6,-8,0,0,0,0,2,-1,-2,5.276763010632706141223025,0.00006},
	{0,0,6,-8,0,0,0,0,2,-1,0,5.276888848871775117288507,0.03317},
	{0,0,6,-8,0,0,0,0,2,-1,2,2.135171753306314812448363,0.00006},
	{0,0,6,-8,0,0,0,0,2,0,-2,5.279704763086942698180337,0.00003},
	{0,0,6,-8,0,0,0,0,2,0,0,5.276161919238319342184695,0.00243},
	{0,0,6,-8,0,0,0,0,2,1,0,5.277330417172529486435906,0.00018},
	{0,0,6,-8,0,0,0,0,4,-3,0,5.283634546430732825683663,0.00031},
	{0,0,6,-8,0,0,0,0,4,-2,0,5.277094448657659420121036,0.00066},
	{0,0,6,-8,0,0,0,0,4,-1,0,5.276950982593145766941234,0.00034},
	{0,0,6,-8,0,0,0,0,4,0,0,5.275369539757914338906630,0.00003},
	{0,0,6,-8,0,1,0,0,2,-2,0,2.877909706461891481410476,0.00002},
	{0,0,6,-8,1,0,0,0,0,0,0,6.228301159922597030060842,0.00001},
	{0,0,6,-8,1,0,0,0,2,-1,0,5.029630148136840617212329,0.00003},
	{0,0,6,-8,2,0,0,0,2,0,0,3.146596687088186072855933,0.00001},
	{0,0,6,-8,3,0,0,0,-4,1,0,1.437601350396024102451520,0.00003},
	{0,0,6,-8,3,0,0,0,-2,-1,0,1.442923382884130356629271,0.00006},
	{0,0,6,-8,3,0,0,0,-2,0,0,1.437817771223271368086216,0.00054},
	{0,0,6,-8,3,0,0,0,-2,1,0,1.445546612749877724013459,0.00046},
	{0,0,6,-8,3,0,0,0,-2,2,0,1.442474309667592269335046,0.00002},
	{0,0,6,-8,3,0,0,0,0,-1,0,1.469270349673461373285477,0.00011},
	{0,0,6,-8,3,0,0,0,0,0,0,1.474749287261321928355073,0.00024},
	{0,0,6,-8,3,0,0,0,2,-3,0,1.958611977246540680752673,0.00001},
	{0,0,6,-7,-6,0,0,0,2,-2,0,3.387433623373332203243535,0.00002},
	{0,0,6,-7,-2,0,0,0,2,-1,-2,4.754609542187983706185150,0.00002},
	{0,0,6,-7,-2,0,0,0,2,0,-2,4.798652402263284599825965,0.00010},
	{0,0,6,-7,-2,0,0,0,2,1,-2,4.754609542187983706185150,0.00002},
	{0,0,6,-7,0,0,0,0,-2,-1,0,2.114389419771117051283227,0.00003},
	{0,0,6,-7,0,0,0,0,-2,0,0,2.021764272769002612761824,0.00018},
	{0,0,6,-7,0,0,0,0,-2,1,0,2.099510836963716098324539,0.00017},
	{0,0,6,-7,0,0,0,0,0,-2,0,5.818838539824317201976100,0.00002},
	{0,0,6,-7,0,0,0,0,0,-1,0,5.938060933830498377972162,0.00030},
	{0,0,6,-7,0,0,0,0,0,0,0,2.550593276536752718186563,0.00103},
	{0,0,6,-7,0,0,0,0,0,1,0,2.556629148688924768606512,0.00021},
	{0,0,6,-7,0,0,0,0,0,2,0,2.543397284030780358676793,0.00002},
	{0,0,6,-7,0,0,0,0,1,0,-1,4.183677611808523266745397,0.00006},
	{0,0,6,-7,0,0,0,0,2,-3,0,2.702016820709304489867009,0.00002},
	{0,0,6,-7,0,0,0,0,2,-2,0,2.637667229319974104839730,0.00003},
	{0,0,6,-7,0,0,0,0,2,-1,-2,2.644773686435319515197762,0.00001},
	{0,0,6,-7,0,0,0,0,2,-1,0,2.631204624165690120207728,0.00264},
	{0,0,6,-7,0,0,0,0,2,0,-2,2.644773686435319515197762,0.00025},
	{0,0,6,-7,0,0,0,0,2,0,0,5.808303034327579439377587,0.00017},
	{0,0,6,-7,0,0,0,0,2,1,-2,2.644773686435319515197762,0.00001},
	{0,0,6,-7,0,0,0,0,2,1,0,5.783166453374506410511913,0.00005},
	{0,0,6,-7,0,0,0,0,4,-2,0,2.630752758422348680511504,0.00004},
	{0,0,6,-6,0,0,0,0,-2,-1,0,2.612006875058378252418834,0.00002},
	{0,0,6,-6,0,0,0,0,-2,0,0,2.630975811500753103189254,0.00012},
	{0,0,6,-6,0,0,0,0,-2,1,0,2.380648647407887619209532,0.00007},
	{0,0,6,-6,0,0,0,0,0,-2,0,4.358236018815035528461976,0.00003},
	{0,0,6,-6,0,0,0,0,0,-1,0,4.048798043615626340852032,0.00036},
	{0,0,6,-6,0,0,0,0,0,0,0,3.128826442776080796193128,0.00063},
	{0,0,6,-6,0,0,0,0,0,1,0,3.021143118586534281888589,0.00011},
	{0,0,6,-6,0,0,0,0,1,0,-1,4.943750349627833884369466,0.00003},
	{0,0,6,-6,0,0,0,0,2,-2,0,3.527523348449283169259161,0.00006},
	{0,0,6,-6,0,0,0,0,2,-1,0,3.275681238565686381747355,0.00119},
	{0,0,6,-6,0,0,0,0,2,0,-2,3.152226770189269000610466,0.00004},
	{0,0,6,-6,0,0,0,0,2,0,0,6.169740476596281553156587,0.00016},
	{0,0,6,-6,0,0,0,0,2,1,0,0.009528974117113439556981,0.00004},
	{0,0,6,-6,0,0,0,0,3,-2,-1,1.801989271765223055155047,0.00004},
	{0,0,6,-6,0,0,0,0,3,-1,-1,1.801539500416984074249171,0.00005},
	{0,0,6,-6,0,0,0,0,4,-2,0,3.139518504306722856966871,0.00002},
	{0,0,6,-6,0,0,0,0,4,-1,0,0.008850739169788443549969,0.00001},
	{0,0,6,-5,0,0,0,0,-2,0,0,0.718360764960046860316822,0.00005},
	{0,0,6,-5,0,0,0,0,-2,1,0,0.715740851219878182476464,0.00002},
	{0,0,6,-5,0,0,0,0,0,-1,0,4.129312350938152853530028,0.00004},
	{0,0,6,-5,0,0,0,0,0,0,0,0.931840363351882916553848,0.00002},
	{0,0,6,-5,0,0,0,0,0,1,0,0.595404588085074015779696,0.00002},
	{0,0,6,-5,0,0,0,0,1,0,-1,5.405839009996872057683959,0.00002},
	{0,0,6,-5,0,0,0,0,2,-1,0,0.525937342263046114787528,0.00014},
	{0,0,6,-5,0,0,0,0,2,0,0,3.641680622433252079162003,0.00006},
	{0,0,6,-4,0,0,0,0,-2,0,0,5.723492075452493388354469,0.00002},
	{0,0,6,0,-8,0,0,0,2,-1,0,3.494988840395782059289331,0.00002},
	{0,0,6,0,-8,0,0,0,2,0,0,0.353396186805989054313670,0.00002},
	{0,0,6,0,-7,0,0,0,0,0,0,0.175437005751966024202915,0.00001},
	{0,0,6,0,-7,0,0,0,2,-1,0,3.308874608411815909647657,0.00004},
	{0,0,6,0,-7,0,0,0,2,0,0,0.167281954822022516093938,0.00004},
	{0,0,6,0,-6,0,0,0,-2,0,0,2.831375912478143686001886,0.00002},
	{0,0,6,0,-6,0,0,0,0,0,0,0.092075891886512051254243,0.00002},
	{0,0,6,0,-6,0,0,0,2,-1,0,3.108730721768618199263301,0.00010},
	{0,0,6,0,-6,0,0,0,2,0,0,6.250323200825485869813747,0.00009},
	{0,0,6,0,-6,0,0,0,2,1,0,6.250323200825485869813747,0.00001},
	{0,0,6,0,-5,0,0,0,-2,0,0,1.045341742602952095353430,0.00003},
	{0,0,6,0,-5,0,0,0,2,-1,0,0.406395029404974073017343,0.00002},
	{0,0,6,0,-5,0,0,0,2,0,0,3.547998504036129485683659,0.00002},
	{0,0,6,0,-2,0,0,0,0,0,0,5.381848237697733239315312,0.00001},
	{0,0,6,0,-2,0,0,0,0,2,0,5.381848237697733239315312,0.00001},
	{0,0,6,0,0,0,0,0,2,-2,0,5.625637223879702553119841,0.00001},
	{0,0,6,0,0,0,0,0,2,-1,0,5.703073294000486015420393,0.00002},
	{0,0,6,0,0,0,0,0,2,0,0,5.625637223879702553119841,0.00001},
	{0,0,7,-17,0,-2,0,0,-2,0,2,6.218767822482353047064407,0.00004},
	{0,0,7,-16,4,5,0,0,-2,-1,0,3.065101155660188592122495,0.00002},
	{0,0,7,-16,4,5,0,0,-2,0,0,3.065101155660188592122495,0.00002},
	{0,0,7,-16,4,5,0,0,-2,1,0,3.065101155660188592122495,0.00007},
	{0,0,7,-16,4,5,0,0,0,-1,0,6.206693809249982152209668,0.00020},
	{0,0,7,-16,4,5,0,0,0,0,0,6.206693809249982152209668,0.00120},
	{0,0,7,-16,4,5,0,0,0,1,0,6.206693809249982152209668,0.00027},
	{0,0,7,-16,4,5,0,0,2,-2,0,6.206693809249982152209668,0.00006},
	{0,0,7,-16,4,5,0,0,2,-1,0,6.206693809249982152209668,0.00115},
	{0,0,7,-16,4,5,0,0,2,0,-2,6.206693809249982152209668,0.00001},
	{0,0,7,-16,4,5,0,0,2,0,0,6.206693809249982152209668,0.00087},
	{0,0,7,-16,4,5,0,0,2,1,0,6.206693809249982152209668,0.00011},
	{0,0,7,-16,4,5,0,0,4,-1,0,6.206693809249982152209668,0.00004},
	{0,0,7,-16,4,5,0,0,4,0,0,6.206693809249982152209668,0.00002},
	{0,0,7,-15,0,0,0,0,-2,1,0,1.369231742140575525112922,0.00003},
	{0,0,7,-15,0,0,0,0,0,-1,0,4.395974051500433077421803,0.00001},
	{0,0,7,-15,0,0,0,0,0,0,0,4.468565436683531011397008,0.00030},
	{0,0,7,-15,0,0,0,0,0,1,0,4.447031913438275196881477,0.00011},
	{0,0,7,-15,0,0,0,0,2,-1,0,4.508268186507897290482560,0.00028},
	{0,0,7,-15,0,0,0,0,2,0,0,4.499532115469964566045746,0.00024},
	{0,0,7,-15,0,0,0,0,2,1,0,4.503484239028181512765059,0.00003},
	{0,0,7,-14,0,0,0,0,0,0,0,2.758494802639214871220474,0.00006},
	{0,0,7,-14,1,0,0,0,0,0,0,3.256111908860625625550256,0.00002},
	{0,0,7,-14,3,0,0,0,0,0,0,0.297591727434423136688935,0.00001},
	{0,0,7,-13,-1,0,0,0,-2,0,0,2.028328107019902848406900,0.00006},
	{0,0,7,-13,-1,0,0,0,-2,1,0,2.036425911150381296010892,0.00007},
	{0,0,7,-13,-1,0,0,0,0,-1,0,2.008988637177329561467332,0.00013},
	{0,0,7,-13,-1,0,0,0,0,0,0,2.044427896704924751958288,0.00055},
	{0,0,7,-13,-1,0,0,0,0,1,0,2.008988637177329561467332,0.00013},
	{0,0,7,-13,-1,0,0,0,2,-1,0,2.036314035545328415821587,0.00007},
	{0,0,7,-13,-1,0,0,0,2,0,0,2.028200872517432529207326,0.00005},
	{0,0,7,-13,0,0,0,0,-4,1,0,3.243626172457708456420278,0.00003},
	{0,0,7,-13,0,0,0,0,-4,2,0,3.243893905964964741173162,0.00001},
	{0,0,7,-13,0,0,0,0,-2,-1,0,3.243625648858933008256145,0.00006},
	{0,0,7,-13,0,0,0,0,-2,0,0,3.240939412607188430115457,0.00063},
	{0,0,7,-13,0,0,0,0,-2,0,2,3.243626521523558903226103,0.00001},
	{0,0,7,-13,0,0,0,0,-2,1,0,3.252173573403500661527232,0.00098},
	{0,0,7,-13,0,0,0,0,-2,2,0,3.244136506730991520441876,0.00004},
	{0,0,7,-13,0,0,0,0,0,-2,0,3.186977148261102232851272,0.00007},
	{0,0,7,-13,0,0,0,0,0,-1,0,3.190557865754493960253058,0.00107},
	{0,0,7,-13,0,0,0,0,0,0,-2,0.073192127511634202940982,0.00001},
	{0,0,7,-13,0,0,0,0,0,0,0,3.214430130197422297300136,0.00558},
	{0,0,7,-13,0,0,0,0,0,0,2,0.073192127511634202940982,0.00001},
	{0,0,7,-13,0,0,0,0,0,1,0,3.188057507068086771084836,0.00105},
	{0,0,7,-13,0,0,0,0,0,2,0,3.185431659208461496746168,0.00007},
	{0,0,7,-13,0,0,0,0,2,-2,0,3.234892893946579306430067,0.00004},
	{0,0,7,-13,0,0,0,0,2,-1,0,3.242858227586830732747103,0.00087},
	{0,0,7,-13,0,0,0,0,2,0,-2,3.235595039904656466944743,0.00001},
	{0,0,7,-13,0,0,0,0,2,0,0,3.233146517497033745058843,0.00055},
	{0,0,7,-13,0,0,0,0,2,1,0,3.235846890915719420434016,0.00005},
	{0,0,7,-13,0,0,0,0,4,-1,0,3.235595039904656466944743,0.00002},
	{0,0,7,-13,1,0,0,0,0,0,0,3.841428493869172289265634,0.00001},
	{0,0,7,-13,3,0,0,0,0,0,0,0.864388972815908540603402,0.00002},
	{0,0,7,-12,0,0,0,0,-2,-1,0,3.742957715603353108235751,0.00002},
	{0,0,7,-12,0,0,0,0,-2,0,0,3.742312292845965338017322,0.00012},
	{0,0,7,-12,0,0,0,0,-2,1,0,3.743519537089569748644635,0.00020},
	{0,0,7,-12,0,0,0,0,0,-1,0,3.727451163331084060814646,0.00012},
	{0,0,7,-12,0,0,0,0,0,0,0,3.727693764097111284172570,0.00066},
	{0,0,7,-12,0,0,0,0,0,1,0,3.727110824126945054501903,0.00010},
	{0,0,7,-12,0,0,0,0,1,0,-1,5.163308580738514841357301,0.00002},
	{0,0,7,-12,0,0,0,0,2,-1,0,3.753629356781746917448572,0.00014},
	{0,0,7,-12,0,0,0,0,2,0,0,3.749188191967122385506173,0.00008},
	{0,0,7,-12,3,0,0,0,0,0,0,1.368939050425016068501805,0.00003},
	{0,0,7,-11,-2,0,0,0,0,0,0,3.224311311757587894533117,0.00001},
	{0,0,7,-11,-1,0,0,0,1,0,-1,4.644702144932621123984973,0.00001},
	{0,0,7,-11,0,0,0,0,-4,1,0,1.203867555100644359811213,0.00002},
	{0,0,7,-11,0,0,0,0,-2,-1,0,1.203385844227093937064410,0.00005},
	{0,0,7,-11,0,0,0,0,-2,0,0,1.202399209600941487607884,0.00047},
	{0,0,7,-11,0,0,0,0,-2,1,0,1.197593620038500228375256,0.00056},
	{0,0,7,-11,0,0,0,0,-2,2,0,1.203111303935755271865560,0.00003},
	{0,0,7,-11,0,0,0,0,0,-2,0,1.153791615399974102018632,0.00002},
	{0,0,7,-11,0,0,0,0,0,-1,0,1.159588901043398623258440,0.00049},
	{0,0,7,-11,0,0,0,0,0,0,0,1.152942338185953818907592,0.00179},
	{0,0,7,-11,0,0,0,0,0,1,0,1.149208904383012708194656,0.00030},
	{0,0,7,-11,0,0,0,0,0,2,0,1.164884229993949249504226,0.00002},
	{0,0,7,-11,0,0,0,0,1,-1,-1,2.519167227091193339560959,0.00002},
	{0,0,7,-11,0,0,0,0,1,0,-1,2.523912777327366185886603,0.00017},
	{0,0,7,-11,0,0,0,0,1,0,1,5.664941689568764537909829,0.00002},
	{0,0,7,-11,0,0,0,0,1,1,-1,2.519167227091193339560959,0.00002},
	{0,0,7,-11,0,0,0,0,2,-2,0,4.320527133128146957119498,0.00003},
	{0,0,7,-11,0,0,0,0,2,-1,0,4.277739164785029579718412,0.00029},
	{0,0,7,-11,0,0,0,0,2,0,0,4.344993856714304492072642,0.00002},
	{0,0,7,-10,0,0,0,0,-2,-1,0,1.764716892924258262453918,0.00002},
	{0,0,7,-10,0,0,0,0,-2,0,0,1.769018780464573836752606,0.00016},
	{0,0,7,-10,0,0,0,0,-2,1,0,1.782305797527081514530778,0.00016},
	{0,0,7,-10,0,0,0,0,0,-2,0,1.623160393144931434861178,0.00005},
	{0,0,7,-10,0,0,0,0,0,-1,0,1.636671161417544650973355,0.00118},
	{0,0,7,-10,0,0,0,0,0,0,0,1.659937273011254932342240,0.00080},
	{0,0,7,-10,0,0,0,0,0,1,0,1.678303721795841640940239,0.00013},
	{0,0,7,-10,0,0,0,0,1,0,-1,3.060925280891867217292202,0.00007},
	{0,0,7,-10,0,0,0,0,2,-3,0,4.773377765766379177136969,0.00004},
	{0,0,7,-10,0,0,0,0,2,-2,0,4.770499717829840946592412,0.00111},
	{0,0,7,-10,0,0,0,0,2,-1,0,4.767405947197755899935601,0.00507},
	{0,0,7,-10,0,0,0,0,2,0,-2,4.772966042595833791040150,0.00002},
	{0,0,7,-10,0,0,0,0,2,0,0,4.767294071592703019746295,0.00043},
	{0,0,7,-10,0,0,0,0,2,1,0,4.769044113233677606444871,0.00004},
	{0,0,7,-10,0,0,0,0,4,-3,0,4.768973776464822122989062,0.00002},
	{0,0,7,-10,0,0,0,0,4,-2,0,4.767540861148934716595704,0.00008},
	{0,0,7,-10,0,0,0,0,4,-1,0,4.766959142909245272790031,0.00005},
	{0,0,7,-10,1,0,0,0,2,-2,0,2.168849975618647452080268,0.00023},
	{0,0,7,-10,1,0,0,0,2,-1,0,2.489787925259447476378227,0.00008},
	{0,0,7,-10,2,0,0,0,2,-2,0,5.780582493416929423801776,0.00001},
	{0,0,7,-10,2,0,0,0,2,0,0,2.638989839827135863714602,0.00001},
	{0,0,7,-9,-2,0,0,0,0,0,0,3.870418238211873251941597,0.00001},
	{0,0,7,-9,0,0,0,0,-2,-2,0,1.550512982892844560112167,0.00001},
	{0,0,7,-9,0,0,0,0,-2,0,0,1.613567016378419261002364,0.00011},
	{0,0,7,-9,0,0,0,0,-2,1,0,1.485828113754206203367403,0.00009},
	{0,0,7,-9,0,0,0,0,0,-2,0,5.302588822107392019233885,0.00002},
	{0,0,7,-9,0,0,0,0,0,-1,0,5.357415198966140046366036,0.00022},
	{0,0,7,-9,0,0,0,0,0,0,0,2.039430844523539843038407,0.00059},
	{0,0,7,-9,0,0,0,0,0,1,0,2.001021383674900455673651,0.00012},
	{0,0,7,-9,0,0,0,0,0,2,0,2.084164156850929927600191,0.00002},
	{0,0,7,-9,0,0,0,0,1,0,-1,3.605963157422888976100239,0.00005},
	{0,0,7,-9,0,0,0,0,2,-2,0,2.136003228161964972997566,0.00002},
	{0,0,7,-9,0,0,0,0,2,-1,-2,2.137862876479964757692187,0.00002},
	{0,0,7,-9,0,0,0,0,2,-1,0,2.125177474410619549161083,0.00186},
	{0,0,7,-9,0,0,0,0,2,0,-2,2.137862876479964757692187,0.00030},
	{0,0,7,-9,0,0,0,0,2,0,0,5.296401629909071040458457,0.00011},
	{0,0,7,-9,0,0,0,0,2,1,-2,2.137862876479964757692187,0.00002},
	{0,0,7,-9,0,0,0,0,2,1,0,5.277014512577918203817262,0.00003},
	{0,0,7,-9,0,0,0,0,4,-2,0,2.123038747945225512836487,0.00003},
	{0,0,7,-9,2,0,0,0,2,-2,0,3.142906188384843702010585,0.00001},
	{0,0,7,-9,2,0,0,0,2,0,0,3.142906188384843702010585,0.00001},
	{0,0,7,-8,-2,0,0,0,0,0,0,4.766617756507555370149021,0.00001},
	{0,0,7,-8,0,0,0,0,-2,-1,0,2.371964238115814360696731,0.00002},
	{0,0,7,-8,0,0,0,0,-2,0,0,2.383270830076083868220849,0.00010},
	{0,0,7,-8,0,0,0,0,-2,1,0,2.260776641854114199503556,0.00007},
	{0,0,7,-8,0,0,0,0,0,-2,0,6.124199425891069026306468,0.00001},
	{0,0,7,-8,0,0,0,0,0,-1,0,0.187063691097051426615039,0.00034},
	{0,0,7,-8,0,0,0,0,0,0,0,2.572902598634520199283315,0.00055},
	{0,0,7,-8,0,0,0,0,0,1,0,2.593378975951842857483598,0.00013},
	{0,0,7,-8,0,0,0,0,0,2,0,2.608486196891255382013242,0.00001},
	{0,0,7,-8,0,0,0,0,1,0,-1,4.212104662000381694042517,0.00003},
	{0,0,7,-8,0,0,0,0,2,-2,0,1.856076152619901442619721,0.00002},
	{0,0,7,-8,0,0,0,0,2,-1,0,2.526724328219403403750221,0.00103},
	{0,0,7,-8,0,0,0,0,2,0,-2,2.641173246721380429846704,0.00004},
	{0,0,7,-8,0,0,0,0,2,0,0,5.867641087302732927355464,0.00020},
	{0,0,7,-8,0,0,0,0,2,1,0,5.784204749746518103847848,0.00004},
	{0,0,7,-8,0,0,0,0,4,-2,0,2.639161929291382158169199,0.00002},
	{0,0,7,-8,0,0,0,0,4,-1,0,5.784629213820602799955850,0.00001},
	{0,0,7,-8,3,0,0,0,-2,0,0,5.931719803592153006377430,0.00003},
	{0,0,7,-8,3,0,0,0,-2,1,0,5.931463240192109687143329,0.00001},
	{0,0,7,-8,3,0,0,0,3,-1,-2,5.900876694116759857422494,0.00002},
	{0,0,7,-7,0,0,0,0,-2,0,0,2.927240216039034947925757,0.00006},
	{0,0,7,-7,0,0,0,0,0,-1,0,5.102222056918713555262457,0.00002},
	{0,0,7,-7,0,0,0,0,0,0,0,3.117845529254232861404716,0.00032},
	{0,0,7,-7,0,0,0,0,0,1,0,3.078075584253664231937364,0.00006},
	{0,0,7,-7,0,0,0,0,1,0,-1,4.954718347713217063699176,0.00002},
	{0,0,7,-7,0,0,0,0,2,-2,0,3.148702950429492553041655,0.00002},
	{0,0,7,-7,0,0,0,0,2,-1,0,3.163446270219864242534413,0.00050},
	{0,0,7,-7,0,0,0,0,2,0,-2,3.148881846677822338165242,0.00002},
	{0,0,7,-7,0,0,0,0,2,0,0,0.014906682608358369848678,0.00013},
	{0,0,7,-7,0,0,0,0,2,1,0,0.007164402046511524069228,0.00003},
	{0,0,7,-6,-2,0,0,0,0,0,0,5.770307216511663561675505,0.00002},
	{0,0,7,-6,0,0,0,0,-2,0,0,0.755544132009160152030347,0.00003},
	{0,0,7,-6,0,0,0,0,-2,1,0,0.621675283986092730437178,0.00001},
	{0,0,7,-6,0,0,0,0,0,-1,0,3.172704543769993446034050,0.00002},
	{0,0,7,-6,0,0,0,0,0,0,0,0.700959134185962562391126,0.00002},
	{0,0,7,-6,0,0,0,0,0,1,0,0.520716538871555445489037,0.00001},
	{0,0,7,-6,0,0,0,0,1,0,-1,5.399213740156302065997806,0.00001},
	{0,0,7,-6,0,0,0,0,2,-1,0,0.520896307784510792515675,0.00010},
	{0,0,7,-6,0,0,0,0,2,0,0,3.662586001680714797856808,0.00006},
	{0,0,7,0,-8,0,0,0,2,0,0,0.155877100824865583161838,0.00002},
	{0,0,7,0,-7,0,0,0,2,-1,0,3.083969212071798970953296,0.00003},
	{0,0,7,0,-7,0,0,0,2,0,0,6.225561865661592086951259,0.00003},
	{0,0,8,-19,0,0,0,0,-2,0,2,3.537715722215079683365957,0.00003},
	{0,0,8,-19,0,3,0,0,2,0,0,4.837374626113882136735356,0.00003},
	{0,0,8,-17,0,0,0,0,-1,0,1,3.057719111055953842281951,0.00005},
	{0,0,8,-17,0,0,0,0,0,-1,0,4.089451648816480044956734,0.00001},
	{0,0,8,-17,0,0,0,0,0,0,0,4.090052914743791845353371,0.00006},
	{0,0,8,-17,0,0,0,0,0,1,0,4.089451648816480044956734,0.00001},
	{0,0,8,-17,0,0,0,0,2,-1,0,4.056751334484039794858745,0.00005},
	{0,0,8,-17,0,0,0,0,2,0,0,4.056751334484039794858745,0.00004},
	{0,0,8,-16,0,0,0,0,0,0,0,2.118740700129264631357273,0.00002},
	{0,0,8,-16,4,5,0,0,-4,-1,0,4.410105633387980894610791,0.00002},
	{0,0,8,-16,4,5,0,0,-4,0,0,4.410105633387980894610791,0.00011},
	{0,0,8,-16,4,5,0,0,-4,1,0,4.410105633387980894610791,0.00029},
	{0,0,8,-16,4,5,0,0,-4,2,0,4.410105633387980894610791,0.00020},
	{0,0,8,-16,4,5,0,0,-3,0,0,4.410105633387980894610791,0.00002},
	{0,0,8,-16,4,5,0,0,-3,3,0,1.268512979798187556568223,0.00001},
	{0,0,8,-16,4,5,0,0,-2,-2,0,4.410105633387980894610791,0.00007},
	{0,0,8,-16,4,5,0,0,-2,-1,0,4.410105633387980894610791,0.00068},
	{0,0,8,-16,4,5,0,0,-2,-1,2,1.268512979798187556568223,0.00001},
	{0,0,8,-16,4,5,0,0,-2,0,-2,1.268512979798187556568223,0.00002},
	{0,0,8,-16,4,5,0,0,-2,0,0,4.410105633387980894610791,0.00865},
	{0,0,8,-16,4,5,0,0,-2,0,2,4.410105633387980894610791,0.00021},
	{0,0,8,-16,4,5,0,0,-2,1,-2,1.268512979798187556568223,0.00003},
	{0,0,8,-16,4,5,0,0,-2,1,0,4.410105633387980894610791,0.01709},
	{0,0,8,-16,4,5,0,0,-2,2,0,4.410105633387980894610791,0.00083},
	{0,0,8,-16,4,5,0,0,-2,3,0,4.410105633387980894610791,0.00006},
	{0,0,8,-16,4,5,0,0,-1,-1,0,1.268512979798187556568223,0.00002},
	{0,0,8,-16,4,5,0,0,-1,0,0,1.268512979798187556568223,0.00023},
	{0,0,8,-16,4,5,0,0,-1,1,0,1.268512979798187556568223,0.00005},
	{0,0,8,-16,4,5,0,0,0,-3,0,1.268512979798187556568223,0.00002},
	{0,0,8,-16,4,5,0,0,0,-2,0,1.268512979798187556568223,0.00015},
	{0,0,8,-16,4,5,0,0,0,-1,0,1.268512979798187556568223,0.00199},
	{0,0,8,-16,4,5,0,0,0,0,0,1.268512979798187556568223,0.00188},
	{0,0,8,-16,4,5,0,0,0,1,0,1.268512979798187556568223,0.00199},
	{0,0,8,-16,4,5,0,0,0,2,0,1.268512979798187556568223,0.00015},
	{0,0,8,-16,4,5,0,0,0,3,0,1.268512979798187556568223,0.00002},
	{0,0,8,-16,4,5,0,0,1,-1,0,1.268512979798187556568223,0.00005},
	{0,0,8,-16,4,5,0,0,1,0,0,1.268512979798187556568223,0.00023},
	{0,0,8,-16,4,5,0,0,1,1,0,1.268512979798187556568223,0.00002},
	{0,0,8,-16,4,5,0,0,2,-3,0,4.410105633387980894610791,0.00006},
	{0,0,8,-16,4,5,0,0,2,-2,0,4.410105633387980894610791,0.00083},
	{0,0,8,-16,4,5,0,0,2,-1,0,4.410105633387980894610791,0.01709},
	{0,0,8,-16,4,5,0,0,2,-1,2,1.268512979798187556568223,0.00003},
	{0,0,8,-16,4,5,0,0,2,0,-2,4.410105633387980894610791,0.00021},
	{0,0,8,-16,4,5,0,0,2,0,0,4.410105633387980894610791,0.00865},
	{0,0,8,-16,4,5,0,0,2,0,2,1.268512979798187556568223,0.00002},
	{0,0,8,-16,4,5,0,0,2,1,-2,1.268512979798187556568223,0.00001},
	{0,0,8,-16,4,5,0,0,2,1,0,4.410105633387980894610791,0.00068},
	{0,0,8,-16,4,5,0,0,2,2,0,4.410105633387980894610791,0.00007},
	{0,0,8,-16,4,5,0,0,3,-3,0,1.268512979798187556568223,0.00001},
	{0,0,8,-16,4,5,0,0,3,0,0,4.410105633387980894610791,0.00002},
	{0,0,8,-16,4,5,0,0,4,-2,0,4.410105633387980894610791,0.00020},
	{0,0,8,-16,4,5,0,0,4,-1,0,4.410105633387980894610791,0.00029},
	{0,0,8,-16,4,5,0,0,4,0,0,4.410105633387980894610791,0.00011},
	{0,0,8,-16,4,5,0,0,4,1,0,4.410105633387980894610791,0.00002},
	{0,0,8,-16,6,0,0,0,-2,0,0,4.555741491227994544033209,0.00007},
	{0,0,8,-16,6,0,0,0,-2,1,0,4.555741491227994544033209,0.00012},
	{0,0,8,-16,6,0,0,0,0,1,0,1.414148837638200761901430,0.00002},
	{0,0,8,-16,6,0,0,0,2,-1,0,4.555741491227994544033209,0.00012},
	{0,0,8,-16,6,0,0,0,2,0,0,4.555741491227994544033209,0.00007},
	{0,0,8,-15,0,0,0,0,-4,0,0,2.737375620558383015890058,0.00003},
	{0,0,8,-15,0,0,0,0,-4,1,0,2.737401800497162529524076,0.00008},
	{0,0,8,-15,0,0,0,0,-4,2,0,2.751227251633910686479112,0.00004},
	{0,0,8,-15,0,0,0,0,-2,-2,0,2.737273344264216312637927,0.00003},
	{0,0,8,-15,0,0,0,0,-2,-1,0,2.726405528077898043903815,0.00026},
	{0,0,8,-15,0,0,0,0,-2,0,0,2.735078767262758336897832,0.00268},
	{0,0,8,-15,0,0,0,0,-2,0,2,2.736811879209988696004530,0.00005},
	{0,0,8,-15,0,0,0,0,-2,1,0,2.746464073572293163039149,0.00414},
	{0,0,8,-15,0,0,0,0,-2,2,0,2.764835932877561130993627,0.00016},
	{0,0,8,-15,0,0,0,0,-2,3,0,2.737468821140438990369148,0.00001},
	{0,0,8,-15,0,0,0,0,-1,0,0,5.874642999195883064089685,0.00010},
	{0,0,8,-15,0,0,0,0,-1,1,0,5.878404532799781812002493,0.00001},
	{0,0,8,-15,0,0,0,0,0,-3,0,2.666952981503813102648337,0.00002},
	{0,0,8,-15,0,0,0,0,0,-2,0,2.684447812859954041186938,0.00035},
	{0,0,8,-15,0,0,0,0,0,-1,-2,5.837846397109013096837771,0.00002},
	{0,0,8,-15,0,0,0,0,0,-1,0,2.683805706228145293579246,0.00503},
	{0,0,8,-15,0,0,0,0,0,0,-2,5.878599660610154487017098,0.00001},
	{0,0,8,-15,0,0,0,0,0,0,0,2.710655851440826324960653,0.02611},
	{0,0,8,-15,0,0,0,0,0,0,2,5.878599660610154487017098,0.00001},
	{0,0,8,-15,0,0,0,0,0,1,0,2.683092390162855167545786,0.00501},
	{0,0,8,-15,0,0,0,0,0,1,2,5.837846397109013096837771,0.00002},
	{0,0,8,-15,0,0,0,0,0,2,0,2.683491896028636691795555,0.00034},
	{0,0,8,-15,0,0,0,0,0,3,0,2.666245774090905129583007,0.00002},
	{0,0,8,-15,0,0,0,0,1,-1,0,5.875578321142027604651048,0.00001},
	{0,0,8,-15,0,0,0,0,1,0,0,5.875136752841273235503650,0.00007},
	{0,0,8,-15,0,0,0,0,2,-3,0,2.733835743769487791610118,0.00001},
	{0,0,8,-15,0,0,0,0,2,-2,0,2.761060087573796284488026,0.00015},
	{0,0,8,-15,0,0,0,0,2,-1,0,2.744043476432701744727183,0.00398},
	{0,0,8,-15,0,0,0,0,2,0,-2,2.733985667552234044563875,0.00006},
	{0,0,8,-15,0,0,0,0,2,0,0,2.732123575773281576317686,0.00257},
	{0,0,8,-15,0,0,0,0,2,1,0,2.723773047967114724343674,0.00025},
	{0,0,8,-15,0,0,0,0,2,2,0,2.734447132606461661197272,0.00003},
	{0,0,8,-15,0,0,0,0,4,-2,0,2.746605096175853688578172,0.00005},
	{0,0,8,-15,0,0,0,0,4,-1,0,2.734803354306793554684418,0.00007},
	{0,0,8,-15,0,0,0,0,4,0,0,2.734526370554501983889395,0.00003},
	{0,0,8,-15,2,0,0,0,0,-1,0,0.330800630710894827402058,0.00001},
	{0,0,8,-15,2,0,0,0,0,1,0,0.330800630710894827402058,0.00001},
	{0,0,8,-14,0,0,0,0,-2,0,0,3.239579277521109190729476,0.00006},
	{0,0,8,-14,0,0,0,0,-2,1,0,3.239580499251585976594470,0.00009},
	{0,0,8,-14,0,0,0,0,0,-1,0,3.188241813837097371475693,0.00005},
	{0,0,8,-14,0,0,0,0,0,0,0,3.217251454933271137548445,0.00029},
	{0,0,8,-14,0,0,0,0,0,1,0,3.188241813837097371475693,0.00005},
	{0,0,8,-14,0,0,0,0,2,-1,0,3.228772722391535676678131,0.00007},
	{0,0,8,-14,0,0,0,0,2,0,0,3.249104062848017893117003,0.00004},
	{0,0,8,-14,3,0,0,0,0,0,0,0.862427920868367614559702,0.00001},
	{0,0,8,-13,0,-1,0,0,1,-1,-1,2.457971620193142303634204,0.00002},
	{0,0,8,-13,0,-1,0,0,1,0,-1,3.021718030042141123203692,0.00031},
	{0,0,8,-13,0,-1,0,0,1,1,-1,2.457971620193142303634204,0.00002},
	{0,0,8,-13,0,0,0,0,-4,1,0,0.728121867867675631735835,0.00001},
	{0,0,8,-13,0,0,0,0,-2,-1,0,0.727474001649335288988141,0.00004},
	{0,0,8,-13,0,0,0,0,-2,0,0,0.725937239242954279738740,0.00035},
	{0,0,8,-13,0,0,0,0,-2,1,0,0.730717521531241587240402,0.00043},
	{0,0,8,-13,0,0,0,0,-2,2,0,0.729243067379156784113547,0.00002},
	{0,0,8,-13,0,0,0,0,0,-2,0,0.668465815902808513371269,0.00001},
	{0,0,8,-13,0,0,0,0,0,-1,0,0.673637750075243402214653,0.00032},
	{0,0,8,-13,0,0,0,0,0,0,0,0.657102849807699507245218,0.00131},
	{0,0,8,-13,0,0,0,0,0,1,0,0.649099991588529823260956,0.00020},
	{0,0,8,-13,0,0,0,0,1,-1,-1,1.961955155428735775302584,0.00002},
	{0,0,8,-13,0,0,0,0,1,0,-1,1.981689418748110442791699,0.00018},
	{0,0,8,-13,0,0,0,0,1,1,-1,1.961955155428735775302584,0.00002},
	{0,0,8,-13,0,0,0,0,2,-1,0,3.775087307270391434599333,0.00009},
	{0,0,8,-13,0,0,0,0,2,0,0,0.656868103023306337817644,0.00002},
	{0,0,8,-12,0,0,0,0,-2,0,0,1.233345468035127900918724,0.00008},
	{0,0,8,-12,0,0,0,0,-2,1,0,1.243173067987257462974071,0.00008},
	{0,0,8,-12,0,0,0,0,0,-2,0,1.121067913655557024554810,0.00002},
	{0,0,8,-12,0,0,0,0,0,-1,0,1.131009832673692372395635,0.00036},
	{0,0,8,-12,0,0,0,0,0,0,0,1.147720836662762255997450,0.00036},
	{0,0,8,-12,0,0,0,0,0,1,0,1.168248875725944158077141,0.00008},
	{0,0,8,-12,0,0,0,0,1,0,-1,2.543278252575794429191092,0.00004},
	{0,0,8,-12,0,0,0,0,2,-2,0,4.272978779250214742546632,0.00021},
	{0,0,8,-12,0,0,0,0,2,-1,0,4.262450778669260031961130,0.00142},
	{0,0,8,-12,0,0,0,0,2,0,0,4.263903067139844793587145,0.00015},
	{0,0,8,-12,0,0,0,0,4,-2,0,4.260936705543155511577424,0.00002},
	{0,0,8,-12,2,0,0,0,2,-2,0,5.485554654653685524579032,0.00004},
	{0,0,8,-12,2,0,0,0,2,-1,0,2.256530779382787788023279,0.00007},
	{0,0,8,-11,-2,0,0,0,0,0,0,4.041705025535521578206044,0.00001},
	{0,0,8,-11,0,0,0,0,-2,0,0,0.912156889113741264907276,0.00006},
	{0,0,8,-11,0,0,0,0,-2,1,0,0.732237877842653817062057,0.00004},
	{0,0,8,-11,0,0,0,0,0,-2,0,4.754941503811713765514924,0.00002},
	{0,0,8,-11,0,0,0,0,0,-1,0,4.815944600893268479069320,0.00017},
	{0,0,8,-11,0,0,0,0,0,0,0,1.517532019616683047757988,0.00029},
	{0,0,8,-11,0,0,0,0,0,1,0,1.477642868628203265402021,0.00006},
	{0,0,8,-11,0,0,0,0,1,0,-1,3.071007000783087192985477,0.00004},
	{0,0,8,-11,0,0,0,0,2,-1,-2,1.632926906573241243592065,0.00007},
	{0,0,8,-11,0,0,0,0,2,-1,0,1.621379982774971750814075,0.00116},
	{0,0,8,-11,0,0,0,0,2,0,-2,1.631332024702768723756208,0.00065},
	{0,0,8,-11,0,0,0,0,2,0,0,4.784224812534598747504333,0.00010},
	{0,0,8,-11,0,0,0,0,2,1,-2,1.632926906573241243592065,0.00007},
	{0,0,8,-11,0,0,0,0,2,1,0,4.772671431018097543130807,0.00001},
	{0,0,8,-11,0,0,0,0,4,-2,0,1.618575587732867360202249,0.00002},
	{0,0,8,-10,0,0,0,0,-2,0,0,1.931228808480300651595485,0.00007},
	{0,0,8,-10,0,0,0,0,-2,1,0,1.805114807389694542294478,0.00004},
	{0,0,8,-10,0,0,0,0,0,-2,0,5.274313266494607077561341,0.00001},
	{0,0,8,-10,0,0,0,0,0,-1,0,5.648770864983187145469401,0.00010},
	{0,0,8,-10,0,0,0,0,0,0,0,2.096496129746746373001542,0.00034},
	{0,0,8,-10,0,0,0,0,0,1,0,2.091160309157549246350527,0.00007},
	{0,0,8,-10,0,0,0,0,1,0,-1,3.622826005056882792132456,0.00003},
	{0,0,8,-10,0,0,0,0,2,-2,0,2.068553059356466938822905,0.00002},
	{0,0,8,-10,0,0,0,0,2,-1,0,2.113986946845607395317757,0.00078},
	{0,0,8,-10,0,0,0,0,2,0,-2,2.137018137121999394878458,0.00003},
	{0,0,8,-10,0,0,0,0,2,0,0,5.279286931264015159115388,0.00011},
	{0,0,8,-10,0,0,0,0,2,1,0,5.278228040006830212860223,0.00003},
	{0,0,8,-10,0,0,0,0,3,-3,0,5.284514541439587986815241,0.00002},
	{0,0,8,-10,0,0,0,0,3,-2,0,2.142922062382720760354005,0.00003},
	{0,0,8,-10,0,0,0,0,4,-2,0,2.135203692831626032244685,0.00001},
	{0,0,8,-10,0,0,0,0,4,0,0,2.137006094350160534389715,0.00002},
	{0,0,8,-9,0,0,0,0,-2,0,0,2.535412402702906131679583,0.00006},
	{0,0,8,-9,0,0,0,0,-2,1,0,2.524919657772841219411930,0.00002},
	{0,0,8,-9,0,0,0,0,0,-1,0,5.115979789280484801849980,0.00002},
	{0,0,8,-9,0,0,0,0,0,0,0,2.610299593984076960140328,0.00032},
	{0,0,8,-9,0,0,0,0,0,1,0,2.591997547848889471566736,0.00006},
	{0,0,8,-9,0,0,0,0,1,0,-1,4.239443150337770305213780,0.00002},
	{0,0,8,-9,0,0,0,0,2,-2,0,2.642122182235690175389209,0.00002},
	{0,0,8,-9,0,0,0,0,2,-1,0,2.642492890168813612916665,0.00059},
	{0,0,8,-9,0,0,0,0,2,0,-2,2.642139111929434402981087,0.00002},
	{0,0,8,-9,0,0,0,0,2,0,0,5.776547117653392682257163,0.00016},
	{0,0,8,-9,0,0,0,0,2,1,0,5.780689482100076048709525,0.00003},
	{0,0,8,-9,0,0,0,0,4,-2,0,2.616845800409532518671085,0.00001},
	{0,0,8,-9,0,0,0,0,4,-1,0,5.783543619025862447813324,0.00001},
	{0,0,8,-8,0,0,0,0,-2,0,0,2.786755522953357822046883,0.00002},
	{0,0,8,-8,0,0,0,0,0,-1,0,6.276738235455644243643292,0.00003},
	{0,0,8,-8,0,0,0,0,0,0,0,3.104827991028233480363951,0.00017},
	{0,0,8,-8,0,0,0,0,0,1,0,3.142543159900429206032868,0.00001},
	{0,0,8,-8,0,0,0,0,1,0,-1,4.961861805808704062314973,0.00001},
	{0,0,8,-8,0,0,0,0,2,-2,0,3.142662889487116029130220,0.00001},
	{0,0,8,-8,0,0,0,0,2,-1,0,3.138116830384446220847394,0.00025},
	{0,0,8,-8,0,0,0,0,2,0,0,0.001755277628730697245252,0.00011},
	{0,0,8,-8,0,0,0,0,2,1,0,0.001099557428756427635702,0.00003},
	{0,0,8,-7,-2,0,0,0,0,0,0,5.762230356332208813796569,0.00001},
	{0,0,8,-7,0,0,0,0,-2,0,0,0.799610554029363318484513,0.00001},
	{0,0,8,-7,0,0,0,0,0,0,0,0.854963845789288634513525,0.00002},
	{0,0,8,-7,0,0,0,0,0,1,0,0.533538600221331815731673,0.00001},
	{0,0,8,-7,0,0,0,0,2,-1,0,0.533682589884621361164818,0.00007},
	{0,0,8,-7,0,0,0,0,2,0,0,3.675359542877286056494768,0.00005},
	{0,0,9,-19,0,3,0,0,0,-2,0,3.040788021048207223628879,0.00001},
	{0,0,9,-19,0,3,0,0,0,-1,0,3.040784006790927307406491,0.00003},
	{0,0,9,-19,0,3,0,0,0,0,0,3.040785403054328650540583,0.00023},
	{0,0,9,-19,0,3,0,0,0,1,0,3.040784530389703199659834,0.00005},
	{0,0,9,-19,0,3,0,0,2,-1,0,3.040786275718954989599752,0.00024},
	{0,0,9,-19,0,3,0,0,2,0,0,3.040786101186029988241444,0.00019},
	{0,0,9,-19,0,3,0,0,2,1,0,3.040786275718954989599752,0.00002},
	{0,0,9,-17,0,0,0,0,-4,1,0,2.229135218778858451571523,0.00001},
	{0,0,9,-17,0,0,0,0,-2,-1,0,2.229135044245933006124005,0.00004},
	{0,0,9,-17,0,0,0,0,-2,0,0,2.226319828162466318843826,0.00038},
	{0,0,9,-17,0,0,0,0,-2,1,0,2.237649109403012204211336,0.00058},
	{0,0,9,-17,0,0,0,0,-2,2,0,2.228738330906955056320840,0.00002},
	{0,0,9,-17,0,0,0,0,0,-2,0,2.186643781875655001556424,0.00006},
	{0,0,9,-17,0,0,0,0,0,-1,0,2.183172147460513023986550,0.00077},
	{0,0,9,-17,0,0,0,0,0,0,0,2.207687216666950558163762,0.00407},
	{0,0,9,-17,0,0,0,0,0,1,0,2.184699310556007745276474,0.00078},
	{0,0,9,-17,0,0,0,0,0,2,0,2.186695443621514023391228,0.00006},
	{0,0,9,-17,0,0,0,0,2,-2,0,2.234972123396303356201997,0.00003},
	{0,0,9,-17,0,0,0,0,2,-1,0,2.243830716547725590004347,0.00061},
	{0,0,9,-17,0,0,0,0,2,0,0,2.231662804601596494791238,0.00040},
	{0,0,9,-17,0,0,0,0,2,1,0,2.234628293533660325920209,0.00004},
	{0,0,9,-17,0,0,0,0,4,-1,0,2.234628293533660325920209,0.00001},
	{0,0,9,-17,1,0,0,0,0,0,0,3.026948432744517969439357,0.00001},
	{0,0,9,-16,0,0,0,0,-2,0,0,2.735798541046280618616038,0.00003},
	{0,0,9,-16,0,0,0,0,-2,1,0,2.735800460908457854003473,0.00002},
	{0,0,9,-16,0,0,0,0,0,-1,0,2.733457181854729967085404,0.00002},
	{0,0,9,-16,0,0,0,0,0,0,0,2.699820672911520169634514,0.00012},
	{0,0,9,-16,0,0,0,0,0,1,0,2.733457181854729967085404,0.00002},
	{0,0,9,-16,0,0,0,0,2,-1,0,2.709851429188581573015426,0.00002},
	{0,0,9,-16,0,0,0,0,2,0,0,2.729269962446271069467230,0.00002},
	{0,0,9,-16,4,5,0,0,-4,0,0,2.613517282993053747475187,0.00003},
	{0,0,9,-16,4,5,0,0,-4,1,0,2.613517282993053747475187,0.00003},
	{0,0,9,-16,4,5,0,0,-4,2,0,2.613517282993053747475187,0.00002},
	{0,0,9,-16,4,5,0,0,-2,-1,0,2.613517282993053747475187,0.00010},
	{0,0,9,-16,4,5,0,0,-2,0,0,2.613517282993053747475187,0.00087},
	{0,0,9,-16,4,5,0,0,-2,0,2,2.613517282993053747475187,0.00001},
	{0,0,9,-16,4,5,0,0,-2,1,0,2.613517282993053747475187,0.00114},
	{0,0,9,-16,4,5,0,0,-2,2,0,2.613517282993053747475187,0.00006},
	{0,0,9,-16,4,5,0,0,0,-1,0,2.613517282993053747475187,0.00025},
	{0,0,9,-16,4,5,0,0,0,0,0,2.613517282993053747475187,0.00121},
	{0,0,9,-16,4,5,0,0,0,1,0,2.613517282993053747475187,0.00020},
	{0,0,9,-16,4,5,0,0,2,-2,0,2.613517282993053747475187,0.00001},
	{0,0,9,-16,4,5,0,0,2,-1,0,5.755109936582847751651570,0.00006},
	{0,0,9,-16,4,5,0,0,2,0,0,5.755109936582847751651570,0.00004},
	{0,0,9,-16,4,5,0,0,2,1,0,5.755109936582847751651570,0.00002},
	{0,0,9,-15,0,0,0,0,-4,1,0,0.379722209644295927155611,0.00002},
	{0,0,9,-15,0,0,0,0,-2,-1,0,0.374531251383014407441152,0.00007},
	{0,0,9,-15,0,0,0,0,-2,0,0,0.409746236101728333878214,0.00067},
	{0,0,9,-15,0,0,0,0,-2,1,0,0.377483301279837590858079,0.00081},
	{0,0,9,-15,0,0,0,0,-2,2,0,0.391670908236374293309723,0.00004},
	{0,0,9,-15,0,0,0,0,0,-2,0,0.236958989220140137099690,0.00002},
	{0,0,9,-15,0,0,0,0,0,-1,0,0.263590270144620830716775,0.00052},
	{0,0,9,-15,0,0,0,0,0,0,0,0.215520935484968589879173,0.00209},
	{0,0,9,-15,0,0,0,0,0,1,0,0.169545123263083546971686,0.00031},
	{0,0,9,-15,0,0,0,0,0,2,0,0.158724954565344716916897,0.00001},
	{0,0,9,-15,0,0,0,0,1,-1,-1,4.678891574182863166697643,0.00002},
	{0,0,9,-15,0,0,0,0,1,0,-1,4.674015298785716865381801,0.00017},
	{0,0,9,-15,0,0,0,0,1,0,0,3.344541982472646779456227,0.00004},
	{0,0,9,-15,0,0,0,0,1,0,1,4.671867322075286210747436,0.00004},
	{0,0,9,-15,0,0,0,0,1,1,-1,4.678891574182863166697643,0.00002},
	{0,0,9,-15,0,0,0,0,2,-1,0,5.842794056472566666116109,0.00002},
	{0,0,9,-15,0,0,0,0,2,0,0,6.197437455562030628186676,0.00004},
	{0,0,9,-14,0,0,0,0,-2,0,0,0.707316146920501598316378,0.00004},
	{0,0,9,-14,0,0,0,0,-2,1,0,0.707315099722950368921204,0.00004},
	{0,0,9,-14,0,0,0,0,0,-1,0,0.634904879716209569195939,0.00012},
	{0,0,9,-14,0,0,0,0,0,0,0,0.651428086277765161504760,0.00014},
	{0,0,9,-14,0,0,0,0,0,1,0,0.657909017389195716063455,0.00003},
	{0,0,9,-14,0,0,0,0,1,0,-1,2.030507848722718389211650,0.00002},
	{0,0,9,-14,0,0,0,0,2,-2,0,3.754262736767295827178259,0.00005},
	{0,0,9,-14,0,0,0,0,2,-1,0,3.767808237092023837533361,0.00044},
	{0,0,9,-14,0,0,0,0,2,0,0,3.764916924653170404724278,0.00006},
	{0,0,9,-13,0,0,0,0,-2,0,0,6.266600141429584880370385,0.00003},
	{0,0,9,-13,0,0,0,0,0,-1,0,4.286042743234317775602449,0.00012},
	{0,0,9,-13,0,0,0,0,0,0,-2,1.130493564280952156764215,0.00001},
	{0,0,9,-13,0,0,0,0,0,0,0,0.941032488923361443156068,0.00012},
	{0,0,9,-13,0,0,0,0,0,1,-2,4.268131476318651529311410,0.00002},
	{0,0,9,-13,0,0,0,0,0,1,0,0.999543953964770581777088,0.00003},
	{0,0,9,-13,0,0,0,0,1,0,-1,2.550240894560775295474286,0.00002},
	{0,0,9,-13,0,0,0,0,2,-2,-2,1.127813087615739506830437,0.00001},
	{0,0,9,-13,0,0,0,0,2,-1,-2,1.128466189821835774509395,0.00021},
	{0,0,9,-13,0,0,0,0,2,-1,0,1.115251778456211040335688,0.00068},
	{0,0,9,-13,0,0,0,0,2,0,-2,1.130493564280952156764215,0.00095},
	{0,0,9,-13,0,0,0,0,2,0,0,1.120589344374659956926621,0.00007},
	{0,0,9,-13,0,0,0,0,2,1,-2,1.128466189821835774509395,0.00021},
	{0,0,9,-13,0,0,0,0,2,2,-2,1.127813087615739506830437,0.00001},
	{0,0,9,-13,0,0,0,0,4,-1,-2,4.268131476318651529311410,0.00002},
	{0,0,9,-13,0,0,0,0,4,0,-2,1.130493564280952156764215,0.00001},
	{0,0,9,-12,0,0,0,0,-2,0,0,1.428459490307003143527709,0.00004},
	{0,0,9,-12,0,0,0,0,-2,1,0,1.426664768237177360887813,0.00001},
	{0,0,9,-12,0,0,0,0,0,-1,0,4.772976689104271308394800,0.00007},
	{0,0,9,-12,0,0,0,0,0,0,0,1.593094304252525850174038,0.00019},
	{0,0,9,-12,0,0,0,0,0,1,0,1.628843708788200395076728,0.00003},
	{0,0,9,-12,0,0,0,0,1,0,-1,3.081771668010612419408289,0.00002},
	{0,0,9,-12,0,0,0,0,2,-2,0,1.630445746508605964208982,0.00001},
	{0,0,9,-12,0,0,0,0,2,-1,0,1.630604396937612277085350,0.00048},
	{0,0,9,-12,0,0,0,0,2,0,-2,1.630705975100078308770435,0.00002},
	{0,0,9,-12,0,0,0,0,2,0,0,4.772044159684930342280040,0.00007},
	{0,0,9,-12,0,0,0,0,2,1,0,4.772178200971484152148605,0.00001},
	{0,0,9,-12,2,0,0,0,2,-3,0,2.634220727646061188664817,0.00001},
	{0,0,9,-12,2,0,0,0,2,-1,0,5.775813381235854748751990,0.00001},
	{0,0,9,-11,-2,0,0,0,0,0,0,4.047608601730392052786556,0.00001},
	{0,0,9,-11,0,0,0,0,-2,0,0,2.067352098298169238432820,0.00005},
	{0,0,9,-11,0,0,0,0,0,-1,0,5.300463360144313185173814,0.00004},
	{0,0,9,-11,0,0,0,0,0,0,0,2.105626121596853916884129,0.00022},
	{0,0,9,-11,0,0,0,0,0,1,0,2.115599282008600034998835,0.00004},
	{0,0,9,-11,0,0,0,0,1,0,-1,3.640164629444969879301652,0.00002},
	{0,0,9,-11,0,0,0,0,2,-2,0,2.135918754226168392307272,0.00002},
	{0,0,9,-11,0,0,0,0,2,-1,0,2.135877913521671445096217,0.00044},
	{0,0,9,-11,0,0,0,0,2,0,-2,2.135928702602904571961062,0.00001},
	{0,0,9,-11,0,0,0,0,2,0,0,5.264146200002964626207813,0.00011},
	{0,0,9,-11,0,0,0,0,2,1,0,5.273248266585039978338045,0.00002},
	{0,0,9,-10,-2,0,0,0,0,0,0,4.753582241390260421098901,0.00001},
	{0,0,9,-10,0,0,0,0,-2,0,0,2.521401597599596478005424,0.00005},
	{0,0,9,-10,0,0,0,0,0,-1,0,5.844927721483128557622422,0.00001},
	{0,0,9,-10,0,0,0,0,0,0,0,2.613332627158193144367715,0.00018},
	{0,0,9,-10,0,0,0,0,0,1,0,2.574208803046712290552023,0.00003},
	{0,0,9,-10,0,0,0,0,1,0,-1,4.265117990832157701674987,0.00001},
	{0,0,9,-10,0,0,0,0,2,-2,0,2.639348330455495439395008,0.00002},
	{0,0,9,-10,0,0,0,0,2,-1,0,2.639024048280474765704184,0.00034},
	{0,0,9,-10,0,0,0,0,2,0,-2,2.639406449919587061003767,0.00001},
	{0,0,9,-10,0,0,0,0,2,0,0,5.807474351998732409185777,0.00013},
	{0,0,9,-10,0,0,0,0,2,1,0,5.788983286705552622208870,0.00003},
	{0,0,9,-10,0,0,0,0,4,0,0,2.639405053656184829691256,0.00002},
	{0,0,9,-9,-2,0,0,0,0,0,0,5.257253022122212904321259,0.00001},
	{0,0,9,-9,-1,0,0,0,0,0,0,2.565031512773876087862845,0.00001},
	{0,0,9,-9,0,0,0,0,-2,0,0,2.689931986435570632210101,0.00002},
	{0,0,9,-9,0,0,0,0,0,-1,0,6.273856871393527434577209,0.00001},
	{0,0,9,-9,0,0,0,0,0,0,0,3.065779914206289369360547,0.00008},
	{0,0,9,-9,0,0,0,0,2,-1,0,3.132341361356672404525625,0.00012},
	{0,0,9,-9,0,0,0,0,2,0,0,6.273904867947956986995450,0.00008},
	{0,0,9,-9,0,0,0,0,2,1,-4,3.258021299062307640781455,0.00002},
	{0,0,9,-9,0,0,0,0,4,-1,-4,0.076978793856761110192544,0.00008},
	{0,0,9,-9,0,0,0,0,4,0,-4,3.365078050050387403757668,0.00053},
	{0,0,9,-9,0,0,0,0,4,1,-4,0.076978793856761110192544,0.00008},
	{0,0,9,-9,0,0,0,0,6,-1,-4,3.258021299062307640781455,0.00002},
	{0,0,9,-8,0,0,0,0,2,-1,0,0.541513882238319865791709,0.00005},
	{0,0,9,-8,0,0,0,0,2,0,0,3.683182457650574725960269,0.00004},
	{0,0,9,-7,0,0,0,0,2,0,0,1.042293699597269140966205,0.00001},
	{0,0,10,-21,2,0,0,0,0,0,0,4.016738614184518496585952,0.00001},
	{0,0,10,-21,2,0,0,0,2,0,0,4.031092725551695288288556,0.00001},
	{0,0,10,-19,0,0,0,0,-2,0,0,1.720231766416501661964844,0.00002},
	{0,0,10,-19,0,0,0,0,-2,1,0,1.720232988146977781696023,0.00003},
	{0,0,10,-19,0,0,0,0,0,-1,0,1.715797757451809957274236,0.00004},
	{0,0,10,-19,0,0,0,0,0,0,0,1.710772780002393078646605,0.00023},
	{0,0,10,-19,0,0,0,0,0,1,0,1.715797757451809957274236,0.00004},
	{0,0,10,-19,0,0,0,0,2,-1,0,1.738203945323062882266640,0.00003},
	{0,0,10,-19,0,0,0,0,2,0,0,1.738203945323062882266640,0.00002},
	{0,0,10,-19,0,3,0,0,-4,0,0,1.244198972521579849015438,0.00003},
	{0,0,10,-19,0,3,0,0,-4,1,0,1.244198972521579849015438,0.00006},
	{0,0,10,-19,0,3,0,0,-4,2,0,1.244198972521579849015438,0.00005},
	{0,0,10,-19,0,3,0,0,-2,-2,0,1.244198972521579849015438,0.00002},
	{0,0,10,-19,0,3,0,0,-2,-1,0,1.244198972521579849015438,0.00013},
	{0,0,10,-19,0,3,0,0,-2,0,0,1.244198972521579849015438,0.00173},
	{0,0,10,-19,0,3,0,0,-2,0,2,1.244198972521579849015438,0.00005},
	{0,0,10,-19,0,3,0,0,-2,1,0,1.244198972521579849015438,0.00340},
	{0,0,10,-19,0,3,0,0,-2,2,0,1.244199147054505072418351,0.00016},
	{0,0,10,-19,0,3,0,0,-1,0,0,4.385792324243073636580448,0.00006},
	{0,0,10,-19,0,3,0,0,0,-2,0,4.385789880782120953028880,0.00003},
	{0,0,10,-19,0,3,0,0,0,-1,0,4.385789706249195951670572,0.00039},
	{0,0,10,-19,0,3,0,0,0,0,0,4.385790927979671849357146,0.00038},
	{0,0,10,-19,0,3,0,0,0,1,0,4.385792149710148635222140,0.00039},
	{0,0,10,-19,0,3,0,0,0,2,0,4.385791975177223633863832,0.00003},
	{0,0,10,-19,0,3,0,0,1,0,0,4.385789531716270062133844,0.00006},
	{0,0,10,-19,0,3,0,0,2,-2,0,1.244197576258178283836742,0.00016},
	{0,0,10,-19,0,3,0,0,2,-1,0,1.244197576258178283836742,0.00340},
	{0,0,10,-19,0,3,0,0,2,0,-2,1.244197576258178283836742,0.00005},
	{0,0,10,-19,0,3,0,0,2,0,0,1.244197576258178283836742,0.00173},
	{0,0,10,-19,0,3,0,0,2,1,0,1.244197576258178283836742,0.00013},
	{0,0,10,-19,0,3,0,0,2,2,0,1.244197576258178283836742,0.00002},
	{0,0,10,-19,0,3,0,0,4,-2,0,1.244197576258178283836742,0.00005},
	{0,0,10,-19,0,3,0,0,4,-1,0,1.244197576258178283836742,0.00006},
	{0,0,10,-19,0,3,0,0,4,0,0,1.244197576258178283836742,0.00003},
	{0,0,10,-19,1,0,0,0,0,0,0,5.040800953481305413106384,0.00001},
	{0,0,10,-18,0,0,0,0,-2,0,0,2.230640914324554024972258,0.00001},
	{0,0,10,-18,0,0,0,0,0,0,0,2.191391426506930084627811,0.00006},
	{0,0,10,-17,0,0,0,0,-2,-1,0,2.481870762706550603837741,0.00002},
	{0,0,10,-17,0,0,0,0,-2,0,0,2.481870064574850154315300,0.00010},
	{0,0,10,-17,0,0,0,0,-2,1,0,2.465145447017614621643133,0.00012},
	{0,0,10,-17,0,0,0,0,0,-1,0,2.619145969830735776184838,0.00011},
	{0,0,10,-17,0,0,0,0,0,0,0,2.657879363788544946345382,0.00048},
	{0,0,10,-17,0,0,0,0,0,1,0,2.668710877126421632254960,0.00008},
	{0,0,10,-17,0,0,0,0,1,0,-1,4.155627378202171762211492,0.00003},
	{0,0,10,-17,0,0,0,0,2,-3,0,2.647352410405141132088147,0.00001},
	{0,0,10,-17,0,0,0,0,2,-1,0,2.848894654845036900070454,0.00003},
	{0,0,10,-17,0,0,0,0,2,0,0,2.802028550171709486704685,0.00002},
	{0,0,10,-16,0,0,0,0,-2,0,0,0.187983828678702863390626,0.00002},
	{0,0,10,-16,0,0,0,0,0,-1,0,0.115678677492932174830642,0.00003},
	{0,0,10,-16,0,0,0,0,0,0,0,0.143554029108234393330434,0.00007},
	{0,0,10,-16,0,0,0,0,1,0,-1,1.376961281798882774651815,0.00001},
	{0,0,10,-16,0,0,0,0,2,-2,0,3.206369501580011771579848,0.00001},
	{0,0,10,-16,0,0,0,0,2,-1,0,3.257271331082725485117635,0.00014},
	{0,0,10,-16,0,0,0,0,2,0,0,3.257207277499177155988264,0.00001},
	{0,0,10,-16,4,5,0,0,-2,0,0,0.816928932598127377495700,0.00008},
	{0,0,10,-16,4,5,0,0,-2,1,0,0.816928932598127377495700,0.00006},
	{0,0,10,-16,4,5,0,0,0,0,0,0.816928932598127377495700,0.00003},
	{0,0,10,-15,-3,0,0,0,2,-2,0,2.912387638637488507242779,0.00002},
	{0,0,10,-15,-3,0,0,0,2,-1,0,3.369626029015234447427929,0.00003},
	{0,0,10,-15,0,0,0,0,-2,0,0,5.047270889018448336571510,0.00006},
	{0,0,10,-15,0,0,0,0,-2,1,0,5.046498231758590691242716,0.00005},
	{0,0,10,-15,0,0,0,0,0,-1,0,3.860271941138329054865608,0.00007},
	{0,0,10,-15,0,0,0,0,0,0,0,6.081122780089670776249022,0.00005},
	{0,0,10,-15,0,0,0,0,0,1,0,6.001928639813353782983540,0.00001},
	{0,0,10,-15,0,0,0,0,1,0,-1,2.035608049862896340442830,0.00001},
	{0,0,10,-15,0,0,0,0,2,-1,0,0.563197678332172269044520,0.00038},
	{0,0,10,-15,1,0,0,0,2,-1,-2,4.336659036871405525914724,0.00004},
	{0,0,10,-15,1,0,0,0,2,0,-2,4.292996484040114246738540,0.00021},
	{0,0,10,-15,1,0,0,0,2,1,-2,4.336659036871405525914724,0.00004},
	{0,0,10,-14,0,0,0,0,-2,0,0,0.930573254314935094377859,0.00002},
	{0,0,10,-14,0,0,0,0,0,-1,0,4.266063610220888868695965,0.00004},
	{0,0,10,-14,0,0,0,0,0,0,0,1.095294636591356729482527,0.00008},
	{0,0,10,-14,0,0,0,0,0,1,0,1.125243788423878621429708,0.00002},
	{0,0,10,-14,0,0,0,0,1,0,-1,2.557710903759311094063378,0.00001},
	{0,0,10,-14,0,0,0,0,2,-2,0,1.125009216172410564382744,0.00001},
	{0,0,10,-14,0,0,0,0,2,-1,0,1.124754921700394927341904,0.00026},
	{0,0,10,-14,0,0,0,0,2,0,-2,1.124677080015755947783873,0.00001},
	{0,0,10,-14,0,0,0,0,2,0,0,4.266251756714253495772482,0.00004},
	{0,0,10,-13,0,0,0,0,-2,0,0,1.597575088041170987551709,0.00002},
	{0,0,10,-13,0,0,0,0,0,-1,0,4.772608424632100110329702,0.00003},
	{0,0,10,-13,0,0,0,0,0,0,0,1.614969039366546343927666,0.00011},
	{0,0,10,-13,0,0,0,0,0,1,0,1.627955510731860400142068,0.00002},
	{0,0,10,-13,0,0,0,0,1,0,-1,3.093001290950869730522754,0.00001},
	{0,0,10,-13,0,0,0,0,2,-2,0,1.629845004180069611976478,0.00001},
	{0,0,10,-13,0,0,0,0,2,-1,0,1.629708170366713115839730,0.00029},
	{0,0,10,-13,0,0,0,0,2,0,0,4.771178650908867169277983,0.00008},
	{0,0,10,-13,0,0,0,0,2,1,0,4.771307805273514723864992,0.00001},
	{0,0,10,-12,0,0,0,0,-2,0,0,2.077536792615257255079086,0.00003},
	{0,0,10,-12,0,0,0,0,0,-1,0,5.294563100075020400936410,0.00003},
	{0,0,10,-12,0,0,0,0,0,0,0,2.100929615112661963394203,0.00014},
	{0,0,10,-12,0,0,0,0,0,1,0,2.128674939698691037648359,0.00002},
	{0,0,10,-12,0,0,0,0,1,0,-1,3.657705712026288580318578,0.00001},
	{0,0,10,-12,0,0,0,0,2,-2,0,2.134170632447370596906921,0.00002},
	{0,0,10,-12,0,0,0,0,2,-1,0,2.142036482320258894418430,0.00027},
	{0,0,10,-12,0,0,0,0,2,0,0,5.274926924259608185252546,0.00010},
	{0,0,10,-12,0,0,0,0,2,1,0,5.275768871090770417708882,0.00003},
	{0,0,10,-11,-2,0,0,0,0,0,0,4.748912263910698428048818,0.00002},
	{0,0,10,-11,-1,0,0,0,0,0,0,2.065502049291055186586163,0.00001},
	{0,0,10,-11,0,0,0,0,-2,0,0,2.433795319394516987188126,0.00002},
	{0,0,10,-11,0,0,0,0,0,-1,0,5.817498999623412991866189,0.00002},
	{0,0,10,-11,0,0,0,0,0,0,0,2.598228373278509195642982,0.00011},
	{0,0,10,-11,0,0,0,0,0,1,0,2.625924479579631043435484,0.00002},
	{0,0,10,-11,0,0,0,0,2,-2,0,2.635370725090200316742539,0.00001},
	{0,0,10,-11,0,0,0,0,2,-1,0,2.649973894941636931577023,0.00021},
	{0,0,10,-11,0,0,0,0,2,0,0,5.775781267177617195329731,0.00009},
	{0,0,10,-11,0,0,0,0,2,1,0,5.776974897853056845065112,0.00003},
	{0,0,10,-10,0,0,0,0,0,-1,0,3.115228582573792870391571,0.00001},
	{0,0,10,-10,0,0,0,0,0,0,0,3.060736261733876251156516,0.00003},
	{0,0,10,-10,0,0,0,0,0,1,0,3.115228582573792870391571,0.00001},
	{0,0,10,-10,0,0,0,0,2,-1,0,3.115163656325618646292241,0.00006},
	{0,0,10,-10,0,0,0,0,2,0,0,6.256715643743840260526667,0.00005},
	{0,0,10,-9,0,0,0,0,2,-1,0,0.545789589839855593389473,0.00004},
	{0,0,10,-9,0,0,0,0,2,0,0,3.687452405665579302507240,0.00003},
	{0,0,11,-21,0,0,0,0,0,-1,1,0.140093564800305270257041,0.00001},
	{0,0,11,-21,0,0,0,0,0,0,0,1.157906054578625720807850,0.00003},
	{0,0,11,-21,2,0,0,0,-2,0,0,2.236402246185387632237962,0.00011},
	{0,0,11,-21,2,0,0,0,-2,1,0,2.259976233859149363780716,0.00016},
	{0,0,11,-21,2,0,0,0,0,-2,0,2.144851698403725581698609,0.00001},
	{0,0,11,-21,2,0,0,0,0,-1,0,2.155845876427888274662337,0.00024},
	{0,0,11,-21,2,0,0,0,0,0,0,2.205053340292765895469529,0.00118},
	{0,0,11,-21,2,0,0,0,0,1,0,2.155688273196433080158840,0.00024},
	{0,0,11,-21,2,0,0,0,0,2,0,2.144880496336383668420922,0.00001},
	{0,0,11,-21,2,0,0,0,2,-1,0,2.259426978743547032024708,0.00016},
	{0,0,11,-21,2,0,0,0,2,0,0,2.235898369630336723901110,0.00011},
	{0,0,11,-20,0,0,0,0,0,0,0,1.699387124627008027744068,0.00003},
	{0,0,11,-19,0,0,0,0,-2,0,0,2.161359895133713848736079,0.00002},
	{0,0,11,-19,0,0,0,0,-2,1,0,2.161360593265414742347730,0.00002},
	{0,0,11,-19,0,0,0,0,0,0,0,2.215273290260743710433644,0.00008},
	{0,0,11,-19,0,0,0,0,1,-1,0,2.252059071306252935329439,0.00004},
	{0,0,11,-19,0,3,0,0,-2,-1,0,5.730795754773314598651268,0.00003},
	{0,0,11,-19,0,3,0,0,-2,0,0,5.730795754773314598651268,0.00017},
	{0,0,11,-19,0,3,0,0,-2,1,0,5.730795754773314598651268,0.00023},
	{0,0,11,-19,0,3,0,0,0,-1,0,5.730797151036715497696150,0.00006},
	{0,0,11,-19,0,3,0,0,0,0,0,5.730796452905015492262919,0.00024},
	{0,0,11,-19,0,3,0,0,0,1,0,5.730797674635491389949493,0.00003},
	{0,0,11,-18,0,0,0,0,-2,0,0,5.956512554682583449050526,0.00002},
	{0,0,11,-18,0,0,0,0,0,0,0,5.925698941271548392251134,0.00003},
	{0,0,11,-18,0,0,0,0,2,-1,0,2.752453869032212452339081,0.00005},
	{0,0,11,-17,0,0,0,0,-2,0,0,0.524306157544132123149438,0.00002},
	{0,0,11,-17,0,0,0,0,0,-1,0,3.252408320187893497887899,0.00005},
	{0,0,11,-17,0,0,0,0,0,0,0,0.335789828910645793413892,0.00004},
	{0,0,11,-17,0,0,0,0,2,-1,0,0.110815317532249962839686,0.00023},
	{0,0,11,-17,0,0,0,0,2,0,0,3.256109465399672497909478,0.00002},
	{0,0,11,-16,0,0,0,0,0,-1,0,3.759571155687236654330263,0.00002},
	{0,0,11,-16,0,0,0,0,0,0,0,0.593392572523374961512843,0.00004},
	{0,0,11,-16,0,0,0,0,0,1,0,0.621335817446579730116696,0.00001},
	{0,0,11,-16,0,0,0,0,2,-1,0,0.619140018714645745667724,0.00013},
	{0,0,11,-16,0,0,0,0,2,0,0,3.760631792273673834614556,0.00004},
	{0,0,11,-15,0,0,0,0,-2,0,0,1.355416588446414438706711,0.00002},
	{0,0,11,-15,0,0,0,0,0,-1,0,4.265456061108269025794471,0.00002},
	{0,0,11,-15,0,0,0,0,0,0,0,1.162871341767624189245112,0.00005},
	{0,0,11,-15,0,0,0,0,0,1,0,1.123975806722304682239155,0.00002},
	{0,0,11,-15,0,0,0,0,2,-1,0,1.114131626142281117353150,0.00015},
	{0,0,11,-15,0,0,0,0,2,0,0,4.265444716468131503006589,0.00005},
	{0,0,11,-14,0,0,0,0,-2,0,0,1.469347144160548790381426,0.00003},
	{0,0,11,-14,0,0,0,0,0,-1,0,4.772017107081524933676064,0.00002},
	{0,0,11,-14,0,0,0,0,0,0,0,1.600079984583633097017241,0.00007},
	{0,0,11,-14,0,0,0,0,0,1,0,1.507500565207920528720820,0.00001},
	{0,0,11,-14,0,0,0,0,1,0,-1,3.104573871089143288770629,0.00001},
	{0,0,11,-14,0,0,0,0,2,-1,0,1.628362172447575195732838,0.00018},
	{0,0,11,-14,0,0,0,0,2,0,0,4.769876809819804108769858,0.00009},
	{0,0,11,-14,0,0,0,0,4,-4,0,4.770144543327059949433533,0.00001},
	{0,0,11,-13,0,0,0,0,-2,0,0,2.005397273175500760800105,0.00003},
	{0,0,11,-13,0,0,0,0,0,-1,0,5.273265021745858760482406,0.00002},
	{0,0,11,-13,0,0,0,0,0,0,0,2.095453819117455207532430,0.00009},
	{0,0,11,-13,0,0,0,0,0,1,0,2.131664339641506700218088,0.00001},
	{0,0,11,-13,0,0,0,0,2,-2,0,2.131678127742597794735957,0.00001},
	{0,0,11,-13,0,0,0,0,2,-1,0,2.131684585460829950420703,0.00017},
	{0,0,11,-13,0,0,0,0,2,0,0,5.273920392879983154443835,0.00008},
	{0,0,11,-13,0,0,0,0,2,1,0,5.273276889984772175523631,0.00002},
	{0,0,11,-12,0,0,0,0,-2,0,0,2.441084163416695762549580,0.00002},
	{0,0,11,-12,0,0,0,0,0,-1,0,5.525103815503877413561895,0.00001},
	{0,0,11,-12,0,0,0,0,0,0,0,2.580894635812327031487712,0.00006},
	{0,0,11,-12,0,0,0,0,2,-1,0,2.629840125756480517793534,0.00012},
	{0,0,11,-12,0,0,0,0,2,0,0,5.771421609239060224183504,0.00009},
	{0,0,11,-12,0,0,0,0,2,1,0,5.771431732148722737463231,0.00002},
	{0,0,11,-11,0,0,0,0,0,0,0,2.946111937642073907994700,0.00001},
	{0,0,11,-11,0,0,0,0,2,-1,0,3.084847985350178234398300,0.00003},
	{0,0,11,-11,0,0,0,0,2,0,0,6.226407826750033791540773,0.00004},
	{0,0,11,-10,0,0,0,0,2,-1,0,0.508659280800002999711751,0.00003},
	{0,0,11,-10,0,0,0,0,2,0,0,3.688791771333559399437263,0.00004},
	{0,0,12,-22,0,0,0,0,0,0,0,1.193422457659158997245186,0.00002},
	{0,0,12,-21,0,0,0,0,0,0,0,1.712391572883617651967825,0.00002},
	{0,0,12,-21,2,0,0,0,-2,0,0,0.220345723669181703385789,0.00002},
	{0,0,12,-21,2,0,0,0,0,0,0,6.246877222750347513624547,0.00002},
	{0,0,12,-20,0,0,0,0,0,0,0,5.411810654032571221705439,0.00001},
	{0,0,12,-20,0,0,0,0,2,-1,0,2.178758035249294344737336,0.00002},
	{0,0,12,-19,0,0,0,0,0,-1,0,2.751058827361092973262657,0.00003},
	{0,0,12,-19,0,0,0,0,2,-2,0,2.750376403623563170697253,0.00001},
	{0,0,12,-19,0,0,0,0,2,-1,0,5.892651480950886089260621,0.00015},
	{0,0,12,-19,0,3,0,0,-2,0,0,3.934207229845462450157356,0.00001},
	{0,0,12,-18,0,0,0,0,0,0,0,0.135592884258187468260459,0.00001},
	{0,0,12,-18,0,0,0,0,2,-1,0,0.099270313596157885860372,0.00008},
	{0,0,12,-18,0,0,0,0,2,0,0,3.254992105612545927328938,0.00002},
	{0,0,12,-17,0,0,0,0,0,0,0,0.688722630800230439795939,0.00002},
	{0,0,12,-17,0,0,0,0,0,1,0,0.557045916317667755279786,0.00001},
	{0,0,12,-17,0,0,0,0,2,-1,0,0.618265434226471288781113,0.00008},
	{0,0,12,-17,0,0,0,0,2,0,0,3.759773788413393269536300,0.00004},
	{0,0,12,-16,0,0,0,0,0,-1,0,4.264742046911278450238569,0.00001},
	{0,0,12,-16,0,0,0,0,0,0,0,1.111557614561439866207593,0.00003},
	{0,0,12,-16,0,0,0,0,0,1,0,1.122503097899471891096823,0.00001},
	{0,0,12,-16,0,0,0,0,2,-1,0,1.122783746843192487219198,0.00010},
	{0,0,12,-16,0,0,0,0,2,0,0,4.264307285394606239492532,0.00005},
	{0,0,12,-15,0,0,0,0,0,-1,0,4.771016684354282055835483,0.00001},
	{0,0,12,-15,0,0,0,0,0,0,0,1.598883561381390983058282,0.00003},
	{0,0,12,-15,0,0,0,0,0,1,0,1.467395866056819375700115,0.00001},
	{0,0,12,-15,0,0,0,0,2,-1,0,1.626517359428217179839748,0.00012},
	{0,0,12,-15,0,0,0,0,2,0,0,4.791033341946628887342285,0.00007},
	{0,0,12,-14,0,0,0,0,0,-1,0,5.269945580041491162148759,0.00001},
	{0,0,12,-14,0,0,0,0,0,0,0,2.092526378363085193257120,0.00005},
	{0,0,12,-14,0,0,0,0,2,-1,0,2.128369158013741380131023,0.00011},
	{0,0,12,-14,0,0,0,0,2,0,0,5.269956052017002789966682,0.00009},
	{0,0,12,-14,0,0,0,0,2,1,0,5.269961288004759936143273,0.00002},
	{0,0,12,-13,0,0,0,0,0,0,0,2.545772851675669912197009,0.00002},
	{0,0,12,-13,0,0,0,0,2,-1,0,2.622424047231831423232506,0.00008},
	{0,0,12,-13,0,0,0,0,2,0,0,5.764002738187609331532713,0.00007},
	{0,0,12,-12,0,0,0,0,2,0,0,6.163427969757669266925859,0.00002},
	{0,0,12,-11,0,0,0,0,2,-1,0,0.546764705292944852565995,0.00002},
	{0,0,12,-11,0,0,0,0,2,0,0,3.687518204578379421576528,0.00003},
	{0,0,13,-21,0,0,0,0,0,-1,0,2.238622654059774674806249,0.00003},
	{0,0,13,-21,0,0,0,0,2,-2,0,2.245771697208868378226043,0.00003},
	{0,0,13,-21,0,0,0,0,2,-1,0,5.380216005781268684415863,0.00013},
	{0,0,13,-20,0,0,0,0,2,-1,0,5.865374951801944014562196,0.00004},
	{0,0,13,-20,0,0,0,0,2,0,0,2.749329031539441636766696,0.00002},
	{0,0,13,-19,0,0,0,0,2,-1,0,0.112701494854880249207874,0.00005},
	{0,0,13,-19,0,0,0,0,2,0,0,3.253954332839310126246346,0.00002},
	{0,0,13,-18,0,0,0,0,0,0,0,0.620026296908808394192647,0.00001},
	{0,0,13,-18,0,0,0,0,2,-1,0,0.617208113765613131107557,0.00006},
	{0,0,13,-18,0,0,0,0,2,0,0,3.758726590862196736964052,0.00003},
	{0,0,13,-17,0,0,0,0,0,0,0,1.105038984338166274667969,0.00002},
	{0,0,13,-17,0,0,0,0,0,1,0,1.120743980546386797669811,0.00001},
	{0,0,13,-17,0,0,0,0,2,-1,0,1.121288872338859432531422,0.00007},
	{0,0,13,-17,0,0,0,0,2,0,0,4.262815727015852651504701,0.00004},
	{0,0,13,-16,0,0,0,0,0,0,0,1.589643439255482570970912,0.00002},
	{0,0,13,-16,0,0,0,0,0,1,0,1.861265365551930894838506,0.00002},
	{0,0,13,-16,0,0,0,0,2,-1,0,1.624359783406901902580444,0.00008},
	{0,0,13,-16,0,0,0,0,2,0,0,4.765948771805265771206450,0.00006},
	{0,0,13,-15,0,0,0,0,0,0,0,2.067592953734944671850826,0.00002},
	{0,0,13,-15,0,0,0,0,2,-1,0,2.124130974991123466111276,0.00008},
	{0,0,13,-15,0,0,0,0,2,0,0,5.265716821796834423707878,0.00006},
	{0,0,13,-14,0,0,0,0,0,0,0,2.516810159936374802214232,0.00001},
	{0,0,13,-14,0,0,0,0,2,-1,0,2.612612155242969969037858,0.00004},
	{0,0,13,-14,0,0,0,0,2,0,0,5.754188402737794305608077,0.00004},
	{0,0,13,-12,0,0,0,0,2,-1,0,0.541969238640165218434674,0.00002},
	{0,0,13,-12,0,0,0,0,2,0,0,3.683583010713907590627514,0.00002},
	{0,0,13,-11,0,0,0,0,2,0,0,1.115354752882078637199470,0.00002},
	{0,0,14,-23,0,0,0,0,0,-3,0,1.722013922115712913907259,0.00001},
	{0,0,14,-23,0,0,0,0,0,-2,0,1.721366579496148130346000,0.00007},
	{0,0,14,-23,0,0,0,0,0,-1,0,4.863761211877233314737623,0.00015},
	{0,0,14,-23,0,0,0,0,0,0,0,4.863704139610692145367921,0.00002},
	{0,0,14,-23,0,0,0,0,2,-4,0,1.707967337762737347617303,0.00002},
	{0,0,14,-23,0,0,0,0,2,-3,0,1.707940110626406271521205,0.00025},
	{0,0,14,-23,0,0,0,0,2,-2,-2,4.863606575705506251949828,0.00002},
	{0,0,14,-23,0,0,0,0,2,-2,0,1.722013922115712913907259,0.00800},
	{0,0,14,-23,0,0,0,0,2,-2,2,4.863606575705506251949828,0.00002},
	{0,0,14,-23,0,0,0,0,2,-1,0,1.722084782483343845527202,0.00162},
	{0,0,14,-23,0,0,0,0,2,0,0,1.722084084351642951915551,0.00011},
	{0,0,14,-23,0,0,0,0,4,-3,0,1.727648717605776651495830,0.00013},
	{0,0,14,-23,0,0,0,0,4,-2,0,1.722449032698235127369912,0.00011},
	{0,0,14,-23,0,0,0,0,4,-1,0,1.722013922115712913907259,0.00001},
	{0,0,14,-23,4,0,0,0,2,0,-2,1.226689305866796919630701,0.00007},
	{0,0,14,-22,0,0,0,0,2,-1,0,5.346796615797006602122110,0.00002},
	{0,0,14,-21,0,0,0,0,2,-1,0,5.890469819385892868979226,0.00002},
	{0,0,14,-21,0,0,0,0,2,0,0,2.748376430833703309986049,0.00002},
	{0,0,14,-21,0,0,0,0,3,-2,-1,4.159615281010053067234367,0.00002},
	{0,0,14,-20,0,0,0,0,2,-1,0,0.111648188651301660812010,0.00003},
	{0,0,14,-20,0,0,0,0,2,0,0,3.252978170188669970741557,0.00002},
	{0,0,14,-19,0,0,0,0,0,0,0,0.614840225569432408114778,0.00002},
	{0,0,14,-19,0,0,0,0,2,-1,0,0.615899989491243360362205,0.00004},
	{0,0,14,-19,0,0,0,0,2,0,0,3.757429636695039931737483,0.00003},
	{0,0,14,-18,0,0,0,0,0,0,0,1.097168771142148280262063,0.00001},
	{0,0,14,-18,0,0,0,0,2,-1,0,1.153709584925130426924511,0.00005},
	{0,0,14,-18,0,0,0,0,2,0,0,4.289343858981540691388545,0.00005},
	{0,0,14,-17,0,0,0,0,0,-1,0,1.621395690738239858674774,0.00001},
	{0,0,14,-17,0,0,0,0,0,0,0,1.578212928918321322768747,0.00001},
	{0,0,14,-17,0,0,0,0,0,1,0,1.621395690738239858674774,0.00001},
	{0,0,14,-17,0,0,0,0,2,-1,0,1.621389582085857927751249,0.00005},
	{0,0,14,-17,0,0,0,0,2,0,0,4.762978221418371127526825,0.00005},
	{0,0,14,-16,0,0,0,0,0,0,0,2.049156691780277927961151,0.00001},
	{0,0,14,-16,0,0,0,0,2,-1,0,2.118843674555132228221055,0.00004},
	{0,0,14,-16,0,0,0,0,2,0,0,5.260428648696215958580069,0.00005},
	{0,0,14,-15,0,0,0,0,2,-1,0,2.612084542210091786529347,0.00002},
	{0,0,14,-15,0,0,0,0,2,0,0,5.741169817314243140060626,0.00004},
	{0,0,14,-13,0,0,0,0,2,0,0,3.676716187304861271911705,0.00001},
	{0,0,15,-25,0,0,0,0,2,-1,0,1.174661738996546800350984,0.00002},
	{0,0,15,-22,0,0,0,0,2,0,0,2.747374437310133199474649,0.00002},
	{0,0,15,-21,0,0,0,0,2,-1,0,0.110229410502355476553227,0.00002},
	{0,0,15,-21,0,0,0,0,2,0,0,3.251821540493373241531572,0.00002},
	{0,0,15,-20,0,0,0,0,2,-1,0,0.614244719228651980813538,0.00003},
	{0,0,15,-20,0,0,0,0,2,0,0,3.755841387075724568944679,0.00003},
	{0,0,15,-19,0,0,0,0,2,-1,0,1.117192235518578380393251,0.00003},
	{0,0,15,-19,0,0,0,0,2,0,0,4.258783492844970375301727,0.00004},
	{0,0,15,-18,0,0,0,0,2,-1,0,1.617761391636812096095355,0.00004},
	{0,0,15,-18,0,0,0,0,2,0,0,4.759351601765652972630960,0.00005},
	{0,0,15,-17,0,0,0,0,2,-1,0,2.112342323091453089034530,0.00003},
	{0,0,15,-17,0,0,0,0,2,0,0,5.253926075502060477617761,0.00003},
	{0,0,15,-16,0,0,0,0,2,-1,0,2.581990004450879006014929,0.00002},
	{0,0,15,-16,0,0,0,0,2,0,0,5.723573756861487282776579,0.00003},
	{0,0,15,-14,0,0,0,0,2,0,0,3.605169032613231294703837,0.00001},
	{0,0,16,-23,0,0,0,0,2,0,0,2.746257601121782077058242,0.00002},
	{0,0,16,-22,0,0,0,0,2,-1,0,0.108849727728653949965221,0.00002},
	{0,0,16,-22,0,0,0,0,2,0,0,3.250441857719671645554627,0.00001},
	{0,0,16,-21,0,0,0,0,2,-1,0,0.612358890971872127373388,0.00003},
	{0,0,16,-21,0,0,0,0,2,0,0,3.753950671897039459423695,0.00002},
	{0,0,16,-20,0,0,0,0,2,-1,0,1.114412275086001713475525,0.00003},
	{0,0,16,-20,0,0,0,0,2,0,0,4.256015051585456454574796,0.00004},
	{0,0,16,-19,0,0,0,0,0,0,0,1.613409936745739736707606,0.00002},
	{0,0,16,-19,0,0,0,0,2,-1,0,1.613384629471585673954337,0.00003},
	{0,0,16,-19,0,0,0,0,2,0,0,4.754999623275804943034473,0.00004},
	{0,0,16,-18,0,0,0,0,2,-1,0,2.104335276082078820536481,0.00002},
	{0,0,16,-18,0,0,0,0,2,0,0,5.245991808722495264305508,0.00004},
	{0,0,16,-17,0,0,0,0,2,0,0,5.698978227976532195953041,0.00002},
	{0,0,16,-15,0,0,0,0,2,0,0,3.651345557699095856207805,0.00002},
	{0,0,16,-5,-1,0,0,0,0,-1,0,4.748998657708672688215756,0.00002},
	{0,0,17,-32,0,0,0,0,0,0,0,4.929208615366067469665268,0.00004},
	{0,0,17,-30,0,0,0,0,1,0,-1,4.255004156882701060737872,0.00003},
	{0,0,17,-28,0,0,0,0,2,0,-2,3.869853275133002146191075,0.00005},
	{0,0,17,-24,0,0,0,0,2,0,0,2.744980194642247184333428,0.00002},
	{0,0,17,-23,0,0,0,0,2,0,0,3.248794615971639654361525,0.00002},
	{0,0,17,-22,0,0,0,0,2,-1,0,0.610107590769724539292440,0.00002},
	{0,0,17,-22,0,0,0,0,2,0,0,3.751699371694891649298143,0.00002},
	{0,0,17,-21,0,0,0,0,2,-1,0,1.111132277822728831040422,0.00002},
	{0,0,17,-21,0,0,0,0,2,0,0,4.252737672316061257049569,0.00003},
	{0,0,17,-20,0,0,0,0,2,-1,0,1.608254583201198739672577,0.00003},
	{0,0,17,-20,0,0,0,0,2,0,0,4.749845142395889396880193,0.00003},
	{0,0,17,-19,0,0,0,0,2,-1,0,2.094724096957196302071225,0.00002},
	{0,0,17,-19,0,0,0,0,2,0,0,5.236312561756784944577703,0.00002},
	{0,0,17,-18,0,0,0,0,2,0,0,5.711015763827537838892567,0.00001},
	{0,0,18,-24,0,0,0,0,2,0,0,3.246876150057846910357284,0.00001},
	{0,0,18,-23,0,0,0,0,2,-1,0,0.607469525605335181062117,0.00002},
	{0,0,18,-23,0,0,0,0,2,0,0,3.749061306530502069023214,0.00002},
	{0,0,18,-22,0,0,0,0,2,-1,0,1.107319606071747175590758,0.00002},
	{0,0,18,-22,0,0,0,0,2,0,0,4.248910688865213280962507,0.00002},
	{0,0,18,-21,0,0,0,0,2,0,0,4.743790071621945436675105,0.00002},
	{0,0,18,-20,0,0,0,0,2,0,0,5.224461078004042136058160,0.00002},
	{0,0,19,-25,0,0,0,0,2,0,0,3.244652251524955843819953,0.00001},
	{0,0,19,-24,0,0,0,0,2,0,0,3.746009772866315312711549,0.00001},
	{0,0,19,-23,0,0,0,0,2,0,0,4.244487500941883872940252,0.00002},
	{0,0,19,-22,0,0,0,0,2,0,0,4.736710841642930880368567,0.00002},
	{0,0,19,-21,0,0,0,0,2,0,0,5.209806420939671944836391,0.00001},
	{0,0,19,-17,-3,0,0,0,-4,3,0,4.460954404881434243179683,0.00003},
	{0,0,20,-26,0,0,0,0,2,0,0,3.242118731582760648990416,0.00002},
	{0,0,20,-25,0,0,0,0,2,0,0,3.742517019967224634058311,0.00001},
	{0,0,20,-24,0,0,0,0,2,0,0,4.239413305207561322163201,0.00001},
	{0,0,20,-23,0,0,0,0,2,0,0,4.728358393974588125274749,0.00002},
	{0,0,20,-18,0,0,0,0,-3,1,1,2.451395219571627759336252,0.00016},
	{0,0,20,-16,0,0,-1,0,-2,1,0,1.836491638550347804681451,0.00002},
	{0,0,20,-16,0,0,0,0,-4,1,0,5.708396199153218830701917,0.00002},
	{0,0,20,-16,0,0,0,0,-4,2,0,5.708396199153218830701917,0.00002},
	{0,0,20,-16,0,0,0,0,-2,0,0,5.707594394894853095934195,0.00007},
	{0,0,20,-16,0,0,0,0,-2,1,0,5.708396199153218830701917,0.00148},
	{0,0,20,-16,0,0,0,0,-2,2,0,5.709052442951968231454885,0.00009},
	{0,0,20,-16,0,0,0,0,0,0,0,5.708396199153218830701917,0.00002},
	{0,0,20,-16,0,0,0,0,0,1,0,5.708396199153218830701917,0.00002},
	{0,0,20,-13,2,0,0,0,0,-1,0,1.036770081580557611999893,0.00002},
	{0,0,21,-26,0,0,0,0,2,0,0,3.738526150099614309141316,0.00001},
	{0,0,21,-25,0,0,0,0,2,0,0,4.233576226057190972085209,0.00001},
	{0,0,21,-24,0,0,0,0,2,0,0,4.718688397253912647499874,0.00001},
	{0,0,21,-18,0,0,0,0,-2,1,0,0.275139113805067281326444,0.00014},
	{0,0,22,-19,-5,0,0,0,-2,1,0,1.532097664889201960036758,0.00001},
	{0,0,23,-21,-4,0,0,0,-2,1,0,5.695166777956027104323766,0.00001},
	{0,0,23,-20,0,0,0,0,-1,0,0,1.762518476198446037983558,0.00009},
	{0,0,23,-20,2,0,0,0,-1,1,-1,4.507817193429183078023925,0.00008},
	{0,0,26,-27,-2,0,0,0,-2,0,0,4.681221414201350405903668,0.00001},
	{0,0,26,-27,-2,0,0,0,-2,1,0,6.217516770474524001599548,0.00001},
	{0,0,26,-27,-2,0,0,0,-2,2,0,4.681221414201350405903668,0.00001},
	{0,0,26,-27,-1,0,0,0,-2,1,0,1.805711011862175752185067,0.00001},
	{0,0,26,-27,0,0,0,0,-2,1,0,5.881009087642532939810280,0.00001},
	{0,0,26,-24,0,0,0,0,0,-1,0,4.857143446952445486886063,0.00004},
	{0,0,26,-22,0,0,0,0,1,-1,-1,4.011182358510794188077853,0.00007},
	{0,0,27,-29,0,0,0,0,-2,1,0,0.928788131555995266630532,0.00002},
	{0,0,28,-31,0,0,-3,0,-2,1,0,0.601340627404031824454478,0.00013},
	{0,0,28,-31,0,0,0,0,-2,0,0,0.516806826814162900696203,0.00002},
	{0,0,28,-31,0,0,0,0,-2,1,0,0.502588327529865930287656,0.00046},
	{0,0,28,-31,0,0,0,0,-2,2,0,0.495033844395533662030573,0.00003},
	{0,0,29,-33,0,0,0,0,-2,0,0,5.336500220407790706644846,0.00003},
	{0,0,29,-33,0,0,0,0,-2,1,0,5.336500220407790706644846,0.00050},
	{0,0,29,-33,0,0,0,0,-2,2,0,5.336500220407790706644846,0.00003},
	{0,0,29,-32,-6,0,0,0,-2,1,0,2.189638417806226922124324,0.00003},
	{0,0,29,-31,0,0,0,0,-1,1,-1,3.693307112641393885610341,0.00002},
	{0,0,29,-29,-4,0,0,0,0,-1,0,0.920290647026810404440766,0.00001},
	{0,0,29,-29,0,0,0,0,0,1,-2,5.881204389985830616183193,0.00001},
	{0,0,30,-35,0,0,0,0,-2,1,0,4.369001733240112095302266,0.00004},
	{0,0,30,-35,2,0,0,0,-2,1,0,1.387696627494974466188182,0.00002},
	{0,0,30,-33,-3,0,0,0,-1,-1,1,2.192205273537135123973485,0.00014},
	{0,0,30,-33,-1,0,0,0,-1,0,0,4.238802090903512898023564,0.00003},
	{0,0,31,-37,0,0,0,0,-2,1,0,3.131087342289113895077435,0.00002},
	{0,0,31,-37,2,0,0,0,-2,1,0,1.622860196513588260103234,0.00001},
	{0,0,31,-34,0,0,0,0,0,-3,2,4.275726276558704519459297,0.00004},
	{0,0,32,-39,2,0,0,0,-2,1,0,0.396140870983656967485587,0.00001},
	{0,0,32,-39,3,0,0,0,-2,1,0,6.157848501204893132410234,0.00001},
	{0,0,32,-35,0,-4,0,0,0,-1,0,4.971462512958074064783887,0.00005},
	{0,0,33,-41,3,0,0,0,-2,1,0,5.926900949527396988969485,0.00001},
	{0,0,33,-40,-3,0,0,0,-2,1,0,1.552303341639540423813060,0.00004},
	{0,0,33,-37,-1,0,0,0,0,-1,0,0.117307244217968079103009,0.00001},
	{0,0,34,-43,0,0,0,0,-2,-1,2,4.731108683809880588455599,0.00001},
	{0,0,34,-43,4,0,0,0,-2,1,0,4.556595655363919306068965,0.00002},
	{0,0,34,-42,-2,0,0,0,-2,1,0,1.219358224876720075968706,0.00001},
	{0,0,34,-41,0,0,0,0,-1,-1,1,0.589006036514337583120948,0.00017},
	{0,0,34,-41,2,0,0,0,-1,-1,0,3.672168906471714677763885,0.00001},
	{0,0,34,-41,2,0,0,0,-1,0,0,3.672168906471714677763885,0.00020},
	{0,0,34,-41,2,0,0,0,-1,1,0,3.672168906471714677763885,0.00001},
	{0,0,34,-39,0,0,0,0,0,-1,0,0.540391635529287484018823,0.00018},
	{0,0,34,-37,0,0,0,0,1,-1,-1,3.182977202681382067339655,0.00002},
	{0,0,35,-44,-2,0,0,0,-2,1,0,0.452267343602215821096735,0.00002},
	{0,0,35,-44,-1,0,0,0,-2,1,0,4.594490244083220709114812,0.00002},
	{0,0,35,-41,0,0,0,0,0,-1,0,6.160338038849937802865497,0.00001},
	{0,0,36,-46,-1,0,0,0,-2,1,0,3.865807427393954220917749,0.00001},
	{0,0,36,-44,0,-2,0,0,-1,1,-1,2.601979958505670875723581,0.00001},
	{0,0,37,-48,0,0,0,0,-2,0,0,3.883028242057532164466238,0.00003},
	{0,0,37,-48,0,0,0,0,-2,1,0,4.394363636199617673128159,0.00016},
	{0,0,37,-48,0,0,0,0,-2,2,0,4.076904651356818121143988,0.00001},
	{0,0,37,-46,0,0,0,0,-1,1,-1,0.036947049468393160231994,0.00008},
	{0,0,37,-45,2,0,0,0,0,-1,0,6.216463813336796206954205,0.00003},
	{0,0,38,-47,3,0,0,0,0,-1,0,5.188592991079231886430989,0.00001},
	{0,0,40,-53,-4,0,0,0,-2,1,0,4.718475118019318514939187,0.00001},
	{0,0,40,-50,-2,0,0,0,0,-1,0,6.154149450388215925045188,0.00001},
	{0,0,40,-48,-2,0,0,0,1,-1,-1,3.311000943039520194588476,0.00003},
	{0,0,40,-48,0,0,0,0,1,0,-2,5.253474558824570372905782,0.00002},
	{0,0,41,-56,3,0,0,0,-2,1,0,2.204681410629166116166289,0.00001},
	{0,0,42,-54,0,-1,0,0,0,-2,0,5.443340899634474538970608,0.00001},
	{0,0,42,-54,0,-1,0,0,0,-1,0,5.443340899634474538970608,0.00021},
	{0,0,42,-54,0,-1,0,0,0,0,0,5.443340899634474538970608,0.00001},
	{0,0,43,-55,-2,0,0,0,0,1,-2,5.450723118771634290169459,0.00001},
	{0,0,43,-52,0,0,0,0,2,-1,-2,4.775336723318818421546439,0.00001},
	{0,0,44,-61,-1,0,0,0,-2,1,0,0.543436711475241973623440,0.00007},
	{0,0,44,-56,1,0,0,0,1,-1,-1,5.190004613378245146293466,0.00013},
	{0,0,45,-63,0,0,0,0,-2,1,0,3.122346733395126694432520,0.00001},
	{0,0,48,-69,2,0,0,0,-2,1,0,0.204068608532157413915087,0.00005},
	{0,0,48,-67,0,0,0,0,-1,0,0,5.852476270498003785291985,0.00008},
	{0,1,-42,51,0,0,0,0,0,1,0,4.884457151614456371646611,0.00001},
	{0,1,-37,45,0,0,0,0,2,-1,0,1.618346775067931009317590,0.00002},
	{0,1,-36,43,0,0,0,0,2,-1,0,1.106491098275825368801861,0.00001},
	{0,1,-11,0,0,0,0,0,4,-1,-2,2.701034200340431734588265,0.00005},
	{0,1,-10,0,0,0,0,0,-2,0,0,5.054982277252534572653531,0.00001},
	{0,1,-10,0,0,0,0,0,-2,2,0,5.054982277252534572653531,0.00001},
	{0,1,-8,0,0,0,0,0,-2,1,0,2.105822645670628379122036,0.00002},
	{0,1,-8,0,2,0,0,0,-2,0,0,5.628720348003350970600422,0.00001},
	{0,1,-8,0,2,0,0,0,-2,2,0,2.487127694413558298691669,0.00001},
	{0,1,-8,10,0,0,0,0,-1,0,1,3.745598049695769926614730,0.00002},
	{0,1,-8,12,0,0,0,0,-2,0,0,2.539884634378216432537556,0.00006},
	{0,1,-8,12,0,0,0,0,-2,1,0,2.541939410506589780425202,0.00008},
	{0,1,-8,12,0,0,0,0,0,-1,0,2.528068929875140202767625,0.00011},
	{0,1,-8,12,0,0,0,0,0,0,0,2.522925095503662618057206,0.00051},
	{0,1,-8,12,0,0,0,0,0,1,0,2.528068929875140202767625,0.00011},
	{0,1,-8,12,0,0,0,0,2,-1,0,2.541958085529585797956997,0.00008},
	{0,1,-8,12,0,0,0,0,2,0,0,2.539886379707468222477473,0.00006},
	{0,1,-8,13,0,0,0,0,0,0,0,6.182973737517828638488027,0.00001},
	{0,1,-7,0,0,0,0,0,-2,-1,0,3.685740761268148091289731,0.00001},
	{0,1,-7,0,0,0,0,0,-2,0,0,3.802707317216126536862930,0.00003},
	{0,1,-7,0,0,0,0,0,-2,1,0,3.735100766909650094049766,0.00002},
	{0,1,-7,0,0,0,0,0,-2,2,0,3.816739589869235782515489,0.00001},
	{0,1,-7,0,0,0,0,0,-2,3,0,0.643527678885687626220147,0.00001},
	{0,1,-7,0,2,0,0,0,-2,0,0,4.043694875415719813815940,0.00005},
	{0,1,-7,0,2,0,0,0,-2,1,0,4.042900925138988021956266,0.00002},
	{0,1,-7,0,2,0,0,0,0,-2,0,4.042926406946067530157052,0.00001},
	{0,1,-7,0,2,0,0,0,0,0,0,4.042926406946067530157052,0.00001},
	{0,1,-7,2,0,0,0,0,-2,0,0,4.047566190229568761083101,0.00002},
	{0,1,-7,2,0,0,0,0,-2,1,0,0.902239579238059086208068,0.00002},
	{0,1,-7,2,0,0,0,0,-2,2,0,4.047566190229568761083101,0.00002},
	{0,1,-7,2,0,0,0,0,-2,3,0,0.902239579238059086208068,0.00002},
	{0,1,-7,11,0,0,0,0,0,0,0,5.677370877303918206280287,0.00001},
	{0,1,-6,0,0,0,0,0,-2,-1,0,5.656613676509949506510111,0.00002},
	{0,1,-6,0,0,0,0,0,-2,2,0,6.041713769178414850102854,0.00005},
	{0,1,-6,0,0,0,0,0,0,-2,0,2.490470523529902724391150,0.00001},
	{0,1,-6,0,0,0,0,0,0,-1,0,2.515021022920155502333728,0.00003},
	{0,1,-6,0,0,0,0,0,0,0,0,2.660449535645032170805280,0.00005},
	{0,1,-6,0,0,0,0,0,2,-1,0,5.784039816132204414600437,0.00003},
	{0,1,-6,0,1,0,0,0,-2,0,0,0.919633356030509441225718,0.00001},
	{0,1,-6,0,1,0,0,0,-2,1,0,0.880855630709699410907376,0.00001},
	{0,1,-6,0,1,0,0,0,0,-1,0,4.022448284299493082016852,0.00001},
	{0,1,-6,0,1,0,0,0,0,1,0,4.022448284299493082016852,0.00001},
	{0,1,-6,0,2,0,0,0,-2,0,0,5.093295919525239412450901,0.00005},
	{0,1,-6,0,2,0,0,0,-2,1,0,5.095604815592703396021079,0.00001},
	{0,1,-6,0,2,0,0,0,-2,3,0,5.095604815592703396021079,0.00001},
	{0,1,-6,2,0,0,0,0,-2,0,0,4.752632607744249781944745,0.00003},
	{0,1,-6,2,0,0,0,0,-2,2,0,4.775457849168907031867093,0.00002},
	{0,1,-6,3,0,0,0,0,-2,0,0,5.037510658775445904211665,0.00001},
	{0,1,-6,3,0,0,0,0,-2,1,0,1.895918005185652344124492,0.00002},
	{0,1,-6,3,0,0,0,0,-2,2,0,5.037510658775445904211665,0.00001},
	{0,1,-6,3,0,0,0,0,-2,3,0,1.895918005185652344124492,0.00002},
	{0,1,-6,6,0,0,0,0,0,0,0,3.656439650186891654470855,0.00001},
	{0,1,-6,8,0,0,0,0,0,0,0,4.746961334872819016084122,0.00001},
	{0,1,-5,0,-1,0,0,0,-2,0,0,1.020870132094889193297149,0.00002},
	{0,1,-5,0,-1,0,0,0,-2,2,0,1.146220377104822940594886,0.00001},
	{0,1,-5,0,0,0,0,0,-4,0,0,4.045330423457763835415335,0.00002},
	{0,1,-5,0,0,0,0,0,-4,3,0,0.904810798292097095973929,0.00003},
	{0,1,-5,0,0,0,0,0,-2,-2,0,0.903716825916947019692316,0.00001},
	{0,1,-5,0,0,0,0,0,-2,0,0,0.938705615964602668732653,0.00005},
	{0,1,-5,0,0,0,0,0,-2,1,0,4.034317570410605569009022,0.00002},
	{0,1,-5,0,0,0,0,0,-2,3,0,4.049584139910725077982079,0.00004},
	{0,1,-5,0,0,0,0,0,0,-2,0,0.901926292637326043610813,0.00001},
	{0,1,-5,0,0,0,0,0,0,0,0,5.648799313849994341296679,0.00004},
	{0,1,-5,0,1,0,0,0,-2,0,0,5.389082278381398971589533,0.00003},
	{0,1,-5,0,1,0,0,0,-2,1,0,2.816055063238287470284149,0.00003},
	{0,1,-5,0,1,0,0,0,-2,2,0,3.861663143085093619077952,0.00001},
	{0,1,-5,2,0,0,0,0,0,0,0,3.007803043514766017096917,0.00001},
	{0,1,-5,3,0,0,0,0,-4,3,0,3.170191793245897393660471,0.00001},
	{0,1,-5,3,0,0,0,0,-2,1,0,6.184040308223721638114512,0.00009},
	{0,1,-5,3,0,0,0,0,-2,2,0,2.323270075583948379716048,0.00007},
	{0,1,-5,3,0,0,0,0,-2,3,0,0.244265112001913586858848,0.00005},
	{0,1,-5,3,0,0,0,0,0,1,0,3.170191793245897393660471,0.00001},
	{0,1,-5,5,0,0,0,0,-1,2,-1,5.772205611139057168657018,0.00002},
	{0,1,-5,5,0,0,0,0,0,0,0,1.274178842148936841027762,0.00001},
	{0,1,-5,6,0,0,0,0,0,0,0,4.548759127022465875711532,0.00001},
	{0,1,-5,8,-3,0,0,0,0,0,0,1.255744150990597107764302,0.00001},
	{0,1,-4,-2,0,0,0,0,-2,0,0,0.193220340033461446260787,0.00003},
	{0,1,-4,-2,0,0,0,0,-2,2,0,0.192468452191702277254137,0.00002},
	{0,1,-4,0,-1,0,0,0,-2,0,0,0.951935211694719729536018,0.00006},
	{0,1,-4,0,-1,0,0,0,-2,1,0,1.088144720777636687003564,0.00010},
	{0,1,-4,0,-1,0,0,0,-2,3,0,5.755350966552547298249465,0.00001},
	{0,1,-4,0,-1,0,0,0,0,1,0,4.229746624612465311088272,0.00002},
	{0,1,-4,0,0,0,0,0,-4,0,0,2.248742073062838020547360,0.00002},
	{0,1,-4,0,0,0,0,0,-4,2,0,2.248742073062838020547360,0.00002},
	{0,1,-4,0,0,0,0,0,-2,0,0,1.883481487067641291233144,0.00006},
	{0,1,-4,0,0,0,0,0,-2,1,0,4.223155214159383774585876,0.00007},
	{0,1,-4,0,0,0,0,0,-2,2,0,2.613079379883728847744351,0.00003},
	{0,1,-4,0,0,0,0,0,-2,3,0,6.258125171647750839554192,0.00003},
	{0,1,-4,0,0,0,0,0,-1,0,0,2.062635171461729477471181,0.00002},
	{0,1,-4,0,0,0,0,0,-1,0,1,4.140513001412826632474662,0.00004},
	{0,1,-4,0,0,0,0,0,0,-1,0,4.219698065977033785145522,0.00003},
	{0,1,-4,0,0,0,0,0,0,0,0,4.287732047417323499871600,0.00028},
	{0,1,-4,0,0,0,0,0,0,1,0,4.381721343762796649912161,0.00004},
	{0,1,-4,0,0,0,0,0,1,0,-1,1.059832338717635158431563,0.00003},
	{0,1,-4,0,0,0,0,0,2,-1,0,4.256990865170246607362969,0.00005},
	{0,1,-4,0,0,0,0,0,2,0,0,4.240998064168372216897751,0.00007},
	{0,1,-4,0,1,0,0,0,-2,1,0,5.387299599083412715572194,0.00003},
	{0,1,-4,0,2,0,0,0,2,-2,0,1.582666660103560385408628,0.00002},
	{0,1,-4,0,2,0,0,0,2,0,0,4.724259313693353057317381,0.00002},
	{0,1,-4,0,3,0,0,0,-2,0,2,6.241988555515511905014137,0.00003},
	{0,1,-4,0,3,0,0,0,0,0,0,6.043864363882722301468675,0.00001},
	{0,1,-4,1,0,0,0,0,-2,1,0,5.185900646175105599411381,0.00003},
	{0,1,-4,2,0,0,0,0,0,0,0,4.761086633575059678946673,0.00002},
	{0,1,-4,3,0,0,0,0,0,0,0,6.168410710239187189074528,0.00002},
	{0,1,-4,4,0,0,0,0,0,-1,0,0.519002276480246660383955,0.00003},
	{0,1,-4,4,0,0,0,0,0,0,0,3.783595787373863927882667,0.00002},
	{0,1,-4,4,0,0,0,0,0,1,0,0.519002276480246660383955,0.00003},
	{0,1,-4,4,0,0,0,0,2,-2,0,0.516598434501474801372467,0.00001},
	{0,1,-4,4,0,0,0,0,2,0,0,0.516598434501474801372467,0.00001},
	{0,1,-3,-1,0,0,0,0,-2,1,0,4.719703306213947513469975,0.00002},
	{0,1,-3,0,-2,0,0,0,-2,0,0,0.900286555805077437497630,0.00003},
	{0,1,-3,0,-2,0,0,0,-2,1,0,4.015711487919719324679590,0.00006},
	{0,1,-3,0,-2,0,0,0,-2,3,0,0.953231467730175863195541,0.00001},
	{0,1,-3,0,-1,0,0,0,-2,1,0,5.307497211562774985793567,0.00002},
	{0,1,-3,0,-1,0,0,0,-2,3,0,0.401583156657225659458277,0.00001},
	{0,1,-3,0,0,0,0,0,-4,2,0,5.974483860924518552337759,0.00002},
	{0,1,-3,0,0,0,0,0,-3,0,1,2.885138162091951397059120,0.00001},
	{0,1,-3,0,0,0,0,0,-3,1,1,6.080302824407084472113638,0.00001},
	{0,1,-3,0,0,0,0,0,-2,-1,0,5.835734199648248576863807,0.00002},
	{0,1,-3,0,0,0,0,0,-2,0,0,5.635277375470169047844138,0.00008},
	{0,1,-3,0,0,0,0,0,-2,1,0,5.901356136062283042065246,0.00109},
	{0,1,-3,0,0,0,0,0,-2,2,0,5.866710652278494642075657,0.00010},
	{0,1,-3,0,0,0,0,0,-2,3,0,6.207709416341717023613000,0.00005},
	{0,1,-3,0,0,0,0,0,-1,-2,3,6.079516902644911624520319,0.00002},
	{0,1,-3,0,0,0,0,0,-1,-1,1,2.905368098918892361126609,0.00018},
	{0,1,-3,0,0,0,0,0,-1,0,-1,5.945826078205547204902359,0.00013},
	{0,1,-3,0,0,0,0,0,-1,0,0,5.868695964302638401477452,0.00016},
	{0,1,-3,0,0,0,0,0,-1,0,1,2.884512287022185983431655,0.00100},
	{0,1,-3,0,0,0,0,0,-1,1,-1,6.048137104424530008373040,0.00006},
	{0,1,-3,0,0,0,0,0,-1,1,0,5.868246367487324199885279,0.00002},
	{0,1,-3,0,0,0,0,0,-1,1,1,2.905368098918892361126609,0.00018},
	{0,1,-3,0,0,0,0,0,0,-2,0,2.399841684126219121253598,0.00003},
	{0,1,-3,0,0,0,0,0,0,-1,0,2.746024425133715585189975,0.00043},
	{0,1,-3,0,0,0,0,0,0,0,0,2.743729840766118588391009,0.00379},
	{0,1,-3,0,0,0,0,0,0,1,0,2.858898882117468343011524,0.00082},
	{0,1,-3,0,0,0,0,0,0,2,0,2.813814584077501734782345,0.00005},
	{0,1,-3,0,0,0,0,0,1,-1,-1,6.050831718256683977585908,0.00001},
	{0,1,-3,0,0,0,0,0,1,0,-1,6.049188665298856015795081,0.00023},
	{0,1,-3,0,0,0,0,0,1,0,0,5.893750514780867533204400,0.00003},
	{0,1,-3,0,0,0,0,0,1,0,1,2.930316533378599874737347,0.00009},
	{0,1,-3,0,0,0,0,0,1,1,-1,6.050831718256683977585908,0.00001},
	{0,1,-3,0,0,0,0,0,2,-2,0,2.929890498508188390047735,0.00004},
	{0,1,-3,0,0,0,0,0,2,-1,0,2.690105995761994606141343,0.00021},
	{0,1,-3,0,0,0,0,0,2,0,0,2.799343186584590803533956,0.00023},
	{0,1,-3,0,0,0,0,0,2,1,0,2.754466757258537512598195,0.00002},
	{0,1,-3,0,0,0,0,0,4,0,0,2.921368404836550247694049,0.00002},
	{0,1,-3,0,1,0,0,0,-2,1,0,4.657815327201629607145605,0.00001},
	{0,1,-3,0,1,0,0,0,-2,3,0,1.516222673611837157281457,0.00001},
	{0,1,-3,0,1,0,0,0,0,0,0,4.743310455143497250674045,0.00001},
	{0,1,-3,0,1,0,0,0,2,-2,0,1.559561293333958653661853,0.00003},
	{0,1,-3,0,1,0,0,0,2,0,0,1.556978729639782565996597,0.00002},
	{0,1,-3,0,2,0,0,0,-2,0,0,3.139969497385438845782346,0.00003},
	{0,1,-3,0,2,0,0,0,-2,1,0,3.118297220464649299742632,0.00005},
	{0,1,-3,0,2,0,0,0,0,-2,0,3.149184835835968421235975,0.00001},
	{0,1,-3,0,2,0,0,0,0,0,0,3.156854510700932259226192,0.00006},
	{0,1,-3,0,2,0,0,0,2,-1,0,3.139264035301782218567723,0.00003},
	{0,1,-3,0,2,0,0,0,2,0,0,3.146050922631087320979759,0.00001},
	{0,1,-3,0,2,0,0,0,2,2,0,3.139758487078872395414919,0.00001},
	{0,1,-3,0,3,0,0,0,2,0,0,2.982886374047444721924194,0.00004},
	{0,1,-3,1,0,0,0,0,0,0,0,2.858008240600175664525295,0.00002},
	{0,1,-3,2,0,0,0,0,-2,2,0,3.127864242759456292475306,0.00001},
	{0,1,-3,2,0,0,0,0,0,-1,0,6.243567903955642428570627,0.00002},
	{0,1,-3,2,0,0,0,0,0,1,0,6.243567903955642428570627,0.00002},
	{0,1,-3,2,0,0,0,0,2,-3,0,0.003603930372443091105505,0.00003},
	{0,1,-3,2,0,0,0,0,2,-2,0,3.132145360881672946362642,0.00002},
	{0,1,-3,2,0,0,0,0,2,-1,0,0.003603930372443091105505,0.00003},
	{0,1,-3,2,0,0,0,0,2,0,0,3.140090448702601566566273,0.00004},
	{0,1,-3,3,0,0,0,0,0,0,0,0.645069677279824560400812,0.00005},
	{0,1,-3,6,0,0,0,0,2,-3,0,1.801461135133569646527008,0.00002},
	{0,1,-3,6,0,0,0,0,2,-1,0,1.801461135133569646527008,0.00002},
	{0,1,-2,-3,0,0,0,0,-2,1,0,0.205041105991368627359250,0.00001},
	{0,1,-2,-3,0,0,0,0,-2,3,0,1.928618494051018039669998,0.00001},
	{0,1,-2,0,-1,0,0,0,-2,1,0,3.560935233517761755450692,0.00002},
	{0,1,-2,0,-1,0,0,0,-2,3,0,0.419342579927968805986183,0.00002},
	{0,1,-2,0,-1,0,0,0,2,-2,0,4.879841104808781082624591,0.00001},
	{0,1,-2,0,-1,0,0,0,2,0,0,1.738248451218988632760443,0.00001},
	{0,1,-2,0,0,0,0,0,-4,0,0,2.572994752019025277434139,0.00002},
	{0,1,-2,0,0,0,0,0,-4,1,0,2.124872390857370785255398,0.00005},
	{0,1,-2,0,0,0,0,0,-4,2,0,3.651287961833780126852389,0.00001},
	{0,1,-2,0,0,0,0,0,-3,0,1,4.479626635350969721116599,0.00001},
	{0,1,-2,0,0,0,0,0,-3,1,1,0.574776716188678205021745,0.00002},
	{0,1,-2,0,0,0,0,0,-3,2,-1,1.337316302372756782190777,0.00001},
	{0,1,-2,0,0,0,0,0,-2,-2,0,1.777235790582962993156002,0.00002},
	{0,1,-2,0,0,0,0,0,-2,-1,0,1.994651630036821998714913,0.00026},
	{0,1,-2,0,0,0,0,0,-2,-1,2,2.053162047880679796918457,0.00002},
	{0,1,-2,0,0,0,0,0,-2,0,0,2.126478268302130825162521,0.00176},
	{0,1,-2,0,0,0,0,0,-2,0,1,1.337283315649893999932374,0.00010},
	{0,1,-2,0,0,0,0,0,-2,0,2,2.057101256002431100000649,0.00006},
	{0,1,-2,0,0,0,0,0,-2,1,0,3.666544932023013902977482,0.00123},
	{0,1,-2,0,0,0,0,0,-2,2,0,4.703653083879681950918439,0.00021},
	{0,1,-2,0,0,0,0,0,-2,3,0,4.821835436184600531817068,0.00006},
	{0,1,-2,0,0,0,0,0,-1,-2,1,4.479538147157894556471547,0.00002},
	{0,1,-2,0,0,0,0,0,-1,-1,-1,1.471143087960851136841711,0.00004},
	{0,1,-2,0,0,0,0,0,-1,-1,0,1.543764318274157831822890,0.00002},
	{0,1,-2,0,0,0,0,0,-1,-1,1,4.479344241077996890965096,0.00044},
	{0,1,-2,0,0,0,0,0,-1,0,-1,1.337014011346311370687090,0.00038},
	{0,1,-2,0,0,0,0,0,-1,0,0,1.541689296326461899866445,0.00032},
	{0,1,-2,0,0,0,0,0,-1,0,1,4.480435420926344392000829,0.00165},
	{0,1,-2,0,0,0,0,0,-1,1,-1,1.343585874111770994687731,0.00087},
	{0,1,-2,0,0,0,0,0,-1,1,0,1.599756924139088765102201,0.00007},
	{0,1,-2,0,0,0,0,0,-1,1,1,4.479192571965998403982212,0.00031},
	{0,1,-2,0,0,0,0,0,-1,2,-1,1.337481934118770920960628,0.00008},
	{0,1,-2,0,0,0,0,0,-1,2,1,4.479576195335587485146789,0.00002},
	{0,1,-2,0,0,0,0,0,0,-3,0,1.871081446330997488658454,0.00004},
	{0,1,-2,0,0,0,0,0,0,-2,0,1.842498363704011543617867,0.00067},
	{0,1,-2,0,0,0,0,0,0,-2,2,5.156098625598526830060564,0.00004},
	{0,1,-2,0,0,0,0,0,0,-1,-2,4.995646144139558764152298,0.00003},
	{0,1,-2,0,0,0,0,0,0,-1,0,1.850497905797602316013695,0.00913},
	{0,1,-2,0,0,0,0,0,0,-1,1,4.478290585808568202708102,0.00008},
	{0,1,-2,0,0,0,0,0,0,-1,2,5.218934492927602697420753,0.00007},
	{0,1,-2,0,0,0,0,0,0,0,-2,4.924744586738241558521167,0.00001},
	{0,1,-2,0,0,0,0,0,0,0,-1,1.332248738889591166412174,0.00015},
	{0,1,-2,0,0,0,0,0,0,0,0,1.810179927411907252476908,0.04478},
	{0,1,-2,0,0,0,0,0,0,0,1,4.478767235227287812904251,0.00034},
	{0,1,-2,0,0,0,0,0,0,0,2,4.924744586738241558521167,0.00001},
	{0,1,-2,0,0,0,0,0,0,1,-2,1.901008257949093671612673,0.00001},
	{0,1,-2,0,0,0,0,0,0,1,-1,1.337416309738896025294252,0.00002},
	{0,1,-2,0,0,0,0,0,0,1,0,1.861085422106050213386652,0.00852},
	{0,1,-2,0,0,0,0,0,0,1,1,4.478767235227287812904251,0.00002},
	{0,1,-2,0,0,0,0,0,0,1,2,4.995646144139558764152298,0.00003},
	{0,1,-2,0,0,0,0,0,0,2,0,1.850145872887474896018034,0.00054},
	{0,1,-2,0,0,0,0,0,0,3,0,1.864551122401735483435914,0.00004},
	{0,1,-2,0,0,0,0,0,1,-2,-1,4.479379496728888021550574,0.00001},
	{0,1,-2,0,0,0,0,0,1,-2,1,1.338184603675623973728648,0.00004},
	{0,1,-2,0,0,0,0,0,1,-1,-1,4.479941143682179216511940,0.00024},
	{0,1,-2,0,0,0,0,0,1,-1,0,4.757760734152459036749860,0.00003},
	{0,1,-2,0,0,0,0,0,1,-1,1,1.340696656068019354535181,0.00057},
	{0,1,-2,0,0,0,0,0,1,0,-1,4.480564400758066057051110,0.00218},
	{0,1,-2,0,0,0,0,0,1,0,0,4.898141580147642670794994,0.00042},
	{0,1,-2,0,0,0,0,0,1,0,1,1.373057852926797384185420,0.00050},
	{0,1,-2,0,0,0,0,0,1,1,-1,4.477373764352496010587856,0.00046},
	{0,1,-2,0,0,0,0,0,1,1,1,1.364844158933986806303551,0.00004},
	{0,1,-2,0,0,0,0,0,1,2,-1,4.479149287800549217308799,0.00002},
	{0,1,-2,0,0,0,0,0,2,-3,0,4.991604310657789866922940,0.00001},
	{0,1,-2,0,0,0,0,0,2,-2,0,3.937477627797849599744495,0.00011},
	{0,1,-2,0,0,0,0,0,2,-1,0,3.986915300591065580704253,0.00186},
	{0,1,-2,0,0,0,0,0,2,0,-2,3.684411343976904174013498,0.00001},
	{0,1,-2,0,0,0,0,0,2,0,0,4.133749850561348360145075,0.00137},
	{0,1,-2,0,0,0,0,0,2,1,0,3.796764471113085903652973,0.00008},
	{0,1,-2,0,0,0,0,0,2,2,0,4.531495726325139195012071,0.00003},
	{0,1,-2,0,0,0,0,0,4,-2,0,4.341406332436830162180286,0.00002},
	{0,1,-2,0,0,0,0,0,4,-1,0,4.591432950832501802551633,0.00004},
	{0,1,-2,0,0,0,0,0,4,0,0,3.832242127884225357803416,0.00001},
	{0,1,-2,0,0,0,0,0,4,1,0,1.533116064507740627931298,0.00002},
	{0,1,-2,0,0,1,0,0,0,-2,2,6.279603367955719050996777,0.00001},
	{0,1,-2,0,0,1,0,0,0,0,0,0.000677362282698999230469,0.00001},
	{0,1,-2,0,1,0,0,0,-2,0,0,3.024453833644642930522650,0.00006},
	{0,1,-2,0,1,0,0,0,-2,1,0,3.106176956007099754231149,0.00018},
	{0,1,-2,0,1,0,0,0,0,-1,0,6.218334108163232620825056,0.00003},
	{0,1,-2,0,1,0,0,0,0,0,0,0.028542416455414467563179,0.00008},
	{0,1,-2,0,1,0,0,0,0,1,0,6.239557486400409302973458,0.00008},
	{0,1,-2,0,1,0,0,0,2,-2,0,0.028377831906951405532835,0.00001},
	{0,1,-2,0,1,0,0,0,2,-1,0,6.260322890241862836546716,0.00002},
	{0,1,-2,0,1,0,0,0,2,0,0,3.098466789503489415835702,0.00003},
	{0,1,-2,0,1,0,0,0,2,2,0,3.119280364432297503185509,0.00001},
	{0,1,-2,0,2,0,0,0,-2,0,0,4.113713645281378283868889,0.00001},
	{0,1,-2,0,2,0,0,0,-2,1,0,4.203554119461935911772343,0.00002},
	{0,1,-2,0,2,0,0,0,0,-1,0,1.061961465872143017818985,0.00008},
	{0,1,-2,0,2,0,0,0,0,0,0,3.701824144858200771324164,0.00002},
	{0,1,-2,0,2,0,0,0,0,1,0,1.061961465872143017818985,0.00008},
	{0,1,-2,0,2,0,0,0,2,-2,0,1.448904102631939583289977,0.00002},
	{0,1,-2,0,2,0,0,0,2,-1,0,4.203554119461935911772343,0.00002},
	{0,1,-2,0,2,0,0,0,2,0,0,1.448904102631939583289977,0.00002},
	{0,1,-2,0,3,0,0,0,0,0,0,3.871586736146082952103598,0.00001},
	{0,1,-2,0,4,0,0,0,0,0,0,4.207344276465566856870737,0.00002},
	{0,1,-2,1,0,0,0,0,0,-1,0,2.947641718731446758283710,0.00002},
	{0,1,-2,1,0,0,0,0,0,0,0,5.529500823488426419771713,0.00001},
	{0,1,-2,1,0,0,0,0,0,1,0,2.947641718731446758283710,0.00002},
	{0,1,-2,2,0,0,0,0,-2,0,0,3.853624680149183134858504,0.00002},
	{0,1,-2,2,0,0,0,0,-2,1,0,3.852268384787458366247392,0.00001},
	{0,1,-2,2,0,0,0,0,-2,2,0,3.856157327426752434718082,0.00003},
	{0,1,-2,2,0,0,0,0,-2,3,0,3.852268384787458366247392,0.00001},
	{0,1,-2,2,0,0,0,0,0,-1,0,3.883381845763985928954298,0.00002},
	{0,1,-2,2,0,0,0,0,0,0,0,4.899865441849837743859553,0.00001},
	{0,1,-2,2,0,0,0,0,0,1,0,3.883381845763985928954298,0.00002},
	{0,1,-2,2,0,0,0,0,2,-3,0,0.781131182442172500302036,0.00004},
	{0,1,-2,2,0,0,0,0,2,-2,0,0.781131356975097723704948,0.00003},
	{0,1,-2,2,0,0,0,0,2,-1,0,0.781131182442172500302036,0.00004},
	{0,1,-2,2,0,0,0,0,2,0,0,0.793036073270025898551694,0.00002},
	{0,1,-2,3,0,0,0,0,-2,0,0,4.126581957856332749656758,0.00002},
	{0,1,-2,3,0,0,0,0,-2,2,0,4.126581957856332749656758,0.00002},
	{0,1,-2,3,0,0,0,0,2,-3,0,4.126859290674474323168397,0.00003},
	{0,1,-2,3,0,0,0,0,2,-2,0,4.134342564375325324022015,0.00002},
	{0,1,-2,3,0,0,0,0,2,-1,0,4.126859290674474323168397,0.00003},
	{0,1,-2,3,0,0,0,0,2,0,0,4.134342564375325324022015,0.00002},
	{0,1,-2,4,0,0,0,0,2,-3,0,4.687662551805836130824900,0.00003},
	{0,1,-2,4,0,0,0,0,2,-2,0,1.702665725626879345000475,0.00001},
	{0,1,-2,4,0,0,0,0,2,-1,0,3.789304933890062176971014,0.00003},
	{0,1,-1,-5,0,0,0,0,-2,1,0,0.420045947616522474810097,0.00002},
	{0,1,-1,-2,0,0,0,0,0,0,0,2.106043953419781011859868,0.00001},
	{0,1,-1,0,-2,0,0,0,-2,0,0,0.435575189169067289451931,0.00002},
	{0,1,-1,0,-2,0,0,0,-2,2,0,3.577167842758860238916441,0.00002},
	{0,1,-1,0,-2,0,0,0,0,0,0,0.107053260329576196974166,0.00001},
	{0,1,-1,0,-1,0,0,0,-2,0,0,3.694931839642075388496778,0.00006},
	{0,1,-1,0,-1,0,0,0,-2,2,0,1.603187194250958569341492,0.00002},
	{0,1,-1,0,-1,0,0,0,0,0,0,1.270365297733329068563535,0.00002},
	{0,1,-1,0,-1,0,0,0,2,-3,0,3.384646158024972262268193,0.00001},
	{0,1,-1,0,-1,0,0,0,2,-2,0,3.384646158024972262268193,0.00001},
	{0,1,-1,0,-1,0,0,0,2,-1,0,3.384645459893271812745752,0.00004},
	{0,1,-1,0,-1,0,0,0,2,0,0,3.345987115093297603607425,0.00007},
	{0,1,-1,0,0,-1,0,0,0,0,0,1.540627088943698153045148,0.00001},
	{0,1,-1,0,0,0,0,0,-6,0,0,3.141367680649211013843569,0.00002},
	{0,1,-1,0,0,0,0,0,-6,1,0,3.141304325197363578325849,0.00005},
	{0,1,-1,0,0,0,0,0,-6,2,0,3.141300660005934552998497,0.00006},
	{0,1,-1,0,0,0,0,0,-6,3,0,3.137596896800277423977832,0.00002},
	{0,1,-1,0,0,0,0,0,-4,-2,0,3.141607314355510105485791,0.00001},
	{0,1,-1,0,0,0,0,0,-4,-1,0,3.141426498245003084974769,0.00020},
	{0,1,-1,0,0,0,0,0,-4,0,0,3.141468909745826820767434,0.00113},
	{0,1,-1,0,0,0,0,0,-4,0,2,3.141042002210788997018653,0.00001},
	{0,1,-1,0,0,0,0,0,-4,1,-2,6.282883714284841047970076,0.00002},
	{0,1,-1,0,0,0,0,0,-4,1,0,3.141461928428818772829345,0.00266},
	{0,1,-1,0,0,0,0,0,-4,2,0,3.141022105457316193621864,0.00175},
	{0,1,-1,0,0,0,0,0,-4,3,0,3.147833950994924911981343,0.00006},
	{0,1,-1,0,0,0,0,0,-3,-1,0,3.141102390602908300820673,0.00003},
	{0,1,-1,0,0,0,0,0,-3,0,0,3.138345468516457792418350,0.00002},
	{0,1,-1,0,0,0,0,0,-3,1,0,6.283036430594391319459646,0.00023},
	{0,1,-1,0,0,0,0,0,-3,2,0,0.001063778179090543859683,0.00004},
	{0,1,-1,0,0,0,0,0,-3,3,0,6.282977438465674246970138,0.00001},
	{0,1,-1,0,0,0,0,0,-2,-3,0,3.141660023298920023648861,0.00009},
	{0,1,-1,0,0,0,0,0,-2,-2,0,3.141817277464524771346532,0.00084},
	{0,1,-1,0,0,0,0,0,-2,-1,-2,6.282911115954098235647507,0.00004},
	{0,1,-1,0,0,0,0,0,-2,-1,0,3.141413582808538773605278,0.00939},
	{0,1,-1,0,0,0,0,0,-2,-1,2,6.283018628236020752808599,0.00023},
	{0,1,-1,0,0,0,0,0,-2,0,-2,6.282951782125669737411044,0.00025},
	{0,1,-1,0,0,0,0,0,-2,0,0,3.141270116744024232247057,0.09922},
	{0,1,-1,0,0,0,0,0,-2,0,2,3.141316717035052885620416,0.00164},
	{0,1,-1,0,0,0,0,0,-2,1,-2,6.282883190686066043895153,0.00031},
	{0,1,-1,0,0,0,0,0,-2,1,0,3.141319684094781461425328,0.13122},
	{0,1,-1,0,0,0,0,0,-2,2,-2,6.282797320486868564159977,0.00003},
	{0,1,-1,0,0,0,0,0,-2,2,0,3.141386355672207475464575,0.00497},
	{0,1,-1,0,0,0,0,0,-2,3,0,3.140691540096988809693812,0.00017},
	{0,1,-1,0,0,0,0,0,-2,4,0,3.140194644858945949295048,0.00001},
	{0,1,-1,0,0,0,0,0,-1,-1,0,0.000102625360017266569032,0.00047},
	{0,1,-1,0,0,0,0,0,-1,-1,1,0.888726891103268523686154,0.00003},
	{0,1,-1,0,0,0,0,0,-1,0,-1,3.850771590420948076172181,0.00001},
	{0,1,-1,0,0,0,0,0,-1,0,0,0.000131946891450771301105,0.00666},
	{0,1,-1,0,0,0,0,0,-1,0,1,2.602657844387145313902465,0.00002},
	{0,1,-1,0,0,0,0,0,-1,1,0,0.000028972465583105871701,0.00077},
	{0,1,-1,0,0,0,0,0,-1,2,-1,3.850771590420948076172181,0.00001},
	{0,1,-1,0,0,0,0,0,-1,2,0,6.267565483038863405340635,0.00002},
	{0,1,-1,0,0,0,0,0,0,-4,0,3.141816404799898876376574,0.00005},
	{0,1,-1,0,0,0,0,0,0,-3,0,3.141774342364926031478944,0.00072},
	{0,1,-1,0,0,0,0,0,0,-2,-2,0.000180990643431811994895,0.00005},
	{0,1,-1,0,0,0,0,0,0,-2,0,3.141750954952949204113111,0.01019},
	{0,1,-1,0,0,0,0,0,0,-2,2,0.000232303323440445272634,0.00001},
	{0,1,-1,0,0,0,0,0,0,-1,-2,0.000138928208458748630528,0.00037},
	{0,1,-1,0,0,0,0,0,0,-1,0,3.141747638827370181502374,0.15350},
	{0,1,-1,0,0,0,0,0,0,-1,2,3.142404231691970917239587,0.00019},
	{0,1,-1,0,0,0,0,0,0,0,-2,6.283110607087601273690325,0.00023},
	{0,1,-1,0,0,0,0,0,0,0,0,3.141765092119890301347596,0.82155},
	{0,1,-1,0,0,0,0,0,0,0,2,0.000181339709282210851879,0.00050},
	{0,1,-1,0,0,0,0,0,0,1,-2,3.145171974819783500265657,0.00012},
	{0,1,-1,0,0,0,0,0,0,1,0,3.141856372839769484528460,0.12722},
	{0,1,-1,0,0,0,0,0,0,1,2,0.000232652389290844129619,0.00031},
	{0,1,-1,0,0,0,0,0,0,2,-2,6.281094926334472638984607,0.00003},
	{0,1,-1,0,0,0,0,0,0,2,0,3.141872255335962815792072,0.00885},
	{0,1,-1,0,0,0,0,0,0,2,2,0.000206297917585729763228,0.00006},
	{0,1,-1,0,0,0,0,0,0,3,0,3.141902798597872692454303,0.00062},
	{0,1,-1,0,0,0,0,0,0,4,0,3.141930200267128991953314,0.00004},
	{0,1,-1,0,0,0,0,0,1,-2,0,3.143381267007237411803544,0.00025},
	{0,1,-1,0,0,0,0,0,1,-2,1,4.311911664341527838928414,0.00003},
	{0,1,-1,0,0,0,0,0,1,-1,-1,0.551596300261240735096635,0.00003},
	{0,1,-1,0,0,0,0,0,1,-1,0,3.141817626530375218152358,0.00292},
	{0,1,-1,0,0,0,0,0,1,-1,1,4.030319370160136749348112,0.00013},
	{0,1,-1,0,0,0,0,0,1,0,-2,3.141951144218153135767579,0.00003},
	{0,1,-1,0,0,0,0,0,1,0,-1,0.427630450413989060542974,0.00025},
	{0,1,-1,0,0,0,0,0,1,0,0,3.141943464769444194217840,0.01218},
	{0,1,-1,0,0,0,0,0,1,0,1,3.311745500498421090895818,0.00004},
	{0,1,-1,0,0,0,0,0,1,0,2,0.000375245789178780826244,0.00002},
	{0,1,-1,0,0,0,0,0,1,1,-1,0.551596300261240735096635,0.00003},
	{0,1,-1,0,0,0,0,0,1,1,0,3.141969470175298706493550,0.00075},
	{0,1,-1,0,0,0,0,0,1,2,0,3.140983708213772374051587,0.00005},
	{0,1,-1,0,0,0,0,0,2,-4,0,6.278213562272355829918524,0.00001},
	{0,1,-1,0,0,0,0,0,2,-2,0,6.283107640027872697885414,0.00176},
	{0,1,-1,0,0,0,0,0,2,-1,-2,0.002880840463341840552991,0.00002},
	{0,1,-1,0,0,0,0,0,2,-1,0,3.139493546098419685108638,0.01292},
	{0,1,-1,0,0,0,0,0,2,-1,2,6.282377917867613348334999,0.00003},
	{0,1,-1,0,0,0,0,0,2,0,-2,3.141953413146180373871630,0.00089},
	{0,1,-1,0,0,0,0,0,2,0,0,3.141848169792285538903798,0.02201},
	{0,1,-1,0,0,0,0,0,2,0,2,6.281227745890549662988178,0.00002},
	{0,1,-1,0,0,0,0,0,2,1,-2,0.001439373034119723624227,0.00008},
	{0,1,-1,0,0,0,0,0,2,1,0,3.141573454968021206212825,0.00286},
	{0,1,-1,0,0,0,0,0,2,2,0,3.143093636746508323653870,0.00028},
	{0,1,-1,0,0,0,0,0,2,3,0,3.142727466669439806423725,0.00003},
	{0,1,-1,0,0,0,0,0,3,-2,0,3.139059308180523366615944,0.00003},
	{0,1,-1,0,0,0,0,0,3,-1,0,3.141912048842908422585651,0.00017},
	{0,1,-1,0,0,0,0,0,3,0,0,3.141917808429439684658746,0.00012},
	{0,1,-1,0,0,0,0,0,3,2,0,3.142275775459023812175019,0.00002},
	{0,1,-1,0,0,0,0,0,4,-3,0,0.005894849548610848338770,0.00006},
	{0,1,-1,0,0,0,0,0,4,-2,0,3.138221899205416498546128,0.00019},
	{0,1,-1,0,0,0,0,0,4,-1,-2,3.142113285305663250568387,0.00002},
	{0,1,-1,0,0,0,0,0,4,-1,0,3.141224214584697360663768,0.00051},
	{0,1,-1,0,0,0,0,0,4,0,0,3.141513415641752793305841,0.00022},
	{0,1,-1,0,0,0,0,0,4,1,0,3.141542737173186328192287,0.00004},
	{0,1,-1,0,0,0,0,0,5,-2,0,3.141934912656109357698142,0.00001},
	{0,1,-1,0,0,0,0,0,6,-1,0,0.000468969970010876379546,0.00003},
	{0,1,-1,0,0,1,0,0,0,0,0,1.499470305319494656259849,0.00002},
	{0,1,-1,0,1,0,0,0,-2,0,0,6.019613188459186581269478,0.00004},
	{0,1,-1,0,1,0,0,0,-2,1,0,2.950716639807610786050418,0.00001},
	{0,1,-1,0,1,0,0,0,0,-1,0,6.092309293397403457959172,0.00007},
	{0,1,-1,0,1,0,0,0,0,0,0,5.159147366735910900104045,0.00001},
	{0,1,-1,0,1,0,0,0,0,1,0,6.092309293397403457959172,0.00007},
	{0,1,-1,0,1,0,0,0,1,-2,1,1.835147909559237344723215,0.00002},
	{0,1,-1,0,1,0,0,0,1,-1,1,1.603167472030410989347615,0.00009},
	{0,1,-1,0,1,0,0,0,2,-3,0,5.488623641610391956646708,0.00002},
	{0,1,-1,0,1,0,0,0,2,-2,0,5.487667724779075051344535,0.00002},
	{0,1,-1,0,1,0,0,0,2,-1,0,5.499462485331126693210990,0.00004},
	{0,1,-1,0,1,0,0,0,2,0,0,5.767913497442552994698417,0.00007},
	{0,1,-1,0,2,0,0,0,0,0,0,1.299423808048558282024487,0.00001},
	{0,1,-1,0,2,0,0,0,1,0,-1,6.195277087013911554436163,0.00001},
	{0,1,-1,2,0,0,0,0,2,-3,0,3.693091564478772514945604,0.00002},
	{0,1,-1,2,0,0,0,0,2,-1,0,4.047003147012875778898433,0.00006},
	{0,1,0,-7,0,0,0,0,-2,0,2,3.083061291794911173980154,0.00001},
	{0,1,0,-6,0,0,0,0,-2,1,0,3.604576842398029778991031,0.00003},
	{0,1,0,-3,0,0,0,0,0,-1,0,0.011447090965055207664736,0.00002},
	{0,1,0,-3,0,0,0,0,0,0,0,5.658655362668931765313118,0.00003},
	{0,1,0,-3,0,0,0,0,0,1,0,0.011447090965055207664736,0.00002},
	{0,1,0,-2,0,0,0,0,-2,2,0,5.606962899015064394347974,0.00002},
	{0,1,0,-2,0,0,0,0,0,-1,0,5.612319838088210666171562,0.00003},
	{0,1,0,-2,0,0,0,0,0,1,0,5.612319838088210666171562,0.00003},
	{0,1,0,-2,0,0,0,0,2,-3,0,2.436785068403183096563680,0.00004},
	{0,1,0,-2,0,0,0,0,2,-2,0,2.445918899977644667131926,0.00002},
	{0,1,0,-2,0,0,0,0,2,-1,0,2.436785068403183096563680,0.00004},
	{0,1,0,-2,0,0,0,0,2,0,0,2.445918899977644667131926,0.00002},
	{0,1,0,0,-3,0,0,0,0,0,0,5.516605981908841549454792,0.00001},
	{0,1,0,0,-2,0,0,0,-2,0,0,5.296403026172473715860178,0.00006},
	{0,1,0,0,-2,0,0,0,2,-3,0,2.457489385720815988634058,0.00002},
	{0,1,0,0,-2,0,0,0,2,-2,0,5.385204680382244646352774,0.00001},
	{0,1,0,0,-2,0,0,0,2,-1,0,5.599082039310609104632022,0.00002},
	{0,1,0,0,-2,0,0,0,2,0,0,2.243612026792450642176391,0.00001},
	{0,1,0,0,-1,0,0,0,-2,0,0,3.144268766931876069037344,0.00004},
	{0,1,0,0,-1,0,0,0,-2,1,0,0.017293245827535413949860,0.00003},
	{0,1,0,0,-1,0,0,0,-2,2,0,3.118765143237109072060775,0.00001},
	{0,1,0,0,-1,0,0,0,0,-2,0,3.158885899417328335658794,0.00003},
	{0,1,0,0,-1,0,0,0,0,-1,0,0.007927285462558244372167,0.00004},
	{0,1,0,0,-1,0,0,0,0,0,0,0.085481688906627065205335,0.00004},
	{0,1,0,0,-1,0,0,0,0,1,0,0.007927285462558244372167,0.00004},
	{0,1,0,0,-1,0,0,0,2,-3,0,0.062901317176025234312320,0.00003},
	{0,1,0,0,-1,0,0,0,2,-2,0,0.071100001337268611822928,0.00002},
	{0,1,0,0,-1,0,0,0,2,-1,0,3.204493970765818655621615,0.00003},
	{0,1,0,0,-1,0,0,0,2,0,0,0.060986516453662265035973,0.00007},
	{0,1,0,0,0,0,0,0,-4,-2,0,1.343437521125351086226374,0.00001},
	{0,1,0,0,0,0,0,0,-4,-1,0,1.358933252356257836979125,0.00003},
	{0,1,0,0,0,0,0,0,-4,0,0,1.369686400410719873121934,0.00024},
	{0,1,0,0,0,0,0,0,-4,1,0,1.349156616018286181102326,0.00040},
	{0,1,0,0,0,0,0,0,-4,2,0,1.358968857072998304147404,0.00016},
	{0,1,0,0,0,0,0,0,-3,0,0,1.332790663622335447513478,0.00002},
	{0,1,0,0,0,0,0,0,-3,0,1,1.803988546423382466343810,0.00002},
	{0,1,0,0,0,0,0,0,-3,1,-1,1.803576474186986855485770,0.00001},
	{0,1,0,0,0,0,0,0,-3,1,1,1.803594102012431754644695,0.00001},
	{0,1,0,0,0,0,0,0,-3,3,0,4.474383317212128119422232,0.00001},
	{0,1,0,0,0,0,0,0,-2,-2,0,1.341791152041944990003230,0.00011},
	{0,1,0,0,0,0,0,0,-2,-1,0,1.346432506121773675644704,0.00093},
	{0,1,0,0,0,0,0,0,-2,-1,2,4.470246537819051901863077,0.00001},
	{0,1,0,0,0,0,0,0,-2,0,-2,4.486133920934105567823735,0.00002},
	{0,1,0,0,0,0,0,0,-2,0,0,1.344870436441238714664337,0.00942},
	{0,1,0,0,0,0,0,0,-2,0,2,1.337767295451472104872437,0.00010},
	{0,1,0,0,0,0,0,0,-2,1,0,1.343287771875530056675530,0.00873},
	{0,1,0,0,0,0,0,0,-2,1,2,4.470246537819051901863077,0.00001},
	{0,1,0,0,0,0,0,0,-2,2,0,1.302886890350365423074663,0.00033},
	{0,1,0,0,0,0,0,0,-2,3,0,1.483782238805018582894490,0.00007},
	{0,1,0,0,0,0,0,0,-2,4,0,1.401314035384884748580703,0.00001},
	{0,1,0,0,0,0,0,0,-1,-1,-1,1.803632499255975796259577,0.00007},
	{0,1,0,0,0,0,0,0,-1,-1,1,4.953159943224110683956951,0.00009},
	{0,1,0,0,0,0,0,0,-1,0,-1,1.803057064201593062691131,0.00077},
	{0,1,0,0,0,0,0,0,-1,0,0,4.503881650498859912090666,0.00022},
	{0,1,0,0,0,0,0,0,-1,0,1,4.945202987164268648712095,0.00198},
	{0,1,0,0,0,0,0,0,-1,1,-1,1.789405796924194325114854,0.00045},
	{0,1,0,0,0,0,0,0,-1,1,1,4.945285541237888438104164,0.00022},
	{0,1,0,0,0,0,0,0,-1,2,-1,1.731065723215331031425990,0.00001},
	{0,1,0,0,0,0,0,0,-1,2,1,4.945191467991205236387486,0.00001},
	{0,1,0,0,0,0,0,0,0,-3,0,1.473777836999661694505903,0.00003},
	{0,1,0,0,0,0,0,0,0,-2,0,1.409803316866585110034293,0.00049},
	{0,1,0,0,0,0,0,0,0,-1,0,1.425993863672710526557807,0.00654},
	{0,1,0,0,0,0,0,0,0,0,-1,4.936953339388866268677702,0.00012},
	{0,1,0,0,0,0,0,0,0,0,0,1.435236429259571844241350,0.01457},
	{0,1,0,0,0,0,0,0,0,0,1,1.803578743115014315634426,0.00005},
	{0,1,0,0,0,0,0,0,0,1,0,1.417714719832950276412475,0.00191},
	{0,1,0,0,0,0,0,0,0,2,0,1.451904149083192319125146,0.00011},
	{0,1,0,0,0,0,0,0,1,-2,-1,1.803538600542218484079626,0.00009},
	{0,1,0,0,0,0,0,0,1,-2,0,4.603177445902097097985006,0.00001},
	{0,1,0,0,0,0,0,0,1,-2,1,4.947590597580997062721053,0.00003},
	{0,1,0,0,0,0,0,0,1,-1,-1,1.803511198872962184580615,0.00141},
	{0,1,0,0,0,0,0,0,1,-1,0,4.718969569796409579964802,0.00003},
	{0,1,0,0,0,0,0,0,1,-1,1,4.945169302309705194886646,0.00088},
	{0,1,0,0,0,0,0,0,1,0,-3,4.945058822968054101920643,0.00001},
	{0,1,0,0,0,0,0,0,1,0,-1,1.803513467800989644729270,0.00894},
	{0,1,0,0,0,0,0,0,1,0,0,4.731456702462727648139662,0.00017},
	{0,1,0,0,0,0,0,0,1,0,1,4.945087969966562191359571,0.00114},
	{0,1,0,0,0,0,0,0,1,1,-1,1.804385259762361082280790,0.00126},
	{0,1,0,0,0,0,0,0,1,1,1,4.945105074193230976220548,0.00012},
	{0,1,0,0,0,0,0,0,1,2,-1,1.803536506147116025289279,0.00009},
	{0,1,0,0,0,0,0,0,2,-3,0,4.705037304509438911281904,0.00004},
	{0,1,0,0,0,0,0,0,2,-3,1,4.929409851828822297648003,0.00003},
	{0,1,0,0,0,0,0,0,2,-2,0,4.639134021019983400435649,0.00195},
	{0,1,0,0,0,0,0,0,2,-2,1,1.803652221476523376253454,0.00003},
	{0,1,0,0,0,0,0,0,2,-1,-1,1.803468961905063894235468,0.00004},
	{0,1,0,0,0,0,0,0,2,-1,0,4.715995005152235464152000,0.00821},
	{0,1,0,0,0,0,0,0,2,0,-1,1.803579266713789985843164,0.00020},
	{0,1,0,0,0,0,0,0,2,0,0,4.805093190801919433852163,0.00062},
	{0,1,0,0,0,0,0,0,2,1,0,4.744538992403976251921449,0.00005},
	{0,1,0,0,0,0,0,0,3,-2,-1,4.945143645969701573505972,0.00002},
	{0,1,0,0,0,0,0,0,3,-1,-1,4.944991278726002192911437,0.00018},
	{0,1,0,0,0,0,0,0,3,-1,1,4.945060742830231781397288,0.00002},
	{0,1,0,0,0,0,0,0,3,0,-1,1.803566525810250231742771,0.00008},
	{0,1,0,0,0,0,0,0,3,1,-1,1.803515213130241656713793,0.00001},
	{0,1,0,0,0,0,0,0,4,-3,0,4.634162450645677999716554,0.00003},
	{0,1,0,0,0,0,0,0,4,-2,0,4.776150919414873463608728,0.00009},
	{0,1,0,0,0,0,0,0,4,-1,0,4.726225601628650352381555,0.00007},
	{0,1,0,0,1,0,0,0,-2,0,0,1.403823295250476999029843,0.00001},
	{0,1,0,0,1,0,0,0,-2,2,0,4.545415948840270559117016,0.00001},
	{0,1,0,0,1,0,0,0,0,0,0,1.649693062966674172997728,0.00001},
	{0,1,0,0,1,0,0,0,2,-3,0,4.988314539550705362103145,0.00002},
	{0,1,0,0,1,0,0,0,2,-2,0,4.625030015334617772282400,0.00002},
	{0,1,0,0,1,0,0,0,2,-1,0,5.278036577387886119083760,0.00006},
	{0,1,0,0,1,0,0,0,2,0,0,2.647375623284192958095673,0.00001},
	{0,1,0,0,2,0,0,0,2,-3,0,2.617860185770791936477053,0.00004},
	{0,1,0,0,2,0,0,0,2,-2,0,5.982958132574651699542301,0.00002},
	{0,1,0,0,2,0,0,0,2,-1,0,1.947837536175203831945169,0.00003},
	{0,1,1,-5,0,0,0,0,0,0,0,1.753536837334757958473119,0.00002},
	{0,1,1,-3,0,0,0,0,1,0,-1,4.234220427084102844617064,0.00001},
	{0,1,1,-2,0,0,0,0,-2,0,0,3.143882001969634298887968,0.00003},
	{0,1,1,-2,0,0,0,0,-2,1,0,0.000902684289131467309207,0.00003},
	{0,1,1,-2,0,0,0,0,-2,3,0,0.000902684289131467309207,0.00001},
	{0,1,1,-2,0,0,0,0,0,-1,0,0.000902684289131467309207,0.00001},
	{0,1,1,-2,0,0,0,0,0,0,0,4.049200865606986887712537,0.00001},
	{0,1,1,-2,0,0,0,0,0,1,0,0.000902684289131467309207,0.00001},
	{0,1,1,-2,0,0,0,0,2,-3,0,3.207471153403870456344293,0.00001},
	{0,1,1,-2,0,0,0,0,2,-1,0,3.207471153403870456344293,0.00001},
	{0,1,1,-1,0,0,0,0,2,0,-2,0.654180994106935864706998,0.00002},
	{0,1,1,0,-4,0,0,0,0,0,0,3.485228261086929180123661,0.00001},
	{0,1,1,0,-3,0,0,0,-2,0,0,3.342951463925304178559372,0.00004},
	{0,1,1,0,-3,0,0,0,-2,2,0,0.159697102958705539066386,0.00001},
	{0,1,1,0,-2,0,0,0,-2,1,0,3.142345414096177957929967,0.00009},
	{0,1,1,0,-2,0,0,0,-2,3,0,0.002577676772270425225447,0.00001},
	{0,1,1,0,-2,0,0,0,0,-1,0,3.142690814755147776793365,0.00002},
	{0,1,1,0,-2,0,0,0,0,0,0,3.154893982352167114413533,0.00005},
	{0,1,1,0,-2,0,0,0,0,1,0,3.142690814755147776793365,0.00002},
	{0,1,1,0,-2,0,0,0,2,-3,0,0.005954016210253455614054,0.00001},
	{0,1,1,0,-2,0,0,0,2,-1,0,3.144076082582456077574307,0.00005},
	{0,1,1,0,-2,0,0,0,2,0,0,0.001637816970071478929125,0.00002},
	{0,1,1,0,-1,0,0,0,-2,0,0,1.582192279612868457405739,0.00003},
	{0,1,1,0,-1,0,0,0,-2,2,0,1.582192279612868457405739,0.00003},
	{0,1,1,0,-1,0,0,0,0,-2,0,6.036178631988639686767328,0.00003},
	{0,1,1,0,-1,0,0,0,0,0,0,3.301499196058737872760958,0.00003},
	{0,1,1,0,0,0,0,0,-4,0,0,1.680654505765352801915924,0.00001},
	{0,1,1,0,0,0,0,0,-4,1,0,6.087670906377303126078004,0.00004},
	{0,1,1,0,0,0,0,0,-2,-1,0,6.140598015944031651258683,0.00009},
	{0,1,1,0,0,0,0,0,-2,0,0,6.208409816970543282366179,0.00087},
	{0,1,1,0,0,0,0,0,-2,1,0,6.235461896777679591252763,0.00067},
	{0,1,1,0,0,0,0,0,-2,2,0,0.034908853967914182936383,0.00006},
	{0,1,1,0,0,0,0,0,-1,0,-1,0.173970580114440359631445,0.00004},
	{0,1,1,0,0,0,0,0,-1,0,0,3.569499564157298188149525,0.00005},
	{0,1,1,0,0,0,0,0,-1,0,1,3.319721829712960481373329,0.00011},
	{0,1,1,0,0,0,0,0,-1,1,-1,0.173970405581515191739683,0.00001},
	{0,1,1,0,0,0,0,0,0,-2,0,0.300926528036208729144363,0.00002},
	{0,1,1,0,0,0,0,0,0,-1,0,0.124469028270601606012136,0.00041},
	{0,1,1,0,0,0,0,0,0,0,0,0.388915033347475236347179,0.00273},
	{0,1,1,0,0,0,0,0,0,1,0,0.421583059088753930865323,0.00027},
	{0,1,1,0,0,0,0,0,0,2,0,0.327823797138693362462902,0.00003},
	{0,1,1,0,0,0,0,0,1,0,-1,0.221391874022827117585166,0.00016},
	{0,1,1,0,0,0,0,0,1,0,0,3.580592178751273113590514,0.00005},
	{0,1,1,0,0,0,0,0,1,0,1,3.345884838799131344444504,0.00003},
	{0,1,1,0,0,0,0,0,2,-3,0,4.887993188678996681062472,0.00002},
	{0,1,1,0,0,0,0,0,2,-2,0,0.237435987704710194101665,0.00002},
	{0,1,1,0,0,0,0,0,2,-1,0,0.378852861143877506222566,0.00066},
	{0,1,1,0,0,0,0,0,2,0,-2,0.466773298614316323185136,0.00001},
	{0,1,1,0,0,0,0,0,2,0,0,3.886707396120736124345285,0.00004},
	{0,1,1,0,0,0,0,0,3,-2,0,0.417032462130029091262884,0.00002},
	{0,1,1,0,0,0,0,0,4,-2,0,0.528516938897493737670175,0.00001},
	{0,1,1,0,2,0,0,0,2,-2,0,5.378394056575111825679869,0.00001},
	{0,1,1,0,2,0,0,0,2,-1,0,5.378394056575111825679869,0.00003},
	{0,1,1,0,2,0,0,0,2,0,0,2.236801402985318265592696,0.00001},
	{0,1,2,-6,0,0,0,0,0,0,0,4.778408677335253429419026,0.00001},
	{0,1,2,-4,0,0,0,0,-2,0,0,5.770879160907541383096486,0.00001},
	{0,1,2,-4,0,0,0,0,-2,2,0,5.770879160907541383096486,0.00001},
	{0,1,2,-3,0,0,0,0,2,-1,0,4.651688872461279267156442,0.00002},
	{0,1,2,0,-3,0,0,0,0,0,0,4.211004406439924352412163,0.00001},
	{0,1,2,0,-2,0,0,0,-2,0,0,4.700306240506058053085781,0.00002},
	{0,1,2,0,-2,0,0,0,-2,2,0,1.558713586916265159132422,0.00002},
	{0,1,2,0,-2,0,0,0,0,0,0,1.573835119555544004299463,0.00001},
	{0,1,2,0,0,0,0,0,-2,0,0,4.811499770887214921799568,0.00009},
	{0,1,2,0,0,0,0,0,-2,1,0,4.922657347485781542673067,0.00004},
	{0,1,2,0,0,0,0,0,-1,0,1,2.134298565081541809718146,0.00002},
	{0,1,2,0,0,0,0,0,0,-1,0,5.333675230480513285158395,0.00003},
	{0,1,2,0,0,0,0,0,0,0,0,5.115712404839078963902921,0.00020},
	{0,1,2,0,0,0,0,0,0,1,0,5.096114800800134680969222,0.00002},
	{0,1,2,0,0,0,0,0,1,0,-1,5.330803291196356319403549,0.00002},
	{0,1,2,0,0,0,0,0,2,-3,0,3.830285264726889238318108,0.00003},
	{0,1,2,0,0,0,0,0,2,-2,0,0.786449898804700064935957,0.00004},
	{0,1,2,0,0,0,0,0,2,-1,0,4.730419627821192740668721,0.00003},
	{0,1,2,0,0,0,0,0,2,0,0,1.271968731717136202874485,0.00004},
	{0,1,2,0,0,0,0,0,2,1,0,0.972338459716383773923098,0.00001},
	{0,1,2,0,1,0,0,0,0,0,0,2.249019754946830040864825,0.00002},
	{0,1,2,0,1,0,0,0,2,-2,0,2.214752309479023573146605,0.00001},
	{0,1,2,0,1,0,0,0,2,-1,0,2.366714113192890600601004,0.00001},
	{0,1,2,0,1,0,0,0,2,0,0,5.383366150548193118652307,0.00012},
	{0,1,2,3,0,0,0,0,2,-2,0,3.223413863456212613556318,0.00001},
	{0,1,2,3,0,0,0,0,2,0,0,3.223413863456212613556318,0.00001},
	{0,1,3,-8,0,0,0,0,0,0,0,4.276880811858899456012750,0.00001},
	{0,1,3,-8,3,0,0,0,0,0,0,1.887017873198032491544041,0.00001},
	{0,1,3,-5,0,0,0,0,0,0,0,2.628723464101054396735435,0.00001},
	{0,1,3,0,-1,0,0,0,2,-3,0,5.595522265768241965133711,0.00003},
	{0,1,3,0,-1,0,0,0,2,-2,0,5.394338162890855770115195,0.00005},
	{0,1,3,0,-1,0,0,0,2,-1,0,5.595522265768241965133711,0.00003},
	{0,1,3,0,-1,0,0,0,2,0,0,5.237383844851659198127436,0.00005},
	{0,1,3,0,0,0,0,0,-2,0,0,1.561439791207880123380392,0.00002},
	{0,1,3,0,0,0,0,0,-2,2,0,2.302206394973329572906096,0.00001},
	{0,1,3,0,0,0,0,0,0,-1,0,2.237741088254592281003852,0.00002},
	{0,1,3,0,0,0,0,0,0,0,0,3.634789189881752591304576,0.00003},
	{0,1,3,0,0,0,0,0,0,1,0,2.237741088254592281003852,0.00002},
	{0,1,3,0,0,0,0,0,1,0,0,2.237774424043305288023475,0.00002},
	{0,1,3,0,0,0,0,0,2,-2,0,2.236488290917511001509865,0.00003},
	{0,1,3,0,0,0,0,0,2,-1,0,5.352092119280482229726204,0.00002},
	{0,1,3,0,0,0,0,0,2,0,-2,5.379367077633098404021439,0.00003},
	{0,1,3,0,0,0,0,0,2,0,0,2.256692047805672007854128,0.00004},
	{0,1,3,0,0,0,0,0,2,2,0,2.237740913721666835556334,0.00002},
	{0,1,3,0,1,0,0,0,2,-2,0,1.999437497378715677953664,0.00001},
	{0,1,3,0,1,0,0,0,2,0,0,5.141030150968508571907023,0.00001},
	{0,1,4,-7,0,0,0,0,2,-1,0,5.303050810760393751763786,0.00002},
	{0,1,4,-2,0,0,0,0,2,-2,0,4.649307370696933894294034,0.00002},
	{0,1,4,-2,0,0,0,0,2,0,0,4.649307370696933894294034,0.00002},
	{0,1,4,0,-1,0,0,0,0,0,0,5.397340303737211186785316,0.00003},
	{0,1,4,0,-1,0,0,0,2,-3,0,5.397383936968510376175345,0.00003},
	{0,1,4,0,-1,0,0,0,2,-2,0,2.247692606583613361692642,0.00002},
	{0,1,4,0,-1,0,0,0,2,-1,0,5.397383936968510376175345,0.00003},
	{0,1,4,0,-1,0,0,0,2,0,0,2.249875489879082479660610,0.00003},
	{0,1,4,0,0,0,0,0,-2,0,0,5.273480046309704682983011,0.00002},
	{0,1,4,0,0,0,0,0,-2,2,0,5.273480046309704682983011,0.00002},
	{0,1,4,0,0,0,0,0,0,-2,0,2.130753626837816216976762,0.00001},
	{0,1,4,0,0,0,0,0,0,0,0,5.272346280427609777063935,0.00001},
	{0,1,4,0,0,0,0,0,2,-3,0,0.652101957901960127550467,0.00003},
	{0,1,4,0,0,0,0,0,2,-2,0,3.623372816711532440336896,0.00005},
	{0,1,4,0,0,0,0,0,2,-1,0,1.046202538990035790789079,0.00001},
	{0,1,4,0,0,0,0,0,2,0,0,5.991486858497446554849830,0.00002},
	{0,1,4,0,0,0,0,0,2,1,0,0.602061797450956004418288,0.00001},
	{0,1,5,-9,0,0,0,0,2,-1,0,4.685736057377484442554305,0.00003},
	{0,1,5,-2,0,0,0,0,2,-3,0,2.239327418011729964320011,0.00001},
	{0,1,5,-2,0,0,0,0,2,-2,0,2.237242796753148077470996,0.00002},
	{0,1,5,-2,0,0,0,0,2,-1,0,2.239327418011729964320011,0.00001},
	{0,1,5,-2,0,0,0,0,2,0,0,2.274920790112275881256210,0.00004},
	{0,1,5,0,-3,0,0,0,2,0,0,2.425877109644069218319373,0.00002},
	{0,1,5,0,-2,0,0,0,0,0,0,2.239522894887953086140442,0.00001},
	{0,1,5,0,-2,0,0,0,0,2,0,5.381115548477746202138405,0.00001},
	{0,1,5,0,-2,0,0,0,2,-3,0,5.381855393547666288611708,0.00002},
	{0,1,5,0,-2,0,0,0,2,-2,0,5.381104378370533680708832,0.00002},
	{0,1,5,0,-2,0,0,0,2,-1,0,2.240262739957873172613745,0.00002},
	{0,1,5,0,-1,0,0,0,2,-2,0,0.675422174702482336350329,0.00001},
	{0,1,5,0,-1,0,0,0,2,0,0,0.675422174702482336350329,0.00001},
	{0,1,5,0,0,0,0,0,0,-1,0,2.653118978253730553262812,0.00001},
	{0,1,5,0,0,0,0,0,0,1,0,2.653118978253730553262812,0.00001},
	{0,1,5,0,0,0,0,0,2,2,0,2.653118978253730553262812,0.00002},
	{0,1,6,-11,0,0,0,0,2,-3,0,2.483250445480252643903896,0.00002},
	{0,1,6,-11,0,0,0,0,2,-2,0,1.182131224596306928731337,0.00010},
	{0,1,6,-11,0,0,0,0,2,-1,0,2.483250445480252643903896,0.00002},
	{0,1,6,0,0,0,0,0,2,0,0,4.179061390469923864543489,0.00003},
	{0,1,9,-20,0,0,0,0,0,0,0,4.329779298025894007651004,0.00001},
	{0,1,29,-36,0,0,0,0,-2,1,0,0.179899987182240733707417,0.00001},
	{0,1,37,-51,0,0,0,0,-2,1,0,2.715854663683741510027403,0.00002},
	{0,1,43,-59,0,0,0,0,0,-2,0,1.698703828224852108164100,0.00001},
	{0,1,43,-59,0,0,0,0,0,-1,0,1.698703828224852108164100,0.00024},
	{0,1,43,-59,0,0,0,0,0,0,0,1.698703828224852108164100,0.00001},
	{0,2,-13,15,0,0,0,0,-4,1,0,5.164957742348724956116257,0.00001},
	{0,2,-13,15,0,0,0,0,-4,2,0,5.164957742348724956116257,0.00009},
	{0,2,-13,15,0,0,0,0,-4,3,0,5.078252752169374772961419,0.00015},
	{0,2,-13,15,0,0,0,0,-2,0,0,5.262058262618803716748062,0.00001},
	{0,2,-13,15,0,0,0,0,-2,1,0,5.077531407589525258572394,0.00028},
	{0,2,-13,15,0,0,0,0,-2,2,-2,2.023365088758931840118294,0.00002},
	{0,2,-13,15,0,0,0,0,-2,2,0,5.164957742348724956116257,0.00808},
	{0,2,-13,15,0,0,0,0,-2,2,2,2.023365088758931840118294,0.00002},
	{0,2,-13,15,0,0,0,0,-2,3,0,5.610183555083770201576954,0.00015},
	{0,2,-13,15,0,0,0,0,-2,4,0,5.262058262618803716748062,0.00001},
	{0,2,-13,15,0,0,0,0,0,1,0,5.205479051592277528470731,0.00012},
	{0,2,-13,15,0,0,0,0,0,2,0,5.164957742348724956116257,0.00009},
	{0,2,-13,15,0,0,0,0,0,3,0,5.164957742348724956116257,0.00001},
	{0,2,-11,0,0,0,0,0,-2,0,0,5.054904261034971035826402,0.00001},
	{0,2,-11,0,0,0,0,0,-2,2,0,5.054904261034971035826402,0.00001},
	{0,2,-10,11,0,0,0,0,0,0,0,1.521126176145315200827213,0.00001},
	{0,2,-9,0,0,0,0,0,-2,1,0,2.114608633125167891364526,0.00002},
	{0,2,-9,0,2,0,0,0,-2,0,0,5.629591267300096291137379,0.00002},
	{0,2,-9,8,0,0,0,0,0,0,0,0.811520506312047418262523,0.00001},
	{0,2,-9,11,0,0,0,0,0,0,0,5.957915799401186873751612,0.00001},
	{0,2,-8,0,0,0,0,0,-2,-1,0,3.721725959785767479104379,0.00001},
	{0,2,-8,0,0,0,0,0,-2,1,0,3.721725959785767479104379,0.00001},
	{0,2,-8,0,0,0,0,0,0,0,0,3.493379123226667992696548,0.00001},
	{0,2,-8,0,2,0,0,0,-2,0,0,4.043609703348223227692415,0.00004},
	{0,2,-8,0,2,0,0,0,-2,1,0,4.042830937435982541217072,0.00002},
	{0,2,-8,0,2,0,0,0,0,0,0,4.042903892198716597761177,0.00002},
	{0,2,-8,0,3,0,0,0,-2,0,0,3.872712124447768911039702,0.00001},
	{0,2,-8,0,3,0,0,0,-2,2,0,3.872712124447768911039702,0.00001},
	{0,2,-8,2,0,0,0,0,-2,0,0,4.047562874103990182561574,0.00002},
	{0,2,-8,2,0,0,0,0,-2,1,0,0.903702688750006033480133,0.00003},
	{0,2,-8,2,0,0,0,0,-2,2,0,4.047562874103990182561574,0.00002},
	{0,2,-8,2,0,0,0,0,-2,3,0,0.903702688750006033480133,0.00003},
	{0,2,-8,5,0,0,0,0,-2,0,2,5.624575016496939028343149,0.00001},
	{0,2,-8,6,0,0,0,0,0,0,0,0.004698949945144333464886,0.00001},
	{0,2,-8,7,0,0,0,0,0,0,0,0.302584939891453685856249,0.00002},
	{0,2,-8,7,0,0,0,0,2,0,0,0.037775033665539275995471,0.00002},
	{0,2,-8,9,0,0,0,0,-2,0,0,4.604270196546771387602348,0.00002},
	{0,2,-8,9,0,0,0,0,-2,1,0,4.604270196546771387602348,0.00002},
	{0,2,-8,9,0,0,0,0,0,-1,0,4.563035047639153241050280,0.00004},
	{0,2,-8,9,0,0,0,0,0,0,0,4.604270196546771387602348,0.00017},
	{0,2,-8,9,0,0,0,0,0,1,0,4.563035047639153241050280,0.00004},
	{0,2,-8,9,0,0,0,0,2,-1,0,4.604270196546771387602348,0.00002},
	{0,2,-8,9,0,0,0,0,2,0,0,4.604270196546771387602348,0.00002},
	{0,2,-7,0,0,0,0,0,-2,-1,0,5.655127877717725404238536,0.00002},
	{0,2,-7,0,0,0,0,0,-2,0,0,2.416588467364955139515814,0.00004},
	{0,2,-7,0,0,0,0,0,-2,1,0,2.304826483246423141082460,0.00004},
	{0,2,-7,0,0,0,0,0,-2,2,0,6.015439059020116552289892,0.00002},
	{0,2,-7,0,0,0,0,0,-2,3,0,2.663274700105235481828458,0.00005},
	{0,2,-7,0,0,0,0,0,0,-2,0,2.491557165522193972861942,0.00001},
	{0,2,-7,0,0,0,0,0,0,0,0,2.742129897440815256004498,0.00005},
	{0,2,-7,0,0,0,0,0,0,2,0,1.991922284152553013214515,0.00002},
	{0,2,-7,0,0,0,0,0,2,-1,0,5.744314202494636312223975,0.00005},
	{0,2,-7,0,1,0,0,0,-2,2,0,0.893751170420984730746738,0.00002},
	{0,2,-7,0,1,0,0,0,-2,3,0,4.035343998543702959125312,0.00001},
	{0,2,-7,0,1,0,0,0,0,-1,0,4.022425769552142149620977,0.00002},
	{0,2,-7,0,1,0,0,0,0,1,0,4.022425769552142149620977,0.00002},
	{0,2,-7,0,2,0,0,0,-2,0,0,5.093267819724282219340239,0.00005},
	{0,2,-7,2,0,0,0,0,-2,0,0,4.572431551266039839731548,0.00001},
	{0,2,-7,3,0,0,0,0,-2,0,0,5.037488144028094083637370,0.00001},
	{0,2,-7,3,0,0,0,0,-2,0,2,5.043523318048565684534879,0.00004},
	{0,2,-7,3,0,0,0,0,-2,2,0,5.037488144028094083637370,0.00001},
	{0,2,-7,6,0,0,0,0,0,0,0,0.150444763528033209620816,0.00001},
	{0,2,-7,7,0,0,0,0,-2,0,0,4.096042710203711578742514,0.00006},
	{0,2,-7,7,0,0,0,0,-2,1,0,4.085767084232594825721208,0.00008},
	{0,2,-7,7,0,0,0,0,0,-1,0,4.148544483031728624666812,0.00009},
	{0,2,-7,7,0,0,0,0,0,0,0,4.107067082423933257473436,0.00053},
	{0,2,-7,7,0,0,0,0,0,1,0,4.148068706277634909440621,0.00009},
	{0,2,-7,7,0,0,0,0,2,-1,0,4.084268020938057297541945,0.00009},
	{0,2,-7,7,0,0,0,0,2,0,0,4.094455682314873001814703,0.00006},
	{0,2,-6,0,-1,0,0,0,-2,0,0,1.019900427162481193477106,0.00002},
	{0,2,-6,0,-1,0,0,0,-2,1,0,1.147446994503124484410250,0.00001},
	{0,2,-6,0,-1,0,0,0,-2,2,0,1.147446994503124484410250,0.00001},
	{0,2,-6,0,-1,0,0,0,-2,3,0,4.289039648092917822452819,0.00001},
	{0,2,-6,0,0,0,0,0,-4,0,0,4.045415071926486305642356,0.00002},
	{0,2,-6,0,0,0,0,0,-4,3,0,1.128192696728048227683416,0.00001},
	{0,2,-6,0,0,0,0,0,-3,2,0,4.045415071926486305642356,0.00001},
	{0,2,-6,0,0,0,0,0,-3,4,0,4.045415071926486305642356,0.00001},
	{0,2,-6,0,0,0,0,0,-2,0,0,0.916335730941791326564783,0.00010},
	{0,2,-6,0,0,0,0,0,-2,1,0,4.824483798791576738551612,0.00003},
	{0,2,-6,0,0,0,0,0,-2,2,0,0.905924492887794752249420,0.00007},
	{0,2,-6,0,0,0,0,0,-2,3,0,4.142607221982294696260851,0.00008},
	{0,2,-6,0,0,0,0,0,0,-1,0,0.905970569580047402347134,0.00001},
	{0,2,-6,0,0,0,0,0,0,0,0,5.664925458006721648018811,0.00005},
	{0,2,-6,0,0,0,0,0,0,1,0,0.545514351416816034578972,0.00004},
	{0,2,-6,0,0,0,0,0,2,0,0,3.742591545526284591005606,0.00002},
	{0,2,-6,0,1,0,0,0,-2,0,0,5.671627173268529276128902,0.00003},
	{0,2,-6,0,1,0,0,0,-2,2,0,3.856321388376439784906324,0.00001},
	{0,2,-6,2,0,0,0,0,-2,1,0,3.733121039939113039451968,0.00002},
	{0,2,-6,2,0,0,0,0,-2,2,0,0.073756741524654376163106,0.00001},
	{0,2,-6,2,0,0,0,0,-2,3,0,3.733121039939113039451968,0.00002},
	{0,2,-6,3,0,0,0,0,0,0,0,5.565956562772383264814380,0.00002},
	{0,2,-6,5,0,0,0,0,-2,0,0,3.645891752852463696399354,0.00002},
	{0,2,-6,5,0,0,0,0,0,0,0,3.891830984672890458853090,0.00008},
	{0,2,-6,5,0,0,0,0,2,0,0,3.645891752852463696399354,0.00001},
	{0,2,-6,6,0,0,0,0,0,0,0,0.983286910114144152572635,0.00002},
	{0,2,-6,8,-3,0,0,0,-2,0,0,4.401176005336002283740982,0.00002},
	{0,2,-6,8,-3,0,0,0,0,0,0,4.398182067537130812695523,0.00003},
	{0,2,-5,-3,0,0,0,0,-2,0,0,6.201375441953304701314664,0.00001},
	{0,2,-5,-3,0,0,0,0,-2,1,0,3.059782788363511585316701,0.00001},
	{0,2,-5,-3,0,0,0,0,-2,2,0,6.201375441953304701314664,0.00001},
	{0,2,-5,-3,0,0,0,0,-2,3,0,3.059782788363511585316701,0.00001},
	{0,2,-5,-2,0,0,0,0,-2,0,0,0.193877456496837297095226,0.00003},
	{0,2,-5,-2,0,0,0,0,-2,2,0,0.192420281104347251632802,0.00002},
	{0,2,-5,0,-2,0,0,0,-2,1,0,5.960208812972456193790549,0.00007},
	{0,2,-5,0,-1,0,0,0,-2,0,0,4.115296484380012387305214,0.00001},
	{0,2,-5,0,-1,0,0,0,-2,1,0,2.648176729410858243340954,0.00004},
	{0,2,-5,0,0,-1,0,0,-2,1,0,4.082169786111308873444159,0.00003},
	{0,2,-5,0,0,-1,0,0,-2,2,0,1.105942366758998485209986,0.00002},
	{0,2,-5,0,0,0,-2,0,-2,1,0,5.900617861788688855995133,0.00004},
	{0,2,-5,0,0,0,-2,0,-2,2,0,3.059553277566874562864996,0.00011},
	{0,2,-5,0,0,0,0,0,-4,0,0,2.041986704680160080727092,0.00002},
	{0,2,-5,0,0,0,0,0,-4,1,0,1.181039521149184645665287,0.00002},
	{0,2,-5,0,0,0,0,0,-4,2,0,1.188714432001904519609070,0.00004},
	{0,2,-5,0,0,0,0,0,-2,-2,0,2.336398442217449744617852,0.00001},
	{0,2,-5,0,0,0,0,0,-2,0,0,1.395164542298408028031531,0.00017},
	{0,2,-5,0,0,0,0,0,-2,1,0,1.180024088590374109486447,0.00200},
	{0,2,-5,0,0,0,0,0,-2,2,0,1.205830003311586740011307,0.00133},
	{0,2,-5,0,0,0,0,0,-2,3,0,0.951922645324105309860840,0.00012},
	{0,2,-5,0,0,0,0,0,-1,0,1,4.164744280082889105187860,0.00007},
	{0,2,-5,0,0,0,0,0,0,-1,0,4.209339536866447240015532,0.00004},
	{0,2,-5,0,0,0,0,0,0,0,0,4.169135353947981847966275,0.00037},
	{0,2,-5,0,0,0,0,0,0,1,0,4.261204439050411352241099,0.00042},
	{0,2,-5,0,0,0,0,0,1,0,-1,1.086317186517873567552783,0.00004},
	{0,2,-5,0,0,0,0,0,2,-1,0,2.294267241271857660223077,0.00013},
	{0,2,-5,0,0,0,0,0,2,0,0,2.564956289083115237303900,0.00014},
	{0,2,-5,0,0,0,0,0,2,1,0,2.264173750710195776036926,0.00002},
	{0,2,-5,0,0,1,0,0,-2,1,0,0.849975869320014010277475,0.00003},
	{0,2,-5,0,1,0,0,0,-2,1,0,1.047310124933351405118742,0.00005},
	{0,2,-5,0,1,0,0,0,-2,2,0,4.024571128268693342988627,0.00001},
	{0,2,-5,0,1,0,0,0,-2,3,0,2.120361761938516664827148,0.00001},
	{0,2,-5,0,2,0,0,0,-2,1,0,4.724860405087740744534130,0.00002},
	{0,2,-5,2,0,0,0,0,0,0,0,5.005825078870114630547050,0.00001},
	{0,2,-5,3,0,0,0,0,0,0,0,3.277711929150382008657516,0.00005},
	{0,2,-5,4,0,0,0,0,0,-1,0,3.658168398810992094638550,0.00002},
	{0,2,-5,4,0,0,0,0,0,1,0,3.658168398810992094638550,0.00002},
	{0,2,-5,4,0,0,0,0,2,-2,0,0.516575745221198867618284,0.00001},
	{0,2,-5,4,0,0,0,0,2,0,0,0.516575745221198867618284,0.00001},
	{0,2,-5,5,0,0,0,0,0,0,0,1.003987736773273242718574,0.00002},
	{0,2,-5,6,0,0,0,0,0,0,0,1.506908025926868566202188,0.00001},
	{0,2,-4,-2,0,0,0,0,-2,1,0,5.361766304791361292814145,0.00002},
	{0,2,-4,-2,0,0,0,0,-2,2,0,1.917573876011472666647251,0.00002},
	{0,2,-4,-2,0,0,0,0,-2,3,0,5.361766304791361292814145,0.00002},
	{0,2,-4,0,-2,0,0,0,-2,0,0,0.904802595244612706260057,0.00002},
	{0,2,-4,0,-2,0,0,0,-2,1,0,0.904802595244612706260057,0.00003},
	{0,2,-4,0,-1,0,0,0,0,0,0,4.141634549990158120635897,0.00001},
	{0,2,-4,0,0,0,0,0,-4,0,0,6.206249797488275099510702,0.00001},
	{0,2,-4,0,0,0,0,0,-4,1,0,3.390439080345266642524393,0.00002},
	{0,2,-4,0,0,0,0,0,-2,-1,0,3.252002880202655266117517,0.00003},
	{0,2,-4,0,0,0,0,0,-2,0,0,3.413837313363353054285199,0.00027},
	{0,2,-4,0,0,0,0,0,-2,0,2,3.369708583088853348641578,0.00002},
	{0,2,-4,0,0,0,0,0,-2,1,0,5.686823929598569193899493,0.00033},
	{0,2,-4,0,0,0,0,0,-2,2,0,6.094396358116939360627384,0.00004},
	{0,2,-4,0,0,0,0,0,-2,3,0,3.272570363706932106140357,0.00002},
	{0,2,-4,0,0,0,0,0,-1,-1,0,2.763543342033533800616851,0.00004},
	{0,2,-4,0,0,0,0,0,-1,-1,1,6.117359829618353117552942,0.00004},
	{0,2,-4,0,0,0,0,0,-1,0,-1,5.122339070943050742812375,0.00002},
	{0,2,-4,0,0,0,0,0,-1,0,0,2.746635639437764009329612,0.00053},
	{0,2,-4,0,0,0,0,0,-1,0,1,6.279120260818766396937463,0.00007},
	{0,2,-4,0,0,0,0,0,-1,1,-1,6.154836411981801091997113,0.00056},
	{0,2,-4,0,0,0,0,0,-1,1,0,2.717291593256908388553938,0.00015},
	{0,2,-4,0,0,0,0,0,-1,1,1,6.117359829618353117552942,0.00004},
	{0,2,-4,0,0,0,0,0,-1,2,-1,3.011624092846157285663367,0.00031},
	{0,2,-4,0,0,0,0,0,-1,2,0,3.184800024552164376956398,0.00002},
	{0,2,-4,0,0,0,0,0,-1,3,-1,3.010736418388593182982049,0.00001},
	{0,2,-4,0,0,0,0,0,0,-2,0,2.904958819209299658581358,0.00008},
	{0,2,-4,0,0,0,0,0,0,-1,0,2.666490643784960035134191,0.00078},
	{0,2,-4,0,0,0,0,0,0,0,0,2.257961076704797065417551,0.00413},
	{0,2,-4,0,0,0,0,0,0,1,0,1.765604218315972140374015,0.00060},
	{0,2,-4,0,0,0,0,0,0,2,0,1.549164716045678735767410,0.00004},
	{0,2,-4,0,0,0,0,0,1,-1,0,5.896113341522217332624223,0.00001},
	{0,2,-4,0,0,0,0,0,1,-1,1,2.960213674399412742133109,0.00005},
	{0,2,-4,0,0,0,0,0,1,0,-1,6.106541755315716635266199,0.00018},
	{0,2,-4,0,0,0,0,0,1,0,0,5.842760371618002324112240,0.00017},
	{0,2,-4,0,0,0,0,0,1,0,1,2.962915793147350207448198,0.00005},
	{0,2,-4,0,0,0,0,0,1,1,-1,3.019588204755932814293828,0.00012},
	{0,2,-4,0,0,0,0,0,2,-2,0,0.494267295788057781091851,0.00009},
	{0,2,-4,0,0,0,0,0,2,-1,0,0.335342675556284885995950,0.00259},
	{0,2,-4,0,0,0,0,0,2,0,-2,0.316190828608300722457614,0.00004},
	{0,2,-4,0,0,0,0,0,2,0,0,0.331764750589696510996163,0.00226},
	{0,2,-4,0,0,0,0,0,2,1,0,0.287992940147229925518246,0.00024},
	{0,2,-4,0,0,0,0,0,2,2,0,0.334107506044648505660888,0.00002},
	{0,2,-4,0,0,0,0,0,4,-2,0,0.290069358358327589186842,0.00005},
	{0,2,-4,0,0,0,0,0,4,-1,0,0.372307527383048397773280,0.00007},
	{0,2,-4,0,0,0,0,0,4,0,0,1.149696723908945061864983,0.00002},
	{0,2,-4,0,0,0,0,0,4,1,0,3.340377103278612480607990,0.00001},
	{0,2,-4,0,1,0,0,0,0,0,0,4.383051982784517797142598,0.00003},
	{0,2,-4,0,1,0,0,0,2,0,0,1.559531622736674671969581,0.00005},
	{0,2,-4,0,2,0,0,0,-2,0,0,3.139966181259859823171610,0.00003},
	{0,2,-4,0,2,0,0,0,-2,1,0,3.139966181259859823171610,0.00002},
	{0,2,-4,0,2,0,0,0,0,-2,0,3.149162321088617488840100,0.00001},
	{0,2,-4,0,2,0,0,0,0,-1,0,3.138564681870508632499650,0.00002},
	{0,2,-4,0,2,0,0,0,0,0,0,3.164621051339381985201271,0.00013},
	{0,2,-4,0,2,0,0,0,0,1,0,3.138564681870508632499650,0.00002},
	{0,2,-4,0,2,0,0,0,0,2,0,3.146350421130729824170658,0.00001},
	{0,2,-4,0,2,0,0,0,2,-1,0,3.138963489604588819048558,0.00003},
	{0,2,-4,0,2,0,0,0,2,0,0,3.138963489604588819048558,0.00003},
	{0,2,-4,0,3,0,0,0,0,0,0,3.053215288921182324344272,0.00002},
	{0,2,-4,1,0,0,0,0,0,0,0,4.831855545953224861932540,0.00003},
	{0,2,-4,2,0,0,0,0,-2,0,0,6.260217821420892114758772,0.00003},
	{0,2,-4,2,0,0,0,0,-2,2,0,6.225879515585454271331400,0.00001},
	{0,2,-4,2,0,0,0,0,0,-1,0,6.267546982548791945077937,0.00004},
	{0,2,-4,2,0,0,0,0,0,0,0,0.021006782877003749021583,0.00009},
	{0,2,-4,2,0,0,0,0,0,1,0,6.267546982548791945077937,0.00004},
	{0,2,-4,2,0,0,0,0,2,-2,0,3.132108359901530914015666,0.00001},
	{0,2,-4,2,0,0,0,0,2,0,0,3.140145077508189164205987,0.00004},
	{0,2,-4,4,0,0,0,0,-2,0,0,1.011866676615551297047091,0.00001},
	{0,2,-4,4,0,0,0,0,-2,2,0,1.011866676615551297047091,0.00001},
	{0,2,-4,4,0,0,0,0,2,-3,0,1.072915850389360326033739,0.00003},
	{0,2,-4,4,0,0,0,0,2,-1,0,1.072915850389360326033739,0.00003},
	{0,2,-3,-4,0,0,0,0,-2,1,0,4.417232859921425003335571,0.00002},
	{0,2,-3,-4,0,0,0,0,-2,3,0,4.417232859921425003335571,0.00002},
	{0,2,-3,-1,0,0,0,0,0,0,0,5.006004324184294418387253,0.00001},
	{0,2,-3,0,-3,0,0,0,-2,0,0,5.252477277689980184050000,0.00002},
	{0,2,-3,0,-3,0,0,0,-2,1,0,5.557416492209449998540549,0.00003},
	{0,2,-3,0,-3,0,0,0,0,-1,0,4.047183788590457353961938,0.00004},
	{0,2,-3,0,-3,0,0,0,0,0,0,0.086635526075120525280049,0.00003},
	{0,2,-3,0,-3,0,0,0,0,1,0,4.047183788590457353961938,0.00004},
	{0,2,-3,0,-3,0,0,0,2,-1,0,5.557542679514368977322647,0.00003},
	{0,2,-3,0,-3,0,0,0,2,0,0,5.252042341640383860124075,0.00002},
	{0,2,-3,0,-2,0,0,0,0,0,0,1.763905663887931352107330,0.00002},
	{0,2,-3,0,-1,0,0,0,0,-1,0,5.253951033710364981743624,0.00003},
	{0,2,-3,0,-1,0,0,0,0,0,0,2.095788922333837955847002,0.00003},
	{0,2,-3,0,-1,0,0,0,0,1,0,5.253951033710364981743624,0.00003},
	{0,2,-3,0,0,-1,0,0,0,0,0,6.216834870335770091287486,0.00001},
	{0,2,-3,0,0,0,0,0,-6,1,0,4.749050319454531710050560,0.00002},
	{0,2,-3,0,0,0,0,0,-6,2,0,4.732737250534915673938485,0.00003},
	{0,2,-3,0,0,0,0,0,-4,-1,0,4.723092561088395591184508,0.00007},
	{0,2,-3,0,0,0,0,0,-4,0,0,4.746839161825180397613622,0.00053},
	{0,2,-3,0,0,0,0,0,-4,1,0,4.740618459305221854549472,0.00121},
	{0,2,-3,0,0,0,0,0,-4,1,2,4.739505288308300201549628,0.00002},
	{0,2,-3,0,0,0,0,0,-4,2,0,4.740369051755111584611768,0.00082},
	{0,2,-3,0,0,0,0,0,-4,3,0,4.732209113903262043265840,0.00002},
	{0,2,-3,0,0,0,0,0,-3,-1,0,4.743199801268921156349734,0.00001},
	{0,2,-3,0,0,0,0,0,-3,0,1,4.479053294691690112472315,0.00001},
	{0,2,-3,0,0,0,0,0,-3,1,0,1.585849093461646930336428,0.00005},
	{0,2,-3,0,0,0,0,0,-3,1,1,0.359680942909495426906830,0.00002},
	{0,2,-3,0,0,0,0,0,-2,-3,0,4.733489312909600066348048,0.00002},
	{0,2,-3,0,0,0,0,0,-2,-2,-2,1.602495694801318260047651,0.00001},
	{0,2,-3,0,0,0,0,0,-2,-2,0,4.732288351851303254136383,0.00033},
	{0,2,-3,0,0,0,0,0,-2,-1,-2,1.588998540096870693005826,0.00002},
	{0,2,-3,0,0,0,0,0,-2,-1,0,4.732652602066194091889884,0.00395},
	{0,2,-3,0,0,0,0,0,-2,-1,2,1.588027787966911352768307,0.00009},
	{0,2,-3,0,0,0,0,0,-2,0,-2,1.580827781203659077036150,0.00008},
	{0,2,-3,0,0,0,0,0,-2,0,0,4.736490930157180478943246,0.04214},
	{0,2,-3,0,0,0,0,0,-2,0,1,4.478125128595479509385768,0.00003},
	{0,2,-3,0,0,0,0,0,-2,0,2,4.740040755322811882876977,0.00082},
	{0,2,-3,0,0,0,0,0,-2,1,-2,1.595497099033746257745747,0.00014},
	{0,2,-3,0,0,0,0,0,-2,1,-1,4.491164657970053930569065,0.00001},
	{0,2,-3,0,0,0,0,0,-2,1,0,4.739725199794051491153368,0.06188},
	{0,2,-3,0,0,0,0,0,-2,1,2,4.728647245965793111110997,0.00003},
	{0,2,-3,0,0,0,0,0,-2,2,0,4.741097203119043257402154,0.00232},
	{0,2,-3,0,0,0,0,0,-2,3,0,4.744316113858497274691217,0.00015},
	{0,2,-3,0,0,0,0,0,-1,-2,1,4.478704403374216269639874,0.00002},
	{0,2,-3,0,0,0,0,0,-1,-1,-1,1.963036561433271431909020,0.00001},
	{0,2,-3,0,0,0,0,0,-1,-1,0,1.582087908923599295363260,0.00015},
	{0,2,-3,0,0,0,0,0,-1,-1,1,4.478944386146365808087921,0.00038},
	{0,2,-3,0,0,0,0,0,-1,0,-1,1.340076016986010198905888,0.00012},
	{0,2,-3,0,0,0,0,0,-1,0,0,1.581766593808306975432743,0.00148},
	{0,2,-3,0,0,0,0,0,-1,0,1,4.483216603089397622738943,0.00067},
	{0,2,-3,0,0,0,0,0,-1,1,-1,1.359006381651916228747723,0.00029},
	{0,2,-3,0,0,0,0,0,-1,1,0,1.600833617754644278008413,0.00017},
	{0,2,-3,0,0,0,0,0,-1,1,1,4.483349771711324649459129,0.00013},
	{0,2,-3,0,0,0,0,0,-1,2,-1,1.337623131255257336036379,0.00003},
	{0,2,-3,0,0,0,0,0,-1,2,0,1.592486755139906451361753,0.00003},
	{0,2,-3,0,0,0,0,0,0,-4,0,4.673911102629372926742235,0.00001},
	{0,2,-3,0,0,0,0,0,0,-3,0,4.677883821072762238202358,0.00027},
	{0,2,-3,0,0,0,0,0,0,-2,-2,1.554338570080290971020531,0.00003},
	{0,2,-3,0,0,0,0,0,0,-2,0,4.689506317627642140166699,0.00408},
	{0,2,-3,0,0,0,0,0,0,-1,-2,1.556165929807128867068400,0.00016},
	{0,2,-3,0,0,0,0,0,0,-1,-1,4.491417556178667780386604,0.00006},
	{0,2,-3,0,0,0,0,0,0,-1,0,4.689638264519093269200312,0.06030},
	{0,2,-3,0,0,0,0,0,0,-1,1,1.332808640513631015522833,0.00002},
	{0,2,-3,0,0,0,0,0,0,-1,2,4.709401151238200355919616,0.00007},
	{0,2,-3,0,0,0,0,0,0,0,-2,1.601315503161119924158129,0.00015},
	{0,2,-3,0,0,0,0,0,0,0,-1,4.491141445091002104561539,0.00089},
	{0,2,-3,0,0,0,0,0,0,0,0,4.711584907198296257035963,0.34355},
	{0,2,-3,0,0,0,0,0,0,0,1,1.336532475005685949298595,0.00016},
	{0,2,-3,0,0,0,0,0,0,0,2,1.582905421145233137991681,0.00021},
	{0,2,-3,0,0,0,0,0,0,1,-2,4.573574392860246362602084,0.00012},
	{0,2,-3,0,0,0,0,0,0,1,-1,4.477908184169456795586939,0.00033},
	{0,2,-3,0,0,0,0,0,0,1,0,4.687408955465521387395711,0.05540},
	{0,2,-3,0,0,0,0,0,0,1,2,1.549746085219518176856468,0.00012},
	{0,2,-3,0,0,0,0,0,0,2,-2,1.380170069628674500705756,0.00001},
	{0,2,-3,0,0,0,0,0,0,2,-1,4.490017627585642934207044,0.00002},
	{0,2,-3,0,0,0,0,0,0,2,0,4.687463584271108985035426,0.00378},
	{0,2,-3,0,0,0,0,0,0,2,2,1.554688857661166156987065,0.00003},
	{0,2,-3,0,0,0,0,0,0,3,0,4.689961150430712599757044,0.00025},
	{0,2,-3,0,0,0,0,0,0,4,0,4.669296452087099424943517,0.00001},
	{0,2,-3,0,0,0,0,0,1,-2,-1,4.478152530264735808884780,0.00003},
	{0,2,-3,0,0,0,0,0,1,-2,1,1.336851346660025363632940,0.00008},
	{0,2,-3,0,0,0,0,0,1,-1,-1,4.478104359177380366929810,0.00045},
	{0,2,-3,0,0,0,0,0,1,-1,0,4.651827277070963440053220,0.00006},
	{0,2,-3,0,0,0,0,0,1,-1,1,1.337851245788492793309388,0.00118},
	{0,2,-3,0,0,0,0,0,1,0,-1,4.477895966864692489650679,0.00397},
	{0,2,-3,0,0,0,0,0,1,0,0,2.093041075959498176217721,0.00008},
	{0,2,-3,0,0,0,0,0,1,0,1,1.346155871435332551655506,0.00083},
	{0,2,-3,0,0,0,0,0,1,1,-1,4.476441933064855938084747,0.00056},
	{0,2,-3,0,0,0,0,0,1,1,0,1.527953555113266581599873,0.00002},
	{0,2,-3,0,0,0,0,0,1,1,1,1.343772275275883831824331,0.00007},
	{0,2,-3,0,0,0,0,0,1,2,-1,4.478143978151400972365082,0.00003},
	{0,2,-3,0,0,0,0,0,1,2,0,4.721415823276004175568232,0.00001},
	{0,2,-3,0,0,0,0,0,2,-3,0,4.735081576786194901274030,0.00004},
	{0,2,-3,0,0,0,0,0,2,-2,0,4.749695218613143588015646,0.00106},
	{0,2,-3,0,0,0,0,0,2,-2,2,1.582451635539714684952628,0.00001},
	{0,2,-3,0,0,0,0,0,2,-1,0,4.730159922828495844271401,0.03451},
	{0,2,-3,0,0,0,0,0,2,-1,2,1.592010978385812736135563,0.00007},
	{0,2,-3,0,0,0,0,0,2,0,-2,4.709162564729452604694870,0.00058},
	{0,2,-3,0,0,0,0,0,2,0,-1,1.352016163464753839562604,0.00022},
	{0,2,-3,0,0,0,0,0,2,0,0,4.712152837336894606323767,0.02172},
	{0,2,-3,0,0,0,0,0,2,0,2,1.576487147353949236361359,0.00005},
	{0,2,-3,0,0,0,0,0,2,1,-2,1.574958238929202281042308,0.00007},
	{0,2,-3,0,0,0,0,0,2,1,-1,1.349572004380261036615707,0.00001},
	{0,2,-3,0,0,0,0,0,2,1,0,4.701631119941247050064703,0.00213},
	{0,2,-3,0,0,0,0,0,2,2,0,4.707358068815816309893307,0.00021},
	{0,2,-3,0,0,0,0,0,3,-3,-1,1.337551398223000287401874,0.00002},
	{0,2,-3,0,0,0,0,0,3,-2,1,1.215660395790519654468653,0.00001},
	{0,2,-3,0,0,0,0,0,3,-1,0,1.573354455879544699925532,0.00002},
	{0,2,-3,0,0,0,0,0,3,0,-1,4.479277220434720874209233,0.00001},
	{0,2,-3,0,0,0,0,0,3,0,0,4.713118178946173131294017,0.00003},
	{0,2,-3,0,0,0,0,0,4,-3,0,4.776526514269901824150111,0.00001},
	{0,2,-3,0,0,0,0,0,4,-2,0,4.687233898941546073046993,0.00037},
	{0,2,-3,0,0,0,0,0,4,-1,-2,4.719534532875279353447695,0.00001},
	{0,2,-3,0,0,0,0,0,4,-1,0,4.682284668781665715187046,0.00057},
	{0,2,-3,0,0,0,0,0,4,0,-2,4.721415823276004175568232,0.00003},
	{0,2,-3,0,0,0,0,0,4,0,0,4.669431889637054133856964,0.00022},
	{0,2,-3,0,0,0,0,0,4,1,0,4.736213073740263013178264,0.00005},
	{0,2,-3,0,0,0,0,0,5,-2,0,4.714947284002262151147988,0.00001},
	{0,2,-3,0,0,0,0,0,6,-2,0,4.803302308456448344031742,0.00001},
	{0,2,-3,0,0,1,0,0,0,-1,0,3.137817157351879160387398,0.00001},
	{0,2,-3,0,0,1,0,0,0,0,0,6.278645007663448573964615,0.00001},
	{0,2,-3,0,0,1,0,0,0,1,0,3.137817157351879160387398,0.00001},
	{0,2,-3,0,0,2,0,0,0,0,0,1.632961638625355815790385,0.00001},
	{0,2,-3,0,1,0,0,0,-2,0,0,3.062739550649315134478456,0.00009},
	{0,2,-3,0,1,0,0,0,-2,1,0,0.052880334742774592893255,0.00005},
	{0,2,-3,0,1,0,0,0,-2,2,0,6.259564544681871289810715,0.00001},
	{0,2,-3,0,1,0,0,0,0,0,0,6.270191505431413681037611,0.00028},
	{0,2,-3,0,1,0,0,0,0,1,-2,3.165260016378537155645745,0.00003},
	{0,2,-3,0,1,0,0,0,0,2,-2,2.350112192282070022741891,0.00009},
	{0,2,-3,0,1,0,0,0,0,2,0,3.119206711537863441208174,0.00002},
	{0,2,-3,0,1,0,0,0,2,-1,0,6.258061467130053401319856,0.00003},
	{0,2,-3,0,1,0,0,0,2,0,0,3.093978849864911229161635,0.00001},
	{0,2,-3,0,2,0,0,0,-2,0,0,0.897991971437480440698664,0.00003},
	{0,2,-3,0,2,0,0,0,0,0,0,0.973583577604756444934253,0.00005},
	{0,2,-3,0,2,0,0,0,2,-2,0,1.050599372441659795640589,0.00003},
	{0,2,-3,0,2,0,0,0,2,-1,0,1.052605104818051806603307,0.00006},
	{0,2,-3,0,2,0,0,0,2,0,0,1.050599372441659795640589,0.00003},
	{0,2,-3,0,3,0,0,0,0,0,0,1.143066392613543813538968,0.00002},
	{0,2,-3,1,0,0,0,0,0,0,0,6.270429393808460538650706,0.00002},
	{0,2,-3,2,0,0,0,0,-2,0,0,0.701180965533891087382301,0.00001},
	{0,2,-3,2,0,0,0,0,-2,1,0,0.707047889814470087443965,0.00001},
	{0,2,-3,2,0,0,0,0,-2,2,0,0.702261673406725961399388,0.00003},
	{0,2,-3,2,0,0,0,0,-2,3,0,0.707047889814470087443965,0.00001},
	{0,2,-3,2,0,0,0,0,0,0,0,4.472785293749002910601575,0.00002},
	{0,2,-3,2,0,0,0,0,2,-2,0,0.780494660863970235453735,0.00003},
	{0,2,-3,2,0,0,0,0,2,0,0,0.791808932272948684527591,0.00002},
	{0,2,-3,3,0,0,0,0,2,-3,0,4.146972988573232932196788,0.00003},
	{0,2,-3,3,0,0,0,0,2,-2,0,4.134320049627974391626140,0.00001},
	{0,2,-3,3,0,0,0,0,2,-1,0,4.035574382004966764725395,0.00005},
	{0,2,-3,3,0,0,0,0,2,0,0,4.134320049627974391626140,0.00001},
	{0,2,-2,-2,0,0,0,0,0,-1,0,0.826728607282225191887903,0.00001},
	{0,2,-2,-2,0,0,0,0,0,0,0,2.647475107051556530990410,0.00001},
	{0,2,-2,-2,0,0,0,0,0,1,0,0.826728607282225191887903,0.00001},
	{0,2,-2,-1,0,0,0,0,1,-3,1,2.902174495453593294769234,0.00001},
	{0,2,-2,-1,0,0,0,0,1,-2,1,2.902174495453593294769234,0.00027},
	{0,2,-2,-1,0,0,0,0,1,-1,1,2.902174495453593294769234,0.00001},
	{0,2,-2,0,-2,0,0,0,-2,0,0,3.585595863183816067731868,0.00001},
	{0,2,-2,0,-2,0,0,0,0,0,0,5.957512104745200431921148,0.00001},
	{0,2,-2,0,-2,0,0,0,1,0,-1,3.059914560722037268902795,0.00001},
	{0,2,-2,0,-1,0,0,0,-2,0,0,3.925803469497109787766931,0.00009},
	{0,2,-2,0,-1,0,0,0,-2,1,0,0.217481638366659013605897,0.00003},
	{0,2,-2,0,-1,0,0,0,-2,2,0,0.170985892560604896273091,0.00004},
	{0,2,-2,0,-1,0,0,0,-2,3,0,3.351771659833183036880655,0.00002},
	{0,2,-2,0,-1,0,0,0,0,-2,0,3.369468425783779252924433,0.00001},
	{0,2,-2,0,-1,0,0,0,0,-1,0,0.201922551683905160402333,0.00001},
	{0,2,-2,0,-1,0,0,0,0,0,0,1.508840105408826293142965,0.00002},
	{0,2,-2,0,-1,0,0,0,0,1,0,0.201922551683905160402333,0.00001},
	{0,2,-2,0,-1,0,0,0,1,0,-1,1.343230699608989997528852,0.00002},
	{0,2,-2,0,-1,0,0,0,2,-2,0,3.385872600890348582680645,0.00001},
	{0,2,-2,0,-1,0,0,0,2,-1,0,3.354617942777335493076407,0.00005},
	{0,2,-2,0,-1,0,0,0,2,0,0,3.346938319535635031343190,0.00006},
	{0,2,-2,0,0,-1,0,0,0,0,0,4.719580784100457115926019,0.00001},
	{0,2,-2,0,0,-1,0,0,2,-1,0,1.614131804924364477216159,0.00003},
	{0,2,-2,0,0,0,0,0,-6,0,0,6.281914009352433936328453,0.00003},
	{0,2,-2,0,0,0,0,0,-6,1,0,0.007667231404011090253880,0.00003},
	{0,2,-2,0,0,0,0,0,-6,2,0,0.009428792218048966111699,0.00007},
	{0,2,-2,0,0,0,0,0,-6,3,0,0.006416353929106753846423,0.00002},
	{0,2,-2,0,0,0,0,0,-5,2,0,3.148639071378869669359801,0.00001},
	{0,2,-2,0,0,0,0,0,-4,-2,0,6.281456384022560790469925,0.00003},
	{0,2,-2,0,0,0,0,0,-4,-1,0,6.273246180688254014512495,0.00020},
	{0,2,-2,0,0,0,0,0,-4,-1,2,0.005382246347300113399614,0.00001},
	{0,2,-2,0,0,0,0,0,-4,0,-2,3.147237571989518478687842,0.00001},
	{0,2,-2,0,0,0,0,0,-4,0,0,0.012346284595682687976193,0.00148},
	{0,2,-2,0,0,0,0,0,-4,0,2,0.004910309317560846396888,0.00005},
	{0,2,-2,0,0,0,0,0,-4,1,-2,3.146915384209600041742760,0.00001},
	{0,2,-2,0,0,0,0,0,-4,1,0,0.010158863444158195213363,0.00346},
	{0,2,-2,0,0,0,0,0,-4,1,2,0.006424731509516326197207,0.00002},
	{0,2,-2,0,0,0,0,0,-4,2,0,0.008568868495591359935037,0.00213},
	{0,2,-2,0,0,0,0,0,-4,3,0,0.008384910792431157777749,0.00005},
	{0,2,-2,0,0,0,0,0,-3,-1,0,0.007582408402364165106446,0.00004},
	{0,2,-2,0,0,0,0,0,-3,0,0,0.021112375296749405495511,0.00004},
	{0,2,-2,0,0,0,0,0,-3,1,0,3.146931790304569265259715,0.00022},
	{0,2,-2,0,0,0,0,0,-3,2,0,3.149153594442357650962094,0.00008},
	{0,2,-2,0,0,0,0,0,-2,-3,0,0.005066516285614338678533,0.00008},
	{0,2,-2,0,0,0,0,0,-2,-2,0,0.004967032518250662567749,0.00084},
	{0,2,-2,0,0,0,0,0,-2,-2,2,3.147260784868569860606158,0.00001},
	{0,2,-2,0,0,0,0,0,-2,-1,-2,3.146695647256774197586537,0.00007},
	{0,2,-2,0,0,0,0,0,-2,-1,0,0.007798131097910663764305,0.01120},
	{0,2,-2,0,0,0,0,0,-2,-1,2,3.146829688543327563365892,0.00024},
	{0,2,-2,0,0,0,0,0,-2,0,-2,3.146877161498981667620001,0.00032},
	{0,2,-2,0,0,0,0,0,-2,0,0,0.006398202504886012741137,0.13432},
	{0,2,-2,0,0,0,0,0,-2,0,2,0.006110397711232147879845,0.00154},
	{0,2,-2,0,0,0,0,0,-2,1,-2,3.146908751958442440610497,0.00037},
	{0,2,-2,0,0,0,0,0,-2,1,0,0.005441413008942720674899,0.16090},
	{0,2,-2,0,0,0,0,0,-2,1,2,3.146681335556908098993745,0.00008},
	{0,2,-2,0,0,0,0,0,-2,2,-2,3.146811188053256547192404,0.00003},
	{0,2,-2,0,0,0,0,0,-2,2,0,0.003973067509239891839656,0.00704},
	{0,2,-2,0,0,0,0,0,-2,2,2,3.146536473228992658590641,0.00003},
	{0,2,-2,0,0,0,0,0,-2,3,0,0.004055621582859223264728,0.00054},
	{0,2,-2,0,0,0,0,0,-2,4,0,0.003860144706635858583010,0.00005},
	{0,2,-2,0,0,0,0,0,-1,-2,0,3.152198321322462248872398,0.00002},
	{0,2,-2,0,0,0,0,0,-1,-1,0,3.143684430698308496232585,0.00022},
	{0,2,-2,0,0,0,0,0,-1,-1,1,3.236794081100776931947394,0.00003},
	{0,2,-2,0,0,0,0,0,-1,0,-1,3.287595903237351624426310,0.00011},
	{0,2,-2,0,0,0,0,0,-1,0,0,3.142714551232975050965024,0.00276},
	{0,2,-2,0,0,0,0,0,-1,0,1,0.064024262016758384796766,0.00020},
	{0,2,-2,0,0,0,0,0,-1,1,-1,0.209044367696668009770633,0.00003},
	{0,2,-2,0,0,0,0,0,-1,1,0,3.143396625904654850813813,0.00029},
	{0,2,-2,0,0,0,0,0,-1,2,0,3.140438292822524513070448,0.00003},
	{0,2,-2,0,0,0,0,0,0,-3,0,0.005179788154068771036109,0.00025},
	{0,2,-2,0,0,0,0,0,0,-2,-2,3.145679865632113880735687,0.00003},
	{0,2,-2,0,0,0,0,0,0,-2,0,0.008482300164692441885039,0.00376},
	{0,2,-2,0,0,0,0,0,0,-1,-2,3.147784383644168126892282,0.00013},
	{0,2,-2,0,0,0,0,0,0,-1,0,0.006955486135047802241649,0.05635},
	{0,2,-2,0,0,0,0,0,0,-1,2,3.147524155052696226420039,0.00009},
	{0,2,-2,0,0,0,0,0,0,0,-2,6.266660704354628741441502,0.00003},
	{0,2,-2,0,0,0,0,0,0,0,0,0.003568849254478004880825,0.30155},
	{0,2,-2,0,0,0,0,0,0,0,2,3.144849612506939617873059,0.00014},
	{0,2,-2,0,0,0,0,0,0,1,-2,6.262699679617227843664296,0.00004},
	{0,2,-2,0,0,0,0,0,0,1,0,0.002736850800052308130272,0.05071},
	{0,2,-2,0,0,0,0,0,0,1,2,3.145329054452462358426601,0.00014},
	{0,2,-2,0,0,0,0,0,0,2,0,0.001345648853287628125136,0.00353},
	{0,2,-2,0,0,0,0,0,0,2,2,3.144953983196209001960142,0.00002},
	{0,2,-2,0,0,0,0,0,0,3,-2,3.137081326539238546047272,0.00002},
	{0,2,-2,0,0,0,0,0,0,3,0,0.003963468198353923069299,0.00023},
	{0,2,-2,0,0,0,0,0,1,-2,-1,3.272193198055576068838946,0.00004},
	{0,2,-2,0,0,0,0,0,1,-1,-2,6.283001524009351079769203,0.00002},
	{0,2,-2,0,0,0,0,0,1,-1,-1,3.272193198055576068838946,0.00052},
	{0,2,-2,0,0,0,0,0,1,-1,0,0.001174606586592183811793,0.00028},
	{0,2,-2,0,0,0,0,0,1,-1,1,0.096754770545258453329218,0.00019},
	{0,2,-2,0,0,0,0,0,1,0,-2,6.282988434039961767041405,0.00036},
	{0,2,-2,0,0,0,0,0,1,0,-1,3.239546290798246186426468,0.00334},
	{0,2,-2,0,0,0,0,0,1,0,0,0.001041787030515415246254,0.00202},
	{0,2,-2,0,0,0,0,0,1,0,1,0.102478403294248648913722,0.00036},
	{0,2,-2,0,0,0,0,0,1,1,-2,6.282692775264673734625376,0.00027},
	{0,2,-2,0,0,0,0,0,1,1,-1,3.272193198055576068838946,0.00052},
	{0,2,-2,0,0,0,0,0,1,1,0,6.280578657941732423353187,0.00009},
	{0,2,-2,0,0,0,0,0,1,1,1,0.102879654489282143514650,0.00004},
	{0,2,-2,0,0,0,0,0,1,2,-2,0.000200189265203749589819,0.00004},
	{0,2,-2,0,0,0,0,0,1,2,-1,3.272193198055576068838946,0.00004},
	{0,2,-2,0,0,0,0,0,2,-4,0,0.012838816510595487188628,0.00003},
	{0,2,-2,0,0,0,0,0,2,-3,0,0.015365355135782477954964,0.00036},
	{0,2,-2,0,0,0,0,0,2,-2,-2,3.139393015133504771796424,0.00002},
	{0,2,-2,0,0,0,0,0,2,-2,0,6.280194161907518335397071,0.00559},
	{0,2,-2,0,0,0,0,0,2,-2,2,3.143564526578696227687715,0.00002},
	{0,2,-2,0,0,0,0,0,2,-1,-2,0.001316501854779322713135,0.00012},
	{0,2,-2,0,0,0,0,0,2,-1,0,6.283143768343388835262431,0.13593},
	{0,2,-2,0,0,0,0,0,2,-1,2,3.141844155535005622681410,0.00029},
	{0,2,-2,0,0,0,0,0,2,0,-2,6.283061388802694935407089,0.00223},
	{0,2,-2,0,0,0,0,0,2,0,0,6.282952654790295632381003,0.03553},
	{0,2,-2,0,0,0,0,0,2,0,2,3.143061348155346212962513,0.00013},
	{0,2,-2,0,0,0,0,0,2,1,-2,3.139303130677026931749651,0.00011},
	{0,2,-2,0,0,0,0,0,2,1,0,0.000150447381521911182061,0.00325},
	{0,2,-2,0,0,0,0,0,2,1,2,3.143029059564184546360366,0.00001},
	{0,2,-2,0,0,0,0,0,2,2,-2,3.141183722946050860258538,0.00002},
	{0,2,-2,0,0,0,0,0,2,2,0,0.002239606496159123657369,0.00031},
	{0,2,-2,0,0,0,0,0,2,3,0,0.001081755070386085414505,0.00002},
	{0,2,-2,0,0,0,0,0,3,-2,0,3.142142781370021786813140,0.00004},
	{0,2,-2,0,0,0,0,0,3,-1,-1,0.209044367696668009770633,0.00003},
	{0,2,-2,0,0,0,0,0,3,-1,0,3.142163899853970487896504,0.00006},
	{0,2,-2,0,0,0,0,0,3,0,-2,3.141408870419558407860450,0.00007},
	{0,2,-2,0,0,0,0,0,3,0,-1,3.235687716887937881438120,0.00002},
	{0,2,-2,0,0,0,0,0,3,0,0,0.000109432144100044469962,0.00004},
	{0,2,-2,0,0,0,0,0,4,-3,0,6.258900097835637055254665,0.00005},
	{0,2,-2,0,0,0,0,0,4,-2,0,0.001028697061125457851843,0.00181},
	{0,2,-2,0,0,0,0,0,4,-1,-2,6.281322866334782872854703,0.00002},
	{0,2,-2,0,0,0,0,0,4,-1,0,0.000280648943720688225350,0.00172},
	{0,2,-2,0,0,0,0,0,4,0,0,6.283177278665027287729572,0.00049},
	{0,2,-2,0,0,0,0,0,4,1,0,0.000970228531183647802637,0.00007},
	{0,2,-2,0,0,0,0,0,5,-3,0,6.283087045142699444966183,0.00001},
	{0,2,-2,0,0,0,0,0,6,-3,0,0.000817686754559343478670,0.00002},
	{0,2,-2,0,0,0,0,0,6,-2,0,0.000719075651821663819167,0.00004},
	{0,2,-2,0,0,0,0,0,6,-1,0,0.000187797427514589855167,0.00005},
	{0,2,-2,0,0,1,0,0,2,-1,0,1.530261753049029005424586,0.00003},
	{0,2,-2,0,1,0,0,0,-2,0,0,6.047218537639205138134457,0.00006},
	{0,2,-2,0,1,0,0,0,-2,1,0,3.000300745725068551905679,0.00004},
	{0,2,-2,0,1,0,0,0,-2,3,0,6.147410210547491260513198,0.00003},
	{0,2,-2,0,1,0,0,0,0,0,0,3.703294061154230654153707,0.00002},
	{0,2,-2,0,1,0,0,0,2,-2,0,6.101345212000828688303500,0.00001},
	{0,2,-2,0,1,0,0,0,2,-1,0,5.870904678471037030362822,0.00007},
	{0,2,-2,0,1,0,0,0,2,0,0,5.530730407946456317347383,0.00005},
	{0,2,-2,0,2,0,0,0,0,0,0,0.127596134691399853977600,0.00001},
	{0,2,-2,1,0,0,0,0,2,-3,0,3.944781132585744920504567,0.00002},
	{0,2,-2,1,0,0,0,0,2,-2,0,6.263943575775124728011178,0.00003},
	{0,2,-2,1,0,0,0,0,2,-1,0,3.944781132585744920504567,0.00002},
	{0,2,-1,-4,0,0,0,0,0,0,0,2.817246424985698549647850,0.00001},
	{0,2,-1,-3,0,0,0,0,-2,0,0,5.290446741034192434938177,0.00002},
	{0,2,-1,-3,0,0,0,0,-2,2,0,5.290446741034192434938177,0.00002},
	{0,2,-1,-3,0,0,0,0,0,-1,0,5.290446741034192434938177,0.00001},
	{0,2,-1,-3,0,0,0,0,0,1,0,5.290446741034192434938177,0.00001},
	{0,2,-1,-3,0,0,0,0,2,-3,0,5.298207347553184121125014,0.00002},
	{0,2,-1,-3,0,0,0,0,2,-2,0,5.298207347553184121125014,0.00002},
	{0,2,-1,-3,0,0,0,0,2,-1,0,5.298207347553184121125014,0.00002},
	{0,2,-1,-3,0,0,0,0,2,0,0,5.298207347553184121125014,0.00002},
	{0,2,-1,-2,0,0,0,0,-2,0,0,2.229366474904747708052355,0.00003},
	{0,2,-1,-2,0,0,0,0,-2,2,0,2.357920446289642146808774,0.00004},
	{0,2,-1,-2,0,0,0,0,0,0,0,6.196064405039486189252784,0.00001},
	{0,2,-1,-2,0,0,0,0,2,-2,0,2.436703037928339199424954,0.00003},
	{0,2,-1,-2,0,0,0,0,2,0,0,2.438055842631560388156231,0.00002},
	{0,2,-1,-1,0,0,0,0,2,-3,0,1.629991960903087511169929,0.00001},
	{0,2,-1,-1,0,0,0,0,2,-1,0,4.771584614492880405123287,0.00001},
	{0,2,-1,0,-3,0,0,0,0,0,0,2.262553736098494638895318,0.00001},
	{0,2,-1,0,-2,0,0,0,-2,0,0,2.028053915794414852058480,0.00006},
	{0,2,-1,0,-2,0,0,0,0,0,0,5.102111926642913353191489,0.00004},
	{0,2,-1,0,-2,0,0,0,2,-3,0,5.605755829304385429168178,0.00002},
	{0,2,-1,0,-2,0,0,0,2,-1,0,2.468588981631799406102346,0.00005},
	{0,2,-1,0,-2,0,0,0,2,0,-2,2.970547594367545674032272,0.00004},
	{0,2,-1,0,-1,0,0,0,-2,0,0,0.044271672740237764942517,0.00003},
	{0,2,-1,0,-1,0,0,0,-2,1,0,3.165171702718386104180581,0.00010},
	{0,2,-1,0,-1,0,0,0,-2,2,0,3.119462576806206310919833,0.00001},
	{0,2,-1,0,-1,0,0,0,0,-2,0,3.231218975871131160459981,0.00001},
	{0,2,-1,0,-1,0,0,0,0,0,0,3.084089465257261242214781,0.00006},
	{0,2,-1,0,-1,0,0,0,0,1,0,3.167225257116282666203233,0.00004},
	{0,2,-1,0,-1,0,0,0,2,-2,0,3.184853780693126079626154,0.00002},
	{0,2,-1,0,-1,0,0,0,2,-1,0,3.098802765384498503209443,0.00016},
	{0,2,-1,0,-1,0,0,0,2,0,-2,3.194651186449196433869702,0.00005},
	{0,2,-1,0,-1,0,0,0,2,0,0,0.070549699024114786993778,0.00009},
	{0,2,-1,0,0,-1,0,0,-2,0,0,3.145356805187569104731438,0.00001},
	{0,2,-1,0,0,-1,0,0,-2,2,0,0.003764151597776170445758,0.00001},
	{0,2,-1,0,0,0,0,0,-6,1,0,4.491766447496141623219046,0.00001},
	{0,2,-1,0,0,0,0,0,-4,-1,0,4.486883365314912275323422,0.00006},
	{0,2,-1,0,0,0,0,0,-4,0,0,4.470121397711683819409245,0.00019},
	{0,2,-1,0,0,0,0,0,-4,1,0,4.486669737014468140046120,0.00050},
	{0,2,-1,0,0,0,0,0,-4,2,0,4.477106379911090172640797,0.00023},
	{0,2,-1,0,0,0,0,0,-4,3,0,4.362063525864659396802381,0.00001},
	{0,2,-1,0,0,0,0,0,-3,0,0,4.494801575065360488281385,0.00002},
	{0,2,-1,0,0,0,0,0,-3,0,1,1.799901508913987591142813,0.00002},
	{0,2,-1,0,0,0,0,0,-3,1,-1,1.801671272775509757835266,0.00001},
	{0,2,-1,0,0,0,0,0,-3,1,0,1.338054751179275525529988,0.00002},
	{0,2,-1,0,0,0,0,0,-3,1,1,1.802893701383606384069935,0.00001},
	{0,2,-1,0,0,0,0,0,-2,-2,0,4.488084500906134977071815,0.00011},
	{0,2,-1,0,0,0,0,0,-2,-1,0,4.486452094456744532635639,0.00120},
	{0,2,-1,0,0,0,0,0,-2,-1,2,1.350646778133638870045274,0.00002},
	{0,2,-1,0,0,0,0,0,-2,0,-2,1.344209305720583280674418,0.00003},
	{0,2,-1,0,0,0,0,0,-2,0,0,4.487107989189643930671991,0.01345},
	{0,2,-1,0,0,0,0,0,-2,0,2,4.495454153672681307796211,0.00010},
	{0,2,-1,0,0,0,0,0,-2,1,-2,1.345954285906727276866945,0.00001},
	{0,2,-1,0,0,0,0,0,-2,1,0,4.487941907506246330683553,0.01203},
	{0,2,-1,0,0,0,0,0,-2,1,2,1.348396176063192175575978,0.00003},
	{0,2,-1,0,0,0,0,0,-2,2,0,4.510762611074848216219380,0.00054},
	{0,2,-1,0,0,0,0,0,-2,3,0,4.436503738324394596759248,0.00003},
	{0,2,-1,0,0,0,0,0,-1,-1,-1,1.801292361794901708549332,0.00004},
	{0,2,-1,0,0,0,0,0,-1,-1,1,4.949168200691874019980787,0.00010},
	{0,2,-1,0,0,0,0,0,-1,0,-1,1.801594652821347120053019,0.00055},
	{0,2,-1,0,0,0,0,0,-1,0,1,4.943122031097115787190432,0.00132},
	{0,2,-1,0,0,0,0,0,-1,1,-1,1.777590266954043318747836,0.00033},
	{0,2,-1,0,0,0,0,0,-1,1,0,1.349663634165990444557792,0.00001},
	{0,2,-1,0,0,0,0,0,-1,1,1,4.942987989810562865500287,0.00013},
	{0,2,-1,0,0,0,0,0,0,-2,0,4.479023798627331132138352,0.00019},
	{0,2,-1,0,0,0,0,0,0,-1,0,4.486457854043275794708734,0.00262},
	{0,2,-1,0,0,0,0,0,0,0,-2,1.348587115083360599143703,0.00001},
	{0,2,-1,0,0,0,0,0,0,0,-1,4.945044860334038006044466,0.00001},
	{0,2,-1,0,0,0,0,0,0,0,0,4.400982099256105506412950,0.00873},
	{0,2,-1,0,0,0,0,0,0,0,1,1.803439116774854689140284,0.00003},
	{0,2,-1,0,0,0,0,0,0,1,0,4.430442558898069371764450,0.00147},
	{0,2,-1,0,0,0,0,0,0,2,0,4.419109786999019462427896,0.00010},
	{0,2,-1,0,0,0,0,0,1,-2,-1,1.802732432960722386283692,0.00004},
	{0,2,-1,0,0,0,0,0,1,-2,1,4.944813255142298302757808,0.00002},
	{0,2,-1,0,0,0,0,0,1,-1,-1,1.802796312011345269965545,0.00073},
	{0,2,-1,0,0,0,0,0,1,-1,0,1.347619155480204611308181,0.00001},
	{0,2,-1,0,0,0,0,0,1,-1,1,4.944420905126449383715226,0.00049},
	{0,2,-1,0,0,0,0,0,1,0,-1,1.802994930480222190993800,0.00442},
	{0,2,-1,0,0,0,0,0,1,0,0,4.830104457114699378905698,0.00005},
	{0,2,-1,0,0,0,0,0,1,0,1,4.944449703059108358615958,0.00049},
	{0,2,-1,0,0,0,0,0,1,1,-1,1.805681341264891992537400,0.00056},
	{0,2,-1,0,0,0,0,0,1,1,1,4.944598928710153273868855,0.00005},
	{0,2,-1,0,0,0,0,0,1,2,-1,1.803944040527456715850008,0.00003},
	{0,2,-1,0,0,0,0,0,2,-3,0,4.563894622295760150620936,0.00007},
	{0,2,-1,0,0,0,0,0,2,-2,0,4.473257754377517159127819,0.00015},
	{0,2,-1,0,0,0,0,0,2,-1,-1,5.001882205556934302137506,0.00003},
	{0,2,-1,0,0,0,0,0,2,-1,0,4.251375791900730227723670,0.00200},
	{0,2,-1,0,0,0,0,0,2,0,-2,4.295195773430552144134253,0.00020},
	{0,2,-1,0,0,0,0,0,2,0,-1,4.945180297883992714957913,0.00024},
	{0,2,-1,0,0,0,0,0,2,0,0,1.239561632699030635507143,0.00013},
	{0,2,-1,0,0,0,0,0,3,-2,-1,4.944715691237111521161296,0.00003},
	{0,2,-1,0,0,0,0,0,3,-1,-1,4.944985344606545041301615,0.00023},
	{0,2,-1,0,0,0,0,0,3,0,-1,1.802988472761989813264449,0.00005},
	{0,2,-1,0,0,0,0,0,4,-2,0,3.589574341213737085354296,0.00001},
	{0,2,-1,0,1,0,0,0,2,-3,0,1.322099474756319059665088,0.00001},
	{0,2,-1,0,1,0,0,0,2,-1,0,4.463692128346112397707657,0.00001},
	{0,2,0,-6,0,0,0,0,0,0,0,1.196250414646165438625758,0.00002},
	{0,2,0,-5,0,0,0,0,0,0,0,1.931636866459417012364952,0.00001},
	{0,2,0,-3,0,0,0,0,2,-3,0,4.042903368599940705507834,0.00002},
	{0,2,0,-3,0,0,0,0,2,-2,0,2.649044856180799989431307,0.00002},
	{0,2,0,-3,0,0,0,0,2,-1,0,4.447754479748600608957076,0.00004},
	{0,2,0,-2,0,0,0,0,-2,0,0,6.279350295214178423464091,0.00003},
	{0,2,0,-2,0,0,0,0,-2,1,0,3.139745920708258086762044,0.00003},
	{0,2,0,-2,0,0,0,0,-2,3,0,3.139745920708258086762044,0.00002},
	{0,2,0,-2,0,0,0,0,0,-2,0,3.139745920708258086762044,0.00001},
	{0,2,0,-2,0,0,0,0,0,-1,0,3.139745920708258086762044,0.00001},
	{0,2,0,-2,0,0,0,0,0,0,0,3.139745920708258086762044,0.00001},
	{0,2,0,-2,0,0,0,0,0,1,0,3.139745920708258086762044,0.00001},
	{0,2,0,-2,0,0,0,0,2,-3,0,2.917500755214130769843450,0.00001},
	{0,2,0,-2,0,0,0,0,2,-1,0,2.917500755214130769843450,0.00001},
	{0,2,0,0,-3,0,0,0,-2,0,0,0.155990547226245196421601,0.00004},
	{0,2,0,0,-3,0,0,0,-2,2,0,0.159408425500425693366324,0.00001},
	{0,2,0,0,-3,0,0,0,0,0,0,3.331594955548427439140369,0.00001},
	{0,2,0,0,-2,0,0,0,-2,0,0,3.140789802133876040812765,0.00002},
	{0,2,0,0,-2,0,0,0,-2,1,0,0.002031388716396200031650,0.00011},
	{0,2,0,0,-2,0,0,0,-2,2,0,0.005360778797500583003899,0.00001},
	{0,2,0,0,-2,0,0,0,-2,3,0,0.001107411410390402202453,0.00002},
	{0,2,0,0,-2,0,0,0,0,-2,0,0.001078264411882096790452,0.00002},
	{0,2,0,0,-2,0,0,0,0,-1,0,0.001845511151058804120290,0.00001},
	{0,2,0,0,-2,0,0,0,0,0,0,0.000158126830230686252557,0.00009},
	{0,2,0,0,-2,0,0,0,0,1,0,0.001845511151058804120290,0.00001},
	{0,2,0,0,-2,0,0,0,2,-3,0,0.001634500844492689638696,0.00001},
	{0,2,0,0,-2,0,0,0,2,-2,0,3.142574226761114974948441,0.00002},
	{0,2,0,0,-2,0,0,0,2,-1,0,3.143227154434285797179882,0.00001},
	{0,2,0,0,-2,0,0,0,2,0,0,0.001634500844492689638696,0.00001},
	{0,2,0,0,-1,0,0,0,-2,0,0,1.582834386244676982968826,0.00002},
	{0,2,0,0,-1,0,0,0,-2,2,0,1.580737024082555342019418,0.00003},
	{0,2,0,0,0,0,0,0,-4,0,0,0.059461447753269613958338,0.00001},
	{0,2,0,0,0,0,0,0,-4,1,0,2.178919129139253119120667,0.00002},
	{0,2,0,0,0,0,0,0,-2,-1,0,2.455815964034004039717729,0.00009},
	{0,2,0,0,0,0,0,0,-2,0,0,2.208614684631460267638658,0.00067},
	{0,2,0,0,0,0,0,0,-2,1,0,2.203261410749743465231631,0.00049},
	{0,2,0,0,0,0,0,0,-2,2,0,1.176653857804773162243350,0.00002},
	{0,2,0,0,0,0,0,0,-1,0,-1,0.160519851168095695204130,0.00003},
	{0,2,0,0,0,0,0,0,-1,0,0,3.577516210477558633584749,0.00004},
	{0,2,0,0,0,0,0,0,-1,0,1,3.321471347755159175818562,0.00006},
	{0,2,0,0,0,0,0,0,-1,1,-1,0.160519851168095695204130,0.00001},
	{0,2,0,0,0,0,0,0,0,-2,0,0.406742349926120905223570,0.00002},
	{0,2,0,0,0,0,0,0,0,-1,0,0.761023418662871153905769,0.00020},
	{0,2,0,0,0,0,0,0,0,0,0,0.543485231628447529317327,0.00204},
	{0,2,0,0,0,0,0,0,0,1,0,0.526653450855139371178382,0.00021},
	{0,2,0,0,0,0,0,0,0,2,0,1.922541781194349486128203,0.00001},
	{0,2,0,0,0,0,0,0,1,0,-1,0.236128561562041233701237,0.00009},
	{0,2,0,0,0,0,0,0,1,0,0,3.587154965804622452907324,0.00003},
	{0,2,0,0,0,0,0,0,2,-3,0,2.068700365145335062777576,0.00002},
	{0,2,0,0,0,0,0,0,2,-2,0,0.059546096221991341723712,0.00001},
	{0,2,0,0,0,0,0,0,2,-1,0,0.507937587154303371583808,0.00039},
	{0,2,0,0,0,0,0,0,2,0,0,3.580945607924801876720267,0.00008},
	{0,2,0,0,0,0,0,0,2,1,0,3.641454602295119080679342,0.00001},
	{0,2,0,0,2,0,0,0,2,-2,0,5.378390740449532358979923,0.00001},
	{0,2,0,0,2,0,0,0,2,0,0,2.243736119702267384212746,0.00002},
	{0,2,1,-8,0,0,0,0,-2,0,0,0.347890720213498150226172,0.00005},
	{0,2,1,-8,0,0,0,0,-2,1,0,0.347890720213498150226172,0.00009},
	{0,2,1,-8,0,0,0,0,0,-1,0,0.424106805187137725354773,0.00002},
	{0,2,1,-8,0,0,0,0,0,0,0,0.009304175709456571213840,0.00012},
	{0,2,1,-8,0,0,0,0,0,1,0,0.424106805187137725354773,0.00002},
	{0,2,1,-8,0,0,0,0,2,-1,0,0.349103374977783820209964,0.00009},
	{0,2,1,-8,0,0,0,0,2,0,0,0.349103374977783820209964,0.00005},
	{0,2,1,-5,0,0,0,0,0,0,0,2.109142087374996421544893,0.00002},
	{0,2,1,-5,0,0,0,0,2,-3,0,2.121242455079073163659586,0.00001},
	{0,2,1,-5,0,0,0,0,2,-1,0,2.121242455079073163659586,0.00001},
	{0,2,1,-4,0,0,0,0,-2,0,0,2.628161642614837756326551,0.00001},
	{0,2,1,-4,0,0,0,0,-2,2,0,2.625005563728456170480285,0.00002},
	{0,2,1,0,-2,0,0,0,-2,0,0,4.698569114301548665935115,0.00002},
	{0,2,1,0,-2,0,0,0,-2,2,0,1.556976460711755105847942,0.00002},
	{0,2,1,0,-1,0,0,0,0,0,0,0.319348303758083651437971,0.00001},
	{0,2,1,0,0,0,0,0,-2,0,0,5.829643349624639370176737,0.00006},
	{0,2,1,0,0,0,0,0,-2,1,0,5.956873139706045705565884,0.00003},
	{0,2,1,0,0,0,0,0,-1,0,1,2.156311879338170367503835,0.00002},
	{0,2,1,0,0,0,0,0,0,-1,0,5.040727475119796352487356,0.00004},
	{0,2,1,0,0,0,0,0,0,0,0,5.158177312737652009388967,0.00013},
	{0,2,1,0,0,0,0,0,0,1,0,5.029720032593318457259102,0.00002},
	{0,2,1,0,0,0,0,0,1,0,-1,5.344277407554677949974575,0.00002},
	{0,2,1,0,0,0,0,0,2,-1,0,4.793219890433527474726816,0.00003},
	{0,2,1,0,0,0,0,0,2,0,0,1.978277998192162323576326,0.00002},
	{0,2,1,0,1,0,0,0,2,-3,0,2.240375139161701945056393,0.00004},
	{0,2,1,0,1,0,0,0,2,-2,0,2.214133415726266651546439,0.00001},
	{0,2,1,0,1,0,0,0,2,-1,0,5.314260711480103260839769,0.00002},
	{0,2,1,0,1,0,0,0,2,0,0,2.238153858622689007518147,0.00007},
	{0,2,1,2,0,0,0,0,2,0,0,2.947780472406980489807893,0.00001},
	{0,2,2,-10,0,0,0,0,0,0,0,1.137150599113909033022196,0.00001},
	{0,2,2,-8,0,0,0,0,0,0,0,1.058068159909719252453897,0.00002},
	{0,2,2,-8,3,0,0,0,-2,0,0,5.032456534327520714100501,0.00002},
	{0,2,2,-8,3,0,0,0,0,0,0,5.029454568014090298788688,0.00003},
	{0,2,2,-7,0,0,0,0,0,0,0,1.617464685663972945306455,0.00001},
	{0,2,2,0,-4,0,0,0,0,0,0,3.037386374336069838619778,0.00001},
	{0,2,2,0,-2,0,0,0,2,-2,0,5.853650528018746967973129,0.00001},
	{0,2,2,0,-2,0,0,0,2,0,0,5.853650528018746967973129,0.00001},
	{0,2,2,0,-1,0,0,0,2,-3,0,2.466300331383659560913202,0.00002},
	{0,2,2,0,-1,0,0,0,2,-2,0,3.848214857599701943513537,0.00001},
	{0,2,2,0,-1,0,0,0,2,-1,0,2.466300331383659560913202,0.00002},
	{0,2,2,0,-1,0,0,0,2,0,0,2.710801062834592212169582,0.00006},
	{0,2,2,0,0,0,0,0,-2,0,0,2.287031804324790140725554,0.00002},
	{0,2,2,0,0,0,0,0,-2,1,0,5.379871128721075201895019,0.00001},
	{0,2,2,0,0,0,0,0,0,-1,0,2.238278475131281197718636,0.00006},
	{0,2,2,0,0,0,0,0,0,0,0,3.862534062381838939614909,0.00003},
	{0,2,2,0,0,0,0,0,0,1,0,2.238278475131281197718636,0.00004},
	{0,2,2,0,0,0,0,0,0,2,0,5.362331267870231954475457,0.00002},
	{0,2,2,0,0,0,0,0,2,-2,0,2.200353692215920808905594,0.00006},
	{0,2,2,0,0,0,0,0,2,-1,0,2.227183591609278590084386,0.00004},
	{0,2,2,0,0,0,0,0,2,0,0,2.224928800748626755989790,0.00011},
	{0,2,2,0,0,0,0,0,2,1,0,2.239249576327090984761981,0.00002},
	{0,2,2,0,0,0,0,0,2,2,0,2.238278475131281197718636,0.00006},
	{0,2,2,0,0,0,0,0,4,-2,0,5.341946345805713924903557,0.00001},
	{0,2,2,0,0,0,0,0,4,-1,0,2.237514369984757944820331,0.00001},
	{0,2,2,0,0,0,0,0,4,0,0,5.379871128721075201895019,0.00001},
	{0,2,2,0,0,0,0,0,4,1,0,5.379107023574551504907504,0.00001},
	{0,2,2,0,1,0,0,0,2,0,0,5.242561015011849789857479,0.00004},
	{0,2,3,-3,0,0,0,0,2,-2,0,4.387278646634071854748527,0.00001},
	{0,2,3,-3,0,0,0,0,2,0,0,4.387278646634071854748527,0.00001},
	{0,2,3,-2,0,0,0,0,2,-2,0,1.476218330892725472125449,0.00002},
	{0,2,3,-2,0,0,0,0,2,0,0,1.476218330892725472125449,0.00002},
	{0,2,3,0,-2,0,0,0,2,0,0,0.702875854770502739299332,0.00001},
	{0,2,3,0,-1,0,0,0,0,-1,0,5.401459280771917725871845,0.00002},
	{0,2,3,0,-1,0,0,0,0,0,0,2.260748367520232005034586,0.00003},
	{0,2,3,0,-1,0,0,0,2,-2,0,2.247689290458034339081905,0.00002},
	{0,2,3,0,-1,0,0,0,2,-1,0,2.259972568667719894364154,0.00009},
	{0,2,3,0,-1,0,0,0,2,0,0,2.259866627182124165784671,0.00005},
	{0,2,3,0,0,0,0,0,-2,0,0,5.272604589156903998059533,0.00003},
	{0,2,3,0,0,0,0,0,-2,2,0,5.272581201744928058872119,0.00004},
	{0,2,3,0,0,0,0,0,0,-2,0,2.130545758123903787861764,0.00001},
	{0,2,3,0,0,0,0,0,0,-1,0,3.659820178415079450218172,0.00003},
	{0,2,3,0,0,0,0,0,0,0,0,0.310643299580836695916730,0.00002},
	{0,2,3,0,0,0,0,0,0,1,0,3.659820178415079450218172,0.00003},
	{0,2,3,0,0,0,0,0,0,2,0,0.438136459846368953030549,0.00002},
	{0,2,3,0,0,0,0,0,2,0,0,3.375177746832903391549507,0.00001},
	{0,2,4,-2,0,0,0,0,2,-3,0,5.378170479897931066659567,0.00001},
	{0,2,4,-2,0,0,0,0,2,-2,0,5.379622419302665825568965,0.00005},
	{0,2,4,-2,0,0,0,0,2,-1,0,5.378722353007411527414661,0.00002},
	{0,2,4,-2,0,0,0,0,2,0,0,5.379199875090757032580768,0.00006},
	{0,2,4,0,-3,0,0,0,2,0,0,5.552054666214398359613824,0.00003},
	{0,2,4,0,-2,0,0,0,0,0,0,5.382240064114806266104551,0.00002},
	{0,2,4,0,-2,0,0,0,2,-3,0,2.240270244873657556894386,0.00002},
	{0,2,4,0,-2,0,0,0,2,-2,0,5.381101062244955102187305,0.00002},
	{0,2,4,0,-2,0,0,0,2,-1,0,2.240270244873657556894386,0.00002},
	{0,2,4,0,-2,0,0,0,2,0,0,5.381405273133577971123032,0.00006},
	{0,2,4,0,-1,0,0,0,2,0,0,0.674480744103956642021558,0.00002},
	{0,2,4,0,0,0,0,0,0,-1,0,2.162644282930256789398982,0.00002},
	{0,2,4,0,0,0,0,0,2,-2,0,5.661727142152442660005818,0.00001},
	{0,2,4,0,0,0,0,0,2,0,0,2.800733515866729916865552,0.00001},
	{0,2,5,0,0,0,0,0,2,0,0,4.171602202312750584667356,0.00002},
	{0,2,18,-19,0,0,0,0,-2,-1,2,4.556406461673003782664182,0.00001},
	{0,2,21,-26,0,0,0,0,-3,1,1,3.279688514528265486092096,0.00006},
	{0,2,21,-24,0,0,0,0,-2,1,0,3.594424960270879765289465,0.00001},
	{0,2,27,-28,0,0,0,0,2,-1,-2,3.853188347836185023709277,0.00007},
	{0,2,38,-56,0,0,0,0,-2,1,0,1.348134725741243489238741,0.00002},
	{0,3,-15,23,0,0,0,0,2,0,-2,2.362197375621654327204624,0.00001},
	{0,3,-12,0,0,0,0,0,-2,0,0,5.054717859870857310511383,0.00001},
	{0,3,-10,0,0,0,0,0,-2,1,0,2.126714062284075446029874,0.00002},
	{0,3,-10,0,0,0,0,0,-2,3,0,2.126714062284075446029874,0.00002},
	{0,3,-10,0,2,0,0,0,-2,0,0,5.630625374881902622803409,0.00002},
	{0,3,-9,0,0,0,0,0,-2,-1,0,3.756865720813720610493647,0.00001},
	{0,3,-9,0,0,0,0,0,-2,0,0,0.678789612961280264258335,0.00002},
	{0,3,-9,0,0,0,0,0,-2,3,0,4.028896054155135075802718,0.00002},
	{0,3,-9,0,0,0,0,0,0,0,0,4.310318353267382107674166,0.00002},
	{0,3,-9,0,1,0,0,0,-2,1,0,5.610147252235329062841629,0.00001},
	{0,3,-9,0,1,0,0,0,-2,3,0,2.468554598645535058665246,0.00001},
	{0,3,-9,0,2,0,0,0,-2,0,0,4.043414226471999661782775,0.00003},
	{0,3,-9,0,2,0,0,0,-2,1,0,4.042176438966484930404022,0.00002},
	{0,3,-9,0,2,0,0,0,-2,3,0,4.042176438966484930404022,0.00002},
	{0,3,-9,0,2,0,0,0,0,0,0,4.042855721111361155806208,0.00002},
	{0,3,-9,0,3,0,0,0,-2,0,0,3.872663953360414357263153,0.00001},
	{0,3,-9,0,3,0,0,0,-2,2,0,3.872663953360414357263153,0.00001},
	{0,3,-9,2,0,0,0,0,-2,0,0,4.047540184823714248807391,0.00002},
	{0,3,-9,2,0,0,0,0,-2,1,0,0.905947531233921021787125,0.00002},
	{0,3,-9,2,0,0,0,0,-2,2,0,4.047540184823714248807391,0.00002},
	{0,3,-9,2,0,0,0,0,-2,3,0,0.905947531233921021787125,0.00002},
	{0,3,-9,4,0,0,0,0,-2,1,0,2.012917896922344240806524,0.00001},
	{0,3,-9,4,0,0,0,0,-2,3,0,2.012917896922344240806524,0.00001},
	{0,3,-9,4,0,0,0,0,0,0,0,6.132360061874617684907207,0.00001},
	{0,3,-9,4,0,0,0,0,2,0,0,6.150085625757872875851717,0.00002},
	{0,3,-8,0,0,0,0,0,-2,-1,0,5.654822968697403418047998,0.00004},
	{0,3,-8,0,0,0,0,0,-2,0,0,2.879080473324129307854946,0.00002},
	{0,3,-8,0,0,0,0,0,-2,1,0,1.218116946712701542665513,0.00001},
	{0,3,-8,0,0,0,0,0,-2,2,0,5.506616240869202094643242,0.00003},
	{0,3,-8,0,0,0,0,0,-2,3,0,2.367848053607910951967597,0.00003},
	{0,3,-8,0,0,0,0,0,0,-2,0,2.492630543012170463157418,0.00001},
	{0,3,-8,0,0,0,0,0,0,-1,0,5.634223196601963579155381,0.00001},
	{0,3,-8,0,0,0,0,0,0,0,0,2.601881871001708645962935,0.00003},
	{0,3,-8,0,0,0,0,0,0,1,0,5.634223196601963579155381,0.00001},
	{0,3,-8,0,0,0,0,0,2,-1,0,5.800110807884568231429512,0.00003},
	{0,3,-8,0,1,0,0,0,-2,-2,0,0.880784944874993591668044,0.00001},
	{0,3,-8,0,1,0,0,0,-2,2,0,0.893640516546408192333217,0.00002},
	{0,3,-8,0,1,0,0,0,-2,3,0,4.035233344669126864801001,0.00002},
	{0,3,-8,0,2,0,0,0,-2,0,0,5.093209351194340150925655,0.00004},
	{0,3,-8,0,2,0,0,0,-2,1,0,1.952885726503672536580325,0.00005},
	{0,3,-8,0,2,0,0,0,-2,3,0,5.101568954712617731672708,0.00001},
	{0,3,-8,2,0,0,0,0,-2,1,0,4.274442412360937915138948,0.00001},
	{0,3,-8,2,0,0,0,0,-2,3,0,4.274442412360937915138948,0.00001},
	{0,3,-8,3,0,0,0,0,-2,0,0,5.037439972940739529860821,0.00001},
	{0,3,-8,3,0,0,0,0,-2,2,0,5.037439972940739529860821,0.00001},
	{0,3,-8,4,0,0,0,0,-2,1,0,1.210375713348405879443703,0.00003},
	{0,3,-8,4,0,0,0,0,-2,2,0,4.376687988732970602256955,0.00001},
	{0,3,-8,4,0,0,0,0,0,-1,0,4.207713588135288951264101,0.00002},
	{0,3,-8,4,0,0,0,0,0,0,0,4.332651062777125972047543,0.00040},
	{0,3,-8,4,0,0,0,0,0,1,0,4.349342693611498944505911,0.00015},
	{0,3,-8,4,0,0,0,0,2,-2,0,4.360583835724819223855775,0.00001},
	{0,3,-8,4,0,0,0,0,2,-1,0,4.357179571018804153936799,0.00036},
	{0,3,-8,4,0,0,0,0,2,0,0,4.363108454487828247181369,0.00030},
	{0,3,-8,4,0,0,0,0,2,1,0,4.359421271910065343035967,0.00003},
	{0,3,-8,4,0,0,0,0,4,0,0,1.221903263991978239033642,0.00002},
	{0,3,-8,5,0,0,0,0,0,0,0,5.455689627691109322427110,0.00001},
	{0,3,-8,6,0,0,0,0,0,0,0,3.675784356017221199408596,0.00005},
	{0,3,-8,8,-3,0,0,0,0,0,0,2.845980304060056642612153,0.00001},
	{0,3,-7,0,-1,0,0,0,-2,0,0,1.018891801387753703878047,0.00002},
	{0,3,-7,0,-1,0,0,0,-2,0,2,1.074954394955689451762737,0.00003},
	{0,3,-7,0,-1,0,0,0,-2,1,0,4.664336051820006545653996,0.00008},
	{0,3,-7,0,-1,0,0,0,-2,2,0,1.148307790890207957801294,0.00001},
	{0,3,-7,0,0,-1,0,0,-2,0,2,5.658844556359848176896321,0.00001},
	{0,3,-7,0,0,0,0,0,-4,0,0,4.045472667791801590908563,0.00002},
	{0,3,-7,0,0,0,0,0,-2,-1,2,0.885366608694403867119149,0.00003},
	{0,3,-7,0,0,0,0,0,-2,0,0,0.921812574134549533866334,0.00007},
	{0,3,-7,0,0,0,0,0,-2,0,2,5.164777973435770164201131,0.00003},
	{0,3,-7,0,0,0,0,0,-2,1,0,5.186107642224392577645631,0.00003},
	{0,3,-7,0,0,0,0,0,-2,1,2,0.885366608694403867119149,0.00003},
	{0,3,-7,0,0,0,0,0,-2,2,0,0.906039335552575986199031,0.00003},
	{0,3,-7,0,0,0,0,0,-2,3,0,4.677090743460655453134223,0.00002},
	{0,3,-7,0,0,0,0,0,0,-1,0,3.632047452159794520554215,0.00002},
	{0,3,-7,0,0,0,0,0,0,-1,2,0.903880014202008585932901,0.00002},
	{0,3,-7,0,0,0,0,0,0,0,0,4.475387056064950463962759,0.00006},
	{0,3,-7,0,0,0,0,0,0,1,0,3.632047452159794520554215,0.00002},
	{0,3,-7,0,0,0,0,0,2,-1,0,3.332432189990609305851876,0.00009},
	{0,3,-7,0,0,0,0,0,2,0,0,3.347709405999165888090374,0.00010},
	{0,3,-7,0,0,0,1,0,-2,0,2,4.160715362037586295684832,0.00001},
	{0,3,-7,0,0,1,0,0,-2,0,2,5.576065509799934538648358,0.00001},
	{0,3,-7,0,0,1,0,0,-2,1,0,2.433454282058677087263732,0.00003},
	{0,3,-7,0,0,1,0,0,-2,3,0,5.575046935648471091440115,0.00003},
	{0,3,-7,0,1,0,0,0,-2,0,0,0.012010134181748580162186,0.00002},
	{0,3,-7,0,1,0,0,0,-2,0,2,3.153602787771541571260059,0.00002},
	{0,3,-7,0,1,0,0,0,-2,1,0,0.045718725223066261631466,0.00003},
	{0,3,-7,0,1,0,0,0,-2,2,0,1.237863601869765295404591,0.00002},
	{0,3,-7,0,1,0,0,0,-2,3,0,0.045718725223066261631466,0.00003},
	{0,3,-7,0,4,0,0,0,-2,1,0,0.073559519319179006435760,0.00003},
	{0,3,-7,0,4,0,0,0,-2,2,0,2.853484521711931343190827,0.00001},
	{0,3,-7,2,0,0,0,0,-2,1,0,0.434097942490179244945381,0.00001},
	{0,3,-7,2,0,0,0,0,-2,3,0,0.434097942490179244945381,0.00001},
	{0,3,-7,2,0,0,0,0,-1,0,1,6.246739516272366010696260,0.00006},
	{0,3,-7,4,0,0,0,0,-4,0,0,2.576819292008920569969632,0.00004},
	{0,3,-7,4,0,0,0,0,-4,1,0,2.574944982925203795787183,0.00010},
	{0,3,-7,4,0,0,0,0,-4,2,0,2.569087657955510639595786,0.00006},
	{0,3,-7,4,0,0,0,0,-2,-2,0,2.576819117475995568611324,0.00003},
	{0,3,-7,4,0,0,0,0,-2,-1,0,2.582656371159290475958414,0.00032},
	{0,3,-7,4,0,0,0,0,-2,0,0,2.577953581489791812231260,0.00338},
	{0,3,-7,4,0,0,0,0,-2,0,2,2.576818942943070123163807,0.00007},
	{0,3,-7,4,0,0,0,0,-2,1,0,2.571237729061042642797474,0.00534},
	{0,3,-7,4,0,0,0,0,-2,2,0,2.561476975219264318184287,0.00020},
	{0,3,-7,4,0,0,0,0,-1,0,0,5.719543442552780909693411,0.00010},
	{0,3,-7,4,0,0,0,0,-1,1,0,5.718411596532863683250980,0.00001},
	{0,3,-7,4,0,0,0,0,0,-3,0,2.623448730035677467498090,0.00002},
	{0,3,-7,4,0,0,0,0,0,-2,0,2.607737101576299121319380,0.00040},
	{0,3,-7,4,0,0,0,0,0,-1,-2,5.740038843958950920409734,0.00002},
	{0,3,-7,4,0,0,0,0,0,-1,0,2.608018099585870164247581,0.00588},
	{0,3,-7,4,0,0,0,0,0,0,-2,5.707267320193028403707558,0.00001},
	{0,3,-7,4,0,0,0,0,0,0,0,2.587119527122490492132556,0.03245},
	{0,3,-7,4,0,0,0,0,0,0,2,5.707267320193028403707558,0.00001},
	{0,3,-7,4,0,0,0,0,0,1,0,2.608079011576764916213733,0.00588},
	{0,3,-7,4,0,0,0,0,0,1,2,5.740038843958950920409734,0.00002},
	{0,3,-7,4,0,0,0,0,0,2,0,2.607815815925564439936579,0.00040},
	{0,3,-7,4,0,0,0,0,0,3,0,2.610216865377532613479161,0.00003},
	{0,3,-7,4,0,0,0,0,1,-1,0,5.718577751877653270184965,0.00001},
	{0,3,-7,4,0,0,0,0,1,0,0,5.719478865370457576489116,0.00010},
	{0,3,-7,4,0,0,0,0,2,-2,0,2.561767747072646539407970,0.00020},
	{0,3,-7,4,0,0,0,0,2,-1,0,2.571403186274131336119808,0.00531},
	{0,3,-7,4,0,0,0,0,2,0,-2,2.576984923754934708739484,0.00007},
	{0,3,-7,4,0,0,0,0,2,0,0,2.578110486589546113123106,0.00336},
	{0,3,-7,4,0,0,0,0,2,1,0,2.582809785600540752881216,0.00032},
	{0,3,-7,4,0,0,0,0,2,2,0,2.576984749222009707381176,0.00003},
	{0,3,-7,4,0,0,0,0,4,-2,0,2.569214194326280509272920,0.00006},
	{0,3,-7,4,0,0,0,0,4,-1,0,2.574950218912960053785355,0.00009},
	{0,3,-7,4,0,0,0,0,4,0,0,2.576984574689084261933658,0.00004},
	{0,3,-7,5,0,0,0,0,0,0,0,4.477687050953228720118204,0.00001},
	{0,3,-7,6,0,0,0,0,1,0,-1,5.824690279740404541541920,0.00002},
	{0,3,-7,7,0,0,0,0,0,0,0,4.665661280321045545349534,0.00001},
	{0,3,-7,7,0,0,0,0,2,-3,0,1.508201314902596568146009,0.00001},
	{0,3,-7,7,0,0,0,0,2,-1,0,1.508201314902596568146009,0.00001},
	{0,3,-6,-3,0,0,0,0,-2,0,0,6.201372125827726122793138,0.00001},
	{0,3,-6,-3,0,0,0,0,-2,1,0,3.059779472237933006795174,0.00002},
	{0,3,-6,-3,0,0,0,0,-2,2,0,6.201372125827726122793138,0.00001},
	{0,3,-6,-3,0,0,0,0,-2,3,0,3.059779472237933006795174,0.00002},
	{0,3,-6,-2,0,0,0,0,-2,0,0,0.193829110876557048070978,0.00003},
	{0,3,-6,-2,0,0,0,0,-2,1,0,0.186204465506294630783302,0.00001},
	{0,3,-6,-2,0,0,0,0,-2,2,0,0.192342439419708299830347,0.00002},
	{0,3,-6,-2,0,0,0,0,-2,3,0,0.186204465506294630783302,0.00001},
	{0,3,-6,-1,0,0,0,0,-2,1,0,0.907084438708670171003234,0.00002},
	{0,3,-6,-1,0,0,0,0,-2,3,0,0.907084438708670171003234,0.00002},
	{0,3,-6,0,-2,0,0,0,-2,1,0,0.120232590577235773365850,0.00004},
	{0,3,-6,0,-2,0,0,0,-2,3,0,3.146596338022335626050108,0.00002},
	{0,3,-6,0,-1,0,0,0,-4,3,0,0.976223911697173485357837,0.00001},
	{0,3,-6,0,-1,0,0,0,-2,0,0,4.114637273521533522568916,0.00001},
	{0,3,-6,0,-1,0,0,0,-2,1,0,4.132422353132281678256277,0.00009},
	{0,3,-6,0,-1,0,0,0,-2,3,0,4.057033728757011736831828,0.00002},
	{0,3,-6,0,-1,0,0,0,0,-1,0,4.114637273521533522568916,0.00001},
	{0,3,-6,0,0,0,0,0,-4,0,0,2.097469150804732951343112,0.00002},
	{0,3,-6,0,0,0,0,0,-3,0,1,4.168096533977195150555417,0.00002},
	{0,3,-6,0,0,0,0,0,-3,1,1,1.041369896824188678863266,0.00003},
	{0,3,-6,0,0,0,0,0,-2,-1,0,4.670817157464361990548696,0.00002},
	{0,3,-6,0,0,0,0,0,-2,0,0,4.416491967653953132355582,0.00005},
	{0,3,-6,0,0,0,0,0,-2,1,0,4.215954858330281496137104,0.00002},
	{0,3,-6,0,0,0,0,0,-2,3,0,2.859121760662947764330966,0.00004},
	{0,3,-6,0,0,0,0,0,-1,-2,1,4.176226801231759822030654,0.00002},
	{0,3,-6,0,0,0,0,0,-1,-1,-1,1.029956316180771658252979,0.00002},
	{0,3,-6,0,0,0,0,0,-1,-1,1,4.173691710493238282708717,0.00035},
	{0,3,-6,0,0,0,0,0,-1,0,-1,1.029956316180771658252979,0.00018},
	{0,3,-6,0,0,0,0,0,-1,0,0,0.404329606768163984931164,0.00003},
	{0,3,-6,0,0,0,0,0,-1,0,1,4.168096533977195150555417,0.00199},
	{0,3,-6,0,0,0,0,0,-1,1,-1,1.024382781747453119436386,0.00004},
	{0,3,-6,0,0,0,0,0,-1,1,1,4.173691710493238282708717,0.00035},
	{0,3,-6,0,0,0,0,0,-1,2,0,1.478054940864599098304666,0.00001},
	{0,3,-6,0,0,0,0,0,-1,2,1,4.176226801231759822030654,0.00002},
	{0,3,-6,0,0,0,0,0,0,-2,0,5.008207278766161785199529,0.00001},
	{0,3,-6,0,0,0,0,0,0,-1,0,1.760432633209387587314154,0.00015},
	{0,3,-6,0,0,0,0,0,0,0,0,1.697881952680088124552071,0.00129},
	{0,3,-6,0,0,0,0,0,0,1,0,1.585581010888540420822324,0.00043},
	{0,3,-6,0,0,0,0,0,0,2,0,1.523608732473352045388992,0.00001},
	{0,3,-6,0,0,0,0,0,1,-1,1,1.041369896824188678863266,0.00003},
	{0,3,-6,0,0,0,0,0,1,0,-1,1.049868254017999325000687,0.00009},
	{0,3,-6,0,0,0,0,0,1,0,1,4.437967545968042770709872,0.00002},
	{0,3,-6,0,0,0,0,0,2,-2,0,1.581257132199649806381103,0.00008},
	{0,3,-6,0,0,0,0,0,2,-1,0,1.580500531968910271629625,0.00153},
	{0,3,-6,0,0,0,0,0,2,0,-2,1.549259138358211718156099,0.00002},
	{0,3,-6,0,0,0,0,0,2,0,0,1.576823297767883325093408,0.00135},
	{0,3,-6,0,0,0,0,0,2,1,0,1.561046743060330976859973,0.00016},
	{0,3,-6,0,0,0,0,0,4,-2,0,1.566500896972813361429644,0.00003},
	{0,3,-6,0,0,0,0,0,4,-1,0,1.574503406126132487585778,0.00003},
	{0,3,-6,0,0,0,0,0,4,0,0,1.563233117014304340841591,0.00004},
	{0,3,-6,0,0,2,0,0,-1,-1,1,1.294477894014256724730672,0.00001},
	{0,3,-6,0,0,2,0,0,-1,0,1,1.658707863086150036124877,0.00002},
	{0,3,-6,0,0,2,0,0,-1,1,1,1.294477894014256724730672,0.00001},
	{0,3,-6,0,1,0,0,0,-1,0,1,2.702342848213576953497750,0.00002},
	{0,3,-6,0,1,0,0,0,0,0,0,3.235263078280927295793390,0.00002},
	{0,3,-6,0,1,0,0,0,2,0,0,3.241090558120411024844998,0.00003},
	{0,3,-6,0,2,0,0,0,-1,0,1,1.457717491755735172986874,0.00001},
	{0,3,-6,0,2,0,0,0,0,0,0,1.209506190315062346130048,0.00002},
	{0,3,-6,0,2,0,0,0,2,-1,0,5.039188443785387327977787,0.00004},
	{0,3,-6,0,2,0,0,0,2,0,0,5.039188443785387327977787,0.00003},
	{0,3,-6,0,3,0,0,0,0,0,0,1.034990718408149490414871,0.00002},
	{0,3,-6,2,0,0,0,0,-2,0,0,1.649195818662781087837743,0.00002},
	{0,3,-6,2,0,0,0,0,-2,1,0,1.649195818662781087837743,0.00003},
	{0,3,-6,2,0,0,0,0,0,-1,0,1.587757785531627829911372,0.00001},
	{0,3,-6,2,0,0,0,0,0,0,0,1.631458561073538371388736,0.00017},
	{0,3,-6,2,0,0,0,0,0,1,0,1.587757785531627829911372,0.00001},
	{0,3,-6,2,0,0,0,0,2,-1,0,1.652595370979815569967286,0.00003},
	{0,3,-6,2,0,0,0,0,2,0,0,1.652595370979815569967286,0.00002},
	{0,3,-6,3,0,0,0,0,0,0,0,2.685461151023661674486220,0.00002},
	{0,3,-6,4,0,0,0,0,-2,-1,0,0.880641653343404939846550,0.00003},
	{0,3,-6,4,0,0,0,0,-2,0,0,0.856399030033203612077841,0.00022},
	{0,3,-6,4,0,0,0,0,-2,1,0,0.878970326051695005631359,0.00026},
	{0,3,-6,4,0,0,0,0,0,-1,0,1.086075109350621792358993,0.00005},
	{0,3,-6,4,0,0,0,0,0,0,0,2.059064402345074373812395,0.00009},
	{0,3,-6,4,0,0,0,0,0,1,0,3.634482710065102484264798,0.00003},
	{0,3,-6,4,0,0,0,0,2,-1,0,3.921996382799734615076659,0.00002},
	{0,3,-6,4,0,0,0,0,2,0,0,3.836728147660626309090048,0.00003},
	{0,3,-5,-3,0,0,0,0,-2,1,0,1.716649652659708369384362,0.00004},
	{0,3,-5,-3,0,0,0,0,-2,2,0,0.817177991082387089605277,0.00005},
	{0,3,-5,-3,0,0,0,0,-2,3,0,1.716649652659708369384362,0.00004},
	{0,3,-5,0,-2,0,0,0,-2,0,0,0.904779905964336772505874,0.00002},
	{0,3,-5,0,-2,0,0,0,0,-1,0,4.046372559554129999526140,0.00002},
	{0,3,-5,0,-2,0,0,0,0,1,0,4.046372559554129999526140,0.00002},
	{0,3,-5,0,-1,0,0,0,0,-2,0,3.783549885214536168120958,0.00001},
	{0,3,-5,0,-1,0,0,0,0,0,0,1.763579287317808219626158,0.00003},
	{0,3,-5,0,0,0,0,0,-4,-1,0,6.006259325286326777870727,0.00002},
	{0,3,-5,0,0,0,0,0,-4,0,0,6.031274605856386195057439,0.00015},
	{0,3,-5,0,0,0,0,0,-4,1,0,6.005328715729164379411031,0.00034},
	{0,3,-5,0,0,0,0,0,-4,2,0,6.056135250254719437634776,0.00025},
	{0,3,-5,0,0,0,0,0,-3,0,0,5.973854844262100449725494,0.00002},
	{0,3,-5,0,0,0,0,0,-3,1,0,2.908455062766894805292850,0.00001},
	{0,3,-5,0,0,0,0,0,-2,-2,0,6.010208830850665151501744,0.00011},
	{0,3,-5,0,0,0,0,0,-2,-1,0,5.986430814187345461618861,0.00098},
	{0,3,-5,0,0,0,0,0,-2,-1,2,3.113399477517702518269971,0.00002},
	{0,3,-5,0,0,0,0,0,-2,0,-2,2.885077075568131199645450,0.00002},
	{0,3,-5,0,0,0,0,0,-2,0,0,6.004007152419553960953635,0.01070},
	{0,3,-5,0,0,0,0,0,-2,0,1,6.080889953167455175275791,0.00004},
	{0,3,-5,0,0,0,0,0,-2,0,2,6.006745574015933009093260,0.00027},
	{0,3,-5,0,0,0,0,0,-2,1,-2,2.883143774355697352973493,0.00004},
	{0,3,-5,0,0,0,0,0,-2,1,0,6.036794209615818473935178,0.01917},
	{0,3,-5,0,0,0,0,0,-2,2,0,6.058400338557956565921359,0.00079},
	{0,3,-5,0,0,0,0,0,-2,3,0,6.033371269886806942395197,0.00006},
	{0,3,-5,0,0,0,0,0,-1,-1,0,2.896086088890936327544523,0.00002},
	{0,3,-5,0,0,0,0,0,-1,0,-1,2.964403860867600215556195,0.00003},
	{0,3,-5,0,0,0,0,0,-1,0,0,2.705403981188649886746589,0.00028},
	{0,3,-5,0,0,0,0,0,-1,0,1,6.120009937554581114227403,0.00013},
	{0,3,-5,0,0,0,0,0,-1,1,-1,2.902062445315614969132412,0.00003},
	{0,3,-5,0,0,0,0,0,-1,1,0,2.838889380375054560801118,0.00005},
	{0,3,-5,0,0,0,0,0,0,-3,0,5.892776621058255059892872,0.00006},
	{0,3,-5,0,0,0,0,0,0,-2,0,5.907194786008980180724848,0.00098},
	{0,3,-5,0,0,0,0,0,0,-1,-2,2.806940604818522366770139,0.00004},
	{0,3,-5,0,0,0,0,0,0,-1,0,5.900385732998174148633552,0.01423},
	{0,3,-5,0,0,0,0,0,0,-1,1,6.108442244338212923082665,0.00007},
	{0,3,-5,0,0,0,0,0,0,-1,2,5.924810743215209285494893,0.00003},
	{0,3,-5,0,0,0,0,0,0,0,-2,2.953189596824761231630418,0.00007},
	{0,3,-5,0,0,0,0,0,0,0,-1,2.942223344068630286329835,0.00004},
	{0,3,-5,0,0,0,0,0,0,0,0,6.013181999231437480091245,0.08277},
	{0,3,-5,0,0,0,0,0,0,0,1,2.939297125044737057919519,0.00019},
	{0,3,-5,0,0,0,0,0,0,0,2,2.975812380056186423615827,0.00004},
	{0,3,-5,0,0,0,0,0,0,1,-2,5.924810743215209285494893,0.00003},
	{0,3,-5,0,0,0,0,0,0,1,0,5.910797145585095613284921,0.01498},
	{0,3,-5,0,0,0,0,0,0,1,2,2.806940604818522366770139,0.00004},
	{0,3,-5,0,0,0,0,0,0,2,0,5.900224813641139931519319,0.00100},
	{0,3,-5,0,0,0,0,0,0,3,0,5.860346134628172443115091,0.00006},
	{0,3,-5,0,0,0,0,0,1,-2,0,3.282548760106434038164025,0.00002},
	{0,3,-5,0,0,0,0,0,1,-1,-1,6.021377192734177263844231,0.00003},
	{0,3,-5,0,0,0,0,0,1,-1,0,1.767837716159749383848521,0.00002},
	{0,3,-5,0,0,0,0,0,1,-1,1,2.921069080869833189950668,0.00008},
	{0,3,-5,0,0,0,0,0,1,0,-1,6.059726788789473239660310,0.00033},
	{0,3,-5,0,0,0,0,0,1,0,0,0.811144911457018280565023,0.00022},
	{0,3,-5,0,0,0,0,0,1,0,1,2.915312461397980392519003,0.00008},
	{0,3,-5,0,0,0,0,0,1,1,-1,6.021377192734177263844231,0.00003},
	{0,3,-5,0,0,0,0,0,1,1,0,0.459850973735056345326200,0.00004},
	{0,3,-5,0,0,0,0,0,2,-3,0,6.086861422670228449760543,0.00006},
	{0,3,-5,0,0,0,0,0,2,-2,0,6.053765791262211592993481,0.00095},
	{0,3,-5,0,0,0,0,0,2,-1,0,6.055423330452830654735408,0.02299},
	{0,3,-5,0,0,0,0,0,2,-1,2,2.899608163321460541084207,0.00005},
	{0,3,-5,0,0,0,0,0,2,0,-2,6.047306153167655295987970,0.00030},
	{0,3,-5,0,0,0,0,0,2,0,0,6.047543867011777152242757,0.01424},
	{0,3,-5,0,0,0,0,0,2,0,2,2.901971164595735785951547,0.00003},
	{0,3,-5,0,0,0,0,0,2,1,-2,2.899460682999666971682018,0.00003},
	{0,3,-5,0,0,0,0,0,2,1,0,6.041487399974431404814368,0.00130},
	{0,3,-5,0,0,0,0,0,2,2,0,6.027848000935946082279315,0.00011},
	{0,3,-5,0,0,0,0,0,3,-2,0,0.236940139664218618609226,0.00007},
	{0,3,-5,0,0,0,0,0,3,-1,0,0.304516495774635853610590,0.00011},
	{0,3,-5,0,0,0,0,0,3,0,0,0.110074076198927978120778,0.00007},
	{0,3,-5,0,0,0,0,0,4,-2,0,6.108004864827663027426752,0.00033},
	{0,3,-5,0,0,0,0,0,4,-1,0,6.082174166431072670491176,0.00043},
	{0,3,-5,0,0,0,0,0,4,0,-2,6.044346249289198169662995,0.00002},
	{0,3,-5,0,0,0,0,0,4,0,0,6.000312813991857119333417,0.00013},
	{0,3,-5,0,0,0,0,0,4,1,0,6.034197683287626290393746,0.00003},
	{0,3,-5,0,0,0,0,0,6,-1,0,6.035507029292472402914882,0.00001},
	{0,3,-5,0,0,2,0,0,-2,0,0,3.120548520666797109868185,0.00002},
	{0,3,-5,0,0,2,0,0,0,-1,0,3.135899040503937307278193,0.00004},
	{0,3,-5,0,0,2,0,0,0,0,0,3.119078080771991778874508,0.00013},
	{0,3,-5,0,0,2,0,0,0,1,0,3.135899040503937307278193,0.00004},
	{0,3,-5,0,0,2,0,0,2,0,0,3.120883449350254412735239,0.00002},
	{0,3,-5,0,0,3,0,0,-2,0,0,1.520461903832006189674075,0.00002},
	{0,3,-5,0,0,3,0,0,-2,1,0,1.520461903832006189674075,0.00003},
	{0,3,-5,0,0,3,0,0,0,-1,0,1.524123255536839804946680,0.00004},
	{0,3,-5,0,0,3,0,0,0,0,0,1.523307314111532306810659,0.00017},
	{0,3,-5,0,0,3,0,0,0,1,0,1.524123255536839804946680,0.00004},
	{0,3,-5,0,0,3,0,0,2,-1,0,1.520604148166043723122698,0.00003},
	{0,3,-5,0,0,3,0,0,2,0,0,1.520604148166043723122698,0.00002},
	{0,3,-5,0,1,0,0,0,-2,0,0,1.436223587484499963906615,0.00010},
	{0,3,-5,0,1,0,0,0,-2,1,0,1.435990236963508026590830,0.00017},
	{0,3,-5,0,1,0,0,0,0,-2,0,1.449530152234629776231145,0.00001},
	{0,3,-5,0,1,0,0,0,0,-1,0,1.436305617959343639000735,0.00021},
	{0,3,-5,0,1,0,0,0,0,0,0,1.401047523608105249692812,0.00098},
	{0,3,-5,0,1,0,0,0,0,1,0,1.439232884180788429873132,0.00023},
	{0,3,-5,0,1,0,0,0,0,2,0,1.449408851851616164552183,0.00001},
	{0,3,-5,0,1,0,0,0,2,-3,0,1.564834805668859463168019,0.00001},
	{0,3,-5,0,1,0,0,0,2,-1,0,1.451101472160200467342861,0.00020},
	{0,3,-5,0,1,0,0,0,2,0,0,1.476568618473600880136587,0.00016},
	{0,3,-5,0,1,0,0,0,2,1,0,1.465968186728688005260324,0.00002},
	{0,3,-5,0,2,0,0,0,-4,1,0,3.123933237685189379106987,0.00002},
	{0,3,-5,0,2,0,0,0,-2,-1,0,3.124111435801817826529714,0.00006},
	{0,3,-5,0,2,0,0,0,-2,0,0,3.124184739630401885790434,0.00060},
	{0,3,-5,0,2,0,0,0,-2,0,2,3.123633913718472321363606,0.00001},
	{0,3,-5,0,2,0,0,0,-2,1,0,3.117890907814784728913082,0.00089},
	{0,3,-5,0,2,0,0,0,-2,2,0,3.123638975173303133914260,0.00004},
	{0,3,-5,0,2,0,0,0,0,-2,0,3.145593471834139620568749,0.00008},
	{0,3,-5,0,2,0,0,0,0,-1,0,3.146832306537205248275768,0.00106},
	{0,3,-5,0,2,0,0,0,0,0,-2,6.264161218332848335421659,0.00001},
	{0,3,-5,0,2,0,0,0,0,0,0,3.122552682246861888160083,0.00612},
	{0,3,-5,0,2,0,0,0,0,0,2,6.264161218332848335421659,0.00001},
	{0,3,-5,0,2,0,0,0,0,1,0,3.147127267180792831169356,0.00105},
	{0,3,-5,0,2,0,0,0,0,2,0,3.144969691159476887776236,0.00008},
	{0,3,-5,0,2,0,0,0,2,-2,0,3.060619673739843005222383,0.00001},
	{0,3,-5,0,2,0,0,0,2,-1,0,3.117343048962584184380376,0.00083},
	{0,3,-5,0,2,0,0,0,2,0,-2,3.123554152171656106418141,0.00001},
	{0,3,-5,0,2,0,0,0,2,0,0,3.122825128143098094568586,0.00051},
	{0,3,-5,0,2,0,0,0,2,1,0,3.123134749552402222860792,0.00005},
	{0,3,-5,0,2,0,0,0,4,-1,0,3.123554152171656106418141,0.00002},
	{0,3,-5,0,3,0,0,0,-2,0,0,2.972008085885614825372159,0.00002},
	{0,3,-5,0,3,0,0,0,-2,1,0,2.972008085885614825372159,0.00002},
	{0,3,-5,0,3,0,0,0,0,-1,0,2.954291597714470363200689,0.00002},
	{0,3,-5,0,3,0,0,0,0,0,0,2.928449380144816593940504,0.00017},
	{0,3,-5,0,3,0,0,0,0,1,0,2.954291597714470363200689,0.00002},
	{0,3,-5,0,3,0,0,0,2,-1,0,2.970540089451762177930050,0.00004},
	{0,3,-5,0,3,0,0,0,2,0,0,2.971822731919052440474616,0.00002},
	{0,3,-5,0,4,0,0,0,0,0,0,2.770430062196052922729450,0.00003},
	{0,3,-5,2,0,0,0,0,-2,0,0,6.268535537037122296055713,0.00003},
	{0,3,-5,2,0,0,0,0,0,-1,0,3.155954793471529296056133,0.00002},
	{0,3,-5,2,0,0,0,0,0,0,0,6.279675799119676327109119,0.00010},
	{0,3,-5,2,0,0,0,0,0,1,0,3.155954793471529296056133,0.00002},
	{0,3,-5,2,0,0,0,0,2,-3,0,3.132093524602888479080320,0.00002},
	{0,3,-5,2,0,0,0,0,2,-1,0,3.132093524602888479080320,0.00002},
	{0,3,-5,2,0,0,0,0,2,0,0,3.173465856389713568574962,0.00002},
	{0,3,-5,3,0,0,0,0,2,-3,0,3.665776289020435285692656,0.00001},
	{0,3,-5,3,0,0,0,0,2,-1,0,3.665776289020435285692656,0.00001},
	{0,3,-5,4,0,0,0,0,-2,0,0,5.454638241349708316363376,0.00002},
	{0,3,-4,-5,0,0,0,0,-2,2,0,1.935215140491855834170565,0.00002},
	{0,3,-4,-3,0,0,0,0,-1,2,-1,2.111159513457376846190527,0.00001},
	{0,3,-4,-2,0,0,0,0,0,0,0,5.274215702589420295964828,0.00001},
	{0,3,-4,-1,0,0,0,0,0,0,0,2.995410856759756157430274,0.00002},
	{0,3,-4,0,-1,0,0,0,2,-3,0,4.881746306220258624364305,0.00001},
	{0,3,-4,0,-1,0,0,0,2,-1,0,1.740153652630465730410947,0.00001},
	{0,3,-4,0,0,0,0,0,-6,1,0,4.733128029754437804399458,0.00002},
	{0,3,-4,0,0,0,0,0,-6,2,0,4.723890351089481853819052,0.00001},
	{0,3,-4,0,0,0,0,0,-4,-1,0,4.734491655499020623665274,0.00008},
	{0,3,-4,0,0,0,0,0,-4,0,0,4.710380280948569087229316,0.00044},
	{0,3,-4,0,0,0,0,0,-4,0,2,4.723320850154556715949639,0.00002},
	{0,3,-4,0,0,0,0,0,-4,1,0,4.713058837751605167909474,0.00100},
	{0,3,-4,0,0,0,0,0,-4,1,2,4.722594444119875944920750,0.00001},
	{0,3,-4,0,0,0,0,0,-4,2,0,4.712978203540162169815630,0.00062},
	{0,3,-4,0,0,0,0,0,-4,3,0,4.718576521648859767310569,0.00002},
	{0,3,-4,0,0,0,0,0,-3,0,0,1.576369337629439648651442,0.00007},
	{0,3,-4,0,0,0,0,0,-3,0,1,1.337295183888807637018203,0.00002},
	{0,3,-4,0,0,0,0,0,-3,1,0,1.576780013602433916375389,0.00019},
	{0,3,-4,0,0,0,0,0,-3,1,1,1.336647841269243075501549,0.00001},
	{0,3,-4,0,0,0,0,0,-2,-3,0,4.722693578821389515098872,0.00002},
	{0,3,-4,0,0,0,0,0,-2,-2,0,4.723434820154711388795477,0.00026},
	{0,3,-4,0,0,0,0,0,-2,-1,-2,1.581406532383620389126122,0.00002},
	{0,3,-4,0,0,0,0,0,-2,-1,0,4.719423879000703259123384,0.00334},
	{0,3,-4,0,0,0,0,0,-2,-1,2,1.581194474879503264475034,0.00006},
	{0,3,-4,0,0,0,0,0,-2,0,-2,1.581427476334644532940388,0.00006},
	{0,3,-4,0,0,0,0,0,-2,0,0,4.722117620168231333366293,0.03668},
	{0,3,-4,0,0,0,0,0,-2,0,2,4.722767929847524470687858,0.00048},
	{0,3,-4,0,0,0,0,0,-2,1,-2,1.581735701480546651964687,0.00012},
	{0,3,-4,0,0,0,0,0,-2,1,0,4.722973006034633769445463,0.04662},
	{0,3,-4,0,0,0,0,0,-2,1,2,4.724879254643662207513444,0.00002},
	{0,3,-4,0,0,0,0,0,-2,2,0,4.726242356789470022704336,0.00198},
	{0,3,-4,0,0,0,0,0,-2,3,0,4.725091835746555446462480,0.00011},
	{0,3,-4,0,0,0,0,0,-1,-2,0,4.715749437326479664989165,0.00008},
	{0,3,-4,0,0,0,0,0,-1,-1,0,4.717024749410911432789817,0.00031},
	{0,3,-4,0,0,0,0,0,-1,-1,1,1.334402824252402641747040,0.00015},
	{0,3,-4,0,0,0,0,0,-1,-1,2,4.718342472996168268650763,0.00002},
	{0,3,-4,0,0,0,0,0,-1,0,-2,4.717313601402116418626065,0.00002},
	{0,3,-4,0,0,0,0,0,-1,0,-1,4.478308911765713773434072,0.00030},
	{0,3,-4,0,0,0,0,0,-1,0,0,1.576899568656195516069829,0.01197},
	{0,3,-4,0,0,0,0,0,-1,0,1,1.336916621974050256582700,0.00102},
	{0,3,-4,0,0,0,0,0,-1,1,-1,4.478903370908943415429349,0.00028},
	{0,3,-4,0,0,0,0,0,-1,1,0,1.576648939375609126400946,0.00125},
	{0,3,-4,0,0,0,0,0,-1,1,1,1.337414738942569236712643,0.00010},
	{0,3,-4,0,0,0,0,0,-1,2,-1,4.478238749529784179514991,0.00002},
	{0,3,-4,0,0,0,0,0,-1,2,0,1.575733339650013054011879,0.00011},
	{0,3,-4,0,0,0,0,0,0,-3,0,4.737303380923982842887199,0.00019},
	{0,3,-4,0,0,0,0,0,0,-2,0,4.735906942989463352944313,0.00265},
	{0,3,-4,0,0,0,0,0,0,-1,-2,1.585917510368325178404803,0.00009},
	{0,3,-4,0,0,0,0,0,0,-1,0,4.732877575006775749955068,0.03945},
	{0,3,-4,0,0,0,0,0,0,-1,2,4.761535706791597988285503,0.00002},
	{0,3,-4,0,0,0,0,0,0,0,-2,1.589838043467079797821384,0.00004},
	{0,3,-4,0,0,0,0,0,0,0,-1,4.476480853907174761729948,0.00007},
	{0,3,-4,0,0,0,0,0,0,0,0,4.729722892383796839510524,0.17511},
	{0,3,-4,0,0,0,0,0,0,0,1,1.331892342656333827477511,0.00004},
	{0,3,-4,0,0,0,0,0,0,0,2,1.585995526585889381365746,0.00013},
	{0,3,-4,0,0,0,0,0,0,1,-1,4.544590931702852110163349,0.00002},
	{0,3,-4,0,0,0,0,0,0,1,0,4.731354775234411391693357,0.02911},
	{0,3,-4,0,0,0,0,0,0,1,2,1.587003105163065530547328,0.00008},
	{0,3,-4,0,0,0,0,0,0,2,0,4.731931432019270467037586,0.00202},
	{0,3,-4,0,0,0,0,0,0,3,0,4.730832747255139913988842,0.00013},
	{0,3,-4,0,0,0,0,0,1,-5,0,1.576209116404106547193464,0.00001},
	{0,3,-4,0,0,0,0,0,1,-4,0,4.711565359510673900444999,0.00002},
	{0,3,-4,0,0,0,0,0,1,-3,-2,4.717801769993900329325243,0.00001},
	{0,3,-4,0,0,0,0,0,1,-3,0,4.710693393016377683579776,0.00028},
	{0,3,-4,0,0,0,0,0,1,-2,-2,1.573607354088158771787676,0.00002},
	{0,3,-4,0,0,0,0,0,1,-2,0,4.710560398927375658217898,0.00405},
	{0,3,-4,0,0,0,0,0,1,-2,1,1.615534875110042678514333,0.00003},
	{0,3,-4,0,0,0,0,0,1,-1,-2,1.576989627645598357474910,0.00008},
	{0,3,-4,0,0,0,0,0,1,-1,-1,1.357791283426677875212363,0.00005},
	{0,3,-4,0,0,0,0,0,1,-1,0,4.718374063455629041641259,0.10386},
	{0,3,-4,0,0,0,0,0,1,-1,1,4.465387366648574385408210,0.00014},
	{0,3,-4,0,0,0,0,0,1,-1,2,1.576989627645598357474910,0.00008},
	{0,3,-4,0,0,0,0,0,1,0,-2,4.717414481432881778744104,0.00012},
	{0,3,-4,0,0,0,0,0,1,0,-1,4.476376832283756712627110,0.00297},
	{0,3,-4,0,0,0,0,0,1,0,0,4.717381320177094217171998,0.06514},
	{0,3,-4,0,0,0,0,0,1,0,1,1.347985500090198129896635,0.00047},
	{0,3,-4,0,0,0,0,0,1,0,2,1.575895829803373615618511,0.00014},
	{0,3,-4,0,0,0,0,0,1,1,-1,1.348944034915393386242499,0.00008},
	{0,3,-4,0,0,0,0,0,1,1,0,4.717443279365539865466417,0.00443},
	{0,3,-4,0,0,0,0,0,1,1,1,1.330333763634303112510793,0.00004},
	{0,3,-4,0,0,0,0,0,1,1,2,1.576209116404106547193464,0.00001},
	{0,3,-4,0,0,0,0,0,1,2,0,4.717408198247574624417666,0.00031},
	{0,3,-4,0,0,0,0,0,1,3,0,4.717801769993900329325243,0.00001},
	{0,3,-4,0,0,0,0,0,2,-3,0,2.913678309619338158142909,0.00004},
	{0,3,-4,0,0,0,0,0,2,-2,0,1.404222975649183968727129,0.00042},
	{0,3,-4,0,0,0,0,0,2,-1,-2,1.601910311370199568870021,0.00002},
	{0,3,-4,0,0,0,0,0,2,-1,-1,1.424409628310675524076601,0.00001},
	{0,3,-4,0,0,0,0,0,2,-1,0,4.923257042616766554488095,0.00431},
	{0,3,-4,0,0,0,0,0,2,0,-2,4.744280509141756141389124,0.00022},
	{0,3,-4,0,0,0,0,0,2,0,-1,1.335670980486901804340505,0.00006},
	{0,3,-4,0,0,0,0,0,2,0,0,4.754217890303835680754219,0.00462},
	{0,3,-4,0,0,0,0,0,2,1,-2,1.601910311370199568870021,0.00002},
	{0,3,-4,0,0,0,0,0,2,1,0,4.742952139048063564530366,0.00056},
	{0,3,-4,0,0,0,0,0,2,2,0,4.725780717202317404712630,0.00008},
	{0,3,-4,0,0,0,0,0,3,-3,0,4.735642351074860201265437,0.00003},
	{0,3,-4,0,0,0,0,0,3,-2,0,4.722306813859146856771076,0.00149},
	{0,3,-4,0,0,0,0,0,3,-1,-2,4.718342472996168268650763,0.00002},
	{0,3,-4,0,0,0,0,0,3,-1,-1,4.480161229700855507473989,0.00007},
	{0,3,-4,0,0,0,0,0,3,-1,0,4.718184520698862627341441,0.00199},
	{0,3,-4,0,0,0,0,0,3,0,-1,4.479303051307649496948216,0.00002},
	{0,3,-4,0,0,0,0,0,3,0,0,4.717581334909373147468159,0.00070},
	{0,3,-4,0,0,0,0,0,3,1,0,4.717504540422284620149185,0.00009},
	{0,3,-4,0,0,0,0,0,4,-3,0,1.629868042526195770491881,0.00006},
	{0,3,-4,0,0,0,0,0,4,-2,0,4.935611704792858489554419,0.00037},
	{0,3,-4,0,0,0,0,0,4,-1,0,4.907013263268455105503563,0.00052},
	{0,3,-4,0,0,0,0,0,4,0,0,4.795390207358383172220329,0.00008},
	{0,3,-4,0,0,0,0,0,4,1,0,1.600386115334432757251193,0.00003},
	{0,3,-4,0,0,0,0,0,5,-3,0,4.722254279448662828144734,0.00002},
	{0,3,-4,0,0,0,0,0,5,-2,0,4.719392812140018378386230,0.00004},
	{0,3,-4,0,0,0,0,0,5,-1,0,4.718100570361841050726071,0.00003},
	{0,3,-4,0,0,0,0,0,6,-3,0,4.939083339208000467124293,0.00001},
	{0,3,-4,0,0,0,0,0,6,-2,0,4.941036188108057558565633,0.00002},
	{0,3,-4,0,1,0,0,0,-2,0,0,3.549112198631827475026057,0.00002},
	{0,3,-4,0,1,0,0,0,-2,1,0,6.187618582256160237875520,0.00011},
	{0,3,-4,0,1,0,0,0,-2,2,0,1.450296700842105490636413,0.00001},
	{0,3,-4,0,1,0,0,0,-2,3,0,6.213100214802352638798766,0.00001},
	{0,3,-4,0,1,0,0,0,0,-1,0,5.974860677510023698744135,0.00001},
	{0,3,-4,0,1,0,0,0,0,0,0,6.226673814928037842264530,0.00044},
	{0,3,-4,0,1,0,0,0,0,1,0,5.974860677510023698744135,0.00001},
	{0,3,-4,0,1,0,0,0,0,2,0,3.118706500174241558198673,0.00003},
	{0,3,-4,0,1,0,0,0,2,-2,0,3.109581569778965270955950,0.00001},
	{0,3,-4,0,1,0,0,0,2,-1,0,5.720934644499546806173385,0.00004},
	{0,3,-4,0,1,0,0,0,2,0,0,3.109580697114339375985992,0.00001},
	{0,3,-4,0,2,0,0,0,-2,0,0,1.457186737130203635359749,0.00004},
	{0,3,-4,0,2,0,0,0,-2,1,0,1.457186737130203635359749,0.00005},
	{0,3,-4,0,2,0,0,0,0,-1,0,4.192366035357877329659004,0.00001},
	{0,3,-4,0,2,0,0,0,0,0,0,1.874265101419560153317434,0.00004},
	{0,3,-4,0,2,0,0,0,0,1,0,4.192366035357877329659004,0.00001},
	{0,3,-4,0,2,0,0,0,1,-1,-1,4.031041936470462161423711,0.00002},
	{0,3,-4,0,2,0,0,0,1,0,-1,1.956905394303940726175028,0.00006},
	{0,3,-4,0,2,0,0,0,1,1,-1,4.031041936470462161423711,0.00002},
	{0,3,-4,0,2,0,0,0,2,-3,0,1.059267201105839273367337,0.00001},
	{0,3,-4,0,2,0,0,0,2,-2,0,1.056832292266381978507184,0.00001},
	{0,3,-4,0,2,0,0,0,2,-1,0,1.543100569559624712923096,0.00003},
	{0,3,-4,0,2,0,0,0,2,0,0,1.051955144204609116087568,0.00004},
	{0,3,-4,1,0,0,0,0,2,-3,0,6.274945084182145471629610,0.00001},
	{0,3,-4,1,0,0,0,0,2,-1,0,6.274945084182145471629610,0.00001},
	{0,3,-4,2,0,0,0,0,2,-3,0,1.944833475466671401932217,0.00002},
	{0,3,-4,2,0,0,0,0,2,-1,0,1.944833475466671401932217,0.00002},
	{0,3,-4,3,0,0,0,0,2,-3,0,0.902621806344245825037831,0.00001},
	{0,3,-4,3,0,0,0,0,2,-2,0,4.134271878540619837849590,0.00001},
	{0,3,-4,3,0,0,0,0,2,-1,0,0.902621806344245825037831,0.00001},
	{0,3,-4,3,0,0,0,0,2,0,0,4.134271878540619837849590,0.00001},
	{0,3,-3,-2,0,0,0,0,0,0,0,0.586487002804934154376326,0.00001},
	{0,3,-3,0,-2,0,0,0,-2,0,0,3.585592547058237045121132,0.00001},
	{0,3,-3,0,-2,0,0,0,0,0,0,5.941938182763804476849145,0.00001},
	{0,3,-3,0,-2,0,0,0,2,-2,0,0.257667844393828449067740,0.00001},
	{0,3,-3,0,-2,0,0,0,2,-1,0,0.529000918699071731587935,0.00003},
	{0,3,-3,0,-1,0,0,0,-4,2,0,0.889045064625907155431150,0.00001},
	{0,3,-3,0,-1,0,0,0,-2,0,0,3.605324017850808804297458,0.00008},
	{0,3,-3,0,-1,0,0,0,-2,1,0,0.227872456068407253093611,0.00003},
	{0,3,-3,0,-1,0,0,0,-2,2,0,4.752446381113061946166454,0.00003},
	{0,3,-3,0,-1,0,0,0,-2,3,0,0.227872456068407253093611,0.00002},
	{0,3,-3,0,-1,0,0,0,0,-2,0,3.369465109658200230313696,0.00001},
	{0,3,-3,0,-1,0,0,0,0,-1,0,1.517799054992238438899221,0.00001},
	{0,3,-3,0,-1,0,0,0,0,0,0,0.808274193903337878630566,0.00003},
	{0,3,-3,0,-1,0,0,0,2,-3,0,4.943128663348273832411905,0.00002},
	{0,3,-3,0,-1,0,0,0,2,-2,0,3.737115400465226944248798,0.00006},
	{0,3,-3,0,-1,0,0,0,2,-1,0,4.582633000743947526700595,0.00008},
	{0,3,-3,0,-1,0,0,0,2,0,0,3.347725463028284220712294,0.00005},
	{0,3,-3,0,-1,0,0,0,4,-3,0,1.517799054992238438899221,0.00001},
	{0,3,-3,0,0,-3,0,0,2,-3,0,2.039792825810403442687857,0.00005},
	{0,3,-3,0,0,-3,0,0,2,-2,0,2.130412764034901762499885,0.00070},
	{0,3,-3,0,0,-3,0,0,2,-1,0,2.039792825810403442687857,0.00005},
	{0,3,-3,0,0,-1,0,0,2,-3,0,1.626951946411963723093663,0.00001},
	{0,3,-3,0,0,-1,0,0,2,-2,0,4.762995849243816692819564,0.00001},
	{0,3,-3,0,0,-1,0,0,2,-1,0,1.619505848224180422079144,0.00007},
	{0,3,-3,0,0,0,0,0,-6,1,0,0.069891360830262524994616,0.00001},
	{0,3,-3,0,0,0,0,0,-4,-1,0,6.230077381502351130393436,0.00003},
	{0,3,-3,0,0,0,0,0,-4,0,0,0.124028681700323439862643,0.00014},
	{0,3,-3,0,0,0,0,0,-4,0,2,0.036429210279326440513614,0.00002},
	{0,3,-3,0,0,0,0,0,-4,1,0,0.085930936656090403658048,0.00034},
	{0,3,-3,0,0,0,0,0,-4,2,0,0.091752482376117508455771,0.00017},
	{0,3,-3,0,0,0,0,0,-4,3,0,3.134533843963027255341558,0.00001},
	{0,3,-3,0,0,0,0,0,-3,1,0,3.193424394517969666651425,0.00002},
	{0,3,-3,0,0,0,0,0,-2,-2,0,0.009144652615824290509128,0.00024},
	{0,3,-3,0,0,0,0,0,-2,-1,0,0.032831214026340135858639,0.00215},
	{0,3,-3,0,0,0,0,0,-2,-1,2,3.177195101402450205796413,0.00003},
	{0,3,-3,0,0,0,0,0,-2,0,-2,3.187845973162744872553276,0.00003},
	{0,3,-3,0,0,0,0,0,-2,0,0,0.049248653635224799718362,0.01502},
	{0,3,-3,0,0,0,0,0,-2,0,2,0.055820341867759040721531,0.00011},
	{0,3,-3,0,0,0,0,0,-2,1,-2,3.188581105843685481460170,0.00001},
	{0,3,-3,0,0,0,0,0,-2,1,0,0.046529430660617626669406,0.01487},
	{0,3,-3,0,0,0,0,0,-2,1,2,3.182859218423947034182220,0.00003},
	{0,3,-3,0,0,0,0,0,-2,2,0,0.028695481830814370538540,0.00082},
	{0,3,-3,0,0,0,0,0,-2,3,0,0.017674774802021377129169,0.00013},
	{0,3,-3,0,0,0,0,0,-1,-2,0,3.091646566385471306404042,0.00003},
	{0,3,-3,0,0,0,0,0,-1,-1,0,3.086487722182426729489180,0.00017},
	{0,3,-3,0,0,0,0,0,-1,0,-1,3.116781576542217546688107,0.00003},
	{0,3,-3,0,0,0,0,0,-1,0,0,5.940994657770175990663120,0.00033},
	{0,3,-3,0,0,0,0,0,-1,0,1,6.182755047762553246570860,0.00013},
	{0,3,-3,0,0,0,0,0,-1,1,-1,0.005840569808873824139694,0.00001},
	{0,3,-3,0,0,0,0,0,-1,1,0,6.273353343904326528956972,0.00006},
	{0,3,-3,0,0,0,0,0,0,-4,0,0.001697681763414884189428,0.00004},
	{0,3,-3,0,0,0,0,0,0,-3,0,0.002507863602190652310697,0.00063},
	{0,3,-3,0,0,0,0,0,0,-2,-2,3.141353194416419469803259,0.00005},
	{0,3,-3,0,0,0,0,0,0,-2,0,0.002443286419866862006767,0.00884},
	{0,3,-3,0,0,0,0,0,0,-1,-2,3.143525431203451514505787,0.00025},
	{0,3,-3,0,0,0,0,0,0,-1,0,0.002102423616952369365973,0.12537},
	{0,3,-3,0,0,0,0,0,0,-1,2,3.135263740656211606250281,0.00004},
	{0,3,-3,0,0,0,0,0,0,0,-2,6.279059348827871644971310,0.00007},
	{0,3,-3,0,0,0,0,0,0,0,-1,0.197554341632013741314466,0.00003},
	{0,3,-3,0,0,0,0,0,0,0,0,3.125880326998714320296813,0.04340},
	{0,3,-3,0,0,0,0,0,0,0,2,6.259473263961990774362221,0.00003},
	{0,3,-3,0,0,0,0,0,0,1,-2,0.002131221549610275677045,0.00020},
	{0,3,-3,0,0,0,0,0,0,1,0,3.127303119404940101588863,0.00737},
	{0,3,-3,0,0,0,0,0,0,1,2,6.263640063018202752687102,0.00003},
	{0,3,-3,0,0,0,0,0,0,2,-2,6.274920649572617747935510,0.00002},
	{0,3,-3,0,0,0,0,0,0,2,0,3.139402439911465059196871,0.00054},
	{0,3,-3,0,0,0,0,0,0,3,0,3.134808035188515251689978,0.00005},
	{0,3,-3,0,0,0,0,0,1,-2,0,3.054300360117147228322665,0.00006},
	{0,3,-3,0,0,0,0,0,1,-1,-1,3.178075270944230812375508,0.00009},
	{0,3,-3,0,0,0,0,0,1,-1,0,3.194712622038866633999987,0.00019},
	{0,3,-3,0,0,0,0,0,1,-1,1,0.115052627890241801478233,0.00006},
	{0,3,-3,0,0,0,0,0,1,0,-2,0.000205599785884932022154,0.00003},
	{0,3,-3,0,0,0,0,0,1,0,-1,3.220300719669430211666850,0.00071},
	{0,3,-3,0,0,0,0,0,1,0,0,6.253210673539985720026380,0.00226},
	{0,3,-3,0,0,0,0,0,1,0,1,0.082002724108626773302788,0.00006},
	{0,3,-3,0,0,0,0,0,1,1,-1,3.178075270944230812375508,0.00009},
	{0,3,-3,0,0,0,0,0,1,1,0,6.228574303950534130080996,0.00016},
	{0,3,-3,0,0,0,0,0,2,-4,0,0.068733509404489495642210,0.00007},
	{0,3,-3,0,0,0,0,0,2,-3,-2,3.151788867079944100879629,0.00001},
	{0,3,-3,0,0,0,0,0,2,-3,0,0.054796182662688770748094,0.00122},
	{0,3,-3,0,0,0,0,0,2,-2,-2,3.148020177626112747759635,0.00013},
	{0,3,-3,0,0,0,0,0,2,-2,0,0.000727278699306037053167,0.07199},
	{0,3,-3,0,0,0,0,0,2,-1,-2,3.141487759301748283746747,0.00187},
	{0,3,-3,0,0,0,0,0,2,-1,-1,3.366339224967878518413045,0.00004},
	{0,3,-3,0,0,0,0,0,2,-1,0,3.141268720480622889112965,0.64371},
	{0,3,-3,0,0,0,0,0,2,-1,2,6.282821929629321289212385,0.00128},
	{0,3,-3,0,0,0,0,0,2,0,-2,0.000592364748126875399932,0.00305},
	{0,3,-3,0,0,0,0,0,2,0,-1,3.339146297090106241256535,0.00015},
	{0,3,-3,0,0,0,0,0,2,0,0,3.140593801658876582649782,0.03030},
	{0,3,-3,0,0,0,0,0,2,0,2,6.282551578128186875460415,0.00018},
	{0,3,-3,0,0,0,0,0,2,1,-2,3.141854976576367697305159,0.00072},
	{0,3,-3,0,0,0,0,0,2,1,0,3.138865576633552034735430,0.00207},
	{0,3,-3,0,0,0,0,0,2,1,2,6.282849505831502590069704,0.00003},
	{0,3,-3,0,0,0,0,0,2,2,-2,3.141847471660584201202937,0.00005},
	{0,3,-3,0,0,0,0,0,2,2,0,3.138452980798380753668653,0.00008},
	{0,3,-3,0,0,0,0,0,3,-2,0,3.167573275769130614065716,0.00002},
	{0,3,-3,0,0,0,0,0,3,-1,0,6.266104118856167914941580,0.00028},
	{0,3,-3,0,0,0,0,0,3,0,0,0.000437379510549778941549,0.00008},
	{0,3,-3,0,0,0,0,0,3,1,0,0.001054876999905372857505,0.00001},
	{0,3,-3,0,0,0,0,0,4,-4,0,6.259383728571364713388903,0.00005},
	{0,3,-3,0,0,0,0,0,4,-3,0,6.275094484366116276419234,0.00133},
	{0,3,-3,0,0,0,0,0,4,-2,-2,0.000147829387643919714021,0.00004},
	{0,3,-3,0,0,0,0,0,4,-2,0,3.141218978596941102665596,0.00765},
	{0,3,-3,0,0,0,0,0,4,-2,2,6.282916177408928604108951,0.00005},
	{0,3,-3,0,0,0,0,0,4,-1,-2,6.283153542187199569468703,0.00035},
	{0,3,-3,0,0,0,0,0,4,-1,0,3.141050030725347941285008,0.00577},
	{0,3,-3,0,0,0,0,0,4,-1,2,6.282865562860620478602414,0.00003},
	{0,3,-3,0,0,0,0,0,4,0,-2,6.280753190866932733626982,0.00001},
	{0,3,-3,0,0,0,0,0,4,0,0,3.141318287831379674202026,0.00071},
	{0,3,-3,0,0,0,0,0,4,1,0,3.140086085379471647627270,0.00004},
	{0,3,-3,0,0,0,0,0,5,-2,0,6.282979009262001035551748,0.00001},
	{0,3,-3,0,0,0,0,0,6,-4,0,6.273298191499963927242334,0.00002},
	{0,3,-3,0,0,0,0,0,6,-3,0,3.145499224054531861582973,0.00009},
	{0,3,-3,0,0,0,0,0,6,-2,0,3.141284079378040328123234,0.00016},
	{0,3,-3,0,0,0,0,0,6,-1,0,3.140971839974858514921152,0.00006},
	{0,3,-3,0,0,1,0,0,2,-3,0,1.530375548516259121001326,0.00001},
	{0,3,-3,0,0,1,0,0,2,-2,0,1.530213581961674007558827,0.00001},
	{0,3,-3,0,0,1,0,0,2,-1,0,1.530461942314232715034450,0.00004},
	{0,3,-3,0,1,0,0,0,-2,0,0,5.724961119083897820303264,0.00007},
	{0,3,-3,0,1,0,0,0,0,-1,0,2.989145997409722088633544,0.00001},
	{0,3,-3,0,1,0,0,0,0,0,0,3.280500616229218735497852,0.00005},
	{0,3,-3,0,1,0,0,0,0,1,0,2.989145997409722088633544,0.00001},
	{0,3,-3,0,1,0,0,0,2,-2,0,0.652849831486439824423940,0.00001},
	{0,3,-3,0,1,0,0,0,2,-1,0,3.538025692690234258463988,0.00004},
	{0,3,-3,0,1,0,0,0,2,0,0,5.795526351538354603576408,0.00004},
	{0,3,-3,0,2,0,0,0,2,-3,0,5.707946776870830518646471,0.00001},
	{0,3,-3,0,2,0,0,0,2,-1,0,3.209423653238076212801388,0.00003},
	{0,3,-2,-3,0,0,0,0,2,-3,0,5.297308852054258387909158,0.00003},
	{0,3,-2,-3,0,0,0,0,2,-2,0,5.298204031427606430781907,0.00001},
	{0,3,-2,-3,0,0,0,0,2,-1,0,5.297308852054258387909158,0.00003},
	{0,3,-2,-3,0,0,0,0,2,0,0,5.298204031427606430781907,0.00001},
	{0,3,-2,-2,0,0,0,0,0,0,0,1.783483371173401943465819,0.00001},
	{0,3,-2,-2,0,0,0,0,2,-2,0,2.198945560575412017101371,0.00001},
	{0,3,-2,-2,0,0,0,0,2,-1,0,2.736261925962685470636870,0.00002},
	{0,3,-2,-2,0,0,0,0,2,0,0,2.437910631237794500947302,0.00002},
	{0,3,-2,0,-2,0,0,0,-2,0,0,1.563758810185005065918062,0.00002},
	{0,3,-2,0,-2,0,0,0,-2,1,0,2.090756614501562804520063,0.00001},
	{0,3,-2,0,-2,0,0,0,-2,2,0,4.705351463774798403960631,0.00002},
	{0,3,-2,0,-2,0,0,0,2,-3,0,5.385133994547538272001930,0.00001},
	{0,3,-2,0,-2,0,0,0,2,-1,0,5.385133994547538272001930,0.00001},
	{0,3,-2,0,-1,0,0,0,-2,0,0,0.040334209947738557111574,0.00001},
	{0,3,-2,0,-1,0,0,0,-2,2,0,0.025986556298793973135419,0.00003},
	{0,3,-2,0,-1,0,0,0,0,-2,0,3.228793840875485265939915,0.00001},
	{0,3,-2,0,-1,0,0,0,0,-1,0,0.083518193498133455610066,0.00002},
	{0,3,-2,0,-1,0,0,0,0,0,0,3.134830549935866184085853,0.00001},
	{0,3,-2,0,-1,0,0,0,2,-1,0,3.225110847087926391196788,0.00010},
	{0,3,-2,0,-1,0,0,0,2,0,0,0.069890313632711323355018,0.00008},
	{0,3,-2,0,0,-1,0,0,-2,0,0,3.145353489061990970299121,0.00001},
	{0,3,-2,0,0,-1,0,0,-2,2,0,0.003760835472197381589010,0.00001},
	{0,3,-2,0,0,0,0,0,-4,0,0,4.477894047002515698352454,0.00003},
	{0,3,-2,0,0,0,0,0,-4,1,0,4.449158771664755818164849,0.00002},
	{0,3,-2,0,0,0,0,0,-3,0,1,1.800869817582993803739555,0.00002},
	{0,3,-2,0,0,0,0,0,-3,1,1,1.803201926529508725138840,0.00002},
	{0,3,-2,0,0,0,0,0,-2,-2,0,4.487698434075593212355670,0.00002},
	{0,3,-2,0,0,0,0,0,-2,-1,0,4.484792286338097788700452,0.00029},
	{0,3,-2,0,0,0,0,0,-2,0,0,4.478734248504425252690453,0.00161},
	{0,3,-2,0,0,0,0,0,-2,0,2,4.505413002384559995050495,0.00001},
	{0,3,-2,0,0,0,0,0,-2,1,0,4.488393598716663213110678,0.00135},
	{0,3,-2,0,0,0,0,0,-2,2,0,4.455852283879079500650278,0.00006},
	{0,3,-2,0,0,0,0,0,-1,-1,-1,1.800154581655526664363265,0.00002},
	{0,3,-2,0,0,0,0,0,-1,-1,1,4.949116189880164995429368,0.00009},
	{0,3,-2,0,0,0,0,0,-1,0,-1,1.800559148976139001163688,0.00042},
	{0,3,-2,0,0,0,0,0,-1,0,0,4.464764284105612546227349,0.00003},
	{0,3,-2,0,0,0,0,0,-1,0,1,4.942014270620875393547067,0.00087},
	{0,3,-2,0,0,0,0,0,-1,1,-1,1.803202275595359171944665,0.00022},
	{0,3,-2,0,0,0,0,0,-1,1,1,4.943305639734425049880429,0.00008},
	{0,3,-2,0,0,0,0,0,0,-3,0,4.483480496872298104449328,0.00003},
	{0,3,-2,0,0,0,0,0,0,-2,0,4.483029154727733001095658,0.00047},
	{0,3,-2,0,0,0,0,0,0,-1,0,4.480068901783424983875648,0.00594},
	{0,3,-2,0,0,0,0,0,0,0,-1,4.935342225956350858950827,0.00004},
	{0,3,-2,0,0,0,0,0,0,0,0,3.335699969949118326439930,0.00041},
	{0,3,-2,0,0,0,0,0,0,0,1,1.803323401445447338176109,0.00003},
	{0,3,-2,0,0,0,0,0,0,1,0,2.288539594265587950872032,0.00005},
	{0,3,-2,0,0,0,0,0,0,2,0,1.377796945444737630737109,0.00001},
	{0,3,-2,0,0,0,0,0,1,-2,1,4.944931588465583338631859,0.00001},
	{0,3,-2,0,0,0,0,0,1,-1,-1,4.941304968812865183735994,0.00005},
	{0,3,-2,0,0,0,0,0,1,-1,1,4.944628599307437255561126,0.00026},
	{0,3,-2,0,0,0,0,0,1,0,-1,1.803101395564594033871231,0.00274},
	{0,3,-2,0,0,0,0,0,1,0,0,4.771494904569328454613242,0.00003},
	{0,3,-2,0,0,0,0,0,1,0,1,4.944489671098978078589425,0.00025},
	{0,3,-2,0,0,0,0,0,1,1,-1,1.803090923589081961964098,0.00033},
	{0,3,-2,0,0,0,0,0,1,1,1,4.944509044253676322000501,0.00003},
	{0,3,-2,0,0,0,0,0,1,2,-1,1.803061078458872756868914,0.00003},
	{0,3,-2,0,0,0,0,0,2,-3,0,1.513685663011138160527480,0.00004},
	{0,3,-2,0,0,0,0,0,2,-2,0,4.489789338519481809441913,0.00046},
	{0,3,-2,0,0,0,0,0,2,-1,0,4.471843863150477105250502,0.00365},
	{0,3,-2,0,0,0,0,0,2,0,-2,4.477487036220949789822043,0.00006},
	{0,3,-2,0,0,0,0,0,2,0,-1,4.945234926689580312597627,0.00008},
	{0,3,-2,0,0,0,0,0,2,0,0,4.495071228434793120243285,0.00014},
	{0,3,-2,0,0,0,0,0,3,-2,-1,4.944062763563940698929855,0.00043},
	{0,3,-2,0,0,0,0,0,3,-2,0,1.344764844021492988801469,0.00002},
	{0,3,-2,0,0,0,0,0,3,-1,-1,1.802706253021942206515860,0.00239},
	{0,3,-2,0,0,0,0,0,3,-1,0,1.344671643439436348188565,0.00004},
	{0,3,-2,0,0,0,0,0,3,0,-1,1.802806958519782343230986,0.00020},
	{0,3,-2,0,0,0,0,0,4,-3,0,4.577678010997535018589133,0.00002},
	{0,3,-2,0,0,0,0,0,4,-2,0,4.474601832434478509981091,0.00010},
	{0,3,-2,0,0,0,0,0,4,-1,0,4.491655270022789636641392,0.00008},
	{0,3,-2,0,0,0,0,0,5,-2,-1,1.802703635028064521605984,0.00003},
	{0,3,-2,0,0,0,0,0,5,-1,-1,1.802705554890241534948814,0.00002},
	{0,3,-1,-6,0,0,0,0,0,0,0,1.401883012721034882375193,0.00001},
	{0,3,-1,-4,0,0,0,0,2,-3,0,2.564705310736678178784587,0.00002},
	{0,3,-1,-4,0,0,0,0,2,-2,0,5.267694105306418350664899,0.00003},
	{0,3,-1,-3,0,0,0,0,0,0,0,5.417104935785570063444538,0.00001},
	{0,3,-1,-2,0,0,0,0,-2,0,0,0.008639728863222329718896,0.00003},
	{0,3,-1,-2,0,0,0,0,-2,1,0,3.139742604582679508240517,0.00001},
	{0,3,-1,-2,0,0,0,0,-2,2,0,0.008639728863222329718896,0.00003},
	{0,3,-1,-2,0,0,0,0,-2,3,0,3.139742604582679508240517,0.00001},
	{0,3,-1,-2,0,0,0,0,0,-2,0,3.139742604582679508240517,0.00001},
	{0,3,-1,-2,0,0,0,0,0,0,0,3.139742604582679508240517,0.00001},
	{0,3,-1,0,-2,0,0,0,-2,-2,0,3.143434848615273224936573,0.00001},
	{0,3,-1,0,-2,0,0,0,-2,1,0,3.142020084723606387910877,0.00001},
	{0,3,-1,0,-2,0,0,0,-2,2,0,0.005425879578599971525543,0.00001},
	{0,3,-1,0,-2,0,0,0,0,-2,0,6.283002920272752866992505,0.00003},
	{0,3,-1,0,-2,0,0,0,0,-1,0,0.001842195025480014829861,0.00001},
	{0,3,-1,0,-2,0,0,0,0,0,0,6.283002920272752866992505,0.00003},
	{0,3,-1,0,-2,0,0,0,0,1,0,0.001842195025480014829861,0.00001},
	{0,3,-1,0,-1,0,0,0,-2,0,0,1.579485273943025180898303,0.00002},
	{0,3,-1,0,-1,0,0,0,-2,2,0,1.577908368963848229071800,0.00003},
	{0,3,-1,0,0,0,0,0,-2,-1,0,0.685137549983708904477453,0.00003},
	{0,3,-1,0,0,0,0,0,-2,0,0,0.766564839037953027478522,0.00033},
	{0,3,-1,0,0,0,0,0,-2,1,0,0.735510893788918762581375,0.00022},
	{0,3,-1,0,0,0,0,0,-2,2,0,0.227754471810972441980780,0.00001},
	{0,3,-1,0,0,0,0,0,-1,0,-1,0.143077030623664364084036,0.00002},
	{0,3,-1,0,0,0,0,0,-1,0,0,3.583323269964794111075435,0.00004},
	{0,3,-1,0,0,0,0,0,-1,0,1,3.315356063122021801348183,0.00004},
	{0,3,-1,0,0,0,0,0,0,-1,0,1.532096617691650619619281,0.00020},
	{0,3,-1,0,0,0,0,0,0,0,0,0.457201214864678573412959,0.00180},
	{0,3,-1,0,0,0,0,0,0,1,0,0.413622786903332984032033,0.00017},
	{0,3,-1,0,0,0,0,0,1,-1,-1,3.147710207150958616750813,0.00002},
	{0,3,-1,0,0,0,0,0,1,0,-1,0.231746912474909472212659,0.00005},
	{0,3,-1,0,0,0,0,0,1,0,0,3.642802694609359015487371,0.00002},
	{0,3,-1,0,0,0,0,0,1,0,1,3.187246801630535752991591,0.00001},
	{0,3,-1,0,0,0,0,0,2,-3,0,2.890889021977272488328481,0.00003},
	{0,3,-1,0,0,0,0,0,2,-2,0,0.458948813044700476559967,0.00002},
	{0,3,-1,0,0,0,0,0,2,-1,0,0.619108079189334081782192,0.00028},
	{0,3,-1,0,0,0,0,0,2,0,0,3.499501214643888413746708,0.00009},
	{0,3,-1,0,0,0,0,0,2,1,0,3.557107726468138775288708,0.00001},
	{0,3,-1,0,0,0,0,0,4,-2,-2,4.302467164160210799650486,0.00007},
	{0,3,0,-8,3,0,0,0,0,0,0,3.477203586252109790422082,0.00001},
	{0,3,0,-5,0,0,0,0,0,0,0,2.102548931592662651013370,0.00001},
	{0,3,0,0,-2,0,0,0,-2,0,0,4.695398374649450090601022,0.00002},
	{0,3,0,0,-2,0,0,0,-2,2,0,1.553805721059656974603058,0.00002},
	{0,3,0,0,-1,0,0,0,0,0,0,0.346917524622586070925934,0.00001},
	{0,3,0,0,0,0,0,0,-2,0,0,5.124235894774118449390699,0.00006},
	{0,3,0,0,0,0,0,0,-2,1,0,5.060460516708694456156081,0.00003},
	{0,3,0,0,0,0,0,0,-1,0,1,2.173769709714169273695461,0.00001},
	{0,3,0,0,0,0,0,0,0,-1,0,5.017917243526706094769452,0.00002},
	{0,3,0,0,0,0,0,0,0,0,0,5.092653987426356110290726,0.00010},
	{0,3,0,0,0,0,0,0,0,1,0,5.097110685671323970780122,0.00001},
	{0,3,0,0,0,0,0,0,1,0,-1,5.360135120072447634242963,0.00002},
	{0,3,0,0,0,0,0,0,2,-3,0,3.815962918352098220964308,0.00002},
	{0,3,0,0,0,0,0,0,2,-1,0,3.815962918352098220964308,0.00002},
	{0,3,0,0,0,0,0,0,2,0,0,3.357463876655636614287914,0.00002},
	{0,3,0,0,1,0,0,0,2,0,0,2.289266174833193279170018,0.00006},
	{0,3,1,0,-1,0,0,0,2,-2,0,2.580170673238599832188811,0.00001},
	{0,3,1,0,-1,0,0,0,2,-1,0,2.466297015258080538302465,0.00003},
	{0,3,1,0,-1,0,0,0,2,0,0,2.693956192091893964146720,0.00003},
	{0,3,1,0,0,0,0,0,-2,1,0,5.378672262057880182339886,0.00002},
	{0,3,1,0,0,0,0,0,0,-1,0,5.381319053868528712314401,0.00002},
	{0,3,1,0,0,0,0,0,0,0,0,3.603246901508009969461455,0.00002},
	{0,3,1,0,0,0,0,0,0,1,0,5.381319053868528712314401,0.00002},
	{0,3,1,0,0,0,0,0,2,-2,0,2.202720707747475525906111,0.00005},
	{0,3,1,0,0,0,0,0,2,0,0,2.229445014721087581222037,0.00006},
	{0,3,1,0,0,0,0,0,2,1,0,5.379668670527842699868870,0.00002},
	{0,3,1,0,0,0,0,0,2,2,0,2.237714908315812323280625,0.00002},
	{0,3,1,0,0,0,0,0,4,-2,0,5.344313361337268197814865,0.00001},
	{0,3,1,0,1,0,0,0,2,-2,0,2.005645982593909693036949,0.00001},
	{0,3,1,0,1,0,0,0,2,-1,0,5.227570556599395068531066,0.00003},
	{0,3,1,0,1,0,0,0,2,0,0,5.147238636183702809034912,0.00001},
	{0,3,2,-9,0,0,0,0,2,0,-2,4.249496944960958089154701,0.00001},
	{0,3,2,-3,0,0,0,0,2,-2,0,4.387275330508493276227000,0.00001},
	{0,3,2,-3,0,0,0,0,2,0,0,4.387275330508493276227000,0.00001},
	{0,3,2,0,-1,0,0,0,2,0,0,5.405478250440484799810292,0.00002},
	{0,3,2,0,0,0,0,0,-2,0,0,5.272332317793592793009338,0.00004},
	{0,3,2,0,0,0,0,0,-2,2,0,5.272307708651140067956931,0.00005},
	{0,3,2,0,0,0,0,0,0,0,0,0.729449365296742535669239,0.00003},
	{0,3,2,0,0,0,0,0,2,0,0,3.697193088220959378276120,0.00002},
	{0,3,3,-2,0,0,0,0,2,-3,0,5.378167163772352488138040,0.00001},
	{0,3,3,-2,0,0,0,0,2,-2,0,5.377200600432597177302796,0.00001},
	{0,3,3,-2,0,0,0,0,2,-1,0,5.378167163772352488138040,0.00001},
	{0,3,3,-2,0,0,0,0,2,0,0,5.377200600432597177302796,0.00001},
	{0,3,3,0,0,0,0,0,0,0,0,5.813004602266601317239747,0.00003},
	{0,3,3,0,0,0,0,0,2,-2,0,5.679383241931467374286058,0.00001},
	{0,3,5,-15,0,0,0,0,2,-3,0,2.734995689590363543430840,0.00003},
	{0,3,5,-15,0,0,0,0,2,-1,0,2.734995689590363543430840,0.00003},
	{0,3,5,0,-2,0,0,0,-4,3,0,3.222960601449469386636792,0.00013},
	{0,3,7,-19,0,0,0,0,2,-3,0,5.321061037844649455053059,0.00002},
	{0,3,7,-19,0,0,0,0,2,-2,0,5.431549804273850590163875,0.00025},
	{0,3,7,-19,0,0,0,0,2,-1,0,5.321061037844649455053059,0.00002},
	{0,3,27,-37,0,0,0,0,-1,-1,1,0.754462551471699160998696,0.00001},
	{0,3,30,-44,0,0,0,0,-2,1,0,0.679189118827061788508104,0.00010},
	{0,4,-49,55,0,0,0,0,0,1,0,5.838502815440687498949046,0.00007},
	{0,4,-16,15,0,0,0,0,-2,1,0,4.446234297970113935605241,0.00001},
	{0,4,-16,15,0,0,0,0,-2,3,0,4.446234297970113935605241,0.00001},
	{0,4,-15,14,0,0,0,0,-1,-1,1,4.996523172088685349478965,0.00002},
	{0,4,-15,14,0,0,0,0,-1,0,1,4.996523172088685349478965,0.00030},
	{0,4,-15,14,0,0,0,0,-1,1,1,4.996523172088685349478965,0.00002},
	{0,4,-12,7,0,0,0,0,-2,2,0,4.881424991104966082389183,0.00006},
	{0,4,-11,0,2,0,0,0,-2,0,0,5.631712191407119760810929,0.00002},
	{0,4,-11,5,0,0,0,0,-2,2,0,5.047977572832579973294287,0.00002},
	{0,4,-10,0,0,0,0,0,-2,-1,0,3.789165133016977549118565,0.00001},
	{0,4,-10,0,0,0,0,0,-2,0,0,3.795711513975358109007630,0.00001},
	{0,4,-10,0,0,0,0,0,-2,1,0,1.713725528030916933630579,0.00001},
	{0,4,-10,0,0,0,0,0,-2,2,0,3.795711513975358109007630,0.00001},
	{0,4,-10,0,0,0,0,0,0,-1,0,1.168678924853635336944535,0.00001},
	{0,4,-10,0,0,0,0,0,0,0,0,4.310314513543027636899296,0.00002},
	{0,4,-10,0,0,0,0,0,0,1,0,1.168678924853635336944535,0.00001},
	{0,4,-10,0,1,0,0,0,-2,1,0,5.611234068760544424492309,0.00001},
	{0,4,-10,0,1,0,0,0,-2,3,0,5.611234068760544424492309,0.00001},
	{0,4,-10,0,2,0,0,0,-2,0,0,4.043269189611159220021364,0.00001},
	{0,4,-10,0,2,0,0,0,-2,1,0,0.901676536021365770956493,0.00001},
	{0,4,-10,0,2,0,0,0,-2,2,0,4.043269189611159220021364,0.00001},
	{0,4,-10,0,2,0,0,0,-2,3,0,0.901676536021365770956493,0.00001},
	{0,4,-10,0,2,0,0,0,0,-2,0,0.901185225836929282294818,0.00001},
	{0,4,-10,0,2,0,0,0,0,0,0,4.042777879426722620337387,0.00001},
	{0,4,-10,0,3,0,0,0,-2,0,0,3.872585937142849932257604,0.00003},
	{0,4,-10,0,3,0,0,0,-2,1,0,0.730993283553056594215036,0.00002},
	{0,4,-10,2,0,0,0,0,-2,0,0,4.047492188269284696389150,0.00002},
	{0,4,-10,2,0,0,0,0,-2,2,0,4.047492188269284696389150,0.00002},
	{0,4,-10,3,0,0,0,0,-2,1,0,5.804117385715445998073392,0.00002},
	{0,4,-10,3,0,0,0,0,-2,3,0,5.804117385715445998073392,0.00002},
	{0,4,-9,0,-1,0,0,0,-2,1,0,5.786001217145595454383056,0.00003},
	{0,4,-9,0,0,0,0,0,-2,-3,0,5.654899239585715164935209,0.00002},
	{0,4,-9,0,0,0,0,0,-2,-1,0,5.654899239585715164935209,0.00002},
	{0,4,-9,0,0,0,0,0,-2,1,0,0.350249532697568477512817,0.00003},
	{0,4,-9,0,0,0,0,0,-2,2,0,5.446937325091133708099278,0.00005},
	{0,4,-9,0,0,0,0,0,-2,3,0,0.646437666347537853717142,0.00003},
	{0,4,-9,0,0,0,0,0,0,-2,0,2.493652956887988825229741,0.00001},
	{0,4,-9,0,0,0,0,0,0,-1,0,5.635245610477782385316914,0.00001},
	{0,4,-9,0,0,0,0,0,0,0,0,2.323167450223930785568882,0.00004},
	{0,4,-9,0,0,0,0,0,0,1,0,5.635245610477782385316914,0.00001},
	{0,4,-9,0,0,0,0,0,2,-1,0,5.472633633135321140628093,0.00003},
	{0,4,-9,0,1,0,0,0,-2,-2,0,0.880707103190354612110013,0.00001},
	{0,4,-9,0,1,0,0,0,-2,1,0,2.020203948417719885810584,0.00003},
	{0,4,-9,0,1,0,0,0,-2,2,0,0.893495479685567528527201,0.00002},
	{0,4,-9,0,1,0,0,0,0,-2,0,0.880707103190354612110013,0.00002},
	{0,4,-9,0,1,0,0,0,0,0,0,0.880707103190354612110013,0.00002},
	{0,4,-9,0,2,0,0,0,-2,0,0,5.093590356570050659001936,0.00003},
	{0,4,-9,0,2,0,0,0,-2,1,0,0.561781867242954424668255,0.00001},
	{0,4,-9,0,2,0,0,0,-2,2,0,1.950727975949431813873503,0.00002},
	{0,4,-9,0,2,0,0,0,-2,3,0,1.960922095044480339964821,0.00001},
	{0,4,-9,1,0,0,0,0,-2,1,0,0.896034410148443649646310,0.00002},
	{0,4,-9,1,0,0,0,0,-2,3,0,0.896034410148443649646310,0.00002},
	{0,4,-9,2,0,0,0,0,-2,1,0,5.586354051207514714860736,0.00001},
	{0,4,-9,2,0,0,0,0,-2,3,0,5.586354051207514714860736,0.00001},
	{0,4,-9,3,0,0,0,0,-2,0,0,5.037361956723175104855272,0.00001},
	{0,4,-9,3,0,0,0,0,-2,1,0,5.037361956723175104855272,0.00002},
	{0,4,-9,3,0,0,0,0,-2,2,0,5.037361956723175104855272,0.00001},
	{0,4,-9,3,0,0,0,0,-2,3,0,5.037361956723175104855272,0.00002},
	{0,4,-9,5,0,0,0,0,0,0,0,0.686471854196858521923730,0.00001},
	{0,4,-9,8,0,0,0,0,2,-3,0,4.658706666850624067421904,0.00002},
	{0,4,-9,8,0,0,0,0,2,-1,0,4.658706666850624067421904,0.00002},
	{0,4,-8,0,-1,0,0,0,-2,0,0,4.290491063898875800930455,0.00001},
	{0,4,-8,0,-1,0,0,0,-2,1,0,5.659830841920149957502417,0.00001},
	{0,4,-8,0,-1,0,0,0,-2,3,0,2.518238188330356841504454,0.00001},
	{0,4,-8,0,-1,0,0,0,0,-1,0,4.197066730632273312551206,0.00001},
	{0,4,-8,0,-1,0,0,0,0,1,0,4.197066730632273312551206,0.00001},
	{0,4,-8,0,0,-1,0,0,-2,1,0,5.660372417587043791797896,0.00006},
	{0,4,-8,0,0,0,0,0,-4,0,0,4.045490993748947161634533,0.00002},
	{0,4,-8,0,0,0,0,0,-4,2,0,0.903898340159154489725779,0.00002},
	{0,4,-8,0,0,0,0,0,-2,0,0,0.838147074847547690623628,0.00003},
	{0,4,-8,0,0,0,0,0,-2,1,0,1.876536647441030769556392,0.00004},
	{0,4,-8,0,0,0,0,0,-2,2,0,1.055568499355012956897326,0.00001},
	{0,4,-8,0,0,0,0,0,-2,3,0,2.336508921559100837583856,0.00001},
	{0,4,-8,0,0,0,0,0,-1,0,1,5.693646421644614541435203,0.00001},
	{0,4,-8,0,0,0,0,0,0,-1,2,0.903898340159154489725779,0.00003},
	{0,4,-8,0,0,0,0,0,0,0,0,5.146294587591298430595543,0.00007},
	{0,4,-8,0,0,0,0,0,2,0,0,3.102608455818472332765623,0.00002},
	{0,4,-8,0,1,0,0,0,-2,0,0,0.726102696456043417150283,0.00003},
	{0,4,-8,0,1,0,0,0,-2,1,0,3.146834051866457482304895,0.00010},
	{0,4,-8,0,1,0,0,0,0,-1,0,0.675154964794002054873090,0.00001},
	{0,4,-8,0,1,0,0,0,0,1,0,0.675154964794002054873090,0.00001},
	{0,4,-8,2,0,0,0,0,0,0,0,5.967158190455123190076847,0.00001},
	{0,4,-8,3,0,0,0,0,0,0,0,3.961254248197768390582496,0.00002},
	{0,4,-7,-3,0,0,0,0,-2,0,0,6.201349436547450189038955,0.00001},
	{0,4,-7,-3,0,0,0,0,-2,0,2,1.801221152361420330123565,0.00001},
	{0,4,-7,-3,0,0,0,0,-2,2,0,6.201349436547450189038955,0.00001},
	{0,4,-7,-2,0,0,0,0,-2,0,0,0.195982847173518048844443,0.00001},
	{0,4,-7,0,-1,0,0,0,-2,0,0,4.113949264730397459288724,0.00001},
	{0,4,-7,0,0,0,0,0,-2,-2,0,2.316406742833405640880073,0.00002},
	{0,4,-7,0,0,0,0,0,-2,0,0,1.165684637988913863182461,0.00004},
	{0,4,-7,0,0,0,0,0,-2,1,0,1.006672402228691032277652,0.00010},
	{0,4,-7,0,0,0,0,0,-2,2,0,5.582354978292420888408287,0.00001},
	{0,4,-7,0,0,0,0,0,-1,0,0,4.272767070811948286745974,0.00003},
	{0,4,-7,0,0,0,0,0,-1,0,1,1.101937708790297509864331,0.00003},
	{0,4,-7,0,0,0,0,0,-1,1,-1,4.218990684031199478454255,0.00001},
	{0,4,-7,0,0,0,0,0,-1,3,-1,1.077398030441406806545501,0.00001},
	{0,4,-7,0,0,0,0,0,0,-1,0,4.494657061803295050594897,0.00014},
	{0,4,-7,0,0,0,0,0,0,0,0,4.215446967517951115667074,0.00055},
	{0,4,-7,0,0,0,0,0,0,1,0,4.323404482932985182230823,0.00010},
	{0,4,-7,0,0,0,0,0,1,0,-1,1.124581435972746623619400,0.00006},
	{0,4,-7,0,0,0,0,0,2,-2,0,1.397370289407078303156595,0.00001},
	{0,4,-7,0,0,0,0,0,2,-1,0,1.556737699670082353264888,0.00021},
	{0,4,-7,0,0,0,0,0,2,0,0,1.552603887336733823332224,0.00011},
	{0,4,-7,0,0,0,0,0,2,1,0,1.447638564391318327650993,0.00002},
	{0,4,-7,0,1,0,0,0,0,0,0,0.210384780562199669162737,0.00002},
	{0,4,-7,0,2,0,0,0,0,0,0,1.262980460602290744276388,0.00001},
	{0,4,-7,0,3,0,0,0,0,0,0,1.804340579333509886339471,0.00002},
	{0,4,-7,0,6,0,0,0,-2,0,0,2.750282679442731303964820,0.00001},
	{0,4,-7,0,6,0,0,0,2,0,0,2.750282679442731303964820,0.00001},
	{0,4,-7,5,0,0,0,0,0,0,0,4.157221561940943388435699,0.00001},
	{0,4,-6,-1,0,0,0,0,0,0,0,4.161382950476473219225682,0.00001},
	{0,4,-6,0,-2,0,0,0,-2,0,0,0.904731909409906998043027,0.00002},
	{0,4,-6,0,-2,0,0,0,0,-1,0,0.904731909409906998043027,0.00001},
	{0,4,-6,0,-2,0,0,0,0,1,0,0.904731909409906998043027,0.00001},
	{0,4,-6,0,0,0,0,0,-4,0,0,6.020068893926882047651361,0.00004},
	{0,4,-6,0,0,0,0,0,-4,1,0,6.007981790725120951890403,0.00008},
	{0,4,-6,0,0,0,0,0,-4,2,0,6.104764137472560747710304,0.00004},
	{0,4,-6,0,0,0,0,0,-2,-2,0,6.026212976492677952933263,0.00003},
	{0,4,-6,0,0,0,0,0,-2,-1,0,6.044941232031202815733195,0.00027},
	{0,4,-6,0,0,0,0,0,-2,0,0,6.027688477842313652388384,0.00310},
	{0,4,-6,0,0,0,0,0,-2,0,2,6.040741446252129165372935,0.00005},
	{0,4,-6,0,0,0,0,0,-2,1,0,6.035476486030562526252652,0.00411},
	{0,4,-6,0,0,0,0,0,-2,2,0,5.971263379388738634645506,0.00017},
	{0,4,-6,0,0,0,0,0,-1,-1,1,6.195898424227621603677107,0.00007},
	{0,4,-6,0,0,0,0,0,-1,0,0,2.833573107473479346651857,0.00018},
	{0,4,-6,0,0,0,0,0,-1,0,1,6.181551294177452859912592,0.00003},
	{0,4,-6,0,0,0,0,0,-1,1,-1,2.941547901648108531702519,0.00002},
	{0,4,-6,0,0,0,0,0,-1,1,1,0.419669480096867331120336,0.00001},
	{0,4,-6,0,0,0,0,0,-1,3,-1,6.076169710205435947614205,0.00001},
	{0,4,-6,0,0,0,0,0,0,-3,0,6.032816080651747903118576,0.00002},
	{0,4,-6,0,0,0,0,0,0,-2,0,6.025579421974203597756059,0.00039},
	{0,4,-6,0,0,0,0,0,0,-1,0,5.980495123934237433616090,0.00511},
	{0,4,-6,0,0,0,0,0,0,0,-2,2.882676375182013028819483,0.00001},
	{0,4,-6,0,0,0,0,0,0,0,-1,6.083295540475479157294103,0.00003},
	{0,4,-6,0,0,0,0,0,0,0,0,5.990201074437503159231255,0.02587},
	{0,4,-6,0,0,0,0,0,0,0,2,2.882676375182013028819483,0.00001},
	{0,4,-6,0,0,0,0,0,0,1,0,5.981861542205622939150089,0.00439},
	{0,4,-6,0,0,0,0,0,0,2,0,5.947230021055850635036677,0.00028},
	{0,4,-6,0,0,0,0,0,0,3,0,5.925082316446819596933437,0.00001},
	{0,4,-6,0,0,0,0,0,1,-2,1,2.950058999745458709895729,0.00005},
	{0,4,-6,0,0,0,0,0,1,-1,-1,6.094922923952265314540000,0.00009},
	{0,4,-6,0,0,0,0,0,1,-1,0,5.934072856489692071590980,0.00005},
	{0,4,-6,0,0,0,0,0,1,-1,1,2.953656821465520110336911,0.00031},
	{0,4,-6,0,0,0,0,0,1,0,-1,6.098501372517628915659316,0.00079},
	{0,4,-6,0,0,0,0,0,1,0,0,5.944712732675699662365787,0.00030},
	{0,4,-6,0,0,0,0,0,1,0,1,2.955580697899993225519211,0.00017},
	{0,4,-6,0,0,0,0,0,1,1,-1,6.094922923952265314540000,0.00009},
	{0,4,-6,0,0,0,0,0,1,1,0,5.941905719639717808888690,0.00002},
	{0,4,-6,0,0,0,0,0,2,-2,0,2.999300322997825674065098,0.00008},
	{0,4,-6,0,0,0,0,0,2,-1,0,5.606559378892003842054237,0.00013},
	{0,4,-6,0,0,0,0,0,2,0,-2,6.016580329817995398400399,0.00002},
	{0,4,-6,0,0,0,0,0,2,0,0,5.967733101910729587302740,0.00063},
	{0,4,-6,0,0,0,0,0,2,1,0,6.008007097999274570554462,0.00010},
	{0,4,-6,0,0,0,0,0,4,-2,0,3.062761367264965617351891,0.00002},
	{0,4,-6,0,0,0,0,0,4,-1,0,3.339222742511343877680474,0.00002},
	{0,4,-6,0,0,0,0,0,4,0,0,2.885490718600853821129704,0.00004},
	{0,4,-6,0,1,0,0,0,0,0,0,0.875258010732703151113299,0.00002},
	{0,4,-6,0,1,0,0,0,2,-2,0,4.704424170343213695844042,0.00003},
	{0,4,-6,0,1,0,0,0,2,0,0,1.560547404361335432909641,0.00002},
	{0,4,-6,0,2,0,0,0,-2,0,0,3.139347811105877905646366,0.00005},
	{0,4,-6,0,2,0,0,0,0,-1,0,0.005461309762415457284834,0.00002},
	{0,4,-6,0,2,0,0,0,0,0,0,3.089965988848726308191317,0.00011},
	{0,4,-6,0,2,0,0,0,0,1,0,0.005461309762415457284834,0.00002},
	{0,4,-6,0,2,0,0,0,2,-3,0,6.282619296903164674006348,0.00001},
	{0,4,-6,0,2,0,0,0,2,-2,0,6.282619122370239672648040,0.00001},
	{0,4,-6,0,2,0,0,0,2,0,0,6.282619122370239672648040,0.00001},
	{0,4,-6,0,3,0,0,0,0,0,0,2.957571769510668691083310,0.00002},
	{0,4,-6,1,0,0,0,0,1,0,-1,1.312229986902141432025815,0.00002},
	{0,4,-6,2,0,0,0,0,0,-1,0,3.143302203592121646380519,0.00001},
	{0,4,-6,2,0,0,0,0,0,1,0,3.143302203592121646380519,0.00001},
	{0,4,-6,2,0,0,0,0,2,-3,0,2.245750404191994231695162,0.00003},
	{0,4,-6,2,0,0,0,0,2,-1,0,2.245750404191994231695162,0.00003},
	{0,4,-6,3,0,0,0,0,2,0,-2,5.280754055033241023409118,0.00001},
	{0,4,-5,-3,0,0,0,0,0,-1,0,5.724299988363241276090321,0.00001},
	{0,4,-5,-3,0,0,0,0,0,0,0,2.837453148933588131797023,0.00001},
	{0,4,-5,-3,0,0,0,0,0,1,0,5.724299988363241276090321,0.00001},
	{0,4,-5,0,-1,0,0,0,-2,0,0,1.814537141889511095982357,0.00001},
	{0,4,-5,0,-1,0,0,0,-2,2,0,4.956129795479304434024925,0.00001},
	{0,4,-5,0,-1,0,0,0,2,-1,0,1.713736698138129899149362,0.00004},
	{0,4,-5,0,0,0,0,0,-4,0,0,1.567541113207002068108409,0.00003},
	{0,4,-5,0,0,0,0,0,-4,1,0,1.632812412974310234403674,0.00009},
	{0,4,-5,0,0,0,0,0,-4,2,0,1.622551971367685919034329,0.00006},
	{0,4,-5,0,0,0,0,0,-3,0,1,1.335931034545448925499045,0.00002},
	{0,4,-5,0,0,0,0,0,-3,1,1,1.335924925893066994575520,0.00002},
	{0,4,-5,0,0,0,0,0,-2,-2,0,1.642518014411725735257619,0.00003},
	{0,4,-5,0,0,0,0,0,-2,-1,0,1.643809732591126504530621,0.00020},
	{0,4,-5,0,0,0,0,0,-2,0,0,1.640935698911867524074637,0.00339},
	{0,4,-5,0,0,0,0,0,-2,0,2,1.628261117883884612211887,0.00002},
	{0,4,-5,0,0,0,0,0,-2,1,0,1.628966230901690570576079,0.00410},
	{0,4,-5,0,0,0,0,0,-2,2,0,1.656448708902368727180487,0.00012},
	{0,4,-5,0,0,0,0,0,-2,3,0,4.725452071704166812082804,0.00003},
	{0,4,-5,0,0,0,0,0,-1,-2,1,1.335551076367289757840240,0.00001},
	{0,4,-5,0,0,0,0,0,-1,-1,-1,1.506888303706320986208311,0.00003},
	{0,4,-5,0,0,0,0,0,-1,-1,1,1.334598999260326879223726,0.00004},
	{0,4,-5,0,0,0,0,0,-1,0,-1,1.335658937715062943851763,0.00036},
	{0,4,-5,0,0,0,0,0,-1,0,0,4.710141868972746337362878,0.00006},
	{0,4,-5,0,0,0,0,0,-1,0,1,4.480461600865123905634846,0.00083},
	{0,4,-5,0,0,0,0,0,-1,1,-1,1.372515753661127879681203,0.00016},
	{0,4,-5,0,0,0,0,0,-1,1,1,4.477431534750737185390790,0.00009},
	{0,4,-5,0,0,0,0,0,-1,2,-1,4.474349283291714662880167,0.00002},
	{0,4,-5,0,0,0,0,0,-1,2,0,4.679030502391322343669344,0.00001},
	{0,4,-5,0,0,0,0,0,0,-3,0,4.756472332098637068042990,0.00003},
	{0,4,-5,0,0,0,0,0,0,-2,0,4.745731226816014114433528,0.00034},
	{0,4,-5,0,0,0,0,0,0,-1,0,4.723934856985408714535879,0.00541},
	{0,4,-5,0,0,0,0,0,0,0,-1,4.475913796433202307412103,0.00008},
	{0,4,-5,0,0,0,0,0,0,0,0,2.283587397045979461296383,0.00044},
	{0,4,-5,0,0,0,0,0,0,0,1,1.332889274725073347482862,0.00003},
	{0,4,-5,0,0,0,0,0,0,1,0,4.576915476647338110183227,0.00021},
	{0,4,-5,0,0,0,0,0,0,2,0,4.882767149299750641944229,0.00001},
	{0,4,-5,0,0,0,0,0,1,-2,-1,1.335411275494204907943185,0.00009},
	{0,4,-5,0,0,0,0,0,1,-2,0,4.859317603601654766976026,0.00001},
	{0,4,-5,0,0,0,0,0,1,-2,1,4.393207530103096836171517,0.00001},
	{0,4,-5,0,0,0,0,0,1,-1,-1,1.335411799092980356107319,0.00135},
	{0,4,-5,0,0,0,0,0,1,-1,0,1.560800302569949282727180,0.00008},
	{0,4,-5,0,0,0,0,0,1,-1,1,4.475819723186519993873844,0.00079},
	{0,4,-5,0,0,0,0,0,1,0,-3,4.488224476312144162193363,0.00001},
	{0,4,-5,0,0,0,0,0,1,0,-1,1.335367293197054605613516,0.00987},
	{0,4,-5,0,0,0,0,0,1,0,0,1.536768165967538735117159,0.00029},
	{0,4,-5,0,0,0,0,0,1,0,1,4.465371309619455608697081,0.00118},
	{0,4,-5,0,0,0,0,0,1,1,-1,1.335400628985767834677745,0.00126},
	{0,4,-5,0,0,0,0,0,1,1,0,1.546295569288325344459167,0.00002},
	{0,4,-5,0,0,0,0,0,1,1,1,4.469722589977603632860337,0.00013},
	{0,4,-5,0,0,0,0,0,1,2,-1,1.335412497224681249718969,0.00009},
	{0,4,-5,0,0,0,0,0,2,-4,0,4.808244208233470651236985,0.00001},
	{0,4,-5,0,0,0,0,0,2,-3,0,5.235515993486174579629733,0.00003},
	{0,4,-5,0,0,0,0,0,2,-2,0,1.585769680980681162196788,0.00269},
	{0,4,-5,0,0,0,0,0,2,-1,-2,1.597264244901390517483719,0.00004},
	{0,4,-5,0,0,0,0,0,2,-1,-1,1.334577880776377734051152,0.00003},
	{0,4,-5,0,0,0,0,0,2,-1,0,1.595216450090025661623372,0.02952},
	{0,4,-5,0,0,0,0,0,2,-1,2,4.740177938202018381730340,0.00006},
	{0,4,-5,0,0,0,0,0,2,0,-2,1.612566593651175939072573,0.00025},
	{0,4,-5,0,0,0,0,0,2,0,-1,1.334533374880451983557350,0.00017},
	{0,4,-5,0,0,0,0,0,2,0,0,1.608365586141625724891924,0.00411},
	{0,4,-5,0,0,0,0,0,2,1,0,1.620252325545258331729315,0.00040},
	{0,4,-5,0,0,0,0,0,2,2,0,1.609691338241440616840805,0.00004},
	{0,4,-5,0,0,0,0,0,3,-2,-1,4.477036043142234689184988,0.00001},
	{0,4,-5,0,0,0,0,0,3,-1,-1,4.477049133111624890091207,0.00013},
	{0,4,-5,0,0,0,0,0,3,-1,1,4.476999391227942659554628,0.00003},
	{0,4,-5,0,0,0,0,0,3,0,-1,1.335425761726996451983496,0.00008},
	{0,4,-5,0,0,0,0,0,3,0,0,1.614091138752793197497226,0.00002},
	{0,4,-5,0,0,0,0,0,3,0,1,4.476999740293793550449664,0.00002},
	{0,4,-5,0,0,0,0,0,3,1,-1,1.335366071466578263837732,0.00001},
	{0,4,-5,0,0,0,0,0,4,-3,0,1.624085417648488238739901,0.00006},
	{0,4,-5,0,0,0,0,0,4,-2,0,1.564904269773088829609264,0.00038},
	{0,4,-5,0,0,0,0,0,4,-1,0,1.555347544920868907425415,0.00025},
	{0,4,-5,0,0,0,0,0,4,0,0,1.677830912101476501518960,0.00011},
	{0,4,-5,0,0,0,0,0,4,1,0,1.616991526903757137034745,0.00001},
	{0,4,-5,0,0,1,0,0,2,-1,0,6.278244454600115709297370,0.00005},
	{0,4,-5,0,0,2,0,0,2,-3,0,4.561970222262511143185293,0.00001},
	{0,4,-5,0,0,2,0,0,2,-1,0,1.420377568672718249231934,0.00001},
	{0,4,-5,0,1,0,0,0,-2,0,0,3.302079343502100972074231,0.00010},
	{0,4,-5,0,1,0,0,0,-2,1,0,3.283027852986106776000952,0.00001},
	{0,4,-5,0,1,0,0,0,0,-1,0,3.109097764510312611463405,0.00004},
	{0,4,-5,0,1,0,0,0,0,0,0,2.990802838468640700853030,0.00003},
	{0,4,-5,0,1,0,0,0,0,1,0,3.106851351230070168440989,0.00003},
	{0,4,-5,0,1,0,0,0,2,-3,0,6.279155691002581640702829,0.00003},
	{0,4,-5,0,1,0,0,0,2,-1,0,1.566703704231895200038593,0.00005},
	{0,4,-5,0,1,0,0,0,2,0,0,3.119131662380027592007536,0.00001},
	{0,4,-5,0,1,0,0,0,2,2,0,6.260724315969820708005500,0.00001},
	{0,4,-5,0,2,0,0,0,0,0,0,1.095053083022880624497475,0.00002},
	{0,4,-5,0,2,0,0,0,2,-3,0,4.012409848573722292996990,0.00002},
	{0,4,-5,0,2,0,0,0,2,-2,0,4.194320455054260321503534,0.00001},
	{0,4,-5,0,2,0,0,0,2,-1,0,0.870817194983928843932119,0.00002},
	{0,4,-5,0,2,0,0,0,2,0,0,1.052840375201220535217317,0.00004},
	{0,4,-5,0,3,0,0,0,2,-3,0,1.592706317559807516204273,0.00001},
	{0,4,-5,0,3,0,0,0,2,-2,0,0.664502696770305045781413,0.00002},
	{0,4,-5,0,3,0,0,0,2,-1,0,4.734298971149600632202237,0.00001},
	{0,4,-5,2,0,0,0,0,2,-3,0,3.921015333227188648379524,0.00004},
	{0,4,-5,2,0,0,0,0,2,-1,0,3.921015333227188648379524,0.00004},
	{0,4,-5,3,0,0,0,0,-2,0,0,4.126433255804062838478785,0.00002},
	{0,4,-5,3,0,0,0,0,-2,2,0,4.126433255804062838478785,0.00002},
	{0,4,-4,-8,0,0,0,0,-2,2,0,5.163863769973574768812341,0.00002},
	{0,4,-4,0,-2,0,0,0,-2,0,0,3.585569857777961111366949,0.00001},
	{0,4,-4,0,-1,0,0,0,-2,0,0,3.319901075027140269213533,0.00005},
	{0,4,-4,0,-1,0,0,0,-2,1,0,0.227849766788131347095003,0.00003},
	{0,4,-4,0,-1,0,0,0,-2,2,0,3.237847212771430172040255,0.00001},
	{0,4,-4,0,-1,0,0,0,0,-2,0,3.369442420377924740648723,0.00001},
	{0,4,-4,0,-1,0,0,0,0,0,0,0.899476897565077315732651,0.00001},
	{0,4,-4,0,-1,0,0,0,2,-2,0,0.245730315908962826387807,0.00001},
	{0,4,-4,0,-1,0,0,0,2,-1,0,0.220759366701904380381194,0.00006},
	{0,4,-4,0,-1,0,0,0,2,0,0,3.387322969498756108919224,0.00001},
	{0,4,-4,0,0,0,0,0,-4,0,0,0.001468694565553228369853,0.00005},
	{0,4,-4,0,0,0,0,0,-4,1,0,6.278766308046461297465157,0.00009},
	{0,4,-4,0,0,0,0,0,-4,2,0,6.280630145154666443829683,0.00006},
	{0,4,-4,0,0,0,0,0,-3,0,0,6.243897771184268918887028,0.00001},
	{0,4,-4,0,0,0,0,0,-2,-2,0,6.274855199725667631582837,0.00008},
	{0,4,-4,0,0,0,0,0,-2,-1,0,6.264417432667041651939144,0.00037},
	{0,4,-4,0,0,0,0,0,-2,0,0,6.268386660451926495341013,0.00469},
	{0,4,-4,0,0,0,0,0,-2,0,2,0.012906186219722467697912,0.00003},
	{0,4,-4,0,0,0,0,0,-2,1,0,6.269369804419575586962310,0.00439},
	{0,4,-4,0,0,0,0,0,-2,2,0,6.267294782471878988872049,0.00033},
	{0,4,-4,0,0,0,0,0,-2,3,0,6.264406786158603246406074,0.00005},
	{0,4,-4,0,0,0,0,0,-1,-1,0,3.142275426393173365369194,0.00002},
	{0,4,-4,0,0,0,0,0,-1,0,-1,4.457910201600105537522722,0.00001},
	{0,4,-4,0,0,0,0,0,-1,0,0,0.024514196541811555940527,0.00014},
	{0,4,-4,0,0,0,0,0,-1,0,1,0.270717496678064883930404,0.00005},
	{0,4,-4,0,0,0,0,0,-1,1,0,6.282126241389476284382454,0.00004},
	{0,4,-4,0,0,0,0,0,0,-3,0,0.013810092239330331101432,0.00003},
	{0,4,-4,0,0,0,0,0,0,-2,0,0.010028661881959418170074,0.00057},
	{0,4,-4,0,0,0,0,0,0,-1,0,0.004458094508369116019952,0.00882},
	{0,4,-4,0,0,0,0,0,0,-1,2,3.142466190880416121444796,0.00002},
	{0,4,-4,0,0,0,0,0,0,0,-2,3.120514312213457763789393,0.00010},
	{0,4,-4,0,0,0,0,0,0,0,0,3.142828521233130167900072,0.04626},
	{0,4,-4,0,0,0,0,0,0,0,2,6.260952779568907722307358,0.00007},
	{0,4,-4,0,0,0,0,0,0,1,-2,3.143174270957950433569295,0.00017},
	{0,4,-4,0,0,0,0,0,0,1,0,3.142928528599269633048152,0.00746},
	{0,4,-4,0,0,0,0,0,0,1,2,0.001634849910343088522785,0.00003},
	{0,4,-4,0,0,0,0,0,0,2,0,3.141765964784516196317554,0.00056},
	{0,4,-4,0,0,0,0,0,0,3,0,3.138272688286649181321764,0.00004},
	{0,4,-4,0,0,0,0,0,1,-2,0,0.016544499578429849862005,0.00010},
	{0,4,-4,0,0,0,0,0,1,-1,-1,3.315284853688540422922415,0.00004},
	{0,4,-4,0,0,0,0,0,1,-1,0,0.011816053568926810149464,0.00012},
	{0,4,-4,0,0,0,0,0,1,-1,1,0.046571318562665497964304,0.00002},
	{0,4,-4,0,0,0,0,0,1,0,-1,3.331992716084957173450221,0.00037},
	{0,4,-4,0,0,0,0,0,1,0,0,0.001785122758939800208591,0.00111},
	{0,4,-4,0,0,0,0,0,1,0,1,0.191003946416353848070102,0.00002},
	{0,4,-4,0,0,0,0,0,1,1,-1,3.315284853688540422922415,0.00004},
	{0,4,-4,0,0,0,0,0,1,1,0,0.002428102055374511090979,0.00006},
	{0,4,-4,0,0,0,0,0,2,-3,0,3.152196750526135460290789,0.00014},
	{0,4,-4,0,0,0,0,0,2,-2,-2,3.136420893950283339535190,0.00001},
	{0,4,-4,0,0,0,0,0,2,-2,0,3.139556028885640781567190,0.00190},
	{0,4,-4,0,0,0,0,0,2,-2,2,0.000479267412597642863872,0.00001},
	{0,4,-4,0,0,0,0,0,2,-1,-2,3.136221402816780745581582,0.00017},
	{0,4,-4,0,0,0,0,0,2,-1,0,3.141763521323563512765986,0.08235},
	{0,4,-4,0,0,0,0,0,2,-1,2,0.000533721685259866017101,0.00016},
	{0,4,-4,0,0,0,0,0,2,0,-2,3.141886217969978467579040,0.00392},
	{0,4,-4,0,0,0,0,0,2,0,0,0.001672549022186166052875,0.00909},
	{0,4,-4,0,0,0,0,0,2,0,2,3.142376480956863726845540,0.00001},
	{0,4,-4,0,0,0,0,0,2,1,0,0.001430297322009353071584,0.00080},
	{0,4,-4,0,0,0,0,0,2,2,0,6.281300526120357829995555,0.00009},
	{0,4,-4,0,0,0,0,0,3,-3,-1,3.089177798158525334315527,0.00001},
	{0,4,-4,0,0,0,0,0,3,-3,0,3.141990763192172853024431,0.00005},
	{0,4,-4,0,0,0,0,0,3,-2,0,3.143473245858817044506850,0.00039},
	{0,4,-4,0,0,0,0,0,3,-1,-1,6.230770451748318450313491,0.00001},
	{0,4,-4,0,0,0,0,0,3,0,-2,3.142718740023179524456509,0.00004},
	{0,4,-4,0,0,0,0,0,3,0,0,0.001201135591222497701544,0.00004},
	{0,4,-4,0,0,0,0,0,3,1,0,0.001126610032162339743167,0.00001},
	{0,4,-4,0,0,0,0,0,4,-3,0,3.107377567999547007815409,0.00001},
	{0,4,-4,0,0,0,0,0,4,-2,0,3.142368103376454335773360,0.00111},
	{0,4,-4,0,0,0,0,0,4,-1,-2,3.146681335556908098993745,0.00004},
	{0,4,-4,0,0,0,0,0,4,-1,0,3.143232041356191608372228,0.00053},
	{0,4,-4,0,0,0,0,0,4,0,-2,0.001427155729355763114780,0.00002},
	{0,4,-4,0,0,0,0,0,4,0,0,6.282153468525807582523157,0.00004},
	{0,4,-4,0,0,0,0,0,4,1,0,0.004007275962578980312012,0.00005},
	{0,4,-4,0,0,0,0,0,6,-3,0,3.141896515412565538127865,0.00002},
	{0,4,-4,0,0,0,0,0,6,-2,0,3.142008914616393866481303,0.00002},
	{0,4,-4,0,0,0,0,0,6,-1,0,0.000673871624195010606416,0.00002},
	{0,4,-4,0,1,0,0,0,-2,0,0,6.030064394553052764536005,0.00005},
	{0,4,-4,0,1,0,0,0,-2,1,0,2.989123482662371600326878,0.00003},
	{0,4,-4,0,1,0,0,0,0,0,0,2.989123482662371600326878,0.00002},
	{0,4,-4,0,1,0,0,0,2,-3,0,2.946151207550243622534936,0.00002},
	{0,4,-4,0,1,0,0,0,2,-1,0,2.451272697458137361792296,0.00006},
	{0,4,-3,-4,0,0,0,0,0,0,0,0.531394288702331518692290,0.00001},
	{0,4,-3,-3,0,0,0,0,2,-3,0,5.316161025969675435476347,0.00001},
	{0,4,-3,-3,0,0,0,0,2,-2,0,5.297528239941233785259556,0.00004},
	{0,4,-3,-3,0,0,0,0,2,-1,0,5.316161025969675435476347,0.00001},
	{0,4,-3,-3,0,0,0,0,2,0,0,5.298181342147329608849304,0.00001},
	{0,4,-3,-1,0,0,0,0,0,0,0,3.149177156387259923775446,0.00002},
	{0,4,-3,0,-2,0,0,0,-2,0,0,1.367364588906792022271475,0.00001},
	{0,4,-3,0,-2,0,0,0,-2,1,0,2.090734099754212316213398,0.00001},
	{0,4,-3,0,-2,0,0,0,-2,2,0,1.538107357102594052733480,0.00003},
	{0,4,-3,0,-1,0,0,0,-2,0,0,3.119294676132164045867512,0.00001},
	{0,4,-3,0,-1,0,0,0,-2,2,0,3.119294676132164045867512,0.00001},
	{0,4,-3,0,-1,0,0,0,0,-2,0,3.171376522742151315981118,0.00001},
	{0,4,-3,0,-1,0,0,0,0,0,0,3.160694758654095437577780,0.00005},
	{0,4,-3,0,-1,0,0,0,0,2,0,3.161470382973682102800694,0.00002},
	{0,4,-3,0,-1,0,0,0,2,-3,0,0.069188516740484415357137,0.00002},
	{0,4,-3,0,-1,0,0,0,2,-1,0,3.210781170330277767277494,0.00002},
	{0,4,-3,0,-1,0,0,0,2,0,0,0.069201955775724771635637,0.00007},
	{0,4,-3,0,0,-1,0,0,-2,0,0,3.145330974314640037903246,0.00001},
	{0,4,-3,0,0,-1,0,0,-2,2,0,0.003738320724846654324186,0.00001},
	{0,4,-3,0,0,0,0,0,-4,0,0,1.344766414817819777383079,0.00002},
	{0,4,-3,0,0,0,0,0,-4,1,0,4.402693220054760381287906,0.00001},
	{0,4,-3,0,0,0,0,0,-3,0,1,1.802906616820071361573241,0.00002},
	{0,4,-3,0,0,0,0,0,-3,1,1,1.803164576483516023941434,0.00001},
	{0,4,-3,0,0,0,0,0,-2,-1,0,4.422985116070147881828234,0.00006},
	{0,4,-3,0,0,0,0,0,-2,0,0,4.387636962729506429070625,0.00042},
	{0,4,-3,0,0,0,0,0,-2,1,0,4.420278284933229606679106,0.00044},
	{0,4,-3,0,0,0,0,0,-2,2,0,4.780716875271015631199134,0.00004},
	{0,4,-3,0,0,0,0,0,-2,3,0,1.517280168605620538357925,0.00001},
	{0,4,-3,0,0,0,0,0,-1,-1,-1,1.796909141911443130723569,0.00003},
	{0,4,-3,0,0,0,0,0,-1,-1,1,4.950570223680001546995300,0.00007},
	{0,4,-3,0,0,0,0,0,-1,0,-1,1.796073478265588274638276,0.00033},
	{0,4,-3,0,0,0,0,0,-1,0,1,4.944709931650580259088201,0.00059},
	{0,4,-3,0,0,0,0,0,-1,1,-1,1.802918834124835223420291,0.00017},
	{0,4,-3,0,0,0,0,0,-1,1,1,4.944701903136020426643427,0.00005},
	{0,4,-3,0,0,0,0,0,0,-2,0,4.488816142928571117920455,0.00006},
	{0,4,-3,0,0,0,0,0,0,-1,0,4.441893140521628424721712,0.00060},
	{0,4,-3,0,0,0,0,0,0,0,-1,4.944606957224713106313629,0.00003},
	{0,4,-3,0,0,0,0,0,0,0,0,1.779892879836199259813156,0.00048},
	{0,4,-3,0,0,0,0,0,0,0,1,1.803210827708694008464363,0.00002},
	{0,4,-3,0,0,0,0,0,0,1,0,1.415263055832673977363356,0.00010},
	{0,4,-3,0,0,0,0,0,1,-1,-1,1.803282909806801281860089,0.00029},
	{0,4,-3,0,0,0,0,0,1,-1,1,4.945002274300289712982703,0.00017},
	{0,4,-3,0,0,0,0,0,1,0,-1,1.803664438781287238100504,0.00196},
	{0,4,-3,0,0,0,0,0,1,0,1,4.944996863779608453626224,0.00013},
	{0,4,-3,0,0,0,0,0,1,1,-1,1.803314674799187722342708,0.00024},
	{0,4,-3,0,0,0,0,0,1,1,1,4.945042940471860326567821,0.00002},
	{0,4,-3,0,0,0,0,0,1,2,-1,1.803260395059450571508819,0.00001},
	{0,4,-3,0,0,0,0,0,2,-3,0,1.413358378019972549921590,0.00003},
	{0,4,-3,0,0,0,0,0,2,-2,0,4.517717399078194695505317,0.00006},
	{0,4,-3,0,0,0,0,0,2,-1,0,4.527282501510824452850557,0.00081},
	{0,4,-3,0,0,0,0,0,2,0,-2,4.535073127692951899803120,0.00003},
	{0,4,-3,0,0,0,0,0,2,0,-1,4.945326556475309942584317,0.00005},
	{0,4,-3,0,0,0,0,0,2,0,0,1.408876023435000623962310,0.00025},
	{0,4,-3,0,0,0,0,0,2,1,0,1.336699677548027098694661,0.00006},
	{0,4,-3,0,0,0,0,0,3,-2,-1,1.803242243635229780096552,0.00001},
	{0,4,-3,0,0,0,0,0,3,-1,-1,1.803360227892664591209382,0.00013},
	{0,4,-3,0,0,0,0,0,3,0,-1,1.803417998290905543967710,0.00003},
	{0,4,-3,0,0,0,0,0,4,-1,0,1.490136459012754155395442,0.00001},
	{0,4,-3,0,0,0,0,0,4,0,0,1.665297877275830451537786,0.00001},
	{0,4,-3,0,1,0,0,0,0,0,0,0.279342390242645233211505,0.00001},
	{0,4,-2,-4,0,0,0,0,0,0,0,4.701624138624239002126615,0.00001},
	{0,4,-2,-4,0,0,0,0,2,-3,0,5.271181273151903212692559,0.00002},
	{0,4,-2,-4,0,0,0,0,2,-1,0,5.271181273151903212692559,0.00002},
	{0,4,-2,-2,0,0,0,0,-2,0,0,0.011429114073759667410957,0.00001},
	{0,4,-2,-2,0,0,0,0,-2,2,0,0.011429114073759667410957,0.00001},
	{0,4,-2,-2,0,0,0,0,0,-2,0,3.139719915302403130397124,0.00001},
	{0,4,-2,-2,0,0,0,0,0,0,0,3.139719915302403130397124,0.00001},
	{0,4,-2,0,-3,0,0,0,0,0,0,3.310765149057576017810334,0.00001},
	{0,4,-2,0,-2,0,0,0,-2,-2,0,0.001819680278129287998717,0.00001},
	{0,4,-2,0,-2,0,0,0,-2,2,0,0.005426577710300768860041,0.00001},
	{0,4,-2,0,-2,0,0,0,0,0,0,3.142743000099782690881511,0.00002},
	{0,4,-2,0,-1,0,0,0,-2,0,0,1.573681006982592833765011,0.00003},
	{0,4,-2,0,-1,0,0,0,-2,2,0,1.573681006982592833765011,0.00003},
	{0,4,-2,0,-1,0,0,0,0,0,0,6.069708152248703747488889,0.00001},
	{0,4,-2,0,-1,0,0,0,0,2,0,6.069708152248703747488889,0.00001},
	{0,4,-2,0,0,0,0,0,-2,-1,0,0.536933091083535485310563,0.00003},
	{0,4,-2,0,0,0,0,0,-2,0,0,0.556444999456206179644369,0.00029},
	{0,4,-2,0,0,0,0,0,-2,1,0,0.518110413232477529099640,0.00019},
	{0,4,-2,0,0,0,0,0,-2,2,0,1.009282193059198196039006,0.00001},
	{0,4,-2,0,0,0,0,0,-1,0,0,3.622944338380167828006506,0.00003},
	{0,4,-2,0,0,0,0,0,-1,0,1,3.307614655224801136768065,0.00002},
	{0,4,-2,0,0,0,0,0,0,-2,0,5.949945404306104634883923,0.00002},
	{0,4,-2,0,0,0,0,0,0,-1,0,0.578890806301479265982834,0.00019},
	{0,4,-2,0,0,0,0,0,0,0,0,0.452427390294623699151799,0.00147},
	{0,4,-2,0,0,0,0,0,0,1,0,0.454123501261711748355765,0.00015},
	{0,4,-2,0,0,0,0,0,1,0,-1,0.195644951430331975883448,0.00003},
	{0,4,-2,0,0,0,0,0,1,0,0,3.596901757012384681644335,0.00002},
	{0,4,-2,0,0,0,0,0,2,-2,0,0.457710676473335686953448,0.00002},
	{0,4,-2,0,0,0,0,0,2,-1,0,0.456000428339306485003846,0.00024},
	{0,4,-2,0,0,0,0,0,2,0,0,3.603326488521901183048612,0.00010},
	{0,4,-1,-7,0,0,0,0,2,-3,0,0.051014054173617061349599,0.00001},
	{0,4,-1,-7,0,0,0,0,2,-2,0,6.181526859567925136218491,0.00003},
	{0,4,-1,-7,0,0,0,0,2,-1,0,0.051014054173617061349599,0.00001},
	{0,4,-1,-5,0,0,0,0,0,0,0,2.125800382420656386983637,0.00001},
	{0,4,-1,0,-3,0,0,0,-2,0,0,6.225433234895720424617593,0.00001},
	{0,4,-1,0,-3,0,0,0,-2,2,0,3.083840581305926420441210,0.00001},
	{0,4,-1,0,0,0,0,0,-2,0,0,5.032384277696487551168048,0.00005},
	{0,4,-1,0,0,0,0,0,-2,1,0,5.048749008361962609114926,0.00002},
	{0,4,-1,0,0,0,0,0,0,0,0,5.040653822225362290510020,0.00008},
	{0,4,-1,0,0,0,0,0,1,0,-1,5.372094814238813853535248,0.00002},
	{0,4,-1,0,0,0,0,0,2,-2,0,0.652054310413380688871143,0.00003},
	{0,4,-1,0,0,0,0,0,2,-1,0,5.119527869116863527665373,0.00002},
	{0,4,-1,0,0,0,0,0,2,0,0,1.269004115449698710804682,0.00002},
	{0,4,-1,0,1,0,0,0,2,0,0,2.314636455373107803978883,0.00005},
	{0,4,0,0,-2,0,0,0,2,-2,0,2.682401937910766420714026,0.00001},
	{0,4,0,0,-2,0,0,0,2,0,0,2.682401937910766420714026,0.00001},
	{0,4,0,0,-1,0,0,0,2,-2,0,2.485008864701636621674652,0.00002},
	{0,4,0,0,-1,0,0,0,2,-1,0,2.466274325977804160459073,0.00002},
	{0,4,0,0,-1,0,0,0,2,0,0,2.611483276282779986132709,0.00004},
	{0,4,0,0,0,0,0,0,0,0,0,4.695522467559266388548167,0.00004},
	{0,4,0,0,0,0,0,0,0,1,0,2.236422666537635883798885,0.00001},
	{0,4,0,0,0,0,0,0,0,2,0,5.378281308305433050520605,0.00004},
	{0,4,0,0,0,0,0,0,0,3,0,2.236422666537635883798885,0.00001},
	{0,4,0,0,0,0,0,0,2,-3,0,5.378058429759952296933534,0.00001},
	{0,4,0,0,0,0,0,0,2,-2,0,2.233821078754612887706799,0.00005},
	{0,4,0,0,0,0,0,0,2,0,0,2.263058310785246440843821,0.00003},
	{0,4,0,0,0,0,0,0,2,1,0,5.378015320127428999796848,0.00002},
	{0,4,0,0,1,0,0,0,2,-2,0,5.221357708061071356553384,0.00001},
	{0,4,0,0,1,0,0,0,2,-1,0,5.227548041852045024313611,0.00003},
	{0,4,0,0,1,0,0,0,2,0,0,5.177419044142113513373715,0.00003},
	{0,4,1,0,-2,0,0,0,2,-2,0,3.927357510663085360391733,0.00001},
	{0,4,1,0,-2,0,0,0,2,0,0,0.785764857073292244393770,0.00001},
	{0,4,1,0,-1,0,0,0,2,-3,0,2.255758471188780145411101,0.00002},
	{0,4,1,0,-1,0,0,0,2,-1,0,2.255758471188780145411101,0.00002},
	{0,4,1,0,-1,0,0,0,2,0,0,2.244876343302595333994987,0.00004},
	{0,4,1,0,-1,0,0,0,2,2,0,2.260722362114377048669667,0.00001},
	{0,4,1,0,0,0,0,0,-2,0,0,5.271989360595576989965139,0.00004},
	{0,4,1,0,0,0,0,0,-2,2,0,5.272058126568105684839338,0.00005},
	{0,4,1,0,0,0,0,0,0,0,0,1.032002889261660394382147,0.00002},
	{0,4,1,0,0,0,0,0,2,-3,0,3.794157647342307537741135,0.00001},
	{0,4,1,0,0,0,0,0,2,-2,0,3.817163879410395921354393,0.00002},
	{0,4,1,0,0,0,0,0,2,-1,0,3.794157647342307537741135,0.00001},
	{0,4,1,0,0,0,0,0,2,0,0,3.817163879410395921354393,0.00002},
	{0,4,2,-2,0,0,0,0,2,-2,0,5.377152603878167624884554,0.00001},
	{0,4,2,-2,0,0,0,0,2,0,0,5.377152603878167624884554,0.00001},
	{0,4,2,0,-3,0,0,0,2,-2,0,5.552028835341467960518003,0.00001},
	{0,4,2,0,-3,0,0,0,2,0,0,5.552028835341467960518003,0.00001},
	{0,4,2,0,-2,0,0,0,0,0,0,5.381836893057595716527430,0.00001},
	{0,4,2,0,-2,0,0,0,0,2,0,2.240244239467802156440257,0.00001},
	{0,4,2,0,0,0,0,0,0,0,0,5.818422278797717339671181,0.00002},
	{0,4,2,0,0,0,0,0,2,-1,0,2.676829625207923779584007,0.00003},
	{0,4,5,0,0,0,0,0,-2,1,0,2.966362294821263123623112,0.00002},
	{0,4,7,0,-3,0,0,0,0,-1,0,2.847235544858091049746918,0.00002},
	{0,4,22,-32,0,0,0,0,-2,1,0,3.763731671558140590150288,0.00001},
	{0,5,-14,0,0,0,0,0,-2,0,0,5.054856962612241488841391,0.00001},
	{0,5,-14,0,0,0,0,0,-2,2,0,5.054856962612241488841391,0.00001},
	{0,5,-14,15,0,0,0,0,2,0,-2,5.896549848368141333310177,0.00002},
	{0,5,-13,6,0,0,0,0,-2,1,0,5.062766096650578973026313,0.00004},
	{0,5,-13,6,0,0,0,0,-2,2,0,1.921446761621648180451416,0.00001},
	{0,5,-13,6,0,0,0,0,-2,3,0,5.062766096650578973026313,0.00004},
	{0,5,-12,0,2,0,0,0,-2,0,0,5.632785568897096695195614,0.00002},
	{0,5,-12,4,0,0,0,0,-2,1,0,5.994446762375904569353224,0.00001},
	{0,5,-12,4,0,0,0,0,-2,3,0,5.994446762375904569353224,0.00001},
	{0,5,-11,0,0,0,0,0,-2,-1,0,3.817983136961282220056546,0.00002},
	{0,5,-11,0,0,0,0,0,-2,0,0,3.796085887099910571862438,0.00001},
	{0,5,-11,0,0,0,0,0,-2,1,0,3.908591032413941679379832,0.00002},
	{0,5,-11,0,0,0,0,0,-2,2,0,3.796085887099910571862438,0.00001},
	{0,5,-11,0,0,0,0,0,0,-1,0,1.168829372235157482151635,0.00002},
	{0,5,-11,0,0,0,0,0,0,0,0,4.655668572221677514733074,0.00003},
	{0,5,-11,0,0,0,0,0,0,1,0,1.168829372235157482151635,0.00002},
	{0,5,-11,0,1,0,0,0,-2,1,0,2.476723961275344887411620,0.00003},
	{0,5,-11,0,2,0,0,0,-2,0,0,4.043088548033577644957859,0.00001},
	{0,5,-11,0,2,0,0,0,-2,1,0,0.901496068976709419295901,0.00004},
	{0,5,-11,0,2,0,0,0,-2,2,0,4.043088548033577644957859,0.00001},
	{0,5,-11,0,3,0,0,0,-2,0,0,3.872475283268273393844083,0.00002},
	{0,5,-11,2,0,0,0,0,-2,0,0,4.045137739108343843952298,0.00004},
	{0,5,-11,2,0,0,0,0,-2,1,0,3.223562565508482524734291,0.00001},
	{0,5,-11,2,0,0,0,0,-2,2,0,4.413730856777298150461775,0.00003},
	{0,5,-11,2,0,0,0,0,-2,3,0,3.223562565508482524734291,0.00001},
	{0,5,-10,0,-1,0,0,0,-2,1,0,2.734929716144637978914034,0.00001},
	{0,5,-10,0,-1,0,0,0,-2,3,0,5.876522369734431094911997,0.00001},
	{0,5,-10,0,0,0,0,0,-2,0,0,5.375617935866889851581618,0.00003},
	{0,5,-10,0,0,0,0,0,-2,2,0,5.266671516897675431323478,0.00005},
	{0,5,-10,0,0,0,0,0,-1,0,0,2.513788995001172921206489,0.00002},
	{0,5,-10,0,0,0,0,0,0,0,0,2.114966600154751574791590,0.00003},
	{0,5,-10,0,0,0,0,0,2,-2,0,4.150242862926844189530584,0.00001},
	{0,5,-10,0,0,0,0,0,2,-1,0,5.145851972092993165119879,0.00003},
	{0,5,-10,0,0,0,0,0,2,0,0,4.788280434117457851073141,0.00003},
	{0,5,-10,0,0,1,0,0,-2,1,0,4.055372349842038204315031,0.00002},
	{0,5,-10,0,0,3,0,0,-2,1,0,0.756734097493169777237654,0.00003},
	{0,5,-10,0,0,3,0,0,-2,3,0,0.756734097493169777237654,0.00003},
	{0,5,-10,0,1,0,0,0,-2,0,0,0.893314838107986064485999,0.00001},
	{0,5,-10,0,1,0,0,0,-2,1,0,5.633194848606688509562446,0.00005},
	{0,5,-10,0,1,0,0,0,-2,2,0,1.543845650617300835349965,0.00002},
	{0,5,-10,0,1,0,0,0,-2,3,0,4.642388885542027665565001,0.00001},
	{0,5,-10,0,1,0,0,0,0,-1,0,0.885438167193735692350742,0.00002},
	{0,5,-10,0,1,0,0,0,0,0,0,0.880596449315778184718795,0.00003},
	{0,5,-10,0,1,0,0,0,0,1,0,0.885438167193735692350742,0.00002},
	{0,5,-10,0,2,0,0,0,-2,1,0,3.478107492271717227083627,0.00002},
	{0,5,-10,0,2,0,0,0,-2,2,0,5.580897279301155755604213,0.00002},
	{0,5,-10,0,3,0,0,0,-2,1,0,5.013014613657854390282864,0.00001},
	{0,5,-10,0,3,0,0,0,-2,3,0,1.871421960068061496329506,0.00001},
	{0,5,-10,3,0,0,0,0,-2,0,0,5.037251477381524011889269,0.00001},
	{0,5,-10,3,0,0,0,0,-2,2,0,5.037251477381524011889269,0.00001},
	{0,5,-10,3,0,0,0,0,0,-1,0,1.895658823791731117935910,0.00002},
	{0,5,-10,3,0,0,0,0,0,1,0,1.895658823791731117935910,0.00002},
	{0,5,-10,7,0,0,0,0,2,-3,0,1.001197478898109949341233,0.00001},
	{0,5,-10,7,0,0,0,0,2,-1,0,1.001197478898109949341233,0.00001},
	{0,5,-9,-2,0,0,0,0,-2,1,0,4.923011474791011643503680,0.00001},
	{0,5,-9,-2,0,0,0,0,-2,3,0,4.923011474791011643503680,0.00001},
	{0,5,-9,0,-1,0,0,0,-2,0,0,4.225816143136974289973296,0.00003},
	{0,5,-9,0,-1,0,0,0,-2,1,0,4.290879574190370249198168,0.00001},
	{0,5,-9,0,-1,0,0,0,-2,2,0,4.100389627238728351699137,0.00001},
	{0,5,-9,0,-1,0,0,0,-2,3,0,1.149286920600576689110994,0.00001},
	{0,5,-9,0,0,0,0,0,-4,0,0,4.045465686474793542970474,0.00002},
	{0,5,-9,0,0,0,0,0,-4,2,0,0.947043926466005547837312,0.00001},
	{0,5,-9,0,0,0,0,0,-2,-1,0,0.902186521228798388172265,0.00001},
	{0,5,-9,0,0,0,0,0,-2,0,0,0.654248712881913108141418,0.00005},
	{0,5,-9,0,0,0,0,0,-2,0,2,4.045465686474793542970474,0.00001},
	{0,5,-9,0,0,0,0,0,-2,1,0,0.989438497595723331912154,0.00006},
	{0,5,-9,0,0,0,0,0,-2,2,0,0.782796750147350728354922,0.00002},
	{0,5,-9,0,0,0,0,0,-2,2,2,4.045465686474793542970474,0.00001},
	{0,5,-9,0,0,0,0,0,-2,3,0,1.452364043341093147176935,0.00003},
	{0,5,-9,0,0,0,0,0,-1,0,0,5.400288164843829008532339,0.00013},
	{0,5,-9,0,0,0,0,0,-1,1,0,5.605538710345437714011041,0.00015},
	{0,5,-9,0,0,0,0,0,-1,2,0,4.053231354448617373975594,0.00004},
	{0,5,-9,0,0,0,0,0,0,0,0,3.447446071571456993609672,0.00017},
	{0,5,-9,0,0,0,0,0,0,1,-2,0.903873032885000649017115,0.00002},
	{0,5,-9,0,0,0,0,0,0,1,0,3.008069729824471405521535,0.00007},
	{0,5,-9,0,0,0,0,0,1,0,0,2.244668474588682904879988,0.00002},
	{0,5,-9,0,0,0,0,0,2,-1,0,3.032898609230417097393229,0.00022},
	{0,5,-9,0,0,0,0,0,2,0,0,3.029403063804522844293388,0.00020},
	{0,5,-9,0,0,0,0,0,2,1,0,3.035059850443161622024490,0.00002},
	{0,5,-9,0,1,0,0,0,-2,0,0,0.724600491568851867718593,0.00003},
	{0,5,-9,0,1,0,0,0,-2,1,0,0.731211624242481095237167,0.00002},
	{0,5,-9,0,1,0,0,0,-2,2,0,0.762184062615447355248932,0.00001},
	{0,5,-9,0,1,0,0,0,0,0,0,4.077790755018055435243696,0.00001},
	{0,5,-9,2,0,0,0,0,0,0,0,4.449842766198612409311863,0.00001},
	{0,5,-9,3,0,0,0,0,1,-2,1,3.287244044860149205788957,0.00007},
	{0,5,-9,5,0,0,0,0,2,-3,0,3.474216106171470919150579,0.00002},
	{0,5,-9,5,0,0,0,0,2,-1,0,3.474216106171470919150579,0.00002},
	{0,5,-8,-3,0,0,0,0,-2,0,0,6.201301265460094747083986,0.00001},
	{0,5,-8,-3,0,0,0,0,-2,2,0,6.201301265460094747083986,0.00001},
	{0,5,-8,-2,0,0,0,0,-2,1,0,0.192086748684291125366386,0.00002},
	{0,5,-8,-2,0,0,0,0,-2,3,0,0.192086748684291125366386,0.00002},
	{0,5,-8,0,-2,0,0,0,0,-1,0,0.314879039142501759851456,0.00003},
	{0,5,-8,0,-2,0,0,0,0,1,0,0.314879039142501759851456,0.00003},
	{0,5,-8,0,-1,0,0,0,-2,0,0,4.113263175801438187306758,0.00001},
	{0,5,-8,0,-1,0,0,0,-2,1,0,0.971670522211645515398004,0.00003},
	{0,5,-8,0,-1,0,0,0,0,-1,0,2.565853562851565516922392,0.00002},
	{0,5,-8,0,-1,0,0,0,0,1,0,2.565853562851565516922392,0.00002},
	{0,5,-8,0,0,0,0,0,-4,0,0,1.405793597443053544182590,0.00003},
	{0,5,-8,0,0,0,0,0,-4,1,0,1.259522265222389192373953,0.00006},
	{0,5,-8,0,0,0,0,0,-4,2,0,1.501839415246151832050714,0.00005},
	{0,5,-8,0,0,0,0,0,-2,-2,0,1.704830981096903563809519,0.00003},
	{0,5,-8,0,0,0,0,0,-2,-1,0,1.243990056610115857438359,0.00022},
	{0,5,-8,0,0,0,0,0,-2,0,0,1.258448364133637031869739,0.00231},
	{0,5,-8,0,0,0,0,0,-2,0,2,1.260846271992951850293707,0.00005},
	{0,5,-8,0,0,0,0,0,-2,1,0,1.263557466453000044381838,0.00337},
	{0,5,-8,0,0,0,0,0,-2,2,0,1.040597588630181258295693,0.00011},
	{0,5,-8,0,0,0,0,0,-1,0,0,4.392672935753211049814126,0.00007},
	{0,5,-8,0,0,0,0,0,0,-3,0,1.167780778420559162356085,0.00001},
	{0,5,-8,0,0,0,0,0,0,-2,0,1.179727731683385405503373,0.00028},
	{0,5,-8,0,0,0,0,0,0,-1,0,1.212635216598037857238523,0.00418},
	{0,5,-8,0,0,0,0,0,0,0,-2,4.404792676611984703072267,0.00001},
	{0,5,-8,0,0,0,0,0,0,0,-1,4.254489808352138524583097,0.00006},
	{0,5,-8,0,0,0,0,0,0,0,0,1.225841424916178201698358,0.02296},
	{0,5,-8,0,0,0,0,0,0,0,2,4.404792676611984703072267,0.00001},
	{0,5,-8,0,0,0,0,0,0,1,-1,1.112694696569114238826614,0.00002},
	{0,5,-8,0,0,0,0,0,0,1,0,1.212170959017007332292337,0.00403},
	{0,5,-8,0,0,0,0,0,0,2,0,1.209493973010298484282998,0.00027},
	{0,5,-8,0,0,0,0,0,0,3,0,1.201196503213392219322486,0.00001},
	{0,5,-8,0,0,0,0,0,1,0,-1,1.181381082083799549664604,0.00012},
	{0,5,-8,0,0,0,0,0,1,0,0,4.451361551713697295440397,0.00003},
	{0,5,-8,0,0,0,0,0,1,1,-1,4.753704065372049036852786,0.00001},
	{0,5,-8,0,0,0,0,0,2,-2,0,1.283253681594681117061896,0.00009},
	{0,5,-8,0,0,0,0,0,2,-1,0,1.261849661779923525983804,0.00253},
	{0,5,-8,0,0,0,0,0,2,0,-2,1.250285633754984582211023,0.00004},
	{0,5,-8,0,0,0,0,0,2,0,0,1.246537888252177372905294,0.00166},
	{0,5,-8,0,0,0,0,0,2,1,0,1.239741052546135868794863,0.00017},
	{0,5,-8,0,0,0,0,0,2,2,0,1.250195400232656739447634,0.00002},
	{0,5,-8,0,0,0,0,0,3,0,-1,4.750862320283951945043555,0.00001},
	{0,5,-8,0,0,0,0,0,4,-2,0,1.271589646203602930185639,0.00002},
	{0,5,-8,0,0,0,0,0,4,-1,0,1.254381921509415409587973,0.00003},
	{0,5,-8,0,0,0,0,0,4,0,0,1.250270449390492366603667,0.00002},
	{0,5,-8,0,1,0,0,0,0,0,0,3.481718403961168828431028,0.00001},
	{0,5,-8,0,2,0,0,0,0,-1,0,1.605670448710696307514922,0.00003},
	{0,5,-8,0,2,0,0,0,0,0,0,4.662476752567856763675991,0.00005},
	{0,5,-8,0,2,0,0,0,0,1,0,1.605670448710696307514922,0.00003},
	{0,5,-8,0,2,0,0,0,2,-1,0,4.729617474496976115005964,0.00002},
	{0,5,-8,0,3,0,0,0,0,0,0,3.381371920348230641906184,0.00004},
	{0,5,-8,2,0,0,0,0,0,0,0,1.625139771049618264697756,0.00001},
	{0,5,-8,3,0,0,0,0,2,-3,0,6.227721536078009378911702,0.00003},
	{0,5,-8,3,0,0,0,0,2,-2,0,3.057147864791775582204991,0.00002},
	{0,5,-8,3,0,0,0,0,2,-1,0,6.227721536078009378911702,0.00003},
	{0,5,-8,4,0,0,0,0,0,0,0,0.533935837159085657788182,0.00001},
	{0,5,-7,-4,0,0,0,0,0,0,0,1.960634988382527366113095,0.00005},
	{0,5,-7,-4,0,0,0,0,2,-1,0,1.960619280419259258252396,0.00004},
	{0,5,-7,-4,0,0,0,0,2,0,0,1.960619280419259258252396,0.00004},
	{0,5,-7,-3,0,0,0,0,0,0,0,0.472171951056585159633983,0.00001},
	{0,5,-7,-2,0,0,0,0,0,-1,0,2.903243335087514420678190,0.00001},
	{0,5,-7,-2,0,0,0,0,0,1,0,2.903243335087514420678190,0.00001},
	{0,5,-7,0,-2,0,0,0,-2,0,0,0.904653893192342906104386,0.00001},
	{0,5,-7,0,-2,0,0,0,-2,2,0,4.046246546782136022102350,0.00001},
	{0,5,-7,0,-1,0,0,0,1,0,-1,3.620046917288931798140084,0.00002},
	{0,5,-7,0,0,0,0,0,-4,0,0,2.931241034283381452496542,0.00004},
	{0,5,-7,0,0,0,0,0,-4,1,0,2.888051814745230760905770,0.00007},
	{0,5,-7,0,0,0,0,0,-4,2,0,2.881777181551385957902767,0.00005},
	{0,5,-7,0,0,0,0,0,-2,-2,0,2.915498862562093673744812,0.00003},
	{0,5,-7,0,0,0,0,0,-2,-1,0,2.908517021955340453587269,0.00023},
	{0,5,-7,0,0,0,0,0,-2,0,0,2.955557834086792290406720,0.00290},
	{0,5,-7,0,0,0,0,0,-2,0,2,2.937348988533660776312217,0.00002},
	{0,5,-7,0,0,0,0,0,-2,1,0,2.938261272133678492224362,0.00365},
	{0,5,-7,0,0,0,0,0,-2,2,0,3.028860790005928560475468,0.00015},
	{0,5,-7,0,0,0,0,0,-1,-1,-1,2.955314186123214170720530,0.00004},
	{0,5,-7,0,0,0,0,0,-1,-1,1,2.898385036581663243282492,0.00006},
	{0,5,-7,0,0,0,0,0,-1,0,-1,2.953485430132974265404755,0.00034},
	{0,5,-7,0,0,0,0,0,-1,0,0,6.005521574611509372232376,0.00008},
	{0,5,-7,0,0,0,0,0,-1,0,1,6.118652769528230450646333,0.00045},
	{0,5,-7,0,0,0,0,0,-1,1,-1,6.106073308944481858873132,0.00009},
	{0,5,-7,0,0,0,0,0,-1,1,1,0.010743374210651095504443,0.00003},
	{0,5,-7,0,0,0,0,0,-1,2,-1,6.098685853819564961497690,0.00003},
	{0,5,-7,0,0,0,0,0,0,-2,0,2.770203169393293585187621,0.00007},
	{0,5,-7,0,0,0,0,0,0,-1,0,2.972676896054978978867211,0.00142},
	{0,5,-7,0,0,0,0,0,0,0,0,2.975651460699152650590804,0.00818},
	{0,5,-7,0,0,0,0,0,0,1,0,2.951481617618759489829472,0.00129},
	{0,5,-7,0,0,0,0,0,0,2,0,3.059278213676760227457407,0.00009},
	{0,5,-7,0,0,0,0,0,1,-2,-1,2.955849478604800406600361,0.00017},
	{0,5,-7,0,0,0,0,0,1,-2,0,6.112038669794872980389755,0.00002},
	{0,5,-7,0,0,0,0,0,1,-1,-1,2.956075498742934293261442,0.00271},
	{0,5,-7,0,0,0,0,0,1,-1,0,2.720541919922897733385980,0.00002},
	{0,5,-7,0,0,0,0,0,1,-1,1,6.118149242039030433204516,0.00046},
	{0,5,-7,0,0,0,0,0,1,0,-3,6.113790805830950247923283,0.00002},
	{0,5,-7,0,0,0,0,0,1,0,-1,2.954277286014604264607897,0.01810},
	{0,5,-7,0,0,0,0,0,1,0,0,2.704937803745441904368363,0.00020},
	{0,5,-7,0,0,0,0,0,1,0,1,6.096560915455262019690963,0.00163},
	{0,5,-7,0,0,0,0,0,1,1,-1,2.956075498742934293261442,0.00271},
	{0,5,-7,0,0,0,0,0,1,1,1,6.096126677537365701198269,0.00018},
	{0,5,-7,0,0,0,0,0,1,2,-1,2.956075498742934293261442,0.00018},
	{0,5,-7,0,0,0,0,0,2,-3,0,2.401654906686116142111587,0.00002},
	{0,5,-7,0,0,0,0,0,2,-2,0,2.809678328283200521298113,0.00011},
	{0,5,-7,0,0,0,0,0,2,-1,-2,3.407741750950763037764091,0.00004},
	{0,5,-7,0,0,0,0,0,2,-1,0,2.867571248637703185124792,0.00281},
	{0,5,-7,0,0,0,0,0,2,0,-2,3.057875143491081804114629,0.00007},
	{0,5,-7,0,0,0,0,0,2,0,0,2.911662279800359520720576,0.00093},
	{0,5,-7,0,0,0,0,0,2,1,-2,0.266149097360969699721522,0.00005},
	{0,5,-7,0,0,0,0,0,2,1,0,2.915738147202541874491999,0.00010},
	{0,5,-7,0,0,0,0,0,3,-2,-1,6.098708368566915893893565,0.00003},
	{0,5,-7,0,0,0,0,0,3,-1,-1,6.101231765599449907711005,0.00018},
	{0,5,-7,0,0,0,0,0,3,-1,1,6.096127201136140705273192,0.00004},
	{0,5,-7,0,0,0,0,0,3,0,-1,2.954263672446438615537545,0.00014},
	{0,5,-7,0,0,0,0,0,3,0,1,6.096128073800767488421570,0.00002},
	{0,5,-7,0,0,0,0,0,3,1,-1,2.955314186123214170720530,0.00004},
	{0,5,-7,0,0,0,0,0,4,-2,0,2.583979156199376792102385,0.00002},
	{0,5,-7,0,0,0,0,0,4,-1,-2,3.408787203172707780396422,0.00001},
	{0,5,-7,0,0,0,0,0,4,-1,0,2.811625417596725462487939,0.00005},
	{0,5,-7,0,0,0,0,0,4,0,-2,0.265860768968540217560559,0.00004},
	{0,5,-7,0,0,0,0,0,4,0,0,2.911488619539785993595160,0.00005},
	{0,5,-7,0,0,1,0,0,0,0,0,4.693578519838395912699980,0.00001},
	{0,5,-7,0,2,0,0,0,-2,0,0,3.139817479207589911993637,0.00002},
	{0,5,-7,0,2,0,0,0,0,-1,0,6.280728058125704116321231,0.00003},
	{0,5,-7,0,2,0,0,0,0,0,0,3.068358289110260539445107,0.00003},
	{0,5,-7,0,2,0,0,0,0,1,0,6.280728058125704116321231,0.00003},
	{0,5,-7,0,2,0,0,0,0,2,0,6.281091784741819061821388,0.00001},
	{0,5,-7,0,2,0,0,0,2,-1,0,2.874325323777070728681338,0.00004},
	{0,5,-7,0,2,0,0,0,2,0,0,6.282375823472511555678466,0.00001},
	{0,5,-7,0,3,0,0,0,0,0,0,2.960602359223831747669919,0.00001},
	{0,5,-7,0,3,0,0,0,2,0,0,2.969307363401078703191160,0.00003},
	{0,5,-7,2,0,0,0,0,2,-3,0,5.885938770114790941079264,0.00002},
	{0,5,-7,2,0,0,0,0,2,-2,0,0.003164630999716118355675,0.00003},
	{0,5,-7,2,0,0,0,0,2,-1,0,5.885938770114790941079264,0.00002},
	{0,5,-7,2,0,0,0,0,2,0,-2,3.239240334580371971640034,0.00002},
	{0,5,-7,2,0,0,0,0,2,0,0,0.003164630999716118355675,0.00003},
	{0,5,-6,-4,0,0,0,0,-4,1,0,0.164273007191584302644216,0.00001},
	{0,5,-6,-4,0,0,0,0,-2,-1,0,0.164273007191584302644216,0.00004},
	{0,5,-6,-4,0,0,0,0,-2,0,0,0.163462825352808510670499,0.00032},
	{0,5,-6,-4,0,0,0,0,-2,1,0,0.177754977531539681834261,0.00054},
	{0,5,-6,-4,0,0,0,0,-2,2,0,0.164273007191584302644216,0.00002},
	{0,5,-6,-4,0,0,0,0,0,-2,0,0.097735820117804461659716,0.00004},
	{0,5,-6,-4,0,0,0,0,0,-1,0,0.091824564474224878996012,0.00053},
	{0,5,-6,-4,0,0,0,0,0,0,0,0.157166375543313779905574,0.00323},
	{0,5,-6,-4,0,0,0,0,0,1,0,0.091732934688495165742594,0.00053},
	{0,5,-6,-4,0,0,0,0,0,2,0,0.097744372231139242668263,0.00004},
	{0,5,-6,-4,0,0,0,0,2,-2,0,0.164064614878896147809328,0.00002},
	{0,5,-6,-4,0,0,0,0,2,-1,0,0.177538731237217584091326,0.00054},
	{0,5,-6,-4,0,0,0,0,2,0,0,0.163275202458219109713511,0.00032},
	{0,5,-6,-4,0,0,0,0,2,1,0,0.164064614878896147809328,0.00004},
	{0,5,-6,-4,0,0,0,0,4,-1,0,0.164064614878896147809328,0.00001},
	{0,5,-6,-2,0,0,0,0,1,0,-1,1.391031253563835168307605,0.00003},
	{0,5,-6,0,-1,0,0,0,-2,0,0,1.815571424004242873095905,0.00001},
	{0,5,-6,0,-1,0,0,0,-2,2,0,4.957164077594036655227683,0.00001},
	{0,5,-6,0,-1,0,0,0,0,-2,0,0.483394243613983476404172,0.00001},
	{0,5,-6,0,-1,0,0,0,0,0,0,3.624986897203776869957892,0.00001},
	{0,5,-6,0,-1,0,0,0,2,-3,0,4.971867080278687289762729,0.00002},
	{0,5,-6,0,-1,0,0,0,2,-1,0,1.830274426688893729675556,0.00002},
	{0,5,-6,0,0,-1,0,0,2,0,-2,0.059718011153312780536773,0.00002},
	{0,5,-6,0,0,0,0,0,-2,-2,0,4.778213898590729868942617,0.00002},
	{0,5,-6,0,0,0,0,0,-2,-1,0,1.526572476076163420444232,0.00014},
	{0,5,-6,0,0,0,0,0,-2,0,0,1.490957985491668136290855,0.00113},
	{0,5,-6,0,0,0,0,0,-2,0,2,1.504554623963479276227417,0.00001},
	{0,5,-6,0,0,0,0,0,-2,1,-2,4.752457725753200357132755,0.00001},
	{0,5,-6,0,0,0,0,0,-2,1,0,1.489343206867722813058208,0.00116},
	{0,5,-6,0,0,0,0,0,-2,2,-2,1.611339278121173723690163,0.00001},
	{0,5,-6,0,0,0,0,0,-2,2,0,1.441869378548850999521846,0.00003},
	{0,5,-6,0,0,0,0,0,-2,3,0,4.935363169907375002765093,0.00002},
	{0,5,-6,0,0,0,0,0,-1,-1,1,4.474961719326238984706379,0.00001},
	{0,5,-6,0,0,0,0,0,-1,0,-1,1.317373646740694015377926,0.00018},
	{0,5,-6,0,0,0,0,0,-1,0,0,1.637437186426244917214490,0.00002},
	{0,5,-6,0,0,0,0,0,-1,0,1,4.478460057278937256342033,0.00039},
	{0,5,-6,0,0,0,0,0,-1,1,-1,1.347164846275910266015785,0.00008},
	{0,5,-6,0,0,0,0,0,-1,1,1,4.473841217946459281051830,0.00004},
	{0,5,-6,0,0,0,0,0,0,-3,0,1.608111989801310981462734,0.00002},
	{0,5,-6,0,0,0,0,0,0,-2,0,1.589903144248179245323627,0.00023},
	{0,5,-6,0,0,0,0,0,0,-1,-2,4.752611140194449745877137,0.00012},
	{0,5,-6,0,0,0,0,0,0,-1,0,1.595206152647438813119152,0.00386},
	{0,5,-6,0,0,0,0,0,0,0,-2,4.752470292123814665785630,0.00072},
	{0,5,-6,0,0,0,0,0,0,0,-1,1.333165734878589026024542,0.00005},
	{0,5,-6,0,0,0,0,0,0,0,0,4.758971119988718356808022,0.00367},
	{0,5,-6,0,0,0,0,0,0,0,1,1.332237045183602752729257,0.00002},
	{0,5,-6,0,0,0,0,0,0,1,-2,1.612523658551576977160380,0.00026},
	{0,5,-6,0,0,0,0,0,0,1,0,4.752916223747699397961242,0.00084},
	{0,5,-6,0,0,0,0,0,0,2,-2,1.611339278121173723690163,0.00008},
	{0,5,-6,0,0,0,0,0,0,2,0,4.755526014578205895588781,0.00005},
	{0,5,-6,0,0,0,0,0,1,-2,-1,1.333011622305637855490090,0.00003},
	{0,5,-6,0,0,0,0,0,1,-1,-1,1.334358143823551667850325,0.00046},
	{0,5,-6,0,0,0,0,0,1,-1,0,1.615359993118993031657737,0.00003},
	{0,5,-6,0,0,0,0,0,1,-1,1,4.474765718851241302900235,0.00030},
	{0,5,-6,0,0,0,0,0,1,0,-2,1.610896313557017567319463,0.00003},
	{0,5,-6,0,0,0,0,0,1,0,-1,1.332654702473605068391294,0.00310},
	{0,5,-6,0,0,0,0,0,1,0,0,1.583608963366712085729660,0.00015},
	{0,5,-6,0,0,0,0,0,1,0,1,4.432423856664932770854648,0.00031},
	{0,5,-6,0,0,0,0,0,1,1,-1,1.336873512341525849222990,0.00037},
	{0,5,-6,0,0,0,0,0,1,1,1,4.445406488305892800383390,0.00003},
	{0,5,-6,0,0,0,0,0,1,2,-1,1.333017556425094563010703,0.00003},
	{0,5,-6,0,0,0,0,0,2,-3,-2,4.753352556060697509110469,0.00004},
	{0,5,-6,0,0,0,0,0,2,-3,0,2.327997648928825658032338,0.00002},
	{0,5,-6,0,0,0,0,0,2,-2,-2,4.752746054145629450715660,0.00050},
	{0,5,-6,0,0,0,0,0,2,-2,0,1.792388041017076938388186,0.00011},
	{0,5,-6,0,0,0,0,0,2,-1,-4,1.613315514433206976363522,0.00001},
	{0,5,-6,0,0,0,0,0,2,-1,-2,4.752697708525349895580803,0.00742},
	{0,5,-6,0,0,0,0,0,2,-1,-1,4.427555435249419524268433,0.00003},
	{0,5,-6,0,0,0,0,0,2,-1,0,4.745224383201234630291765,0.02267},
	{0,5,-6,0,0,0,0,0,2,-1,2,1.602542818691122139540539,0.00005},
	{0,5,-6,0,0,0,0,0,2,0,-4,1.615153869734332392482656,0.00007},
	{0,5,-6,0,0,0,0,0,2,0,-2,4.752457725753200357132755,0.05272},
	{0,5,-6,0,0,0,0,0,2,0,-1,4.474490829494051524761744,0.00037},
	{0,5,-6,0,0,0,0,0,2,0,0,1.620897224703870209694401,0.00342},
	{0,5,-6,0,0,0,0,0,2,1,-2,4.752746054145629450715660,0.00738},
	{0,5,-6,0,0,0,0,0,2,1,-1,4.474490829494051524761744,0.00002},
	{0,5,-6,0,0,0,0,0,2,1,0,1.627323876075563724441508,0.00045},
	{0,5,-6,0,0,0,0,0,2,2,-2,4.752746054145629450715660,0.00050},
	{0,5,-6,0,0,0,0,0,2,2,0,1.612093958489736023054206,0.00006},
	{0,5,-6,0,0,0,0,0,2,3,-2,4.752746054145629450715660,0.00004},
	{0,5,-6,0,0,0,0,0,3,-3,0,1.603040935659641563759692,0.00001},
	{0,5,-6,0,0,0,0,0,3,-1,-1,4.576849677734538879292359,0.00012},
	{0,5,-6,0,0,0,0,0,3,0,-1,1.333460695522175942784315,0.00003},
	{0,5,-6,0,0,0,0,0,3,0,0,1.613643810865507122187523,0.00002},
	{0,5,-6,0,0,0,0,0,4,-2,-2,1.611339278121173723690163,0.00008},
	{0,5,-6,0,0,0,0,0,4,-2,0,4.768435167857656864498495,0.00032},
	{0,5,-6,0,0,0,0,0,4,-1,-2,1.611984875411486495266900,0.00039},
	{0,5,-6,0,0,0,0,0,4,-1,0,4.771385297892303256617197,0.00015},
	{0,5,-6,0,0,0,0,0,4,0,-2,4.752439225263128896870057,0.00049},
	{0,5,-6,0,0,0,0,0,4,0,0,1.721184541655164990103799,0.00008},
	{0,5,-6,0,0,0,0,0,4,1,-2,4.752629466151596204781526,0.00010},
	{0,5,-6,0,0,0,0,0,4,1,0,1.615679039306257669394995,0.00001},
	{0,5,-6,0,0,0,0,0,6,-2,-2,1.611339278121173723690163,0.00001},
	{0,5,-6,0,0,0,0,0,6,-1,-2,4.752457725753200357132755,0.00001},
	{0,5,-6,0,0,1,0,0,2,-3,0,3.137580490705308644550087,0.00002},
	{0,5,-6,0,0,1,0,0,2,-1,0,3.137580490705308644550087,0.00002},
	{0,5,-6,0,1,0,0,0,-2,0,0,3.343465463390016711997532,0.00009},
	{0,5,-6,0,1,0,0,0,-2,1,0,3.303109611359553277054601,0.00001},
	{0,5,-6,0,1,0,0,0,0,0,0,5.656723108654048814969428,0.00002},
	{0,5,-6,0,1,0,0,0,2,-3,0,3.509847002850935204776306,0.00002},
	{0,5,-6,0,2,0,0,0,0,0,0,1.273091676557869478259022,0.00002},
	{0,5,-6,0,2,0,0,0,2,-3,0,4.490685041491606632746425,0.00002},
	{0,5,-6,0,2,0,0,0,2,-1,0,4.490685041491606632746425,0.00002},
	{0,5,-6,1,0,0,0,0,0,0,0,3.133734308632688314588677,0.00001},
	{0,5,-6,2,0,0,0,0,2,-3,0,3.903550870600032585144845,0.00002},
	{0,5,-6,2,0,0,0,0,2,-2,0,0.761958217010239247102277,0.00002},
	{0,5,-6,2,0,0,0,0,2,-1,0,3.903550870600032585144845,0.00002},
	{0,5,-6,2,0,0,0,0,2,0,0,0.761958217010239247102277,0.00002},
	{0,5,-6,3,0,0,0,0,-2,0,0,4.126322776462411745512782,0.00002},
	{0,5,-6,3,0,0,0,0,-2,2,0,4.126322776462411745512782,0.00002},
	{0,5,-5,-4,0,0,0,0,-2,0,0,4.561778410577717046692214,0.00003},
	{0,5,-5,-4,0,0,0,0,-2,1,0,4.561778410577717046692214,0.00002},
	{0,5,-5,-4,0,0,0,0,0,0,0,4.261242836293955171811376,0.00002},
	{0,5,-5,-3,0,0,0,0,2,-3,0,0.602717692183855402454640,0.00001},
	{0,5,-5,-3,0,0,0,0,2,-1,0,0.602717692183855402454640,0.00001},
	{0,5,-5,0,-2,0,0,0,-2,0,0,3.585521861223531558948707,0.00001},
	{0,5,-5,0,-1,0,0,0,-2,0,0,3.340524409067481048651871,0.00006},
	{0,5,-5,0,-1,0,0,0,-2,1,0,0.227801595700776293718093,0.00001},
	{0,5,-5,0,-1,0,0,0,-2,2,0,3.238142347947942312202940,0.00001},
	{0,5,-5,0,-1,0,0,0,-2,3,0,3.369394249290569298693754,0.00001},
	{0,5,-5,0,-1,0,0,0,0,-2,0,3.369394249290569298693754,0.00001},
	{0,5,-5,0,-1,0,0,0,0,0,0,0.949243215856443556255329,0.00002},
	{0,5,-5,0,0,0,0,0,-4,-1,0,3.133164284098987284465920,0.00001},
	{0,5,-5,0,0,0,0,0,-4,0,0,6.267746648215219984479063,0.00003},
	{0,5,-5,0,0,0,0,0,-4,1,0,6.262144315849243803029367,0.00003},
	{0,5,-5,0,0,0,0,0,-4,2,0,0.017629745307319921732159,0.00002},
	{0,5,-5,0,0,0,0,0,-2,-1,0,6.222179766637077058533123,0.00004},
	{0,5,-5,0,0,0,0,0,-2,0,0,6.252639776341657906755245,0.00120},
	{0,5,-5,0,0,0,0,0,-2,1,0,6.253575970952428342286566,0.00104},
	{0,5,-5,0,0,0,0,0,-2,2,0,6.263922282758250581480297,0.00018},
	{0,5,-5,0,0,0,0,0,-2,3,0,6.220204926588445815127670,0.00003},
	{0,5,-5,0,0,0,0,0,-1,-1,0,3.146584469783422211008883,0.00001},
	{0,5,-5,0,0,0,0,0,-1,0,0,0.001152091839241456980650,0.00019},
	{0,5,-5,0,0,0,0,0,-1,0,1,0.259415093508000016431225,0.00004},
	{0,5,-5,0,0,0,0,0,-1,1,0,0.000009948376736367678163,0.00005},
	{0,5,-5,0,0,0,0,0,0,-3,0,6.222733559608735198764862,0.00002},
	{0,5,-5,0,0,0,0,0,0,-2,0,6.280349321678021290438210,0.00014},
	{0,5,-5,0,0,0,0,0,0,-1,0,6.260129856826591066010224,0.00197},
	{0,5,-5,0,0,0,0,0,0,0,-2,3.058166089877389470785829,0.00011},
	{0,5,-5,0,0,0,0,0,0,0,0,3.142090246959536870008378,0.03305},
	{0,5,-5,0,0,0,0,0,0,0,2,0.002057568655176114820471,0.00003},
	{0,5,-5,0,0,0,0,0,0,1,-2,3.217005887107515338385610,0.00004},
	{0,5,-5,0,0,0,0,0,0,1,0,3.142488356561916607034846,0.00532},
	{0,5,-5,0,0,0,0,0,0,2,0,3.142071921002390855193198,0.00043},
	{0,5,-5,0,0,0,0,0,0,3,0,3.141492646223654094939093,0.00004},
	{0,5,-5,0,0,0,0,0,0,4,0,3.142090945091237319530819,0.00001},
	{0,5,-5,0,0,0,0,0,1,-2,0,3.197067245732732043705937,0.00002},
	{0,5,-5,0,0,0,0,0,1,-1,-1,3.316548123001134218412744,0.00002},
	{0,5,-5,0,0,0,0,0,1,-1,0,0.002392497338633827082266,0.00009},
	{0,5,-5,0,0,0,0,0,1,0,-2,3.142701461263584850058805,0.00004},
	{0,5,-5,0,0,0,0,0,1,0,-1,3.316548123001134218412744,0.00027},
	{0,5,-5,0,0,0,0,0,1,0,0,0.005128126408209739660327,0.00064},
	{0,5,-5,0,0,0,0,0,1,1,-1,3.316548123001134218412744,0.00002},
	{0,5,-5,0,0,0,0,0,1,1,0,0.007722034742523711803308,0.00003},
	{0,5,-5,0,0,0,0,0,2,-2,0,3.142117648628793169507389,0.00124},
	{0,5,-5,0,0,0,0,0,2,-1,-2,3.048185250016934411121383,0.00009},
	{0,5,-5,0,0,0,0,0,2,-1,0,3.142866569410823984753733,0.03759},
	{0,5,-5,0,0,0,0,0,2,-1,2,0.000683121869230580601104,0.00008},
	{0,5,-5,0,0,0,0,0,2,0,-2,3.139807705363778289608945,0.00126},
	{0,5,-5,0,0,0,0,0,2,0,0,0.000835663645854884925071,0.00952},
	{0,5,-5,0,0,0,0,0,2,0,2,3.141978196821558544371555,0.00004},
	{0,5,-5,0,0,0,0,0,2,1,-2,6.203659903411240073012323,0.00008},
	{0,5,-5,0,0,0,0,0,2,1,0,0.000290771853382255321841,0.00080},
	{0,5,-5,0,0,0,0,0,2,2,0,6.280999805890238540939663,0.00012},
	{0,5,-5,0,0,0,0,0,3,-2,0,0.002764077936383419788202,0.00012},
	{0,5,-5,0,0,0,0,0,3,-1,-2,0.001092227045898051286665,0.00001},
	{0,5,-5,0,0,0,0,0,3,-1,-1,3.130449773513360511856263,0.00002},
	{0,5,-5,0,0,0,0,0,3,0,-2,0.001108807673791997521970,0.00018},
	{0,5,-5,0,0,0,0,0,3,0,0,0.001401848455201845644602,0.00003},
	{0,5,-5,0,0,0,0,0,3,1,0,0.001157851425773038242864,0.00001},
	{0,5,-5,0,0,0,0,0,4,-3,0,3.178102847146412113232827,0.00003},
	{0,5,-5,0,0,0,0,0,4,-2,0,3.142744919961959926268946,0.00052},
	{0,5,-5,0,0,0,0,0,4,-1,-2,3.142455718904904493626873,0.00004},
	{0,5,-5,0,0,0,0,0,4,-1,0,3.142801294096799313848578,0.00016},
	{0,5,-5,0,0,0,0,0,4,0,-2,0.000310494073929791242900,0.00002},
	{0,5,-5,0,0,0,0,0,4,0,0,6.282772362278564060034114,0.00010},
	{0,5,-5,0,0,0,0,0,4,1,0,0.000235619449019234481748,0.00004},
	{0,5,-5,0,0,0,0,0,6,-1,0,0.000611039771123214722932,0.00001},
	{0,5,-5,0,1,0,0,0,-2,0,0,6.033238450330730806570045,0.00004},
	{0,5,-5,0,1,0,0,0,-2,1,0,2.989075311575017046550329,0.00001},
	{0,5,-5,0,1,0,0,0,-2,3,0,6.130667965164809274369873,0.00001},
	{0,5,-5,0,1,0,0,0,0,0,0,2.989075311575017046550329,0.00002},
	{0,5,-5,0,1,0,0,0,2,-2,0,2.902301031824362720357158,0.00002},
	{0,5,-5,0,1,0,0,0,2,-1,0,6.043894383545857174055982,0.00004},
	{0,5,-5,0,1,0,0,0,2,0,0,2.768398324413806399491023,0.00003},
	{0,5,-4,-3,0,0,0,0,2,-3,0,2.156540692003107384522309,0.00002},
	{0,5,-4,-3,0,0,0,0,2,-2,0,5.298133345592900056431063,0.00001},
	{0,5,-4,-3,0,0,0,0,2,-1,0,2.156540692003107384522309,0.00002},
	{0,5,-4,-3,0,0,0,0,2,0,0,5.298133345592900056431063,0.00001},
	{0,5,-4,-1,0,0,0,0,0,0,0,3.149128985299904925909686,0.00001},
	{0,5,-4,0,-3,0,0,0,0,0,0,1.981323946802742819173204,0.00002},
	{0,5,-4,0,-2,0,0,0,0,0,0,4.830242512658531772729020,0.00001},
	{0,5,-4,0,-1,0,0,0,-2,0,0,3.118873179117807481475211,0.00001},
	{0,5,-4,0,-1,0,0,0,-2,1,0,3.167538892782866266628616,0.00003},
	{0,5,-4,0,-1,0,0,0,-2,2,0,3.118873179117807481475211,0.00001},
	{0,5,-4,0,-1,0,0,0,-2,3,0,0.025946239193072900830472,0.00003},
	{0,5,-4,0,-1,0,0,0,0,-2,0,3.171277737106488192608822,0.00001},
	{0,5,-4,0,-1,0,0,0,0,-1,0,3.163842285427142186904348,0.00001},
	{0,5,-4,0,-1,0,0,0,0,0,0,3.167265225156153718444330,0.00008},
	{0,5,-4,0,-1,0,0,0,0,1,0,3.163842285427142186904348,0.00001},
	{0,5,-4,0,-1,0,0,0,2,-2,0,3.210095081401318939384737,0.00002},
	{0,5,-4,0,-1,0,0,0,2,-1,0,3.210095081401318939384737,0.00002},
	{0,5,-4,0,-1,0,0,0,2,0,0,0.068502427811525434808715,0.00002},
	{0,5,-4,0,0,-1,0,0,-2,0,0,3.145282803227285040037486,0.00001},
	{0,5,-4,0,0,-1,0,0,-2,2,0,0.003690149637491610921936,0.00001},
	{0,5,-4,0,0,0,0,0,-3,0,1,1.802756169438549216366141,0.00002},
	{0,5,-4,0,0,0,0,0,-2,-1,0,4.355643681277048706590449,0.00002},
	{0,5,-4,0,0,0,0,0,-2,0,0,4.087187433177867923461690,0.00008},
	{0,5,-4,0,0,0,0,0,-2,1,0,4.372152925204588314045395,0.00018},
	{0,5,-4,0,0,0,0,0,-2,2,0,4.948976214474154922129401,0.00002},
	{0,5,-4,0,0,0,0,0,-2,3,0,4.376101383571374903169726,0.00001},
	{0,5,-4,0,0,0,0,0,-1,-1,-1,1.802876248091086708313924,0.00002},
	{0,5,-4,0,0,0,0,0,-1,-1,1,4.951931056897780791814512,0.00005},
	{0,5,-4,0,0,0,0,0,-1,0,-1,1.802832614859786852790080,0.00029},
	{0,5,-4,0,0,0,0,0,-1,0,1,4.947319722481086756715740,0.00042},
	{0,5,-4,0,0,0,0,0,-1,1,-1,1.802806958519782343230986,0.00014},
	{0,5,-4,0,0,0,0,0,-1,1,1,4.946525597671429075319338,0.00003},
	{0,5,-4,0,0,0,0,0,0,-2,0,4.215897960596666216304129,0.00001},
	{0,5,-4,0,0,0,0,0,0,-1,0,4.432102716082566118416253,0.00019},
	{0,5,-4,0,0,0,0,0,0,0,-1,4.944684624376425752245723,0.00001},
	{0,5,-4,0,0,0,0,0,0,0,0,1.668526736392019982346824,0.00029},
	{0,5,-4,0,0,0,0,0,0,1,0,1.310845242673609245542821,0.00005},
	{0,5,-4,0,0,0,0,0,1,-1,-1,1.803285527800679188814570,0.00022},
	{0,5,-4,0,0,0,0,0,1,-1,1,4.944983599277292363183278,0.00012},
	{0,5,-4,0,0,0,0,0,1,0,-1,1.803400021399609975958356,0.00145},
	{0,5,-4,0,0,0,0,0,1,0,1,4.944934555525311026258350,0.00008},
	{0,5,-4,0,0,0,0,0,1,1,-1,1.803338934875790444678501,0.00016},
	{0,5,-4,0,0,0,0,0,2,-2,0,4.659973601354646888239586,0.00004},
	{0,5,-4,0,0,0,0,0,2,-1,0,4.604620833193496132196287,0.00052},
	{0,5,-4,0,0,0,0,0,2,0,-2,4.587280638009082700534691,0.00002},
	{0,5,-4,0,0,0,0,0,2,0,-1,4.945369666107834127899423,0.00003},
	{0,5,-4,0,0,0,0,0,2,0,0,1.429881759114453254611021,0.00031},
	{0,5,-4,0,0,0,0,0,2,1,0,1.374703523878502808841517,0.00007},
	{0,5,-4,0,0,0,0,0,3,-1,-1,1.803334397019735080291980,0.00006},
	{0,5,-4,0,0,0,0,0,3,0,-1,1.803392691016751703259047,0.00003},
	{0,5,-4,0,0,0,0,0,4,-1,0,1.462317830598141688014380,0.00002},
	{0,5,-3,-13,0,0,0,0,-2,1,0,5.732420481773995213359285,0.00001},
	{0,5,-3,-13,0,0,0,0,-2,3,0,5.732420481773995213359285,0.00001},
	{0,5,-3,-4,0,0,0,0,0,0,0,5.297704867261535888189883,0.00001},
	{0,5,-3,-3,0,0,0,0,-2,0,0,5.868136411744448999172619,0.00001},
	{0,5,-3,-3,0,0,0,0,-2,2,0,5.868136411744448999172619,0.00001},
	{0,5,-3,-2,0,0,0,0,-2,0,0,0.010848792097471552861587,0.00001},
	{0,5,-3,-2,0,0,0,0,-2,1,0,3.136178118651331558908169,0.00002},
	{0,5,-3,-2,0,0,0,0,-2,2,0,0.010848792097471552861587,0.00001},
	{0,5,-3,-2,0,0,0,0,0,-2,0,3.139671744215048132531365,0.00001},
	{0,5,-3,-2,0,0,0,0,0,0,0,3.139671744215048132531365,0.00001},
	{0,5,-3,0,-2,0,0,0,-2,-2,0,0.001771509190774244596467,0.00001},
	{0,5,-3,0,-2,0,0,0,-2,2,0,0.005385737005804102674189,0.00002},
	{0,5,-3,0,-2,0,0,0,0,-2,0,6.279048527786510014436772,0.00002},
	{0,5,-3,0,-1,0,0,0,-2,0,0,1.568062093988722205395447,0.00002},
	{0,5,-3,0,-1,0,0,0,-2,2,0,4.709654747578515987527226,0.00002},
	{0,5,-3,0,0,0,0,0,-2,-1,0,0.504287754622532835568904,0.00003},
	{0,5,-3,0,0,0,0,0,-2,0,0,0.523594063209318449914065,0.00028},
	{0,5,-3,0,0,0,0,0,-2,1,0,0.491007893409958373620583,0.00017},
	{0,5,-3,0,0,0,0,0,-2,2,0,0.453718584875249075771819,0.00002},
	{0,5,-3,0,0,0,0,0,-1,0,-1,3.241812949897811435562289,0.00001},
	{0,5,-3,0,0,0,0,0,-1,0,0,3.589138008900738530115859,0.00002},
	{0,5,-3,0,0,0,0,0,-1,0,1,3.298558839867903547116157,0.00001},
	{0,5,-3,0,0,0,0,0,0,-1,0,0.449657203705858266040707,0.00017},
	{0,5,-3,0,0,0,0,0,0,0,0,0.460613333552327530728832,0.00119},
	{0,5,-3,0,0,0,0,0,0,1,0,0.453615086850605864210451,0.00012},
	{0,5,-3,0,0,0,0,0,0,2,0,2.615862307376033868422383,0.00001},
	{0,5,-3,0,0,0,0,0,1,0,-1,0.140726246654153175352775,0.00002},
	{0,5,-3,0,0,0,0,0,1,0,0,3.600148418486944557059815,0.00002},
	{0,5,-3,0,0,0,0,0,2,-2,0,5.878623048022131314382932,0.00002},
	{0,5,-3,0,0,0,0,0,2,-1,0,0.506754428454376348867072,0.00019},
	{0,5,-3,0,0,0,0,0,2,0,0,3.781659519101701061316589,0.00010},
	{0,5,-2,0,-3,0,0,0,-2,0,0,6.225385063808364982662624,0.00001},
	{0,5,-2,0,-3,0,0,0,-2,2,0,3.083792410218571866664661,0.00001},
	{0,5,-2,0,0,0,0,0,-2,0,0,5.062065172422977710198211,0.00002},
	{0,5,-2,0,0,0,0,0,-2,1,0,5.034631738174280890518730,0.00002},
	{0,5,-2,0,0,0,0,0,0,0,0,5.026903071180599980039005,0.00008},
	{0,5,-2,0,0,0,0,0,1,0,-1,5.381096698921824739159092,0.00001},
	{0,5,-2,0,0,0,0,0,2,0,0,4.362310489953816983188517,0.00002},
	{0,5,-2,0,1,0,0,0,2,0,0,2.330134804597892461686115,0.00004},
	{0,5,-1,0,-2,0,0,0,2,-2,0,5.823946420413204094757020,0.00001},
	{0,5,-1,0,-2,0,0,0,2,0,0,2.682353766823410978759057,0.00001},
	{0,5,-1,0,-1,0,0,0,2,-2,0,2.476061783357137890959621,0.00001},
	{0,5,-1,0,-1,0,0,0,2,0,0,2.528143979032975607879052,0.00008},
	{0,5,-1,0,0,0,0,0,-2,0,0,3.168657474300469178984940,0.00001},
	{0,5,-1,0,0,0,0,0,-2,2,0,3.168657474300469178984940,0.00001},
	{0,5,-1,0,0,0,0,0,0,-2,0,2.562103024821954289080850,0.00001},
	{0,5,-1,0,0,0,0,0,0,-1,0,2.237729743614454314126760,0.00002},
	{0,5,-1,0,0,0,0,0,0,0,0,3.280774632921781730487965,0.00002},
	{0,5,-1,0,0,0,0,0,0,1,0,2.236499635557648524297747,0.00003},
	{0,5,-1,0,0,0,0,0,2,-3,0,2.235052583074820020669904,0.00001},
	{0,5,-1,0,0,0,0,0,2,-2,0,2.234612236504541993298290,0.00002},
	{0,5,-1,0,0,0,0,0,2,-1,0,5.376645236664613136667867,0.00001},
	{0,5,-1,0,0,0,0,0,2,0,0,2.293538391776224649731830,0.00002},
	{0,5,-1,0,0,0,0,0,2,2,0,2.237729743614454314126760,0.00002},
	{0,5,-1,0,1,0,0,0,2,-2,0,5.227561306354360226578137,0.00003},
	{0,5,-1,0,1,0,0,0,2,0,0,5.201740207268654714312106,0.00005},
	{0,5,0,0,-1,0,0,0,0,0,0,2.260674191027021606714698,0.00001},
	{0,5,0,0,-1,0,0,0,0,2,0,2.260674191027021606714698,0.00001},
	{0,5,0,0,-1,0,0,0,2,0,0,2.247700635098172750048207,0.00004},
	{0,5,0,0,0,0,0,0,-2,0,0,5.271772590702478389346197,0.00005},
	{0,5,0,0,0,0,0,0,-2,2,0,5.271772590702478389346197,0.00005},
	{0,5,0,0,0,0,0,0,2,-2,0,3.705018271922276174024091,0.00003},
	{0,5,0,0,0,0,0,0,2,-1,0,3.665531768392230826947298,0.00002},
	{0,5,1,0,0,0,0,0,2,-1,0,2.680909506867386049577817,0.00002},
	{0,5,31,-52,0,0,0,0,-2,1,0,5.646275742284536214299351,0.00002},
	{0,6,-14,4,0,0,0,0,-2,0,2,1.392861754883326641518693,0.00002},
	{0,6,-14,6,0,0,0,0,-1,0,1,2.841699360470765434172336,0.00001},
	{0,6,-14,8,0,0,0,0,0,-1,0,3.048304281471920340607085,0.00001},
	{0,6,-14,8,0,0,0,0,0,0,0,0.942349688909841609607554,0.00001},
	{0,6,-14,8,0,0,0,0,0,1,0,3.048304281471920340607085,0.00001},
	{0,6,-13,0,2,0,0,0,-2,0,0,5.633807982772914613178727,0.00002},
	{0,6,-13,0,2,0,0,0,-2,1,0,2.492215329183121497180764,0.00002},
	{0,6,-13,4,0,0,0,0,-2,1,0,1.419362136113907713053095,0.00001},
	{0,6,-13,4,0,0,0,0,-2,3,0,1.419362136113907713053095,0.00001},
	{0,6,-12,0,0,0,0,0,-4,0,0,0.701753957127320915354574,0.00002},
	{0,6,-12,0,0,0,0,0,-2,-1,0,3.843346610717114142374840,0.00002},
	{0,6,-12,0,0,0,0,0,-2,-1,2,3.843346610717114142374840,0.00001},
	{0,6,-12,0,0,0,0,0,-2,0,0,3.832837634225005896126959,0.00003},
	{0,6,-12,0,0,0,0,0,-2,0,2,3.810793427640616570784005,0.00001},
	{0,6,-12,0,0,0,0,0,-2,1,0,3.843346610717114142374840,0.00002},
	{0,6,-12,0,0,0,0,0,-2,1,2,3.843346610717114142374840,0.00001},
	{0,6,-12,0,0,0,0,0,-2,2,0,3.832837634225005896126959,0.00003},
	{0,6,-12,0,0,0,0,0,0,0,0,4.829352220207089985137827,0.00002},
	{0,6,-12,0,0,4,0,0,-2,0,2,0.808550479523928666836241,0.00003},
	{0,6,-12,0,2,0,0,0,-2,0,0,4.042710509717595712686489,0.00004},
	{0,6,-12,0,2,0,0,0,-2,0,2,3.542817494151584867267957,0.00002},
	{0,6,-12,0,2,0,0,0,0,-1,0,0.900929535101512080075281,0.00001},
	{0,6,-12,0,2,0,0,0,0,1,0,0.900929535101512080075281,0.00001},
	{0,6,-12,0,3,0,0,0,-2,0,0,3.872330246407432507993462,0.00001},
	{0,6,-12,0,3,0,0,0,-2,1,0,0.692085356670047890936814,0.00001},
	{0,6,-12,0,3,0,0,0,-2,2,0,0.730737592817639503017801,0.00001},
	{0,6,-12,0,3,0,0,0,-2,3,0,0.692085356670047890936814,0.00001},
	{0,6,-12,0,4,0,0,0,-2,1,0,0.563292100644705029388604,0.00003},
	{0,6,-12,1,0,0,0,0,-2,1,0,2.485879958531307387659126,0.00001},
	{0,6,-12,1,0,0,0,0,-2,3,0,2.485879958531307387659126,0.00001},
	{0,6,-12,2,0,0,0,0,-2,0,0,4.077944518525156603061532,0.00005},
	{0,6,-12,2,0,0,0,0,-2,2,0,4.045013820731452547363460,0.00004},
	{0,6,-12,2,0,0,0,0,0,-1,0,4.046214432723899356858510,0.00001},
	{0,6,-12,2,0,0,0,0,0,1,0,4.046214432723899356858510,0.00001},
	{0,6,-11,-1,0,0,0,0,-2,1,0,0.741416564378892029019141,0.00002},
	{0,6,-11,-1,0,0,0,0,-2,2,0,1.865116085480605923052622,0.00002},
	{0,6,-11,-1,0,0,0,0,-2,3,0,0.741416564378892029019141,0.00002},
	{0,6,-11,0,-1,0,0,0,-2,1,0,5.806944120971976097678180,0.00003},
	{0,6,-11,0,-1,0,0,0,-2,3,0,2.665351467382183425769426,0.00003},
	{0,6,-11,0,0,0,0,0,-4,3,0,6.150543425620670134890133,0.00001},
	{0,6,-11,0,0,0,0,0,-2,-1,2,5.655310788223335549673720,0.00001},
	{0,6,-11,0,0,0,0,0,-2,0,0,6.257538217420305137750347,0.00001},
	{0,6,-11,0,0,0,0,0,-2,1,0,3.644709990415938793972828,0.00004},
	{0,6,-11,0,0,0,0,0,-2,1,2,5.655310788223335549673720,0.00001},
	{0,6,-11,0,0,0,0,0,-2,2,0,5.813379848055780563242934,0.00006},
	{0,6,-11,0,0,0,0,0,-2,3,0,3.442096986479944664694131,0.00004},
	{0,6,-11,0,0,0,0,0,0,0,0,3.195131850125195516199028,0.00002},
	{0,6,-11,0,0,0,0,0,0,2,0,2.962579119134640226462807,0.00002},
	{0,6,-11,0,0,0,0,0,2,-3,0,5.842320548646500633083178,0.00002},
	{0,6,-11,0,0,0,0,0,2,-2,0,1.009722539629476223410620,0.00001},
	{0,6,-11,0,0,0,0,0,2,-1,0,5.842320548646500633083178,0.00002},
	{0,6,-11,0,0,0,0,0,2,0,0,1.009722539629476223410620,0.00001},
	{0,6,-11,0,1,0,0,0,-2,0,0,0.893098068214888352045477,0.00001},
	{0,6,-11,0,1,0,0,0,-2,1,0,6.011746291388747387429703,0.00003},
	{0,6,-11,0,1,0,0,0,-2,2,0,0.893098068214888352045477,0.00001},
	{0,6,-11,0,1,0,0,0,0,-1,0,0.880287176972324836299322,0.00004},
	{0,6,-11,0,1,0,0,0,0,0,0,0.880451412454937520912779,0.00003},
	{0,6,-11,0,1,0,0,0,0,1,0,0.880287176972324836299322,0.00004},
	{0,6,-11,0,2,0,0,0,-2,1,0,5.095617905562092708748878,0.00003},
	{0,6,-11,0,2,0,0,0,-2,3,0,5.095617905562092708748878,0.00003},
	{0,6,-11,0,3,0,0,0,0,0,0,0.622170433894883356806815,0.00004},
	{0,6,-11,0,3,0,0,0,2,-1,0,0.626591003824334746852287,0.00005},
	{0,6,-11,0,3,0,0,0,2,0,0,0.626591003824334746852287,0.00004},
	{0,6,-11,2,0,0,0,0,-2,1,0,1.664981274549518497352096,0.00001},
	{0,6,-11,2,0,0,0,0,-2,3,0,1.664981274549518497352096,0.00001},
	{0,6,-11,2,0,0,0,0,0,-1,0,1.720902845513893275608552,0.00002},
	{0,6,-11,2,0,0,0,0,0,1,0,1.720902845513893275608552,0.00002},
	{0,6,-11,3,0,0,0,0,0,-1,0,5.037106265987758568769550,0.00001},
	{0,6,-11,3,0,0,0,0,0,1,0,5.037106265987758568769550,0.00001},
	{0,6,-10,-3,0,0,0,0,-2,1,0,1.509704392454413790503054,0.00002},
	{0,6,-10,-3,0,0,0,0,-2,3,0,1.509704392454413790503054,0.00002},
	{0,6,-10,0,-1,0,0,0,-2,0,0,4.434977622426450771797590,0.00004},
	{0,6,-10,0,-1,0,0,0,-2,1,0,4.217171527351846194164864,0.00007},
	{0,6,-10,0,-1,0,0,0,0,-2,2,5.653119352814530707007634,0.00003},
	{0,6,-10,0,0,0,0,0,-4,2,0,0.307453012241116319103185,0.00001},
	{0,6,-10,0,0,0,0,0,-2,-2,0,0.902421442546116892025054,0.00002},
	{0,6,-10,0,0,0,0,0,-2,0,0,1.657591201430724359155988,0.00006},
	{0,6,-10,0,0,0,0,0,-2,0,2,4.045395175173013058156357,0.00003},
	{0,6,-10,0,0,0,0,0,-2,1,0,2.111210128005684527607855,0.00007},
	{0,6,-10,0,0,0,0,0,-2,2,0,1.050734809991614504554036,0.00002},
	{0,6,-10,0,0,0,0,0,-2,3,0,0.961118610619938307237931,0.00003},
	{0,6,-10,0,0,0,0,0,0,-1,0,3.716694175552267331852363,0.00004},
	{0,6,-10,0,0,0,0,0,0,0,0,3.426024772997104506089272,0.00008},
	{0,6,-10,0,0,0,0,0,0,1,0,3.459180443731390219852528,0.00005},
	{0,6,-10,0,0,0,0,0,1,0,-1,2.634017920386979572100472,0.00001},
	{0,6,-10,0,0,0,0,0,2,-1,0,2.653165404011833317099445,0.00010},
	{0,6,-10,0,0,0,0,0,2,0,0,2.732755908561279145629896,0.00007},
	{0,6,-10,0,1,0,0,0,-2,0,0,0.723203879101405933127467,0.00003},
	{0,6,-10,0,1,0,0,0,-2,1,0,0.680678408277788471458791,0.00003},
	{0,6,-10,0,1,0,0,0,-2,3,0,3.822271061867581920523662,0.00003},
	{0,6,-10,0,1,0,0,0,0,-1,0,1.162443037969185022362240,0.00001},
	{0,6,-10,0,1,0,0,0,0,1,0,1.162443037969185022362240,0.00001},
	{0,6,-10,0,2,0,0,0,0,-1,0,5.446205683068697567250638,0.00001},
	{0,6,-10,0,2,0,0,0,0,0,0,6.042518365963584159317179,0.00002},
	{0,6,-10,0,2,0,0,0,0,1,0,5.446205683068697567250638,0.00001},
	{0,6,-10,0,3,0,0,0,-4,1,0,5.115197707242666425031530,0.00001},
	{0,6,-10,0,3,0,0,0,-2,-1,0,5.115197707242666425031530,0.00004},
	{0,6,-10,0,3,0,0,0,-2,0,0,5.114297815480337128235533,0.00039},
	{0,6,-10,0,3,0,0,0,-2,1,0,5.124130651420223614422866,0.00061},
	{0,6,-10,0,3,0,0,0,-2,2,0,5.115207830152327161954418,0.00002},
	{0,6,-10,0,3,0,0,0,0,-2,0,5.073767605057599716644745,0.00005},
	{0,6,-10,0,3,0,0,0,0,-1,0,5.071002828989515265334376,0.00068},
	{0,6,-10,0,3,0,0,0,0,0,0,5.107082624352592858940625,0.00373},
	{0,6,-10,0,3,0,0,0,0,1,0,5.070880132343100754610532,0.00068},
	{0,6,-10,0,3,0,0,0,0,2,0,5.073763590800320244511568,0.00005},
	{0,6,-10,0,3,0,0,0,2,-2,0,5.115040453077060789155439,0.00002},
	{0,6,-10,0,3,0,0,0,2,-1,0,5.124050191741706505865750,0.00060},
	{0,6,-10,0,3,0,0,0,2,0,0,5.114154698481673477772347,0.00038},
	{0,6,-10,0,3,0,0,0,2,1,0,5.115050925052573305151782,0.00004},
	{0,6,-10,0,3,0,0,0,4,-1,0,5.115050925052573305151782,0.00001},
	{0,6,-10,0,4,0,0,0,0,0,0,3.547412247940384677491465,0.00003},
	{0,6,-9,-3,0,0,0,0,-2,0,0,6.201223423775456211615165,0.00001},
	{0,6,-9,-3,0,0,0,0,-2,1,0,6.201223423775456211615165,0.00001},
	{0,6,-9,-3,0,0,0,0,-2,2,0,6.201223423775456211615165,0.00001},
	{0,6,-9,-3,0,0,0,0,-2,3,0,6.201223423775456211615165,0.00001},
	{0,6,-9,-2,0,0,0,0,-2,1,0,3.337319810027894018134020,0.00001},
	{0,6,-9,-2,0,0,0,0,-2,3,0,3.337319810027894018134020,0.00001},
	{0,6,-9,-2,0,0,0,0,0,-1,0,3.333499109762353196373397,0.00002},
	{0,6,-9,-2,0,0,0,0,0,1,0,3.333499109762353196373397,0.00002},
	{0,6,-9,0,-1,0,0,0,-2,0,0,4.112591049506495899379388,0.00001},
	{0,6,-9,0,-1,0,0,0,0,-1,0,0.970998395916702450314517,0.00001},
	{0,6,-9,0,-1,0,0,0,0,1,0,0.970998395916702450314517,0.00001},
	{0,6,-9,0,0,0,0,0,-4,1,0,1.247515098100368868827559,0.00001},
	{0,6,-9,0,0,0,0,0,-4,2,0,2.143710078539996288782277,0.00002},
	{0,6,-9,0,0,0,0,0,-2,-1,0,1.201496525311810170677518,0.00004},
	{0,6,-9,0,0,0,0,0,-2,0,0,1.245964373059971874724283,0.00038},
	{0,6,-9,0,0,0,0,0,-2,1,0,1.252121894661007761584415,0.00047},
	{0,6,-9,0,0,0,0,0,-2,2,0,1.001530662252315684312975,0.00002},
	{0,6,-9,0,0,0,0,0,-1,-1,1,4.303141908449031660666151,0.00006},
	{0,6,-9,0,0,0,0,0,-1,0,0,4.364214644167742740421545,0.00003},
	{0,6,-9,0,0,0,0,0,0,-2,0,1.124152957641382233333616,0.00002},
	{0,6,-9,0,0,0,0,0,0,-1,0,1.181655796908063660310972,0.00048},
	{0,6,-9,0,0,0,0,0,0,0,0,1.242252232273905132586833,0.00254},
	{0,6,-9,0,0,0,0,0,0,1,0,1.238970140615529791361382,0.00041},
	{0,6,-9,0,0,0,0,0,0,2,0,1.245389810670215480215006,0.00003},
	{0,6,-9,0,0,0,0,0,1,-2,1,4.287730302088071709931683,0.00014},
	{0,6,-9,0,0,0,0,0,1,-1,-1,1.159828709282622494214365,0.00002},
	{0,6,-9,0,0,0,0,0,1,-1,0,1.210978899137895137272380,0.00003},
	{0,6,-9,0,0,0,0,0,1,-1,1,1.161963072424886611599959,0.00029},
	{0,6,-9,0,0,0,0,0,1,0,-1,1.165103094282149420735095,0.00021},
	{0,6,-9,0,0,0,0,0,1,0,0,1.222621466979173954214843,0.00015},
	{0,6,-9,0,0,0,0,0,1,0,1,4.325373737928010164921488,0.00001},
	{0,6,-9,0,0,0,0,0,1,1,-1,1.159828709282622494214365,0.00002},
	{0,6,-9,0,0,0,0,0,2,-2,0,4.667104667612444579560815,0.00006},
	{0,6,-9,0,0,0,0,0,2,-1,0,4.635040874858207260444942,0.00063},
	{0,6,-9,0,0,0,0,0,2,0,0,4.645916545026159027997892,0.00009},
	{0,6,-9,0,0,0,0,0,4,-3,0,4.700825475958526844522112,0.00004},
	{0,6,-9,0,0,0,0,0,4,-2,0,4.714140243756141046560515,0.00010},
	{0,6,-9,0,0,0,0,0,4,-1,0,4.715523591721271223775602,0.00005},
	{0,6,-9,0,2,0,0,0,0,0,0,4.729843320102184556219527,0.00003},
	{0,6,-9,0,2,0,0,0,2,-2,0,4.730640062905719034347385,0.00001},
	{0,6,-9,0,2,0,0,0,2,0,0,4.730640062905719034347385,0.00001},
	{0,6,-9,0,3,0,0,0,-2,0,0,3.101550786291763728286242,0.00002},
	{0,6,-9,0,3,0,0,0,0,0,0,0.380000240594138616323505,0.00002},
	{0,6,-9,2,0,0,0,0,0,0,0,1.619453139280770059826864,0.00001},
	{0,6,-9,2,0,0,0,0,2,-3,0,0.026610860572232344911647,0.00003},
	{0,6,-9,2,0,0,0,0,2,-1,0,0.026610860572232344911647,0.00003},
	{0,6,-8,0,-2,0,0,0,-2,0,0,0.904543239317766367690865,0.00001},
	{0,6,-8,0,-2,0,0,0,-2,2,0,4.046135892907559927778038,0.00001},
	{0,6,-8,0,0,0,0,0,-2,-2,0,6.058719908343996429778144,0.00002},
	{0,6,-8,0,0,0,0,0,-2,-1,0,6.123331648186977282932730,0.00010},
	{0,6,-8,0,0,0,0,0,-2,0,0,5.384095000043826573232764,0.00005},
	{0,6,-8,0,0,0,0,0,-2,1,0,3.013850434840001479841476,0.00025},
	{0,6,-8,0,0,0,0,0,-2,2,0,5.853315424802363331480137,0.00001},
	{0,6,-8,0,0,0,0,0,-1,0,-1,2.942850964467647933986427,0.00002},
	{0,6,-8,0,0,0,0,0,-1,0,1,6.239411053276167073988745,0.00006},
	{0,6,-8,0,0,0,0,0,-1,1,-1,3.683012288048505666893107,0.00002},
	{0,6,-8,0,0,0,0,0,0,-2,0,6.082593918116177000854350,0.00032},
	{0,6,-8,0,0,0,0,0,0,-1,-2,2.918990742796558013338881,0.00003},
	{0,6,-8,0,0,0,0,0,0,-1,0,6.058557767256487203155757,0.01441},
	{0,6,-8,0,0,0,0,0,0,0,0,5.984260846328339766841964,0.00262},
	{0,6,-8,0,0,0,0,0,0,1,0,6.009667953315473098996335,0.00035},
	{0,6,-8,0,0,0,0,0,0,2,0,5.992621497044169132095703,0.00001},
	{0,6,-8,0,0,0,0,0,1,-2,0,6.059931864976582538417915,0.00002},
	{0,6,-8,0,0,0,0,0,1,-1,-1,2.949363660571464151871623,0.00010},
	{0,6,-8,0,0,0,0,0,1,-1,0,2.900557098835770286626712,0.00008},
	{0,6,-8,0,0,0,0,0,1,-1,1,6.090994711404801975618284,0.00006},
	{0,6,-8,0,0,0,0,0,1,0,-1,2.951173217939932147402260,0.00082},
	{0,6,-8,0,0,0,0,0,1,0,0,2.831320760073781084287248,0.00009},
	{0,6,-8,0,0,0,0,0,1,0,1,6.094126006615804946875414,0.00008},
	{0,6,-8,0,0,0,0,0,1,1,-1,2.949363660571464151871623,0.00010},
	{0,6,-8,0,0,0,0,0,2,-4,0,2.947514658761901440442443,0.00013},
	{0,6,-8,0,0,0,0,0,2,-3,-2,6.065830379716621756358563,0.00002},
	{0,6,-8,0,0,0,0,0,2,-3,0,2.947770873096094756959928,0.00192},
	{0,6,-8,0,0,0,0,0,2,-2,-2,6.058068376934227394770005,0.00004},
	{0,6,-8,0,0,0,0,0,2,-2,0,2.916913975519610069397913,0.05946},
	{0,6,-8,0,0,0,0,0,2,-2,2,6.058634212677723951401276,0.00007},
	{0,6,-8,0,0,0,0,0,2,-1,-2,2.918998073179416952172005,0.00013},
	{0,6,-8,0,0,0,0,0,2,-1,-1,3.022465554560770595315944,0.00001},
	{0,6,-8,0,0,0,0,0,2,-1,0,2.918585302811320225657710,0.07667},
	{0,6,-8,0,0,0,0,0,2,-1,2,6.060342890015427030903084,0.00017},
	{0,6,-8,0,0,0,0,0,2,0,-2,2.952906155354237505150650,0.00006},
	{0,6,-8,0,0,0,0,0,2,0,-1,2.951381959318470915576427,0.00007},
	{0,6,-8,0,0,0,0,0,2,0,0,2.922393785772097185571283,0.00558},
	{0,6,-8,0,0,0,0,0,2,0,2,6.060589505038733726394184,0.00003},
	{0,6,-8,0,0,0,0,0,2,1,0,2.918499432612122301833324,0.00041},
	{0,6,-8,0,0,0,0,0,2,2,0,2.919755720607707605296355,0.00003},
	{0,6,-8,0,0,0,0,0,3,-2,0,6.058235055877793762135752,0.00002},
	{0,6,-8,0,0,0,0,0,3,-1,0,6.060578509464446206322918,0.00003},
	{0,6,-8,0,0,0,0,0,4,-4,0,2.872845284571379664839696,0.00003},
	{0,6,-8,0,0,0,0,0,4,-3,0,2.903976896972127352825055,0.00093},
	{0,6,-8,0,0,0,0,0,4,-2,0,2.917582436623123776087141,0.00166},
	{0,6,-8,0,0,0,0,0,4,-1,-2,6.060586712511930151947581,0.00002},
	{0,6,-8,0,0,0,0,0,4,-1,0,2.919358832735804210045671,0.00080},
	{0,6,-8,0,0,0,0,0,4,0,0,2.923873824977788249412924,0.00013},
	{0,6,-8,0,0,0,0,0,6,-4,0,2.904172373848350918734695,0.00001},
	{0,6,-8,0,0,0,0,0,6,-3,0,2.914317798257268332662306,0.00003},
	{0,6,-8,0,0,0,0,0,6,-2,0,2.918162584066486875400415,0.00002},
	{0,6,-8,0,0,0,1,0,2,-2,0,1.672248301956047455973930,0.00001},
	{0,6,-8,0,0,1,0,0,2,-3,0,5.281360556948309969982347,0.00001},
	{0,6,-8,0,0,1,0,0,2,-2,0,1.497468936266232786280739,0.00007},
	{0,6,-8,0,0,1,0,0,2,-1,0,2.139767903358516409895174,0.00001},
	{0,6,-8,0,1,0,0,0,0,-1,0,1.120973316810098818763208,0.00003},
	{0,6,-8,0,1,0,0,0,0,0,0,1.592684675477082700822962,0.00001},
	{0,6,-8,0,1,0,0,0,2,-2,0,0.376201356944247722324803,0.00003},
	{0,6,-8,0,1,0,0,0,2,-1,0,4.262564748669415592985388,0.00013},
	{0,6,-8,0,2,0,0,0,-2,0,0,3.139706825333013373580116,0.00001},
	{0,6,-8,0,2,0,0,0,-2,2,0,6.281299478922806933667289,0.00001},
	{0,6,-8,0,2,0,0,0,0,-1,0,6.280946747880978620059977,0.00001},
	{0,6,-8,0,2,0,0,0,0,1,0,6.280946747880978620059977,0.00001},
	{0,6,-8,0,2,0,0,0,2,-1,0,6.235852326931350830818701,0.00003},
	{0,6,-8,0,2,0,0,0,2,0,0,6.280754412597408631313556,0.00002},
	{0,6,-8,0,3,0,0,0,2,-3,0,2.952593392352280243784435,0.00001},
	{0,6,-8,0,3,0,0,0,2,-2,0,6.110754805597105487890985,0.00001},
	{0,6,-8,0,3,0,0,0,2,-1,0,2.952593392352280243784435,0.00001},
	{0,6,-8,0,3,0,0,0,2,0,0,2.969162152007312815982232,0.00001},
	{0,6,-8,0,4,0,0,0,2,0,-2,5.957526416445066530513941,0.00002},
	{0,6,-8,2,0,0,0,0,2,-2,0,0.002988527278189890331456,0.00002},
	{0,6,-8,2,0,0,0,0,2,0,0,6.177313460220685392698670,0.00002},
	{0,6,-7,-2,0,0,0,0,2,-3,0,5.396950222649389949935994,0.00001},
	{0,6,-7,-2,0,0,0,0,2,-1,0,5.396950222649389949935994,0.00001},
	{0,6,-7,0,-1,0,0,0,-2,0,0,1.822996054642226804176630,0.00002},
	{0,6,-7,0,-1,0,0,0,0,0,0,4.607391543381037735116479,0.00001},
	{0,6,-7,0,-1,0,0,0,2,-3,0,1.743336260521477276697055,0.00001},
	{0,6,-7,0,-1,0,0,0,2,-1,0,4.884928914111270614739624,0.00001},
	{0,6,-7,0,0,0,0,0,-2,-1,0,1.731337994578642014431580,0.00002},
	{0,6,-7,0,0,0,0,0,-2,0,0,1.569886835721682416533440,0.00020},
	{0,6,-7,0,0,0,0,0,-2,1,0,1.544071496222508832474318,0.00032},
	{0,6,-7,0,0,0,0,0,-2,2,0,4.953608667374798990579166,0.00002},
	{0,6,-7,0,0,0,0,0,-1,0,-1,1.330880924354803207521059,0.00011},
	{0,6,-7,0,0,0,0,0,-1,0,0,1.600507066651595922124329,0.00001},
	{0,6,-7,0,0,0,0,0,-1,0,1,4.472186296749717904219779,0.00023},
	{0,6,-7,0,0,0,0,0,-1,1,-1,1.331335408092022554171763,0.00006},
	{0,6,-7,0,0,0,0,0,-1,1,1,4.472701867010757226239548,0.00003},
	{0,6,-7,0,0,0,0,0,0,-2,0,1.635312771660717423571896,0.00004},
	{0,6,-7,0,0,0,0,0,0,-1,0,2.528443826598468557875776,0.00037},
	{0,6,-7,0,0,0,0,0,0,0,0,4.733455628055036612522599,0.00395},
	{0,6,-7,0,0,0,0,0,0,1,0,4.739403361079983945103322,0.00077},
	{0,6,-7,0,0,0,0,0,0,2,0,4.725691879943390460994124,0.00004},
	{0,6,-7,0,0,0,0,0,1,-2,0,4.767624113354255399599424,0.00003},
	{0,6,-7,0,0,0,0,0,1,-1,-1,1.330886858474259915041671,0.00037},
	{0,6,-7,0,0,0,0,0,1,-1,0,1.603277253240361410746573,0.00002},
	{0,6,-7,0,0,0,0,0,1,-1,1,4.516814714789063600619556,0.00016},
	{0,6,-7,0,0,0,0,0,1,0,-1,1.331027532011970659908684,0.00160},
	{0,6,-7,0,0,0,0,0,1,0,0,1.596229090122032623355608,0.00011},
	{0,6,-7,0,0,0,0,0,1,0,1,4.461393878787085931492129,0.00010},
	{0,6,-7,0,0,0,0,0,1,1,-1,1.331238367785611664828593,0.00018},
	{0,6,-7,0,0,0,0,0,1,1,1,4.467963298091592427851992,0.00001},
	{0,6,-7,0,0,0,0,0,1,2,1,1.331618675029621279293224,0.00002},
	{0,6,-7,0,0,0,0,0,2,-2,0,4.550765033931781999854138,0.00020},
	{0,6,-7,0,0,0,0,0,2,-1,-2,4.751937443103180669368157,0.00002},
	{0,6,-7,0,0,0,0,0,2,-1,-1,4.583000392551491941617314,0.00001},
	{0,6,-7,0,0,0,0,0,2,-1,0,4.726112504293120686327256,0.00811},
	{0,6,-7,0,0,0,0,0,2,0,-2,4.751937443103180669368157,0.00031},
	{0,6,-7,0,0,0,0,0,2,0,-1,4.472392943733153991558993,0.00008},
	{0,6,-7,0,0,0,0,0,2,0,0,1.646233994922146726125334,0.00140},
	{0,6,-7,0,0,0,0,0,2,1,-2,4.751937443103180669368157,0.00002},
	{0,6,-7,0,0,0,0,0,2,1,0,1.644374172071221495983195,0.00019},
	{0,6,-7,0,0,0,0,0,2,2,0,1.573372956369615938143625,0.00004},
	{0,6,-7,0,0,0,0,0,3,-3,-1,4.473003459905502410265399,0.00001},
	{0,6,-7,0,0,0,0,0,3,-3,0,4.755029293873088036548324,0.00002},
	{0,6,-7,0,0,0,0,0,3,-2,-1,4.471844212216327107967118,0.00021},
	{0,6,-7,0,0,0,0,0,3,-2,0,1.611660418703540598173163,0.00012},
	{0,6,-7,0,0,0,0,0,3,-1,-1,4.471860443778370886036555,0.00076},
	{0,6,-7,0,0,0,0,0,3,0,-1,4.470342007329136002624637,0.00002},
	{0,6,-7,0,0,0,0,0,3,0,0,1.613422328583428821957568,0.00002},
	{0,6,-7,0,0,0,0,0,4,-2,0,4.749778819884314273735981,0.00013},
	{0,6,-7,0,0,0,0,0,4,-1,0,4.791754337460628399014695,0.00007},
	{0,6,-7,0,0,0,0,0,4,0,0,1.727049022474791195591592,0.00007},
	{0,6,-7,0,0,0,0,0,4,1,0,1.615921291006434445947093,0.00001},
	{0,6,-7,0,1,0,0,0,-2,0,0,3.366675724447663053950919,0.00009},
	{0,6,-7,0,1,0,0,0,0,-2,0,6.262888698775219253889190,0.00002},
	{0,6,-7,0,1,0,0,0,0,-1,0,3.118875971644610611832604,0.00001},
	{0,6,-7,0,1,0,0,0,0,0,0,6.129660386587633347232895,0.00003},
	{0,6,-7,0,1,0,0,0,0,1,0,3.118875971644610611832604,0.00001},
	{0,6,-7,0,1,0,0,0,2,-2,0,3.117433282484912027143764,0.00002},
	{0,6,-7,0,1,0,0,0,2,0,0,3.117433282484912027143764,0.00002},
	{0,6,-7,0,2,0,0,0,2,-2,0,1.050439674815102364391350,0.00002},
	{0,6,-7,0,2,0,0,0,2,0,0,1.050439674815102364391350,0.00002},
	{0,6,-7,2,0,0,0,0,2,-2,0,0.761813180149398472273958,0.00001},
	{0,6,-7,2,0,0,0,0,2,0,0,0.761813180149398472273958,0.00001},
	{0,6,-7,3,0,0,0,0,-2,0,0,4.126177565068645414214643,0.00002},
	{0,6,-7,3,0,0,0,0,-2,2,0,4.126177565068645414214643,0.00002},
	{0,6,-6,-7,0,0,0,0,0,-1,0,2.516912610763467395003090,0.00001},
	{0,6,-6,-7,0,0,0,0,0,1,0,2.516912610763467395003090,0.00001},
	{0,6,-6,0,-2,0,0,0,-2,0,0,3.585443845005967133943159,0.00001},
	{0,6,-6,0,-1,0,0,0,-2,0,0,3.295041652359284256590399,0.00008},
	{0,6,-6,0,-1,0,0,0,-2,2,0,3.238413921179552623641484,0.00001},
	{0,6,-6,0,-1,0,0,0,0,-2,0,3.369316407605930319135723,0.00001},
	{0,6,-6,0,-1,0,0,0,0,0,0,0.227723754016137341915638,0.00001},
	{0,6,-6,0,-1,0,0,0,2,0,0,0.098603772354821248025125,0.00003},
	{0,6,-6,0,0,0,0,0,-4,2,0,5.962380875226563681223979,0.00001},
	{0,6,-6,0,0,0,0,0,-2,-1,0,3.115492650889619685727894,0.00001},
	{0,6,-6,0,0,0,0,0,-2,0,0,6.081846568130472974189615,0.00004},
	{0,6,-6,0,0,0,0,0,-2,0,2,6.277830986100318533260634,0.00001},
	{0,6,-6,0,0,0,0,0,-2,1,0,6.137294805801707830994474,0.00005},
	{0,6,-6,0,0,0,0,0,-2,2,0,6.229330031516647103728701,0.00010},
	{0,6,-6,0,0,0,0,0,-2,3,0,0.003662922501160499264006,0.00002},
	{0,6,-6,0,0,0,0,0,-1,0,0,6.282867831788648160795674,0.00018},
	{0,6,-6,0,0,0,0,0,-1,0,1,0.232564773762394011447086,0.00003},
	{0,6,-6,0,0,0,0,0,-1,1,0,0.007334920714431369948016,0.00003},
	{0,6,-6,0,0,0,0,0,0,-1,0,6.274837746433147955826826,0.00008},
	{0,6,-6,0,0,0,0,0,0,0,-2,3.138382644029525270212844,0.00001},
	{0,6,-6,0,0,0,0,0,0,0,0,3.141970517372850046911026,0.02263},
	{0,6,-6,0,0,0,0,0,0,0,2,0.001524894167467445889319,0.00002},
	{0,6,-6,0,0,0,0,0,0,1,-2,3.141846249930108303516363,0.00002},
	{0,6,-6,0,0,0,0,0,0,1,0,3.142145748429750362618051,0.00369},
	{0,6,-6,0,0,0,0,0,0,2,0,3.141484443176169261136010,0.00031},
	{0,6,-6,0,0,0,0,0,0,3,0,3.141252663451505000580255,0.00002},
	{0,6,-6,0,0,0,0,0,1,-1,-1,3.322884366317574222904341,0.00001},
	{0,6,-6,0,0,0,0,0,1,-1,0,0.000232477856365644687574,0.00005},
	{0,6,-6,0,0,0,0,0,1,0,-1,3.322884366317574222904341,0.00021},
	{0,6,-6,0,0,0,0,0,1,0,0,0.000365646478292812055887,0.00041},
	{0,6,-6,0,0,0,0,0,1,1,-1,3.322884366317574222904341,0.00001},
	{0,6,-6,0,0,0,0,0,1,1,0,6.282496251190898384209049,0.00001},
	{0,6,-6,0,0,0,0,0,2,-3,0,0.028568596394194383653042,0.00004},
	{0,6,-6,0,0,0,0,0,2,-2,0,3.142173848230707111639504,0.00080},
	{0,6,-6,0,0,0,0,0,2,-1,-2,3.141849042456910989784546,0.00003},
	{0,6,-6,0,0,0,0,0,2,-1,0,3.142390967189655270885851,0.02116},
	{0,6,-6,0,0,0,0,0,2,-1,2,0.000392524548773524721307,0.00004},
	{0,6,-6,0,0,0,0,0,2,0,-2,3.142210674677924586717381,0.00067},
	{0,6,-6,0,0,0,0,0,2,0,0,0.001148601180737468139756,0.00848},
	{0,6,-6,0,0,0,0,0,2,0,2,3.142015372334626466255258,0.00003},
	{0,6,-6,0,0,0,0,0,2,1,-2,0.000521155314645506840404,0.00003},
	{0,6,-6,0,0,0,0,0,2,1,0,0.000528311164578683530556,0.00070},
	{0,6,-6,0,0,0,0,0,2,2,0,0.000247836753783194801461,0.00009},
	{0,6,-6,0,0,0,0,0,3,-2,0,0.001157676892847838692399,0.00005},
	{0,6,-6,0,0,0,0,0,3,-1,0,3.142742301968081797269861,0.00001},
	{0,6,-6,0,0,0,0,0,3,0,-2,0.001190838148635730946168,0.00003},
	{0,6,-6,0,0,0,0,0,3,0,0,0.001385093294382699858833,0.00003},
	{0,6,-6,0,0,0,0,0,3,1,0,0.001146506785635075052060,0.00001},
	{0,6,-6,0,0,0,0,0,4,-3,0,3.151655174859241181906100,0.00003},
	{0,6,-6,0,0,0,0,0,4,-2,0,3.141906987388077610034998,0.00030},
	{0,6,-6,0,0,0,0,0,4,-1,-2,3.142170183039278086312152,0.00001},
	{0,6,-6,0,0,0,0,0,4,-1,0,3.141506783390595192173578,0.00004},
	{0,6,-6,0,0,0,0,0,4,0,0,0.000438252175175776151773,0.00010},
	{0,6,-6,0,0,0,0,0,4,1,0,0.000494102711239594624519,0.00004},
	{0,6,-6,0,1,0,0,0,-2,0,0,6.039871050554159737089321,0.00005},
	{0,6,-6,0,1,0,0,0,0,0,0,2.892366094123235420454421,0.00003},
	{0,6,-6,0,1,0,0,0,2,0,0,2.898133011037675288434912,0.00002},
	{0,6,-5,-2,0,0,0,0,2,-2,0,2.434151715627774326122790,0.00001},
	{0,6,-5,-2,0,0,0,0,2,0,0,2.434151715627774326122790,0.00001},
	{0,6,-5,0,-2,0,0,0,0,0,0,4.831411708724442810591881,0.00002},
	{0,6,-5,0,-1,0,0,0,-2,-2,0,0.022171615619784767331479,0.00001},
	{0,6,-5,0,-1,0,0,0,-2,2,0,3.118356561659216819037965,0.00001},
	{0,6,-5,0,-1,0,0,0,0,0,0,3.167889354896666453953458,0.00008},
	{0,6,-5,0,-1,0,0,0,2,-3,0,3.126008783231660981272171,0.00001},
	{0,6,-5,0,-1,0,0,0,2,-2,0,0.067830476049507620883716,0.00002},
	{0,6,-5,0,-1,0,0,0,2,-1,0,6.267601436821453653180924,0.00001},
	{0,6,-5,0,-1,0,0,0,2,0,0,0.034441629327155304229890,0.00003},
	{0,6,-5,0,0,-1,0,0,-2,0,0,3.145204961542646060479456,0.00001},
	{0,6,-5,0,0,-1,0,0,-2,2,0,0.003612307952852663456289,0.00001},
	{0,6,-5,0,0,0,0,0,-3,0,1,1.802564706819605566678888,0.00002},
	{0,6,-5,0,0,0,0,0,-2,0,0,2.059579449007337803578821,0.00003},
	{0,6,-5,0,0,0,0,0,-2,1,0,4.399148979942736126247382,0.00008},
	{0,6,-5,0,0,0,0,0,-2,2,0,4.813647398531793797360478,0.00003},
	{0,6,-5,0,0,0,0,0,-1,-1,-1,1.802642897570094770998139,0.00003},
	{0,6,-5,0,0,0,0,0,-1,-1,1,4.942335934802017050060385,0.00001},
	{0,6,-5,0,0,0,0,0,-1,0,-1,1.802594901015665218579898,0.00023},
	{0,6,-5,0,0,0,0,0,-1,0,1,4.944095401220953256427038,0.00029},
	{0,6,-5,0,0,0,0,0,-1,1,-1,1.802666634047922045169798,0.00009},
	{0,6,-5,0,0,0,0,0,0,-2,0,4.400093726666840510119982,0.00002},
	{0,6,-5,0,0,0,0,0,0,-1,0,4.310206652195254228843169,0.00008},
	{0,6,-5,0,0,0,0,0,0,0,-1,4.944532082599801370292880,0.00001},
	{0,6,-5,0,0,0,0,0,0,0,0,1.631589111701587491154442,0.00013},
	{0,6,-5,0,0,0,0,0,0,1,0,1.280229724132675883652155,0.00003},
	{0,6,-5,0,0,0,0,0,1,-1,-1,1.803209431445292221241061,0.00017},
	{0,6,-5,0,0,0,0,0,1,-1,1,4.944898601742720778418061,0.00008},
	{0,6,-5,0,0,0,0,0,1,0,-1,1.803343472731845587020416,0.00106},
	{0,6,-5,0,0,0,0,0,1,0,1,4.944818840195904563472595,0.00004},
	{0,6,-5,0,0,0,0,0,1,1,-1,1.803274008627616220579171,0.00011},
	{0,6,-5,0,0,0,0,0,1,1,1,1.803300188566395956257793,0.00001},
	{0,6,-5,0,0,0,0,0,2,-2,0,4.393902694744165948748105,0.00003},
	{0,6,-5,0,0,0,0,0,2,-1,0,4.655940669052063718424961,0.00039},
	{0,6,-5,0,0,0,0,0,2,0,-2,4.536097461430947497262878,0.00001},
	{0,6,-5,0,0,0,0,0,2,0,-1,4.945430054499952987612232,0.00002},
	{0,6,-5,0,0,0,0,0,2,0,0,1.523366306240249823389377,0.00033},
	{0,6,-5,0,0,0,0,0,2,1,0,1.467216271676788919009482,0.00006},
	{0,6,-5,0,0,0,0,0,2,2,0,1.350452522987892090000628,0.00001},
	{0,6,-5,0,0,0,0,0,3,-1,-1,1.744259365162857067232949,0.00003},
	{0,6,-5,0,0,0,0,0,3,0,-1,1.803329335564904267741326,0.00002},
	{0,6,-5,0,0,0,0,0,4,-2,0,1.273481234046914600810396,0.00001},
	{0,6,-5,0,0,0,0,0,4,-1,0,1.503184715033589080590559,0.00002},
	{0,6,-5,0,0,0,0,0,4,0,0,1.423592814220742130970621,0.00002},
	{0,6,-5,0,1,0,0,0,2,-2,0,2.646971230496505622653558,0.00001},
	{0,6,-5,0,1,0,0,0,2,0,0,5.788563884086299182740731,0.00001},
	{0,6,-4,-3,0,0,0,0,-2,0,0,5.868113896997098066776744,0.00001},
	{0,6,-4,-3,0,0,0,0,-2,2,0,5.868113896997098066776744,0.00001},
	{0,6,-4,-2,0,0,0,0,-2,0,0,0.010342646614393196519144,0.00001},
	{0,6,-4,-2,0,0,0,0,-2,1,0,3.136090677655806402412964,0.00003},
	{0,6,-4,-2,0,0,0,0,-2,2,0,0.010342646614393196519144,0.00001},
	{0,6,-4,-2,0,0,0,0,0,-2,0,3.139593902530409152973334,0.00001},
	{0,6,-4,0,-3,0,0,0,-2,0,0,0.135779634488150863225187,0.00001},
	{0,6,-4,0,-3,0,0,0,-2,2,0,0.135779634488150863225187,0.00001},
	{0,6,-4,0,-2,0,0,0,-2,0,0,0.005314702105247932906185,0.00002},
	{0,6,-4,0,-2,0,0,0,-2,1,0,0.002582563694176009169018,0.00004},
	{0,6,-4,0,-2,0,0,0,-2,2,0,0.005314702105247932906185,0.00002},
	{0,6,-4,0,-2,0,0,0,-2,3,0,0.001693667506135297347661,0.00001},
	{0,6,-4,0,-2,0,0,0,0,-2,0,6.278769798704965765523411,0.00002},
	{0,6,-4,0,0,0,0,0,-2,-1,0,0.483152340979657091146748,0.00003},
	{0,6,-4,0,0,0,0,0,-2,0,0,0.487432237371397569791753,0.00026},
	{0,6,-4,0,0,0,0,0,-2,1,0,0.445208359442524737037417,0.00015},
	{0,6,-4,0,0,0,0,0,-2,2,0,0.434059545246635369863952,0.00002},
	{0,6,-4,0,0,0,0,0,-1,0,0,3.591842396576703677624209,0.00002},
	{0,6,-4,0,0,0,0,0,-1,0,1,3.216571125590843571728783,0.00001},
	{0,6,-4,0,0,0,0,0,0,-1,0,0.450361094993187605073359,0.00017},
	{0,6,-4,0,0,0,0,0,0,0,0,0.456351239518957341179117,0.00097},
	{0,6,-4,0,0,0,0,0,0,1,0,0.453314715686337632583047,0.00009},
	{0,6,-4,0,0,0,0,0,1,0,-1,0.057678070323581812073321,0.00001},
	{0,6,-4,0,0,0,0,0,1,0,0,3.602189581047152255877108,0.00002},
	{0,6,-4,0,0,0,0,0,2,-2,0,5.795321100818320303460496,0.00003},
	{0,6,-4,0,0,0,0,0,2,-1,0,0.503974642554725016374562,0.00015},
	{0,6,-4,0,0,0,0,0,2,0,0,3.823549864610518156382568,0.00011},
	{0,6,-3,0,-3,0,0,0,-2,0,0,6.225307047590801445835496,0.00001},
	{0,6,-3,0,-3,0,0,0,-2,2,0,3.083714394001007441659112,0.00001},
	{0,6,-3,0,0,0,0,0,-2,1,0,4.894112662102338973113547,0.00002},
	{0,6,-3,0,0,0,0,0,0,0,0,5.049295121884910919618505,0.00007},
	{0,6,-3,0,0,0,0,0,1,0,-1,5.387937516925016545599192,0.00001},
	{0,6,-3,0,1,0,0,0,2,0,0,2.188357869734038452236291,0.00003},
	{0,6,-2,0,-1,0,0,0,2,-2,0,3.852591794297853144968258,0.00001},
	{0,6,-2,0,-1,0,0,0,2,0,0,2.649449248968487324873422,0.00008},
	{0,6,-2,0,0,0,0,0,0,-1,0,2.238200284380791771354779,0.00003},
	{0,6,-2,0,0,0,0,0,0,0,0,2.781558979638469875084184,0.00001},
	{0,6,-2,0,0,0,0,0,0,1,0,2.238200284380791771354779,0.00003},
	{0,6,-2,0,0,0,0,0,0,2,0,3.212096275921655141871724,0.00001},
	{0,6,-2,0,0,0,0,0,2,-2,0,2.231143394616203146085809,0.00001},
	{0,6,-2,0,0,0,0,0,2,0,0,2.235521902110681580211349,0.00003},
	{0,6,-2,0,0,0,0,0,2,2,0,2.237726252955949846068506,0.00002},
	{0,6,-2,0,0,0,0,0,4,0,0,5.375761227398477615224692,0.00002},
	{0,6,-2,0,1,0,0,0,2,0,0,5.214592113748640400672230,0.00008},
	{0,6,-1,0,-1,0,0,0,0,0,0,2.260596349342383071245877,0.00002},
	{0,6,-1,0,0,0,0,0,-2,0,0,5.271473790334537667945369,0.00004},
	{0,6,-1,0,0,0,0,0,-2,2,0,5.271473790334537667945369,0.00004},
	{0,6,-1,0,0,0,0,0,0,0,0,1.386170511597030641226524,0.00001},
	{0,6,-1,0,0,0,0,0,2,-2,0,3.787086620410777815237680,0.00004},
	{0,6,-1,0,0,0,0,0,2,0,0,3.787086620410777815237680,0.00004},
	{0,6,0,-15,0,0,0,0,2,-3,0,5.652264665079829164540115,0.00001},
	{0,6,0,-15,0,0,0,0,2,-1,0,5.652264665079829164540115,0.00001},
	{0,6,0,-2,0,0,0,0,2,-2,0,5.380860381341104670127606,0.00002},
	{0,6,0,-2,0,0,0,0,2,0,0,5.379833953208007280011316,0.00003},
	{0,6,0,0,0,0,0,0,2,0,0,5.709564871620353976311435,0.00001},
	{0,6,4,0,-6,0,0,0,0,-1,0,2.167314958541518343793086,0.00002},
	{0,7,-42,36,0,0,0,0,2,-1,0,5.346600440789082142600819,0.00001},
	{0,7,-19,11,0,0,0,0,-2,1,0,2.767330531977436613999544,0.00005},
	{0,7,-19,11,0,0,0,0,-2,2,0,2.319539783373660846166331,0.00007},
	{0,7,-19,11,0,0,0,0,-2,3,0,2.767330531977436613999544,0.00005},
	{0,7,-16,0,0,0,0,0,-2,0,0,5.054730426241471619164258,0.00002},
	{0,7,-16,0,0,0,0,0,-2,2,0,5.054847014235504865098392,0.00001},
	{0,7,-14,0,0,0,0,0,0,0,0,5.328002910411531622969505,0.00002},
	{0,7,-14,0,2,0,0,0,-2,0,0,5.634760408945727938601067,0.00002},
	{0,7,-14,0,2,0,0,0,-2,1,0,5.636366460923412979866498,0.00002},
	{0,7,-14,0,2,0,0,0,-2,3,0,2.494773807333619863868535,0.00002},
	{0,7,-14,2,0,0,0,0,-2,1,0,5.638444449930838153761670,0.00002},
	{0,7,-14,2,0,0,0,0,-2,3,0,5.638444449930838153761670,0.00002},
	{0,7,-14,5,0,0,0,0,0,-1,0,5.047079600932429244153354,0.00003},
	{0,7,-14,5,0,0,0,0,0,1,0,5.047079600932429244153354,0.00003},
	{0,7,-13,0,-1,0,0,0,-2,1,0,0.907288467698228351387968,0.00007},
	{0,7,-13,0,-1,0,0,0,-2,2,0,4.031429399564404825184738,0.00001},
	{0,7,-13,0,-1,0,0,0,0,1,0,4.048881121288021134319024,0.00002},
	{0,7,-13,0,0,0,0,0,-2,-1,0,3.865559416107246182292556,0.00002},
	{0,7,-13,0,0,0,0,0,-2,0,0,3.839068459654625620203205,0.00002},
	{0,7,-13,0,0,0,0,0,-2,1,0,4.259485638803046647637984,0.00005},
	{0,7,-13,0,0,0,0,0,-2,2,0,3.839068459654625620203205,0.00002},
	{0,7,-13,0,0,0,0,0,-2,3,0,1.761033899136699831800001,0.00002},
	{0,7,-13,0,0,0,0,0,0,0,0,4.680913712654223957088107,0.00002},
	{0,7,-13,0,1,0,0,0,-2,1,0,2.487399093112243164682695,0.00001},
	{0,7,-13,0,1,0,0,0,-2,2,0,2.472689632709359930373694,0.00001},
	{0,7,-13,0,1,0,0,0,-2,3,0,2.487399093112243164682695,0.00001},
	{0,7,-13,0,2,0,0,0,-2,1,0,3.545848607463522927929489,0.00001},
	{0,7,-13,0,2,0,0,0,-2,2,0,0.900202081869280856807336,0.00002},
	{0,7,-13,0,2,0,0,0,-2,3,0,3.545848607463522927929489,0.00001},
	{0,7,-13,0,3,0,0,0,-2,1,0,0.725824490973275504579476,0.00003},
	{0,7,-13,0,3,0,0,0,-2,3,0,0.725824490973275504579476,0.00003},
	{0,7,-13,2,0,0,0,0,-2,0,0,4.079300115755179589882573,0.00005},
	{0,7,-13,2,0,0,0,0,-2,1,0,4.044852552308568327532612,0.00003},
	{0,7,-13,2,0,0,0,0,-2,2,0,4.044852552308568327532612,0.00003},
	{0,7,-13,2,0,0,0,0,-2,3,0,4.044852552308568327532612,0.00003},
	{0,7,-13,2,0,0,0,0,0,-1,0,0.903259898718774989490043,0.00003},
	{0,7,-13,2,0,0,0,0,0,1,0,0.903259898718774989490043,0.00003},
	{0,7,-13,3,0,0,0,0,0,-1,0,0.351812300509804221082533,0.00004},
	{0,7,-13,3,0,0,0,0,0,1,0,0.351812300509804221082533,0.00004},
	{0,7,-12,-2,0,0,0,0,-2,1,0,0.030345516105649807808708,0.00001},
	{0,7,-12,-2,0,0,0,0,-2,3,0,0.030345516105649807808708,0.00001},
	{0,7,-12,0,0,0,0,0,-2,0,0,6.050398003937562663168137,0.00001},
	{0,7,-12,0,0,0,0,0,-2,1,0,6.248129671021580122669548,0.00006},
	{0,7,-12,0,0,0,0,0,-2,2,0,5.833297370946614712750034,0.00004},
	{0,7,-12,0,0,0,0,0,-2,3,0,6.054242091615080312294594,0.00006},
	{0,7,-12,0,0,0,0,0,0,-2,0,3.022535193197925185160102,0.00001},
	{0,7,-12,0,0,0,0,0,0,-1,0,3.590940759485123034977505,0.00002},
	{0,7,-12,0,0,0,0,0,0,0,0,1.355262999472238938380997,0.00003},
	{0,7,-12,0,0,0,0,0,0,1,0,3.364499124337501090309388,0.00003},
	{0,7,-12,0,0,0,0,0,0,2,0,2.490861826348199858927046,0.00001},
	{0,7,-12,0,0,0,0,0,2,-2,0,4.151625163694423470417405,0.00002},
	{0,7,-12,0,0,0,0,0,2,-1,0,4.151754841657846917257757,0.00002},
	{0,7,-12,0,1,0,0,0,0,0,0,0.880270770877356056871577,0.00002},
	{0,7,-12,0,2,0,0,0,-2,1,0,1.953427127637641147472891,0.00003},
	{0,7,-12,0,2,0,0,0,0,-1,0,5.095019781227434485515460,0.00002},
	{0,7,-12,0,2,0,0,0,0,1,0,5.095019781227434485515460,0.00002},
	{0,7,-12,1,0,0,0,0,0,-1,0,4.036006176461909511488102,0.00001},
	{0,7,-12,1,0,0,0,0,0,1,0,4.036006176461909511488102,0.00001},
	{0,7,-12,2,0,0,0,0,-2,0,0,1.664800632971937144333197,0.00002},
	{0,7,-12,2,0,0,0,0,-2,2,0,1.664800632971937144333197,0.00002},
	{0,7,-12,2,0,0,0,0,0,-1,0,1.664800632971937144333197,0.00001},
	{0,7,-12,2,0,0,0,0,0,1,0,1.664800632971937144333197,0.00001},
	{0,7,-11,-4,0,0,0,0,-2,1,0,6.008711861951229415979014,0.00001},
	{0,7,-11,-4,0,0,0,0,-2,3,0,6.008711861951229415979014,0.00001},
	{0,7,-11,0,-1,0,0,0,-2,0,0,4.226717431162703597635755,0.00003},
	{0,7,-11,0,0,0,0,0,-2,0,0,2.546484771477558251007167,0.00006},
	{0,7,-11,0,0,0,0,0,-2,0,2,4.045279285310680705833875,0.00002},
	{0,7,-11,0,0,0,0,0,-2,1,0,2.205637501993408466915980,0.00007},
	{0,7,-11,0,0,0,0,0,-2,2,0,1.065857215295519466735641,0.00001},
	{0,7,-11,0,0,0,0,0,-2,3,0,0.906548448095382708444845,0.00003},
	{0,7,-11,0,0,0,0,0,0,-1,0,2.273842351167468578410080,0.00010},
	{0,7,-11,0,0,0,0,0,0,0,0,2.672333831587711650001893,0.00058},
	{0,7,-11,0,0,0,0,0,0,1,0,2.273842351167468578410080,0.00010},
	{0,7,-11,0,0,0,0,0,1,0,-1,2.646975942885485988398386,0.00002},
	{0,7,-11,0,0,0,0,0,1,0,0,1.027770989424349634688838,0.00002},
	{0,7,-11,0,0,0,0,0,2,-1,0,3.009865150025997859728477,0.00003},
	{0,7,-11,0,0,0,0,0,2,0,0,2.670974743699183751033388,0.00004},
	{0,7,-11,0,1,0,0,0,-2,0,0,0.683324676489662330425290,0.00005},
	{0,7,-11,0,1,0,0,0,-2,1,0,3.816311460603721616990924,0.00003},
	{0,7,-11,0,1,0,0,0,-2,2,0,0.674695070536101559888209,0.00003},
	{0,7,-11,0,1,0,0,0,0,-1,0,0.679290522456602596790276,0.00003},
	{0,7,-11,0,1,0,0,0,0,1,0,0.679290522456602596790276,0.00003},
	{0,7,-10,-2,0,0,0,0,0,-1,0,0.191689860812387619093400,0.00002},
	{0,7,-10,-2,0,0,0,0,0,1,0,0.191689860812387619093400,0.00002},
	{0,7,-10,0,-1,0,0,0,-2,0,0,4.111935154773596501343036,0.00001},
	{0,7,-10,0,0,0,0,0,-4,0,0,2.111541740563563251953383,0.00003},
	{0,7,-10,0,0,0,0,0,-2,0,0,4.565828970705745781799578,0.00008},
	{0,7,-10,0,0,0,0,0,-2,1,0,4.438697791727077124335210,0.00011},
	{0,7,-10,0,0,0,0,0,0,-1,0,1.265753788783709810061850,0.00011},
	{0,7,-10,0,0,0,0,0,0,0,0,0.855650807382873579420846,0.00010},
	{0,7,-10,0,0,0,0,0,0,1,0,4.439193988833419091122323,0.00001},
	{0,7,-10,0,0,0,0,0,0,2,0,1.267762313686904729337357,0.00001},
	{0,7,-10,0,0,0,0,0,1,-1,-1,4.335859676073992474698571,0.00002},
	{0,7,-10,0,0,0,0,0,1,0,-1,4.335859676073992474698571,0.00036},
	{0,7,-10,0,0,0,0,0,1,0,0,4.364875600355473395097761,0.00003},
	{0,7,-10,0,0,0,0,0,1,0,1,1.193449335729639848580064,0.00004},
	{0,7,-10,0,0,0,0,0,1,1,-1,4.335859676073992474698571,0.00002},
	{0,7,-10,0,0,0,0,0,1,2,-3,1.184289847815173546408118,0.00001},
	{0,7,-10,0,0,0,0,0,2,-3,0,0.735119765503546740426088,0.00001},
	{0,7,-10,0,0,0,0,0,2,-2,0,4.442082334212544836304914,0.00006},
	{0,7,-10,0,0,0,0,0,2,-1,0,4.429179289585475132184911,0.00064},
	{0,7,-10,0,0,0,0,0,2,0,0,4.429889114992262122427746,0.00014},
	{0,7,-10,0,1,0,0,0,-2,0,0,0.427207906202081211244348,0.00001},
	{0,7,-10,0,1,0,0,0,-2,2,0,3.568800559791874604798068,0.00001},
	{0,7,-10,0,1,0,0,0,2,-3,0,2.954017581021907368210577,0.00002},
	{0,7,-10,0,1,0,0,0,2,-1,0,2.954017581021907368210577,0.00002},
	{0,7,-10,0,2,0,0,0,2,-3,0,1.592489722199635027166664,0.00001},
	{0,7,-10,0,2,0,0,0,2,-1,0,1.592489722199635027166664,0.00001},
	{0,7,-10,0,2,0,0,0,2,0,0,4.731592314545608246589836,0.00002},
	{0,7,-10,0,3,0,0,0,2,-3,0,1.420907625166548671202804,0.00002},
	{0,7,-10,0,3,0,0,0,2,-1,0,3.736700012103252532824627,0.00006},
	{0,7,-10,0,4,0,0,0,2,-1,0,3.005340383940202197976532,0.00003},
	{0,7,-10,2,0,0,0,0,2,-3,0,4.735284733111126520554990,0.00001},
	{0,7,-10,2,0,0,0,0,2,-1,0,4.735284733111126520554990,0.00001},
	{0,7,-9,0,0,0,0,0,-2,0,0,2.994155092362946302131377,0.00006},
	{0,7,-9,0,0,0,0,0,-2,1,0,2.884088346546876735487785,0.00007},
	{0,7,-9,0,0,0,0,0,-2,2,0,3.935402605850153001654235,0.00001},
	{0,7,-9,0,0,0,0,0,-2,3,0,6.227433033152655283970489,0.00001},
	{0,7,-9,0,0,0,0,0,-1,0,-1,2.937014234383128030714261,0.00001},
	{0,7,-9,0,0,0,0,0,-1,0,1,0.110320691222234770756394,0.00004},
	{0,7,-9,0,0,0,0,0,0,-1,0,2.989366781560099717296453,0.00029},
	{0,7,-9,0,0,0,0,0,0,0,0,5.969091491667557036748804,0.00101},
	{0,7,-9,0,0,0,0,0,0,1,0,6.030904770587889096589151,0.00018},
	{0,7,-9,0,0,0,0,0,1,-3,1,2.948534978242618009858234,0.00002},
	{0,7,-9,0,0,0,0,0,1,-1,-1,2.948294820937543025962668,0.00004},
	{0,7,-9,0,0,0,0,0,1,-1,1,6.090127631832410237677777,0.00002},
	{0,7,-9,0,0,0,0,0,1,0,-1,2.949337829698535085043432,0.00037},
	{0,7,-9,0,0,0,0,0,1,0,0,2.848688880526226707701198,0.00004},
	{0,7,-9,0,0,0,0,0,1,0,1,6.090127108233635233602854,0.00003},
	{0,7,-9,0,0,0,0,0,1,1,-1,2.948294820937543025962668,0.00004},
	{0,7,-9,0,0,0,0,0,2,-3,0,6.131628594385107433595294,0.00006},
	{0,7,-9,0,0,0,0,0,2,-2,0,5.778257016721571659445544,0.00001},
	{0,7,-9,0,0,0,0,0,2,-1,0,6.088575859594462791335445,0.00238},
	{0,7,-9,0,0,0,0,0,2,0,-2,6.110170294830613357817128,0.00015},
	{0,7,-9,0,0,0,0,0,2,0,-1,6.092386960549117880248104,0.00003},
	{0,7,-9,0,0,0,0,0,2,0,0,3.043832224329535485196629,0.00023},
	{0,7,-9,0,0,0,0,0,2,1,0,2.948112608563635106406764,0.00004},
	{0,7,-9,0,0,0,0,0,4,-3,0,2.998342835370181536092105,0.00001},
	{0,7,-9,0,0,0,0,0,4,-2,0,6.071950202205814939304673,0.00004},
	{0,7,-9,0,0,0,0,0,4,0,0,2.962350481002629098981060,0.00003},
	{0,7,-9,0,1,0,0,0,-2,0,0,4.719278667606936927825245,0.00001},
	{0,7,-9,0,1,0,0,0,-2,2,0,1.577686014017144255916492,0.00001},
	{0,7,-9,0,1,0,0,0,0,0,0,1.587726369605092058279183,0.00001},
	{0,7,-9,0,1,0,0,0,2,-3,0,4.710579423016222122555519,0.00002},
	{0,7,-9,0,1,0,0,0,2,-2,0,1.569521538309239794273253,0.00002},
	{0,7,-9,0,1,0,0,0,2,-1,0,4.710579423016222122555519,0.00002},
	{0,7,-9,0,1,0,0,0,2,0,0,1.569521538309239794273253,0.00002},
	{0,7,-9,0,2,0,0,0,-2,0,0,3.139561788472172931818704,0.00001},
	{0,7,-9,0,2,0,0,0,-2,2,0,6.281154442061965603727458,0.00001},
	{0,7,-9,0,2,0,0,0,2,-3,0,3.140243339545075951235731,0.00001},
	{0,7,-9,0,2,0,0,0,2,-1,0,3.140243339545075951235731,0.00001},
	{0,7,-9,0,2,0,0,0,2,0,0,6.280458928355046488434255,0.00003},
	{0,7,-9,0,3,0,0,0,2,-1,0,6.110574338552449802364208,0.00003},
	{0,7,-9,2,0,0,0,0,2,-2,0,0.002780309498426966705736,0.00002},
	{0,7,-9,4,0,0,0,0,0,0,0,1.006069041906276551046062,0.00001},
	{0,7,-8,-3,0,0,0,0,2,-2,0,6.118547351641409726141774,0.00003},
	{0,7,-8,0,-1,0,0,0,-2,0,0,1.823381946939842679356047,0.00002},
	{0,7,-8,0,0,0,0,0,-2,0,0,1.452661621978557970891188,0.00002},
	{0,7,-8,0,0,0,0,0,-2,1,0,1.579994037419981456338292,0.00016},
	{0,7,-8,0,0,0,0,0,-2,2,0,4.801345096233261777740609,0.00001},
	{0,7,-8,0,0,0,0,0,-1,-1,1,1.329088122147154660268598,0.00002},
	{0,7,-8,0,0,0,0,0,-1,0,-1,1.328614439788163403832755,0.00007},
	{0,7,-8,0,0,0,0,0,-1,0,0,1.634934035213034597688875,0.00004},
	{0,7,-8,0,0,0,0,0,-1,0,1,4.469829753193675259126394,0.00014},
	{0,7,-8,0,0,0,0,0,-1,1,-1,1.328888107414876174061646,0.00005},
	{0,7,-8,0,0,0,0,0,0,-1,0,1.564722755530881581620406,0.00025},
	{0,7,-8,0,0,0,0,0,0,0,0,4.742459781666076068518123,0.00303},
	{0,7,-8,0,0,0,0,0,0,1,0,4.744053267273146801130679,0.00059},
	{0,7,-8,0,0,0,0,0,0,2,0,4.740918481403639361815294,0.00004},
	{0,7,-8,0,0,0,0,0,1,-1,-1,1.328969614290944400991634,0.00014},
	{0,7,-8,0,0,0,0,0,1,-1,0,1.604322007330605259767253,0.00001},
	{0,7,-8,0,0,0,0,0,1,-1,1,4.470642203960478511248766,0.00007},
	{0,7,-8,0,0,0,0,0,1,0,-1,1.328980260799381474257075,0.00097},
	{0,7,-8,0,0,0,0,0,1,0,0,1.588115054429511063815994,0.00007},
	{0,7,-8,0,0,0,0,0,1,0,1,4.470151766440668694713167,0.00002},
	{0,7,-8,0,0,0,0,0,1,1,-1,1.328932787843727147958361,0.00010},
	{0,7,-8,0,0,0,0,0,2,-3,0,4.727365650696052412627068,0.00003},
	{0,7,-8,0,0,0,0,0,2,-2,0,4.729106093026142154656100,0.00009},
	{0,7,-8,0,0,0,0,0,2,-1,0,4.747469225685150284732572,0.00422},
	{0,7,-8,0,0,0,0,0,2,0,-2,4.750365075980058193749755,0.00014},
	{0,7,-8,0,0,0,0,0,2,0,-1,4.504934258570738592197813,0.00004},
	{0,7,-8,0,0,0,0,0,2,0,0,1.632066284719082771559329,0.00147},
	{0,7,-8,0,0,0,0,0,2,1,0,1.639316906030642728708813,0.00020},
	{0,7,-8,0,0,0,0,0,2,2,0,1.611716269239604315544057,0.00003},
	{0,7,-8,0,0,0,0,0,3,-1,-1,1.466587080481445148905095,0.00009},
	{0,7,-8,0,0,0,0,0,3,0,-1,1.328970661488495297319901,0.00001},
	{0,7,-8,0,0,0,0,0,3,0,0,1.613316038031982424527655,0.00002},
	{0,7,-8,0,0,0,0,0,4,-2,0,4.773487546976330264669741,0.00007},
	{0,7,-8,0,0,0,0,0,4,-1,0,4.570527920650889974751863,0.00001},
	{0,7,-8,0,0,0,0,0,4,0,0,1.718169310839419816616669,0.00007},
	{0,7,-8,0,0,0,0,0,4,1,0,1.615587758586378264169525,0.00001},
	{0,7,-8,0,1,0,0,0,-2,0,0,3.389614935872474976719104,0.00008},
	{0,7,-8,0,1,0,0,0,0,0,0,0.202187667197283121867102,0.00002},
	{0,7,-8,0,1,0,0,0,2,-2,0,3.116528852866528698228876,0.00001},
	{0,7,-8,0,1,0,0,0,2,0,0,3.118077483511823455586409,0.00004},
	{0,7,-8,0,2,0,0,0,2,0,0,1.050259033237521011372451,0.00003},
	{0,7,-8,0,2,0,0,0,4,-4,0,1.050259033237521011372451,0.00013},
	{0,7,-8,2,0,0,0,0,-2,1,0,0.706785217762044837286339,0.00001},
	{0,7,-8,3,0,0,0,0,-2,0,0,4.125997098023989728687866,0.00002},
	{0,7,-8,3,0,0,0,0,-2,2,0,4.125997098023989728687866,0.00002},
	{0,7,-7,0,-2,0,0,0,0,0,0,3.396230606402159235557292,0.00002},
	{0,7,-7,0,-1,0,0,0,-2,0,0,3.270363569400710268553212,0.00007},
	{0,7,-7,0,-1,0,0,0,-2,2,0,3.238655474748028950671142,0.00001},
	{0,7,-7,0,-1,0,0,0,0,0,0,2.812570862452530739972190,0.00002},
	{0,7,-7,0,-1,0,0,0,2,-1,0,3.293462303919154621212328,0.00003},
	{0,7,-7,0,-1,0,0,0,2,0,0,0.097360748861550883148652,0.00002},
	{0,7,-7,0,0,0,0,0,-4,2,0,3.138125731563631504172918,0.00002},
	{0,7,-7,0,0,0,0,0,-2,-1,0,3.158947160474073534430772,0.00004},
	{0,7,-7,0,0,0,0,0,-2,0,0,3.159708298560868211524166,0.00031},
	{0,7,-7,0,0,0,0,0,-2,1,0,3.156448547116918579291678,0.00023},
	{0,7,-7,0,0,0,0,0,-2,2,0,6.278589855259085084071558,0.00010},
	{0,7,-7,0,0,0,0,0,-2,3,0,6.278949742150846446975265,0.00002},
	{0,7,-7,0,0,0,0,0,-1,0,0,6.282430975876874157393104,0.00014},
	{0,7,-7,0,0,0,0,0,-1,0,1,0.306483132775783040369078,0.00002},
	{0,7,-7,0,0,0,0,0,-1,1,0,0.000897622834300683598331,0.00002},
	{0,7,-7,0,0,0,0,0,0,-2,0,3.129252477646492280882740,0.00002},
	{0,7,-7,0,0,0,0,0,0,-1,0,3.166578089029643106044887,0.00041},
	{0,7,-7,0,0,0,0,0,0,0,-2,3.140269868549706355764783,0.00001},
	{0,7,-7,0,0,0,0,0,0,0,0,3.141346038566486420506862,0.01547},
	{0,7,-7,0,0,0,0,0,0,0,2,0.000414341164423453838482,0.00002},
	{0,7,-7,0,0,0,0,0,0,1,0,3.142950519747844673190684,0.00258},
	{0,7,-7,0,0,0,0,0,0,2,0,3.144769676427198401569285,0.00020},
	{0,7,-7,0,0,0,0,0,0,3,0,3.143864374144188733595229,0.00002},
	{0,7,-7,0,0,0,0,0,1,-1,0,0.005606695689106584376549,0.00005},
	{0,7,-7,0,0,0,0,0,1,0,-1,3.331218662561697296808916,0.00017},
	{0,7,-7,0,0,0,0,0,1,0,0,0.000329343629851330007945,0.00023},
	{0,7,-7,0,0,0,0,0,1,1,0,6.282480543227630498392955,0.00001},
	{0,7,-7,0,0,0,0,0,2,-4,0,0.000374024058702384840352,0.00001},
	{0,7,-7,0,0,0,0,0,2,-3,0,0.001370083462815548710351,0.00003},
	{0,7,-7,0,0,0,0,0,2,-2,0,3.145102161649703020884772,0.00055},
	{0,7,-7,0,0,0,0,0,2,-1,-2,3.141997046377480007350869,0.00004},
	{0,7,-7,0,0,0,0,0,2,-1,0,3.142491847220420631003890,0.01290},
	{0,7,-7,0,0,0,0,0,2,-1,2,0.000540353936417444489539,0.00003},
	{0,7,-7,0,0,0,0,0,2,0,-2,3.142109794647159226599342,0.00038},
	{0,7,-7,0,0,0,0,0,2,0,0,0.000822399143539728088616,0.00708},
	{0,7,-7,0,0,0,0,0,2,0,2,3.141763870389413515482602,0.00003},
	{0,7,-7,0,0,0,0,0,2,1,0,0.000098960168588078475829,0.00059},
	{0,7,-7,0,0,0,0,0,2,2,0,6.283102578573041441245550,0.00008},
	{0,7,-7,0,0,0,0,0,3,-2,0,0.000194778744522567184589,0.00003},
	{0,7,-7,0,0,0,0,0,3,-1,0,3.142686975030793750107705,0.00001},
	{0,7,-7,0,0,0,0,0,3,0,0,0.001334304213149664934332,0.00003},
	{0,7,-7,0,0,0,0,0,3,1,0,0.001091005315421655300773,0.00001},
	{0,7,-7,0,0,0,0,0,4,-2,0,3.139916439376178036724241,0.00018},
	{0,7,-7,0,0,0,0,0,4,-1,0,6.281921514268217876519884,0.00001},
	{0,7,-7,0,0,0,0,0,4,0,0,0.000070511301780570913322,0.00009},
	{0,7,-7,0,0,0,0,0,4,1,0,0.000302291026445417846270,0.00003},
	{0,7,-7,0,1,0,0,0,-2,0,0,6.042413297142614325707655,0.00005},
	{0,7,-7,0,1,0,0,0,0,-2,0,6.130479295072668755040013,0.00001},
	{0,7,-7,0,1,0,0,0,0,0,0,2.988886641482876083131259,0.00001},
	{0,7,-7,0,1,0,0,0,2,-1,0,6.054736019793394596888447,0.00002},
	{0,7,-6,-2,0,0,0,0,2,-2,0,2.433971074050192306970075,0.00001},
	{0,7,-6,-2,0,0,0,0,2,0,0,2.433971074050192306970075,0.00001},
	{0,7,-6,0,-2,0,0,0,-2,0,0,1.886309793120498401464147,0.00001},
	{0,7,-6,0,-2,0,0,0,-2,2,0,1.886309793120498401464147,0.00001},
	{0,7,-6,0,-2,0,0,0,0,0,0,4.850881031063364545730110,0.00001},
	{0,7,-6,0,-1,0,0,0,-2,-2,0,3.163653789867927113022006,0.00001},
	{0,7,-6,0,-1,0,0,0,-2,2,0,3.117787933388917132049301,0.00001},
	{0,7,-6,0,-1,0,0,0,0,0,0,3.167927054008509379912084,0.00008},
	{0,7,-6,0,-1,0,0,0,2,0,0,0.067174406783682957811088,0.00003},
	{0,7,-6,0,0,-1,0,0,-2,0,0,3.145094307668069077976725,0.00001},
	{0,7,-6,0,0,-1,0,0,-2,2,0,0.003501654078276223488325,0.00001},
	{0,7,-6,0,0,-1,0,0,0,0,0,3.144924836197700912521213,0.00001},
	{0,7,-6,0,0,0,0,0,-3,0,1,1.802332054430314745019359,0.00002},
	{0,7,-6,0,0,0,0,0,-2,0,0,1.483690434486363729504887,0.00004},
	{0,7,-6,0,0,0,0,0,-2,1,0,4.487324933615666644470821,0.00003},
	{0,7,-6,0,0,0,0,0,-2,2,0,5.020514817052450062817570,0.00003},
	{0,7,-6,0,0,0,0,0,-1,-1,-1,1.802438519514686365852185,0.00002},
	{0,7,-6,0,0,0,0,0,-1,0,-1,1.802315299269495740830394,0.00018},
	{0,7,-6,0,0,0,0,0,-1,0,1,4.942129113285655961362863,0.00022},
	{0,7,-6,0,0,0,0,0,-1,1,-1,1.802383541643248543451250,0.00007},
	{0,7,-6,0,0,0,0,0,-1,1,1,1.803189360158894416485964,0.00001},
	{0,7,-6,0,0,0,0,0,0,-1,0,4.156982975432195637210953,0.00003},
	{0,7,-6,0,0,0,0,0,0,0,-1,4.944350393824669787079529,0.00001},
	{0,7,-6,0,0,0,0,0,0,0,0,1.812874890309911668495602,0.00003},
	{0,7,-6,0,0,0,0,0,0,1,0,1.430354917874668840838126,0.00003},
	{0,7,-6,0,0,0,0,0,0,2,0,6.161231996492809059873252,0.00001},
	{0,7,-6,0,0,0,0,0,1,-1,-1,1.803087781996428384800879,0.00014},
	{0,7,-6,0,0,0,0,0,1,-1,1,4.944791787592498266690200,0.00006},
	{0,7,-6,0,0,0,0,0,1,0,-1,1.803238054845025084560461,0.00081},
	{0,7,-6,0,0,0,0,0,1,1,-1,1.803162307555488563792778,0.00009},
	{0,7,-6,0,0,0,0,0,1,1,1,1.803193199883248665216229,0.00001},
	{0,7,-6,0,0,0,0,0,2,-2,0,4.515251248845126852415888,0.00001},
	{0,7,-6,0,0,0,0,0,2,-1,0,4.696768981711040957804926,0.00029},
	{0,7,-6,0,0,0,0,0,2,0,-2,4.569293449270953821894636,0.00001},
	{0,7,-6,0,0,0,0,0,2,0,-1,4.945403874561173473978215,0.00002},
	{0,7,-6,0,0,0,0,0,2,0,0,1.556827060527784301058318,0.00033},
	{0,7,-6,0,0,0,0,0,2,1,0,1.492047943609538407372384,0.00005},
	{0,7,-6,0,0,0,0,0,3,0,-1,1.803204893589237078899146,0.00002},
	{0,7,-6,0,0,0,0,0,4,-1,0,1.533542099378152334665515,0.00002},
	{0,7,-6,0,0,0,0,0,4,0,0,1.427699224884834361404273,0.00003},
	{0,7,-5,-3,0,0,0,0,-2,0,0,5.868065725909742624821774,0.00001},
	{0,7,-5,-3,0,0,0,0,-2,2,0,5.868065725909742624821774,0.00001},
	{0,7,-5,-2,0,0,0,0,-2,0,0,0.009890780871051864375776,0.00001},
	{0,7,-5,-2,0,0,0,0,-2,2,0,0.009890780871051864375776,0.00001},
	{0,7,-5,-2,0,0,0,0,0,-2,0,3.139483248655833058649023,0.00001},
	{0,7,-5,0,-3,0,0,0,-2,0,0,0.133968157257505937618447,0.00001},
	{0,7,-5,0,-3,0,0,0,-2,2,0,0.133968157257505937618447,0.00001},
	{0,7,-5,0,-2,0,0,0,-2,2,0,0.005217312732986648798894,0.00002},
	{0,7,-5,0,-2,0,0,0,0,-2,0,0.002031388716396200031650,0.00003},
	{0,7,-5,0,-2,0,0,0,0,0,0,6.281779444467104234206545,0.00007},
	{0,7,-5,0,-2,0,0,0,2,-2,0,3.141317240633828333784550,0.00001},
	{0,7,-5,0,-1,0,0,0,0,0,0,1.557552419364913287580521,0.00001},
	{0,7,-5,0,0,0,0,0,-2,-1,0,0.468431885002486503299934,0.00003},
	{0,7,-5,0,0,0,0,0,-2,0,0,0.485571367322921221276744,0.00022},
	{0,7,-5,0,0,0,0,0,-2,1,0,0.447138693595230507504823,0.00013},
	{0,7,-5,0,0,0,0,0,-1,0,0,3.593973967192164220563200,0.00002},
	{0,7,-5,0,0,0,0,0,0,-2,0,5.970288089402724374110676,0.00001},
	{0,7,-5,0,0,0,0,0,0,-1,0,0.460637070030154638367037,0.00014},
	{0,7,-5,0,0,0,0,0,0,0,0,0.457392502950697166230754,0.00076},
	{0,7,-5,0,0,0,0,0,0,1,0,0.452889029881776206121202,0.00007},
	{0,7,-5,0,0,0,0,0,2,-2,0,5.711083657135439750618389,0.00003},
	{0,7,-5,0,0,0,0,0,2,-1,0,0.452382011734071831643433,0.00011},
	{0,7,-5,0,0,0,0,0,2,0,0,3.816041283635513092775682,0.00011},
	{0,7,-4,0,-3,0,0,0,-2,0,0,6.225196393716224463332765,0.00001},
	{0,7,-4,0,-3,0,0,0,-2,2,0,3.083603740126431347334801,0.00001},
	{0,7,-4,0,-1,0,0,0,2,-2,0,2.732390436615911522011402,0.00001},
	{0,7,-4,0,-1,0,0,0,2,0,0,5.873983090205704193920155,0.00001},
	{0,7,-4,0,0,0,0,0,-2,1,0,4.874935158814351687794897,0.00002},
	{0,7,-4,0,0,0,0,0,0,0,0,4.995784723282166162050544,0.00005},
	{0,7,-4,0,0,0,0,0,1,0,-1,5.393207015002637660927576,0.00001},
	{0,7,-4,0,0,0,0,0,2,-2,0,0.769585305841454458963824,0.00003},
	{0,7,-4,0,0,0,0,0,2,0,0,0.511396306132980482672679,0.00001},
	{0,7,-4,0,1,0,0,0,2,-2,0,5.363301845467265849265459,0.00003},
	{0,7,-4,0,1,0,0,0,2,0,0,5.436678105214985734505717,0.00002},
	{0,7,-3,0,-1,0,0,0,2,-2,0,5.139471222880627188089875,0.00002},
	{0,7,-3,0,-1,0,0,0,2,0,0,2.747255754920997716794773,0.00005},
	{0,7,-3,0,0,0,0,0,0,-1,0,2.238137627060645229448710,0.00003},
	{0,7,-3,0,0,0,0,0,0,0,0,3.217319348241173493363476,0.00001},
	{0,7,-3,0,0,0,0,0,0,1,0,2.238137627060645229448710,0.00003},
	{0,7,-3,0,0,0,0,0,2,-2,0,2.279269801542395779136996,0.00001},
	{0,7,-3,0,0,0,0,0,2,-1,0,2.237461835574273472104778,0.00002},
	{0,7,-3,0,0,0,0,0,2,0,0,2.230340892226136073617226,0.00003},
	{0,7,-3,0,0,0,0,0,2,1,0,2.238449691930901597203274,0.00003},
	{0,7,-3,0,0,0,0,0,2,2,0,2.237703738208599357761841,0.00002},
	{0,7,-3,0,1,0,0,0,2,0,0,5.214732089154651362150616,0.00007},
	{0,7,-2,-2,0,0,0,0,2,-2,0,1.475955833373225445370736,0.00001},
	{0,7,-2,-2,0,0,0,0,2,0,0,1.475955833373225445370736,0.00001},
	{0,7,-2,0,0,0,0,0,-4,1,2,5.368076368169022671850144,0.00003},
	{0,7,-2,0,0,0,0,0,-2,0,0,5.271107271191618259820189,0.00004},
	{0,7,-2,0,0,0,0,0,-2,2,0,5.271107271191618259820189,0.00004},
	{0,7,-2,0,0,0,0,0,0,0,0,1.852710110624504968868109,0.00002},
	{0,7,-2,0,0,0,0,0,2,-2,0,3.874224626777547531020218,0.00002},
	{0,7,-2,0,0,0,0,0,2,0,0,3.874224626777547531020218,0.00002},
	{0,7,0,0,0,0,0,0,-2,0,0,2.559244699105963416485565,0.00005},
	{0,7,0,0,0,0,0,0,-2,1,0,5.821982052340084479169491,0.00002},
	{0,7,0,0,0,0,0,0,-2,2,0,2.559244699105963416485565,0.00005},
	{0,7,1,0,0,0,0,0,-1,0,0,1.424592538816284559288761,0.00007},
	{0,7,4,-4,0,0,0,0,0,-1,0,4.451592982372511997368747,0.00004},
	{0,8,-47,39,0,0,0,0,0,1,0,0.256525700931323374920368,0.00001},
	{0,8,-21,19,0,0,0,0,2,0,-2,0.523018279089085602606701,0.00001},
	{0,8,-17,0,0,0,0,0,-2,0,0,5.054863943929249536779480,0.00004},
	{0,8,-17,0,0,0,0,0,-2,1,0,1.913248950125030711788554,0.00001},
	{0,8,-17,0,0,0,0,0,-2,2,0,5.054863943929249536779480,0.00004},
	{0,8,-17,0,0,0,0,0,-2,3,0,1.913248950125030711788554,0.00001},
	{0,8,-16,0,0,0,0,0,-3,1,2,3.300317608155137971692739,0.00009},
	{0,8,-15,0,0,0,0,0,-2,1,0,2.367083424862612250905158,0.00002},
	{0,8,-15,0,0,0,0,0,-2,3,0,2.114928901042908648832963,0.00004},
	{0,8,-15,0,0,0,0,0,0,-1,0,1.811035313278309688556078,0.00002},
	{0,8,-15,0,0,0,0,0,0,0,0,1.168142585174497760647228,0.00004},
	{0,8,-15,0,0,0,0,0,0,1,0,1.684371533473325133201115,0.00004},
	{0,8,-15,0,0,0,0,0,2,-1,0,1.467898695414318943619492,0.00012},
	{0,8,-15,0,0,0,0,0,2,0,0,1.457223912643271113154242,0.00017},
	{0,8,-15,0,0,0,0,0,2,1,0,1.460910222556408566418895,0.00001},
	{0,8,-15,0,1,0,0,0,-2,1,0,3.848871624997227236519848,0.00001},
	{0,8,-15,0,1,0,0,0,-2,3,0,3.848871624997227236519848,0.00001},
	{0,8,-15,0,2,0,0,0,-2,0,0,5.635633771703425942689591,0.00001},
	{0,8,-15,0,2,0,0,0,-2,1,0,2.525009193163469056742088,0.00003},
	{0,8,-15,0,3,0,0,0,-2,1,0,5.428684148175000778735466,0.00002},
	{0,8,-15,0,3,0,0,0,-2,3,0,5.428684148175000778735466,0.00002},
	{0,8,-14,0,0,0,0,0,-2,-1,0,3.430203789358079458082784,0.00002},
	{0,8,-14,0,0,0,0,0,-2,0,0,2.825983892287032617218756,0.00017},
	{0,8,-14,0,0,0,0,0,-2,0,2,2.807316897805252509101592,0.00001},
	{0,8,-14,0,0,0,0,0,-2,1,0,2.940803169656282634036870,0.00011},
	{0,8,-14,0,0,0,0,0,-1,0,0,5.911857258572757345405080,0.00001},
	{0,8,-14,0,0,0,0,0,0,-1,0,5.976615082474128648470924,0.00030},
	{0,8,-14,0,0,0,0,0,0,0,0,5.932151598049096641318556,0.00297},
	{0,8,-14,0,0,0,0,0,0,1,0,5.919119748123231161684998,0.00092},
	{0,8,-14,0,0,0,0,0,0,2,0,5.908387544019792159133431,0.00007},
	{0,8,-14,0,0,0,0,0,2,-2,0,5.972509020875887308932306,0.00010},
	{0,8,-14,0,0,0,0,0,2,-1,0,5.949267169358779305810003,0.00265},
	{0,8,-14,0,0,0,0,0,2,0,-2,5.947680490535791619777228,0.00003},
	{0,8,-14,0,0,0,0,0,2,0,0,5.934604309246924280785151,0.00242},
	{0,8,-14,0,0,0,0,0,2,1,0,5.928015516787720429192632,0.00024},
	{0,8,-14,0,0,0,0,0,2,2,0,5.940731985717751406639309,0.00002},
	{0,8,-14,0,0,0,0,0,4,-2,0,5.951933857922901083270517,0.00005},
	{0,8,-14,0,0,0,0,0,4,-1,0,5.936271971347204967628386,0.00010},
	{0,8,-14,0,0,0,0,0,4,0,0,5.931842674771494294816421,0.00006},
	{0,8,-14,0,0,0,0,0,4,1,0,2.806157824649003096340039,0.00001},
	{0,8,-14,0,1,0,0,0,-2,0,0,2.473562995467057934462218,0.00002},
	{0,8,-14,0,1,0,0,0,-2,1,0,5.620934085144353886676072,0.00001},
	{0,8,-14,0,1,0,0,0,-2,2,0,2.473562995467057934462218,0.00002},
	{0,8,-14,0,1,0,0,0,-2,3,0,2.479341431554560770678108,0.00001},
	{0,8,-14,0,2,0,0,0,-2,0,0,0.899602561271220846350616,0.00001},
	{0,8,-14,0,2,0,0,0,-2,2,0,0.899169545083800980656008,0.00001},
	{0,8,-14,0,2,0,0,0,0,-1,0,4.042604568231999095928586,0.00002},
	{0,8,-14,0,2,0,0,0,0,1,0,4.042604568231999095928586,0.00002},
	{0,8,-14,1,0,0,0,0,0,0,0,1.007553269902172532468398,0.00001},
	{0,8,-14,2,0,0,0,0,-2,0,0,4.082517281165381817231719,0.00004},
	{0,8,-14,2,0,0,0,0,-2,1,0,0.904224542196352287781735,0.00001},
	{0,8,-14,2,0,0,0,0,-2,2,0,4.044653410240915292206410,0.00003},
	{0,8,-14,2,0,0,0,0,-2,3,0,0.904224542196352287781735,0.00001},
	{0,8,-14,2,0,0,0,0,0,-1,0,0.733744096987124838626926,0.00002},
	{0,8,-14,2,0,0,0,0,0,1,0,0.733744096987124838626926,0.00002},
	{0,8,-13,0,-1,0,0,0,0,-1,0,2.646096646008331720878459,0.00002},
	{0,8,-13,0,-1,0,0,0,0,1,0,2.646096646008331720878459,0.00002},
	{0,8,-13,0,0,-1,0,0,0,-1,0,0.968437125239400842247051,0.00001},
	{0,8,-13,0,0,-1,0,0,0,1,0,0.968437125239400842247051,0.00001},
	{0,8,-13,0,0,0,0,0,-6,1,0,4.129717965456316086658717,0.00001},
	{0,8,-13,0,0,0,0,0,-6,2,0,4.135439329277278197594114,0.00002},
	{0,8,-13,0,0,0,0,0,-4,-1,0,4.067899974147003661073541,0.00005},
	{0,8,-13,0,0,0,0,0,-4,0,0,4.098418277848600688173519,0.00027},
	{0,8,-13,0,0,0,0,0,-4,1,0,4.145427674053516753360782,0.00072},
	{0,8,-13,0,0,0,0,0,-4,1,2,4.151919077140459712893517,0.00001},
	{0,8,-13,0,0,0,0,0,-4,2,0,4.128567269880475620880134,0.00051},
	{0,8,-13,0,0,0,0,0,-4,3,0,4.089972105999424734079639,0.00001},
	{0,8,-13,0,0,0,0,0,-3,1,0,1.000099317732755288545832,0.00003},
	{0,8,-13,0,0,0,0,0,-2,-3,0,4.898663608126915036677929,0.00002},
	{0,8,-13,0,0,0,0,0,-2,-2,0,4.120890439165579621771940,0.00019},
	{0,8,-13,0,0,0,0,0,-2,-1,-2,1.004624607417325954372700,0.00001},
	{0,8,-13,0,0,0,0,0,-2,-1,0,4.137412598529583540596377,0.00227},
	{0,8,-13,0,0,0,0,0,-2,-1,2,0.998097948679493196522117,0.00006},
	{0,8,-13,0,0,0,0,0,-2,0,-2,0.993491152118854192742958,0.00005},
	{0,8,-13,0,0,0,0,0,-2,0,0,4.143704161417172571191259,0.02418},
	{0,8,-13,0,0,0,0,0,-2,0,2,4.151919077140459712893517,0.00055},
	{0,8,-13,0,0,0,0,0,-2,1,-2,1.011569970642712146258191,0.00009},
	{0,8,-13,0,0,0,0,0,-2,1,0,4.154026213146392088049197,0.03878},
	{0,8,-13,0,0,0,0,0,-2,1,2,4.124698223994655243984653,0.00002},
	{0,8,-13,0,0,0,0,0,-2,2,0,4.215603174486004078858059,0.00152},
	{0,8,-13,0,0,0,0,0,-2,3,0,4.195030629526896426284566,0.00011},
	{0,8,-13,0,0,0,0,0,-1,-1,0,0.969810175761944726069430,0.00007},
	{0,8,-13,0,0,0,0,0,-1,0,0,0.971824285718746239126631,0.00065},
	{0,8,-13,0,0,0,0,0,-1,1,0,1.035974385974573364066487,0.00009},
	{0,8,-13,0,0,0,0,0,0,-3,0,4.051120378718330528045044,0.00018},
	{0,8,-13,0,0,0,0,0,0,-2,-2,0.946216291334709747040677,0.00002},
	{0,8,-13,0,0,0,0,0,0,-2,0,4.070971579097588666229512,0.00263},
	{0,8,-13,0,0,0,0,0,0,-1,-2,0.948787510388747867828840,0.00010},
	{0,8,-13,0,0,0,0,0,0,-1,0,4.074405688933812719199068,0.03878},
	{0,8,-13,0,0,0,0,0,0,-1,2,4.056607693886600252142216,0.00006},
	{0,8,-13,0,0,0,0,0,0,0,-2,1.011199088176663485327822,0.00011},
	{0,8,-13,0,0,0,0,0,0,0,0,4.114615980504659376038035,0.22653},
	{0,8,-13,0,0,0,0,0,0,0,2,1.011725479479064881971340,0.00011},
	{0,8,-13,0,0,0,0,0,0,1,-2,4.063419713957133971860003,0.00006},
	{0,8,-13,0,0,0,0,0,0,1,0,4.074388584707143046159672,0.03874},
	{0,8,-13,0,0,0,0,0,0,1,2,0.948787510388747867828840,0.00010},
	{0,8,-13,0,0,0,0,0,0,2,0,4.074747598934277625915001,0.00262},
	{0,8,-13,0,0,0,0,0,0,2,2,0.947213397936374157382033,0.00002},
	{0,8,-13,0,0,0,0,0,0,3,0,4.072084401028660316512742,0.00018},
	{0,8,-13,0,0,0,0,0,1,-1,0,1.037679049054996305301302,0.00009},
	{0,8,-13,0,0,0,0,0,1,0,0,1.014433706879384722299164,0.00064},
	{0,8,-13,0,0,0,0,0,1,1,0,0.995898659289055188104101,0.00007},
	{0,8,-13,0,0,0,0,0,2,-3,0,4.184758668747209142679822,0.00011},
	{0,8,-13,0,0,0,0,0,2,-2,0,4.173895739482796685138055,0.00149},
	{0,8,-13,0,0,0,0,0,2,-1,-2,4.129052645945455957132708,0.00002},
	{0,8,-13,0,0,0,0,0,2,-1,0,4.153348676330767652586928,0.03850},
	{0,8,-13,0,0,0,0,0,2,-1,2,1.010725580350597452294892,0.00009},
	{0,8,-13,0,0,0,0,0,2,0,-2,4.151384133724723035641091,0.00055},
	{0,8,-13,0,0,0,0,0,2,0,0,4.140318920800004853788323,0.02393},
	{0,8,-13,0,0,0,0,0,2,0,2,0.989862089005182355094803,0.00005},
	{0,8,-13,0,0,0,0,0,2,1,-2,0.997136795860419922199469,0.00006},
	{0,8,-13,0,0,0,0,0,2,1,0,4.124180733871439130666658,0.00226},
	{0,8,-13,0,0,0,0,0,2,1,2,1.001593668638312673024870,0.00001},
	{0,8,-13,0,0,0,0,0,2,2,0,4.115759171164715901625186,0.00018},
	{0,8,-13,0,0,0,0,0,2,3,0,4.143976258247558774883146,0.00002},
	{0,8,-13,0,0,0,0,0,3,-1,0,1.009792003733705589851866,0.00003},
	{0,8,-13,0,0,0,0,0,3,0,0,4.165734230834620355210518,0.00002},
	{0,8,-13,0,0,0,0,0,4,-3,0,4.142054650741112453715687,0.00001},
	{0,8,-13,0,0,0,0,0,4,-2,0,4.153169605549513754283453,0.00051},
	{0,8,-13,0,0,0,0,0,4,-1,-2,4.151343991151927426130896,0.00001},
	{0,8,-13,0,0,0,0,0,4,-1,0,4.142020965886548999890238,0.00071},
	{0,8,-13,0,0,0,0,0,4,0,0,4.095479492454092707021118,0.00027},
	{0,8,-13,0,0,0,0,0,4,1,0,4.127383762114699372602900,0.00005},
	{0,8,-13,0,0,0,0,0,6,-2,0,4.141658810066759954793270,0.00002},
	{0,8,-13,0,0,0,0,0,6,-1,0,4.128884221672638688005463,0.00001},
	{0,8,-13,0,0,1,0,0,0,-1,0,4.037487786463927363911353,0.00002},
	{0,8,-13,0,0,1,0,0,0,1,0,4.037487786463927363911353,0.00002},
	{0,8,-13,0,1,0,0,0,-2,0,0,0.880499059943516959592102,0.00003},
	{0,8,-13,0,1,0,0,0,-2,3,0,4.014072972817947615453704,0.00002},
	{0,8,-13,0,1,0,0,0,0,-2,0,4.021646654574051460429018,0.00001},
	{0,8,-13,0,1,0,0,0,0,-1,0,2.807675388433612084781998,0.00003},
	{0,8,-13,0,1,0,0,0,0,0,0,0.880054000984258344431055,0.00001},
	{0,8,-13,0,1,0,0,0,0,1,0,2.807675388433612084781998,0.00003},
	{0,8,-13,0,2,0,0,0,-2,0,0,1.953210532277468436390677,0.00003},
	{0,8,-13,0,2,0,0,0,0,-1,0,5.102465879415217564485374,0.00002},
	{0,8,-13,0,2,0,0,0,0,0,0,1.154607033226505929945915,0.00001},
	{0,8,-13,0,2,0,0,0,0,1,0,5.102465879415217564485374,0.00002},
	{0,8,-13,2,0,0,0,0,-2,0,0,1.664584037611764655295588,0.00001},
	{0,8,-13,2,0,0,0,0,-2,2,0,1.664584037611764655295588,0.00001},
	{0,8,-13,2,0,0,0,0,1,0,-1,4.341795017261249611806306,0.00003},
	{0,8,-12,-2,0,0,0,0,0,-1,0,4.927583190233685073167180,0.00002},
	{0,8,-12,-2,0,0,0,0,0,1,0,4.927583190233685073167180,0.00002},
	{0,8,-12,-1,0,0,0,0,0,0,0,1.419738080034787408578723,0.00001},
	{0,8,-12,0,-1,0,0,0,-2,0,0,4.230616496711659735296962,0.00005},
	{0,8,-12,0,-1,0,0,0,-2,1,0,1.054821149369308930232592,0.00001},
	{0,8,-12,0,-1,0,0,0,-2,2,0,4.196330201687931804599430,0.00003},
	{0,8,-12,0,-1,0,0,0,-2,3,0,4.196413802959102490319765,0.00001},
	{0,8,-12,0,-1,0,0,0,0,-1,0,1.054821149369308930232592,0.00001},
	{0,8,-12,0,-1,0,0,0,0,1,0,1.054821149369308930232592,0.00001},
	{0,8,-12,0,0,0,0,0,-4,0,0,2.233882165278432641031259,0.00003},
	{0,8,-12,0,0,0,0,0,-4,1,0,2.138420683708901925967893,0.00006},
	{0,8,-12,0,0,0,0,0,-4,2,0,2.563274489815893453226181,0.00001},
	{0,8,-12,0,0,0,0,0,-2,-1,0,1.949905402272966936649823,0.00014},
	{0,8,-12,0,0,0,0,0,-2,-1,2,4.045117842354871484644718,0.00001},
	{0,8,-12,0,0,0,0,0,-2,0,0,1.744577015086720139791510,0.00108},
	{0,8,-12,0,0,0,0,0,-2,0,2,3.110468371571903478667309,0.00001},
	{0,8,-12,0,0,0,0,0,-2,1,0,1.602958556118947219815141,0.00102},
	{0,8,-12,0,0,0,0,0,-2,1,2,4.045117842354871484644718,0.00001},
	{0,8,-12,0,0,0,0,0,-2,2,0,1.129848316056490054037909,0.00006},
	{0,8,-12,0,0,0,0,0,-2,3,0,3.952771075368449960052430,0.00002},
	{0,8,-12,0,0,0,0,0,-1,-1,1,5.824790636172394009406617,0.00002},
	{0,8,-12,0,0,0,0,0,-1,0,-1,2.683026416717129603028980,0.00001},
	{0,8,-12,0,0,0,0,0,-1,1,-1,2.678526783372563002671995,0.00002},
	{0,8,-12,0,0,0,0,0,0,-2,0,0.085972300959362674133146,0.00004},
	{0,8,-12,0,0,0,0,0,0,-1,0,0.125769124030412182690952,0.00070},
	{0,8,-12,0,0,0,0,0,0,0,0,6.115089679860283844448077,0.00388},
	{0,8,-12,0,0,0,0,0,0,1,-2,4.045117842354871484644718,0.00003},
	{0,8,-12,0,0,0,0,0,0,1,0,5.983701468303076254073858,0.00083},
	{0,8,-12,0,0,0,0,0,0,2,0,5.815653663005278417585941,0.00008},
	{0,8,-12,0,0,0,0,0,1,-1,-1,5.820031646900981847636558,0.00005},
	{0,8,-12,0,0,0,0,0,1,-1,0,2.362843845576592993751319,0.00002},
	{0,8,-12,0,0,0,0,0,1,-1,1,2.688521062268258265959275,0.00004},
	{0,8,-12,0,0,0,0,0,1,0,-1,2.678311584275792522902293,0.00028},
	{0,8,-12,0,0,0,0,0,1,0,0,2.719614102892537133016049,0.00016},
	{0,8,-12,0,0,0,0,0,1,0,1,5.820348424160218137046741,0.00050},
	{0,8,-12,0,0,0,0,0,1,1,-1,5.820031646900981847636558,0.00005},
	{0,8,-12,0,0,0,0,0,1,1,1,5.820255398111086719836749,0.00005},
	{0,8,-12,0,0,0,0,0,2,-2,0,2.440057560750672482896562,0.00003},
	{0,8,-12,0,0,0,0,0,2,-1,0,5.731203638219505513973218,0.00040},
	{0,8,-12,0,0,0,0,0,2,0,-2,5.677436850749642438529463,0.00002},
	{0,8,-12,0,0,0,0,0,2,0,0,5.776287761726546676754879,0.00038},
	{0,8,-12,0,0,0,0,0,2,1,0,5.661464644632942189161895,0.00002},
	{0,8,-12,0,0,0,0,0,3,0,-1,5.820255398111086719836749,0.00002},
	{0,8,-12,0,1,0,0,0,-2,0,0,0.681365369871373527388414,0.00007},
	{0,8,-12,0,1,0,0,0,-2,2,0,0.664125356586023896099391,0.00001},
	{0,8,-11,-4,0,0,0,0,0,0,0,0.616879119201612202694207,0.00001},
	{0,8,-11,-2,0,0,0,0,-2,0,0,3.336922573090140176077512,0.00002},
	{0,8,-11,-2,0,0,0,0,-2,2,0,3.336922573090140176077512,0.00002},
	{0,8,-11,0,-1,0,0,0,-2,2,0,0.916153344034957850539058,0.00001},
	{0,8,-11,0,0,0,0,0,-4,0,0,2.087224417161376965879072,0.00002},
	{0,8,-11,0,0,0,0,0,-2,-2,0,1.129006718291178268387398,0.00001},
	{0,8,-11,0,0,0,0,0,-2,0,0,5.375550566157762055752301,0.00007},
	{0,8,-11,0,0,0,0,0,-2,1,0,4.920335186916003245016782,0.00008},
	{0,8,-11,0,0,0,0,0,-2,2,0,5.620480823137611103845757,0.00002},
	{0,8,-11,0,0,0,0,0,0,-1,0,4.468323010450428789397392,0.00020},
	{0,8,-11,0,0,0,0,0,0,0,0,1.391345063763343548046691,0.00009},
	{0,8,-11,0,0,0,0,0,1,0,-1,4.326259143457546585409546,0.00010},
	{0,8,-11,0,0,0,0,0,2,-3,0,0.920639538344284025228603,0.00002},
	{0,8,-11,0,0,0,0,0,2,-2,0,4.457970066393448504982189,0.00003},
	{0,8,-11,0,0,0,0,0,2,-1,0,1.327738459036587270745144,0.00097},
	{0,8,-11,0,0,0,0,0,2,0,-1,1.158153716799483756716427,0.00005},
	{0,8,-11,0,0,0,0,0,2,0,0,4.355886282043075929948373,0.00002},
	{0,8,-11,0,0,0,0,0,4,-2,0,1.333992148279408374023092,0.00001},
	{0,8,-11,0,0,3,0,0,2,0,-2,3.088429575508195412680834,0.00006},
	{0,8,-11,0,1,0,0,0,2,-1,0,6.108276263526349225685408,0.00003},
	{0,8,-11,0,2,0,0,0,2,-2,0,1.590873023713512690591187,0.00001},
	{0,8,-11,0,2,0,0,0,2,0,-2,1.590873023713512690591187,0.00001},
	{0,8,-11,0,2,0,0,0,2,0,0,4.732465677303305362499941,0.00001},
	{0,8,-10,0,0,0,0,0,-2,0,0,2.842145641160500169064562,0.00002},
	{0,8,-10,0,0,0,0,0,-2,1,0,2.939895074846469835705420,0.00003},
	{0,8,-10,0,0,0,0,0,-2,2,0,5.851995257756154700246043,0.00001},
	{0,8,-10,0,0,0,0,0,-1,0,1,0.065917420656396635836316,0.00002},
	{0,8,-10,0,0,0,0,0,0,-1,0,3.248840867196816972750639,0.00005},
	{0,8,-10,0,0,0,0,0,0,0,0,5.991855995634244536063306,0.00075},
	{0,8,-10,0,0,0,0,0,0,1,0,6.054862032565389462490657,0.00012},
	{0,8,-10,0,0,0,0,0,0,2,0,6.102949518649261939629014,0.00002},
	{0,8,-10,0,0,0,0,0,1,-1,-1,2.946715996096189282837940,0.00001},
	{0,8,-10,0,0,0,0,0,1,0,-2,6.107684596909922269958315,0.00002},
	{0,8,-10,0,0,0,0,0,1,0,-1,2.946715996096189282837940,0.00021},
	{0,8,-10,0,0,0,0,0,1,0,0,2.865977763030632008423026,0.00003},
	{0,8,-10,0,0,0,0,0,1,1,-1,2.946715996096189282837940,0.00001},
	{0,8,-10,0,0,0,0,0,2,-3,0,6.027474500476019514394466,0.00002},
	{0,8,-10,0,0,0,0,0,2,-2,0,6.140106705759595939753126,0.00003},
	{0,8,-10,0,0,0,0,0,2,-1,0,6.134320415690457828361559,0.00104},
	{0,8,-10,0,0,0,0,0,2,0,-2,6.125496205525299941996309,0.00004},
	{0,8,-10,0,0,0,0,0,2,0,0,3.034436244301423890590286,0.00024},
	{0,8,-10,0,0,0,0,0,2,1,0,2.971654307646235171347371,0.00003},
	{0,8,-10,0,0,0,0,0,3,-2,-2,2.943612277087368056527339,0.00002},
	{0,8,-10,0,0,0,0,0,3,-1,-2,6.104883867059247570807656,0.00008},
	{0,8,-10,0,0,0,0,0,3,-1,-1,2.947598958164773463863639,0.00005},
	{0,8,-10,0,0,0,0,0,3,0,-2,2.966091768787204152602044,0.00012},
	{0,8,-10,0,0,0,0,0,4,-2,0,6.097973235885975284986671,0.00002},
	{0,8,-10,0,0,0,0,0,4,-1,0,2.986036693347294601608155,0.00001},
	{0,8,-10,0,0,0,0,0,4,0,0,2.981802175516106157004970,0.00003},
	{0,8,-10,0,1,0,0,0,-2,0,0,4.720352045096913862209931,0.00001},
	{0,8,-10,0,1,0,0,0,-2,2,0,1.578759391507120746211967,0.00001},
	{0,8,-10,0,1,0,0,0,2,-1,0,4.711987554656730914359741,0.00003},
	{0,8,-10,0,1,0,0,0,2,0,0,1.570394901066938020406383,0.00003},
	{0,8,-10,0,3,0,0,0,0,0,0,2.946265003017473738111676,0.00001},
	{0,8,-10,2,0,0,0,0,2,-3,0,3.142649101386025378701561,0.00001},
	{0,8,-10,2,0,0,0,0,2,-1,0,3.142649101386025378701561,0.00001},
	{0,8,-10,4,0,0,0,0,-2,0,0,1.011458967702285605128054,0.00001},
	{0,8,-10,4,0,0,0,0,-2,2,0,1.011458967702285605128054,0.00001},
	{0,8,-10,4,0,0,0,0,0,0,0,1.005924005045435887240046,0.00001},
	{0,8,-9,0,-1,0,0,0,-2,0,0,1.823825086036924059129660,0.00002},
	{0,8,-9,0,-1,0,0,0,0,0,0,6.162274830720876117595708,0.00001},
	{0,8,-9,0,0,0,0,0,-2,0,0,4.754310218221266204352560,0.00004},
	{0,8,-9,0,0,0,0,0,-2,1,0,1.521738961245690413548459,0.00008},
	{0,8,-9,0,0,0,0,0,-2,2,0,4.807230521003911682953458,0.00001},
	{0,8,-9,0,0,0,0,0,-1,0,-1,1.325582802877449228873274,0.00003},
	{0,8,-9,0,0,0,0,0,-1,0,0,1.595377718512909881454220,0.00001},
	{0,8,-9,0,0,0,0,0,-1,0,1,4.467051014491575600118267,0.00013},
	{0,8,-9,0,0,0,0,0,-1,1,-1,1.325870433138177872933738,0.00002},
	{0,8,-9,0,0,0,0,0,0,-1,0,1.666400227231390029913882,0.00007},
	{0,8,-9,0,0,0,0,0,0,0,0,4.744945828652616270915132,0.00226},
	{0,8,-9,0,0,0,0,0,0,1,0,4.755157401040184694807067,0.00047},
	{0,8,-9,0,0,0,0,0,0,2,0,5.053713422886334960537624,0.00002},
	{0,8,-9,0,0,0,0,0,0,3,0,4.768159405835841191390045,0.00002},
	{0,8,-9,0,0,0,0,0,1,-1,-1,1.325726443474888327500594,0.00010},
	{0,8,-9,0,0,0,0,0,1,-1,0,1.605225215218512246906357,0.00001},
	{0,8,-9,0,0,0,0,0,1,-1,1,4.438091638877859068657017,0.00004},
	{0,8,-9,0,0,0,0,0,1,0,-1,1.326083712372771561405216,0.00063},
	{0,8,-9,0,0,0,0,0,1,0,0,1.584617065542664127164585,0.00005},
	{0,8,-9,0,0,0,0,0,1,1,-1,1.325549118022885775047826,0.00006},
	{0,8,-9,0,0,0,0,0,2,-3,0,4.941966623132295843845441,0.00006},
	{0,8,-9,0,0,0,0,0,2,-2,0,4.293060712156586689047799,0.00008},
	{0,8,-9,0,0,0,0,0,2,-1,0,4.758468116098292455262708,0.00267},
	{0,8,-9,0,0,0,0,0,2,0,-2,4.752801032017067939250410,0.00008},
	{0,8,-9,0,0,0,0,0,2,0,-1,4.466921336528152153277915,0.00002},
	{0,8,-9,0,0,0,0,0,2,0,0,1.659374229794561728112967,0.00134},
	{0,8,-9,0,0,0,0,0,2,1,0,1.647113117266376214331558,0.00020},
	{0,8,-9,0,0,0,0,0,2,2,0,1.622535565272717139606584,0.00002},
	{0,8,-9,0,0,0,0,0,3,0,0,1.613265947082450191274461,0.00002},
	{0,8,-9,0,0,0,0,0,4,-3,0,1.789507724152510803605765,0.00001},
	{0,8,-9,0,0,0,0,0,4,-2,0,4.946561376921095209979740,0.00003},
	{0,8,-9,0,0,0,0,0,4,0,0,1.717934389522101312763880,0.00005},
	{0,8,-9,0,1,0,0,0,-2,0,0,3.364119166159341922650583,0.00009},
	{0,8,-9,0,1,0,0,0,0,0,0,0.124794183110248146917343,0.00003},
	{0,8,-9,0,1,0,0,0,2,-1,0,3.118884174692095001546477,0.00005},
	{0,8,-9,0,1,0,0,0,2,0,0,3.116127950737345386755806,0.00003},
	{0,8,-9,0,2,0,0,0,-2,0,0,4.060625790890541431110705,0.00001},
	{0,8,-9,0,2,0,0,0,-2,2,0,4.060625790890541431110705,0.00001},
	{0,8,-9,0,2,0,0,0,2,-2,0,4.191635091467142082422015,0.00001},
	{0,8,-9,0,2,0,0,0,2,0,0,1.050042437877348522334842,0.00001},
	{0,8,-9,3,0,0,0,0,-2,0,0,4.125780328130892016247344,0.00001},
	{0,8,-9,3,0,0,0,0,-2,2,0,4.125780328130892016247344,0.00001},
	{0,8,-8,0,-2,0,0,0,0,0,0,3.517606911238226885529912,0.00001},
	{0,8,-8,0,-1,0,0,0,-2,0,0,3.244072802213293638118330,0.00007},
	{0,8,-8,0,-1,0,0,0,-2,1,0,5.220407376283359823787578,0.00001},
	{0,8,-8,0,-1,0,0,0,-2,2,0,3.238862994396090932980314,0.00001},
	{0,8,-8,0,0,0,0,0,-4,0,0,3.136347939187550171169505,0.00002},
	{0,8,-8,0,0,0,0,0,-4,1,0,3.145950566199097409025853,0.00002},
	{0,8,-8,0,0,0,0,0,-4,2,0,3.138323128302032305469993,0.00002},
	{0,8,-8,0,0,0,0,0,-4,3,0,3.149311895805513739077242,0.00001},
	{0,8,-8,0,0,0,0,0,-2,-1,0,3.148067650581766852013743,0.00006},
	{0,8,-8,0,0,0,0,0,-2,0,0,3.148116170734972740774538,0.00042},
	{0,8,-8,0,0,0,0,0,-2,1,0,3.139238902560553601261972,0.00031},
	{0,8,-8,0,0,0,0,0,-2,2,0,6.274427070460154354236693,0.00008},
	{0,8,-8,0,0,0,0,0,-2,3,0,0.012536001885374471395695,0.00001},
	{0,8,-8,0,0,0,0,0,-1,0,0,6.281693923333757645366404,0.00011},
	{0,8,-8,0,0,0,0,0,-1,0,1,0.302532056415118266734510,0.00001},
	{0,8,-8,0,0,0,0,0,-1,1,0,0.001128180828489134613149,0.00001},
	{0,8,-8,0,0,0,0,0,0,-3,0,0.024872687170171190601531,0.00002},
	{0,8,-8,0,0,0,0,0,0,-2,0,3.218938839254099182340951,0.00001},
	{0,8,-8,0,0,0,0,0,0,-1,0,3.148123326584905345981724,0.00052},
	{0,8,-8,0,0,0,0,0,0,0,-2,3.126116295513583942522473,0.00001},
	{0,8,-8,0,0,0,0,0,0,0,0,3.141000288841666154837640,0.01070},
	{0,8,-8,0,0,0,0,0,0,1,0,3.142373688430060596488147,0.00180},
	{0,8,-8,0,0,0,0,0,0,2,0,3.129651983512274249221718,0.00017},
	{0,8,-8,0,0,0,0,0,1,-1,0,6.283013392248265382988848,0.00003},
	{0,8,-8,0,0,0,0,0,1,0,-1,3.324360914864761262776938,0.00015},
	{0,8,-8,0,0,0,0,0,1,0,0,0.000293215314335047347837,0.00016},
	{0,8,-8,0,0,0,0,0,1,1,0,3.142584698736626602766364,0.00001},
	{0,8,-8,0,0,0,0,0,2,-3,0,3.252938725747574810753804,0.00001},
	{0,8,-8,0,0,0,0,0,2,-2,0,3.151077645409756655681122,0.00037},
	{0,8,-8,0,0,0,0,0,2,-1,-2,3.141487061170047834224306,0.00002},
	{0,8,-8,0,0,0,0,0,2,-1,0,3.142238774478881779828043,0.00824},
	{0,8,-8,0,0,0,0,0,2,-1,2,0.000197571271325758121779,0.00002},
	{0,8,-8,0,0,0,0,0,2,0,-2,3.141432257831535235226283,0.00025},
	{0,8,-8,0,0,0,0,0,2,0,0,0.000785049097547049442615,0.00571},
	{0,8,-8,0,0,0,0,0,2,0,2,3.141655310909939657904033,0.00002},
	{0,8,-8,0,0,0,0,0,2,1,0,0.000139975406009945228586,0.00048},
	{0,8,-8,0,0,0,0,0,2,2,0,0.000060911990894602102307,0.00007},
	{0,8,-8,0,0,0,0,0,3,-4,0,0.000992219679758776307646,0.00001},
	{0,8,-8,0,0,0,0,0,3,-1,0,3.142509649578790753565727,0.00001},
	{0,8,-8,0,0,0,0,0,3,0,0,0.000992394212683975858111,0.00004},
	{0,8,-8,0,0,0,0,0,3,1,0,0.000991696080983178089932,0.00001},
	{0,8,-8,0,0,0,0,0,4,-2,0,3.135055348343523284881940,0.00012},
	{0,8,-8,0,0,0,0,0,4,-1,0,0.000833045651976893511241,0.00005},
	{0,8,-8,0,0,0,0,0,4,0,0,6.283184958113736229279311,0.00010},
	{0,8,-8,0,0,0,0,0,4,1,0,0.000081157810217736322395,0.00002},
	{0,8,-8,0,0,0,0,0,6,-1,0,0.000302116493520218404225,0.00001},
	{0,8,-8,0,1,0,0,0,-2,0,0,6.077474518354227583927241,0.00007},
	{0,8,-8,0,1,0,0,0,-2,1,0,3.014351344335323812373417,0.00002},
	{0,8,-8,0,1,0,0,0,0,-2,0,6.130334258211828313278602,0.00001},
	{0,8,-8,0,1,0,0,0,0,0,0,2.988741604622035197280638,0.00001},
	{0,8,-7,0,-1,0,0,0,-2,0,0,3.117190856251809805144148,0.00001},
	{0,8,-7,0,-1,0,0,0,-2,1,0,3.163508578474160337634657,0.00001},
	{0,8,-7,0,-1,0,0,0,-2,2,0,3.117190856251809805144148,0.00001},
	{0,8,-7,0,-1,0,0,0,-2,3,0,3.163508578474160337634657,0.00001},
	{0,8,-7,0,-1,0,0,0,0,0,0,3.167911869644017386349333,0.00007},
	{0,8,-7,0,-1,0,0,0,2,0,0,0.066532474684799447484096,0.00002},
	{0,8,-7,0,0,0,0,0,-2,0,0,1.823495742407072794932787,0.00001},
	{0,8,-7,0,0,0,0,0,-2,1,0,4.486813726677757685479264,0.00002},
	{0,8,-7,0,0,0,0,0,-2,2,0,4.480409240987564878366811,0.00003},
	{0,8,-7,0,0,0,0,0,-1,-1,-1,1.802195569682808917733041,0.00002},
	{0,8,-7,0,0,0,0,0,-1,-1,1,4.943651563992170316907959,0.00002},
	{0,8,-7,0,0,0,0,0,-1,0,-1,1.801415931105943002421554,0.00014},
	{0,8,-7,0,0,0,0,0,-1,0,1,4.943496578754594139581968,0.00017},
	{0,8,-7,0,0,0,0,0,-1,1,-1,1.802235363189754302482015,0.00007},
	{0,8,-7,0,0,0,0,0,0,-2,0,1.350966871518454848200008,0.00003},
	{0,8,-7,0,0,0,0,0,0,-1,0,4.011611011375084245855760,0.00001},
	{0,8,-7,0,0,0,0,0,0,0,-1,4.944136940057150653160534,0.00001},
	{0,8,-7,0,0,0,0,0,0,1,0,1.141804345031426803913632,0.00003},
	{0,8,-7,0,0,0,0,0,1,-1,-1,1.802921103052862683568947,0.00011},
	{0,8,-7,0,0,0,0,0,1,-1,1,4.944638722217098880662434,0.00003},
	{0,8,-7,0,0,0,0,0,1,0,-1,1.803890109853570011821944,0.00060},
	{0,8,-7,0,0,0,0,0,1,0,1,1.802925989974768494761292,0.00002},
	{0,8,-7,0,0,0,0,0,1,1,-1,1.803047813956557554604387,0.00005},
	{0,8,-7,0,0,0,0,0,1,1,1,1.803045370495604649008214,0.00002},
	{0,8,-7,0,0,0,0,0,1,2,1,1.803050431950435683603473,0.00002},
	{0,8,-7,0,0,0,0,0,2,-1,0,4.726008482669702637224418,0.00021},
	{0,8,-7,0,0,0,0,0,2,0,0,1.576210861733358781222591,0.00030},
	{0,8,-7,0,0,0,0,0,2,1,0,1.514694812384641098290672,0.00005},
	{0,8,-7,0,0,0,0,0,4,-1,0,1.567435346254331118842629,0.00001},
	{0,8,-7,0,0,0,0,0,4,0,0,1.455053421185491080436236,0.00003},
	{0,8,-6,-3,0,0,0,0,-2,0,0,5.867987884225104089352953,0.00001},
	{0,8,-6,-3,0,0,0,0,-2,2,0,5.867987884225104089352953,0.00001},
	{0,8,-6,-2,0,0,0,0,-2,0,0,0.009474519844451219710568,0.00001},
	{0,8,-6,-2,0,0,0,0,-2,2,0,0.009474519844451219710568,0.00001},
	{0,8,-6,0,-3,0,0,0,-2,0,0,0.132190539414349716995645,0.00001},
	{0,8,-6,0,-3,0,0,0,-2,2,0,0.132190539414349716995645,0.00001},
	{0,8,-6,0,-2,0,0,0,-2,2,0,0.005094092487795850304755,0.00002},
	{0,8,-6,0,-2,0,0,0,0,-2,0,0.002789734276387736359309,0.00001},
	{0,8,-6,0,-2,0,0,0,0,0,0,6.280040747466268946652690,0.00004},
	{0,8,-6,0,0,0,0,0,-2,-1,0,0.462173134304834809515938,0.00002},
	{0,8,-6,0,0,0,0,0,-2,0,0,0.462938461181834348678876,0.00021},
	{0,8,-6,0,0,0,0,0,-2,1,0,0.454989882702401760017352,0.00012},
	{0,8,-6,0,0,0,0,0,-1,0,0,3.595665889369047629742226,0.00002},
	{0,8,-6,0,0,0,0,0,0,-2,0,5.971714023401603732565945,0.00001},
	{0,8,-6,0,0,0,0,0,0,-1,0,0.469221995554864379496252,0.00013},
	{0,8,-6,0,0,0,0,0,0,0,0,0.454164341966208418011064,0.00061},
	{0,8,-6,0,0,0,0,0,0,1,0,0.451617906587548745278582,0.00005},
	{0,8,-6,0,0,0,0,0,2,-2,0,4.931719969626761290726336,0.00001},
	{0,8,-6,0,0,0,0,0,2,-1,0,0.386894465672441401071779,0.00008},
	{0,8,-6,0,0,0,0,0,2,0,0,3.737377897984726971003511,0.00010},
	{0,8,-5,0,-3,0,0,0,-2,0,0,6.225051356855384021571354,0.00001},
	{0,8,-5,0,-3,0,0,0,-2,2,0,3.083458703265590461484180,0.00001},
	{0,8,-5,0,0,0,0,0,-2,1,0,4.839936594922884083302961,0.00002},
	{0,8,-5,0,0,0,0,0,0,0,0,4.955286975983516306598631,0.00003},
	{0,8,-5,0,0,0,0,0,2,-2,0,0.689023001964498615912191,0.00002},
	{0,8,-5,0,0,0,0,0,2,-1,0,0.676489618073002119125192,0.00002},
	{0,8,-5,0,0,0,0,0,2,0,0,0.689023001964498615912191,0.00002},
	{0,8,-4,0,-1,0,0,0,2,-2,0,5.644970061471118683016357,0.00001},
	{0,8,-4,0,-1,0,0,0,2,0,0,3.840956207773582598008488,0.00002},
	{0,8,-4,0,0,0,0,0,0,-1,0,5.379005445412084362999394,0.00001},
	{0,8,-4,0,0,0,0,0,0,0,0,5.057316306061226285351040,0.00002},
	{0,8,-4,0,0,0,0,0,0,2,0,5.379248046178112474535737,0.00002},
	{0,8,-4,0,0,0,0,0,2,-1,0,2.235231130257298914898456,0.00002},
	{0,8,-4,0,0,0,0,0,2,0,0,2.251642635746727183487792,0.00003},
	{0,8,-4,0,0,0,0,0,2,1,0,2.235983192631983751397229,0.00003},
	{0,8,-4,0,0,0,0,0,2,2,0,2.237655567121244803985292,0.00002},
	{0,8,-3,0,-2,0,0,0,2,-2,0,4.328776780903548448975471,0.00001},
	{0,8,-3,0,-2,0,0,0,2,0,0,1.187184127313755777066717,0.00001},
	{0,8,-3,0,-1,0,0,0,2,-3,0,2.260340658606966091070944,0.00001},
	{0,8,-3,0,-1,0,0,0,2,-1,0,5.401933312196758762979698,0.00001},
	{0,8,-3,0,-1,0,0,0,2,0,0,2.255499115261933695819607,0.00002},
	{0,8,-3,0,0,0,0,0,-2,2,0,5.272716115696106875532223,0.00001},
	{0,8,-2,0,-2,0,0,0,2,-2,0,5.380963704832822713797214,0.00001},
	{0,8,-2,0,-2,0,0,0,2,0,0,5.380963704832822713797214,0.00001},
	{0,8,-2,0,0,0,0,0,2,-2,0,5.829955938093672074273854,0.00002},
	{0,8,-2,0,0,0,0,0,2,0,0,5.829955938093672074273854,0.00002},
	{0,8,-1,-1,0,0,0,0,-2,1,0,1.104486064031134473495399,0.00002},
	{0,8,-1,0,-6,0,0,0,-2,1,0,4.422533075793880996684493,0.00003},
	{0,9,-18,0,0,0,0,0,-2,0,0,5.054795177956720841905280,0.00001},
	{0,9,-18,3,0,0,0,0,-2,2,0,4.094372255576627317452676,0.00020},
	{0,9,-17,0,0,0,0,0,-2,1,0,3.632338573079027188583723,0.00003},
	{0,9,-17,0,3,0,0,0,-2,0,2,6.259841179368311969710703,0.00005},
	{0,9,-16,0,0,0,0,0,-2,1,0,5.273599601363465616543635,0.00003},
	{0,9,-16,0,0,0,0,0,-2,3,0,4.682723270022691508529533,0.00001},
	{0,9,-16,0,0,0,0,0,0,0,0,5.357152352380789572805497,0.00002},
	{0,9,-16,0,2,0,0,0,-2,1,0,2.496277059418362753717702,0.00002},
	{0,9,-16,0,2,0,0,0,-2,3,0,5.637869713008155869715665,0.00002},
	{0,9,-15,0,0,0,0,0,-2,-1,0,3.902076241915022336570473,0.00001},
	{0,9,-15,0,0,0,0,0,-2,0,0,3.924677906662498383383308,0.00001},
	{0,9,-15,0,0,0,0,0,-2,1,0,4.163161091918405887213339,0.00004},
	{0,9,-15,0,0,0,0,0,-2,2,0,3.924677906662498383383308,0.00001},
	{0,9,-15,0,0,0,0,0,0,-1,0,1.033205944715060109473370,0.00003},
	{0,9,-15,0,0,0,0,0,0,-1,2,3.902076241915022336570473,0.00002},
	{0,9,-15,0,0,0,0,0,0,0,0,4.158153044162732570043772,0.00003},
	{0,9,-15,0,0,0,0,0,0,1,0,1.033205944715060109473370,0.00003},
	{0,9,-15,0,1,0,0,0,-2,0,0,2.474354851348687933665360,0.00002},
	{0,9,-15,0,1,0,0,0,-2,1,0,2.474354851348687933665360,0.00001},
	{0,9,-15,0,1,0,0,0,-2,2,0,2.474354851348687933665360,0.00002},
	{0,9,-15,0,1,0,0,0,-2,3,0,5.615947504938480605574114,0.00001},
	{0,9,-15,0,1,0,0,0,0,-1,0,2.480053002290599106771651,0.00002},
	{0,9,-15,0,1,0,0,0,0,1,0,2.480053002290599106771651,0.00002},
	{0,9,-15,0,2,0,0,0,-2,0,0,0.900098932910488036540642,0.00003},
	{0,9,-15,0,2,0,0,0,-2,1,0,0.900363524825090411063400,0.00006},
	{0,9,-15,0,2,0,0,0,-2,2,0,0.899061858268953018047398,0.00001},
	{0,9,-15,0,2,0,0,0,0,-1,0,0.900411870445370521309769,0.00002},
	{0,9,-15,0,2,0,0,0,0,1,0,0.900411870445370521309769,0.00002},
	{0,9,-15,0,3,0,0,0,0,-1,0,3.867206832388203618933176,0.00003},
	{0,9,-15,0,3,0,0,0,0,1,0,3.867206832388203618933176,0.00003},
	{0,9,-15,0,4,0,0,0,0,-1,0,0.562641790965412003089341,0.00001},
	{0,9,-15,0,4,0,0,0,0,1,0,0.562641790965412003089341,0.00001},
	{0,9,-15,2,0,0,0,0,-2,0,0,4.044760398924062805292579,0.00004},
	{0,9,-15,2,0,0,0,0,-2,2,0,4.044416569061420219100000,0.00003},
	{0,9,-15,2,0,0,0,0,0,-1,0,0.903971643987738215919592,0.00001},
	{0,9,-15,2,0,0,0,0,0,1,0,0.903971643987738215919592,0.00001},
	{0,9,-14,0,0,0,0,0,-4,2,0,1.971569650679196872289367,0.00001},
	{0,9,-14,0,0,0,0,0,-2,-1,0,5.655820424364917720083668,0.00004},
	{0,9,-14,0,0,0,0,0,-2,0,0,5.317817517962742712711588,0.00007},
	{0,9,-14,0,0,0,0,0,-2,1,0,4.552022020059068196928820,0.00003},
	{0,9,-14,0,0,0,0,0,-2,2,0,5.113162304268990432376540,0.00007},
	{0,9,-14,0,0,0,0,0,0,-1,0,3.959725165240095989815927,0.00002},
	{0,9,-14,0,0,0,0,0,0,0,0,3.229648005011410916154091,0.00005},
	{0,9,-14,0,0,0,0,0,0,1,0,3.959725165240095989815927,0.00002},
	{0,9,-14,0,0,0,0,0,2,-3,0,1.010188368006833536938416,0.00003},
	{0,9,-14,0,0,0,0,0,2,-1,0,1.010188368006833536938416,0.00003},
	{0,9,-14,0,1,0,0,0,-2,0,0,0.879423413525512898125669,0.00003},
	{0,9,-14,0,1,0,0,0,-2,1,0,4.020725644327773906638868,0.00001},
	{0,9,-14,0,1,0,0,0,-2,3,0,0.879423413525512898125669,0.00003},
	{0,9,-14,0,1,0,0,0,0,-1,0,4.021016067115305681056725,0.00004},
	{0,9,-14,0,1,0,0,0,0,1,0,4.021016067115305681056725,0.00004},
	{0,9,-14,0,2,0,0,0,-2,0,0,1.952957634068854586573138,0.00003},
	{0,9,-14,2,0,0,0,0,-2,0,0,1.664330964870225360030531,0.00001},
	{0,9,-14,2,0,0,0,0,-2,2,0,1.664330964870225360030531,0.00001},
	{0,9,-13,-3,0,0,0,0,0,-1,0,4.652488233258693206551015,0.00003},
	{0,9,-13,-3,0,0,0,0,0,1,0,4.652488233258693206551015,0.00003},
	{0,9,-13,0,-1,0,0,0,-2,0,0,4.213917710027352825363778,0.00008},
	{0,9,-13,0,0,0,0,0,-2,0,0,0.746195275870852436916891,0.00003},
	{0,9,-13,0,0,0,0,0,-2,1,0,4.006048123450202780304608,0.00002},
	{0,9,-13,0,0,0,0,0,-2,2,0,0.696357050014303924356796,0.00001},
	{0,9,-13,0,0,0,0,0,-2,3,0,4.045300578327554852364756,0.00003},
	{0,9,-13,0,0,0,0,0,0,-1,0,3.213978962585781751215563,0.00006},
	{0,9,-13,0,0,0,0,0,0,0,0,2.946216133798417846634266,0.00003},
	{0,9,-13,0,0,0,0,0,0,1,0,4.045300403794629851006448,0.00003},
	{0,9,-13,0,0,0,0,0,1,0,-1,5.813288916401750938689474,0.00002},
	{0,9,-13,0,0,0,0,0,2,-3,0,1.072634328781013390852195,0.00004},
	{0,9,-13,0,0,0,0,0,2,-2,0,5.872470064277151458043136,0.00004},
	{0,9,-13,0,0,0,0,0,2,-1,0,5.941694883866076359879571,0.00024},
	{0,9,-13,0,0,0,0,0,2,0,0,1.310854318385719530226652,0.00002},
	{0,9,-13,0,1,0,0,0,-2,0,0,0.677898447845211915563368,0.00007},
	{0,9,-13,0,1,0,0,0,2,-3,0,0.639686732800823665279211,0.00001},
	{0,9,-13,0,1,0,0,0,2,-1,0,5.165803528904241659347463,0.00002},
	{0,9,-13,0,2,0,0,0,2,-2,0,0.273503740295948594152264,0.00001},
	{0,9,-12,-2,0,0,0,0,-2,0,0,3.336669500348600880812455,0.00001},
	{0,9,-12,-2,0,0,0,0,-2,2,0,3.336669500348600880812455,0.00001},
	{0,9,-12,0,-1,0,0,0,-2,0,0,0.936432150080954817106260,0.00006},
	{0,9,-12,0,-1,0,0,0,-2,2,0,0.886762348497223795718014,0.00002},
	{0,9,-12,0,-1,0,0,0,0,0,0,4.058341329432606947591466,0.00002},
	{0,9,-12,0,0,0,0,0,-2,0,0,5.527951669244355770160837,0.00002},
	{0,9,-12,0,0,0,0,0,-2,1,0,1.978855178575796847084689,0.00002},
	{0,9,-12,0,0,0,0,0,-2,2,0,5.236759889644070575798196,0.00003},
	{0,9,-12,0,0,0,0,0,0,-1,0,4.455043498303704829766048,0.00006},
	{0,9,-12,0,0,0,0,0,0,0,0,1.164596250667370380682542,0.00016},
	{0,9,-12,0,0,0,0,0,1,0,-1,4.358010173209827975426833,0.00005},
	{0,9,-12,0,0,0,0,0,2,-2,0,1.434044892979235319430131,0.00001},
	{0,9,-12,0,0,0,0,0,2,-1,0,1.313507567914601104064332,0.00024},
	{0,9,-12,0,0,0,0,0,2,0,0,4.454338908884674985699803,0.00006},
	{0,9,-12,0,2,0,0,0,2,-1,0,1.591664879595142245705119,0.00002},
	{0,9,-11,0,0,0,0,0,-2,0,0,3.452206282573345941244725,0.00002},
	{0,9,-11,0,0,0,0,0,-2,2,0,5.966304898983822546654210,0.00003},
	{0,9,-11,0,0,0,0,0,-2,3,0,0.418079310615375288051609,0.00001},
	{0,9,-11,0,0,0,0,0,-1,0,1,0.144426344668381168023785,0.00002},
	{0,9,-11,0,0,0,0,0,0,-1,0,5.526674262764821321525233,0.00002},
	{0,9,-11,0,0,0,0,0,0,0,0,6.013562481008372984092603,0.00057},
	{0,9,-11,0,0,0,0,0,0,1,0,6.077610828568808187810646,0.00009},
	{0,9,-11,0,0,0,0,0,1,0,-1,2.945803363430321564209180,0.00014},
	{0,9,-11,0,0,0,0,0,1,0,0,2.881715222362939865519138,0.00002},
	{0,9,-11,0,0,0,0,0,2,-2,0,6.138128549585384341469307,0.00002},
	{0,9,-11,0,0,0,0,0,2,-1,0,6.156385042627095849354646,0.00061},
	{0,9,-11,0,0,0,0,0,2,0,-2,6.142457664262031435953304,0.00002},
	{0,9,-11,0,0,0,0,0,2,0,0,3.031276325690688278058360,0.00024},
	{0,9,-11,0,0,0,0,0,2,1,0,2.983566877922797289102164,0.00003},
	{0,9,-11,0,0,0,0,0,4,-1,0,2.997310124051776103470957,0.00001},
	{0,9,-11,0,0,0,0,0,4,0,0,2.998872717331086956704667,0.00002},
	{0,9,-11,0,1,0,0,0,-2,0,0,4.721374633505657669729771,0.00001},
	{0,9,-11,0,1,0,0,0,-2,2,0,1.579781979915864331687203,0.00001},
	{0,9,-11,0,1,0,0,0,2,0,0,1.571186756948567575520315,0.00002},
	{0,9,-11,0,2,0,0,0,2,-2,0,3.138576550109421603451665,0.00002},
	{0,9,-11,2,0,0,0,0,-2,0,0,3.127471369144832369357800,0.00001},
	{0,9,-11,2,0,0,0,0,-2,2,0,3.127471369144832369357800,0.00001},
	{0,9,-11,2,0,0,0,0,0,0,0,0.013861230386413764259501,0.00001},
	{0,9,-11,2,0,0,0,0,2,-2,0,0.000803549587618189323571,0.00002},
	{0,9,-11,2,0,0,0,0,2,0,0,0.000803549587618189323571,0.00002},
	{0,9,-11,4,0,0,0,0,-2,0,0,1.011278500657629253467462,0.00001},
	{0,9,-11,4,0,0,0,0,-2,2,0,1.011278500657629253467462,0.00001},
	{0,9,-10,0,-1,0,0,0,-2,0,0,1.819417606076862981012709,0.00002},
	{0,9,-10,0,0,0,0,0,-2,0,0,4.815181892010147457483527,0.00005},
	{0,9,-10,0,0,0,0,0,-2,1,0,1.308925205963490157046181,0.00002},
	{0,9,-10,0,0,0,0,0,-2,2,0,1.641626151163956492951002,0.00002},
	{0,9,-10,0,0,0,0,0,-2,3,0,4.731239408970854931624217,0.00001},
	{0,9,-10,0,0,0,0,0,-1,0,-1,1.321970669457521951883905,0.00002},
	{0,9,-10,0,0,0,0,0,-1,0,1,4.450325000670938280222799,0.00009},
	{0,9,-10,0,0,0,0,0,-1,1,-1,1.321633471846036522734380,0.00002},
	{0,9,-10,0,0,0,0,0,0,-1,0,4.668200036250996554088033,0.00004},
	{0,9,-10,0,0,0,0,0,0,0,0,4.742951964515137674993639,0.00168},
	{0,9,-10,0,0,0,0,0,0,1,0,4.750816767190475076176881,0.00038},
	{0,9,-10,0,0,0,0,0,0,2,0,4.753841073718330534347842,0.00003},
	{0,9,-10,0,0,0,0,0,1,-1,-1,1.418771342162107540474381,0.00007},
	{0,9,-10,0,0,0,0,0,1,-1,1,4.464232482282529446138142,0.00003},
	{0,9,-10,0,0,0,0,0,1,0,-1,1.322607714634499664896339,0.00045},
	{0,9,-10,0,0,0,0,0,1,0,0,1.571197752522855317636186,0.00003},
	{0,9,-10,0,0,0,0,0,1,0,1,1.322995526794292775463191,0.00001},
	{0,9,-10,0,0,0,0,0,1,1,-1,1.456395404847349528409950,0.00005},
	{0,9,-10,0,0,0,0,0,2,-3,0,4.857579255666668593960367,0.00002},
	{0,9,-10,0,0,0,0,0,2,-2,0,4.264554773082539718132011,0.00005},
	{0,9,-10,0,0,0,0,0,2,-1,0,4.757910832468130735151135,0.00179},
	{0,9,-10,0,0,0,0,0,2,0,-2,4.752609569398122957295527,0.00006},
	{0,9,-10,0,0,0,0,0,2,0,0,1.642054629495321105281391,0.00117},
	{0,9,-10,0,0,0,0,0,2,1,0,1.634168533803110001656478,0.00017},
	{0,9,-10,0,0,0,0,0,2,2,0,1.616350292936574506441616,0.00002},
	{0,9,-10,0,0,0,0,0,3,0,0,1.613239941676595456954146,0.00002},
	{0,9,-10,0,0,0,0,0,4,-2,0,4.871300859712923703170873,0.00003},
	{0,9,-10,0,0,0,0,0,4,-1,0,4.647580716467936134961292,0.00001},
	{0,9,-10,0,0,0,0,0,4,0,0,1.710771732804841738229129,0.00004},
	{0,9,-10,0,1,0,0,0,-2,0,0,3.675248016338083179022078,0.00004},
	{0,9,-10,0,1,0,0,0,-2,2,0,6.255554999791264059183504,0.00002},
	{0,9,-10,0,2,0,0,0,-2,0,0,4.060480579496775987990986,0.00001},
	{0,9,-10,0,2,0,0,0,-2,2,0,4.060480579496775987990986,0.00001},
	{0,9,-10,3,0,0,0,0,-2,0,0,4.125527429922278166429805,0.00001},
	{0,9,-10,3,0,0,0,0,-2,2,0,4.125527429922278166429805,0.00001},
	{0,9,-10,3,0,0,0,0,0,0,0,4.133369019718562853427102,0.00001},
	{0,9,-9,0,-1,0,0,0,-2,0,0,3.216258886187662202615911,0.00007},
	{0,9,-9,0,-1,0,0,0,-2,2,0,3.239034036662785887017435,0.00001},
	{0,9,-9,0,0,0,0,0,-4,1,0,3.143912370698619174191890,0.00001},
	{0,9,-9,0,0,0,0,0,-4,2,0,3.117145826757108384441608,0.00002},
	{0,9,-9,0,0,0,0,0,-4,3,0,3.144774039750328320508288,0.00001},
	{0,9,-9,0,0,0,0,0,-2,-2,0,0.002952922561449206322742,0.00003},
	{0,9,-9,0,0,0,0,0,-2,-1,0,3.169403428022771418426373,0.00002},
	{0,9,-9,0,0,0,0,0,-2,0,0,3.150861922714209839568866,0.00039},
	{0,9,-9,0,0,0,0,0,-2,1,0,3.145744442814437213939982,0.00027},
	{0,9,-9,0,0,0,0,0,-2,2,0,6.254972757952798723124488,0.00009},
	{0,9,-9,0,0,0,0,0,-2,3,0,6.275463970568763372170906,0.00001},
	{0,9,-9,0,0,0,0,0,-1,0,-1,0.257073559783524363542284,0.00001},
	{0,9,-9,0,0,0,0,0,-1,0,0,6.281539112629105581220301,0.00009},
	{0,9,-9,0,0,0,0,0,-1,0,1,0.300290704589707191374259,0.00001},
	{0,9,-9,0,0,0,0,0,0,-1,0,3.141641871874699454281199,0.00051},
	{0,9,-9,0,0,0,0,0,0,0,0,3.140831166437147992098744,0.00748},
	{0,9,-9,0,0,0,0,0,0,0,2,0.000116587994033221214324,0.00001},
	{0,9,-9,0,0,0,0,0,0,1,0,3.145071792920718589670059,0.00128},
	{0,9,-9,0,0,0,0,0,0,2,0,3.155317224695775912834961,0.00013},
	{0,9,-9,0,0,0,0,0,1,-1,0,0.059922738274571715755279,0.00001},
	{0,9,-9,0,0,0,0,0,1,0,-1,3.336935837592455378342038,0.00011},
	{0,9,-9,0,0,0,0,0,1,0,0,0.005214345673258259476757,0.00007},
	{0,9,-9,0,0,0,0,0,1,0,1,3.336923794820616961942505,0.00002},
	{0,9,-9,0,0,0,0,0,1,1,0,3.142441407205037950944870,0.00001},
	{0,9,-9,0,0,0,0,0,2,-3,0,3.102421356522658602017373,0.00002},
	{0,9,-9,0,0,0,0,0,2,-2,0,3.140410542087417322676401,0.00027},
	{0,9,-9,0,0,0,0,0,2,-1,0,3.141540642778083647357334,0.00536},
	{0,9,-9,0,0,0,0,0,2,0,-2,3.141725822211720586807360,0.00017},
	{0,9,-9,0,0,0,0,0,2,0,0,0.001084023998413678052666,0.00451},
	{0,9,-9,0,0,0,0,0,2,0,2,3.141649725856332953100036,0.00002},
	{0,9,-9,0,0,0,0,0,2,1,0,6.283159301773731719720217,0.00038},
	{0,9,-9,0,0,0,0,0,2,2,0,6.282608126795951264398354,0.00005},
	{0,9,-9,0,0,0,0,0,3,-1,0,3.142400391967616002375507,0.00002},
	{0,9,-9,0,0,0,0,0,3,0,0,0.000820653814287733776589,0.00004},
	{0,9,-9,0,0,0,0,0,4,-2,0,3.141580087219178807345088,0.00008},
	{0,9,-9,0,0,0,0,0,4,-1,0,0.000039793506945470712654,0.00005},
	{0,9,-9,0,0,0,0,0,4,0,0,0.000004537856055185256840,0.00008},
	{0,9,-9,0,0,0,0,0,4,1,0,0.000031590459461097363458,0.00001},
	{0,9,-9,0,1,0,0,0,-2,0,0,6.077709090605695863018809,0.00007},
	{0,9,-9,0,1,0,0,0,-2,1,0,3.013906459908990420615282,0.00002},
	{0,9,-9,0,1,0,0,0,0,0,0,3.066759567515433992923590,0.00002},
	{0,9,-9,0,1,0,0,0,2,-2,0,2.912673698101889918632423,0.00001},
	{0,9,-9,0,1,0,0,0,2,0,0,2.912673698101889918632423,0.00001},
	{0,9,-9,11,0,0,0,0,-2,1,0,5.259322459016302353518313,0.00001},
	{0,9,-8,-3,0,0,0,0,-2,0,0,5.289858390543344945911031,0.00002},
	{0,9,-8,-3,0,0,0,0,-2,2,0,5.289858390543344945911031,0.00002},
	{0,9,-8,-2,0,0,0,0,-2,1,0,2.378798074801998119198743,0.00001},
	{0,9,-8,-2,0,0,0,0,0,0,0,5.442477136187661379551628,0.00001},
	{0,9,-8,0,-1,0,0,0,-2,2,0,3.116577023953883696094636,0.00001},
	{0,9,-8,0,-1,0,0,0,0,-2,0,3.158379753934250189217892,0.00002},
	{0,9,-8,0,-1,0,0,0,0,0,0,3.165470154020477266954003,0.00009},
	{0,9,-8,0,-1,0,0,0,2,0,0,3.164173548919170464444051,0.00002},
	{0,9,-8,0,0,0,0,0,-2,0,0,4.451580066936046797820836,0.00002},
	{0,9,-8,0,0,0,0,0,-2,1,0,4.488443166067419554110529,0.00001},
	{0,9,-8,0,0,0,0,0,-1,-1,1,4.943338451924363496914339,0.00002},
	{0,9,-8,0,0,0,0,0,-1,0,-1,1.801762902561239609866561,0.00012},
	{0,9,-8,0,0,0,0,0,-1,0,1,4.943314017314834885041819,0.00015},
	{0,9,-8,0,0,0,0,0,-1,1,-1,1.801961346497191307491903,0.00006},
	{0,9,-8,0,0,0,0,0,-1,2,1,4.944434867760466367769823,0.00002},
	{0,9,-8,0,0,0,0,0,0,-1,0,3.599066837949483677050466,0.00001},
	{0,9,-8,0,0,0,0,0,0,0,0,6.041451969790615272870582,0.00001},
	{0,9,-8,0,0,0,0,0,1,-1,-1,1.802709394614595783679079,0.00009},
	{0,9,-8,0,0,0,0,0,1,-1,1,4.944441500011623524812876,0.00002},
	{0,9,-8,0,0,0,0,0,1,0,-1,1.802964910817087762495703,0.00045},
	{0,9,-8,0,0,0,0,0,1,0,1,1.802800151735699518695810,0.00003},
	{0,9,-8,0,0,0,0,0,1,1,-1,1.802851813481558762575219,0.00004},
	{0,9,-8,0,0,0,0,0,2,-1,0,4.697147194559948779613023,0.00020},
	{0,9,-8,0,0,0,0,0,2,0,0,1.566972834002552605880965,0.00030},
	{0,9,-8,0,0,0,0,0,2,1,0,1.606739811943393103632616,0.00003},
	{0,9,-8,0,0,0,0,0,4,-1,0,1.577225421627542756297657,0.00001},
	{0,9,-8,0,0,0,0,0,4,0,0,1.477941145397368982727926,0.00002},
	{0,9,-7,-3,0,0,0,0,-2,0,0,5.867877230350527995028642,0.00001},
	{0,9,-7,-3,0,0,0,0,-2,2,0,5.867877230350527995028642,0.00001},
	{0,9,-7,-2,0,0,0,0,-2,0,0,0.009078504637173703817332,0.00001},
	{0,9,-7,-2,0,0,0,0,-2,2,0,0.009078504637173703817332,0.00001},
	{0,9,-7,0,-3,0,0,0,-2,0,0,0.130444686563579798077583,0.00001},
	{0,9,-7,0,-3,0,0,0,-2,2,0,0.130444686563579798077583,0.00001},
	{0,9,-7,0,-2,0,0,0,-2,2,0,0.004943645106273938417962,0.00002},
	{0,9,-7,0,-2,0,0,0,0,0,0,6.281186207054352266254682,0.00005},
	{0,9,-7,0,0,0,0,0,-2,-1,0,0.453914585350248089845593,0.00002},
	{0,9,-7,0,0,0,0,0,-2,0,0,0.434520661235012262135768,0.00021},
	{0,9,-7,0,0,0,0,0,-2,1,0,0.457705440485579706511032,0.00012},
	{0,9,-7,0,0,0,0,0,-1,0,0,3.597011887288185771893723,0.00002},
	{0,9,-7,0,0,0,0,0,0,-1,0,0.348806319939094389148693,0.00012},
	{0,9,-7,0,0,0,0,0,0,0,0,0.463483352974306983540487,0.00047},
	{0,9,-7,0,0,0,0,0,0,1,0,0.278055384452224607638726,0.00004},
	{0,9,-7,0,0,0,0,0,2,-2,0,5.513054411413958355581144,0.00002},
	{0,9,-7,0,0,0,0,0,2,-1,0,0.451478454780314342187353,0.00007},
	{0,9,-7,0,0,0,0,0,2,0,0,3.675596733122632020496212,0.00008},
	{0,9,-6,-4,0,0,0,0,0,0,0,2.630761659601533519747818,0.00001},
	{0,9,-6,0,-3,0,0,0,-2,0,0,6.224870715277802446507849,0.00002},
	{0,9,-6,0,-1,0,0,0,-2,0,0,0.420704634876225169737296,0.00001},
	{0,9,-6,0,-1,0,0,0,-2,2,0,3.562297288466018230224108,0.00001},
	{0,9,-6,0,0,0,0,0,-2,1,0,4.815596931306272310280292,0.00002},
	{0,9,-6,0,0,0,0,0,0,0,0,4.579966835778600753315004,0.00004},
	{0,9,-6,0,0,0,0,0,2,-3,0,0.687095634871521254716242,0.00001},
	{0,9,-6,0,0,0,0,0,2,-2,0,0.688945683878635306562899,0.00001},
	{0,9,-6,0,0,0,0,0,2,-1,0,0.687095634871521254716242,0.00001},
	{0,9,-6,0,0,0,0,0,2,0,0,0.688945683878635306562899,0.00001},
	{0,9,-5,0,0,0,0,0,-2,1,0,3.790185452497693674445145,0.00001},
	{0,9,-5,0,0,0,0,0,0,-1,0,5.374878265329893878288203,0.00002},
	{0,9,-5,0,0,0,0,0,0,0,0,5.379170204493473939066917,0.00002},
	{0,9,-5,0,0,0,0,0,0,2,0,5.379170204493473939066917,0.00002},
	{0,9,-5,0,0,0,0,0,2,-2,0,2.256096192399041022724759,0.00002},
	{0,9,-5,0,0,0,0,0,2,-1,0,2.238569945116364312553969,0.00001},
	{0,9,-5,0,0,0,0,0,2,0,0,2.229514129759466278812852,0.00006},
	{0,9,-5,0,0,0,0,0,2,1,0,2.238569945116364312553969,0.00001},
	{0,9,-5,0,0,0,0,0,2,2,0,2.237925744089453328200534,0.00004},
	{0,9,-4,0,-1,0,0,0,2,-2,0,5.409327050506981926503158,0.00001},
	{0,9,-4,0,-1,0,0,0,2,0,0,5.409327050506981926503158,0.00001},
	{0,9,-4,0,0,-1,0,0,-3,2,0,2.235654547133832714678192,0.00005},
	{0,9,-4,0,0,0,0,0,-2,0,0,5.272376474623668762831130,0.00002},
	{0,9,-4,0,0,0,0,0,-2,2,0,5.272376474623668762831130,0.00002},
	{0,9,-4,0,0,0,0,0,2,-2,0,0.629554572894221009526916,0.00002},
	{0,9,-4,0,0,0,0,0,2,0,0,0.629554572894221009526916,0.00002},
	{0,9,-3,0,-2,0,0,0,-2,0,0,1.519632523371458265870615,0.00001},
	{0,9,-3,0,-2,0,0,0,-2,1,0,6.104068623765640744238681,0.00007},
	{0,9,-3,0,-2,0,0,0,-2,2,0,4.661225176961251825957788,0.00001},
	{0,9,-3,0,-2,0,0,0,2,-2,0,2.240655788105422541178768,0.00001},
	{0,9,-3,0,-2,0,0,0,2,0,0,5.382248441695215213087522,0.00001},
	{0,9,-3,0,-1,0,0,0,-2,1,0,6.178765399625419263429649,0.00002},
	{0,9,-3,0,0,-4,0,0,-2,1,0,3.525313063484557751792181,0.00003},
	{0,9,-3,0,0,0,0,0,-2,0,0,0.376476246301436834329479,0.00001},
	{0,9,-3,0,0,0,0,0,-2,1,0,1.090390784992028239130946,0.00004},
	{0,9,-3,0,0,0,0,0,-2,2,0,0.376476246301436834329479,0.00001},
	{0,9,-3,0,0,0,0,0,2,0,0,5.831393914864389849128656,0.00002},
	{0,9,-2,0,-3,0,0,0,-1,0,0,1.411910801938368376085009,0.00001},
	{0,9,-1,-4,0,0,0,0,-2,1,0,1.151425821598895948838504,0.00004},
	{0,9,-1,0,-4,0,0,0,0,-1,0,0.506211456524080949392896,0.00001},
	{0,9,8,-21,0,0,0,0,-2,1,0,4.249551399233620685436108,0.00003},
	{0,10,-19,0,0,0,0,0,-2,0,0,5.054740374618208242907258,0.00002},
	{0,10,-19,0,0,0,0,0,-2,2,0,5.054751370192495762978524,0.00001},
	{0,10,-18,0,0,-1,0,0,-2,2,0,2.129990917954694751301759,0.00001},
	{0,10,-18,0,0,0,0,0,-2,1,0,1.167810449017843144048356,0.00002},
	{0,10,-18,0,0,0,0,0,-2,3,0,6.153715387003245496089221,0.00001},
	{0,10,-18,0,2,0,0,0,-2,1,0,0.771480907942045490699456,0.00001},
	{0,10,-18,0,2,0,0,0,-2,3,0,0.771480907942045490699456,0.00001},
	{0,10,-17,0,0,0,0,0,0,0,0,5.370829101465267818582561,0.00002},
	{0,10,-16,0,0,0,0,0,-2,-1,0,3.917109809960000799122781,0.00001},
	{0,10,-16,0,0,0,0,0,-2,1,0,3.917109809960000799122781,0.00001},
	{0,10,-16,0,0,0,0,0,0,0,0,4.871883276084314040588197,0.00002},
	{0,10,-16,0,0,0,0,0,2,-1,0,0.775517156370207683124818,0.00002},
	{0,10,-16,0,1,0,0,0,-2,0,0,2.475066247551800380222176,0.00003},
	{0,10,-16,0,1,0,0,0,0,2,-2,5.616658901141594384398559,0.00001},
	{0,10,-16,0,2,0,0,0,-2,0,0,0.899551946722912942888684,0.00002},
	{0,10,-16,0,2,0,0,0,-2,1,0,4.041582852487882071557124,0.00002},
	{0,10,-16,0,2,0,0,0,-2,2,0,0.899551946722912942888684,0.00002},
	{0,10,-16,0,2,0,0,0,-2,3,0,4.041582852487882071557124,0.00002},
	{0,10,-16,0,2,0,0,0,0,-1,0,0.899552121255838166291596,0.00002},
	{0,10,-16,0,2,0,0,0,0,1,0,0.899552121255838166291596,0.00002},
	{0,10,-15,0,0,0,0,0,-2,-1,0,5.655920257198131295695021,0.00003},
	{0,10,-15,0,0,0,0,0,-2,0,0,6.241943526020810928400806,0.00001},
	{0,10,-15,0,0,0,0,0,-2,1,0,5.738441518627525717022309,0.00001},
	{0,10,-15,0,0,0,0,0,-2,2,0,5.921385010959394179508308,0.00003},
	{0,10,-15,0,0,0,0,0,0,0,0,3.024999772634666239667922,0.00002},
	{0,10,-15,0,0,0,0,0,1,0,-1,0.971312729714986611284644,0.00001},
	{0,10,-15,0,0,0,0,0,2,-3,0,4.151798125823296103931170,0.00004},
	{0,10,-15,0,0,0,0,0,2,-1,0,4.151798125823296103931170,0.00004},
	{0,10,-15,0,0,0,0,0,2,0,0,1.010749316828424504421946,0.00002},
	{0,10,-15,0,1,0,0,0,-2,0,0,0.879077314734842407695226,0.00003},
	{0,10,-15,0,1,0,0,0,-2,1,0,0.879512076251514174352053,0.00004},
	{0,10,-15,0,1,0,0,0,0,-1,0,0.879512076251514174352053,0.00001},
	{0,10,-15,0,1,0,0,0,0,1,0,0.879512076251514174352053,0.00001},
	{0,10,-15,0,2,0,0,0,-2,0,0,1.952668433011799153931065,0.00002},
	{0,10,-15,1,0,0,0,0,2,-2,0,4.035247481836067962035486,0.00001},
	{0,10,-15,2,0,0,0,0,-2,0,0,1.664041938346095150791371,0.00001},
	{0,10,-15,2,0,0,0,0,-2,2,0,1.664041938346095150791371,0.00001},
	{0,10,-14,0,-1,0,0,0,-2,0,0,4.213814561068559783052478,0.00007},
	{0,10,-14,0,0,0,0,0,-2,0,0,1.211746320409996968692212,0.00003},
	{0,10,-14,0,0,0,0,0,-2,1,0,4.043042296808399882479534,0.00001},
	{0,10,-14,0,0,0,0,0,-2,2,0,0.592242400546310610032208,0.00004},
	{0,10,-14,0,0,0,0,0,-2,3,0,4.043042296808399882479534,0.00001},
	{0,10,-14,0,0,0,0,0,-1,0,0,4.044660740623773342861114,0.00002},
	{0,10,-14,0,0,0,0,0,0,0,0,2.857622173769634787987570,0.00003},
	{0,10,-14,0,0,0,0,0,1,0,-1,5.824889945406832580943046,0.00001},
	{0,10,-14,0,0,0,0,0,2,-1,-2,4.008770138951613049016487,0.00001},
	{0,10,-14,0,0,0,0,0,2,-1,0,2.715054604754627565199598,0.00007},
	{0,10,-14,0,0,0,0,0,2,0,0,2.202647403918891910734601,0.00002},
	{0,10,-14,0,0,0,0,0,2,1,-2,4.008770138951613049016487,0.00001},
	{0,10,-14,0,1,0,0,0,-2,0,0,0.677898796911062251346891,0.00003},
	{0,10,-14,0,1,0,0,0,-2,2,0,3.819491450500855922456367,0.00003},
	{0,10,-13,-2,0,0,0,0,-2,0,0,3.336380473824470449528690,0.00001},
	{0,10,-13,-2,0,0,0,0,-2,2,0,3.336380473824470449528690,0.00001},
	{0,10,-13,0,-1,0,0,0,-2,0,0,0.936159878717643723078368,0.00006},
	{0,10,-13,0,-1,0,0,0,-2,2,0,4.028456754782408388848580,0.00002},
	{0,10,-13,0,0,0,0,0,-2,1,0,1.905541750681149171242623,0.00001},
	{0,10,-13,0,0,0,0,0,0,-1,0,4.193656706339726980559135,0.00003},
	{0,10,-13,0,0,0,0,0,0,0,0,1.179214081284523762960248,0.00013},
	{0,10,-13,0,0,0,0,0,1,0,-1,4.369412583746031586429126,0.00003},
	{0,10,-13,0,0,0,0,0,2,-1,0,1.333891966380343685472099,0.00012},
	{0,10,-13,0,0,0,0,0,2,0,0,4.467624180617930207404243,0.00007},
	{0,10,-13,0,1,0,0,0,0,0,0,6.167036437986167740632482,0.00001},
	{0,10,-13,0,2,0,0,0,0,0,0,4.711062530153173888436413,0.00001},
	{0,10,-12,0,0,0,0,0,-2,0,0,6.177007853068660736539641,0.00001},
	{0,10,-12,0,0,0,0,0,-2,2,0,5.841909698140580253777898,0.00002},
	{0,10,-12,0,0,0,0,0,0,-1,0,6.175132322254467176492199,0.00005},
	{0,10,-12,0,0,0,0,0,0,0,0,6.018774732286527928692976,0.00043},
	{0,10,-12,0,0,0,0,0,0,1,0,6.090055200668452961565436,0.