/* GSequencer - Advanced GTK Sequencer
 * Copyright (C) 2005-2022 Joël Krähemann
 *
 * This file is part of GSequencer.
 *
 * GSequencer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GSequencer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GSequencer.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ags/app/ags_gsequencer_resource.h>

#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.ags_gsequencer"), aligned (sizeof(void *) > 8 ? sizeof(void *) : 8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[11406]; const double alignment; void * const ptr;}  ags_gsequencer_resource_data = {
  "\107\126\141\162\151\141\156\164\000\000\000\000\000\000\000\000"
  "\030\000\000\000\124\001\000\000\000\000\000\050\013\000\000\000"
  "\000\000\000\000\000\000\000\000\002\000\000\000\002\000\000\000"
  "\004\000\000\000\005\000\000\000\007\000\000\000\010\000\000\000"
  "\010\000\000\000\012\000\000\000\012\000\000\000\320\241\356\333"
  "\004\000\000\000\124\001\000\000\013\000\114\000\140\001\000\000"
  "\144\001\000\000\227\126\056\122\003\000\000\000\144\001\000\000"
  "\020\000\166\000\170\001\000\000\277\005\000\000\324\265\002\000"
  "\377\377\377\377\277\005\000\000\001\000\114\000\300\005\000\000"
  "\304\005\000\000\267\023\033\263\010\000\000\000\304\005\000\000"
  "\003\000\114\000\310\005\000\000\330\005\000\000\117\114\323\121"
  "\005\000\000\000\330\005\000\000\007\000\114\000\340\005\000\000"
  "\344\005\000\000\113\120\220\013\002\000\000\000\344\005\000\000"
  "\004\000\114\000\350\005\000\000\354\005\000\000\272\377\101\223"
  "\000\000\000\000\354\005\000\000\004\000\114\000\360\005\000\000"
  "\364\005\000\000\165\337\244\336\003\000\000\000\364\005\000\000"
  "\023\000\166\000\010\006\000\000\356\015\000\000\212\150\206\137"
  "\006\000\000\000\356\015\000\000\004\000\114\000\364\015\000\000"
  "\370\015\000\000\006\110\222\065\003\000\000\000\370\015\000\000"
  "\023\000\166\000\020\016\000\000\034\037\000\000\272\143\351\207"
  "\003\000\000\000\034\037\000\000\017\000\166\000\060\037\000\000"
  "\215\054\000\000\147\163\145\161\165\145\156\143\145\162\057\000"
  "\006\000\000\000\141\147\163\137\145\144\151\164\137\155\145\156"
  "\165\056\165\151\000\000\000\000\067\004\000\000\000\000\000\000"
  "\074\077\170\155\154\040\166\145\162\163\151\157\156\075\042\061"
  "\056\060\042\040\145\156\143\157\144\151\156\147\075\042\125\124"
  "\106\055\070\042\077\076\012\074\151\156\164\145\162\146\141\143"
  "\145\076\012\040\040\074\155\145\156\165\040\151\144\075\042\141"
  "\147\163\055\145\144\151\164\055\155\145\156\165\042\076\012\040"
  "\040\040\040\074\163\145\143\164\151\157\156\076\012\040\040\040"
  "\040\040\040\074\151\164\145\155\076\012\040\040\040\040\040\040"
  "\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155"
  "\145\075\042\154\141\142\145\154\042\040\164\162\141\156\163\154"
  "\141\164\141\142\154\145\075\042\171\145\163\042\076\116\157\164"
  "\141\164\151\157\156\074\057\141\164\164\162\151\142\165\164\145"
  "\076\012\040\040\040\040\040\040\040\040\074\141\164\164\162\151"
  "\142\165\164\145\040\156\141\155\145\075\042\141\143\164\151\157"
  "\156\042\076\141\160\160\056\145\144\151\164\137\156\157\164\141"
  "\164\151\157\156\074\057\141\164\164\162\151\142\165\164\145\076"
  "\012\040\040\040\040\040\040\074\057\151\164\145\155\076\012\040"
  "\040\040\040\040\040\074\151\164\145\155\076\012\040\040\040\040"
  "\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156"
  "\141\155\145\075\042\154\141\142\145\154\042\040\164\162\141\156"
  "\163\154\141\164\141\142\154\145\075\042\171\145\163\042\076\101"
  "\165\164\157\155\141\164\151\157\156\074\057\141\164\164\162\151"
  "\142\165\164\145\076\012\040\040\040\040\040\040\040\040\074\141"
  "\164\164\162\151\142\165\164\145\040\156\141\155\145\075\042\141"
  "\143\164\151\157\156\042\076\141\160\160\056\145\144\151\164\137"
  "\141\165\164\157\155\141\164\151\157\156\074\057\141\164\164\162"
  "\151\142\165\164\145\076\012\040\040\040\040\040\040\074\057\151"
  "\164\145\155\076\012\040\040\040\040\040\040\074\151\164\145\155"
  "\076\012\040\040\040\040\040\040\040\040\074\141\164\164\162\151"
  "\142\165\164\145\040\156\141\155\145\075\042\154\141\142\145\154"
  "\042\040\164\162\141\156\163\154\141\164\141\142\154\145\075\042"
  "\171\145\163\042\076\127\141\166\145\074\057\141\164\164\162\151"
  "\142\165\164\145\076\012\040\040\040\040\040\040\040\040\074\141"
  "\164\164\162\151\142\165\164\145\040\156\141\155\145\075\042\141"
  "\143\164\151\157\156\042\076\141\160\160\056\145\144\151\164\137"
  "\167\141\166\145\074\057\141\164\164\162\151\142\165\164\145\076"
  "\012\040\040\040\040\040\040\074\057\151\164\145\155\076\012\040"
  "\040\040\040\040\040\074\151\164\145\155\076\012\040\040\040\040"
  "\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156"
  "\141\155\145\075\042\154\141\142\145\154\042\040\164\162\141\156"
  "\163\154\141\164\141\142\154\145\075\042\171\145\163\042\076\123"
  "\150\145\145\164\074\057\141\164\164\162\151\142\165\164\145\076"
  "\012\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142"
  "\165\164\145\040\156\141\155\145\075\042\141\143\164\151\157\156"
  "\042\076\141\160\160\056\145\144\151\164\137\163\150\145\145\164"
  "\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040"
  "\040\040\040\074\057\151\164\145\155\076\012\040\040\040\040\040"
  "\040\074\151\164\145\155\076\012\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141\164"
  "\141\142\154\145\075\042\171\145\163\042\076\124\145\155\160\157"
  "\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040"
  "\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040"
  "\156\141\155\145\075\042\141\143\164\151\157\156\042\076\141\160"
  "\160\056\145\144\151\164\137\164\145\155\160\157\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040\074"
  "\057\151\164\145\155\076\012\040\040\040\040\040\040\074\151\164"
  "\145\155\076\012\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142"
  "\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145"
  "\075\042\171\145\163\042\076\115\145\164\141\074\057\141\164\164"
  "\162\151\142\165\164\145\076\012\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\141\143\164\151\157\156\042\076\141\160\160\056\145\144\151"
  "\164\137\155\145\164\141\074\057\141\164\164\162\151\142\165\164"
  "\145\076\012\040\040\040\040\040\040\074\057\151\164\145\155\076"
  "\012\040\040\040\040\074\057\163\145\143\164\151\157\156\076\012"
  "\040\040\074\057\155\145\156\165\076\012\074\057\151\156\164\145"
  "\162\146\141\143\145\076\012\000\000\050\165\165\141\171\051\057"
  "\005\000\000\000\165\151\057\000\012\000\000\000\001\000\000\000"
  "\011\000\000\000\007\000\000\000\156\157\156\147\156\165\057\000"
  "\000\000\000\000\157\162\147\057\004\000\000\000\141\147\163\057"
  "\010\000\000\000\141\147\163\137\160\162\151\155\141\162\171\137"
  "\155\145\156\165\056\165\151\000\326\007\000\000\000\000\000\000"
  "\074\077\170\155\154\040\166\145\162\163\151\157\156\075\042\061"
  "\056\060\042\040\145\156\143\157\144\151\156\147\075\042\125\124"
  "\106\055\070\042\077\076\012\074\151\156\164\145\162\146\141\143"
  "\145\076\012\040\040\074\155\145\156\165\040\151\144\075\042\141"
  "\147\163\055\160\162\151\155\141\162\171\055\155\145\156\165\042"
  "\076\012\040\040\040\040\074\163\145\143\164\151\157\156\076\012"
  "\040\040\040\040\040\040\074\151\164\145\155\076\012\040\040\040"
  "\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040"
  "\156\141\155\145\075\042\154\141\142\145\154\042\040\164\162\141"
  "\156\163\154\141\164\141\142\154\145\075\042\171\145\163\042\076"
  "\137\117\160\145\156\074\057\141\164\164\162\151\142\165\164\145"
  "\076\012\040\040\040\040\040\040\040\040\074\141\164\164\162\151"
  "\142\165\164\145\040\156\141\155\145\075\042\141\143\164\151\157"
  "\156\042\076\141\160\160\056\157\160\145\156\074\057\141\164\164"
  "\162\151\142\165\164\145\076\012\040\040\040\040\040\040\074\057"
  "\151\164\145\155\076\012\040\040\040\040\040\040\074\151\164\145"
  "\155\076\012\040\040\040\040\040\040\040\040\074\141\164\164\162"
  "\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142\145"
  "\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145\075"
  "\042\171\145\163\042\076\137\123\141\166\145\074\057\141\164\164"
  "\162\151\142\165\164\145\076\012\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\141\143\164\151\157\156\042\076\141\160\160\056\163\141\166"
  "\145\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\074\057\151\164\145\155\076\012\040\040\040\040"
  "\040\040\074\151\164\145\155\076\012\040\040\040\040\040\040\040"
  "\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145"
  "\075\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141"
  "\164\141\142\154\145\075\042\171\145\163\042\076\123\141\166\145"
  "\040\141\163\074\057\141\164\164\162\151\142\165\164\145\076\012"
  "\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142\165"
  "\164\145\040\156\141\155\145\075\042\141\143\164\151\157\156\042"
  "\076\141\160\160\056\163\141\166\145\137\141\163\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040\074"
  "\057\151\164\145\155\076\012\040\040\040\040\040\040\074\151\164"
  "\145\155\076\012\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142"
  "\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145"
  "\075\042\171\145\163\042\076\137\115\145\164\141\055\144\141\164"
  "\141\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145"
  "\040\156\141\155\145\075\042\141\143\164\151\157\156\042\076\141"
  "\160\160\056\155\145\164\141\137\144\141\164\141\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040\074"
  "\057\151\164\145\155\076\012\040\040\040\040\040\040\074\151\164"
  "\145\155\076\012\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142"
  "\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145"
  "\075\042\171\145\163\042\076\137\105\170\160\157\162\164\074\057"
  "\141\164\164\162\151\142\165\164\145\076\012\040\040\040\040\040"
  "\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141"
  "\155\145\075\042\141\143\164\151\157\156\042\076\141\160\160\056"
  "\145\170\160\157\162\164\074\057\141\164\164\162\151\142\165\164"
  "\145\076\012\040\040\040\040\040\040\074\057\151\164\145\155\076"
  "\012\040\040\040\040\040\040\074\151\164\145\155\076\012\040\040"
  "\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145"
  "\040\156\141\155\145\075\042\154\141\142\145\154\042\040\164\162"
  "\141\156\163\154\141\164\141\142\154\145\075\042\171\145\163\042"
  "\076\123\115\106\040\151\155\160\157\162\164\074\057\141\164\164"
  "\162\151\142\165\164\145\076\012\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\141\143\164\151\157\156\042\076\141\160\160\056\163\155\146"
  "\137\151\155\160\157\162\164\074\057\141\164\164\162\151\142\165"
  "\164\145\076\012\040\040\040\040\040\040\074\057\151\164\145\155"
  "\076\012\040\040\040\040\040\040\074\151\164\145\155\076\012\040"
  "\040\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164"
  "\145\040\156\141\155\145\075\042\154\141\142\145\154\042\040\164"
  "\162\141\156\163\154\141\164\141\142\154\145\075\042\171\145\163"
  "\042\076\123\115\106\040\145\170\160\157\162\164\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040\040"
  "\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145"
  "\075\042\141\143\164\151\157\156\042\076\141\160\160\056\163\155"
  "\146\137\145\170\160\157\162\164\074\057\141\164\164\162\151\142"
  "\165\164\145\076\012\040\040\040\040\040\040\074\057\151\164\145"
  "\155\076\012\040\040\040\040\040\040\074\151\164\145\155\076\012"
  "\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142\165"
  "\164\145\040\156\141\155\145\075\042\154\141\142\145\154\042\040"
  "\164\162\141\156\163\154\141\164\141\142\154\145\075\042\171\145"
  "\163\042\076\137\120\162\145\146\145\162\145\156\143\145\163\074"
  "\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040\040"
  "\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156"
  "\141\155\145\075\042\141\143\164\151\157\156\042\076\141\160\160"
  "\056\160\162\145\146\145\162\145\156\143\145\163\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040\074"
  "\057\151\164\145\155\076\012\040\040\040\040\040\040\074\151\164"
  "\145\155\076\012\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142"
  "\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145"
  "\075\042\171\145\163\042\076\104\157\167\156\154\157\141\144\040"
  "\163\141\155\160\154\145\163\074\057\141\164\164\162\151\142\165"
  "\164\145\076\012\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\141\143\164"
  "\151\157\156\042\076\141\160\160\056\144\157\167\156\154\157\141"
  "\144\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\074\057\151\164\145\155\076\012\040\040\040\040"
  "\040\040\074\151\164\145\155\076\012\040\040\040\040\040\040\040"
  "\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145"
  "\075\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141"
  "\164\141\142\154\145\075\042\171\145\163\042\076\137\101\142\157"
  "\165\164\074\057\141\164\164\162\151\142\165\164\145\076\012\040"
  "\040\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164"
  "\145\040\156\141\155\145\075\042\141\143\164\151\157\156\042\076"
  "\141\160\160\056\141\142\157\165\164\074\057\141\164\164\162\151"
  "\142\165\164\145\076\012\040\040\040\040\040\040\074\057\151\164"
  "\145\155\076\012\040\040\040\040\040\040\074\151\164\145\155\076"
  "\012\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142"
  "\165\164\145\040\156\141\155\145\075\042\154\141\142\145\154\042"
  "\040\164\162\141\156\163\154\141\164\141\142\154\145\075\042\171"
  "\145\163\042\076\137\110\145\154\160\074\057\141\164\164\162\151"
  "\142\165\164\145\076\012\040\040\040\040\040\040\040\040\074\141"
  "\164\164\162\151\142\165\164\145\040\156\141\155\145\075\042\141"
  "\143\164\151\157\156\042\076\141\160\160\056\150\145\154\160\074"
  "\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040\040"
  "\040\040\074\057\151\164\145\155\076\012\040\040\040\040\040\040"
  "\074\151\164\145\155\076\012\040\040\040\040\040\040\040\040\074"
  "\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075\042"
  "\154\141\142\145\154\042\040\164\162\141\156\163\154\141\164\141"
  "\142\154\145\075\042\171\145\163\042\076\137\121\165\151\164\074"
  "\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040\040"
  "\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156"
  "\141\155\145\075\042\141\143\164\151\157\156\042\076\141\160\160"
  "\056\161\165\151\164\074\057\141\164\164\162\151\142\165\164\145"
  "\076\012\040\040\040\040\040\040\074\057\151\164\145\155\076\012"
  "\040\040\040\040\074\057\163\145\143\164\151\157\156\076\012\040"
  "\040\074\057\155\145\156\165\076\012\074\057\151\156\164\145\162"
  "\146\141\143\145\076\012\000\000\050\165\165\141\171\051\141\160"
  "\160\057\000\000\003\000\000\000\141\147\163\137\155\141\143\150"
  "\151\156\145\137\155\145\156\165\056\165\151\000\000\000\000\000"
  "\374\020\000\000\000\000\000\000\074\077\170\155\154\040\166\145"
  "\162\163\151\157\156\075\042\061\056\060\042\040\145\156\143\157"
  "\144\151\156\147\075\042\125\124\106\055\070\042\077\076\012\074"
  "\151\156\164\145\162\146\141\143\145\076\012\040\040\074\155\145"
  "\156\165\040\151\144\075\042\141\147\163\055\155\141\143\150\151"
  "\156\145\055\155\145\156\165\042\076\012\040\040\040\040\074\163"
  "\145\143\164\151\157\156\076\012\040\040\040\040\040\040\074\151"
  "\164\145\155\076\012\040\040\040\040\040\040\040\040\074\141\164"
  "\164\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141"
  "\142\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154"
  "\145\075\042\171\145\163\042\076\155\157\166\145\040\165\160\074"
  "\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040\040"
  "\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156"
  "\141\155\145\075\042\141\143\164\151\157\156\042\076\155\141\143"
  "\150\151\156\145\056\155\157\166\145\137\165\160\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040\074"
  "\057\151\164\145\155\076\012\040\040\040\040\040\040\074\151\164"
  "\145\155\076\012\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142"
  "\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145"
  "\075\042\171\145\163\042\076\155\157\166\145\040\144\157\167\156"
  "\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040"
  "\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040"
  "\156\141\155\145\075\042\141\143\164\151\157\156\042\076\155\141"
  "\143\150\151\156\145\056\155\157\166\145\137\144\157\167\156\074"
  "\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040\040"
  "\040\040\074\057\151\164\145\155\076\012\040\040\040\040\040\040"
  "\074\151\164\145\155\076\012\040\040\040\040\040\040\040\040\074"
  "\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075\042"
  "\154\141\142\145\154\042\040\164\162\141\156\163\154\141\164\141"
  "\142\154\145\075\042\171\145\163\042\076\150\151\144\145\074\057"
  "\141\164\164\162\151\142\165\164\145\076\012\040\040\040\040\040"
  "\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141"
  "\155\145\075\042\141\143\164\151\157\156\042\076\155\141\143\150"
  "\151\156\145\056\150\151\144\145\074\057\141\164\164\162\151\142"
  "\165\164\145\076\012\040\040\040\040\040\040\074\057\151\164\145"
  "\155\076\012\040\040\040\040\040\040\074\151\164\145\155\076\012"
  "\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142\165"
  "\164\145\040\156\141\155\145\075\042\154\141\142\145\154\042\040"
  "\164\162\141\156\163\154\141\164\141\142\154\145\075\042\171\145"
  "\163\042\076\163\150\157\167\074\057\141\164\164\162\151\142\165"
  "\164\145\076\012\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\141\143\164"
  "\151\157\156\042\076\155\141\143\150\151\156\145\056\163\150\157"
  "\167\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\074\057\151\164\145\155\076\012\040\040\040\040"
  "\040\040\074\151\164\145\155\076\012\040\040\040\040\040\040\040"
  "\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145"
  "\075\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141"
  "\164\141\142\154\145\075\042\171\145\163\042\076\144\145\163\164"
  "\162\157\171\074\057\141\164\164\162\151\142\165\164\145\076\012"
  "\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142\165"
  "\164\145\040\156\141\155\145\075\042\141\143\164\151\157\156\042"
  "\076\155\141\143\150\151\156\145\056\144\145\163\164\162\157\171"
  "\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040"
  "\040\040\040\074\057\151\164\145\155\076\012\040\040\040\040\040"
  "\040\074\151\164\145\155\076\012\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141\164"
  "\141\142\154\145\075\042\171\145\163\042\076\162\145\156\141\155"
  "\145\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145"
  "\040\156\141\155\145\075\042\141\143\164\151\157\156\042\076\155"
  "\141\143\150\151\156\145\056\162\145\156\141\155\145\074\057\141"
  "\164\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040"
  "\074\057\151\164\145\155\076\012\040\040\040\040\040\040\074\151"
  "\164\145\155\076\012\040\040\040\040\040\040\040\040\074\141\164"
  "\164\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141"
  "\142\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154"
  "\145\075\042\171\145\163\042\076\162\145\156\141\155\145\040\141"
  "\165\144\151\157\074\057\141\164\164\162\151\142\165\164\145\076"
  "\012\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142"
  "\165\164\145\040\156\141\155\145\075\042\141\143\164\151\157\156"
  "\042\076\155\141\143\150\151\156\145\056\162\145\156\141\155\145"
  "\137\141\165\144\151\157\074\057\141\164\164\162\151\142\165\164"
  "\145\076\012\040\040\040\040\040\040\074\057\151\164\145\155\076"
  "\012\040\040\040\040\040\040\074\151\164\145\155\076\012\040\040"
  "\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145"
  "\040\156\141\155\145\075\042\154\141\142\145\154\042\040\164\162"
  "\141\156\163\154\141\164\141\142\154\145\075\042\171\145\163\042"
  "\076\162\145\160\157\163\151\164\151\157\156\040\141\165\144\151"
  "\157\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145"
  "\040\156\141\155\145\075\042\141\143\164\151\157\156\042\076\155"
  "\141\143\150\151\156\145\056\162\145\160\157\163\151\164\151\157"
  "\156\137\141\165\144\151\157\074\057\141\164\164\162\151\142\165"
  "\164\145\076\012\040\040\040\040\040\040\074\057\151\164\145\155"
  "\076\012\040\040\040\040\040\040\074\151\164\145\155\076\012\040"
  "\040\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164"
  "\145\040\156\141\155\145\075\042\154\141\142\145\154\042\040\164"
  "\162\141\156\163\154\141\164\141\142\154\145\075\042\171\145\163"
  "\042\076\160\162\157\160\145\162\164\151\145\163\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040\040"
  "\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145"
  "\075\042\141\143\164\151\157\156\042\076\155\141\143\150\151\156"
  "\145\056\160\162\157\160\145\162\164\151\145\163\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040\074"
  "\057\151\164\145\155\076\012\040\040\040\040\040\040\074\151\164"
  "\145\155\076\012\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142"
  "\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145"
  "\075\042\171\145\163\042\076\163\164\151\143\153\171\040\143\157"
  "\156\164\162\157\154\163\074\057\141\164\164\162\151\142\165\164"
  "\145\076\012\040\040\040\040\040\040\040\040\074\141\164\164\162"
  "\151\142\165\164\145\040\156\141\155\145\075\042\141\143\164\151"
  "\157\156\042\076\155\141\143\150\151\156\145\056\163\164\151\143"
  "\153\171\137\143\157\156\164\162\157\154\163\074\057\141\164\164"
  "\162\151\142\165\164\145\076\012\040\040\040\040\040\040\074\057"
  "\151\164\145\155\076\012\040\040\040\040\040\040\074\163\165\142"
  "\155\145\156\165\076\012\040\040\040\040\040\040\040\040\074\141"
  "\164\164\162\151\142\165\164\145\040\156\141\155\145\075\042\154"
  "\141\142\145\154\042\040\164\162\141\156\163\154\141\164\141\142"
  "\154\145\075\042\171\145\163\042\076\145\144\151\164\074\057\141"
  "\164\164\162\151\142\165\164\145\076\012\011\074\163\145\143\164"
  "\151\157\156\076\012\011\040\040\074\151\164\145\155\076\012\040"
  "\040\040\040\040\040\040\040\040\040\040\040\074\141\164\164\162"
  "\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142\145"
  "\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145\075"
  "\042\171\145\163\042\076\143\157\160\171\040\160\141\164\164\145"
  "\162\156\074\057\141\164\164\162\151\142\165\164\145\076\012\040"
  "\040\040\040\040\040\040\040\040\040\040\040\074\141\164\164\162"
  "\151\142\165\164\145\040\156\141\155\145\075\042\141\143\164\151"
  "\157\156\042\076\155\141\143\150\151\156\145\056\143\157\160\171"
  "\137\160\141\164\164\145\162\156\074\057\141\164\164\162\151\142"
  "\165\164\145\076\012\011\040\040\074\057\151\164\145\155\076\012"
  "\011\040\040\074\151\164\145\155\076\012\040\040\040\040\040\040"
  "\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145"
  "\040\156\141\155\145\075\042\154\141\142\145\154\042\040\164\162"
  "\141\156\163\154\141\164\141\142\154\145\075\042\171\145\163\042"
  "\076\160\141\163\164\145\040\160\141\164\164\145\162\156\074\057"
  "\141\164\164\162\151\142\165\164\145\076\012\040\040\040\040\040"
  "\040\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164"
  "\145\040\156\141\155\145\075\042\141\143\164\151\157\156\042\076"
  "\155\141\143\150\151\156\145\056\160\141\163\164\145\137\160\141"
  "\164\164\145\162\156\074\057\141\164\164\162\151\142\165\164\145"
  "\076\012\011\040\040\074\057\151\164\145\155\076\012\011\040\040"
  "\074\151\164\145\155\076\012\040\040\040\040\040\040\040\040\040"
  "\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141"
  "\155\145\075\042\154\141\142\145\154\042\040\164\162\141\156\163"
  "\154\141\164\141\142\154\145\075\042\171\145\163\042\076\145\156"
  "\166\145\154\157\160\145\074\057\141\164\164\162\151\142\165\164"
  "\145\076\012\040\040\040\040\040\040\040\040\040\040\040\040\074"
  "\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075\042"
  "\141\143\164\151\157\156\042\076\155\141\143\150\151\156\145\056"
  "\145\156\166\145\154\157\160\145\074\057\141\164\164\162\151\142"
  "\165\164\145\076\012\011\040\040\074\057\151\164\145\155\076\011"
  "\040\040\012\011\040\040\074\151\164\145\155\076\012\040\040\040"
  "\040\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142"
  "\165\164\145\040\156\141\155\145\075\042\154\141\142\145\154\042"
  "\040\164\162\141\156\163\154\141\164\141\142\154\145\075\042\171"
  "\145\163\042\076\160\162\145\163\145\164\074\057\141\164\164\162"
  "\151\142\165\164\145\076\012\040\040\040\040\040\040\040\040\040"
  "\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141"
  "\155\145\075\042\141\143\164\151\157\156\042\076\155\141\143\150"
  "\151\156\145\056\160\162\145\163\145\164\074\057\141\164\164\162"
  "\151\142\165\164\145\076\012\011\040\040\074\057\151\164\145\155"
  "\076\011\040\040\012\011\040\040\074\151\164\145\155\076\012\040"
  "\040\040\040\040\040\040\040\040\040\040\040\074\141\164\164\162"
  "\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142\145"
  "\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145\075"
  "\042\171\145\163\042\076\162\145\146\162\145\163\150\040\160\157"
  "\162\164\163\074\057\141\164\164\162\151\142\165\164\145\076\012"
  "\040\040\040\040\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\141\143\164"
  "\151\157\156\042\076\155\141\143\150\151\156\145\056\162\145\146"
  "\162\145\163\150\137\160\157\162\164\074\057\141\164\164\162\151"
  "\142\165\164\145\076\012\011\040\040\074\057\151\164\145\155\076"
  "\011\040\040\012\011\074\057\163\145\143\164\151\157\156\076\011"
  "\040\040\012\040\040\040\040\040\040\074\057\163\165\142\155\145"
  "\156\165\076\012\040\040\040\040\040\040\074\163\165\142\155\145"
  "\156\165\076\012\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142"
  "\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145"
  "\075\042\171\145\163\042\076\143\157\156\156\145\143\164\151\157"
  "\156\074\057\141\164\164\162\151\142\165\164\145\076\012\011\074"
  "\163\145\143\164\151\157\156\076\012\011\040\040\074\151\164\145"
  "\155\076\012\040\040\040\040\040\040\040\040\040\040\040\040\074"
  "\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075\042"
  "\154\141\142\145\154\042\040\164\162\141\156\163\154\141\164\141"
  "\142\154\145\075\042\171\145\163\042\076\141\165\144\151\157\040"
  "\143\157\156\156\145\143\164\151\157\156\074\057\141\164\164\162"
  "\151\142\165\164\145\076\012\040\040\040\040\040\040\040\040\040"
  "\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141"
  "\155\145\075\042\141\143\164\151\157\156\042\076\155\141\143\150"
  "\151\156\145\056\141\165\144\151\157\137\143\157\156\156\145\143"
  "\164\151\157\156\074\057\141\164\164\162\151\142\165\164\145\076"
  "\012\011\040\040\074\057\151\164\145\155\076\012\011\040\040\074"
  "\151\164\145\155\076\012\040\040\040\040\040\040\040\040\040\040"
  "\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155"
  "\145\075\042\154\141\142\145\154\042\040\164\162\141\156\163\154"
  "\141\164\141\142\154\145\075\042\171\145\163\042\076\115\111\104"
  "\111\040\143\157\156\156\145\143\164\151\157\156\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040\040"
  "\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040"
  "\156\141\155\145\075\042\141\143\164\151\157\156\042\076\155\141"
  "\143\150\151\156\145\056\155\151\144\151\137\143\157\156\156\145"
  "\143\164\151\157\156\074\057\141\164\164\162\151\142\165\164\145"
  "\076\012\011\040\040\074\057\151\164\145\155\076\012\011\040\040"
  "\074\151\164\145\155\076\012\040\040\040\040\040\040\040\040\040"
  "\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141"
  "\155\145\075\042\154\141\142\145\154\042\040\164\162\141\156\163"
  "\154\141\164\141\142\154\145\075\042\171\145\163\042\076\115\111"
  "\104\111\040\103\103\040\143\157\156\156\145\143\164\151\157\156"
  "\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040"
  "\040\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142"
  "\165\164\145\040\156\141\155\145\075\042\141\143\164\151\157\156"
  "\042\076\155\141\143\150\151\156\145\056\155\151\144\151\137\143"
  "\143\137\143\157\156\156\145\143\164\151\157\156\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\011\040\040\074\057\151\164"
  "\145\155\076\012\011\074\057\163\145\143\164\151\157\156\076\011"
  "\040\040\012\040\040\040\040\040\040\074\057\163\165\142\155\145"
  "\156\165\076\012\040\040\040\040\040\040\074\163\165\142\155\145"
  "\156\165\076\012\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142"
  "\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145"
  "\075\042\171\145\163\042\076\145\170\160\157\162\164\074\057\141"
  "\164\164\162\151\142\165\164\145\076\012\011\074\163\145\143\164"
  "\151\157\156\076\012\011\040\040\074\151\164\145\155\076\012\040"
  "\040\040\040\040\040\040\040\040\040\040\040\074\141\164\164\162"
  "\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142\145"
  "\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145\075"
  "\042\171\145\163\042\076\141\165\144\151\157\040\145\170\160\157"
  "\162\164\074\057\141\164\164\162\151\142\165\164\145\076\012\040"
  "\040\040\040\040\040\040\040\040\040\040\040\074\141\164\164\162"
  "\151\142\165\164\145\040\156\141\155\145\075\042\141\143\164\151"
  "\157\156\042\076\155\141\143\150\151\156\145\056\141\165\144\151"
  "\157\137\145\170\160\157\162\164\074\057\141\164\164\162\151\142"
  "\165\164\145\076\012\011\040\040\074\057\151\164\145\155\076\012"
  "\011\040\040\074\151\164\145\155\076\012\040\040\040\040\040\040"
  "\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145"
  "\040\156\141\155\145\075\042\154\141\142\145\154\042\040\164\162"
  "\141\156\163\154\141\164\141\142\154\145\075\042\171\145\163\042"
  "\076\115\111\104\111\040\145\170\160\157\162\164\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040\040"
  "\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040"
  "\156\141\155\145\075\042\141\143\164\151\157\156\042\076\155\141"
  "\143\150\151\156\145\056\155\151\144\151\137\145\170\160\157\162"
  "\164\074\057\141\164\164\162\151\142\165\164\145\076\012\011\040"
  "\040\074\057\151\164\145\155\076\012\011\074\057\163\145\143\164"
  "\151\157\156\076\011\040\040\012\040\040\040\040\040\040\074\057"
  "\163\165\142\155\145\156\165\076\012\040\040\040\040\040\040\074"
  "\163\165\142\155\145\156\165\076\012\040\040\040\040\040\040\040"
  "\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145"
  "\075\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141"
  "\164\141\142\154\145\075\042\171\145\163\042\076\151\155\160\157"
  "\162\164\074\057\141\164\164\162\151\142\165\164\145\076\012\011"
  "\074\163\145\143\164\151\157\156\076\012\011\040\040\074\151\164"
  "\145\155\076\012\040\040\040\040\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141\164"
  "\141\142\154\145\075\042\171\145\163\042\076\141\165\144\151\157"
  "\040\151\155\160\157\162\164\074\057\141\164\164\162\151\142\165"
  "\164\145\076\012\040\040\040\040\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\141\143\164\151\157\156\042\076\155\141\143\150\151\156\145"
  "\056\141\165\144\151\157\137\151\155\160\157\162\164\074\057\141"
  "\164\164\162\151\142\165\164\145\076\012\011\040\040\074\057\151"
  "\164\145\155\076\012\011\040\040\074\151\164\145\155\076\012\040"
  "\040\040\040\040\040\040\040\040\040\040\040\074\141\164\164\162"
  "\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142\145"
  "\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145\075"
  "\042\171\145\163\042\076\115\111\104\111\040\151\155\160\157\162"
  "\164\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\040\040\040\040\040\040\074\141\164\164\162\151"
  "\142\165\164\145\040\156\141\155\145\075\042\141\143\164\151\157"
  "\156\042\076\155\141\143\150\151\156\145\056\155\151\144\151\137"
  "\151\155\160\157\162\164\074\057\141\164\164\162\151\142\165\164"
  "\145\076\012\011\040\040\074\057\151\164\145\155\076\012\011\074"
  "\057\163\145\143\164\151\157\156\076\011\040\040\012\040\040\040"
  "\040\040\040\074\057\163\165\142\155\145\156\165\076\012\040\040"
  "\040\040\074\057\163\145\143\164\151\157\156\076\012\040\040\074"
  "\057\155\145\156\165\076\012\074\057\151\156\164\145\162\146\141"
  "\143\145\076\012\000\000\050\165\165\141\171\051\141\147\163\137"
  "\141\144\144\137\155\145\156\165\056\165\151\000\000\000\000\000"
  "\115\015\000\000\000\000\000\000\074\077\170\155\154\040\166\145"
  "\162\163\151\157\156\075\042\061\056\060\042\040\145\156\143\157"
  "\144\151\156\147\075\042\125\124\106\055\070\042\077\076\012\074"
  "\151\156\164\145\162\146\141\143\145\076\012\040\040\074\155\145"
  "\156\165\040\151\144\075\042\141\147\163\055\141\144\144\055\155"
  "\145\156\165\042\076\012\040\040\040\040\074\163\145\143\164\151"
  "\157\156\076\012\040\040\040\040\040\040\074\151\164\145\155\076"
  "\012\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142"
  "\165\164\145\040\156\141\155\145\075\042\154\141\142\145\154\042"
  "\040\164\162\141\156\163\154\141\164\141\142\154\145\075\042\171"
  "\145\163\042\076\120\141\156\145\154\074\057\141\164\164\162\151"
  "\142\165\164\145\076\012\040\040\040\040\040\040\040\040\074\141"
  "\164\164\162\151\142\165\164\145\040\156\141\155\145\075\042\141"
  "\143\164\151\157\156\042\076\141\160\160\056\141\144\144\137\160"
  "\141\156\145\154\074\057\141\164\164\162\151\142\165\164\145\076"
  "\012\040\040\040\040\040\040\074\057\151\164\145\155\076\012\040"
  "\040\040\040\040\040\074\151\164\145\155\076\012\040\040\040\040"
  "\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156"
  "\141\155\145\075\042\154\141\142\145\154\042\040\164\162\141\156"
  "\163\154\141\164\141\142\154\145\075\042\171\145\163\042\076\123"
  "\160\145\143\164\162\157\155\145\164\145\162\074\057\141\164\164"
  "\162\151\142\165\164\145\076\012\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\141\143\164\151\157\156\042\076\141\160\160\056\141\144\144"
  "\137\163\160\145\143\164\162\157\155\145\164\145\162\074\057\141"
  "\164\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040"
  "\074\057\151\164\145\155\076\012\040\040\040\040\040\040\074\151"
  "\164\145\155\076\012\040\040\040\040\040\040\040\040\074\141\164"
  "\164\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141"
  "\142\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154"
  "\145\075\042\171\145\163\042\076\105\161\165\141\154\151\172\145"
  "\162\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145"
  "\040\156\141\155\145\075\042\141\143\164\151\157\156\042\076\141"
  "\160\160\056\141\144\144\137\145\161\165\141\154\151\172\145\162"
  "\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040"
  "\040\040\040\074\057\151\164\145\155\076\012\040\040\040\040\040"
  "\040\074\151\164\145\155\076\012\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141\164"
  "\141\142\154\145\075\042\171\145\163\042\076\115\151\170\145\162"
  "\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040"
  "\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040"
  "\156\141\155\145\075\042\141\143\164\151\157\156\042\076\141\160"
  "\160\056\141\144\144\137\155\151\170\145\162\074\057\141\164\164"
  "\162\151\142\165\164\145\076\012\040\040\040\040\040\040\074\057"
  "\151\164\145\155\076\012\040\040\040\040\040\040\074\151\164\145"
  "\155\076\012\040\040\040\040\040\040\040\040\074\141\164\164\162"
  "\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142\145"
  "\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145\075"
  "\042\171\145\163\042\076\104\162\165\155\074\057\141\164\164\162"
  "\151\142\165\164\145\076\012\040\040\040\040\040\040\040\040\074"
  "\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075\042"
  "\141\143\164\151\157\156\042\076\141\160\160\056\141\144\144\137"
  "\144\162\165\155\074\057\141\164\164\162\151\142\165\164\145\076"
  "\012\040\040\040\040\040\040\074\057\151\164\145\155\076\012\040"
  "\040\040\040\040\040\074\151\164\145\155\076\012\040\040\040\040"
  "\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156"
  "\141\155\145\075\042\154\141\142\145\154\042\040\164\162\141\156"
  "\163\154\141\164\141\142\154\145\075\042\171\145\163\042\076\115"
  "\141\164\162\151\170\074\057\141\164\164\162\151\142\165\164\145"
  "\076\012\040\040\040\040\040\040\040\040\074\141\164\164\162\151"
  "\142\165\164\145\040\156\141\155\145\075\042\141\143\164\151\157"
  "\156\042\076\141\160\160\056\141\144\144\137\155\141\164\162\151"
  "\170\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\074\057\151\164\145\155\076\012\040\040\040\040"
  "\040\040\074\151\164\145\155\076\012\040\040\040\040\040\040\040"
  "\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145"
  "\075\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141"
  "\164\141\142\154\145\075\042\171\145\163\042\076\123\171\156\164"
  "\150\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145"
  "\040\156\141\155\145\075\042\141\143\164\151\157\156\042\076\141"
  "\160\160\056\141\144\144\137\163\171\156\164\150\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040\074"
  "\057\151\164\145\155\076\012\040\040\040\040\040\040\074\151\164"
  "\145\155\076\012\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142"
  "\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145"
  "\075\042\171\145\163\042\076\106\115\040\123\171\156\164\150\074"
  "\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040\040"
  "\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156"
  "\141\155\145\075\042\141\143\164\151\157\156\042\076\141\160\160"
  "\056\141\144\144\137\146\155\137\163\171\156\164\150\074\057\141"
  "\164\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040"
  "\074\057\151\164\145\155\076\012\040\040\040\040\040\040\074\151"
  "\164\145\155\076\012\040\040\040\040\040\040\040\040\074\141\164"
  "\164\162\151\142\165\164\145\040\156\141\155\145\075\042\154\141"
  "\142\145\154\042\040\164\162\141\156\163\154\141\164\141\142\154"
  "\145\075\042\171\145\163\042\076\123\171\156\143\163\171\156\164"
  "\150\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145"
  "\040\156\141\155\145\075\042\141\143\164\151\157\156\042\076\141"
  "\160\160\056\141\144\144\137\163\171\156\143\163\171\156\164\150"
  "\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040"
  "\040\040\040\074\057\151\164\145\155\076\012\040\040\040\040\040"
  "\040\074\151\164\145\155\076\012\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141\164"
  "\141\142\154\145\075\042\171\145\163\042\076\106\115\040\123\171"
  "\156\143\163\171\156\164\150\074\057\141\164\164\162\151\142\165"
  "\164\145\076\012\040\040\040\040\040\040\040\040\074\141\164\164"
  "\162\151\142\165\164\145\040\156\141\155\145\075\042\141\143\164"
  "\151\157\156\042\076\141\160\160\056\141\144\144\137\146\155\137"
  "\163\171\156\143\163\171\156\164\150\074\057\141\164\164\162\151"
  "\142\165\164\145\076\012\040\040\040\040\040\040\074\057\151\164"
  "\145\155\076\012\040\040\040\040\040\040\074\151\164\145\155\076"
  "\012\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142"
  "\165\164\145\040\156\141\155\145\075\042\154\141\142\145\154\042"
  "\040\164\162\141\156\163\154\141\164\141\142\154\145\075\042\171"
  "\145\163\042\076\110\171\142\162\151\144\040\123\171\156\164\150"
  "\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040"
  "\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040"
  "\156\141\155\145\075\042\141\143\164\151\157\156\042\076\141\160"
  "\160\056\141\144\144\137\150\171\142\162\151\144\137\163\171\156"
  "\164\150\074\057\141\164\164\162\151\142\165\164\145\076\012\040"
  "\040\040\040\040\040\074\057\151\164\145\155\076\012\040\040\040"
  "\040\040\040\074\151\164\145\155\076\012\040\040\040\040\040\040"
  "\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155"
  "\145\075\042\154\141\142\145\154\042\040\164\162\141\156\163\154"
  "\141\164\141\142\154\145\075\042\171\145\163\042\076\110\171\142"
  "\162\151\144\040\106\115\040\123\171\156\164\150\074\057\141\164"
  "\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040\040"
  "\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145"
  "\075\042\141\143\164\151\157\156\042\076\141\160\160\056\141\144"
  "\144\137\150\171\142\162\151\144\137\146\155\137\163\171\156\164"
  "\150\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\074\057\151\164\145\155\076\012\040\040\040\040"
  "\040\040\074\151\164\145\155\076\012\040\040\040\040\040\040\040"
  "\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145"
  "\075\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141"
  "\164\141\142\154\145\075\042\171\145\163\042\076\123\164\141\162"
  "\147\141\172\145\162\040\123\171\156\164\150\074\057\141\164\164"
  "\162\151\142\165\164\145\076\012\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\141\143\164\151\157\156\042\076\141\160\160\056\141\144\144"
  "\137\163\164\141\162\147\141\172\145\162\137\163\171\156\164\150"
  "\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040"
  "\040\040\040\074\057\151\164\145\155\076\012\040\040\040\040\040"
  "\040\074\151\164\145\155\076\012\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141\164"
  "\141\142\154\145\075\042\171\145\163\042\076\121\165\141\156\164"
  "\165\155\040\123\171\156\164\150\074\057\141\164\164\162\151\142"
  "\165\164\145\076\012\040\040\040\040\040\040\040\040\074\141\164"
  "\164\162\151\142\165\164\145\040\156\141\155\145\075\042\141\143"
  "\164\151\157\156\042\076\141\160\160\056\141\144\144\137\161\165"
  "\141\156\164\165\155\137\163\171\156\164\150\074\057\141\164\164"
  "\162\151\142\165\164\145\076\012\040\040\040\040\040\040\074\057"
  "\151\164\145\155\076\012\040\040\040\040\040\040\074\151\164\145"
  "\155\076\012\040\040\040\040\040\040\040\040\074\141\164\164\162"
  "\151\142\165\164\145\040\156\141\155\145\075\042\154\141\142\145"
  "\154\042\040\164\162\141\156\163\154\141\164\141\142\154\145\075"
  "\042\171\145\163\042\076\122\141\166\145\156\040\123\171\156\164"
  "\150\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040"
  "\040\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145"
  "\040\156\141\155\145\075\042\141\143\164\151\157\156\042\076\141"
  "\160\160\056\141\144\144\137\162\141\166\145\156\137\163\171\156"
  "\164\150\074\057\141\164\164\162\151\142\165\164\145\076\012\040"
  "\040\040\040\040\040\074\057\151\164\145\155\076\012\040\040\040"
  "\040\040\040\074\151\164\145\155\076\012\040\040\040\040\040\040"
  "\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155"
  "\145\075\042\154\141\142\145\154\042\040\164\162\141\156\163\154"
  "\141\164\141\142\154\145\075\042\171\145\163\042\076\106\120\154"
  "\141\171\145\162\074\057\141\164\164\162\151\142\165\164\145\076"
  "\012\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142"
  "\165\164\145\040\156\141\155\145\075\042\141\143\164\151\157\156"
  "\042\076\141\160\160\056\141\144\144\137\146\146\160\154\141\171"
  "\145\162\074\057\141\164\164\162\151\142\165\164\145\076\012\040"
  "\040\040\040\040\040\074\057\151\164\145\155\076\012\040\040\040"
  "\040\040\040\074\151\164\145\155\076\012\040\040\040\040\040\040"
  "\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155"
  "\145\075\042\154\141\142\145\154\042\040\164\162\141\156\163\154"
  "\141\164\141\142\154\145\075\042\171\145\163\042\076\123\106\062"
  "\040\123\171\156\164\150\074\057\141\164\164\162\151\142\165\164"
  "\145\076\012\040\040\040\040\040\040\040\040\074\141\164\164\162"
  "\151\142\165\164\145\040\156\141\155\145\075\042\141\143\164\151"
  "\157\156\042\076\141\160\160\056\141\144\144\137\163\146\062\137"
  "\163\171\156\164\150\074\057\141\164\164\162\151\142\165\164\145"
  "\076\012\040\040\040\040\040\040\074\057\151\164\145\155\076\012"
  "\040\040\040\040\040\040\074\151\164\145\155\076\012\040\040\040"
  "\040\040\040\040\040\074\141\164\164\162\151\142\165\164\145\040"
  "\156\141\155\145\075\042\154\141\142\145\154\042\040\164\162\141"
  "\156\163\154\141\164\141\142\154\145\075\042\171\145\163\042\076"
  "\120\151\164\143\150\040\123\141\155\160\154\145\162\074\057\141"
  "\164\164\162\151\142\165\164\145\076\012\040\040\040\040\040\040"
  "\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141\155"
  "\145\075\042\141\143\164\151\157\156\042\076\141\160\160\056\141"
  "\144\144\137\160\151\164\143\150\137\163\141\155\160\154\145\162"
  "\074\057\141\164\164\162\151\142\165\164\145\076\012\040\040\040"
  "\040\040\040\074\057\151\164\145\155\076\012\040\040\040\040\040"
  "\040\074\151\164\145\155\076\012\040\040\040\040\040\040\040\040"
  "\074\141\164\164\162\151\142\165\164\145\040\156\141\155\145\075"
  "\042\154\141\142\145\154\042\040\164\162\141\156\163\154\141\164"
  "\141\142\154\145\075\042\171\145\163\042\076\123\106\132\040\123"
  "\171\156\164\150\074\057\141\164\164\162\151\142\165\164\145\076"
  "\012\040\040\040\040\040\040\040\040\074\141\164\164\162\151\142"
  "\165\164\145\040\156\141\155\145\075\042\141\143\164\151\157\156"
  "\042\076\141\160\160\056\141\144\144\137\163\146\172\137\163\171"
  "\156\164\150\074\057\141\164\164\162\151\142\165\164\145\076\012"
  "\040\040\040\040\040\040\074\057\151\164\145\155\076\012\040\040"
  "\040\040\040\040\074\151\164\145\155\076\012\040\040\040\040\040"
  "\040\040\040\074\141\164\164\162\151\142\165\164\145\040\156\141"
  "\155\145\075\042\154\141\142\145\154\042\040\164\162\141\156\163"
  "\154\141\164\141\142\154\145\075\042\171\145\163\042\076\101\165"
  "\144\151\157\162\145\143\074\057\141\164\164\162\151\142\165\164"
  "\145\076\012\040\040\040\040\040\040\040\040\074\141\164\164\162"
  "\151\142\165\164\145\040\156\141\155\145\075\042\141\143\164\151"
  "\157\156\042\076\141\160\160\056\141\144\144\137\141\165\144\151"
  "\157\162\145\143\074\057\141\164\164\162\151\142\165\164\145\076"
  "\012\040\040\040\040\040\040\074\057\151\164\145\155\076\012\040"
  "\040\040\040\074\057\163\145\143\164\151\157\156\076\012\040\040"
  "\074\057\155\145\156\165\076\012\074\057\151\156\164\145\162\146"
  "\141\143\145\076\012\000\000\050\165\165\141\171\051" };

static GStaticResource static_resource = { ags_gsequencer_resource_data.data, sizeof (ags_gsequencer_resource_data.data) - 1 /* nul terminator */, NULL, NULL, NULL };

G_MODULE_EXPORT
GResource *ags_gsequencer_get_resource (void);
GResource *ags_gsequencer_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/* GLIB - Library of useful routines for C programming
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GLib Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GLib Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GLib at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __G_CONSTRUCTOR_H__
#define __G_CONSTRUCTOR_H__

/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a usable way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER)

/*
 * Only try to include gslist.h if not already included via glib.h,
 * so that items using gconstructor.h outside of GLib (such as
 * GResources) continue to build properly.
 */
#ifndef __G_LIB_H__
#include "gslist.h"
#endif

#include <stdlib.h>

#define G_HAS_CONSTRUCTORS 1

/* We do some weird things to avoid the constructors being optimized
 * away on VS2015 if WholeProgramOptimization is enabled. First we
 * make a reference to the array from the wrapper to make sure its
 * references. Then we use a pragma to make sure the wrapper function
 * symbol is always included at the link stage. Also, the symbols
 * need to be extern (but not dllexport), even though they are not
 * really used from another object file.
 */

/* We need to account for differences between the mangling of symbols
 * for x86 and x64/ARM/ARM64 programs, as symbols on x86 are prefixed
 * with an underscore but symbols on x64/ARM/ARM64 are not.
 */
#ifdef _M_IX86
#define G_MSVC_SYMBOL_PREFIX "_"
#else
#define G_MSVC_SYMBOL_PREFIX ""
#endif

#define G_DEFINE_CONSTRUCTOR(_func) G_MSVC_CTOR (_func, G_MSVC_SYMBOL_PREFIX)
#define G_DEFINE_DESTRUCTOR(_func) G_MSVC_DTOR (_func, G_MSVC_SYMBOL_PREFIX)

#define G_MSVC_CTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _wrapper(void);              \
  int _func ## _wrapper(void) { _func(); g_slist_find (NULL,  _array ## _func); return 0; } \
  __pragma(comment(linker,"/include:" _sym_prefix # _func "_wrapper")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _wrapper;

#define G_MSVC_DTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _constructor(void);              \
  int _func ## _constructor(void) { atexit (_func); g_slist_find (NULL,  _array ## _func); return 0; } \
   __pragma(comment(linker,"/include:" _sym_prefix # _func "_constructor")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */
#endif /* __G_CONSTRUCTOR_H__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(ags_gsequencerresource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(ags_gsequencerresource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(ags_gsequencerresource_destructor)
#endif
G_DEFINE_DESTRUCTOR(ags_gsequencerresource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void ags_gsequencerresource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void ags_gsequencerresource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
