.TH groff_pdfmark @MAN7EXT@ "@MDATE@" "groff-pdfmark @VERSION@"
.
.SH Name
groff_pdfmark \- embed pdfmark controls in GNU roff
PostScript output stream
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2023, Free Software Foundation, Inc.
.\"
.\" This file is part of groff-pdfmark, an independently maintained
.\" add-on for the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, no Front-Cover Texts,
.\" and no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called fdl-v1.3.txt, in the fdl directory of the groff-pdfmark
.\" source package, whence it is programmatically marked up, to be
.\" processed by groff -m pdfmark, for inclusion as an appendix to
.\" the pdfmark.pdf document.
.
.
.\" Save and disable compatibility mode (e.g., for Solaris 10/11).
.nr _? \n(.C
.do rnn _? *groff_pdfmark_7_man_C
.cp 0
.
.
.\" ====================================================================
.\" Local macro definitions
.\" ====================================================================
.
.\" @IMPORT_LOCAL_FALLBACK_MACROS@
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
Command line invocation:
.
.RS 2n
.SY pdfroff\~\-mpdfmark
.RI [ option\~ .\|.\|.\&]
.RI [ file\~ .\|.\|.]
.
.SY pdfroff\~\-m\~pdfmark
.RI [ option\~ .\|.\|.\&]
.RI [ file\~ .\|.\|.]
.YS
.RE
.
.P
Macro calls, from within
.MR groff @MAN7EXT@
document source:
.
.RS 2n
.SY .\^pdfmark
.IR \%arbitrary\ pdfmark\ instruction\ code \ .\|.\|.
.
.SY .\^pdfinfo
.RI \%/< key-name > \ record\ content \ .\|.\|.
.
.SY .\^pdfview
.IR \%initial\ page\ view\ specification \ .\|.\|.
.
.SY .\^pdfnote
.RB [ \-O ]
.RB [ \-PD
.RI < line-count >]
.RI \(rs[# \ comment \ .\|.\|.]\p
.RB [ \-C
.RI < red >\ < green >\ < blue >]
.RI \(rs[# \ comment \ .\|.\|.]\p
.RB [ \-I
.RI < icon-style-name >]
.RB [ \-T
.RI < title \ .\|.\|.>]
.RB [ \-\- ]
.RI \(rs[# \ comment \ .\|.\|.]\p
.RI [ one\ of\ multiple\ lines\ of\ text \ .\|.\|.\&
.RI \(rs[# \ comment \ .\|.\|.\&]]\ .\|.\|.\p
.IR last\ line\ of\ text \ .\|.\|.
.
.SY .\^pdfhref
.RI < opcode >\ [ options \ .\|.\|.\&]\ [ \-\- ]
.IR descriptive\ text \ .\|.\|.
.
.SY .\^pdfbookmark
.RB [ \-T
.RI < tag >
.RB |\ \-N
.RI < refname >]
.RI < level >
.RI < context \ .\|.\|.>
.
.SY .\^pdfsync
.RB [ O " | " M ]\ .\|.\|.
.YS
.RE
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
This manual page describes the capabilities, and,
for those which are not separately documented in other manual pages,
the usage of the collection of macros which are provided by the
.I \%groff-pdfmark
macro package.
.
.P
The command line invocation synopses, above,
relate specifically to the invocation of
.MR groff @MAN1EXT@ ,
(with
.I indirect
invocation, via the
.MR pdfroff @MAN1EXT@
wrapper command, being
.I strongly
recommended,
in order to take advantage of its \%multi-pass
.MR groff @MAN1EXT@
processing,
which is normally a prerequisite for successful operation of
the various macros within the
.I \%groff-pdfmark
suite).
.
.P
On the other hand,
the macro calls synopses relate to the usage of the various
.I \%groff-pdfmark
macros themselves,
from within any user-written
.MR groff @MAN7EXT@
input file;
each of these macros performs, respectively,
one of the following functions:
.P
.RS 2n
.ll -2n
.TP 14n
.B \%.\^pdfmark
Writes arbitrary
.I \%pdfmark
code to the
.MR groff @MAN1EXT@
PostScript\*R output data stream, (via the
.MR grops @MAN1EXT@
input stream).
.
.TP 14n
.B \%.\^pdfinfo
Inserts a
.B \%/DOCINFO
.I \%pdfmark
record,
with a specified
.IR \%key-name ,
and arbitrary content,
into the internal document \%meta-data cache.
.
.TP 14n
.B \%.\^pdfview
Inserts a
.B \%/DOCVIEW
.I \%pdfmark
specification record
into the internal document \%meta-data cache.
.
.TP 14n
.B \%.\^pdfnote
Inserts PDF annotations,
in a style resembling \(lqsticky notes\(rq,
directly from within the
.MR groff @MAN7EXT@
input data stream,
into a PDF document;
usage is described in
.MR groff_pdfnote @MAN7EXT@ .
.
.TP 14n
.B \%.\^pdfhref
Provides various capabilities,
as described in
.MR groff_pdfhref @MAN7EXT@ ,
and selected by the
.I \%opcode
argument,
for creating and linking to document reference marks,
or for linking to internet resources.
.
.TP 14n
.B \%.\^pdfbookmark
Creates a
.I document outline
reference mark,
at the current output position,
and inserts a link,
which both represents, and leads to the specified context,
into the internal document outline cache;
this is an
.I exact
analogue for the
.B \%pdfhref
macro, when it is invoked with its
.RB \%\(lq O \(rq
operator, as described in
.MR groff_pdfhref @MAN7EXT@ .
.
.TP 14n
.B \%.\^pdfsync
Flushes content from the internal document outline
and/or meta-data caches,
to the PostScript\*R output stream.
.ll +2n
.RE
.P
With the exception of the
.B \%.\^pdfhref
and
.B \%.\^pdfnote
macros,
which are comprehensively documented in the
.MR groff_pdfhref @MAN7EXT@
and
.MR groff_pdfnote @MAN7EXT@
manual pages respectively,
further guidance on the usage of each of
the above macros may be found in the
.SR 1 Usage
section,
which follows.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
.SS Invoking Arbitrary \f(CBpdfmark\fP Instructions
.
Each of the capabilities,
which is supported by the
.I \%groff-pdfmark
macro suite,
is implemented in terms of the fundamental
.RS 2n
.SY \%.\^pdfmark
.IR \%arbitrary\ instruction\ code \ .\|.\|.\ / keyword
.YS
.RE
.P
macro;
execution of this results in insertion,
into the
.MR grops @MAN1EXT@
output stream,
of the
.I \%pdfmark
code:
.P
.RS 2n
.EX
[ arbitrary instruction code ... /keyword pdfmark
.EE
.RE
.P
In general,
it will usually be more convenient to use one of the higher level
.I \%groff-pdfmark
macros, rather than to invoke the
.B \%.\^pdfmark
macro directly; however,
if it is desired to exploit any
.I \%pdfmark
feature,
which is not supported by the available higher level macros,
this may be achievable by use of the
.B \%.\^pdfmark
macro.
.
.P
Notice that the
.B \%.\^pdfmark
macro supplies the initial
.RB \%\(lq [ \(rq
instruction mark,
and the terminating
.B \%pdfmark
operator,
for inclusion in the
.MR grops @MAN1EXT@
output;
thus, these should
.I \%not
be included within the specified macro arguments.
.
.P
Conversely, the terminal
.RI \%/ keyword
argument
.I is
required; it
.I must
be specified as one of the
.I \%pdfmark
feature object-name keywords,
as documented in the
.UR https://\:www.\:adobe.\:com/go/\:acrobatsdk_pdfmark
the Adobe\*R PDFMark Reference Manual
.UE .
.
For example,
a PDF document outline entry may be represented by
.MR grops @MAN1EXT@
output similar to:
.P
.RS 2n
.EX
[ /Count 2
\& \& /Title (A PDF bookmark with two children)
\& \& /View  [/FitH \(rsn(Y? u]
\& \& /OUT
\& pdfmark
.EE
.RE
.P
(in which the
.MR groff @MAN7EXT@
register reference, \(lq\fC\(rsn(Y?\fP\(rq,
represents the computed vertical location of the bookmark
on the current page).
.
Although the preferred method for producing such
.I \%pdfmark
output is discussed below,
under the
.SR 0 "Creating a Document Outline"
heading,
this output,
as illustrated above,
may be reproduced by calling the
.B \%.\^pdfmark
macro, thus:
.P
.RS 2n
.EX
\&.pdfmark \(rs
\&  /Count 2 \(rs
\& \& /Title (A PDF bookmark with two children) \(rs
\& \& /View  [/FitH \(rsn(Y? u] \(rs
\& \& /OUT
.EE
.RE
.
.P
It may be further noted that,
whereas contemporary PDF document production tools may be reasonably
tolerant of non-conformity, the
.B \%.\^pdfmark
macro
.I does
endeavour,
insofar as is practicable,
to format its output to conform to the Adobe\*R
.IR "Document Structuring Conventions" ,
so as to preserve compatibility with the broadest possible spectrum
of such PDF document production tools.
.
.
.SS Defining Document \%Meta-Data
.
Whereas
.MR groff @MAN1EXT@
and
.MR gs @MAN1EXT@ \|\(em\|both
of which are called by
.MR pdfroff @MAN1EXT@ \|\(em\|will
.I automatically
insert
.I some
\%meta-data
into any PDF document which they produce,
there are some \%meta-data entries,
which it may be desired to incorporate,
each of which
.I must
be specified manually.
.
Among those entries which,
if it is desired that they should be specified,
require an explicit manual specification,
are those in the PDF
.B \%/DOCINFO
category with key names
.BR \%/Title ,
.BR \%/Author ,
.BR \%/Subject ,
and
.BR \%/Keywords .
.
.P
While such \%meta-data may be specified directly,
using the
.B \%.\^pdfmark
macro,
for example:
.P
.RS 2n
.EX
\&.pdfmark /Title (An Example PDF Document) /DOCINFO
.EE
.RE
.P
the
.B \%.\^pdfinfo
macro,
which conforms to the syntactic calling convention:
.RS 2n
.SY \%.\^pdfinfo
.RI \%\h'0.5n'/< key-name > \ string\ value \ .\|.\|.\&
.YS
.RE
.P
offers an alternative method for specifying such \%meta-data;
the effect of the preceding example may be reproduced by the call:
.P
.RS 2n
.EX
\&.pdfinfo /Title An Example PDF Document
.EE
.RE
.
.P
.ne 2v
It should be noted that,
when the
.B \%.\^pdfinfo
macro is used to specify document \%meta-data,
this \%meta-data will
.I not
be written immediately to the
.MR grops @MAN1EXT@
output stream;
rather,
it will be cached internally,
in a
.MR groff @MAN7EXT@
diversion,
until it is flushed to the output stream,
by a subsequent invocation of the
.B \%.\^pdfsync
macro,
(which may be called,
conveniently,
from within an end-of-input macro).
.
.
.SS Establishing an Initial Document View
.
By default,
when any PDF document is opened for the first time,
the viewer application will position the viewport to display
the top of the first page,
at a magnification which is selected according to
the configuration of the particular viewer application
which is in use.
Furthermore,
it is dependent on the particular viewer configuration,
whether a navigational side pane is displayed,
and what contents may be displayed in such a pane;
a common default is to show thumbnail views
of the document pages.
.
.P
The viewer application's default initial view configuration may,
or may not, conform to the document author's preference;
if not, alternative preferences may be specified
by macro calls of the form:
.RS 2n
.SY .\^pdfview
.IR \%view\ specification \ .\|.\|.
.YS
.RE
.P
While it is not guaranteed that any particular viewer application
will honour every possible
.IR \%view\ specification ,
this should be specified to conform with the requirements of the
.B \%/DOCVIEW
.I \%pdfmark
feature object,
as they are described in
.UR https://\:www.\:adobe.\:com/go/\:acrobatsdk_pdfmark
the Adobe\*R PDFMark Reference Manual
.UE ;
typical usage might include:
.P
.RS 2n
.EX
\&.\^pdfview /PageMode /UseOutlines
\&.\^pdfview /Page 1 /View [/FitH \(rsn(.p u]
.EE
.RE
.P
In this example,
note that the
.MR grops @MAN1EXT@
.RB \(lq u \(rq
operator is required,
to convert the view specification from
.MR groff @MAN7EXT@
page \%co-ordinates,
to a mapping within the PostScript, or PDF,
page \%co-ordinate system.
.
.
.SS Creating a Document Outline
.
A document outline is created by a series of calls to either the
.B \%.\^pdfbookmark
macro, (or the entirely analogous
.B \%.\^pdfhref\^\ O
macro);
when called in the form:
.RS 2n
.SY .\^pdfbookmark
.RB [ \-T
.RI < tag >\ |
.B  \-N
.RI < refname >]
.RI < level >
.RI < context \ .\|.\|.>
.YS
.RE
.P
this is
.I exactly
equivalent to:
.RS 2n
.SY .\^pdfhref\^\ O
.RB [ \-T
.RI < tag >\ |
.B  \-N
.RI < refname >]
.RI < level >
.RI < context \ .\|.\|.>
.YS
.RE
.P
This is formally documented in the
.ie \n(CS .B \%USAGE
.el .B \%Usage
section of
.MR groff_pdfhref @MAN7EXT@ ,
under the subheading
.BR "Creating a Document Outline" ;
please refer to that manual page,
for complete documentation of
.B \%.\^pdfhref\^\ O
usage,
(and analogously, therefore, of
.B \%.\^pdfbookmark
usage).
.
.P
Please note that,
regardless of whether a document outline is created by use of
.BR \%.\^pdfbookmark ,
or
.BR \%.\^pdfhref\^\ O ,
the constructed outline is initially stored
in an internal outline cache; this
.I must
ultimately be flushed to the PDF output data stream,
by calling the
.BR \%.\^pdfsync
macro, (typically from within an \(lqend-of-input\(rq processing macro),
as described under the subheading
.SR 0 "Flushing Internal Data Caches" ,
which follows immediately below.
.
.
.SS Flushing Internal Data Caches
.
The
.I \%groff-pdfmark
macros use two internal data caches for intermediate storage of data,
which may not yet be ready for committal to the PDF output data stream,
namely:
.RS 2n
.ll -2n
.IP \(bu 2n
The \%meta-data cache,
which is implemented as a
.MR groff @MAN7EXT@
diversion,
and is used for intermediate storage of \%meta-data
which has been specified by use of the
.B \%.\^pdfinfo
and
.B \%.\^pdfview
macros.
.IP \(bu 2n
The outline data cache,
which is implemented as a collection of internally named,
and dynamically defined,
.MR groff @MAN7EXT@
registers and strings;
this stores information relating to
the evolving structure of any document outline,
until it has become sufficiently developed
for committal to the PDF output data stream.
.ll +2n
.RE
.P
Both of these caches
.I must
be
.I explicitly
flushed,
to avoid loss of data
on completion of document processing;
flushing may be achieved by calling the
.B \%.\^pdfsync
macro:
.RS 2n
.SY .\^pdfsync
.RB [ O \ |
.BR M ]\ .\|.\|.
.YS
.RE
.P
When the
.RB \%\(lq M \(rq
argument is specified,
the \%meta-data cache is flushed.
This may be safely requested at any time,
.I after all
desired \%meta-data has been defined;
typically,
the request is deferred until all document input data
has been processed.
.
.P
When the
.RB \%\(lq O \(rq
argument is specified,
the document outline cache is flushed.
This may be safely requested
.I \%only
when the next bookmark to be placed will be at the topmost level,
(i.e.\ at level
.IR one ),
or when
.I all
document input data has been processed;
however, it is unnecessary to
.I explicitly
request such outline cache flushes,
other than at the end of document processing,
since the
.BR \%.\^pdfbookmark \|\(em\|or
.BR \%.\^pdfhref\^\ O \|\(em\|macros
will request them
.IR automatically ,
when it is safe to do so.
.
.P
It is permitted to specify
.I \%both
the
.RB \%\(lq M \(rq
and
.RB \%\(lq O \(rq
arguments together,
as a space-separated pair,
in a single
.B \%.\^pdfsync
macro call;
this requests flushing of
.I \%both
caches.
.
.P
If the
.B \%.\^pdfsync
macro is called
.I without
arguments,
this is interpreted as being equivalent to specifying
.I \%both
the
.RB \%\(lq M \(rq
and the
.RB \%\(lq O \(rq
arguments together.
.
.P
Typically,
it is convenient to specify a
.B \%.\^pdfsync
call,
.I without
arguments,
in an \(lqend-of-input\(rq processing macro,
to ensure that both caches are appropriately flushed
when all document input has been processed;
any macro package,
which is designed to interoperate with
.IR \%groff-pdfmark ,
should automatically incorporate such
an \(lqend-of-input\(rq processing request.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @SITE_TMACDIR@/pdfmark.tmac
This implements the core functionality of the entire
.I \%groff-pdfmark
macro suite.
.
.
.\" ====================================================================
.SH Author
.\" ====================================================================
.
The
.B \%groff_pdfmark
macros are provided by the
.I \%groff-pdfmark
package,
which was written by
.MT @AUTHOR_MT_ADDRESS@
Keith\ Marshall
.ME .
This was originally included as a contributed component of the
.I GNU\ roff
software distribution,
but is now independently maintained at,
and distributed from
.UR @PROJECT_HOSTING_SITE@
Keith's
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence the latest version may
.I always
be obtained;
any residual copies,
which may be found within recent
.I GNU\ roff
distributions,
are likely to be outdated.
.
.
.\" ====================================================================
.SH See Also
.\" ====================================================================
.
.\" @ENUMERATE_MR_REFERENCES@
.
.P
More comprehensive documentation,
on the use of the
.BR \%groff_pdfmark
macros,
and the
.I \%groff-pdfmark
macro suite in general,
may be found,
in PDF format,
in the reference guide
.RI \[lq] "Portable Document Format Publishing with GNU Troff" \[rq],
which has also been written by Keith Marshall;
the most recently published version of this guide may be read online,
by following the appropriate document reference link on
.UR @PROJECT_HOSTING_SITE@
the
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence a copy may also be downloaded.
.
.\" ====================================================================
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_pdfmark_7_man_C]
.do rr *groff_pdfmark_7_man_C
.
.\" ====================================================================
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
