.\" cover-info.ms
.\"
.\" Complement for the cover.ms template, which may be included within
.\" any primary document source stream, such that this template provides
.\" the front-matter specification; it overrides the default definitions
.\" of the CS and CE macros, as provided by spdf.tmac, to propagate the
.\" title and author specifications, from within a CS ... CE block, so
.\" that they are made available for use as PDF document meta-data.
.\"
.\"
.\" $Id: cover-info.ms,v 5a83bd9691e8 2023/12/11 21:52:19 keith $
.\"
.\" This file is part of the groff-pdfmark extension to groff, the GNU
.\" roff type-setting system.
.\"
.\" Written by Keith Marshall <keith.d.marshall@ntlworld.com>
.\" Copyright (C) 2023, Free Software Foundation, Inc.
.\"
.\" Copying and distribution of this file, with or without modification,
.\" is permitted, in any medium, without royalty, provided the copyright
.\" notice, and this notice are preserved.
.\"
.de CS
.\" By default, spdf.tmac ignores meta-data which is specified
.\" between .CS and .CE macro calls; override this behaviour, to
.\" read the document title and author meta-data, while ignoring
.\" other document meta-data attributes, which are specific only
.\" to the document front-matter content.
.\"
.   di doc.title
.   de AU@first de
.   \" The document title is collected in a diversion, named
.   \" "doc.title", which ends with the first .AU macro call;
.   \" terminate the diversion, and convert it to a string.
.   \"
.      br
.      di
.      asciify doc.title
.      chop doc.title
.      ds doc.author \\\\$*
.      als AU AU@next
.   de AU@next als
.   \" Multiple AU calls are permitted; any, beyond the first,
.   \" append additional names to the recorded list of authors.
.   \"
.      as doc.author , \\\\$*
.   als AU AU@first
.   de AI als
.   \" AI, and other additional macros, which are defined by
.   \" cover.ms for exclusive use within CS ... CE blocks, may
.   \" be treated here as "no-op" calls.
.   \"
.   als ASSERT-RIGHTS AI
.   als FDL-REFERENCE AI
.   als PUB AI
..
.de CE
.\" Additionally, override the default definition of CE, such
.\" that it completes the propagation of the title and author
.\" meta-data, from within the CS ... CE block.
.\"
.   pdfinfo /Title    \\*[doc.title]
.   pdfinfo /Author   \\*[doc.author]
..
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: filetype=groff
.\"
.\" $RCSfile: cover-info.ms,v $: end of file
