/* StandaloneAppletViewer.java -- a standalone viewer for Java applets
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;


/**
 * StandaloneAppletViewer displays an applet in its own Frame.  Most
 * of the context that is available to an applet within a webpage is
 * available to it in StandaloneAppletViewer.
 */
class StandaloneAppletViewer extends AppletViewer
{
  static ArrayList appletTags = new ArrayList();
  static ArrayList appletWindows = new ArrayList();

  StandaloneAppletViewer(String[] urls)
    throws MalformedURLException, IOException
  {
    // Handle each file specified on the command line.
    for (int i = 0; i < urls.length; i++)
      {
        TagParser parser = new TagParser(urls[i]);
        appletTags.addAll(parser.parseAppletTags());
      }

    printTags();
    createWindows();
  }

  StandaloneAppletViewer(String code, String codebase, String archives,
                         List parameters, Dimension dimensions)
    throws IOException
    {
      if (!(code.equals("") || code.endsWith(".class")))
        {
          System.err.println("gcjappletviewer: option '--code' requires a class filename");
          AppletViewer.printHelpMessage(1);
        }
      
      String tagString =
        "<EMBED"
        + " CODE=\"" + code + "\""
        + " WIDTH=" + dimensions.width
        + " HEIGHT=" + dimensions.height
        + " CODEBASE=\"" + codebase + "\""
        + " ARCHIVE=\"" + archives + "\">";

      // Handle parameters.
      Iterator pairs = parameters.iterator();
      while (pairs.hasNext())
        {
          StringTokenizer paramTokenizer =
            new StringTokenizer((String) pairs.next(), ",");
          tagString +=
            "<PARAM NAME=" + paramTokenizer.nextToken().trim() + " VALUE="
            + paramTokenizer.nextToken().trim() + ">";
        }
      
      tagString += "</EMBED>";

      StringReader reader = new StringReader(tagString);
      String path = System.getProperty("user.dir") + File.separator;
      TagParser parser = new TagParser(reader,
                                    new URL("file", "", path));
      appletTags.addAll(parser.parseAppletTags());

      printTags();
      createWindows();
    }

  void printTags()
  {
    if (verbose)
      {
        System.out.println("parsed applet tags:");

        for (int i = 0; i < appletTags.size(); i++)
          {
            AppletTag tag = (AppletTag) appletTags.get(i);

            System.out.println(" tag " + i + ":");
            System.out.println(tag);
          }
      }
  }

  void createWindows()
  {
    for (int i = 0; i < appletTags.size(); i++)
      {
        AppletTag tag = (AppletTag) appletTags.get(i);
          
        // Create a StandaloneAppletWindow and add it to the
        // appletWindows list.
        new StandaloneAppletWindow(tag, appletWindows);
      }
  }
}
