dnl ---------------------------------------------------------------------------
dnl GCJWEBPLUGIN_CHECK_GLIB
dnl ---------------------------------------------------------------------------

AC_DEFUN([GCJWEBPLUGIN_CHECK_GLIB],[
PKG_CHECK_MODULES([GLIB],[glib-2.0 >= 2.0])
AC_SUBST([GLIB_CFLAGS])
AC_SUBST([GLIB_LIBS])
])

dnl ---------------------------------------------------------------------------
dnl GCJWEBPLUGIN_CHECK_JAVA
dnl ---------------------------------------------------------------------------

AC_DEFUN([GCJWEBPLUGIN_CHECK_JAVA],[
AC_MSG_CHECKING([for java])
AC_ARG_WITH([java],
	    [AS_HELP_STRING([--with-java],
			    [the java vm to use for non-native viewer (default: gij)])],
	    [AC_SUBST([JAVA], ["$withval"])],
	    [AC_SUBST([JAVA], ["gij"])])
AC_MSG_RESULT([$JAVA])
])

dnl ---------------------------------------------------------------------------
dnl GCJWEBPLUGIN_CHECK_JAVAC
dnl ---------------------------------------------------------------------------

AC_DEFUN([GCJWEBPLUGIN_CHECK_JAVAC],[
AC_MSG_CHECKING([for javac])
AC_ARG_WITH([javac],
            [AS_HELP_STRING([--with-javac],
			    [the java compiler with flags to use (default: gcj -C)])],
	    [AC_SUBST([JAVAC], ["$withval"])],
	    [AC_SUBST([JAVAC], ["gcj -C"])])
AC_MSG_RESULT([$JAVAC])
dnl No fancy checking of the executable here.
dnl GCJWEBPLUGIN_CHECK_FEATURE_EMBEDDEDWINDOW will do this for us.
])

dnl ---------------------------------------------------------------------------
dnl GCJWEBPLUGIN_CHECK_JAVAH
dnl ---------------------------------------------------------------------------

AC_DEFUN([GCJWEBPLUGIN_CHECK_JAVAH],[
AC_MSG_CHECKING([for javah])
AC_ARG_WITH([javah],
	    [AS_HELP_STRING([--with-javah],
			    [the java header generator to use (default: gcjh)])],
	    [AC_SUBST([JAVAH], ["$withval"])],
	    [AC_SUBST([JAVAH], ["gcjh"])])
AC_MSG_RESULT([$JAVAH])
])

dnl ---------------------------------------------------------------------------
dnl GCJWEBPLUGIN_CHECK_JAR
dnl ---------------------------------------------------------------------------

AC_DEFUN([GCJWEBPLUGIN_CHECK_JAR],[
AC_MSG_CHECKING([for jar])
AC_ARG_WITH([jar],
	    [AS_HELP_STRING([--with-jar],
			    [the jar tool to use (default: jar)])],
	    [AC_SUBST([JAR], ["$withval"])],
	    [AC_SUBST([JAR], ["jar"])])
AC_MSG_RESULT([$JAR])
])

dnl ---------------------------------------------------------------------------
dnl GCJWEBPLUGIN_CHECK_FEATURE_EMBEDDEDWINDOW
dnl ---------------------------------------------------------------------------

AC_DEFUN([GCJWEBPLUGIN_CHECK_FEATURE_EMBEDDEDWINDOW],[
AC_MSG_CHECKING([for GNU EmbeddedWindow extension])
cat << EOF > EmbeddedWindowTest.java
import gnu.java.awt.EmbeddedWindow;
public class EmbeddedWindowTest extends EmbeddedWindow { }
EOF
$JAVAC EmbeddedWindowTest.java 2>/dev/null && test -s EmbeddedWindowTest.class
if test -s EmbeddedWindowTest.class
then
   AC_MSG_RESULT([found])
else
   AC_MSG_ERROR([not found])
fi
rm -rf EmbeddedWindowTest.class EmbeddedWindowTest.java
])

dnl ---------------------------------------------------------------------------
dnl GCJWEBPLUGIN_ENABLE_XPCOM_API
dnl ---------------------------------------------------------------------------

AC_DEFUN([GCJWEBPLUGIN_ENABLE_XPCOM_API],[
AC_ARG_ENABLE([xpcom-api],
              [AS_HELP_STRING([--enable-xpcom-api],
                              [use deprecated XPCOM plug-in API (default: disabled)])])
AM_CONDITIONAL([USE_XPCOM_API],
               [test "x$enable_xpcom_api" = xyes])
])

dnl ---------------------------------------------------------------------------
dnl GCJWEBPLUGIN_ENABLE_DEBUG
dnl ---------------------------------------------------------------------------

AC_DEFUN([GCJWEBPLUGIN_ENABLE_DEBUG],[
AC_ARG_ENABLE([debug],
              [AS_HELP_STRING([--enable-debug],
                              [enable plugin debugging output])],
              [AC_DEFINE([DEBUG], [], [Enable plugin debugging output.])])
])

dnl ---------------------------------------------------------------------------
dnl GCJWEBPLUGIN_WITH_PLUGIN_DIR
dnl ---------------------------------------------------------------------------

AC_DEFUN([GCJWEBPLUGIN_WITH_PLUGIN_DIR],[
AC_MSG_CHECKING([for plugin directory])
AC_ARG_WITH([plugin-dir],
            [AS_HELP_STRING([--with-plugin-dir],
                            [install directory (default: ~/.mozilla/plugins)])],
            [AC_SUBST([PLUGIN_DIR], [$withval])],
            [AC_SUBST([PLUGIN_DIR], [$HOME/.mozilla/plugins/])])
AC_MSG_RESULT([$PLUGIN_DIR])
])

dnl ---------------------------------------------------------------------------
dnl GCJWEBPLUGIN_ENABLE_EXTERNAL_MOZILLA_INCLUDES
dnl ---------------------------------------------------------------------------

AC_DEFUN([GCJWEBPLUGIN_ENABLE_EXTERNAL_MOZILLA_INCLUDES],[
AC_MSG_CHECKING([for using or own headers])
AC_ARG_ENABLE([external-mozilla-includes],
 	      [AS_HELP_STRING([--enable-external-mozilla-includes],
 			      [use Mozilla headers on your system (default: disabled)])],
	      [AC_MSG_RESULT([no])
	       AC_CHECK_PROG([MOZILLA_CONFIG], [mozilla-config], [mozilla-config], [$PATH])
	      ],
	      [AC_MSG_RESULT([yes])])
AM_CONDITIONAL([USE_EXTERNAL_MOZILLA_INCLUDES],
	       [test "x$enable_external_mozilla_includes" = xyes])
])
