/* gcjwebplugin - Webbrowser plugin to execute Java (tm) applets.
   Copyright (C) 2003  Michael Koch <konqueror@gmx.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307  USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


#include <glib.h>

#include <nsplugindefs.h>
#include <nsIJVMPluginTagInfo.h>
#include <nsIPluginInstancePeer.h>
#include <nsIPluginTagInfo2.h>
#include <plugin/npapi.h>

#include "GCJPluginInstance.h"
#include "pluginDebug.h"

NS_IMPL_ISUPPORTS2 (GCJPluginInstance, nsIPluginInstance, nsIJVMPluginInstance)

GCJPluginInstance::GCJPluginInstance (GCJPluginFactory* factory, JNIEnv* jniEnv)
  : m_peer (NULL)
{
  PLUGIN_DEBUG ("GCJPluginInstance::GCJPluginInstance\n");
}

GCJPluginInstance::~GCJPluginInstance ()
{
  PLUGIN_DEBUG ("GCJPluginInstance::~GCJPluginInstance\n");
}

NS_IMETHODIMP
GCJPluginInstance::Initialize (nsIPluginInstancePeer* peer)
{
  PLUGIN_DEBUG ("GCJPluginInstance::Initialize\n");
  
  m_peer = peer;
  NS_ADDREF(m_peer);

  nsresult result;
  nsIJVMPluginTagInfo* pluginTagInfo;
  nsIPluginTagInfo2* pluginTagInfo2;
  
  result = CallQueryInterface(peer, &pluginTagInfo);
  result = CallQueryInterface(peer, &pluginTagInfo2);
  
  if (NS_SUCCEEDED (result))
    {
      // Extract tag data from web browser.
      pluginTagInfo->GetCode (&code);
      pluginTagInfo->GetCodeBase (&codebase);
      pluginTagInfo->GetArchive (&archive);
      pluginTagInfo2->GetDocumentBase (&documentbase);
      pluginTagInfo2->GetParameters (numParams, paramNames, paramValues);
    }

  pluginTagInfo->Release();
  pluginTagInfo2->Release();

  return NS_OK;
}

NS_IMETHODIMP
GCJPluginInstance::GetPeer (nsIPluginInstancePeer** result)
{
  PLUGIN_DEBUG ("GCJPluginInstance::GetPeer\n");
  
  (*result) = m_peer;
  NS_ADDREF(m_peer);
  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::Start ()
{
  PLUGIN_DEBUG ("GCJPluginInstance::Start\n");

  // FIXME: call applet's start method via protocol

  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::Stop ()
{
  PLUGIN_DEBUG ("GCJPluginInstance::Stop\n");

  // FIXME: call applet's stop method via protocol

  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::Destroy ()
{
  PLUGIN_DEBUG ("GCJPluginInstance::Destroy\n");

  // FIXME: kill spawned process
  
  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::SetWindow (nsPluginWindow* window)
{
  PLUGIN_DEBUG ("GCJPluginInstance::SetWindow\n");

  width = window->width;
  height = window->height;
  xid = (int)(window->window);
  int output_to_gcjappletviewer_fd = 0;
  int input_from_gcjappletviewer_fd = 0;

  gchar *command_line [3] = { "gcjappletviewer", "--plugin", NULL };

  printf ("Running: %s\n", command_line);
  GError *err = NULL;

  // FIXME: open input and output pipes
  if (!g_spawn_async_with_pipes (NULL,
				 command_line,
				 NULL,
				 G_SPAWN_SEARCH_PATH,
				 NULL,
				 NULL,
				 NULL,
				 &output_to_gcjappletviewer_fd,
				 &input_from_gcjappletviewer_fd,
				 NULL,
				 &err))
  {
    fprintf (stderr, "SetWindow error: %s\n", err->message);
    return NPERR_GENERIC_ERROR;
  }

  GIOChannel* output_to_appletviewer = g_io_channel_unix_new (output_to_gcjappletviewer_fd);
  GIOChannel* input_from_appletviewer = g_io_channel_unix_new (input_from_gcjappletviewer_fd);

  g_printerr ("Spawned gcjappletviewer successfully.\n");

  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::NewStream (nsIPluginStreamListener** listener)
{
  PLUGIN_DEBUG ("GCJPluginInstance::NewStream\n");
  
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP 
GCJPluginInstance::Print (nsPluginPrint* platformPrint)
{
  PLUGIN_DEBUG ("GCJPluginInstance::Print\n");
  
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP 
GCJPluginInstance::GetValue (nsPluginInstanceVariable variable, void* value)
{
  PLUGIN_DEBUG2 ("GCJPluginInstance::GetValue: variable: %i\n", variable);
  
  switch (variable)
    {
      case nsPluginInstanceVariable_WindowlessBool:
        *(PRBool*) value = PR_FALSE;
        break;

      case nsPluginInstanceVariable_TransparentBool:
        *(PRBool*) value = PR_FALSE;
        break;

      case nsPluginInstanceVariable_DoCacheBool:
        *(PRBool*) value = PR_FALSE;
        break;

      case nsPluginInstanceVariable_CallSetWindowAfterDestroyBool:
	*(PRBool*) value = PR_FALSE;
	break;

      case (nsPluginInstanceVariable)NPPVpluginNeedsXEmbed:
	*(PRBool*) value = PR_TRUE;
	break;

      default:
	PLUGIN_DEBUG ("GCJPluginInstance::GetValue: Requested unknown value\n");
        return NS_ERROR_NOT_IMPLEMENTED;
    }

  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::HandleEvent (nsPluginEvent* event, PRBool* handled)
{
  PLUGIN_DEBUG ("GCJPluginInstance::HandleEvent\n");
 
  (*handled) = PR_TRUE;
  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::GetJavaObject (jobject* result)
{
  PLUGIN_DEBUG ("GCJPluginInstance::GetJavaObject\n");
 
  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::GetText (const char** result)
{
  PLUGIN_DEBUG ("GCJPluginInstance::GetText\n");
  
  return NS_ERROR_NOT_IMPLEMENTED;
}
