/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2015-2016-2017 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/***************
 *    cli.cc    *
 *    ~~~~~~    *
 ****************/

#include <pthread.h>
#include "../include/cli.h"
#include "../include/global.h"
#include "../include/search.h"

/* Cli ()
 * Welcomes users and runs the main loop.
 */
Cli::Cli ()
{
  debug (gettext ("Debug mode activated, and Fisoco (CLI version) launched !"));
  
  std::cout << gettext ("Welcome to Fisoco's command line interface !") << std::endl <<
    gettext ("Type 'help' to view a list of commands") << std::endl;
  // Prepare the variables
  init_command_list ();
  init_char_map ();
  init_entry_map ();
  std::string input = prompt ();
  std::list<std::string> command = parse_input (input);

  while (command.front () != "quit")
    {
      // Debug
      int size = command.size ();
      int i = 1;
      debug ("Input contains " + std::to_string (size) + " items.");
      for (std::string arg : command)
	{
	  debug (std::to_string (i) + "# argument is " + arg);
	  i++;
	}
      // Examine the command, then capture another one
      if (*command.begin () != "")
	examine (command);
      input = prompt ();        
      command = parse_input (input);
    }
}

std::string
Cli::get_dir_term ()
{
  return dir_term;
}

std::string
Cli::get_search_term ()
{
  return search_term;
}

void
Cli::notify (std::list<std::string> files, std::string dir)
{
  for (std::string file : files)
    results.add_file (dir, file);
}

void
Cli::search_finished ()
{
  // If it is not an internal call, tell user it has finished
  if (dir_term != "/var/tmp/fisoco" && search_term != ".bak.fis")
    {
      int size = results.get_list_size ();
      std::string gdn_message = gettext ("Search has finished: ")
	+ std::to_string(size) + gettext (" file(s) have been found !");
      std::cout << std::endl;
      goodnews (gdn_message);
    }
}
