/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2016 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 * 
 * This file is part of Fisoco.
 * 
 * Fisoco is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Fisoco is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *//////////////////////////////////////
/**********
 * list.h *
 * ~~~~~~ *
 **********/

#ifndef LIST_H
#define LIST_H

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <iostream>
#include <list>
#include <vector>
#include "search.h"
// i18n
#include "../include/gettext.h"

class List
{
 public:
  List ();    
  void add_file (std::string dir, std::string file);
  void del_file (int id);
  std::list<std::string> get_complete_names ();
  std::vector<std::string> get_infos (int id);
  int get_list_size ();
  void select (int id);
  
 private:
  // File class
  class File
  {
  public:
    File ();
    void set_filename (std::string name);
    std::string get_filename ();
    void set_filepath (std::string path);
    std::string get_filepath ();
    
    std::string filename;
    std::string filepath;
    std::string ownername;
    int size;
  };
  
  // Member data.
  std::vector<File*> Llist;
  int id;
  int number_max;
};

#endif // LIST_H

