/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2015-2016 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 *    cli.h     *
 *    ~~~~~~    *
 ****************/

#ifndef FISOCO_CLI_H
#define FISOCO_CLI_H

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <iostream>
#include <list>
#include <map>
#include "search.h"
#include "list.h"
// i18n
#include "gettext.h"

class Cli
{
public:
    Cli ();
    
    // Called from the worker thread.
    void notify (std::list<std::string> files, std::string dir);
    void search_finished ();
    std::string get_search_term ();
    std::string get_dir_term ();
    
private:

    // Prompt
    std::string bind_command (std::string cinitial, std::string winitial);
    void display_version ();
    void examine (std::list<std::string> command);
    void help (std::string argument);
    std::list<std::string> parse_input (std::string input);
    std::string prompt ();

    // Internal functions
    void backup ();
    void backup (std::string filename);
    const std::string currentDateTime ();
    std::list<std::string> get_file_from_line (std::string line);
    int load ();
    int load (int number);

    // External functions
    void clean ();
    void info (int numbers);
    void interactive_read ();
    int read ();
    void search ();

    List results;
    std::string dir_term;
    std::string search_term;

    struct entry {
      std::string command;
      std::string arguments;
      std::string short_desc;
      std::string long_desc;
    };

    std::map<std::string,struct entry> get_help_entries ();
};

#endif // FISOCO_CLI_H
