/*
 * Native.cs - Interface to the underlying native curses library.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace Curses
{

using System;
using System.Runtime.InteropServices;

[DllImportMapAttribute("std-shared-object",
					   "libcsharpcurses-0-0-1.dll",
					   "libcsharpcurses.so")]
[DllImportMapAttribute("std-shared-object",
					   "cygncurses5.dll",
					   "libncurses.so")]
internal sealed class Native
{
	//
	// Initialization, termination, and input processing.
	//

	[DllImport("libcsharpcurses-0-0-1.dll")]
	extern public static int CursesHelpInitialize();

	[DllImport("libcsharpcurses-0-0-1.dll")]
	extern public static void CursesHelpTerminate();

	[DllImport("libcsharpcurses-0-0-1.dll")]
	extern public static int CursesHelpGetNextChar(long timeToFire);

	//
	// Global variable access.
	//

	[DllImport("libcsharpcurses-0-0-1.dll")]
	extern public static int CursesHelpGetLines();

	[DllImport("libcsharpcurses-0-0-1.dll")]
	extern public static int CursesHelpGetCols();

	[DllImport("libcsharpcurses-0-0-1.dll")]
	extern public static IntPtr CursesHelpGetStdScr();

	[DllImport("libcsharpcurses-0-0-1.dll")]
	extern public static int CursesHelpGetColorPairs();

	//
	// Window operations.
	//

	[DllImport("cygncurses5.dll")]
	extern public static IntPtr newwin(int nlines, int ncols,
									   int begin_y, int begin_x);

	[DllImport("cygncurses5.dll")]
	extern public static IntPtr derwin(IntPtr orig, int nlines, int ncols,
									   int begin_y, int begin_x);

	[DllImport("cygncurses5.dll")]
	extern public static int delwin(IntPtr window);

	[DllImport("cygncurses5.dll")]
	extern public static void wbkgdset(IntPtr window, uint ch);

	[DllImport("cygncurses5.dll")]
	extern public static int wbkgd(IntPtr window, uint ch);

	[DllImport("cygncurses5.dll")]
	extern public static uint getbkgd(IntPtr window);

	[DllImport("cygncurses5.dll")]
	extern public static int wborder(IntPtr window,
									 uint ls, uint rs, uint ts, uint bs,
									 uint tl, uint tr, uint bl, uint br);

	[DllImport("cygncurses5.dll")]
	extern public static int wclear(IntPtr window);

	[DllImport("cygncurses5.dll")]
	extern public static int werase(IntPtr window);

	[DllImport("libcsharpcurses-0-0-1.dll")]
	extern public static int CursesHelpGetX(IntPtr window);

	[DllImport("libcsharpcurses-0-0-1.dll")]
	extern public static int CursesHelpGetY(IntPtr window);

	[DllImport("libcsharpcurses-0-0-1.dll")]
	extern public static int CursesHelpGetWidth(IntPtr window);

	[DllImport("libcsharpcurses-0-0-1.dll")]
	extern public static int CursesHelpGetHeight(IntPtr window);

	//
	// Refresh and update operations.
	//

	[DllImport("cygncurses5.dll")]
	extern public static int wrefresh(IntPtr window);

	[DllImport("cygncurses5.dll")]
	extern public static int wtouchln(IntPtr window, int y,
									  int n, int changed);

	//
	// Color management.
	//

	[DllImport("cygncurses5.dll")]
	extern public static int start_color();

	[DllImport("cygncurses5.dll")]
	extern public static int has_colors();

	[DllImport("cygncurses5.dll")]
	extern public static int init_pair(short pair, short f, short g);

	[DllImport("cygncurses5.dll")]
	extern public static int pair_content(short pair, out short f, out short g);

	//
	// Drawing operations.
	//

	[DllImport("cygncurses5.dll")]
	extern public static int wmove(IntPtr window, int y, int x);

	[DllImport("cygncurses5.dll")]
	extern public static int waddch(IntPtr window, uint ch);

	[DllImport("cygncurses5.dll")]
	extern public static int wechochar(IntPtr window, uint ch);

	[DllImport("libcsharpcurses-0-0-1.dll")]
	extern public static void CursesHelpAddLineChar(IntPtr window, int ch);

	[DllImport("cygncurses5.dll")]
	extern public static int waddstr(IntPtr window, String str);

	[DllImport("cygncurses5.dll")]
	extern public static int wattrset(IntPtr window, int attrs);

	[DllImport("cygncurses5.dll")]
	extern public static int wclrtobot(IntPtr window);

	[DllImport("cygncurses5.dll")]
	extern public static int wclrtoeol(IntPtr window);

	[DllImport("cygncurses5.dll")]
	extern public static int whline(IntPtr window, uint ch, int n);

	[DllImport("cygncurses5.dll")]
	extern public static int wvline(IntPtr window, uint ch, int n);

	[DllImport("cygncurses5.dll")]
	extern public static int winsch(IntPtr window, uint ch);

	[DllImport("cygncurses5.dll")]
	extern public static int wdelch(IntPtr window);

	//
	// Misc operators.
	//

	[DllImport("cygncurses5.dll")]
	extern public static int beep();

	[DllImport("cygncurses5.dll")]
	extern public static int flash();

} // class Native

} // namespace Curses
