/*
 * MouseState.cs - Mouse button state values.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace Curses
{

using System;

/// <summary>
/// <para>Mouse state masks for use with <c>Curses</c> classes.</para>
/// </summary>
///
/// <remarks>
/// <para>When mouse events are reported to the application,
/// the called delegate is passed a <c>state</c> parameter
/// that indicates the state of all mouse buttons and shift keys.
/// The constants in this enumeration can be used to decode
/// this state information.</para>
/// </remarks>
[Flags]
public enum MouseState
{

	/// <summary>
	/// <para>Button1 has been released.</para>
	/// </summary>
	Button1Released		 		= 0x00000001,

	/// <summary>
	/// <para>Button1 has been pressed.</para>
	/// </summary>
	Button1Pressed				= 0x00000002,

	/// <summary>
	/// <para>Button1 has been clicked.</para>
	/// </summary>
	Button1Clicked				= 0x00000004,

	/// <summary>
	/// <para>Button1 has been double-clicked.</para>
	/// </summary>
	Button1DoubleClicked		= 0x00000008,

	/// <summary>
	/// <para>Button1 has been triple-clicked.</para>
	/// </summary>
	Button1TripleClicked		= 0x00000010,

	/// <summary>
	/// <para>Button1 has been involved in a "reserved" event.</para>
	/// </summary>
	Button1ReservedEvent		= 0x00000020,

	/// <summary>
	/// <para>Button2 has been released.</para>
	/// </summary>
	Button2Released		 		= 0x00000040,

	/// <summary>
	/// <para>Button2 has been pressed.</para>
	/// </summary>
	Button2Pressed				= 0x00000080,

	/// <summary>
	/// <para>Button2 has been clicked.</para>
	/// </summary>
	Button2Clicked				= 0x00000100,

	/// <summary>
	/// <para>Button2 has been double-clicked.</para>
	/// </summary>
	Button2DoubleClicked		= 0x00000200,

	/// <summary>
	/// <para>Button2 has been triple-clicked.</para>
	/// </summary>
	Button2TripleClicked		= 0x00000400,

	/// <summary>
	/// <para>Button2 has been involved in a "reserved" event.</para>
	/// </summary>
	Button2ReservedEvent		= 0x00000800,

	/// <summary>
	/// <para>Button3 has been released.</para>
	/// </summary>
	Button3Released		 		= 0x00001000,

	/// <summary>
	/// <para>Button3 has been pressed.</para>
	/// </summary>
	Button3Pressed				= 0x00002000,

	/// <summary>
	/// <para>Button3 has been clicked.</para>
	/// </summary>
	Button3Clicked				= 0x00004000,

	/// <summary>
	/// <para>Button3 has been double-clicked.</para>
	/// </summary>
	Button3DoubleClicked		= 0x00008000,

	/// <summary>
	/// <para>Button3 has been triple-clicked.</para>
	/// </summary>
	Button3TripleClicked		= 0x00010000,

	/// <summary>
	/// <para>Button3 has been involved in a "reserved" event.</para>
	/// </summary>
	Button3ReservedEvent		= 0x00020000,

	/// <summary>
	/// <para>Button4 has been released.</para>
	/// </summary>
	Button4Released		 		= 0x00040000,

	/// <summary>
	/// <para>Button4 has been pressed.</para>
	/// </summary>
	Button4Pressed				= 0x00080000,

	/// <summary>
	/// <para>Button4 has been clicked.</para>
	/// </summary>
	Button4Clicked				= 0x00100000,

	/// <summary>
	/// <para>Button4 has been double-clicked.</para>
	/// </summary>
	Button4DoubleClicked		= 0x00200000,

	/// <summary>
	/// <para>Button4 has been triple-clicked.</para>
	/// </summary>
	Button4TripleClicked		= 0x00400000,

	/// <summary>
	/// <para>Button4 has been involved in a "reserved" event.</para>
	/// </summary>
	Button4ReservedEvent		= 0x00800000,

	/// <summary>
	/// <para>The "Ctrl" key is currently held down.</para>
	/// </summary>
	Ctrl						= 0x01000000,

	/// <summary>
	/// <para>The "Shift" key is currently held down.</para>
	/// </summary>
	Shift						= 0x02000000,

	/// <summary>
	/// <para>The "Alt" key is currently held down.</para>
	/// </summary>
	Alt							= 0x04000000,

	/// <summary>
	/// <para>State mask that corresponds to all mouse events,
	/// except for the reporting of the mouse position.</para>
	/// </summary>
	AllMouseEvents				= 0x07FFFFFF,

	/// <summary>
	/// <para>State mask that indicates that the mouse position
	/// should be reported to the application.</para>
	/// </summary>
	ReportMousePosition			= 0x08000000

} // enum MouseState

} // namespace Curses
