/*
 * Banner.cs - Display the game banner screen.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace Frogger
{

using System;
using Curses;

public class Banner
{

	// Draw the banner.
	public static void DrawBanner(Window window)
			{
				window.Background = Color.Black;
				DrawingContext dc = window.DrawingContext;
				dc.Foreground = Color.Green;
				dc.Background = Color.Black;
				int lines = window.Height;
				if(lines > 24)
				{
					dc.Move(0, (lines / 2) - 11);
				}
				dc.Add(@"

    CCCCCC   UU    UU  RRRRRRR    SSSSSS   EEEEEEEE         OOOO    FFFFFFFF
   CC    CC  UU    UU  RR    RR  SS    SS  EE              OO  OO   FF
   CC        UU    UU  RR    RR  SS        EE             OO    OO  FF
   CC        UU    UU  RRRRRRR    SSSSSS   EEEEEE         OO    OO  FFFFFF
   CC        UU    UU  RR  RR          SS  EE             OO    OO  FF
   CC    CC  UU    UU  RR   RR   SS    SS  EE              OO  OO   FF
    CCCCCC    UUUUUU   RR    RR   SSSSSS   EEEEEEEE         OOOO    FF


     FFFFFFFF  RRRRRRR     OOOO     GGGGGG    GGGGGG   EEEEEEEE  RRRRRRR
     FF        RR    RR   OO  OO   GG    GG  GG    GG  EE        RR    RR
     FF        RR    RR  OO    OO  GG        GG        EE        RR    RR
     FFFFFF    RRRRRRR   OO    OO  GG   GGG  GG   GGG  EEEEEE    RRRRRRR
     FF        RR  RR    OO    OO  GG    GG  GG    GG  EE        RR  RR  
     FF        RR   RR    OO  OO   GG    GG  GG    GG  EE        RR   RR 
     FF        RR    RR    OOOO     GGGGGG    GGGGGG   EEEEEEEE  RR    RR


");
				dc.Foreground = Color.White;
				dc.Add(@"
             Copyright (c) 2001 Southern Storm Software, Pty Ltd
");
			}

} // class Banner

} // namespace Frogger
