﻿//
// MonoTests.Mono.Math.BitwiseTest.cs
//
// Authors:
//	Ben Maurer
//
// Copyright (c) 2003 Ben Maurer. All rights reserved
//

using System;
using Mono.Math;
using NUnit.Framework;

namespace MonoTests.Mono.Math {

	public abstract class Bitwise_Base : BigIntegerTestSet {

		BigInteger N, expectedNls, expectedNrs;

		int shiftAmount;
		
		public Bitwise_Base() 
		{
			N = new BigInteger(n);
			expectedNls = new BigInteger(ExpectedNLeftShift);
			expectedNrs = new BigInteger(ExpectedNRightShift);
			shiftAmount = ShiftAmount;
		}
		
		public abstract uint[] n {
			get;
		}
		
		public abstract int ShiftAmount {
			get;
		}

		public abstract uint[] ExpectedNLeftShift {
			get;
		}

		public abstract uint[] ExpectedNRightShift {
			get;
		}

		[Test]
		public void ShiftLeft() 
		{
			Expect( N << shiftAmount, expectedNls );
		}

		[Test]
		public void ShiftRight() 
		{
			Expect( N >> shiftAmount, expectedNrs );
		}
	}

	public class Bitwise_Rand512n : Bitwise_Base {

		public override uint[] n {
			get {
				return new uint[] {
					0xb29696b0, 0x8a8674b9, 0xabf0f8b7, 0xb873579f, 0x88d90993, 0x697c9290,
					0xbb70f64c, 0x77f4c616, 0x60bab197, 0x39884b0d, 0x37e83131, 0x8de30d79,
					0xae47b2e2, 0x67718497, 0x23559359, 0xc4c9259c
				};
			}
		}

		public override int ShiftAmount {
			get {
				return 12;
			}
		}

		public override uint[] ExpectedNLeftShift {
			get {
				return new uint[] {
					0xb29, 0x696b08a8, 0x674b9abf, 0x0f8b7b87, 0x3579f88d, 0x90993697, 
					0xc9290bb7, 0x0f64c77f, 0x4c61660b, 0xab197398, 0x84b0d37e, 0x831318de, 
					0x30d79ae4, 0x7b2e2677, 0x18497235, 0x59359c4c, 0x9259c000
				};
			}
		}
		public override uint[] ExpectedNRightShift {
			get {
				return new uint[] {
					0xb2969, 0x6b08a867, 0x4b9abf0f, 0x8b7b8735, 0x79f88d90, 0x993697c9,
					0x290bb70f, 0x64c77f4c, 0x61660bab, 0x19739884, 0xb0d37e83, 0x1318de30,
					0xd79ae47b, 0x2e267718, 0x49723559, 0x359c4c92
				};
			}
		}
	}
	
	public class Bitwise_Rand2048n : Bitwise_Base {

		public override uint[] n {
			get {
				return new uint[] {
					0x27dd8385, 0xf44cf2f6, 0x2fba638e, 0x23151ade, 0xc4366886, 0x86d5ea9e,
					0xd8c92f09, 0x326fd166, 0xc466ab65, 0xe163db79, 0xcc6eb808, 0xce262b4c,
					0x7317b66b, 0x360c9746, 0x0464d7c2, 0x37709a34, 0x2ee973fc, 0x04c90896,
					0x60790e40, 0xff5247f8, 0x864d5f5b, 0xcf8e8567, 0x59782b43, 0x27cfbb82,
					0x0dc53a89, 0x8072e526, 0xcf44d0d1, 0x4eeac325, 0xcb1c91aa, 0x8d09c910,
					0xe13ab08e, 0x656235ef, 0xb553255c, 0x8709557a, 0x7f809100, 0xf47c7acf,
					0x9c70a17f, 0x8c1b2aa3, 0x1d6f0cec, 0x9c1ca046, 0xaac3c552, 0xd04318fc,
					0x5c217295, 0x8deb3c73, 0xaa039583, 0x72ccfbc6, 0x91783ee6, 0xe3257194,
					0x70e54a12, 0x0b29e5b9, 0x0b4c883c, 0xaf2fe460, 0x21f86d3b, 0x35ce8fc7,
					0x9f336fc8, 0x3e0e1aa0, 0xed8ec9f1, 0xc10572d9, 0x26fb856e, 0x96f425c2,
					0xf73f62f4, 0xa0690bb7, 0x35875324, 0x513e84b7
				};
			}
		}

		public override int ShiftAmount {
			get {
				return 48;
			}
		}

		public override uint[] ExpectedNLeftShift {
			get {
				return new uint[] {
					0x27dd, 0x8385f44c, 0xf2f62fba, 0x638e2315, 0x1adec436, 0x688686d5,
					0xea9ed8c9, 0x2f09326f, 0xd166c466, 0xab65e163, 0xdb79cc6e, 0xb808ce26,
					0x2b4c7317, 0xb66b360c, 0x97460464, 0xd7c23770, 0x9a342ee9, 0x73fc04c9,
					0x08966079, 0x0e40ff52, 0x47f8864d, 0x5f5bcf8e, 0x85675978, 0x2b4327cf,
					0xbb820dc5, 0x3a898072, 0xe526cf44, 0xd0d14eea, 0xc325cb1c, 0x91aa8d09,
					0xc910e13a, 0xb08e6562, 0x35efb553, 0x255c8709, 0x557a7f80, 0x9100f47c,
					0x7acf9c70, 0xa17f8c1b, 0x2aa31d6f, 0x0cec9c1c, 0xa046aac3, 0xc552d043,
					0x18fc5c21, 0x72958deb, 0x3c73aa03, 0x958372cc, 0xfbc69178, 0x3ee6e325,
					0x719470e5, 0x4a120b29, 0xe5b90b4c, 0x883caf2f, 0xe46021f8, 0x6d3b35ce,
					0x8fc79f33, 0x6fc83e0e, 0x1aa0ed8e, 0xc9f1c105, 0x72d926fb, 0x856e96f4,
					0x25c2f73f, 0x62f4a069, 0x0bb73587, 0x5324513e, 0x84b70000, 0x00000000
				};
			}
		}

		public override uint[] ExpectedNRightShift {
			get {
				return new uint[] {
					0x27dd, 0x8385f44c, 0xf2f62fba, 0x638e2315, 0x1adec436, 0x688686d5,
					0xea9ed8c9, 0x2f09326f, 0xd166c466, 0xab65e163, 0xdb79cc6e, 0xb808ce26,
					0x2b4c7317, 0xb66b360c, 0x97460464, 0xd7c23770, 0x9a342ee9, 0x73fc04c9,
					0x08966079, 0x0e40ff52, 0x47f8864d, 0x5f5bcf8e, 0x85675978, 0x2b4327cf,
					0xbb820dc5, 0x3a898072, 0xe526cf44, 0xd0d14eea, 0xc325cb1c, 0x91aa8d09,
					0xc910e13a, 0xb08e6562, 0x35efb553, 0x255c8709, 0x557a7f80, 0x9100f47c,
					0x7acf9c70, 0xa17f8c1b, 0x2aa31d6f, 0x0cec9c1c, 0xa046aac3, 0xc552d043,
					0x18fc5c21, 0x72958deb, 0x3c73aa03, 0x958372cc, 0xfbc69178, 0x3ee6e325,
					0x719470e5, 0x4a120b29, 0xe5b90b4c, 0x883caf2f, 0xe46021f8, 0x6d3b35ce,
					0x8fc79f33, 0x6fc83e0e, 0x1aa0ed8e, 0xc9f1c105, 0x72d926fb, 0x856e96f4,
					0x25c2f73f, 0x62f4a069, 0x0bb73587
				};
			}
		}
	}
}
