/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.WeightedEvaluation;
import org.apache.commons.math3.stat.descriptive.moment.FirstMoment;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.apache.commons.math3.util.MathUtils;

public class Mean
extends AbstractStorelessUnivariateStatistic
implements Serializable,
WeightedEvaluation {
    private static final long serialVersionUID = -1296043746617791564L;
    protected FirstMoment moment;
    protected boolean incMoment;

    public Mean() {
        this.incMoment = true;
        this.moment = new FirstMoment();
    }

    public Mean(FirstMoment m1) {
        this.moment = m1;
        this.incMoment = false;
    }

    public Mean(Mean original) throws NullArgumentException {
        Mean.copy(original, this);
    }

    public void increment(double d2) {
        if (this.incMoment) {
            this.moment.increment(d2);
        }
    }

    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    public double getResult() {
        return this.moment.m1;
    }

    public long getN() {
        return this.moment.getN();
    }

    public double evaluate(double[] values2, int begin, int length) throws MathIllegalArgumentException {
        if (this.test(values2, begin, length)) {
            Sum sum = new Sum();
            double sampleSize = length;
            double xbar = sum.evaluate(values2, begin, length) / sampleSize;
            double correction = 0.0;
            for (int i2 = begin; i2 < begin + length; ++i2) {
                correction += values2[i2] - xbar;
            }
            return xbar + correction / sampleSize;
        }
        return Double.NaN;
    }

    public double evaluate(double[] values2, double[] weights, int begin, int length) throws MathIllegalArgumentException {
        if (this.test(values2, weights, begin, length)) {
            Sum sum = new Sum();
            double sumw = sum.evaluate(weights, begin, length);
            double xbarw = sum.evaluate(values2, weights, begin, length) / sumw;
            double correction = 0.0;
            for (int i2 = begin; i2 < begin + length; ++i2) {
                correction += weights[i2] * (values2[i2] - xbarw);
            }
            return xbarw + correction / sumw;
        }
        return Double.NaN;
    }

    public double evaluate(double[] values2, double[] weights) throws MathIllegalArgumentException {
        return this.evaluate(values2, weights, 0, values2.length);
    }

    public Mean copy() {
        Mean result2 = new Mean();
        Mean.copy(this, result2);
        return result2;
    }

    public static void copy(Mean source, Mean dest) throws NullArgumentException {
        MathUtils.checkNotNull(source);
        MathUtils.checkNotNull(dest);
        dest.setData(source.getDataRef());
        dest.incMoment = source.incMoment;
        dest.moment = source.moment.copy();
    }
}

