/*
 * Decompiled with CFR 0.152.
 */
package gde.device.robbe;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.robbe.PowerPeak;
import gde.device.robbe.PowerPeakIV;
import gde.device.robbe.PowerPeakSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.util.logging.Logger;

public class PowerPeakGathererThread
extends Thread {
    static final String $CLASS_NAME = PowerPeakGathererThread.class.getName();
    static final Logger log = Logger.getLogger(PowerPeakGathererThread.class.getName());
    static final int TIME_STEP_DEFAULT = 1000;
    static final int WAIT_TIME_RETRYS = 3600;
    final DataExplorer application;
    final PowerPeakSerialPort serialPort;
    final PowerPeak device;
    final Channels channels;
    String recordSetKey1 = Messages.getString((String)"GDE_MSGT0272");
    String recordSetKey2 = Messages.getString((String)"GDE_MSGT0272");
    int retryCounter = 3600;
    boolean isCollectDataStopped = false;
    boolean isProgrammExecuting1 = false;
    boolean isProgrammExecuting2 = false;
    boolean[] isAlerted4Finish = new boolean[]{false, false, false, false};
    boolean isCombinedMode = false;
    boolean isContinuousRecordSet = Settings.getInstance().isContinuousRecordSet();

    public PowerPeakGathererThread() throws ApplicationConfigurationException, SerialPortException {
        super("dataGatherer");
        this.application = DataExplorer.getInstance();
        this.device = (PowerPeak)this.application.getActiveDevice();
        this.serialPort = this.device.getCommunicationPort();
        this.channels = Channels.getInstance();
        this.setPriority(10);
    }

    @Override
    public void run() {
        String $METHOD_NAME = "run";
        RecordSet recordSet1 = null;
        RecordSet recordSet2 = null;
        int[] points1 = new int[this.device.getNumberOfMeasurements(1)];
        int[] points2 = new int[this.device.getNumberOfMeasurements(2)];
        byte[] dataBuffer = null;
        this.isProgrammExecuting1 = false;
        this.isProgrammExecuting2 = false;
        this.isCollectDataStopped = false;
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
        while (!this.isCollectDataStopped) {
            try {
                dataBuffer = this.serialPort.getData(true);
                switch (this.device.getDeviceTypeIdentifier()) {
                    default: 
                }
                this.isProgrammExecuting1 = this.device.isProcessing(1, dataBuffer);
                this.isProgrammExecuting2 = this.device.isProcessing(2, dataBuffer);
                if (this.isProgrammExecuting1 || this.isProgrammExecuting2) {
                    switch (this.device.getDeviceTypeIdentifier()) {
                        default: {
                            Object[] ch1;
                            if (this.isProgrammExecuting1) {
                                ch1 = this.processDataChannel(1, recordSet1, this.recordSetKey1, dataBuffer, points1);
                                recordSet1 = (RecordSet)ch1[0];
                                this.recordSetKey1 = (String)ch1[1];
                            }
                            if (!this.isProgrammExecuting2) break;
                            byte[] buffer = new byte[Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO)) / 2];
                            System.arraycopy(dataBuffer, buffer.length - 4, buffer, 0, buffer.length);
                            if (log.isLoggable(Level.FINER)) {
                                log.log(Level.FINER, StringHelper.byte2CharString((byte[])dataBuffer, (int)1, (int)buffer.length));
                                log.log(Level.FINER, StringHelper.byte2CharString((byte[])buffer, (int)1, (int)buffer.length));
                            }
                            Object[] ch2 = this.processDataChannel(2, recordSet2, this.recordSetKey2, buffer, points2);
                            recordSet2 = (RecordSet)ch2[0];
                            this.recordSetKey2 = (String)ch2[1];
                            break;
                        }
                        case PowerPeakIV: {
                            Object[] ch1;
                            if (this.isProgrammExecuting1) {
                                ch1 = this.processDataChannel(1, recordSet1, this.recordSetKey1, dataBuffer, points1);
                                recordSet1 = (RecordSet)ch1[0];
                                this.recordSetKey1 = (String)ch1[1];
                            }
                            if (!this.isProgrammExecuting2) break;
                            Object[] ch2 = this.processDataChannel(2, recordSet2, this.recordSetKey2, ((PowerPeakIV)this.device).getPreparedBufferChannel2(dataBuffer), points2);
                            recordSet2 = (RecordSet)ch2[0];
                            this.recordSetKey2 = (String)ch2[1];
                        }
                    }
                    if (!this.isProgrammExecuting1 && recordSet1 != null && recordSet1.getRecordDataSize(true) > 5) {
                        this.finalizeRecordSet(recordSet1.getName());
                        this.isProgrammExecuting1 = false;
                        recordSet1 = null;
                    }
                    if (this.isProgrammExecuting2 || recordSet2 == null || recordSet2.getRecordDataSize(true) <= 5) continue;
                    this.finalizeRecordSet(recordSet2.getName());
                    this.isProgrammExecuting2 = false;
                    recordSet2 = null;
                    continue;
                }
                this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI2200"));
                log.logp(java.util.logging.Level.FINER, $CLASS_NAME, "run", "wait for device activation");
                if (0 == this.setRetryCounter(this.getRetryCounter() - 1)) {
                    log.log(java.util.logging.Level.FINE, "device activation timeout");
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI2203"));
                    this.stopDataGatheringThread(false, null);
                }
                int processNumber = this.device.getProcessingMode(dataBuffer);
                if (recordSet1 != null && recordSet1.getRecordDataSize(true) > 5) {
                    this.finalizeRecordSet(recordSet1.getName());
                    this.isProgrammExecuting1 = false;
                    recordSet1 = null;
                    if (processNumber == 4) {
                        this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI2204", (Object[])new Object[]{1}));
                    }
                }
                if (recordSet2 == null || recordSet2.getRecordDataSize(true) <= 5) continue;
                this.finalizeRecordSet(recordSet2.getName());
                this.isProgrammExecuting2 = false;
                recordSet2 = null;
                if (processNumber != 4) continue;
                this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI2204", (Object[])new Object[]{2}));
            }
            catch (DataInconsitsentException e) {
                String message = Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"});
                if (recordSet1 != null) {
                    this.cleanup(recordSet1.getName(), message);
                }
                if (recordSet2 != null) {
                    this.cleanup(recordSet2.getName(), message);
                }
                this.stopDataGatheringThread(false, e);
            }
            catch (Throwable e) {
                if (e instanceof TimeOutException) {
                    if (recordSet1 != null) {
                        this.finalizeRecordSet(recordSet1.getName());
                        recordSet1 = null;
                        WaitTimer.delay((long)1000L);
                    }
                    if (recordSet2 == null) continue;
                    this.finalizeRecordSet(recordSet2.getName());
                    recordSet2 = null;
                    WaitTimer.delay((long)1000L);
                    continue;
                }
                if (e instanceof TimeOutException && !this.isProgrammExecuting1 && !this.isProgrammExecuting2) {
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI2200"));
                    log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "wait for device activation ...");
                    if (0 != this.setRetryCounter(this.getRetryCounter() - 1)) continue;
                    log.log(java.util.logging.Level.FINE, "device activation timeout");
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI2200"));
                    this.stopDataGatheringThread(false, null);
                    continue;
                }
                log.log(java.util.logging.Level.FINE, "program end detected");
                this.stopDataGatheringThread(true, e);
            }
        }
        this.application.setStatusMessage("");
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "======> exit");
    }

    private synchronized Object[] processDataChannel(int number, RecordSet recordSet, String recordSetKey, byte[] dataBuffer, int[] points) throws DataInconsitsentException {
        Channel channel;
        String processName;
        String $METHOD_NAME = "processOutlet";
        Object[] result = new Object[2];
        int processNumber = this.device.getProcessingMode(dataBuffer);
        String string = processName = this.isContinuousRecordSet ? Messages.getString((String)"GDE_MSGT2239") : this.device.USAGE_MODE[processNumber];
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "processName = " + processName + " " + processNumber);
        }
        if ((channel = (Channel)this.channels.get((Object)number)) != null) {
            if (recordSet == null || !((String)recordSetKey).contains(processName)) {
                this.application.setStatusMessage("");
                this.setRetryCounter(3600);
                StringBuilder extend = new StringBuilder();
                if (processNumber < 5) {
                    String processingType = this.device.getProcessingType(dataBuffer);
                    int cycleNumber = this.device.getCycleNumber(number, dataBuffer);
                    if (processingType.length() > 3 || cycleNumber > 0) {
                        extend.append(" [");
                    }
                    if (processingType.length() > 3) {
                        extend.append(processingType);
                    }
                    if (cycleNumber > 0) {
                        if (processingType.equals(Messages.getString((String)"GDE_MSGT2302"))) {
                            extend.append(":").append(cycleNumber);
                        } else {
                            if (processingType.length() > 0) {
                                extend.append(" - ");
                            }
                            extend.append(Messages.getString((String)"GDE_MSGT2302")).append(":").append(cycleNumber);
                        }
                    }
                    if (processingType.length() > 3 || cycleNumber > 0) {
                        extend.append("]");
                    }
                }
                recordSetKey = channel.getNextRecordSetNumber() + ") " + (String)(this.isContinuousRecordSet ? processName : processName + extend.toString());
                recordSetKey = ((String)recordSetKey).length() <= 40 ? recordSetKey : ((String)recordSetKey).substring(0, 40);
                channel.put(recordSetKey, (Object)RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.application.getActiveDevice(), (int)channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                channel.applyTemplateBasics((String)recordSetKey);
                log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "processOutlet", (String)recordSetKey + " created for channel " + channel.getName());
                recordSet = (RecordSet)channel.get(recordSetKey);
                this.device.setTemperatureUnit(number, recordSet, dataBuffer);
                recordSet.setAllDisplayable();
                this.channels.switchChannel(channel.getNumber(), (String)recordSetKey);
                channel.switchRecordSet((String)recordSetKey);
                String description = recordSet.getRecordSetDescription() + GDE.LINE_SEPARATOR + "Firmware  : " + this.device.firmware + (String)(this.device.getBatteryMemoryNumber(number, dataBuffer) >= 1 ? "; Memory #" + this.device.getBatteryMemoryNumber(number, dataBuffer) : "");
                recordSet.setRecordSetDescription(description);
                if (processNumber == 4 && !this.isAlerted4Finish[number]) {
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI2204", (Object[])new Object[]{number}));
                    this.isAlerted4Finish[number] = true;
                } else {
                    this.isAlerted4Finish[number] = false;
                }
            }
            if (this.isContinuousRecordSet && processNumber == 3) {
                result[0] = recordSet;
                result[1] = recordSetKey;
                return result;
            }
            recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer));
            this.application.updateAllTabs(false);
            if (recordSet.get(0).realSize() < 3 || recordSet.get(0).realSize() % 10 == 0) {
                this.device.updateVisibilityStatus(recordSet, true);
            }
        }
        result[0] = recordSet;
        result[1] = recordSetKey;
        return result;
    }

    void stopDataGatheringThread(boolean enableEndMessage, Throwable throwable) {
        String $METHOD_NAME = "stopDataGatheringThread";
        if (throwable != null) {
            log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "stopDataGatheringThread", throwable.getMessage(), throwable);
        }
        this.isCollectDataStopped = true;
        if (this.serialPort != null) {
            if (this.serialPort.getXferErrors() > 0) {
                log.log(java.util.logging.Level.WARNING, "During complete data transfer " + this.serialPort.getXferErrors() + " number of errors occured!");
            }
            this.serialPort.close();
        }
    }

    void finalizeRecordSet(String recordSetKey) {
        RecordSet tmpRecordSet = this.channels.getActiveChannel().getActiveRecordSet();
        if (tmpRecordSet != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, true);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(recordSetKey, false);
            log.log(Level.TIME, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(String recordSetKey, final String message) {
        RecordSet activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet();
        if (activeRecordSet != null) {
            activeRecordSet.clear();
            this.channels.getActiveChannel().remove(recordSetKey);
            if (Thread.currentThread().getId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(recordSetKey, true);
                this.application.openMessageDialog(message);
            } else {
                final String useRecordSetKey = recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PowerPeakGathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        PowerPeakGathererThread.this.application.updateStatisticsData();
                        PowerPeakGathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        PowerPeakGathererThread.this.application.openMessageDialog(message);
                    }
                });
            }
        } else {
            this.application.openMessageDialog(message);
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }

    int getRetryCounter() {
        return this.retryCounter;
    }

    int setRetryCounter(int newRetryCounter) {
        this.retryCounter = newRetryCounter;
        return this.retryCounter;
    }
}

