/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.skyrc.ChargerDialog;
import gde.device.skyrc.MC3000;
import gde.device.skyrc.Q200GathererThread;
import gde.device.skyrc.Q200UsbPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbException;
import javax.xml.bind.JAXBException;

public class Q200
extends MC3000
implements IDevice {
    static final Logger log = Logger.getLogger(Q200.class.getName());
    final ChargerDialog dialog;
    Q200GathererThread dataGatherThread;
    Q200UsbPort usbPort;
    int[] resetEnergy = new int[]{5, 5, 5, 5};
    double[] energy = new double[]{0.0, 0.0, 0.0, 0.0};
    SystemInfo[] systemInfo = new SystemInfo[4];
    SystemSetting[] systemSetting = new SystemSetting[4];

    public Q200(String xmlFileName) throws FileNotFoundException, JAXBException {
        super(xmlFileName);
        this.USAGE_MODE_LI = new String[]{Messages.getString((String)"GDE_MSGT3616"), Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3613"), Messages.getString((String)"GDE_MSGT3612"), Messages.getString((String)"GDE_MSGT3615")};
        this.USAGE_MODE_NI = new String[]{Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3625"), Messages.getString((String)"GDE_MSGT3623"), Messages.getString((String)"GDE_MSGT3626"), Messages.getString((String)"GDE_MSGT3624")};
        this.USAGE_MODE_PB = new String[]{Messages.getString((String)"GDE_MSGT3620"), Messages.getString((String)"GDE_MSGT3623")};
        this.BATTERY_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3649"), Messages.getString((String)"GDE_MSGT3640"), Messages.getString((String)"GDE_MSGT3641"), Messages.getString((String)"GDE_MSGT3642"), Messages.getString((String)"GDE_MSGT3643"), Messages.getString((String)"GDE_MSGT3644"), Messages.getString((String)"GDE_MSGT3648")};
        this.usbPort = new Q200UsbPort(this, this.application);
        this.dialog = new ChargerDialog(this.application.getShell(), this);
    }

    public Q200(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        this.USAGE_MODE_LI = new String[]{Messages.getString((String)"GDE_MSGT3616"), Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3613"), Messages.getString((String)"GDE_MSGT3612"), Messages.getString((String)"GDE_MSGT3615")};
        this.USAGE_MODE_NI = new String[]{Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3625"), Messages.getString((String)"GDE_MSGT3623"), Messages.getString((String)"GDE_MSGT3626"), Messages.getString((String)"GDE_MSGT3624")};
        this.USAGE_MODE_PB = new String[]{Messages.getString((String)"GDE_MSGT3620"), Messages.getString((String)"GDE_MSGT3623")};
        this.BATTERY_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3649"), Messages.getString((String)"GDE_MSGT3640"), Messages.getString((String)"GDE_MSGT3641"), Messages.getString((String)"GDE_MSGT3642"), Messages.getString((String)"GDE_MSGT3643"), Messages.getString((String)"GDE_MSGT3644"), Messages.getString((String)"GDE_MSGT3648")};
        this.usbPort = new Q200UsbPort(this, this.application);
        this.dialog = new ChargerDialog(this.application.getShell(), this);
    }

    @Override
    public DeviceDialog getDialog() {
        return this.dialog;
    }

    @Override
    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    @Override
    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    @Override
    public int getLovDataByteSize() {
        return 86;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVoltage = Integer.MIN_VALUE;
        int minVoltage = Integer.MAX_VALUE;
        points[0] = DataParser.parse2Short((byte)dataBuffer[10], (byte)dataBuffer[9]);
        points[1] = DataParser.parse2Short((byte)dataBuffer[12], (byte)dataBuffer[11]);
        points[2] = DataParser.parse2Short((byte)dataBuffer[6], (byte)dataBuffer[5]) * 1000;
        points[3] = Double.valueOf((double)points[0] / 1000.0 * (double)points[1]).intValue();
        switch (dataBuffer[1]) {
            case 0: {
                switch (dataBuffer[3]) {
                    case 1: {
                        this.energy[0] = this.energy[0] + (double)points[0] / 1000.0 * (double)points[1] / 3600.0;
                        points[4] = Double.valueOf(this.energy[0]).intValue();
                        break;
                    }
                    case 2: {
                        this.energy[1] = this.energy[1] + (double)points[0] / 1000.0 * (double)points[1] / 3600.0;
                        points[4] = Double.valueOf(this.energy[1]).intValue();
                        break;
                    }
                    case 4: {
                        this.energy[2] = this.energy[2] + (double)points[0] / 1000.0 * (double)points[1] / 3600.0;
                        points[4] = Double.valueOf(this.energy[2]).intValue();
                        break;
                    }
                    case 8: {
                        this.energy[3] = this.energy[3] + (double)points[0] / 1000.0 * (double)points[1] / 3600.0;
                        points[4] = Double.valueOf(this.energy[3]).intValue();
                        break;
                    }
                }
                if (!log.isLoggable(java.util.logging.Level.FINE)) break;
                log.log(java.util.logging.Level.FINE, "add up Energy");
                break;
            }
            case 1: {
                switch (dataBuffer[3]) {
                    case 1: {
                        this.energy[0] = 0.0;
                        points[4] = 0;
                        break;
                    }
                    case 2: {
                        this.energy[1] = 0.0;
                        points[4] = 0;
                        break;
                    }
                    case 4: {
                        this.energy[2] = 0.0;
                        points[4] = 0;
                        break;
                    }
                    case 8: {
                        this.energy[3] = 0.0;
                        points[4] = 0;
                        break;
                    }
                }
                points[4] = 0;
                if (!log.isLoggable(java.util.logging.Level.FINE)) break;
                log.log(java.util.logging.Level.FINE, "reset Energy");
                break;
            }
            default: {
                points[4] = points[4];
                if (!log.isLoggable(java.util.logging.Level.FINE)) break;
                log.log(java.util.logging.Level.FINE, "untouche Energy");
            }
        }
        points[5] = dataBuffer[13] * 1000;
        points[6] = dataBuffer[14] * 1000;
        points[7] = DataParser.parse2Short((byte)dataBuffer[16], (byte)dataBuffer[15]) * 100;
        if (dataBuffer[0] <= 3) {
            int j = 0;
            int i = 9;
            while (i < points.length) {
                if (dataBuffer[j + 17] != 0) {
                    points[i] = DataParser.parse2Short((byte)dataBuffer[j + 18], (byte)dataBuffer[j + 17]);
                    maxVoltage = points[i] > maxVoltage ? points[i] : maxVoltage;
                    minVoltage = points[i] < minVoltage ? points[i] : minVoltage;
                } else {
                    points[i] = 0;
                }
                ++i;
                j += 2;
            }
            points[8] = 1000 * (maxVoltage != Integer.MIN_VALUE && minVoltage != Integer.MAX_VALUE ? maxVoltage - minVoltage : 0);
        }
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            int j = 0;
            int k = 0;
            while (j < points.length) {
                points[j] = ((convertBuffer[k] & 0xFF) << 24) + ((convertBuffer[k + 1] & 0xFF) << 16) + ((convertBuffer[k + 2] & 0xFF) << 8) + ((convertBuffer[k + 3] & 0xFF) << 0);
                ++j;
                k += 4;
            }
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                dataTableRow[index + 1] = record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    @Override
    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = (value - reduction) * factor + offset;
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    @Override
    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = (value - offset) / factor + reduction;
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    @Override
    public int getCurrentSmoothIndex() {
        return 1;
    }

    public boolean isProcessing(int outletNum, byte[] channelBuffer, byte[] dataBuffer) {
        if (log.isLoggable(java.util.logging.Level.FINE)) {
            log.log(java.util.logging.Level.FINE, "isProcessing = " + (dataBuffer == null ? channelBuffer[4] == 1 : dataBuffer[4] == 1));
        }
        if (dataBuffer == null) {
            return channelBuffer[4] == 1;
        }
        return dataBuffer[4] == 1 && (channelBuffer[5] == 4 || channelBuffer[5] == 5) && !this.isContinuousRecordSet() && this.settings.isReduceChargeDischarge() && this.getProcessSubType(channelBuffer, dataBuffer) == 2 ? false : dataBuffer[4] == 1;
    }

    @Override
    public String getProcessingStatusName(byte[] dataBuffer) {
        return this.isContinuousRecordSet() ? Messages.getString((String)"GDE_MSGT3606") : this.STATUS_MODE[dataBuffer[5]];
    }

    @Override
    public String getProcessingBatteryTypeName(byte[] channelBuffer) {
        return this.BATTERY_TYPE[channelBuffer[5]];
    }

    @Override
    public int getProcessingType(byte[] channelBuffer) {
        return channelBuffer[7];
    }

    @Override
    public int getBatteryType(byte[] channelBuffer) {
        return channelBuffer[5];
    }

    @Override
    public String getProcessingTypeName(byte[] channelBuffer) {
        String processTypeName = "";
        switch (this.getBatteryType(channelBuffer)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                processTypeName = this.USAGE_MODE_LI[channelBuffer[7]];
                break;
            }
            case 4: 
            case 5: {
                processTypeName = this.USAGE_MODE_NI[channelBuffer[7]];
                break;
            }
            case 6: {
                processTypeName = this.USAGE_MODE_PB[channelBuffer[7]];
            }
        }
        return this.isContinuousRecordSet() ? Messages.getString((String)"GDE_MSGT3606") : processTypeName;
    }

    public int getCycleNumber(byte[] dataBuffer) {
        return dataBuffer[18];
    }

    public int getProcessSubType(byte[] channelBuffer, byte[] dataBuffer) {
        if (channelBuffer[5] == 4 || channelBuffer[5] == 5) {
            return dataBuffer[17];
        }
        return this.getProcessingType(channelBuffer);
    }

    public String getProcessSubTypeName(byte[] channelBuffer, byte[] dataBuffer) {
        switch (this.getBatteryType(channelBuffer)) {
            default: {
                return "";
            }
            case 4: 
            case 5: 
        }
        if (this.isContinuousRecordSet() || this.getProcessingType(channelBuffer) != 4) {
            return "";
        }
        switch (dataBuffer[17]) {
            default: {
                return Messages.getString((String)"GDE_MSGT3620");
            }
            case 2: {
                return Messages.getString((String)"GDE_MSGT3627");
            }
            case 3: 
        }
        return Messages.getString((String)"GDE_MSGT3623");
    }

    @Override
    public int[] getCellVoltageOrdinals() {
        return new int[]{0, 2};
    }

    public String getHarwareString(int channelId) {
        return this.systemInfo[channelId - 1].getHardwareVersion();
    }

    public String getFirmwareString(int channelId) {
        return this.systemInfo[channelId - 1].getFirmwareVersion();
    }

    @Override
    public void makeInActiveDisplayable(RecordSet recordSet) {
    }

    @Override
    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        boolean configChanged = this.isChangePropery();
        String[] measurementNames = this.getMeasurementNames(channelConfigNumber);
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            if (log.isLoggable(java.util.logging.Level.FINE)) {
                log.log(java.util.logging.Level.FINE, record.getName() + " = " + measurementNames[i]);
            }
            if (record.isActive() && record.isActive() != measurement.isActive()) {
                record.setActive(Boolean.valueOf(measurement.isActive()));
                record.setVisible(measurement.isActive());
                record.setDisplayable(measurement.isActive());
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, "switch " + record.getName() + " to " + measurement.isActive());
                }
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData() && measurement.isActive());
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, record.getName() + " hasReasonableData " + record.hasReasonableData());
                }
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            if (log.isLoggable(java.util.logging.Level.FINE)) {
                log.log(java.util.logging.Level.FINE, "add to displayable counter: " + record.getName());
            }
            ++displayableCounter;
        }
        if (log.isLoggable(java.util.logging.Level.FINE)) {
            log.log(java.util.logging.Level.FINE, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
        this.setChangePropery(configChanged);
    }

    @Override
    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    @Override
    public void open_closeCommPort() {
        block27: {
            if (this.usbPort != null) {
                if (!this.usbPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block27;
                        this.dataGatherThread = new Q200GathererThread(this.application, this, this.usbPort, activChannel.getNumber(), this.getDialog());
                        try {
                            if (this.dataGatherThread != null && this.usbPort.isConnected()) {
                                block18: for (int i = 0; i < this.systemInfo.length; ++i) {
                                    switch (i) {
                                        default: {
                                            this.systemInfo[i] = new SystemInfo(this.usbPort.getSystemInfo(this.dataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemInfo.CHANNEL_A.value()));
                                            this.systemSetting[i] = new SystemSetting(this.usbPort.getSystemSetting(this.dataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemSetting.CHANNEL_A.value()));
                                            continue block18;
                                        }
                                        case 1: {
                                            this.systemInfo[i] = new SystemInfo(this.usbPort.getSystemInfo(this.dataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemInfo.CHANNEL_B.value()));
                                            this.systemSetting[i] = new SystemSetting(this.usbPort.getSystemSetting(this.dataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemSetting.CHANNEL_B.value()));
                                            continue block18;
                                        }
                                        case 2: {
                                            this.systemInfo[i] = new SystemInfo(this.usbPort.getSystemInfo(this.dataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemInfo.CHANNEL_C.value()));
                                            this.systemSetting[i] = new SystemSetting(this.usbPort.getSystemSetting(this.dataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemSetting.CHANNEL_C.value()));
                                            continue block18;
                                        }
                                        case 3: {
                                            this.systemInfo[i] = new SystemInfo(this.usbPort.getSystemInfo(this.dataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemInfo.CHANNEL_D.value()));
                                            this.systemSetting[i] = new SystemSetting(this.usbPort.getSystemSetting(this.dataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemSetting.CHANNEL_D.value()));
                                        }
                                    }
                                }
                                WaitTimer.delay((long)100L);
                                this.dataGatherThread.start();
                            }
                        }
                        catch (Throwable e) {
                            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (UsbClaimException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0051", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            log.log(java.util.logging.Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (UsbException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0050"));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            log.log(java.util.logging.Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    if (this.dataGatherThread != null) {
                        this.dataGatherThread.stopDataGatheringThread(false, null);
                    }
                    try {
                        WaitTimer.delay((long)1000L);
                        if (this.usbPort != null && this.usbPort.isConnected()) {
                            this.usbPort.closeUsbPort(null);
                        }
                    }
                    catch (UsbException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
    }

    @Override
    public String getFileBaseDir() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected class SystemInfo {
        byte channelId;
        byte[] machineId = new byte[16];

        public SystemInfo(byte[] buffer) {
            this.channelId = buffer[4];
            for (int i = 0; i < 15; ++i) {
                this.machineId[i] = buffer[i + 5];
            }
        }

        public byte getChannelId() {
            return this.channelId;
        }

        public String getFirmwareVersion() {
            return String.format("Firmware: %d.%02d", this.machineId[11], this.machineId[12]);
        }

        public int getFirmwareVersionAsInt() {
            return Integer.valueOf(String.format("%d%02d", this.machineId[11], this.machineId[12]));
        }

        public String getHardwareVersion() {
            return String.format("Hardware: %d.%d", this.machineId[13] / 10, this.machineId[13] % 10);
        }

        public int getHardwareVersionAsInt() {
            return this.machineId[13];
        }
    }

    protected class SystemSetting {
        byte channelId;
        byte changeToDischargeTime;
        byte isTimeLimiting;
        byte[] timeLimit = new byte[2];
        byte isCapacityLimiting;
        byte[] capacityLimit = new byte[2];
        byte isKeySound;
        byte isSystemSound;
        byte[] minInputVoltage = new byte[2];
        byte isBalacerConnected;
        byte isMaxTemperature;
        byte maxTempearture;
        byte[] totalVoltage = new byte[2];
        byte[] cellVoltage1 = new byte[2];
        byte[] cellVoltage2 = new byte[2];
        byte[] cellVoltage3 = new byte[2];
        byte[] cellVoltage4 = new byte[2];
        byte[] cellVoltage5 = new byte[2];
        byte[] cellVoltage6 = new byte[2];

        public SystemSetting(byte[] buffer) {
            this.channelId = buffer[3];
            this.changeToDischargeTime = buffer[4];
            this.isTimeLimiting = buffer[5];
            System.arraycopy(buffer, 6, this.timeLimit, 0, 2);
            this.isCapacityLimiting = buffer[8];
            System.arraycopy(buffer, 9, this.capacityLimit, 0, 2);
            this.isKeySound = buffer[11];
            this.isSystemSound = buffer[12];
            System.arraycopy(buffer, 13, this.minInputVoltage, 0, 2);
            this.isBalacerConnected = buffer[15];
            this.isMaxTemperature = buffer[16];
            this.maxTempearture = buffer[17];
            System.arraycopy(buffer, 18, this.totalVoltage, 0, 2);
            System.arraycopy(buffer, 20, this.cellVoltage1, 0, 2);
            System.arraycopy(buffer, 22, this.cellVoltage2, 0, 2);
            System.arraycopy(buffer, 24, this.cellVoltage3, 0, 2);
            System.arraycopy(buffer, 26, this.cellVoltage4, 0, 2);
            System.arraycopy(buffer, 28, this.cellVoltage5, 0, 2);
            System.arraycopy(buffer, 30, this.cellVoltage6, 0, 2);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("channel=0x%02x C>D_Time %d TimeLimit = %b %d CapacityLimit %b %d KeyBuzzer %b SysBuzzer %b TemperatureLimit %b %d Balancer %b", this.getChannelId(), this.getChangeToDischargeTime(), this.isTimeLimiting(), this.getTimeLimit(), this.isCapacityLimiting(), this.getCapacityLimit(), this.isKeySound(), this.isSystemSound(), this.isMaxTemperature(), this.getMaxTempearture(), this.isBalancerConnected()));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("Voltage %d CellVoltage1 %d CellVoltage2 %d CellVoltage3 %d CellVoltage4 %d CellVoltage5 %d CellVoltage6 %d", this.getTotalVoltage(), this.getCellVoltage1(), this.getCellVoltage2(), this.getCellVoltage3(), this.getCellVoltage4(), this.getCellVoltage5(), this.getCellVoltage6()));
            }
        }

        public byte getChannelId() {
            return this.channelId;
        }

        public int getChangeToDischargeTime() {
            return this.changeToDischargeTime;
        }

        public boolean isTimeLimiting() {
            return this.isTimeLimiting == 1;
        }

        public short getTimeLimit() {
            return DataParser.parse2Short((byte)this.timeLimit[1], (byte)this.timeLimit[0]);
        }

        public boolean isCapacityLimiting() {
            return this.isCapacityLimiting == 1;
        }

        public short getCapacityLimit() {
            return DataParser.parse2Short((byte)this.capacityLimit[1], (byte)this.capacityLimit[0]);
        }

        public boolean isKeySound() {
            return this.isKeySound == 1;
        }

        public boolean isSystemSound() {
            return this.isSystemSound == 1;
        }

        public short getMinInputVoltage() {
            return DataParser.parse2Short((byte)this.minInputVoltage[1], (byte)this.minInputVoltage[0]);
        }

        public boolean isMaxTemperature() {
            return this.isMaxTemperature == 1;
        }

        public byte getMaxTempearture() {
            return this.maxTempearture;
        }

        public boolean isBalancerConnected() {
            return this.isBalacerConnected == 1;
        }

        public short getTotalVoltage() {
            return DataParser.parse2Short((byte)this.totalVoltage[1], (byte)this.totalVoltage[0]);
        }

        public short getCellVoltage1() {
            return DataParser.parse2Short((byte)this.cellVoltage1[1], (byte)this.cellVoltage1[0]);
        }

        public short getCellVoltage2() {
            return DataParser.parse2Short((byte)this.cellVoltage2[1], (byte)this.cellVoltage2[0]);
        }

        public short getCellVoltage3() {
            return DataParser.parse2Short((byte)this.cellVoltage3[1], (byte)this.cellVoltage3[0]);
        }

        public short getCellVoltage4() {
            return DataParser.parse2Short((byte)this.cellVoltage4[1], (byte)this.cellVoltage4[0]);
        }

        public short getCellVoltage5() {
            return DataParser.parse2Short((byte)this.cellVoltage5[1], (byte)this.cellVoltage5[0]);
        }

        public short getCellVoltage6() {
            return DataParser.parse2Short((byte)this.cellVoltage6[1], (byte)this.cellVoltage6[0]);
        }
    }
}

