/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.primitives.Shorts;

public class PowerBoxBlock
extends DataBlock {
    private short voltageOneInHunderthOfVolts;
    private short voltageTwoInHunderthOfVolts;
    private short capacityOneInmAh;
    private short capacityTwoInmAh;
    private byte alarms;

    public PowerBoxBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("Voltage PB1");
        this.measurementNames.add("Capacity PB1");
        this.measurementNames.add("Voltage PB2");
        this.measurementNames.add("Capacity PB2");
        this.measurementNames.add("Alarms PB");
        this.measurementUnits.add("V");
        this.measurementUnits.add("mAh");
        this.measurementUnits.add("V");
        this.measurementUnits.add("mAh");
        this.measurementUnits.add("");
        this.measurementFactors.add(0.01);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(0.01);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof PowerBoxBlock) {
            PowerBoxBlock powerbox = (PowerBoxBlock)block;
            return powerbox.voltageOneInHunderthOfVolts == this.voltageOneInHunderthOfVolts && powerbox.voltageTwoInHunderthOfVolts == this.voltageTwoInHunderthOfVolts && powerbox.capacityOneInmAh == this.capacityOneInmAh && powerbox.capacityTwoInmAh == this.capacityTwoInmAh && powerbox.getAlarms() == (short)(this.alarms & 0xFF);
        }
        return false;
    }

    public short getVoltageOneInHunderthOfVolts() {
        return this.voltageOneInHunderthOfVolts;
    }

    public short getVoltageTwoInHunderthOfVolts() {
        return this.voltageTwoInHunderthOfVolts;
    }

    public short getCapacityOneInmAh() {
        return this.capacityOneInmAh;
    }

    public short getCapacityTwoInmAh() {
        return this.capacityTwoInmAh;
    }

    public short getAlarms() {
        return (short)(this.alarms & 0xFF);
    }

    private void decode(byte[] rawData) {
        this.voltageOneInHunderthOfVolts = Shorts.fromBytes(rawData[6], rawData[7]);
        this.voltageTwoInHunderthOfVolts = Shorts.fromBytes(rawData[8], rawData[9]);
        this.capacityOneInmAh = Shorts.fromBytes(rawData[10], rawData[11]);
        this.capacityTwoInmAh = Shorts.fromBytes(rawData[12], rawData[13]);
        this.alarms = rawData[15];
        this.measurementValues.add(Integer.valueOf(this.getVoltageOneInHunderthOfVolts()));
        this.measurementValues.add(Integer.valueOf(this.getCapacityOneInmAh()));
        this.measurementValues.add(Integer.valueOf(this.getVoltageTwoInHunderthOfVolts()));
        this.measurementValues.add(Integer.valueOf(this.getCapacityTwoInmAh()));
        this.measurementValues.add(Integer.valueOf(this.getAlarms()));
    }
}

