/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.primitives.Ints;

public class EscBlock
extends DataBlock {
    private int rpmFactorThen;
    private int voltsInputInHundredthOfVolt;
    private int tempFETInTenthOfDegreeCelsius;
    private int currentMotorInHundredthAmps;
    private int tempBECInTenthOfDegreeCelsius;
    private int currentBECInTenthOfAmps;
    private int voltsBECInHundredthOfVolt;
    private int throttleInPercent;
    private int powerOutInPercent;

    public EscBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("RPM ESC");
        this.measurementNames.add("Voltage ESC");
        this.measurementNames.add("TempFET ESC");
        this.measurementNames.add("Current ESC");
        this.measurementNames.add("CurrentBEC ESC");
        this.measurementNames.add("VoltsBEC ESC");
        this.measurementNames.add("Throttle ESC");
        this.measurementNames.add("PowerOut ESC");
        this.measurementNames.add("PowerIn ESC");
        this.measurementUnits.add("1/min");
        this.measurementUnits.add("V");
        this.measurementUnits.add("\u00b0C");
        this.measurementUnits.add("A");
        this.measurementUnits.add("A");
        this.measurementUnits.add("V");
        this.measurementUnits.add("%");
        this.measurementUnits.add("%");
        this.measurementUnits.add("W");
        this.measurementFactors.add(10.0);
        this.measurementFactors.add(0.01);
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(0.01);
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(0.05);
        this.measurementFactors.add(0.5);
        this.measurementFactors.add(0.5);
        this.measurementFactors.add(0.1);
    }

    private void decode(byte[] rawData) {
        this.rpmFactorThen = Ints.fromBytes((byte)0, (byte)0, rawData[6], rawData[7]);
        this.voltsInputInHundredthOfVolt = Ints.fromBytes((byte)0, (byte)0, rawData[8], rawData[9]);
        this.tempFETInTenthOfDegreeCelsius = Ints.fromBytes((byte)0, (byte)0, rawData[10], rawData[11]);
        this.currentMotorInHundredthAmps = Ints.fromBytes((byte)0, (byte)0, rawData[12], rawData[13]);
        this.tempBECInTenthOfDegreeCelsius = Ints.fromBytes((byte)0, (byte)0, rawData[14], rawData[15]);
        this.currentBECInTenthOfAmps = rawData[16];
        this.voltsBECInHundredthOfVolt = rawData[17];
        this.throttleInPercent = rawData[18];
        this.powerOutInPercent = rawData[19];
        this.measurementValues.add(this.getRpmFactorThen());
        this.measurementValues.add(this.getVoltsInputInHundredthOfVolt());
        this.measurementValues.add(this.getTempFETInTenthOfDegreeCelsius());
        this.measurementValues.add(this.getCurrentMotorInHundredthAmps());
        this.measurementValues.add(this.getCurrentBECInTenthOfAmps());
        this.measurementValues.add(this.getVoltsBECInHundredthOfVolt());
        this.measurementValues.add(this.getThrottleInPercent());
        this.measurementValues.add(this.getPowerOutInPercent());
        this.measurementValues.add(this.getPowerInTenthsOfW());
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof EscBlock) {
            EscBlock esc = (EscBlock)block;
            return esc.rpmFactorThen == this.rpmFactorThen && esc.voltsInputInHundredthOfVolt == this.voltsInputInHundredthOfVolt && esc.tempFETInTenthOfDegreeCelsius == this.tempFETInTenthOfDegreeCelsius && esc.currentMotorInHundredthAmps == this.currentMotorInHundredthAmps && esc.tempBECInTenthOfDegreeCelsius == this.tempBECInTenthOfDegreeCelsius && esc.currentBECInTenthOfAmps == this.currentBECInTenthOfAmps && esc.voltsBECInHundredthOfVolt == this.voltsBECInHundredthOfVolt && esc.throttleInPercent == this.throttleInPercent && esc.powerOutInPercent == this.powerOutInPercent;
        }
        return false;
    }

    public int getRpmFactorThen() {
        return this.rpmFactorThen != 65535 ? this.rpmFactorThen : 0;
    }

    public int getVoltsInputInHundredthOfVolt() {
        return this.voltsInputInHundredthOfVolt != 65535 ? this.voltsInputInHundredthOfVolt : 0;
    }

    public int getTempFETInTenthOfDegreeCelsius() {
        return this.tempFETInTenthOfDegreeCelsius != 65535 ? this.tempFETInTenthOfDegreeCelsius : 0;
    }

    public int getCurrentMotorInHundredthAmps() {
        return this.currentMotorInHundredthAmps != 65535 ? this.currentMotorInHundredthAmps : 0;
    }

    public int getTempBECInTenthOfDegreeCelsius() {
        return this.tempBECInTenthOfDegreeCelsius != 65535 ? this.tempBECInTenthOfDegreeCelsius : 0;
    }

    public int getCurrentBECInTenthOfAmps() {
        return this.currentBECInTenthOfAmps != 255 ? this.currentBECInTenthOfAmps & 0xFF : 0;
    }

    public int getVoltsBECInHundredthOfVolt() {
        return this.voltsBECInHundredthOfVolt != 255 ? this.voltsBECInHundredthOfVolt & 0xFF : 0;
    }

    public int getThrottleInPercent() {
        return this.throttleInPercent != -1 ? this.throttleInPercent & 0xFF : 0;
    }

    public int getPowerOutInPercent() {
        return this.powerOutInPercent != 255 ? this.powerOutInPercent & 0xFF : 0;
    }

    public int getPowerInTenthsOfW() {
        return (int)((double)this.getCurrentMotorInHundredthAmps() / 1000.0 * (double)this.getVoltsInputInHundredthOfVolt());
    }
}

