/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.utils;

import gde.log.Logger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.logging.Level;

public class GpsCoordinate
implements Comparable<GpsCoordinate> {
    private static final String $CLASS_NAME = GpsCoordinate.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    public static double EARTH_RADIUS = 6371.000785;
    public static double GPS_ACCURACY = 0.0078;
    private double latitude;
    private double longitude;
    private DecimalFormat format = new DecimalFormat("##.#######", new DecimalFormatSymbols(Locale.US));

    public GpsCoordinate() {
    }

    public GpsCoordinate(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public GpsCoordinate(String angularCoordinate) {
        StringBuilder sb = new StringBuilder(angularCoordinate.replace('P', '+').replace('M', '-')).insert(2, '.').insert(13, '.').insert(24, '.').insert(35, '.');
        this.latitude = Math.toDegrees(Math.atan2(Double.parseDouble(sb.substring(0, 11)), Double.parseDouble(sb.substring(11, 22))));
        this.longitude = Math.toDegrees(Math.atan2(Double.parseDouble(sb.substring(22, 33)), Double.parseDouble(sb.substring(33, 44))));
    }

    public String toAngularCoordinate() {
        String angularCoordinate = String.format(Locale.US, "%+10.8f%+10.8f%+10.8f%+10.8f", Math.sin(Math.toRadians(this.latitude)), Math.cos(Math.toRadians(this.latitude)), Math.sin(Math.toRadians(this.longitude)), Math.cos(Math.toRadians(this.longitude)));
        angularCoordinate = angularCoordinate.replace(".", "").replace('+', 'P').replace('-', 'M');
        log.log(Level.FINEST, angularCoordinate, this);
        return angularCoordinate;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getFormattedLatitude() {
        return String.format(Locale.ENGLISH, "%.7f", this.latitude).trim();
    }

    public String getFormattedLongitude() {
        return String.format(Locale.ENGLISH, "%.7f", this.longitude).trim();
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%.7f, %.7f", this.latitude, this.longitude);
    }

    public String toCsvString() {
        return this.format.format(this.latitude) + "," + this.format.format(this.longitude);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GpsCoordinate)) {
            return false;
        }
        GpsCoordinate c = (GpsCoordinate)o;
        return this.getDistance(c) <= GPS_ACCURACY;
    }

    public int hashCode() {
        return 31 * this.toAngularCoordinate().hashCode();
    }

    @Override
    public int compareTo(GpsCoordinate yourCoordinate) {
        if (this.equals(yourCoordinate)) {
            return 0;
        }
        return this.toAngularCoordinate().compareTo(yourCoordinate.toAngularCoordinate());
    }

    public double getDistance(GpsCoordinate yourCoordinate) {
        double phi1 = Math.toRadians(this.latitude);
        double phi2 = Math.toRadians(yourCoordinate.getLatitude());
        double dPhi = Math.toRadians(yourCoordinate.getLatitude() - this.latitude);
        double dLambda = Math.toRadians(yourCoordinate.getLongitude() - this.longitude);
        double sqOppositeLeg = Math.sin(dPhi / 2.0) * Math.sin(dPhi / 2.0) + Math.cos(phi1) * Math.cos(phi2) * Math.sin(dLambda / 2.0) * Math.sin(dLambda / 2.0);
        double zeta = 2.0 * Math.atan2(Math.sqrt(sqOppositeLeg), Math.sqrt(1.0 - sqOppositeLeg));
        log.fine(() -> String.format("distance=%f  %s  %s", EARTH_RADIUS * zeta, this, yourCoordinate));
        return EARTH_RADIUS * zeta;
    }
}

