/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.device.IDevice;
import gde.histo.cache.ExtendedVault;
import gde.histo.datasources.DirectoryScanner;
import gde.histo.datasources.HistoSet;
import gde.histo.datasources.SourceFolders;
import gde.histo.exclusions.InclusionData;
import gde.histo.guard.Reminder;
import gde.histo.recordings.TrailDataTags;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordFormatter;
import gde.histo.recordings.TrailRecordSet;
import gde.histo.recordings.TrailRecordSetFormatter;
import gde.histo.ui.AbstractChartComposite;
import gde.histo.ui.ExclusionActivity;
import gde.histo.ui.Measure;
import gde.histo.ui.SummaryMeasuring;
import gde.histo.ui.data.SummarySpots;
import gde.histo.ui.menu.AbstractTabAreaContextMenu;
import gde.histo.ui.menu.ChartTabAreaContextMenu;
import gde.histo.utils.HistoCurveUtils;
import gde.log.Level;
import gde.log.Logger;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.MathUtils;
import gde.utils.StringHelper;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public final class SummaryComposite
extends AbstractChartComposite {
    private static final String $CLASS_NAME = SummaryComposite.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    static final int UNK_GAP = 2;
    private final AbstractChartComposite.AbstractChartData chartData = new AbstractChartComposite.AbstractChartData();
    private VolatileComment volatileComment;

    SummaryComposite(SashForm useParent, CTabItem parentWindow) {
        super((Composite)useParent, parentWindow, 0);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.curveAreaBackground = this.settings.getGraphicsCurveAreaBackground();
        this.surroundingBackground = this.settings.getGraphicsSurroundingBackground();
        this.curveAreaBorderColor = this.settings.getGraphicsCurvesBorderColor();
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new ChartTabAreaContextMenu();
        this.init();
        this.enableGraphicsScale(false);
    }

    private void init() {
        this.setLayout(null);
        this.setDragDetect(false);
        this.setBackground(this.surroundingBackground);
        this.contextMenu.createMenu(this.popupmenu);
        this.addListener(11, new Listener(){

            public void handleEvent(Event evt) {
                log.finer(() -> "GraphicsComposite.controlResized() = " + String.valueOf(evt));
                Rectangle clientRect = SummaryComposite.this.getClientArea();
                Point size = new Point(clientRect.width, clientRect.height);
                log.finer(() -> String.valueOf(SummaryComposite.this.oldSize) + " - " + String.valueOf(size));
                if (!SummaryComposite.this.oldSize.equals((Object)size)) {
                    log.fine(() -> "size changed, update " + String.valueOf(SummaryComposite.this.oldSize) + " - " + String.valueOf(size));
                    SummaryComposite.this.oldSize = size;
                    SummaryComposite.this.setComponentBounds();
                    SummaryComposite.this.doRedrawGraphics();
                }
            }
        });
        this.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                log.finer(() -> "GraphicsComposite.helpRequested " + String.valueOf(evt));
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_94.html");
            }
        });
        this.graphicsHeader = new Text((Composite)this, 0x100000C);
        this.graphicsHeader.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 3, 1));
        this.graphicsHeader.setBackground(this.surroundingBackground);
        this.graphicsHeader.setMenu(this.popupmenu);
        this.graphicsHeader.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                int levelMax;
                String levelsText;
                Object toolTipText;
                log.finer(() -> "graphicsHeader.paintControl, event=" + String.valueOf(evt));
                SourceFolders sourceFolders = DataExplorer.getInstance().getPresentHistoExplorer().getHistoSet().getSourceFolders();
                String headerText = sourceFolders != null ? sourceFolders.getTruncatedFileNamesCsv().replace(",", " | ") : "";
                Object object = toolTipText = sourceFolders != null ? sourceFolders.getDecoratedPathsCsv().replace(',', '\n') : "";
                if (!headerText.equals(SummaryComposite.this.graphicsHeaderText)) {
                    SummaryComposite.this.graphicsHeaderText = headerText;
                    SummaryComposite.this.graphicsHeader.setText(headerText);
                }
                String string = levelsText = (levelMax = Settings.getInstance().getSubDirectoryLevelMax()) > 0 ? "\n+ " + levelMax + " " + Messages.getString("GDE_MSGT0870") : "";
                if (!((String)toolTipText).isEmpty()) {
                    toolTipText = (String)toolTipText + levelsText;
                }
                SummaryComposite.this.graphicsHeader.setToolTipText((String)toolTipText);
            }
        });
        this.graphicCanvas = new Canvas((Composite)this, 0);
        this.graphicCanvas.setBackground(this.surroundingBackground);
        this.graphicCanvas.setMenu(this.popupmenu);
        this.graphicCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent evt) {
                log.finest(() -> "graphicCanvas.mouseMove = " + String.valueOf(evt));
                SummaryComposite.this.mouseMoveAction(evt);
            }
        });
        this.graphicCanvas.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent evt) {
                log.finest(() -> "graphicCanvas.mouseExit, event=" + String.valueOf(evt));
                SummaryComposite.this.graphicCanvas.setCursor(DataExplorer.getInstance().getCursor());
            }
        });
        this.graphicCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent evt) {
                log.finest(() -> "graphicCanvas.mouseDown, event=" + String.valueOf(evt));
                if (evt.button == 1 || evt.button == 3) {
                    SummaryComposite.this.mouseDownAction(evt);
                }
            }

            public void mouseUp(MouseEvent evt) {
                log.finest(() -> "graphicCanvas.mouseUp, event=" + String.valueOf(evt));
                if (evt.button == 1 || evt.button == 3) {
                    SummaryComposite.this.mouseUpAction(evt);
                }
            }
        });
        this.graphicCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                log.finer(() -> "graphicCanvas.paintControl, event=" + String.valueOf(evt));
                try {
                    SummaryComposite.this.drawAreaPaintControl(evt);
                }
                catch (Exception e) {
                    log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                }
            }
        });
        this.recordSetComment = new Text((Composite)this, 16394);
        this.recordSetComment.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.recordSetComment.setBackground(this.surroundingBackground);
        this.recordSetComment.setMenu(this.popupmenu);
        this.recordSetComment.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                log.finer(() -> "recordSetComment.paintControl, event=" + String.valueOf(evt));
            }
        });
    }

    private void drawAreaPaintControl(PaintEvent evt) {
        log.finest(() -> "drawAreaPaintControl.paintControl, event=" + String.valueOf(evt));
        long nanoTime = System.nanoTime();
        this.abstractDrawAreaPaintControl(evt.gc);
        log.time(() -> "drawTime=" + StringHelper.getFormatedTime("ss:SSS", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - nanoTime)));
    }

    void mouseMoveAction(MouseEvent evt) {
        if (Channels.getInstance().getActiveChannel() == null) {
            return;
        }
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        if (trailRecordSet != null && trailRecordSet.getTimeStepSize() > 0 && this.canvasImage != null) {
            Point point = this.checkCurveBounds(evt.x, evt.y);
            this.graphicCanvas.setCursor(this.application.getCursor());
            List<Integer> snappedIndices = this.getSnappedIndices(point);
            TrailRecord record = this.getDisplayRecord(point);
            if (point.x > 0 && point.x < this.curveAreaBounds.width && !snappedIndices.isEmpty()) {
                this.graphicCanvas.setCursor(SWTResourceManager.getCursor(2));
                Object text = TrailRecordSetFormatter.getFileNameLines(snappedIndices);
                if (snappedIndices.size() == 1) {
                    TrailRecordFormatter formatter = new TrailRecordFormatter(record);
                    ExtendedVault vault = trailRecordSet.getVault(snappedIndices.get(0));
                    String outliers = record.getVaultOutliers(vault).mapToObj(formatter::getScaleValue).collect(Collectors.joining(" : "));
                    String scraps = record.getVaultScraps(vault).mapToObj(formatter::getScaleValue).collect(Collectors.joining(" : "));
                    if (!outliers.isEmpty()) {
                        text = (String)text + "\n o " + outliers;
                    }
                    if (!scraps.isEmpty()) {
                        text = (String)text + "\n s " + scraps;
                    }
                }
                if (this.graphicCanvas.getToolTipText() == null || !((String)text).equals(this.graphicCanvas.getToolTipText())) {
                    log.log(Level.FINEST, "", text);
                    this.graphicCanvas.setToolTipText((String)text);
                }
            } else if (point.x == 0 && record != null && this.getChartData(record).getMinMaxWarning()[0] != null) {
                String hintForClick = "\n" + Messages.getString("GDE_MSGT0914");
                this.graphicCanvas.setToolTipText(new TrailRecordFormatter(record).defineFormattedMinWarning(this.getChartData(record)) + hintForClick);
            } else if (point.x == this.curveAreaBounds.width && record != null && this.getChartData(record).getMinMaxWarning()[1] != null) {
                String hintForClick = "\n" + Messages.getString("GDE_MSGT0914");
                this.graphicCanvas.setToolTipText(new TrailRecordFormatter(record).defineFormattedMaxWarning(this.getChartData(record)) + hintForClick);
            } else {
                this.graphicCanvas.setToolTipText(null);
            }
            if ((evt.stateMask & 0x80000) != 524288) {
                this.windowActor.processMouseUpMove(point);
            }
        }
    }

    @Nullable
    private TrailRecord getDisplayRecord(Point point) {
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        if (trailRecordSet == null) {
            return null;
        }
        if (trailRecordSet.getDisplayRecords() == null || trailRecordSet.getDisplayRecords().isEmpty()) {
            return null;
        }
        int stripHeight = this.fixedCanvasHeight / trailRecordSet.getDisplayRecords().size();
        int xPos = point.x;
        int yPos = point.y;
        log.finest(() -> String.format("x=%d y=%d  stripXPos=%d  stripYPos=%d  stripHeight=%d", point.x, point.y, xPos, yPos, stripHeight));
        if (yPos < 0 || yPos >= stripHeight * trailRecordSet.getDisplayRecords().size() - 1) {
            return null;
        }
        int displayOrdinal = Math.min(yPos / stripHeight, trailRecordSet.getDisplayRecords().size() - 1);
        if (displayOrdinal < 0) {
            return null;
        }
        TrailRecord record = trailRecordSet.getDisplayRecords().get(displayOrdinal);
        log.finest(() -> String.format("x=%d y=%d  displayOrdinal=%d  record=%s", point.x, point.y, displayOrdinal, record.getName()));
        return record;
    }

    private List<Integer> getSnappedIndices(Point point) {
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        if (trailRecordSet == null) {
            return new ArrayList<Integer>();
        }
        if (trailRecordSet.getDisplayRecords() == null || trailRecordSet.getDisplayRecords().isEmpty()) {
            return new ArrayList<Integer>();
        }
        TrailRecord record = this.getDisplayRecord(point);
        if (record == null || !record.isVisible() && this.settings.isPartialDataTable()) {
            return new ArrayList<Integer>();
        }
        int stripHeight = this.fixedCanvasHeight / trailRecordSet.getDisplayRecords().size();
        int stripYPos = (point.y - 2) % stripHeight;
        List<Integer> snappedIndexes = this.getChartData(record).getSummarySpots().getSnappedIndexes(point.x, stripYPos);
        log.log(java.util.logging.Level.FINER, "", Arrays.toString(snappedIndexes.toArray()));
        return snappedIndexes;
    }

    void mouseDownAction(MouseEvent evt) {
        if (Channels.getInstance().getActiveChannel() == null) {
            return;
        }
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        if (this.canvasImage != null && trailRecordSet != null && trailRecordSet.getTimeStepSize() > 0) {
            Point point = this.checkCurveBounds(evt.x, evt.y);
            TrailRecord record = this.getDisplayRecord(point);
            if (point.x == 0 && record != null && this.getChartData(record).getMinMaxWarning()[0] != null) {
                this.changeChartAsPerWarning(record, 0);
            } else if (point.x == this.curveAreaBounds.width && record != null && this.getChartData(record).getMinMaxWarning()[1] != null) {
                this.changeChartAsPerWarning(record, 1);
            }
            if (evt.button == 1) {
                this.windowActor.processMouseDownAction(point);
            } else if (evt.button == 3) {
                this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.IS_CURSOR_IN_CANVAS.name(), (Object)"true");
                Path activeFolder = DirectoryScanner.getActiveFolder4Ui();
                this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.EXCLUDED_LIST.name(), (Object)Arrays.stream(ExclusionActivity.getExcludedTrusses()).collect(Collectors.joining(",")));
                InclusionData inclusionData = new InclusionData(activeFolder, Analyzer.getInstance().getDataAccess());
                String[] includedRecordNames = inclusionData.getIncludedRecordNames();
                ChartTabAreaContextMenu.SummaryWarning summaryWarning = new ChartTabAreaContextMenu.SummaryWarning(activeFolder, record != null ? record.getName() : "", includedRecordNames);
                this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.SUMMARY_WARNING.name(), (Object)summaryWarning);
                List<Integer> snappedIndices = this.getSnappedIndices(point);
                if (this.isBeyondLeftBounds(evt.x) && record != null && this.getChartData(record).getMinMaxWarning()[0] != null) {
                    Reminder outlier = this.getChartData(record).getMinMaxWarning()[0];
                    ExtendedVault vault = record.getParent().getVault(outlier.getIndices().get(0));
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_LINK_PATH.name(), (Object)vault.getLoadLinkPath());
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_FILE_PATH.name(), (Object)vault.getLoadFilePath());
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.RECORDSET_BASE_NAME.name(), (Object)vault.getLogRecordsetBaseName());
                } else if (this.isBeyondRightBounds(evt.x) && record != null && this.getChartData(record).getMinMaxWarning()[1] != null) {
                    Reminder outlier = this.getChartData(record).getMinMaxWarning()[1];
                    ExtendedVault vault = record.getParent().getVault(outlier.getIndices().get(0));
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_LINK_PATH.name(), (Object)vault.getLoadLinkPath());
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_FILE_PATH.name(), (Object)vault.getLoadFilePath());
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.RECORDSET_BASE_NAME.name(), (Object)vault.getLogRecordsetBaseName());
                } else if (snappedIndices.size() == 1) {
                    Integer index = snappedIndices.get(0);
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_LINK_PATH.name(), (Object)trailRecordSet.getDataTagText(index, TrailDataTags.DataTag.LINK_PATH));
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_FILE_PATH.name(), (Object)trailRecordSet.getDataTagText(index, TrailDataTags.DataTag.FILE_PATH));
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.RECORDSET_BASE_NAME.name(), (Object)trailRecordSet.getDataTagText(index, TrailDataTags.DataTag.RECORDSET_BASE_NAME));
                } else {
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_LINK_PATH.name(), (Object)"");
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_FILE_PATH.name(), (Object)"");
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.RECORDSET_BASE_NAME.name(), (Object)"");
                }
            }
        }
    }

    private void changeChartAsPerWarning(TrailRecord record, int actionType) {
        TrailRecordFormatter recordFormatter = new TrailRecordFormatter(record);
        this.volatileComment = new VolatileComment(recordFormatter.defineMinMaxWarningText(this.getChartData(record)), Messages.getString("GDE_MSGT0909"), 3);
        this.windowActor.setTrailVisible(record, this.getChartData(record).getMinMaxWarning()[actionType].getSelectIndex());
        this.windowActor.updateHistoTabs(false, false, false);
    }

    void mouseUpAction(MouseEvent evt) {
        if (Channels.getInstance().getActiveChannel() == null) {
            return;
        }
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        if (this.canvasImage != null && trailRecordSet != null && trailRecordSet.getTimeStepSize() > 0) {
            Point point = this.checkCurveBounds(evt.x, evt.y);
            if (evt.button == 1) {
                this.windowActor.processMouseUpAction(point);
            }
        }
    }

    @Override
    protected void setFixedGraphicCanvas(Rectangle realBounds) {
        if (this.retrieveTrailRecordSet().isSmartStatistics()) {
            int heightWithScale = realBounds.height + this.getXScaleHeight() + 5;
            this.setFixedGraphicCanvas(realBounds.y - 5, heightWithScale);
        } else {
            this.setFixedGraphicCanvas(realBounds.y - 5, 11);
        }
    }

    @Override
    protected void drawCurveArea(int dataScaleWidth) {
        this.canvasImageGC.setBackground(this.curveAreaBackground);
        this.canvasImageGC.fillRectangle(this.curveAreaBounds);
        this.canvasImageGC.setBackground(this.surroundingBackground);
        HistoCurveUtils.drawCurveAreaBorders(this.canvasImageGC, this.curveAreaBounds, this.curveAreaBorderColor);
        long startTime = new Date().getTime();
        if (this.fixedCanvasHeight > 11) {
            this.drawTrailRecordSet(dataScaleWidth);
        }
        log.fine(() -> "draw records time = " + StringHelper.getFormatedDuration("ss.SSS", new Date().getTime() - startTime));
    }

    @Override
    protected void defineLayoutParams() {
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        this.chartData.clear();
        for (TrailRecord record : trailRecordSet.getValues()) {
            this.chartData.put(record.getName(), new SummaryLayout(record));
        }
        trailRecordSet.updateSyncSummaryScale(this.chartData);
        if (trailRecordSet.getDisplayRecords() == null || trailRecordSet.getDisplayRecords().isEmpty()) {
            return;
        }
        SummarySpots.Density density = SummarySpots.Density.toDensity(this.curveAreaBounds.width, trailRecordSet.getTimeStepSize() == 0 ? 1 : trailRecordSet.getTimeStepSize());
        int stripHeight = this.fixedCanvasHeight / trailRecordSet.getDisplayRecords().size();
        log.fine(() -> "curve area bounds = " + this.curveAreaBounds.toString());
        for (int i = 0; i < trailRecordSet.getDisplayRecords().size(); ++i) {
            TrailRecord record = trailRecordSet.getDisplayRecords().get(i);
            if (record.isVisible()) {
                log.fine(() -> String.format("record=%s  isVisible=%b isDisplayable=%b isScaleVisible=%b", record.getName(), record.isVisible(), record.isDisplayable(), record.isScaleSynced(), record.isScaleVisible()));
            }
            Rectangle drawStripBounds = new Rectangle(this.curveAreaBounds.x, this.curveAreaBounds.y + stripHeight * i + 2, this.curveAreaBounds.width, stripHeight);
            log.finer(() -> record.getName() + "  x0=" + this.curveAreaBounds.x + " y0=" + drawStripBounds.y + " width=" + this.curveAreaBounds.width + " height=" + stripHeight);
            SummarySpots summarySpots = this.getChartData(record).getSummarySpots();
            summarySpots.initialize(drawStripBounds, density);
        }
    }

    private void drawTrailRecordSet(int dataScaleWidth) {
        log.finer(() -> "trail record set summary");
        boolean isDrawScaleInRecordColor = this.settings.isDrawScaleInRecordColor();
        boolean isDrawNameInRecordColor = this.settings.isDrawNameInRecordColor();
        boolean isDrawNumbersInRecordColor = this.settings.isDrawNumbersInRecordColor();
        boolean isPartialDataTable = this.settings.isPartialDataTable();
        boolean isSummaryBoxVisible = this.settings.isSummaryBoxVisible();
        boolean isSummarySpreadVisible = this.settings.isSummarySpreadVisible();
        boolean isSummarySpotsVisible = this.settings.isSummarySpotsVisible();
        boolean isCurveSelector = this.windowActor.isCurveSelectorEnabled();
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        if (trailRecordSet == null) {
            return;
        }
        InclusionData inclusionData = new InclusionData(DirectoryScanner.getActiveFolder4Ui(), Analyzer.getInstance().getDataAccess());
        List<String> exclusiveNames = Arrays.asList(inclusionData.getIncludedRecordNames());
        for (int i = 0; i < trailRecordSet.getDisplayRecords().size(); ++i) {
            boolean isDefaultOrExclusiveWarning;
            TrailRecord record = trailRecordSet.getDisplayRecords().get(i);
            SummaryLayout summary = this.getChartData(record);
            SummarySpots summarySpots = summary.getSummarySpots();
            HistoCurveUtils.drawChannelItemScale(summary, this.canvasImageGC, dataScaleWidth, isDrawScaleInRecordColor, isDrawNumbersInRecordColor);
            if (exclusiveNames.contains(record.getName())) {
                HistoCurveUtils.drawChannelItemWarnMarker(summary, this.canvasImageGC, dataScaleWidth, isDrawNumbersInRecordColor);
            }
            if (record.size() == 0) continue;
            if (record.isVisible() || !isPartialDataTable) {
                if (isSummarySpreadVisible) {
                    HistoCurveUtils.drawChannelItemSpread(summary.getSummarySpots(), this.canvasImageGC);
                }
                if (!isCurveSelector && record.isVisible()) {
                    HistoCurveUtils.drawChannelItemText(summary, this.canvasImageGC, isDrawNameInRecordColor);
                }
                if (isSummaryBoxVisible) {
                    HistoCurveUtils.drawChannelItemBoxplot(summary, this.canvasImageGC, dataScaleWidth, isDrawNumbersInRecordColor, this.isSpaceBelow(i));
                }
                if (isSummarySpotsVisible) {
                    summarySpots.drawMarkers(this.canvasImageGC);
                }
                summarySpots.drawRecentMarkers(this.canvasImageGC);
            }
            boolean bl = isDefaultOrExclusiveWarning = exclusiveNames.isEmpty() || exclusiveNames.contains(record.getName());
            if (isDefaultOrExclusiveWarning && !HistoSet.isGpsCoordinates(record)) {
                HistoCurveUtils.drawChannelItemWarnings(summary, this.canvasImageGC, dataScaleWidth);
            }
            this.canvasImageGC.setBackground(this.surroundingBackground);
        }
    }

    private boolean isSpaceBelow(int displayOrdinal) {
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        if (trailRecordSet == null) {
            return true;
        }
        int nextOrdinal = displayOrdinal + 1;
        if (nextOrdinal < trailRecordSet.getDisplayRecords().size()) {
            TrailRecord nextRecord = trailRecordSet.getDisplayRecords().get(nextOrdinal);
            return !nextRecord.isVisible() && this.settings.isPartialDataTable();
        }
        return true;
    }

    @Override
    protected int[] defineNumberLeftRightScales() {
        return new int[]{1, 1};
    }

    @Override
    protected void setRecordSetCommentStandard() {
        this.recordSetComment.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        if (this.retrieveTrailRecordSet().isSmartStatistics()) {
            if (this.volatileComment == null || this.volatileComment.isExpired()) {
                this.recordSetComment.setText(this.windowActor.getHistoSet().getDirectoryScanStatistics());
                this.recordSetComment.setToolTipText(Messages.getString("GDE_MSGT0896"));
            } else {
                this.recordSetComment.setText(this.volatileComment.getTextLines());
                this.recordSetComment.setToolTipText(this.volatileComment.getToolTip());
                if (this.volatileComment.isExpired()) {
                    this.volatileComment = null;
                }
            }
        } else {
            this.recordSetComment.setText("supported for smart statistics only");
            this.recordSetComment.setToolTipText("supported for smart statistics only");
        }
    }

    @Override
    public void setMeasuringActive(Measure measure) {
        this.measuring = new SummaryMeasuring(this, measure);
        if (this.canvasBounds == null) {
            return;
        }
        this.doRedrawGraphics();
        if (this.canvasBounds.height == 0) {
            return;
        }
    }

    public SummaryLayout getChartData(TrailRecord trailRecord) {
        return (SummaryLayout)this.chartData.get(trailRecord.getName());
    }

    public static final class SummaryLayout
    extends AbstractChartComposite.AbstractChartLayout {
        private final Logger log = Logger.getLogger(SummaryLayout.class.getName());
        private final TrailRecord trailRecord;
        private final SummarySpots summarySpots;
        Double syncMax = null;
        Double syncMin = null;
        private Reminder[] warningMinMaxValues = null;
        private double[] scaleMinMaxValues = null;
        private DecimalFormat decimalFormat = null;

        public SummaryLayout(TrailRecord trailRecord) {
            this.trailRecord = trailRecord;
            this.summarySpots = new SummarySpots(this);
        }

        public void clear() {
            this.warningMinMaxValues = null;
            this.scaleMinMaxValues = null;
            this.decimalFormat = null;
            this.resetSyncMinMax();
        }

        public void setSyncMinMax(int recencyLimit) {
            double[] lowerUpper = this.trailRecord.defineExtrema();
            double[] recentMinMax = this.trailRecord.defineRecentMinMax(recencyLimit);
            if (lowerUpper.length == 0) {
                this.resetSyncMinMax();
            } else {
                this.setSyncMinMax(Math.min(lowerUpper[0], recentMinMax[0]), Math.max(lowerUpper[1], recentMinMax[1]));
            }
        }

        public DecimalFormat getDecimalFormat() {
            if (this.decimalFormat == null) {
                this.decimalFormat = this.defineDecimalFormat();
            }
            return this.decimalFormat;
        }

        private DecimalFormat defineDecimalFormat() {
            return TrailRecordFormatter.getDecimalFormat(this.getScaleMinMax());
        }

        public double[] getScaleMinMax() {
            if (this.scaleMinMaxValues == null) {
                this.scaleMinMaxValues = this.defineScaleMinMax();
            }
            return this.scaleMinMaxValues;
        }

        private double[] defineScaleMinMax() {
            this.log.finer(() -> "'" + this.trailRecord.getName() + "'  syncSummaryMin=" + this.getSyncMin() + " syncSummaryMax=" + this.getSyncMax());
            double minValue = this.getSyncMin();
            double maxValue = this.getSyncMax();
            double deltaValueDisplay = maxValue - minValue;
            if (Math.abs(deltaValueDisplay) < 1.0E-4) {
                maxValue += maxValue / 20.0;
                minValue -= minValue / 20.0;
            }
            double[] tmpMinMax = new double[]{MathUtils.floorStepwise(minValue, maxValue - minValue), MathUtils.ceilStepwise(maxValue, maxValue - minValue)};
            this.log.finer(() -> "'" + this.trailRecord.getName() + "'  tmpMin=" + tmpMinMax[0] + " tmpMax=" + tmpMinMax[1]);
            return tmpMinMax;
        }

        public Reminder[] getMinMaxWarning() {
            if (this.warningMinMaxValues == null) {
                this.warningMinMaxValues = this.trailRecord.defineMinMaxWarning(Settings.getInstance().getReminderCount());
            }
            return this.warningMinMaxValues;
        }

        public boolean hasReasonableMinMax() {
            return this.syncMin == null && this.syncMax == null || !HistoSet.fuzzyEquals(this.syncMin, this.syncMax);
        }

        public void setSyncMinMax(double newMin, double newMax) {
            this.syncMin = newMin;
            this.syncMax = newMax;
            this.log.finer(() -> this.trailRecord.getName() + " syncSummaryMin=" + newMin + " syncSummaryMax=" + newMax);
        }

        public void resetSyncMinMax() {
            this.syncMax = null;
            this.syncMin = null;
        }

        public boolean isSyncMinMaxDefined() {
            return this.syncMin != null && this.syncMax != null;
        }

        public double getSyncMax() {
            return this.syncMax != null ? this.syncMax : 0.0;
        }

        public double getSyncMin() {
            return this.syncMin != null ? this.syncMin : 0.0;
        }

        public SummarySpots getSummarySpots() {
            return this.summarySpots;
        }

        public TrailRecord getTrailRecord() {
            return this.trailRecord;
        }

        public String toString() {
            return "SummaryLayout [trailRecordSize=" + this.trailRecord.size() + ", syncMax=" + this.syncMax + ", syncMin=" + this.syncMin + ", warningMinMaxValues=" + Arrays.toString(this.warningMinMaxValues) + "]";
        }
    }

    private static final class VolatileComment {
        private final IDevice device = Analyzer.getInstance().getActiveDevice();
        private final Channel channel = Analyzer.getInstance().getActiveChannel();
        private final String objectKey = Settings.getInstance().getActiveObjectKey();
        private final String textLines;
        private final String toolTip;
        private int remainingAccessCounter;

        private VolatileComment(String textLines, String toolTip, int accessCounter) {
            this.textLines = textLines;
            this.toolTip = toolTip;
            this.remainingAccessCounter = accessCounter;
        }

        private String getTextLines() {
            if (--this.remainingAccessCounter < 0) {
                throw new UnsupportedOperationException();
            }
            return this.remainingAccessCounter >= 0 ? this.textLines : "";
        }

        private String getToolTip() {
            return this.remainingAccessCounter > 0 ? this.toolTip : "";
        }

        private boolean isExpired() {
            if (this.remainingAccessCounter > 0) {
                boolean isOtherChart = !this.device.equals(Analyzer.getInstance().getActiveDevice()) || !this.channel.equals(Analyzer.getInstance().getActiveChannel()) || !this.objectKey.equals(Settings.getInstance().getActiveObjectKey());
                return isOtherChart;
            }
            return true;
        }

        public String toString() {
            boolean isSameChart = this.device.equals(Analyzer.getInstance().getActiveDevice()) && this.channel.equals(Analyzer.getInstance().getActiveChannel()) && this.objectKey.equals(Settings.getInstance().getActiveObjectKey());
            return "VolatileComment [textLines=" + this.textLines + ", toolTip=" + this.toolTip + ", remainingAccessCounter=" + this.remainingAccessCounter + ", isSameChart=" + isSameChart + "]";
        }
    }
}

