/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.settlements;

import gde.Analyzer;
import gde.data.Record;
import gde.device.AmountTypes;
import gde.device.IDevice;
import gde.device.TransitionAmountType;
import gde.histo.settlements.SettlementRecord;
import gde.histo.transitions.Transition;
import gde.log.Logger;
import java.util.logging.Level;

public final class AmountEvaluator {
    private static final String $CLASS_NAME = AmountEvaluator.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final SettlementRecord histoSettlement;
    private final Analyzer analyzer;

    public AmountEvaluator(SettlementRecord newHistoSettlement, Analyzer analyzer) {
        this.histoSettlement = newHistoSettlement;
        this.analyzer = analyzer;
    }

    public void addFromTransition(Transition transition) {
        int reverseTranslatedResult;
        IDevice device = this.analyzer.getActiveDevice();
        TransitionAmountType transitionAmount = this.histoSettlement.getSettlement().getEvaluation().getTransitionAmount();
        log.log(Level.FINE, ">", transitionAmount);
        Record record = this.histoSettlement.getParent().get(this.histoSettlement.getParent().getRecordNames()[transitionAmount.getRefOrdinal()]);
        log.fine(() -> record.getName() + " values   " + String.valueOf(record.subList(transition.getReferenceStartIndex(), transition.getThresholdEndIndex() + 1)));
        if (transitionAmount.getAmountType() == AmountTypes.MIN) {
            double min = Double.MAX_VALUE;
            for (int j = transition.getThresholdStartIndex(); j < transition.getThresholdEndIndex() + 1; ++j) {
                if (record.elementAt(j) == null) continue;
                min = Math.min(min, transitionAmount.isUnsigned() ? Math.abs(device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0)) : device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0));
            }
            reverseTranslatedResult = (int)(this.histoSettlement.reverseTranslateValue(min) * 1000.0);
        } else if (transitionAmount.getAmountType() == AmountTypes.MAX) {
            double max = transitionAmount.isUnsigned() ? 0.0 : -1.7976931348623157E308;
            for (int j = transition.getThresholdStartIndex(); j < transition.getThresholdEndIndex() + 1; ++j) {
                if (record.elementAt(j) == null) continue;
                max = Math.max(max, transitionAmount.isUnsigned() ? Math.abs(device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0)) : device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0));
            }
            reverseTranslatedResult = (int)(this.histoSettlement.reverseTranslateValue(max) * 1000.0);
        } else if (transitionAmount.getAmountType() == AmountTypes.AVG) {
            double avg = 0.0;
            double value = 0.0;
            int skipCount = 0;
            for (int j = transition.getThresholdStartIndex(); j < transition.getThresholdEndIndex() + 1; ++j) {
                if (record.elementAt(j) != null) {
                    value = transitionAmount.isUnsigned() ? Math.abs(device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0)) : device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0);
                    double deltaAvg = value - avg;
                    avg += deltaAvg / (double)(j - transition.getThresholdStartIndex() - skipCount + 1);
                    continue;
                }
                ++skipCount;
            }
            reverseTranslatedResult = (int)(this.histoSettlement.reverseTranslateValue(avg) * 1000.0);
        } else if (transitionAmount.getAmountType() == AmountTypes.SIGMA) {
            double avg = 0.0;
            double q = 0.0;
            double value = 0.0;
            int skipCount = 0;
            for (int j = transition.getThresholdStartIndex(); j < transition.getThresholdEndIndex() + 1; ++j) {
                if (record.elementAt(j) != null) {
                    value = transitionAmount.isUnsigned() ? Math.abs(device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0)) : device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0);
                    double deltaAvg = value - avg;
                    q += deltaAvg * (value - (avg += deltaAvg / (double)(j - transition.getThresholdStartIndex() - skipCount + 1)));
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, String.format("value=%f  deltaAvg=%f  q=%f", value, deltaAvg, q));
                    continue;
                }
                ++skipCount;
            }
            reverseTranslatedResult = (int)(this.histoSettlement.reverseTranslateValue(Math.sqrt(q / (double)(transition.getThresholdSize() - skipCount - 1))) * 1000.0);
        } else {
            boolean reverseTranslatedResult2 = false;
            throw new UnsupportedOperationException();
        }
        this.histoSettlement.add((Integer)reverseTranslatedResult, transition);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("%s: timeStamp_ms=%d  reverseTranslatedResult=%d  amountType=%s", new Object[]{this.histoSettlement.getName(), (int)this.histoSettlement.getParent().getTime_ms(transition.getThresholdEndIndex() + 1), reverseTranslatedResult, transitionAmount.getAmountType()}));
        }
    }
}

