/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.data.Channel;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapter2;
import gde.device.graupner.HoTTAdapterD;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.HoTTbinReader2;
import gde.device.graupner.HoTTlogReader;
import gde.exception.DataInconsitsentException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;

public class HoTTbinReaderD
extends HoTTbinReader2 {
    static final Logger logger = Logger.getLogger(HoTTbinReaderD.class.getName());

    public static void migrateAddPoints(RecordSet tmpRecordSet, EnumSet<HoTTAdapter.Sensor> migrationJobs, long timeStep_ms, boolean[] isResetMinMax) throws DataInconsitsentException {
        int i;
        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.EAM)) {
            eamBinParser.migratePoints(points);
            if (!isResetMinMax[1] && points[60] != 0) {
                for (i = 60; i < 87; ++i) {
                    tmpRecordSet.get(i).setMinMax(points[i], points[i]);
                }
                isResetMinMax[1] = true;
            }
        }
        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.GAM)) {
            gamBinParser.migratePoints(points);
            if (!isResetMinMax[2] && points[38] != 0) {
                for (i = 38; i < 59; ++i) {
                    tmpRecordSet.get(i).setMinMax(points[i], points[i]);
                }
                isResetMinMax[2] = true;
            }
        }
        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.GPS)) {
            gpsBinParser.migratePoints(points);
            if (!isResetMinMax[3] && points[27] >= 3000 && points[20] != 0 && points[21] != 0) {
                for (i = 20; i < 38; ++i) {
                    tmpRecordSet.get(i).setMinMax(points[i], points[i]);
                }
                isResetMinMax[3] = true;
            }
        }
        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.VARIO)) {
            varBinParser.migratePoints(points);
        }
        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.ESC)) {
            escBinParser.migratePoints(points);
            if (!isResetMinMax[0] && points[107] != 0) {
                for (i = 123; i < 152; ++i) {
                    tmpRecordSet.get(i).setMinMax(points[i], points[i]);
                }
                isResetMinMax[0] = true;
            }
        }
        migrationJobs.clear();
        if (points[219] != 0 || points[222] != 0) {
            System.out.println();
        }
        recordSet.addPoints(points, (double)timeStep_ms);
    }

    public static synchronized void read(String filePath, HoTTAdapter.PickerParameters newPickerParameters) throws Exception {
        pickerParameters = newPickerParameters;
        HashMap<String, String> header = HoTTbinReaderD.getFileInfo(new File(filePath), newPickerParameters);
        detectedSensors = HoTTAdapter.Sensor.getSetFromDetected(header.get("DETECTED SENSOR"));
        HoTTbinReaderD.setAltitudeClimbPickeParameter(pickerParameters, detectedSensors);
        if (detectedSensors.size() <= 2) {
            isReceiverOnly = detectedSensors.size() == 1;
            HoTTbinReaderD.readSingle(new File(header.get("FilePath")), header);
        } else {
            HoTTbinReaderD.readMultiple(new File(header.get("FilePath")), header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readSingle(File file, HashMap<String, String> header) throws IOException, DataInconsitsentException {
        long startTime = System.nanoTime() / 1000000L;
        FileInputStream file_input = new FileInputStream(file);
        DataInputStream data_in = new DataInputStream(file_input);
        long fileSize = file.length();
        IDevice device = application.getActiveDevice();
        int recordSetNumber = ((Channel)channels.get((Object)1)).maxSize() + 1;
        Object recordSetName = "";
        String recordSetNameExtend = HoTTbinReaderD.getRecordSetExtend(file);
        Channel channel = null;
        int channelNumber = HoTTbinReaderD.pickerParameters.analyzer.getActiveChannel().getNumber();
        device.getMeasurementFactor(channelNumber, 12);
        boolean isSensorData = false;
        boolean isVarioDetected = false;
        boolean isGPSdetected = false;
        boolean isESCdetected = false;
        boolean[] isResetMinMax = new boolean[]{false, false, false, false, false};
        recordSet = null;
        points = new int[device.getNumberOfMeasurements(channelNumber)];
        pointsGPS = points;
        pointsVario = points;
        pointsESC = pointsVario;
        pointsEAM = pointsVario;
        pointsGAM = pointsVario;
        dataBlockSize = 64;
        buf = new byte[dataBlockSize];
        buf0 = new byte[30];
        buf1 = new byte[30];
        buf2 = new byte[30];
        buf3 = new byte[30];
        buf4 = new byte[30];
        HoTTbinReader.BufCopier bufCopier = new HoTTbinReader.BufCopier(buf, buf0, buf1, buf2, buf3, buf4);
        long[] timeSteps_ms = new long[]{0L};
        rcvBinParser = HoTTAdapter.Sensor.RECEIVER.createBinParserD(pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        chnBinParser = HoTTAdapter.Sensor.CHANNEL.createBinParserD(pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        varBinParser = (VarBinParserD)HoTTAdapter.Sensor.VARIO.createBinParserD(pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        gpsBinParser = HoTTAdapter.Sensor.GPS.createBinParserD(pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        gamBinParser = HoTTAdapter.Sensor.GAM.createBinParserD(pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        eamBinParser = HoTTAdapter.Sensor.EAM.createBinParserD(pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        escBinParser = HoTTAdapter.Sensor.ESC.createBinParserD(pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        isTextModusSignaled = false;
        boolean isSdLogFormat = Boolean.parseBoolean(header.get("SD_FORMAT"));
        long numberDatablocks = isSdLogFormat ? fileSize - 27L - 323L : fileSize / (long)dataBlockSize;
        long startTimeStamp_ms = HoTTbinReaderD.getStartTimeStamp(file.getName(), file.lastModified(), numberDatablocks);
        String date = new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp_ms);
        String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp_ms);
        MenuToolBar menuToolBar = application.getMenuToolBar();
        int progressIndicator = (int)(numberDatablocks / 30L);
        GDE.getUiNotification().setProgress(0);
        if (isSdLogFormat) {
            data_in.skip(27L);
        }
        try {
            String newFileDescription;
            channel = (Channel)channels.get((Object)channelNumber);
            String string = newFileDescription = application.isObjectoriented() ? date + " " + application.getObjectKey() : date;
            if (channel.getFileDescription().length() <= newFileDescription.length() || application.isObjectoriented() && !channel.getFileDescription().contains(application.getObjectKey())) {
                channel.setFileDescription(newFileDescription);
            }
            recordSetName = recordSetNumber + device.getRecordSetStemNameReplacement() + recordSetNameExtend;
            recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)channelNumber, (boolean)true, (boolean)true, (boolean)true);
            channel.put(recordSetName, (Object)recordSet);
            RecordSet tmpRecordSet = (RecordSet)channel.get(recordSetName);
            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
            int i = 0;
            while ((long)i < numberDatablocks) {
                data_in.read(buf);
                if (log.isLoggable(Level.FINE) && i % 10 == 0) {
                    log.log(Level.FINE, StringHelper.fourDigitsRunningNumber((int)buf.length));
                    log.log(Level.FINE, StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
                }
                if (!HoTTbinReaderD.pickerParameters.isFilterTextModus || (buf[6] & 1) == 0) {
                    if (buf[33] >= 0 && buf[33] <= 4 && buf[3] != 0 && buf[4] != 0) {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, String.format("Sensor %x Blocknummer : %d", buf[7], buf[33]));
                        }
                        ((HoTTbinReader2.RcvBinParser)rcvBinParser).trackPackageLoss(true);
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, StringHelper.byte2Hex2CharString((byte[])new byte[]{buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)buf[7], (boolean)false));
                        }
                        if (buf[33] == 0 && (buf[38] & 0x80) != 128 && DataParser.parse2Short((byte[])buf, (int)40) >= 0) {
                            rcvBinParser.parse();
                        }
                        chnBinParser.parse();
                        if (buf[33] == 0) {
                            bufCopier.copyToBuffer();
                        }
                        switch ((byte)(buf[7] & 0xFF)) {
                            case -119: 
                            case 55: {
                                if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO)) break;
                                bufCopier.copyToVarioBuffer();
                                if (!bufCopier.is4BuffersFull()) break;
                                varBinParser.parse();
                                if (!isVarioDetected) {
                                    HoTTAdapter2.updateVarioTypeDependent(buf4[9] & 0xFF, device, recordSet);
                                    isVarioDetected = true;
                                }
                                bufCopier.clearBuffers();
                                isSensorData = true;
                                break;
                            }
                            case -118: 
                            case 56: {
                                int j;
                                if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS)) break;
                                bufCopier.copyToFreeBuffer();
                                if (!bufCopier.is4BuffersFull()) break;
                                gpsBinParser.parse();
                                if (!isGPSdetected && HoTTbinReaderD.isReasonableData(buf4) && recordSet.get(33).size() > 0 && recordSet.get(33).get(recordSet.get(33).size() - 1) != 0) {
                                    HoTTAdapter2.updateGpsTypeDependent(buf4[9] & 0xFF, device, recordSet, (recordSet.get(33).size() - 1) * 5);
                                    isGPSdetected = true;
                                }
                                bufCopier.clearBuffers();
                                isSensorData = true;
                                if (isResetMinMax[3] || points[27] != 3000 || points[20] == 0 || points[21] == 0) break;
                                for (j = 20; j < 38; ++j) {
                                    tmpRecordSet.get(j).setMinMax(points[j], points[j]);
                                }
                                isResetMinMax[3] = true;
                                break;
                            }
                            case -115: 
                            case 53: {
                                int j;
                                if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM)) break;
                                bufCopier.copyToFreeBuffer();
                                if (!bufCopier.is4BuffersFull()) break;
                                gamBinParser.parse();
                                bufCopier.clearBuffers();
                                isSensorData = true;
                                if (isResetMinMax[2] || points[38] == 0) break;
                                for (j = 38; j < 60; ++j) {
                                    tmpRecordSet.get(j).setMinMax(points[j], points[j]);
                                }
                                isResetMinMax[2] = true;
                                break;
                            }
                            case -114: 
                            case 54: {
                                int j;
                                if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM)) break;
                                bufCopier.copyToFreeBuffer();
                                if (!bufCopier.is4BuffersFull()) break;
                                eamBinParser.parse();
                                bufCopier.clearBuffers();
                                isSensorData = true;
                                if (isResetMinMax[1] || points[60] == 0) break;
                                for (j = 60; j < 87; ++j) {
                                    tmpRecordSet.get(j).setMinMax(points[j], points[j]);
                                }
                                isResetMinMax[1] = true;
                                break;
                            }
                            case -116: 
                            case 57: {
                                int j;
                                if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC)) break;
                                bufCopier.copyToFreeBuffer();
                                if (!bufCopier.is4BuffersFull()) break;
                                escBinParser.parse();
                                if (!isESCdetected) {
                                    HoTTAdapterD.updateEscTypeDependent(buf4[9] & 0xFF, device, recordSet);
                                    isESCdetected = true;
                                }
                                bufCopier.clearBuffers();
                                isSensorData = true;
                                if (isResetMinMax[0] || points[107] == 0) break;
                                for (j = 123; j < 152; ++j) {
                                    tmpRecordSet.get(j).setMinMax(points[j], points[j]);
                                }
                                isResetMinMax[0] = true;
                            }
                        }
                        if (isSensorData || HoTTbinReader.isReceiverOnly) {
                            ((HoTTbinReader2.RcvBinParser)rcvBinParser).updateLossStatistics();
                        }
                        tmpRecordSet.addPoints(points, (double)timeSteps_ms[0]);
                        timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                        if (i % progressIndicator == 0) {
                            GDE.getUiNotification().setProgress((int)((long)(i * 100) / numberDatablocks));
                        }
                    } else {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "-->> Found tx=rx=0 dBm");
                        }
                        ((HoTTbinReader2.RcvBinParser)rcvBinParser).trackPackageLoss(false);
                        chnBinParser.parse();
                        tmpRecordSet.addPoints(points, (double)timeSteps_ms[0]);
                        timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                    }
                } else if (!isTextModusSignaled) {
                    isTextModusSignaled = true;
                    application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2404"));
                }
                ++i;
            }
            ((HoTTbinReader2.RcvBinParser)rcvBinParser).finalUpdateLossStatistics();
            String packageLossPercentage = tmpRecordSet.getRecordDataSize(true) > 0 ? String.format("%.1f", ((HoTTbinReader2.RcvBinParser)HoTTbinReaderD.rcvBinParser).getLostPackages().percentage) : "100";
            detectedSensors.add(HoTTAdapter.Sensor.CHANNEL);
            tmpRecordSet.setRecordSetDescription(tmpRecordSet.getRecordSetDescription() + Messages.getString((String)"GDE_MSGI2404", (Object[])new Object[]{((HoTTbinReader2.RcvBinParser)rcvBinParser).getLossTotal(), ((HoTTbinReader2.RcvBinParser)HoTTbinReaderD.rcvBinParser).getLostPackages().lossTotal, packageLossPercentage, ((HoTTbinReader2.RcvBinParser)rcvBinParser).getLostPackages().getStatistics()}) + String.format(" - Sensor: %s", HoTTlogReader.detectedSensors.toString()) + (HoTTAdapter2.isAltClimbSensor(detectedSensors) ? String.format(" - %s = %s", Messages.getString((String)"GDE_MSGT2419"), HoTTAdapter.Sensor.fromOrdinal(HoTTbinReaderD.pickerParameters.altitudeClimbSensorSelection).name()) : ""));
            log.log(Level.WARNING, "skipped number receiver data due to package loss = " + ((HoTTbinReader2.RcvBinParser)HoTTbinReaderD.rcvBinParser).getLostPackages().lossTotal);
            log.log(Level.TIME, "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
            if (GDE.isWithUi()) {
                GDE.getUiNotification().setProgress(99);
                device.updateVisibilityStatus(tmpRecordSet, true);
                channel.applyTemplate((String)recordSetName, false);
                tmpRecordSet.descriptionAppendFilename(file.getName());
                menuToolBar.updateChannelSelector();
                menuToolBar.updateRecordSetSelectCombo();
                GDE.getUiNotification().setProgress(100);
            }
        }
        finally {
            data_in.close();
            data_in = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readMultiple(File file, HashMap<String, String> header) throws IOException, DataInconsitsentException {
        long startTime = System.nanoTime() / 1000000L;
        FileInputStream file_input = new FileInputStream(file);
        DataInputStream data_in = new DataInputStream(file_input);
        long fileSize = file.length();
        IDevice device = application.getActiveDevice();
        int recordSetNumber = ((Channel)channels.get((Object)1)).maxSize() + 1;
        Object recordSetName = "";
        String recordSetNameExtend = HoTTbinReaderD.getRecordSetExtend(file);
        Channel channel = null;
        int channelNumber = HoTTbinReaderD.pickerParameters.analyzer.getActiveChannel().getNumber();
        boolean isReceiverData = false;
        recordSet = null;
        boolean isJustMigrated = false;
        boolean isVarioDetected = false;
        boolean isGPSdetected = false;
        boolean isESCdetected = false;
        boolean[] isResetMinMax = new boolean[]{false, false, false, false, false};
        points = new int[device.getNumberOfMeasurements(channelNumber)];
        pointsGAM = new int[points.length];
        pointsEAM = new int[points.length];
        pointsESC = new int[points.length];
        pointsVario = new int[points.length];
        HoTTbinReaderD.pointsVario[2] = 100000;
        pointsGPS = new int[points.length];
        dataBlockSize = 64;
        buf = new byte[dataBlockSize];
        buf0 = new byte[30];
        buf1 = new byte[30];
        buf2 = new byte[30];
        buf3 = new byte[30];
        buf4 = new byte[30];
        HoTTbinReader.BufCopier bufCopier = new HoTTbinReader.BufCopier(buf, buf0, buf1, buf2, buf3, buf4);
        long[] timeSteps_ms = new long[]{0L};
        rcvBinParser = HoTTAdapter.Sensor.RECEIVER.createBinParserD(pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        chnBinParser = HoTTAdapter.Sensor.CHANNEL.createBinParserD(pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        varBinParser = (VarBinParserD)HoTTAdapter.Sensor.VARIO.createBinParserD(pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        gpsBinParser = HoTTAdapter.Sensor.GPS.createBinParserD(pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        gamBinParser = HoTTAdapter.Sensor.GAM.createBinParserD(pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        eamBinParser = HoTTAdapter.Sensor.EAM.createBinParserD(pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        escBinParser = HoTTAdapter.Sensor.ESC.createBinParserD(pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        int actualSensor = -1;
        int lastSensor = -1;
        int logCountVario = 0;
        int logCountGPS = 0;
        int logCountGAM = 0;
        int logCountEAM = 0;
        int logCountESC = 0;
        EnumSet<HoTTAdapter.Sensor> migrationJobs = EnumSet.noneOf(HoTTAdapter.Sensor.class);
        boolean isSdLogFormat = Boolean.parseBoolean(header.get("SD_FORMAT"));
        long numberDatablocks = isSdLogFormat ? fileSize - 27L - 323L : fileSize / (long)dataBlockSize;
        long startTimeStamp_ms = HoTTbinReaderD.getStartTimeStamp(file.getName(), file.lastModified(), numberDatablocks);
        String date = new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp_ms);
        String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp_ms);
        MenuToolBar menuToolBar = application.getMenuToolBar();
        int progressIndicator = (int)(numberDatablocks / 30L);
        GDE.getUiNotification().setProgress(0);
        if (isSdLogFormat) {
            data_in.skip(27L);
        }
        try {
            String newFileDescription;
            channel = (Channel)channels.get((Object)channelNumber);
            String string = newFileDescription = application.isObjectoriented() ? date + " " + application.getObjectKey() : date;
            if (channel.getFileDescription().length() <= newFileDescription.length() || application.isObjectoriented() && !channel.getFileDescription().contains(application.getObjectKey())) {
                channel.setFileDescription(newFileDescription);
            }
            recordSetName = recordSetNumber + device.getRecordSetStemNameReplacement() + recordSetNameExtend;
            recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)channelNumber, (boolean)true, (boolean)true, (boolean)true);
            channel.put(recordSetName, (Object)recordSet);
            RecordSet tmpRecordSet = (RecordSet)channel.get(recordSetName);
            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
            int i = 0;
            while ((long)i < numberDatablocks) {
                data_in.read(buf);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
                }
                if (!HoTTbinReaderD.pickerParameters.isFilterTextModus || (buf[6] & 1) == 0) {
                    if (buf[33] >= 0 && buf[33] <= 4 && buf[3] != 0 && buf[4] != 0) {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, String.format("Sensor %x Blocknummer : %d", buf[7], buf[33]));
                        }
                        ((HoTTbinReader2.RcvBinParser)rcvBinParser).trackPackageLoss(true);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, StringHelper.byte2Hex2CharString((byte[])new byte[]{buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)buf[7], (boolean)false));
                        }
                        if (buf[33] == 0 && (buf[38] & 0x80) != 128 && DataParser.parse2Short((byte[])buf, (int)40) >= 0) {
                            rcvBinParser.parse();
                            isReceiverData = true;
                        }
                        chnBinParser.parse();
                        if (actualSensor == -1) {
                            byte by = (byte)(buf[7] & 0xFF);
                            actualSensor = by;
                            lastSensor = by;
                        } else {
                            actualSensor = (byte)(buf[7] & 0xFF);
                        }
                        if (actualSensor != lastSensor) {
                            if (logCountVario >= 5 || logCountGPS >= 5 || logCountGAM >= 5 || logCountEAM >= 5 || logCountESC >= 5) {
                                switch (lastSensor) {
                                    case -119: 
                                    case 55: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO)) break;
                                        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.VARIO) && isReceiverData) {
                                            HoTTbinReaderD.migrateAddPoints(tmpRecordSet, migrationJobs, timeSteps_ms[0], isResetMinMax);
                                            isJustMigrated = true;
                                            isReceiverData = false;
                                        }
                                        varBinParser.parse();
                                        migrationJobs.add(HoTTAdapter.Sensor.VARIO);
                                        if (isVarioDetected) break;
                                        HoTTAdapter2.updateVarioTypeDependent(buf4[9] & 0xFF, device, recordSet);
                                        isVarioDetected = true;
                                        break;
                                    }
                                    case -118: 
                                    case 56: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS)) break;
                                        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.GPS) && isReceiverData) {
                                            HoTTbinReaderD.migrateAddPoints(tmpRecordSet, migrationJobs, timeSteps_ms[0], isResetMinMax);
                                            isJustMigrated = true;
                                            isReceiverData = false;
                                        }
                                        gpsBinParser.parse();
                                        migrationJobs.add(HoTTAdapter.Sensor.GPS);
                                        if (isGPSdetected || !HoTTbinReaderD.isReasonableData(buf4) || recordSet.get(33).size() <= 0 || recordSet.get(33).get(recordSet.get(33).size() - 1) == 0) break;
                                        HoTTAdapter2.updateGpsTypeDependent(buf4[9] & 0xFF, device, recordSet, (recordSet.get(33).size() - 1) * 5);
                                        isGPSdetected = true;
                                        break;
                                    }
                                    case -115: 
                                    case 53: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM)) break;
                                        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.GAM) && isReceiverData) {
                                            HoTTbinReaderD.migrateAddPoints(tmpRecordSet, migrationJobs, timeSteps_ms[0], isResetMinMax);
                                            isJustMigrated = true;
                                            isReceiverData = false;
                                        }
                                        gamBinParser.parse();
                                        migrationJobs.add(HoTTAdapter.Sensor.GAM);
                                        break;
                                    }
                                    case -114: 
                                    case 54: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM)) break;
                                        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.EAM) && isReceiverData) {
                                            HoTTbinReaderD.migrateAddPoints(tmpRecordSet, migrationJobs, timeSteps_ms[0], isResetMinMax);
                                            isJustMigrated = true;
                                            isReceiverData = false;
                                        }
                                        eamBinParser.parse();
                                        migrationJobs.add(HoTTAdapter.Sensor.EAM);
                                        break;
                                    }
                                    case -116: 
                                    case 57: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC)) break;
                                        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.ESC) && isReceiverData) {
                                            HoTTbinReaderD.migrateAddPoints(tmpRecordSet, migrationJobs, timeSteps_ms[0], isResetMinMax);
                                            isJustMigrated = true;
                                            isReceiverData = false;
                                        }
                                        escBinParser.parse();
                                        migrationJobs.add(HoTTAdapter.Sensor.ESC);
                                        if (isESCdetected) break;
                                        HoTTAdapterD.updateEscTypeDependent(buf4[9] & 0xFF, device, recordSet, 1);
                                        isESCdetected = true;
                                    }
                                }
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "isReceiverData " + isReceiverData + " migrationJobs " + String.valueOf(migrationJobs));
                                }
                            }
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "logCountVario = " + logCountVario + " logCountGPS = " + logCountGPS + " logCountGeneral = " + logCountGAM + " logCountElectric = " + logCountEAM);
                            }
                            lastSensor = actualSensor;
                            logCountESC = 0;
                            logCountEAM = 0;
                            logCountGAM = 0;
                            logCountGPS = 0;
                            logCountVario = 0;
                        }
                        switch (lastSensor) {
                            case -119: 
                            case 55: {
                                ++logCountVario;
                                break;
                            }
                            case -118: 
                            case 56: {
                                ++logCountGPS;
                                break;
                            }
                            case -115: 
                            case 53: {
                                ++logCountGAM;
                                break;
                            }
                            case -114: 
                            case 54: {
                                ++logCountEAM;
                                break;
                            }
                            case -116: 
                            case 57: {
                                ++logCountESC;
                            }
                        }
                        if (isJustMigrated || HoTTbinReader.isReceiverOnly) {
                            ((HoTTbinReader2.RcvBinParser)rcvBinParser).updateLossStatistics();
                        }
                        tmpRecordSet.addPoints(points, (double)timeSteps_ms[0]);
                        isReceiverData = false;
                        isJustMigrated = false;
                        bufCopier.copyToBuffer();
                        timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                        if (i % progressIndicator == 0) {
                            GDE.getUiNotification().setProgress((int)((long)(i * 100) / numberDatablocks));
                        }
                    } else {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "-->> Found tx=rx=0 dBm");
                        }
                        ((HoTTbinReader2.RcvBinParser)rcvBinParser).trackPackageLoss(false);
                        chnBinParser.parse();
                        tmpRecordSet.addPoints(points, (double)timeSteps_ms[0]);
                        timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                    }
                } else if (!isTextModusSignaled) {
                    isTextModusSignaled = true;
                    application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2404"));
                }
                ++i;
            }
            ((HoTTbinReader2.RcvBinParser)rcvBinParser).finalUpdateLossStatistics();
            String packageLossPercentage = tmpRecordSet.getRecordDataSize(true) > 0 ? String.format("%.1f", ((HoTTbinReader2.RcvBinParser)HoTTbinReaderD.rcvBinParser).getLostPackages().percentage) : "100";
            detectedSensors.add(HoTTAdapter.Sensor.CHANNEL);
            tmpRecordSet.setRecordSetDescription(tmpRecordSet.getRecordSetDescription() + Messages.getString((String)"GDE_MSGI2404", (Object[])new Object[]{((HoTTbinReader2.RcvBinParser)rcvBinParser).getLossTotal(), ((HoTTbinReader2.RcvBinParser)HoTTbinReaderD.rcvBinParser).getLostPackages().lossTotal, packageLossPercentage, ((HoTTbinReader2.RcvBinParser)rcvBinParser).getLostPackages().getStatistics()}) + String.format(" - Sensor: %s", HoTTlogReader.detectedSensors.toString()) + (HoTTAdapter2.isAltClimbSensor(detectedSensors) ? String.format(" - %s = %s", Messages.getString((String)"GDE_MSGT2419"), HoTTAdapter.Sensor.fromOrdinal(HoTTbinReaderD.pickerParameters.altitudeClimbSensorSelection).name()) : ""));
            log.log(Level.WARNING, "skipped number receiver data due to package loss = " + ((HoTTbinReader2.RcvBinParser)HoTTbinReaderD.rcvBinParser).getLostPackages().lossTotal);
            log.log(Level.TIME, "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
            if (menuToolBar != null) {
                GDE.getUiNotification().setProgress(99);
                device.makeInActiveDisplayable(tmpRecordSet);
                device.updateVisibilityStatus(tmpRecordSet, true);
                channel.applyTemplate((String)recordSetName, false);
                tmpRecordSet.descriptionAppendFilename(file.getName());
                menuToolBar.updateChannelSelector();
                menuToolBar.updateRecordSetSelectCombo();
                GDE.getUiNotification().setProgress(100);
            }
        }
        finally {
            data_in.close();
            data_in = null;
        }
    }

    public static class VarBinParserD
    extends HoTTbinReader2.VarBinParser {
        private int tmpHeight = 0;
        private int tmpClimb10 = 0;

        protected VarBinParserD(HoTTAdapter.PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
            this(pickerParameters, new int[pickerParameters.analyzer.getActiveDevice().getNumberOfMeasurements(pickerParameters.analyzer.getActiveChannel().getNumber())], timeSteps_ms, buffers);
        }

        protected VarBinParserD(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.VARIO);
            if (buffers.length != 5) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
            points[2] = 100000;
        }

        @Override
        protected boolean parse() {
            this.tmpHeight = DataParser.parse2Short((byte[])this._buf1, (int)2) - 500;
            this.tmpClimb10 = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)2) - 30000;
            if (this.isPointsValid()) {
                if (this.pickerParameters.altitudeClimbSensorSelection == 1) {
                    this.points[10] = this.tmpHeight * 1000;
                    this.points[11] = (DataParser.parse2UnsignedShort((byte[])this._buf1, (int)8) - 30000) * 10;
                    this.points[12] = (DataParser.parse2UnsignedShort((byte[])this._buf2, (int)0) - 30000) * 10;
                    this.points[13] = this.tmpClimb10 * 10;
                }
                this.points[14] = (this._buf1[1] & 0x3F) * 1000;
                if ((this._buf4[9] & 0xFF) > 100 && (this._buf4[9] & 0xFF) < 120) {
                    try {
                        this.points[15] = Integer.parseInt(String.format(Locale.ENGLISH, "%c%c%c%c%c0", this._buf2[4], this._buf2[5], this._buf2[6], this._buf2[8], this._buf2[9]).trim());
                        this.points[16] = Integer.parseInt(String.format(Locale.ENGLISH, "%c%c%c%c%c0", this._buf3[1], this._buf3[2], this._buf3[3], this._buf3[5], this._buf3[6]).trim());
                        this.points[17] = Integer.parseInt(String.format(Locale.ENGLISH, "%c%c%c%c%c0", this._buf3[8], this._buf3[9], this._buf4[0], this._buf4[2], this._buf4[3]).trim());
                    }
                    catch (NumberFormatException e) {
                        byte[] tmpArray = new byte[21];
                        System.arraycopy(this._buf2, 4, tmpArray, 0, 6);
                        System.arraycopy(this._buf3, 0, tmpArray, 6, 10);
                        System.arraycopy(this._buf4, 0, tmpArray, 16, 5);
                        HoTTbinReader2.log.log(Level.WARNING, "'" + new String(tmpArray) + "'");
                    }
                    this.points[18] = (this._buf4[8] & 0xFF) * 1000;
                    this.points[19] = (this._buf4[9] & 0xFF) * 1000;
                } else {
                    int i = 0;
                    int j = 0;
                    while (i < 3) {
                        HoTTbinReaderD.points[i + 239] = DataParser.parse2Short((byte[])this._buf2, (int)(4 + j)) * 1000;
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        HoTTbinReaderD.points[i + 242] = DataParser.parse2Short((byte[])this._buf3, (int)(0 + j)) * 1000;
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        HoTTbinReaderD.points[i + 247] = DataParser.parse2Short((byte[])this._buf4, (int)(0 + j)) * 1000;
                        ++i;
                        j += 2;
                    }
                }
                return true;
            }
            System.out.println();
            this.points[14] = (this._buf1[1] & 0x3F) * 1000;
            return this.isPointsValid();
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpHeight >= -490 && this.tmpHeight < 5000;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            if (this.points[10] != 0 || this.points[11] != 0 || this.points[12] != 0 || this.points[13] != 0) {
                int j;
                for (j = 10; j < 20; ++j) {
                    targetPoints[j] = this.points[j];
                }
                for (j = 223; j < 236; ++j) {
                    targetPoints[j] = this.points[j];
                }
            }
        }
    }

    public static class EscBinParser
    extends HoTTbinReader.BinParser {
        private final boolean isChannelsChannel;
        private int tmpTemperatureFet = 0;
        private int tmpVoltage = 0;
        private int tmpCurrent = 0;
        private int tmpRevolution = 0;
        private int tmpCapacity = 0;
        private int parseCount = 0;

        protected boolean isChannelsChannel() {
            return this.isChannelsChannel;
        }

        protected EscBinParser(HoTTAdapter.PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
            this(pickerParameters, new int[pickerParameters.analyzer.getActiveDevice().getNumberOfMeasurements(pickerParameters.analyzer.getActiveChannel().getNumber())], timeSteps_ms, buffers);
        }

        protected EscBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.ESC);
            if (buffers.length != 5) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
            this.isChannelsChannel = this.pickerParameters.analyzer.getActiveChannel().getNumber() == 4;
        }

        @Override
        protected boolean parse() {
            this.tmpVoltage = DataParser.parse2Short((byte[])this._buf1, (int)3);
            this.tmpCurrent = DataParser.parse2Short((byte[])this._buf2, (int)1);
            this.tmpCapacity = DataParser.parse2Short((byte[])this._buf1, (int)7);
            this.tmpRevolution = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)5);
            this.tmpTemperatureFet = (this._buf1[9] & 0xFF) - 20;
            if (this.isPointsValid()) {
                this.points[123] = this.tmpVoltage * 1000;
                this.points[124] = this.tmpCurrent * 1000;
                this.points[126] = Double.valueOf((double)this.points[107] / 1000.0 * (double)this.points[108]).intValue();
                if (!this.pickerParameters.isFilterEnabled || this.parseCount <= 20 || this.tmpCapacity != 0 && Math.abs(this.tmpCapacity) <= this.points[109] / 1000 + this.tmpVoltage * this.tmpCurrent / 2500 + 2) {
                    this.points[125] = this.tmpCapacity * 1000;
                } else if (this.tmpCapacity != 0 && HoTTbinReader2.log.isLoggable(Level.FINE)) {
                    HoTTbinReader2.log.log(Level.FINE, StringHelper.getFormatedTime((String)"mm:ss.SSS", (long)this.getTimeStep_ms()) + " - " + this.tmpCapacity + " - " + this.points[104] / 1000 + " + " + (this.tmpVoltage * this.tmpCurrent / 2500 + 2));
                }
                this.points[127] = this.tmpRevolution * 1000;
                this.points[128] = this.tmpTemperatureFet * 1000;
                this.points[129] = ((this._buf2[9] & 0xFF) - 20) * 1000;
                this.points[130] = DataParser.parse2Short((byte[])this._buf1, (int)5) * 1000;
                this.points[131] = DataParser.parse2Short((byte[])this._buf2, (int)3) * 1000;
                this.points[132] = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)7) * 1000;
                this.points[133] = ((this._buf2[0] & 0xFF) - 20) * 1000;
                this.points[134] = ((this._buf3[0] & 0xFF) - 20) * 1000;
                this.points[135] = (this._buf1[1] & 0xFF) * 1000;
                if ((this._buf4[9] & 0xFF) == 3) {
                    this.points[136] = DataParser.parse2Short((byte[])this._buf3, (int)1) * 1000;
                    this.points[137] = DataParser.parse2Short((byte[])this._buf3, (int)3) * 1000;
                    this.points[138] = (this._buf3[5] & 0xFF) * 1000;
                    this.points[139] = (this._buf3[6] & 0xFF) * 1000;
                    this.points[140] = (this._buf3[7] & 0xFF) * 1000;
                    this.points[141] = (this._buf3[8] & 0xFF) * 1000;
                    this.points[142] = DataParser.parse2UnsignedShort((byte)this._buf3[9], (byte)this._buf4[0]) * 1000;
                    this.points[143] = ((this._buf4[1] & 0xFF) - 20) * 1000;
                    this.points[144] = ((this._buf4[2] & 0xFF) - 20) * 1000;
                    this.points[145] = (this._buf4[3] & 0xFF) * 1000;
                    this.points[146] = ((this._buf4[4] & 0xFF) - 20) * 1000;
                    this.points[147] = DataParser.parse2Short((byte[])this._buf4, (int)5) * 1000;
                    this.points[146] = (this._buf4[7] & 0xFF) * 1000;
                    this.points[149] = (this._buf4[8] & 0xFF) * 1000;
                    this.points[150] = 0;
                    this.points[151] = (this._buf4[9] & 0xFF) * 1000;
                } else if ((this._buf4[9] & 0xFF) >= 128) {
                    this.points[136] = DataParser.parse2Short((byte[])this._buf3, (int)1) * 1000;
                    this.points[137] = DataParser.parse2Short((byte[])this._buf3, (int)3) * 1000;
                    this.points[138] = (this._buf3[5] & 0xFF) * 1000;
                    this.points[139] = (this._buf3[6] & 0xFF) * 1000;
                    this.points[140] = (this._buf3[7] & 0xFF) * 1000;
                    this.points[141] = (this._buf3[8] & 0xFF) * 1000;
                    this.points[142] = DataParser.parse2UnsignedShort((byte)this._buf3[9], (byte)this._buf4[0]) * 1000;
                    this.points[143] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)1) * 1000;
                    this.points[144] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)3) * 1000;
                    this.points[145] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)5) * 1000;
                    this.points[146] = ((this._buf4[7] & 0xFF) - 20) * 1000;
                    this.points[147] = (this._buf4[8] & 0xFF) * 1000;
                    this.points[148] = 0;
                    this.points[149] = 0;
                    this.points[150] = 0;
                    this.points[151] = (this._buf4[9] & 0xFF) * 1000;
                }
                return true;
            }
            this.points[135] = (this._buf1[1] & 0xFF) * 1000;
            return false;
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpVoltage > 0 && this.tmpVoltage < 1000 && this.tmpCurrent < 4000 && this.tmpCurrent > -10 && this.tmpRevolution > -1 && this.tmpRevolution < 20000 && (this.points[112] == 0 || this.points[112] / 1000 - this.tmpTemperatureFet <= 20);
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            for (int j = 123; j < 152; ++j) {
                targetPoints[j] = this.points[j];
            }
        }
    }

    public static class ChnBinParser
    extends HoTTbinReader.BinParser {
        protected final byte[] _buf;

        protected ChnBinParser(HoTTAdapter.PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
            this(pickerParameters, new int[pickerParameters.analyzer.getActiveDevice().getNumberOfMeasurements(pickerParameters.analyzer.getActiveChannel().getNumber())], timeSteps_ms, buffers);
            throw new UnsupportedOperationException("use in situ parsing");
        }

        protected ChnBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.CHANNEL);
            this._buf = buffers[0];
            if (buffers.length != 1) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
        }

        @Override
        protected boolean parse() {
            this.points[4] = (this._buf[3] & 0xFF) * -1000;
            this.points[5] = (this._buf[4] & 0xFF) * -1000;
            this.points[87] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)8) / 2 * 1000;
            this.points[88] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)10) / 2 * 1000;
            this.points[89] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)12) / 2 * 1000;
            this.points[90] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)14) / 2 * 1000;
            this.points[91] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)16) / 2 * 1000;
            this.points[92] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)18) / 2 * 1000;
            this.points[93] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)20) / 2 * 1000;
            this.points[94] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)22) / 2 * 1000;
            if (this._buf[5] == 0) {
                this.points[95] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)24) / 2 * 1000;
                this.points[96] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)26) / 2 * 1000;
                this.points[97] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)28) / 2 * 1000;
                this.points[98] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)30) / 2 * 1000;
                if (this.points[99] == 0) {
                    this.points[99] = 1500000;
                    this.points[100] = 1500000;
                    this.points[101] = 1500000;
                    this.points[102] = 1500000;
                }
            } else {
                this.points[99] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)24) / 2 * 1000;
                this.points[100] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)26) / 2 * 1000;
                this.points[101] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)28) / 2 * 1000;
                this.points[102] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)30) / 2 * 1000;
                if (this.points[95] == 0) {
                    this.points[95] = 1500000;
                    this.points[96] = 1500000;
                    this.points[97] = 1500000;
                    this.points[98] = 1500000;
                }
            }
            this.points[119] = (this._buf[50] & 1) * 100000;
            this.points[120] = (this._buf[50] & 2) * 50000;
            this.points[121] = (this._buf[50] & 4) * 25000;
            this.points[122] = this._buf[37] > 0 && this._buf[37] < 27 ? this._buf[32] * 1000 : 0;
            return true;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            int j;
            for (j = 4; j < 7; ++j) {
                targetPoints[j] = this.points[j];
            }
            for (j = 87; j < 103; ++j) {
                targetPoints[j] = this.points[j];
            }
            throw new UnsupportedOperationException("use in situ parsing");
        }
    }
}

