/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.parser;

import org.xhtmlrenderer.css.parser.FSColor;

public class FSCMYKColor
implements FSColor {
    private final float _cyan;
    private final float _magenta;
    private final float _yellow;
    private final float _black;

    public FSCMYKColor(float c2, float m2, float y2, float k2) {
        if (c2 < 0.0f || c2 > 1.0f) {
            throw new IllegalArgumentException();
        }
        if (m2 < 0.0f || m2 > 1.0f) {
            throw new IllegalArgumentException();
        }
        if (y2 < 0.0f || y2 > 1.0f) {
            throw new IllegalArgumentException();
        }
        if (k2 < 0.0f || k2 > 1.0f) {
            throw new IllegalArgumentException();
        }
        this._cyan = c2;
        this._magenta = m2;
        this._yellow = y2;
        this._black = k2;
    }

    public float getCyan() {
        return this._cyan;
    }

    public float getMagenta() {
        return this._magenta;
    }

    public float getYellow() {
        return this._yellow;
    }

    public float getBlack() {
        return this._black;
    }

    public String toString() {
        return "cmyk(" + this._cyan + ", " + this._magenta + ", " + this._yellow + ", " + this._black + ")";
    }

    @Override
    public FSColor lightenColor() {
        return new FSCMYKColor(this._cyan * 0.8f, this._magenta * 0.8f, this._yellow * 0.8f, this._black);
    }

    @Override
    public FSColor darkenColor() {
        return new FSCMYKColor(Math.min(1.0f, this._cyan / 0.8f), Math.min(1.0f, this._magenta / 0.8f), Math.min(1.0f, this._yellow / 0.8f), this._black);
    }
}

