/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.Serializable;
import org.apache.commons.math3.random.BitsStreamGenerator;
import org.apache.commons.math3.util.FastMath;

public abstract class AbstractWell
extends BitsStreamGenerator
implements Serializable {
    private static final long serialVersionUID = -817701723016583596L;
    protected int index;
    protected final int[] v;
    protected final int[] iRm1;
    protected final int[] iRm2;
    protected final int[] i1;
    protected final int[] i2;
    protected final int[] i3;

    protected AbstractWell(int k2, int m1, int m2, int m3) {
        this(k2, m1, m2, m3, null);
    }

    protected AbstractWell(int k2, int m1, int m2, int m3, int seed) {
        this(k2, m1, m2, m3, new int[]{seed});
    }

    protected AbstractWell(int k2, int m1, int m2, int m3, int[] seed) {
        int w2 = 32;
        int r2 = (k2 + 32 - 1) / 32;
        this.v = new int[r2];
        this.index = 0;
        this.iRm1 = new int[r2];
        this.iRm2 = new int[r2];
        this.i1 = new int[r2];
        this.i2 = new int[r2];
        this.i3 = new int[r2];
        for (int j2 = 0; j2 < r2; ++j2) {
            this.iRm1[j2] = (j2 + r2 - 1) % r2;
            this.iRm2[j2] = (j2 + r2 - 2) % r2;
            this.i1[j2] = (j2 + m1) % r2;
            this.i2[j2] = (j2 + m2) % r2;
            this.i3[j2] = (j2 + m3) % r2;
        }
        this.setSeed(seed);
    }

    protected AbstractWell(int k2, int m1, int m2, int m3, long seed) {
        this(k2, m1, m2, m3, new int[]{(int)(seed >>> 32), (int)(seed & 0xFFFFFFFFL)});
    }

    public void setSeed(int seed) {
        this.setSeed(new int[]{seed});
    }

    public void setSeed(int[] seed) {
        if (seed == null) {
            this.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
            return;
        }
        System.arraycopy(seed, 0, this.v, 0, FastMath.min(seed.length, this.v.length));
        if (seed.length < this.v.length) {
            for (int i2 = seed.length; i2 < this.v.length; ++i2) {
                long l2 = this.v[i2 - seed.length];
                this.v[i2] = (int)(1812433253L * (l2 ^ l2 >> 30) + (long)i2 & 0xFFFFFFFFL);
            }
        }
        this.index = 0;
        this.clear();
    }

    public void setSeed(long seed) {
        this.setSeed(new int[]{(int)(seed >>> 32), (int)(seed & 0xFFFFFFFFL)});
    }

    protected abstract int next(int var1);
}

