/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.security;

import com.itextpdf.text.pdf.security.DigestAlgorithms;
import com.itextpdf.text.pdf.security.ExternalSignature;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;

public class PrivateKeySignature
implements ExternalSignature {
    private PrivateKey pk;
    private String hashAlgorithm;
    private String encryptionAlgorithm;
    private String provider;

    public PrivateKeySignature(PrivateKey pk, String hashAlgorithm, String provider2) {
        this.pk = pk;
        this.provider = provider2;
        this.hashAlgorithm = DigestAlgorithms.getDigest(DigestAlgorithms.getAllowedDigests(hashAlgorithm));
        this.encryptionAlgorithm = pk.getAlgorithm();
        if (this.encryptionAlgorithm.startsWith("EC")) {
            this.encryptionAlgorithm = "ECDSA";
        }
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public byte[] sign(byte[] b2) throws GeneralSecurityException {
        String signMode = this.hashAlgorithm + "with" + this.encryptionAlgorithm;
        Signature sig = this.provider == null ? Signature.getInstance(signMode) : Signature.getInstance(signMode, this.provider);
        sig.initSign(this.pk);
        sig.update(b2);
        return sig.sign();
    }
}

