/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.ui.SWTResourceManager;
import java.util.Random;
import org.eclipse.swt.graphics.Color;

public final class ColorUtils {
    public static String getDefaultRgb(int ordinal) {
        String rgb;
        switch (ordinal) {
            case 0: {
                rgb = "0,0,255";
                break;
            }
            case 1: {
                rgb = "0,128,0";
                break;
            }
            case 2: {
                rgb = "128,0,0";
                break;
            }
            case 3: {
                rgb = "255,0,255";
                break;
            }
            case 4: {
                rgb = "64,0,64";
                break;
            }
            case 5: {
                rgb = "0,128,128";
                break;
            }
            case 6: {
                rgb = "128,128,0";
                break;
            }
            case 7: {
                rgb = "128,0,128";
                break;
            }
            case 8: {
                rgb = "0,128,255";
                break;
            }
            case 9: {
                rgb = "128,255,0";
                break;
            }
            case 10: {
                rgb = "255,0,128";
                break;
            }
            case 11: {
                rgb = "0,64,128";
                break;
            }
            case 12: {
                rgb = "64,128,0";
                break;
            }
            case 13: {
                rgb = "128,0,64";
                break;
            }
            case 14: {
                rgb = "128,64,0";
                break;
            }
            case 15: {
                rgb = "0,128,64";
                break;
            }
            default: {
                Random rand = new Random();
                rgb = ColorUtils.toRGB(rand.nextInt() & 0xFF, rand.nextInt() & 0xFF, rand.nextInt() & 0xFF);
            }
        }
        return rgb;
    }

    public static String toRGB(int red, int green, int blue) {
        return red + "," + green + "," + blue;
    }

    public static int toRGB(String rgb) {
        int r = Integer.parseInt(rgb.split(",")[0]);
        int g = Integer.parseInt(rgb.split(",")[1]);
        int b = Integer.parseInt(rgb.split(",")[2]);
        return ColorUtils.toIntRGB(r, g, b);
    }

    public static String toRGB(int rgb) {
        return ColorUtils.toRGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static int toIntRGB(int red, int green, int blue) {
        return red << 16 + green << 8 + blue;
    }

    public static Color getColor(String rgb) {
        int r = Integer.parseInt(rgb.split(",")[0]);
        int g = Integer.parseInt(rgb.split(",")[1]);
        int b = Integer.parseInt(rgb.split(",")[2]);
        Color color = SWTResourceManager.getColor(r, g, b);
        return color;
    }
}

