/*
 * Decompiled with CFR 0.152.
 */
package gde.io;

import gde.Analyzer;
import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.IDevice;
import gde.exception.DataInconsitsentException;
import gde.exception.NotSupportedException;
import gde.exception.NotSupportedFileFormatException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class LogViewReader {
    static final Logger log = Logger.getLogger(LogViewReader.class.getName());
    static final DataExplorer application = DataExplorer.getInstance();
    static final Channels channels = Channels.getInstance();
    static final LogViewDeviceMap deviceMap = new LogViewDeviceMap();
    static final HashMap<String, String> lov2osdMap = new HashMap();

    public static String putDeviceMap(String key, String value) {
        return deviceMap.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static RecordSet read(String filePath) throws Exception {
        FileInputStream file_input = new FileInputStream(new File(filePath));
        DataInputStream data_in = new DataInputStream(file_input);
        String channelConfig = "";
        String recordSetName = "";
        String recordSetComment = "";
        String recordSetProperties = "";
        int recordDataSize = 0;
        int recordSetDataBytes = 0;
        int lastRecordSetDataBytes = 0;
        Channel channel = null;
        RecordSet recordSet = null;
        IDevice device = application.getActiveDevice();
        boolean isFirstRecordSetDisplayed = false;
        device.getLovKeyMappings(lov2osdMap);
        HashMap<String, String> header = LogViewReader.readHeader(data_in);
        int channelNumber = device.recordSetNumberFollowChannel() ? Integer.valueOf(header.get("Channel/Configuration Number : ")).intValue() : channels.getActiveChannelNumber();
        ChannelTypes channelType = device.getChannelTypes(channelNumber);
        String channelConfigName = device.getChannelNameReplacement(channelNumber);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "channelConfigName = " + channelConfigName + " (Channel/Configuration Type : " + String.valueOf((Object)channelType) + "; Channel/Configuration Number : " + channelNumber + ")");
        }
        header.put("Channel/Configuration Type : ", channelType.name());
        header.put("Channel/Configuration Name: ", channelConfigName);
        int numberRecordSets = Integer.valueOf(header.get("NumberRecordSets : ").trim());
        ArrayList<HashMap<String, String>> recordSetsInfo = new ArrayList<HashMap<String, String>>(numberRecordSets);
        for (int i = 1; i <= numberRecordSets; ++i) {
            Object recordSetInfo = header.get(i + " RecordSetName : ");
            recordSetInfo = (String)recordSetInfo + "||::||Channel/Configuration Name: " + header.get("Channel/Configuration Name: ");
            recordSetInfo = header.containsKey("timeStep_ms") ? (String)recordSetInfo + "||::||timeStep_ms=" + device.getTimeStep_ms() : (String)recordSetInfo + "||::||timeStep_ms=" + device.getTimeStep_ms();
            recordSetInfo = (String)recordSetInfo + "||::||";
            recordSetInfo = (String)recordSetInfo + device.getConvertedRecordConfigurations(header, lov2osdMap, channelNumber);
            recordSetsInfo.add(LogViewReader.getRecordSetProperties((String)recordSetInfo));
        }
        try {
            long position = Long.parseLong(header.get("Data_Pointer_Pos : ").trim());
            for (HashMap hashMap : recordSetsInfo) {
                channelConfig = (String)hashMap.get("Channel/Configuration Name: ");
                recordSetName = (String)hashMap.get("RecordSetName : ");
                recordSetName = recordSetName.length() <= 40 ? recordSetName : recordSetName.substring(0, 40);
                recordSetComment = (String)hashMap.get("RecordSetComment : ");
                recordSetProperties = (String)hashMap.get("RecordSetProperties : ");
                String[] recordsProperties = StringHelper.splitString((String)hashMap.get("RecordProperties : "), "|:-:|", "RecordProperties : ");
                channel = (Channel)channels.get(channelNumber);
                if (channel == null) {
                    String msg = Messages.getString("GDE_MSGI0018", new Object[]{recordSetName}) + " " + Messages.getString("GDE_MSGI0019") + "\n" + Messages.getString("GDE_MSGI0020");
                    DataExplorer.getInstance().openMessageDialogAsync(msg);
                    channel = channels.addChannel(channelConfig, channelType, Analyzer.getInstance());
                }
                recordSet = RecordSet.createRecordSet(recordSetName, device, channel.getNumber(), true, true, true);
                recordSet.setRecordSetDescription(recordSetComment);
                recordSet.setDeserializedProperties(recordSetProperties);
                recordSet.setSaved(true);
                try {
                    void var28_33;
                    int day;
                    int year;
                    void var28_32;
                    String[] timeStamp = recordSetComment.split(" |,");
                    boolean bl = false;
                    while (!timeStamp[var28_32].contains(".") && !timeStamp[var28_32].contains("-")) {
                        ++var28_32;
                    }
                    int n = year = timeStamp[var28_32].contains(".") ? Integer.parseInt(timeStamp[var28_32].substring(6, 10)) : Integer.parseInt(timeStamp[var28_32].substring(0, 4));
                    year = year >= 2000 ? year : (year > 50 ? year + 1900 : year + 2000);
                    int month = timeStamp[var28_32].contains(".") ? Integer.parseInt(timeStamp[var28_32].substring(3, 5)) : Integer.parseInt(timeStamp[var28_32].substring(5, 7));
                    int n2 = day = timeStamp[var28_32].contains(".") ? Integer.parseInt(timeStamp[var28_32].substring(0, 2)) : Integer.parseInt(timeStamp[var28_32].substring(8, 10));
                    while (!timeStamp[var28_33].contains(":")) {
                        ++var28_33;
                    }
                    int hour = Integer.parseInt(timeStamp[var28_33].substring(0, 2));
                    int minute = Integer.parseInt(timeStamp[var28_33].substring(3, 5));
                    int second = Integer.parseInt(timeStamp[var28_33].substring(6, 8));
                    GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, minute, second);
                    recordSet.setStartTimeStamp(calendar.getTimeInMillis());
                }
                catch (Exception timeStamp) {
                    // empty catch block
                }
                for (int i = 0; i < recordsProperties.length; ++i) {
                    Record record = recordSet.get(i);
                    record.setSerializedProperties(recordsProperties[i]);
                    record.setSerializedDeviceSpecificProperties(recordsProperties[i]);
                }
                channel.put(recordSetName, recordSet);
            }
            MenuToolBar menuToolBar = application.getMenuToolBar();
            if (menuToolBar != null) {
                menuToolBar.updateChannelSelector();
                menuToolBar.updateRecordSetSelectCombo();
            }
            String[] stringArray = new String[2];
            for (HashMap hashMap : recordSetsInfo) {
                channelConfig = (String)hashMap.get("Channel/Configuration Name: ");
                recordSetName = (String)hashMap.get("RecordSetName : ");
                String string = recordSetName = recordSetName.length() <= 40 ? recordSetName : recordSetName.substring(0, 40);
                if (stringArray[0] == null || stringArray[1] == null) {
                    stringArray[0] = channelConfig;
                    stringArray[1] = recordSetName;
                }
                recordDataSize = Integer.valueOf(((String)hashMap.get("RecordDataSize : ")).trim());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "recordDataSize = " + recordDataSize);
                }
                recordSetDataBytes = Long.valueOf(((String)hashMap.get("RecordSetDataBytes : ")).trim()).intValue();
                if (lastRecordSetDataBytes == 0) {
                    lastRecordSetDataBytes = recordSetDataBytes;
                } else {
                    recordSetDataBytes -= lastRecordSetDataBytes;
                    lastRecordSetDataBytes = Long.valueOf(((String)hashMap.get("RecordSetDataBytes : ")).trim()).intValue();
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "recordSetDataSize = " + recordSetDataBytes);
                }
                long recordSetDataPointer = position;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("recordSetDataPointer = %d (0x%X)", recordSetDataPointer, recordSetDataPointer));
                }
                channel = (Channel)channels.get(channelNumber);
                recordSet = (RecordSet)channel.get(recordSetName);
                recordSet.setFileDataPointerAndSize(recordSetDataPointer, recordDataSize, recordSetDataBytes);
                byte[] buffer = new byte[recordSetDataBytes];
                if (recordSetName.equals(stringArray[1])) {
                    long startTime = new Date().getTime();
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "data buffer size = " + buffer.length);
                    }
                    data_in.readFully(buffer);
                    log.log(Level.TIME, "read time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
                    device.addConvertedLovDataBufferAsRawDataPoints(recordSet, buffer, recordDataSize, GDE.isWithUi());
                    log.log(Level.TIME, "read time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
                    device.updateVisibilityStatus(recordSet, true);
                    if (application.getMenuToolBar() != null) {
                        channel.applyTemplate(recordSet.getName(), true);
                    }
                }
                if (!isFirstRecordSetDisplayed && stringArray[0] != null && stringArray[1] != null && application.getMenuToolBar() != null) {
                    isFirstRecordSetDisplayed = true;
                    channel.setFileName(filePath);
                    channel.setFileDescription(header.get("FileComment : "));
                    channel.setSaved(true);
                    channels.switchChannel(channelNumber, stringArray[1]);
                }
                position += (long)buffer.length;
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, String.format("data pointer position = 0x%X", position));
            }
            Iterator iterator = recordSet;
            return iterator;
        }
        finally {
            data_in.close();
            data_in = null;
            file_input = null;
        }
    }

    public static void readRecordSetsData(RecordSet recordSet, String filePath, boolean doUpdateProgressBar) throws FileNotFoundException, IOException, DataInconsitsentException {
        try (RandomAccessFile random_in = null;){
            long recordSetFileDataPointer = recordSet.getFileDataPointer();
            int recordFileDataSize = recordSet.getFileDataSize();
            IDevice device = recordSet.getDevice();
            long startTime = new Date().getTime();
            byte[] buffer = new byte[recordSet.getFileDataBytesSize()];
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "recordSetDataSize = " + buffer.length);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("recordSetDataPointer = %d (0x%X)", recordSetFileDataPointer, recordSetFileDataPointer));
            }
            random_in = new RandomAccessFile(new File(filePath), "r");
            random_in.seek(recordSetFileDataPointer);
            recordSetFileDataPointer = random_in.getFilePointer();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("recordSetDataPointer = %d (0x%X)", recordSetFileDataPointer, recordSetFileDataPointer));
            }
            random_in.readFully(buffer);
            random_in.close();
            device.addConvertedLovDataBufferAsRawDataPoints(recordSet, buffer, recordFileDataSize, doUpdateProgressBar);
            log.log(Level.TIME, "read time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
            device.updateVisibilityStatus(recordSet, true);
            if (application.getMenuToolBar() != null) {
                channels.getActiveChannel().applyTemplate(recordSet.getName(), true);
            }
        }
    }

    public static HashMap<String, String> getRecordSetProperties(String recordSetProperties) {
        return StringHelper.splitString(recordSetProperties, "||::||", GDE.LOV_FORMAT_DATA_KEYS);
    }

    private static HashMap<String, String> getBaseHeaderData(HashMap<String, String> header, DataInputStream data_in) throws IOException, NotSupportedFileFormatException {
        long position = 0L;
        byte[] buffer = new byte[8];
        position += (long)data_in.read(buffer);
        long headerSize = LogViewReader.parse2Long(buffer);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Header_Size : " + headerSize);
        }
        header.put("Header_Size : ", "" + headerSize);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int streamVersion = LogViewReader.parse2Int(buffer);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Stream_Version : " + streamVersion);
        }
        header.put("Stream_Version : ", "" + streamVersion);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int tmpStringSize = LogViewReader.parse2Int(buffer);
        buffer = new byte[tmpStringSize];
        position += (long)data_in.read(buffer);
        String stringVersion = new String(buffer);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "String_Stream_Version : " + stringVersion);
        }
        if (streamVersion != Integer.valueOf(stringVersion.split(":V")[1])) {
            NotSupportedFileFormatException e = new NotSupportedFileFormatException(Messages.getString("GDE_MSGE0008", new Object[]{streamVersion, stringVersion}));
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        header.put("String_Stream_Version : ", stringVersion);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        tmpStringSize = LogViewReader.parse2Int(buffer);
        buffer = new byte[tmpStringSize];
        position += (long)data_in.read(buffer);
        String lovFormatVersion = new String(buffer);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Format_Version : " + lovFormatVersion);
        }
        header.put("Format_Version : ", lovFormatVersion);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        tmpStringSize = LogViewReader.parse2Int(buffer);
        buffer = new byte[tmpStringSize];
        position += (long)data_in.read(buffer);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Created : " + new String(buffer));
        }
        header.put("Created : ", new String(buffer));
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        tmpStringSize = LogViewReader.parse2Int(buffer);
        buffer = new byte[tmpStringSize];
        position += (long)data_in.read(buffer);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Updated : " + new String(buffer));
        }
        header.put("Updated : ", new String(buffer));
        header.put("Data_Pointer_Pos : ", "" + position);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        return header;
    }

    public static HashMap<String, String> getHeader(String filePath) throws IOException, NotSupportedFileFormatException, Exception {
        FileInputStream file_input = new FileInputStream(new File(filePath));
        HashMap<String, String> header = null;
        try (DataInputStream data_in = new DataInputStream(file_input);){
            header = LogViewReader.readHeader(data_in);
        }
        return header;
    }

    public static HashMap<String, String> readHeader(DataInputStream data_in) throws IOException, NotSupportedFileFormatException, NotSupportedException, DataInconsitsentException {
        Object useVersion;
        HashMap<String, String> header = new HashMap<String, String>();
        LogViewReader.getBaseHeaderData(header, data_in);
        String streamVersion = header.get("Stream_Version : ");
        String[] aVersion = header.get("Format_Version : ").split(" ");
        Object object = useVersion = aVersion.length > 1 ? aVersion[1] : "";
        if (aVersion.length >= 3) {
            useVersion = (String)useVersion + " " + aVersion[2];
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "using format version " + (String)useVersion);
        }
        if (((String)useVersion).equals("1.13")) {
            header = LogViewReader.getHeaderInfo_1_13(data_in, header);
            header = LogViewReader.getRecordSetInfo_1_13(data_in, header);
        } else if (((String)useVersion).startsWith("1.14") || ((String)useVersion).equals("1.15")) {
            header = LogViewReader.getHeaderInfo_1_15(data_in, header);
            header = LogViewReader.getRecordSetInfo_1_15(data_in, header);
        } else if (((String)useVersion).equals("1.50 ALPHA")) {
            header = LogViewReader.getHeaderInfo_1_50_ALPHA(data_in, header);
            header = LogViewReader.getRecordSetInfo_1_50_ALPHA(data_in, header);
        } else if (((String)useVersion).equals("1.50 PreBETA") || ((String)useVersion).startsWith("2.0 BETA")) {
            header = LogViewReader.getHeaderInfo_1_50_BETA(data_in, header);
            header = LogViewReader.getRecordSetInfo_1_50_BETA(data_in, header);
        } else if (streamVersion.equals("4")) {
            header = LogViewReader.getHeaderInfo_4(data_in, header);
            header = LogViewReader.getRecordSetInfo_4(data_in, header);
        } else if (streamVersion.equals("5")) {
            header = LogViewReader.getHeaderInfo_5(data_in, header);
            header = LogViewReader.getRecordSetInfo_5(data_in, header);
        } else {
            NotSupportedFileFormatException e = new NotSupportedFileFormatException(Messages.getString("GDE_MSGI0021", new Object[]{useVersion}));
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        return header;
    }

    private static HashMap<String, String> getHeaderInfo_1_13(DataInputStream data_in, HashMap<String, String> header) throws IOException, NotSupportedException {
        long position = Long.parseLong(header.get("Data_Pointer_Pos : "));
        long headerSize = Long.parseLong(header.get("Header_Size : "));
        StringBuilder fileComment = new StringBuilder();
        byte[] buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberCommentLines = LogViewReader.parse2Int(buffer);
        for (int i = 0; i < numberCommentLines; ++i) {
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int fileCommentSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[fileCommentSize];
            position += (long)data_in.read(buffer);
            fileComment.append(new String(buffer)).append(" ");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "FileComment :  = " + fileComment.toString());
        }
        header.put("FileComment : ", fileComment.toString());
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberChannels = LogViewReader.parse2Int(buffer);
        for (int i = 0; i < numberChannels; ++i) {
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int fileCommentSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[fileCommentSize];
            position += (long)data_in.read(buffer);
            String channelConfigName = new String(buffer);
            header.put("Channel/Configuration Name: ", channelConfigName);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Channel/Configuration Name: " + channelConfigName);
        }
        int channelNumber = Integer.valueOf(new String(buffer).split("=")[1].trim());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Channel/Configuration Number : " + channelNumber);
        }
        header.put("Channel/Configuration Number : ", "" + channelNumber);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int comStrSize = LogViewReader.parse2Int(buffer);
        if (comStrSize != 0) {
            buffer = new byte[comStrSize];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "CommunicationPort = " + new String(buffer));
            }
        }
        position += (long)data_in.skipBytes(4);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int deviceNameSize = LogViewReader.parse2Int(buffer);
        buffer = new byte[deviceNameSize];
        position += (long)data_in.read(buffer);
        String deviceName = new String(buffer);
        deviceName = LogViewReader.mapLovDeviceNames(deviceName);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "DeviceName : " + deviceName);
        }
        header.put("DeviceName : ", deviceName);
        position += data_in.skip(headerSize - position);
        header.put("Data_Pointer_Pos : ", "" + position);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        return header;
    }

    private static HashMap<String, String> getRecordSetInfo_1_13(DataInputStream data_in, HashMap<String, String> header) throws IOException {
        long position = Long.parseLong(header.get("Data_Pointer_Pos : "));
        position += data_in.skip(8L);
        byte[] buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberRecordSets = LogViewReader.parse2Int(buffer);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "NumberRecordSets : " + numberRecordSets);
        }
        header.put("NumberRecordSets : ", "" + numberRecordSets);
        position += (long)data_in.skipBytes(8);
        for (int i = 0; i < numberRecordSets; ++i) {
            StringBuilder sb = new StringBuilder();
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int recordSetNameSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[recordSetNameSize];
            position += (long)data_in.read(buffer);
            String recordSetName = new String(buffer);
            sb.append("RecordSetName : ").append(recordSetName).append("||::||");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetName : " + recordSetName);
            }
            position += (long)data_in.skipBytes(4);
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int recordSetCommentSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[recordSetCommentSize];
            position += (long)data_in.read(buffer);
            String recordSetComment = new String(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetComment : " + recordSetComment);
            }
            sb.append("RecordSetComment : ").append(recordSetComment).append("||::||");
            position += (long)data_in.skipBytes(4);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            int tmpDataSize = 0;
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            tmpDataSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int dataSize = tmpDataSize = tmpDataSize > LogViewReader.parse2Int(buffer) ? tmpDataSize : LogViewReader.parse2Int(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordDataSize : " + dataSize);
            }
            sb.append("RecordDataSize : ").append(dataSize).append("||::||");
            position += (long)data_in.skipBytes(28);
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long recordSetDataBytes = LogViewReader.parse2Long(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetDataBytes : " + recordSetDataBytes);
            }
            sb.append("RecordSetDataBytes : ").append(recordSetDataBytes);
            header.put("Data_Pointer_Pos : ", "" + position);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            header.put(i + 1 + " RecordSetName : ", sb.toString());
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, header.get(i + 1 + " RecordSetName : "));
        }
        return header;
    }

    private static HashMap<String, String> getHeaderInfo_1_15(DataInputStream data_in, HashMap<String, String> header) throws IOException, NotSupportedException {
        long position = Long.parseLong(header.get("Data_Pointer_Pos : "));
        long headerSize = Long.parseLong(header.get("Header_Size : "));
        StringBuilder fileComment = new StringBuilder();
        byte[] buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberCommentLines = LogViewReader.parse2Int(buffer);
        for (int i = 0; i < numberCommentLines; ++i) {
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int fileCommentSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[fileCommentSize];
            position += (long)data_in.read(buffer);
            fileComment.append(new String(buffer)).append(" ");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "FileComment :  = " + fileComment.toString());
        }
        header.put("FileComment : ", fileComment.toString());
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberChannels = LogViewReader.parse2Int(buffer);
        for (int i = 0; i < numberChannels; ++i) {
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int fileCommentSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[fileCommentSize];
            position += (long)data_in.read(buffer);
            String channelConfigName = new String(buffer);
            header.put("Channel/Configuration Name: ", channelConfigName);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Channel/Configuration Name: " + channelConfigName);
        }
        int channelNumber = Integer.valueOf(new String(buffer).split("=")[1].trim());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Channel/Configuration Number : " + channelNumber);
        }
        header.put("Channel/Configuration Number : ", "" + channelNumber);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int comStrSize = LogViewReader.parse2Int(buffer);
        if (comStrSize != 0) {
            buffer = new byte[comStrSize];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "CommunicationPort = " + new String(buffer));
            }
        }
        position += (long)data_in.skipBytes(4);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int deviceNameSize = LogViewReader.parse2Int(buffer);
        buffer = new byte[deviceNameSize];
        position += (long)data_in.read(buffer);
        String deviceName = new String(buffer);
        deviceName = LogViewReader.mapLovDeviceNames(deviceName);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "DeviceName : " + deviceName);
        }
        header.put("DeviceName : ", deviceName);
        position += data_in.skip(headerSize - position);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        header.put("Data_Pointer_Pos : ", "" + position);
        return header;
    }

    private static HashMap<String, String> getRecordSetInfo_1_15(DataInputStream data_in, HashMap<String, String> header) throws IOException {
        long position = Long.parseLong(header.get("Data_Pointer_Pos : "));
        position += data_in.skip(8L);
        byte[] buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberRecordSets = LogViewReader.parse2Int(buffer);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "NumberRecordSets : " + numberRecordSets);
        }
        header.put("NumberRecordSets : ", "" + numberRecordSets);
        position += (long)data_in.skipBytes(8);
        for (int i = 0; i < numberRecordSets; ++i) {
            StringBuilder sb = new StringBuilder();
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int recordSetNameSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[recordSetNameSize];
            position += (long)data_in.read(buffer);
            String recordSetName = new String(buffer);
            sb.append("RecordSetName : ").append(recordSetName).append("||::||");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetName : " + recordSetName);
            }
            position += (long)data_in.skipBytes(4);
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int recordSetCommentSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[recordSetCommentSize];
            position += (long)data_in.read(buffer);
            String recordSetComment = new String(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetComment : " + recordSetComment);
            }
            sb.append("RecordSetComment : ").append(recordSetComment).append("||::||");
            position += (long)data_in.skipBytes(4);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            int tmpDataSize = 0;
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            tmpDataSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int dataSize = tmpDataSize = tmpDataSize > LogViewReader.parse2Int(buffer) ? tmpDataSize : LogViewReader.parse2Int(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordDataSize : " + dataSize);
            }
            sb.append("RecordDataSize : ").append(dataSize).append("||::||");
            position += (long)data_in.skipBytes(16);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            StringBuilder config = new StringBuilder();
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int numberLines = LogViewReader.parse2Int(buffer);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "numberLines = " + numberLines);
            }
            for (int j = 0; j < numberLines; ++j) {
                buffer = new byte[4];
                position += (long)data_in.read(buffer);
                int stringSize = LogViewReader.parse2Int(buffer);
                buffer = new byte[stringSize];
                position += (long)data_in.read(buffer);
                config.append(new String(buffer)).append("||::||");
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, new String(buffer));
            }
            header.put("logview_config_data", config.toString());
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            position += (long)data_in.skipBytes(8);
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long recordSetDataBytes = LogViewReader.parse2Long(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetDataBytes : " + recordSetDataBytes);
            }
            sb.append("RecordSetDataBytes : ").append(recordSetDataBytes);
            header.put("Data_Pointer_Pos : ", "" + position);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            header.put(i + 1 + " RecordSetName : ", sb.toString());
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, header.get(i + 1 + " RecordSetName : "));
        }
        return header;
    }

    private static HashMap<String, String> getHeaderInfo_1_50_ALPHA(DataInputStream data_in, HashMap<String, String> header) throws IOException, NotSupportedException {
        long position = Long.parseLong(header.get("Data_Pointer_Pos : "));
        long headerSize = Long.parseLong(header.get("Header_Size : "));
        StringBuilder fileComment = new StringBuilder();
        byte[] buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberCommentLines = LogViewReader.parse2Int(buffer);
        for (int i = 0; i < numberCommentLines; ++i) {
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int fileCommentSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[fileCommentSize];
            position += (long)data_in.read(buffer);
            fileComment.append(new String(buffer)).append(" ");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "FileComment :  = " + fileComment.toString());
        }
        header.put("FileComment : ", fileComment.toString());
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberChannels = LogViewReader.parse2Int(buffer);
        for (int i = 0; i < numberChannels; ++i) {
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int fileCommentSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[fileCommentSize];
            position += (long)data_in.read(buffer);
            String channelConfigName = new String(buffer);
            header.put("Channel/Configuration Name: ", channelConfigName);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Channel/Configuration Name: " + channelConfigName);
        }
        int channelNumber = Integer.valueOf(new String(buffer).split("=")[1].trim());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Channel/Configuration Number : " + channelNumber);
        }
        header.put("Channel/Configuration Number : ", "" + channelNumber);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int comStrSize = LogViewReader.parse2Int(buffer);
        if (comStrSize != 0) {
            buffer = new byte[comStrSize];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "CommunicationPort = " + new String(buffer));
            }
        }
        position += (long)data_in.skipBytes(4);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int deviceNameSize = LogViewReader.parse2Int(buffer);
        buffer = new byte[deviceNameSize];
        position += (long)data_in.read(buffer);
        String deviceName = new String(buffer);
        deviceName = LogViewReader.mapLovDeviceNames(deviceName);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "DeviceName : " + deviceName);
        }
        header.put("DeviceName : ", deviceName);
        position += data_in.skip(headerSize - position);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        header.put("Data_Pointer_Pos : ", "" + position);
        return header;
    }

    private static HashMap<String, String> getRecordSetInfo_1_50_ALPHA(DataInputStream data_in, HashMap<String, String> header) throws IOException {
        long position = Long.parseLong(header.get("Data_Pointer_Pos : "));
        position += data_in.skip(88L);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        byte[] buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberRecordSets = LogViewReader.parse2Int(buffer);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "NumberRecordSets : " + numberRecordSets);
        }
        header.put("NumberRecordSets : ", "" + numberRecordSets);
        position += (long)data_in.skipBytes(8);
        for (int i = 0; i < numberRecordSets; ++i) {
            StringBuilder sb = new StringBuilder();
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int recordSetNameSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[recordSetNameSize];
            position += (long)data_in.read(buffer);
            String recordSetName = new String(buffer);
            sb.append("RecordSetName : ").append(recordSetName).append("||::||");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetName : " + recordSetName);
            }
            position += (long)data_in.skipBytes(4);
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int recordSetCommentSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[recordSetCommentSize];
            position += (long)data_in.read(buffer);
            String recordSetComment = new String(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetComment : " + recordSetComment);
            }
            sb.append("RecordSetComment : ").append(recordSetComment).append("||::||");
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            position += (long)data_in.skipBytes(2);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long recordSetConfigSize = LogViewReader.parse2Long(buffer);
            buffer = new byte[(int)recordSetConfigSize];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "RecordSetConfig = " + new String(buffer));
            }
            position += (long)data_in.skipBytes(112);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            int tmpDataSize = 0;
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            tmpDataSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int dataSize = LogViewReader.parse2Int(buffer);
            if (tmpDataSize != dataSize) {
                log.log(Level.WARNING, "data size calculation wrong");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordDataSize : " + dataSize);
            }
            sb.append("RecordDataSize : ").append(dataSize).append("||::||");
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            position += (long)data_in.skipBytes(216);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            StringBuilder config = new StringBuilder();
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int numberLines = LogViewReader.parse2Int(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "numberLines = " + numberLines);
            }
            for (int j = 0; j < numberLines; ++j) {
                buffer = new byte[4];
                position += (long)data_in.read(buffer);
                int stringSize = LogViewReader.parse2Int(buffer);
                buffer = new byte[stringSize];
                position += (long)data_in.read(buffer);
                config.append(new String(buffer)).append("||::||");
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, new String(buffer));
            }
            header.put("logview_config_data", config.toString());
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long recordSetDataBytes = LogViewReader.parse2Long(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetDataBytes : " + recordSetDataBytes);
            }
            sb.append("RecordSetDataBytes : ").append(recordSetDataBytes);
            header.put("Data_Pointer_Pos : ", "" + position);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            header.put(i + 1 + " RecordSetName : ", sb.toString());
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, header.get(i + 1 + " RecordSetName : "));
        }
        return header;
    }

    private static HashMap<String, String> getHeaderInfo_1_50_BETA(DataInputStream data_in, HashMap<String, String> header) throws IOException, NotSupportedException {
        long position = Long.parseLong(header.get("Data_Pointer_Pos : "));
        long headerSize = Long.parseLong(header.get("Header_Size : "));
        byte[] buffer = new byte[8];
        position += (long)data_in.read(buffer);
        long fileCommentSize = LogViewReader.parse2Long(buffer);
        buffer = new byte[(int)fileCommentSize];
        position += (long)data_in.read(buffer);
        String rtfString = new String(buffer);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, rtfString);
        }
        String fileComment = LogViewReader.parseRtfString(rtfString);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "FileComment :  = " + fileComment);
        }
        header.put("FileComment : ", fileComment);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberChannels = LogViewReader.parse2Int(buffer);
        for (int i = 0; i < numberChannels; ++i) {
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            fileCommentSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[(int)fileCommentSize];
            position += (long)data_in.read(buffer);
            String channelConfigName = new String(buffer);
            header.put("Channel/Configuration Name: ", channelConfigName);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Channel/Configuration Name: " + channelConfigName);
        }
        int channelNumber = Integer.valueOf(new String(buffer).split("=")[1].trim());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Channel/Configuration Number : " + channelNumber);
        }
        header.put("Channel/Configuration Number : ", "" + channelNumber);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int comStrSize = LogViewReader.parse2Int(buffer);
        if (comStrSize != 0) {
            buffer = new byte[comStrSize];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "CommunicationPort = " + new String(buffer));
            }
        }
        position += (long)data_in.skipBytes(4);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int deviceNameSize = LogViewReader.parse2Int(buffer);
        buffer = new byte[deviceNameSize];
        position += (long)data_in.read(buffer);
        String deviceName = new String(buffer);
        deviceName = LogViewReader.mapLovDeviceNames(deviceName);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "DeviceName : " + deviceName);
        }
        header.put("DeviceName : ", deviceName);
        position += data_in.skip(8L);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int deviceConfigLineSize = LogViewReader.parse2Int(buffer);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "DeviceConfigLineSize = " + deviceConfigLineSize);
        }
        for (int i = 0; i < deviceConfigLineSize; ++i) {
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int lineSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[lineSize];
            position += (long)data_in.read(buffer);
            String configLine = new String(buffer);
            if (configLine.startsWith("TimeStep_ms=")) {
                header.put("timeStep_ms", configLine.split("=")[1]);
            } else if (configLine.startsWith("WerteAnzahl=")) {
                header.put("WerteAnzahl=", "" + (Integer.valueOf(configLine.split("=")[1].trim()) - 1));
            }
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, configLine);
        }
        position += data_in.skip(headerSize - position);
        header.put("Data_Pointer_Pos : ", "" + position);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        return header;
    }

    private static HashMap<String, String> getRecordSetInfo_1_50_BETA(DataInputStream data_in, HashMap<String, String> header) throws IOException {
        long position = Long.parseLong(header.get("Data_Pointer_Pos : "));
        position += data_in.skip(88L);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        byte[] buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberRecordSets = LogViewReader.parse2Int(buffer);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "NumberRecordSets : " + numberRecordSets);
        }
        header.put("NumberRecordSets : ", "" + numberRecordSets);
        position += (long)data_in.skipBytes(8);
        for (int i = 0; i < numberRecordSets; ++i) {
            StringBuilder sb = new StringBuilder();
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int recordSetNameSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[recordSetNameSize];
            position += (long)data_in.read(buffer);
            String recordSetName = new String(buffer);
            sb.append("RecordSetName : ").append(recordSetName).append("||::||");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetName : " + recordSetName);
            }
            position += (long)data_in.skipBytes(2);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long recordSetConfigSize = LogViewReader.parse2Long(buffer);
            buffer = new byte[(int)recordSetConfigSize];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "RecordSetConfig = " + new String(buffer));
            }
            position += (long)data_in.skipBytes(112);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            int tmpDataSize = 0;
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            tmpDataSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int dataSize = tmpDataSize = tmpDataSize > LogViewReader.parse2Int(buffer) ? tmpDataSize : LogViewReader.parse2Int(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordDataSize : " + dataSize);
            }
            sb.append("RecordDataSize : ").append(dataSize).append("||::||");
            position += (long)data_in.skipBytes(16);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            StringBuilder config = new StringBuilder();
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int numberLines = LogViewReader.parse2Int(buffer);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "numberLines = " + numberLines);
            }
            for (int j = 0; j < numberLines; ++j) {
                buffer = new byte[4];
                position += (long)data_in.read(buffer);
                int stringSize = LogViewReader.parse2Int(buffer);
                buffer = new byte[stringSize];
                position += (long)data_in.read(buffer);
                config.append(new String(buffer)).append("||::||");
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, new String(buffer));
            }
            header.put("logview_config_data", config.toString());
            position += (long)data_in.skipBytes(4);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long rtfCommentSize = LogViewReader.parse2Long(buffer);
            buffer = new byte[(int)rtfCommentSize];
            position += (long)data_in.read(buffer);
            String rtfString = new String(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, rtfString);
            }
            String recordSetComment = LogViewReader.parseRtfString(rtfString);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetComment : " + recordSetComment);
            }
            sb.append("RecordSetComment : ").append(recordSetComment).append("||::||");
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            buffer = new byte[LogViewReader.parse2Int(buffer)];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, new String(buffer));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            position += data_in.skip(175L);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long recordSetDataBytes = LogViewReader.parse2Long(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetDataBytes : " + recordSetDataBytes);
            }
            sb.append("RecordSetDataBytes : ").append(recordSetDataBytes);
            header.put("Data_Pointer_Pos : ", "" + position);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            header.put(i + 1 + " RecordSetName : ", sb.toString());
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, header.get(i + 1 + " RecordSetName : "));
        }
        return header;
    }

    private static HashMap<String, String> getHeaderInfo_4(DataInputStream data_in, HashMap<String, String> header) throws IOException, NotSupportedException {
        long position = Long.parseLong(header.get("Data_Pointer_Pos : "));
        long headerSize = Long.parseLong(header.get("Header_Size : "));
        byte[] buffer = new byte[8];
        position += (long)data_in.read(buffer);
        long fileCommentSize = LogViewReader.parse2Long(buffer);
        buffer = new byte[(int)fileCommentSize];
        position += (long)data_in.read(buffer);
        String rtfString = new String(buffer);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, rtfString);
        }
        String fileComment = LogViewReader.parseRtfString(rtfString);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "FileComment :  = " + fileComment);
        }
        header.put("FileComment : ", fileComment);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberChannels = LogViewReader.parse2Int(buffer);
        for (int i = 0; i < numberChannels; ++i) {
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            fileCommentSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[(int)fileCommentSize];
            position += (long)data_in.read(buffer);
            String channelConfigName = new String(buffer);
            header.put("Channel/Configuration Name: ", channelConfigName);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Channel/Configuration Name: " + channelConfigName);
        }
        int channelNumber = Integer.valueOf(new String(buffer).split("=")[1].trim());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Channel/Configuration Number : " + channelNumber);
        }
        header.put("Channel/Configuration Number : ", "" + channelNumber);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int comStrSize = LogViewReader.parse2Int(buffer);
        if (comStrSize != 0) {
            buffer = new byte[comStrSize];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "CommunicationPort = " + new String(buffer));
            }
        }
        position += (long)data_in.skipBytes(4);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int deviceNameSize = LogViewReader.parse2Int(buffer);
        buffer = new byte[deviceNameSize];
        position += (long)data_in.read(buffer);
        String deviceName = new String(buffer);
        deviceName = LogViewReader.mapLovDeviceNames(deviceName);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "DeviceName : " + deviceName);
        }
        header.put("DeviceName : ", deviceName);
        position += data_in.skip(8L);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int deviceConfigLineSize = LogViewReader.parse2Int(buffer);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "DeviceConfigLineSize = " + deviceConfigLineSize);
        }
        for (int i = 0; i < deviceConfigLineSize; ++i) {
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int lineSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[lineSize];
            position += (long)data_in.read(buffer);
            String configLine = new String(buffer);
            if (configLine.startsWith("TimeStep_ms=")) {
                header.put("timeStep_ms", configLine.split("=")[1]);
            } else if (configLine.startsWith("WerteAnzahl=")) {
                header.put("WerteAnzahl=", "" + (Integer.valueOf(configLine.split("=")[1].trim()) - 1));
            }
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, configLine);
        }
        position += data_in.skip(headerSize - position);
        header.put("Data_Pointer_Pos : ", "" + position);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        return header;
    }

    private static HashMap<String, String> getRecordSetInfo_4(DataInputStream data_in, HashMap<String, String> header) throws IOException {
        long position = Long.parseLong(header.get("Data_Pointer_Pos : "));
        position += data_in.skip(88L);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        byte[] buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberRecordSets = LogViewReader.parse2Int(buffer);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "NumberRecordSets : " + numberRecordSets);
        }
        header.put("NumberRecordSets : ", "" + numberRecordSets);
        position += (long)data_in.skipBytes(8);
        for (int i = 0; i < numberRecordSets; ++i) {
            StringBuilder sb = new StringBuilder();
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int recordSetNameSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[recordSetNameSize];
            position += (long)data_in.read(buffer);
            String recordSetName = new String(buffer);
            sb.append("RecordSetName : ").append(recordSetName).append("||::||");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetName : " + recordSetName);
            }
            position += (long)data_in.skipBytes(2);
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long recordSetConfigSize = LogViewReader.parse2Long(buffer);
            buffer = new byte[(int)recordSetConfigSize];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "RecordSetConfig = " + new String(buffer));
            }
            position += (long)data_in.skipBytes(112);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            int tmpDataSize = 0;
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            tmpDataSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int dataSize = tmpDataSize = tmpDataSize > LogViewReader.parse2Int(buffer) ? tmpDataSize : LogViewReader.parse2Int(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordDataSize : " + dataSize);
            }
            sb.append("RecordDataSize : ").append(dataSize).append("||::||");
            position += (long)data_in.skipBytes(16);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            StringBuilder config = new StringBuilder();
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int numberLines = LogViewReader.parse2Int(buffer);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "numberLines = " + numberLines);
            }
            for (int j = 0; j < numberLines; ++j) {
                buffer = new byte[4];
                position += (long)data_in.read(buffer);
                int stringSize = LogViewReader.parse2Int(buffer);
                buffer = new byte[stringSize];
                position += (long)data_in.read(buffer);
                config.append(new String(buffer)).append("||::||");
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, new String(buffer));
            }
            header.put("logview_config_data", config.toString());
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long rtfCommentSize = LogViewReader.parse2Long(buffer);
            buffer = new byte[(int)rtfCommentSize];
            position += (long)data_in.read(buffer);
            String rtfString = new String(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, rtfString);
            }
            String recordSetComment = LogViewReader.parseRtfString(rtfString);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetComment : " + recordSetComment);
            }
            sb.append("RecordSetComment : ").append(recordSetComment).append("||::||");
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            buffer = new byte[LogViewReader.parse2Int(buffer)];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, new String(buffer));
            }
            position += data_in.skip(175L);
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long recordSetDataBytes = LogViewReader.parse2Long(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetDataBytes : " + recordSetDataBytes);
            }
            sb.append("RecordSetDataBytes : ").append(recordSetDataBytes);
            header.put("Data_Pointer_Pos : ", "" + position);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            header.put(i + 1 + " RecordSetName : ", sb.toString());
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, header.get(i + 1 + " RecordSetName : "));
        }
        return header;
    }

    private static HashMap<String, String> getHeaderInfo_5(DataInputStream data_in, HashMap<String, String> header) throws IOException, NotSupportedException {
        int channelNumber;
        long position = Long.parseLong(header.get("Data_Pointer_Pos : "));
        long headerSize = Long.parseLong(header.get("Header_Size : "));
        byte[] buffer = new byte[]{};
        long fileCommentSize = 0L;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        buffer = new byte[8];
        position += (long)data_in.read(buffer);
        fileCommentSize = LogViewReader.parse2Long(buffer);
        buffer = new byte[(int)fileCommentSize];
        position += (long)data_in.read(buffer);
        String rtfString = new String(buffer);
        String fileComment = LogViewReader.parseRtfString(rtfString);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "FileComment :  = " + fileComment);
        }
        header.put("FileComment : ", fileComment);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberChannels = LogViewReader.parse2Int(buffer);
        for (int i = 0; i < numberChannels; ++i) {
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            fileCommentSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[(int)fileCommentSize];
            position += (long)data_in.read(buffer);
            String channelConfigName = new String(buffer);
            header.put("Channel/Configuration Name: ", channelConfigName);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Channel/Configuration Name: " + channelConfigName);
        }
        int n = channelNumber = new String(buffer).contains("=") ? Integer.valueOf(new String(buffer).split("=")[1].trim()) : 1;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Channel/Configuration Number : " + channelNumber);
        }
        header.put("Channel/Configuration Number : ", "" + channelNumber);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int comStrSize = LogViewReader.parse2Int(buffer);
        if (comStrSize != 0) {
            buffer = new byte[comStrSize];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "CommunicationPort = " + new String(buffer));
            }
        }
        position += (long)data_in.skipBytes(4);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int deviceNameSize = LogViewReader.parse2Int(buffer);
        buffer = new byte[deviceNameSize];
        position += (long)data_in.read(buffer);
        String deviceName = new String(buffer);
        deviceName = LogViewReader.mapLovDeviceNames(deviceName);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "DeviceName : " + deviceName);
        }
        header.put("DeviceName : ", deviceName);
        position += data_in.skip(8L);
        buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int deviceConfigLineSize = LogViewReader.parse2Int(buffer);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "DeviceConfigLineSize = " + deviceConfigLineSize);
        }
        for (int i = 0; i < deviceConfigLineSize; ++i) {
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int lineSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[lineSize];
            position += (long)data_in.read(buffer);
            String configLine = new String(buffer);
            if (configLine.startsWith("TimeStep_ms=")) {
                header.put("timeStep_ms", configLine.split("=")[1]);
            } else if (configLine.startsWith("WerteAnzahl=")) {
                header.put("WerteAnzahl=", "" + (Integer.valueOf(configLine.split("=")[1].trim()) - 1));
            }
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, configLine);
        }
        position += data_in.skip(headerSize - position);
        header.put("Data_Pointer_Pos : ", "" + position);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("position = 0x%X", position));
        }
        return header;
    }

    static String parseRtfString(String rtfString) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, rtfString);
        }
        StringBuilder fileComment = new StringBuilder();
        if (rtfString.indexOf("\\plain ") != -1) {
            String[] array = rtfString.split("plain ");
            for (int i = 1; i < array.length; ++i) {
                int beginIndex = 0;
                int endIndex = 0;
                while ((beginIndex = array[i].indexOf(" ", beginIndex)) != -1 && (endIndex = array[i].indexOf("\\", beginIndex)) != -1) {
                    fileComment.append(array[i].substring(beginIndex + 1, endIndex));
                    beginIndex = endIndex + 1;
                }
            }
        }
        while (fileComment.length() > 1 && (fileComment.lastIndexOf("\n") == fileComment.length() - 1 || fileComment.lastIndexOf("\r") == fileComment.length() - 1)) {
            fileComment.deleteCharAt(fileComment.length() - 1);
        }
        return fileComment.toString();
    }

    private static HashMap<String, String> getRecordSetInfo_5(DataInputStream data_in, HashMap<String, String> header) throws IOException, DataInconsitsentException {
        long position = Long.parseLong(header.get("Data_Pointer_Pos : "));
        position += data_in.skip(88L);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        byte[] buffer = new byte[4];
        position += (long)data_in.read(buffer);
        int numberRecordSets = LogViewReader.parse2Int(buffer);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "NumberRecordSets : " + numberRecordSets);
        }
        header.put("NumberRecordSets : ", "" + numberRecordSets);
        position += (long)data_in.skipBytes(8);
        for (int i = 0; i < numberRecordSets; ++i) {
            StringBuilder sb = new StringBuilder();
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int recordSetNameSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[recordSetNameSize];
            position += (long)data_in.read(buffer);
            String recordSetName = new String(buffer);
            sb.append("RecordSetName : ").append(recordSetName).append("||::||");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetName : " + recordSetName);
            }
            position += (long)data_in.skipBytes(2);
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long recordSetConfigSize = LogViewReader.parse2Long(buffer);
            buffer = new byte[(int)recordSetConfigSize];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "RecordSetConfig = " + new String(buffer));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            position += (long)data_in.skipBytes(112);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            int dataSize = 0;
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            dataSize = LogViewReader.parse2Int(buffer);
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int n = dataSize = dataSize > LogViewReader.parse2Int(buffer) ? dataSize : LogViewReader.parse2Int(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordDataSize : " + dataSize);
            }
            sb.append("RecordDataSize : ").append(dataSize).append("||::||");
            position += (long)data_in.skipBytes(16);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            StringBuilder config = new StringBuilder();
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int numberLines = LogViewReader.parse2Int(buffer);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "numberLines = " + numberLines);
            }
            for (int j = 0; j < numberLines; ++j) {
                buffer = new byte[4];
                position += (long)data_in.read(buffer);
                int stringSize = LogViewReader.parse2Int(buffer);
                buffer = new byte[stringSize];
                position += (long)data_in.read(buffer);
                config.append(new String(buffer)).append("||::||");
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, new String(buffer));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            header.put("logview_config_data", config.toString());
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long rtfCommentSize = LogViewReader.parse2Long(buffer);
            buffer = new byte[(int)rtfCommentSize];
            position += (long)data_in.read(buffer);
            String rtfString = new String(buffer);
            String recordSetComment = LogViewReader.parseRtfString(rtfString);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RecordSetComment : " + recordSetComment.toString());
            }
            sb.append("RecordSetComment : ").append(recordSetComment.toString()).append("||::||");
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            buffer = new byte[LogViewReader.parse2Int(buffer)];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, new String(buffer));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            buffer = new byte[115];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, new String(buffer));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            buffer = new byte[4];
            position += (long)data_in.read(buffer);
            int numberChars = LogViewReader.parse2Int(buffer);
            if (numberChars > 100) {
                log.log(Level.SEVERE, "numberChars = " + numberChars);
                throw new DataInconsitsentException("Corrupt input file");
            }
            buffer = new byte[numberChars];
            position += (long)data_in.read(buffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "R_%" + new String(buffer) + "%@");
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            position += data_in.skip(56L);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("position = 0x%X", position));
            }
            buffer = new byte[8];
            position += (long)data_in.read(buffer);
            long recordSetDataBytes = LogViewReader.parse2Long(buffer);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("%s%d (%X%X%X%X%X%X%X%X)", "RecordSetDataBytes : ", recordSetDataBytes, buffer[0], buffer[1], buffer[2], buffer[3], buffer[4], buffer[5], buffer[6], buffer[7]));
            }
            sb.append("RecordSetDataBytes : ").append(recordSetDataBytes);
            header.put("Data_Pointer_Pos : ", "" + position);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("position = 0x%X", position));
            }
            header.put(i + 1 + " RecordSetName : ", sb.toString());
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, header.get(i + 1 + " RecordSetName : "));
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("position = 0x%X", position));
        }
        return header;
    }

    public static int parse2Int(byte[] buffer) {
        switch (buffer.length) {
            case 1: {
                return buffer[0] & 0xFF;
            }
            case 2: {
                return (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
            }
            case 3: {
                return (buffer[2] & 0xFF) << 16 | (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
            }
            default: {
                return (buffer[3] & 0xFF) << 24 | (buffer[2] & 0xFF) << 16 | (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
            }
            case 8: 
        }
        return (buffer[3] & 0xFF) << 24 | (buffer[2] & 0xFF) << 16 | (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
    }

    public static long parse2Long(byte[] buffer) {
        long tmpLong1 = ((long)(buffer[3] & 0xFF) << 24) + (long)((buffer[2] & 0xFF) << 16) + (long)((buffer[1] & 0xFF) << 8) + (long)((buffer[0] & 0xFF) << 0);
        long tmpLong2 = (((long)buffer[7] & 0xFFL) << 56) + ((long)(buffer[6] & 0xFF) << 48) + ((long)(buffer[5] & 0xFF) << 40) + ((long)(buffer[4] & 0xFF) << 32);
        return tmpLong2 + tmpLong1;
    }

    private static String mapLovDeviceNames(String deviceName) throws NotSupportedException {
        String deviceKey = deviceName.toLowerCase().trim();
        String string = deviceKey = deviceMap.containsKey(deviceKey) ? deviceKey : deviceKey.split("_")[0];
        if (!deviceMap.containsKey(deviceKey)) {
            String msg = Messages.getString("GDE_MSGW0016", new Object[]{deviceName});
            NotSupportedException e = new NotSupportedException(msg);
            log.log(Level.WARNING, e.getMessage(), e);
            throw e;
        }
        return deviceMap.get(deviceKey) != null ? deviceMap.get(deviceKey) : deviceMap.get(deviceKey.split("_")[0]);
    }

    static {
        deviceMap.put("htronic akkumaster c4", "AkkuMasterC4");
        deviceMap.put("akkumatik", "Akkumatik");
        deviceMap.put("picolario", "Picolario");
        deviceMap.put("e-station 902", "eStation902");
        deviceMap.put("e-station bc6", "eStationBC6");
        deviceMap.put("e-station bc6dx", "eStationBC6 80W");
        deviceMap.put("e-station bc610", "eStationBC610");
        deviceMap.put("e-station bc8", "eStationBC8");
        deviceMap.put("pichler p6", "PichlerP6");
        deviceMap.put("imax b6", "iMax B6");
        deviceMap.put("pichler p60", "PichlerP60 50W");
        deviceMap.put("pichler p6 80w", "PichlerP60 80W");
        deviceMap.put("pichler p60 80w 220v", "PichlerP60 80W");
        deviceMap.put("wstech datavario", "DataVario");
        deviceMap.put("wstech datavario duo", "DataVarioDuo");
        deviceMap.put("wstech linkvario", "LinkVario");
        deviceMap.put("wstech linkvario duo", "LinkVarioDuo");
        deviceMap.put("qc copter", "QC-Copter");
        deviceMap.put("unilog", "UniLog");
        deviceMap.put("sm unilog", "UniLog");
        deviceMap.put("sm unilog 2", "UniLog2");
        deviceMap.put("sm jlog2", "JLog2");
        deviceMap.put("lipowatch", "LiPoWatch");
        deviceMap.put("sm lipowatch", "LiPoWatch");
        deviceMap.put("sm gps logger", "GPS-Logger");
        deviceMap.put("nmea 0183", "NMEA-Adapter");
        deviceMap.put("graupner ultra duo plus 40", "UltraDuoPlus40");
        deviceMap.put("graupner ultra duo plus 45", "UltraDuoPlus45");
        deviceMap.put("graupner ultra duo plus 50", "UltraDuoPlus50");
        deviceMap.put("graupner ultra duo plus 60", "UltraDuoPlus60");
        deviceMap.put("graupner ultra duo plus 80", "UltraDuoPlus80");
        deviceMap.put("raytronic c60", "Raytronic C60");
        deviceMap.put("robbe powerpeak twin 1000w", "Robbe Powerpeak Twin 1000W");
        deviceMap.put("robbe powerpeak iv", "Robbe PowerPeak IV");
        deviceMap.put("megapower gemini 2014 duo2", "UltraDuoPlus80");
        deviceMap.put("graupner ultramat 18", "Ultramat18");
        deviceMap.put("graupner ultramat 12 plus pocket", "Ultramat12");
        deviceMap.put("graupner ultramat 16", "Ultramat16");
        deviceMap.put("graupner ultramat 16s", "Ultramat16S");
        deviceMap.put("graupner ultra trio plus 14", "UltraTrioPlus14");
        deviceMap.put("graupner ultra trio plus 16", "UltraTrioPlus16S");
        deviceMap.put("junsi icharger 106b", "iCharger106B");
        deviceMap.put("junsi icharger 1010b", "iCharger1010B");
        deviceMap.put("junsi icharger 206b", "iCharger206B");
        deviceMap.put("junsi icharger 208b", "iCharger208B");
        deviceMap.put("junsi icharger 306b", "iCharger306B");
        deviceMap.put("junsi icharger 3010b", "iCharger3010B");
        deviceMap.put("junsi icharger 308 duo", "iCharger308DUO");
        deviceMap.put("junsi icharger 4010 duo", "iCharger4010DUO");
        deviceMap.put("junsi celllog 8s", "CellLog 8S");
        deviceMap.put("openformat\\jlog2", "JLog2");
        deviceMap.put("openformat\\kosmik", "Kosmik");
        deviceMap.put("openformat\\av4ms_fv_762", "AV4ms_FV_762");
        deviceMap.put("openformat\\usb-wde1", "USB-WDE1");
        deviceMap.put("elv usb-wde1", "USB-WDE1");
        deviceMap.put("schulze next 10.36 car", "next 10.36-8");
        deviceMap.put("schulze next 10.36", "next 10.36-8");
    }

    public static class LogViewDeviceMap
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1L;

        public boolean containsKey(String key) {
            String openFormat = "openformat";
            String jlog2 = "jlog2";
            if (key.startsWith(openFormat) && key.contains(jlog2)) {
                for (String tmpKey : this.keySet()) {
                    if (!tmpKey.startsWith(openFormat) || !tmpKey.contains("jlog2")) continue;
                    return super.containsKey(openFormat + "\\" + jlog2);
                }
            }
            return super.containsKey(key);
        }

        public String get(String key) {
            String openFormat = "openformat";
            String jlog2 = "jlog2";
            if (key.startsWith(openFormat) && key.contains(jlog2)) {
                for (String tmpKey : this.keySet()) {
                    if (!tmpKey.startsWith(openFormat) || !tmpKey.contains("jlog2")) continue;
                    return (String)super.get(openFormat + "\\" + jlog2);
                }
            }
            return (String)super.get(key);
        }
    }
}

