/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.device;

import gde.Analyzer;
import gde.device.ChannelType;
import gde.device.DeviceConfiguration;
import gde.device.IChannelItem;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.ScoreGroupType;
import gde.device.SettlementType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;

public final class ChannelItems {
    private final DeviceConfiguration deviceConfiguration;
    private final ChannelType channelType;

    public ChannelItems(Analyzer analyzer) {
        this.deviceConfiguration = analyzer.getActiveDevice().getDeviceConfiguration();
        this.channelType = this.deviceConfiguration.getChannel(analyzer.getActiveChannel().getNumber());
    }

    public void processItems(BiConsumer<Integer, IChannelItem> measurementAction, BiConsumer<Integer, IChannelItem> settlementAction, BiConsumer<Integer, IChannelItem> scoreGroupAction) {
        PropertyType topPlacementProperty;
        List<MeasurementType> channelMeasurements = this.channelType.getMeasurement();
        LinkedHashMap<Integer, SettlementType> channelSettlements = this.channelType.getSettlements();
        LinkedHashMap<Integer, ScoreGroupType> channelScoreGroups = this.channelType.getScoreGroups();
        int myIndex = channelMeasurements.size() + channelSettlements.size();
        for (IChannelItem iChannelItem : channelScoreGroups.values()) {
            topPlacementProperty = iChannelItem.getProperty("histo_top_placement");
            if (topPlacementProperty != null && Boolean.parseBoolean(topPlacementProperty.getValue())) {
                scoreGroupAction.accept(myIndex, iChannelItem);
            }
            ++myIndex;
        }
        myIndex = channelMeasurements.size();
        for (SettlementType settlementType : channelSettlements.values()) {
            topPlacementProperty = settlementType.getProperty("histo_top_placement");
            if (topPlacementProperty != null && Boolean.parseBoolean(topPlacementProperty.getValue())) {
                settlementAction.accept(myIndex, settlementType);
            }
            ++myIndex;
        }
        for (int i = 0; i < channelMeasurements.size(); ++i) {
            MeasurementType measurement = channelMeasurements.get(i);
            measurementAction.accept(i, measurement);
        }
        myIndex = channelMeasurements.size();
        for (SettlementType settlementType : channelSettlements.values()) {
            topPlacementProperty = settlementType.getProperty("histo_top_placement");
            if (topPlacementProperty == null || !Boolean.parseBoolean(topPlacementProperty.getValue())) {
                settlementAction.accept(myIndex, settlementType);
            }
            ++myIndex;
        }
        myIndex = channelMeasurements.size() + channelSettlements.size();
        for (ScoreGroupType scoreGroupType : channelScoreGroups.values()) {
            topPlacementProperty = scoreGroupType.getProperty("histo_top_placement");
            if (topPlacementProperty == null || !Boolean.parseBoolean(topPlacementProperty.getValue())) {
                scoreGroupAction.accept(myIndex, scoreGroupType);
            }
            ++myIndex;
        }
    }
}

