/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSToolbar;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTToolbar;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    int itemCount;
    ToolItem[] items;
    NSToolbar nsToolbar;
    NSArray accessibilityAttributes = null;
    ToolItem lastFocus;
    static int NEXT_ID;

    public ToolBar(Composite parent, int style) {
        this(parent, style, false);
    }

    ToolBar(Composite parent, int style, boolean internal) {
        super(parent, ToolBar.checkStyle(parent, style, internal));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    @Override
    long accessibilityAttributeValue(long id2, long sel, long arg0) {
        id returnObject;
        NSString nsAttributeName = new NSString(arg0);
        if (id2 == this.accessibleHandle() && this.accessible != null && (returnObject = this.accessible.internal_accessibilityAttributeValue(nsAttributeName, -1)) != null) {
            return returnObject.id;
        }
        if (nsAttributeName.isEqualToString(OS.NSAccessibilityRoleAttribute) || nsAttributeName.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            NSString role = OS.NSAccessibilityToolbarRole;
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                return role.id;
            }
            long roleDescription = OS.NSAccessibilityRoleDescription(role.id, 0L);
            return roleDescription;
        }
        if (nsAttributeName.isEqualToString(OS.NSAccessibilityChildrenAttribute)) {
            NSMutableArray returnValue = NSMutableArray.arrayWithCapacity(this.itemCount);
            int i2 = 0;
            while (i2 < this.itemCount) {
                returnValue.addObject(new id(this.getItem(i2).accessibleHandle()));
                ++i2;
            }
            return returnValue.id;
        }
        if (nsAttributeName.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return NSNumber.numberWithBool((boolean)this.isEnabled()).id;
        }
        if (nsAttributeName.isEqualToString(OS.NSAccessibilityFocusedAttribute)) {
            boolean focused = this.view.id == this.view.window().firstResponder().id;
            return NSNumber.numberWithBool((boolean)focused).id;
        }
        return super.accessibilityAttributeValue(id2, sel, arg0);
    }

    @Override
    boolean accessibilityIsIgnored(long id2, long sel) {
        if (id2 == this.view.id) {
            return false;
        }
        return super.accessibilityIsIgnored(id2, sel);
    }

    static int checkStyle(Composite parent, int style, boolean internal) {
        int newStyle = style & 0xFFFFFCFF;
        if (!internal && (newStyle & 0x10000) != 0) {
            newStyle &= 0xFFFEFFFF;
        }
        if ((style & 0x10000) != 0) {
            if (parent instanceof Shell) {
                Shell s = (Shell)parent;
                if (s.window.toolbar() != null) {
                    newStyle &= 0xFFFEFFFF;
                }
            } else {
                newStyle &= 0xFFFEFFFF;
            }
        }
        if ((newStyle & 0x10000) != 0) {
            newStyle &= 0xFFFFFDBF;
            newStyle |= 0x100;
        }
        return newStyle;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed2) {
        this.checkWidget();
        int width = wHint;
        int height = hHint;
        if (wHint == -1) {
            width = Integer.MAX_VALUE;
        }
        if (hHint == -1) {
            height = Integer.MAX_VALUE;
        }
        int[] result2 = this.layout(width, height, false);
        Point extent = new Point(result2[1], result2[2]);
        if (wHint != -1) {
            extent.x = wHint;
        }
        if (hHint != -1) {
            extent.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, extent.x, extent.y);
        return new Point(trim.width, trim.height);
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        if (this.nsToolbar != null) {
            NSRect outer = this.view.frame();
            NSRect inner = new NSView(this.view.subviews().objectAtIndex(0L)).frame();
            width += (int)outer.width - (int)inner.width;
        } else if (this.scrollView != null) {
            NSSize size = new NSSize();
            size.width = width;
            size.height = height;
            size = NSScrollView.frameSizeForContentSize(size, false, false, 2L);
            width = (int)size.width;
            height = (int)size.height;
            NSRect frame = this.scrollView.contentView().frame();
            x = (int)((double)x - frame.x);
            y = (int)((double)y - frame.y);
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    void createHandle() {
        if ((this.style & 0x10000) != 0) {
            this.nsToolbar = ((NSToolbar)new SWTToolbar().alloc()).initWithIdentifier(NSString.stringWith(String.valueOf(NEXT_ID++)));
            this.nsToolbar.setDelegate(this.nsToolbar);
            this.nsToolbar.setDisplayMode(2L);
            NSWindow window = this.parent.view.window();
            window.setToolbar(this.nsToolbar);
            this.nsToolbar.setVisible(true);
            NSArray views = window.contentView().superview().subviews();
            int i2 = 0;
            while ((long)i2 < views.count()) {
                id id2 = views.objectAtIndex(i2);
                if (new NSObject(id2).className().getString().equals("NSToolbarView")) {
                    this.view = new NSView(id2);
                    OS.object_setClass(this.view.id, OS.objc_getClass("SWTToolbarView"));
                    this.view.retain();
                    break;
                }
                ++i2;
            }
            this.style &= 0xFFFEFFFF;
        } else {
            this.state |= 0x800;
            if (this.hasBorder()) {
                NSRect rect = new NSRect();
                NSScrollView scrollWidget = (NSScrollView)new SWTScrollView().alloc();
                scrollWidget.initWithFrame(rect);
                scrollWidget.setDrawsBackground(false);
                scrollWidget.setBorderType(2L);
                this.scrollView = scrollWidget;
            }
            NSView widget = (NSView)new SWTView().alloc();
            widget.init();
            this.view = widget;
            if (this.scrollView != null) {
                this.view.setAutoresizingMask(18L);
            }
        }
    }

    void createItem(ToolItem item2, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ToolItem[] newItems = new ToolItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        item2.createWidget();
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item2;
        if (this.nsToolbar != null) {
            this.nsToolbar.insertItemWithItemIdentifier(item2.getItemID(), index);
        } else {
            this.view.addSubview(item2.view);
        }
        this.relayout();
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.itemCount = 0;
    }

    @Override
    NSFont defaultNSFont() {
        return NSFont.systemFontOfSize(11.0);
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.nsToolbar != null) {
            this.display.removeWidget(this.nsToolbar);
        }
    }

    void destroyItem(ToolItem item2) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item2) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        if (item2 == this.lastFocus) {
            this.lastFocus = null;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        if (this.nsToolbar != null) {
            this.nsToolbar.removeItemAtIndex(index);
        } else {
            item2.view.removeFromSuperview();
        }
        this.relayout();
    }

    @Override
    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        if (this.background != null) {
            this.fillBackground(this.view, context, rect, -1);
        }
    }

    @Override
    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        int i2 = 0;
        while (i2 < this.itemCount) {
            ToolItem item2 = this.items[i2];
            if (item2 != null) {
                item2.enableWidget(enabled && item2.getEnabled());
            }
            ++i2;
        }
    }

    @Override
    Widget findTooltip(NSPoint pt) {
        pt = this.view.convertPoint_fromView_(pt, null);
        int i2 = 0;
        while (i2 < this.itemCount) {
            ToolItem item2 = this.items[i2];
            if (OS.NSPointInRect(pt, item2.view.frame())) {
                return item2;
            }
            ++i2;
        }
        return super.findTooltip(pt);
    }

    @Override
    void setZOrder() {
        if (this.nsToolbar != null) {
            return;
        }
        super.setZOrder();
    }

    @Override
    public Rectangle getBounds() {
        this.checkWidget();
        if (this.nsToolbar != null) {
            NSRect rect = this.view.frame();
            rect = this.view.convertRect_toView_(rect, null);
            return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
        }
        return super.getBounds();
    }

    @Override
    boolean forceFocus(NSView focusView) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        ToolItem[] items = this.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            ToolItem item2 = items[i2];
            if (item2.setFocus()) {
                this.lastFocus = item2;
                return true;
            }
            ++i2;
        }
        return false;
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemCount) {
            return this.items[index];
        }
        this.error(6);
        return null;
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int i2 = 0;
        while (i2 < this.itemCount) {
            Rectangle rect = this.items[i2].getBounds();
            if (rect.contains(point)) {
                return this.items[i2];
            }
            ++i2;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        ToolItem[] result2 = new ToolItem[this.itemCount];
        System.arraycopy(this.items, 0, result2, 0, this.itemCount);
        return result2;
    }

    public int getRowCount() {
        this.checkWidget();
        Rectangle rect = this.getClientArea();
        return this.layout(rect.width, rect.height, false)[0];
    }

    @Override
    boolean hasKeyboardFocus(long inId) {
        return this.hasFocus();
    }

    public int indexOf(ToolItem item2) {
        this.checkWidget();
        if (item2 == null) {
            this.error(4);
        }
        if (item2.isDisposed()) {
            this.error(5);
        }
        int i2 = 0;
        while (i2 < this.itemCount) {
            if (this.items[i2] == item2) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    int[] layoutHorizontal(int width, int height, boolean resize) {
        int xSpacing = 0;
        int ySpacing = 2;
        int marginWidth = 0;
        int marginHeight = 0;
        int x = marginWidth;
        int y = marginHeight;
        int maxX = 0;
        int rows = 1;
        boolean wrap = (this.style & 0x40) != 0;
        int itemHeight = 0;
        Point[] sizes = new Point[this.itemCount];
        int i2 = 0;
        while (i2 < this.itemCount) {
            Point size = sizes[i2] = this.items[i2].computeSize();
            itemHeight = Math.max(itemHeight, size.y);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.itemCount) {
            ToolItem item2 = this.items[i2];
            Point size = sizes[i2];
            if (wrap && i2 != 0 && x + size.x > width) {
                ++rows;
                x = marginWidth;
                y += ySpacing + itemHeight;
            }
            if (resize) {
                item2.setBounds(x, y, size.x, itemHeight);
                boolean visible = x + size.x <= width && y + itemHeight <= height;
                item2.setVisible(visible);
                Control control = item2.control;
                if (control != null) {
                    control.setBounds(x, y, size.x, itemHeight);
                }
            }
            maxX = Math.max(maxX, x += xSpacing + size.x);
            ++i2;
        }
        return new int[]{rows, maxX, y + itemHeight};
    }

    int[] layoutUnified(int width, int height, boolean resize) {
        int x = 0;
        int y = 0;
        int itemHeight = 0;
        int maxX = 0;
        Point[] sizes = new Point[this.itemCount];
        NSRect[] containerRects = new NSRect[this.itemCount];
        NSArray itemViewers = new NSView(this.view.subviews().objectAtIndex(0L)).subviews();
        int i2 = 0;
        while (i2 < this.itemCount) {
            Point size = sizes[i2] = this.items[i2].computeSize();
            containerRects[i2] = new NSView(itemViewers.objectAtIndex(i2)).frame();
            if (i2 == 0) {
                x = (int)containerRects[0].x;
            }
            itemHeight = Math.max(itemHeight, size.y);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.itemCount) {
            ToolItem item2 = this.items[i2];
            Point size = sizes[i2];
            if (resize) {
                item2.setBounds(0, 0, size.x, itemHeight);
                Control control = item2.control;
                if (control != null) {
                    control.setBounds(x, y, size.x, itemHeight);
                }
            }
            x = (int)((double)x + containerRects[i2].width);
            maxX = Math.max(maxX, x);
            ++i2;
        }
        return new int[]{1, maxX, itemHeight};
    }

    int[] layoutVertical(int width, int height, boolean resize) {
        int xSpacing = 2;
        int ySpacing = 0;
        int marginWidth = 0;
        int marginHeight = 0;
        int x = marginWidth;
        int y = marginHeight;
        int maxY = 0;
        int cols = 1;
        boolean wrap = (this.style & 0x40) != 0;
        int itemWidth = 0;
        Point[] sizes = new Point[this.itemCount];
        int i2 = 0;
        while (i2 < this.itemCount) {
            Point size = sizes[i2] = this.items[i2].computeSize();
            itemWidth = Math.max(itemWidth, size.x);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.itemCount) {
            ToolItem item2 = this.items[i2];
            Point size = sizes[i2];
            if (wrap && i2 != 0 && y + size.y > height) {
                ++cols;
                x += xSpacing + itemWidth;
                y = marginHeight;
            }
            if (resize) {
                item2.setBounds(x, y, itemWidth, size.y);
                boolean visible = x + itemWidth <= width && y + size.y <= height;
                item2.setVisible(visible);
                Control control = item2.control;
                if (control != null) {
                    control.setBounds(x, y, itemWidth, size.y);
                }
            }
            maxY = Math.max(maxY, y += ySpacing + size.y);
            ++i2;
        }
        return new int[]{cols, x + itemWidth, maxY};
    }

    int[] layout(int nWidth, int nHeight, boolean resize) {
        if (this.nsToolbar != null) {
            return this.layoutUnified(nWidth, nHeight, resize);
        }
        if ((this.style & 0x200) != 0) {
            return this.layoutVertical(nWidth, nHeight, resize);
        }
        return this.layoutHorizontal(nWidth, nHeight, resize);
    }

    @Override
    void register() {
        super.register();
        if (this.nsToolbar != null) {
            this.display.addWidget(this.nsToolbar, this);
        }
    }

    void relayout() {
        if (!this.getDrawing()) {
            return;
        }
        Rectangle rect = this.getClientArea();
        this.layout(rect.width, rect.height, true);
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.itemCount) {
                ToolItem item2 = this.items[i2];
                if (item2 != null && !item2.isDisposed()) {
                    item2.release(false);
                }
                ++i2;
            }
            this.itemCount = 0;
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.nsToolbar != null) {
            this.nsToolbar.release();
            this.nsToolbar = null;
        }
        if (this.accessibilityAttributes != null) {
            this.accessibilityAttributes.release();
        }
        this.accessibilityAttributes = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        int i2 = 0;
        while (i2 < this.itemCount) {
            ToolItem item2 = this.items[i2];
            if (item2.control == control) {
                item2.setControl(null);
            }
            ++i2;
        }
    }

    @Override
    void resized() {
        super.resized();
        this.relayout();
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.items.length) {
                ToolItem item2 = this.items[i2];
                if (item2 != null) {
                    item2.reskin(flags);
                }
                ++i2;
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    boolean sendMouseEvent(NSEvent nsEvent, int type2, boolean send) {
        switch (type2) {
            case 5: 
            case 6: {
                NSPoint windowPoint = NSEvent.mouseLocation();
                windowPoint = this.view.window().convertScreenToBase(windowPoint);
                int i2 = 0;
                while (i2 < this.itemCount) {
                    ToolItem item2 = this.items[i2];
                    int currState = item2.state;
                    NSPoint viewPoint = item2.view.convertPoint_fromView_(windowPoint, null);
                    item2.state = item2.view.mouse(viewPoint, item2.view.bounds()) ? (item2.state |= 0x20) : (item2.state &= 0xFFFFFFDF);
                    if (currState != item2.state) {
                        item2.updateImage(true);
                    }
                    ++i2;
                }
                break;
            }
            case 7: {
                int i3 = 0;
                while (i3 < this.itemCount) {
                    ToolItem item3 = this.items[i3];
                    int currState = item3.state;
                    item3.state &= 0xFFFFFFDF;
                    if (currState != item3.state) {
                        item3.updateImage(true);
                    }
                    ++i3;
                }
                break;
            }
        }
        return super.sendMouseEvent(nsEvent, type2, send);
    }

    @Override
    void setBounds(int x, int y, int width, int height, boolean move2, boolean resize) {
        if (this.nsToolbar != null) {
            return;
        }
        super.setBounds(x, y, width, height, move2, resize);
    }

    @Override
    void setFont(NSFont font) {
        int i2 = 0;
        while (i2 < this.itemCount) {
            ToolItem item2 = this.items[i2];
            if (item2.button != null) {
                item2.button.setAttributedTitle(item2.createString());
            }
            ++i2;
        }
    }

    @Override
    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0) {
            this.relayout();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.nsToolbar != null) {
            this.nsToolbar.setVisible(visible);
        }
        super.setVisible(visible);
    }

    @Override
    long toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(long id2, long sel, long toolbar2, long itemIdentifier, boolean flag) {
        NSString itemID = new NSString(itemIdentifier);
        int j = 0;
        while (j < this.itemCount) {
            ToolItem item2 = this.items[j];
            if (itemID.isEqual(item2.nsItem.itemIdentifier())) {
                return item2.nsItem.id;
            }
            ++j;
        }
        return 0L;
    }

    @Override
    long toolbarAllowedItemIdentifiers(long id2, long sel, long toolbar2) {
        NSMutableArray array = NSMutableArray.arrayWithCapacity(this.itemCount);
        int i2 = 0;
        while (i2 < this.itemCount) {
            array.addObject(this.items[i2].nsItem.itemIdentifier());
            ++i2;
        }
        return array.id;
    }

    @Override
    long toolbarDefaultItemIdentifiers(long id2, long sel, long toolbar2) {
        return this.toolbarAllowedItemIdentifiers(id2, sel, toolbar2);
    }

    @Override
    long toolbarSelectableItemIdentifiers(long id2, long sel, long toolbar2) {
        NSMutableArray array = NSMutableArray.arrayWithCapacity(this.itemCount);
        int i2 = 0;
        while (i2 < this.itemCount) {
            if ((this.items[i2].style & 0x10) != 0) {
                array.addObject(this.items[i2].nsItem.itemIdentifier());
            }
            ++i2;
        }
        return array.id;
    }

    @Override
    boolean translateTraversal(int key2, NSEvent theEvent, boolean[] consume2) {
        boolean result2 = super.translateTraversal(key2, theEvent, consume2);
        if (result2) {
            return result2;
        }
        boolean next = false;
        boolean checkPopup = false;
        switch (key2) {
            case 123: {
                next = false;
                break;
            }
            case 124: {
                next = true;
                break;
            }
            case 126: {
                next = false;
                checkPopup = true;
                break;
            }
            case 125: {
                next = true;
                checkPopup = true;
                break;
            }
            default: {
                return false;
            }
        }
        consume2[0] = true;
        if (checkPopup && this.lastFocus != null && this.lastFocus.handleKeyDown()) {
            return false;
        }
        ToolItem[] items = this.getItems();
        ToolItem item2 = this.lastFocus;
        int length = items.length;
        int index = 0;
        while (index < length) {
            if (items[index] == item2) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            ToolItem child = items[index];
            if (child.isDisposed() || !child.setFocus()) continue;
            this.lastFocus = child;
            return false;
        }
        return false;
    }
}

