/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSearchField;
import org.eclipse.swt.internal.cocoa.NSSearchFieldCell;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSUndoManager;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTSearchField;
import org.eclipse.swt.internal.cocoa.SWTSearchFieldCell;
import org.eclipse.swt.internal.cocoa.SWTSecureTextField;
import org.eclipse.swt.internal.cocoa.SWTTextField;
import org.eclipse.swt.internal.cocoa.SWTTextView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int textLimit = LIMIT;
    int tabs = 8;
    char echoCharacter;
    boolean doubleClick;
    boolean receivingFocus;
    char[] hiddenText;
    String message;
    NSRange selectionRange;
    id targetSearch;
    id targetCancel;
    long actionSearch;
    long actionCancel;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\r";
    static final char PASSWORD = '\u2022';

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
        if ((style & 0x80) != 0) {
            NSSearchFieldCell cell = new NSSearchFieldCell(((NSSearchField)this.view).cell());
            if ((style & 0x100) != 0) {
                this.style |= 0x100;
                NSButtonCell cancelCell = cell.cancelButtonCell();
                this.targetCancel = cancelCell.target();
                this.actionCancel = cancelCell.action();
                cancelCell.setTarget(this.view);
                cancelCell.setAction(OS.sel_sendCancelSelection);
            } else {
                cell.setCancelButtonCell(null);
            }
            if ((style & 0x200) != 0) {
                this.style |= 0x200;
                NSButtonCell searchCell = cell.searchButtonCell();
                this.targetSearch = searchCell.target();
                this.actionSearch = searchCell.action();
                searchCell.setTarget(this.view);
                searchCell.setAction(OS.sel_sendSearchSelection);
            } else {
                cell.setSearchButtonCell(null);
            }
        }
    }

    public void addModifyListener(ModifyListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(listener2));
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(25, typedListener);
    }

    public void append(String string2) {
        int charCount;
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string2 = this.verifyText(string2, charCount = this.getCharCount(), charCount, null)) == null) {
            return;
        }
        if ((this.style & 4) != 0) {
            this.setSelection(this.getCharCount());
            this.insertEditText(string2);
        } else {
            NSString str = this.textLimit != LIMIT ? this.getInsertString(string2, null) : NSString.stringWith(string2);
            NSTextView widget = (NSTextView)this.view;
            NSTextStorage storage2 = widget.textStorage();
            NSRange range = new NSRange();
            range.location = storage2.length();
            storage2.replaceCharactersInRange(range, str);
            range.location = storage2.length();
            widget.scrollRangeToVisible(range);
            widget.setSelectedRange(range);
        }
        if (string2.length() != 0) {
            this.sendEvent(24);
        }
    }

    @Override
    boolean becomeFirstResponder(long id2, long sel) {
        this.receivingFocus = true;
        boolean result2 = super.becomeFirstResponder(id2, sel);
        this.receivingFocus = false;
        return result2;
    }

    static int checkStyle(int style) {
        if ((style & 0x80) != 0) {
            style |= 0x804;
            style &= 0xFFBFFFFF;
        }
        if ((style & 4) != 0 && (style & 2) != 0) {
            style &= 0xFFFFFFFD;
        }
        if (((style = Text.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
            style &= 0xFFFFFEFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    public void clearSelection() {
        this.checkWidget();
        Point selection2 = this.getSelection();
        this.setSelection(selection2.x);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed2) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 4) != 0) {
            NSCell cell = ((NSTextField)this.view).cell();
            NSSize size = cell.cellSize();
            NSString str = ((NSTextField)this.view).stringValue();
            if (str.length() > 0L) {
                width = (int)Math.ceil(size.width);
            }
            height = (int)Math.ceil(size.height);
            Point border = null;
            if ((this.style & 0x800) != 0 && (wHint != -1 || hHint != -1)) {
                NSRect insets = cell.titleRectForBounds(new NSRect());
                border = new Point(-((int)Math.ceil(insets.width)), -((int)Math.ceil(insets.height)));
                width -= border.x;
                height -= border.y;
            }
            if (width <= 0) {
                width = 64;
            }
            if (height <= 0) {
                height = 64;
            }
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            if (border != null) {
                width += border.x;
                height += border.y;
            }
        } else {
            NSLayoutManager layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            NSTextContainer textContainer = (NSTextContainer)new NSTextContainer().alloc();
            NSSize size = new NSSize();
            size.height = 5000000.0;
            size.width = 5000000.0;
            if ((this.style & 0x40) != 0) {
                if (wHint != -1) {
                    size.width = wHint;
                }
                if (hHint != -1) {
                    size.height = hHint;
                }
            }
            textContainer.initWithContainerSize(size);
            layoutManager.addTextContainer(textContainer);
            NSTextStorage textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            textStorage.setAttributedString(((NSTextView)this.view).textStorage());
            layoutManager.setTextStorage(textStorage);
            layoutManager.glyphRangeForTextContainer(textContainer);
            NSRect rect = layoutManager.usedRectForTextContainer(textContainer);
            width = layoutManager.numberOfGlyphs() == 0L ? 64 : (int)Math.ceil(rect.width);
            height = (int)Math.ceil(rect.height);
            textStorage.release();
            textContainer.release();
            layoutManager.release();
            if (width <= 0) {
                width = 64;
            }
            if (height <= 0) {
                height = 64;
            }
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            Rectangle trim = this.computeTrim(0, 0, width, height);
            width = trim.width;
            height = trim.height;
        }
        return new Point(width, height);
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle result2 = super.computeTrim(x, y, width, height);
        if ((this.style & 4) != 0) {
            NSTextField widget = (NSTextField)this.view;
            if ((this.style & 0x80) != 0) {
                NSSearchFieldCell cell = new NSSearchFieldCell(widget.cell());
                int testWidth = 100;
                NSRect rect = new NSRect();
                rect.width = testWidth;
                rect = cell.searchTextRectForBounds(rect);
                int leftIndent = (int)rect.x;
                int rightIndent = testWidth - leftIndent - (int)Math.ceil(rect.width);
                result2.x -= leftIndent;
                result2.width += leftIndent + rightIndent;
            }
            NSRect inset = widget.cell().titleRectForBounds(new NSRect());
            result2.x = (int)((double)result2.x - inset.x);
            result2.y = (int)((double)result2.y - inset.y);
            result2.width = (int)((double)result2.width - inset.width);
            result2.height = (int)((double)result2.height - inset.height);
        }
        return result2;
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0 || this.echoCharacter != '\u0000') {
            return;
        }
        if ((this.style & 4) != 0) {
            Point selection2 = this.getSelection();
            if (selection2.x == selection2.y) {
                return;
            }
            this.copyToClipboard(this.getEditText(selection2.x, selection2.y - 1));
        } else {
            NSText text2 = (NSText)this.view;
            if (text2.selectedRange().length == 0L) {
                return;
            }
            text2.copy(null);
        }
    }

    @Override
    void createHandle() {
        if ((this.style & 8) != 0 && (this.style & 0xB00) == 0) {
            this.state |= 0x800;
        }
        if ((this.style & 4) != 0) {
            int align;
            NSTextField widget = (this.style & 0x400000) != 0 ? (NSTextField)new SWTSecureTextField().alloc() : ((this.style & 0x80) != 0 ? (NSTextField)new SWTSearchField().alloc() : (NSTextField)new SWTTextField().alloc());
            widget.init();
            widget.setSelectable(true);
            widget.setEditable((this.style & 8) == 0);
            if ((this.style & 0x800) == 0) {
                widget.setFocusRingType(1L);
                widget.setBordered(false);
            }
            int n = align = (this.style & 0x80) != 0 ? 3 : 0;
            if ((this.style & 0x1000000) != 0) {
                align = 2;
            }
            if ((this.style & 0x20000) != 0) {
                align = 1;
            }
            widget.setAlignment(align);
            NSCell cell = widget.cell();
            cell.setWraps(false);
            cell.setScrollable(true);
            this.view = widget;
        } else {
            NSScrollView scrollWidget = (NSScrollView)new SWTScrollView().alloc();
            scrollWidget.init();
            scrollWidget.setHasVerticalScroller((this.style & 0x200) != 0);
            scrollWidget.setHasHorizontalScroller((this.style & 0x100) != 0);
            scrollWidget.setAutoresizesSubviews(true);
            if ((this.style & 0x800) != 0) {
                scrollWidget.setBorderType(2L);
            }
            NSTextView widget = (NSTextView)new SWTTextView().alloc();
            widget.init();
            widget.setEditable((this.style & 8) == 0);
            widget.setAllowsUndo(true);
            NSSize size = new NSSize();
            size.height = 3.4028234663852886E38;
            size.width = 3.4028234663852886E38;
            widget.setMaxSize(size);
            widget.setAutoresizingMask(18L);
            if ((this.style & 0x40) == 0) {
                NSTextContainer textContainer = widget.textContainer();
                widget.setHorizontallyResizable(true);
                textContainer.setWidthTracksTextView(false);
                NSSize csize = new NSSize();
                csize.height = 3.4028234663852886E38;
                csize.width = 3.4028234663852886E38;
                textContainer.setContainerSize(csize);
            }
            int align = 0;
            if ((this.style & 0x1000000) != 0) {
                align = 2;
            }
            if ((this.style & 0x20000) != 0) {
                align = 1;
            }
            widget.setAlignment(align);
            widget.setRichText(false);
            widget.setDelegate(widget);
            widget.setFont(this.display.getSystemFont().handle);
            widget.setUsesFontPanel(false);
            this.view = widget;
            this.scrollView = scrollWidget;
        }
    }

    @Override
    void createWidget() {
        super.createWidget();
        if ((this.style & 0x400000) != 0) {
            NSText fieldEditor = this.view.window().fieldEditor(true, this.view);
            long nsSecureTextViewClass = OS.objc_lookUpClass("NSSecureTextView");
            if (fieldEditor != null && nsSecureTextViewClass != 0L && fieldEditor.isKindOfClass(nsSecureTextViewClass)) {
                long editorClass = OS.objc_getClass("SWTSecureEditorView");
                OS.object_setClass(fieldEditor.id, editorClass);
            }
        }
        this.doubleClick = true;
        this.message = "";
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        if ((this.style & 0x400000) != 0 || this.echoCharacter != '\u0000') {
            return;
        }
        boolean cut = true;
        char[] oldText = null;
        Point oldSelection = this.getSelection();
        if ((this.hooks(25) || this.filters(25)) && oldSelection.x != oldSelection.y) {
            oldText = this.getEditText(oldSelection.x, oldSelection.y - 1);
            String newText = this.verifyText("", oldSelection.x, oldSelection.y, null);
            if (newText == null) {
                return;
            }
            if (newText.length() != 0) {
                this.copyToClipboard(oldText);
                if ((this.style & 4) != 0) {
                    this.insertEditText(newText);
                } else {
                    NSTextView widget = (NSTextView)this.view;
                    widget.replaceCharactersInRange(widget.selectedRange(), NSString.stringWith(newText));
                }
                cut = false;
            }
        }
        if (cut) {
            if ((this.style & 4) != 0) {
                if (oldText == null) {
                    oldText = this.getEditText(oldSelection.x, oldSelection.y - 1);
                }
                this.copyToClipboard(oldText);
                this.insertEditText("");
            } else {
                ((NSTextView)this.view).cut(null);
            }
        }
        Point newSelection = this.getSelection();
        if (!cut || !oldSelection.equals(newSelection)) {
            this.sendEvent(24);
        }
    }

    @Override
    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    @Override
    NSFont defaultNSFont() {
        if ((this.style & 2) != 0) {
            return this.display.textViewFont;
        }
        if ((this.style & 0x80) != 0) {
            return this.display.searchFieldFont;
        }
        if ((this.style & 0x400000) != 0) {
            return this.display.secureTextFieldFont;
        }
        return this.display.textFieldFont;
    }

    @Override
    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    @Override
    void deregister() {
        super.deregister();
        if ((this.style & 4) != 0) {
            this.display.removeWidget(((NSControl)this.view).cell());
        }
    }

    @Override
    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        if ((this.style & 4) != 0) {
            NSText text2;
            if (this.backgroundImage == null) {
                return;
            }
            if (new NSView(id2).isKindOfClass(OS.class_NSText) && !(text2 = new NSText(id2)).isFieldEditor()) {
                return;
            }
        }
        if ((this.style & 2) != 0 && id2 != this.scrollView.id) {
            return;
        }
        this.fillBackground(this.view, context, rect, -1);
    }

    @Override
    void drawInteriorWithFrame_inView(long id2, long sel, NSRect cellFrame, long viewid) {
        Image image;
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if ((image = control.backgroundImage) != null && !image.isDisposed()) {
            NSGraphicsContext context = NSGraphicsContext.currentContext();
            control.fillBackground(this.view, context, cellFrame, -1);
        } else if ((this.style & 0x80) != 0) {
            this.drawInteriorWithFrame_inView_searchfield(id2, sel, cellFrame, viewid);
        }
        super.drawInteriorWithFrame_inView(id2, sel, cellFrame, viewid);
    }

    void drawInteriorWithFrame_inView_searchfield(long id2, long sel, NSRect cellFrame, long viewid) {
        if (this.background == null) {
            return;
        }
        double searchFieldHeight = 22.0;
        double borderWidth = 1.0;
        NSRect frameRect = new NSRect();
        frameRect.x = cellFrame.x + borderWidth;
        frameRect.width = cellFrame.width - 2.0 * borderWidth;
        if (cellFrame.height <= searchFieldHeight) {
            frameRect.height = cellFrame.height - 2.0 * borderWidth;
            frameRect.y = cellFrame.y + borderWidth;
        } else {
            frameRect.height = searchFieldHeight - 2.0 * borderWidth;
            frameRect.y = cellFrame.y + (cellFrame.height - frameRect.height) / 2.0;
        }
        NSBezierPath path2 = NSBezierPath.bezierPathWithRoundedRect(frameRect, 2.0, 2.0);
        NSColor bgColor = NSColor.colorWithDeviceRed(this.background[0], this.background[1], this.background[2], this.background[3]);
        bgColor.setFill();
        path2.fill();
        NSSearchField searchField = (NSSearchField)this.view;
        NSCell _cell = searchField.cell();
        SWTSearchFieldCell cell = new SWTSearchFieldCell(_cell.id);
        if (cell.searchButtonCell() != null) {
            cell.searchButtonCell().drawInteriorWithFrame(cell.searchButtonRectForBounds(cellFrame), this.view);
        }
        if (cell.cancelButtonCell() != null && ((NSSearchField)this.view).stringValue().length() > 0L) {
            cell.cancelButtonCell().drawInteriorWithFrame(cell.cancelButtonRectForBounds(cellFrame), this.view);
        }
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter2, boolean[] consume2) {
        long position;
        Point selection2 = this.getSelection();
        if (selection2.x != selection2.y && (long)selection2.x <= (position = this.getPosition(x, y)) && position < (long)selection2.y && super.dragDetect(x, y, filter2, consume2)) {
            if (consume2 != null) {
                consume2[0] = true;
            }
            return true;
        }
        return false;
    }

    @Override
    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        if ((this.style & 2) != 0) {
            this.setForeground(this.foreground);
        }
    }

    @Override
    Cursor findCursor() {
        Cursor cursor = super.findCursor();
        return cursor != null ? cursor : this.display.getSystemCursor(19);
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return (this.getTopPixel() + this.getCaretLocation().y) / this.getLineHeight();
    }

    @Override
    boolean acceptsFirstResponder(long id2, long sel) {
        if ((this.style & 8) != 0) {
            return true;
        }
        return super.acceptsFirstResponder(id2, sel);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        NSTextView widget = null;
        if ((this.style & 4) != 0) {
            if (this.hasFocus()) {
                widget = new NSTextView(this.view.window().fieldEditor(true, this.view));
            }
        } else {
            widget = (NSTextView)this.view;
        }
        if (widget == null) {
            return new Point(0, 0);
        }
        NSLayoutManager layoutManager = widget.layoutManager();
        NSTextContainer container = widget.textContainer();
        NSRange range = widget.selectedRange();
        long[] rectCount = new long[1];
        long pArray = layoutManager.rectArrayForCharacterRange(range, range, container, rectCount);
        NSRect rect = new NSRect();
        if (rectCount[0] > 0L) {
            OS.memmove(rect, pArray, (long)NSRect.sizeof);
        }
        return new Point((int)rect.x, (int)rect.y);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return this.selectionRange != null ? (int)this.selectionRange.location : 0;
        }
        NSRange range = ((NSTextView)this.view).selectedRange();
        return (int)range.location;
    }

    public int getCharCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return (int)((NSControl)this.view).stringValue().length();
        }
        return (int)((NSTextView)this.view).textStorage().length();
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.echoCharacter;
    }

    public boolean getEditable() {
        this.checkWidget();
        return (this.style & 8) == 0;
    }

    char[] getEditText() {
        if (this.hiddenText != null) {
            char[] text2 = new char[this.hiddenText.length];
            System.arraycopy(this.hiddenText, 0, text2, 0, text2.length);
            return text2;
        }
        NSString str = null;
        str = (this.style & 4) != 0 ? ((NSTextField)this.view).stringValue() : ((NSTextView)this.view).textStorage().string();
        int length = (int)str.length();
        char[] buffer = new char[length];
        NSRange range = new NSRange();
        range.length = length;
        str.getCharacters(buffer, range);
        return buffer;
    }

    char[] getEditText(int start, int end) {
        NSString str = null;
        str = (this.style & 4) != 0 ? ((NSTextField)this.view).stringValue() : ((NSTextView)this.view).textStorage().string();
        int length = (int)str.length();
        if (start > (end = Math.min(end, length - 1))) {
            return new char[0];
        }
        start = Math.max(0, start);
        NSRange range = new NSRange();
        range.location = start;
        range.length = Math.max(0, end - start + 1);
        char[] buffer = new char[(int)range.length];
        if (this.hiddenText != null) {
            System.arraycopy(this.hiddenText, (int)range.location, buffer, 0, buffer.length);
        } else {
            str.getCharacters(buffer, range);
        }
        return buffer;
    }

    NSString getInsertString(String string2, NSRange range) {
        int selectionLength;
        int charCount = this.getCharCount();
        int length = string2.length();
        int n = selectionLength = range != null ? (int)range.length : 0;
        if (charCount - selectionLength + length > this.textLimit) {
            length = this.textLimit - charCount + selectionLength;
            length = Math.max(0, length);
        }
        char[] buffer = new char[length];
        string2.getChars(0, buffer.length, buffer, 0);
        NSString str = NSString.stringWithCharacters(buffer, buffer.length);
        return str;
    }

    public int getLineCount() {
        long c;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        NSTextStorage storage2 = ((NSTextView)this.view).textStorage();
        int count = (int)storage2.paragraphs().count();
        NSString string2 = storage2.string();
        long length = string2.length();
        if (length == 0L || (c = string2.characterAtIndex(length - 1L)) == 10L || c == 13L) {
            ++count;
        }
        return count;
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        Font font;
        this.checkWidget();
        Font font2 = font = this.font != null ? this.font : this.defaultFont();
        if ((this.style & 4) != 0) {
            NSDictionary dict = NSDictionary.dictionaryWithObject(font.handle, OS.NSFontAttributeName);
            NSString str = NSString.stringWith(" ");
            NSAttributedString attribStr = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(str, dict);
            NSSize size = attribStr.size();
            attribStr.release();
            return (int)size.height;
        }
        NSTextView widget = (NSTextView)this.view;
        return (int)Math.ceil(widget.layoutManager().defaultLineHeightForFont(font.handle));
    }

    @Override
    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    long getPosition(long x, long y) {
        if ((this.style & 2) != 0) {
            NSTextView widget = (NSTextView)this.view;
            NSPoint viewLocation = new NSPoint();
            viewLocation.x = x;
            viewLocation.y = y;
            return widget.characterIndexForInsertionAtPoint(viewLocation);
        }
        return 0L;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (this.selectionRange == null) {
                NSString str = ((NSTextField)this.view).stringValue();
                return new Point((int)str.length(), (int)str.length());
            }
            return new Point((int)this.selectionRange.location, (int)(this.selectionRange.location + this.selectionRange.length));
        }
        NSTextView widget = (NSTextView)this.view;
        NSRange range = widget.selectedRange();
        return new Point((int)range.location, (int)(range.location + range.length));
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return this.selectionRange != null ? (int)this.selectionRange.length : 0;
        }
        NSTextView widget = (NSTextView)this.view;
        NSRange range = widget.selectedRange();
        return (int)range.length;
    }

    public String getSelectionText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            Point selection2 = this.getSelection();
            if (selection2.x == selection2.y) {
                return "";
            }
            return new String(this.getEditText(selection2.x, selection2.y - 1));
        }
        NSTextView widget = (NSTextView)this.view;
        NSRange range = widget.selectedRange();
        NSString str = widget.textStorage().string();
        char[] buffer = new char[(int)range.length];
        str.getCharacters(buffer, range);
        return new String(buffer);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return new String(this.getEditText());
        }
        NSString str = ((NSTextView)this.view).textStorage().string();
        return str.getString();
    }

    public String getText(int start, int end) {
        this.checkWidget();
        if (start > end || end < 0) {
            return "";
        }
        if ((this.style & 4) != 0) {
            return new String(this.getEditText(start, end));
        }
        NSTextStorage storage2 = ((NSTextView)this.view).textStorage();
        if (start > (end = Math.min(end, (int)storage2.length() - 1))) {
            return "";
        }
        start = Math.max(0, start);
        NSRange range = new NSRange();
        range.location = start;
        range.length = end - start + 1;
        NSAttributedString substring = storage2.attributedSubstringFromRange(range);
        NSString string2 = substring.string();
        return string2.getString();
    }

    public char[] getTextChars() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return this.getEditText();
        }
        NSString str = ((NSTextView)this.view).textStorage().string();
        int length = (int)str.length();
        char[] buffer = new char[length];
        NSRange range = new NSRange();
        range.length = length;
        str.getCharacters(buffer, range);
        return buffer;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return this.getTopPixel() / this.getLineHeight();
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return (int)this.scrollView.contentView().bounds().y;
    }

    public void insert(String string2) {
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            Point selection2 = this.getSelection();
            if ((string2 = this.verifyText(string2, selection2.x, selection2.y, null)) == null) {
                return;
            }
        }
        if ((this.style & 4) != 0) {
            this.insertEditText(string2);
        } else {
            NSTextView widget = (NSTextView)this.view;
            NSRange range = widget.selectedRange();
            NSString str = this.textLimit != LIMIT ? this.getInsertString(string2, range) : NSString.stringWith(string2);
            widget.textStorage().replaceCharactersInRange(range, str);
        }
        if (string2.length() != 0) {
            this.sendEvent(24);
        }
    }

    void insertEditText(String string2) {
        int length = string2.length();
        Point selection2 = this.getSelection();
        if (this.hasFocus() && this.hiddenText == null) {
            int charCount;
            if (this.textLimit != LIMIT && (charCount = this.getCharCount()) - (selection2.y - selection2.x) + length > this.textLimit) {
                length = this.textLimit - charCount + (selection2.y - selection2.x);
                length = Math.max(0, length);
            }
            char[] buffer = new char[length];
            string2.getChars(0, buffer.length, buffer, 0);
            NSString nsstring = NSString.stringWithCharacters(buffer, buffer.length);
            NSText fieldEditor = ((NSTextField)this.view).currentEditor();
            if (fieldEditor != null) {
                fieldEditor.replaceCharactersInRange(fieldEditor.selectedRange(), nsstring);
            }
            this.selectionRange = null;
        } else {
            int charCount;
            String oldText = this.getText();
            if (this.textLimit != LIMIT && (charCount = oldText.length()) - (selection2.y - selection2.x) + length > this.textLimit) {
                string2 = string2.substring(0, this.textLimit - charCount + (selection2.y - selection2.x));
            }
            String newText = String.valueOf(oldText.substring(0, selection2.x)) + string2 + oldText.substring(selection2.y);
            this.setEditText(newText);
            this.setSelection(selection2.x + string2.length());
        }
    }

    @Override
    boolean isEventView(long id2) {
        if ((this.style & 2) != 0) {
            return super.isEventView(id2);
        }
        return true;
    }

    @Override
    boolean isNeeded(ScrollBar scrollbar) {
        boolean result2 = false;
        if ((this.style & 2) != 0) {
            NSRect docFrame = this.scrollView.documentView().frame();
            NSRect contentFrame = this.scrollView.contentView().frame();
            result2 = (scrollbar.style & 0x200) != 0 ? docFrame.height > contentFrame.height : docFrame.width > contentFrame.width;
        }
        return result2;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        boolean paste = true;
        String oldText = null;
        if ((this.hooks(25) || this.filters(25)) && (oldText = this.getClipboardText()) != null) {
            Point selection2 = this.getSelection();
            String newText = this.verifyText(oldText, selection2.x, selection2.y, null);
            if (newText == null) {
                return;
            }
            if (!newText.equals(oldText)) {
                if ((this.style & 4) != 0) {
                    this.insertEditText(newText);
                } else {
                    NSTextView textView = (NSTextView)this.view;
                    NSRange range = textView.selectedRange();
                    NSString str = this.textLimit != LIMIT ? this.getInsertString(newText, range) : NSString.stringWith(newText);
                    textView.replaceCharactersInRange(range, str);
                }
                paste = false;
            }
        }
        if (paste) {
            if ((this.style & 4) != 0) {
                if (oldText == null) {
                    oldText = this.getClipboardText();
                }
                if (oldText == null) {
                    return;
                }
                this.insertEditText(oldText);
            } else if (this.textLimit != LIMIT) {
                if (oldText == null) {
                    oldText = this.getClipboardText();
                }
                if (oldText == null) {
                    return;
                }
                NSTextView textView = (NSTextView)this.view;
                NSRange range = textView.selectedRange();
                NSString str = this.getInsertString(oldText, range);
                textView.replaceCharactersInRange(range, str);
            } else {
                ((NSTextView)this.view).paste(null);
            }
        }
        this.sendEvent(24);
    }

    @Override
    void register() {
        super.register();
        if ((this.style & 4) != 0) {
            this.display.addWidget(((NSControl)this.view).cell(), this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if ((this.style & 4) != 0) {
            ((NSControl)this.view).abortEditing();
        }
        this.hiddenText = null;
        this.message = null;
        this.selectionRange = null;
    }

    public void removeModifyListener(ModifyListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener2);
    }

    public void removeSegmentListener(SegmentListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, listener2);
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener2);
        this.eventTable.unhook(14, listener2);
    }

    public void removeVerifyListener(VerifyListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener2);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            this.setSelection(0, this.getCharCount());
        } else {
            ((NSTextView)this.view).selectAll(null);
        }
    }

    @Override
    boolean sendKeyEvent(NSEvent nsEvent, int type2) {
        short keyCode;
        boolean result2 = super.sendKeyEvent(nsEvent, type2);
        if (!result2) {
            return result2;
        }
        if (type2 != 1) {
            return result2;
        }
        long modifierFlags = nsEvent.modifierFlags();
        if ((modifierFlags & 0x100000L) != 0L) {
            keyCode = nsEvent.keyCode();
            switch (keyCode) {
                case 7: {
                    if ((this.style & 0x400000) == 0) {
                        this.cut();
                    }
                    return false;
                }
                case 8: {
                    if ((this.style & 0x400000) == 0) {
                        this.copy();
                    }
                    return false;
                }
                case 9: {
                    this.paste();
                    return false;
                }
                case 0: {
                    NSApplication.sharedApplication().sendAction(OS.sel_selectAll_, null, NSApplication.sharedApplication());
                    return false;
                }
            }
        }
        if (this.isDisposed()) {
            return false;
        }
        if ((this.style & 4) != 0) {
            keyCode = nsEvent.keyCode();
            switch (keyCode) {
                case 36: 
                case 76: {
                    this.sendSelectionEvent(14);
                }
            }
        }
        return result2;
    }

    @Override
    boolean sendKeyEvent(int type2, Event event) {
        boolean result2 = super.sendKeyEvent(type2, event);
        if (!result2) {
            return result2;
        }
        if (type2 != 1) {
            return result2;
        }
        if ((event.stateMask & 0x400000) != 0) {
            switch (event.keyCode) {
                case 122: {
                    NSUndoManager undoManager = this.view.undoManager();
                    if (undoManager == null && (this.style & 4) != 0) {
                        NSText fieldEditor = ((NSTextField)this.view).currentEditor();
                        undoManager = fieldEditor.undoManager();
                    }
                    if (undoManager != null) {
                        if ((event.stateMask & 0x20000) != 0) {
                            if (undoManager.canRedo()) {
                                undoManager.redo();
                                return false;
                            }
                        } else if (undoManager.canUndo()) {
                            undoManager.undo();
                            return false;
                        }
                    }
                    return false;
                }
            }
        }
        if (this.isDisposed()) {
            return false;
        }
        return result2;
    }

    @Override
    void sendSearchSelection() {
        if (this.targetSearch != null) {
            ((NSSearchField)this.view).sendAction(this.actionSearch, this.targetSearch);
        }
        Event event = new Event();
        event.detail = 512;
        this.sendSelectionEvent(14, event, false);
    }

    @Override
    void sendCancelSelection() {
        if (this.targetCancel != null) {
            ((NSSearchField)this.view).sendAction(this.actionCancel, this.targetCancel);
        }
        Event event = new Event();
        event.detail = 256;
        this.sendSelectionEvent(14, event, false);
    }

    @Override
    void setBackgroundColor(NSColor nsColor) {
        if ((this.style & 4) != 0) {
            ((NSTextField)this.view).setBackgroundColor(nsColor);
        } else {
            ((NSTextView)this.view).setBackgroundColor(nsColor);
        }
    }

    @Override
    void setBackgroundImage(NSImage image) {
        if ((this.style & 4) != 0) {
            NSTextField widget = (NSTextField)this.view;
            widget.setDrawsBackground(image == null);
        } else {
            ((NSTextView)this.view).setDrawsBackground(image == null);
            this.scrollView.setDrawsBackground(image == null);
        }
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        this.doubleClick = doubleClick;
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((this.style & 0x400000) == 0) {
            Point selection2 = this.getSelection();
            char[] text2 = this.getTextChars();
            this.echoCharacter = echo;
            this.setEditText(text2);
            this.setSelection(selection2);
        }
        this.echoCharacter = echo;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style = editable ? (this.style &= 0xFFFFFFF7) : (this.style |= 8);
        if ((this.style & 4) != 0) {
            ((NSTextField)this.view).setEditable(editable);
        } else {
            ((NSTextView)this.view).setEditable(editable);
        }
    }

    void setEditText(String string2) {
        char[] text2 = new char[string2.length()];
        string2.getChars(0, text2.length, text2, 0);
        this.setEditText(text2);
    }

    void setEditText(char[] text2) {
        char[] buffer;
        int length = Math.min(text2.length, this.textLimit);
        if ((this.style & 0x400000) == 0 && this.echoCharacter != '\u0000') {
            this.hiddenText = new char[length];
            buffer = new char[length];
            int i2 = 0;
            while (i2 < length) {
                this.hiddenText[i2] = text2[i2];
                buffer[i2] = this.echoCharacter;
                ++i2;
            }
        } else {
            this.hiddenText = null;
            buffer = text2;
        }
        NSTextField widget = (NSTextField)this.view;
        NSString nsstring = NSString.stringWithCharacters(buffer, length);
        widget.setStringValue(nsstring);
        NSText fieldEditor = widget.currentEditor();
        if (fieldEditor != null) {
            fieldEditor.setString(nsstring);
        }
        this.selectionRange = null;
    }

    @Override
    void setFrameSize(long id2, long sel, NSSize size) {
        NSArray subviews;
        NSSearchField widget;
        NSText editor;
        super.setFrameSize(id2, sel, size);
        if ((this.style & 0x80) != 0 && (editor = (widget = (NSSearchField)this.view).currentEditor()) != null && (subviews = widget.subviews()).count() > 0L) {
            NSRect rect = widget.cell().drawingRectForBounds(widget.bounds());
            new NSView(subviews.objectAtIndex(0L)).setFrame(rect);
        }
    }

    @Override
    void setFont(NSFont font) {
        if ((this.style & 2) != 0) {
            ((NSTextView)this.view).setFont(font);
            return;
        }
        super.setFont(font);
    }

    @Override
    void setForeground(double[] color) {
        NSColor nsColor;
        if (color == null) {
            nsColor = NSColor.textColor();
            if ((this.style & 2) != 0 && !this.isEnabled()) {
                nsColor = NSColor.disabledControlTextColor();
            }
        } else {
            double alpha = 1.0;
            if ((this.style & 2) != 0 && !this.isEnabled()) {
                alpha = 0.5;
            }
            nsColor = NSColor.colorWithDeviceRed(color[0], color[1], color[2], alpha);
        }
        if ((this.style & 4) != 0) {
            ((NSTextField)this.view).setTextColor(nsColor);
        } else {
            ((NSTextView)this.view).setTextColor(nsColor);
        }
    }

    @Override
    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    @Override
    void setOrientation() {
        int direction;
        int n = direction = (this.style & 0x4000000) != 0 ? 1 : 0;
        if ((this.style & 4) != 0) {
            NSTextField widget = (NSTextField)this.view;
            widget.setBaseWritingDirection(direction);
        } else {
            NSTextView widget = (NSTextView)this.view;
            widget.setBaseWritingDirection(direction);
        }
    }

    public void setMessage(String message2) {
        this.checkWidget();
        if (message2 == null) {
            this.error(4);
        }
        this.message = message2;
        if ((this.style & 4) != 0) {
            NSString str = NSString.stringWith(message2);
            NSTextFieldCell cell = new NSTextFieldCell(((NSTextField)this.view).cell());
            cell.setPlaceholderString(str);
        }
    }

    public void setSelection(int start) {
        this.checkWidget();
        this.setSelection(start, start);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            NSString str = ((NSTextField)this.view).stringValue();
            int length = (int)str.length();
            int selStart = Math.min(Math.max(Math.min(start, end), 0), length);
            int selEnd = Math.min(Math.max(Math.max(start, end), 0), length);
            this.selectionRange = new NSRange();
            this.selectionRange.location = selStart;
            this.selectionRange.length = selEnd - selStart;
            NSText fieldEditor = ((NSControl)this.view).currentEditor();
            if (fieldEditor != null) {
                fieldEditor.setSelectedRange(this.selectionRange);
                fieldEditor.scrollRangeToVisible(this.selectionRange);
            }
        } else {
            int length = (int)((NSTextView)this.view).textStorage().length();
            int selStart = Math.min(Math.max(Math.min(start, end), 0), length);
            int selEnd = Math.min(Math.max(Math.max(start, end), 0), length);
            NSRange range = new NSRange();
            range.location = selStart;
            range.length = selEnd - selStart;
            NSTextView widget = (NSTextView)this.view;
            widget.setSelectedRange(range);
            widget.scrollRangeToVisible(range);
        }
    }

    public void setSelection(Point selection2) {
        this.checkWidget();
        if (selection2 == null) {
            this.error(4);
        }
        this.setSelection(selection2.x, selection2.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        if (this.tabs == tabs) {
            return;
        }
        this.tabs = tabs;
        if ((this.style & 4) != 0) {
            return;
        }
        double size = this.textExtent((String)"s").width * (double)tabs;
        NSTextView widget = (NSTextView)this.view;
        NSParagraphStyle defaultStyle = widget.defaultParagraphStyle();
        NSMutableParagraphStyle paragraphStyle = new NSMutableParagraphStyle(defaultStyle.mutableCopy());
        paragraphStyle.setTabStops(NSArray.array());
        NSTextTab tab2 = (NSTextTab)new NSTextTab().alloc();
        tab2 = tab2.initWithType(0L, size);
        paragraphStyle.addTabStop(tab2);
        tab2.release();
        paragraphStyle.setDefaultTabInterval(size);
        widget.setDefaultParagraphStyle(paragraphStyle);
        paragraphStyle.release();
    }

    public void setText(String string2) {
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string2 = this.verifyText(string2, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if ((this.style & 4) != 0) {
            this.setEditText(string2);
            NSText fieldEditor = ((NSControl)this.view).currentEditor();
            if (fieldEditor != null) {
                NSRange range = new NSRange();
                fieldEditor.setSelectedRange(range);
                fieldEditor.scrollRangeToVisible(range);
            }
        } else {
            NSTextView widget = (NSTextView)this.view;
            char[] buffer = new char[Math.min(string2.length(), this.textLimit)];
            string2.getChars(0, buffer.length, buffer, 0);
            NSString str = NSString.stringWithCharacters(buffer, buffer.length);
            widget.setString(str);
            widget.setSelectedRange(new NSRange());
        }
        this.sendEvent(24);
    }

    public void setTextChars(char[] text2) {
        this.checkWidget();
        if (text2 == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            String string2 = this.verifyText(new String(text2), 0, this.getCharCount(), null);
            if (string2 == null) {
                return;
            }
            text2 = new char[string2.length()];
            string2.getChars(0, text2.length, text2, 0);
        }
        if ((this.style & 4) != 0) {
            this.setEditText(text2);
            NSText fieldEditor = ((NSControl)this.view).currentEditor();
            if (fieldEditor != null) {
                NSRange range = new NSRange();
                fieldEditor.setSelectedRange(range);
                fieldEditor.scrollRangeToVisible(range);
            }
        } else {
            NSTextView widget = (NSTextView)this.view;
            int length = Math.min(text2.length, this.textLimit);
            NSString str = NSString.stringWithCharacters(text2, length);
            widget.setString(str);
            widget.setSelectedRange(new NSRange());
        }
        this.sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if (limit < 0) {
            return;
        }
        this.textLimit = limit;
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int row2 = Math.max(0, Math.min(index, this.getLineCount() - 1));
        NSPoint pt = new NSPoint();
        pt.x = this.scrollView.contentView().bounds().x;
        pt.y = this.getLineHeight() * row2;
        this.view.scrollPoint(pt);
    }

    @Override
    boolean shouldChangeTextInRange_replacementString(long id2, long sel, long affectedCharRange, long replacementString) {
        String text2;
        NSRange range = new NSRange();
        OS.memmove(range, affectedCharRange, (long)NSRange.sizeof);
        boolean result2 = this.callSuperBoolean(id2, sel, range, replacementString);
        NSString nsString = new NSString(replacementString);
        if (!(this.hooks(25) || this.echoCharacter != '\u0000' && (this.style & 0x400000) == 0)) {
            return result2 && (long)this.getCharCount() - range.length + nsString.length() <= (long)this.textLimit;
        }
        String newText = text2 = nsString.getString();
        if (this.hooks(25)) {
            NSEvent currentEvent = this.display.application.currentEvent();
            long type2 = currentEvent.type();
            if (type2 != 10L && type2 != 11L) {
                currentEvent = null;
            }
            newText = this.verifyText(text2, (int)range.location, (int)(range.location + range.length), currentEvent);
        }
        if (newText == null) {
            return false;
        }
        if ((long)this.getCharCount() - range.length + (long)newText.length() > (long)this.textLimit) {
            return false;
        }
        if ((this.style & 4) != 0) {
            if (text2 != newText || this.echoCharacter != '\u0000') {
                if (range.length == 1L) {
                    NSText editor = new NSText(id2);
                    editor.setSelectedRange(range);
                }
                this.insertEditText(newText);
                result2 = false;
            }
        } else if (text2 != newText) {
            NSTextView widget = (NSTextView)this.view;
            widget.textStorage().replaceCharactersInRange(widget.selectedRange(), NSString.stringWith(newText));
            result2 = false;
        }
        if (!result2) {
            this.sendEvent(24);
        }
        return result2;
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            this.setSelection(this.getSelection());
        } else {
            NSTextView widget = (NSTextView)this.view;
            widget.scrollRangeToVisible(widget.selectedRange());
        }
    }

    @Override
    void textViewDidChangeSelection(long id2, long sel, long aNotification) {
        NSNotification notification = new NSNotification(aNotification);
        NSText editor = new NSText(notification.object().id);
        this.selectionRange = editor.selectedRange();
    }

    @Override
    void textDidChange(long id2, long sel, long aNotification) {
        if ((this.style & 4) != 0) {
            super.textDidChange(id2, sel, aNotification);
        }
        this.postEvent(24);
    }

    @Override
    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(long id2, long sel, long aTextView, long oldSelectedCharRange, long newSelectedCharRange) {
        if (this.receivingFocus && this.selectionRange != null) {
            return this.selectionRange;
        }
        NSRange result2 = new NSRange();
        OS.memmove(result2, newSelectedCharRange, (long)NSRange.sizeof);
        return result2;
    }

    @Override
    int traversalCode(int key2, NSEvent theEvent) {
        int bits = super.traversalCode(key2, theEvent);
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits &= 0xFFFFFFFB;
            if (key2 == 48 && theEvent != null) {
                boolean next;
                long modifiers = theEvent.modifierFlags();
                boolean bl = next = (modifiers & 0x20000L) == 0L;
                if (next && (modifiers & 0x40000L) == 0L) {
                    bits &= 0xFFFFFFE7;
                }
            }
        }
        return bits;
    }

    @Override
    void updateCursorRects(boolean enabled) {
        super.updateCursorRects(enabled);
        if (this.scrollView == null) {
            return;
        }
        NSClipView contentView = this.scrollView.contentView();
        contentView.setDocumentCursor(enabled ? NSCursor.IBeamCursor() : null);
    }

    String verifyText(String string2, int start, int end, NSEvent keyEvent) {
        Event event = new Event();
        if (keyEvent != null) {
            this.setKeyState(event, 3, keyEvent);
        }
        event.text = string2;
        event.start = start;
        event.end = end;
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

