/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

class HessenbergTransformer {
    private final double[][] householderVectors;
    private final double[] ort;
    private RealMatrix cachedP;
    private RealMatrix cachedPt;
    private RealMatrix cachedH;

    HessenbergTransformer(RealMatrix matrix) {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m = matrix.getRowDimension();
        this.householderVectors = matrix.getData();
        this.ort = new double[m];
        this.cachedP = null;
        this.cachedPt = null;
        this.cachedH = null;
        this.transform();
    }

    public RealMatrix getP() {
        if (this.cachedP == null) {
            int j;
            int n = this.householderVectors.length;
            int high = n - 1;
            double[][] pa = new double[n][n];
            for (int i2 = 0; i2 < n; ++i2) {
                for (j = 0; j < n; ++j) {
                    pa[i2][j] = i2 == j ? 1.0 : 0.0;
                }
            }
            for (int m = high - 1; m >= 1; --m) {
                if (this.householderVectors[m][m - 1] == 0.0) continue;
                for (int i3 = m + 1; i3 <= high; ++i3) {
                    this.ort[i3] = this.householderVectors[i3][m - 1];
                }
                for (j = m; j <= high; ++j) {
                    int i4;
                    double g = 0.0;
                    for (i4 = m; i4 <= high; ++i4) {
                        g += this.ort[i4] * pa[i4][j];
                    }
                    g = g / this.ort[m] / this.householderVectors[m][m - 1];
                    for (i4 = m; i4 <= high; ++i4) {
                        double[] dArray = pa[i4];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + g * this.ort[i4];
                    }
                }
            }
            this.cachedP = MatrixUtils.createRealMatrix(pa);
        }
        return this.cachedP;
    }

    public RealMatrix getPT() {
        if (this.cachedPt == null) {
            this.cachedPt = this.getP().transpose();
        }
        return this.cachedPt;
    }

    public RealMatrix getH() {
        if (this.cachedH == null) {
            int m = this.householderVectors.length;
            double[][] h = new double[m][m];
            for (int i2 = 0; i2 < m; ++i2) {
                if (i2 > 0) {
                    h[i2][i2 - 1] = this.householderVectors[i2][i2 - 1];
                }
                for (int j = i2; j < m; ++j) {
                    h[i2][j] = this.householderVectors[i2][j];
                }
            }
            this.cachedH = MatrixUtils.createRealMatrix(h);
        }
        return this.cachedH;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    private void transform() {
        int n = this.householderVectors.length;
        int high = n - 1;
        for (int m = 1; m <= high - 1; ++m) {
            double f;
            double scale2 = 0.0;
            for (int i2 = m; i2 <= high; ++i2) {
                scale2 += FastMath.abs(this.householderVectors[i2][m - 1]);
            }
            if (Precision.equals(scale2, 0.0)) continue;
            double h = 0.0;
            for (int i3 = high; i3 >= m; --i3) {
                this.ort[i3] = this.householderVectors[i3][m - 1] / scale2;
                h += this.ort[i3] * this.ort[i3];
            }
            double g = this.ort[m] > 0.0 ? -FastMath.sqrt(h) : FastMath.sqrt(h);
            h -= this.ort[m] * g;
            int n2 = m;
            this.ort[n2] = this.ort[n2] - g;
            for (int j = m; j < n; ++j) {
                int i4;
                f = 0.0;
                for (i4 = high; i4 >= m; --i4) {
                    f += this.ort[i4] * this.householderVectors[i4][j];
                }
                f /= h;
                for (i4 = m; i4 <= high; ++i4) {
                    double[] dArray = this.householderVectors[i4];
                    int n3 = j;
                    dArray[n3] = dArray[n3] - f * this.ort[i4];
                }
            }
            for (int i5 = 0; i5 <= high; ++i5) {
                int j;
                f = 0.0;
                for (j = high; j >= m; --j) {
                    f += this.ort[j] * this.householderVectors[i5][j];
                }
                f /= h;
                for (j = m; j <= high; ++j) {
                    double[] dArray = this.householderVectors[i5];
                    int n4 = j;
                    dArray[n4] = dArray[n4] - f * this.ort[j];
                }
            }
            this.ort[m] = scale2 * this.ort[m];
            this.householderVectors[m][m - 1] = scale2 * g;
        }
    }
}

