/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder.internal.io;

import de.treichels.hott.decoder.internal.decoder.BaseDecoder;
import de.treichels.hott.decoder.internal.io.CRC16;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\b2\b\b\u0002\u0010\u0018\u001a\u00020\bJ\"\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\f2\b\b\u0002\u0010\u001b\u001a\u00020\b2\b\b\u0002\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\u0016\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\bJ\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\"J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lde/treichels/hott/decoder/internal/io/HoTTWriter;", "", "outputStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "_crc", "Lde/treichels/hott/decoder/internal/io/CRC16;", "crc", "", "getCrc", "()I", "data", "", "getData", "()[B", "<set-?>", "offset", "getOffset", "setOffset", "(I)V", "resetCRC", "", "skip", "n", "value", "write", "buffer", "off", "len", "writeBoolean", "", "writeByte", "writeInt", "writeLong", "", "writeShort", "writeString", "string", "", "length", "writeUnsignedByte", "writeUnsignedInt", "writeUnsignedShort", "HoTT-Decoder"})
public final class HoTTWriter {
    private final CRC16 _crc;
    private int offset;
    private final OutputStream outputStream;

    public final int getOffset() {
        return this.offset;
    }

    private final void setOffset(int n) {
        this.offset = n;
    }

    @NotNull
    public final byte[] getData() {
        if (!(this.outputStream instanceof ByteArrayOutputStream)) {
            throw (Throwable)new IllegalStateException(this.outputStream.getClass().getName());
        }
        byte[] byArray = ((ByteArrayOutputStream)this.outputStream).toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "outputStream.toByteArray()");
        return byArray;
    }

    public final int getCrc() {
        return this._crc.getValue();
    }

    public final void resetCRC() {
        this._crc.reset();
    }

    public final void skip(int n, int value) {
        Iterable $receiver$iv = RangesKt.until(0, n);
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            this.writeByte(value);
        }
    }

    public static /* synthetic */ void skip$default(HoTTWriter hoTTWriter, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        hoTTWriter.skip(n, n2);
    }

    @NotNull
    public final HoTTWriter write(@NotNull byte[] buffer, int off, int len) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        this.outputStream.write(buffer, off, len);
        this._crc.update(buffer, off, len);
        this.offset += len;
        return this;
    }

    @NotNull
    public static /* synthetic */ HoTTWriter write$default(HoTTWriter hoTTWriter, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return hoTTWriter.write(byArray, n, n2);
    }

    @NotNull
    public final HoTTWriter writeBoolean(boolean value) {
        this.writeByte(value ? 1 : 0);
        return this;
    }

    @NotNull
    public final HoTTWriter writeByte(int value) {
        this.writeUnsignedByte(value & 0xFF);
        return this;
    }

    @NotNull
    public final HoTTWriter writeInt(int value) {
        this.writeUnsignedInt((long)value & 0xFFFFFFFFL);
        return this;
    }

    @NotNull
    public final HoTTWriter writeLong(long value) {
        this.writeUnsignedInt(value & 0xFFFFFFFFL);
        this.writeUnsignedInt(value >>> 32);
        return this;
    }

    @NotNull
    public final HoTTWriter writeShort(int value) {
        this.writeUnsignedShort(value & 0xFFFF);
        return this;
    }

    @NotNull
    public final HoTTWriter writeString(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull(string2, "string");
        String string3 = string2;
        Charset charset = BaseDecoder.Companion.getISO_8859_1();
        HoTTWriter hoTTWriter = this;
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        HoTTWriter.write$default(hoTTWriter, byArray2, 0, 0, 6, null);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HoTTWriter writeString(@NotNull String string2, int length) {
        Intrinsics.checkParameterIsNotNull(string2, "string");
        int strLen = Math.min(string2.length(), length);
        String string3 = string2;
        int n = 0;
        HoTTWriter hoTTWriter = this;
        String string4 = string3.substring(n, strLen);
        Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        Object object = string4;
        string3 = object;
        Charset charset = BaseDecoder.Companion.getISO_8859_1();
        String string5 = string3;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string5.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "(this as java.lang.String).getBytes(charset)");
        object = byArray;
        HoTTWriter.write$default(hoTTWriter, (byte[])object, 0, 0, 6, null);
        int n2 = strLen;
        int n3 = length;
        while (n2 < n3) {
            void i2;
            this.writeByte(32);
            ++i2;
        }
        return this;
    }

    @NotNull
    public final HoTTWriter writeUnsignedByte(int value) {
        this.outputStream.write(value);
        this._crc.update((byte)value);
        int n = this.offset;
        this.offset = n + 1;
        return this;
    }

    @NotNull
    public final HoTTWriter writeUnsignedInt(long value) {
        this.writeUnsignedShort((int)(value & 0xFFFFL));
        this.writeUnsignedShort((int)(value >>> 16));
        return this;
    }

    @NotNull
    public final HoTTWriter writeUnsignedShort(int value) {
        this.writeUnsignedByte(value & 0xFF);
        this.writeUnsignedByte(value >>> 8);
        return this;
    }

    public HoTTWriter(@NotNull OutputStream outputStream) {
        Intrinsics.checkParameterIsNotNull(outputStream, "outputStream");
        this.outputStream = outputStream;
        this._crc = new CRC16();
    }

    public /* synthetic */ HoTTWriter(OutputStream outputStream, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            outputStream = new ByteArrayOutputStream();
        }
        this(outputStream);
    }

    public HoTTWriter() {
        this(null, 1, null);
    }
}

