/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder.internal.firmware;

import de.treichels.hott.decoder.internal.firmware.DeviceFirmwareKt;
import de.treichels.hott.decoder.internal.firmware.GyroReceiverFirmware;
import de.treichels.hott.decoder.internal.firmware.HexDeviceFirmware;
import de.treichels.hott.decoder.internal.firmware.StandardDeviceFirmware;
import de.treichels.hott.model.enums.ReceiverType;
import de.treichels.hott.model.enums.Registered;
import de.treichels.hott.serial.SerialPort;
import de.treichels.hott.util.Callback;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lde/treichels/hott/decoder/internal/firmware/DeviceFirmware;", "", "deviceType", "Lde/treichels/hott/model/enums/Registered;", "packets", "", "", "(Lde/treichels/hott/model/enums/Registered;[[B)V", "getDeviceType", "()Lde/treichels/hott/model/enums/Registered;", "getPackets", "()[[B", "[[B", "updateDevice", "", "callback", "Lde/treichels/hott/util/Callback;", "port", "Lde/treichels/hott/serial/SerialPort;", "Companion", "HoTT-Decoder"})
public abstract class DeviceFirmware {
    @NotNull
    private final Registered<?> deviceType;
    @NotNull
    private final byte[][] packets;
    @NotNull
    private static ResourceBundle messages;
    public static final int retryCount = 5;
    private static final List<Integer> knownIds;
    public static final Companion Companion;

    public abstract void updateDevice(@Nullable Callback var1, @NotNull SerialPort var2);

    @NotNull
    public final Registered<?> getDeviceType() {
        return this.deviceType;
    }

    @NotNull
    public final byte[][] getPackets() {
        return this.packets;
    }

    public DeviceFirmware(@NotNull Registered<?> deviceType, @NotNull byte[][] packets) {
        Intrinsics.checkParameterIsNotNull(deviceType, "deviceType");
        Intrinsics.checkParameterIsNotNull(packets, "packets");
        this.deviceType = deviceType;
        this.packets = packets;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_2;
        Object $receiver$iv$iv;
        Companion = new Companion(null);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("messages");
        if (resourceBundle == null) {
            Intrinsics.throwNpe();
        }
        messages = resourceBundle;
        Object $receiver$iv = ReceiverType.values();
        ReceiverType[] receiverTypeArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((ReceiverType[])$receiver$iv).length);
        Iterator iterator2 = $receiver$iv$iv;
        int n = ((void)iterator2).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var7_8 = item$iv$iv = iterator2[j];
            Collection collection = destination$iv$iv;
            Integer n2 = it.getId();
            collection.add(n2);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            int it = ((Number)element$iv$iv).intValue();
            if (it == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        knownIds = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)((List)var2_2), Integer.valueOf(5)), Integer.valueOf(10));
    }

    @NotNull
    public static final ResourceBundle getMessages() {
        Companion companion = Companion;
        return messages;
    }

    public static final void setMessages(@NotNull ResourceBundle resourceBundle) {
        Companion companion = Companion;
        messages = resourceBundle;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J)\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u00042\u0006\u0010\u0019\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001aR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/treichels/hott/decoder/internal/firmware/DeviceFirmware$Companion;", "", "()V", "knownIds", "", "", "messages", "Ljava/util/ResourceBundle;", "messages$annotations", "getMessages", "()Ljava/util/ResourceBundle;", "setMessages", "(Ljava/util/ResourceBundle;)V", "retryCount", "detectDevice", "Lde/treichels/hott/model/enums/Registered;", "callback", "Lde/treichels/hott/util/Callback;", "port", "Lde/treichels/hott/serial/SerialPort;", "load", "Lde/treichels/hott/decoder/internal/firmware/DeviceFirmware;", "file", "Ljava/io/File;", "forProductCode", "productCode", "forProductCode$HoTT_Decoder", "HoTT-Decoder"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void messages$annotations() {
        }

        @NotNull
        public final ResourceBundle getMessages() {
            return messages;
        }

        public final void setMessages(@NotNull ResourceBundle resourceBundle) {
            Intrinsics.checkParameterIsNotNull(resourceBundle, "<set-?>");
            messages = resourceBundle;
        }

        @Nullable
        public final Registered<?> forProductCode$HoTT_Decoder(@NotNull List<? extends Registered<?>> $receiver, int productCode) {
            Object v0;
            block1: {
                Iterable iterable;
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                Iterable iterable2 = iterable = (Iterable)$receiver;
                for (Object t : iterable2) {
                    Registered it = (Registered)t;
                    if (!(it.getProductCode() == productCode)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public final DeviceFirmware load(@NotNull File file) {
            DeviceFirmware deviceFirmware;
            Intrinsics.checkParameterIsNotNull(file, "file");
            try {
                deviceFirmware = StandardDeviceFirmware.Companion.load(file);
            }
            catch (IOException e1) {
                DeviceFirmware deviceFirmware2;
                try {
                    deviceFirmware2 = HexDeviceFirmware.Companion.load(file);
                }
                catch (IOException e2) {
                    GyroReceiverFirmware gyroReceiverFirmware;
                    try {
                        gyroReceiverFirmware = GyroReceiverFirmware.Companion.load(file);
                    }
                    catch (IOException e3) {
                        throw (Throwable)new IOException(e1.getMessage() + '/' + e2.getMessage() + '/' + e3.getMessage(), e2);
                    }
                    deviceFirmware2 = gyroReceiverFirmware;
                }
                deviceFirmware = deviceFirmware2;
            }
            return deviceFirmware;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Registered<?> detectDevice(@Nullable Callback callback, @NotNull SerialPort port) {
            Registered<?> registered;
            Intrinsics.checkParameterIsNotNull(port, "port");
            Closeable closeable = port;
            Throwable throwable = null;
            try {
                Registered<?> registered2;
                SerialPort it = (SerialPort)closeable;
                it.setBaudRate(19200);
                it.open();
                int[] nArray = CollectionsKt.toIntArray(knownIds);
                int rc = DeviceFirmwareKt.waitForBoot(it, callback, Arrays.copyOf(nArray, nArray.length));
                if (rc == 5 || rc == 10) {
                    StandardDeviceFirmware.Companion.updateMode(rc, it);
                    Thread.sleep(100L);
                    Triple<Integer, Integer, Integer> triple = StandardDeviceFirmware.Companion.getInfo(it);
                    int productCode = ((Number)triple.component1()).intValue();
                    registered2 = Companion.forProductCode$HoTT_Decoder(DeviceFirmwareKt.getDeviceList(), productCode);
                } else {
                    registered2 = ReceiverType.Companion.forId(rc);
                }
                registered = registered2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            return registered;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

