/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder.internal.decoder;

import de.treichels.hott.decoder.HoTTSerialPort;
import de.treichels.hott.decoder.internal.decoder.BaseDecoder$Companion$WhenMappings;
import de.treichels.hott.decoder.internal.decoder.MC16Decoder;
import de.treichels.hott.decoder.internal.decoder.MC20Decoder;
import de.treichels.hott.decoder.internal.decoder.MC26Decoder;
import de.treichels.hott.decoder.internal.decoder.MC28Decoder;
import de.treichels.hott.decoder.internal.decoder.MC32Decoder;
import de.treichels.hott.decoder.internal.decoder.MX12Decoder;
import de.treichels.hott.decoder.internal.decoder.MX16Decoder;
import de.treichels.hott.decoder.internal.decoder.MX20Decoder;
import de.treichels.hott.decoder.internal.decoder.MZ12Decoder;
import de.treichels.hott.decoder.internal.decoder.MZ12ProDecoder;
import de.treichels.hott.decoder.internal.decoder.MZ18Decoder;
import de.treichels.hott.decoder.internal.decoder.MZ18ProDecoder;
import de.treichels.hott.decoder.internal.decoder.MZ24Decoder;
import de.treichels.hott.decoder.internal.decoder.MZ24ProDecoder;
import de.treichels.hott.decoder.internal.io.HoTTReader;
import de.treichels.hott.decoder.internal.io.HoTTWriter;
import de.treichels.hott.messages.Messages;
import de.treichels.hott.model.BaseModel;
import de.treichels.hott.model.HoTTException;
import de.treichels.hott.model.Receiver;
import de.treichels.hott.model.Switch;
import de.treichels.hott.model.Telemetry;
import de.treichels.hott.model.enums.ModelType;
import de.treichels.hott.model.enums.PhaseType;
import de.treichels.hott.model.enums.ReceiverBindType;
import de.treichels.hott.model.enums.ReceiverClass;
import de.treichels.hott.model.enums.ReceiverFirmwareType;
import de.treichels.hott.model.enums.SensorType;
import de.treichels.hott.model.enums.SwitchAssignment;
import de.treichels.hott.model.enums.SwitchFunction;
import de.treichels.hott.model.enums.TelemetryAlarmType;
import de.treichels.hott.model.enums.TransmitterType;
import de.treichels.hott.model.enums.VarioToneSensor;
import de.treichels.hott.model.enums.Vendor;
import de.treichels.hott.serial.ModelInfo;
import de.treichels.hott.serial.ResponseCode;
import de.treichels.hott.util.Util;
import de.treichels.hott.voice.Announcements;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\t\b&\u0018\u0000 g2\u00020\u0001:\u0001gB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00103\u001a\u000204H$J\b\u00105\u001a\u000204H\u0004J\b\u00106\u001a\u000204H\u0004J\b\u00107\u001a\u000204H\u0004J\b\u00108\u001a\u000209H\u0004J)\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020<2\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010>\"\u00020\u0001H\u0004\u00a2\u0006\u0002\u0010?J9\u0010:\u001a\u00020'2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00042\u0006\u0010;\u001a\u00020<2\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010>\"\u00020\u0001H\u0004\u00a2\u0006\u0002\u0010CJ)\u0010D\u001a\u00020'2\u0006\u0010;\u001a\u00020<2\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010>\"\u00020\u0001H\u0004\u00a2\u0006\u0002\u0010?J1\u0010D\u001a\u00020'2\u0006\u0010B\u001a\u00020\u00042\u0006\u0010;\u001a\u00020<2\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010>\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010EJ\b\u0010F\u001a\u000204H\u0004J\b\u0010G\u001a\u000204H\u0004J\b\u0010H\u001a\u000204H\u0004J\b\u0010I\u001a\u000204H\u0004J\b\u0010J\u001a\u000204H\u0004J\b\u0010K\u001a\u000204H\u0014J\b\u0010L\u001a\u000204H\u0004J\b\u0010M\u001a\u000204H$J\u0010\u0010N\u001a\u0002042\u0006\u0010O\u001a\u000209H\u0004J\u0010\u0010P\u001a\u0002042\u0006\u0010Q\u001a\u00020'H\u0004J\u0010\u0010R\u001a\u0002042\u0006\u0010Q\u001a\u00020'H\u0002J\b\u0010S\u001a\u000204H\u0004J\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00020U0\u00172\u0006\u0010V\u001a\u00020WH&J\u000e\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020\u0004J\u0016\u0010[\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*2\u0006\u0010\\\u001a\u00020YJ\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020Y0\u00172\u0006\u0010V\u001a\u00020WH&J\u0018\u0010^\u001a\u00020_2\u0006\u0010V\u001a\u00020W2\u0006\u0010`\u001a\u00020UH&J\u0018\u0010^\u001a\u00020_2\u0006\u0010V\u001a\u00020W2\u0006\u0010a\u001a\u00020\u0004H&J\u0016\u0010b\u001a\u00020U2\u0006\u0010V\u001a\u00020W2\u0006\u0010a\u001a\u00020\u0004J\u0010\u0010c\u001a\u00020Y2\u0006\u0010V\u001a\u00020WH&J\b\u0010d\u001a\u000204H\u0004J\b\u0010e\u001a\u000204H\u0004J\b\u0010f\u001a\u000204H\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R$\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R\u0012\u0010)\u001a\u00020*X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006h"}, d2={"Lde/treichels/hott/decoder/internal/decoder/BaseDecoder;", "", "()V", "blockStart", "", "fileLen", "getFileLen", "()I", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "model", "Lde/treichels/hott/model/BaseModel;", "getModel", "()Lde/treichels/hott/model/BaseModel;", "setModel", "(Lde/treichels/hott/model/BaseModel;)V", "modelCount", "getModelCount", "phaseTypes", "", "Lde/treichels/hott/model/enums/ModelType;", "", "Lde/treichels/hott/model/enums/PhaseType;", "getPhaseTypes", "()Ljava/util/Map;", "reader", "Lde/treichels/hott/decoder/internal/io/HoTTReader;", "getReader", "()Lde/treichels/hott/decoder/internal/io/HoTTReader;", "setReader", "(Lde/treichels/hott/decoder/internal/io/HoTTReader;)V", "switchAssignments", "Lde/treichels/hott/model/enums/SwitchAssignment;", "getSwitchAssignments", "()Ljava/util/List;", "switches", "", "Lde/treichels/hott/model/Switch;", "getSwitches", "transmitterType", "Lde/treichels/hott/model/enums/TransmitterType;", "getTransmitterType", "()Lde/treichels/hott/model/enums/TransmitterType;", "writer", "Lde/treichels/hott/decoder/internal/io/HoTTWriter;", "getWriter", "()Lde/treichels/hott/decoder/internal/io/HoTTWriter;", "setWriter", "(Lde/treichels/hott/decoder/internal/io/HoTTWriter;)V", "decode", "", "decodeCurrentSensor", "decodeReceiverBindType", "decodeReceiverFirmwareType", "decodeRfID", "", "decodeSwitch", "function", "Lde/treichels/hott/model/enums/SwitchFunction;", "qualifier", "", "(Lde/treichels/hott/model/enums/SwitchFunction;[Ljava/lang/Object;)Lde/treichels/hott/model/Switch;", "reverse", "", "assignment", "(ZILde/treichels/hott/model/enums/SwitchFunction;[Ljava/lang/Object;)Lde/treichels/hott/model/Switch;", "decodeSwitchWithoutDirection", "(ILde/treichels/hott/model/enums/SwitchFunction;[Ljava/lang/Object;)Lde/treichels/hott/model/Switch;", "decodeTeleVoice", "decodeTeleVoiceAirESC", "decodeTelemetryDataReceiveTime", "decodeTelemetryDisplayNum", "decodeTelemetryUserWarningAlarm", "decodeTransmitterData", "decodeVarioToneSensor", "encode", "encodeRfID", "id", "encodeSwitch", "sw", "encodeSwitchWithoutDirection", "encodeTransmitterData", "getAllModelInfos", "Lde/treichels/hott/serial/ModelInfo;", "port", "Lde/treichels/hott/decoder/HoTTSerialPort;", "getAnnouncement", "", "index", "getAnnouncementIndex", "announcement", "getCustomPhaseNames", "getModelData", "", "info", "modelNumber", "getModelInfo", "getOwnerName", "resetCRC", "verifyChecksum", "writeChecksum", "Companion", "HoTT-Decoder"})
public abstract class BaseDecoder {
    @NotNull
    protected BaseModel model;
    @NotNull
    protected HoTTReader reader;
    @NotNull
    protected HoTTWriter writer;
    private int blockStart;
    @NotNull
    private final List<Switch> switches = new ArrayList();
    @NotNull
    public static final String UNUSED_ANNOUNCEMENT = "--";
    @NotNull
    private static final Charset ISO_8859_1;
    private static final boolean VERIFY_CHECKSUM;
    public static final Companion Companion;

    @NotNull
    protected final BaseModel getModel() {
        BaseModel baseModel = this.model;
        if (baseModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        return baseModel;
    }

    protected final void setModel(@NotNull BaseModel baseModel) {
        Intrinsics.checkParameterIsNotNull(baseModel, "<set-?>");
        this.model = baseModel;
    }

    private final Logger getLogger() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        Intrinsics.checkExpressionValueIsNotNull(logger, "Logger.getLogger(javaClass.name)");
        return logger;
    }

    @NotNull
    protected final HoTTReader getReader() {
        HoTTReader hoTTReader = this.reader;
        if (hoTTReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        return hoTTReader;
    }

    protected final void setReader(@NotNull HoTTReader hoTTReader) {
        Intrinsics.checkParameterIsNotNull(hoTTReader, "<set-?>");
        this.reader = hoTTReader;
    }

    @NotNull
    protected final HoTTWriter getWriter() {
        HoTTWriter hoTTWriter = this.writer;
        if (hoTTWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("writer");
        }
        return hoTTWriter;
    }

    protected final void setWriter(@NotNull HoTTWriter hoTTWriter) {
        Intrinsics.checkParameterIsNotNull(hoTTWriter, "<set-?>");
        this.writer = hoTTWriter;
    }

    @NotNull
    protected final List<Switch> getSwitches() {
        return this.switches;
    }

    protected abstract int getFileLen();

    public abstract int getModelCount();

    @NotNull
    public abstract TransmitterType getTransmitterType();

    @NotNull
    public abstract List<SwitchAssignment> getSwitchAssignments();

    @NotNull
    public abstract Map<ModelType, List<PhaseType>> getPhaseTypes();

    protected abstract void decode();

    protected abstract void encode();

    protected final void encodeRfID(long id2) {
        HoTTWriter hoTTWriter = this.writer;
        if (hoTTWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("writer");
        }
        hoTTWriter.writeUnsignedInt(id2 & 0xFFFFFFFFL);
        HoTTWriter hoTTWriter2 = this.writer;
        if (hoTTWriter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("writer");
        }
        hoTTWriter2.writeUnsignedByte((int)(id2 >> 32 & 0xFFL));
    }

    protected final void encodeSwitch(@NotNull Switch sw) {
        Intrinsics.checkParameterIsNotNull(sw, "sw");
        HoTTWriter hoTTWriter = this.writer;
        if (hoTTWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("writer");
        }
        hoTTWriter.writeUnsignedByte(sw.getReverse() ? 1 : 0);
        this.encodeSwitchWithoutDirection(sw);
    }

    private final void encodeSwitchWithoutDirection(Switch sw) {
        if (sw.getAssignment() == SwitchAssignment.Unassigned) {
            HoTTWriter hoTTWriter = this.writer;
            if (hoTTWriter == null) {
                Intrinsics.throwUninitializedPropertyAccessException("writer");
            }
            hoTTWriter.writeUnsignedByte(255);
        } else {
            HoTTWriter hoTTWriter = this.writer;
            if (hoTTWriter == null) {
                Intrinsics.throwUninitializedPropertyAccessException("writer");
            }
            hoTTWriter.writeUnsignedByte(this.getSwitchAssignments().indexOf((Object)sw.getAssignment()));
        }
    }

    protected final void encodeTransmitterData() {
        HoTTWriter hoTTWriter = this.writer;
        if (hoTTWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("writer");
        }
        BaseModel baseModel = this.model;
        if (baseModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        hoTTWriter.writeInt(baseModel.getAppVersion());
        HoTTWriter hoTTWriter2 = this.writer;
        if (hoTTWriter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("writer");
        }
        BaseModel baseModel2 = this.model;
        if (baseModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        hoTTWriter2.writeInt(baseModel2.getMemoryVersion());
        HoTTWriter hoTTWriter3 = this.writer;
        if (hoTTWriter3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("writer");
        }
        hoTTWriter3.skip(244, -1);
        BaseModel baseModel3 = this.model;
        if (baseModel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        this.encodeRfID(baseModel3.getTransmitterId());
        HoTTWriter hoTTWriter4 = this.writer;
        if (hoTTWriter4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("writer");
        }
        hoTTWriter4.skip(91, -1);
        BaseModel baseModel4 = this.model;
        if (baseModel4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        if (baseModel4.isBound()) {
            HoTTWriter hoTTWriter5 = this.writer;
            if (hoTTWriter5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("writer");
            }
            BaseModel baseModel5 = this.model;
            if (baseModel5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("model");
            }
            hoTTWriter5.writeByte(baseModel5.getReceiverClass().getId());
        } else {
            HoTTWriter hoTTWriter6 = this.writer;
            if (hoTTWriter6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("writer");
            }
            hoTTWriter6.writeByte(-1);
        }
        HoTTWriter hoTTWriter7 = this.writer;
        if (hoTTWriter7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("writer");
        }
        hoTTWriter7.skip(3743, -1);
    }

    public final int getAnnouncementIndex(@NotNull TransmitterType transmitterType, @NotNull String announcement) {
        Intrinsics.checkParameterIsNotNull(transmitterType, "transmitterType");
        Intrinsics.checkParameterIsNotNull(announcement, "announcement");
        return Intrinsics.areEqual(announcement, UNUSED_ANNOUNCEMENT) ? 1026 : Announcements.INSTANCE.getIndexOf(transmitterType, announcement);
    }

    /*
     * WARNING - void declaration
     */
    protected final void decodeCurrentSensor() {
        Enum enum_;
        Enum enum_2;
        Telemetry telemetry;
        block4: {
            SensorType[] sensorTypeArray;
            SensorType[] sensorTypeArray2;
            this.resetCRC();
            BaseModel baseModel = this.model;
            if (baseModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException("model");
            }
            Telemetry telemetry2 = baseModel.getTelemetry();
            HoTTReader hoTTReader = this.reader;
            if (hoTTReader == null) {
                Intrinsics.throwUninitializedPropertyAccessException("reader");
            }
            int n = hoTTReader.readUnsignedByte();
            telemetry = telemetry2;
            for (SensorType sensorType : sensorTypeArray2 = (sensorTypeArray = SensorType.values())) {
                void code$iv;
                SensorType it$iv = sensorType;
                if (!(it$iv.ordinal() == code$iv)) continue;
                enum_2 = sensorType;
                break block4;
            }
            enum_2 = enum_ = null;
        }
        if (enum_2 == null) {
            enum_ = ArraysKt.last(SensorType.values());
        }
        Enum enum_3 = enum_;
        telemetry.setCurrentSensor((SensorType)enum_3);
        this.verifyChecksum();
    }

    /*
     * WARNING - void declaration
     */
    protected final void decodeReceiverBindType() {
        Enum enum_;
        Enum enum_2;
        BaseModel baseModel;
        block8: {
            ReceiverBindType[] receiverBindTypeArray;
            ReceiverBindType[] receiverBindTypeArray2;
            this.resetCRC();
            BaseModel baseModel2 = this.model;
            if (baseModel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("model");
            }
            HoTTReader hoTTReader = this.reader;
            if (hoTTReader == null) {
                Intrinsics.throwUninitializedPropertyAccessException("reader");
            }
            int n = hoTTReader.readUnsignedByte();
            baseModel = baseModel2;
            for (ReceiverBindType receiverBindType : receiverBindTypeArray2 = (receiverBindTypeArray = ReceiverBindType.values())) {
                void code$iv;
                ReceiverBindType it$iv = receiverBindType;
                if (!(it$iv.ordinal() == code$iv)) continue;
                enum_2 = receiverBindType;
                break block8;
            }
            enum_2 = enum_ = null;
        }
        if (enum_2 == null) {
            enum_ = ArraysKt.last(ReceiverBindType.values());
        }
        Enum enum_3 = enum_;
        baseModel.setReceiverBindType((ReceiverBindType)enum_3);
        BaseModel baseModel3 = this.model;
        if (baseModel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        if (baseModel3.getReceiverBindType() == ReceiverBindType.Unknown) {
            HoTTReader hoTTReader = this.reader;
            if (hoTTReader == null) {
                Intrinsics.throwUninitializedPropertyAccessException("reader");
            }
            hoTTReader.skip(2);
        } else {
            this.verifyChecksum();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void decodeReceiverFirmwareType() {
        this.resetCRC();
        BaseModel baseModel = this.model;
        if (baseModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        Iterable $receiver$iv = baseModel.getReceiver();
        for (Object element$iv : $receiver$iv) {
            Enum enum_;
            Enum enum_2;
            Receiver receiver2;
            block11: {
                ReceiverFirmwareType[] receiverFirmwareTypeArray;
                ReceiverFirmwareType[] receiverFirmwareTypeArray2;
                Receiver it = (Receiver)element$iv;
                HoTTReader hoTTReader = this.reader;
                if (hoTTReader == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("reader");
                }
                int n = hoTTReader.readUnsignedByte();
                receiver2 = it;
                for (ReceiverFirmwareType receiverFirmwareType : receiverFirmwareTypeArray2 = (receiverFirmwareTypeArray = ReceiverFirmwareType.values())) {
                    void code$iv;
                    ReceiverFirmwareType it$iv = receiverFirmwareType;
                    if (!(it$iv.ordinal() == code$iv)) continue;
                    enum_2 = receiverFirmwareType;
                    break block11;
                }
                enum_2 = enum_ = null;
            }
            if (enum_2 == null) {
                enum_ = ArraysKt.last(ReceiverFirmwareType.values());
            }
            Enum enum_3 = enum_;
            receiver2.setFirmwareType((ReceiverFirmwareType)enum_3);
        }
        HoTTReader hoTTReader = this.reader;
        if (hoTTReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        BaseModel baseModel2 = this.model;
        if (baseModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        hoTTReader.skip(4 - baseModel2.getReceiver().size());
        BaseModel baseModel3 = this.model;
        if (baseModel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        if (baseModel3.getReceiver().get(0).getFirmwareType() == ReceiverFirmwareType.Unknown) {
            HoTTReader hoTTReader2 = this.reader;
            if (hoTTReader2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("reader");
            }
            hoTTReader2.skip(2);
        } else {
            this.verifyChecksum();
        }
    }

    protected final long decodeRfID() {
        HoTTReader hoTTReader = this.reader;
        if (hoTTReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        long l = hoTTReader.readUnsignedInt();
        HoTTReader hoTTReader2 = this.reader;
        if (hoTTReader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        return l + ((long)hoTTReader2.readUnsignedByte() << 32);
    }

    @NotNull
    protected final Switch decodeSwitch(boolean reverse, int assignment, @NotNull SwitchFunction function, Object ... qualifier) {
        Intrinsics.checkParameterIsNotNull((Object)function, "function");
        Intrinsics.checkParameterIsNotNull(qualifier, "qualifier");
        Switch sw = this.decodeSwitchWithoutDirection(assignment, function, Arrays.copyOf(qualifier, qualifier.length));
        sw.setReverse(sw.getAssignment() == SwitchAssignment.Unassigned ? false : (sw.getAssignment().isUnidirectional() ? false : reverse));
        return sw;
    }

    @NotNull
    protected final Switch decodeSwitch(@NotNull SwitchFunction function, Object ... qualifier) {
        Intrinsics.checkParameterIsNotNull((Object)function, "function");
        Intrinsics.checkParameterIsNotNull(qualifier, "qualifier");
        HoTTReader hoTTReader = this.reader;
        if (hoTTReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        boolean bl = hoTTReader.readBoolean();
        HoTTReader hoTTReader2 = this.reader;
        if (hoTTReader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        return this.decodeSwitch(bl, hoTTReader2.readUnsignedByte(), function, Arrays.copyOf(qualifier, qualifier.length));
    }

    private final Switch decodeSwitchWithoutDirection(int assignment, SwitchFunction function, Object ... qualifier) {
        Switch switch_;
        SwitchAssignment switchAssignment = assignment == 255 ? SwitchAssignment.Unassigned : this.getSwitchAssignments().get(assignment);
        int n = this.switches.size();
        List<Object> list2 = Arrays.asList(Arrays.copyOf(qualifier, qualifier.length));
        Intrinsics.checkExpressionValueIsNotNull(list2, "Arrays.asList(*qualifier)");
        Switch $receiver = switch_ = new Switch(switchAssignment, false, 0, null, false, false, false, function, n, list2, 124, null);
        this.switches.add($receiver);
        return switch_;
    }

    @NotNull
    protected final Switch decodeSwitchWithoutDirection(@NotNull SwitchFunction function, Object ... qualifier) {
        Intrinsics.checkParameterIsNotNull((Object)function, "function");
        Intrinsics.checkParameterIsNotNull(qualifier, "qualifier");
        HoTTReader hoTTReader = this.reader;
        if (hoTTReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        return this.decodeSwitchWithoutDirection(hoTTReader.readUnsignedByte(), function, Arrays.copyOf(qualifier, qualifier.length));
    }

    protected final void decodeTelemetryDataReceiveTime() {
        this.resetCRC();
        BaseModel baseModel = this.model;
        if (baseModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        Telemetry telemetry = baseModel.getTelemetry();
        HoTTReader hoTTReader = this.reader;
        if (hoTTReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        telemetry.setTelemetryDataReceiveTime(hoTTReader.readUnsignedByte());
        BaseModel baseModel2 = this.model;
        if (baseModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        if (baseModel2.getTelemetry().getTelemetryDataReceiveTime() == 255) {
            HoTTReader hoTTReader2 = this.reader;
            if (hoTTReader2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("reader");
            }
            hoTTReader2.skip(2);
        } else {
            this.verifyChecksum();
        }
    }

    protected final void decodeTelemetryDisplayNum() {
        this.resetCRC();
        BaseModel baseModel = this.model;
        if (baseModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        Telemetry telemetry = baseModel.getTelemetry();
        HoTTReader hoTTReader = this.reader;
        if (hoTTReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        telemetry.setCurrentSensorPage(hoTTReader.readUnsignedByte());
        this.verifyChecksum();
    }

    /*
     * WARNING - void declaration
     */
    protected final void decodeTelemetryUserWarningAlarm() {
        boolean valid2;
        byte[] data2;
        block10: {
            boolean bl;
            byte[] $receiver$iv;
            data2 = new byte[21];
            this.resetCRC();
            HoTTReader hoTTReader = this.reader;
            if (hoTTReader == null) {
                Intrinsics.throwUninitializedPropertyAccessException("reader");
            }
            HoTTReader.read$default(hoTTReader, data2, 0, 0, 6, null);
            for (byte element$iv : $receiver$iv = data2) {
                byte it = element$iv;
                if (!(it != -1)) continue;
                bl = true;
                break block10;
            }
            bl = valid2 = false;
        }
        if (valid2) {
            Enum enum_;
            Enum enum_2;
            TelemetryAlarmType[] telemetryAlarmTypeArray;
            Telemetry telemetry;
            block11: {
                TelemetryAlarmType[] telemetryAlarmTypeArray2;
                HoTTReader r = new HoTTReader(data2);
                BaseModel baseModel = this.model;
                if (baseModel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("model");
                }
                int n = 10;
                telemetry = baseModel.getTelemetry();
                TelemetryAlarmType[] telemetryAlarmTypeArray3 = new ArrayList(n);
                int n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int n4;
                    int $i$a$1$any = n4 = n2++;
                    telemetryAlarmTypeArray = telemetryAlarmTypeArray3;
                    String string2 = this.getAnnouncement(r.readUnsignedShort());
                    telemetryAlarmTypeArray.add((String)string2);
                }
                telemetryAlarmTypeArray = telemetryAlarmTypeArray3;
                telemetry.setUserAlarmList((List<String>)telemetryAlarmTypeArray);
                BaseModel baseModel2 = this.model;
                if (baseModel2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("model");
                }
                n = r.readUnsignedByte();
                telemetry = baseModel2.getTelemetry();
                for (TelemetryAlarmType telemetryAlarmType : telemetryAlarmTypeArray2 = (telemetryAlarmTypeArray3 = TelemetryAlarmType.values())) {
                    void code$iv;
                    TelemetryAlarmType it$iv = telemetryAlarmType;
                    if (!(it$iv.ordinal() == code$iv)) continue;
                    enum_2 = telemetryAlarmType;
                    break block11;
                }
                enum_2 = enum_ = null;
            }
            if (enum_2 == null) {
                enum_ = ArraysKt.last(TelemetryAlarmType.values());
            }
            telemetryAlarmTypeArray = enum_;
            telemetry.setTelemetryAlarmType((TelemetryAlarmType)telemetryAlarmTypeArray);
            this.verifyChecksum();
        } else {
            HoTTReader hoTTReader = this.reader;
            if (hoTTReader == null) {
                Intrinsics.throwUninitializedPropertyAccessException("reader");
            }
            hoTTReader.skip(2);
        }
    }

    protected final void decodeTeleVoice() {
        Telemetry telemetry;
        this.resetCRC();
        BaseModel baseModel = this.model;
        if (baseModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        Telemetry $receiver = telemetry = baseModel.getTelemetry();
        HoTTReader hoTTReader = this.reader;
        if (hoTTReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        $receiver.setVoiceDelay(hoTTReader.readByte());
        HoTTReader hoTTReader2 = this.reader;
        if (hoTTReader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        $receiver.setSelectedSensor(SensorType.Companion.forMap(hoTTReader2.readUnsignedByte()));
        HoTTReader hoTTReader3 = this.reader;
        if (hoTTReader3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        $receiver.setBasicVoiceList(hoTTReader3.readUnsignedShort());
        HoTTReader hoTTReader4 = this.reader;
        if (hoTTReader4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        $receiver.setGeneralAirVoiceList(hoTTReader4.readInt());
        HoTTReader hoTTReader5 = this.reader;
        if (hoTTReader5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        $receiver.setElectricAirVoiceList(hoTTReader5.readInt());
        HoTTReader hoTTReader6 = this.reader;
        if (hoTTReader6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        $receiver.setVarioVoiceList(hoTTReader6.readInt());
        HoTTReader hoTTReader7 = this.reader;
        if (hoTTReader7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        $receiver.setGpsVoiceList(hoTTReader7.readInt());
        this.verifyChecksum();
    }

    protected final void decodeTeleVoiceAirESC() {
        this.resetCRC();
        BaseModel baseModel = this.model;
        if (baseModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        HoTTReader hoTTReader = this.reader;
        if (hoTTReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        baseModel.setEscVoiceAnnounceFlag(hoTTReader.readUnsignedInt());
        BaseModel baseModel2 = this.model;
        if (baseModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        if (baseModel2.getEscVoiceAnnounceFlag() == 0xFFFFFFFFL) {
            HoTTReader hoTTReader2 = this.reader;
            if (hoTTReader2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("reader");
            }
            hoTTReader2.skip(2);
        } else {
            this.verifyChecksum();
        }
    }

    protected void decodeTransmitterData() {
        BaseModel baseModel = this.model;
        if (baseModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        HoTTReader hoTTReader = this.reader;
        if (hoTTReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        baseModel.setAppVersion(hoTTReader.readInt());
        BaseModel baseModel2 = this.model;
        if (baseModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        HoTTReader hoTTReader2 = this.reader;
        if (hoTTReader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        baseModel2.setMemoryVersion(hoTTReader2.readInt());
        HoTTReader hoTTReader3 = this.reader;
        if (hoTTReader3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        hoTTReader3.skip(244);
        BaseModel baseModel3 = this.model;
        if (baseModel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        baseModel3.setTransmitterId(this.decodeRfID());
        HoTTReader hoTTReader4 = this.reader;
        if (hoTTReader4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        hoTTReader4.skip(91);
        BaseModel baseModel4 = this.model;
        if (baseModel4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        HoTTReader hoTTReader5 = this.reader;
        if (hoTTReader5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        baseModel4.setReceiverClass(ReceiverClass.Companion.forId(hoTTReader5.readByte()));
        BaseModel baseModel5 = this.model;
        if (baseModel5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        BaseModel baseModel6 = this.model;
        if (baseModel6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        baseModel5.setBound(baseModel6.getReceiverClass() != ReceiverClass.Unknown);
        HoTTReader hoTTReader6 = this.reader;
        if (hoTTReader6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        hoTTReader6.skip(3743);
    }

    /*
     * WARNING - void declaration
     */
    protected final void decodeVarioToneSensor() {
        Enum enum_;
        Enum enum_2;
        Telemetry telemetry;
        block8: {
            VarioToneSensor[] varioToneSensorArray;
            VarioToneSensor[] varioToneSensorArray2;
            this.resetCRC();
            BaseModel baseModel = this.model;
            if (baseModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException("model");
            }
            Telemetry telemetry2 = baseModel.getTelemetry();
            HoTTReader hoTTReader = this.reader;
            if (hoTTReader == null) {
                Intrinsics.throwUninitializedPropertyAccessException("reader");
            }
            int n = hoTTReader.readUnsignedByte();
            telemetry = telemetry2;
            for (VarioToneSensor varioToneSensor : varioToneSensorArray2 = (varioToneSensorArray = VarioToneSensor.values())) {
                void code$iv;
                VarioToneSensor it$iv = varioToneSensor;
                if (!(it$iv.ordinal() == code$iv)) continue;
                enum_2 = varioToneSensor;
                break block8;
            }
            enum_2 = enum_ = null;
        }
        if (enum_2 == null) {
            enum_ = ArraysKt.last(VarioToneSensor.values());
        }
        Enum enum_3 = enum_;
        telemetry.setVarioToneSensor((VarioToneSensor)enum_3);
        BaseModel baseModel = this.model;
        if (baseModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
        }
        if (baseModel.getTelemetry().getVarioToneSensor() == VarioToneSensor.Unknown) {
            HoTTReader hoTTReader = this.reader;
            if (hoTTReader == null) {
                Intrinsics.throwUninitializedPropertyAccessException("reader");
            }
            hoTTReader.skip(2);
        } else {
            this.verifyChecksum();
        }
    }

    @NotNull
    public abstract List<ModelInfo> getAllModelInfos(@NotNull HoTTSerialPort var1);

    @NotNull
    public final String getAnnouncement(int index) {
        return index == 1026 ? UNUSED_ANNOUNCEMENT : Announcements.INSTANCE.getAnnouncement(this.getTransmitterType(), index);
    }

    @NotNull
    public abstract List<String> getCustomPhaseNames(@NotNull HoTTSerialPort var1);

    @NotNull
    public abstract byte[] getModelData(@NotNull HoTTSerialPort var1, int var2);

    @NotNull
    public abstract byte[] getModelData(@NotNull HoTTSerialPort var1, @NotNull ModelInfo var2);

    @NotNull
    public final ModelInfo getModelInfo(@NotNull HoTTSerialPort port, int modelNumber) {
        Intrinsics.checkParameterIsNotNull(port, "port");
        return this.getAllModelInfos(port).get(modelNumber);
    }

    @NotNull
    public abstract String getOwnerName(@NotNull HoTTSerialPort var1);

    protected final void resetCRC() {
        HoTTReader hoTTReader = this.reader;
        if (hoTTReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        hoTTReader.resetCRC();
        HoTTReader hoTTReader2 = this.reader;
        if (hoTTReader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        this.blockStart = hoTTReader2.getOffset();
        if (Util.INSTANCE.getDEBUG()) {
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
            StackTraceElement[] stackTrace = thread2.getStackTrace();
            StackTraceElement stackTraceElement = stackTrace[2];
            Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "stackTrace[2]");
            String name = stackTraceElement.getMethodName();
            Logger logger = this.getLogger();
            Object[] objectArray = new Object[2];
            objectArray[0] = name;
            HoTTReader hoTTReader3 = this.reader;
            if (hoTTReader3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("reader");
            }
            objectArray[1] = hoTTReader3.getOffset();
            logger.log(Level.FINER, "Block \"%s\" start at 0x%04X%n", objectArray);
        }
    }

    protected final void verifyChecksum() {
        HoTTReader hoTTReader = this.reader;
        if (hoTTReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        int offset = hoTTReader.getOffset();
        HoTTReader hoTTReader2 = this.reader;
        if (hoTTReader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        int calculatedCrc = hoTTReader2.getCrc();
        HoTTReader hoTTReader3 = this.reader;
        if (hoTTReader3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("reader");
        }
        int fileCrc = hoTTReader3.readUnsignedShort();
        if (Util.INSTANCE.getDEBUG()) {
            this.getLogger().log(Level.FINER, "Block end at 0x%04X, Size: %d, CRC: calculated=0x%04X, file=0x%04X%n", new Integer[]{offset, offset - this.blockStart, calculatedCrc, fileCrc});
        }
        if (fileCrc != calculatedCrc) {
            Object[] objectArray = new Object[5];
            objectArray[0] = offset;
            objectArray[1] = calculatedCrc;
            objectArray[2] = fileCrc;
            BaseModel baseModel = this.model;
            if (baseModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException("model");
            }
            objectArray[3] = baseModel.getModelName();
            BaseModel baseModel2 = this.model;
            if (baseModel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("model");
            }
            objectArray[4] = baseModel2.getTransmitterType();
            String message2 = Messages.getString("BaseDecoder.InvalidChecksum", objectArray);
            this.getLogger().severe(message2);
            if (VERIFY_CHECKSUM) {
                String string2 = message2;
                Intrinsics.checkExpressionValueIsNotNull(string2, "message");
                throw (Throwable)new HoTTException(string2, new Object[0]);
            }
        }
    }

    protected final void writeChecksum() {
        HoTTWriter hoTTWriter = this.writer;
        if (hoTTWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("writer");
        }
        HoTTWriter hoTTWriter2 = this.writer;
        if (hoTTWriter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("writer");
        }
        hoTTWriter.writeUnsignedShort(hoTTWriter2.getCrc());
    }

    static {
        Companion = new Companion(null);
        Charset charset = Charset.forName("ISO-8859-1");
        Intrinsics.checkExpressionValueIsNotNull(charset, "Charset.forName(\"ISO-8859-1\")");
        ISO_8859_1 = charset;
        VERIFY_CHECKSUM = Preferences.userNodeForPackage(BaseDecoder.class).getBoolean("verifyChecksum", true);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0019J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010$\u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Lde/treichels/hott/decoder/internal/decoder/BaseDecoder$Companion;", "", "()V", "ISO_8859_1", "Ljava/nio/charset/Charset;", "getISO_8859_1", "()Ljava/nio/charset/Charset;", "UNUSED_ANNOUNCEMENT", "", "VERIFY_CHECKSUM", "", "getVERIFY_CHECKSUM", "()Z", "decode", "Lde/treichels/hott/model/BaseModel;", "port", "Lde/treichels/hott/decoder/HoTTSerialPort;", "modelNumber", "", "type", "Lde/treichels/hott/model/enums/ModelType;", "name", "data", "Ljava/io/InputStream;", "file", "Ljava/io/File;", "encode", "model", "dir", "getDecoder", "Lde/treichels/hott/decoder/internal/decoder/BaseDecoder;", "reader", "Lde/treichels/hott/decoder/internal/io/HoTTReader;", "Lde/treichels/hott/model/enums/TransmitterType;", "getRfId", "", "getTransmitterType", "HoTT-Decoder"})
    public static final class Companion {
        @NotNull
        public final Charset getISO_8859_1() {
            return ISO_8859_1;
        }

        public final boolean getVERIFY_CHECKSUM() {
            return VERIFY_CHECKSUM;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final BaseModel decode(@Nullable File file) {
            String fileName;
            if (file == null || !file.exists()) {
                throw (Throwable)new HoTTException("FileNotFound", file);
            }
            String string2 = fileName = file.getName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "fileName");
            if (!StringsKt.endsWith$default(string2, ".mdl", false, 2, null)) {
                throw (Throwable)new HoTTException("InvalidFileName", fileName);
            }
            ModelType type2 = ModelType.Companion.forChar(fileName.charAt(0));
            Object object = fileName;
            int n = 1;
            int n2 = fileName.length() - 4;
            String string3 = ((String)object).substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String name = string3;
            object = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)object;
                BaseModel baseModel = Companion.decode(type2, name, it);
                return baseModel;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final BaseModel decode(@NotNull HoTTSerialPort port, int modelNumber) {
            byte[] modelData;
            Intrinsics.checkParameterIsNotNull(port, "port");
            ModelInfo info = port.getModelInfo(modelNumber);
            Object object = modelData = port.getModelData(info);
            object = new ByteArrayInputStream((byte[])object);
            Throwable throwable = null;
            try {
                BaseModel baseModel;
                ByteArrayInputStream it = (ByteArrayInputStream)object;
                BaseModel $receiver = baseModel = Companion.decode(info.getModelType(), info.getModelName(), it);
                $receiver.setModelNumber(modelNumber);
                BaseModel baseModel2 = baseModel;
                return baseModel2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }

        @NotNull
        public final BaseModel decode(@NotNull ModelType type2, @NotNull String name, @NotNull InputStream data2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, "type");
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(data2, "data");
            HoTTReader reader = new HoTTReader(data2);
            BaseModel model = type2.getModel();
            model.setModelNumber(0);
            model.setModelName(name);
            BaseDecoder decoder2 = this.getDecoder(reader);
            if (data2.available() != decoder2.getFileLen() - 4) {
                throw (Throwable)new HoTTException("InvalidDataSize", decoder2.getFileLen(), data2.available() + 4);
            }
            model.setVendor(Vendor.Graupner);
            model.setTransmitterType(decoder2.getTransmitterType());
            decoder2.setModel(model);
            decoder2.setReader(reader);
            decoder2.decode();
            return model;
        }

        @NotNull
        public final BaseDecoder getDecoder(@NotNull HoTTSerialPort port) {
            Intrinsics.checkParameterIsNotNull(port, "port");
            return this.getDecoder(this.getTransmitterType(port));
        }

        private final BaseDecoder getDecoder(HoTTReader reader) {
            int productCode = reader.readInt();
            BaseDecoder decoder2 = this.getDecoder(TransmitterType.Companion.forProductCode(productCode));
            decoder2.setReader(reader);
            return decoder2;
        }

        @NotNull
        public final BaseDecoder getDecoder(@NotNull TransmitterType type2) {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            switch (BaseDecoder$Companion$WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1: {
                    return new MC16Decoder();
                }
                case 2: {
                    return new MC20Decoder();
                }
                case 3: {
                    return new MC26Decoder();
                }
                case 4: {
                    return new MC28Decoder();
                }
                case 5: {
                    return new MC32Decoder();
                }
                case 6: {
                    return new MX12Decoder();
                }
                case 7: {
                    return new MX16Decoder();
                }
                case 8: {
                    return new MX20Decoder();
                }
                case 9: {
                    return new MZ12Decoder();
                }
                case 10: {
                    return new MZ12ProDecoder();
                }
                case 11: {
                    return new MZ18Decoder();
                }
                case 12: {
                    return new MZ18ProDecoder();
                }
                case 13: {
                    return new MZ24Decoder();
                }
                case 14: {
                    return new MZ24ProDecoder();
                }
            }
            throw (Throwable)new HoTTException("InvalidTransmitterType", type2);
        }

        public final long getRfId(@NotNull HoTTSerialPort port) {
            Intrinsics.checkParameterIsNotNull(port, "port");
            Pair<ResponseCode, byte[]> pair = port.readMemoryBlock(0, 5);
            byte[] data2 = pair.component2();
            HoTTReader reader = new HoTTReader(data2);
            return reader.readUnsignedInt() + ((long)reader.readUnsignedByte() << 32);
        }

        private final TransmitterType getTransmitterType(HoTTSerialPort port) {
            return port.getTransmitterType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final File encode(@NotNull BaseModel model, @Nullable File dir) {
            Intrinsics.checkParameterIsNotNull(model, "model");
            if (dir == null || !dir.exists() || !dir.isDirectory()) {
                throw (Throwable)new HoTTException("DirNotFound", dir);
            }
            if (model.getVendor() != Vendor.Graupner) {
                throw (Throwable)new HoTTException("InvalidVendor", new Object[]{model.getVendor()});
            }
            StringBuilder fileName = new StringBuilder();
            fileName.append(model.getModelType().getChar());
            fileName.append(model.getModelName());
            fileName.append(".mdl");
            File file = new File(dir, fileName.toString());
            BaseDecoder encoder = this.getDecoder(model.getTransmitterType());
            Closeable closeable = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                HoTTWriter writer = new HoTTWriter(it);
                encoder.setWriter(writer);
                encoder.setModel(model);
                writer.writeInt(model.getTransmitterType().getProductCode());
                encoder.encode();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            return file;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

