/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.BivariateGridInterpolator;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.MathArrays;

@Deprecated
public class BicubicSplineInterpolator
implements BivariateGridInterpolator {
    private final boolean initializeDerivatives;

    public BicubicSplineInterpolator() {
        this(false);
    }

    public BicubicSplineInterpolator(boolean initializeDerivatives) {
        this.initializeDerivatives = initializeDerivatives;
    }

    public BicubicSplineInterpolatingFunction interpolate(double[] xval, double[] yval, double[][] fval) throws NoDataException, DimensionMismatchException, NonMonotonicSequenceException, NumberIsTooSmallException {
        if (xval.length == 0 || yval.length == 0 || fval.length == 0) {
            throw new NoDataException();
        }
        if (xval.length != fval.length) {
            throw new DimensionMismatchException(xval.length, fval.length);
        }
        MathArrays.checkOrder(xval);
        MathArrays.checkOrder(yval);
        int xLen = xval.length;
        int yLen = yval.length;
        double[][] fX = new double[yLen][xLen];
        for (int i2 = 0; i2 < xLen; ++i2) {
            if (fval[i2].length != yLen) {
                throw new DimensionMismatchException(fval[i2].length, yLen);
            }
            for (int j = 0; j < yLen; ++j) {
                fX[j][i2] = fval[i2][j];
            }
        }
        SplineInterpolator spInterpolator = new SplineInterpolator();
        PolynomialSplineFunction[] ySplineX = new PolynomialSplineFunction[yLen];
        for (int j = 0; j < yLen; ++j) {
            ySplineX[j] = spInterpolator.interpolate(xval, fX[j]);
        }
        PolynomialSplineFunction[] xSplineY = new PolynomialSplineFunction[xLen];
        for (int i3 = 0; i3 < xLen; ++i3) {
            xSplineY[i3] = spInterpolator.interpolate(yval, fval[i3]);
        }
        double[][] dFdX = new double[xLen][yLen];
        for (int j = 0; j < yLen; ++j) {
            UnivariateFunction f = ySplineX[j].derivative();
            for (int i4 = 0; i4 < xLen; ++i4) {
                dFdX[i4][j] = f.value(xval[i4]);
            }
        }
        double[][] dFdY = new double[xLen][yLen];
        for (int i5 = 0; i5 < xLen; ++i5) {
            UnivariateFunction f = xSplineY[i5].derivative();
            for (int j = 0; j < yLen; ++j) {
                dFdY[i5][j] = f.value(yval[j]);
            }
        }
        double[][] d2FdXdY = new double[xLen][yLen];
        for (int i6 = 0; i6 < xLen; ++i6) {
            int nI = this.nextIndex(i6, xLen);
            int pI = this.previousIndex(i6);
            for (int j = 0; j < yLen; ++j) {
                int nJ = this.nextIndex(j, yLen);
                int pJ = this.previousIndex(j);
                d2FdXdY[i6][j] = (fval[nI][nJ] - fval[nI][pJ] - fval[pI][nJ] + fval[pI][pJ]) / ((xval[nI] - xval[pI]) * (yval[nJ] - yval[pJ]));
            }
        }
        return new BicubicSplineInterpolatingFunction(xval, yval, fval, dFdX, dFdY, d2FdXdY, this.initializeDerivatives);
    }

    private int nextIndex(int i2, int max) {
        int index = i2 + 1;
        return index < max ? index : index - 1;
    }

    private int previousIndex(int i2) {
        int index = i2 - 1;
        return index >= 0 ? index : 0;
    }
}

