/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedType;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnsignedTypes {
    private static final Set<Name> unsignedTypeNames;
    private static final HashMap<ClassId, ClassId> arrayClassIdToUnsignedClassId;
    private static final HashMap<ClassId, ClassId> unsignedClassIdToArrayClassId;
    private static final Set<Name> arrayClassesShortNames;
    public static final UnsignedTypes INSTANCE;

    public final boolean isShortNameOfUnsignedArray(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return arrayClassesShortNames.contains(name);
    }

    @Nullable
    public final ClassId getUnsignedClassIdByArrayClassId(@NotNull ClassId arrayClassId) {
        Intrinsics.checkParameterIsNotNull(arrayClassId, "arrayClassId");
        return arrayClassIdToUnsignedClassId.get(arrayClassId);
    }

    @Nullable
    public final ClassId getUnsignedArrayClassIdByUnsignedClassId(@NotNull ClassId arrayClassId) {
        Intrinsics.checkParameterIsNotNull(arrayClassId, "arrayClassId");
        return unsignedClassIdToArrayClassId.get(arrayClassId);
    }

    public final boolean isUnsignedType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        if (TypeUtils.noExpectedType(type2)) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "type.constructor.declara\u2026escriptor ?: return false");
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        return this.isUnsignedClass(descriptor2);
    }

    public final boolean isUnsignedClass(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        return container instanceof PackageFragmentDescriptor && Intrinsics.areEqual(((PackageFragmentDescriptor)container).getFqName(), KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME) && unsignedTypeNames.contains(descriptor2.getName());
    }

    private UnsignedTypes() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        UnsignedType[] unsignedTypeArray;
        Name name;
        Collection collection;
        UnsignedType item$iv$iv;
        void $receiver$iv$iv;
        UnsignedTypes unsignedTypes;
        INSTANCE = unsignedTypes = new UnsignedTypes();
        UnsignedType[] $receiver$iv = UnsignedType.values();
        UnsignedType[] unsignedTypeArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        void var4_5 = $receiver$iv$iv;
        int n = ((void)var4_5).length;
        for (int j = 0; j < n; ++j) {
            void it;
            item$iv$iv = var4_5[j];
            void var8_13 = item$iv$iv;
            collection = destination$iv$iv;
            name = it.getTypeName();
            collection.add(name);
        }
        unsignedTypeNames = CollectionsKt.toSet((List)unsignedTypeArray);
        arrayClassIdToUnsignedClassId = new HashMap();
        unsignedClassIdToArrayClassId = new HashMap();
        $receiver$iv = UnsignedType.values();
        Collection destination$iv = new LinkedHashSet();
        unsignedTypeArray = $receiver$iv;
        int n2 = unsignedTypeArray.length;
        for (n = 0; n < n2; ++n) {
            void it;
            UnsignedType item$iv;
            item$iv$iv = item$iv = unsignedTypeArray[n];
            collection = destination$iv;
            name = it.getArrayClassId().getShortClassName();
            collection.add(name);
        }
        arrayClassesShortNames = (Set)unsignedTypeArray2;
        for (UnsignedType unsignedType : UnsignedType.values()) {
            Map map2 = arrayClassIdToUnsignedClassId;
            ClassId classId = unsignedType.getArrayClassId();
            ClassId classId2 = unsignedType.getClassId();
            map2.put(classId, classId2);
            map2 = unsignedClassIdToArrayClassId;
            classId = unsignedType.getClassId();
            classId2 = unsignedType.getArrayClassId();
            map2.put(classId, classId2);
        }
    }
}

