/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.mdlviewer.swt.dialogs;

import de.treichels.hott.decoder.HoTTDecoder;
import de.treichels.hott.mdlviewer.swt.dialogs.SelectFromTransmitterDialog;
import de.treichels.hott.model.enums.ModelType;
import de.treichels.hott.serial.ModelInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SelectFromMemoryDialog
extends SelectFromTransmitterDialog {
    private org.eclipse.swt.widgets.List list;
    private final List<ModelInfo> infos = new ArrayList<ModelInfo>();

    public SelectFromMemoryDialog(Shell parent) {
        super(parent);
    }

    @Override
    protected void getSelectionComponent(Composite dialog2) {
        this.list = new org.eclipse.swt.widgets.List(dialog2, 2564);
        this.list.addListener(14, new DefaultListener());
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.list.setLayoutData(gridData);
    }

    @Override
    protected void onCancel() {
        this.model = null;
    }

    @Override
    protected void onOpen() {
        BusyIndicator.showWhile(this.getParent().getDisplay(), new OpenRunner());
    }

    @Override
    protected void onReload() {
        BusyIndicator.showWhile(this.getParent().getDisplay(), new ReloadRunner());
    }

    private final class ReloadRunner
    implements Runnable {
        private ReloadRunner() {
        }

        @Override
        public void run() {
            try {
                List<ModelInfo> i2 = SelectFromMemoryDialog.this.port.getAllModelInfos();
                SelectFromMemoryDialog.this.list.removeAll();
                for (ModelInfo info : i2) {
                    if (info.getModelType() == ModelType.Unknown) continue;
                    SelectFromMemoryDialog.this.infos.add(info);
                    SelectFromMemoryDialog.this.list.add(String.format("%02d: %c%s.mdl", info.getModelNumber(), Character.valueOf(info.getModelType().getChar()), info.getModelName()));
                }
            }
            catch (Throwable t) {
                SelectFromMemoryDialog.this.showError(t);
            }
        }
    }

    private final class OpenRunner
    implements Runnable {
        private OpenRunner() {
        }

        @Override
        public void run() {
            try {
                int index = SelectFromMemoryDialog.this.list.getSelectionIndex();
                int modelNumber = ((ModelInfo)SelectFromMemoryDialog.this.infos.get(index)).getModelNumber();
                SelectFromMemoryDialog.this.model = HoTTDecoder.INSTANCE.decodeMemory(SelectFromMemoryDialog.this.port, modelNumber);
            }
            catch (Throwable t) {
                SelectFromMemoryDialog.this.showError(t);
            }
        }
    }

    private final class DefaultListener
    implements Listener {
        private DefaultListener() {
        }

        @Override
        public void handleEvent(Event arg0) {
            SelectFromMemoryDialog.this.onOpen();
            SelectFromMemoryDialog.this.dialog.close();
        }
    }
}

