/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder;

import de.treichels.hott.model.enums.Registered;
import de.treichels.hott.util.Callback;
import de.treichels.hott.util.HashUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Request;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0001\u001fB%\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001b\u001a\u00020\fJ\u0010\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\b\u0010\u001e\u001a\u00020\u0006H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lde/treichels/hott/decoder/Firmware;", "T", "Lde/treichels/hott/model/enums/Registered;", "", "device", "path", "", "name", "size", "", "(Lde/treichels/hott/model/enums/Registered;Ljava/lang/String;Ljava/lang/String;J)V", "cacheDir", "Ljava/io/File;", "getDevice", "()Lde/treichels/hott/model/enums/Registered;", "Lde/treichels/hott/model/enums/Registered;", "file", "getFile", "()Ljava/io/File;", "isCached", "", "()Z", "getName", "()Ljava/lang/String;", "getPath", "getSize", "()J", "download", "task", "Lde/treichels/hott/util/Callback;", "toString", "Companion", "HoTT-Decoder"})
public final class Firmware<T extends Registered<?>> {
    private final File cacheDir;
    @NotNull
    private final File file;
    @NotNull
    private final T device;
    @NotNull
    private final String path;
    @NotNull
    private final String name;
    private final long size;
    private static final Logger LOG;
    private static final String FTP_SERVER_ADDRESS = "data.graupnersj.com";
    private static final String FILE_LIST = "file_list.php";
    private static final String FILE_DOWN = "file_down.php";
    public static final Companion Companion;

    @NotNull
    public String toString() {
        return this.device + " -> " + this.path + this.name + ':' + this.size;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final boolean isCached() {
        return this.file.exists() && this.file.length() == this.size;
    }

    @NotNull
    public final File download(@Nullable Callback task2) {
        if (!this.isCached()) {
            Callback callback = task2;
            if (callback == null || !callback.isCancelled()) {
                this.cacheDir.mkdirs();
                Companion.download(task2, this.path + this.name, this.file);
            }
        }
        return this.file;
    }

    @NotNull
    public final File download() {
        return this.download(null);
    }

    @NotNull
    public final T getDevice() {
        return this.device;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getSize() {
        return this.size;
    }

    public Firmware(@NotNull T device, @NotNull String path2, @NotNull String name, long size) {
        Intrinsics.checkParameterIsNotNull(device, "device");
        Intrinsics.checkParameterIsNotNull(path2, "path");
        Intrinsics.checkParameterIsNotNull(name, "name");
        this.device = device;
        this.path = path2;
        this.name = name;
        this.size = size;
        this.cacheDir = new File(System.getProperty("user.home") + "/.java/cache/HoTT/firmware/" + this.device.getName());
        this.file = new File(this.cacheDir, this.name);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getLogger("javaClass");
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJB\u0010\n\u001a\u0002H\u0010\"\u0004\b\u0001\u0010\u00102\u0006\u0010\r\u001a\u00020\u00042'\u0010\u0011\u001a#\u0012\u0004\u0012\u00020\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u0002H\u00100\u0012\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u001b0\u001a\"\f\b\u0001\u0010\u0010*\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010\u001eJ5\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u001b0\u001a\"\f\b\u0001\u0010\u0010*\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u0002H\u00102\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!J=\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u001b0\u001a\"\f\b\u0001\u0010\u0010*\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u0002H\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020 \u00a2\u0006\u0002\u0010#J5\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u001b0\u001a\"\f\b\u0001\u0010\u0010*\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u0002H\u00102\u0006\u0010$\u001a\u00020\u0004\u00a2\u0006\u0002\u0010%J=\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u001b0\u001a\"\f\b\u0001\u0010\u0010*\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u0002H\u00102\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0001\u00a2\u0006\u0002\u0010&J\"\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00140'0\u001a2\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lde/treichels/hott/decoder/Firmware$Companion;", "", "()V", "FILE_DOWN", "", "FILE_LIST", "FTP_SERVER_ADDRESS", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "download", "task", "Lde/treichels/hott/util/Callback;", "path", "file", "Ljava/io/File;", "T", "func", "Lkotlin/Function2;", "Ljava/io/InputStream;", "", "Lkotlin/ParameterName;", "name", "size", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "list", "", "Lde/treichels/hott/decoder/Firmware;", "Lde/treichels/hott/model/enums/Registered;", "device", "(Lde/treichels/hott/model/enums/Registered;)Ljava/util/List;", "productCode", "", "(Lde/treichels/hott/model/enums/Registered;I)Ljava/util/List;", "mask", "(Lde/treichels/hott/model/enums/Registered;II)Ljava/util/List;", "category", "(Lde/treichels/hott/model/enums/Registered;Ljava/lang/String;)Ljava/util/List;", "(Lde/treichels/hott/model/enums/Registered;Ljava/lang/String;Ljava/lang/Object;)Ljava/util/List;", "Lkotlin/Pair;", "HoTT-Decoder"})
    public static final class Companion {
        @NotNull
        public final <T extends Registered<?>> List<Firmware<T>> list(@NotNull T device) {
            Intrinsics.checkParameterIsNotNull(device, "device");
            return this.list(device, device.getCategory(), (Object)device.getProductCode());
        }

        @NotNull
        public final <T extends Registered<?>> List<Firmware<T>> list(@NotNull T device, @NotNull String category) {
            Intrinsics.checkParameterIsNotNull(device, "device");
            Intrinsics.checkParameterIsNotNull(category, "category");
            return this.list(device, category, (Object)device.getProductCode());
        }

        @NotNull
        public final <T extends Registered<?>> List<Firmware<T>> list(@NotNull T device, int productCode) {
            Intrinsics.checkParameterIsNotNull(device, "device");
            return this.list(device, device.getCategory(), (Object)productCode);
        }

        @NotNull
        public final <T extends Registered<?>> List<Firmware<T>> list(@NotNull T device, int productCode, int mask) {
            Intrinsics.checkParameterIsNotNull(device, "device");
            int part = productCode % mask;
            int min = mask / 10;
            return part >= min ? this.list(device, device.getCategory(), (Object)part) : CollectionsKt.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <T extends Registered<?>> List<Firmware<T>> list(@NotNull T device, @NotNull String category, @NotNull Object productCode) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(device, "device");
            Intrinsics.checkParameterIsNotNull(category, "category");
            Intrinsics.checkParameterIsNotNull(productCode, "productCode");
            String path2 = "/Firmware/" + category + '/' + productCode + '/';
            Iterable iterable = $receiver$iv = (Iterable)this.list(path2);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void $name_size;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                String name = (String)$name_size.component1();
                long size = ((Number)$name_size.component2()).longValue();
                Firmware<T> firmware = new Firmware<T>(device, path2, name, size);
                collection.add(firmware);
            }
            return (List)destination$iv$iv;
        }

        private final List<Pair<String, Long>> list(String path2) {
            Object t = Request.Post("http://data.graupnersj.com/file_list.php").bodyForm(new BasicNameValuePair("path", path2)).execute().handleResponse(new ResponseHandler<List<? extends Pair<? extends String, ? extends Long>>>(path2){
                final /* synthetic */ String $path;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<Pair<String, Long>> handleResponse(HttpResponse response) {
                    void $receiver$iv$iv;
                    Object object;
                    HttpResponse httpResponse = response;
                    Intrinsics.checkExpressionValueIsNotNull(httpResponse, "response");
                    Object $receiver = object = httpResponse.getStatusLine();
                    Firmware.access$getLOG$cp().finer(this.$path + " -> " + $receiver);
                    if ($receiver.getStatusCode() != 200) {
                        throw (Throwable)new IOException($receiver.toString());
                    }
                    HttpEntity httpEntity = response.getEntity();
                    Intrinsics.checkExpressionValueIsNotNull(httpEntity, "response.entity");
                    InputStream inputStream2 = httpEntity.getContent();
                    Intrinsics.checkExpressionValueIsNotNull(inputStream2, "response.entity.content");
                    object = inputStream2;
                    $receiver = Charsets.UTF_8;
                    Iterable $receiver$iv = TextStreamsKt.readLines(new InputStreamReader((InputStream)object, (Charset)$receiver));
                    $receiver = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void line2;
                        String string2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        Firmware.access$getLOG$cp().finer((String)line2);
                        List parts = StringsKt.split$default((CharSequence)line2, new String[]{"|"}, false, 0, 6, null);
                        String name = (String)parts.get(0);
                        String string3 = (String)parts.get(1);
                        long size = Long.parseLong(string3);
                        Pair<String, Long> pair = new Pair<String, Long>(name, size);
                        collection.add(pair);
                    }
                    return (List)destination$iv$iv;
                }
                {
                    this.$path = string2;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(t, "Request.Post(\"http://$FT\u2026)\n            }\n        }");
            return (List)t;
        }

        public final <T> T download(@NotNull String path2, @NotNull Function2<? super InputStream, ? super Long, ? extends T> func) {
            Intrinsics.checkParameterIsNotNull(path2, "path");
            Intrinsics.checkParameterIsNotNull(func, "func");
            return Request.Post("http://data.graupnersj.com/file_down.php").bodyForm(new BasicNameValuePair("file", path2)).execute().handleResponse(new ResponseHandler<T>(func){
                final /* synthetic */ Function2 $func;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final T handleResponse(HttpResponse response) {
                    R r;
                    HttpResponse httpResponse = response;
                    Intrinsics.checkExpressionValueIsNotNull(httpResponse, "response");
                    Object object = httpResponse.getStatusLine();
                    StatusLine $receiver = object;
                    if ($receiver.getStatusCode() != 200) {
                        throw (Throwable)new IOException($receiver.toString());
                    }
                    HttpEntity httpEntity = response.getEntity();
                    Intrinsics.checkExpressionValueIsNotNull(httpEntity, "response.entity");
                    object = httpEntity.getContent();
                    Throwable throwable = null;
                    try {
                        InputStream it;
                        InputStream inputStream2 = it = (InputStream)object;
                        Intrinsics.checkExpressionValueIsNotNull(inputStream2, "it");
                        HttpEntity httpEntity2 = response.getEntity();
                        Intrinsics.checkExpressionValueIsNotNull(httpEntity2, "response.entity");
                        r = this.$func.invoke(inputStream2, httpEntity2.getContentLength());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, throwable);
                    }
                    return (T)r;
                }
                {
                    this.$func = function2;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String download(@Nullable Callback task2, @NotNull String path2, @NotNull File file) {
            void bytesRead;
            Intrinsics.checkParameterIsNotNull(path2, "path");
            Intrinsics.checkParameterIsNotNull(file, "file");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[0x100000];
            Ref.LongRef longRef = new Ref.LongRef();
            longRef.element = 0L;
            this.download(path2, (Function2)new Function2<InputStream, Long, Unit>(file, task2, buffer, (Ref.LongRef)bytesRead, md){
                final /* synthetic */ File $file;
                final /* synthetic */ Callback $task;
                final /* synthetic */ byte[] $buffer;
                final /* synthetic */ Ref.LongRef $bytesRead;
                final /* synthetic */ MessageDigest $md;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull InputStream inputStream2, long size) {
                    Intrinsics.checkParameterIsNotNull(inputStream2, "inputStream");
                    Object object = this.$file;
                    object = new FileOutputStream((File)object);
                    Throwable throwable = null;
                    try {
                        FileOutputStream outputStream = (FileOutputStream)object;
                        while (true) {
                            Callback callback = this.$task;
                            if (callback != null && !callback.isCancelled()) break;
                            int len = inputStream2.read(this.$buffer);
                            if (len < 0) break;
                            this.$bytesRead.element += (long)len;
                            outputStream.write(this.$buffer, 0, len);
                            this.$md.update(this.$buffer, 0, len);
                            Callback callback2 = this.$task;
                            if (callback2 == null) continue;
                            callback2.updateProgress(this.$bytesRead.element, size);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, throwable);
                    }
                    if (size > 0L && this.$bytesRead.element != size) {
                        throw (Throwable)new IOException("Size mismatch: expected " + size + ", but got " + this.$bytesRead.element + '.');
                    }
                }
                {
                    this.$file = file;
                    this.$task = callback;
                    this.$buffer = byArray;
                    this.$bytesRead = longRef;
                    this.$md = messageDigest;
                    super(2);
                }
            });
            Callback callback = task2;
            if (callback != null) {
                if (callback.isCancelled()) {
                    throw (Throwable)new InterruptedException();
                }
            }
            MessageDigest messageDigest = md;
            Intrinsics.checkExpressionValueIsNotNull(messageDigest, "md");
            return HashUtilsKt.getHash(messageDigest);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

