/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.java;

import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.MetadataParserImpl;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;

final class ID3MetadataParser
extends MetadataParserImpl {
    private static final int ID3_VERSION_MIN = 2;
    private static final int ID3_VERSION_MAX = 4;
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final String CHARSET_ISO_8859_1 = "ISO-8859-1";
    private static final String CHARSET_UTF_16 = "UTF-16";
    private static final String CHARSET_UTF_16BE = "UTF-16BE";
    private int COMMCount = 0;
    private int TXXXCount = 0;
    private int version = 3;
    private boolean unsynchronized = false;

    public ID3MetadataParser(Locator locator) {
        super(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parse() {
        block32: {
            try {
                int n;
                if (!Charset.isSupported(CHARSET_ISO_8859_1)) {
                    throw new UnsupportedCharsetException(CHARSET_ISO_8859_1);
                }
                byte[] byArray = this.getBytes(10);
                this.version = byArray[3] & 0xFF;
                if (byArray[0] != 73 || byArray[1] != 68 || byArray[2] != 51 || this.version < 2 || this.version > 4) break block32;
                int n2 = byArray[5] & 0xFF;
                if ((n2 & 0x80) == 128) {
                    this.unsynchronized = true;
                }
                int n3 = 0;
                int n4 = 21;
                for (n = 6; n < 10; ++n) {
                    n3 += (byArray[n] & 0x7F) << n4;
                    n4 -= 7;
                }
                this.startRawMetadata(n3 + 10);
                this.stuffRawMetadata(byArray, 0, 10);
                this.readRawMetadata(n3);
                this.setParseRawMetadata(true);
                this.skipBytes(10);
                while (this.getStreamPosition() < n3) {
                    Object object;
                    Object object2;
                    String string2;
                    byte[] byArray2;
                    Object object3;
                    byte[] byArray3;
                    if (2 == this.version) {
                        byArray3 = this.getBytes(3);
                        n = this.getU24();
                    } else {
                        byArray3 = this.getBytes(4);
                        n = this.getFrameSize();
                        this.skipBytes(2);
                    }
                    if (0 == byArray3[0]) {
                        if (Logger.canLog(1)) {
                            Logger.logMsg(1, "ID3MetadataParser", "parse", "ID3 parser: zero padding detected at " + this.getStreamPosition() + ", terminating");
                        }
                        break;
                    }
                    String string3 = new String(byArray3, Charset.forName(CHARSET_ISO_8859_1));
                    if (Logger.canLog(1)) {
                        Logger.logMsg(1, "ID3MetadataParser", "parse", this.getStreamPosition() + "\\" + n3 + ": frame ID " + string3 + ", size " + n);
                    }
                    if (string3.equals("APIC") || string3.equals("PIC")) {
                        object3 = this.getBytes(n);
                        if (this.unsynchronized) {
                            object3 = this.unsynchronizeBuffer((byte[])object3);
                        }
                        if ((byArray2 = string3.equals("PIC") ? this.getImageFromPIC((byte[])object3) : this.getImageFromAPIC((byte[])object3)) == null) continue;
                        this.addMetadataItem("image", byArray2);
                        continue;
                    }
                    if (string3.startsWith("T") && !string3.equals("TXXX")) {
                        object3 = this.getEncoding();
                        byArray2 = this.getBytes(n - 1);
                        if (this.unsynchronized) {
                            byArray2 = this.unsynchronizeBuffer(byArray2);
                        }
                        string2 = new String(byArray2, (String)object3);
                        String[] stringArray = this.getTagFromFrameID(string3);
                        if (stringArray == null) continue;
                        for (int j = 0; j < stringArray.length; ++j) {
                            object2 = this.convertValue(stringArray[j], string2);
                            if (object2 == null) continue;
                            this.addMetadataItem(stringArray[j], object2);
                        }
                        continue;
                    }
                    if (string3.equals("COMM") || string3.equals("COM")) {
                        String[] stringArray;
                        String string4;
                        object3 = this.getEncoding();
                        byArray2 = this.getBytes(3);
                        if (this.unsynchronized) {
                            byArray2 = this.unsynchronizeBuffer(byArray2);
                        }
                        string2 = new String(byArray2, Charset.forName(CHARSET_ISO_8859_1));
                        byArray2 = this.getBytes(n - 4);
                        if (this.unsynchronized) {
                            byArray2 = this.unsynchronizeBuffer(byArray2);
                        }
                        if ((string4 = new String(byArray2, (String)object3)) == null) continue;
                        int n5 = string4.indexOf(0);
                        object2 = "";
                        if (n5 == 0) {
                            object = this.isTwoByteEncoding((String)object3) ? string4.substring(2) : string4.substring(1);
                        } else {
                            object2 = string4.substring(0, n5);
                            object = this.isTwoByteEncoding((String)object3) ? string4.substring(n5 + 2) : string4.substring(n5 + 1);
                        }
                        if ((stringArray = this.getTagFromFrameID(string3)) == null) continue;
                        for (int j = 0; j < stringArray.length; ++j) {
                            this.addMetadataItem(stringArray[j] + "-" + this.COMMCount, (String)object2 + "[" + string2 + "]=" + (String)object);
                            ++this.COMMCount;
                        }
                        continue;
                    }
                    if (string3.equals("TXX") || string3.equals("TXXX")) {
                        object3 = this.getEncoding();
                        byArray2 = this.getBytes(n - 1);
                        if (this.unsynchronized) {
                            byArray2 = this.unsynchronizeBuffer(byArray2);
                        }
                        if (null == (string2 = new String(byArray2, (String)object3))) continue;
                        int n6 = string2.indexOf(0);
                        String string5 = n6 != 0 ? string2.substring(0, n6) : "";
                        Object object4 = object2 = this.isTwoByteEncoding((String)object3) ? string2.substring(n6 + 2) : string2.substring(n6 + 1);
                        object = this.getTagFromFrameID(string3);
                        if (object == null) continue;
                        for (int j = 0; j < ((String[])object).length; ++j) {
                            if (string5.equals("")) {
                                this.addMetadataItem(object[j] + "-" + this.TXXXCount, object2);
                            } else {
                                this.addMetadataItem(object[j] + "-" + this.TXXXCount, string5 + "=" + (String)object2);
                            }
                            ++this.TXXXCount;
                        }
                        continue;
                    }
                    this.skipBytes(n);
                }
            }
            catch (Exception exception) {
                if (Logger.canLog(3)) {
                    Logger.logMsg(3, "ID3MetadataParser", "parse", "Exception while processing ID3v2 metadata: " + exception);
                }
            }
            finally {
                if (null != this.rawMetaBlob) {
                    this.setParseRawMetadata(false);
                    this.addRawMetadata("ID3");
                    this.disposeRawMetadata();
                }
                this.done();
            }
        }
    }

    private int getFrameSize() throws IOException {
        if (this.version == 4) {
            byte[] byArray = this.getBytes(4);
            int n = 0;
            int n2 = 21;
            for (int j = 0; j < 4; ++j) {
                n += (byArray[j] & 0x7F) << n2;
                n2 -= 7;
            }
            return n;
        }
        return this.getInteger();
    }

    private String getEncoding() throws IOException {
        byte by = this.getNextByte();
        if (by == 0) {
            return CHARSET_ISO_8859_1;
        }
        if (by == 1) {
            return CHARSET_UTF_16;
        }
        if (by == 2) {
            return CHARSET_UTF_16BE;
        }
        if (by == 3) {
            return CHARSET_UTF_8;
        }
        throw new IllegalArgumentException();
    }

    private boolean isTwoByteEncoding(String string2) {
        if (string2.equals(CHARSET_ISO_8859_1) || string2.equals(CHARSET_UTF_8)) {
            return false;
        }
        if (string2.equals(CHARSET_UTF_16) || string2.equals(CHARSET_UTF_16BE)) {
            return true;
        }
        throw new IllegalArgumentException();
    }

    private String[] getTagFromFrameID(String string2) {
        if (string2.equals("TPE2") || string2.equals("TP2")) {
            return new String[]{"album artist"};
        }
        if (string2.equals("TALB") || string2.equals("TAL")) {
            return new String[]{"album"};
        }
        if (string2.equals("TPE1") || string2.equals("TP1")) {
            return new String[]{"artist"};
        }
        if (string2.equals("COMM") || string2.equals("COM")) {
            return new String[]{"comment"};
        }
        if (string2.equals("TCOM") || string2.equals("TCM")) {
            return new String[]{"composer"};
        }
        if (string2.equals("TLEN") || string2.equals("TLE")) {
            return new String[]{"duration"};
        }
        if (string2.equals("TCON") || string2.equals("TCO")) {
            return new String[]{"genre"};
        }
        if (string2.equals("TIT2") || string2.equals("TT2")) {
            return new String[]{"title"};
        }
        if (string2.equals("TRCK") || string2.equals("TRK")) {
            return new String[]{"track number", "track count"};
        }
        if (string2.equals("TPOS") || string2.equals("TPA")) {
            return new String[]{"disc number", "disc count"};
        }
        if (string2.equals("TYER") || string2.equals("TDRC")) {
            return new String[]{"year"};
        }
        if (string2.equals("TXX") || string2.equals("TXXX")) {
            return new String[]{"text"};
        }
        return null;
    }

    private byte[] getImageFromPIC(byte[] byArray) {
        int n;
        for (n = 5; 0 != byArray[n] && n < byArray.length; ++n) {
        }
        if (n == byArray.length) {
            return null;
        }
        String string2 = new String(byArray, 1, 3, Charset.forName(CHARSET_ISO_8859_1));
        if (Logger.canLog(1)) {
            Logger.logMsg(1, "ID3MetadataParser", "getImageFromPIC", "PIC type: " + string2);
        }
        if (string2.equalsIgnoreCase("PNG") || string2.equalsIgnoreCase("JPG")) {
            return Arrays.copyOfRange(byArray, n + 1, byArray.length);
        }
        if (Logger.canLog(3)) {
            Logger.logMsg(3, "ID3MetadataParser", "getImageFromPIC", "Unsupported picture type found \"" + string2 + "\"");
        }
        return null;
    }

    private byte[] getImageFromAPIC(byte[] byArray) {
        int n;
        int n2;
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = byArray.length - 10;
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (byArray[n3] != 105 || byArray[n3 + 1] != 109 || byArray[n3 + 2] != 97 || byArray[n3 + 3] != 103 || byArray[n3 + 4] != 101 || byArray[n3 + 5] != 47) continue;
            if (byArray[n3 += 6] == 106 && byArray[n3 + 1] == 112 && byArray[n3 + 2] == 101 && byArray[n3 + 3] == 103) {
                bl = true;
                n5 = n3 + 4;
                break;
            }
            if (byArray[n3] != 112 || byArray[n3 + 1] != 110 || byArray[n3 + 2] != 103) continue;
            bl2 = true;
            n5 = n3 + 3;
            break;
        }
        if (bl) {
            n3 = 0;
            n2 = byArray.length - 1;
            for (n = n5; n < n2; ++n) {
                if (-1 != byArray[n] || -40 != byArray[n + 1]) continue;
                n3 = 1;
                n5 = n;
                break;
            }
            if (n3 != 0) {
                return Arrays.copyOfRange(byArray, n5, byArray.length);
            }
        }
        if (bl2) {
            n3 = 0;
            n2 = byArray.length - 7;
            for (n = n5; n < n2; ++n) {
                if (-119 != byArray[n] || 80 != byArray[n + 1] || 78 != byArray[n + 2] || 71 != byArray[n + 3] || 13 != byArray[n + 4] || 10 != byArray[n + 5] || 26 != byArray[n + 6] || 10 != byArray[n + 7]) continue;
                n3 = 1;
                n5 = n;
                break;
            }
            if (n3 != 0) {
                return Arrays.copyOfRange(byArray, n5, byArray.length);
            }
        }
        return null;
    }

    private byte[] unsynchronizeBuffer(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        for (int j = 0; j < byArray.length; ++j) {
            if ((byArray[j] & 0xFF) == 255 && byArray[j + 1] == 0 && byArray[j + 2] == 0 || (byArray[j] & 0xFF) == 255 && byArray[j + 1] == 0 && (byArray[j + 2] & 0xE0) == 224) {
                byArray2[n] = byArray[j];
                byArray2[++n] = byArray[j + 2];
                ++n;
                j += 2;
                continue;
            }
            byArray2[n] = byArray[j];
            ++n;
        }
        return Arrays.copyOf(byArray2, n);
    }
}

