/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

import com.itextpdf.text.pdf.qrcode.ByteMatrix;
import com.itextpdf.text.pdf.qrcode.EncodeHintType;
import com.itextpdf.text.pdf.qrcode.Encoder;
import com.itextpdf.text.pdf.qrcode.ErrorCorrectionLevel;
import com.itextpdf.text.pdf.qrcode.QRCode;
import com.itextpdf.text.pdf.qrcode.WriterException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QRCodeWriter {
    private static final int QUIET_ZONE_SIZE = 4;

    public ByteMatrix encode(String contents, int width, int height) throws WriterException {
        return this.encode(contents, width, height, null);
    }

    public ByteMatrix encode(String contents, int width, int height, Map<EncodeHintType, Object> hints) throws WriterException {
        ErrorCorrectionLevel requestedECLevel;
        if (contents == null || contents.length() == 0) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + width + 'x' + height);
        }
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        if (hints != null && (requestedECLevel = (ErrorCorrectionLevel)hints.get(EncodeHintType.ERROR_CORRECTION)) != null) {
            errorCorrectionLevel = requestedECLevel;
        }
        QRCode code = new QRCode();
        Encoder.encode(contents, errorCorrectionLevel, hints, code);
        return QRCodeWriter.renderResult(code, width, height);
    }

    private static ByteMatrix renderResult(QRCode code, int width, int height) {
        int offset;
        ByteMatrix input = code.getMatrix();
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        int qrWidth = inputWidth + 8;
        int qrHeight = inputHeight + 8;
        int outputWidth = Math.max(width, qrWidth);
        int outputHeight = Math.max(height, qrHeight);
        int multiple = Math.min(outputWidth / qrWidth, outputHeight / qrHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        ByteMatrix output = new ByteMatrix(outputWidth, outputHeight);
        byte[][] outputArray = output.getArray();
        byte[] row2 = new byte[outputWidth];
        for (int y = 0; y < topPadding; ++y) {
            QRCodeWriter.setRowColor(outputArray[y], (byte)-1);
        }
        byte[][] inputArray = input.getArray();
        for (int y = 0; y < inputHeight; ++y) {
            int x;
            for (int x2 = 0; x2 < leftPadding; ++x2) {
                row2[x2] = -1;
            }
            int offset2 = leftPadding;
            for (x = 0; x < inputWidth; ++x) {
                int value = inputArray[y][x] == 1 ? 0 : -1;
                for (int z = 0; z < multiple; ++z) {
                    row2[offset2 + z] = value;
                }
                offset2 += multiple;
            }
            for (x = offset2 = leftPadding + inputWidth * multiple; x < outputWidth; ++x) {
                row2[x] = -1;
            }
            offset2 = topPadding + y * multiple;
            for (int z = 0; z < multiple; ++z) {
                System.arraycopy(row2, 0, outputArray[offset2 + z], 0, outputWidth);
            }
        }
        for (int y = offset = topPadding + inputHeight * multiple; y < outputHeight; ++y) {
            QRCodeWriter.setRowColor(outputArray[y], (byte)-1);
        }
        return output;
    }

    private static void setRowColor(byte[] row2, byte value) {
        for (int x = 0; x < row2.length; ++x) {
            row2[x] = value;
        }
    }
}

