/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

import com.itextpdf.text.pdf.qrcode.GF256;

final class GF256Poly {
    private final GF256 field;
    private final int[] coefficients;

    GF256Poly(GF256 field2, int[] coefficients) {
        if (coefficients == null || coefficients.length == 0) {
            throw new IllegalArgumentException();
        }
        this.field = field2;
        int coefficientsLength = coefficients.length;
        if (coefficientsLength > 1 && coefficients[0] == 0) {
            int firstNonZero;
            for (firstNonZero = 1; firstNonZero < coefficientsLength && coefficients[firstNonZero] == 0; ++firstNonZero) {
            }
            if (firstNonZero == coefficientsLength) {
                this.coefficients = field2.getZero().coefficients;
            } else {
                this.coefficients = new int[coefficientsLength - firstNonZero];
                System.arraycopy(coefficients, firstNonZero, this.coefficients, 0, this.coefficients.length);
            }
        } else {
            this.coefficients = coefficients;
        }
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int degree) {
        return this.coefficients[this.coefficients.length - 1 - degree];
    }

    int evaluateAt(int a) {
        if (a == 0) {
            return this.getCoefficient(0);
        }
        int size = this.coefficients.length;
        if (a == 1) {
            int result2 = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                result2 = GF256.addOrSubtract(result2, this.coefficients[i2]);
            }
            return result2;
        }
        int result3 = this.coefficients[0];
        for (int i3 = 1; i3 < size; ++i3) {
            result3 = GF256.addOrSubtract(this.field.multiply(a, result3), this.coefficients[i3]);
        }
        return result3;
    }

    GF256Poly addOrSubtract(GF256Poly other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException("GF256Polys do not have same GF256 field");
        }
        if (this.isZero()) {
            return other;
        }
        if (other.isZero()) {
            return this;
        }
        int[] smallerCoefficients = this.coefficients;
        int[] largerCoefficients = other.coefficients;
        if (smallerCoefficients.length > largerCoefficients.length) {
            int[] temp = smallerCoefficients;
            smallerCoefficients = largerCoefficients;
            largerCoefficients = temp;
        }
        int[] sumDiff = new int[largerCoefficients.length];
        int lengthDiff = largerCoefficients.length - smallerCoefficients.length;
        System.arraycopy(largerCoefficients, 0, sumDiff, 0, lengthDiff);
        for (int i2 = lengthDiff; i2 < largerCoefficients.length; ++i2) {
            sumDiff[i2] = GF256.addOrSubtract(smallerCoefficients[i2 - lengthDiff], largerCoefficients[i2]);
        }
        return new GF256Poly(this.field, sumDiff);
    }

    GF256Poly multiply(GF256Poly other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException("GF256Polys do not have same GF256 field");
        }
        if (this.isZero() || other.isZero()) {
            return this.field.getZero();
        }
        int[] aCoefficients = this.coefficients;
        int aLength = aCoefficients.length;
        int[] bCoefficients = other.coefficients;
        int bLength = bCoefficients.length;
        int[] product = new int[aLength + bLength - 1];
        for (int i2 = 0; i2 < aLength; ++i2) {
            int aCoeff = aCoefficients[i2];
            for (int j = 0; j < bLength; ++j) {
                product[i2 + j] = GF256.addOrSubtract(product[i2 + j], this.field.multiply(aCoeff, bCoefficients[j]));
            }
        }
        return new GF256Poly(this.field, product);
    }

    GF256Poly multiply(int scalar) {
        if (scalar == 0) {
            return this.field.getZero();
        }
        if (scalar == 1) {
            return this;
        }
        int size = this.coefficients.length;
        int[] product = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            product[i2] = this.field.multiply(this.coefficients[i2], scalar);
        }
        return new GF256Poly(this.field, product);
    }

    GF256Poly multiplyByMonomial(int degree, int coefficient) {
        if (degree < 0) {
            throw new IllegalArgumentException();
        }
        if (coefficient == 0) {
            return this.field.getZero();
        }
        int size = this.coefficients.length;
        int[] product = new int[size + degree];
        for (int i2 = 0; i2 < size; ++i2) {
            product[i2] = this.field.multiply(this.coefficients[i2], coefficient);
        }
        return new GF256Poly(this.field, product);
    }

    GF256Poly[] divide(GF256Poly other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException("GF256Polys do not have same GF256 field");
        }
        if (other.isZero()) {
            throw new IllegalArgumentException("Divide by 0");
        }
        GF256Poly quotient = this.field.getZero();
        GF256Poly remainder = this;
        int denominatorLeadingTerm = other.getCoefficient(other.getDegree());
        int inverseDenominatorLeadingTerm = this.field.inverse(denominatorLeadingTerm);
        while (remainder.getDegree() >= other.getDegree() && !remainder.isZero()) {
            int degreeDifference = remainder.getDegree() - other.getDegree();
            int scale2 = this.field.multiply(remainder.getCoefficient(remainder.getDegree()), inverseDenominatorLeadingTerm);
            GF256Poly term = other.multiplyByMonomial(degreeDifference, scale2);
            GF256Poly iterationQuotient = this.field.buildMonomial(degreeDifference, scale2);
            quotient = quotient.addOrSubtract(iterationQuotient);
            remainder = remainder.addOrSubtract(term);
        }
        return new GF256Poly[]{quotient, remainder};
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer(8 * this.getDegree());
        for (int degree = this.getDegree(); degree >= 0; --degree) {
            int coefficient = this.getCoefficient(degree);
            if (coefficient == 0) continue;
            if (coefficient < 0) {
                result2.append(" - ");
                coefficient = -coefficient;
            } else if (result2.length() > 0) {
                result2.append(" + ");
            }
            if (degree == 0 || coefficient != 1) {
                int alphaPower = this.field.log(coefficient);
                if (alphaPower == 0) {
                    result2.append('1');
                } else if (alphaPower == 1) {
                    result2.append('a');
                } else {
                    result2.append("a^");
                    result2.append(alphaPower);
                }
            }
            if (degree == 0) continue;
            if (degree == 1) {
                result2.append('x');
                continue;
            }
            result2.append("x^");
            result2.append(degree);
        }
        return result2.toString();
    }
}

